<?php
$dsn = 'pgsql:host=127.0.0.1;dbname=campus';
$user = 'zona';
$password = 'zona2020';

try {
    $dbh = new PDO($dsn, $user, $password);

    $fecha_cotizacion = $_POST['fechaCotizacion'];
    $nombre = $_POST['clienteNombre'];
    $dni = $_POST['clienteDNI'] ?? null;
    $domicilio = $_POST['clienteDomicilio'] ?? null;
    $telefono = $_POST['clienteTelefono'] ?? null;
    $contacto = $_POST['clienteContacto'] ?? null;

    $dbh->beginTransaction();

    // Agregar o obtener cliente
    $stmt = $dbh->prepare("SELECT id_cliente FROM clientes WHERE nombre = ?");
    $stmt->execute([$nombre]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cliente) {
        $id_cliente = $cliente['id_cliente'];
    } else {
        $stmt = $dbh->prepare("INSERT INTO clientes (nombre, dni, domicilio, telefono, contacto) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$nombre, $dni, $domicilio, $telefono, $contacto]);
        $id_cliente = $dbh->lastInsertId();
    }

    $total_adeudado = 0;
    $total_costo = 0;
    $total_abonar_cliente = 0;

    $dominio = $_POST['dominio'][0];
    $stmt = $dbh->prepare("INSERT INTO dominios (dominio, id_cliente) VALUES (?, ?)");
    $stmt->execute([$dominio, $id_cliente]);
    $id_dominio = $dbh->lastInsertId();

    foreach ($_POST['nroActa'] as $index => $nro_acta) {
        $fecha_infraccion = !empty($_POST['fechaInfraccion'][$index]) ? $_POST['fechaInfraccion'][$index] : null;
        $importe = $_POST['importe'][$index];
        $porcentaje_costo = $_POST['porcentajeCosto'][$index];
        $porcentaje_descuento = $_POST['porcentajeDescuento'][$index];

        $stmt = $dbh->prepare("INSERT INTO infracciones (nro_acta, fecha_infraccion, importe, porcentaje_costo_estudio, porcentaje_descuento, id_dominio) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$nro_acta, $fecha_infraccion, $importe, $porcentaje_costo, $porcentaje_descuento, $id_dominio]);

        $total_adeudado += $importe;
        $total_costo += $importe * ($porcentaje_costo / 100);
        $total_abonar_cliente += $importe - ($importe * ($porcentaje_descuento / 100));
    }

    $stmt = $dbh->prepare("INSERT INTO cotizaciones (fecha_cotizacion, id_cliente, total_adeudado, total_costo, total_abonar_cliente) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$fecha_cotizacion, $id_cliente, $total_adeudado, $total_costo, $total_abonar_cliente]);

    $dbh->commit();

    echo json_encode(['success' => true]);

} catch (PDOException $e) {
    $dbh->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
