document.addEventListener('DOMContentLoaded', () => {
    const addDominioBtn = document.getElementById('addDominioBtn');
    const dominiosContainer = document.getElementById('dominiosContainer');

    addDominioBtn.addEventListener('click', () => {
        const newDominio = document.createElement('div');
        newDominio.classList.add('dominio');
        newDominio.innerHTML = `
            <label for="dominio">Dominio:</label>
            <input type="text" name="dominio[]" required>
            <div class="infraccionesContainer">
                <div class="infraccion">
                    <label for="nroActa">Nro de Acta:</label>
                    <input type="text" name="nroActa[]" required>

                    <label for="fechaInfraccion">Fecha de Infracción:</label>
                    <input type="date" name="fechaInfraccion[]" required>

                    <label for="importe">Importe:</label>
                    <input type="number" step="0.01" name="importe[]" required>

                    <label for="porcentajeCosto">Porcentaje de Costo:</label>
                    <input type="number" step="0.01" name="porcentajeCosto[]" required>

                    <label for="porcentajeDescuento">Porcentaje de Descuento:</label>
                    <input type="number" step="0.01" name="porcentajeDescuento[]" required>
                </div>
            </div>
            <button type="button" class="addInfraccionBtn">Agregar Infracción</button>
        `;
        dominiosContainer.appendChild(newDominio);

        const addInfraccionBtns = newDominio.querySelectorAll('.addInfraccionBtn');
        addInfraccionBtns.forEach(button => {
            button.addEventListener('click', () => {
                const newInfraccion = document.createElement('div');
                newInfraccion.classList.add('infraccion');
                newInfraccion.innerHTML = `
                    <label for="nroActa">Nro de Acta:</label>
                    <input type="text" name="nroActa[]" required>

                    <label for="fechaInfraccion">Fecha de Infracción:</label>
                    <input type="date" name="fechaInfraccion[]" required>

                    <label for="importe">Importe:</label>
                    <input type="number" step="0.01" name="importe[]" required>

                    <label for="porcentajeCosto">Porcentaje de Costo:</label>
                    <input type="number" step="0.01" name="porcentajeCosto[]" required>

                    <label for="porcentajeDescuento">Porcentaje de Descuento:</label>
                    <input type="number" step="0.01" name="porcentajeDescuento[]" required>
                `;
                newDominio.querySelector('.infraccionesContainer').appendChild(newInfraccion);
            });
        });
    });

    document.getElementById('cotizacionForm').addEventListener('submit', (event) => {
        event.preventDefault();
        const formData = new FormData(event.target);
        fetch('registrar_cotizacion.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Cotización registrada con éxito');
                // Aquí podrías redirigir o limpiar el formulario
            } else {
                alert('Error al registrar la cotización');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error al registrar la cotización');
        });
    });
});
