<?php
header('Content-Type: application/json');

$dsn = 'pgsql:host=localhost;dbname=campus';
$user = 'zona';
$password = 'zona2020';

$id_cotizacion = $_GET['id_cotizacion'];

try {
    $dbh = new PDO($dsn, $user, $password);

    // Obtener datos de la cotización
    $stmt = $dbh->prepare("SELECT c.fecha_cotizacion, cl.nombre AS cliente_nombre, cl.dni AS cliente_dni, cl.domicilio AS cliente_domicilio, cl.telefono AS cliente_telefono, cl.contacto AS cliente_contacto
                           FROM cotizaciones c
                           JOIN clientes cl ON c.id_cliente = cl.id_cliente
                           WHERE c.id_cotizacion = ?");
    $stmt->execute([$id_cotizacion]);
    $cotizacion = $stmt->fetch(PDO::FETCH_ASSOC);

    // Obtener datos de los dominios y sus infracciones
    $stmt = $dbh->prepare("SELECT d.dominio, d.jurisdiccion, i.nro_acta, i.importe, i.porcentaje_costo_estudio AS porcentaje_costo, i.porcentaje_descuento, i.observaciones
                           FROM dominios d
                           JOIN infracciones i ON d.id_dominio = i.id_dominio
                           WHERE d.id_cotizacion = ?
                           ORDER BY d.dominio, d.jurisdiccion, i.nro_acta");
    $stmt->execute([$id_cotizacion]);
    $dominios_infracciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Estructurar los datos de dominios e infracciones
    $dominios = [];
    foreach ($dominios_infracciones as $item) {
/*
        $dominio = $item['dominio'];
        if (!isset($dominios[$dominio])) {
            $dominios[$dominio] = [
                'dominio' => $dominio,
                'jurisdiccion' => $item['jurisdiccion'],
                'infracciones' => []
            ];
        }
        $dominios[$dominio]['infracciones'][] = [
            'nro_acta' => $item['nro_acta'],
            'importe' => $item['importe'],
            'porcentaje_costo' => $item['porcentaje_costo'],
            'porcentaje_descuento' => $item['porcentaje_descuento'],
            'observaciones' => $item['observaciones']
        ];
*/

        $dominio = $item['dominio'];
        $jurisdiccion = $item['jurisdiccion'];
        $dominio_key = $dominio . '|' . $jurisdiccion; // Unique key to differentiate by domain and jurisdiction

        if (!isset($dominios[$dominio_key])) {
            $dominios[$dominio_key] = [
                'dominio' => $dominio,
                'jurisdiccion' => $jurisdiccion,
                'infracciones' => []
            ];
        }
        $dominios[$dominio_key]['infracciones'][] = [
            'nro_acta' => $item['nro_acta'],
            'importe' => $item['importe'],
            'porcentaje_costo' => $item['porcentaje_costo'],
            'porcentaje_descuento' => $item['porcentaje_descuento'],
            'observaciones' => $item['observaciones']
        ];

    }

    $data = [
        'cotizacion' => $cotizacion,
        'dominios' => array_values($dominios)
    ];

    echo json_encode(['success' => true, 'data' => $data]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
