<?php
$id_cotizacion = $_GET['id_cotizacion'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Modificar Cotización</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h1>Modificar Cotización</h1>
    <form id="cotizacionForm">
        <div class="form-group">
            <label for="fechaCotizacion">Fecha de Cotización:</label>
            <input type="date" class="form-control" id="fechaCotizacion" name="fechaCotizacion" required>
        </div>
        <div class="form-group">
            <label for="clienteNombre">Nombre del Cliente:</label>
            <input type="text" class="form-control" id="clienteNombre2" name="clienteNombre2" required disabled>
	    <input type="hidden" id="clienteNombre" name="clienteNombre">
        </div>
        <div class="form-group">
            <label for="clienteDNI">DNI:</label>
            <input type="text" class="form-control" id="clienteDNI" name="clienteDNI">
        </div>
        <div class="form-group">
            <label for="clienteDomicilio">Domicilio:</label>
            <input type="text" class="form-control" id="clienteDomicilio" name="clienteDomicilio">
        </div>
        <div class="form-group">
            <label for="clienteTelefono">Teléfono:</label>
            <input type="text" class="form-control" id="clienteTelefono" name="clienteTelefono">
        </div>
	<div class="form-group">
	    <label for="clienteContacto">Contacto:</label>
	    <input type="text" class="form-control" id="clienteContacto" name="clienteContacto">
	</div>

        <div id="dominiosContainer">
            <!-- Aquí se agregarán dinámicamente los dominios e infracciones -->
        </div>
        <button type="button" id="addDominioBtn" class="btn btn-primary">Agregar Dominio</button>

        <div class="mt-3">
            <h4>Totales</h4>
            <p>Total Adeudado: <span id="totalAdeudado">0.00</span></p>
            <p>Total Costo: <span id="totalCosto">0.00</span></p>
            <p>Total a Abonar: <span id="totalAbonar">0.00</span></p>
            <p>Ganancia: <span id="totalGanancia">0.00</span></p>
        </div>

        <button type="submit" class="btn btn-success">Guardar Cambios</button>
    </form>
</div>

<script>
$(document).ready(function() {
    const idCotizacion = <?= $id_cotizacion ?>;
    const dominiosContainer = $('#dominiosContainer');

    function cargarCotizacion() {
        $.ajax({
            url: 'obtener_cotizacion.php',
            method: 'GET',
            data: { id_cotizacion: idCotizacion },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    const cotizacion = response.data.cotizacion;
                    const dominios = response.data.dominios;

//console.log(cotizacion.fecha_cotizacion);
                    // Set the date of the quotation
const rawFechaCotizacion = cotizacion.fecha_cotizacion;
const parts = rawFechaCotizacion.split('-');
const formattedFechaCotizacion = `${parts[2]}-${parts[1]}-${parts[0]}`;
const fechaCotizacion = new Date(formattedFechaCotizacion).toISOString().split('T')[0];
//                    const fechaCotizacion = new Date(cotizacion.fecha_cotizacion).toISOString().split('T')[0];
//                    const fechaCotizacion = cotizacion.fecha_cotizacion;
//console.log(fechaCotizacion);
                    $('#fechaCotizacion').val(fechaCotizacion);

                    $('#clienteNombre').val(cotizacion.cliente_nombre);
                    $('#clienteNombre2').val(cotizacion.cliente_nombre);
                    $('#clienteDNI').val(cotizacion.cliente_dni);
                    $('#clienteDomicilio').val(cotizacion.cliente_domicilio);
                    $('#clienteTelefono').val(cotizacion.cliente_telefono);
                    $('#clienteContacto').val(cotizacion.cliente_contacto);

                    dominios.forEach(function(dominio, index) {
                        addNewDominio(index, dominio);
                    });

                    updateTotals();
                }
            }
        });
    }

    function addNewDominio(index, data = {}) {
        const newDominio = $(`
            <div class="dominio mb-4 p-3 border rounded" data-index="${index}">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="dominio">Dominio:</label>
                        <input type="text" class="form-control" name="dominio[]" value="${data.dominio || ''}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="jurisdiccion">Jurisdicción:</label>
                        <select class="form-control jurisdiccion" name="jurisdiccion[${index}]" required>
                            <!-- Opciones de jurisdicción cargadas dinámicamente -->
                        </select>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Nro de Acta</th>
                                <th>Importe</th>
                                <th>% de Costo</th>
                                <th>% de Descuento</th>
                                <th>Observaciones</th>
                            </tr>
                        </thead>
                        <tbody class="infraccionesContainer">
                            ${data.infracciones ? data.infracciones.map(infraccion => `
                                <tr class="infraccion" data-precargada="true">
                                    <td><input type="text" class="form-control" name="nroActa[${index}][]" value="${infraccion.nro_acta || ''}" required></td>
                                    <td><input type="number" class="form-control importe" step="0.01" name="importe[${index}][]" value="${infraccion.importe || ''}" required></td>
                                    <td><input type="number" class="form-control porcentajeCosto" step="0.01" name="porcentajeCosto[${index}][]" value="${infraccion.porcentaje_costo}" required></td>
                                    <td><input type="number" class="form-control porcentajeDescuento" step="0.01" name="porcentajeDescuento[${index}][]" value="${infraccion.porcentaje_descuento || 50}" required></td>
                                    <td><input type="text" class="form-control" name="observaciones[${index}][]" value="${infraccion.observaciones || ''}"></td>
                                </tr>
                            `).join('') : `
                                <tr class="infraccion">
                                    <td><input type="text" class="form-control" name="nroActa[${index}][]" required></td>
                                    <td><input type="number" class="form-control importe" step="0.01" name="importe[${index}][]" required></td>
                                    <td><input type="number" class="form-control porcentajeCosto" step="0.01" name="porcentajeCosto[${index}][]" required></td>
                                    <td><input type="number" class="form-control porcentajeDescuento" step="0.01" name="porcentajeDescuento[${index}][]" value="50" required></td>
                                    <td><input type="text" class="form-control" name="observaciones[${index}][]"></td>
                                </tr>
                            `}
                        </tbody>
                    </table>
                </div>
                <button type="button" class="btn btn-secondary addInfraccionBtn">Agregar Infracción</button>
            </div>
        `);
        dominiosContainer.append(newDominio);

        newDominio.find('.addInfraccionBtn').on('click', function() {
            addNewInfraccion(index, newDominio);
        });

        loadJurisdicciones(newDominio).then(() => {
            if (data.jurisdiccion) {
                newDominio.find('.jurisdiccion').val(data.jurisdiccion);
            }
            setDefaultJurisdiccion(index, newDominio);
            updateTotals();
            addDescuentoValidation(newDominio);
        });

        newDominio.find('.jurisdiccion').on('change', function() {
            updateJurisdiccionCosts(index, newDominio);
        });

        // Add event listeners to update totals when values change
        newDominio.find('.importe, .porcentajeCosto, .porcentajeDescuento').on('input change', updateTotals);
    }

    function addNewInfraccion(index, dominioElement) {
        const porcentajeCostoActual = dominioElement.find('.jurisdiccion').find(':selected').data('porcentajeCosto');

        const newInfraccion = $(`
            <tr class="infraccion">
                <td><input type="text" class="form-control" name="nroActa[${index}][]" required></td>
                <td><input type="number" class="form-control importe" step="0.01" name="importe[${index}][]" required></td>
                <td><input type="number" class="form-control porcentajeCosto" step="0.01" name="porcentajeCosto[${index}][]" value="${porcentajeCostoActual || ''}" required></td>
                <td><input type="number" class="form-control porcentajeDescuento" step="0.01" name="porcentajeDescuento[${index}][]" value="50" required></td>
                <td><input type="text" class="form-control" name="observaciones[${index}][]"></td>
            </tr>
        `);
        dominioElement.find('.infraccionesContainer').append(newInfraccion);

        // Add event listeners to update totals when values change
        newInfraccion.find('.importe, .porcentajeCosto, .porcentajeDescuento').on('input change', updateTotals);
        updateTotals();
        addDescuentoValidation(newInfraccion);
    }

    function loadJurisdicciones(element) {
        return fetch('obtener_jurisdicciones.php')
        .then(response => response.json())
        .then(data => {
            const jurisdicciones = data.jurisdicciones;
            const jurisdiccionSelects = element.find('.jurisdiccion');
            jurisdiccionSelects.each(function() {
                const select = $(this);
                select.empty();
                jurisdicciones.forEach(jurisdiccion => {
                    const option = $('<option>').val(jurisdiccion.id).text(jurisdiccion.nombre).data('porcentajeCosto', jurisdiccion.porcentaje_costo);
                    select.append(option);
                });
            });
        })
        .catch(error => console.error('Error al cargar las jurisdicciones:', error));
    }

    function setDefaultJurisdiccion(dominioIndex, dominioElement) {
        const firstOption = dominioElement.find('.jurisdiccion option:first');
        const porcentajeCosto = firstOption.data('porcentajeCosto');

        const infracciones = dominioElement.find('.infraccion');
        infracciones.each(function() {
            const porcentajeCostoInput = $(this).find('.porcentajeCosto');
            if ($(this).data('precargada') !== true) {
                porcentajeCostoInput.val(porcentajeCosto);
            }
        });
    }

    function updateJurisdiccionCosts(dominioIndex, dominioElement) {
        const selectedJurisdiccion = dominioElement.find('.jurisdiccion').val();
        const selectedOption = dominioElement.find(`.jurisdiccion option[value="${selectedJurisdiccion}"]`);
        const porcentajeCosto = selectedOption.data('porcentajeCosto');

        const infracciones = dominioElement.find('.infraccion');
        infracciones.each(function() {
            const porcentajeCostoInput = $(this).find('.porcentajeCosto');
            if ($(this).data('precargada') !== true) {
                porcentajeCostoInput.val(porcentajeCosto);
            }
        });

        updateTotals();
    }

    function updateTotals() {
        let totalAdeudado = 0;
        let totalCosto = 0;
        let totalAbonar = 0;

        $('.table .infraccion').each(function() {
            const importe = parseFloat($(this).find('.importe').val()) || 0;
            const porcentajeCosto = parseFloat($(this).find('.porcentajeCosto').val()) || 0;
            const porcentajeDescuento = parseFloat($(this).find('.porcentajeDescuento').val()) || 0;

            totalAdeudado += importe;
            totalCosto += importe * (porcentajeCosto / 100);
            totalAbonar += importe - (importe * (porcentajeDescuento / 100));
        });

        $('#totalAdeudado').text(number_format(totalAdeudado.toFixed(2)));
        $('#totalCosto').text(number_format(totalCosto.toFixed(2)));
        $('#totalAbonar').text(number_format(totalAbonar.toFixed(2)));
        $('#totalGanancia').text(number_format((totalAbonar - totalCosto).toFixed(2)));
    }

    function number_format(number, decimals = 2, dec_point = ',', thousands_sep = '.') {
        number = parseFloat(number).toFixed(decimals);

        var nstr = number.toString();
        var x = nstr.split('.');
        var x1 = x[0];
        var x2 = x.length > 1 ? dec_point + x[1] : '';
        var rgx = /(\d+)(\d{3})/;

        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + thousands_sep + '$2');
        }

        return x1 + x2;
    }

    function addDescuentoValidation(element) {
        element.find('.porcentajeDescuento').on('blur', function() {
            const row = $(this).closest('.infraccion');
            const porcentajeCosto = parseFloat(row.find('.porcentajeCosto').val()) || 0;
            const porcentajeDescuento = parseFloat($(this).val()) || 0;
            if (porcentajeCosto + porcentajeDescuento > 100) {
                alert('No se puede hacer un % de descuento mayor al costo');
                $(this).val('');
            }
            updateTotals();
        });
    }

    $('#addDominioBtn').on('click', function() {
        const newIndex = $('.dominio').length;
        addNewDominio(newIndex);
    });

    $('#cotizacionForm').on('submit', function(event) {
        event.preventDefault();

        const formData = $(this).serialize();
        $.ajax({
            url: 'guardar_modificaciones.php',
            method: 'POST',
            data: formData + '&id_cotizacion=' + idCotizacion,
            success: function(response) {
                if (response.success) {
                    window.open('generar_pdf.php?id_cotizacion=' + idCotizacion, '_blank');
                    window.location.reload();
                } else {
                    alert('Error al guardar las modificaciones.');
                }
            }
        });
    });

    cargarCotizacion();
});
</script>
</body>
</html>
