<?php
$dsn = 'pgsql:host=localhost;dbname=campus';
$user = 'zona';
$password = 'zona2020';

try {
    $dbh = new PDO($dsn, $user, $password);

    $stmt = $dbh->prepare("
        SELECT 
            TO_CHAR(fecha_cotizacion, 'YYYY-MM') AS periodo, 
            SUM(CASE WHEN pago_estudio = 'NO' THEN total_abonar_cliente - total_costo ELSE 0 END) AS suma_adeudada, 
            SUM(CASE WHEN pago_estudio = 'SI' THEN total_abonar_cliente - total_costo ELSE 0 END) AS suma_abonada,
            SUM(total_abonar_cliente - total_costo) AS ganancia_total
        FROM cotizaciones
        WHERE estado = 2
        GROUP BY TO_CHAR(fecha_cotizacion, 'YYYY-MM')
        ORDER BY periodo
    ");
    $stmt->execute();
    $ganancias = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'data' => $ganancias]);

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
