<?php
header('Content-Type: application/json');

$dsn = 'pgsql:host=localhost;dbname=campus';
$user = 'zona';
$password = 'zona2020';

$id_cotizacion = $_POST['id_cotizacion'];
$fecha_cotizacion = $_POST['fechaCotizacion'];
$cliente_nombre = $_POST['clienteNombre'];
$cliente_dni = $_POST['clienteDNI'];
$cliente_domicilio = $_POST['clienteDomicilio'];
$cliente_telefono = $_POST['clienteTelefono'];
$cliente_contacto = $_POST['clienteContacto'];

try {
    $dbh = new PDO($dsn, $user, $password);
    $dbh->beginTransaction();

    // Obtener id_cliente desde la cotización
    $stmt = $dbh->prepare("SELECT id_cliente FROM cotizaciones WHERE id_cotizacion = ?");
    $stmt->execute([$id_cotizacion]);
    $id_cliente = $stmt->fetchColumn();

    if (!$id_cliente) {
        throw new Exception("Cliente no encontrado para la cotización especificada.");
    }

    // Actualizar datos del cliente
    $stmt = $dbh->prepare("UPDATE clientes SET nombre = ?, dni = ?, domicilio = ?, telefono = ?, contacto = ? WHERE id_cliente = ?");
    $stmt->execute([$cliente_nombre, $cliente_dni, $cliente_domicilio, $cliente_telefono, $cliente_contacto, $id_cliente]);

    // Actualizar datos de la cotización
    $stmt = $dbh->prepare("UPDATE cotizaciones SET fecha_cotizacion = ? WHERE id_cotizacion = ?");
    $stmt->execute([$fecha_cotizacion, $id_cotizacion]);

    // Eliminar dominios e infracciones existentes
    $stmt = $dbh->prepare("DELETE FROM infracciones WHERE id_dominio IN (SELECT id_dominio FROM dominios WHERE id_cotizacion = ?)");
    $stmt->execute([$id_cotizacion]);

    $stmt = $dbh->prepare("DELETE FROM dominios WHERE id_cotizacion = ?");
    $stmt->execute([$id_cotizacion]);

    // Variables para los totales
    $total_adeudado = 0;
    $total_costo = 0;
    $total_abonar_cliente = 0;

    // Insertar nuevos dominios e infracciones
    foreach ($_POST['dominio'] as $index => $dominio) {
        $jurisdiccion = $_POST['jurisdiccion'][$index];

        // Insertar dominio
        $stmt = $dbh->prepare("INSERT INTO dominios (dominio, id_cotizacion, id_cliente, jurisdiccion) VALUES (?, ?, ?, ?) RETURNING id_dominio");
        $stmt->execute([$dominio, $id_cotizacion, $id_cliente, $jurisdiccion]);
        $id_dominio = $stmt->fetchColumn();

        // Insertar infracciones
        foreach ($_POST['nroActa'][$index] as $i => $nroActa) {
            $importe = $_POST['importe'][$index][$i];
            $porcentajeCosto = $_POST['porcentajeCosto'][$index][$i];
            $porcentajeDescuento = $_POST['porcentajeDescuento'][$index][$i];
            $observaciones = $_POST['observaciones'][$index][$i];

	    if($importe>0){
        	$stmt = $dbh->prepare("INSERT INTO infracciones (nro_acta, importe, porcentaje_costo_estudio, porcentaje_descuento, observaciones, id_dominio) VALUES (?, ?, ?, ?, ?, ?)");
        	$stmt->execute([$nroActa, $importe, $porcentajeCosto, $porcentajeDescuento, $observaciones, $id_dominio]);

        	// Calcular totales
        	$total_adeudado += $importe;
        	$total_costo += $importe * ($porcentajeCosto / 100);
        	$total_abonar_cliente += $importe - ($importe * ($porcentajeDescuento / 100));
	    }
        }
    }

    // Actualizar totales de la cotización
    $stmt = $dbh->prepare("UPDATE cotizaciones SET total_adeudado = ?, total_costo = ?, total_abonar_cliente = ? WHERE id_cotizacion = ?");
    $stmt->execute([$total_adeudado, $total_costo, $total_abonar_cliente, $id_cotizacion]);

    $dbh->commit();

    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    $dbh->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} catch (Exception $e) {
    $dbh->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>