<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;
use GuzzleHttp\Cookie\CookieJar;
use GuzzleHttp\Exception\RequestException;

function getInitialCookiesAndCsrf(Client $client) {
    $response = $client->request('GET', 'https://infraccionesba.gba.gob.ar/consulta-infraccion', [
        'headers' => [
            'User-Agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, como Gecko) Chrome/125.0.0.0 Safari/537.36',
        ]
    ]);

    $body = (string) $response->getBody();
    preg_match('/<meta name="_csrf" content="([^"]+)"/', $body, $csrfMatch);
    if (!isset($csrfMatch[1])) {
        throw new \Exception('No se pudo capturar el token CSRF.');
    }
    $csrfToken = $csrfMatch[1];

    $cookieJar = $client->getConfig('cookies');

    return [$cookieJar, $csrfToken];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $dominio = $_POST['dominio'];

    // Crear cliente Guzzle
    $client = new Client([
        'cookies' => true,
        'headers' => [
            'User-Agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',
        ],
    ]);

    try {
        // Paso 1: Obtener las cookies iniciales y el token CSRF
        list($cookieJar, $csrfToken) = getInitialCookiesAndCsrf($client);

        echo "CSRF Token: $csrfToken\n";
        echo "Cookies: ";
        print_r($cookieJar->toArray());

        // Guardar cookies y token CSRF en una sesión para uso posterior
        session_start();
        $_SESSION['cookieJar'] = serialize($cookieJar);
        $_SESSION['csrfToken'] = $csrfToken;

        echo "Por favor, resuelve el reCAPTCHA manualmente en el siguiente enlace: \n";
        echo "https://infraccionesba.gba.gob.ar/consulta-infraccion\n";
        echo "Luego presiona cualquier tecla para continuar...\n";
        readline(); // Espera hasta que el usuario presione una tecla

        // Paso 2: Realizar la solicitud a la API de infracciones con los tokens y cookies capturados
        $cookieJar = unserialize($_SESSION['cookieJar']);
        $csrfToken = $_SESSION['csrfToken'];

        $response = $client->request('GET', 'https://infraccionesba.gba.gob.ar/rest/consultar-infraccion', [
            'query' => [
                'dominio' => $dominio,
                'cantPorPagina' => 10,
                'paginaActual' => 1,
                '_csrf' => $csrfToken,
            ],
            'cookies' => $cookieJar,
            'headers' => [
                'X-CSRF-TOKEN' => $csrfToken,
                'Referer' => 'https://infraccionesba.gba.gob.ar/consulta-infraccion',
                'Accept' => 'application/json',
                'Accept-Encoding' => 'gzip, deflate, br, zstd',
                'Accept-Language' => 'es-AR,es;q=0.9',
                'Cache-Control' => 'no-cache',
                'Pragma' => 'no-cache',
            ]
        ]);

        $httpcode = $response->getStatusCode();
        $body = (string) $response->getBody();
        $data = json_decode($body, true);

        echo "HTTP Status Code: $httpcode\n";
        echo "Response: $body\n";

        if (isset($data['error']) && $data['error'] == true) {
            die('Error: API response error - ' . json_encode($data));
        }

        echo "<pre>";
        print_r($data);
        echo "</pre>";

    } catch (RequestException $e) {
        echo 'Request failed: ' . $e->getMessage();
    } catch (\Exception $e) {
        echo 'Error: ' . $e->getMessage();
    }
}
?>
