CREATE OR REPLACE FUNCTION f_ai_convenios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	centro		integer;
	newunif		integer;
	existe		integer;
	idastoh		integer;
	cuentadxv	integer;
	rubro		integer;
	cargo		integer;
    BEGIN

	select cop_unifun,cop_centro into unifun,centro from coprop where cop_id=NEW.con_idcopr;
	newunif:=unifun + 90000;

	select cop_id into existe from coprop where cop_centro=centro and cop_unifun=newunif;
	if not found then
	    insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
		select cop_codemp,cop_idptov,newunif,cop_nombre,cop_codaso,0,0,0,0,0,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,1,cop_mail,cop_inter,cop_recib,cop_centro,cop_division from coprop where cop_id=NEW.con_idcopr;
	  else
	    update coprop set cop_estado=1 where cop_id=existe;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	    values (NEW.con_codemp,NEW.con_idptov,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_comprob,NEW.con_numero,'Convenio de Pago',NEW.con_fechai,NEW.con_fechai,'Convenio de Pago',0,-1);

	select ash_id into idastoh from astoh where ash_codemp=NEW.con_codemp and ash_idptov=NEW.con_idptov and ash_comprob=NEW.con_comprob and ash_numero=NEW.con_numero;

	select idcbl(NEW.con_codemp,valvaramb(NEW.con_codemp,0,'DEUDXV')::integer)  into cuentadxv;


	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),NEW.con_idcopr,idastoh,cuentadxv,NEW.con_monto*-1,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);

	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),existe,idastoh,cuentadxv,NEW.con_monto,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);


	select valvaramb(NEW.con_codemp,0,'CODCARCONV') into cargo;

	select car_rubcar into rubro from cargos where car_id=cargo;

	insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr)
	    values (NEW.con_codemp,NEW.con_idptov,NEW.con_centro,NEW.con_division,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_fechai,NEW.con_fechai,NEW.con_comprob,NEW.con_numero,NEW.con_operador,rubro,cargo,NEW.con_leyen,1,0,NEW.con_monto,NEW.con_monto,NEW.con__idcopr);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_convenios() OWNER TO sanjor;


drop TRIGGER ai_convenios on convenios;

CREATE TRIGGER ai_convenios
    AFTER INSERT ON convenios
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_convenios();





CREATE OR REPLACE FUNCTION f_ai_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	regis		record;
    BEGIN

    for regis in select * from varambi where vari_codemp=1 and vari_idptov=0 
	loop
	    insert into varambi values (NEW.emp_codigo,0,regis.vari_codigo,regis.vari_nombre,regis.vari_valor,regis.vari_tipo);
	end loop;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_empresa() OWNER TO sanjor;


drop TRIGGER ai_empresa on empresa;

CREATE TRIGGER ai_empresa
    AFTER INSERT ON empresa
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_empresa();

