SET default_with_oids = true;

CREATE OR REPLACE FUNCTION f_ai_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    newunif		int4;
    tipcta		int4;
    BEGIN

    if(int4gt(NEW.cop_unifun,90000)) then
	newunif:=NEW.cop_unifun + 90000 ;
	insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
	    values (NEW.cop_codemp,NEW.cop_idptov,newunif,NEW.cop_nombre,NEW.cop_codaso,NEW.cop_porc1,NEW.cop_porc2,NEW.cop_porc3,NEW.cop_porc4,NEW.cop_porc5,NEW.cop_direc,NEW.cop_locali,NEW.cop_codpos,NEW.cop_provin,NEW.cop_descuf,NEW.cop_tipuf,NEW.cop_coniva,NEW.cop_nrcuit,NEW.cop_tipdoc,NEW.cop_nrodoc,NEW.cop_grupo,5,NEW.cop_mail,NEW.cop_inter,NEW.cop_recib,NEW.cop_centro,NEW.cop_division);
    end if;

    select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
    insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla) values (NEW.cop_codemp,NEW.cop_idptov,tipcta,NEW.cop_unifun,NEW.cop_nombre,0,NEW.cop_id);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_coprop() OWNER TO sanjor;


drop TRIGGER ai_coprop ON coprop;
CREATE TRIGGER ai_coprop
    AFTER INSERT ON coprop
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_coprop();





drop table ctasconv;
drop table convenios;

CREATE TABLE convenios (
    con_id integer NOT NULL,
    con_codemp integer DEFAULT 0 NOT NULL,
    con_idptov integer NOT NULL,
    con_division integer NOT NULL,
    con_centro integer NOT NULL,
    con_idcopr integer NOT NULL,
    con_comprob integer NOT NULL,
    con_numero integer,
    con_monto numeric(15,5) DEFAULT 0,
    con_fechai date default date(now()),
    con_fechaf date default date(now()),
    con_cuotas integer default 1,
    con_operador integer,
    con_leyen text
);



ALTER TABLE public.convenios OWNER TO sanjor;

CREATE SEQUENCE convenios_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.convenios_con_id_seq OWNER TO sanjor;
ALTER SEQUENCE convenios_con_id_seq OWNED BY convenios.con_id;
ALTER TABLE ONLY convenios ALTER COLUMN con_id SET DEFAULT nextval('convenios_con_id_seq'::regclass);
ALTER TABLE ONLY convenios ADD CONSTRAINT convenios_pkey PRIMARY KEY (con_id);

ALTER TABLE ONLY convenios ADD CONSTRAINT "$1" FOREIGN KEY (con_codemp) REFERENCES empresa(emp_codigo);
ALTER TABLE ONLY convenios ADD CONSTRAINT "$2" FOREIGN KEY (con_idptov) REFERENCES ptovta(ptv_id);
ALTER TABLE ONLY convenios ADD CONSTRAINT "$3" FOREIGN KEY (con_division) REFERENCES division(div_id) MATCH FULL;
ALTER TABLE ONLY convenios ADD CONSTRAINT "$4" FOREIGN KEY (con_centro) REFERENCES centroc(cco_id) MATCH FULL;
ALTER TABLE ONLY convenios ADD CONSTRAINT "$5" FOREIGN KEY (con_idcopr) REFERENCES coprop(cop_id) MATCH FULL;
ALTER TABLE ONLY convenios ADD CONSTRAINT "$6" FOREIGN KEY (con_comprob) REFERENCES comprob(comp_id);

CREATE INDEX idx_convenios_1 ON convenios USING btree (con_codemp, con_idptov, con_division, con_centro, con_idcopr);

REVOKE ALL ON TABLE convenios FROM PUBLIC;
REVOKE ALL ON TABLE convenios FROM sanjor;
GRANT ALL ON TABLE convenios TO sanjor;
GRANT ALL ON TABLE convenios TO nobody;

REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE convenios_con_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE convenios_con_id_seq TO nobody;





CREATE TABLE ctasconv (
    ctc_id integer NOT NULL,
    ctc_idconv integer NOT NULL,
    ctc_cuota integer default 1,
    ctc_fecha date default date(now()),
    ctc_importe numeric(15,5) DEFAULT 0,
    ctc_leyen text
);


ALTER TABLE public.ctasconv OWNER TO sanjor;

CREATE SEQUENCE ctasconv_ctc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.ctasconv_ctc_id_seq OWNER TO sanjor;
ALTER SEQUENCE ctasconv_ctc_id_seq OWNED BY ctasconv.ctc_id;
ALTER TABLE ONLY ctasconv ALTER COLUMN ctc_id SET DEFAULT nextval('ctasconv_ctc_id_seq'::regclass);
ALTER TABLE ONLY ctasconv ADD CONSTRAINT ctasconv_pkey PRIMARY KEY (ctc_id);

ALTER TABLE ONLY ctasconv ADD CONSTRAINT "$1" FOREIGN KEY (ctc_idconv) REFERENCES convenios(con_id);

REVOKE ALL ON TABLE ctasconv FROM PUBLIC;
REVOKE ALL ON TABLE ctasconv FROM sanjor;
GRANT ALL ON TABLE ctasconv TO sanjor;
GRANT ALL ON TABLE ctasconv TO nobody;

REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE ctasconv_ctc_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE ctasconv_ctc_id_seq TO nobody;





drop table cambtitu;
CREATE TABLE cambtitu (
    cbt_id integer NOT NULL,
    cbt_codemp integer NOT NULL,
    cbt_idptov integer NOT NULL,
    cbt_division integer,
    cbt_centro integer,
    cbt_unifun integer,
    cbt_idcopr integer NOT NULL,
    cbt_nombre character varying(240) NOT NULL,
    cbt_direcc character varying(240),
    cbt_locali character varying(240),
    cbt_codpos character varying(10),
    cbt_provin integer,
    cbt_telefono character varying(20),
    cbt_mail character varying(20),
    cbt_fecha date DEFAULT date(now()),
    cbt_tipdoc character varying(10),
    cbt_nrodoc integer,
    cbt_nrcuit character varying(20),
    cbt_leyen text,
    cbt_operador integer
);


ALTER TABLE public.cambtitu OWNER TO sanjor;

CREATE SEQUENCE cambtitu_cbt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.cambtitu_cbt_id_seq OWNER TO sanjor;
ALTER SEQUENCE cambtitu_cbt_id_seq OWNED BY cambtitu.cbt_id;
ALTER TABLE ONLY cambtitu ALTER COLUMN cbt_id SET DEFAULT nextval('cambtitu_cbt_id_seq'::regclass);
ALTER TABLE ONLY cambtitu ADD CONSTRAINT cambtitu_pkey PRIMARY KEY (cbt_id);

CREATE INDEX idx_cambtitu_1 ON cambtitu USING btree (cbt_codemp, cbt_idptov, cbt_idcopr);
CREATE INDEX idx_cambtitu_2 ON cambtitu USING btree (cbt_idcopr);
ALTER TABLE ONLY cambtitu ADD CONSTRAINT "$1" FOREIGN KEY (cbt_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;
ALTER TABLE ONLY cambtitu ADD CONSTRAINT "$2" FOREIGN KEY (cbt_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;
ALTER TABLE ONLY cambtitu ADD CONSTRAINT "$3" FOREIGN KEY (cbt_division) REFERENCES division(div_id) MATCH FULL;
ALTER TABLE ONLY cambtitu ADD CONSTRAINT "$4" FOREIGN KEY (cbt_centro) REFERENCES centroc(cco_id) MATCH FULL;
ALTER TABLE ONLY cambtitu ADD CONSTRAINT "$5" FOREIGN KEY (cbt_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


REVOKE ALL ON TABLE cambtitu FROM PUBLIC;
REVOKE ALL ON TABLE cambtitu FROM sanjor;
GRANT ALL ON TABLE cambtitu TO sanjor;
GRANT ALL ON TABLE cambtitu TO nobody;

REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE cambtitu_cbt_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE cambtitu_cbt_id_seq TO nobody;



CREATE OR REPLACE FUNCTION f_au_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	tipcta		integer;
	telefono	character varying;
	mail		character varying;
BEGIN
	select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
	if int4ne(NEW.cop_unifun,OLD.cop_unifun) THEN 
	    update ctes set cte_codigo=NEW.cop_unifun where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if int4ne(NEW.cop_estado,OLD.cop_estado) THEN 
	    update ctes set cte_estado=NEW.cop_estado where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if bpcharne(NEW.cop_nombre,OLD.cop_nombre) THEN 
	    update ctes set cte_nombre=NEW.cop_nombre where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	    if OLD.cop_nombre is not null THEN 
		telefono:=' ';
		mail:=' ';
		select tel_dato into telefono from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel not in (6,7) order by tel_codigo desc limit 1;
		select tel_dato into mail from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel=7 limit 1;
		insert into cambtitu (cbt_codemp,cbt_idptov,cbt_division,cbt_centro,cbt_unifun,cbt_idcopr,cbt_nombre,cbt_direcc,cbt_locali,cbt_codpos,cbt_provin,cbt_tipdoc,cbt_nrodoc,cbt_nrcuit,cbt_telefono,cbt_mail) values (OLD.cop_codemp,OLD.cop_idptov,OLD.cop_division,OLD.cop_centro,OLD.cop_unifun,OLD.cop_id,OLD.cop_nombre,OLD.cop_direcc,OLD.cop_locali,OLD.cop_codpos,OLD.cop_provin,OLD.cop_tipdoc,OLD.cop_nrodoc,OLD.cop_nrcuit,telefono,mail);
	    END IF;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_coprop() OWNER TO sanjor;


drop table judicial;
drop table estjud;
CREATE TABLE estjud (
    etj_codigo integer NOT NULL,
    etj_nombre character varying(240) NOT NULL
);
ALTER TABLE public.estjud OWNER TO sanjor;
ALTER TABLE ONLY estjud ADD CONSTRAINT estjud_pkey PRIMARY KEY (etj_codigo);
REVOKE ALL ON TABLE estjud FROM PUBLIC;
REVOKE ALL ON TABLE estjud FROM sanjor;
GRANT ALL ON TABLE estjud TO sanjor;
GRANT ALL ON TABLE estjud TO nobody;

insert into estjud values (1,'A Intimar');
insert into estjud values (2,'Intimado');
insert into estjud values (3,'Intimado por Carta Documento');
insert into estjud values (4,'Informe de Dominio Solicitado');
insert into estjud values (5,'Legajo en Estudio Jurico');
insert into estjud values (6,'En proceso Judicial');
insert into estjud values (7,'En Proceso de Remate Judicial');
insert into estjud values (8,'En Convenio de Pago');
insert into estjud values (50,'Otra Diligencia');




drop table estjurid;
CREATE TABLE estjurid (
    est_codigo integer NOT NULL,
    est_nombre character varying(240) NOT NULL
);
ALTER TABLE public.estjurid OWNER TO sanjor;
ALTER TABLE ONLY estjurid ADD CONSTRAINT estjurid_pkey PRIMARY KEY (est_codigo);
REVOKE ALL ON TABLE estjurid FROM PUBLIC;
REVOKE ALL ON TABLE estjurid FROM sanjor;
GRANT ALL ON TABLE estjurid TO sanjor;
GRANT ALL ON TABLE estjurid TO nobody;

insert into estjurid values (1,'Estudio Agustn P. Jorge');
insert into estjurid values (2,'Estudio Benegas');
insert into estjurid values (3,'Estudio Gorosito');
insert into estjurid values (50,'Otros Estudios');




CREATE TABLE judicial (
    jud_id integer NOT NULL,
    jud_codemp integer NOT NULL,
    jud_idptov integer NOT NULL,
    jud_division integer,
    jud_centro integer,
    jud_idcopr integer NOT NULL,
    jud_ejcod integer,
    jud_fecha date default date(now()),
    jud_deuda numeric(15,2) DEFAULT 0,
    jud_gasto numeric(15,2) DEFAULT 0,
    jud_reintg integer DEFAULT 1,
    jud_estado integer DEFAULT 1,
    jud_estudio integer,
    jud_leyen text,
    jud_operador integer
);


ALTER TABLE public.judicial OWNER TO sanjor;

CREATE SEQUENCE judicial_jud_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;

ALTER TABLE public.judicial_jud_id_seq OWNER TO sanjor;
ALTER SEQUENCE judicial_jud_id_seq OWNED BY judicial.jud_id;
ALTER TABLE ONLY judicial ALTER COLUMN jud_id SET DEFAULT nextval('judicial_jud_id_seq'::regclass);
ALTER TABLE ONLY judicial ADD CONSTRAINT judicial_pkey PRIMARY KEY (jud_id);

CREATE INDEX idx_judicial_1 ON judicial USING btree (jud_codemp, jud_idptov, jud_idcopr);
CREATE INDEX idx_judicial_2 ON judicial USING btree (jud_idcopr);
ALTER TABLE ONLY judicial ADD CONSTRAINT "$1" FOREIGN KEY (jud_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$2" FOREIGN KEY (jud_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$3" FOREIGN KEY (jud_division) REFERENCES division(div_id) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$4" FOREIGN KEY (jud_centro) REFERENCES centroc(cco_id) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$5" FOREIGN KEY (jud_idcopr) REFERENCES coprop(cop_id) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$6" FOREIGN KEY (jud_ejcod) REFERENCES estjud(etj_codigo) MATCH FULL;
ALTER TABLE ONLY judicial ADD CONSTRAINT "$7" FOREIGN KEY (jud_estudio) REFERENCES estjurid(est_codigo) MATCH FULL;


REVOKE ALL ON TABLE judicial FROM PUBLIC;
REVOKE ALL ON TABLE judicial FROM sanjor;
GRANT ALL ON TABLE judicial TO sanjor;
GRANT ALL ON TABLE judicial TO nobody;

REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE judicial_jud_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE judicial_jud_id_seq TO nobody;



























