--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: act_talon(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION act_talon(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select tal_valor from talon where tal_id = $1;$_$;


ALTER FUNCTION public.act_talon(integer) OWNER TO zona;

--
-- Name: actfeclose(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION actfeclose() RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
registro 	RECORD;
registror 	RECORD;
stm		integer;
retval		numeric;
maxfecha	date;
fecharet	date;
BEGIN

retval:=0;

for registro in select op_id as x from operaciones where op_estado=101 and int4lt(op_tipoper,100::int4) and op_fecha_close is null loop
    maxfecha:='01-01-1900';
    select sitem_id into stm from subitem where sitem_idoper=registro.x and sitem_estado=1;
    if stm is null then
	for registror in select distinct ret_idopera as y from retiros where ret_idsitem in (select sitem_id from subitem where sitem_idoper=registro.x) loop
	    select op_fechain into fecharet from operaciones where op_id=registror.y;
	    if date_gt(fecharet,maxfecha) then
		maxfecha:=fecharet;
	    end if;
	end loop;
	update operaciones set op_fecha_close=maxfecha where op_id=registro.x;
    end if;
end loop; 

retval:=retval::numeric(15,2);

RETURN retval;
END;$$;


ALTER FUNCTION public.actfeclose() OWNER TO zona;

--
-- Name: actualizoweb(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION actualizoweb(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
begin


update wsubitem set wsitem_estado=7;

for registro in select 
     * from subitem where sitem_estado=1 and estadop(sitem_idoper)=101
    loop

	select cantidispw(wsitem_id),wsitem_cantcompw into disponible,compromweb  from wsubitem where wsitem_id=registro.sitem_id;
	if not found then
		insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
		    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),0);

		for regist in select 
		    * from retiros where ret_idsitem=registro.sitem_id
		    loop
			insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
			    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
		    end loop; 

	    else

		dispon:=registro.sitem_canting-registro.sitem_cantcomp-registro.sitem_cantret-registro.sitem_cantmala;

		if(compromweb<=dispon) then 

			delete from wretiros where wret_idsitem=registro.sitem_id;
			delete from wsubitem where wsitem_id=registro.sitem_id;

			insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
			    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),compromweb);

			for regist in select 
			    * from retiros where ret_idsitem=registro.sitem_id
			    loop
				insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			    end loop; 
		
		    else

			delete from wretiros where wret_idsitem=registro.sitem_id;
			delete from wsubitem where wsitem_id=registro.sitem_id;

			insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
			    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),0);

			for regist in select 
			    * from retiros where ret_idsitem=registro.sitem_id
			    loop
				insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			    end loop; 

			--grabo temporalweb

			llevo:=0;
			elultimo:=0;

			for registw2 in select 
    			    * from wret2 where wret2_idsitem=registro.sitem_id and wret2_estado<50
    			    loop
				elultimo:=registw2.wret2_cantidad;
				llevo:=llevo+registw2.wret2_cantidad;
				if(llevo<=dispon) then
					update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;
				    else
					if((dispon+registw2.wret2_cantidad-llevo) > 0) then
						insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registro.sitem_id,dispon,compromweb,registw2.wret2_id,dispon+registw2.wret2_cantidad-llevo);
					    else
						insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registro.sitem_id,dispon,compromweb,registw2.wret2_id,-1);
					end if;
				end if;
			    end loop; 
		end if;
	end if;
    end loop; 


delete from wsubitem where wsitem_estado=7;

ret:='t';

return ret;
end;$_$;


ALTER FUNCTION public.actualizoweb(integer) OWNER TO zona;

--
-- Name: actualizowebnew(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION actualizowebnew(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
begin


for registw2 in select 
    * from wret2 where wret2_estado<50
    loop

	elultimo:=0;
	dispon:=0;
	dispon:=cantidispw(registw2.wret2_idsitem);
	elultimo:=registw2.wret2_cantidad;

	if(elultimo<=dispon) then
		update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;
	    else
		if(dispon <= 0) then
			insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,-1);
		    else
			insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,dispon);
		end if;
	end if;
    end loop; 

ret:='t';

return ret;
end;$_$;


ALTER FUNCTION public.actualizowebnew(integer) OWNER TO zona;

--
-- Name: almacenajeconfactur(date, smallint, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION almacenajeconfactur(date, smallint, smallint, smallint, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
fecha		 alias for $1;
dias		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
usuario		 alias for $5;
ret 		 boolean;
ultfec 		 date;
registro	 record;
regi		 record;
hay	 	 int4;
begin

ret:='t';

if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart in (5,7,8,11) and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from almacenaje where al_estado=1 and al_tiprod=1 
	    loop
		ret:='f';
		insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (registro.al_idusu,fecha,8,1,(registro.al_importe / dias * registro.al_dias * registro.al_tarifa)::numeric,(registro.al_importe / dias * registro.al_dias * registro.al_tarifa)::numeric,registro.al_leyenda,1::int2,anio,mes,registro.al_dias,registro.al_id);
	    end loop; 

	for regi in select 
	    * from almacenaje where al_estado=1 and al_tiprod!=1 
	    loop
		ret:='f';
		insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (regi.al_idusu,fecha,idartdetipp(regi.al_tiprod),(regi.al_canti * regi.al_dias),regi.al_tarifa::numeric,(regi.al_tarifa * regi.al_dias * regi.al_canti)::numeric,regi.al_leyenda,1::int2,anio,mes,regi.al_dias,regi.al_id);
	    end loop; 

    else
	delete from confactur where cfc_idart in (5,7,8,11) and cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario;
	for registro in select 
	    * from almacenaje where al_estado=1 and al_tiprod=1 and cfc_usurio=usuario
	    loop
		ret:='f';
		insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (registro.al_idusu,fecha,8,1,(registro.al_importe / dias * registro.al_dias * registro.al_tarifa)::numeric,(registro.al_importe / dias * registro.al_dias * registro.al_tarifa)::numeric,registro.al_leyenda,1::int2,anio,mes,registro.al_dias,registro.al_id);
	    end loop; 

	for regi in select 
	    * from almacenaje where al_estado=1 and al_tiprod!=1 and al_idusu=usuario
	    loop
		ret:='f';
		insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (regi.al_idusu,fecha,idartdetipp(regi.al_tiprod),(regi.al_canti * regi.al_dias),regi.al_tarifa::numeric,(regi.al_tarifa * regi.al_dias * regi.al_canti)::numeric,regi.al_leyenda,1::int2,anio,mes,regi.al_dias,regi.al_id);
	    end loop; 


    end if;

return ret;
end;$_$;


ALTER FUNCTION public.almacenajeconfactur(date, smallint, smallint, smallint, integer) OWNER TO zona;

--
-- Name: almconfactur(date, smallint, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION almconfactur(date, smallint, smallint, smallint, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
fecha		 alias for $1;
estado		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
usuario		 alias for $5;
ret 		 boolean;
ultfec 		 date;
registro	 record;
hay	 	 int4;
begin

ret:='t';

if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart in (5,7,11) and cfc_anio=anio and cfc_mes=mes;

	for registro in select 
	    * from almacen where alm_estado=estado  
	    loop
	    ret:='f';
	    if(registro.alm_retiro is NULL) then ultfec:=fecha; else ultfec:=registro.alm_retiro; end if;

	    if((int4eq(registro.alm_idusu,4030::int4) and int4eq(idartdetipp(registro.alm_tiprod),6))  or (int4eq(registro.alm_idusu,4117::int4) and int4eq(idartdetipp(registro.alm_tiprod),6))) then
		    ret:='f';
		else
		    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (registro.alm_idusu,fecha,idartdetipp(registro.alm_tiprod),1::numeric,registro.alm_tarifa::numeric,registro.alm_tarifa*date_mi(ultfec,registro.alm_ultfac)::numeric,registro.alm_leyenda,1::int2,anio,mes,date_mi(ultfec,registro.alm_ultfac),registro.alm_id);
		    ret:='t';
		end if;
	    end loop; 

    else
	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart in (5,7,11);
	for registro in select 
	    * from almacen where alm_estado=estado and alm_idusu=usuario 
	    loop
	    ret:='f';
	    if(registro.alm_retiro is NULL) then ultfec:=fecha; else ultfec:=registro.alm_retiro; end if;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias,cfc_idalm) values (registro.alm_idusu,fecha,idartdetipp(registro.alm_tiprod),1::numeric,registro.alm_tarifa::numeric,registro.alm_tarifa*date_mi(ultfec,registro.alm_ultfac)::numeric,registro.alm_leyenda,1::int2,anio,mes,date_mi(ultfec,registro.alm_ultfac),registro.alm_id);
	    end loop; 

end if;

return ret;
end;$_$;


ALTER FUNCTION public.almconfactur(date, smallint, smallint, smallint, integer) OWNER TO zona;

--
-- Name: alqconfactur(integer, smallint, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION alqconfactur(integer, smallint, smallint, date) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
anio 		 alias for $2;
mes 		 alias for $3;
fecha		 alias for $4;
ret 		 boolean;
registro	 record;
aux_iva		 numeric;
hay	 	 int4;
importe 	 numeric;
articulo 	 int4;
begin

ret:='f';

SELECT  var_valor 
INTO     aux_iva -- Monto no grabado de alquileres
FROM varamb    WHERE var_codigo like 'IMP_SIN_IVA%';


if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart between 22 and 31 and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from tarifas where tari_idart between 22 and 31  
		and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:='t';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		importe:=valtarico(registro.tari_usuario,articulo,0::numeric,0::int2,fecha::date,registro.tari_idcontr,registro.tari_orden);
		if(importe < aux_iva) then articulo:=articulo + 5; end if;
--		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,importe,importe,1::int2,anio,mes);
	    end if; 
	end loop; 

    else

	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart between 22 and 31;
	for registro in select 
	    * from tarifas where tari_idart between 22 and 31 and tari_usuario=usuario and estadocontr(tari_idcontr)=1 
		and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:='t';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		importe:=valtarico(registro.tari_usuario,articulo,0::numeric,0::int2,fecha::date,registro.tari_idcontr,registro.tari_orden);
		if(importe < aux_iva) then articulo:=articulo + 5; end if;
--		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,importe,importe,1::int2,anio,mes);
    	    end if; 
	end loop; 
end if;

return ret;
end;$_$;


ALTER FUNCTION public.alqconfactur(integer, smallint, smallint, date) OWNER TO zona;

--
-- Name: alqconfactur2(integer, smallint, smallint, date, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION alqconfactur2(integer, smallint, smallint, date, numeric) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
anio 		 alias for $2;
mes 		 alias for $3;
fecha		 alias for $4;
cotiza		 alias for $5;
ret 		 boolean;
registro	 record;
aux_iva		 numeric;
aux_iva_a	 numeric;
hay	 	 int4;
importe 	 numeric;
cantidad 	 numeric;
total 		 numeric;
articulo 	 int4;
begin

ret:='f';

SELECT  var_valor 
INTO     aux_iva_a -- Monto no grabado de alquileres
FROM varamb    WHERE var_codigo like 'IMP_SIN_IVA%';

--Divido importe maximo para factura no grabado por cotizacion dolar pasada por referencia
aux_iva:=aux_iva_a/cotiza;

--Actualmente esta situacion no pasa nunca, obligo usuario
if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart between 22 and 31 and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from tarifas where tari_idart between 22 and 31  
		and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:='t';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		importe:=valtarico(registro.tari_usuario,articulo,0::numeric,0::int2,fecha::date,registro.tari_idcontr,registro.tari_orden);
		if(importe < aux_iva) then articulo:=articulo + 5; end if;
--		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,importe,importe,1::int2,anio,mes);
	    end if; 
	end loop; 

    else

	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart in (23,24,25);
	for registro in select 
	    * from tarifas where tari_idart in (23,24,25) and tari_usuario=usuario and estadocontr(tari_idcontr)=1 
		and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:='t';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		importe:=imptari(registro.tari_usuario,articulo,fecha::date,registro.tari_idcontr);
		cantidad:=cantmetroscontr(registro.tari_idcontr);
		--Total = importe de la tarifa en dolares * cantidad de metros cuadrados del contrato
		total:=importe*cantidad;
		if(total < aux_iva) then articulo:=articulo + 5; end if;
--		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
		insert into confactur1 (cfc1_ptov,cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_estado,cfc1_anio,cfc1_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,cantidad,importe,total,1::int2,anio,mes);
    	    end if; 
	end loop; 
end if;

return ret;
end;$_$;


ALTER FUNCTION public.alqconfactur2(integer, smallint, smallint, date, numeric) OWNER TO zona;

--
-- Name: analiz1_astc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION analiz1_astc(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	idastc		integer;
	registro	 record;
	imp		numeric;
    BEGIN
    retval:=1;


    for registro in select idastoh,idcli(1,codcli) as idcli,importe,grupo from m_ctacte order by idastoh
    loop
	select astc_id into idastc from astoctas where astc_idastoh=registro.idastoh and astc_ctacble=18 and astc_importe=registro.importe and astc_ctacte=registro.idcli limit 1;
	if not found then
	    select astc_id into idastc from astoctas where astc_idastoh=registro.idastoh and astc_ctacble=18 and astc_importe=registro.importe and astc_ctacte=-1 limit 1;
	    if found then
		update astoctas set astc_ctacte=registro.idcli, astc_grupo=registro.grupo where astc_id=idastc;
	      else		
		insert into m_difer (numero,dif1,astoc) values (idastoh,'no lo encontre en astoctas',idcli);
	    end if;
	end if;
    end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.analiz1_astc(integer) OWNER TO zona;

--
-- Name: analiz2_astc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION analiz2_astc(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	idastc		integer;
	nume		integer;
	idastoh1		integer;
	registro	 record;
	imp		numeric;
    BEGIN
    retval:=1;


    for registro in select * from m_difer where tip=1 and codigo='PG' order by numero
    loop
	select astc_id,astc_idastoh into idastc,idastoh1 from astoctas where astc_comprob=838 and astc_numero=registro.numero order by astc_id limit 1;
	nume:=idastc -1;
	update astoctas set astc_ctacte=idcli(1,ctacte::integer) from m_astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(1,ctacble) and astc_ctacble=18 and idastoh=idastoh1 and orden+nume=astc_id;
    end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.analiz2_astc(integer) OWNER TO zona;

--
-- Name: anioastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION anioastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_anio from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.anioastoh(integer) OWNER TO zona;

--
-- Name: anul_factu_alm(integer, smallint, smallint, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION anul_factu_alm(integer, smallint, smallint, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	anio		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	opera		ALIAS FOR $4; 
	codemp		ALIAS FOR $5; 
	articulo	integer;
	artsegur	integer;
	registro	record;
	regist		record;
	retval 		integer;
    BEGIN
    retval:=0;

    select valvaramb(codemp,0,'ARTALM')  into articulo;   
    select valvaramb(codemp,0,'ARTSEG')  into artsegur;   

    if(int4ne(cliente,0) and int4eq(opera,0)) then
	for registro in select distinct(fac_idoper) from facturacion where fac_codemp=codemp and fac_cliente=cliente and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart=articulo
	loop
	    update voling set vol_ultfac=vol_ultfac-registro.fac_dias where vol_idoper=registro.fac_idoper;
	end loop;

	delete from facturacion where fac_codemp=codemp and fac_cliente=cliente and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart in (articulo,artsegur);
	for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
	    loop
		delete from facturacion where fac_codemp=codemp and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_cliente=cliente;
	    end loop; 
    end if;


    if(int4eq(cliente,0) and  int4eq(opera,0)) then
	for registro in select distinct(fac_idoper) from facturacion where fac_codemp=codemp and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart=articulo
	loop
	update voling set vol_ultfac=vol_ultfac-registro.fac_dias where vol_idoper=registro.fac_idoper;
	end loop;
	delete from facturacion where fac_codemp=codemp and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart in (articulo,artsegur);
	for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
	    loop
		delete from facturacion where fac_codemp=codemp and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_anio=anio and fac_mes=mes and fac_estado=1;
	    end loop; 
    end if;


    if(int4ne(opera,0)) then
	for registro in select distinct(fac_idoper) from facturacion where fac_codemp=codemp and fac_idoper=opera and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart=articulo
	loop
	update voling set vol_ultfac=vol_ultfac-registro.fac_dias where vol_idoper=registro.fac_idoper;
	end loop;
	delete from facturacion where fac_codemp=codemp and fac_idoper=opera and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idart in (articulo,artsegur);
	for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
	    loop
		delete from facturacion where fac_codemp=codemp and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_anio=anio and fac_mes=mes and fac_estado=1 and fac_idoper=opera;
	    end loop; 
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.anul_factu_alm(integer, smallint, smallint, integer, integer) OWNER TO zona;

--
-- Name: arrcompvsret(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arrcompvsret(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
cantidad	 numeric(15,5);

begin
for registro in select 
    * from auxoperv
    loop
	if int4gt(registro.avh_idoper,0) then 
		update subitem set sitem_cantcomp=0 where sitem_id=registro.avh_idoper;
	end if;
end loop; 

delete from auxoperv where avh_idoper>0;

ret:='t';
return ret;
end;$_$;


ALTER FUNCTION public.arrcompvsret(integer) OWNER TO zona;

--
-- Name: arreart(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreart() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
idart		int4;
rowintotal 	int4;
ruflo 	int4;
idsitem 	int4;
begin
ret:=0;

idsitem:=1;
for regi in select * from intotal order by int_directo,int_indirecto,int_tipoper,int_numero,int_articod,int_lotenum
	loop
	idart:=cidart(regi.int_indirecto::int4,regi.int_articod::varchar);
	update subitem set sitem_artic=idart where sitem_id=idsitem;
	idsitem:=idsitem+1;
    end loop; 

return ret;
end;$$;


ALTER FUNCTION public.arreart() OWNER TO zona;

--
-- Name: arreartic(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreartic(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare

mal		alias for $1;
bien		alias for $2;
codigobien	varchar;
codigomal	varchar;
ret		int4;

begin
ret:=20;

select sitem_id into ret from subitem where sitem_artic=mal; 

return ret;
end;$_$;


ALTER FUNCTION public.arreartic(integer, integer) OWNER TO zona;

--
-- Name: arrecono(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arrecono() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
idoper		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
conocim 	varchar;
ruflo2 	int4;
begin
ret:=0;
idoper:=1;

for regi in select distinct on (int_directo,int_indirecto,int_tipoper,int_numero) * from intotal
	loop
	conocim:=trim(regi.int_conocim);
	update operaciones  set op_conocim=conocim where op_id=idoper;
	idoper:=idoper+1;
        end loop; 

return ret;
end;$$;


ALTER FUNCTION public.arrecono() OWNER TO zona;

--
-- Name: arrecontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arrecontr(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
ret 		 boolean;
registro	 record;
regi		 record;
regi2		 record;
regi3		 record;
unif	 	 int4;
anterior 	 int2;
begin

    ret:='f';
--    for registro in select 
--	* from contratos where contr_locador=usuario and contr_estado in (1,0) and contr_unifun=0  
--	loop
--	    anterior:=1;
--	    for regi in select 
--		* from unifun where unif_usuario=usuario and unif_estado=1  
--		loop
--		    if(int2ne(anterior,regi.unif_codigo)) then
--			update contratos set contr_unifun=regi.unif_codigo where contr_id=registro.contr_id;
--			anterior:=regi.unif_codigo;		
--		      else
--			insert into contratos1 (contr1_id,contr1_locador,contr1_locatario,contr1_idsubt,contr1_unifun,contr1_garantia,contr1_step,contr1_facturable,contr1_leyenda,contr1_estado,contr1_metros,contr1_puxmtro,contr1_inter,contr1_fecha1,contr1_fecha2,contr1_fecha3,contr1_fecha4,contr1_fecha5,contr1_fecha6,contr1_fecha7,contr1_fecha8,contr1_dispos)
--			     values (registro.contr_id,registro.contr_locador,registro.contr_locatario,registro.contr_idsubt,regi.unif_codigo,registro.contr_garantia,registro.contr_step,registro.contr_facturable,registro.contr_leyenda,registro.contr_estado,registro.contr_metros,registro.contr_puxmtro,registro.contr_inter,registro.contr_fecha1,registro.contr_fecha2,registro.contr_fecha3,registro.contr_fecha4,registro.contr_fecha5,registro.contr_fecha6,registro.contr_fecha7,registro.contr_fecha8,registro.contr_dispos);
--			ret:='t';
--		    end if;
--		    anterior:=regi.unif_codigo;		
--		end loop; 
--	end loop; 



	for regi3 in select 
	    * from contratos1 where contr1_locador=usuario  
	    loop
		select contr_unifun into anterior from contratos where contr_id=regi3.contr1_id and contr_unifun=regi3.contr1_unifun;
		if not found then
		    insert into contratos (contr_locador,contr_locatario,contr_idsubt,contr_unifun,contr_garantia,contr_step,contr_facturable,contr_leyenda,contr_estado,contr_metros,contr_puxmtro,contr_inter,contr_fecha1,contr_fecha2,contr_fecha3,contr_fecha4,contr_fecha5,contr_fecha6,contr_fecha7,contr_fecha8,contr_dispos)
    		     values (regi3.contr1_locador,regi3.contr1_locatario,regi3.contr1_idsubt,regi3.contr1_unifun,regi3.contr1_garantia,regi3.contr1_step,regi3.contr1_facturable,regi3.contr1_leyenda,regi3.contr1_estado,regi3.contr1_metros,regi3.contr1_puxmtro,regi3.contr1_inter,regi3.contr1_fecha1,regi3.contr1_fecha2,regi3.contr1_fecha3,regi3.contr1_fecha4,regi3.contr1_fecha5,regi3.contr1_fecha6,regi3.contr1_fecha7,regi3.contr1_fecha8,regi3.contr1_dispos);
		end if;
	end loop; 


    return ret;
    end;$_$;


ALTER FUNCTION public.arrecontr(integer) OWNER TO zona;

--
-- Name: arreglo4030(integer, integer, numeric, numeric, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo4030(integer, integer, numeric, numeric, smallint, smallint) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 
	tope		ALIAS FOR $2; 
	tarifamayor	ALIAS FOR $3; 
	tarifamenor	ALIAS FOR $4; 
	anio		ALIAS FOR $5; 
	mes		ALIAS FOR $6; 
	ret 		integer;
	cuantos		int4;
    BEGIN
    ret:=0;

    select count(*) into cuantos from almacen where alm_estado=1 and alm_idusu=usuario and alm_retiro is null;

    ret:=cuantos;

    if int4gt(cuantos,tope) then
	    update almacen set alm_tarifa=tarifamayor where alm_estado=1 and alm_idusu=usuario;    
	    update confactur set cfc_precio=tarifamayor,cfc_importe=cfc_dias*tarifamayor where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=11 and cfc_ptov=2;
	else    
	    update almacen set alm_tarifa=tarifamenor where alm_estado=1 and alm_idusu=usuario;    
	    update confactur set cfc_precio=tarifamenor,cfc_importe=cfc_dias*tarifamenor where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=11 and cfc_ptov=2;
    end if;    
    
return ret;
	
    END;$_$;


ALTER FUNCTION public.arreglo4030(integer, integer, numeric, numeric, smallint, smallint) OWNER TO zona;

--
-- Name: arreglo_cantcompret(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo_cantcompret(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
DECLARE
operacion	ALIAS FOR $1; 	-- id de la Operacion
modo		ALIAS FOR $2; 	-- 1 arregla cantcomp
				-- 2 arregla cantret
cuantos		numeric;
registro 	RECORD;
retval 		boolean;
BEGIN

retval:='f';

if int4ne(operacion,0) then    
	if int4eq(modo,2) then        

		for registro in select sitem_id as x
    		    from subitem where sitem_idoper = operacion
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2eq(estadop(ret_idopera),101::int2);

			    update subitem set sitem_cantret=cuantos
				where sitem_id=registro.x;
			end loop; 

	    else

		for registro in select sitem_id as x
    		    from subitem where sitem_idoper = operacion
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2lt(estadop(ret_idopera),100::int2);

			    update subitem set sitem_cantcomp=cuantos
				where sitem_id=registro.x;
			end loop; 

retval:='t';

	end if;    

    else

	if int4eq(modo,2) then        

		for registro in select sitem_id as x
    		    from subitem 
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2eq(estadop(ret_idopera),101::int2);

			    update subitem set sitem_cantret=cuantos
				where sitem_id=registro.x;
			end loop; 

	    else

		for registro in select sitem_id as x
    		    from subitem 
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2lt(estadop(ret_idopera),100::int2);

			    update subitem set sitem_cantcomp=cuantos
				where sitem_id=registro.x;
			end loop; 

retval:='t';

	end if;    


end if;    

RETURN retval;
END;$_$;


ALTER FUNCTION public.arreglo_cantcompret(integer, integer) OWNER TO zona;

--
-- Name: arreglo_importo(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo_importo(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	caratul		ALIAS FOR $1; -- id de la Caratula.
	despachos	text;
	xx		int4;
	retval		boolean;
	registro	record;
    BEGIN
	
	select despacho into despachos from caratula where car_id=caratul;

	select items_idcaratula into xx from items where items_idcaratula=caratul;
	if not found then
		update items set items_idcaratula=caratul where bpchareq(despachos,items_despacho);
		update items set codigo_articulo=modelo_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '';
		update items set codigo_articulo=descrip_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '';
		update items set codigo_articulo=marca_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '';
		update items set codigo_articulo='S/C' where items_idcaratula=caratul and trim(codigo_articulo) like '';
	end if;

	retval:='t';

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.arreglo_importo(integer) OWNER TO zona;

--
-- Name: articdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION articdesitem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sitem_artic from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.articdesitem(integer) OWNER TO zona;

--
-- Name: articulodewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION articulodewret2(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.wsitem_codart from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;$_$;


ALTER FUNCTION public.articulodewret2(integer) OWNER TO zona;

--
-- Name: ashdeastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ashdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idastoh from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ashdeastc(integer) OWNER TO zona;

--
-- Name: astcdecomp(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecomp(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 limit 1 ;$_$;


ALTER FUNCTION public.astcdecomp(integer, integer) OWNER TO zona;

--
-- Name: astcdecompchq(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompchq(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchq(character varying, integer, integer) OWNER TO zona;

--
-- Name: astcdecompchqn(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompchqn(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 and astc_importe<0 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchqn(character varying, integer, integer) OWNER TO zona;

--
-- Name: astcdecompchqp(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompchqp(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 and astc_importe>0 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchqp(character varying, integer, integer) OWNER TO zona;

--
-- Name: astcdecompxctacte(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompxctacte(integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_ctacte= idprov(1, $3) limit 1 ;$_$;


ALTER FUNCTION public.astcdecompxctacte(integer, integer, integer) OWNER TO zona;

--
-- Name: astcdecompxctacte2(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompxctacte2(integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_ctacte= idcli(1, $3) limit 1 ;$_$;


ALTER FUNCTION public.astcdecompxctacte2(integer, integer, integer) OWNER TO zona;

--
-- Name: astcdecompximp(integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION astcdecompximp(integer, integer, numeric) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_importe= $3 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompximp(integer, integer, numeric) OWNER TO zona;

--
-- Name: auto_adentro(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION auto_adentro(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select iol_liviano from inoutliv where iol_estado=1 and iol_liviano= $1 ;$_$;


ALTER FUNCTION public.auto_adentro(integer) OWNER TO zona;

--
-- Name: borro_la_operacion(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION borro_la_operacion(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit 
	consi		int4;
    BEGIN
	select csg_id into consi from consig where bpchareq(csg_nrocuit,cuit);
		if not found then
		    insert into consig (csg_nrocuit,csg_nombre) values (cuit,'DATO DESCONOCIDO');
		    select csg_id into consi from consig where bpchareq(csg_nrocuit,cuit);
		end if;

	RETURN consi;
    END;$_$;


ALTER FUNCTION public.borro_la_operacion(integer) OWNER TO zona;

--
-- Name: borro_todo_ingre(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION borro_todo_ingre(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion		ALIAS FOR $1; -- id  Operacion
	cholo			ALIAS FOR $2; -- id  Operador
	estado_operacion	int2;
	salidas 		numeric;
	ret boolean;
	aux_texto 		text;
    BEGIN
    ret:=true;
    select op_estado into estado_operacion from
	 operaciones where op_id=operacion;

    if int2eq(estado_operacion,1::int2) 	-- A Futuro
	then
	delete from subitem where sitem_idoper=operacion;	
	delete from item where item_idoper=operacion;	
    	update operaciones set op_estado=999 where op_id=operacion;
    end if;

    if int2eq(estado_operacion,101::int2) 	-- Oficializada
	then
	select sum(sitem_cantret)+sum(sitem_cantcomp) into salidas 
	    from subitem where sitem_idoper=operacion;
--	raise notice 'oficializada ';
	if(numeric_ne(salidas,0::numeric)) then
	aux_texto:='No se puede Anular esta operacion por existir retiros o reexpediciones ';
	insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
--      raise notice 'No se puede Anular esta operacion por existir retiros o reexpediciones ';
	else
    	    update operaciones set op_estado=102 where op_id=operacion;
	    update subitem set sitem_estado=3 where sitem_idoper=operacion;
	    insert into modopub (mod_idoperador,mod_idoper,mod_modalidad,mod_estado) values(cholo,operacion,'A', 1);
--	    raise notice 'la op paso a 102 ';
	end if;

    end if;

    if int2eq(estado_operacion,102::int2) 	-- Modificada
	then
	    if(check_autorizacion(operacion,cholo))
	    then
    	    update operaciones set op_estado=999 where op_id=operacion;
	    delete from subitem where sitem_idoper=operacion;	
	    delete from item where item_idoper=operacion;	
--	    raise notice 'la op paso a 999 ';
	    end if;
    end if;

return ret;
	
    END;$_$;


ALTER FUNCTION public.borro_todo_ingre(integer, integer) OWNER TO zona;

--
-- Name: bzaconfactur(date, date, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION bzaconfactur(date, date, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
desde		 alias for $1;
hasta		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:='t';
for registro in select 
    * from opervehi where opv_est_camion=50 and date_ge(date(opv_fecha_egr),desde) and date_le(date(opv_fecha_egr),hasta) and opv_pesa='S' and opv_nro_ticket is not null
	loop

	ret:='f';
	select op_directo,op_indirecto,op_tipoper into directo,indirecto,tipoper from operaciones where op_id=registro.opv_idoper;

	select cfc_id into hay from confactur where cfc_idoper=registro.opv_idoper and cfc_ticket=registro.opv_nro_ticket;
	if not found then
	    auxot:=substr(nomusu(indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(tipoper),1,3) || '-'|| nrotaldiroper(registro.opv_idoper);
--	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_ticket,cfc_anio,cfc_mes,cfc_indirecto) values (directo,registro.opv_fecha_egr,40::int4,1::numeric,15::numeric,15::numeric,registro.opv_idoper,auxot,1::int2,registro.opv_nro_ticket,anio,mes,indirecto);
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_ticket,cfc_anio,cfc_mes,cfc_indirecto) values (directo,registro.opv_fecha_egr,40::int4,1::numeric,valtari(directo,40,0::numeric,0::int2,registro.opv_fecha_egr::date),valtari(directo,40,0::numeric,0::int2,registro.opv_fecha_egr::date),registro.opv_idoper,auxot,1::int2,registro.opv_nro_ticket,anio,mes,indirecto);
	end if;

end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.bzaconfactur(date, date, smallint, smallint) OWNER TO zona;

--
-- Name: calculo_alm(integer, date, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_alm(integer, date, integer, smallint, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	fechah		ALIAS FOR $2; 
	opera		ALIAS FOR $3; 
	deposito	ALIAS FOR $4; 
	codemp		ALIAS FOR $5; 
	registro	record;
	regi		record;
	regist		record;
	mal		int2;
	pase		int4;
	aux_texto 	text;
	aux_texto2 	text;
	articulo	integer;
	sigo		integer;
	retval 		numeric;
	valstoc		numeric;
	retire		numeric;
	volumen		numeric;
	precio		numeric;
	importe		numeric;
    BEGIN
    retval:=0;

    select valvaramb(codemp,0,'ARTALM')  into articulo;   

    if(int4ne(cliente,0)) then
	for registro in select * from voling where vol_directo=codemp and vol_cliente=cliente and vol_estado=101 and vol_ultfac<fechah 
	loop
	    pase:=1;
	    volumen:=registro.vol_canting;

	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;

	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;

	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fechah and vole_cantret!=0 and vole_estado!=999
		loop
		    pase:=2;
		    volumen:=volumen - regi.vole_cantret;
		    retval:=retval+ ((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio);
		end loop;

	    if(volumen) then
		retval:=retval+ ((fechah - registro.vol_ultfac) * volumen * precio);
	    end if;
	end loop;
    end if;


    if(int4ne(opera,0)) then
	for registro in select * from voling where vol_directo=codemp and vol_idoper=opera and vol_estado=101 and vol_ultfac<fechah 
	loop
	    pase:=1;
	    volumen:=registro.vol_canting;

	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;

	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;

	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fechah and vole_cantret!=0 and vole_estado!=999
		loop
		    pase:=2;
		    volumen:=volumen - regi.vole_cantret;
		    retval:=retval+ ((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio);
		end loop;

	    if(volumen) then
		retval:=retval+ ((fechah - registro.vol_ultfac) * volumen * precio);
	    end if;
	end loop;
    end if;


    if(int2ne(deposito,0::int2)) then
	for registro in select * from voling where vol_directo=codemp and depositop(vol_idoper)=deposito and vol_estado=101 and vol_ultfac<fechah 
	loop
	    pase:=1;
	    volumen:=registro.vol_canting;

	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;

	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;

	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fechah and vole_cantret!=0 and vole_estado!=999
		loop
		    pase:=2;
		    volumen:=volumen - regi.vole_cantret;
		    retval:=retval+ ((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio);
		end loop;

	    if(volumen) then
		retval:=retval+ ((fechah - registro.vol_ultfac) * volumen * precio);
	    end if;
	end loop;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.calculo_alm(integer, date, integer, smallint, integer) OWNER TO zona;

--
-- Name: calculo_almac(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_almac(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	valvol		numeric;
	valvoli		numeric;
	totdias		integer;
	t		int4;
	nvalvol		numeric;
	oldf		date;
	ultfactu	date;
	ultfecha	date;
	antf		date;
	fecha		date;
	tarifa		numeric;
	remanente	numeric;
	dias		integer;
	diasbonif	integer;
	diasret		integer;
	nusuario	integer;
	almacomun	integer;
	almararo	integer;
	cuantos		integer;
	ret		numeric;
	aux_texto 	text;
	registro	RECORD;
	regi		RECORD;
	registro2	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
tarifa:=0;

almacomun:=9;
almararo:=107;


if(int4eq(usuario,0))  THEN

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 order by 1
	loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=registro2.usu;
	    if (cuantos is not null and int4gt(cuantos,0)) then
		totdias:=0;
		dias:=0;
		ret:=0;
		valvol:=0;
		nvalvol:=0;
		oldf:=fechad;
		fecha:=fechad;
		tarifa:=0;
		nusuario=registro2.usu;
		delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
	
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=nusuario and estadop(vol_idoper)=101 and vol_directo=1 order by 1 asc limit 1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(nusuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(nusuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(nusuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(nusuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(nusuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(nusuario,almacomun,valvol,fechah::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=nusuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 order by 1
	loop
	    diasbonif:=30;
	    ret:=0;
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu 
		loop
		    select (registro.vol_ultfac + interval '1 day')::date into oldf;
		    fecha:=oldf;
		    dias:=0;
		    select (fechah - registro.vol_fechain) into totdias;
		    if (int4le(totdias,diasbonif)) then
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias;
			if int4eq(modo,1) then
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end if;
		    else
			remanente:=vol_fecha_indirecto_op(registro2.usu,registro.vol_ultfac,registro.vol_idoper);
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - FACTURO, MAYOR A % DIAS = % DIAS // VOLUMEN INICIAL: %',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias,remanente;
			for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,registro.vol_ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
			    loop
				select (regi.vole_fechaeg - registro.vol_fechain) into diasret;
				if (int4le(diasret,diasbonif)) then
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % NO CUENTA POR SER RETIRADO ANTES DE LOS % DIAS = % DIAS // VOLUMEN SACADO: %',regi.vole_idoper,regi.vole_compbte,diasbonif,diasret,regi.vole_cantret;
				    remanente:=remanente - regi.vole_cantret;
				    RAISE NOTICE 'REMANENTE %',remanente;
				else
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % SE FACTURA EL VOLUMEN ANTES DEL RETIRO POR SER RETIRADO A LOS % DIAS // VOLUMEN A FACTURAR: %',regi.vole_idoper,regi.vole_compbte,diasret,remanente;
				    select (regi.vole_fechaeg - oldf + 1) into dias;
				    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
				    ret:= ret + (dias * tarifa * remanente);
				    RAISE NOTICE 'SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: EGRESO % - ULT % // TOTAL SUMADO %',dias,tarifa,regi.vole_fechaeg,oldf,ret;
				    remanente:=remanente - regi.vole_cantret;
				    select (oldf + interval '1 day')::date into oldf;
				end if;
			    end loop;
			if (numeric_gt(remanente,0)) then
			    select (fechah - oldf + 1) into dias;
			    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
			    ret:= ret + (dias * tarifa * remanente);
			    RAISE NOTICE 'REMANENTE % // SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: CORTE % - ULT % // TOTAL SUMADO %',remanente,dias,tarifa,fechah,oldf,ret;
			    if int4eq(modo,1) then
				update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			else
			    if int4eq(modo,1) then
				update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			end if;
		    end if;
		end loop;

		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,registro2.usu,1::int2);
		end if;
	end loop;

else

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1
	loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=usuario;
	    if (cuantos is not null and int4gt(cuantos,0)) then
		delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;

		--AGREGO
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 order by 1 asc limit 1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(usuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(usuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(usuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(usuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(usuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,usuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=usuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;


    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1
	loop
	    diasbonif:=30;
	    ret:=0;
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu 
		loop
		    select (registro.vol_ultfac + interval '1 day')::date into oldf;
		    fecha:=oldf;
		    dias:=0;
		    select (fechah - registro.vol_fechain) into totdias;
		    if (int4le(totdias,diasbonif)) then
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias;
			if int4eq(modo,1) then
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end if;
		    else
			remanente:=vol_fecha_indirecto_op(registro2.usu,registro.vol_ultfac,registro.vol_idoper);
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - FACTURO, MAYOR A % DIAS = % DIAS // VOLUMEN INICIAL: %',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias,remanente;
			for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,registro.vol_ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
			    loop
				select (regi.vole_fechaeg - registro.vol_fechain) into diasret;
				if (int4le(diasret,diasbonif)) then
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % NO CUENTA POR SER RETIRADO ANTES DE LOS % DIAS = % DIAS // VOLUMEN SACADO: %',regi.vole_idoper,regi.vole_compbte,diasbonif,diasret,regi.vole_cantret;
				    remanente:=remanente - regi.vole_cantret;
				    RAISE NOTICE 'REMANENTE %',remanente;
				else
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % SE FACTURA EL VOLUMEN ANTES DEL RETIRO POR SER RETIRADO A LOS % DIAS // VOLUMEN A FACTURAR: %',regi.vole_idoper,regi.vole_compbte,diasret,remanente;
				    select (regi.vole_fechaeg - oldf + 1) into dias;
				    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
				    ret:= ret + (dias * tarifa * remanente);
				    RAISE NOTICE 'SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: EGRESO % - ULT % // TOTAL SUMADO %',dias,tarifa,regi.vole_fechaeg,oldf,ret;
				    remanente:=remanente - regi.vole_cantret;
				    select (oldf + interval '1 day')::date into oldf;
				end if;
			    end loop;
			if (numeric_gt(remanente,0)) then
			    select (fechah - oldf + 1) into dias;
			    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
			    ret:= ret + (dias * tarifa * remanente);
			    RAISE NOTICE 'REMANENTE % // SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: CORTE % - ULT % // TOTAL SUMADO %',remanente,dias,tarifa,fechah,oldf,ret;
			    if int4eq(modo,1) then
				update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			else
			    if int4eq(modo,1) then
				update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			end if;
		    end if;
		end loop;

		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,registro2.usu,1::int2);
		end if;


	end loop;


end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_almac(integer, date, date, integer) OWNER TO zona;

--
-- Name: calculo_almac2(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_almac2(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	valvol		numeric;
	valvoli		numeric;
	totdias		integer;
	t		int4;
	nvalvol		numeric;
	oldf		date;
	ultfactu	date;
	ultfecha	date;
	antf		date;
	fecha		date;
	tarifa		numeric;
	remanente	numeric;
	dias		integer;
	diasbonif	integer;
	diasret		integer;
	nusuario	integer;
	almacomun	integer;
	almararo	integer;
	cuantos		integer;
	ret		numeric;
	aux_texto 	text;
	registro	RECORD;
	regi		RECORD;
	registro2	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
tarifa:=0;

almacomun:=9;
almararo:=107;


if(int4eq(usuario,0))  THEN

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 order by 1
	loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=registro2.usu;
	    if (cuantos is not null and int4gt(cuantos,0)) then
		totdias:=0;
		dias:=0;
		ret:=0;
		valvol:=0;
		nvalvol:=0;
		oldf:=fechad;
		fecha:=fechad;
		tarifa:=0;
		nusuario=registro2.usu;
		delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
	
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=nusuario and estadop(vol_idoper)=101 and vol_directo=1 order by 1 asc limit 1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(nusuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(nusuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(nusuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(nusuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(nusuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(nusuario,almacomun,valvol,fechah::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=nusuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 order by 1
	loop
	    diasbonif:=30;
	    ret:=0;
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu 
		loop
		    select (registro.vol_ultfac + interval '1 day')::date into oldf;
		    fecha:=oldf;
		    dias:=0;
		    select (fechah - registro.vol_fechain) into totdias;
		    if (int4le(totdias,diasbonif)) then
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias;
			if int4eq(modo,1) then
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end if;
		    else
			remanente:=vol_fecha_indirecto_op(registro2.usu,registro.vol_ultfac,registro.vol_idoper);
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - FACTURO, MAYOR A % DIAS = % DIAS // VOLUMEN INICIAL: %',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias,remanente;
			for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,registro.vol_ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
			    loop
				select (regi.vole_fechaeg - registro.vol_fechain) into diasret;
				if (int4le(diasret,diasbonif)) then
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % NO CUENTA POR SER RETIRADO ANTES DE LOS % DIAS = % DIAS // VOLUMEN SACADO: %',regi.vole_idoper,regi.vole_compbte,diasbonif,diasret,regi.vole_cantret;
				    remanente:=remanente - regi.vole_cantret;
				    RAISE NOTICE 'REMANENTE %',remanente;
				else
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % SE FACTURA EL VOLUMEN ANTES DEL RETIRO POR SER RETIRADO A LOS % DIAS // VOLUMEN A FACTURAR: %',regi.vole_idoper,regi.vole_compbte,diasret,remanente;
				    select (regi.vole_fechaeg - oldf + 1) into dias;
				    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
				    ret:= ret + (dias * tarifa * remanente);
				    RAISE NOTICE 'SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: EGRESO % - ULT % // TOTAL SUMADO %',dias,tarifa,regi.vole_fechaeg,oldf,ret;
				    remanente:=remanente - regi.vole_cantret;
				    select (oldf + interval '1 day')::date into oldf;
				end if;
			    end loop;
			if (numeric_gt(remanente,0)) then
			    select (fechah - oldf + 1) into dias;
			    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
			    ret:= ret + (dias * tarifa * remanente);
			    RAISE NOTICE 'REMANENTE % // SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: CORTE % - ULT % // TOTAL SUMADO %',remanente,dias,tarifa,fechah,oldf,ret;
			    if int4eq(modo,1) then
				update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			else
			    if int4eq(modo,1) then
				update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			end if;
		    end if;
		end loop;

		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,registro2.usu,1::int2);
		end if;
	end loop;

else

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1
	loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=usuario;
	    if (cuantos is not null and int4gt(cuantos,0)) then
		delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;

		--AGREGO
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 order by 1 asc limit 1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(usuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(usuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(usuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(usuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(usuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,usuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=usuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;


    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1
	loop
	    diasbonif:=30;
	    ret:=0;
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu 
		loop
		    select (registro.vol_ultfac + interval '1 day')::date into oldf;
		    fecha:=oldf;
		    dias:=0;
		    select (fechah - registro.vol_fechain) into totdias;
		    if (int4le(totdias,diasbonif)) then
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias;
			if int4eq(modo,1) then
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end if;
		    else
			remanente:=vol_fecha_indirecto_op(registro2.usu,registro.vol_ultfac,registro.vol_idoper);
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - FACTURO, MAYOR A % DIAS = % DIAS // VOLUMEN INICIAL: %',registro.vol_idoper,registro.vol_compbte,diasbonif,totdias,remanente;
			for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,registro.vol_ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
			    loop
				select (regi.vole_fechaeg - registro.vol_fechain) into diasret;
				if (int4le(diasret,diasbonif)) then
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % NO CUENTA POR SER RETIRADO ANTES DE LOS % DIAS = % DIAS // VOLUMEN SACADO: %',regi.vole_idoper,regi.vole_compbte,diasbonif,diasret,regi.vole_cantret;
				    remanente:=remanente - regi.vole_cantret;
				    RAISE NOTICE 'REMANENTE %',remanente;
				else
				    RAISE NOTICE 'RETIRO ID % - COMPBTE % SE FACTURA EL VOLUMEN ANTES DEL RETIRO POR SER RETIRADO A LOS % DIAS // VOLUMEN A FACTURAR: %',regi.vole_idoper,regi.vole_compbte,diasret,remanente;
				    select (regi.vole_fechaeg - oldf + 1) into dias;
				    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
				    ret:= ret + (dias * tarifa * remanente);
				    RAISE NOTICE 'SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: EGRESO % - ULT % // TOTAL SUMADO %',dias,tarifa,regi.vole_fechaeg,oldf,ret;
				    remanente:=remanente - regi.vole_cantret;
				    select (oldf + interval '1 day')::date into oldf;
				end if;
			    end loop;
			if (numeric_gt(remanente,0)) then
			    select (fechah - oldf + 1) into dias;
			    select tariman(registro2.usu,almararo,remanente,fecha::date) into tarifa;
			    ret:= ret + (dias * tarifa * remanente);
			    RAISE NOTICE 'REMANENTE % // SE FACTURAN % DIAS A UNA TARIFA DE % // FECHAS: CORTE % - ULT % // TOTAL SUMADO %',remanente,dias,tarifa,fechah,oldf,ret;
			    if int4eq(modo,1) then
				update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			else
			    if int4eq(modo,1) then
				update voling set vol_factu=3,vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			end if;
		    end if;
		end loop;

		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,registro2.usu,1::int2);
		end if;


	end loop;


end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_almac2(integer, date, date, integer) OWNER TO zona;

--
-- Name: calculo_almac_abierto(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_almac_abierto(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	valvol		numeric;
	valvoli		numeric;
	totdias		integer;
	totdias1	integer;
	t		int4;
	nvalvol		numeric;
	oldf		date;
	ultfactu	date;
	ultfecha	date;
	antf		date;
	fecha		date;
	fechaing	date;
	fechaegr	date;
	tarifa		numeric;
	remanente	numeric;
	dias		integer;
	diasa		integer;
	diasbonif	integer;
	diasret		integer;
	nusuario	integer;
	abierto		integer;
	cuantos		integer;
	ret		numeric;
	aux_texto 	text;
	compingreso 	character varying(16);
	registro	RECORD;
	regi		RECORD;
	registro2	RECORD;
	registro3	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
tarifa:=0;

abierto:=4;

if(int4eq(usuario,0))  THEN

	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=abierto and estadocontr(tari_idcontr)=1 order by 1 loop
	    nusuario=registro2.usu;
	    for registro3 in select * from sitemxvehi where date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr)) in (1,101) and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=nusuario and sv_estado=1 order by 1,2 loop

		--Si voy a grabar, borro todo lo que exista de este articulo para este usuario y para esta fecha.
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=abierto and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
		end if;

		--Obtengo cual es el peso que debo cobrar consultando cual era el peso al dia de ayer del retiro
		valvol:=registro3.sv_peso;

		--La fecha que ingreso la operacion
		fechaing:=registro3.sv_fechaing;

		--Dias desde el ingreso inicial a hoy que retiro
		select (registro3.sv_fechaegr - fechaing + 1) into diasa;
		--Cual es la tarifa en principio?
		select tariman(nusuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;

		dias:=30;
		--Se excede los 30 dias?
		if int4gt(diasa,dias) then
		    select tariman(nusuario,abierto,dias,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * dias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,dias,ret,fechaing,registro3.sv_fechaegr;
		    totdias:=diasa-dias;
		    select tariman(nusuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * totdias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		else
		    ret:=ret + (valvol * tarifa * diasa);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		end if;
	    end loop;

		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) and numeric_gt(ret,0) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),abierto,1,ret,ret,1,aux_texto,nusuario,4::int2);
		    for registro3 in select * from sitemxvehi where date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr))=101 and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=nusuario and sv_estado=1 order by 1,2 loop
			    update sitemxvehi set sv_estado=50,sv_fechafac=fechad where sv_id=registro3.sv_id;
			end loop;
		end if;
	end loop;


else

	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=abierto and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1 loop
	    for registro3 in select * from sitemxvehi where date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr)) in (1,101) and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=usuario and sv_estado=1 order by 1,2 loop

		--Si voy a grabar, borro todo lo que exista de este articulo para este usuario y para esta fecha.
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=abierto and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;
		end if;

		--Obtengo cual es el peso que debo cobrar consultando cual era el peso al dia de ayer del retiro
		valvol:=registro3.sv_peso;

		--La fecha que ingreso la operacion
		fechaing:=registro3.sv_fechaing;

		--Dias desde el ingreso inicial a hoy que retiro
		select (registro3.sv_fechaegr - fechaing + 1) into diasa;
		--Cual es la tarifa en principio?
		select tariman(usuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;

		dias:=30;
		--Se excede los 30 dias?
		if int4gt(diasa,dias) then
		    select tariman(usuario,abierto,dias,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * dias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,dias,ret,fechaing,registro3.sv_fechaegr;
		    totdias:=diasa-dias;
		    select tariman(usuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * totdias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		else
		    ret:=ret + (valvol * tarifa * diasa);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		end if;
	    end loop;

		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) and numeric_gt(ret,0) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),abierto,1,ret,ret,1,aux_texto,usuario,4::int2);
		    for registro3 in select * from sitemxvehi where date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr))=101 and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=usuario and sv_estado=1 order by 1,2 loop
			    update sitemxvehi set sv_estado=50,sv_fechafac=fechad where sv_id=registro3.sv_id;
			end loop;
		end if;
	end loop;

end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_almac_abierto(integer, date, date, integer) OWNER TO zona;

--
-- Name: calculo_almac_abierto(integer, date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_almac_abierto(integer, date, date, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	depo		ALIAS FOR $5; 	
	valvol		numeric;
	valvoli		numeric;
	totdias		integer;
	totdias1	integer;
	t		int4;
	nvalvol		numeric;
	oldf		date;
	ultfactu	date;
	ultfecha	date;
	antf		date;
	fecha		date;
	fechaing	date;
	fechaegr	date;
	tarifa		numeric;
	remanente	numeric;
	dias		integer;
	diasa		integer;
	diasbonif	integer;
	diasret		integer;
	nusuario	integer;
	abierto		integer;
	cuantos		integer;
	ptv		integer;
	ret		numeric;
	aux_texto 	text;
	compingreso 	character varying(16);
	registro	RECORD;
	regi		RECORD;
	registro2	RECORD;
	registro3	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
tarifa:=0;

abierto:=4;

if int4eq(depo,5) then
    ptv:=3;
else
    ptv:=4;
end if;


if(int4eq(usuario,0))  THEN

	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=abierto and estadocontr(tari_idcontr)=1 order by 1 loop
	    nusuario=registro2.usu;
	    for registro3 in select * from sitemxvehi where depositem(sv_idsitem)=depo and date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr)) in (1,101) and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=nusuario and sv_estado=1 order by 1,2 loop

		--Si voy a grabar, borro todo lo que exista de este articulo para este usuario y para esta fecha.
--		if int4eq(modo,1) then
--		    delete from confactur1 where cfc1_idart=abierto and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
--		end if;

		--Obtengo cual es el peso que debo cobrar consultando cual era el peso al dia de ayer del retiro
		valvol:=registro3.sv_peso;

		--La fecha que ingreso la operacion
		fechaing:=registro3.sv_fechaing;

		--Dias desde el ingreso inicial a hoy que retiro
		select (registro3.sv_fechaegr - fechaing + 1) into diasa;
		--Cual es la tarifa en principio?
		select tariman(nusuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;

		dias:=30;
		--Se excede los 30 dias?
		if int4gt(diasa,dias) then
		    select tariman(nusuario,abierto,dias,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * dias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,dias,ret,fechaing,registro3.sv_fechaegr;
		    totdias:=diasa-dias;
		    select tariman(nusuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * totdias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		else
		    ret:=ret + (valvol * tarifa * diasa);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',nusuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		end if;
	    end loop;

		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) and numeric_gt(ret,0) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),abierto,1,ret,ret,1,aux_texto,nusuario,ptv::int2);
		    for registro3 in select * from sitemxvehi where depositem(sv_idsitem)=depo and date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr))=101 and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=nusuario and sv_estado=1 order by 1,2 loop
			    update sitemxvehi set sv_estado=50,sv_fechafac=fechad where sv_id=registro3.sv_id;
			end loop;
		end if;
	end loop;


else

	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=abierto and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1 loop
	    for registro3 in select * from sitemxvehi where depositem(sv_idsitem)=depo and date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr)) in (1,101) and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=usuario and sv_estado=1 order by 1,2 loop

		--Si voy a grabar, borro todo lo que exista de este articulo para este usuario y para esta fecha.
--		if int4eq(modo,1) then
--		    delete from confactur1 where cfc1_idart=abierto and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;
--		end if;

		--Obtengo cual es el peso que debo cobrar consultando cual era el peso al dia de ayer del retiro
		valvol:=registro3.sv_peso;

		--La fecha que ingreso la operacion
		fechaing:=registro3.sv_fechaing;

		--Dias desde el ingreso inicial a hoy que retiro
		select (registro3.sv_fechaegr - fechaing + 1) into diasa;
		--Cual es la tarifa en principio?
		select tariman(usuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;

		dias:=30;
		--Se excede los 30 dias?
		if int4gt(diasa,dias) then
		    select tariman(usuario,abierto,dias,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * dias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,dias,ret,fechaing,registro3.sv_fechaegr;
		    totdias:=diasa-dias;
		    select tariman(usuario,abierto,diasa,registro3.sv_fechaegr) into tarifa;
		    ret:=ret + (valvol * tarifa * totdias);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		else
		    ret:=ret + (valvol * tarifa * diasa);
		    RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - F-ING: % - F-EGR: %',usuario,tarifa,valvol,diasa,ret,fechaing,registro3.sv_fechaegr;
		end if;
	    end loop;

		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) and numeric_gt(ret,0) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),abierto,1,ret,ret,1,aux_texto,usuario,ptv::int2);
		    for registro3 in select * from sitemxvehi where depositem(sv_idsitem)=depo and date_le(sv_fechaegr,fechah) and date_ge(sv_fechaegr,fechad) and estadop(opdeopv(sv_idopvegr))=101 and directodeop(opdeopv(sv_idopvegr))=1 and indirectodeop(opdeopv(sv_idopvegr))=usuario and sv_estado=1 order by 1,2 loop
			    update sitemxvehi set sv_estado=50,sv_fechafac=fechad where sv_id=registro3.sv_id;
			end loop;
		end if;
	end loop;

end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_almac_abierto(integer, date, date, integer, integer) OWNER TO zona;

--
-- Name: calculo_almac_comun(integer, date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_almac_comun(integer, date, date, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	cdesc		ALIAS FOR $5; 	-- 1 descuento
					-- 2 almacenaje
	valvol		numeric;
	valvoli		numeric;
	totdias		integer;
	totdias1	integer;
	t		int4;
	nvalvol		numeric;
	oldf		date;
	ultfactu	date;
	ultfecha	date;
	antf		date;
	fecha		date;
	fechaing	date;
	fechaegr	date;
	tarifa		numeric;
	remanente	numeric;
	dias		integer;
	diasa		integer;
	nacional	integer;
	nacional2	integer;
	diasbonif	integer;
	diasret		integer;
	nusuario	integer;
	almacomun	integer;
	almararo	integer;
	descraro	integer;
	cuantos		integer;
	ret		numeric;
	aux_texto 	text;
	compingreso 	character varying(16);
	registro	RECORD;
	regi		RECORD;
	registro2	RECORD;
	registro3	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
tarifa:=0;

almacomun:=9;
almararo:=107;
descraro:=108;
nacional:=6;
nacional2:=5;


if(int4eq(usuario,0))  THEN

    if (int4ne(cdesc,1)) then
	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 order by 1 loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=registro2.usu and vol_indirecto!=1 and depositop(vol_idoper) not in (nacional,nacional2);
	    if (cuantos is not null and int4gt(cuantos,0)) then
		totdias:=0;
		dias:=0;
		ret:=0;
		valvol:=0;
		nvalvol:=0;
		oldf:=fechad;
		fecha:=fechad;
		tarifa:=0;
		nusuario=registro2.usu;
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
		end if;
	
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=nusuario and estadop(vol_idoper)=101 and vol_directo=1 and depositop(vol_idoper) not in (nacional,nacional2) order by 1 asc limit 1;
		ultfactu:=fechad-1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(nusuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(nusuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(nusuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(nusuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(nusuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(nusuario,almacomun,valvol,fechah::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);

		RAISE NOTICE 'USUARIO: %, ALMACENAJE %',nusuario,ret;


		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) and numeric_gt(ret,0) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=nusuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;
    end if;

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 order by 1 loop
	diasbonif:=30;
	ret:=0;
	nusuario=registro2.usu;
	if (int4eq(cdesc,1)) then
	    for registro in select * from volegr where date_ge(vole_fechaeg,fechad) and date_le(vole_fechaeg,fechah) and vole_directo=1 and estadop(vole_idoper)=101 and vole_indirecto=registro2.usu and depositop(vole_idoperi) not in (nacional,nacional2) 
		loop
		    select vol_fechain,vol_ultfac,vol_compbte into oldf,fecha,compingreso from voling where vol_idoper=registro.vole_idoperi;
		    dias:=0;
		    /*Busco todos los retiros del mes, por cada retiro chequeo si se realizo dentro de los primero 30 dias, si fue asi descuento, sino sigo. Ultfac es para obtener
		    la tarifa*/
		    select (registro.vole_fechaeg - oldf) into totdias;
		    if (int4le(totdias,diasbonif)) then
			aux_texto:='Bonificacion Almacenaje ' || registro.vole_compbte || ' Correspondiente a Mercaderia Depositada Del Comprobante ' compingreso;
			/*RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vole_idoper,registro.vole_compbte,diasbonif,totdias;*/
			remanente:=registro.vole_cantret;
			select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
			select tariman(nusuario,almararo,nvalvol,registro.vole_fechaeg::date) into tarifa;
			ret:=ret + (remanente * tarifa * totdias);
		    end if;
		end loop;
		if (numeric_gt(ret,0)) then
		    ret:= ret * -1;
		    RAISE NOTICE 'USUARIO: %, DESCUENTO %',nusuario,ret;
		    if int4eq(modo,1) then
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),descraro,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    end if;
		end if;
	else
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=registro2.usu and vol_indirecto!=1 and depositop(vol_idoper) not in (nacional,nacional2);
	    if (cuantos is not null and int4gt(cuantos,0)) then
		totdias:=0;
		dias:=0;
		ret:=0;
		valvol:=0;
		nvalvol:=0;
		oldf:=fechad;
		fecha:=fechad;
		tarifa:=0;
		nusuario=registro2.usu;
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=almararo and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
		end if;
	
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 and date_lt(vol_ultfac,fechad) and depositop(vol_idoper) not in (nacional,nacional2) order by 1 desc limit 1;
		ultfactu:=fechad-1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(usuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(usuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(usuario,almararo,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
		    end if;
		end if;



		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(nusuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(nusuario,almararo,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(nusuario,almararo,valvol,fechah::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);

		RAISE NOTICE 'USUARIO: %, ALMACENAJE %',nusuario,ret;
		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=nusuario 
			loop
			    select (fechah - registro.vol_fechain) into totdias1;
			    if (int4gt(totdias1,diasbonif)) then
				update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    end if;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end if;
    end loop;

else


    if (int4ne(cdesc,1)) then
	for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almacomun and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1 loop
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=usuario and depositop(vol_idoper) not in (nacional,nacional2);
	    if (cuantos is not null and int4gt(cuantos,0)) then
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=almacomun and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;
		end if;
		--AGREGO
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 and depositop(vol_idoper) not in (nacional,nacional2) order by 1 asc limit 1;
		ultfactu:=fechad-1;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(usuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(usuario,fechad) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(usuario,almacomun,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			oldf:=oldf+1;
			RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: 1 - RET: % - FECHAD: % - FECHAH: %',usuario,tarifa,valvol,ret,ultfactu,fechad;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(usuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(usuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			select (fecha + 1) into oldf;
			RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % ',usuario,tarifa,valvol,dias,ret;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(usuario,almacomun,valvol,fecha::date) into tarifa;
		select vol_fecha_indirecto(nusuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % ',usuario,tarifa,valvol,dias,ret;
		aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),almacomun,1,ret,ret,totdias,aux_texto,usuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=usuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end loop;
    end if;

    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1 loop
	diasbonif:=30;
	nusuario:=registro2.usu;
	ret:=0;
	if (int4eq(cdesc,1)) then
	    for registro in select * from volegr where date_ge(vole_fechaeg,fechad) and date_le(vole_fechaeg,fechah) and vole_directo=1 and estadop(vole_idoper)=101 and vole_indirecto=registro2.usu and depositop(vole_idoperi) not in (nacional,nacional2) 
		loop
		    select vol_fechain,vol_ultfac,vol_compbte into oldf,fecha,compingreso from voling where vol_idoper=registro.vole_idoperi;
		    dias:=0;
		    /*Busco todos los retiros del mes, por cada retiro chequeo si se realizo dentro de los primero 30 dias, si fue asi descuento, sino sigo. Ultfac es para obtener
		    la tarifa*/
		    select (registro.vole_fechaeg - oldf) into totdias;
		    if (int4le(totdias,diasbonif)) then
			aux_texto:='Bonificacion Almacenaje ' || registro.vole_compbte || ' Correspondiente a Mercaderia Depositada Del Comprobante ' compingreso;
			RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % - NO FACTURO, MENOR A % DIAS = % DIAS',registro.vole_idoper,registro.vole_compbte,diasbonif,totdias;
			remanente:=registro.vole_cantret;
			select vol_fecha_indirecto(nusuario, fecha) into nvalvol;
			select tariman(nusuario,almararo,nvalvol,registro.vole_fechaeg::date) into tarifa;
			ret:=ret + (remanente * tarifa * totdias);
		    end if;
		end loop;
		if (numeric_gt(ret,0)) then
		    ret:= ret * -1;
		    if int4eq(modo,1) then
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),descraro,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
		    end if;
		end if;
	else
	    aux_texto:='Almacenaje Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;
	    select count(*) into cuantos from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto=usuario and vol_indirecto!=1 and depositop(vol_idoper) not in (nacional,nacional2);
	    if (cuantos is not null and int4gt(cuantos,0)) then
		totdias:=0;
		dias:=0;
		ret:=0;
		valvol:=0;
		nvalvol:=0;
		oldf:=fechad;
		fecha:=fechad;
		tarifa:=0;
		if int4eq(modo,1) then
		    delete from confactur1 where cfc1_idart=almararo and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;
		end if;
	
		select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 and date_lt(vol_ultfac,fechad) and depositop(vol_idoper) not in (nacional,nacional2) order by 1 desc limit 1;
		ultfactu:=fechad-1;
		RAISE NOTICE 'USUARIO: % - FECH ULTFACT: % - FECHAD: % ',usuario,ultfactu,fechad;
		if(date_le(ultfactu,fechad)) then
		    select vol_fecha_indirecto(usuario,ultfactu) into valvol;
		    select vol_fecha_indirecto(usuario,fechad) into nvalvol;
		    RAISE NOTICE 'USUARIO: % - VOL ULTFACT: % - VOL FECHAD: % ',usuario,valvol,nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select tariman(usuario,almararo,valvol,fechad::date) into tarifa;
			ret:=ret + (valvol * tarifa * 1);
			RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: 1 - RET: % - FECHAD: % - FECHAH: %',usuario,tarifa,valvol,ret,ultfactu,fechad;
			oldf:=oldf+1;
		    end if;
		end if;

		select (fechah - fechad) into totdias;
		t:=0;
		while t <= totdias loop
		    select vol_fecha_indirecto(usuario, fecha) into valvol;
		    select (fechad + t) into fecha;
		    select vol_fecha_indirecto(usuario, fecha) into nvalvol;
		    if(numeric_ne(valvol,nvalvol)) then
			select (fecha - oldf + 1) into dias;
			select tariman(usuario,almararo,valvol,fecha::date) into tarifa;
			ret:=ret + (valvol * tarifa * dias);
			RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - FD: % - FH: %',usuario,tarifa,valvol,dias,ret,oldf,fecha;
			select (fecha + 1) into oldf;
		    end if;
		    t:= t + 1;
		end loop;

		select (fechah - oldf) into dias;
		dias:=dias + 1;
		select tariman(usuario,almararo,valvol,fechah::date) into tarifa;
		select vol_fecha_indirecto(usuario, fechad) into valvoli;
		ret:=ret + (valvol * tarifa * dias);
		RAISE NOTICE 'USUARIO: % - TARIFA: % - VOLUMEN: % - DIAS: % - RET: % - FD: % - FH: %',usuario,tarifa,valvol,dias,ret,oldf,fechah;

		if int4eq(modo,1) then
		    select (fechah - fechad) into totdias;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),almararo,1,ret,ret,totdias,aux_texto,usuario,1::int2);
		    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=usuario 
			loop
			    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
			    remanente:=registro.vol_canting;
			    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
				loop
				    remanente:= remanente - regi.vole_cantret;
					if(numeric_le(remanente,0)) then
					    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
					end if;
				end loop;
			end loop;
		end if;
	    end if;
	end if;

    end loop;



end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_almac_comun(integer, date, date, integer, integer) OWNER TO zona;

--
-- Name: calculo_funcion(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_funcion(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idreg		ALIAS FOR $1;  -- id del registro
	idartic		ALIAS FOR $2;  -- id del articulo 
	idoper		ALIAS FOR $3; 
	tabla		ALIAS FOR $4;  -- 1=voling   y   2=volegr 
	modo		int4;
	pase		int4;
	registro	record;
	valorfob	text;
	funcion		text;
	funcion2	text;
	funcion3	text;
	cotiz		text;
	peso		text;
	volumen		numeric;
	cantidad	numeric;
	preciopul	numeric;
	precio		numeric;
	sinfun		int4;
	retval		numeric;
    BEGIN
    retval:=0;
    pase:=0;
    sinfun:=1;


	select cfac_funcion into funcion from complfac where cfac_id=idreg;
	if not found then
	    select art_funcion into funcion from articvta where art_id=idartic;
	    if not found then
		sinfun:=0;
	    end if;
	end if;

	    funcion:='('||funcion; 
	    funcion:=funcion||')'; 


	select cfac_precio into preciopul from complfac where cfac_id=idreg;
	if not found then
	    select art_precio into precio from articvta where art_id=idartic;
	end if;

	if numeric_eq(preciopul,0) then
	    select art_precio into precio from articvta where art_id=idartic;
	end if;


if sinfun then
	if funcion then
	    if numeric_gt(preciopul,0) then
		    funcion:= funcion ||'*'||preciopul; 
		else
		    if(precio) then
			funcion:= funcion ||'*'||precio; 
		    end if;
	    end if;


	    if(funcion like '%FOB%') then
	    pase:=1;
		if int4eq(tabla,1) then
		    select valfob_ahora(idoper) into valorfob;
		end if;
		if int4eq(tabla,2) then
		    select valfob_reti(idoper) into valorfob;
		end if;
		select replace(funcion,'FOB',valorfob) into funcion2;
		select ult_cotiz(1) into cotiz;
		funcion2:= cotiz ||'*'||funcion2; 
		funcion3:=funcion2; 
	    end if;

	    if(funcion3) then
		funcion:=funcion3; 
	    end if;

	    if(funcion like '%VOL%' or funcion like '%PESO%' or funcion like '%CANT%') then
	    pase:=1;
		volumen:=0;
		peso:=0;
		cantidad:=0;

		if int4eq(tabla,1) then
		    select volton_hay(idoper) into valorfob;
		    select vol_modo into modo from voling where vol_idoper=idoper; 
		    if int4eq(modo,1) then volumen:=valorfob; end if;
		    if int4eq(modo,2) then cantidad:=valorfob; end if;
		    if int4eq(modo,3) then peso:=valorfob; end if;
		end if;

		if int4eq(tabla,2) then
		    for registro in select vol_modo as modalidad,sum(vole_cantret) as cuanto from volegr,voling where vole_idoper=idoper 
			and vole_idoperi=vol_idoper  group by 1 
			loop
			    if int4eq(registro.modalidad,1) then volumen:=registro.cuanto; end if;
			    if int4eq(registro.modalidad,2) then cantidad:=registro.cuanto; end if;
			    if int4eq(registro.modalidad,3) then peso:=registro.cuanto; end if;
			end loop;
		end if;

		select replace(funcion,'VOL',volumen) into funcion2;
		select replace(funcion2,'PESO',peso) into funcion;
		select replace(funcion,'CANT',cantidad) into funcion2;

		funcion3:=funcion2; 
	    end if;

	    if int4eq(pase,0) then
		funcion3:=funcion;
	    end if;

	    select eval_funcion(funcion3) into retval;

	  else

	    if numeric_gt(preciopul,0) then
		    retval:=preciopul; 
		else
		    if(precio) then
			retval:= precio; 
		    end if;
	    end if;

	end if;

  else
    if numeric_gt(preciopul,0) then
	    retval:=preciopul; 
		    if(precio) then
			retval:= precio; 
		    end if;
    end if;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.calculo_funcion(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: calculo_prop(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_prop(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- fecha desde
	fechad		ALIAS FOR $2; 	-- fecha desde
	proxfact	ALIAS FOR $3; 	-- fecha desde
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	remanente	numeric;
	dias		integer;
	diasbon		integer;
	almararo	integer;
	ultfac		date;
	ret		numeric;
	tarifa		numeric;
	volumen		numeric;
	aux_texto	text;
	registro	RECORD;
	registro2	RECORD;
	regi		RECORD;
    BEGIN

almararo:=107;
diasbon:=31;
ret:=0;

if(int4eq(usuario,0))  THEN
    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 order by 1 loop
	for registro in select * from voling where vol_factu=1 and date_eq(vol_ultfac,vol_fechain) and date_lt(vol_ultfac,fechad) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu loop
	    select (fechad - interval '1 day')::date into ultfac;
	    aux_texto:='Proporcional Almacenaje ' || registro.vol_compbte || ' Correspondiente a Mercaderia Depositada Desde ' || registro.vol_ultfac || ' Hasta ' || ultfac;
	    RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % ',registro.vol_idoper,registro.vol_compbte;
	    remanente:=registro.vol_canting;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,ultfac) and estadop(vole_idoper)=101 loop
		remanente:= remanente - regi.vole_cantret;
	    end loop;
	    if(numeric_gt(remanente,0)) then
		select (ultfac - registro.vol_ultfac + 1) into dias;
		select vol_fecha_indirecto(registro2.usu,registro.vol_ultfac) into volumen;
		select tariman(registro2.usu,almararo,volumen,ultfac::date) into tarifa;
		ret:=ret + (remanente * tarifa * dias);
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,proxfact,date_part('year',proxfact),date_part('month',proxfact),almararo,1,ret,ret,dias,aux_texto,registro2.usu,1::int2);
		end if;
	    end if;
	end loop;
    end loop;
else
    for registro2 in select distinct tari_usuario as usu from tarifas where tari_idcontr>0 and tari_idart=almararo and estadocontr(tari_idcontr)=1 and tari_usuario=usuario order by 1 loop
	for registro in select * from voling where vol_factu=1 and date_eq(vol_ultfac,vol_fechain) and date_lt(vol_ultfac,fechad) and vol_directo=1 and estadop(vol_idoper)=101 and vol_indirecto=registro2.usu loop
	    select (fechad - interval '1 day')::date into ultfac;
	    aux_texto:='Proporcional Almacenaje ' || registro.vol_compbte || ' Correspondiente a Mercaderia Depositada Desde ' || registro.vol_ultfac || ' Hasta ' || ultfac;
	    RAISE NOTICE 'OPERACION ID: % - COMPROBANTE: % ',registro.vol_idoper,registro.vol_compbte;
	    remanente:=registro.vol_canting;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,ultfac) and estadop(vole_idoper)=101 loop
		remanente:= remanente - regi.vole_cantret;
	    end loop;
	    if(numeric_gt(remanente,0)) then
		select (ultfac - registro.vol_ultfac + 1) into dias;
		select vol_fecha_indirecto(registro2.usu,registro.vol_ultfac) into volumen;
		select tariman(registro2.usu,almararo,volumen,ultfac::date) into tarifa;
		ret:=ret + (remanente * tarifa * dias);
		if int4eq(modo,1) then
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (registro2.usu,proxfact,date_part('year',proxfact),date_part('month',proxfact),almararo,1,ret,ret,dias,aux_texto,registro2.usu,1::int2);
		end if;
	    end if;
	end loop;
    end loop;
end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_prop(integer, date, date, integer) OWNER TO zona;

--
-- Name: calculo_seg(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_seg(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	valcif		numeric;
	valcifi		numeric;
	totdias		integer;
	t		int4;
	elprimero	int4;
	nvalcif		numeric;
	oldf		date;
	antf		date;
	fecha		date;
	ultfactu	date;
	fechai		date;
	tarseg		numeric;
	nacional	integer;
	nacional2	integer;
	dias		integer;
	entre		integer;
	nusuario	integer;
	ret		numeric;
	aux_texto 	text;
	registro	RECORD;

    BEGIN

ret:=0;
dias:=0;
oldf:=fechad;
fecha:=fechad;
nacional:=6;
nacional2:=5;

if(int4eq(usuario,0))  THEN
    for registro in select vol_indirecto,count(*) as cuantos  from voling where vol_factu in (1,3) and date_le(vol_ultfac,fechah) and estadop(vol_idoper)=101 and vol_directo=1 and vol_indirecto!=1 and depositop(vol_idoper) not in (nacional,nacional2) group by 1 order by 1
	loop
	totdias:=0;
	dias:=0;
	ret:=0;
	entre:=0;
	valcif:=0;
	elprimero:=0;
	nvalcif:=0;
	oldf:=fechad;
	fecha:=fechad;
	nusuario=registro.vol_indirecto;
	if int4eq(modo,1) then
	    delete from confactur1 where cfc1_idart=55 and date_gt(cfc1_fecha,fechad) and cfc1_usuario=nusuario;
	end if;

	select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=nusuario and estadop(vol_idoper)=101 and vol_directo=1 and depositop(vol_idoper) not in (nacional,nacional2) order by 1 desc limit 1;
	ultfactu:=fechad-1;
	if (date_le(ultfactu,fechad)) then
	    select cif_a_fecha_indirecto(nusuario, ultfactu) into valcif;
	    select cif_a_fecha_indirecto(nusuario, fechad) into nvalcif;
	    if(numeric_ne(valcif,nvalcif)) then
		select tarseg(nusuario,valcif) into tarseg;
		ret:=ret + (valcif * tarseg / 30 * 1);
		oldf:=oldf+1;
	    end if;
	end if;


	select (fechah - fechad) into totdias;

	entre:=0;
	t:=0;
	while t <= totdias loop
	    select cif_a_fecha_indirecto(nusuario, fecha) into valcif;

	    select (fechad + t) into fecha;
	    select cif_a_fecha_indirecto(nusuario, fecha) into nvalcif;

	    if(numeric_ne(valcif,nvalcif)) then
		select (fecha - oldf + 1) into dias;
		select tarseg(nusuario,valcif) into tarseg;
		ret:=ret + (valcif * tarseg / 30 * (dias + entre));
		select (fecha + 1) into oldf;
	    end if;
	    t:= t + 1;
	end loop;

	select (fechah - oldf) into dias;
	dias:=dias + 1;
	select tarseg(nusuario,valcif) into tarseg;

	select cif_a_fecha_indirecto(nusuario, fechad) into valcifi;
	if numeric_eq(valcifi,0) then
	    entre:=0;
	    select cif_a_fecha_indirecto(nusuario, fechah) into valcif;
	    select tarseg(nusuario,valcif) into tarseg;
	end if;
	ret:=ret + (valcif * tarseg / 30 * (dias + entre));
	aux_texto:='Seguro Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;


	if int4eq(modo,1) and numeric_gt(ret,0) then
	    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (nusuario,fechah,date_part('year',fechah),date_part('month',fechah),55,1,ret,ret,totdias,aux_texto,nusuario,1::int2);
	end if;

	end loop;


  else

	nusuario:=usuario;

	if int4eq(modo,1) then
	    delete from confactur1 where cfc1_idart=55 and date_gt(cfc1_fecha,fechad) and cfc1_usuario=usuario;
	end if;

	select vol_ultfac into ultfactu from voling where vol_factu=1 and vol_indirecto=usuario and estadop(vol_idoper)=101 and vol_directo=1 and depositop(vol_idoper) not in (nacional,nacional2) order by 1 desc limit 1;
	ultfactu:=fechad-1;
	if (date_le(ultfactu,fechad)) then
	    select cif_a_fecha_indirecto(usuario, ultfactu) into valcif;
	    select cif_a_fecha_indirecto(usuario, fechad) into nvalcif;
	    if(numeric_ne(valcif,nvalcif)) then
		select tarseg(nusuario,valcif) into tarseg;
		ret:=ret + (valcif * tarseg / 30 * 1);
		RAISE NOTICE 'RET %, VALCIF %, TARIFA %, DIAS 1 (NVALCIF % - ULTFACTU % - FECHAD %)',ret,valcif,tarseg,nvalcif,ultfactu,fechad;
		oldf:=oldf+1;
	    end if;
	end if;



	select (fechah - fechad) into totdias;

	entre:=0;
	t:=0;
	while t <= totdias loop
	    select cif_a_fecha_indirecto(usuario, fecha) into valcif;
	    select (fechad + t) into fecha;
	    select cif_a_fecha_indirecto(usuario, fecha) into nvalcif;

	    if(numeric_ne(valcif,nvalcif)) then
		select (fecha - oldf + 1) into dias;
		select tarseg(nusuario,valcif) into tarseg;
		ret:=ret + (valcif * tarseg / 30 * (dias + entre));
		RAISE NOTICE 'RET %, VALCIF %, TARIFA %, DIAS %',ret,valcif,tarseg,(dias+entre);
		select (fecha + 1) into oldf;
	    end if;
	    t:= t + 1;
	end loop;

	select (fechah - oldf) into dias;
	dias:=dias + 1;
	select tarseg(nusuario,valcif) into tarseg;

	select cif_a_fecha_indirecto(usuario, fechad) into valcifi;
	if numeric_eq(valcifi,0) then
	    entre:=0;
	    select cif_a_fecha_indirecto(usuario, fechah) into valcif;
	    select tarseg(nusuario,valcif) into tarseg;
	end if;

	ret:=ret + (valcif * tarseg / 30 * (dias + entre));
	RAISE NOTICE 'RET %, VALCIF %, TARIFA %, DIAS %',ret,valcif,tarseg,(dias+entre);

	aux_texto:='Seguro Correspondiente a Mercaderia Depositada  Desde ' || fechad || ' Hasta ' || fechah;

	if int4eq(usuario,1) then
	    ret:=0;
	end if;

	if int4eq(modo,1) and numeric_gt(ret,0) then
	    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_indirecto,cfc1_ptov) values (usuario,fechah,date_part('year',fechah),date_part('month',fechah),55,1,ret,ret,totdias,aux_texto,usuario,1::int2);
	end if;
end if;

update voling set vol_factu=2 where vol_factu=3;


RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_seg(integer, date, date, integer) OWNER TO zona;

--
-- Name: calculo_seg_y_alm(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION calculo_seg_y_alm(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	valcif		numeric;
	valalm		numeric;
	unicif		numeric;
	remanente	numeric;
	remanseg	numeric;
	sacado		numeric;
	tarifa		numeric;
	tarseg		numeric;
	porcif		numeric;
	operacion	integer;
	dias		integer;
	ultfac		date;
	ultfac2		date;
	ultfac3		date;
	esnuevo		integer;
	ret		numeric;
	aux_texto 	text;
	registro	RECORD;
	regi		RECORD;
    BEGIN


if(int4eq(usuario,0))  THEN
    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101
    loop
	sacado:=0;
	valcif:=0;
	remanente:=0;
	dias=0;
	tarifa=0;
	if int4eq(modo,1) then
	    select hfac_id into esnuevo from histfac where hfac_idoper=registro.vol_idoper;
	    if not found then
		select (registro.vol_ultfac -1) into ultfac3;
		insert into histfac (hfac_fecha,hfac_anio,hfac_mes,hfac_idoper) values (ultfac3,date_part('year',registro.vol_ultfac),date_part('month',registro.vol_ultfac),registro.vol_idoper);
	    end if;
	    insert into histfac (hfac_fecha,hfac_anio,hfac_mes,hfac_idoper) values (fechah,date_part('year',fechah),date_part('month',fechah),registro.vol_idoper);

	    select tarifb(registro.vol_indirecto,9,0::numeric,registro.vol_idoper,fechah::date) into tarifa;

	    select (hfac_fecha + 1) into ultfac from histfac where hfac_idoper=registro.vol_idoper and date_ne(hfac_fecha,fechah) order by hfac_id desc limit 1;
	    select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into valcif from operaciones,auxoper where op_id=auxo_idoper and op_id=registro.vol_idoper;
	    if not found then
		valcif:=-99999999;
	    end if;

	    unicif:= valcif / registro.vol_canting;

	    select sum(vole_cantret) into sacado from volegr where vole_idoperi=registro.vol_idoper and date_lt(vole_fechaeg,ultfac) and estadop(vole_idoper)=101;
	    if not found then
		sacado:=0;
	    end if;
	    if(sacado is null) then
		sacado:=0;
	    end if;

	    remanente:=registro.vol_canting - sacado;

	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101 order by vole_fechaeg
		loop

		    remanente:= remanente - regi.vole_cantret;
		    --  ALMACENAJE
		    select (regi.vole_fechaeg - ultfac) into dias;
		    dias:=dias + 1;

		    if int4eq(registro.vol_directo,1) then
			aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_indirecto),1,25) || ' Por Egreso ' || compbteoper(regi.vole_idoper) || ' Correspondiente a Mercaderia Ingresada en Operacion ' || compbteoper(regi.vole_idoperi);
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_indirecto,regi.vole_fechaeg,date_part('year',fechah),date_part('month',fechah),9,regi.vole_cantret,tarifa,(regi.vole_cantret * dias * tarifa),dias,aux_texto,regi.vole_idoper,registro.vol_indirecto,1::int2);


		      else

			aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_directo),1,25) || ' Por Egreso ' || compbteoper(regi.vole_idoper) || ' Correspondiente a Mercaderia Ingresada en Operacion ' || compbteoper(regi.vole_idoperi);
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_directo,regi.vole_fechaeg,date_part('year',fechah),date_part('month',fechah),9,regi.vole_cantret,tarifa,(regi.vole_cantret * dias * tarifa),dias,aux_texto,regi.vole_idoper,registro.vol_indirecto,1::int2);

		    end if;
		end loop;

	    if(numeric_gt(remanente,0)) then
		select (fechah - ultfac) into dias;
		dias:=dias + 1;

	    ret:=dias::numeric;

		if int4eq(registro.vol_directo,1) then
		    aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_indirecto),1,25) || ' Correspondiente a Mercaderia en Stock Ingresada en Operacion ' || compbteoper(registro.vol_idoper);
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_indirecto,fechah,date_part('year',fechah),date_part('month',fechah),9,remanente,tarifa,(remanente * dias * tarifa),dias,aux_texto,registro.vol_idoper,registro.vol_indirecto,1::int2);


		  else

		    aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_directo),1,25) || ' Correspondiente a Mercaderia en Stock Ingresada en Operacion ' || compbteoper(registro.vol_idoper);
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_directo,fechah,date_part('year',fechah),date_part('month',fechah),9,remanente,tarifa,(remanente * dias * tarifa),dias,aux_texto,registro.vol_idoper,registro.vol_indirecto,1::int2);

		end if;
	    end if;
	end if;
	if int4eq(modo,3) then
	    delete from histfac where date_eq(hfac_fecha,fechah) and hfac_idoper=registro.vol_idoper;
	    select hfac_fecha into ultfac2 from histfac where hfac_idoper=registro.vol_idoper order by hfac_id desc limit 1;
	    delete from confactur1 where cfc1_idoper=registro.vol_idoper and cfc1_idart=9 and date_gt(cfc1_fecha,ultfac2);
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac2) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
		loop
		    delete from confactur1 where cfc1_idoper=regi.vole_idoper and cfc1_idart in (9) and date_gt(cfc1_fecha,ultfac2);
		end loop;
	    update voling set vol_ultfac=ultfac2 where vol_idoper=registro.vol_idoper;
	end if;
    end loop;



  else



    for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and vol_indirecto=usuario and estadop(vol_idoper)=101
    loop
	sacado:=0;
	valcif:=0;
	remanente:=0;
	dias=0;
	tarifa=0;
	if int4eq(modo,1) then
	    select hfac_id into esnuevo from histfac where hfac_idoper=registro.vol_idoper;
	    if not found then
		select (registro.vol_ultfac -1) into ultfac3;
		insert into histfac (hfac_fecha,hfac_anio,hfac_mes,hfac_idoper) values (ultfac3,date_part('year',registro.vol_ultfac),date_part('month',registro.vol_ultfac),registro.vol_idoper);
	    end if;
	    insert into histfac (hfac_fecha,hfac_anio,hfac_mes,hfac_idoper) values (fechah,date_part('year',fechah),date_part('month',fechah),registro.vol_idoper);

	    select tarifb(registro.vol_indirecto,9,0::numeric,registro.vol_idoper,fechah::date) into tarifa;

	    select (hfac_fecha +1) into ultfac from histfac where hfac_idoper=registro.vol_idoper and date_ne(hfac_fecha,fechah) order by hfac_id desc limit 1;
	    select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into valcif from operaciones,auxoper where op_id=auxo_idoper and op_id=registro.vol_idoper;
	    if not found then
		valcif:=-99999999;
	    end if;

	    unicif:= valcif / registro.vol_canting;

	    select sum(vole_cantret) into sacado from volegr where vole_idoperi=registro.vol_idoper and date_le(vole_fechaeg,ultfac) and estadop(vole_idoper)=101;
	    if not found then
		sacado:=0;
	    end if;
	    if(sacado is null) then
		sacado:=0;
	    end if;

	    remanente:=registro.vol_canting - sacado;

	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
		loop

		    remanente:= remanente - regi.vole_cantret;
		    --  ALMACENAJE
		    select (regi.vole_fechaeg - ultfac) into dias;
		    dias:=dias + 1;

		    if int4eq(registro.vol_directo,1) then
			aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_indirecto),1,25) || ' Por Egreso ' || compbteoper(regi.vole_idoper) || ' Correspondiente a Mercaderia Ingresada en Operacion ' || compbteoper(regi.vole_idoperi);
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_indirecto,regi.vole_fechaeg,date_part('year',fechah),date_part('month',fechah),9,regi.vole_cantret,tarifa,(regi.vole_cantret * dias * tarifa),dias,aux_texto,regi.vole_idoper,registro.vol_indirecto,1::int2);


		      else

			aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_directo),1,25) || ' Por Egreso ' || compbteoper(regi.vole_idoper) || ' Correspondiente a Mercaderia Ingresada en Operacion ' || compbteoper(regi.vole_idoperi);
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_directo,regi.vole_fechaeg,date_part('year',fechah),date_part('month',fechah),9,regi.vole_cantret,tarifa,(regi.vole_cantret * dias * tarifa),dias,aux_texto,regi.vole_idoper,registro.vol_indirecto,1::int2);

		    end if;
		end loop;


	    if(numeric_gt(remanente,0)) then
		select (fechah - ultfac) into dias;
		dias:=dias + 1;

		if int4eq(registro.vol_directo,1) then
		    aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_indirecto),1,25) || ' Correspondiente a Mercaderia en Stock Ingresada en Operacion ' || compbteoper(registro.vol_idoper);
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_indirecto,fechah,date_part('year',fechah),date_part('month',fechah),9,remanente,tarifa,(remanente * dias * tarifa),dias,aux_texto,registro.vol_idoper,registro.vol_indirecto,1::int2);


		  else

		    aux_texto:='Almacenaje del Usuario ' || substr(nomusu(registro.vol_directo),1,25) || ' Correspondiente a Mercaderia en Stock Ingresada en Operacion ' || compbteoper(registro.vol_idoper);
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_anio,cfc1_mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,cfc1_indirecto,cfc1_ptov) values (registro.vol_directo,fechah,date_part('year',fechah),date_part('month',fechah),9,remanente,tarifa,(remanente * dias * tarifa),dias,aux_texto,registro.vol_idoper,registro.vol_indirecto,1::int2);

		end if;
	    end if;
	end if;
	if int4eq(modo,3) then
	    delete from histfac where date_eq(hfac_fecha,fechah) and hfac_idoper=registro.vol_idoper;
	    select hfac_fecha into ultfac2 from histfac where hfac_idoper=registro.vol_idoper order by hfac_id desc limit 1;
	    delete from confactur1 where cfc1_idoper=registro.vol_idoper and cfc1_idart in (9) and date_gt(cfc1_fecha,ultfac2) and cfc1_usuario=usuario;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac2) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
		loop
		    delete from confactur1 where cfc1_idoper=regi.vole_idoper and cfc1_idart in (9) and date_gt(cfc1_fecha,ultfac2) and cfc1_usuario=usuario;
		end loop;
	    update voling set vol_ultfac=ultfac2 where vol_idoper=registro.vol_idoper;
	end if;
    end loop;
END IF;


if int4eq(modo,1) then
    if(int4eq(usuario,0))  THEN
	for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101
	loop
	    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
	end loop;

      else

	for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and vol_indirecto=usuario and estadop(vol_idoper)=101
	loop
	    update voling set vol_ultfac=fechah where vol_idoper=registro.vol_idoper;
	end loop;
    END IF;
END IF;



if int4eq(modo,1) then
    if(int4eq(usuario,0))  THEN
	for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and estadop(vol_idoper)=101
	loop
	    remanente:=registro.vol_canting;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
	    loop
		remanente:= remanente - regi.vole_cantret;
		if(numeric_le(remanente,0)) then
		    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
		end if;
	    end loop;
	end loop;

      else

	for registro in select * from voling where vol_factu=1 and date_le(vol_ultfac,fechah) and vol_directo=1 and vol_indirecto=usuario and estadop(vol_idoper)=101
	loop
	remanente:=registro.vol_canting;
	for regi in select * from volegr where vole_idoperi=registro.vol_idoper and date_gt(vole_fechaeg,ultfac) and date_le(vole_fechaeg,fechah) and estadop(vole_idoper)=101
	    loop
		remanente:= remanente - regi.vole_cantret;
		if(numeric_le(remanente,0)) then
		    update voling set vol_factu=3 where vol_idoper=registro.vol_idoper;
		end if;
	    end loop;
	end loop;
    END IF;
END IF;

select calculo_seg(usuario,fechad,fechah,modo) into remanseg;

RETURN ret;
END;$_$;


ALTER FUNCTION public.calculo_seg_y_alm(integer, date, date, integer) OWNER TO zona;

--
-- Name: cambio_estado(integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cambio_estado(integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; 	-- operacion
	estado		ALIAS FOR $2; 	-- estado
	modo		ALIAS FOR $3; 	-- 1 cambia estado
					-- Solo verifica sin cambiar estado 
	viejo_estado	int2;
	directo		int4;
	tipoper		int4;
	indirecto	int4;
	consign		int4;
	duedepo		int4;
	nrotalzon	int4;
	nrotaldir	int4;
	vencecsg	int4;
	deposito	int2;
	importe		numeric;
	impd		numeric;
	tc		numeric;
	aux_texto 	text;
	mal		int2;
	trans 		boolean;
	trans1 		boolean;
	notid		int4;
	fobopera	numeric;
	foboperai	numeric;
	ret		boolean;
	registro	RECORD;
    BEGIN

select op_estado,op_tipoper,op_directo,op_indirecto,op_nrotalzon,op_nrotaldir,op_deposito,op_importe,op_consig
into viejo_estado,tipoper,directo,indirecto,nrotalzon,nrotaldir,deposito,importe,consign
	    from operaciones where op_id=operacion;

select unif_usuario into duedepo from unifun where unif_codigo=deposito;

vencecsg:=2;
if(consign is null) then 
    consign:=-1; 
  else 
    select 1 into vencecsg from consig where csg_id = consign and csg_fecvto < date(now()) ; 
end if;

------------------- I N G R E S O S


if(int4lt(tipoper,100::int2))  THEN 


    select op_tipo_cambio into tc from operaciones where op_id=operacion;
    if numeric_gt(tc,0) then
	update subitem set sitem_imp_dolar=sitem_importe*tc where sitem_imp_dolar=0 and sitem_idoper=operacion;
    end if;

------------------- PUBLICACION 
--falta ver los contratos por unidad funcional que salen de subitem

    if(( int2eq(estado,101::int2)and int2eq(viejo_estado,1::int2) )
	or 
	(int2eq(estado,102::int2)and int2eq(viejo_estado,101::int2) )
	or 
	(int2eq(estado,1::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if(int4eq(tipoper,10::int2) or int4eq(tipoper,30::int2))  THEN 
		foboperai:=fob_hijos1(operacion,2::int2);
		update operaciones set op_importe=foboperai,op_impdolar=foboperai WHERE op_id = operacion;
	    END IF;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
	    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no existe contrato entre el directo '||directo||'  ('||nomusu(directo) ||')     y el indirecto '||indirecto||'  ('||nomusu(indirecto)||')';
	    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (numeric_ne(fobpadre_vs_fobhijos(operacion,1::int2),0)) THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el valor FOB de los SUBITEMS es distinto al FOB de la operacion, debera modificar este error antes de oficializar';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (seg_disponible(deposito, importe,1::int2)!=true) THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el deposito '||deposito||'  ('||traigo_nomunifun(deposito::int2)||') no tiene el seguro necesario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    trans1:=tipprod_ok(operacion,1::int2,2::int2);

	    if (int4ne(duedepo,directo)) THEN
		trans1:=hay_contrato(duedepo,directo,5::int2,operacion,5::int2);
	    END IF;
	    
	    if(tipoper=5 and consign=-1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no se ha definifo el consignatario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if(vencecsg=1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' la disposicion de Almacenaje se ha vencido';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;


	    for registro in select itemdeitem(sitem_iditem) as item, sitem_codigo,sitem_deposito  from subitem where sitem_idoper=operacion and estadunif(sitem_deposito) in (999,500) 
		loop
		    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el Item '||registro.item ||' Subitem '||registro.sitem_codigo||' Se encuentra en el deposito '||registro.sitem_deposito||' que esta INHABILITADO ';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		end loop; 

	END IF;
	
    else

------------------- E G R E S O S
------------------- PUBLICACION 
        if ((int2eq(estado,101::int2) and int2eq(viejo_estado,1::int2)) 
		or 
    	    (int2eq(estado,102::int2) and int2eq(viejo_estado,101::int2))
		or 
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no existe contrato entre el directo '||directo||'  ('||nomusu(directo) ||')     y el indirecto '||indirecto||'  ('||nomusu(indirecto)||')';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if ctacte_ok(directo)!=true THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el usuario directo '||directo||'  ('||nomusu(directo) ||')  esta inhabilitado por falta de pago   ';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;
	    
	    if(tipoper=105 and consign=-1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no se ha definifo el consignatario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if(vencecsg=1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' la disposicion de Almacenaje se ha vencido';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    fobopera:=fob_hijos2(operacion,2::int2);

	    for registro in select itemitemdesitem(ret_idsitem) as item, sitemcodigo(ret_idsitem) as sitem_codigo from retiros where ret_idopera=operacion and estadunif(depositem(ret_idsitem))=999 
		loop
		    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el Item '||registro.item ||' Subitem '||registro.sitem_codigo||' Se encuentra en un deposito INHABILITADO ';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		end loop; 

	END IF;
END IF;

select not_id into notid from noticias where not_tipo=1 and not_numero=operacion;

if found then 
    	    ret:='f';
	    if(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2)) THEN 
		    update operaciones set op_estado=11::int2 WHERE op_id = operacion;
	    end if;

	else

	    ret:='t';

	    if(int2eq(modo,1::int2)) then
	    update operaciones set op_estado=estado WHERE op_id = operacion;
	    update opervehi set opv_est_camion=50 where opv_idoper=operacion and opv_est_camion < 50;
	    end if;

end if;

if int2eq(estado,999::int2) then
    update operaciones set op_estado=estado WHERE op_id = operacion;
    update subitem set sitem_estado=estado where sitem_idoper = operacion;
    update opervehi set opv_est_camion=999 where opv_idoper=operacion and opv_est_camion= 50;
end if;

if(int2eq(estado,1::int2) and int4gt(tipoper,100::int4) and int2eq(modo,1::int2)) then
    fobopera:=fob_hijos2(operacion,1::int2);
    foboperai:=fob_hijos2(operacion,2::int2);
    select op_importe into impd from operaciones where op_id=operacion;
    if(impd is null or impd!=fobopera) then
	update operaciones set op_importe=fobopera where op_id=operacion;
	select op_tipo_cambio into tc from operaciones where op_id=operacion;
	if(tc is not null) then
	    update operaciones set op_impdolar=op_importe*tc where op_id=operacion;
	else
	    update operaciones set op_impdolar=foboperai where op_id=operacion;
	end if;
    end if;
end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.cambio_estado(integer, smallint, smallint) OWNER TO zona;

--
-- Name: cambioestadoatodos(smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cambioestadoatodos(smallint, smallint) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
modalidad	alias for $1;	-- 1 cambia de 11 a   1
				-- 2 cambia de  1 a 101
tipoper		alias for $2;	-- 1 Operaciones de Ingreso
				-- 2 Operaciones de Egreso

registro	RECORD;
operacion	int4;
bien		boolean;
ret 		int4;
begin
ret:=0;

if(int2eq(modalidad,1::int2) and int2eq(tipoper,1::int2))  THEN 
    for registro in select * from operaciones where op_estado=11 and op_tipoper<100
	loop
	    bien:=cambio_estado(registro.op_id,1::int2,1::int2);
	    ret:= ret+1;
	end loop; 
end if;

if(int2eq(modalidad,1::int2) and int2eq(tipoper,2::int2))  THEN 
    for registro in select * from operaciones where op_estado=11 and op_tipoper>100
	loop
	    bien:=cambio_estado(registro.op_id,1::int2,1::int2);
	    ret:= ret+1;
	end loop; 
end if;

return ret;
END;$_$;


ALTER FUNCTION public.cambioestadoatodos(smallint, smallint) OWNER TO zona;

--
-- Name: cantcomp_cantret(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcomp_cantret(integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
DECLARE
operacion	ALIAS FOR $1; 	-- id de la Operacion
modalidad	ALIAS FOR $2; 	-- Modalidad sumo o resto 
				--  1=actualizo normal
				--  2=Me arrepiento y corrijo lo ya hecho
registro 	RECORD;
retval 		boolean;
BEGIN

if modalidad=1 then    

	for registro in select ret_idsitem as x, ret_cantidad as y
    	    from retiros where ret_idopera=operacion
		loop
		    update subitem set sitem_cantcomp=sitem_cantcomp - registro.y,
				   sitem_cantret=sitem_cantret + registro.y
			where sitem_id=registro.x;
		end loop; 

    else

	for registro in select ret_idsitem as x, ret_cantidad as y
    	    from retiros where ret_idopera=operacion
		loop
		    update subitem set sitem_cantcomp=sitem_cantcomp + registro.y,
		    	    sitem_cantret=sitem_cantret - registro.y
				where sitem_id=registro.x;
		end loop; 

end if;    
RETURN retval;
END;$_$;


ALTER FUNCTION public.cantcomp_cantret(integer, smallint) OWNER TO zona;

--
-- Name: cantcompdeidsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcompdeidsitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_cantcomp from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.cantcompdeidsitem(integer) OWNER TO zona;

--
-- Name: cantcompwdeidwsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcompwdeidwsitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select wsitem_cantcompw from wsubitem where wsitem_id= $1 ;$_$;


ALTER FUNCTION public.cantcompwdeidwsitem(integer) OWNER TO zona;

--
-- Name: cantdispalm(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantdispalm(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select b.sitem_canting-b.sitem_cantret-b.sitem_cantmala from almacen a, subitem b where b.sitem_id=a.alm_idsitem and a.alm_id= $1 and a.alm_retiro is NULL;$_$;


ALTER FUNCTION public.cantdispalm(integer) OWNER TO zona;

--
-- Name: cantidad_disponible(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidad_disponible(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	sitem		ALIAS FOR $1; -- id del SubItem.
	retval 		numeric;
    BEGIN
	
    SELECT  
	sitem_canting-sitem_cantret-sitem_cantcomp-sitem_cantmala 
	    INTO retval
	    FROM subitem   WHERE int4eq(sitem_id,sitem);
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.cantidad_disponible(integer) OWNER TO zona;

--
-- Name: cantidispd(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidispd(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitemd_canting-sitemd_cantret-sitemd_cantcomp-sitemd_cantmala from subitemd where sitemd_id = $1;$_$;


ALTER FUNCTION public.cantidispd(integer) OWNER TO zona;

--
-- Name: cantidisponib(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidisponib(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_canting-sitem_cantret-sitem_cantcomp-sitem_cantmala from subitem where sitem_id = $1;$_$;


ALTER FUNCTION public.cantidisponib(integer) OWNER TO zona;

--
-- Name: cantidispw(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidispw(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select wsitem_canting-wsitem_cantret-wsitem_cantcomp-wsitem_cantmala-wsitem_cantcompw from wsubitem where wsitem_id = $1;$_$;


ALTER FUNCTION public.cantidispw(integer) OWNER TO zona;

--
-- Name: cantingdeidsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantingdeidsitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_canting from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.cantingdeidsitem(integer) OWNER TO zona;

--
-- Name: cantitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantitem(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
ret 		 int4;
begin
select count(*) into ret from item where item_idoper= opid;
return ret;
end;$_$;


ALTER FUNCTION public.cantitem(integer) OWNER TO zona;

--
-- Name: cantmaladeidsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantmaladeidsitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_cantmala from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.cantmaladeidsitem(integer) OWNER TO zona;

--
-- Name: cantmetroscontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantmetroscontr(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
contrato	 alias for $1;
ret 		 numeric;
begin
    select contr_metros into ret from contratos where contr_id=contrato;
    return ret;
end;$_$;


ALTER FUNCTION public.cantmetroscontr(integer) OWNER TO zona;

--
-- Name: cantretdeidsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantretdeidsitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_cantret from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.cantretdeidsitem(integer) OWNER TO zona;

--
-- Name: cantreweb(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantreweb(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(wret2_cantidad) from wret2 where wret2_estado<50 and wret2_idsitem= $1 ;$_$;


ALTER FUNCTION public.cantreweb(integer) OWNER TO zona;

--
-- Name: capiposadeitem(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION capiposadeitem(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
nroitem		 alias for $1;
nroartic	 alias for $2;
ret 		 varchar;
hay	 	 int4;
auxot		 varchar;
begin

    select trim(item_posa) into ret from item where item_id=nroitem ;

    if (bpchareq(ret,'DESCONOCIDA') or bpchareq(trim(ret),'')) then

	select trim(artic_posa) into ret from articu where artic_id=nroartic;

	if ret is null then 
	    ret:='DESCONOCIDA';
	end if;
    end if;

    ret:=substr(ret,1,4);

return ret;
end;$_$;


ALTER FUNCTION public.capiposadeitem(integer, integer) OWNER TO zona;

--
-- Name: carga_almacenaje(date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION carga_almacenaje(date, date, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
desde		 alias for $1;
hasta		 alias for $2;
usuario		 alias for $3;
ret 		 boolean;
registro	 record;
regi		 record;
regi2		 record;
regi3		 record;
contrato	 int4;
tarifa	 	 numeric;
elusu		 int4;
cantdias	 int4;
begin

ret:='f';
contrato:=-1;
tarifa:=-1;

select (hasta-desde)::int4 into cantdias;

for registro in select 
    * from unifun where unif_usuario=1
    loop
    if(int4eq(usuario,0::int4)) then
	    for regi in select 
		* from subitem,operaciones  where sitem_deposito=registro.unif_codigo and op_id=sitem_idoper and date_ge(op_fechain,desde) and date_le(op_fechain,hasta) and op_estado=101
		loop
		ret:='t';
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 
		    if numeric_eq(tarifa,0::numeric) then
			select valtarico(tari_usuario,tari_idart,0::numeric,0::int2,hasta::date,tari_idcontr,tari_orden) into tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		    end if;
		end if;

		if contrato is null then 
		    contrato:=-1;
		end if;

		if tarifa is null then 
		    tarifa:=-1;
		end if;

		delete from almacenaje where al_idsitem=regi.sitem_id;
		insert into almacenaje (al_fech,al_idoper,al_idusu,al_idsitem,al_idcontr,al_canti,al_impdolar,al_fecing,al_ultfac,al_tiprod,al_tarifa,al_leyenda) values (hasta,regi.op_id,regi.sitem_directo,regi.sitem_id,contrato,regi.sitem_canting,regi.sitem_imp_dolar,regi.op_fechain,regi.op_fechain,tiprodsitem(regi.sitem_id),tarifa,traigo_codarticu(regi.sitem_id));
	    end loop; 
	else
	    for regi in select 
		* from subitem,operaciones where sitem_deposito=registro.unif_codigo and sitem_directo=usuario and op_id=sitem_idoper and date_ge(op_fechain,desde) and date_le(op_fechain,hasta) and op_estado=101
		loop
		ret:='t';
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 
		    if numeric_eq(tarifa,0::numeric) then
			select valtarico(tari_usuario,tari_idart,0::numeric,0::int2,hasta::date,tari_idcontr,tari_orden) into tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		    end if;
		end if;
		if contrato is null then 
		    contrato:=-1;
		end if;

		if tarifa is null then 
		    tarifa:=-1;
		end if;

		delete from almacenaje where al_idsitem=regi.sitem_id;
		insert into almacenaje (al_fech,al_idoper,al_idusu,al_idsitem,al_idcontr,al_canti,al_impdolar,al_fecing,al_ultfac,al_tiprod,al_tarifa,al_leyenda) values (hasta,regi.op_id,regi.sitem_directo,regi.sitem_id,contrato,regi.sitem_canting,regi.sitem_imp_dolar,regi.op_fechain,regi.op_fechain,tiprodsitem(regi.sitem_id),tarifa,traigo_codarticu(regi.sitem_id));
	    end loop; 
    end if;
end loop; 

update almacenaje set al_retiro=fechainretsitem(al_idsitem) where al_estado=1;
update almacenaje set al_importe=al_impdolar*cotpeso(date(now())) where al_estado=1 and al_impdolar is not null;
update almacenaje set al_dias=(al_retiro-al_ultfac)::int4 where al_estado=1 and al_retiro is not null;
update almacenaje set al_dias=(al_fech-al_ultfac)::int4 where al_estado=1 and al_retiro is null;

for regi3 in select al_idusu, sum(al_importe) as totfob from almacenaje where al_estado=1 and al_tiprod not in (4,5,6,7,8,9,32) group by 1
    loop
    if numeric_gt(regi3.totfob,500000::numeric) then
    tarifa:=0.0057;
      else
	if numeric_gt(regi3.totfob,200000::numeric) then
	    tarifa:=0.0076;
	  else
	    tarifa:=0.0096;
	end if;
    end if;
update almacenaje set al_tarifa=tarifa, al_total=(tarifa * al_importe / cantdias * al_dias) where al_estado=1 and al_importe is not null and al_idusu=regi3.al_idusu and al_tiprod not in (4,5,6,7,8,9,32);
end loop; 

update almacenaje set al_total=(al_tarifa * al_dias) where al_estado=1 and al_tiprod in (4,5,6,7,8,9,32);
update almacenaje set al_tarifa=-1 where al_estado=1 and al_tarifa in (null,0);
update almacenaje set al_total=-100 where al_estado=1 and al_total in (null,0);
update almacenaje set al_dias=-1 where al_estado=1 and al_dias in (null,0);

return ret;
end;$_$;


ALTER FUNCTION public.carga_almacenaje(date, date, integer) OWNER TO zona;

--
-- Name: cargoalmacen(date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cargoalmacen(date, date, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
desde		 alias for $1;
hasta		 alias for $2;
usuario		 alias for $3;
ret 		 boolean;
registro	 record;
regi		 record;
regi2		 record;
contrato	 int4;
tarifa	 	 numeric;
begin

ret:='f';
contrato:=1;
tarifa:=-1;

for registro in select 
    * from unifun where unif_usuario=1
    loop
    if(int4eq(usuario,0::int4)) then
	    for regi in select 
		* from subitem where sitem_deposito=registro.unif_codigo and tiprodsitem(sitem_id) between 4 and 9 and date_ge(fechainop(sitem_idoper),desde) and date_le(fechainop(sitem_idoper),hasta)  and estadop(sitem_idoper)>100
		loop
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 

		    if numeric_eq(tarifa,0::numeric) then
			select valtarico(tari_usuario,tari_idart,0::numeric,0::int2,hasta::date,tari_idcontr,tari_orden) into tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		    end if;

		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),contrato,tarifa,stepcontr(contrato));

		  else
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),3520,1000000::numeric,stepcontr(contrato));
		end if;

	    end loop; 
	else
	    for regi in select 
		* from subitem where sitem_deposito=registro.unif_codigo and tiprodsitem(sitem_id) between 4 and 9 and date_ge(fechainop(sitem_idoper),desde) and date_le(fechainop(sitem_idoper),hasta) and sitem_directo=usuario and estadop(sitem_idoper)>100
		loop
		ret:='t';
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 

		    if numeric_eq(tarifa,0::numeric) then
			select valtarico(tari_usuario,tari_idart,0::numeric,0::int2,hasta::date,tari_idcontr,tari_orden) into tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		    end if;

		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),contrato,tarifa,stepcontr(contrato));
		  else
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),3520,1000000::numeric,stepcontr(contrato));
		end if;
	    end loop; 
    end if;
end loop; 

update almacen set alm_retiro=fechainretsitem(alm_idsitem) where alm_estado in (1,100,3);

update almacen set alm_estado=1 where alm_estado in (100,3) and date_ge(alm_retiro,desde) and date_le(alm_retiro,hasta);

return ret;
end;$_$;


ALTER FUNCTION public.cargoalmacen(date, date, integer) OWNER TO zona;

--
-- Name: cargodep(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cargodep() RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
registro 	RECORD;
registror 	RECORD;
stm		integer;
retval		numeric;
maxfecha	date;
fecharet	date;
BEGIN

retval:=0;

for registro in select op_id as x,op_tipoper as y from operaciones where op_estado=101 and op_deposito is null loop
    if int4gt(registro.y,100) then
	select distinct sitem_deposito into stm from subitem where sitem_id in (select ret_idsitem from retiros where ret_idopera=registro.x) and sitem_estado in (1,2) and sitem_deposito is not null order by 1 limit 1;
    else
	select distinct sitem_deposito into stm from subitem where sitem_idoper=registro.x and sitem_estado in (1,2) and sitem_deposito is not null order by 1 limit 1;
    end if;
    if stm is not null then
	update operaciones set op_deposito=stm where op_id=registro.x;
    end if;
end loop; 

retval:=1::numeric(15,2);

RETURN retval;
END;$$;


ALTER FUNCTION public.cargodep() OWNER TO zona;

--
-- Name: cbleok(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cbleok(integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	codigo		ALIAS FOR $2;
	empre		ALIAS FOR $3;
	esisti		integer;
	retval 		boolean;
    BEGIN
    retval:='f';
    if int4eq(codemp,empre) then
	    retval:='t';
	else
	    if int4eq(codemp,0) then
		retval:='t';
		select count(*) into esisti from ctacble 
		    where cbl_codemp in (codemp,empre) and cbl_codigo=codigo;
    		if int4gt(esisti,1) then
		    retval:='f';
		end if;
	    end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.cbleok(integer, integer, integer) OWNER TO zona;

--
-- Name: cf1tocf(smallint, smallint, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cf1tocf(smallint, smallint, date, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
anio 		 alias for $1;
mes 		 alias for $2;
fechah 		 alias for $3;
usuario		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:='t';

if(int4eq(usuario,0::int4)) then
    update confactur1 set cfc1_anio=anio, cfc1_mes=mes, cfc1_estado=4 where cfc1_estado=1 and date_le(cfc1_fecha,fechah);

    insert into confactur (cfc_usuario,cfc_fecha,cfc_anio,cfc_mes,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_dias,cfc_leyen,cfc_idoper,cfc_estado,cfc_idemiti,cfc_indirecto,cfc_ticket,cfc_ptov) 
	select cfc1_usuario,cfc1_fecha,anio,mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,1,cfc1_idemiti,cfc1_indirecto,cfc1_ticket,cfc1_ptov from confactur1 where cfc1_estado=4;
    update confactur1 set cfc1_estado=50 where cfc1_estado=4;

  else

    update confactur1 set cfc1_anio=anio, cfc1_mes=mes, cfc1_estado=4 where cfc1_estado=1 and date_le(cfc1_fecha,fechah) and cfc1_usuario= usuario;
    insert into confactur (cfc_usuario,cfc_fecha,cfc_anio,cfc_mes,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_dias,cfc_leyen,cfc_idoper,cfc_estado,cfc_idemiti,cfc_indirecto,cfc_ticket,cfc_ptov) 
	select cfc1_usuario,cfc1_fecha,anio,mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,1,cfc1_idemiti,cfc1_indirecto,cfc1_ticket,cfc1_ptov from confactur1 where cfc1_estado=4;
    update confactur1 set cfc1_estado=50 where cfc1_estado=4 and cfc1_usuario=usuario;
end if;

return ret;
end;$_$;


ALTER FUNCTION public.cf1tocf(smallint, smallint, date, integer) OWNER TO zona;

--
-- Name: cf1tocfb(smallint, smallint, date, integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cf1tocfb(smallint, smallint, date, integer, numeric, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
anio 		 alias for $1;
mes 		 alias for $2;
fechah 		 alias for $3;
usuario		 alias for $4;
cotiz		 alias for $5;
ptovta		 alias for $6;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:='f';

if(int4eq(usuario,0::int4)) then
    update confactur1 set cfc1_anio=anio, cfc1_mes=mes, cfc1_estado=4 where cfc1_estado=1 and date_le(cfc1_fecha,fechah) and cfc1_ptov=ptovta;
    update confactur1 set cfc1_dias=1 where cfc1_dias is null and cfc1_estado=4;

    insert into confactur (cfc_usuario,cfc_fecha,cfc_anio,cfc_mes,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_dias,cfc_leyen,cfc_idoper,cfc_estado,cfc_idemiti,cfc_indirecto,cfc_ticket,cfc_ptov) 
	select cfc1_usuario,cfc1_fecha,anio,mes,cfc1_idart,cfc1_canti,cfc1_precio*cotiz,cfc1_importe*cotiz,cfc1_dias,cfc1_leyen,cfc1_idoper,1,cfc1_idemiti,cfc1_indirecto,cfc1_ticket,cfc1_ptov from confactur1 where cfc1_estado=4;

    update confactur1 set cfc1_estado=50 where cfc1_estado=4;
    ret:='t';

  else

    update confactur1 set cfc1_anio=anio, cfc1_mes=mes, cfc1_estado=4 where cfc1_estado=1 and date_le(cfc1_fecha,fechah) and cfc1_usuario= usuario and cfc1_ptov=ptovta;
    update confactur1 set cfc1_dias=1 where cfc1_dias is null and cfc1_estado=4;
    insert into confactur (cfc_usuario,cfc_fecha,cfc_anio,cfc_mes,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_dias,cfc_leyen,cfc_idoper,cfc_estado,cfc_idemiti,cfc_indirecto,cfc_ticket,cfc_ptov) 
	select cfc1_usuario,cfc1_fecha,anio,mes,cfc1_idart,cfc1_canti,cfc1_precio*cotiz,cfc1_importe*cotiz,cfc1_dias,cfc1_leyen,cfc1_idoper,1,cfc1_idemiti,cfc1_indirecto,cfc1_ticket,cfc1_ptov from confactur1 where cfc1_estado=4;
    update confactur1 set cfc1_estado=50 where cfc1_estado=4 and cfc1_usuario=usuario;
    ret:='t';
end if;

return ret;
end;$_$;


ALTER FUNCTION public.cf1tocfb(smallint, smallint, date, integer, numeric, integer) OWNER TO zona;

--
-- Name: check_autorizacion(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION check_autorizacion(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; -- id  Operacion
	operador	ALIAS FOR $2; -- id  Operador
	autorizadopor 	int4;
	retval 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='f';
    select mod_autoriz1 into autorizadopor from modopub where mod_idoper=operacion;
    if autorizadopor is null then
    	    update modopub set mod_autoriz1=operador,mod_fecaut1=now() where mod_idoper=operacion;
	else
	    if int4eq(autorizadopor,operador) then
		    aux_texto:='Ya fue autorizado por usted anteriormente hace falta la autorizacion de otra persona para numericizar el cambio definitivo!!';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		else
		    update modopub set mod_autoriz2=operador,mod_fecaut2=now() where 
		    mod_idoper=operacion;	
		    retval:='t';
	    end if;
    end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.check_autorizacion(integer, integer) OWNER TO zona;

--
-- Name: chkcompvsret(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION chkcompvsret(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
cantidad	 numeric(15,5);

begin
for registro in select 
    * from subitem where sitem_estado=1 and sitem_cantcomp!=0
    loop
	select sum(ret_cantidad) into cantidad from retiros where ret_idsitem=registro.sitem_id and estado_opera(ret_idopera)<100 group by ret_idsitem;
	if not found then 
		insert into auxoperv (avh_idoper) values (registro.sitem_id);
	    else
		if (numeric_ne(cantidad,registro.sitem_cantcomp)) then
		    insert into auxoperv (avh_idoper) values (registro.sitem_id * -1);
		end if;
	end if;
end loop; 

ret:='t';
return ret;
end;$_$;


ALTER FUNCTION public.chkcompvsret(integer) OWNER TO zona;

--
-- Name: chkmigra(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION chkmigra(character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
auxoid 		 int4;
primera		 int4;
begin
primera:=-1;
for registro in select 
    oid as oid 
     from usuarios
	loop
	if(primera<0) then 
		primera:=registro.oid;
	    else
		primera:= primera+1;
	end if;

	if(registro.oid!=primera) then 
		ret:='t';
		primera:=registro.oid;
	    else
		ret:='f';
	end if;
end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.chkmigra(character varying) OWNER TO zona;

--
-- Name: cidart(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidart(integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare

indirecto	 alias for $1;
codigo		 alias for $2;
ret		int4;
begin

select artic_id into ret from articu where artic_indirecto=indirecto and
bpchareq(trim(artic_codigo),trim(codigo)) order by artic_id limit 1;

return ret;
end;$_$;


ALTER FUNCTION public.cidart(integer, character varying) OWNER TO zona;

--
-- Name: cidop(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidop(integer, integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
directo		 alias for $1;
indirecto	 alias for $2;
tipoper		 alias for $3;
numero		 alias for $4;
ret		int4;
begin

select op_id into ret from operaciones where op_directo=directo and
op_indirecto=indirecto and op_tipoper=tipoper and op_nrotaldir=numero;

if ret is null then
select op_id into ret from operaciones where op_directo=directo and
op_indirecto=indirecto and op_tipoper=5 and op_nrotaldir=numero;
end if;

return ret;
end;$_$;


ALTER FUNCTION public.cidop(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: cidsitem(integer, smallint, character varying, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidsitem(integer, smallint, character varying, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
operacion	 alias for $1;
lote		 alias for $2;
compbte		 alias for $3;
articid		 alias for $4;
ret		int4;
begin

    select sitem_id into ret from subitem where 
	sitem_idoper=operacion and
	sitem_artic=articid and
	sitem_codigo=lote and
	bpchareq(sitem_compbte,compbte);
return ret;
end;$_$;


ALTER FUNCTION public.cidsitem(integer, smallint, character varying, integer) OWNER TO zona;

--
-- Name: cierre_ejercicio(character varying, date, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cierre_ejercicio(character varying, date, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
tipo		 alias for $3; -- 1 Resultado, 2 Patrimoniales
codemp		 alias for $4;
idptov		 alias for $5;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
begin
ret:='f';

    select idcomp(comprobante,idptov) into elcomprob;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' EJERCICIO CERRADO AL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,substr(fecha::text,7,4)::int2,substr(fecha::text,4,2)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Cierre de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select idcbl(codemp,valvaramb(codemp,0,'CTARDOE')::integer)  into cuentardo;   

    if(int4eq(tipo,1::int4)) then
	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and date_le(astc_fecval,fecha) and codcble(astc_ctacble)>=3000 and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'30-06-2008' group by 1  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	select sum(astc_importe * -1) into resultad from astoctas where astc_idastoh=idastoh;

	
	if(resultad != 0) then
	    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	     values (idastoh,cuentardo,resultad,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
	end if;
	ret:='t';


      else

	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and date_le(astc_fecval,fecha) and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'30-06-2008'  group by 1  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	ret:='t';

    end if;
    return ret;
end;$_$;


ALTER FUNCTION public.cierre_ejercicio(character varying, date, integer, integer, integer) OWNER TO zona;

--
-- Name: cierroop(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cierroop() RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare
ret 		 boolean;
registro	 record;
regi1		 record;
primera		 int4;
cerrada		 date;
hayalgo		 numeric;
begin
primera:=-1;
ret:='t';
for registro in select 
    auxo_idoper from auxoper where auxo_idoper<100
	loop
	select op_fecha_close into cerrada from operaciones where op_id=registro.auxo_idoper;
	if(cerrada is null) then 
	    select sum(sitem_canting)-sum(sitem_cantret) into hayalgo from subitem where sitem_idoper=registro.auxo_idoper;
	    if(numeric_eq(hayalgo,0)) then
		update operaciones set op_fecha_close=date(now()) where op_id=registro.auxo_idoper;
	    end if;
	end if;
end loop; 

return ret;
end;$$;


ALTER FUNCTION public.cierroop() OWNER TO zona;

--
-- Name: cif_a_fecha_directo(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cif_a_fecha_directo(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
directo	ALIAS FOR $1; 	-- id del directo
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
valfob		numeric;
valcif		numeric;
porcif		numeric;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where op_directo=directo and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	select op_impdolar into valfob from operaciones where op_id=registro.x;
	select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into valcif from operaciones,auxoper where op_id=auxo_idoper and op_id=registro.x;
	porcif:= valcif / valfob;
	for registror in select * from subitem where sitem_idoper=registro.x
	    loop

		retval:=retval + (registror.sitem_imp_dolar * porcif);

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar / registror.sitem_canting * porcif;
		    end if;


		    select sum(ret_cantidad) into cantret from retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;
		    if not found then 
			retirado:=0;
		      else
			retirado:=cantret * precio *porcif;
		    end if;

		    if(retirado is not null and retirado!=0) then 
			retval:=retval - retirado;
		    end if;
		end if;
	    end loop;
	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.cif_a_fecha_directo(integer, date) OWNER TO zona;

--
-- Name: cif_a_fecha_indirecto(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cif_a_fecha_indirecto(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
indirecto	ALIAS FOR $1; 	-- id del indirecto
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
comp		character varying(16);
valfob		numeric;
valcif		numeric;
porcif		numeric;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
nacional	integer;
nacional2	integer;
BEGIN

retval:=0;
nacional=6;
nacional2=5;

for registro in select op_id as x
    from operaciones where op_indirecto=indirecto and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) and op_deposito not in (nacional,nacional2) and (op_fecha_close is null or date_gt(op_fecha_close,fecha)) 
	loop
	select op_impdolar into valfob from operaciones where op_id=registro.x;
	select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into valcif from operaciones,auxoper where op_id=auxo_idoper and op_id=registro.x;
	porcif:= valcif / valfob;

	RAISE NOTICE 'op id %, impdolar %, cif %, porcif %',registro.x,valfob,valcif,porcif;

	for registror in select sitem_id,sitem_imp_dolar,sitem_cantret,sitem_canting from subitem where sitem_idoper=registro.x 
	    loop

		retval:=retval + (registror.sitem_imp_dolar * porcif);
		RAISE NOTICE 'RETVAL %',retval;

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar / registror.sitem_canting * porcif;
		    end if;


		    select sum(ret_cantidad) into cantret from retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;
		    if not found then 
			retirado:=0;
		      else
			retirado:=cantret * precio;
		    end if;

		    if(retirado is not null and retirado!=0) then 
			retval:=retval - retirado;
		    end if;
		end if;
	end loop;
end loop; 



retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.cif_a_fecha_indirecto(integer, date) OWNER TO zona;

--
-- Name: cif_id(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cif_id(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
opera		ALIAS FOR $1; 	-- id del indirecto
registro 	RECORD;
registror 	RECORD;
valfob		numeric;
valcif		numeric;
porcif		numeric;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where op_id=opera and op_estado=101 
	loop
	select op_impdolar into valfob from operaciones where op_id=registro.x;
	select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into valcif from operaciones,auxoper where op_id=auxo_idoper and op_id=registro.x;
	porcif:= valcif / valfob;

	for registror in select * from subitem where sitem_idoper=registro.x
	    loop

		retval:=retval + (registror.sitem_imp_dolar * porcif);

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar / registror.sitem_canting * porcif;
		    end if;


		    select sum(ret_cantidad) into cantret from retiros where registror.sitem_id=ret_idsitem and ret_idopera=registro.x and estadop(ret_idopera)=101;
		    if not found then 
			retirado:=0;
		      else
			retirado:=cantret * precio;
		    end if;

		    if(retirado is not null and retirado!=0) then 
			retval:=retval - retirado;
		    end if;
		end if;
	    end loop;
	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.cif_id(integer) OWNER TO zona;

--
-- Name: cliedeastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cliedeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_ctacte from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'DEUDXV')::integer) limit 1;$_$;


ALTER FUNCTION public.cliedeastc(integer) OWNER TO zona;

--
-- Name: climodfac(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION climodfac(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_modfac from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.climodfac(integer) OWNER TO zona;

--
-- Name: closeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION closeop(integer) RETURNS date
    LANGUAGE sql
    AS $_$select op_fechain from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.closeop(integer) OWNER TO zona;

--
-- Name: cnunif(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cnunif(character varying) RETURNS smallint
    LANGUAGE sql
    AS $_$select unif_codigo from unifun where bpchareq(unif_newcod, trim($1));$_$;


ALTER FUNCTION public.cnunif(character varying) OWNER TO zona;

--
-- Name: codartdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codartdesitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select codigodeartic(sitem_artic) from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.codartdesitem(integer) OWNER TO zona;

--
-- Name: codartdewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codartdewret2(integer) RETURNS character
    LANGUAGE sql
    AS $_$select codigodeartic(a.sitem_artic) from subitem a, wret2 b where a.sitem_id=b.wret2_idsitem and b.wret2_id= $1 ;$_$;


ALTER FUNCTION public.codartdewret2(integer) OWNER TO zona;

--
-- Name: codartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codartic(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select art_codigo from articvta where art_id = $1;$_$;


ALTER FUNCTION public.codartic(integer) OWNER TO zona;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codcble(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_codigo from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO zona;

--
-- Name: codcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_codigo from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.codcli(integer) OWNER TO zona;

--
-- Name: codclideastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codclideastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_codcli from emiti where emi_idastoh= $1 ;$_$;


ALTER FUNCTION public.codclideastoh(integer) OWNER TO zona;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO zona;

--
-- Name: codcompash(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codcompash(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoh where comp_id=ash_comprob and ash_id= $1 ;$_$;


ALTER FUNCTION public.codcompash(integer) OWNER TO zona;

--
-- Name: codcompastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codcompastc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.codcompastc(integer) OWNER TO zona;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO zona;

--
-- Name: codempcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codempcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_codemp from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.codempcli(integer) OWNER TO zona;

--
-- Name: codigodeartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codigodeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_codigo from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.codigodeartic(integer) OWNER TO zona;

--
-- Name: codigodearticd(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codigodearticd(integer) RETURNS character
    LANGUAGE sql
    AS $_$select articd_codigo from articud where articd_id= $1 ;$_$;


ALTER FUNCTION public.codigodearticd(integer) OWNER TO zona;

--
-- Name: codigopordepo(text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codigopordepo(text) RETURNS smallint
    LANGUAGE sql
    AS $_$select unif_codigo from unifun where unif_codmaria=trim($1)::int2;$_$;


ALTER FUNCTION public.codigopordepo(text) OWNER TO zona;

--
-- Name: codprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_codigo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.codprov(integer) OWNER TO zona;

--
-- Name: codprovdeastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codprovdeastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cpra_prove from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.codprovdeastoh(integer) OWNER TO zona;

--
-- Name: codptv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codptv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_codigo from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.codptv(integer) OWNER TO zona;

--
-- Name: compadunombre(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compadunombre(character varying) RETURNS character
    LANGUAGE sql
    AS $_$select cad_nombre from compadu where bpchareq(cad_codigo::varchar, $1::varchar );$_$;


ALTER FUNCTION public.compadunombre(character varying) OWNER TO zona;

--
-- Name: compbte_fe(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbte_fe(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	comp		ALIAS FOR $1; -- Comprobante 
    BEGIN
	if trim(comp)='FA' then
	    RETURN 1;
	  else
	    if trim(comp)='DA' then
		RETURN 2;
	      else
		if trim(comp)='CA' then
		    RETURN 3;
		  else
		    if trim(comp)='FB' then
			RETURN 6;
		      else
			if trim(comp)='DB' then
			    RETURN 7;
			  else
			    if trim(comp)='CB' then
				RETURN 8;
			    else
				if trim(comp)='FCE' then
				    RETURN 201;
				else
				    if trim(comp)='CCE' then
					RETURN 203;
				    else
					if trim(comp)='DCE' then
					    RETURN 202;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
    END;$_$;


ALTER FUNCTION public.compbte_fe(character varying) OWNER TO zona;

--
-- Name: compbte_fec(character varying, character varying, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbte_fec(character varying, character varying, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	comp		ALIAS FOR $1; -- Comprobante 
	letra		ALIAS FOR $2; -- letra 
	iva		ALIAS FOR $3; -- importe iva 
    BEGIN
	if trim(comp)!='NK' and trim(comp)!='DK' then
	    if trim(letra)='A' then
		RETURN 1;
	    else
		if trim(letra)='B' then
		    RETURN 6;
		else
		    if trim(letra)='C' then
			RETURN 11;
		    else
			if trim(letra)='E' then
			    RETURN 19;
			else
			    if trim(letra)='G' then
				RETURN 39;
			    else
				if trim(letra)='M' then
				    RETURN 51;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 81;
					else
					    RETURN 83;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	else
	    if trim(comp)='NK' then
		if trim(letra)='A' then
		    RETURN 3;
		else
		    if trim(letra)='B' then
			RETURN 8;
		    else
			if trim(letra)='C' then
			    RETURN 13;
			else
			    if trim(letra)='E' then
				RETURN 21;
			    else
				if trim(letra)='M' then
				    RETURN 53;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 112;
					else
					    RETURN 111;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    else
		if trim(letra)='A' then
		    RETURN 2;
		else
		    if trim(letra)='B' then
			RETURN 7;
		    else
			if trim(letra)='C' then
			    RETURN 12;
			else
			    if trim(letra)='E' then
				RETURN 20;
			    else
				if trim(letra)='M' then
				    RETURN 52;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 115;
					else
					    RETURN 116;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
    END;$_$;


ALTER FUNCTION public.compbte_fec(character varying, character varying, numeric) OWNER TO zona;

--
-- Name: compbteoper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbteoper(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_compbte from operaciones  where op_id= $1;$_$;


ALTER FUNCTION public.compbteoper(integer) OWNER TO zona;

--
-- Name: compbteret_idalm(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbteret_idalm(integer) RETURNS character
    LANGUAGE sql
    AS $_$select compbteoper(b.ret_idopera) from almacen a, retiros b where b.ret_idsitem=a.alm_idsitem and a.alm_id= $1 and a.alm_retiro is not NULL order by ret_id desc limit 1;$_$;


ALTER FUNCTION public.compbteret_idalm(integer) OWNER TO zona;

--
-- Name: compbteret_idsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbteret_idsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_compbte from operaciones a, retiros b where b.ret_idsitem= $1 and b.ret_idopera=a.op_id order by ret_id desc limit 1;$_$;


ALTER FUNCTION public.compbteret_idsitem(integer) OWNER TO zona;

--
-- Name: compbtesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbtesitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select sitem_compbte from subitem where sitem_id = $1;$_$;


ALTER FUNCTION public.compbtesitem(integer) OWNER TO zona;

--
-- Name: compdeastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_comprob from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.compdeastc(integer) OWNER TO zona;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO zona;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO zona;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO zona;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO zona;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO zona;

--
-- Name: confactur1confactur(smallint, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION confactur1confactur(smallint, smallint, date) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
anio 		 alias for $1;
mes 		 alias for $2;
fechah 		 alias for $3;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:='t';
update confactur1 set cfc1_anio=anio, cfc1_mes=mes, cfc1_estado=4 where cfc1_estado=1 and cfc1_fecha <= fechah;

insert into confactur (cfc_usuario,cfc_fecha,cfc_anio,cfc_mes,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_dias,cfc_leyen,cfc_idoper,cfc_estado,cfc_idemiti,cfc_indirecto,cfc_ticket,cfc_ptov) 
select cfc1_usuario,cfc1_fecha,anio,mes,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_dias,cfc1_leyen,cfc1_idoper,1,cfc1_idemiti,cfc1_indirecto,cfc1_ticket,cfc1_ptov
 from confactur1 where cfc1_estado=4;
update confactur1 set cfc1_estado=50 where cfc1_estado=4;
return ret;
end;$_$;


ALTER FUNCTION public.confactur1confactur(smallint, smallint, date) OWNER TO zona;

--
-- Name: conivacli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conivacli(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_coniva from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conivacli(integer) OWNER TO zona;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO zona;

--
-- Name: conocimsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conocimsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_conocim from operaciones a,subitem b where a.op_id=b.sitem_idoper and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.conocimsitem(integer) OWNER TO zona;

--
-- Name: conpagcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conpagcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_conpag from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conpagcli(integer) OWNER TO zona;

--
-- Name: consigdeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION consigdeop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_consig from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.consigdeop(integer) OWNER TO zona;

--
-- Name: contindlocador(integer, integer, smallint, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contindlocador(integer, integer, smallint, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
unifusu		 alias for $1;
indlocad	 alias for $2;
unifun		 alias for $3;
tipo_contrato 	 alias for $4;
modo 		 alias for $5; 	-- 1 solo busca indirecto locador
				-- 2 busca Indirecto locador o reciprocidad
unicont		 int2;
tipusu		 int2;
pame		 int2;
ret 		 boolean;
registro	 RECORD;
hayuno	 	 int2;
hayunoaprob	 int2;

begin

pame:=2;
ret:='f';
hayuno:=0;
hayunoaprob:=0;


select usu_tipusu into tipusu from usuarios where usu_codigo=indlocad;
if(int2eq(tipusu,3::int2)) then
    pame:=1;
end if; 


if(unifusu!=indlocad) then

    if(int2eq(pame,1::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu and contr_locatario=indlocad and tipo_de_contrato(contr_idsubt)=tipo_contrato and int2eq(contr_estado,1::int2)
	    loop
		if int2eq(unifun,registro.contr_unifun::int2) then  
		hayunoaprob:=1;
		ret:='t'; 
		end if;
	    end loop;
    end if;


    if(int2eq(modo,2::int2) and int2eq(pame,2::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu 
		and contr_locatario=indlocad 
		and tipo_de_contrato(contr_idsubt) in (2::int2,4::int2,5::int2) 
		and int2eq(contr_estado,1::int2) 
		and contr_unifun=unifun
	    loop
		ret:='t';
	    end loop;

    end if;

end if;

if(int4eq(unifusu,indlocad)) then
    ret:='t';
end if;

return ret;
END;$_$;


ALTER FUNCTION public.contindlocador(integer, integer, smallint, smallint, smallint) OWNER TO zona;

--
-- Name: contrid_almacen(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contrid_almacen(integer, smallint) RETURNS integer
    LANGUAGE sql
    AS $_$select contr_id from contratos where contr_estado= $2 and contr_locador=1  and contr_idsubt in (7,8) and contr_locatario = $1 order by contr_id desc limit 1;$_$;


ALTER FUNCTION public.contrid_almacen(integer, smallint) OWNER TO zona;

--
-- Name: copio_artic_descrip(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION copio_artic_descrip(integer, integer, character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
operacion	 alias for $1;
item_a_modificar alias for $2;
ladesc	 	 alias for $3;
ret 		 boolean;
registro	 record;
begin

ret:='f';

for registro in select 
    * from subitem where sitem_idoper=operacion and sitem_iditem=item_a_modificar
    loop
	update articu set artic_descrip=ladesc where trim(artic_descrip) like '' and artic_id=registro.sitem_artic;
    ret:='t';
    end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.copio_artic_descrip(integer, integer, character varying) OWNER TO zona;

--
-- Name: cotpeso(date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cotpeso(date) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz from cotiza WHERE int2eq(cot_moneda,1::int2) and  date_le(cot_fecha, $1 ::date) order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.cotpeso(date) OWNER TO zona;

--
-- Name: ctacte_ok(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ctacte_ok(integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select (case when usu_estado=1 then 't'::boolean else 'f'::boolean end) from usuarios where usu_codigo= $1 ;$_$;


ALTER FUNCTION public.ctacte_ok(integer) OWNER TO zona;

--
-- Name: cual_consignatario(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_consignatario(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit 
	consi		int4;
    BEGIN
	select csg_id into consi from consig where bpchareq(csg_nrocuit,cuit);
		if not found then
		    insert into consig (csg_nrocuit,csg_nombre) values (cuit,'DATO DESCONOCIDO');
		    select csg_id into consi from consig where bpchareq(csg_nrocuit,cuit);
		end if;

	RETURN consi;
    END;$_$;


ALTER FUNCTION public.cual_consignatario(character varying) OWNER TO zona;

--
-- Name: cual_despachante(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_despachante(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit Despachante
	despa		int4;
    BEGIN
	select desp_id into despa from despach where bpchareq(desp_nrcuit,cuit);
		if not found then
		    insert into despach (desp_tipo,desp_nrcuit,desp_nroreg,desp_nombre) values (1,cuit,'S/D','DATO DESCONOCIDO');
		    select desp_id into despa from despach where bpchareq(desp_nrcuit,cuit);
		end if;

	RETURN despa;
    END;$_$;


ALTER FUNCTION public.cual_despachante(character varying) OWNER TO zona;

--
-- Name: cual_moneda(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_moneda(character varying) RETURNS smallint
    LANGUAGE sql
    AS $_$select mon_codigo from moneda where bpchareq(trim(mon_simbol),trim($1));$_$;


ALTER FUNCTION public.cual_moneda(character varying) OWNER TO zona;

--
-- Name: cualdepo(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cualdepo(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select unif_codigo from unifun where unif_estado in (1,100,200) and unif_usuario = $1 limit 1;$_$;


ALTER FUNCTION public.cualdepo(integer) OWNER TO zona;

--
-- Name: cuantdepo(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuantdepo(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from unifun where unif_estado in (1,100,200) and unif_usuario = $1;$_$;


ALTER FUNCTION public.cuantdepo(integer) OWNER TO zona;

--
-- Name: cuit_fe(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuit_fe(character varying) RETURNS character
    LANGUAGE sql
    AS $_$select regexp_replace(regexp_replace(trim($1), '-', ''),'-','');$_$;


ALTER FUNCTION public.cuit_fe(character varying) OWNER TO zona;

--
-- Name: cuitcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuitcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nrcuit from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.cuitcli(integer) OWNER TO zona;

--
-- Name: cuitconsig(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuitconsig(integer) RETURNS character
    LANGUAGE sql
    AS $_$select csg_nrocuit from consig where csg_id = $1;$_$;


ALTER FUNCTION public.cuitconsig(integer) OWNER TO zona;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO zona;

--
-- Name: cuitusu(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuitusu(integer) RETURNS character
    LANGUAGE sql
    AS $_$select usu_nrocuit from usuarios where usu_codigo = $1;$_$;


ALTER FUNCTION public.cuitusu(integer) OWNER TO zona;

--
-- Name: depositem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION depositem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select sitem_deposito from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.depositem(integer) OWNER TO zona;

--
-- Name: depositop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION depositop(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select op_deposito from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.depositop(integer) OWNER TO zona;

--
-- Name: descartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_codi||'  -  '||art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.descartic(integer) OWNER TO zona;

--
-- Name: descauto(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descauto(integer) RETURNS character
    LANGUAGE sql
    AS $_$select mar_nombre||'  - Modelo:  '|| mod_nombre from marauto a,modauto b where a.mar_codigo=b.mod_marca  and mod_id = $1 ;$_$;


ALTER FUNCTION public.descauto(integer) OWNER TO zona;

--
-- Name: descautoinout(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descautoinout(integer) RETURNS character
    LANGUAGE sql
    AS $_$select descauto(lv_modelo) from ingxl,inoutliv,livianos where lv_id=iol_liviano and igxl_iol=iol_id and igxl_io= $1 ;$_$;


ALTER FUNCTION public.descautoinout(integer) OWNER TO zona;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO zona;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO zona;

--
-- Name: descchqf(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descchqf(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select bco_nombre||'  - Nro: '||chq_nucheq||'  - Fecha: '||chq_fecheq||'  - Importe: $ '||chq_importe from cheques,bancos where chq_codbco=bco_codigo and chq_id= $1 ;$_$;


ALTER FUNCTION public.descchqf(integer) OWNER TO zona;

--
-- Name: descchqt(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descchqt(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select bco_nombre||'  - Nro: '||chq_nucheq||'  - Fecha: '||chq_fecheq||'  - Importe: $ '||chq_importe from cheques,bancos where chq_codbco=bco_codigo and chq_id= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.descchqt(integer) OWNER TO zona;

--
-- Name: desccli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_codigo||'  -  '||cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.desccli(integer) OWNER TO zona;

--
-- Name: desccli_emiti(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccli_emiti(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.cli_codigo||'  -  '||a.cli_nombre from clientes a, emiti b where a.cli_id=b.emi_codcli and b.emi_id= $1 ;$_$;


ALTER FUNCTION public.desccli_emiti(integer) OWNER TO zona;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select trim(comp_codigo)::character varying||'  -  '||rpad(comp_nombre,40,' ') from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO zona;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO zona;

--
-- Name: desccompdeastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION desccompdeastoh(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||ash_numero 
    from comprob,astoh where comp_id=ash_comprob and ash_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoh(integer) OWNER TO zona;

--
-- Name: descctes(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_codigo||'  -  '||cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.descctes(integer) OWNER TO zona;

--
-- Name: descdirdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descdirdesitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.usu_codigo||' - '||a.usu_nombre from usuarios a,subitem b where a.usu_codigo=b.sitem_directo and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.descdirdesitem(integer) OWNER TO zona;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO zona;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO zona;

--
-- Name: descfacg(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descfacg(integer, integer, integer, integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select desccomp(astc_comprob)||'  Nro  '||astc_numero from astoctas where astc_codemp= $1 and astc_tipcta= $2 and astc_ctacte= $3 and astc_grupo= $4 order by astc_fecval asc,astc_importe desc limit 1;$_$;


ALTER FUNCTION public.descfacg(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: descfactcpra(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descfactcpra(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Prov: '|| cpra_nomprov || '  Factura:  '|| cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0'::text) ||' - '|| lpad(cpra_nucomp::text,8,'0'::text) from compra where cpra_id= $1 ;$_$;


ALTER FUNCTION public.descfactcpra(integer) OWNER TO zona;

--
-- Name: descfc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descfc(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0'::text) ||' - '|| lpad(cpra_nucomp::text,8,'0'::text) from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.descfc(integer) OWNER TO zona;

--
-- Name: descgente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descgente(integer) RETURNS character
    LANGUAGE sql
    AS $_$select gte_nombre||'  - Docum.:  '|| gte_tdoc ||'  Nro  '||gte_nrodoc from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.descgente(integer) OWNER TO zona;

--
-- Name: descgentet(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descgentet(integer) RETURNS character
    LANGUAGE sql
    AS $_$select gte_nombre||'  - Docum.:  '|| gte_tdoc ||'  Nro  '||gte_nrodoc from gente where gte_tarjeta= $1 and gte_estado=1 order by gte_id desc limit 1;$_$;


ALTER FUNCTION public.descgentet(integer) OWNER TO zona;

--
-- Name: descgteio(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descgteio(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.gte_nombre||'  -  '|| a.gte_tdoc ||'  -  '||a.gte_nrodoc from gente a,inout b where b.io_gente=a.gte_id and b.io_id= $1 ;$_$;


ALTER FUNCTION public.descgteio(integer) OWNER TO zona;

--
-- Name: descindirdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descindirdesitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.usu_codigo||' - '||a.usu_nombre from usuarios a,subitem b where a.usu_codigo=b.sitem_indirecto and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.descindirdesitem(integer) OWNER TO zona;

--
-- Name: descliv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descliv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select lv_patente||'   -  Marca: '|| descauto(lv_modelo) from livianos where lv_id = $1 ;$_$;


ALTER FUNCTION public.descliv(integer) OWNER TO zona;

--
-- Name: descmon(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descmon(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_codigo||'  -  '||mon_nombre from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.descmon(smallint) OWNER TO zona;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO zona;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO zona;

--
-- Name: descrioper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descrioper(integer) RETURNS character
    LANGUAGE sql
    AS $_$select traigo_simbtipoper(op_tipoper)||'-'||op_nrotaldir from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.descrioper(integer) OWNER TO zona;

--
-- Name: descripdeartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descripdeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_descrip from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.descripdeartic(integer) OWNER TO zona;

--
-- Name: diasconpag(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION diasconpag(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cdp_dias from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.diasconpag(integer) OWNER TO zona;

--
-- Name: direcgente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION direcgente(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select gte_direcc||'  Localidad: '||gte_locali from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.direcgente(integer) OWNER TO zona;

--
-- Name: directodeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodeop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_directo from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.directodeop(integer) OWNER TO zona;

--
-- Name: directodewop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select wop_directo from woperaciones where wop_id= $1 ;$_$;


ALTER FUNCTION public.directodewop(integer) OWNER TO zona;

--
-- Name: directodewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewret2(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select a.wsitem_directo from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;$_$;


ALTER FUNCTION public.directodewret2(integer) OWNER TO zona;

--
-- Name: directodewsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewsitem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select wsitem_directo from wsubitem where wsitem_id= $1 ;$_$;


ALTER FUNCTION public.directodewsitem(integer) OWNER TO zona;

--
-- Name: docgente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION docgente(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_nrodoc from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.docgente(integer) OWNER TO zona;

--
-- Name: dsctocli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION dsctocli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cli_descto from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.dsctocli(integer) OWNER TO zona;

--
-- Name: elimino_op_malas(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elimino_op_malas(smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	estado		ALIAS FOR $1; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select op_id as x
    	    from operaciones where op_estado in (1,11) and op_tipoper>100
		loop

		    select ret_id into operacion from retiros where ret_idopera=registro.x;
		    if not found then
			update operaciones set op_fecha_close=date(now()) where op_id=registro.x and op_fecha_close is null;
			ret:='t';
		    end if;		
		end loop; 
    
    update operaciones set op_estado=estado where op_estado in (1,11) and op_tipoper>100 and op_fecha_close=date(now()) ;

return ret;
	
    END;$_$;


ALTER FUNCTION public.elimino_op_malas(smallint) OWNER TO zona;

--
-- Name: elimino_rexp_vencidas(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elimino_rexp_vencidas(smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	estado		ALIAS FOR $1; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

update operaciones set op_estado=estado where op_estado in (1,11) and op_tipoper in (101,105) and op_fechain < date(now())-31 and op_vence=1;

return ret;
	
    END;$_$;


ALTER FUNCTION public.elimino_rexp_vencidas(smallint) OWNER TO zona;

--
-- Name: elimino_wop_vacias(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elimino_wop_vacias(smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	estado		ALIAS FOR $1; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select wop_id as x
    	    from woperaciones where wop_estado in (1,11) and wop_tipoper>100
		loop

		    select wret2_id into operacion from wret2 where wret2_idopera=registro.x;
		    if not found then
			ret:='t';
			update woperaciones set wop_bultos=-1 where wop_id=registro.x ;
		    end if;		
		end loop; 
    
    update woperaciones set wop_estado=999 where wop_bultos=-1 ;


return ret;
	
    END;$_$;


ALTER FUNCTION public.elimino_wop_vacias(smallint) OWNER TO zona;

--
-- Name: elprecio(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elprecio(integer, integer, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	articulo	ALIAS FOR $3; 
	idart 		integer;
	retval 		numeric(15,2);
    BEGIN
    select idarticvta(codemp,articulo) into idart;
    select ltp_precio into retval from
    	 listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	    select art_precio into retval from
    		articvta where int4eq(idart,art_id);
    end if;

    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecio(integer, integer, character varying) OWNER TO zona;

--
-- Name: elprecioid(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elprecioid(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	idart		ALIAS FOR $3; 
	retval 		numeric;
    BEGIN
    select ltp_precio into retval from
    	 listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	    select art_precio into retval from
    		articvta where int4eq(idart,art_id);
    end if;

    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecioid(integer, integer, integer) OWNER TO zona;

--
-- Name: es_sensible(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION es_sensible(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
laposa		alias for $1;
ret		int4;
begin
    select 2 into ret from posarest where bpchareq(posar_codigo,laposa);
    if not found then
	select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,14));
	if not found then
	    select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,13));
	    if not found then
		select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,12));
		if not found then
		    select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,11));
		    if not found then
			select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,10));
			if not found then
			    select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,9));
			    if not found then
				select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,8));
			        if not found then
			    	    select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,7));
				    if not found then
					select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,6));
				        if not found then
					    select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,5));
				    	    if not found then
						select 2 into ret from posarest where bpchareq(posar_codigo,substr(laposa,1,4));
					    end if;
				        end if;
				    end if;
			        end if;
			    end if;
		        end if;
		    end if;
		end if;
	    end if;
	end if;
    end if;

    if ret is null then
	ret:=1;
    end if;
    
    return ret;
end;$_$;


ALTER FUNCTION public.es_sensible(character varying) OWNER TO zona;

--
-- Name: estado_opera(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estado_opera(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select op_estado from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.estado_opera(integer) OWNER TO zona;

--
-- Name: estadocontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadocontr(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select contr_estado from contratos where contr_id= $1;$_$;


ALTER FUNCTION public.estadocontr(integer) OWNER TO zona;

--
-- Name: estadop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadop(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select op_estado from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.estadop(integer) OWNER TO zona;

--
-- Name: estadunif(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadunif(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select unif_estado from unifun where unif_codigo= $1 ;$_$;


ALTER FUNCTION public.estadunif(integer) OWNER TO zona;

--
-- Name: eval_funcion(text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION eval_funcion(text) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	res		record;
    BEGIN
	for res in execute 'select '||$1||' as result' loop
	return res.result;
	end loop;
END;$_$;


ALTER FUNCTION public.eval_funcion(text) OWNER TO zona;

--
-- Name: existe_modopub(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION existe_modopub(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; -- id  Operacion
	operador	int4;
	retval 		boolean;
    BEGIN
    retval:='f';
    select mod_idoperador into operador from modopub where mod_idoper=operacion;
    if found then
	retval:='t';
    end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.existe_modopub(integer) OWNER TO zona;

--
-- Name: f_ad_retiros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_retiros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    estado 		int2;
    dato 		varchar;
    aux_texto 		text;
    BEGIN

    select op_estado into estado from operaciones 
	where OLD.ret_idopera = op_id;

    if (int2lt(estado,100::int2)) then
        update subitem 
	set sitem_cantcomp= sitem_cantcomp - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
    END IF;

    if(int2eq(estado,999::int2) ) then
        update subitem 
	set sitem_cantcomp= sitem_cantcomp - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
    END IF;

    if(int2gt(estado,100::int2) and int2ne(estado,999::int2)) then
        update subitem 
	set sitem_cantret= sitem_cantret - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
	aux_texto:='El usuario autorizado ha borrado el retiro de la operacion publicada '||OLD.ret_idopera||' que era del subitem '||OLD.ret_idsitem ||' con una cantidad de '||OLD.ret_cantidad ||' el dia de hoy';
	insert into noticias(not_tipo,not_numero,not_texto)values(59,OLD.ret_idopera,aux_texto);
    END IF;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_retiros() OWNER TO zona;

--
-- Name: f_ad_seguros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_seguros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN

    if(int2ne(OLD.seg_estado,1::int2)) then
    update unifun set unif_seguro=unif_seguro-OLD.seg_impmoncte where unif_codigo=OLD.seg_unifun;
    end if;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_seguros() OWNER TO zona;

--
-- Name: f_ad_subitem(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_subitem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
BEGIN

if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
    aux_texto:='El usuario autorizado ha borrado el subitem '||OLD.sitem_id ||' de la operacion publicada '||OLD.sitem_idoper||' que tenia un importe de '||OLD.sitem_importe||' del articulo '||OLD.sitem_artic||' con una cantidad de '||OLD.sitem_canting||' el dia de hoy';
    insert into noticias(not_tipo,not_numero,not_texto)values(49,OLD.sitem_idoper,aux_texto);
end if;

RETURN OLD;
END;$$;


ALTER FUNCTION public.f_ad_subitem() OWNER TO zona;

--
-- Name: f_ad_volegr(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_volegr() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    aux_texto 		text;
    BEGIN

    update voling set vol_cantret= vol_cantret - OLD.vole_cantret where vol_idoper=OLD.vole_idoperi;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_volegr() OWNER TO zona;

--
-- Name: f_ad_wret2(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_wret2() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    estado 		int2;
    dato 		varchar;
    aux_texto 		text;
    BEGIN

        update wsubitem set wsitem_cantcompw= wsitem_cantcompw - OLD.wret2_cantidad where wsitem_id=OLD.wret2_idsitem;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_wret2() OWNER TO zona;

--
-- Name: f_ai_artseg(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_artseg() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
    if(int4eq(NEW.as_tipo,1::int4))  THEN 
	    update livianos set lv_estado=NEW.as_estado where lv_id=NEW.as_idorig;
	else
	    update gente set gte_estado=NEW.as_estado,gte_fechas=NEW.as_fechas where gte_id=NEW.as_idorig;
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_artseg() OWNER TO zona;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcbl(NEW.astc_codemp, valvaramb(NEW.astc_codemp,NEW.astc_idptov,'BANCO')::integer) into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;

    if(int4eq(NEW.astc_ctacble,ctabco))  THEN 

	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;

	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;

    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO zona;

--
-- Name: f_ai_clientes(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into ctes (cte_nombre,cte_codemp,cte_codigo,cte_tipcta) values (NEW.cli_nombre,NEW.cli_codemp,NEW.cli_codigo,31);
	insert into sucursal (sucu_cliente,sucu_nombre) values (NEW.cli_id,NEW.cli_nombre);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_clientes() OWNER TO zona;

--
-- Name: f_ai_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_contratos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    if int4eq(tipo_de_contrato(NEW.contr_idsubt),1) then
	update unifun set unif_usuario=NEW.contr_locatario, unif_estado=1::int2
	where unif_codigo=NEW.contr_unifun;

    end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_contratos() OWNER TO zona;

--
-- Name: f_ai_facturacion(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_facturacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	if NEW.fac_anio is null then NEW.fac_anio=date_part('year',NEW.fac_fecha)::int2; end if;
	if NEW.fac_anio is null then NEW.fac_mes=date_part('month',NEW.fac_fecha)::int2; end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_facturacion() OWNER TO zona;

--
-- Name: f_ai_ingzpa(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_ingzpa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE

aux_texto 	text;
registro	record;
importe		numeric;
precio		numeric;
paletiz		integer;
nopaletiz	integer;
concepto	integer;
elid		integer;
existe		int4;
tarifa		numeric;

BEGIN

paletiz:=6;
nopaletiz:=1;
elid:=NEW.i_id*-1;

if int4eq(NEW.i_paletiz,1) then
    concepto:=paletiz;
else
    concepto:=nopaletiz;
end if;

select tariman(NEW.i_indirecto,concepto,NEW.i_voling::numeric,NEW.i_fecing) into tarifa;
aux_texto:='Ingreso ZPA - Man. carga ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,NEW.i_voling::numeric,tarifa,tarifa*NEW.i_voling,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
aux_texto:='Egreso ZPA - Man. carga ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,NEW.i_voling::numeric,tarifa,tarifa*NEW.i_voling,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);

aux_texto:='Ingreso ZPA - Declaracion SIM ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
concepto=34;
select tarifb(NEW.i_indirecto,concepto,0::numeric,elid,NEW.i_fecing) into tarifa;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
aux_texto:='Ingreso ZPA - Gestion SIM ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
concepto=17;
select tarifb(NEW.i_indirecto,concepto,0::numeric,elid,NEW.i_fecing) into tarifa;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
aux_texto:='Ingreso ZPA - Ingreso de Mercaderia ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
concepto=32;
select tarifb(NEW.i_indirecto,concepto,0::numeric,elid,NEW.i_fecing) into tarifa;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
aux_texto:='Ingreso ZPA - Salida de Mercaderia ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
concepto=35;
select tari_chasta into tarifa from tarifas where tari_idart=35 and tari_idcontr=-1 limit 1;
insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);



RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_ingzpa() OWNER TO zona;

--
-- Name: f_ai_item(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_item() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipodeop	int4;
	essensi		int4;
	esta		int4;
BEGIN


    select tipoperdeop(NEW.item_idoper) into tipodeop;
	if int4lt(tipodeop,6) then
	    select es_sensible(NEW.item_posa) into essensi;
	    if int4eq(essensi,2) then
	    select opr_idoper into esta from operest where opr_idoper=NEW.item_idoper and opr_compbte=compbteoper(NEW.item_idoper);
		if not found then
		    insert into operest (opr_idoper,opr_compbte) values (NEW.item_idoper,compbteoper(NEW.item_idoper));
		end if;
	    end if;
	end if;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_item() OWNER TO zona;

--
-- Name: f_ai_operaciones(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_operaciones() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	operacion	int4;
    BEGIN
    update talonop set talop_numero=talop_numero+1 where talop_usuario=NEW.op_directo and talop_tipoper=NEW.op_tipoper;
    update talonop set talop_numero=talop_numero+1 where talop_usuario=1 and talop_tipoper=NEW.op_tipoper;
    select auxo_idoper into operacion from auxoper where auxo_idoper=NEW.op_id;
    if not found then
	insert into auxoper(auxo_idoper) values(NEW.op_id);

	if(int4lt(NEW.op_tipoper,100::int4)) THEN 
	    insert into voling(vol_idoper,vol_directo,vol_indirecto,vol_cliente,vol_compbte,vol_comptrans,vol_canting) values (NEW.op_id,NEW.op_directo,NEW.op_indirecto,idcli(NEW.op_directo,NEW.op_indirecto),NEW.op_compbte,NEW.op_comptrans,NEW.op_volumen);
	end if;
    end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_operaciones() OWNER TO zona;

--
-- Name: f_ai_prove(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into ctes (cte_nombre,cte_codemp,cte_codigo,cte_tipcta) values (NEW.prov_nombre,NEW.prov_codemp,NEW.prov_id,eval_funcion(valvaramb(NEW.prov_codemp,ptovdefault(NEW.prov_codemp),'TIPCTADXC')));
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_prove() OWNER TO zona;

--
-- Name: f_ai_retiros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_retiros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    existe	int4;
    BEGIN
        update subitem set sitem_cantcomp=sitem_cantcomp+NEW.ret_cantidad where sitem_id=NEW.ret_idsitem;

--estas 4 lineas son las que hay que comentariar si no funca
	select vole_idoper into existe from volegr where vole_idoper=NEW.ret_idopera and vole_idoperi=sitemop(NEW.ret_idsitem);
	if not found then
	    insert into volegr(vole_idoper,vole_idoperi,vole_directo,vole_indirecto,vole_cliente,vole_compbte) values(NEW.ret_idopera,sitemop(NEW.ret_idsitem),directodeop(NEW.ret_idopera),indirectodeop(NEW.ret_idopera),idcli(directodeop(NEW.ret_idopera),indirectodeop(NEW.ret_idopera)),compbteret_idsitem(NEW.ret_idsitem));
	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_retiros() OWNER TO zona;

--
-- Name: f_ai_seguros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_seguros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    segvie 		numeric;
    BEGIN

    select unif_seguro into segvie from unifun where unif_codigo=NEW.seg_unifun;
    if segvie is null then segvie:=0; end if;

    update unifun set unif_seguro= segvie + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_seguros() OWNER TO zona;

--
-- Name: f_ai_subitemd(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_subitemd() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	operacion	int4;
    BEGIN
	insert into stockd(stk_idsitem,stk_iditem,stk_idoper,stk_codigo,stk_artic,stk_canting,stk_cantret,stk_cantcomp,stk_cantmala,stk_importe,stk_imp_dolar,stk_volumen,stk_peso,stk_tipemb,stk_deposito,stk_idacta,stk_estado,stk_directo,stk_indirecto,stk_compbte,stk_cliente,stk_comptras) values (NEW.sitemd_id,NEW.sitemd_iditem,NEW.sitemd_idoper,NEW.sitemd_codigo,iddearticudm(NEW.sitemd_artic),NEW.sitemd_canting,NEW.sitemd_cantret,NEW.sitemd_cantcomp,NEW.sitemd_cantmala,NEW.sitemd_importe,NEW.sitemd_imp_dolar,NEW.sitemd_volumen,NEW.sitemd_peso,NEW.sitemd_tipemb,NEW.sitemd_deposito,NEW.sitemd_idacta,NEW.sitemd_estado,NEW.sitemd_directo,NEW.sitemd_indirecto,NEW.sitemd_compbte,NEW.sitemd_cliente,NEW.sitemd_comptras);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_subitemd() OWNER TO zona;

--
-- Name: f_ai_usuarios(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_usuarios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    insert into talonop values(NEW.usu_codigo,1,1);
    insert into talonop values(NEW.usu_codigo,5,1);
    insert into talonop values(NEW.usu_codigo,10,1);
    insert into talonop values(NEW.usu_codigo,20,1);
    insert into talonop values(NEW.usu_codigo,30,1);
    insert into talonop values(NEW.usu_codigo,101,1);
    insert into talonop values(NEW.usu_codigo,105,1);
    insert into talonop values(NEW.usu_codigo,110,1);
    insert into talonop values(NEW.usu_codigo,120,1);
    insert into talonop values(NEW.usu_codigo,130,1);
    insert into talonop values(NEW.usu_codigo,2,1);
    insert into talonop values(NEW.usu_codigo,3,1);
    insert into talonop values(NEW.usu_codigo,4,1);
    insert into talonop values(NEW.usu_codigo,102,1);
    insert into talonop values(NEW.usu_codigo,103,1);

    insert into sucursales (suc_cliente,suc_codigo,suc_nombre) values(NEW.usu_codigo,1::int2,NEW.usu_nombre);

    insert into clientes (cli_codemp,cli_idptov,cli_codigo,cli_codaso,cli_nrcuit,cli_tipcli,cli_nombre,cli_fantasy,cli_nomabre,cli_coniva,cli_conpag,cli_catego,cli_limcred,cli_interes,cli_grupo,cli_saldo,cli_estado) values (1,1,NEW.usu_codigo,NEW.usu_codigo,NEW.usu_nrocuit,NEW.usu_tipusu,NEW.usu_nombre,NEW.usu_fantasy,NEW.usu_nomabre,NEW.usu_coniva,NEW.usu_conpago,NEW.usu_catego,NEW.usu_limcred,NEW.usu_tasaint,NEW.usu_grupo,NEW.usu_saldo,NEW.usu_estado);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_usuarios() OWNER TO zona;

--
-- Name: f_ai_wret2(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_wret2() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
        update wsubitem set wsitem_cantcompw=wsitem_cantcompw+NEW.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_wret2() OWNER TO zona;

--
-- Name: f_au_artseg(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_artseg() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
if(int2ne(NEW.as_estado,OLD.as_estado)) THEN 
    if(int4eq(NEW.as_tipo,1::int4))  THEN 
	    update livianos set lv_estado=NEW.as_estado where lv_id=NEW.as_idorig;
	else
	    update gente set gte_estado=NEW.as_estado,gte_fechas=NEW.as_fechas where gte_id=NEW.as_idorig;
    END IF;
END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_artseg() OWNER TO zona;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total	numeric;
	dias	numeric;
BEGIN

    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=OLD.astc_id;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=OLD.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=OLD.astc_id;
	END IF;

    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	if int4eq(OLD.astc_ctacble,18) THEN 
	    update emiti set emi_codcli=NEW.astc_ctacte where emi_idastoh=OLD.astc_idastoh;
	END IF;
	
	if int4eq(OLD.astc_ctacble,134) THEN 
		update compra set cpra_prove=NEW.astc_ctacte where cpra_idastoh=OLD.astc_idastoh;
	END IF;
    END IF;

    if (int4ne(NEW.astc_estado,OLD.astc_estado) and int4eq(NEW.astc_estado,2)) THEN 
	select sum(astc_importe) into total from astoctas where astc_idastoh=OLD.astc_idastoh and astc_importe>0;
	update compra set cpra_total=total where cpra_idastoh=OLD.astc_idastoh;
    END IF;


    if (int4eq(NEW.astc_estado,999) and int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,1,'DEUDXV')::integer)) or int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,1,'DEUDXC')::integer))))  THEN 
	update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=OLD.astc_idastoh;
    END IF;

    if (int4ne(NEW.astc_estado,OLD.astc_estado)  and int2eq(NEW.astc_cierra,2::int2) and int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,1,'DEUDXV')::integer))) THEN 
	select diasconpag(emi_conpag) into dias from emiti where emi_idastoh=NEW.astc_idastoh;
	    if found then
		update astoctas set astc_fecvto=astc_fecval+dias::integer where astc_id=NEW.astc_id;
	    end if;
    END IF;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO zona;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	update emiti set emi_estado=NEW.ash_estado where emi_idastoh=OLD.ash_id;
	delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;

    if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	END IF;

    if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	update compra set cpra_fecval=NEW.ash_fecval where cpra_idastoh=OLD.ash_id;
	update emiti set emi_fecval=NEW.ash_fecval where emi_idastoh=OLD.ash_id;
	update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;

    if date_ne(NEW.ash_fecomp,OLD.ash_fecomp) THEN 
	update compra set cpra_fecori=NEW.ash_fecomp where cpra_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	update compra set cpra_comprob=NEW.ash_comprob where cpra_idastoh=OLD.ash_id;
	update emiti set emi_comprob=NEW.ash_comprob where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	update compra set cpra_numero=NEW.ash_numero where cpra_idastoh=OLD.ash_id;
	update emiti set emi_numero=NEW.ash_numero where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	update compra set cpra_codemp=NEW.ash_codemp where cpra_idastoh=OLD.ash_id;
	update emiti set emi_codemp=NEW.ash_codemp where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	update compra set cpra_idptov=NEW.ash_idptov where cpra_idastoh=OLD.ash_id;
	update emiti set emi_idptov=NEW.ash_idptov where emi_idastoh=OLD.ash_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO zona;

--
-- Name: f_au_auxoper(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_auxoper() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
tipoper		int4;
indi		int4;
dir		int4;
fecha		date;
existe		int4;
BEGIN

    select op_tipoper,op_directo,op_indirecto,op_fechain into tipoper,dir,indi,fecha from operaciones where op_id=NEW.auxo_idoper;

    if(int4eq(tipoper,101::int4) or int4eq(tipoper,105::int4))  THEN 
	select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.auxo_idoper and cfc1_idart=35;
	if found then
	    if(int4eq(dir,1::int4)) THEN
		update confactur1 set cfc1_precio=tarrexb(indi,35,0::numeric,NEW.auxo_idoper,fecha), cfc1_importe=tarrexb(indi,35,0::numeric,NEW.auxo_idoper,fecha) where cfc1_idoper=NEW.auxo_idoper and cfc1_idart=35;
	    else
		update confactur1 set cfc1_precio=tarrexb(dir,35,0::numeric,NEW.auxo_idoper,fecha), cfc1_importe=tarrexb(dir,35,0::numeric,NEW.auxo_idoper,fecha) where cfc1_idoper=NEW.auxo_idoper and cfc1_idart=35;
	    END IF;
	END IF;
    END IF;


RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_auxoper() OWNER TO zona;

--
-- Name: f_au_clientes(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.cli_nombre,OLD.cli_nombre) THEN 
	update ctes set cte_nombre=NEW.cli_nombre where cte_codigo=OLD.cli_id and cte_codemp=OLD.cli_codemp and cte_tipcta=eval_funcion(valvaramb(NEW.cli_codemp,ptovdefault(NEW.cli_codemp),'TIPCTADXV'));
	update sucursal set sucu_nombre=NEW.cli_nombre where sucu_cliente=OLD.cli_id and sucu_nombre=OLD.cli_nombre;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_clientes() OWNER TO zona;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO zona;

--
-- Name: f_au_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_contratos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	operacion	int4;
    BEGIN

    if(int2eq(OLD.contr_estado,1::int2) and int2eq(NEW.contr_estado,2::int2) and int4lt(NEW.contr_idsubt,7)) then 

	select contr_id into operacion from contratos where int4lt(contr_idsubt,7) and contr_locatario=NEW.contr_locatario and contr_locador=NEW.contr_locador and contr_estado=1 and contr_id!=OLD.contr_id;
	if not found then
	    select contr_id into operacion from contratos where int4eq(contr_idsubt,11) and contr_locatario=NEW.contr_locatario and contr_estado=1;
	    if not found then
		update contratos set contr_estado=0 where contr_locador=NEW.contr_locatario and contr_estado=1 and contr_idsubt>6;
	    end if;
	end if;

    END IF;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_contratos() OWNER TO zona;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;

	if int4eq(NEW.emi_estado,2) THEN 
	    update astoctas set astc_fecvto=astc_fecval+diasconpag(NEW.emi_conpag) where astc_idastoh=OLD.emi_idastoh and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,0,'DEUDXV')::integer);
	    END IF;

	END IF;

    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrocuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;



    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO zona;

--
-- Name: f_au_feccontra(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_feccontra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN

	if(int4eq(NEW.fechac_codevent,5) and date_ne(OLD.fechac_fecha,NEW.fechac_fecha)) then
    	    update tarifas set tari_fhasta=NEW.fechac_fecha where tari_idcontr=NEW.fechac_idcontra;
	end if;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_feccontra() OWNER TO zona;

--
-- Name: f_au_gente(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_gente() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
if(int2ne(NEW.gte_estado,OLD.gte_estado)) THEN 
    if(int4eq(NEW.gte_estado,31::int4) or int4eq(NEW.gte_estado,21::int4) )  THEN 
	update carvis set cvt_estado=2 where cvt_gente=NEW.gte_id;
    END IF;
END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_gente() OWNER TO zona;

--
-- Name: f_au_ingzpa(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_ingzpa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE

aux_texto 	text;
registro	record;
importe		numeric;
precio		numeric;
paletiz		integer;
nopaletiz	integer;
concepto	integer;
elid		integer;
existe		int4;
tarifa		numeric;

BEGIN

paletiz:=6;
nopaletiz:=1;
elid:=NEW.i_id*-1;

if int4eq(NEW.i_paletiz,1) then
    concepto:=paletiz;
else
    concepto:=nopaletiz;
end if;


if int4ne(NEW.i_paletiz,OLD.i_paletiz) or numeric_ne(NEW.i_voling,OLD.i_voling) then
    delete from confactur1 where cfc1_idoper=elid and cfc1_idart in (paletiz,nopaletiz);
    select tariman(NEW.i_indirecto,concepto,NEW.i_voling::numeric,NEW.i_fecing) into tarifa;
    aux_texto:='Ingreso ZPA - Man. carga ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,NEW.i_voling::numeric,tarifa,tarifa*NEW.i_voling,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
    aux_texto:='Egreso ZPA - Man. carga ' || substr(nomusu(NEW.i_indirecto),1,25) || ' / ' || NEW.i_compbte;
    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.i_indirecto,NEW.i_fecing,concepto::int4,NEW.i_voling::numeric,tarifa,tarifa*NEW.i_voling,elid,aux_texto,1::int2,date_part('year',NEW.i_fecing),date_part('month',NEW.i_fecing),NEW.i_indirecto);
end if;

if int4eq(NEW.i_estado,999::int4) then
    delete from confactur1 where cfc1_idoper=elid;
    update opervehi set opv_est_camion=100 where opv_idoper=elid;
end if;



RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_ingzpa() OWNER TO zona;

--
-- Name: f_au_inout(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_inout() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
if(int2ne(NEW.io_estado,OLD.io_estado)) THEN 
    update ingxl set igxl_estado=NEW.io_estado where igxl_io=NEW.io_id;
    update visita set vt_estado=NEW.io_estado where vt_gente=NEW.io_gente;
END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_inout() OWNER TO zona;

--
-- Name: f_au_item(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_item() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
BEGIN
if int2gt(estadop(NEW.item_idoper),100::int2) THEN

    if (int2ne(NEW.item_item,OLD.item_item)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  item '||NEW.item_id ||' de la operacion publicada '||NEW.item_idoper||' que tenia un codigo '||OLD.item_item||' por el codigo '||NEW.item_item||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(31,NEW.item_idoper,aux_texto);
        end if;

    if (int2ne(NEW.item_moneda,OLD.item_moneda)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  item '||NEW.item_id ||' de la operacion publicada '||NEW.item_idoper||' que tenia la moneda '||OLD.item_moneda||' por la moneda '||NEW.item_moneda||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(32,NEW.item_idoper,aux_texto);
        end if;

    if (int4ne(NEW.item_tipprod,OLD.item_tipprod)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  item '||NEW.item_id ||' de la operacion publicada '||NEW.item_idoper||' que tenia tipo de producto '||OLD.item_tipprod||' por el tipo de producto '||NEW.item_tipprod||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(33,NEW.item_idoper,aux_texto);
        end if;

    if (int2ne(NEW.item_unimed,OLD.item_unimed)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  item '||NEW.item_id ||' de la operacion publicada '||NEW.item_idoper||' que tenia unimed '||OLD.item_unimed||' por la unimed '||NEW.item_unimed||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(34,NEW.item_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.item_posa,OLD.item_posa)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  item '||NEW.item_id ||' de la operacion publicada '||NEW.item_idoper||' que tenia posicion arancelaria '||OLD.item_posa||' por la pocision arancelaria '||NEW.item_posa||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(35,NEW.item_idoper,aux_texto);
        end if;
end if;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_item() OWNER TO zona;

--
-- Name: f_au_operaciones(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_operaciones() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
existe		int4;
tarifa		numeric;
nacional	int4;
nacional2	int4;
BEGIN

nacional:=6;
nacional2:=5;
tarifa:=0;

    if((int4eq(NEW.op_tipoper,101::int4) or int4eq(NEW.op_tipoper,105::int4)) and NEW.op_deposito not in (nacional,nacional2))  THEN 
	RAISE NOTICE 'entre';
	aux_texto:=substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
	select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=35;
	if not found then
	    RAISE NOTICE 'no cfc1';
	    if(int4eq(NEW.op_directo,1::int4)) THEN
		insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,35::int4,1::numeric,tarrexb(NEW.op_indirecto,35,0::numeric,NEW.op_id,NEW.op_fechain),tarrexb(NEW.op_indirecto,35,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
	      else
		insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,35::int4,1::numeric,tarrexb(NEW.op_directo,35,0::numeric,NEW.op_id,NEW.op_fechain),tarrexb(NEW.op_directo,35,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
	    END IF;
	  else
	    RAISE NOTICE 'si cfc1';
	    if(int4eq(NEW.op_directo,1::int4)) THEN
		update confactur1 set cfc1_fecha=NEW.op_fechain, cfc1_precio=tarrexb(NEW.op_indirecto,35,0::numeric,NEW.op_id,NEW.op_fechain), cfc1_importe=tarrexb(NEW.op_indirecto,35,0::numeric,NEW.op_id,NEW.op_fechain), cfc1_leyen=aux_texto, cfc1_anio=date_part('year',NEW.op_fechain), cfc1_mes=date_part('month',NEW.op_fechain), cfc1_indirecto=NEW.op_indirecto, cfc1_usuario=NEW.op_indirecto where cfc1_idoper=NEW.op_id and cfc1_idart=35;
	      else
		update confactur1 set cfc1_fecha=NEW.op_fechain, cfc1_precio=tarrexb(NEW.op_directo,35,0::numeric,NEW.op_id,NEW.op_fechain), cfc1_importe=tarrexb(NEW.op_directo,35,0::numeric,NEW.op_id,NEW.op_fechain), cfc1_leyen=aux_texto, cfc1_anio=date_part('year',NEW.op_fechain), cfc1_mes=date_part('month',NEW.op_fechain), cfc1_indirecto=NEW.op_indirecto where cfc1_idoper=NEW.op_id and cfc1_idart=35;
	    END IF;
	END IF;
    END IF;



if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,101::int2) 
    and int4lt(NEW.op_tipoper,100::int4)) THEN 
    delete from subitem where sitem_idoper=NEW.op_id;
    delete from item where item_idoper=NEW.op_id;
    delete from voling where vol_idoper=NEW.op_id;
    delete from confactur1 where cfc1_idoper=NEW.op_id;
    delete from confactur where cfc_idoper=NEW.op_id;
end if;

if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,101::int2) 
    and (int4eq(NEW.op_tipoper,101::int4) or int4eq(NEW.op_tipoper,105::int4)) ) THEN 
    delete from retiros where ret_idopera=NEW.op_id;
    delete from volegr where vole_idoper=NEW.op_id;
    delete from confactur1 where cfc1_idoper=NEW.op_id;
    delete from confactur where cfc_idoper=NEW.op_id;
end if;

if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,101::int2) ) THEN
    if(int4eq(NEW.op_tipoper,110::int4) or int4eq(NEW.op_tipoper,120::int4) or int4eq(NEW.op_tipoper,130::int4)) THEN 
    update operaciones set op_estado=999 where op_id=NEW.op_id+1;
    delete from retiros where ret_idopera=NEW.op_id;
    delete from volegr where vole_idoper=NEW.op_id;
    delete from confactur1 where cfc1_idoper=NEW.op_id;
    delete from confactur where cfc_idoper=NEW.op_id;

    delete from subitem where sitem_idoper=NEW.op_id+1;
    delete from item where item_idoper=NEW.op_id+1;
    delete from voling where vol_idoper=NEW.op_id+1;
    delete from confactur1 where cfc1_idoper=NEW.op_id+1;
    delete from confactur where cfc_idoper=NEW.op_id+1;
    end if;
end if;

if(int2eq(NEW.op_estado,101::int2) and int2eq(OLD.op_estado,1::int2)) THEN 
    if(int4lt(NEW.op_tipoper,100::int4))  THEN -- es ingreso
	    trans:=valmer_unifun(NEW.op_id,1::int2,1::int2);
	    if int4ne(NEW.op_deposito,nacional) and int4ne(NEW.op_deposito,nacional2) then
		aux_texto:='Declaracion SIM - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=34;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,34::int4,1::numeric,tarifb(NEW.op_indirecto,34,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,34,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
		aux_texto:='Gestion SIM - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=17;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,17::int4,1::numeric,tarifb(NEW.op_indirecto,17,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,17,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
		aux_texto:='Ingreso de Mercaderia - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=32;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,32::int4,1::numeric,tarifb(NEW.op_indirecto,32,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,32,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    else
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,32::int4,1::numeric,tarifb(NEW.op_directo,32,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,32,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
		aux_texto:='Digitalizacion Legajo - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=114;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,114::int4,1::numeric,tarifb(NEW.op_indirecto,114,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,114,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;

		aux_texto:='Bonificacion hasta 31-07-2020 - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select tari_imp_dolar into tarifa from tarifas where tari_usuario=NEW.op_indirecto and tari_idcontr>0 and tari_idart=122 and now()::date between tari_fdesde and tari_fhasta order by 1 limit 1;
		if tarifa is not null and tarifa!=0 then
		    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=122;
		    if not found then
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,122::int4,1::numeric,tarifa,tarifa,NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    else
			update confactur1 set cfc1_fecha=NEW.op_fechain, cfc1_precio=tarifa, cfc1_importe=tarifa, cfc1_leyen=aux_texto, cfc1_anio=date_part('year',NEW.op_fechain), cfc1_mes=date_part('month',NEW.op_fechain), cfc1_indirecto=NEW.op_indirecto, cfc1_usuario=NEW.op_indirecto where cfc1_id=existe;
		    END IF;
		END IF;

		if(int4eq(NEW.op_canal,4::int4)) then
		    aux_texto:='Rampa de Verificacion - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
		    if not found then
			if(int4eq(NEW.op_directo,1::int4)) THEN
			    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
			else
			    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
			END IF;
		    END IF;
		END IF;
	    END IF;
	    update voling set vol_estado=NEW.op_estado,vol_fechain=NEW.op_fechain,vol_ultfac=NEW.op_fechain where vol_idoper=NEW.op_id;
	else                                  -- es egreso     
	    if(int4eq(NEW.op_canal,4::int4) and int4ne(NEW.op_deposito,nacional) and int4ne(NEW.op_deposito,nacional2)) then
		aux_texto:='Rampa de Verificacion - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    else
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
	    END IF;
	    trans:=valmer_unifun(NEW.op_id,2::int2,1::int2);
	    trans:=cantcomp_cantret(NEW.op_id,1::int2);
	    update volegr set vole_estado=NEW.op_estado where vole_idoper=NEW.op_id;
	END IF;
END IF;

if(int2eq(NEW.op_estado,101::int2) and int2eq(OLD.op_estado,11::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	update voling set vol_estado=NEW.op_estado,vol_fechain=NEW.op_fechain,vol_ultfac=NEW.op_fechain where vol_idoper=NEW.op_id;
	if int4ne(NEW.op_deposito,nacional) and int4ne(NEW.op_deposito,nacional2) then
	    aux_texto:='Declaracion SIM - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=34;
	    if not found then
		if(int4eq(NEW.op_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,34::int4,1::numeric,tarifb(NEW.op_indirecto,34,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,34,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		END IF;
	    END IF;
	    aux_texto:='Gestion SIM - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=17;
	    if not found then
		if(int4eq(NEW.op_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,17::int4,1::numeric,tarifb(NEW.op_indirecto,17,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,17,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		END IF;
	    END IF;
	    aux_texto:='Ingreso de Mercaderia - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=32;
	    if not found then
		if(int4eq(NEW.op_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,32::int4,1::numeric,tarifb(NEW.op_indirecto,32,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,32,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		else
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,32::int4,1::numeric,tarifb(NEW.op_directo,32,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,32,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		END IF;
	    END IF;
		aux_texto:='Digitalizacion Legajo - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=114;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,114::int4,1::numeric,tarifb(NEW.op_indirecto,114,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,114,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
	    if(int4eq(NEW.op_canal,4::int4)) then
		aux_texto:='Rampa de Verificacion - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    else
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
	    END IF;
	END IF;
    else    -- es egreso     
	    if(int4eq(NEW.op_canal,4::int4) and int4ne(NEW.op_deposito,nacional) and int4ne(NEW.op_deposito,nacional2)) then
		aux_texto:='Rampa de Verificacion - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
		select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
		if not found then
		    if(int4eq(NEW.op_directo,1::int4)) THEN
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    else
			insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		    END IF;
		END IF;
	    END IF;
	    update volegr set vole_estado=NEW.op_estado where vole_idoper=NEW.op_id;
    END IF;
END IF;


if(int2eq(NEW.op_estado,1::int2) and int2eq(OLD.op_estado,11::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	    update voling set vol_estado=NEW.op_estado where vol_idoper=NEW.op_id;
	else                                  -- es egreso     
	    update volegr set vole_estado=NEW.op_estado,vole_fechaeg=NEW.op_fecha_close where vole_idoper=NEW.op_id;
	END IF;
END IF;

if(int2eq(NEW.op_estado,1::int2) and int2eq(OLD.op_estado,101::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=34;
	    if found then
		delete from confactur1 where cfc1_id=existe;
	    END IF;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=17;
	    if found then
		delete from confactur1 where cfc1_id=existe;
	    END IF;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=32;
	    if found then
		delete from confactur1 where cfc1_id=existe;
	    END IF;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
	    if found then
		delete from confactur1 where cfc1_id=existe;
	    END IF;
	    trans:=valmer_unifun(NEW.op_id,1::int2,2::int2);
	    update voling set vol_estado=NEW.op_estado where vol_idoper=NEW.op_id;
	else                                  -- es egreso     
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
	    if found then
		delete from confactur1 where cfc1_id=existe;
	    END IF;
	    update volegr set vole_estado=NEW.op_estado,vole_fechaeg=NEW.op_fechain where vole_idoper=NEW.op_id;
	    trans:=valmer_unifun(NEW.op_id,2::int2,2::int2);
	    trans:=cantcomp_cantret(NEW.op_id,2::int2);
	END IF;
END IF;

if (int4lt(NEW.op_tipoper,100::int4) and date_ne(OLD.op_fechain,NEW.op_fechain)) THEN 
    update voling set vol_fechain=NEW.op_fechain where vol_idoper=NEW.op_id;
    update confactur1 set cfc1_fecha=NEW.op_fechain,cfc1_anio=date_part('year',NEW.op_fechain),cfc1_mes=date_part('month',NEW.op_fechain) where cfc1_idoper=NEW.op_id;
  else
    update volegr set vole_fechaeg=NEW.op_fechain where vole_idoper=NEW.op_id;
END IF;


if(int2eq(NEW.op_estado,101::int2) and int2eq(OLD.op_estado,101::int2)) THEN 
	if (int4ne(NEW.op_directo,OLD.op_directo) or
	    int4ne(NEW.op_indirecto,OLD.op_indirecto) or
	    int4ne(NEW.op_tipoper,OLD.op_tipoper) or
	    int4ne(NEW.op_consig,OLD.op_consig) or
	    numeric_ne(NEW.op_importe,OLD.op_importe) or
	    bpcharne(NEW.op_compbte,OLD.op_compbte))  then
		aux_texto:='El usuario autorizado ha modificado la operacion publicada '||NEW.op_id||	' de importe '||OLD.op_importe||' a importe '||NEW.op_importe||' de directo '||OLD.op_directo||' a directo '||NEW.op_directo||' de indirecto '||OLD.op_indirecto||' a indirecto '||NEW.op_indirecto||' de tipoper '||OLD.op_tipoper||' a tipoper '||NEW.op_tipoper||' de compbte '||OLD.op_compbte||' a compbte '||NEW.op_compbte||' de consignatario '||OLD.op_consig||' a consiganatario '||NEW.op_consig||' el dia de hoy';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
		if (int4ne(NEW.op_directo,OLD.op_directo) or int4ne(NEW.op_indirecto,OLD.op_indirecto) or bpcharne(NEW.op_compbte,OLD.op_compbte))   then
		    update voling set vol_compbte=NEW.op_compbte,vol_directo=NEW.op_directo,vol_indirecto=NEW.op_indirecto where vol_idoper=NEW.op_id;
		    update volegr set vole_compbte=NEW.op_compbte,vole_directo=NEW.op_directo,vole_indirecto=NEW.op_indirecto where vole_idoper=NEW.op_id;
		END IF;
	END IF;
	if(int4ne(NEW.op_canal,OLD.op_canal) and int4eq(NEW.op_canal,4) and int4ne(NEW.op_deposito,nacional) and int4ne(NEW.op_deposito,nacional2)) then
	    aux_texto:='Rampa de Verificacion - ' || substr(nomusu(NEW.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(NEW.op_tipoper),1,3) || '-'|| NEW.op_nrotaldir;
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.op_id and cfc1_idart=18;
	    if not found then
		if(int4eq(NEW.op_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_indirecto,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_indirecto,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		else
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.op_directo,NEW.op_fechain,18::int4,1::numeric,tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),tarifb(NEW.op_directo,18,0::numeric,NEW.op_id,NEW.op_fechain),NEW.op_id,aux_texto,1::int2,date_part('year',NEW.op_fechain),date_part('month',NEW.op_fechain),NEW.op_indirecto);
		END IF;
	    END IF;
	END IF;
END IF;

if(int2ne(NEW.op_moneda,OLD.op_moneda)) THEN 
    if(numeric_ne(NEW.op_tipo_cambio,0)) then
	update operaciones set op_impdolar=op_importe  * NEW.op_tipo_cambio where op_id=NEW.op_id;
	update subitem set sitem_imp_dolar=sitem_importe * NEW.op_tipo_cambio where sitem_idoper=NEW.op_id;
      else
	update subitem set sitem_imp_dolar=sitem_importe * ult_cotiz(NEW.op_moneda) where sitem_idoper=NEW.op_id;
	update operaciones set op_impdolar=op_importe * ult_cotiz(NEW.op_moneda) where op_id=NEW.op_id;
    END IF;
    update item set item_moneda=NEW.op_moneda where item_idoper=NEW.op_id;
END IF;

if(bpcharne(NEW.op_compbte,OLD.op_compbte)) THEN 
    update subitem set sitem_compbte=NEW.op_compbte where sitem_idoper=NEW.op_id;
    update voling set vol_compbte=NEW.op_compbte where vol_idoper=NEW.op_id;
    update volegr set vole_compbte=NEW.op_compbte,vole_fechaeg=NEW.op_fechain where vole_idoper=NEW.op_id;
END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_operaciones() OWNER TO zona;

--
-- Name: f_au_opervehi(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_opervehi() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
indir		integer;
elid		integer;
concepto	integer;
tarifa		numeric;
comp		character varying(16);
notid		int4;
existe		int4;
nacional	int4;
nacional2	int4;
BEGIN

nacional:=6;
nacional2:=5;

if(int2eq(NEW.opv_est_camion,50::int2) and int2ne(OLD.opv_est_camion,50::int2)) THEN 

	if(int4gt(NEW.opv_idoper,0) and int4ne(depositop(NEW.opv_idoper),nacional) and int4ne(depositop(NEW.opv_idoper),nacional2)) then
	    select cfc1_id into existe from confactur1 where cfc1_idoperv=NEW.opv_id;
	    if not found then
		aux_texto:='Servicio de Balanza - ' || substr(nomusu(indirectodeop(NEW.opv_idoper)),1,25) || ' / ' || substr(traigo_simbtipoper(tipoperdeop(NEW.opv_idoper)),1,3) || '-'|| nrotaldiroper(NEW.opv_idoper);
		if(int4eq(directodeop(NEW.opv_idoper),1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto,cfc1_ticket,cfc1_idoperv) 
			values (indirectodeop(NEW.opv_idoper),NEW.opv_fecha_egr,40::int4,1::numeric,tarifb(indirectodeop(NEW.opv_idoper),40,0::numeric,NEW.opv_idoper,date(NEW.opv_fecha_egr)),tarifb(indirectodeop(NEW.opv_idoper),40,0::numeric,NEW.opv_idoper,date(NEW.opv_fecha_egr)),NEW.opv_idoper,aux_texto,1::int2,date_part('year',NEW.opv_fecha_egr),date_part('month',NEW.opv_fecha_egr),indirectodeop(NEW.opv_idoper),NEW.opv_nro_ticket,NEW.opv_id);
		  else
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto,cfc1_ticket,cfc1_idoperv) 
			values (directodeop(NEW.opv_idoper),NEW.opv_fecha_egr,40::int4,1::numeric,tarifb(directodeop(NEW.opv_idoper),40,0::numeric,NEW.opv_idoper,date(NEW.opv_fecha_egr)),tarifb(directodeop(NEW.opv_idoper),40,0::numeric,NEW.opv_idoper,date(NEW.opv_fecha_egr)),NEW.opv_idoper,aux_texto,1::int2,date_part('year',NEW.opv_fecha_egr),date_part('month',NEW.opv_fecha_egr),indirectodeop(NEW.opv_idoper),NEW.opv_nro_ticket,NEW.opv_id);
		END IF;
	    END IF;
	    update volegr set vole_fechaeg=NEW.opv_fecha_egr where vole_idoper=NEW.opv_idoper;
	else
	    if(int4ne(depositop(NEW.opv_idoper),nacional) and int4ne(depositop(NEW.opv_idoper),nacional2)) then
		select cfc1_id into existe from confactur1 where cfc1_idoperv=NEW.opv_id;
		if not found then
		    elid:=NEW.opv_idoper*-1;
		    select i_indirecto,i_compbte into indir,comp from ingzpa where i_id=elid;
		    elid:=NEW.opv_idoper;
		    aux_texto:='Ingreso ZPA - Servicio de Balanza - ' || substr(nomusu(indir),1,25) || ' / ' || comp;
		    concepto:=40;
		    select tarifb(indir,concepto,0::numeric,elid,date(NEW.opv_fecha_egr)) into tarifa;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto,cfc1_ticket,cfc1_idoperv) values (indir,NEW.opv_fecha_ing::date,concepto,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.opv_fecha_ing),date_part('month',NEW.opv_fecha_ing),indir,NEW.opv_nro_ticket,NEW.opv_id);
		    aux_texto:='Egreso ZPA - Servicio de Balanza - ' || substr(nomusu(indir),1,25) || ' / ' || comp;
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto,cfc1_ticket,cfc1_idoperv) values (indir,NEW.opv_fecha_egr::date,concepto,1::numeric,tarifa,tarifa,elid,aux_texto,1::int2,date_part('year',NEW.opv_fecha_egr),date_part('month',NEW.opv_fecha_egr),indir,NEW.opv_nro_ticket,NEW.opv_id);
		END IF;
	    END IF;
	END IF;
END IF;

if(int2ne(NEW.opv_est_camion,50::int2) and int2eq(OLD.opv_est_camion,50::int2)) THEN 
	delete from confactur1 where cfc1_idoperv=NEW.opv_id;
END IF;


if(int2eq(OLD.opv_est_camion,50::int2) or (int2eq(OLD.opv_est_camion,2::int2) and int2eq(NEW.opv_est_camion,2::int2)) or (int2eq(OLD.opv_est_camion,1::int2) and int2eq(NEW.opv_est_camion,1::int2))) THEN 

    if (int4ne(NEW.opv_idoper,OLD.opv_idoper)) then
	    update contene set cont_idoper=NEW.opv_idoper where cont_idopv=OLD.opv_id;
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia un la operacion '||OLD.opv_idoper||' por la operacion '||NEW.opv_idoper||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(81,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_pat_chasis,OLD.opv_pat_chasis)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como chasis '||OLD.opv_pat_chasis||' por el chasis '||NEW.opv_pat_chasis||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(82,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_pat_tractor,OLD.opv_pat_tractor)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como tractor '||OLD.opv_pat_tractor||' por el tractor '||NEW.opv_pat_tractor||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(83,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_chofer,OLD.opv_chofer)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como chofer '||OLD.opv_chofer||' por el chofer '||NEW.opv_chofer||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(84,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_pat_chasis,OLD.opv_pat_chasis)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como chasis '||OLD.opv_pat_chasis||' por el chasis '||NEW.opv_pat_chasis||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(85,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_codtd,OLD.opv_codtd)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como tipo de documento '||OLD.opv_codtd||' por el tipo de documento '||NEW.opv_codtd||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(86,OLD.opv_idoper,aux_texto);
        end if;

    if (int2ne(NEW.opv_est_camion,OLD.opv_est_camion)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como estado '||OLD.opv_est_camion||' por el estado '||NEW.opv_est_camion||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(87,OLD.opv_idoper,aux_texto);
        end if;

    if (int4ne(NEW.opv_nro_ticket,OLD.opv_nro_ticket)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como ticket '||OLD.opv_nro_ticket||' por el ticket '||NEW.opv_nro_ticket||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(88,OLD.opv_idoper,aux_texto);
        end if;

    if (bpcharne(NEW.opv_pesa,OLD.opv_pesa)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia pesa '||OLD.opv_pesa||' por pesa '||NEW.opv_pesa||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(89,OLD.opv_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.opv_peso_ing,OLD.opv_peso_ing)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como peso ing '||OLD.opv_peso_ing||' por el peso '||NEW.opv_peso_ing||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(90,OLD.opv_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.opv_peso_egr,OLD.opv_peso_egr)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como peso egr '||OLD.opv_peso_egr||' por el peso '||NEW.opv_peso_egr||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(91,OLD.opv_idoper,aux_texto);
        end if;

    if (timestamp_ne(NEW.opv_fecha_egr,OLD.opv_fecha_egr)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como fecha egr '||OLD.opv_fecha_egr||' por la fecha '||NEW.opv_fecha_egr||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(92,OLD.opv_idoper,aux_texto);
        end if;

    if (timestamp_ne(NEW.opv_fecha_ing,OLD.opv_fecha_ing)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como fecha ing '||OLD.opv_fecha_ing||' por la fecha '||NEW.opv_fecha_ing||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(93,OLD.opv_idoper,aux_texto);
        end if;


    if (int8ne(NEW.opv_nro_doc,OLD.opv_nro_doc)) then
	    aux_texto:='El usuario autorizado ha modificado el vehiculo '||OLD.opv_id ||' de la operacion publicada '||OLD.opv_idoper||' que tenia como doc '||OLD.opv_nro_doc||' por el doc '||NEW.opv_nro_doc||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(94,OLD.opv_idoper,aux_texto);
        end if;

END IF;


RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_opervehi() OWNER TO zona;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	update ctes set cte_nombre=NEW.prov_nombre where cte_codigo=OLD.prov_id and cte_codemp=OLD.prov_codemp and cte_tipcta=eval_funcion(valvaramb(NEW.prov_codemp,ptovdefault(NEW.prov_codemp),'TIPCTADXC'));
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO zona;

--
-- Name: f_au_retiros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_retiros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
    BEGIN

	if(estadop(NEW.ret_idopera)<100 and numeric_ne(NEW.ret_cantidad,OLD.ret_cantidad)) then
    	    update subitem set sitem_cantcomp=sitem_cantcomp + NEW.ret_cantidad - OLD.ret_cantidad where sitem_id=NEW.ret_idsitem;
	end if;

	if(int2gt(estadop(NEW.ret_idopera),100::int2))then

	    if(numeric_ne(NEW.ret_cantidad,OLD.ret_cantidad)) then
    		update subitem set sitem_cantret=sitem_cantret + NEW.ret_cantidad - OLD.ret_cantidad where sitem_id=NEW.ret_idsitem;
		aux_texto:='El usuario autorizado ha modificado la cantidad del retiro de la operacion publicada '||NEW.ret_idopera||' cambiandola de '||OLD.ret_cantidad ||' a '||NEW.ret_cantidad ||' el dia de hoy';
		insert into noticias(not_tipo,not_numero,not_texto)values(51,NEW.ret_idopera,aux_texto);
	    end if;

	    if(int4ne(NEW.ret_idsitem,OLD.ret_idsitem)) then
    		update subitem set sitem_cantret=sitem_cantret - OLD.ret_cantidad where sitem_id=OLD.ret_idsitem;
    		update subitem set sitem_cantret=sitem_cantret + NEW.ret_cantidad where sitem_id=NEW.ret_idsitem;
		aux_texto:='El usuario autorizado ha modificado el articulo del retiro de la operacion publicada '||NEW.ret_idopera||' cambiandolo del articulo '||OLD.ret_idsitem ||' a '||NEW.ret_idsitem ||' el dia de hoy';
		insert into noticias(not_tipo,not_numero,not_texto)values(52,NEW.ret_idopera,aux_texto);
	    end if;

	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_retiros() OWNER TO zona;

--
-- Name: f_au_seguros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_seguros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN

--cambio el importe pero siempre en estado 1 (vigente)
    if(numeric_ne(OLD.seg_importei,NEW.seg_importei)) then
	if(int2eq(NEW.seg_estado,OLD.seg_estado)) then 
	    update unifun set unif_seguro=unif_seguro - OLD.seg_impmoncte where unif_codigo=OLD.seg_unifun;
	    update unifun set unif_seguro=unif_seguro + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;
	END IF;
    END IF;

-- pasa de estado 1 (vigente) a 2 (inactivo o anulado)
    if(int2eq(OLD.seg_estado,1::int2) and int2ne(NEW.seg_estado,1::int2)) then 
	    update unifun set unif_seguro=unif_seguro - OLD.seg_impmoncte where unif_codigo=NEW.seg_unifun;
    END IF;

-- pasa de estado  2 (inactivo o anulado) a 1 (vigente)
    if(int2ne(OLD.seg_estado,1::int2)) then
	if(int2eq(NEW.seg_estado,1::int2)) then 
	    update unifun set unif_seguro=unif_seguro + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;
        END IF;
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_seguros() OWNER TO zona;

--
-- Name: f_au_sucursales(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_sucursales() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if (bpcharne(NEW.suc_direccl,OLD.suc_direccl) or OLD.suc_direccl is NULL) THEN 
	update sucursal set sucu_direccl=NEW.suc_direccl where sucu_cliente=idcli(1,OLD.suc_cliente);
	update sucursal set sucu_direcc=NEW.suc_direccl where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;


    if (bpcharne(NEW.suc_localil,OLD.suc_localil) or OLD.suc_localil is NULL) THEN 
	update sucursal set sucu_localil=NEW.suc_localil where sucu_cliente=idcli(1,OLD.suc_cliente);
	update sucursal set sucu_locali=NEW.suc_localil where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (bpcharne(NEW.suc_codposl,OLD.suc_codposl) or OLD.suc_codposl is NULL) THEN 
	update sucursal set sucu_codposl=NEW.suc_codposl where sucu_cliente=idcli(1,OLD.suc_cliente);
	update sucursal set sucu_codpos=NEW.suc_codposl where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (int4ne(NEW.suc_codprovl,OLD.suc_codprovl) or OLD.suc_codprovl is NULL) THEN 
	update sucursal set sucu_codprovl=NEW.suc_codprovl where sucu_cliente=idcli(1,OLD.suc_cliente);
	update sucursal set sucu_provin=NEW.suc_codprovl where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (int2ne(NEW.suc_paisl,OLD.suc_paisl) or OLD.suc_paisl is NULL) THEN 
	update sucursal set sucu_paisl=NEW.suc_paisl where sucu_cliente=idcli(1,OLD.suc_cliente);
	update sucursal set sucu_pais=NEW.suc_paisl where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;


    if (bpcharne(NEW.suc_direcc,OLD.suc_direcc) or OLD.suc_direcc is NULL) THEN 
	update sucursal set sucu_direcc=NEW.suc_direcc where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (bpcharne(NEW.suc_locali,OLD.suc_locali) or OLD.suc_locali is NULL) THEN 
	update sucursal set sucu_locali=NEW.suc_locali where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (bpcharne(NEW.suc_codpos,OLD.suc_codpos) or OLD.suc_codpos is NULL) THEN 
	update sucursal set sucu_codpos=NEW.suc_codpos where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (int4ne(NEW.suc_codprov,OLD.suc_codprov) or OLD.suc_codprov is NULL) THEN 
	update sucursal set sucu_provin=NEW.suc_codprov where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;

    if (int2ne(NEW.suc_pais,OLD.suc_pais) or OLD.suc_pais is NULL) THEN 
	update sucursal set sucu_pais=NEW.suc_pais where sucu_cliente=idcli(1,OLD.suc_cliente);
	END IF;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_sucursales() OWNER TO zona;

--
-- Name: f_au_unifun(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_unifun() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int2ne(NEW.unif_codigo,OLD.unif_codigo)) THEN 
	update wsubitem set wsitem_deposito=NEW.unif_codigo where wsitem_deposito=OLD.unif_codigo;
	update subitem set sitem_deposito=NEW.unif_codigo where sitem_deposito=OLD.unif_codigo;
	update operaciones set op_deposito=NEW.unif_codigo where op_deposito=OLD.unif_codigo;
	update woperaciones set wop_deposito=NEW.unif_codigo where wop_deposito=OLD.unif_codigo;
	update subitemd set sitemd_deposito=NEW.unif_codigo where sitemd_deposito=OLD.unif_codigo;
	update stock set stk_deposito=NEW.unif_codigo where stk_deposito=OLD.unif_codigo;
	update inhabilit set inh_deposito=NEW.unif_codigo where inh_deposito=OLD.unif_codigo;
	update intotal set int_deposito=NEW.unif_codigo where int_deposito='OLD.unif_codigo';
	update contratos set contr_unifun=NEW.unif_codigo where contr_unifun=OLD.unif_codigo;
	update seguros set seg_unifun=NEW.unif_codigo where seg_unifun=OLD.unif_codigo;
    END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_unifun() OWNER TO zona;

--
-- Name: f_au_usuarios(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_usuarios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.usu_nombre,OLD.usu_nombre) THEN 
	update clientes set cli_nombre=NEW.usu_nombre where cli_codigo=OLD.usu_codigo and cli_codemp=1;
	update sucursales set suc_nombre=NEW.usu_nombre where suc_cliente=OLD.usu_codigo;
	END IF;

    if bpcharne(NEW.usu_nrocuit,OLD.usu_nrocuit) THEN 
	update clientes set cli_nrcuit=NEW.usu_nrocuit where cli_codigo=OLD.usu_codigo and cli_codemp=1;
	END IF;

    if bpcharne(NEW.usu_fantasy,OLD.usu_fantasy) THEN 
	update clientes set cli_fantasy=NEW.usu_fantasy where cli_codigo=OLD.usu_codigo and cli_codemp=1;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_usuarios() OWNER TO zona;

--
-- Name: f_au_volegr(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_volegr() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE

aux_texto 	text;
tipoper		int4;
nrotaldir	int4;
existe		int4;
existee		int4;
nacional	int4;
nacional2	int4;
idart		int4;
tarifa		numeric;

BEGIN

nacional:=6;
nacional2:=5;

if (int4ne(depositop(NEW.vole_idoperi),nacional) and int4ne(depositop(NEW.vole_idoperi),nacional2) and int4eq(NEW.vole_factu,OLD.vole_factu)) then
    select op_tipoper, op_nrotaldir into tipoper,nrotaldir from operaciones where op_id=NEW.vole_idoper;

    --Obtengo el articulo, si es paletizado => 6, si es no paletizado => 1
    if(int4eq(NEW.vole_paletiz,1::int4)) THEN
	idart:=6;
    else
	idart:=1;
    end if;

    if(int4eq(NEW.vole_directo,1::int4)) THEN
	if(int4eq(NEW.vole_indirecto,113::int4)) THEN
	    tarifa:=5;
	else
	    select tariman(NEW.vole_indirecto,idart,NEW.vole_cantret::numeric,NEW.vole_fechaeg) into tarifa;
	end if;
    else
	select tariman(NEW.vole_directo,idart,NEW.vole_cantret::numeric,NEW.vole_fechaeg) into tarifa;
    END IF;

    aux_texto:='Man. carga ' || substr(nomusu(NEW.vole_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(tipoper),1,3) || '-'|| nrotaldir;

    if(numeric_ne(NEW.vole_cantret,0) or NEW.vole_paletiz in (1,2)) THEN
    --LA NUEVA CANTIDAD ES DISTINTA A 0 O EL PALETIZADO ES 1 o 2
	select cfc1_id into existee from confactur1 where cfc1_idoper=NEW.vole_idoper and cfc1_idart=idart and cfc1_estado=50;
	if not found then
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.vole_idoper and cfc1_idart=idart;
	    if not found then
		if(int4eq(NEW.vole_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.vole_indirecto,NEW.vole_fechaeg,idart,1::numeric,tarifa*NEW.vole_cantret,tarifa*NEW.vole_cantret,NEW.vole_idoper,aux_texto,1::int2,date_part('year',NEW.vole_fechaeg),date_part('month',NEW.vole_fechaeg),NEW.vole_indirecto);
		else
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.vole_directo,NEW.vole_fechaeg,idart,1::numeric,tarifa*NEW.vole_cantret,tarifa*NEW.vole_cantret,NEW.vole_idoper,aux_texto,1::int2,date_part('year',NEW.vole_fechaeg),date_part('month',NEW.vole_fechaeg),NEW.vole_indirecto);
		END IF;
	    else
		if(int4eq(NEW.vole_directo,1::int4)) THEN
		    update confactur1 set cfc1_usuario=NEW.vole_indirecto,cfc1_fecha=NEW.vole_fechaeg,cfc1_idart=idart,cfc1_canti=1::numeric,cfc1_precio=tarifa*NEW.vole_cantret,cfc1_importe=tarifa*NEW.vole_cantret,cfc1_idoper=NEW.vole_idoper,cfc1_leyen=aux_texto,cfc1_estado=1::int2,cfc1_anio=date_part('year',NEW.vole_fechaeg),cfc1_mes=date_part('month',NEW.vole_fechaeg),cfc1_indirecto=NEW.vole_indirecto where cfc1_id=existe;
		else
		    update confactur1 set cfc1_usuario=NEW.vole_directo,cfc1_fecha=NEW.vole_fechaeg,cfc1_idart=idart,cfc1_canti=1::numeric,cfc1_precio=tarifa*NEW.vole_cantret,cfc1_importe=tarifa*NEW.vole_cantret,cfc1_idoper=NEW.vole_idoper,cfc1_leyen=aux_texto,cfc1_estado=1::int2,cfc1_anio=date_part('year',NEW.vole_fechaeg),cfc1_mes=date_part('month',NEW.vole_fechaeg),cfc1_indirecto=NEW.vole_indirecto where cfc1_id=existe;
		END IF;
	    END IF;
	END IF;
    END IF;
END IF;


RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_volegr() OWNER TO zona;

--
-- Name: f_au_voling(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_voling() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE

aux_texto 	text;
tipoper		int4;
nrotaldir	int4;
existe		int4;
existee		int4;
nacional	int4;
nacional2	int4;
idart		int4;
tarifa		numeric;

BEGIN

nacional:=6;
nacional2:=5;

if (int4ne(depositop(NEW.vol_idoper),nacional) and int4ne(depositop(NEW.vol_idoper),nacional2) and int4eq(NEW.vol_factu,OLD.vol_factu)) then

    select op_tipoper, op_nrotaldir into tipoper,nrotaldir from operaciones where op_id=NEW.vol_idoper;

    --Obtengo el articulo, si es paletizado => 6, si es no paletizado => 1
    if(int4eq(NEW.vol_paletiz,1::int4)) THEN
	idart:=6;
    else
	idart:=1;
    end if;

    if(int4eq(NEW.vol_directo,1::int4)) THEN
	select tariman(NEW.vol_indirecto,idart,NEW.vol_canting::numeric,NEW.vol_fechain) into tarifa;
    else
	select tariman(NEW.vol_directo,idart,NEW.vol_canting::numeric,NEW.vol_fechain) into tarifa;
    END IF;

    aux_texto:='Man. carga ' || substr(nomusu(NEW.vol_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(tipoper),1,3) || '-'|| nrotaldir;

    if(numeric_ne(NEW.vol_canting,0) or NEW.vol_paletiz in (1,2)) THEN
    --LA NUEVA CANTIDAD ES DISTINTA A 0 O EL PALETIZADO ES 1 o 2
	select cfc1_id into existee from confactur1 where cfc1_idoper=NEW.vol_idoper and cfc1_idart=idart and cfc1_estado=50;
	if not found then
	    select cfc1_id into existe from confactur1 where cfc1_idoper=NEW.vol_idoper and cfc1_idart=idart;
	    if not found then
		if(int4eq(NEW.vol_directo,1::int4)) THEN
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.vol_indirecto,NEW.vol_fechain,idart,1::numeric,tarifa*NEW.vol_canting,tarifa*NEW.vol_canting,NEW.vol_idoper,aux_texto,1::int2,date_part('year',NEW.vol_fechain),date_part('month',NEW.vol_fechain),NEW.vol_indirecto);
		else
		    insert into confactur1 (cfc1_usuario,cfc1_fecha,cfc1_idart,cfc1_canti,cfc1_precio,cfc1_importe,cfc1_idoper,cfc1_leyen,cfc1_estado,cfc1_anio,cfc1_mes,cfc1_indirecto) values (NEW.vol_directo,NEW.vol_fechain,idart,1::numeric,tarifa*NEW.vol_canting,tarifa*NEW.vol_canting,NEW.vol_idoper,aux_texto,1::int2,date_part('year',NEW.vol_fechain),date_part('month',NEW.vol_fechain),NEW.vol_indirecto);
		END IF;
	    else
		if(int4eq(NEW.vol_directo,1::int4)) THEN
		    update confactur1 set cfc1_usuario=NEW.vol_indirecto,cfc1_fecha=NEW.vol_fechain,cfc1_idart=idart,cfc1_canti=1::numeric,cfc1_precio=tarifa*NEW.vol_canting,cfc1_importe=tarifa*NEW.vol_canting,cfc1_idoper=NEW.vol_idoper,cfc1_leyen=aux_texto,cfc1_estado=1::int2,cfc1_anio=date_part('year',NEW.vol_fechain),cfc1_mes=date_part('month',NEW.vol_fechain),cfc1_indirecto=NEW.vol_indirecto where cfc1_id=existe;
		else
		    update confactur1 set cfc1_usuario=NEW.vol_directo,cfc1_fecha=NEW.vol_fechain,cfc1_idart=idart,cfc1_canti=1::numeric,cfc1_precio=tarifa*NEW.vol_canting,cfc1_importe=tarifa*NEW.vol_canting,cfc1_idoper=NEW.vol_idoper,cfc1_leyen=aux_texto,cfc1_estado=1::int2,cfc1_anio=date_part('year',NEW.vol_fechain),cfc1_mes=date_part('month',NEW.vol_fechain),cfc1_indirecto=NEW.vol_indirecto where cfc1_id=existe;
		END IF;
	    END IF;
	END IF;
    END IF;
END IF;


if(int4eq(NEW.vol_factu,2::int4) and int4ne(NEW.vol_factu,OLD.vol_factu)) then
    update volegr set vole_factu=2 where vole_idoperi=NEW.vol_idoper;
END IF;

if(int4eq(NEW.vol_factu,3::int4) and int4ne(NEW.vol_factu,OLD.vol_factu)) then
    update volegr set vole_factu=3 where vole_idoperi=NEW.vol_idoper;
END IF;


RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_voling() OWNER TO zona;

--
-- Name: f_au_woperaciones(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_woperaciones() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
BEGIN

if(int2ne(NEW.wop_estado,OLD.wop_estado)) THEN 
    update wret2 set wret2_estado=NEW.wop_estado where wret2_idopera=NEW.wop_id;
end if;

if(int2eq(NEW.wop_estado,999::int2)) THEN 
    delete from wret2 where wret2_idopera=NEW.wop_id;
end if;


RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_woperaciones() OWNER TO zona;

--
-- Name: f_au_wret2(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_wret2() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
    BEGIN

	if(numeric_ne(NEW.wret2_cantidad,OLD.wret2_cantidad)) then
	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw + NEW.wret2_cantidad - OLD.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
	end if;

	if(int4ne(NEW.wret2_idsitem,OLD.wret2_idsitem)) then
    	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw - OLD.wret2_cantidad where wsitem_id=OLD.wret2_idsitem;
    	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw + NEW.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_wret2() OWNER TO zona;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

----------------------------  CHEQUES ---------------------------------------    
	
    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	END IF;
    END IF;


    select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
    if found then
	update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
    END IF;

----------------------------  MONEX ---------------------------------------    

    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
    if found then
	update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
    END IF;


----------------------------  DOCUM ---------------------------------------    

    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
    if found then
	update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
    END IF;

    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO zona;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from emiti where int4eq(emi_idastoh,OLD.ash_id);
--    delete from compliq where int4eq(cliq_idastoh,OLD.ash_id);
    delete from compra where int4eq(cpra_idastoh,OLD.ash_id);
    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO zona;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO zona;

--
-- Name: f_bd_subitem(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_subitem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
salidas		numeric;

BEGIN

-- if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
--    if booleq(existe_modopub(OLD.sitem_idoper),'f') THEN 
--	    RAISE EXCEPTION  'USTED NO ESTA AUTORIZADO A MODIFICAR UNA OPERACION PUBLICADA';
--	else
--	    update operaciones set op_estado=102 where op_id=OLD.sitem_idoper;
--    end if;
-- end if;

-- if int2eq(estadop(OLD.sitem_idoper),1::int2) THEN
--    aux_texto:='Ha modificado un subitem de la operacion '||OLD.sitem_idoper||'  debera corroborar nuevamente si se puede oficializar';
--    insert into noticias(not_tipo,not_numero,not_texto)values(1,OLD.sitem_idoper,aux_texto);
--    update operaciones set op_estado=11 where op_id=OLD.sitem_idoper;
-- end if;

if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
    salidas:=OLD.sitem_cantret+OLD.sitem_cantcomp;
    if(numeric_ne(salidas,0::numeric)) then
        RAISE EXCEPTION  'NO SE PUEDE BORRAR ESTE SUBITEM POR EXISTIR RETIROS O REEXPEDICIONES QUE AFECTAN AL MISMO';
    END IF;
END IF;
RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_subitem() OWNER TO zona;

--
-- Name: f_bi_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_contratos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    ale 		int2;
    usua 		int4;
    BEGIN
    select unif_codigo into ale from unifun where unif_codigo=NEW.contr_unifun;
    if not found then
	NEW.contr_unifun:=0;
    end if;

    select usu_codigo into usua from usuarios where usu_codigo=NEW.contr_locador;
    if not found then
	NEW.contr_locador:=1;
    end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bi_contratos() OWNER TO zona;

--
-- Name: f_bi_item(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_item() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	usu1 		int4;
	usu2 		int4;
	aux_texto 	text;
BEGIN

--	NEW.item_item=cantitem(NEW.item_idoper)+1;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bi_item() OWNER TO zona;

--
-- Name: f_bi_lecting(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_lecting() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    BEGIN
	delete from lecting where let_estado=1 and let_tarje=NEW.let_tarje;

    if(tarjehabilit(NEW.let_tarje) is NULL) then
	    RAISE EXCEPTION  'LA TARJETA NO EXISTE O NO ESTA HABILITADA';
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bi_lecting() OWNER TO zona;

--
-- Name: f_bi_operaciones(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_operaciones() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
BEGIN
--	if (hay_contrato (NEW.op_directo, NEW.op_indirecto, 1::int2,0,3::int2)!=true )THEN 
--	    aux_texto:='En la Operacion '||traigo_simbtipoper(NEW.op_tipoper)||' '||NEW.op_nrotalzon||' no existe contrato entre el directo '||NEW.op_directo||'  ('||nomusu(NEW.op_directo) ||')     y el indirecto '||NEW.op_indirecto||'  ('||nomusu(NEW.op_indirecto)||')';
--	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;

--    if ( NEW.op_tipoper<100 and seg_disponible(NEW.op_deposito, NEW.op_importe,1::int2)!=true) THEN 
--	aux_texto:='En la Operacion '||traigo_simbtipoper(NEW.op_tipoper)||' '||NEW.op_nrotalzon||' el deposito '||NEW.op_deposito||'  ('||traigo_nomunifun(NEW.op_deposito::int2)||') no tiene el seguro necesario';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;

--    if ( NEW.op_tipoper>100 and ctacte_ok(NEW.op_directo)!=true) THEN 
--	aux_texto:='En la Operacion '||traigo_simbtipoper(NEW.op_tipoper)||' '||NEW.op_nrotalzon||' el usuario directo '||NEW.op_directo||'  ('||nomusu(NEW.op_directo) ||')  esta inhabilitado por falta de pago   ';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bi_operaciones() OWNER TO zona;

--
-- Name: f_bi_puertos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_puertos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    nompais 		varchar;
    BEGIN
    select pai_nombre into nompais from pais where pai_codigo=NEW.pue_pais;
    if not found then
	insert into pais values(NEW.pue_pais,'DATO DESCONOCIDO');
    end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bi_puertos() OWNER TO zona;

--
-- Name: f_bi_retiros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_retiros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
    if cantidad_disponible(NEW.ret_idsitem)<NEW.ret_cantidad then
	RAISE EXCEPTION  'LA CANTIDAD A RETIRAR ES MAYOR A LAS DISPONIBILIDADES';
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bi_retiros() OWNER TO zona;

--
-- Name: f_bi_subitem(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_subitem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	usu1 		int4;
	usu2 		int4;
	aux_texto 	text;
BEGIN

if numeric_eq(NEW.sitem_imp_dolar,0::numeric) then
    NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
end if;

--     if(tipprod_posible(NEW.sitem_deposito,(select item_tipprod from item where item_id=NEW.sitem_iditem)) !=true) then	
--	aux_texto:='El tipo de mercaderia no puede ser almacenada en la unidad funcional '||NEW.sitem_deposito||'  ('||traigo_nomunifun(NEW.sitem_deposito)||')';	 
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.sitem_idoper,aux_texto);
--	END IF;

--    select unif_usuario into usu1 from unifun where int2eq(unif_codigo,NEW.sitem_deposito);
--    select op_directo into usu2 from operaciones where op_id=NEW.sitem_idoper;
--    if (hay_contrato(usu1, usu2, 1::int2 ,NEW.sitem_idoper, 2::int2)!=true ) THEN 
--	aux_texto:='No Hay CONTRATO DE SERVICIO(2) PARA EL SUBITEM entre  '||usu1||'  ('||nomusu(usu1) ||')  y  '||usu2 ||'  ('||nomusu(usu2)||') ';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.sitem_idoper,aux_texto);
--	END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bi_subitem() OWNER TO zona;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 


------------------ PARTIDA DOBLE -----------------------------------

    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;

------------------ CASO CHEQUES -----------------------------------



END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO zona;

--
-- Name: f_bu_caratula(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_caratula() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
BEGIN

    if(textne(NEW.despacho,OLD.despacho))
    then
	update items set items_despacho=NEW.despacho where items_idcaratula=NEW.car_id;
    END IF;

    if(textne(NEW.transito,OLD.transito))
    then
	update items set items_transito=NEW.transito where items_idcaratula=NEW.car_id;
    END IF;
	
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_caratula() OWNER TO zona;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 


    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;

END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO zona;

--
-- Name: f_bu_operaciones(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_operaciones() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
salidas		numeric;
trans 		boolean;
notid		int4;
BEGIN

if(int2eq(NEW.op_estado,1::int2) and int2eq(OLD.op_estado,11::int2)) THEN 
NEW.op_fechain:=date(now());
END IF;

if(int2eq(NEW.op_estado,1::int2)and int2eq(OLD.op_estado,101::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	select sum(sitem_cantret)+sum(sitem_cantcomp) into salidas 
	    from subitem where sitem_idoper=NEW.op_id;
	if(numeric_ne(salidas,0::numeric)) then
	    RAISE EXCEPTION  'NO SE PUEDE MODIFICAR ESTA OPERACION POR EXISTIR RETIROS O REEXPEDICIONES QUE AFECTAN LA MISMA';
	END IF;
    END IF;
END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_operaciones() OWNER TO zona;

--
-- Name: f_bu_retiros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_retiros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
BEGIN

    if ((cantidad_disponible(NEW.ret_idsitem)+OLD.ret_cantidad)<NEW.ret_cantidad) then
	RAISE EXCEPTION  'LA CANTIDAD A RETIRAR ES MAYOR A LAS DISPONIBILIDADES';
    END IF;
	
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_retiros() OWNER TO zona;

--
-- Name: f_bu_seguros(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_seguros() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN

--    if(date_lt(date(NEW.seg_hasta),date('now()'))) then 
--	RAISE EXCEPTION  'LA FECHA DE EXPIRACION NO PUEDE SER MENOR A LA ACTUAL';
--    END IF;

    if(date_lt(date(NEW.seg_hasta),date(NEW.seg_fechad))) then 
	RAISE EXCEPTION  'LA FECHA DE VIGENCIA NO PUEDE SER MENOR O IGUAL A LA COMIENZO';
    END IF;

--    if(date_lt(date(OLD.seg_hasta),date('now()'))) then 
--	RAISE EXCEPTION  'DEBERA ANULAR ESTE CONTRATO Y CARGARLO NUEVAMENTE';
--    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_seguros() OWNER TO zona;

--
-- Name: f_bu_subitem(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_subitem() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	aux_texto 	text;
BEGIN

if int2lt(estadop(NEW.sitem_idoper),100::int2) THEN
    if numeric_ne(NEW.sitem_importe,OLD.sitem_importe) then
	NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
    end if;
end if;

if int2gt(estadop(NEW.sitem_idoper),100::int2) THEN
    if numeric_ne(NEW.sitem_importe,OLD.sitem_importe) then
	NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
	if (numeric_ne(fobpadre_vs_fobhijos(NEW.sitem_idoper,1::int2),0)) THEN 
	    aux_texto:='El usuario autorizado ha modificado el importe del subitem '||NEW.sitem_id ||' de la operacion publicada '||NEW.sitem_idoper||' que tenia un importe de '||OLD.sitem_importe||' por un importe de '||NEW.sitem_importe||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(41,NEW.sitem_idoper,aux_texto);
        end if;
    end if;

    if (int2ne(NEW.sitem_codigo,OLD.sitem_codigo)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  subitem '||NEW.sitem_id ||' de la operacion publicada '||NEW.sitem_idoper||' que tenia un codigo '||OLD.sitem_codigo||' por el codigo '||NEW.sitem_codigo||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(42,NEW.sitem_idoper,aux_texto);
        end if;

    if (int4ne(NEW.sitem_artic,OLD.sitem_artic)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  subitem '||NEW.sitem_id ||' de la operacion publicada '||NEW.sitem_idoper||' que tenia el articulo '||OLD.sitem_artic||' por el articulo '||NEW.sitem_artic||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(43,NEW.sitem_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.sitem_canting,OLD.sitem_canting)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  subitem '||NEW.sitem_id ||' de la operacion publicada '||NEW.sitem_idoper||' que tenia la cantidad '||OLD.sitem_canting||' por la cantidad '||NEW.sitem_canting||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(44,NEW.sitem_idoper,aux_texto);
        end if;

    if (int2ne(NEW.sitem_deposito,OLD.sitem_deposito)) then
	    aux_texto:='El usuario autorizado ha modificado el numero de  subitem '||NEW.sitem_id ||' de la operacion publicada '||NEW.sitem_idoper||' que estaba en el deposito '||OLD.sitem_deposito||' por el deposito '||NEW.sitem_deposito||' el dia de hoy';
	    insert into noticias(not_tipo,not_numero,not_texto)values(45,NEW.sitem_idoper,aux_texto);
        end if;
end if;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_subitem() OWNER TO zona;

--
-- Name: f_bu_volegr(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_volegr() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE

cantidad	numeric;
canting		numeric;
retirado	numeric;

BEGIN
cantidad := 0::numeric;
canting := 0::numeric;
retirado := 0::numeric;

select vol_cantret into retirado from voling where vol_idoper=NEW.vole_idoperi;
select vol_canting into canting from voling  where vol_idoper=OLD.vole_idoperi;

if(numeric_ne(NEW.vole_cantret,OLD.vole_cantret))THEN
    if(numeric_ne(OLD.vole_cantret,0::numeric)) THEN
	cantidad:= retirado - OLD.vole_cantret + NEW.vole_cantret;
	if numeric_lt(canting,cantidad) then
	    RAISE EXCEPTION  'EL VOLUMEN RETIRADO NO PODRA SER NUNCA MAYOR QUE EL INGRESADO';
	else
--	    RAISE EXCEPTION 'cantidad %, cantret %, canting %, nuevo %, viejo %',cantidad,retirado,canting,NEW.vole_cantret,OLD.vole_cantret;
	    update voling set vol_cantret=cantidad where vol_idoper=OLD.vole_idoperi;
	end if;
    else
	cantidad:= retirado+NEW.vole_cantret;
	if numeric_lt(canting,cantidad) then
	    RAISE EXCEPTION  'EL VOLUMEN RETIRADO NO PODRA SER NUNCA MAYOR QUE EL INGRESADO';
	else
--	    RAISE EXCEPTION 'cantidad2 %',cantidad;
	    update voling set vol_cantret=cantidad where vol_idoper=OLD.vole_idoperi;
	end if;

    END IF;
else
	update voling set vol_cantret=retirado where vol_idoper=OLD.vole_idoperi;
END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_volegr() OWNER TO zona;

--
-- Name: f_bu_voling(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_voling() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
mal		int2;
salidas		int4;
trans 		boolean;
notid		int4;
BEGIN


if(int2eq(NEW.vol_estado,999::int2)) THEN 
    select cfc1_id into salidas
	    from confactur1 where cfc1_idoper=NEW.vol_idoper and cfc1_estado=50 limit 1;
	if found then
	    RAISE EXCEPTION  'NO SE PUEDE ANULAR ESTA OPERACION POR EXISTIR CONCEPTOS YA FACTURADOS AL CLIENTE';
	END IF;
END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_bu_voling() OWNER TO zona;

--
-- Name: factu_alm(integer, smallint, smallint, date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION factu_alm(integer, smallint, smallint, date, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	anio		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	fecfac		ALIAS FOR $4; 
	fechah		ALIAS FOR $5; 
	opera		ALIAS FOR $6; 
	codemp		ALIAS FOR $7; 
	registro	record;
	regi		record;
	regist		record;
	mal		int2;
	pase		int4;
	aux_texto 	text;
	aux_texto2 	text;
	articulo	integer;
	artsegur	integer;
	sigo		integer;
	retval 		integer;
	valstoc		numeric;
	impreti		numeric;
	retire		numeric;
	retireus	numeric;
	impaseg		numeric;
	volumen		numeric;
	precio		numeric;
	cotiz		numeric;
	precios		numeric;
	importe		numeric;
    BEGIN
    retval:=0;
    impaseg:=0;

    select valvaramb(codemp,0,'ARTALM') into articulo;   
    select valvaramb(codemp,0,'ARTSEG') into artsegur;   
    select ult_cotiz(1) into cotiz;


    if(int4ne(cliente,0) and int4eq(opera,0)) then
	for registro in select * from voling where vol_directo=codemp and vol_cliente=cliente and vol_estado=101 and vol_ultfac<fechah 
	loop
	    impaseg:=0;
	    impreti:=0;
	    retireus:=0;
	    pase:=1;
	    volumen:=registro.vol_canting;
	    impaseg:=fob_a_fecha_oper(registro.vol_idoper,registro.vol_ultfac) * cotiz;
	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;
	    if numeric_ne(retire,0) then
		select sum((s.sitem_imp_dolar/s.sitem_canting) * r.ret_cantidad * cotiz) into retireus from subitem s, retiros r, volegr v where v.vole_idoperi=registro.vol_idoper and v.vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and v.vole_estado!=999 and r.ret_idsitem=s.sitem_id and r.ret_idopera=v.vole_idoper and s.sitem_idoper=v.vole_idoperi;
		if (retireus is null) then retireus:=0; end if;
		impaseg:=impaseg - retireus;
	    end if;
	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;
	    precios:=(calculo_funcion(-1,artsegur,registro.vol_idoper,1)) / 360;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fecfac and vole_estado=101
		loop
		    volumen:=volumen - regi.vole_cantret;
		    aux_texto:='Almacenaje Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),articulo,regi.vole_cantret,(regi.vole_fechaeg - registro.vol_ultfac),precio,((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio));
		    select sum((s.sitem_imp_dolar/s.sitem_canting)*r.ret_cantidad * cotiz) into impreti from subitem s, retiros r  where r.ret_idsitem=s.sitem_id and r.ret_idopera=regi.vole_idoper and s.sitem_idoper=regi.vole_idoperi;
		    impaseg:=impaseg - impreti;
		    aux_texto:='Seguro Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),artsegur,impreti ,(regi.vole_fechaeg - registro.vol_ultfac),precios,((regi.vole_fechaeg - registro.vol_ultfac) * impreti * precios));
		end loop;
	    if numeric_gt(volumen,0) then
		aux_texto:='Almacenaje Operacion  '||compbteoper(registro.vol_idoper)||' Periodo:  '||registro.vol_ultfac + 1 ||' - '||fechah ;
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),articulo,volumen,(fechah - registro.vol_ultfac),precio,((fechah - registro.vol_ultfac) * volumen * precio));
		aux_texto:='Seguro Operacion  '||compbteoper(registro.vol_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '|| fechah ||' )';
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),artsegur,impaseg ,(fechah - registro.vol_ultfac),precios,((fechah - registro.vol_ultfac) * impaseg * precios));
	    end if;
	    for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
		loop
		    select fac_estado into mal from facturacion where fac_codemp=codemp and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado!=1 and fac_anio=anio and fac_mes=mes limit 1;
		    if not found then
			delete from facturacion where fac_codemp=registro.vol_directo and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado=1 and fac_anio=anio and fac_mes=mes;
			aux_texto2:=' ( Concepto:  '  || descartic(regist.cfac_idart) || '  -  Operacion:  ' || traigo_simbtipoper(tipoperdeop(registro.vol_idoper)) || ' - ' || nrotaldiroper(registro.vol_idoper) || '   Comprobante:  ' || registro.vol_compbte || ' ) ';
			if(int4eq(regist.cfac_cliente,registro.vol_cliente) or  regist.cfac_cliente is null) then
			    precio:=calculo_funcion(regist.cfac_id,regist.cfac_idart,registro.vol_idoper,1);
			    importe:= precio * regist.cfac_dias * regist.cfac_canti ;
			end if;
			if numeric_gt(importe,0) then 
			    insert into facturacion (fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_directo,registro.vol_cliente,registro.vol_fechain,anio,mes,registro.vol_idoper,aux_texto2,regist.cfac_ptov,regist.cfac_idart,regist.cfac_canti * impaseg,regist.cfac_dias,precio,importe);
			end if;
		    end if;
		end loop; 
	end loop;
	update voling set vol_ultfac=fechah where vol_directo=codemp and vol_cliente=cliente and vol_estado=101 and vol_ultfac<fechah;
    end if;


    if(int4eq(cliente,0) and  int4eq(opera,0)) then
	for registro in select * from voling where vol_directo=codemp and vol_estado=101 and climodfac(vol_cliente)=1 and vol_ultfac<fechah
	loop
	    impaseg:=0;
	    impreti:=0;
	    retireus:=0;
	    pase:=1;
	    volumen:=registro.vol_canting;
	    impaseg:=fob_a_fecha_oper(registro.vol_idoper,registro.vol_ultfac) * cotiz;
	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;
	    if numeric_ne(retire,0) then
		select sum((s.sitem_imp_dolar/s.sitem_canting) * r.ret_cantidad * cotiz) into retireus from subitem s, retiros r, volegr v where v.vole_idoperi=registro.vol_idoper and v.vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and v.vole_estado!=999 and r.ret_idsitem=s.sitem_id and r.ret_idopera=v.vole_idoper and s.sitem_idoper=v.vole_idoperi;
		if (retireus is null) then retireus:=0; end if;
		impaseg:=impaseg - retireus;
	    end if;
	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;
	    precios:=(calculo_funcion(-1,artsegur,registro.vol_idoper,1)) / 360;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fecfac and vole_estado=101
		loop
		    volumen:=volumen - regi.vole_cantret;
		    aux_texto:='Almacenaje Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),articulo,regi.vole_cantret,(regi.vole_fechaeg - registro.vol_ultfac),precio,((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio));
		    select sum((s.sitem_imp_dolar/s.sitem_canting)*r.ret_cantidad * cotiz) into impreti from subitem s, retiros r  where r.ret_idsitem=s.sitem_id and r.ret_idopera=regi.vole_idoper and s.sitem_idoper=regi.vole_idoperi;
		    impaseg:=impaseg - impreti;
		    aux_texto:='Seguro Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),artsegur,impreti ,(regi.vole_fechaeg - registro.vol_ultfac),precios,((regi.vole_fechaeg - registro.vol_ultfac) * impreti * precios));
		end loop;
	    if numeric_gt(volumen,0) then
		aux_texto:='Almacenaje Operacion  '||compbteoper(registro.vol_idoper)||' Periodo:  '||registro.vol_ultfac + 1 ||' - '||fechah ;
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),articulo,volumen,(fechah - registro.vol_ultfac),precio,((fechah - registro.vol_ultfac) * volumen * precio));
		aux_texto:='Seguro Operacion  '||compbteoper(registro.vol_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '|| fechah ||' )';
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),artsegur,impaseg ,(fechah - registro.vol_ultfac),precios,((fechah - registro.vol_ultfac) * impaseg * precios));
	    end if;
	    for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
		loop
		    select fac_estado into mal from facturacion where fac_codemp=codemp and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado!=1 and fac_anio=anio and fac_mes=mes limit 1;
		    if not found then
			delete from facturacion where fac_codemp=registro.vol_directo and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado=1 and fac_anio=anio and fac_mes=mes;
			aux_texto2:=' ( Concepto:  '  || descartic(regist.cfac_idart) || '  -  Operacion:  ' || traigo_simbtipoper(tipoperdeop(registro.vol_idoper)) || ' - ' || nrotaldiroper(registro.vol_idoper) || '   Comprobante:  ' || registro.vol_compbte || ' ) ';
			if(int4eq(regist.cfac_cliente,registro.vol_cliente) or  regist.cfac_cliente is null) then
			    precio:=calculo_funcion(regist.cfac_id,regist.cfac_idart,registro.vol_idoper,1);
			    importe:= precio * regist.cfac_dias * regist.cfac_canti ;
			end if;
			if numeric_gt(importe,0) then 
			    insert into facturacion (fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_directo,registro.vol_cliente,registro.vol_fechain,anio,mes,registro.vol_idoper,aux_texto2,regist.cfac_ptov,regist.cfac_idart,regist.cfac_canti * impaseg,regist.cfac_dias,precio,importe);
			end if;
		    end if;
		end loop; 
	end loop;
	update voling set vol_ultfac=fechah where vol_directo=codemp and vol_estado=101 and climodfac(vol_cliente)=1 and vol_ultfac<fechah;
    end if;


    if(int4ne(opera,0)) then
	for registro in select * from voling where vol_directo=codemp and vol_idoper=opera and vol_estado=101 and vol_ultfac<fechah 
	loop
	    impaseg:=0;
	    impreti:=0;
	    retireus:=0;
	    pase:=1;
	    volumen:=registro.vol_canting;
	    impaseg:=fob_a_fecha_oper(registro.vol_idoper,registro.vol_ultfac) * cotiz;
	    select sum(vole_cantret) into retire from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and vole_estado!=999 ;
	    if (retire is null) then retire:=0; end if;
	    volumen:=volumen - retire;
	    if numeric_ne(retire,0) then
		select sum((s.sitem_imp_dolar/s.sitem_canting) * r.ret_cantidad * cotiz) into retireus from subitem s, retiros r, volegr v where v.vole_idoperi=registro.vol_idoper and v.vole_fechaeg<=registro.vol_ultfac and registro.vol_cantret!=0 and v.vole_estado!=999 and r.ret_idsitem=s.sitem_id and r.ret_idopera=v.vole_idoper and s.sitem_idoper=v.vole_idoperi;
		if (retireus is null) then retireus:=0; end if;
		impaseg:=impaseg - retireus;
	    end if;
	    select elprecioid(codemp,registro.vol_cliente,articulo) into precio;
	    precios:=(calculo_funcion(-1,artsegur,registro.vol_idoper,1)) / 360;
	    for regi in select * from volegr where vole_idoperi=registro.vol_idoper and vole_fechaeg>registro.vol_ultfac and vole_fechaeg<=fecfac and vole_estado=101
		loop
		    volumen:=volumen - regi.vole_cantret;
		    aux_texto:='Almacenaje Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),articulo,regi.vole_cantret,(regi.vole_fechaeg - registro.vol_ultfac),precio,((regi.vole_fechaeg - registro.vol_ultfac) * regi.vole_cantret * precio));
		    select sum((s.sitem_imp_dolar/s.sitem_canting)*r.ret_cantidad * cotiz) into impreti from subitem s, retiros r  where r.ret_idsitem=s.sitem_id and r.ret_idopera=regi.vole_idoper and s.sitem_idoper=regi.vole_idoperi;
		    impaseg:=impaseg - impreti;
		    aux_texto:='Seguro Operacion  '||compbteoper(regi.vole_idoperi)||' retirada con comprobante  '||compbteoper(regi.vole_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '||regi.vole_fechaeg ||' )';
		    insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,regi.vole_fechaeg,regi.vole_directo,registro.vol_cliente,fecfac,anio,mes,regi.vole_idoperi,aux_texto,ptovdefault(registro.vol_directo),artsegur,impreti ,(regi.vole_fechaeg - registro.vol_ultfac),precios,((regi.vole_fechaeg - registro.vol_ultfac) * impreti * precios));
		end loop;
	    if numeric_gt(volumen,0) then
		aux_texto:='Almacenaje Operacion  '||compbteoper(registro.vol_idoper)||' Periodo:  '||registro.vol_ultfac + 1 ||' - '||fechah ;
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),articulo,volumen,(fechah - registro.vol_ultfac),precio,((fechah - registro.vol_ultfac) * volumen * precio));
		aux_texto:='Seguro Operacion  '||compbteoper(registro.vol_idoper)||' (  '||registro.vol_ultfac + 1 ||' - '|| fechah ||' )';
		insert into facturacion (fac_fecdes,fac_fechas,fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_ultfac,fechah,codemp,registro.vol_cliente,fecfac,anio,mes,registro.vol_idoper,aux_texto,ptovdefault(registro.vol_directo),artsegur,impaseg ,(fechah - registro.vol_ultfac),precios,((fechah - registro.vol_ultfac) * impaseg * precios));
	    end if;
	    for regist in select * from complfac where cfac_codemp=codemp and cfac_estado=1 and cfac_evento=3 
		loop
		    select fac_estado into mal from facturacion where fac_codemp=codemp and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado!=1 and fac_anio=anio and fac_mes=mes limit 1;
		    if not found then
			delete from facturacion where fac_codemp=registro.vol_directo and fac_cliente=registro.vol_cliente and fac_idoper=registro.vol_idoper and fac_ptov=regist.cfac_ptov and fac_idart=regist.cfac_idart and fac_estado=1 and fac_anio=anio and fac_mes=mes;
			aux_texto2:=' ( Concepto:  '  || descartic(regist.cfac_idart) || '  -  Operacion:  ' || traigo_simbtipoper(tipoperdeop(registro.vol_idoper)) || ' - ' || nrotaldiroper(registro.vol_idoper) || '   Comprobante:  ' || registro.vol_compbte || ' ) ';
			if(int4eq(regist.cfac_cliente,registro.vol_cliente) or  regist.cfac_cliente is null) then
			    precio:=calculo_funcion(regist.cfac_id,regist.cfac_idart,registro.vol_idoper,1);
			    importe:= precio * regist.cfac_dias * regist.cfac_canti ;
			end if;
			if numeric_gt(importe,0) then 
			    insert into facturacion (fac_codemp,fac_cliente,fac_fecha,fac_anio,fac_mes,fac_idoper,fac_leyen,fac_ptov,fac_idart,fac_canti,fac_dias,fac_precio,fac_importe) values (registro.vol_directo,registro.vol_cliente,registro.vol_fechain,anio,mes,registro.vol_idoper,aux_texto2,regist.cfac_ptov,regist.cfac_idart,regist.cfac_canti * impaseg,regist.cfac_dias,precio,importe);
			end if;
		    end if;
		end loop; 
	end loop;
	update voling set vol_ultfac=fechah where vol_directo=codemp and vol_idoper=opera and vol_estado=101 and vol_ultfac<fechah;
    end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.factu_alm(integer, smallint, smallint, date, date, integer, integer) OWNER TO zona;

--
-- Name: facturacontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION facturacontr(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select contr_facturable from contratos where contr_id= $1;$_$;


ALTER FUNCTION public.facturacontr(integer) OWNER TO zona;

--
-- Name: facturo(integer, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION facturo(integer, integer, smallint, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cliente		ALIAS FOR $2; 
	estado		ALIAS FOR $3; 
	operador	ALIAS FOR $4; 
	ivaemp 		smallint;
	ivacli 		smallint;
	registro	record;
	regi		record;
	aux_texto 	text;
	idcompro	integer;
	idmovsto	integer;
	idastoh		integer;
	idemiti		integer;
	lineas		integer;
	yvan		integer;
	primera		integer;
	numero		integer;
	ptonew		integer;
	ptoold		integer;
	clinew		integer;
	cliold		integer;
	yapase		integer;
	eliva		numeric;
	elivast		numeric;
	retval 		integer;
    BEGIN
    retval:=0;
    primera:=0;
    ptoold:=0;
    ptonew:=0;
    yapase:=0;
    yvan:=0;


    select valvaramb(codemp,ptovdefault(codemp),'LINFAC') into lineas;
    select emp_coniva into ivaemp from empresa where emp_codigo=codemp;

    if(int4eq(cliente,0)) then
	for registro in select * from facturacion where fac_codemp=codemp and fac_estado=estado 
	loop
	    ptonew:=registro.fac_ptov;
	    clinew:=registro.fac_cliente;

	    if(int4eq(primera,0) or int4ne(ptonew,ptoold) or int4ne(clinew,cliold)) then
		ptoold:=registro.fac_ptov;
		cliold:=registro.fac_cliente;
		select cli_coniva into ivacli from clientes where cli_id=registro.fac_cliente;
		if(int2eq(ivaemp,1::int2)) then
		    if(int2eq(ivacli,1::int2)) then
			select idcomp('FA',ptonew) into idcompro;
		      else		
			select idcomp('FB',ptonew) into idcompro;
		    end if;
	          else
		    select idcomp('FC',ptonew) into idcompro;
		end if;


		select numtalon(ptonew,idcompro,1) into numero;
		select nomcomp(idcompro) into aux_texto;
		insert into astoh (ash_estado,ash_codemp,ash_idptov,ash_anio,ash_mes,ash_fecomp,ash_fecval,ash_operad,ash_comprob,ash_numero,ash_titulo) values (-2,registro.fac_codemp,registro.fac_ptov,registro.fac_anio,registro.fac_mes,registro.fac_fecha,registro.fac_fecfac,operador,idcompro,numero,aux_texto);
		select max(ash_id) into idastoh from astoh;
		insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrocuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado) values (idastoh,registro.fac_codemp,registro.fac_ptov,idcompro,numero,registro.fac_fecfac,registro.fac_cliente,nomcli(registro.fac_cliente),cuitcli(registro.fac_cliente),provinclie(registro.fac_cliente,registro.fac_ptov),grupocli(registro.fac_cliente,1),registro.fac_ptov,ivacli,conpagcli(registro.fac_cliente),-2);
		select max(emi_id) into idemiti from emiti;
		update astoh set ash_idemiti=idemiti where ash_id=idastoh;
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecha,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		primera:=1;
		yvan:=1;

	      else

		select movs_id into idmovsto from movsto where movs_idastoh=idastoh and movs_idemiti=idemiti and movs_artic=registro.fac_idart and movs_precio=registro.fac_precio;
		if not found then
		    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecfac,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		    yvan:=yvan + 1; 
		    if int4eq(yvan,lineas)then
		      primera:=0;
		      yvan:=0; 
		    end if;
		  else
		    update movsto set movs_canti=movs_canti+registro.fac_canti,movs_importe=movs_importe+registro.fac_importe,movs_dias=movs_dias+registro.fac_dias where movs_id=idmovsto;
		    update movsto set movs_dias=movs_importe/movs_canti/movs_precio where movs_id=idmovsto;
		end if;

	    end if;
	end loop;
    update facturacion set fac_estado=2 where fac_codemp=codemp and fac_estado=estado;
    end if;


    if(int4ne(cliente,0)) then
	for registro in select * from facturacion where fac_codemp=codemp and fac_cliente=cliente and fac_estado=estado
	loop
	    ptonew:=registro.fac_ptov;
	    if(int4eq(primera,0) or int4ne(ptonew,ptoold)) then
		ptoold:=registro.fac_ptov;
		select cli_coniva into ivacli from clientes where cli_id=cliente;
		if(int2eq(ivaemp,1::int2)) then
		    if(int2eq(ivacli,1::int2)) then
			select idcomp('FA',ptonew) into idcompro;
		      else		
			select idcomp('FB',ptonew) into idcompro;
		    end if;
	          else
		    select idcomp('FC',ptonew) into idcompro;
		end if;
		select numtalon(ptonew,idcompro,1) into numero;
		select nomcomp(idcompro) into aux_texto;
		insert into astoh (ash_estado,ash_codemp,ash_idptov,ash_anio,ash_mes,ash_fecomp,ash_fecval,ash_operad,ash_comprob,ash_numero,ash_titulo) values (-2,registro.fac_codemp,registro.fac_ptov,registro.fac_anio,registro.fac_mes,registro.fac_fecha,registro.fac_fecfac,operador,idcompro,numero,aux_texto);
		select max(ash_id) into idastoh from astoh;
		insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrocuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado) values (idastoh,registro.fac_codemp,registro.fac_ptov,idcompro,numero,registro.fac_fecfac,registro.fac_cliente,nomcli(registro.fac_cliente),cuitcli(registro.fac_cliente),provinclie(registro.fac_cliente,registro.fac_ptov),grupocli(registro.fac_cliente,1),registro.fac_ptov,ivacli,conpagcli(registro.fac_cliente),-2);
		select max(emi_id) into idemiti from emiti;
		update astoh set ash_idemiti=idemiti where ash_id=idastoh;
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecha,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		primera:=1;
		yvan:=1;

	      else

		select movs_id into idmovsto from movsto where movs_idastoh=idastoh and movs_idemiti=idemiti and movs_artic=registro.fac_idart and movs_precio=registro.fac_precio;
		if not found then
		    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecfac,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		    yvan:=yvan + 1; 
		    if int4eq(yvan,lineas)then
		      primera:=0;
		      yvan:=0; 
		    end if;
		  else
		    update movsto set movs_canti=movs_canti+registro.fac_canti, movs_importe=movs_importe+registro.fac_importe, movs_dias=movs_dias+registro.fac_dias where movs_id=idmovsto;
		    update movsto set movs_dias=movs_importe/movs_canti/movs_precio where movs_id=idmovsto;
		end if;
	    end if;
	end loop;
    update facturacion set fac_estado=2 where fac_codemp=codemp and fac_cliente=cliente and fac_estado=estado;
    end if;


    eliva:=0;
    elivast:=0;
    for regi in select * from astoh where ash_estado=-2
	loop
	    select sum(movs_importe * movs_tasa / 100) into eliva from movsto where movs_idastoh=regi.ash_id;
	    select graboastocta(regi.ash_id,eliva,elivast,0::numeric) into yapase;
	end loop;
    update astoh set ash_estado=-1 where ash_estado=-2;

    retval:=yapase;

RETURN retval;
END;$_$;


ALTER FUNCTION public.facturo(integer, integer, smallint, integer) OWNER TO zona;

--
-- Name: fecdechq(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecdechq(integer) RETURNS date
    LANGUAGE sql
    AS $_$select chq_fecheq from cheques where chq_id= $1 ;$_$;


ALTER FUNCTION public.fecdechq(integer) OWNER TO zona;

--
-- Name: fecegre_almacen(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecegre_almacen(integer) RETURNS date
    LANGUAGE sql
    AS $_$select alm_retiro from almacen where alm_id= $1;$_$;


ALTER FUNCTION public.fecegre_almacen(integer) OWNER TO zona;

--
-- Name: fecegre_de_almacen(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecegre_de_almacen(character varying) RETURNS date
    LANGUAGE sql
    AS $_$select alm_retiro from almacen where trim(alm_leyenda)= $1 limit 1;$_$;


ALTER FUNCTION public.fecegre_de_almacen(character varying) OWNER TO zona;

--
-- Name: fecha_fe(date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecha_fe(date) RETURNS character
    LANGUAGE sql
    AS $_$select date_part('Y',$1)::character varying||lpad(date_part('Month',$1)::text,2,'0')::character varying||lpad(date_part('D',$1)::text,2,'0')::character varying;$_$;


ALTER FUNCTION public.fecha_fe(date) OWNER TO zona;

--
-- Name: fechaevento(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechaevento(integer, integer) RETURNS date
    LANGUAGE sql
    AS $_$select fechac_fecha from feccontra where fechac_idcontra= $1 and fechac_codevent= $2;$_$;


ALTER FUNCTION public.fechaevento(integer, integer) OWNER TO zona;

--
-- Name: fechainop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainop(integer) RETURNS date
    LANGUAGE sql
    AS $_$select op_fechain from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.fechainop(integer) OWNER TO zona;

--
-- Name: fechainretsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainretsitem(integer) RETURNS date
    LANGUAGE sql
    AS $_$select op_fechain from operaciones a,retiros b where a.op_id=b.ret_idopera and a.op_estado>100 and b.ret_idsitem= $1 order by ret_id desc limit 1;$_$;


ALTER FUNCTION public.fechainretsitem(integer) OWNER TO zona;

--
-- Name: fechainsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainsitem(integer) RETURNS date
    LANGUAGE sql
    AS $_$select op_fechain from operaciones a,subitem b where a.op_id=b.sitem_idoper and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.fechainsitem(integer) OWNER TO zona;

--
-- Name: fecvalash(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecvalash(integer) RETURNS date
    LANGUAGE sql
    AS $_$select ash_fecval from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.fecvalash(integer) OWNER TO zona;

--
-- Name: fecvalastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecvalastc(integer) RETURNS date
    LANGUAGE sql
    AS $_$select astc_fecval from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.fecvalastc(integer) OWNER TO zona;

--
-- Name: fecvtoconsig(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecvtoconsig(integer) RETURNS date
    LANGUAGE sql
    AS $_$select csg_fecvto from consig where csg_id= $1 ;$_$;


ALTER FUNCTION public.fecvtoconsig(integer) OWNER TO zona;

--
-- Name: fob_a_fecha_compbte(character varying, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_compbte(character varying, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
compbte		ALIAS FOR $1; 	-- Comprobante
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where bpchareq(op_compbte,compbte::varchar) and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	for registror in select *
	    from subitem where sitem_idoper=registro.x
		loop

		retval:=retval+registror.sitem_imp_dolar;

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;


		select sum(ret_cantidad) into cantret from
    		    retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;

		    if(retirado is not null and retirado!=0) then   retval:=retval-retirado; end if;

		end if;

		end loop; 

	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.fob_a_fecha_compbte(character varying, date) OWNER TO zona;

--
-- Name: fob_a_fecha_deposito(smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_deposito(smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
deposito	ALIAS FOR $1; 	-- deposito
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select *
    from subitem, operaciones where sitem_deposito=deposito and sitem_idoper=op_id and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop

	retval:=retval+registro.sitem_imp_dolar;

	if(registro.sitem_cantret is not null and registror.sitem_cantret!=0) then
	    if(registro.sitem_canting is not null and registror.sitem_canting!=0) then
		precio:=registro.sitem_imp_dolar/registro.sitem_canting;
	    end if;


	select sum(ret_cantidad) into cantret from
    	    retiros where registro.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

	    if not found then 
		    retirado:=0;
		else
		    retirado:=cantret*precio;
	    end if;

	    if(retirado is not null and retirado!=0) then   retval:=retval-retirado; end if;

	end if;

	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.fob_a_fecha_deposito(smallint, date) OWNER TO zona;

--
-- Name: fob_a_fecha_directo(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_directo(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
directo		ALIAS FOR $1; 	-- id del directo
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where op_directo=directo and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	for registror in select *
	    from subitem where sitem_idoper=registro.x
		loop

		retval:=retval+registror.sitem_imp_dolar;

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;


		select sum(ret_cantidad) into cantret from
    		    retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;

		    if(retirado is not null and retirado!=0) then   retval:=retval-retirado; end if;

		end if;

		end loop; 

	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.fob_a_fecha_directo(integer, date) OWNER TO zona;

--
-- Name: fob_a_fecha_directo2(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_directo2(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
directo		ALIAS FOR $1; 	-- id del directo
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where op_directo=directo and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	for registror in select *
	    from subitem where sitem_estado=1 and sitem_idoper=registro.x 
		loop
		retval:=retval+((registror.sitem_imp_dolar / registror.sitem_canting)*(registror.sitem_canting - registror.sitem_cantret));
		end loop; 
	end loop; 

retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.fob_a_fecha_directo2(integer, date) OWNER TO zona;

--
-- Name: fob_a_fecha_oper(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_oper(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
compbte		ALIAS FOR $1; 	-- Comprobante
fecha		ALIAS FOR $2;	-- fecha hasta
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

	for registror in select *
	    from subitem where sitem_idoper=compbte
		loop

		retval:=retval+registror.sitem_imp_dolar;

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then
		    if(registror.sitem_canting is not null and registror.sitem_canting!=0) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;


		select sum(ret_cantidad) into cantret from
    		    retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;

		    if(retirado is not null and retirado!=0) then   retval:=retval-retirado; end if;

		end if;

		end loop; 

retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.fob_a_fecha_oper(integer, date) OWNER TO zona;

--
-- Name: fob_hijos1(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_hijos1(integer, smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select (case when $2 =1 then sum(sitem_importe) else sum(sitem_imp_dolar) end) from subitem where sitem_idoper= $1 ;$_$;


ALTER FUNCTION public.fob_hijos1(integer, smallint) OWNER TO zona;

--
-- Name: fob_hijos2(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_hijos2(integer, smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select (case when $2 =1 then sum(ret_cantidad*sitem_importe/sitem_canting) else sum(ret_cantidad*sitem_imp_dolar/sitem_canting) end) from retiros,subitem where sitem_id=ret_idsitem and ret_idopera= $1 ;$_$;


ALTER FUNCTION public.fob_hijos2(integer, smallint) OWNER TO zona;

--
-- Name: fobpadre_vs_fobhijos(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fobpadre_vs_fobhijos(integer, smallint) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	id		ALIAS FOR $1; -- id dela OP.
	modo		ALIAS FOR $2; -- Modalidad de Operacion.
	fobt 		numeric;
	fobs 		numeric;
	retval 		numeric;
	cantidad	numeric;
    BEGIN
    SELECT   op_importe INTO fobt FROM operaciones WHERE op_id=id;
    
    if  int2eq(modo,1::int2) then
	 fobs := fob_hijos1(id,1::int2);
	 else
	 fobs := fob_hijos2(id,2::int2);
    end if;

    if (fobs is not null and fobs!=0) then cantidad=1::numeric; else fobs=0; end if;

    retval := fobt - fobs;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.fobpadre_vs_fobhijos(integer, smallint) OWNER TO zona;

--
-- Name: gastoct(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gastoct(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then

	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1 
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct(integer, integer, integer, numeric) OWNER TO zona;

--
-- Name: gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctacte		ALIAS FOR $6; 
	nucheq		ALIAS FOR $7; 
	fecvto		ALIAS FOR $8; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then
	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte,astc_nucheq,astc_fecvto) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1,tipcta,ctacte,nucheq,fecvto
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) OWNER TO zona;

--
-- Name: genernd(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION genernd(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
elcliente	 alias for $2;
nrogpo		 alias for $3;
totpag		 alias for $4;
ret 		 integer;
registro	 record;
regi		 record;
regi2		 record;
codemp		 integer;
idpto		 integer;
tipct		 integer;
ctadxv		 integer;
ctabco		 integer;
ctachq		 integer;
ctadocu		 integer;
primera		 integer;
salgrup		 numeric;
llevo		 numeric;
interd		 numeric;
prompago	 date;
acum1		 numeric;
acum2		 numeric;
tempor		 numeric;
valmin		 numeric;
begin

ret:=0;
llevo:=0;
acum1:=0;
acum2:=0;
tempor:=0;

select ash_codemp,ash_idptov into codemp,idpto from astoh where ash_id=idastoh;
select idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) into ctadxv;   
select idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) into ctachq;   
select idcbl(codemp,valvaramb(codemp,0,'BANCO')::integer) into ctabco;   
select idcbl(codemp,valvaramb(codemp,0,'DOCUM')::integer) into ctadocu;   
select sum(astc_importe) into salgrup from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo and astc_idastoh!=idastoh;
select (contr_inter + valvaramb(codemp,0,'INTBP')::numeric) into interd from contratos where contr_locatario=codcli(elcliente) and contr_idsubt in (0,1,2,3,4,5,6) and contr_inter is not null order by contr_id desc limit 1;
select valvaramb(codemp,0,'VALMINND') into valmin;   


if interd is null then
interd:= 20000.1;
end if;

for regi in select 
     * from astoctas where astc_idastoh=idastoh
    loop
	if(numeric_gt(regi.astc_importe,0::numeric)) then

	    if(int4eq(regi.astc_ctacble,ctachq)) then
		for regi2 in select * from cheques where chq_idastoc=regi.astc_id
		    loop
			select (regi2.chq_fecheq - '01-01-1900'::date) * regi2.chq_importe into acum1;
			acum2:=acum2 + acum1;
		    end loop; 
		tempor:=acum2;
		acum1:=0;
		acum2:=0;
	      else
		if(int4eq(regi.astc_ctacble,ctadocu)) then
		    for regi2 in select * from docum where doc_idastoc=regi.astc_id
			loop
			    select (regi2.doc_fecdoc - '01-01-1900'::date) * regi2.doc_importe into acum1;
			    acum2:=acum2 + acum1;
			end loop; 
		    tempor:= tempor + acum2;
		    acum1:=0;
		    acum2:=0;
	          else
		    if(int4eq(regi.astc_ctacble,ctabco)) then
			select (regi.astc_fecvto - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
			acum1:=0;
			acum2:=0;
	              else
			select (regi.astc_fecval - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
    		    end if;
    		end if;
    	    end if;
	end if;
    end loop; 

select ('01-01-1900'::date + (tempor / totpag)::integer) into prompago;


primera:=1;
for registro in select 
     * from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo order by astc_fecval desc ,astc_idastoh desc
loop
    if(numeric_gt(salgrup,0::numeric)) then
	if(numeric_le(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
	    llevo:= llevo + (registro.astc_importe * (prompago - registro.astc_fecvto) * interd / 100 / 30);
	    salgrup:= salgrup - registro.astc_importe;
ret:=(llevo * 1000 )::integer;
	  else 
	    if(numeric_gt(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
		llevo:=llevo + (salgrup * (prompago - registro.astc_fecvto) * interd  / 100 / 30);
ret:=(salgrup * 100000 )::integer;
		salgrup:= salgrup - registro.astc_importe;
	    end if;
	end if;
    end if;
end loop; 



if numeric_ge(llevo,valmin) then
    insert into notdeb (nd_idasho,nd_codemp,nd_idptov,nd_fecval,nd_grupo,nd_codcli,nd_tpago,nd_tnd,nd_interes) values (idastoh,codemp,idpto,date(now()),nrogpo,elcliente,totpag,llevo,interd);
--    select max(nd_id) into ret from notdeb;
end if;


return ret;
end;$_$;


ALTER FUNCTION public.genernd(integer, integer, integer, numeric) OWNER TO zona;

--
-- Name: genernd1(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION genernd1(integer, integer, integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
elcliente	 alias for $2;
nrogpo		 alias for $3;
totpag		 alias for $4;
ret 		 numeric;
registro	 record;
regi		 record;
regi2		 record;
codemp		 integer;
idpto		 integer;
tipct		 integer;
ctadxv		 integer;
ctabco		 integer;
ctachq		 integer;
ctadocu		 integer;
primera		 integer;
salgrup		 numeric;
llevo		 numeric;
interd		 numeric;
prompago	 date;
acum1		 numeric;
acum2		 numeric;
tempor		 numeric;
valmin		 numeric;
begin

ret:=0;
llevo:=0;
acum1:=0;
acum2:=0;
tempor:=0;

select ash_codemp,ash_idptov into codemp,idpto from astoh where ash_id=idastoh;
select idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) into ctadxv;   
select idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) into ctachq;   
select idcbl(codemp,valvaramb(codemp,0,'BANCO')::integer) into ctabco;   
select idcbl(codemp,valvaramb(codemp,0,'DOCUM')::integer) into ctadocu;   
select sum(astc_importe) into salgrup from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo and astc_idastoh!=idastoh;
select (contr_inter * valvaramb(codemp,0,'INTBP')::numeric) into interd from contratos where contr_locatario=codcli(elcliente) and contr_idsubt in (0,1,2,3,4,5,6) and contr_inter is not null order by contr_id desc limit 1;
select valvaramb(codemp,0,'VALMINND') into valmin;   


if interd is null then
interd:= 20000.1;
end if;



for regi in select 
     * from astoctas where astc_idastoh=idastoh
    loop
	if(numeric_gt(regi.astc_importe,0::numeric)) then

	    if(int4eq(regi.astc_ctacble,ctachq)) then
		for regi2 in select * from cheques where chq_idastoc=regi.astc_id
		    loop
			select (regi2.chq_fecheq - '01-01-1900'::date) * regi2.chq_importe into acum1;
			acum2:=acum2 + acum1;
		    end loop; 
		tempor:=acum2;
		acum1:=0;
		acum2:=0;
	      else
		if(int4eq(regi.astc_ctacble,ctadocu)) then
		    for regi2 in select * from docum where doc_idastoc=regi.astc_id
			loop
			    select (regi2.doc_fecdoc - '01-01-1900'::date) * regi2.doc_importe into acum1;
			    acum2:=acum2 + acum1;
			end loop; 
		    tempor:= tempor + acum2;
		    acum1:=0;
		    acum2:=0;
	          else
		    if(int4eq(regi.astc_ctacble,ctabco)) then
			select (regi.astc_fecvto - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
			acum1:=0;
			acum2:=0;
	              else
			select (regi.astc_fecval - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
    		    end if;
    		end if;
    	    end if;
	end if;
    end loop; 


select ('01-01-1900'::date + (tempor / totpag)::integer) into prompago;


primera:=1;
for registro in select 
     * from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo order by astc_fecval,astc_idastoh desc
    loop
	if(numeric_le(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
	    llevo:= llevo + (registro.astc_importe * (prompago - registro.astc_fecvto) * interd / 100 / 30);
	    salgrup:= salgrup - registro.astc_importe;
	  else 
	    if(numeric_gt(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
		llevo:=llevo + (salgrup * (prompago - registro.astc_fecvto) * interd  / 100 / 30);
	    end if;
	end if;
    end loop; 

ret:=salgrup;


return ret;
end;$_$;


ALTER FUNCTION public.genernd1(integer, integer, integer, numeric) OWNER TO zona;

--
-- Name: gente_adentro(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gente_adentro(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select io_gente from inout where io_estado=1 and io_gente= $1 ;$_$;


ALTER FUNCTION public.gente_adentro(integer) OWNER TO zona;

--
-- Name: gentedeusu(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gentedeusu(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_id from gente where gte_usu= $1 and gte_id= $2 ;$_$;


ALTER FUNCTION public.gentedeusu(integer, integer) OWNER TO zona;

--
-- Name: get_idopera(integer, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION get_idopera(integer, integer, smallint, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
directo	 	 alias for $1;
indirecto	 alias for $2;
tipoper		 alias for $3;
nro		 alias for $4;
ret 		 int4;
begin
select op_id into ret from operaciones where
op_directo=directo and op_indirecto=indirecto and
op_tipoper=tipoper and op_nrotaldir=nro ;
return ret;
end;$_$;


ALTER FUNCTION public.get_idopera(integer, integer, smallint, integer) OWNER TO zona;

--
-- Name: grabo_seg_y_alm_abierto(integer, date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabo_seg_y_alm_abierto(integer, date, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	ret		numeric;
    BEGIN


select calculo_almac_abierto(usuario,fechad,fechah,modo) into ret;

RETURN ret;
END;$_$;


ALTER FUNCTION public.grabo_seg_y_alm_abierto(integer, date, date, integer) OWNER TO zona;

--
-- Name: grabo_seg_y_alm_abierto(integer, date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabo_seg_y_alm_abierto(integer, date, date, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	unifun		ALIAS FOR $5; 	-- fecha hasta
	ret		numeric;
    BEGIN


select calculo_almac_abierto(usuario,fechad,fechah,modo,unifun) into ret;

RETURN ret;
END;$_$;


ALTER FUNCTION public.grabo_seg_y_alm_abierto(integer, date, date, integer, integer) OWNER TO zona;

--
-- Name: grabo_seg_y_alm_comun(integer, date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabo_seg_y_alm_comun(integer, date, date, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- 0 es a todos
	fechad		ALIAS FOR $2; 	-- fecha desde
	fechah		ALIAS FOR $3; 	-- fecha hasta
	modo		ALIAS FOR $4; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	cdesc		ALIAS FOR $5; 	-- 1 Graba
					-- 2 Solo Calcula
					-- 3 Anula la facturacion de fechah
	ret		numeric;
    BEGIN


select calculo_almac_comun(usuario,fechad,fechah,modo,cdesc) into ret;

select calculo_seg(usuario,fechad,fechah,modo) into ret;

RETURN ret;
END;$_$;


ALTER FUNCTION public.grabo_seg_y_alm_comun(integer, date, date, integer, integer) OWNER TO zona;

--
-- Name: graboastocta(integer, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION graboastocta(integer, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::integer) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::integer) into ctaiva;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::integer) into ctaivast;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::integer) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastocta(integer, numeric, numeric, numeric) OWNER TO zona;

--
-- Name: graboastoctac(integer, numeric, numeric, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION graboastoctac(integer, numeric, numeric, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctact		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::integer) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
	    if(int4eq(registro.cualtipcta, tipcta)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (ctact,tipcta,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::integer) into ctaiva;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::integer) into ctaivast;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::integer) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctac(integer, numeric, numeric, numeric, integer, integer) OWNER TO zona;

--
-- Name: grabocontrapart(integer, integer, real, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabocontrapart(integer, integer, real, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:='DESCONOCIDA'; end if;
if(registro_artic.marca is null) then registro_artic.marca:='DESCONOCIDA'; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:='DESCONOCIDA'; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:='DESCONOCIDA'; end if;
if(registro_artic.present is null) then registro_artic.present:='DESCONOCIDA'; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.grabocontrapart(integer, integer, real, numeric) OWNER TO zona;

--
-- Name: grabocontrapart(integer, integer, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabocontrapart(integer, integer, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:='DESCONOCIDA'; end if;
if(registro_artic.marca is null) then registro_artic.marca:='DESCONOCIDA'; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:='DESCONOCIDA'; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:='DESCONOCIDA'; end if;
if(registro_artic.present is null) then registro_artic.present:='DESCONOCIDA'; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.grabocontrapart(integer, integer, numeric, numeric) OWNER TO zona;

--
-- Name: grabonotiweb(integer, integer, integer, character varying, text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabonotiweb(integer, integer, integer, character varying, text) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
DECLARE
directo		ALIAS FOR $1; 	-- id del directo si es cero a todos
operador	ALIAS FOR $2;	-- Operador de carga
prioridad	ALIAS FOR $3;	 
titulo		ALIAS FOR $4;	 
texto		ALIAS FOR $5; 	-- texto
registro 	RECORD;
retval 		boolean;
BEGIN
retval:='t';		

if directo=0 then
	for registro in select usu_codigo as x
	    from usuarios where usu_tipusu=1 and usu_codigo>3
		loop
		    insert into wnoticias (wnot_directo,wnot_operadcar,wnot_prioridad,wnot_titulo,wnot_texto) values (registro.x,operador,prioridad,titulo::varchar,texto::text);
		end loop; 
    else
	insert into wnoticias (wnot_directo,wnot_operadcar,wnot_prioridad,wnot_titulo,wnot_texto) values (directo,operador,prioridad,titulo::varchar,texto::text);

end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.grabonotiweb(integer, integer, integer, character varying, text) OWNER TO zona;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cli_grupo into retval from
    	 clientes where int4eq(cliente,cli_id);

    if found then
	if int4eq(modo,1) then
	    update clientes set cli_grupo=cli_grupo+1 where int4eq(cliente,cli_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO zona;

--
-- Name: grupoprov(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grupoprov(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select prov_grupo into retval from
    	 prove where int4eq(provd,prov_id);

    if found then
	if int4eq(modo,1) then
	    update prove set prov_grupo=prov_grupo+1 where int4eq(provd,prov_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupoprov(integer, integer) OWNER TO zona;

--
-- Name: gsiessensible(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gsiessensible(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
oper		alias for $1;
registro	RECORD;
tipodeop	int4;
essensi		int4;
ret 		int4;
begin
ret:=0;


    select tipoperdeop(oper) into tipodeop;
	if int4lt(tipodeop,6) then

	for registro in select * from item where item_idoper=oper
	    loop
	    select es_sensible('registro.item_posa') into essensi;
		if int4eq(essensi,2) then
		    insert into operest (opr_idoper,opr_compbte) values (oper,compbteoper(oper));
		end if;
	    ret:= 1;
	    end loop; 
	end if;

return ret;
END;$_$;


ALTER FUNCTION public.gsiessensible(integer) OWNER TO zona;

--
-- Name: gtutti(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gtutti(integer, character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
compbte	 	 alias for $2;
ret 		 boolean;
registro	 record;
disponible	 numeric;
primera		 int4;
directo		 int4;
haycuantos	 int2;
elmayor		 int2;
indirecto	 int4;
begin
primera:=-1;

select op_directo,op_indirecto into directo,indirecto from operaciones where op_id=opid;

	select count(*) into haycuantos from retiros where ret_idopera=opid;
	if(int2eq(haycuantos,0::int2)) then
	    haycuantos:=0;
	end if;

	select max(ret_item) into elmayor from retiros where ret_idopera=opid;

	if(int2lt(haycuantos,elmayor)) then
	    haycuantos:=elmayor;
	end if;

for registro in select 
     * from subitem where sitem_estado=1 and bpchareq(sitem_compbte,compbte) and sitem_directo=directo and sitem_indirecto=indirecto and estadop(sitem_idoper)=101
	loop
	disponible:=registro.sitem_canting-registro.sitem_cantcomp-registro.sitem_cantret-registro.sitem_cantmala;
	if(disponible>0) then 

	    haycuantos:=haycuantos+1;
	    insert into retiros (ret_item,ret_idopera,ret_idsitem,ret_cantidad) values (haycuantos,opid,registro.sitem_id,disponible);
	end if;
end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.gtutti(integer, character varying) OWNER TO zona;

--
-- Name: gtuttiopinter(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gtuttiopinter(integer, character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
compbte	 	 alias for $2;
ret 		 boolean;
registro	 record;
disponible	 numeric;
primera		 int4;
sitemcreado	 int4;
retcreado	 int4;
nopid		 int4;
directo		 int4;
haycuantos	 int2;
elmayor		 int2;
tipoper		 int4;
indirecto	 int4;
begin
primera:=-1;
nopid:=opid+1;

select op_directo,op_indirecto into directo,indirecto from operaciones where op_id=opid;

	select count(*) into haycuantos from retiros where ret_idopera=opid;
	if(int2eq(haycuantos,0::int2)) then
	    haycuantos:=0;
	end if;

	select max(ret_item) into elmayor from retiros where ret_idopera=opid;

	if(int2lt(haycuantos,elmayor)) then
	    haycuantos:=elmayor;
	end if;

	select op_tipoper into tipoper from operaciones where op_id=opid;


for registro in select 
     * from subitem where sitem_estado=1 and bpchareq(sitem_compbte,compbte) and sitem_directo=directo and sitem_indirecto=indirecto and estadop(sitem_idoper)=101
	loop
	disponible:=registro.sitem_canting-registro.sitem_cantcomp-registro.sitem_cantret-registro.sitem_cantmala;
	if(disponible>0) then 
	    haycuantos:=haycuantos+1;
	    insert into retiros (ret_item,ret_idopera,ret_idsitem,ret_cantidad) values (haycuantos,opid,registro.sitem_id,disponible);
	    select max(ret_id) into retcreado from retiros where ret_idopera=opid;
	    select grabocontrapart(registro.sitem_id,nopid,disponible,0::numeric) into sitemcreado;
	    update retiros set ret_idsitemc=sitemcreado where ret_id=retcreado;
	end if;
end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.gtuttiopinter(integer, character varying) OWNER TO zona;

--
-- Name: gtuttiw(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gtuttiw(integer, character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
compbte	 	 alias for $2;
ret 		 boolean;
registro	 record;
disponible	 numeric;
primera		 int4;
directo		 int4;
haycuantos	 int2;
elmayor		 int2;
indirecto	 int4;
begin
primera:=-1;

    select wop_directo,wop_indirecto into directo,indirecto from woperaciones where wop_id=opid;

    select count(*) into haycuantos from wret2 where wret2_idopera=opid;
    if(int2eq(haycuantos,0::int2)) then
        haycuantos:=0;
    end if;

    select max(wret2_item) into elmayor from wret2 where wret2_idopera=opid;
    if(int2lt(haycuantos,elmayor)) then
        haycuantos:=elmayor;
    end if;

for registro in select 
     * from wsubitem where wsitem_directo=directo and wsitem_indirecto=indirecto and bpchareq(wsitem_compbte,compbte) 
    loop
	disponible:=registro.wsitem_canting-registro.wsitem_cantcomp-registro.wsitem_cantcompw-registro.wsitem_cantret-registro.wsitem_cantmala;
	if(disponible>0) then 

	    haycuantos:=haycuantos+1;
	    insert into wret2 (wret2_item,wret2_idopera,wret2_idsitem,wret2_cantidad) values (haycuantos,opid,registro.wsitem_id,disponible);
	end if;
    end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.gtuttiw(integer, character varying) OWNER TO zona;

--
-- Name: habro_ejercicio(character varying, date, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION habro_ejercicio(character varying, date, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
codemp		 alias for $3;
idptov		 alias for $4;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
compcierre 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
idashcierre 	 integer;
begin
ret:='f';
    select idcomp(comprobante,idptov) into elcomprob;
    select idcomp('ZZ',idptov) into compcierre;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' INICIADO EL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,substr(fecha::text,7,4)::int2,substr(fecha::text,4,2)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Apertura de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select ash_id into idashcierre from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=compcierre and date_le(ash_fecval,fecha) order by ash_id desc limit 1;

    for registro in select 
	    astc_ctacble, astc_tipcta, astc_ctacte, (astc_importe * -1) as cuanto from astoctas 
	      where astc_idastoh=idashcierre  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1,registro.astc_tipcta,registro.astc_ctacte);	
		end if;
	ret:='t';
    end loop; 
    return ret;
end;$_$;


ALTER FUNCTION public.habro_ejercicio(character varying, date, integer, integer) OWNER TO zona;

--
-- Name: hay_cont_recipro(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_recipro(integer, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; 	-- id dela operacion
	directo		ALIAS FOR $2; 	-- Usuario Directo
	modo		ALIAS FOR $3; 	-- modo
					--1 valido en publicacion
					--2 valido solo
	indirecto 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='t';		
    for registro in select sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by y
	loop
	select unif_usuario into indirecto from unifun where unif_codigo=registro.y;
	    if int4ne(directo,indirecto) then
		    trans:=hay_contrato(directo,indirecto,2::int2,operacion,5::int2);
		else
		    trans:='t';		
	    end if;
	end loop; 

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.hay_cont_recipro(integer, integer, smallint) OWNER TO zona;

--
-- Name: hay_cont_valido(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_valido(integer, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- Titular de la unifun 
	directo		ALIAS FOR $2; 	-- Usuario Directo o indirecto
	modo 		alias for $3;  	-- 1  valida que exista contrato
					-- 2 valida que exista y este aprobado
					-- 3 valida que exista contrato y no graba noticias
					-- 4 valida que exista y este aprobado y no graba noticias
					-- 43 valida que exista  tipo contrato 3 y este aprobado y no graba noticias
					-- 443 valida que exista  tipo contrato 4 y este aprobado y no graba noticias
	indirecto 	int4;
	operacion 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='f';		
    operacion=1;

if(usuario!=directo) then
    if usuario is not null then
	if int4ne(directo,usuario) then
	        if int2eq(modo,43::int2) then
	    		trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
		    else
	    		if int2eq(modo,443::int2) then
	    			trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				end if;
			    else
				trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				    if booleq(trans,'f')then
					trans:=hay_contrato(usuario,directo,modo::int2,operacion,5::int2);
					if booleq(trans,'f')then
					    trans:=hay_contrato(usuario,directo,modo::int2,operacion,2::int2);
					end if;
				    end if;
				end if;
			end if;
		end if;
	    else
		trans:='t';		
	end if;
	retval:=trans;
    end if;
else
    retval:='t';		
end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.hay_cont_valido(integer, integer, smallint) OWNER TO zona;

--
-- Name: hay_cont_valido_new(integer, integer, smallint, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_valido_new(integer, integer, smallint, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
directo		ALIAS FOR $1; 	-- Titular de la unifun 
indirecto	ALIAS FOR $2; 	-- Usuario Directo o indirecto
deposito	ALIAS FOR $3; 	-- Unifun
operacion	ALIAS FOR $4; 	-- Operacion
modo 		alias for $5;  	-- 1 valida que exista contrato aprobado
				-- 2 valida que exista contrato aprobado y graba noticias
retval 		boolean;
estado		smallint;
aux_texto 	text;
BEGIN

    retval:='f';		
    
    if(indirecto!=directo) then
	select contr_estado into estado from contratos where contr_locador=directo and contr_locatario=indirecto and contr_unifun=deposito and contr_estado=1;
	if not found then
	    if int2eq(modo,2::int2) then
		aux_texto:='No Existe Contrato Aprobado Entre '|| nomusu(directo) ||' y '||nomusu(indirecto)||' Para el Deposito '|| deposito;
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		retval:='f';		
	      else
		retval:='f';		
	    end if;
	  else
	    retval:='t';		
	end if;
      else
	retval:='t';		
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.hay_cont_valido_new(integer, integer, smallint, integer, smallint) OWNER TO zona;

--
-- Name: hay_contrato(integer, integer, smallint, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_contrato(integer, integer, smallint, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
directo		 alias for $1;
indirecto	 alias for $2;
caso 		 alias for $3;  -- 1 valida que exista contrato
				-- 2 valida que exista y este aprobado
				-- 3 valida que exista contrato y no graba noticias
				-- 4 valida que exista y este aprobado y no graba noticias
				-- 43 valida que exista y este aprobado y no graba noticias
				-- 5 valida que exista y este aprobado y no haya ni reprocidad ni indirecto locador ni
operacion	 alias for $4;
tipo_contrato alias for $5;
aux_texto	 text;
ret 		 boolean;
registro	 RECORD;
estado		 int2;
unifun		 int2;
hayuno	 	 int2;
hayunoaprob	 int2;

begin
ret:='f';
hayuno:=0;
hayunoaprob:=0;

if(int4ne(directo,indirecto)) then
    if caso!=5 then
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt)=tipo_contrato
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;
      else
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt) in (4::int2,5::int2)
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;

    end if;

  else

	hayuno:=1;
	hayunoaprob:=1;
 end if;

if caso=1 and hayuno=1 then
    ret:=true;
end if;

if int2ne(caso,1::int2) and hayunoaprob=1 then     
    ret:=true;
end if;

if caso=2 and hayuno=1  and hayunoaprob=0 then
    aux_texto:='No Existe Contrato Aprobado  tipo  '||nomtipc(tipo_contrato)||' entre '||nomusu(directo) ||' y '||nomusu(indirecto)||' !!!!!!!';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;

if  hayuno=0  and hayunoaprob=0 and int2ne(caso,4::int2) and int4ne(directo,1) then
    aux_texto:='No Existe Contrato Aprobado  de tipo  '||nomtipc(tipo_contrato)||' entre '||nomusu(directo) ||' y '||nomusu(indirecto)||' !!!!!!!';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;
return ret;
END;$_$;


ALTER FUNCTION public.hay_contrato(integer, integer, smallint, integer, smallint) OWNER TO zona;

--
-- Name: hayarticstock(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hayarticstock(integer, integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(sitem_canting-sitem_cantcomp-sitem_cantret-sitem_cantmala) from subitem where sitem_estado=1 and estadop(sitem_idoper)=101 and sitem_directo= $2 and sitem_artic= $1 ;$_$;


ALTER FUNCTION public.hayarticstock(integer, integer) OWNER TO zona;

--
-- Name: hubovisita(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hubovisita(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from visita where vt_inout= $1 ;$_$;


ALTER FUNCTION public.hubovisita(integer) OWNER TO zona;

--
-- Name: idartdetipp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idartdetipp(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select tip_imo from tipprod where tip_codigo= $1 ;$_$;


ALTER FUNCTION public.idartdetipp(integer) OWNER TO zona;

--
-- Name: idarticvta(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idarticvta(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select art_id from articvta where art_codemp= $1 and bpchareq(trim( $2 ),art_codi);$_$;


ALTER FUNCTION public.idarticvta(integer, character varying) OWNER TO zona;

--
-- Name: idashdecomp(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idashdecomp(integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_id from astoh where ash_codemp= $1 and ash_idptov= $2 and ash_comprob= $3 and ash_numero= $4;$_$;


ALTER FUNCTION public.idashdecomp(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: idcbl(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idcbl(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_id from ctacble where cbl_codemp in ( $1,0) and cbl_codigo= $2 order by cbl_codemp desc limit 1;$_$;


ALTER FUNCTION public.idcbl(integer, integer) OWNER TO zona;

--
-- Name: idcli(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idcli(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_id from clientes where cli_codemp= $1 and cli_codigo= $2;$_$;


ALTER FUNCTION public.idcli(integer, integer) OWNER TO zona;

--
-- Name: idcomp(character varying, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idcomp(character varying, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select comp_id from comprob where bpchareq(trim(comp_codigo),trim( $1 )) and comp_idptov in ( $2 ,0) limit 1;$_$;


ALTER FUNCTION public.idcomp(character varying, integer) OWNER TO zona;

--
-- Name: idctes(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idctes(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_id from ctes where cte_tipcta= $1 and cte_codigo= $2;$_$;


ALTER FUNCTION public.idctes(integer, integer) OWNER TO zona;

--
-- Name: iddearticud(integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION iddearticud(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select articd_id from articud where articd_indirecto = $1 and articd_codigo=trim($2);$_$;


ALTER FUNCTION public.iddearticud(integer, character varying) OWNER TO zona;

--
-- Name: iddearticudm(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION iddearticudm(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select articd_id from articud a,articu b where a.articd_indirecto=b.artic_indirecto  and a.articd_codigo=b.artic_codigo and b.artic_id= $1;$_$;


ALTER FUNCTION public.iddearticudm(integer) OWNER TO zona;

--
-- Name: idopleyrexp(character varying, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idopleyrexp(character varying, smallint) RETURNS integer
    LANGUAGE sql
    AS $_$select leyr_idoper from leyenrexp where leyr_nro= $2 and leyr_leyenda like '%$1%' ;$_$;


ALTER FUNCTION public.idopleyrexp(character varying, smallint) OWNER TO zona;

--
-- Name: idopleyrexp2(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idopleyrexp2(character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select leyr_idoper from leyenrexp where leyr_leyenda like '%$1%' ;$_$;


ALTER FUNCTION public.idopleyrexp2(character varying) OWNER TO zona;

--
-- Name: idprov(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idprov(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_id from prove where prov_codemp= $1 and prov_codigo= $2;$_$;


ALTER FUNCTION public.idprov(integer, integer) OWNER TO zona;

--
-- Name: idptov(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idptov(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 and ptv_codigo= $2;$_$;


ALTER FUNCTION public.idptov(integer, integer) OWNER TO zona;

--
-- Name: idsitemdewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idsitemdewret2(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select a.wsitem_id from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;$_$;


ALTER FUNCTION public.idsitemdewret2(integer) OWNER TO zona;

--
-- Name: idwopdewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idwopdewret2(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select wret2_idopera from wret2 where wret2_id= $1 ;$_$;


ALTER FUNCTION public.idwopdewret2(integer) OWNER TO zona;

--
-- Name: importe_fe(numeric); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION importe_fe(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	imp		ALIAS FOR $1;
	retval		text;
    BEGIN
	select lpad((imp::numeric(15,2)*100)::numeric(15,0)::text,15,'0') into retval;
	RETURN retval;
    END;$_$;


ALTER FUNCTION public.importe_fe(numeric) OWNER TO estlm;

--
-- Name: importo_ingreso(integer, integer, integer, integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION importo_ingreso(integer, integer, integer, integer, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	caratul		ALIAS FOR $1; -- id de la Caratula.
	directo		ALIAS FOR $2; -- Directo.
	indirecto	ALIAS FOR $3; -- Indirecto.
	tipoper		ALIAS FOR $4; -- Tipoper.
	consig		ALIAS FOR $5; -- Consignatario.
	deposito	ALIAS FOR $6; -- Deposito.
	operacion	int4;
	elitem		int4;
	articulo	int4;
	monedi		int2;
	moned		int2;
	posafab		varchar;
	despachos	text ;
	retval		boolean;
	registro	record;
    BEGIN
	retval:='f';

	select cual_moneda(divisa_fob) into monedi from caratula where car_id=caratul;

	if(monedi is null) then 
	    select divisa_fob::int2 into monedi from caratula where car_id=caratul;
	end if;

	select mon_codigo into moned from moneda where mon_codigo=monedi;
	if not found then
	    moned=2;
	end if;

	select despacho into despachos from caratula where car_id=caratul;

	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_consig,op_compbte,op_comptrans,op_nrotalzon,op_nrotaldir,op_deposito,op_iddespach,op_peso,op_bultos,op_moneda,op_importe,op_impdolar,op_tipo_cambio,op_embalaje) select tipoper,directo,indirecto,consig,despachos,substr(transito,0,16),val_talon(tipoper,1),val_talon(tipoper,directo),deposito,cual_despachante(cuit_despachante),peso_bruto_bultos::numeric,cant_bultos_declar::integer,moned::int2,monto_fob::numeric(15,2),valor_moncte(moned,fecha_oficializ::date,monto_fob::numeric,0::numeric),monto_fob::numeric/valor_moncte(moned,fecha_oficializ::date,monto_fob::numeric,0::numeric),codigo_embalaje::smallint from caratula where car_id=caratul;
	
	select max(op_id) into operacion from operaciones;

	delete from auxoper where auxo_idoper=operacion;
	insert into auxoper(auxo_idoper,auxo_facturas,auxo_fecha_oficial,auxo_monflet,auxo_impflet,auxo_monseg,auxo_impseg,auxo_plazo_suspens,auxo_medio_transpo) select operacion,referencias::varchar(90),fecha_oficializ,cual_moneda(divisa_flete),monto_flete::numeric,cual_moneda(divisa_seguro),monto_seguro::numeric,plazo_suspensiva::int2,medio_transporte::int2 from caratula where car_id=caratul;

	update items set s_monto_fob_dolar=s_monto_fob_divisa where s_monto_fob_dolar='';
	update items set s_monto_fob_dolar='0',s_monto_fob_divisa='0' where s_monto_fob_dolar='';

	for registro in select * from items where items_despacho=despachos
	    loop

	    select posa_codigo into posafab from posaran where bpchareq(posa_codigo,trim(registro.posic_arancelaria)::varchar);
		if not found then
		    insert into posaran (posa_codigo,posa_nombre) values (trim(registro.posic_arancelaria),'NN');
		end if;

	    select item_id into elitem from item where item_idoper=operacion and item_item=registro.nro_item::int2;
		if not found then
		    insert into item (item_idoper,item_item,item_existe_sitem,item_moneda,item_tipprod,item_unimed,item_posa,item_bloqueado,item_paisorigen,item_proced,item_tipitem) values (operacion,registro.nro_item::int2,registro.numero_subitem::int2,moned,1,registro.unidad_declarada::int2,trim(registro.posic_arancelaria),1,registro.pais_origen::int2,registro.pais_procedencia::int2,trim(registro.tipo_item));
		    select max(item_id) into elitem from item;
		end if;


	    select artic_id into articulo from articu where artic_indirecto=indirecto and bpchareq(artic_codigo,trim(registro.codigo_articulo)::varchar);
		if not found then
		    insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) values (indirecto,trim(registro.codigo_articulo),trim(registro.marca_articulo),trim(registro.modelo_articulo),trim(registro.descrip_articulo),trim(registro.present_articulo),1,trim(registro.posic_arancelaria),registro.unidad_declarada::int2);
		    select artic_id into articulo from articu where artic_indirecto=indirecto and bpchareq(artic_codigo,trim(registro.codigo_articulo));
		end if;

	    insert into subitem (sitem_iditem,sitem_idoper,sitem_codigo,sitem_artic,sitem_canting,sitem_importe,sitem_imp_dolar,sitem_tipemb,sitem_deposito,sitem_directo,sitem_indirecto,sitem_compbte) values (elitem,operacion,registro.numero_subitem::int2,articulo,registro.s_cant_declarada::numeric,registro.s_monto_fob_divisa::numeric,registro.s_monto_fob_dolar::numeric,0::int2,deposito,directo,indirecto,despachos);

	    end loop;

	update operaciones set op_impdolar=opimpdolar(operacion) where op_id=operacion;



	retval:='t';

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.importo_ingreso(integer, integer, integer, integer, integer, smallint) OWNER TO zona;

--
-- Name: imprim_fact_deta(character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta(character varying, integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_anio=anio and cfc_mes=mes and cfc_ptov=2 group by cfc_usuario order by 1
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_deta(character varying, integer, smallint, smallint) OWNER TO zona;

--
-- Name: imprim_fact_deta_alm(character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta_alm(character varying, integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_anio=anio and cfc_mes=mes and cfc_ptov=2 and cfc_idart in (5,7,11) group by 1 order by 1
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_deta_alm(character varying, integer, smallint, smallint) OWNER TO zona;

--
-- Name: imprim_fact_deta_almxc(character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta_almxc(character varying, integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_mes=mes and cfc_anio=anio and cfc_ptov=2 and cfc_idart in (5,7,11) and cfc_usuario in (258,284,325,377,520,522,568,893,983,1004,1365,1757,1823,4069,4116,4117,4344,4862,5140) group by cfc_usuario
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_deta_almxc(character varying, integer, smallint, smallint) OWNER TO zona;

--
-- Name: imprim_fact_detaxc(character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_detaxc(character varying, integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_mes=mes and cfc_anio=anio and cfc_ptov=2 and cfc_usuario in (258,284,325,377,520,522,568,893,983,1004,1365,1757,1823,4069,4116,4117,4344,4862,5140)  group by cfc_usuario
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_detaxc(character varying, integer, smallint, smallint) OWNER TO zona;

--
-- Name: imprim_fact_detaxc(character varying, integer, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_detaxc(character varying, integer, smallint, smallint, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	usuario		ALIAS FOR $5; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_anio=anio and cfc_mes=mes and cfc_ptov=2 and cfc_usuario=usuario group by cfc_usuario
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_detaxc(character varying, integer, smallint, smallint, integer) OWNER TO zona;

--
-- Name: imprim_fact_detaxc(character varying, integer, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_detaxc(character varying, integer, integer, smallint, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	usuario		ALIAS FOR $5; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:='f';

    for registro in select cfc_usuario as x
    	    from confactur where cfc_mes=11 and cfc_anio=2004 and cfc_ptov=2 and cfc_usuario=usuario group by cfc_usuario
		loop
		    operacion:=genimpre('lexmark',501,registro.x);
		    ret:='t';
		end loop; 
return ret;
	
    END;$_$;


ALTER FUNCTION public.imprim_fact_detaxc(character varying, integer, integer, smallint, integer) OWNER TO zona;

--
-- Name: imptari(integer, integer, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imptari(integer, integer, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
fecha		 alias for $3;
contrato	 alias for $4;
ret 		 numeric;
registro	 record;
importe 	 numeric;
begin

    for registro in select 
	    * from tarifas where tari_usuario=usuario and tari_idart=articulo and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_idcontr=contrato limit 1
	loop
	    importe=registro.tari_imp_dolar;
	    ret= importe;
	    if ret is null then
		ret=registro.tari_importe;
	    end if;
	end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.imptari(integer, integer, date, integer) OWNER TO zona;

--
-- Name: indiconcontr(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indiconcontr(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
locador		 alias for $1;
locatario	 alias for $2;
temporal	 integer;
ret 		 boolean;
begin
ret:='f';

select contr_locatario into temporal from contratos where contr_locador=locador and contr_locatario =locatario and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;

if found then
    ret:='t';
end if;

return ret;

end;$_$;


ALTER FUNCTION public.indiconcontr(integer, integer) OWNER TO zona;

--
-- Name: indirectodeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodeop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_indirecto from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.indirectodeop(integer) OWNER TO zona;

--
-- Name: indirectodeusu(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodeusu(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from operaciones where op_directo= $1 and op_indirecto= $2 limit 1;$_$;


ALTER FUNCTION public.indirectodeusu(integer, integer) OWNER TO zona;

--
-- Name: indirectodewop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodewop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select wop_indirecto from woperaciones where wop_id= $1 ;$_$;


ALTER FUNCTION public.indirectodewop(integer) OWNER TO zona;

--
-- Name: indirectodewret2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodewret2(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select a.wsitem_indirecto from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;$_$;


ALTER FUNCTION public.indirectodewret2(integer) OWNER TO zona;

--
-- Name: itemdeitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION itemdeitem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select item_item from item where item_id= $1 ;$_$;


ALTER FUNCTION public.itemdeitem(integer) OWNER TO zona;

--
-- Name: itemdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION itemdesitem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sitem_iditem from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.itemdesitem(integer) OWNER TO zona;

--
-- Name: itemitemdesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION itemitemdesitem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select item_item from subitem a, item b where a.sitem_iditem=b.item_id and a.sitem_id= $1 ;$_$;


ALTER FUNCTION public.itemitemdesitem(integer) OWNER TO zona;

--
-- Name: leyartic(integer); Type: FUNCTION; Schema: public; Owner: zonab
--

CREATE FUNCTION leyartic(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select art_leyen from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.leyartic(integer) OWNER TO zonab;

--
-- Name: leyrexp(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION leyrexp(integer, smallint) RETURNS character
    LANGUAGE sql
    AS $_$select leyr_leyenda from leyenrexp where leyr_nro= $2 and leyr_idoper= $1 ;$_$;


ALTER FUNCTION public.leyrexp(integer, smallint) OWNER TO zona;

--
-- Name: llevastock(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION llevastock(integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from varambi where vari_codemp= $1 and vari_codigo='STOCK' and vari_valor='1' limit 1;$_$;


ALTER FUNCTION public.llevastock(integer) OWNER TO zona;

--
-- Name: lpad(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION lpad(integer, integer, integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select lpad($1::text,$2,$3::text);$_$;


ALTER FUNCTION public.lpad(integer, integer, integer) OWNER TO zona;

--
-- Name: marcadeartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcadeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_marca from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.marcadeartic(integer) OWNER TO zona;

--
-- Name: marcasitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcasitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_marca from articu a,subitem b where a.artic_id=b.sitem_artic and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.marcasitem(integer) OWNER TO zona;

--
-- Name: marcontdeopv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcontdeopv(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idopv		ALIAS FOR $1;  
	codmarcont	int4;
	indi		int4;
	regi		RECORD;
	trans		varchar;
	trans1		varchar;
	retval		varchar;
    BEGIN

    indi=1;
    for regi in select * from contene where cont_idopv= $1 
    loop
    select marc_descrip into trans from marcont where marc_codigo=regi.cont_marcont;
	trans1:= trans||'-'||regi.cont_nrocont;

	if indi>1 then
		retval:= trans1||' / '||trans||'-'||regi.cont_nrocont;
	    else
		retval:= trans1;
	end if;
	indi:=indi+1;
    end loop;
    
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.marcontdeopv(integer) OWNER TO zona;

--
-- Name: meapeso(smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION meapeso(smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	moneda		ALIAS FOR $1; 
	fecha		ALIAS FOR $2; 
	cotipes		numeric;
	retval 		numeric;
    BEGIN

    select cotpeso(fecha) into cotipes;
    select (cot_cotiz * cotipes) into retval from cotiza WHERE int2eq(moneda,cot_moneda) and  date_le(cot_fecha,fecha) order by cot_fecha desc limit 1;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.meapeso(smallint, date) OWNER TO zona;

--
-- Name: mesastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION mesastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_mes from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.mesastoh(integer) OWNER TO zona;

--
-- Name: migracion(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo1 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from intotal order by int_directo,int_indirecto,int_tipoper,int_numero,int_articod,int_lotenum
	loop
	rowintotal:=regi.int_id;
	operid:=cidop(regi.int_directo::int4,regi.int_indirecto::int4,regi.int_tipoper::int4,	regi.int_numero::int4);	

	if(regi.int_id<270554) then
		ruflo1:=regi.int_idret::int4;
	    else
		ruflo1:=cidart(regi.int_indirecto::int4,regi.int_articod::varchar);
	end if;


	
	if regi.int_lotenum::int2 < 1  then
		insert into item (
    		item_idoper,item_existe_sitem,item_moneda,item_tipprod,item_unimed) 
		values	(operid,0,regi.int_moneda::int2,trim(regi.int_tiprod)::int4,regi.int_unimed::int2);
		select max(item_id) into ruflo from item; 
	end if;
	

	insert into subitem (sitem_iditem,sitem_idoper,sitem_codigo,
			sitem_artic,sitem_canting,sitem_cantret,
			sitem_cantcomp,sitem_importe,sitem_tipemb,
			sitem_deposito,sitem_directo,sitem_indirecto,sitem_compbte)
		values
(ruflo,operid,regi.int_lotenum,ruflo1,	
    regi.int_canting::numeric,regi.int_cantret::numeric,regi.int_cantcomp::numeric,
    regi.int_valori::numeric,regi.int_embalaje::int2,regi.int_deposito::int2,
    regi.int_directo::int4,regi.int_indirecto::int4,regi.int_compbte);

    end loop; 
return ret;
end;$$;


ALTER FUNCTION public.migracion() OWNER TO zona;

--
-- Name: migracion1(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion1() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select distinct on (int_directo,int_indirecto,int_tipoper,int_numero) * from intotal
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,op_deposito,op_conocim,op_peso,op_bultos,op_moneda,op_importe,op_impdolar,op_tipo_cambio,op_embalaje) 
	values
	(regi.int_tipoper::int4,regi.int_directo::int4,regi.int_indirecto::int4,regi.int_compbte::varchar,val_talon(regi.int_tipoper::int4,1),regi.int_numero::int4,regi.int_estado::int2,regi.int_consig::int4,regi.int_fecha::date,regi.int_deposito::int2,regi.int_conocim::varchar,regi.int_peso::numeric,regi.int_bultos::int4,regi.int_moneda::int2,regi.int_fobt::numeric,regi.int_valcte::numeric,regi.int_tipcbo::numeric,regi.int_embalaje::int2);
--	ret:=ret+1;		
        end loop; 

return ret;
end;$$;


ALTER FUNCTION public.migracion1() OWNER TO zona;

--
-- Name: migracion2(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion2() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;


for regi in select distinct on (int_articod,int_directo,int_indirecto) * from intotal
	loop
	select artic_id into ruflo from articu where artic_indirecto=regi.int_indirecto::int4 and artic_codigo=regi.int_articod::varchar;

	if not found then
	insert into articu (artic_indirecto,artic_codigo,artic_descrip,artic_tiprod,artic_unimed) 
	values
	(regi.int_indirecto::int4,regi.int_articod::varchar,regi.int_artidesc::varchar,trim(regi.int_tiprod)::int4,regi.int_unimed::int2);
ret:=ret+1;
	end if;
        end loop; 

return ret;
end;$$;


ALTER FUNCTION public.migracion2() OWNER TO zona;

--
-- Name: migracion_e(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_e() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;
for regi in select distinct on (egt_directo,egt_indirecto,egt_tipoper,egt_numero) * from egretot
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,
	op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,
	op_comptrans,op_peso,op_bultos,op_moneda,op_importe,
	op_impdolar,op_embalaje) 
	values
	(regi.egt_tipoper::int4,regi.egt_directo::int4,regi.egt_indirecto::int4,
	regi.egt_compbte,val_talon(regi.egt_tipoper::int4,1),regi.egt_numero::int4,
	101::int2,regi.egt_consig::int4,regi.egt_fecha::date,
	regi.egt_combteeg::char,regi.egt_peso::numeric,regi.egt_bultos::int4,
	regi.egt_moneda::int2,regi.egt_fobt::numeric,regi.egt_valcte::numeric,
	regi.egt_embalaje::int2	);
	ret:=ret+1;		
        end loop; 

for regi in select * from egretot 
	loop
	operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,	regi.egt_numero::int4);	
	artic_id:=cidart(regi.egt_indirecto::int4,regi.egt_articod::varchar);
	
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,cidsitem(operid,regi.egt_lotenum::int2,regi.egt_compbte::varchar,artic_id),1::int2,0::int2,regi.egt_cantret::numeric);

--	ret:=ret+1;		

    end loop; 

return ret;
end;$$;


ALTER FUNCTION public.migracion_e() OWNER TO zona;

--
-- Name: migracion_e1(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_e1(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
desde	 	alias for $1;
hasta		alias for $2;
regi 		RECORD;
ret		int4;
operid		int4;
operidi		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from egretot where egt_id between desde and hasta
    loop
    operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,regi.egt_numero::int4);
    operidi:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoperin::int4,regi.egt_numeroin::int4);
    artic_id:=cidart(regi.egt_indirecto::int4,trim(regi.egt_articod)::varchar);
    ruflo2=cidsitem(operidi::int4,regi.egt_lotenum::int2,trim(regi.egt_compbte)::varchar,artic_id::int4);
    if ruflo2 is null then ruflo2=0; end if;
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,ruflo2,1::int2,0::int2,regi.egt_cantret::numeric);

ret:=1;
    end loop; 


return ret;
end;$_$;


ALTER FUNCTION public.migracion_e1(integer, integer) OWNER TO zona;

--
-- Name: migracion_ep(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_ep() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;
for regi in select distinct on (trim(egt_directo),trim(egt_indirecto),trim(egt_tipoper),trim(egt_numero)) * from egretot where egt_id>6499
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,
	op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,
	op_comptrans,op_peso,op_bultos,op_moneda,op_importe,
	op_impdolar,op_embalaje) 
	values
	(trim(regi.egt_tipoper)::int4,trim(regi.egt_directo)::int4,trim(regi.egt_indirecto)::int4,
	trim(regi.egt_compbte)::varchar,val_talon(trim(regi.egt_tipoper)::int4,1),trim(regi.egt_numero)::int4,
	trim(regi.egt_esta)::int2,trim(regi.egt_consig)::int4,trim(regi.egt_fecha)::date,
	trim(regi.egt_combteeg)::varchar,trim(regi.egt_peso)::numeric,trim(regi.egt_bultos)::int4,
	trim(regi.egt_moneda)::int2,trim(regi.egt_fobt)::numeric,trim(regi.egt_valcte)::numeric,
	trim(regi.egt_embalaje)::int2	);
	ret:=ret+1;		
        end loop; 

return ret;
end;$$;


ALTER FUNCTION public.migracion_ep() OWNER TO zona;

--
-- Name: migracion_ep1(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_ep1() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare
regi 		RECORD;
ret		int4;
operid		int4;
operidi		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from egretot 
    loop
    operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,regi.egt_numero::int4);

    operidi:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoperin::int4,regi.egt_numeroin::int4);
    artic_id:=cidart(regi.egt_indirecto::int4,trim(regi.egt_articod)::varchar);
    ruflo2=cidsitem(operidi::int4,regi.egt_lotenum::int2,trim(regi.egt_compbte)::varchar,artic_id::int4);
    if ruflo2 is null then ruflo2=0; end if;
	
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,ruflo2,1::int2,0::int2,regi.egt_cantret::numeric);
    end loop; 

return ret;
end;$$;


ALTER FUNCTION public.migracion_ep1() OWNER TO zona;

--
-- Name: mismo_consig(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION mismo_consig(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	op_ing		ALIAS FOR $1; -- id  Op.ING.
	op_egr		ALIAS FOR $2; -- id  Op.EGR.
	retval 		boolean;
    BEGIN
    retval:='f';
    if  int4eq((select op_consig from operaciones where op_id=op_ing),(select op_consig from operaciones where op_id=op_egr)) 
        then retval:='t';
    end if;		

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.mismo_consig(integer, integer) OWNER TO zona;

--
-- Name: modelodeartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION modelodeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_modelo from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.modelodeartic(integer) OWNER TO zona;

--
-- Name: modoalm(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION modoalm(smallint) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	modo		ALIAS FOR $1; 
	retval 		varchar;
    BEGIN

    if int2eq(modo,1::int2) then retval:='VOLUMEN';   end if;
    if int2eq(modo,2::int2) then retval:='CANTIDAD';   end if;
    if int2eq(modo,3::int2) then retval:='PESO';   end if;



    RETURN retval;
    END;$_$;


ALTER FUNCTION public.modoalm(smallint) OWNER TO zona;

--
-- Name: moncteopera(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION moncteopera(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
operacion	alias for $1; 	--operacion
importe 		numeric;
importe_dolar 		numeric;
tipo_cambio 		numeric;
ret 		numeric;
begin


    select op_importe,op_impdolar,op_tipo_cambio into importe,importe_dolar,tipo_cambio from operaciones where op_id=operacion;
	if(tipo_cambio is not null) then   
	    ret:=tipo_cambio;
	  else
	    ret:=importe_dolar / importe;
	end if;

return ret;
END;$_$;


ALTER FUNCTION public.moncteopera(integer) OWNER TO zona;

--
-- Name: monctesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monctesitem(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
sitem		alias for $1; 	--Id del Subitem
registro	RECORD;
operacion	int4;
ret 		numeric;
begin

select sitem_idoper into operacion from subitem where sitem_id=sitem;

for registro in select 
    op_impdolar as impdolar, 
    op_importe as importe, 
    op_tipo_cambio as tc 
     from operaciones where op_id=operacion
	loop

	if(registro.impdolar is null or numeric_eq(registro.impdolar,0::numeric) or registro.importe is null or numeric_eq(registro.importe,0::numeric)) then   
	    registro.importe=1; registro.impdolar=1;
	end if;

	if(registro.tc is not null or numeric_ne(registro.tc,0::numeric)) then 
	    ret:=registro.tc;
	else
	    ret:=registro.impdolar / registro.importe;
	end if;

	end loop; 

return ret;
END;$_$;


ALTER FUNCTION public.monctesitem(integer) OWNER TO zona;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO zona;

--
-- Name: monedadeitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedadeitem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select item_moneda from item where item_id= $1 ;$_$;


ALTER FUNCTION public.monedadeitem(integer) OWNER TO zona;

--
-- Name: monedadeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedadeop(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select op_moneda from operaciones  where op_id= $1;$_$;


ALTER FUNCTION public.monedadeop(integer) OWNER TO zona;

--
-- Name: monedasitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedasitem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select item_moneda from subitem a, item b where a.sitem_iditem=b.item_id and a.sitem_id= $1 ;$_$;


ALTER FUNCTION public.monedasitem(integer) OWNER TO zona;

--
-- Name: monedeempre(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedeempre(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from monex a, astoctas b where a.mne_id= $2 and a.mne_idastoc=b.astc_id and b.astc_codemp= $1 ;$_$;


ALTER FUNCTION public.monedeempre(integer, integer) OWNER TO zona;

--
-- Name: newunif(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION newunif(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select unif_newcod from unifun where unif_codigo = $1;$_$;


ALTER FUNCTION public.newunif(integer) OWNER TO zona;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO zona;

--
-- Name: nomarticusitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomarticusitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select articu.artic_descrip from articu,subitem where subitem.sitem_artic=artic_id and sitem_id= $1 ;$_$;


ALTER FUNCTION public.nomarticusitem(integer) OWNER TO zona;

--
-- Name: nombreciaseg(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombreciaseg(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cs_nombre from ciaseg where cs_id= $1 ;$_$;


ALTER FUNCTION public.nombreciaseg(integer) OWNER TO zona;

--
-- Name: nombredepo(text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombredepo(text) RETURNS character
    LANGUAGE sql
    AS $_$select unif_nombre from unifun where unif_codmaria=trim($1)::int2;$_$;


ALTER FUNCTION public.nombredepo(text) OWNER TO zona;

--
-- Name: nombretgt(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombretgt(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select tgte_nombre from tipgente where tgte_id= $1 ;$_$;


ALTER FUNCTION public.nombretgt(integer) OWNER TO zona;

--
-- Name: nombunifsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombunifsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select unif_nombre from unifun a, subitem b where b.sitem_id= $1 and b.sitem_deposito=a.unif_codigo ;$_$;


ALTER FUNCTION public.nombunifsitem(integer) OWNER TO zona;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO zona;

--
-- Name: nomciaseggte(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomciaseggte(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select nombreciaseg(as_ciaseg) from artseg where as_estado=1 and as_idorig= $1 ;$_$;


ALTER FUNCTION public.nomciaseggte(integer) OWNER TO zona;

--
-- Name: nomcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.nomcli(integer) OWNER TO zona;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO zona;

--
-- Name: nomconpag(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomconpag(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cdp_nombre from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomconpag(integer) OWNER TO zona;

--
-- Name: nomconsig(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomconsig(integer) RETURNS character
    LANGUAGE sql
    AS $_$select csg_nombre from consig where csg_id= $1 ;$_$;


ALTER FUNCTION public.nomconsig(integer) OWNER TO zona;

--
-- Name: nomdespach(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomdespach(integer) RETURNS character
    LANGUAGE sql
    AS $_$select desp_nombre from despach where desp_id= $1 ;$_$;


ALTER FUNCTION public.nomdespach(integer) OWNER TO zona;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO zona;

--
-- Name: nomestadodeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomestadodeop(integer) RETURNS character
    LANGUAGE sql
    AS $_$select eto_nombre from estoper where eto_codigo=estadop($1);$_$;


ALTER FUNCTION public.nomestadodeop(integer) OWNER TO zona;

--
-- Name: nomestusu(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomestusu(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select esc_nombre from estusu where esc_codigo= $1 ;$_$;


ALTER FUNCTION public.nomestusu(smallint) OWNER TO zona;

--
-- Name: nomgente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomgente(integer) RETURNS character
    LANGUAGE sql
    AS $_$select gte_nombre from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.nomgente(integer) OWNER TO zona;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO zona;

--
-- Name: nomivacli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomivacli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva,clientes where iva_codigo=cli_coniva and cli_id= $1 ;$_$;


ALTER FUNCTION public.nomivacli(integer) OWNER TO zona;

--
-- Name: nommoneda(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nommoneda(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_nombre from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.nommoneda(smallint) OWNER TO zona;

--
-- Name: nomopera(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomopera(integer) RETURNS character
    LANGUAGE sql
    AS $_$select operad_nombre from operadores where operad_id= $1 ;$_$;


ALTER FUNCTION public.nomopera(integer) OWNER TO zona;

--
-- Name: nompais(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nompais(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais where pai_codigo= $1 ;$_$;


ALTER FUNCTION public.nompais(smallint) OWNER TO zona;

--
-- Name: nompaiscli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nompaiscli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais,sucursal where pai_codigo=sucu_pais and sucu_cliente= $1 ;$_$;


ALTER FUNCTION public.nompaiscli(integer) OWNER TO zona;

--
-- Name: nomposa(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomposa(character varying) RETURNS character
    LANGUAGE sql
    AS $_$select posa_nombre from posaran where posa_codigo= $1;$_$;


ALTER FUNCTION public.nomposa(character varying) OWNER TO zona;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO zona;

--
-- Name: nomprovcli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomprovcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin,sucursal where pro_codigo=sucu_provin and sucu_cliente= $1 ;$_$;


ALTER FUNCTION public.nomprovcli(integer) OWNER TO zona;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO zona;

--
-- Name: nomptv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.nomptv(integer) OWNER TO zona;

--
-- Name: nomsubtc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomsubtc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select subt_descrip from subtcontrat where subt_id= $1 ;$_$;


ALTER FUNCTION public.nomsubtc(integer) OWNER TO zona;

--
-- Name: nomtipc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtipc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tipc_descrip from tipcontrat where tipc_codigo = $1;$_$;


ALTER FUNCTION public.nomtipc(integer) OWNER TO zona;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtipcta(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO zona;

--
-- Name: nomtiproditem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtiproditem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tip_descrip from tipprod a, item b where a.tip_codigo=b.item_tipprod and b.item_id= $1 ;$_$;


ALTER FUNCTION public.nomtiproditem(integer) OWNER TO zona;

--
-- Name: nomtiprodsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtiprodsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tip_descrip from tipprod a, item b,subitem c where a.tip_codigo=b.item_tipprod and b.item_id=c.sitem_iditem and c.sitem_id= $1 ;$_$;


ALTER FUNCTION public.nomtiprodsitem(integer) OWNER TO zona;

--
-- Name: nomtipusu(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtipusu(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select tpu_nombre from tipusu where tpu_codigo= $1 ;$_$;


ALTER FUNCTION public.nomtipusu(smallint) OWNER TO zona;

--
-- Name: nomunifsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomunifsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select unif_nombre from unifun a,subitem b where a.unif_codigo=b.sitem_deposito and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.nomunifsitem(integer) OWNER TO zona;

--
-- Name: nomusu(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomusu(integer) RETURNS character
    LANGUAGE sql
    AS $_$select usu_nombre from usuarios where usu_codigo = $1;$_$;


ALTER FUNCTION public.nomusu(integer) OWNER TO zona;

--
-- Name: nomusuvta(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomusuvta(integer) RETURNS character
    LANGUAGE sql
    AS $_$select nomusu(vt_usuario) from visita where vt_inout= $1 limit 1;$_$;


ALTER FUNCTION public.nomusuvta(integer) OWNER TO zona;

--
-- Name: nomvend(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomvend(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ven_nombre from vendedor where ven_id= $1 ;$_$;


ALTER FUNCTION public.nomvend(integer) OWNER TO zona;

--
-- Name: nomzona(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomzona(integer) RETURNS character
    LANGUAGE sql
    AS $_$select zon_nombre from zona where zon_codigo= $1 ;$_$;


ALTER FUNCTION public.nomzona(integer) OWNER TO zona;

--
-- Name: nroastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nroastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_numero from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.nroastc(integer) OWNER TO zona;

--
-- Name: nrotaldiroper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nrotaldiroper(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_nrotaldir from operaciones  where op_id= $1;$_$;


ALTER FUNCTION public.nrotaldiroper(integer) OWNER TO zona;

--
-- Name: nrotaldirsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nrotaldirsitem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_nrotaldir from operaciones a,subitem b where a.op_id=b.sitem_idoper and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.nrotaldirsitem(integer) OWNER TO zona;

--
-- Name: numero_letras(numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION numero_letras(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
     numero	ALIAS FOR $1;
     lnEntero INTEGER;
     lcRetorno TEXT = '';
     lnTerna INTEGER = 1;
     lcMiles TEXT;
     lcCadena TEXT;
     maxi TEXT;
     lnUnidades INTEGER;
     lnDecenas INTEGER;
     lnCentenas INTEGER;
     lnFraccion INTEGER;
     lnSw INTEGER;
BEGIN
     lnEntero := FLOOR(numero)::INTEGER;--Obtenemos la parte Entera
     lnFraccion := FLOOR(((numero - lnEntero) * 100))::INTEGER;--Obtenemos la Fraccion del Monto
    -- lcRetorno := '';
    -- lnTerna := 1;
     IF lnEntero > 0 THEN
     lnSw := LENGTH(lnEntero::varchar);
     WHILE lnTerna <= lnSw LOOP
        -- Recorro terna por terna
        lcCadena = '';
        lnUnidades = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnDecenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnCentenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
       SELECT
         CASE /* UNIDADES */
           WHEN lnUnidades = 1 AND lnTerna = 1 THEN 'UNO ' || lcCadena
           WHEN lnUnidades = 1 AND lnTerna <> 1 THEN 'UN ' || lcCadena
           WHEN lnUnidades = 2 THEN 'DOS ' || lcCadena
           WHEN lnUnidades = 3 THEN 'TRES ' || lcCadena
           WHEN lnUnidades = 4 THEN 'CUATRO ' || lcCadena
           WHEN lnUnidades = 5 THEN 'CINCO ' || lcCadena
           WHEN lnUnidades = 6 THEN 'SEIS ' || lcCadena
           WHEN lnUnidades = 7 THEN 'SIETE ' || lcCadena
           WHEN lnUnidades = 8 THEN 'OCHO ' || lcCadena
           WHEN lnUnidades = 9 THEN 'NUEVE ' || lcCadena
           ELSE lcCadena
          END INTO lcCadena;
          /* UNIDADES */
    -- Analizo las decenas
    SELECT
    CASE /* DECENAS */
      WHEN lnDecenas = 1 THEN
        CASE lnUnidades
          WHEN 0 THEN 'DIEZ '
          WHEN 1 THEN 'ONCE '
          WHEN 2 THEN 'DOCE '
          WHEN 3 THEN 'TRECE '
          WHEN 4 THEN 'CATORCE '
          WHEN 5 THEN 'QUINCE '
          ELSE 'DIECI' || lcCadena
        END
      WHEN lnDecenas = 2 AND lnUnidades = 0 THEN 'VEINTE ' || lcCadena
      WHEN lnDecenas = 2 AND lnUnidades <> 0 THEN 'VEINTI' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades = 0 THEN 'TREINTA ' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades <> 0 THEN 'TREINTA Y ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades = 0 THEN 'CUARENTA ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades <> 0 THEN 'CUARENTA Y ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades = 0 THEN 'CINCUENTA ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades <> 0 THEN 'CINCUENTA Y ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades = 0 THEN 'SESENTA ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades <> 0 THEN 'SESENTA Y ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades = 0 THEN 'SETENTA ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades <> 0 THEN 'SETENTA Y ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades = 0 THEN 'OCHENTA ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades <> 0 THEN 'OCHENTA Y ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades = 0 THEN 'NOVENTA ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades <> 0 THEN 'NOVENTA Y ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena; /* DECENAS */
    -- Analizo las centenas
    SELECT
    CASE /* CENTENAS */
      WHEN lnCentenas = 1 AND lnUnidades = 0 AND lnDecenas = 0 THEN 'CIEN ' || lcCadena
      WHEN lnCentenas = 1 AND NOT(lnUnidades = 0 AND lnDecenas = 0) THEN 'CIENTO ' || lcCadena
      WHEN lnCentenas = 2 THEN 'DOSCIENTOS ' || lcCadena
      WHEN lnCentenas = 3 THEN 'TRESCIENTOS ' || lcCadena
      WHEN lnCentenas = 4 THEN 'CUATROCIENTOS ' || lcCadena
      WHEN lnCentenas = 5 THEN 'QUINIENTOS ' || lcCadena
      WHEN lnCentenas = 6 THEN 'SEISCIENTOS ' || lcCadena
      WHEN lnCentenas = 7 THEN 'SETECIENTOS ' || lcCadena
      WHEN lnCentenas = 8 THEN 'OCHOCIENTOS ' || lcCadena
      WHEN lnCentenas = 9 THEN 'NOVECIENTOS ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena;/* CENTENAS */
    -- Analizo la terna
    SELECT
    CASE /* TERNA */
      WHEN lnTerna = 1 THEN lcCadena
      WHEN lnTerna = 2 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0 THEN lcCadena || ' MILLON '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        NOT (lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0) THEN lcCadena || ' MILLONES '
      WHEN lnTerna = 4 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL MILLONES '
      ELSE ''
    END INTO lcCadena;/* TERNA */
 
    --Retornamos los Valores Obtenidos
    lcRetorno = lcCadena  || lcRetorno;
    lnTerna = lnTerna + 1;
    END LOOP;
  END IF;
  IF lnTerna = 1 THEN
    lcRetorno := 'CERO';
  END IF;

  
  IF lnFraccion!= 0  THEN
	lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' CON ' || LTRIM(lnFraccion::varchar) || '/100 CENTAVOS ------';
    else
	lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' ------';
  END IF;

RETURN lcRetorno;
end;$_$;


ALTER FUNCTION public.numero_letras(numeric) OWNER TO zona;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO zona;

--
-- Name: numtalonf(integer, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION numtalonf(integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comprob		ALIAS FOR $2; 
	fecha		ALIAS FOR $3;
	otro 		integer;
	anter		date;
	retval 		integer;
    BEGIN

    select tal_fecha into anter from
    	 talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);

    if(date_le(anter,fecha)) then
	select tal_valor into retval from
    	    talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	if not found then
		otro:=0;
		select tal_valor into retval from talon where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
	     else
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	end if;
      else
        retval:=-1;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalonf(integer, integer, date) OWNER TO zona;

--
-- Name: opdeopv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opdeopv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select opv_idoper from opervehi where opv_id= $1 ;$_$;


ALTER FUNCTION public.opdeopv(integer) OWNER TO zona;

--
-- Name: opera_de_dir_ind(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opera_de_dir_ind(integer, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	directo		ALIAS FOR $1; 
	indirecto	ALIAS FOR $2; 
	tipoper		ALIAS FOR $3; 
	operacion	ALIAS FOR $4; 
	esta 		int4;
	retval 		boolean;
    BEGIN
    retval:='t';

    select op_id into esta from operaciones where
	op_directo=directo and 
	op_indirecto=indirecto and 
	op_tipoper=tipoper and 
	op_id=operacion ;

    if not found  
        then retval:='f';
    end if;		

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.opera_de_dir_ind(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: opera_publicada(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opera_publicada(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	sitem		ALIAS FOR $1; -- id del SubItem.
	estado		int2;
	operacion	int4;
	retval 		boolean;
    BEGIN

    SELECT  sitem_idoper INTO operacion
	    FROM subitem   WHERE int4eq(sitem_id,sitem);

    SELECT  op_estado INTO estado
	    FROM operaciones   WHERE int4eq(op_id,operacion);

    if int2eq(estado,101::int2) then
    	    retval:='t';
	else
	    retval:='f';
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.opera_publicada(integer) OWNER TO zona;

--
-- Name: opimpdolar(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opimpdolar(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(sitem_imp_dolar) from subitem where sitem_idoper= $1 ;$_$;


ALTER FUNCTION public.opimpdolar(integer) OWNER TO zona;

--
-- Name: opverif(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opverif(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select auxo_verif from auxoper where auxo_idoper= $1 ;$_$;


ALTER FUNCTION public.opverif(integer) OWNER TO zona;

--
-- Name: orden_tarifa(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION orden_tarifa(integer, integer) RETURNS smallint
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1;  
	articulo	ALIAS FOR $2; 
	orden		int2;
	retval		int2;
    BEGIN

    retval:=1;
    SELECT  max(tari_orden) INTO orden
	    FROM tarifas   WHERE int4eq(tari_idart,articulo) and int4eq(tari_usuario,usuario);

    if int2gt(orden,0::int2) then
	    retval:= orden + 1;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.orden_tarifa(integer, integer) OWNER TO zona;

--
-- Name: otrconfactur(integer, integer, smallint, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION otrconfactur(integer, integer, smallint, smallint, date) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
fecha		 alias for $5;
ret 		 boolean;
registro	 record;
hay	 	 int4;
importe 	 numeric;
begin

ret:='f';

if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart=articulo and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from tarifas where tari_idart=articulo
		and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:='t';
--	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (registro.tari_usuario,fecha,articulo::int4,1::numeric,valtarico(registro.tari_usuario,articulo,0::numeric,0::int2,fecha::date,registro.tari_idcontr,registro.tari_orden),valtarico(registro.tari_usuario,articulo,0::numeric,0::int2,fecha::date,registro.tari_idcontr,registro.tari_orden),1::int2,anio,mes);
	end loop; 

    else

	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=articulo;
--	select tari_importe into importe from tarifas where tari_idart=articulo and tari_usuario=usuario and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha);
	select valtarico(usuario,articulo,0::numeric,0::int2,fecha::date,tari_idcontr,tari_orden) into importe from tarifas where  estadocontr(tari_idcontr)=1 ;
	insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (usuario,fecha,articulo::int4,1::numeric,importe::numeric,importe::numeric,1::int2,anio,mes);
end if;

return ret;
end;$_$;


ALTER FUNCTION public.otrconfactur(integer, integer, smallint, smallint, date) OWNER TO zona;

--
-- Name: pagfac1(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pagfac1(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
ret 		 varchar;
aux1 		 varchar;
aux2 		 varchar;
codemp	 	 integer;
cuantchq 	 integer;
pago	 	 numeric;
eneft	 	 numeric;
enchq	 	 numeric;
enotr	 	 numeric;
begin
codemp:=1;

    select sum(astc_importe) into pago from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) and astc_importe<0 and codcomp(astc_comprob) not in ('CA','CB');

    if pago is not null then
	ret:='Forma de Pago:';
	select sum(astc_importe) into eneft from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer) and astc_importe>0;
	select sum(astc_importe) into enchq from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
	select sum(astc_importe) into enotr from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
	if eneft is not null then
	    ret:= ret || '  Efectivo                                                      $'|| eneft ;
	  else	    
	    if enchq is not null then
		select count(*) into cuantchq from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
		if (cuantchq>2) then
		    ret:= ret || '  Cheques segun detalle al dorso                                 $'|| enchq ;
		    end if;
		if (cuantchq<3) then
		    select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 order by chq_id asc limit 1;
		    ret:= ret ||' Cheque '|| aux1;
		    end if;
	      else	    
		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;
	    end if;
	end if;

if ret is null then 
    ret:='   ';
end if;

return ret;
end;$_$;


ALTER FUNCTION public.pagfac1(integer) OWNER TO zona;

--
-- Name: pagfac2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pagfac2(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
ret 		 varchar;
aux1 		 varchar;
aux2 		 varchar;
codemp	 	 integer;
cuantchq 	 integer;
pago	 	 numeric;
eneft	 	 numeric;
enchq	 	 numeric;
enotr	 	 numeric;
begin
codemp:=1;

    select sum(astc_importe) into pago from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) and astc_importe<0 and codcomp(astc_comprob) not in ('CA','CB');

    if pago is not null then
	select sum(astc_importe) into eneft from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer) and astc_importe>0;
	select sum(astc_importe) into enchq from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
	select sum(astc_importe) into enotr from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
	if eneft is not null then
	    if enchq is not null then
		select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 limit 1;
		ret:= ret ||' Cheque '|| aux1;
	      else	    
		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;

	  else    

	    if enchq is not null then
		select count(*) into cuantchq from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
		if int4eq(cuantchq,2) then
		    select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 order by chq_id desc limit 1;
		    ret:= ret ||' Cheque '|| aux1;
	    	  else	    
		    if enotr is not null then
			select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
			ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
			end if;
		    end if;

	      else	    

		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;
	    end if;
	end if;

if ret is null then 
    ret:='   ';
end if;

return ret;
end;$_$;


ALTER FUNCTION public.pagfac2(integer) OWNER TO zona;

--
-- Name: paisorideitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION paisorideitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.pai_nombre  from pais a, item b where a.pai_codigo=b.item_paisorigen and b.item_id= $1 ;$_$;


ALTER FUNCTION public.paisorideitem(integer) OWNER TO zona;

--
-- Name: patentede(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION patentede(integer) RETURNS character
    LANGUAGE sql
    AS $_$select lv_patente from livianos where lv_id= $1;$_$;


ALTER FUNCTION public.patentede(integer) OWNER TO zona;

--
-- Name: patinout(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION patinout(integer) RETURNS character
    LANGUAGE sql
    AS $_$select lv_patente from ingxl,inoutliv,livianos where lv_id=iol_liviano and igxl_iol=iol_id and igxl_io= $1 ;$_$;


ALTER FUNCTION public.patinout(integer) OWNER TO zona;

--
-- Name: patoper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION patoper(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
idoper		 alias for $1;
ret 		 varchar;
auxot		 varchar;
begin

    select opv_pat_tractor into ret from opervehi where opv_idoper = idoper limit 1;

    if ret is null then 
	ret:='A/CARGAR';
    end if;

return ret;
end;$_$;


ALTER FUNCTION public.patoper(integer) OWNER TO zona;

--
-- Name: polizagte(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION polizagte(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select as_poliza from artseg where as_idorig= $1 ;$_$;


ALTER FUNCTION public.polizagte(integer) OWNER TO zona;

--
-- Name: posadeartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION posadeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_posa from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.posadeartic(integer) OWNER TO zona;

--
-- Name: posadeitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION posadeitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select item_posa from item where  item_id= $1 ;$_$;


ALTER FUNCTION public.posadeitem(integer) OWNER TO zona;

--
-- Name: precio_unitario(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION precio_unitario(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	item		ALIAS FOR $1; -- id del Sub Item.
	retval 		numeric;
	importe		numeric;
	cantidad	numeric;
    BEGIN
    retval:=0;
    SELECT   sitem_importe,sitem_canting INTO importe,cantidad
	    FROM subitem   WHERE int4eq(sitem_id,item);
    if(importe!=0 and cantidad!=0) then
	retval:= importe / cantidad::numeric;
    end if;	    
	    
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.precio_unitario(integer) OWNER TO zona;

--
-- Name: precio_unitariod(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION precio_unitariod(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	item		ALIAS FOR $1; -- id del Sub Item.
	retval 		numeric;
	importe		numeric;
	cantidad	numeric;
    BEGIN
    retval:=0;
    SELECT   sitem_imp_dolar,sitem_canting INTO importe,cantidad
	    FROM subitem   WHERE int4eq(sitem_id,item);

    if(importe!=0 and cantidad!=0) then
	retval:= importe / cantidad::numeric;
    end if;	    

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.precio_unitariod(integer) OWNER TO zona;

--
-- Name: preciodesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION preciodesitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_importe/sitem_canting from subitem where sitem_importe!=0 and sitem_id= $1 ;$_$;


ALTER FUNCTION public.preciodesitem(integer) OWNER TO zona;

--
-- Name: preciodoldesitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION preciodoldesitem(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sitem_imp_dolar/sitem_canting from subitem where sitem_imp_dolar!=0 and sitem_id= $1 ;$_$;


ALTER FUNCTION public.preciodoldesitem(integer) OWNER TO zona;

--
-- Name: presintdeopv(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION presintdeopv(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idopv		ALIAS FOR $1;  
	codmarcont	int4;
	indi		int4;
	regi		RECORD;
	trans		varchar;
	trans1		varchar;
	retval		varchar;
    BEGIN

    indi=1;
    for regi in select * from contene where cont_idopv= $1 
    loop
	trans1:= regi.cont_preori||'-'||regi.cont_preana;

	if indi>1 then
		retval:= trans1||' / '||regi.cont_preori||'-'||regi.cont_preana;
	    else
		retval:= trans1;
	end if;
	indi:=indi+1;
    end loop;
    
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.presintdeopv(integer) OWNER TO zona;

--
-- Name: procdif(integer, integer, date, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION procdif(integer, integer, date, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idptov		ALIAS FOR $1; 
	ctacble		ALIAS FOR $2;
	fechad		ALIAS FOR $3;
	fechah		ALIAS FOR $4;
	codemp		integer;
	saldo 		numeric;
	coef		numeric;
	coefref		numeric;
	coefaa		numeric;
	coefrel		numeric;
	auximp		numeric;
	mesd		integer;
	aniod		integer;
	mesh		integer;
	anioh		integer;
	mesa		integer;
	anioa		integer;
	tipcta		integer;
	registro	record;
    BEGIN

    select ptv_codemp into codemp from ptovta where ptv_id=idptov;

    select date_part('month',fechad)::integer,date_part('year',fechad)::integer into mesd,aniod;
    select date_part('month',fechah)::integer,date_part('year',fechah)::integer into mesh,anioh;

    mesa:=mesd;
    anioa:=aniod;

    if int4eq(mesd,1) then
	mesa:=12;
	anioa:=anioa-1;
    else
	mesa:=mesa-1;
    end if;

    select inf_coef into coefaa from inflacion where inf_mes=mesa and inf_anio=anioa;
    if coefaa is null then
	coefaa:=1;
    end if;

    RAISE NOTICE 'COEFAA %, PERIODO %-%',coefaa,mesa,anioa;

    mesa:=mesd;
    anioa:=aniod;


    select inf_coef into coefref from inflacion where inf_mes=mesh and inf_anio=anioh;
    if coefref is null then
	coefref:=1;
    end if;


    coefaa:=coefref/coefaa;
    RAISE NOTICE 'COEFAA %',coefaa;
    coefaa:=coefaa-1;
    RAISE NOTICE 'COEFAA %',coefaa;

    if int4lt(mesh,12) then
	mesh:=mesh+1;
    else
	mesh:=1;
	anioh:=anioh+1;
    end if;

    saldo:=0;

    while int4ne(mesa,mesh) or int4ne(anioa,anioh) loop

	RAISE NOTICE 'PERIODO AVANZO %-%, HASTA %-%',mesa,anioa,mesh,anioh;

	select inf_coef into coef from inflacion where inf_mes=mesa and inf_anio=anioa;
	if coef is null then
	    coef:=1;
	end if;


	RAISE NOTICE 'SALDO % ',saldo;

	saldo:=0;

	if int4eq(mesa,mesd) and int4eq(anioa,aniod) then
	    RAISE NOTICE 'PERIODO AVANZO AA %-%, DESDE %-%',mesa,anioa,mesd,aniod;
	    if int4gt(idptov,0) then
		select astc_importe into saldo from astoctas where codcomp(astc_comprob)='AA' and astc_idptov=idptov and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesd and date_part('year',astc_fecval)::integer=aniod;
	    else
		select astc_importe into saldo from astoctas where codcomp(astc_comprob)='AA' and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesd and date_part('year',astc_fecval)::integer=aniod;
	    end if;
	    if saldo is not null then
		saldo:=saldo*coefaa;
	    end if;
	end if;

	if saldo is null then
	    saldo:=0;
	end if;

	coefrel:=coefref/coef;
	coefrel:=coefrel-1;

	if int4gt(idptov,0) then
	    for registro in select * from astoctas where codcomp(astc_comprob) not in ('AA') and astc_idptov=idptov and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesa and date_part('year',astc_fecval)::integer=anioa order by 1 loop 
		saldo:=saldo+(registro.astc_importe*coefrel);
	    end loop;
	    insert into difcta (dc_mes,dc_anio,dc_ctacble,dc_importeacum,dc_codemp,dc_idptov) values (mesa,anioa,ctacble,saldo,codemp,idptov);
	else
	    for registro in select * from astoctas where codcomp(astc_comprob) not in ('AA') and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesa and date_part('year',astc_fecval)::integer=anioa order by 1 loop 
		saldo:=saldo+(registro.astc_importe*coefrel);
	    end loop;
	    insert into difcta (dc_mes,dc_anio,dc_ctacble,dc_importeacum,dc_codemp,dc_idptov) values (mesa,anioa,ctacble,saldo,codemp,idptov);
	end if;

	RAISE NOTICE 'SALDO % ',saldo;

	if int4lt(mesa,12) then
	    mesa:=mesa+1;
	else
	    mesa:=1;
	    anioa:=anioa+1;
	end if;

    end loop;

    RETURN 1;
    END;$_$;


ALTER FUNCTION public.procdif(integer, integer, date, date) OWNER TO zona;

--
-- Name: provdeastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION provdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_ctacte from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'DEUDXC')::integer) limit 1;$_$;


ALTER FUNCTION public.provdeastc(integer) OWNER TO zona;

--
-- Name: provinclie(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION provinclie(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sucu_provin from sucursal where sucu_cliente= $1 and sucu_codigo= $2 ;$_$;


ALTER FUNCTION public.provinclie(integer, integer) OWNER TO zona;

--
-- Name: proxcodprov(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION proxcodprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(prov_codigo)+1 from prove where prov_codemp= $1 ;$_$;


ALTER FUNCTION public.proxcodprov(integer) OWNER TO zona;

--
-- Name: proxgpocli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION proxgpocli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(astc_grupo)+1 from astoctas where astc_codemp=1 and astc_ctacble=18 and astc_ctacte= $1 ;$_$;


ALTER FUNCTION public.proxgpocli(integer) OWNER TO zona;

--
-- Name: pruebaindi(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pruebaindi(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select 't'::boolean as temporal from contratos where contr_locador = $1 and contr_locatario = $2 and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;$_$;


ALTER FUNCTION public.pruebaindi(integer, integer) OWNER TO zona;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO zona;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO zona;

--
-- Name: publico(date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION publico(date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	fecha		ALIAS FOR $1; -- fecha
	registro	RECORD;
	regi		RECORD;
	regi2		RECORD;
	primera		int4;
	estado		int2;
	operacion	int4;
	fecsal		date;
	operaciono	int4;
	fecsalo		date;
	trans		boolean;
	retval		int4;

    BEGIN

    primera:=1;
    estado:=0;

    for registro in
	select * from opervehi where opv_est_camion < 50 and opv_fecha_egr is not null and depositop(opv_idoper) not in (5,6) order by opv_idoper
	loop
	operacion:=registro.opv_idoper;
	fecsal:=registro.opv_fecha_egr;

	if(int4eq(primera,1) or int4ne(operacion,operaciono)) then
		primera:=0;

		if(int2eq(estado,1::int2)) then
		    insert into auxoperv (avh_idoper,avh_fecha_pub) values (operaciono,fecsalo);
		end if;
		estado:=0;

		if(int2eq(registro.opv_est_camion,2::int2) and int2ne(estado,2::int2) and date_le(date(registro.opv_fecha_egr),fecha)) then
		        estado:=1;
		    else
			estado:=2;
		end if;

	    else

		if(int2ne(estado,2::int2) and int2eq(registro.opv_est_camion,2::int2) and date_le(date(registro.opv_fecha_egr),fecha)) then
		        estado:=1;
		    else
			estado:=2;
		end if;

	end if;

	operaciono:=registro.opv_idoper;
	fecsalo:=registro.opv_fecha_egr;

	end loop;

	if(int2eq(estado,1::int2)) then
	    insert into auxoperv (avh_idoper,avh_fecha_pub) values (operaciono,fecsalo);
	    retval:=operaciono;
	end if;


    for regi2 in
	select * from opervehi where opv_est_camion < 50 and opv_fecha_egr is null order by opv_idoper
	loop
	    delete from auxoperv where avh_idoper=regi2.opv_idoper;
	end loop;


    for regi in
	select * from auxoperv  
	loop
	    if(int2lt(estado_opera(regi.avh_idoper),100::int2)) then
		trans:=cambio_estado(regi.avh_idoper,101::int2,1::int2);
		update opervehi set opv_est_camion=50 where opv_idoper=regi.avh_idoper and opv_est_camion < 50;
		if(int4lt(tipoperdeop(regi.avh_idoper),100)) then
			update operaciones set op_fechain=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		    else
			update operaciones set op_fechain=regi.avh_fecha_pub, op_fecha_close=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		end if;
	    end if;
	end loop;


    delete from auxoperv;


    RETURN retval;
    END;$_$;


ALTER FUNCTION public.publico(date) OWNER TO zona;

--
-- Name: publico_oper(date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION publico_oper(date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	fecha		ALIAS FOR $1; -- fecha
	operacion	ALIAS FOR $2; -- operacion
	registro	RECORD;
	regi		RECORD;
	regi2		RECORD;
	entro		int4;
	estado		int2;
	fecsal		date;
	trans		boolean;
	retval		int4;

    BEGIN

    entro:=1;
    estado:=0;

    for registro in
	select * from opervehi where opv_est_camion < 50 and opv_fecha_egr is not null and opv_idoper=operacion
	loop
	fecsal:=date(registro.opv_fecha_egr);
	    if(int2ne(registro.opv_est_camion,2::int2) and date_le(date(registro.opv_fecha_egr),fecha)) then
		estado:=1;
	    end if;
	end loop;

	if(int2ne(estado,1::int2)) then
	    insert into auxoperv (avh_idoper,avh_fecha_pub) values (operacion,fecsal);
	    entro:=2;
	end if;

	retval:=entro;

    for regi2 in
	select * from opervehi where opv_est_camion < 50 and opv_fecha_egr is null and opv_idoper=operacion
	loop
	    delete from auxoperv where avh_idoper=regi2.opv_idoper;
	end loop;


    for regi in
	select * from auxoperv  
	loop
	    if(int2eq(estadop(regi.avh_idoper),1::int2)) then
		trans:=cambio_estado(regi.avh_idoper,101::int2,1::int2);
		update opervehi set opv_est_camion=50 where opv_idoper=regi.avh_idoper and opv_est_camion < 50;
		if(int4lt(tipoperdeop(regi.avh_idoper),100)) then
			update operaciones set op_fechain=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		    else
			update operaciones set op_fechain=regi.avh_fecha_pub, op_fecha_close=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		end if;
	    end if;
	end loop;


    delete from auxoperv;


    RETURN retval;
    END;$_$;


ALTER FUNCTION public.publico_oper(date, integer) OWNER TO zona;

--
-- Name: reenumero(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION reenumero(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
registro	 record;
cantidad	 integer;
ret		 boolean;

begin
cantidad:=1;
ret:='f';
for registro in select 
    * from retiros where ret_idopera=opid order by 1
    loop
	update retiros set ret_item=cantidad where ret_id=registro.ret_id;
	cantidad:=cantidad+1;
	ret:='t';
end loop;

return ret;
end;$_$;


ALTER FUNCTION public.reenumero(integer) OWNER TO zona;

--
-- Name: reparoweb(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION reparoweb(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
aux_texto	 text;
indirecto	 integer;
operacion	 integer;

begin


lock wret2 in access exclusive mode;

drop trigger au_wret2 ON wret2;


for registro in select 
     * from temporalweb
loop


    if(registro.wtmp_valor>0) then
	    update wret2 set wret2_cantidad=registro.wtmp_valor where wret2_id=registro.wtmp_idret;
--	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw-registro.wtmp_compweb+registro.wtmp_valor where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw+registro.wtmp_valor where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    aux_texto:='SE LE COMUNICA QUE SE HA MODIFICADO LA REEXPEDICION NUMERO:  <b>'||idwopdewret2(registro.wtmp_idret)||'</b> QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO <b>'||nomusu(indirectodewret2(registro.wtmp_idret)) ||'</b>.  EL MOTIVO DE ESTA MODIFICACION RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN AL ARTICULO:  <b>'||articulodewret2(registro.wtmp_idret)||'</b> QUE TAMBIEN FUERA COMPROMETIDO POR USTED.  VERIQUE LA CANTIDAD A RETIRAR DE ESE ARTICULO Y FINALIZE NUEVAMENTE LA OPERACION !!!!!!!';
	    ret:=grabonotiweb(directodewret2(registro.wtmp_idret),5,10,'ARTICULOS PARCIALMENTE COMPROMETIDOS',aux_texto);
	    update woperaciones set wop_estado=11 where wop_id=idwopdewret2(registro.wtmp_idret);

	else
	    aux_texto:='SE LE COMUNICA QUE SE HA ELIMINADO DE LA REEXPEDICION NUMERO:  <b>'||idwopdewret2(registro.wtmp_idret)||'</b> QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO <b>'||nomusu(indirectodewret2(registro.wtmp_idret)) ||'</b>.   EL ARTICULO:  <b>'||articulodewret2(registro.wtmp_idret)||' </b> QUE TAMBIEN FUERA COMPROMETIDO POR USTED.  EL MOTIVO RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN DICHO ARTICULO VERIFIQUE NUEVAMENTE LA OPERACION !!!!!!!';
	    ret:=grabonotiweb(directodewret2(registro.wtmp_idret),5,10,'ITEMS DE REEXPEDICIONES ELIMINADOS',aux_texto);
--	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw-registro.wtmp_compweb where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    delete from wret2 where wret2_id=registro.wtmp_idret;
	    update woperaciones set wop_estado=11 where wop_id=idwopdewret2(registro.wtmp_idret);

    end if;
end loop; 

CREATE TRIGGER au_wret2 AFTER UPDATE ON wret2 FOR EACH ROW EXECUTE PROCEDURE f_au_wret2();
			
 delete from temporalweb;
ret:='t';
return ret;
end;$_$;


ALTER FUNCTION public.reparoweb(integer) OWNER TO zona;

--
-- Name: retenig(integer, numeric, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION retenig(integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	imppago		ALIAS FOR $2;
	fecha		ALIAS FOR $3;
	codemp		integer;
	ptov		integer;
	tipct		integer;
	retsn		integer;
	idastoh		integer;
	deudxc		integer;
	ctaretig	integer;
	compnk		integer;
	registro	record;
	totpagt		numeric;
	totrett		numeric;
	totpag 		numeric;
	totret 		numeric;
	mnoi 		numeric;
	tasa 		numeric;
	retval 		numeric;
    BEGIN
    select prov_codemp into codemp from prove where prov_id=provd;
    select prov_idptov into ptov from prove where prov_id=provd;
    select valvaramb(codemp,ptov,'TIPCTADXC') into tipct;	
    select idcbl(codemp,valvaramb(codemp,ptov,'DEUDXC')::int4) into deudxc;
    select idcbl(codemp,valvaramb(codemp,ptov,'CTARETIG')::int4) into ctaretig;
    select valvaramb(codemp,ptov,'MNIRETIG') into mnoi;
    select valvaramb(codemp,ptov,'TASARIG') into tasa;
    select prov_retig into retsn from prove where prov_id=provd;
    select idcomp('NK',1) into compnk;

    totrett:=0;
    totpagt:=0;
    totret:=0;
    totpag:=0;
    retval:=0;


    if int4eq(retsn,1) then

	for registro in select 
         * from astoctas where astc_estado=2 and astc_ctacble=deudxc and astc_tipcta=tipct and astc_ctacte=provd and date_part('year',astc_fecval)=date_part('year',fecha::date) and date_part('month',astc_fecval)=date_part('month',fecha::date) and astc_importe>0 and astc_comprob!=compnk  
	    loop 
	    select sum(astc_importe*-1) into totrett from astoctas where astc_idastoh=registro.astc_idastoh and astc_ctacble=ctaretig and astc_importe<0; 
	    select sum(astc_importe*-1) into totpagt from astoctas where astc_idastoh=registro.astc_idastoh and astc_importe<0; 
	
	    if totpagt is null then
		totpagt:=0;
	    end if;

	    if totrett is null then
		totrett:=0;
	    end if;

	    totpag:= totpag + totpagt;
	    totret:= totret + totrett;
	    
	    end loop;

	    
	if totpag is null then
	    totpag:=0;
	end if;

	if totret is null then
	    totret:=0;
	end if;

	totpag:= ((totpag + imppago)/1.21) - mnoi;


	if(totpag > 0 ) then
	    retval:= ( totpag * tasa / 100) - totret;
	end if;

	if(retval < 0 ) then
	end if;

    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.retenig(integer, numeric, date) OWNER TO zona;

--
-- Name: reti_a_fecha(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION reti_a_fecha(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
idsitem		ALIAS FOR $1; 	-- id del subitem
fecha		ALIAS FOR $2;	-- fecha hasta
difer1 		numeric;
difer2 		numeric;
retval 		numeric;
BEGIN

retval:=0;

select sum(ret_cantidad) into retval from
    retiros where ret_idsitem=idsitem and date_le(fechainop(ret_idopera),fecha) and estadop(ret_idopera)=101;


if retval is null then
    retval:=0;
end if;


select sum(ret_cantidad) into difer1 from
    retiros where ret_idsitem=idsitem and estadop(ret_idopera)=101;

if difer1 is null then
    difer1:=0;
end if;


select sitem_cantret into difer2 from
    subitem where sitem_id=idsitem;

if difer2 is null then
    difer2:=0;
end if;


if numeric_ne(difer2,difer1) then

retval:=retval + difer2 - difer1;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.reti_a_fecha(integer, date) OWNER TO zona;

--
-- Name: reti_a_fechap(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION reti_a_fechap(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
idsitem		ALIAS FOR $1; 	-- id del subitem
fecha		ALIAS FOR $2;	-- fecha hasta
retval 		numeric;
BEGIN

retval:=0;

select sum(ret_cantidad) into retval from
    retiros where ret_idsitem=idsitem and date_le(fechainop(ret_idopera),fecha) and estadop(ret_idopera)=101;


if retval is null then
    retval:=0;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.reti_a_fechap(integer, date) OWNER TO zona;

--
-- Name: retirosafecha(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION retirosafecha(integer, date) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(ret_cantidad) from retiros where ret_idsitem= $1 and date_le(fechainop(ret_idopera), $2) and estadop(ret_idopera)=101;$_$;


ALTER FUNCTION public.retirosafecha(integer, date) OWNER TO zona;

--
-- Name: rexpconfactur(date, date, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION rexpconfactur(date, date, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
desde		 alias for $1;
hasta		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin

ret:='t';
for registro in select 
    * from operaciones where op_estado=101 and date_ge(op_fechain,desde) and date_le(op_fechain,hasta) and op_tipoper in (101,105) 
	loop

	ret:='f';
	select cfc_id into hay from confactur where cfc_idoper=registro.op_id and cfc_idart=35 and cfc_fecha=registro.op_fechain;
	if not found then
	    auxot:=substr(nomusu(registro.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(registro.op_tipoper),1,3) || '-'|| registro.op_nrotaldir;
--	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_indirecto) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,20::numeric,20::numeric,registro.op_id,auxot,1::int2,anio,mes,registro.op_indirecto);
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_indirecto) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,valtari(registro.op_directo,35,0::numeric,0::int2,registro.op_fechain::date),valtari(registro.op_directo,35,0::numeric,0::int2,registro.op_fechain::date),registro.op_id,auxot,1::int2,anio,mes,registro.op_indirecto);
	end if;

end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.rexpconfactur(date, date, smallint, smallint) OWNER TO zona;

--
-- Name: rexpconfacturd(date, date, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION rexpconfacturd(date, date, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
desde		 alias for $1;
hasta		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin

ret:='t';
for registro in select 
    * from operaciones where op_estado=101 and date_ge(op_fechain,desde) and date_le(op_fechain,hasta) and op_tipoper in (101,105) 
	loop

	ret:='f';
	select cfc_id into hay from confactur where cfc_idoper=registro.op_id and cfc_idart=35;
	if not found then
	    auxot:=substr(nomusu(registro.op_indirecto),1,25) || ' / ' || substr(traigo_simbtipoper(registro.op_tipoper),1,3) || '-'|| registro.op_nrotaldir;
--	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_indirecto) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,20::numeric,20::numeric,registro.op_id,auxot,1::int2,anio,mes,registro.op_indirecto);
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_indirecto) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,valtari(registro.op_directo,35,0::numeric,0::int2,registro.op_fechain::date),valtari(registro.op_directo,35,0::numeric,0::int2,registro.op_fechain::date),registro.op_id,auxot,1::int2,anio,mes,registro.op_indirecto);
	end if;
end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.rexpconfacturd(date, date, smallint, smallint) OWNER TO zona;

--
-- Name: sacoauto(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sacoauto(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
idiol		alias for $1;
ret 		boolean;
idio 		int4;
existe 		int4;
existeo		int4;
fecout		timestamp without time zone;
begin

    existeo:=2;
    select ogxl_io into idio from outgxl where ogxl_iol=idiol limit 1;

    if not found then
	select igxl_io into idio from ingxl where igxl_iol=idiol limit 1;
	if not found then
	    ret:='f';
	  else
	    existe:=1;
	    ret:='t';
	end if;
      else
	existeo:=1;
	existe:=1;
	ret:='t';
    end if;

    if int4eq(existe,1::int4) then
	select io_fecout into fecout from inout where io_id=idio;
	if found then
	    update inoutliv set iol_estado=101, iol_fecout=fecout where iol_id=idiol;	    
	    if int4eq(existeo,2::int4) then
		insert into outgxl values(idiol,idio,101);
	    end if;
	end if;
    end if;




return ret;
end;$_$;


ALTER FUNCTION public.sacoauto(integer) OWNER TO zona;

--
-- Name: saldoal(integer, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION saldoal(integer, integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	tipcta		ALIAS FOR $3; 
	ctacte		ALIAS FOR $4;
	fechad		ALIAS FOR $5;
	salant 		numeric;
	retval 		numeric;
    BEGIN
    select sum(astc_importe) into retval from astoctas 
	where astc_codemp=codemp and astc_idptov=ptovta and astc_tipcta=tipcta 
	and astc_ctacte=ctacte and astc_fecval< fechad and astc_cierra= 1
	and astc_estado=2;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldoal(integer, integer, integer, integer, date) OWNER TO zona;

--
-- Name: saldocbl(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION saldocbl(integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	cuenta		ALIAS FOR $3; 
	fechad		ALIAS FOR $4;
	retval 		numeric;
    BEGIN
    if int4eq(codemp,-1) then
	    select sum(astc_importe) into retval from astoctas 
		where astc_ctacble=cuenta and astc_fecval< fechad and astc_estado=2 and codcomp(astc_comprob)!='AR' ;
        else
	    if int4eq(ptovta,0) then
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_ctacble=cuenta 
			    and astc_estado=2 and astc_comprob not in (6,7,147,157) and astc_fecval< fechad;
    		else
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_idptov=ptovta  
			    and astc_ctacble=cuenta and astc_estado=2 and astc_comprob not in (6,7,147,157) 
			    and astc_fecval< fechad ;
	    end if;
    end if;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldocbl(integer, integer, integer, date) OWNER TO zona;

--
-- Name: salgrup(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION salgrup(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	tipcta		ALIAS FOR $2;
	ctacte		ALIAS FOR $3;
	grupo		ALIAS FOR $4;
	esisti		integer;
	retval 		numeric;
    BEGIN
    if int4eq(grupo,0) then
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo is null;
	else
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo=grupo;
    end if;

    if not found then
	retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.salgrup(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: salioel(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION salioel(integer) RETURNS date
    LANGUAGE sql
    AS $_$select fechainop(ret_idopera) from retiros where ret_idsitem = $1 limit 1;$_$;


ALTER FUNCTION public.salioel(integer) OWNER TO zona;

--
-- Name: seg_disponible(smallint, numeric, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION seg_disponible(smallint, numeric, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cod_unifun	ALIAS FOR $1; -- id dela unifun
	valorfob	ALIAS FOR $2; -- Valor Fob
	caso		ALIAS FOR $3; -- Caso 
	
		    --  0=compara parametro contra monto UNIFUN
		    --  1=compara contra la oper (INSERTO DE OP FUTURO)
 
	compara 	numeric;
	aux_seg 	varchar;
	retval 		boolean;
    BEGIN
	if caso=0 then
		SELECT  unif_seguro - unif_valormerca INTO compara FROM unifun   
		    WHERE cod_unifun = unif_codigo;
			retval:=numeric_le(valorfob,compara); 
	    elsif	
	    caso=1 then
		 SELECT  var_valor  INTO     aux_seg 	-- Controla seguro??
		    FROM varamb    WHERE var_codigo like 'SEGURO%';
	    
		 if bpchareq(aux_seg,'NO') then
			return true;
	        else
	    	SELECT  unif_seguro - unif_valormerca INTO compara FROM unifun   
			WHERE cod_unifun = unif_codigo;
	    	retval:=numeric_le(valorfob,compara); 
	        end if;	
	    
	    end if;


    RETURN retval;
    END;$_$;


ALTER FUNCTION public.seg_disponible(smallint, numeric, smallint) OWNER TO zona;

--
-- Name: seg_ok(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION seg_ok(integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cod_operacion	ALIAS FOR $1; -- id dela operacion
	cod_modo	ALIAS FOR $2; -- modo de operacion
-- modo =	1 valido para notificar y devuelvo true
--		2 valido pulenta (notifico y devuelvo true/false segun)
	compara 	numeric;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
	aux_texto 	text;
    BEGIN
    retval:='t';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla seguro??
	    FROM varamb    WHERE var_codigo like 'SEGURO%';
	
    if bpchareq(aux_seg,'NO') 
	then return true;
    end if;

    for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
     from subitem where sitem_idoper=cod_operacion group by sitem_deposito
	loop
	trans:=seg_disponible(registro.x,registro.y,0::int2);

	if booleq(trans,'f') then 
		retval:=trans;	
		aux_texto:='Con la unifun '||registro.x ||' existen problemas de seguro por '||registro.y ||' !!!!!!!!!!';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,cod_operacion,aux_texto);
	    end if;
	end loop; 

	if  bpchareq(aux_seg,'NI') or (int2eq(cod_modo,1::int2)) then
--	if  bpchareq(aux_seg,'NI') then
--	if   (int2eq(cod_modo,1::int2)) then
	    retval:='t';		
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.seg_ok(integer, smallint) OWNER TO zona;

--
-- Name: segunifun(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION segunifun(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(seg_impmoncte) from seguros where seg_estado=1 and seg_importei>0 and seg_unifun= $1 ;$_$;


ALTER FUNCTION public.segunifun(integer) OWNER TO zona;

--
-- Name: sepuedeimportar(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sepuedeimportar(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
begin

ret:='t';

for registro in select 
    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
    from wret2 where wret2_idopera=wopid 
    loop
	if(booleq(ret,'t')) then
	    if(registro.x < registro.y) then
		ret:='f';
	    end if;
	end if;
    end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.sepuedeimportar(integer) OWNER TO zona;

--
-- Name: sibunimedsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sibunimedsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select uni_simbolo from unimed a, item b where a.uni_codigo=b.item_unimed and b.item_id= $1 ;$_$;


ALTER FUNCTION public.sibunimedsitem(integer) OWNER TO zona;

--
-- Name: simbmoneda(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbmoneda(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_simbol from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.simbmoneda(smallint) OWNER TO zona;

--
-- Name: simbunimeditem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimeditem(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	sitem		ALIAS FOR $1;  
	deposito	int2;
	retval		varchar;
    BEGIN

    SELECT  item_unimed INTO deposito
	    FROM item   WHERE int4eq(item_id,sitem);

    SELECT  uni_simbolo INTO retval
	    FROM unimed   WHERE int2eq(uni_codigo,deposito);

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.simbunimeditem(integer) OWNER TO zona;

--
-- Name: simbunimedsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.uni_simbolo from unimed a, item b ,subitem c where int2eq(a.uni_codigo,b.item_unimed) and b.item_id=c.sitem_iditem and c.sitem_id= $1 ;$_$;


ALTER FUNCTION public.simbunimedsitem(integer) OWNER TO zona;

--
-- Name: simbunimedwsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedwsitem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select uni_simbolo from unimed where uni_codigo= $1 ;$_$;


ALTER FUNCTION public.simbunimedwsitem(integer) OWNER TO zona;

--
-- Name: simbunimedwsitem2(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedwsitem2(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.uni_simbolo from unimed a,wsubitem b where a.uni_codigo=b.wsitem_unimed and b.wsitem_id= $1 ;$_$;


ALTER FUNCTION public.simbunimedwsitem2(integer) OWNER TO zona;

--
-- Name: sitemcodigo(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sitemcodigo(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select sitem_codigo from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.sitemcodigo(integer) OWNER TO zona;

--
-- Name: sitemid_almacen(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sitemid_almacen(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select alm_idsitem from almacen where alm_id= $1 ;$_$;


ALTER FUNCTION public.sitemid_almacen(integer) OWNER TO zona;

--
-- Name: sitemid_de_almacen(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sitemid_de_almacen(character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select alm_idsitem from almacen where trim(alm_leyenda)= $1 order by alm_id desc limit 1;$_$;


ALTER FUNCTION public.sitemid_de_almacen(character varying) OWNER TO zona;

--
-- Name: sitemop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sitemop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sitem_idoper from subitem where sitem_id= $1 ;$_$;


ALTER FUNCTION public.sitemop(integer) OWNER TO zona;

--
-- Name: stasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION stasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_stasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.stasaconiva(smallint) OWNER TO zona;

--
-- Name: stepcontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION stepcontr(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select contr_step from contratos where contr_id= $1;$_$;


ALTER FUNCTION public.stepcontr(integer) OWNER TO zona;

--
-- Name: stivacli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION stivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select stasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.stivacli(integer) OWNER TO zona;

--
-- Name: subtotf(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION subtotf(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(movs_importe) from movsto where movs_idastoh= $1 ;$_$;


ALTER FUNCTION public.subtotf(integer) OWNER TO zona;

--
-- Name: tarifb(integer, integer, numeric, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tarifb(integer, integer, numeric, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
canti		 alias for $3;
operacion	 alias for $4;
fecha		 alias for $5;
importe		 numeric;
maximo		 numeric;
minimo		 numeric;
ret 		 numeric;
begin

    select tari_imp_dolar,tari_cdesde,tari_chasta into importe,minimo,maximo from tarifas where tari_usuario=usuario and tari_idart=articulo and 
	date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
	if not found then
	    select tari_imp_dolar,tari_cdesde,tari_chasta into importe,minimo,maximo from tarifas where tari_usuario=1 and tari_idart=articulo and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
	    if not found then
		select tari_imp_dolar,tari_cdesde,tari_chasta into importe,minimo,maximo from tarifas where tari_usuario=1 and tari_idart=articulo and tari_fhasta is null limit 1;
		if not found then
		    importe:=-999999;
		    minimo:=-9998;
		    maximo:=-9999;
		end if;
	    end if;
	end if;

    ret:= importe;

    if(numeric_le(importe,minimo)) then
	ret:= minimo;
    end if;

    if(numeric_ge(importe,maximo)) then
	ret:= maximo;
    end if;

return ret;
end;$_$;


ALTER FUNCTION public.tarifb(integer, integer, numeric, integer, date) OWNER TO zona;

--
-- Name: tariman(integer, integer, numeric, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tariman(integer, integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
canti		 alias for $3;
fecha		 alias for $4;
importe		 numeric;
minimo		 numeric;
maximo		 numeric;
registro	 record;
registrod	 record;
ret 		 numeric;
begin
importe:= 0;

	for registro in select tari_imp_dolar as t, tari_cdesde as d, tari_chasta as h from tarifas 
	    where tari_usuario=usuario and tari_idart=articulo and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    if(canti>=registro.d and canti<=registro.h) then
		importe:=registro.t;
	    end if;
--	    RAISE NOTICE 'ENTRE 1';
	end loop;
	if(importe=0) then
	    for registrod in select tari_imp_dolar as t,tari_cdesde as d,tari_chasta as h from tarifas 
		where tari_usuario=1 and tari_idart=articulo and date_le(tari_fdesde,fecha) and (date_ge(tari_fhasta,fecha) or tari_fhasta is null)
	    loop
		if(canti>=registrod.d and canti<=registrod.h) then
		    importe:=registrod.t;
		end if;
--		RAISE NOTICE 'ENTRE 2 - CANTI % - D % - H % - T %',canti,registrod.d,registrod.h,registrod.t;
	    end loop;
	end if;

	if(importe=0) then
	    select tari_imp_dolar,tari_cdesde,tari_chasta into importe,minimo,maximo from tarifas where tari_usuario=usuario and tari_idart=articulo and 
		date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_cdesde is not null limit 1;
	    if not found then
		select tari_imp_dolar,tari_cdesde,tari_chasta into importe,minimo,maximo from tarifas where tari_usuario=1 and tari_idart=articulo and tari_cdesde is not null and tari_fhasta is null limit 1;
		if not found then
		    importe:=-999999;
		    minimo:=-9998;
		    maximo:=-9999;
		end if;
	    end if;

	    if(numeric_le(importe,minimo)) then
		importe:= minimo;
	    end if;

	    if(numeric_ge(importe,maximo)) then
		importe:= maximo;
	    end if;
--	    RAISE NOTICE 'ENTRE 3';
	end if;

	if(numeric_le(importe,0)) then
	    for registrod in select tari_imp_dolar as t,tari_ddesde as d,tari_dhasta as h from tarifas 
		where tari_usuario=usuario and tari_idart=articulo and date_le(tari_fdesde,fecha) and (date_ge(tari_fhasta,fecha) or tari_fhasta is null) and tari_ddesde is not null
	    loop
		if(canti>=registrod.d and canti<=registrod.h) then
		    importe:=registrod.t;
		end if;
--		RAISE NOTICE 'ENTRE 4';
	    end loop;
	end if;



	ret:= importe;
RETURN ret;
END;$_$;


ALTER FUNCTION public.tariman(integer, integer, numeric, date) OWNER TO zona;

--
-- Name: tarjehabilit(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tarjehabilit(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_tarjeta from gente where gte_estado=1 and gte_tarjeta= $1 ;$_$;


ALTER FUNCTION public.tarjehabilit(integer) OWNER TO zona;

--
-- Name: tarrexb(integer, integer, numeric, integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tarrexb(integer, integer, numeric, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
canti		 alias for $3;
operacion	 alias for $4;
fecha		 alias for $5;
maximo		 numeric;
minimo		 numeric;
porcentaje	 numeric;
importeo	 numeric;
importe		 numeric;
ret 		 numeric;
begin

    select tari_imp_dolar,tari_cdesde,tari_chasta into porcentaje,minimo,maximo from tarifas where tari_usuario=usuario and tari_idart=articulo and 
	date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
	if not found then
	    select tari_imp_dolar,tari_cdesde,tari_chasta into porcentaje,minimo,maximo from tarifas where tari_usuario=1 and tari_idart=articulo and 
		date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
	    if not found then
		select tari_imp_dolar,tari_cdesde,tari_chasta into porcentaje,minimo,maximo from tarifas where tari_usuario=1 and tari_idart=articulo and tari_fhasta is null limit 1;
		if not found then
		    porcentaje:=-99;
		    minimo:=-9998;
		    maximo:=-9999;
		end if;
	    end if;
	end if;


    select sum(op_impdolar+auxo_impsegdol+auxo_impfletdol) into importeo from operaciones,auxoper where op_id=auxo_idoper and op_id=operacion;
	    if not found then
		importeo:=99999999;
	    end if;

    importe:= importeo * porcentaje / 100;
    ret:= importe;

    if(numeric_le(importe,minimo)) then
	ret:= minimo;
    end if;

    if(numeric_ge(importe,maximo)) then
	ret:= maximo;
    end if;

return ret;
end;$_$;


ALTER FUNCTION public.tarrexb(integer, integer, numeric, integer, date) OWNER TO zona;

--
-- Name: tarseg(integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tarseg(integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- user
	valcif		ALIAS FOR $2; 	-- numeric
	ret		numeric;
    BEGIN
ret:=0;

    if int4eq(usuario,614) then
	if numeric_lt(valcif,100000) then
	    ret:= 0.003;
	else
	    if numeric_lt(valcif,300000) then
		ret:= 0.002;
	    else
		ret:= 0.001;
	    end if;
	end if;
    else
	if int4eq(usuario,5217) or int4eq(usuario,113) or int4eq(usuario,9918) or int4eq(usuario,9618) or int4eq(usuario,9718) or int4eq(usuario,9518) or int4eq(usuario,9818) then
	    ret:=0.001;
	else
	    if int4eq(usuario,12719) or int4eq(usuario,13520) or int4eq(usuario,1616) then
		if numeric_lt(valcif,1000000) then
		    ret:= 0.0015;
		else
		    ret:= 0.001;
		end if;
	    else
		if int4eq(usuario,6418) then
		    ret:= 0.002;
		else
		    if int4eq(usuario,8718) or int4eq(usuario,10518) or int4eq(usuario,7318) or int4eq(usuario,8818) or int4eq(usuario,9118) or int4eq(usuario,13220) then
			if numeric_lt(valcif,300000) then
			    ret:= 0.002;
			else
			    if numeric_lt(valcif,1000000) then
				ret:= 0.0015;
			    else
				ret:= 0.001;
			    end if;
			end if;
		    else
			if int4eq(usuario,6017) then
			    ret:=0.0008;
			else
			    if numeric_lt(valcif,100000) then
				ret:= 0.003;
			    else
				if numeric_lt(valcif,300000) then
				    ret:= 0.002;
				else
				    if numeric_lt(valcif,1000000) then
					ret:= 0.0015;
				    else
					ret:= 0.001;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
    end if;
RETURN ret;
END;$_$;


ALTER FUNCTION public.tarseg(integer, numeric) OWNER TO zona;

--
-- Name: tasaartic(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tasaartic(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select art_tasa from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.tasaartic(integer) OWNER TO zona;

--
-- Name: tasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_tasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.tasaconiva(smallint) OWNER TO zona;

--
-- Name: tasaiva_fe(numeric); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION tasaiva_fe(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	imp		ALIAS FOR $1;
	inte		integer;
	retval		text;
    BEGIN
	if (numeric_eq(imp,0)) then
	    inte:=3;
	else
	    if (numeric_eq(imp,10.5)) then
		inte:=4;
	    else
		if (numeric_eq(imp,21)) then
		    inte:=5;
		else
		    if (numeric_eq(imp,27)) then
			inte:=6;
		    else
			if (numeric_eq(imp,5)) then
			    inte:=8;
			else
			    if (numeric_eq(imp,2.5)) then
				inte:=9;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
	select lpad(inte::text,4,'0') into retval;
	RETURN retval;
    END;$_$;


ALTER FUNCTION public.tasaiva_fe(numeric) OWNER TO estlm;

--
-- Name: tdocgente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tdocgente(integer) RETURNS character
    LANGUAGE sql
    AS $_$select gte_tdoc from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.tdocgente(integer) OWNER TO zona;

--
-- Name: tdocngente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tdocngente(integer) RETURNS character
    LANGUAGE sql
    AS $_$select gte_tdoc ||'  -  '||gte_nrodoc from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.tdocngente(integer) OWNER TO zona;

--
-- Name: tgtegte(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tgtegte(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select tgte_tipo from tipgente where tgte_id= $1 ;$_$;


ALTER FUNCTION public.tgtegte(integer) OWNER TO zona;

--
-- Name: tiene_funcion(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tiene_funcion(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idreg		ALIAS FOR $1;  -- id del registro
	idartic		ALIAS FOR $2;  -- id del articulo 
	idoper		ALIAS FOR $3; 
	tabla		ALIAS FOR $4;  -- 1=voling   y   2=volegr 
	modo		int4;
	pase		int4;
	sinfun		int4;
	registro	record;
	valorfob	text;
	funcion		text;
	funcion2	text;
	funcion3	text;
	cotiz		text;
	peso		text;
	volumen		numeric;
	cantidad	numeric;
	preciopul	numeric;
	precio		numeric;
	retval		numeric;
    BEGIN
    retval:=0;
    pase:=0;
    sinfun:=1;

	select cfac_funcion into funcion from complfac where cfac_id=idreg;
	if not found then
	    select art_funcion into funcion from articvta where art_id=idartic;
	    if not found then
		sinfun:=0;
	    end if;
	end if;


	select cfac_precio into preciopul from complfac where cfac_id=idreg;
	if not found then
	    select art_precio into precio from articvta where art_id=idartic;
	end if;

if sinfun then
	if funcion then
	    if numeric_gt(preciopul,0) then
		    retval:=preciopul; 
		else
		    if(precio) then
			retval:=precio; 
		    end if;
	    end if;
	end if;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.tiene_funcion(integer, integer, integer, integer) OWNER TO zona;

--
-- Name: tiene_vol(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tiene_vol(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(vol_canting-vol_cantret) from voling where vol_estado=101 and vol_cliente= $1 ;$_$;


ALTER FUNCTION public.tiene_vol(integer) OWNER TO zona;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO zona;

--
-- Name: tipgentedeusu(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipgentedeusu(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_id from gente where gte_tipo= $1 and gte_id= $2 ;$_$;


ALTER FUNCTION public.tipgentedeusu(integer, integer) OWNER TO zona;

--
-- Name: tipo_de_contrato(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipo_de_contrato(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select subt_idtipc from subtcontrat where subt_id= $1 ;$_$;


ALTER FUNCTION public.tipo_de_contrato(integer) OWNER TO zona;

--
-- Name: tipoperdeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipoperdeop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_tipoper from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.tipoperdeop(integer) OWNER TO zona;

--
-- Name: tipprod_item(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_item(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	itemc	ALIAS FOR $1; -- id del Item
	tipo	int4;
    BEGIN
    SELECT item_tipprod into tipo
	FROM item WHERE item_id = itemc;
    RETURN tipo;
    END;$_$;


ALTER FUNCTION public.tipprod_item(integer) OWNER TO zona;

--
-- Name: tipprod_ok(integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_ok(integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; -- id dela operacion
	unifun		ALIAS FOR $2; -- id unifun
	modo		ALIAS FOR $3; -- modo
-- modo =	1 valido para notificar y devuelvo true
--		2 valido pulenta (notifico y devuelvo true/false segun)
	compara 	numeric;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
	aux_texto 	text;
    BEGIN
    retval:='t';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla tipo de merca?
	    FROM varamb    WHERE var_codigo like 'VALID_TIPMERC%';
	
    if bpchareq(aux_seg,'NO') 
	then return true;
    end if;

    for registro in select sitem_iditem as x,sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by x,y
	loop
	trans:=tipprod_posible(registro.y::int2,tipprod_item(registro.x));

	if booleq(trans,'f') then 
		retval:=trans;	
		aux_texto:='La unidad funcional '||registro.y||'  ('||traigo_nomunifun(registro.y) ||')  no tolera el ingreso de mercaderia del tipo '||tipprod_item(registro.x) ||' debera cambiar de ubicacion la misma. Notifique al usuario ';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    end if;
	end loop; 

	if  bpchareq(aux_seg,'NI') or (int2eq(modo,1::int2)) then
	    retval:='t';		
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.tipprod_ok(integer, smallint, smallint) OWNER TO zona;

--
-- Name: tipprod_posible(smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_posible(smallint, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	unifun		ALIAS FOR $1; -- id de Unifun.
	tipmerc		ALIAS FOR $2; -- tipo de Mercaderia
	compara 	numeric;
	registro 	RECORD;
	kk 		int2;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
    BEGIN
    retval:='t';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla Tipo de Merca??
	    FROM varamb    WHERE var_codigo like 'VALID_TIPMERC%';
	
    if bpchareq(aux_seg,'NO') 
	then return true;
    end if;


    select txu_codtipp into kk from tippxunif where 
	    int4eq(txu_codtipp,tipmerc) and 
		int2eq(txu_codunif,unifun);
    if not found then 
	return false;
    end if;


    if bpchareq(aux_seg,'NI')  then
	    retval:='t';		
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.tipprod_posible(smallint, integer) OWNER TO zona;

--
-- Name: tipproditem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipproditem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select item_tipprod from item where item_id = $1;$_$;


ALTER FUNCTION public.tipproditem(integer) OWNER TO zona;

--
-- Name: tipprodsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprodsitem(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	sitem		ALIAS FOR $1;  
	iditem		int4;
	retval		int4;
    BEGIN

    select sitem_iditem into iditem from subitem where sitem_id= $1 ;

    select item_tipprod into retval from item where item_id=iditem;
    
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.tipprodsitem(integer) OWNER TO zona;

--
-- Name: tipprove(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprove(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_tipo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.tipprove(integer) OWNER TO zona;

--
-- Name: tiprodsitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tiprodsitem(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select item_tipprod from item b, subitem c where  b.item_id=c.sitem_iditem and c.sitem_id= $1 ;$_$;


ALTER FUNCTION public.tiprodsitem(integer) OWNER TO zona;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO zona;

--
-- Name: tivacli(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select tasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.tivacli(integer) OWNER TO zona;

--
-- Name: totdescto(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totdescto(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTADESCTO')::integer);$_$;


ALTER FUNCTION public.totdescto(integer) OWNER TO zona;

--
-- Name: totfactu(integer, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totfactu(integer, smallint, smallint, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
anio		 alias for $2;
mes		 alias for $3;
articulo	 alias for $4;
ret 		 numeric;

begin

if int4eq(articulo,0) then 
    select sum(cfc_importe) into ret from confactur where cfc_usuario=usuario and cfc_anio=anio and cfc_mes=mes;
  else
    select sum(cfc_importe) into ret from confactur where cfc_usuario=usuario and cfc_anio=anio and cfc_mes=mes and cfc_idart=articulo;
end if;

return ret;
end;$_$;


ALTER FUNCTION public.totfactu(integer, smallint, smallint, integer) OWNER TO zona;

--
-- Name: totimpastc(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totimpastc(integer, integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select astc_importe from astoctas where astc_ctacble= $1 and astc_idastoh= $2 ;$_$;


ALTER FUNCTION public.totimpastc(integer, integer) OWNER TO zona;

--
-- Name: totiva21(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totiva21(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTAIVA')::integer);$_$;


ALTER FUNCTION public.totiva21(integer) OWNER TO zona;

--
-- Name: totivast(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totivast(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTAIVAST')::integer);$_$;


ALTER FUNCTION public.totivast(integer) OWNER TO zona;

--
-- Name: totretirado(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totretirado(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(r.ret_cantidad * (s.sitem_imp_dolar / s.sitem_canting)) from retiros r, subitem s where r.ret_idopera= $1 and r.ret_idsitem=s.sitem_id;$_$;


ALTER FUNCTION public.totretirado(integer) OWNER TO zona;

--
-- Name: tposastc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tposastc(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_importe>0 ;$_$;


ALTER FUNCTION public.tposastc(integer) OWNER TO zona;

--
-- Name: trae_cotiza(smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION trae_cotiza(smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
moneda		 alias for $1;
fecha		 alias for $2;
ret 		 numeric;
begin
     SELECT  cot_cotiz  INTO     ret 
	    FROM cotiza    
		WHERE int2eq(moneda,cot_moneda) and  
		    date_le(cot_fecha,fecha) 
	    order by cot_fecha desc limit 1;
return ret;
END;$_$;


ALTER FUNCTION public.trae_cotiza(smallint, date) OWNER TO zona;

--
-- Name: traigo_codarticu(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_codarticu(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_codigo from articu a,subitem b where a.artic_id=b.sitem_artic and b.sitem_id= $1 ;$_$;


ALTER FUNCTION public.traigo_codarticu(integer) OWNER TO zona;

--
-- Name: traigo_compbte(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_compbte(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_compbte from operaciones a, subitem b where b.sitem_id= $1 and b.sitem_idoper=a.op_id ;$_$;


ALTER FUNCTION public.traigo_compbte(integer) OWNER TO zona;

--
-- Name: traigo_moneda(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_moneda(integer) RETURNS character
    LANGUAGE sql
    AS $_$select mon_simbol from moneda a, item b where a.mon_codigo=b.item_moneda and b.item_id= $1 ;$_$;


ALTER FUNCTION public.traigo_moneda(integer) OWNER TO zona;

--
-- Name: traigo_nomarticu(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomarticu(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artic_descrip from articu where artic_id= $1 ;$_$;


ALTER FUNCTION public.traigo_nomarticu(integer) OWNER TO zona;

--
-- Name: traigo_nomtipoper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomtipoper(integer) RETURNS character
    LANGUAGE sql
    AS $_$select top_nombre from tipoper where top_codigo= $1 ;$_$;


ALTER FUNCTION public.traigo_nomtipoper(integer) OWNER TO zona;

--
-- Name: traigo_nomunifun(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomunifun(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select unif_nombre from unifun where unif_codigo= $1 ;$_$;


ALTER FUNCTION public.traigo_nomunifun(smallint) OWNER TO zona;

--
-- Name: traigo_simbtipoper(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_simbtipoper(integer) RETURNS character
    LANGUAGE sql
    AS $_$select top_comprob from tipoper where top_codigo= $1 ;$_$;


ALTER FUNCTION public.traigo_simbtipoper(integer) OWNER TO zona;

--
-- Name: transfieroweb(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transfieroweb(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registleye	 record;
registwr	 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
idop		 integer;
primera		 integer;
elestado	 smallint;
begin

ret:='t';
idop:=0;

select wop_estado into elestado from woperaciones where wop_id=wopid;

if found then
    if int2eq(elestado,1::int2) then

	for registro in select 
	    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
	    from wret2 where wret2_idopera=wopid 
	    loop
		if(booleq(ret,'t')) then
		    if(registro.x < registro.y) then
			ret:='f';
		    end if;
		end if;
	    end loop; 


	if(booleq(ret,'t')) then

		insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo) from woperaciones where wop_id = wopid;

		select op_id into idop from operaciones where op_idopw=wopid;

		for regist in select 
		    * from wret2 where wret2_idopera=wopid
		loop
		    insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad) values (idop,regist.wret2_idsitem,regist.wret2_item,regist.wret2_sitem,regist.wret2_cantidad);
		    update wsubitem set wsitem_cantcomp=wsitem_cantcomp+regist.wret2_cantidad, wsitem_cantcompw=wsitem_cantcompw-regist.wret2_cantidad where wsitem_id=regist.wret2_idsitem;
		end loop; 

		for registleye in select 
		    * from wleyenrexp where wleyr_idoper=wopid
		loop
		    insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
		end loop; 

		update woperaciones set wop_estado=50 where wop_id=wopid;

		for registwr in select 
		    * from retiros where ret_idopera=idop
		loop
		    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir,wret_estado) 
			values (registwr.ret_id,registwr.ret_idopera,registwr.ret_idsitem,registwr.ret_item,registwr.ret_sitem,registwr.ret_cantidad,registwr.ret_idsitemc,compbteoper(registwr.ret_idopera),tipoperdeop(registwr.ret_idopera),nrotaldiroper(registwr.ret_idopera),1::int2);
		end loop; 


	    else


		for registw2 in select 
		    * from wret2 where wret2_idopera=wopid 
	        loop

		primera:=0;
		elultimo:=0;
		dispon:=0;
		dispon:=cantidisponib(registw2.wret2_idsitem);
		elultimo:=registw2.wret2_cantidad;

		if(elultimo<=dispon) then
			if(int4eq(primera,0)) then
			    insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo) from woperaciones where wop_id = wopid;
			    select op_id into idop from operaciones where op_idopw=wopid;
			    for registleye in select 
				* from wleyenrexp where wleyr_idoper=wopid
			    loop
				insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
			    end loop; 
			    primera:=1;
			end if;

			update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;

		    else
			if(dispon <= 0) then
				insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,-1);
    			    else
				insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,dispon);
			end if;
		end if;
		end loop; 

		ret:=reparoweb(1);
	end if;
    end if;
end if;
return idop;
end;$_$;


ALTER FUNCTION public.transfieroweb(integer) OWNER TO zona;

--
-- Name: transfreexpdeweb(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transfreexpdeweb(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registleye	 record;
registwr	 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
idop		 integer;
primera		 integer;
entre		 integer;
elestado	 smallint;
aux_texto	 text;
aux_texto1	 text;
aux_texto2	 text;
aux_texto3	 text;
begin

ret:='t';
entre:=0;
idop:=0;

select wop_estado into elestado from woperaciones where wop_id=wopid;

if found then
    if int2eq(elestado,1::int2) then
	for registro in select 
	    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
	    from wret2 where wret2_idopera=wopid 
	    loop
		entre:=1;
		if(booleq(ret,'t')) then
		    if(registro.x < registro.y) then
			ret:='f';
		    end if;
		end if;
	    end loop; 


    if int4eq(entre,0) then
	ret:='f';
    end if;


	if(booleq(ret,'t')) then

		insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir,op_consig) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo),wop_consig from woperaciones where wop_id = wopid;

		select op_id into idop from operaciones where op_idopw=wopid;

		for regist in select 
		    * from wret2 where wret2_idopera=wopid
		loop
		    insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad) values (idop,regist.wret2_idsitem,regist.wret2_item,regist.wret2_sitem,regist.wret2_cantidad);
		    update wsubitem set wsitem_cantcomp=wsitem_cantcomp+regist.wret2_cantidad, wsitem_cantcompw=wsitem_cantcompw-regist.wret2_cantidad where wsitem_id=regist.wret2_idsitem;
		end loop; 

		for registleye in select 
		    * from wleyenrexp where wleyr_idoper=wopid
		loop
		    insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
		end loop; 

		update woperaciones set wop_estado=50 where wop_id=wopid;

		for registwr in select 
		    * from retiros where ret_idopera=idop
		loop
		    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir,wret_estado) 
			values (registwr.ret_id,registwr.ret_idopera,registwr.ret_idsitem,registwr.ret_item,registwr.ret_sitem,registwr.ret_cantidad,registwr.ret_idsitemc,compbteoper(registwr.ret_idopera),tipoperdeop(registwr.ret_idopera),nrotaldiroper(registwr.ret_idopera),1::int2);
		end loop; 


	    else


		for registro in select 
		    * from wret2 where wret2_idopera=wopid 
		loop

		    delete from wretiros where wret_idsitem=registro.wret2_idsitem; 

		    for regist in select 
			* from retiros where ret_idsitem=registro.wret2_idsitem
			loop
			    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			end loop; 


		    if(registro.wret2_cantidad<=cantidisponib(registro.wret2_idsitem)) then

			    update wsubitem set wsitem_cantcompw=cantcompwdeidwsitem(registro.wret2_idsitem),wsitem_canting=cantingdeidsitem(registro.wret2_idsitem),wsitem_cantcomp=cantcompdeidsitem(registro.wret2_idsitem),wsitem_cantret=cantretdeidsitem(registro.wret2_idsitem),wsitem_cantmala=cantmaladeidsitem(registro.wret2_idsitem) where wsitem_id=registro.wret2_idsitem;

			else

			    aux_texto2:='<br> SE HA ELIMINADO EL ARTICULO  <B> '||codartdewret2(registro.wret2_id)||'</B> EL CUAL USTED HABIA COMPROMETIDO POR UNA CANTIDAD DE : <B>'||registro.wret2_cantidad||'</B> ';
			    insert into temporalweb (wtmp_idwop,wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (wopid,registro.wret2_idsitem,cantidisponib(registro.wret2_idsitem),registro.wret2_cantidad,registro.wret2_id,-1);

		    end if;

		end loop; 

		aux_texto:='SE LE COMUNICA QUE NO SE HA PODIDO PROCESAR LA REEXPEDICION NUMERO:  <b>'||wopid||' </b>QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO  <b>'||nomusu(indirectodewop(wopid))||' </b>.  EL MOTIVO DE ESTA MODIFICACION RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN AL/LOS SIGUIENTES ARTICULOS POR USTED COMPROMETIDOS '||aux_texto2||'<BR>   VERIQUE NUEVAMENTE LA OPERACION Y FINALICELA !!!!!!! ';
		ret:=grabonotiweb(directodewop(wopid),5,10,'ERROR EN LA IMPORTACION DE REEXPEDICIONES',aux_texto);
		update woperaciones set wop_estado=11 where wop_id=wopid;



		for registro in select 
    		    * from temporalweb where wtmp_idwop=wopid
		    loop
			update wsubitem set wsitem_canting=cantingdeidsitem(registro.wtmp_idsitem),wsitem_cantcomp=cantcompdeidsitem(registro.wtmp_idsitem),wsitem_cantret=cantretdeidsitem(registro.wtmp_idsitem),wsitem_cantmala=cantmaladeidsitem(registro.wtmp_idsitem) where wsitem_id=registro.wtmp_idsitem;
			delete from wret2 where wret2_id=registro.wtmp_idret;
		    end loop; 
			
		delete from temporalweb where wtmp_idwop=wopid;

	end if;
    end if;
end if;
return idop;
end;$_$;


ALTER FUNCTION public.transfreexpdeweb(integer) OWNER TO zona;

--
-- Name: transitodeop(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transitodeop(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_comptrans from operaciones where op_id= $1 ;$_$;


ALTER FUNCTION public.transitodeop(integer) OWNER TO zona;

--
-- Name: transitositem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transitositem(integer) RETURNS character
    LANGUAGE sql
    AS $_$select op_comptrans from operaciones a, subitem b where b.sitem_id= $1 and b.sitem_idoper=a.op_id ;$_$;


ALTER FUNCTION public.transitositem(integer) OWNER TO zona;

--
-- Name: trato(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION trato(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select tgte_trato from tipgente where tgte_id= $1;$_$;


ALTER FUNCTION public.trato(integer) OWNER TO zona;

--
-- Name: tratodegente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tratodegente(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select tgte_trato from gente,tipgente where tgte_id= gte_tipo and gte_id= $1;$_$;


ALTER FUNCTION public.tratodegente(integer) OWNER TO zona;

--
-- Name: ult_auto(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ult_auto(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select iol_liviano from inoutliv where iol_estado=101 and iol_barreo= $1 order by iol_fecout desc limit 1;$_$;


ALTER FUNCTION public.ult_auto(integer) OWNER TO zona;

--
-- Name: ult_autoi(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ult_autoi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select iol_liviano from inoutliv where iol_estado=1 and iol_barrei= $1 order by iol_fecin desc limit 1;$_$;


ALTER FUNCTION public.ult_autoi(integer) OWNER TO zona;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO zona;

--
-- Name: ulticont(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ulticont(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
opid		 alias for $1;
ret 		 int4;
begin
select max(contr_id) into ret from contratos;
return ret;
end;$_$;


ALTER FUNCTION public.ulticont(integer) OWNER TO zona;

--
-- Name: ultiopeindi(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ultiopeindi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select op_id from operaciones WHERE op_estado=101 and op_tipoper in (101,105) and op_indirecto= $1 order by op_fechain desc limit 1;$_$;


ALTER FUNCTION public.ultiopeindi(integer) OWNER TO zona;

--
-- Name: unifunes(integer, integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION unifunes(integer, integer, integer, smallint) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
declare
locador		 alias for $1;
locatario	 alias for $2;
idsubt		 alias for $3;
estado		 alias for $4;
ret		 character varying;
registro	 record;

begin

	ret='';
	for registro in select * from contratos
	      where contr_locador=locador and contr_locatario=locatario and contr_idsubt=idsubt
		and contr_estado=estado order by contr_unifun
	    loop
		if(char_length(ret)<1) then
		    ret:=registro.contr_unifun;
		  else
		    ret:=ret ||' -  '||registro.contr_unifun;
		end if;
	    end loop;


return ret;
end;$_$;


ALTER FUNCTION public.unifunes(integer, integer, integer, smallint) OWNER TO zona;

--
-- Name: unifunesnewxd(integer, integer, integer, smallint, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION unifunesnewxd(integer, integer, integer, smallint, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
declare
locador		 alias for $1;
locatario	 alias for $2;
idsubt		 alias for $3;
estado		 alias for $4;
dispos		 alias for $5;
ret		 character varying;
registro	 record;
begin

	ret='';
	if dispos is not null then
	    for registro in select * from contratos
	      where contr_locador=locador and contr_locatario=locatario and contr_idsubt=idsubt
		and contr_estado=estado and bpchareq(trim(dispos),trim(contr_dispos)) order by contr_unifun
		loop
		    if(char_length(ret)<1) then
			ret:=newunif(registro.contr_unifun);
		      else
			ret:=ret ||' -  '||newunif(registro.contr_unifun);
		    end if;
		end loop;
	  else
	    for registro in select * from contratos
	      where contr_locador=locador and contr_locatario=locatario and contr_idsubt=idsubt
		and contr_estado=estado order by contr_unifun
		loop
		    if(char_length(ret)<1) then
			ret:=newunif(registro.contr_unifun);
		      else
			ret:=ret ||' -  '||newunif(registro.contr_unifun);
		    end if;
		end loop;
	end if;


return ret;
end;$_$;


ALTER FUNCTION public.unifunesnewxd(integer, integer, integer, smallint, character varying) OWNER TO zona;

--
-- Name: unifunesxd(integer, integer, integer, smallint, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION unifunesxd(integer, integer, integer, smallint, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
declare
locador		 alias for $1;
locatario	 alias for $2;
idsubt		 alias for $3;
estado		 alias for $4;
dispos		 alias for $5;
ret		 character varying;
registro	 record;
begin

	ret='';
	if dispos is not null then
	    for registro in select * from contratos
	      where contr_locador=locador and contr_locatario=locatario and contr_idsubt=idsubt
		and contr_estado=estado and bpchareq(trim(dispos),trim(contr_dispos)) order by contr_unifun
		loop
		    if(char_length(ret)<1) then
			ret:=registro.contr_unifun;
		      else
			ret:=ret ||' -  '||registro.contr_unifun;
		    end if;
		end loop;
	  else
	    for registro in select * from contratos
	      where contr_locador=locador and contr_locatario=locatario and contr_idsubt=idsubt
		and contr_estado=estado order by contr_unifun
		loop
		    if(char_length(ret)<1) then
			ret:=registro.contr_unifun;
		      else
			ret:=ret ||' -  '||registro.contr_unifun;
		    end if;
		end loop;
	end if;


return ret;
end;$_$;


ALTER FUNCTION public.unifunesxd(integer, integer, integer, smallint, character varying) OWNER TO zona;

--
-- Name: unimeddeitem(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION unimeddeitem(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select item_unimed from item where item_id= $1 ;$_$;


ALTER FUNCTION public.unimeddeitem(integer) OWNER TO zona;

--
-- Name: usuario_inout(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usuario_inout(integer, date) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
    idio		 alias for $1;
    fecha		 alias for $2;
    retval		varchar;

    begin
    retval:='TRAMITES';

    select nomusu(vt_usuario) into retval from visita where date(vt_fecin)=fecha and vt_inout=idio;
    if not found then
	select usudegte(io_gente) into retval from inout where io_id=idio;
    end if;

return retval;
END;$_$;


ALTER FUNCTION public.usuario_inout(integer, date) OWNER TO zona;

--
-- Name: usucontrapart(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usucontrapart(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
operacion	 alias for $1;
modo		 alias for $2;
directo		 int4;
indirecto	 int4;
deposito	 int4;
ret 		 int4;
begin

 SELECT  op_directo,op_indirecto,op_deposito  INTO  directo,indirecto,deposito    
    FROM operaciones   WHERE op_id= operacion+1;

if int4eq(modo,1) then ret:=directo; end if;
if int4eq(modo,2) then ret:=indirecto; end if;
if int4eq(modo,3) then ret:=deposito; end if;

return ret;
END;$_$;


ALTER FUNCTION public.usucontrapart(integer, integer) OWNER TO zona;

--
-- Name: usudegente(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usudegente(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_usu from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.usudegente(integer) OWNER TO zona;

--
-- Name: usudegente(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usudegente(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select gte_usu from gente where gte_id= $1 ;$_$;


ALTER FUNCTION public.usudegente(integer, integer) OWNER TO zona;

--
-- Name: usudegte(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usudegte(integer) RETURNS character
    LANGUAGE sql
    AS $_$select nomusu(gte_usu) from gente  where gte_id= $1 ;$_$;


ALTER FUNCTION public.usudegte(integer) OWNER TO zona;

--
-- Name: usuporcuit(text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usuporcuit(text) RETURNS integer
    LANGUAGE sql
    AS $_$select usu_codigo from usuarios where bpchareq(usu_nrocuit,trim($1));$_$;


ALTER FUNCTION public.usuporcuit(text) OWNER TO zona;

--
-- Name: usupordepo(text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usupordepo(text) RETURNS integer
    LANGUAGE sql
    AS $_$select unif_usuario from unifun where unif_codmaria=trim($1)::int2;$_$;


ALTER FUNCTION public.usupordepo(text) OWNER TO zona;

--
-- Name: usureal_confactur(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usureal_confactur(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
cfcid		 alias for $1;
ret 		 int4;
auxreal		 int4;
auxusu 		 int4;

begin
    select cfc_usuario,cfc_usureal into auxusu,auxreal  
     from confactur where cfc_id=cfcid;

	if auxreal is null then 
		ret:=auxusu;
	    else
		ret:= auxreal;
	end if;

return ret;
end;$_$;


ALTER FUNCTION public.usureal_confactur(integer) OWNER TO zona;

--
-- Name: usuvisita(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usuvisita(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select vt_usuario from visita where vt_inout= $1 and vt_usuario= $2;$_$;


ALTER FUNCTION public.usuvisita(integer, integer) OWNER TO zona;

--
-- Name: val_talon(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION val_talon(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
tipoper		 alias for $1;
usuario		 alias for $2;
ret 		 int4;
begin

 SELECT  talop_numero  INTO     ret 
    FROM talonop   WHERE talop_usuario=usuario and talop_tipoper=tipoper;

return ret;
END;$_$;


ALTER FUNCTION public.val_talon(integer, integer) OWNER TO zona;

--
-- Name: valfob_ahora(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valfob_ahora(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum((sitem_canting-sitem_cantret)*(sitem_imp_dolar/sitem_canting)) from subitem where sitem_idoper = $1;$_$;


ALTER FUNCTION public.valfob_ahora(integer) OWNER TO zona;

--
-- Name: valfob_reti(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valfob_reti(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum((r.ret_cantidad)*(s.sitem_imp_dolar/s.sitem_canting)) from subitem s, retiros r where r.ret_idopera = $1  and r.ret_idsitem=s.sitem_id;$_$;


ALTER FUNCTION public.valfob_reti(integer) OWNER TO zona;

--
-- Name: valmer_unifun(integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valmer_unifun(integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
DECLARE
operacion	ALIAS FOR $1; 	-- id de la operacion
caso		ALIAS FOR $2; 	-- Caso 
				--  1=arregla valormerca de unifun por ingreso
				--  2=arregla valormerca de unifun por egreso
modalidad	ALIAS FOR $3; 	-- Modalidad sumo o resto 
				--  1=actualizo normal
				--  2=Me arrepiento y corrijo lo ya hecho
compara 	numeric;
deposito 	int2;
registro 	RECORD;
retval 		boolean;
trans 		boolean;
aux_texto 	text;
BEGIN
retval:='t';		

if modalidad=1 then
	if caso=1 then
		for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
    		    from subitem where sitem_idoper=operacion group by sitem_deposito
			loop
			    update unifun set unif_valormerca=unif_valormerca+registro.y
				where unif_codigo=registro.x;
			end loop; 
	    else
		for registro in select ret_idsitem as x,sum(ret_cantidad*precio_unitariod(ret_idsitem)) as y
    		    from retiros where ret_idopera=operacion group by x
			loop
			    select sitem_deposito into deposito from subitem where sitem_id=registro.x;
			    update unifun set unif_valormerca=unif_valormerca-registro.y
				where unif_codigo=deposito;
			end loop; 
	end if;

    else
	if caso=1 then
		for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
    		    from subitem where sitem_idoper=operacion group by sitem_deposito
			loop
			    update unifun set unif_valormerca=unif_valormerca-registro.y
				where unif_codigo=registro.x;
			end loop; 
	    else
		for registro in select ret_idsitem as x,sum(ret_cantidad*precio_unitariod(ret_idsitem)) as y
    		    from retiros where ret_idopera=operacion group by x
			loop
			    select sitem_deposito into deposito from subitem where sitem_id=registro.x;
			    update unifun set unif_valormerca=unif_valormerca+registro.y
				where unif_codigo=deposito;
			end loop; 
	end if;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.valmer_unifun(integer, smallint, smallint) OWNER TO zona;

--
-- Name: valmerxunif(smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valmerxunif(smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
deposito	 alias for $1;
ret 		 boolean;
total 		 numeric;
depo 		 int2;
registro	 record;
begin

ret:='f';

if(int2eq(deposito,0::int2)) then
    for registro in select 
	sitem_deposito as depos, sum((sitem_canting-sitem_cantret)*(sitem_imp_dolar/sitem_canting)) as totals from subitem where sitem_estado=1 and estadop(sitem_idoper)=101 group by sitem_deposito
	loop
	    ret:='t';
	    update unifun set unif_valormerca=registro.totals where unif_codigo=registro.depos;
	end loop; 

else

    select sum((sitem_canting-sitem_cantret)*(sitem_imp_dolar/sitem_canting)) into total from subitem where sitem_estado=1 and sitem_deposito=deposito and estadop(sitem_idoper)=10;
    ret:='t';
    update unifun set unif_valormerca=total where unif_codigo=deposito;

end if;

return ret;
end;$_$;


ALTER FUNCTION public.valmerxunif(smallint) OWNER TO zona;

--
-- Name: valor_moncte(smallint, date, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valor_moncte(smallint, date, numeric, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
moneda		 alias for $1;
fecha		 alias for $2;
cuanto		 alias for $3;
tipo_de_cambio	 alias for $4;
aux_mon		 int2;
cotiz		 numeric;
ret 		 numeric;
begin

 SELECT  var_valor 
 INTO     aux_mon -- Codigo Moneda Homogenea
    FROM varamb    WHERE var_codigo like 'MONH%';

if int2eq(aux_mon,moneda) then
	    ret:= cuanto;
   else
     if numeric_eq(tipo_de_cambio,0::numeric) then -- busco la cotizacion
	    cotiz:=trae_cotiza(moneda,fecha)::numeric;
	    if (cotiz is not null) then 
		    if (cotiz!=0) then 
			ret:=cuanto / cotiz;
		    end if;
		else
		    ret:=0;
	    end if;
	else

	    ret:= cuanto / tipo_de_cambio;

--	    cotiz:=trae_cotiza(1::int2,fecha)::numeric;
--	    if(cotiz) then 
--		    ret:= cuanto * (tipo_de_cambio / cotiz);
--		else
--		    ret:=0;
--	    end if;
    end if;

end if;

return ret;
END;$_$;


ALTER FUNCTION public.valor_moncte(smallint, date, numeric, numeric) OWNER TO zona;

--
-- Name: valstock(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valstock(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
    operacioni	ALIAS FOR $1; 	-- Operacion de ingreso
    operacione	ALIAS FOR $2; 	-- Operacion de egreso
    registro 	RECORD;
    registror 	RECORD;
    retirado	numeric;
    cantret		numeric;
    precio		numeric;
    retval 		numeric;
BEGIN

    retval:=0;
    for registror in select *
        from subitem where sitem_idoper=operacioni
	    loop
		retval:=retval+registror.sitem_imp_dolar;

		if(numeric_ne(registror.sitem_canting,0) and numeric_ne(registror.sitem_imp_dolar,0)) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;

		if(registror.sitem_cantret is not null and registror.sitem_cantret!=0) then

		    select sum(ret_cantidad) into cantret from retiros where registror.sitem_id=ret_idsitem and ret_idopera=operacione;
		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;
		    if(retirado is not null and retirado!=0) then   retval:=retval-retirado; end if;
		end if;
	    end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.valstock(integer, integer) OWNER TO zona;

--
-- Name: valtari(integer, integer, numeric, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valtari(integer, integer, numeric, smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
canti		 alias for $3;
dias		 alias for $4;
fecha		 alias for $5;
ret 		 numeric;
paso 		 numeric;
paso5 		 numeric;
registro	 record;
regi		 record;
hay	 	 int4;
articulo5 	 int4;
coti 	 	 numeric;
importe 	 numeric;
begin

    for registro in select 
	    * from tarifas where tari_imp_dolar!=0 and tari_usuario=usuario and tari_idart=articulo and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1
	loop
	    if numeric_ne(canti,0::numeric) then
		if (registro.tari_cdesde is not null and registro.tari_chasta is not null and numeric_ge(registro.tari_chasta,canti) and numeric_le(registro.tari_cdesde,canti)) then
			paso=1;
		    else
			paso=0;
		end if;
	    end if; 

	    if int2ne(dias,0::int2) then
		if (registro.tari_ddesde is not null and registro.tari_dhasta is not null and int2ge(registro.tari_dhasta,dias) and int2le(registro.tari_ddesde,dias)) then
			paso=1;
		    else
			paso=0;
		end if;
	    end if; 

	    if paso is null then 
		paso=1; 
	    end if;

	    importe=registro.tari_imp_dolar;
	    select cot_cotiz into coti from cotiza where cot_moneda=1 order by cot_fecha desc limit 1;

	    if numeric_ge(coti,registro.tari_cot_dolar) then
		    ret= importe * coti * paso;
		else
		    ret= importe * registro.tari_cot_dolar * paso;
	    end if;
	end loop; 


    if ret is null then
    if int4ge(articulo,27) then
    if int4le(articulo,31) then
	articulo5=articulo - 5;
	for regi in select 
	    * from tarifas where tari_imp_dolar!=0 and tari_usuario=usuario and tari_idart=articulo5 and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1
	    loop
		if numeric_ne(canti,0::numeric) then
		    if (regi.tari_cdesde is not null and regi.tari_chasta is not null and numeric_ge(regi.tari_chasta,canti) and numeric_le(regi.tari_cdesde,canti)) then
			paso5=1;
		      else
			paso5=0;
		    end if;
		end if; 

		if int2ne(dias,0::int2) then
		    if (regi.tari_ddesde is not null and regi.tari_dhasta is not null and int2ge(regi.tari_dhasta,dias) and int2le(regi.tari_ddesde,dias)) then
			paso5=1;
		      else
			paso5=0;
		    end if;
		end if; 

		if paso5 is null then 
		    paso5=1; 
		end if;

		importe=regi.tari_imp_dolar;
		select cot_cotiz into coti from cotiza where cot_moneda=1 order by cot_fecha desc limit 1;

		if numeric_ge(coti,regi.tari_cot_dolar) then
		    ret= importe * coti * paso5;
		  else
		    ret= importe * regi.tari_cot_dolar * paso5;
		end if;
	    end loop; 
    end if;
    end if;
    end if;




	if ret is null then
	    select tari_importe into ret from tarifas where tari_usuario=usuario and tari_idart=articulo and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
	end if;

    if ret is null then
    if int4ge(articulo,27) then
    if int4le(articulo,31) then
	articulo5=articulo - 5;
	    select tari_importe into ret from tarifas where tari_usuario=usuario and tari_idart=articulo5 and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) limit 1;
    end if;
    end if;
    end if;


	if ret is null then
	    if int4eq(articulo,50) then ret=20; 
		else
		    if int4eq(articulo,35) then ret=38.20; 
			else
			    if int4eq(articulo,40) then ret=28.65; 
				else
				    ret=0; 
			    end if;
		    end if;
	    end if;
	end if;


return ret;
end;$_$;


ALTER FUNCTION public.valtari(integer, integer, numeric, smallint, date) OWNER TO zona;

--
-- Name: valtarico(integer, integer, numeric, smallint, date, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valtarico(integer, integer, numeric, smallint, date, integer, smallint) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
usuario		 alias for $1;
articulo	 alias for $2;
canti		 alias for $3;
dias		 alias for $4;
fecha		 alias for $5;
contrato	 alias for $6;
orden		 alias for $7;
ret 		 numeric;
paso 		 numeric;
paso5 		 numeric;
registro	 record;
regi		 record;
hay	 	 int4;
articulo5 	 int4;
coti 	 	 numeric;
importe 	 numeric;
begin

    for registro in select 
	    * from tarifas where tari_imp_dolar!=0 and tari_usuario=usuario and tari_idart=articulo and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_idcontr=contrato and tari_orden=orden limit 1
	loop
	    if numeric_ne(canti,0::numeric) then
		if (registro.tari_cdesde is not null and registro.tari_chasta is not null and numeric_ge(registro.tari_chasta,canti) and numeric_le(registro.tari_cdesde,canti)) then
			paso=1;
		    else
			paso=0;
		end if;
	    end if; 

	    if int2ne(dias,0::int2) then
		if (registro.tari_ddesde is not null and registro.tari_dhasta is not null and int2ge(registro.tari_dhasta,dias) and int2le(registro.tari_ddesde,dias)) then
			paso=1;
		    else
			paso=0;
		end if;
	    end if; 

	    if paso is null then 
		paso=1; 
	    end if;

	    importe=registro.tari_imp_dolar;
	    select cot_cotiz into coti from cotiza where cot_moneda=1 order by cot_fecha desc limit 1;

	    if numeric_ge(coti,registro.tari_cot_dolar) then
		    ret= importe * coti * paso;
		else
		    ret= importe * registro.tari_cot_dolar * paso;
	    end if;
	end loop; 


    if ret is null then
    if int4ge(articulo,27) then
    if int4le(articulo,31) then
	articulo5=articulo - 5;
	for regi in select 
	    * from tarifas where tari_imp_dolar!=0 and tari_usuario=usuario and tari_idart=articulo5 and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_idcontr=contrato and tari_orden=orden limit 1
	    loop
		if numeric_ne(canti,0::numeric) then
		    if (regi.tari_cdesde is not null and regi.tari_chasta is not null and numeric_ge(regi.tari_chasta,canti) and numeric_le(regi.tari_cdesde,canti)) then
			paso5=1;
		      else
			paso5=0;
		    end if;
		end if; 

		if int2ne(dias,0::int2) then
		    if (regi.tari_ddesde is not null and regi.tari_dhasta is not null and int2ge(regi.tari_dhasta,dias) and int2le(regi.tari_ddesde,dias)) then
			paso5=1;
		      else
			paso5=0;
		    end if;
		end if; 

		if paso5 is null then 
		    paso5=1; 
		end if;

		importe=regi.tari_imp_dolar;
		select cot_cotiz into coti from cotiza where cot_moneda=1 order by cot_fecha desc limit 1;

		if numeric_ge(coti,regi.tari_cot_dolar) then
		    ret= importe * coti * paso5;
		  else
		    ret= importe * regi.tari_cot_dolar * paso5;
		end if;
	    end loop; 
    end if;
    end if;
    end if;




	if ret is null then
	    select tari_importe into ret from tarifas where tari_usuario=usuario and tari_idart=articulo and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_idcontr=contrato and tari_orden=orden limit 1;
	end if;

    if ret is null then
    if int4ge(articulo,27) then
    if int4le(articulo,31) then
	articulo5=articulo - 5;
	    select tari_importe into ret from tarifas where tari_usuario=usuario and tari_idart=articulo5 and 
	    date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha) and tari_idcontr=contrato and tari_orden=orden limit 1;
    end if;
    end if;
    end if;


	if ret is null then
	    if int4eq(articulo,50) then ret=20; 
		else
		    if int4eq(articulo,35) then ret=38.20; 
			else
			    if int4eq(articulo,40) then ret=28.65; 
				else
				    ret=0; 
			    end if;
		    end if;
	    end if;
	end if;


return ret;
end;$_$;


ALTER FUNCTION public.valtarico(integer, integer, numeric, smallint, date, integer, smallint) OWNER TO zona;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	codigo		ALIAS FOR $3; 
	otro 		integer;
	retval 		varchar;
    BEGIN

    select vari_valor into retval from
    	 varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);

    if not found then
	select vari_valor into retval from
    	    varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from
    		varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO zona;

--
-- Name: veo_seg_disponible(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION veo_seg_disponible(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; -- Operacion
 
	compara 	numeric;
	totals		numeric;
	aux_seg 	varchar;
	importe 	numeric;
	deposito	int2;
	retval 		boolean;

    BEGIN

	SELECT  var_valor  INTO     aux_seg 	
		    FROM varamb    WHERE var_codigo like 'SEGURO%';
	retval:='f';
	    
	if bpchareq(aux_seg,'NO') then
	    select op_deposito,op_impdolar into deposito,importe from operaciones where op_id=operacion;
	    select sum((sitem_canting-sitem_cantret-sitem_cantmala)*(sitem_imp_dolar/sitem_canting)) into totals from subitem where sitem_estado=1 and sitem_deposito=deposito and estadop(sitem_idoper)=101;
	    SELECT  unif_seguro - totals INTO compara FROM unifun WHERE unif_codigo = deposito;
	    if numeric_le(importe,compara) then
		retval:='t';
	      else
		retval:='f';
	    end if;

	  else
	    retval='t';

	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.veo_seg_disponible(integer) OWNER TO zona;

--
-- Name: verif_estado(integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION verif_estado(integer, smallint, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; 	-- operacion
	estado		ALIAS FOR $2; 	-- estado
	modo		ALIAS FOR $3; 	-- 1 cambia estado
					-- Solo verifica sin cambiar estado 
	viejo_estado	int2;
	directo		int4;
	tipoper		int4;
	indirecto	int4;
	consig		int4;
	duedepo		int4;
	nrotalzon	int4;
	nrotaldir	int4;
	deposito	int2;
	importe		numeric;
	aux_texto 	text;
	mal		int2;
	trans 		boolean;
	trans1 		boolean;
	notid		int4;
	fobopera	numeric;
	foboperai	numeric;
	ret		boolean;
	registro	RECORD;
    BEGIN

select 	op_estado,op_tipoper,op_directo,op_indirecto,op_nrotalzon,op_nrotaldir,op_deposito,op_importe,op_consig
into viejo_estado,tipoper,directo,indirecto,nrotalzon,nrotaldir,deposito,importe,consig
	    from operaciones where op_id=operacion;

select unif_usuario into duedepo from unifun where unif_codigo=deposito;

if consig is null then
    consig:=-1;
end if;

------------------- I N G R E S O S


if(int4lt(tipoper,100::int2))  THEN 



------------------- PUBLICACION 
--falta ver los contratos por unidad funcional que salen de subitem

    if(( int2eq(estado,101::int2)and int2eq(viejo_estado,1::int2) )
	or 
	(int2eq(estado,102::int2)and int2eq(viejo_estado,101::int2) )
	or 
	(int2eq(estado,1::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if(int4eq(tipoper,10::int2) or int4eq(tipoper,30::int2))  THEN 
		foboperai:=fob_hijos1(operacion,2::int2);
		update operaciones set op_importe=foboperai,op_impdolar=foboperai WHERE op_id = operacion;
	    END IF;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
	    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no existe contrato entre el directo '||directo||'  ('||nomusu(directo) ||')     y el indirecto '||indirecto||'  ('||nomusu(indirecto)||')';
	    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (numeric_ne(fobpadre_vs_fobhijos(operacion,1::int2),0)) THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el valor FOB de los SUBITEMS es distinto al FOB de la operacion, debera modificar este error antes de oficializar';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (seg_disponible(deposito, importe,1::int2)!=true) THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el deposito '||deposito||'  ('||traigo_nomunifun(deposito::int2)||') no tiene el seguro necesario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    trans1:=tipprod_ok(operacion,1::int2,2::int2);

	    if (int4ne(duedepo,directo)) THEN
		trans1:=hay_contrato(duedepo,directo,5::int2,operacion,5::int2);
	    END IF;
	    
	    if(tipoper=5 and consig=-1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no se ha definifo el consignatario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;


	    for registro in select itemdeitem(sitem_iditem) as item, sitem_codigo  from subitem where sitem_idoper=operacion and estadunif(sitem_deposito)=999 
		loop
		    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el Item '||registro.item ||' Subitem '||registro.sitem_codigo||' Se encuentra en un deposito INHABILITADO ';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		end loop; 

	END IF;
	
    else

------------------- E G R E S O S
------------------- PUBLICACION 
        if ((int2eq(estado,101::int2) and int2eq(viejo_estado,1::int2)) 
		or 
    	    (int2eq(estado,102::int2) and int2eq(viejo_estado,101::int2))
		or 
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no existe contrato entre el directo '||directo||'  ('||nomusu(directo) ||')     y el indirecto '||indirecto||'  ('||nomusu(indirecto)||')';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if ctacte_ok(directo)!=true THEN 
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el usuario directo '||directo||'  ('||nomusu(directo) ||')  esta inhabilitado por falta de pago   ';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;
	    
	    if(tipoper=105 and consig=-1) then
		aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' no se ha definifo el consignatario';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    fobopera:=fob_hijos2(operacion,2::int2);

	    for registro in select itemitemdesitem(ret_idsitem) as item, sitemcodigo(ret_idsitem) as sitem_codigo from retiros where ret_idopera=operacion and estadunif(depositem(ret_idsitem))=999 
		loop
		    aux_texto:='En la Operacion '||traigo_simbtipoper(tipoper)||' '||nrotaldir||' el Item '||registro.item ||' Subitem '||registro.sitem_codigo||' Se encuentra en un deposito INHABILITADO ';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		end loop; 

	END IF;
END IF;

select not_id into notid from noticias where not_tipo=1 and not_numero=operacion;

if found then 
    	    ret:='f';
	    if(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2)) THEN 
		    update operaciones set op_estado=11::int2 WHERE op_id = operacion;
	    end if;

	else

	    ret:='t';

    	    if (int2eq(estado,101::int2) and int2eq(viejo_estado,1::int2) and (fobopera>0)) then
		update operaciones set op_impdolar=fobopera WHERE op_id = operacion;
	    end if;
	
	    if(int2eq(modo,1::int2)) then	
	    update operaciones set op_estado=estado WHERE op_id = operacion;
	    end if;

end if;

if int2eq(estado,999::int2) then
    update operaciones set op_estado=estado WHERE op_id = operacion;
end if;


RETURN ret;
END;$_$;


ALTER FUNCTION public.verif_estado(integer, smallint, smallint) OWNER TO zona;

--
-- Name: vol_fecha_indirecto(integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION vol_fecha_indirecto(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
indirecto	ALIAS FOR $1; 	-- id del indirecto
fecha		ALIAS FOR $2;	-- fecha hasta
fechad		date;
fechah		date;
mes		integer;
anio		integer;
nacional	integer;
registro 	RECORD;
registror 	RECORD;
volumen		numeric;
volingg		numeric;
retval 		numeric;
BEGIN

volumen:= 0;
volingg:= 0;
retval:= 0;
nacional:=5;

select date_part('month',fecha) into mes;
select date_part('year',fecha) into anio;
fechad:='01-'||mes||'-'||anio;
select (fechad::date + interval '1 month' - interval '1 day')::date into fechah;


for registro in select vol_idoper as op from voling where vol_indirecto=indirecto and vol_estado=101 and (vol_factu=1 or (vol_factu=2 and date_ge(vol_ultfac,fechah::date))) and date_le(vol_fechain,fecha) and depositop(vol_idoper)!=nacional 
	loop

	select vol_canting into volingg from voling where vol_idoper=registro.op;
	if(volingg is not null and volingg!=0) then
	    volumen:=volumen + volingg;
	end if;

	for registror in select * from volegr where vole_idoperi=registro.op and date_le(vole_fechaeg,fecha) and vole_estado=101 
	    loop
		if(registror.vole_cantret is not null and registror.vole_cantret!=0) then
		    volumen:=volumen - registror.vole_cantret;
		end if;
	    end loop;
	
	end loop; 
retval:=volumen::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.vol_fecha_indirecto(integer, date) OWNER TO zona;

--
-- Name: vol_fecha_indirecto_op(integer, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION vol_fecha_indirecto_op(integer, date, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
indirecto	ALIAS FOR $1; 	-- id del indirecto
fecha		ALIAS FOR $2;	-- fecha hasta
operacion	ALIAS FOR $3;	-- Opera
fechad		date;
fechah		date;
mes		integer;
anio		integer;
registro 	RECORD;
registror 	RECORD;
volumen		numeric;
volingg		numeric;
retval 		numeric;
BEGIN

volumen:= 0;
volingg:= 0;
retval:= 0;

select date_part('month',fecha) into mes;
select date_part('year',fecha) into anio;
fechad:='01-'||mes||'-'||anio;
select (fechad::date + interval '1 month' - interval '1 day')::date into fechah;


for registro in select vol_idoper as op from voling where vol_indirecto=indirecto and vol_estado=101 and (vol_factu=1 or (vol_factu=2 and date_ge(vol_ultfac,fechah::date))) and date_le(vol_fechain,fecha) and vol_idoper=operacion 
	loop

	select vol_canting into volingg from voling where vol_idoper=registro.op;
	if(volingg is not null and volingg!=0) then
	    volumen:=volumen + volingg;
	end if;

	for registror in select * from volegr where vole_idoperi=registro.op and date_le(vole_fechaeg,fecha) and vole_estado=101 
	    loop
		if(registror.vole_cantret is not null and registror.vole_cantret!=0) then
		    volumen:=volumen - registror.vole_cantret;
		end if;
	    end loop;
	
	end loop; 
retval:=volumen::numeric(15,2);

RETURN retval;
END;$_$;


ALTER FUNCTION public.vol_fecha_indirecto_op(integer, date, integer) OWNER TO zona;

--
-- Name: vol_mes_indirecto(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION vol_mes_indirecto(integer, integer, integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
    DECLARE
usuario		ALIAS FOR $1; 	-- indirecto
mes		ALIAS FOR $2; 	-- mes
anio		ALIAS FOR $3; 	-- anio

valvol		numeric;
totdias		integer;
t		int4;
nvalvol		numeric;
oldf		date;
fecha		date;
tarifa		numeric;
dias		integer;
ret		character varying;
fechad		date;
fechah		date;

BEGIN

    select (('01-'||mes||'-'||anio)::date) into fechad;
    ret:=NULL;
    dias:=0;
    oldf:=fechad;
    fecha:=fechad;
    tarifa:=0;

    select (date_part('day',((date_trunc('month',('01-'||mes||'-'||anio)::date) + interval '1 month') - interval '1 day')::date)::integer) into totdias;
    t:=0;
    while t <= totdias loop
	select vol_fecha_indirecto(usuario, fecha) into valvol;
	select (fechad + t) into fecha;
	select vol_fecha_indirecto(usuario, fecha) into nvalvol;
	if(numeric_ne(valvol,nvalvol)) then
	    select (fecha - oldf + 1) into dias;
	    select tariman(usuario,9,valvol,fecha::date) into tarifa;
	    if(numeric_ne(valvol,0))then
		if(int4ne(dias::int4,0::int4)) then
		    if(ret is NULL) then
			ret:='Volumen: '||valvol||' Tarifa: '||tarifa||' Dias: '||dias;
		    else
			ret:=ret||' - Volumen: '||valvol||' Tarifa: '||tarifa||' Dias: '||dias;
		    end if;
		end if;
	    end if;
	    select (fecha + 1) into oldf;
	end if;
	t:= t + 1;
    end loop;
    select ((totdias||'-'||mes||'-'||anio)::date) into fechah;
    select (fechah - oldf) into dias;
    dias:=dias + 1;
    select tariman(usuario,9,valvol,fecha::date) into tarifa;
    if(numeric_ne(valvol,0)) then
	if(int4ne(dias::int4,0::int4)) then
	    if(ret is null) then
		ret:='Volumen: '||valvol||' Tarifa: '||tarifa||' Dias: '||dias;
	    else
		ret:=ret||' - Volumen: '||valvol||' Tarifa: '||tarifa||' Dias: '||dias;
	    end if;
	end if;
    end if;

RETURN ret;
END;$_$;


ALTER FUNCTION public.vol_mes_indirecto(integer, integer, integer) OWNER TO zona;

--
-- Name: volton_hay(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION volton_hay(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select (vol_canting-vol_cantret) from voling where vol_idoper = $1;$_$;


ALTER FUNCTION public.volton_hay(integer) OWNER TO zona;

--
-- Name: volton_reti(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION volton_reti(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select vole_cantret from volegr where vole_idoper = $1;$_$;


ALTER FUNCTION public.volton_reti(integer) OWNER TO zona;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: actas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE actas (
    acta_id integer NOT NULL,
    acta_subitem integer DEFAULT 1,
    acta_texto text,
    acta_canti numeric(15,5) DEFAULT 0,
    acta_tipo smallint,
    acta_estado smallint DEFAULT 1,
    acta_fecha date,
    acta_nroexped character varying(40),
    acta_idoper integer
);


ALTER TABLE actas OWNER TO zona;

--
-- Name: actas_acta_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE actas_acta_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE actas_acta_id_seq OWNER TO zona;

--
-- Name: actas_acta_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE actas_acta_id_seq OWNED BY actas.acta_id;


--
-- Name: aduanas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE aduanas (
    adu_codigo smallint NOT NULL,
    adu_nombre character varying(40) NOT NULL
);


ALTER TABLE aduanas OWNER TO zona;

--
-- Name: almacen; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE almacen (
    alm_id integer NOT NULL,
    alm_idusu integer NOT NULL,
    alm_idsitem integer NOT NULL,
    alm_idcontr integer NOT NULL,
    alm_ultfac date DEFAULT now() NOT NULL,
    alm_retiro date,
    alm_tiprod integer NOT NULL,
    alm_tarifa numeric(15,5) NOT NULL,
    alm_estado smallint,
    alm_leyenda character varying(180)
);


ALTER TABLE almacen OWNER TO zona;

--
-- Name: almacen_alm_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE almacen_alm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen_alm_id_seq OWNER TO zona;

--
-- Name: almacen_alm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE almacen_alm_id_seq OWNED BY almacen.alm_id;


SET default_with_oids = false;

--
-- Name: almacenaje; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE almacenaje (
    al_id integer NOT NULL,
    al_idoper integer,
    al_idusu integer,
    al_idsitem integer,
    al_idcontr integer,
    al_canti numeric(15,5) DEFAULT 0,
    al_impdolar numeric(15,5) DEFAULT 0,
    al_importe numeric(15,5) DEFAULT 0,
    al_fecing date,
    al_fech date,
    al_ultfac date,
    al_retiro date,
    al_dias integer,
    al_tiprod integer,
    al_tarifa numeric(15,5) DEFAULT 0,
    al_total numeric(15,5) DEFAULT 0,
    al_estado smallint DEFAULT 1,
    al_leyenda text
);


ALTER TABLE almacenaje OWNER TO zona;

--
-- Name: almacenaje_al_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE almacenaje_al_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacenaje_al_id_seq OWNER TO zona;

--
-- Name: almacenaje_al_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE almacenaje_al_id_seq OWNED BY almacenaje.al_id;


SET default_with_oids = true;

--
-- Name: articu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE articu (
    artic_id integer NOT NULL,
    artic_indirecto integer NOT NULL,
    artic_codigo character varying(40) NOT NULL,
    artic_marca character varying(40),
    artic_modelo character varying(40),
    artic_descrip character varying(40),
    artic_present character varying(40),
    artic_tiprod integer,
    artic_posa character varying(15),
    artic_unimed smallint
);


ALTER TABLE articu OWNER TO zona;

--
-- Name: articu1; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE articu1 (
    artic_id integer NOT NULL,
    artic_indirecto integer NOT NULL,
    artic_codigo character varying(40) NOT NULL,
    artic_marca character varying(40),
    artic_modelo character varying(40),
    artic_descrip character varying(40),
    artic_present character varying(40),
    artic_tiprod integer,
    artic_posa character varying(15),
    artic_unimed smallint
);


ALTER TABLE articu1 OWNER TO zona;

--
-- Name: articu_artic_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE articu_artic_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articu_artic_id_seq OWNER TO zona;

--
-- Name: articu_artic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE articu_artic_id_seq OWNED BY articu.artic_id;


--
-- Name: articud; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE articud (
    articd_id integer NOT NULL,
    articd_idartic integer NOT NULL,
    articd_indirecto integer NOT NULL,
    articd_codigo character varying(40) NOT NULL,
    articd_marca character varying(40),
    articd_modelo character varying(40),
    articd_descrip character varying(40),
    articd_present character varying(40),
    articd_tiprod integer,
    articd_posa character varying(15),
    articd_unimed smallint
);


ALTER TABLE articud OWNER TO zona;

--
-- Name: articud_articd_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE articud_articd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articud_articd_id_seq OWNER TO zona;

--
-- Name: articud_articd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE articud_articd_id_seq OWNED BY articud.articd_id;


--
-- Name: articud_articd_idartic_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE articud_articd_idartic_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articud_articd_idartic_seq OWNER TO zona;

--
-- Name: articud_articd_idartic_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE articud_articd_idartic_seq OWNED BY articud.articd_idartic;


--
-- Name: articvta; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codigo smallint,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_stock numeric(15,5),
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_present numeric(15,5),
    art_peso numeric(15,5),
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_idptov integer,
    art_precio_unique numeric(15,5),
    art_codemp integer,
    art_codi character varying(20),
    art_nombre character varying(60),
    art_leyen text,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codsrb integer,
    art_codcbl integer,
    art_funcion text,
    art_precio numeric(15,5) DEFAULT 0,
    art_idcbl integer
);


ALTER TABLE articvta OWNER TO zona;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articvta_art_id_seq OWNER TO zona;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


--
-- Name: artseg; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE artseg (
    as_id integer NOT NULL,
    as_tipo integer,
    as_idorig integer,
    as_ciaseg integer,
    as_poliza character varying(40),
    as_fecdes date DEFAULT date(now()),
    as_fechas date,
    as_estado smallint DEFAULT 1,
    as_obs text
);


ALTER TABLE artseg OWNER TO zona;

--
-- Name: artseg_as_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE artseg_as_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE artseg_as_id_seq OWNER TO zona;

--
-- Name: artseg_as_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE artseg_as_id_seq OWNED BY artseg.as_id;


--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer,
    astc_iddiv integer,
    astc_idcco integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(15,2) DEFAULT 0,
    astc_cotiza numeric(15,5) DEFAULT 0,
    astc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(15,5),
    astc_leyen character varying(100),
    astc_idashce integer
);


ALTER TABLE astoctas OWNER TO zona;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoctas_astc_id_seq OWNER TO zona;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer,
    ash_anio smallint NOT NULL,
    ash_mes smallint NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer NOT NULL,
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_nro2 integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date,
    ash_titulo character varying(200)
);


ALTER TABLE astoh OWNER TO zona;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoh_ash_id_seq OWNER TO zona;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


--
-- Name: autorizados; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE autorizados (
    aut_id integer NOT NULL,
    aut_usuario integer NOT NULL,
    aut_nombre character varying(40),
    aut_tipdocu character varying(5) NOT NULL,
    aut_numdocu integer,
    aut_fechaa date DEFAULT now(),
    aut_fechav date,
    aut_estado smallint DEFAULT 1,
    aut_permiso smallint DEFAULT 1
);


ALTER TABLE autorizados OWNER TO zona;

--
-- Name: autorizados_aut_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE autorizados_aut_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE autorizados_aut_id_seq OWNER TO zona;

--
-- Name: autorizados_aut_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE autorizados_aut_id_seq OWNED BY autorizados.aut_id;


--
-- Name: auxfe; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE auxfe (
    fe_id integer NOT NULL,
    fe_idcli integer NOT NULL,
    fe_cuit character varying(11) NOT NULL,
    fe_cbte smallint DEFAULT 1 NOT NULL,
    fe_ptovta smallint DEFAULT 1 NOT NULL,
    fe_nograv numeric(15,2),
    fe_grav numeric(15,2),
    fe_ivatot numeric(15,2),
    fe_total numeric(15,2),
    fe_tributo numeric(15,2),
    fe_ivaex numeric(15,2),
    fe_iva21 numeric(15,2),
    fe_iva105 numeric(15,2),
    fe_fechaf character varying(8),
    fe_iniserv character varying(8),
    fe_finserv character varying(8),
    fe_fechavp character varying(8),
    fe_cae character varying(14),
    fe_fechavtocae character varying(8),
    fe_numero integer,
    fe_estado integer DEFAULT 1 NOT NULL,
    fe_errores text,
    fe_moneda integer DEFAULT 1,
    fe_tc numeric
);


ALTER TABLE auxfe OWNER TO zona;

--
-- Name: auxfe_fe_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE auxfe_fe_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxfe_fe_id_seq OWNER TO zona;

--
-- Name: auxfe_fe_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE auxfe_fe_id_seq OWNED BY auxfe.fe_id;


--
-- Name: auxoper; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE auxoper (
    auxo_idoper integer NOT NULL,
    auxo_compremb character varying(16),
    auxo_facturas character varying(90),
    auxo_monflet smallint,
    auxo_impflet numeric(15,2),
    auxo_impfletdol numeric(15,2),
    auxo_monseg smallint,
    auxo_impseg numeric(15,2),
    auxo_impsegdol numeric(15,2),
    auxo_plazo_suspens smallint,
    auxo_base_imponibl numeric(15,2),
    auxo_medio_transpo smallint,
    auxo_mat_medtransp character varying(40),
    auxo_fecha_oficial date,
    auxo_fecha_arribtr date,
    auxo_puerto character varying(5),
    auxo_fojas smallint,
    auxo_verif integer DEFAULT 1,
    auxo_veri_text text,
    auxo_veri_oper integer,
    aux_agentrans character varying(90)
);


ALTER TABLE auxoper OWNER TO zona;

--
-- Name: auxoperv; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE auxoperv (
    avh_id integer NOT NULL,
    avh_idoper integer NOT NULL,
    avh_fecha_pub date,
    avh_fecha timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE auxoperv OWNER TO zona;

--
-- Name: auxoperv_avh_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE auxoperv_avh_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxoperv_avh_id_seq OWNER TO zona;

--
-- Name: auxoperv_avh_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE auxoperv_avh_id_seq OWNED BY auxoperv.avh_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(40) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE bancos OWNER TO zona;

SET default_with_oids = false;

--
-- Name: cantret; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cantret (
    sum numeric
);


ALTER TABLE cantret OWNER TO zona;

SET default_with_oids = true;

--
-- Name: caratula; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE caratula (
    car_id integer NOT NULL,
    despacho text NOT NULL,
    destinacion text,
    cod_aduana text,
    cuit_despachante text,
    estado_declaracion text,
    tipo_impo_expo text,
    nro_reg_manifiesto text,
    motivo_suspensiva text,
    cuit_impo_expo text,
    nombre_impo_expo text,
    divisa_seguro text,
    divisa_flete text,
    divisa_fob text,
    plazo_suspensiva text,
    peso_bruto_bultos text,
    cantidad_bultos text,
    monto_seguro text,
    monto_flete text,
    monto_fob text,
    base_imponible text,
    medio_transporte text,
    marca_bultos text,
    condicion_venta text,
    codigo_deposito text,
    fecha_oficializ date,
    fecha_llegada_trans date,
    inscripto_en_iva text,
    cotizacion_pagos text,
    peso_guia text,
    transito text,
    codigo_embalaje text,
    tipo_embalaje text,
    nro_bultos text,
    cant_bultos_declar text,
    cant_unidad_medida text,
    unidad_medida text,
    cant_declarada text,
    cant_disponible text,
    referencias text,
    fecreg timestamp without time zone DEFAULT now(),
    estado smallint DEFAULT 1,
    car_wopid integer
);


ALTER TABLE caratula OWNER TO zona;

--
-- Name: caratula_car_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE caratula_car_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caratula_car_id_seq OWNER TO zona;

--
-- Name: caratula_car_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE caratula_car_id_seq OWNED BY caratula.car_id;


--
-- Name: carvis; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE carvis (
    cvt_id integer NOT NULL,
    cvt_gente integer NOT NULL,
    cvt_usuario integer,
    cvt_operad integer,
    cvt_estado smallint DEFAULT 1,
    cvt_fecdes date DEFAULT date(now()),
    cvt_fechas date DEFAULT date(now()),
    cvt_fecreg timestamp without time zone DEFAULT now()
);


ALTER TABLE carvis OWNER TO zona;

--
-- Name: carvis_cvt_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE carvis_cvt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE carvis_cvt_id_seq OWNER TO zona;

--
-- Name: carvis_cvt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE carvis_cvt_id_seq OWNED BY carvis.cvt_id;


--
-- Name: catego; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE catego (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(40) NOT NULL
);


ALTER TABLE catego OWNER TO zona;

--
-- Name: catego_cat_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE catego_cat_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catego_cat_codigo_seq OWNER TO zona;

--
-- Name: catego_cat_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE catego_cat_codigo_seq OWNED BY catego.cat_codigo;


--
-- Name: catimo; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE catimo (
    imo_codigo integer NOT NULL,
    imo_nombre character varying(40) NOT NULL
);


ALTER TABLE catimo OWNER TO zona;

--
-- Name: centroc; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE centroc (
    cco_id integer NOT NULL,
    cco_codemp integer DEFAULT 1 NOT NULL,
    cco_idptov integer DEFAULT 1 NOT NULL,
    cco_coddiv integer DEFAULT 1 NOT NULL,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(30)
);


ALTER TABLE centroc OWNER TO zona;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE centroc_cco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE centroc_cco_id_seq OWNER TO zona;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE centroc_cco_id_seq OWNED BY centroc.cco_id;


--
-- Name: cheques; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(15,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text
);


ALTER TABLE cheques OWNER TO zona;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cheques_chq_id_seq OWNER TO zona;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


SET default_with_oids = false;

--
-- Name: chqrech; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE chqrech (
    chqr_id integer NOT NULL,
    chqr_cliente integer DEFAULT 1,
    chqr_idchq integer,
    chqr_idastoh integer,
    chqr_idastohc integer,
    chqr_texto text,
    chqr_estado smallint DEFAULT 1
);


ALTER TABLE chqrech OWNER TO zona;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE chqrech_chqr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chqrech_chqr_id_seq OWNER TO zona;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE chqrech_chqr_id_seq OWNED BY chqrech.chqr_id;


SET default_with_oids = true;

--
-- Name: ciaseg; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ciaseg (
    cs_id integer NOT NULL,
    cs_nombre character varying(100) NOT NULL,
    cs_tipo integer DEFAULT 1,
    cs_nivel integer,
    cs_estado smallint DEFAULT 1
);


ALTER TABLE ciaseg OWNER TO zona;

--
-- Name: ciaseg_cs_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE ciaseg_cs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ciaseg_cs_id_seq OWNER TO zona;

--
-- Name: ciaseg_cs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE ciaseg_cs_id_seq OWNED BY ciaseg.cs_id;


--
-- Name: clacont; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE clacont (
    clac_codigo integer NOT NULL,
    clac_nombre character(5) NOT NULL,
    clac_descrip character varying(40),
    clac_medida smallint,
    clac_altura numeric(15,5),
    clac_dimint_largo numeric(15,5),
    clac_dimint_ancho numeric(15,5),
    clac_dimint_alto numeric(15,5),
    clac_appuert_ancho numeric(15,5),
    clac_appuert_alto numeric(15,5),
    clac_capmax_peso numeric(15,5),
    clac_capmax_tara numeric(15,5),
    clac_capmax_neto numeric(15,5),
    clac_capmax_volume numeric(15,5)
);


ALTER TABLE clacont OWNER TO zona;

--
-- Name: clacont_clac_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE clacont_clac_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE clacont_clac_codigo_seq OWNER TO zona;

--
-- Name: clacont_clac_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE clacont_clac_codigo_seq OWNED BY clacont.clac_codigo;


--
-- Name: clientes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE clientes (
    cli_id integer NOT NULL,
    cli_codemp integer NOT NULL,
    cli_idptov integer,
    cli_codigo integer NOT NULL,
    cli_codaso integer,
    cli_nrcuit character varying(20),
    cli_tipcli smallint,
    cli_nombre character varying(40),
    cli_fantasy character varying(40),
    cli_nomabre character varying(40),
    cli_coniva smallint NOT NULL,
    cli_descto numeric(15,5) DEFAULT 0,
    cli_conpag integer,
    cli_catego integer,
    cli_limcred numeric(15,2),
    cli_interes numeric(15,5),
    cli_grupo integer,
    cli_saldo numeric(15,2),
    cli_estado smallint DEFAULT 1 NOT NULL,
    cli_modfac smallint DEFAULT 1
);


ALTER TABLE clientes OWNER TO zona;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE clientes_cli_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE clientes_cli_id_seq OWNER TO zona;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE clientes_cli_id_seq OWNED BY clientes.cli_id;


--
-- Name: compadu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE compadu (
    cad_codigo character(4) NOT NULL,
    cad_nombre character varying(40) NOT NULL,
    cad_destino character(1),
    cad_tipoper integer
);


ALTER TABLE compadu OWNER TO zona;

--
-- Name: complfac; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE complfac (
    cfac_id integer NOT NULL,
    cfac_codemp integer NOT NULL,
    cfac_ptov smallint DEFAULT 1,
    cfac_cliente integer,
    cfac_anio smallint,
    cfac_mes smallint,
    cfac_fechad date DEFAULT date(now()),
    cfac_fechah date,
    cfac_idart integer NOT NULL,
    cfac_canti numeric(15,5) DEFAULT 1,
    cfac_dias smallint DEFAULT 1,
    cfac_importe numeric(15,2) DEFAULT 0,
    cfac_estado smallint DEFAULT 1,
    cfac_funcion text,
    cfac_evento smallint DEFAULT 1,
    cfac_leyen text DEFAULT ' '::text,
    cfac_precio numeric(15,5)
);


ALTER TABLE complfac OWNER TO zona;

--
-- Name: complfac_cfac_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE complfac_cfac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE complfac_cfac_id_seq OWNER TO zona;

--
-- Name: complfac_cfac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE complfac_cfac_id_seq OWNED BY complfac.cfac_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(40),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(15,2) DEFAULT 0
);


ALTER TABLE compra OWNER TO zona;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compra_cpra_id_seq OWNER TO zona;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(40) NOT NULL,
    comp_idptov integer,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text,
    comp_codemp integer
);


ALTER TABLE comprob OWNER TO zona;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprob_comp_id_seq OWNER TO zona;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: confactur; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE confactur (
    cfc_id integer NOT NULL,
    cfc_usuario integer NOT NULL,
    cfc_fecha date,
    cfc_anio smallint NOT NULL,
    cfc_mes smallint NOT NULL,
    cfc_idart integer NOT NULL,
    cfc_canti numeric(15,5),
    cfc_precio numeric(15,2),
    cfc_importe numeric(15,2),
    cfc_dias smallint,
    cfc_leyen character varying(300),
    cfc_idoper integer,
    cfc_estado smallint DEFAULT 1,
    cfc_idemiti integer,
    cfc_indirecto integer,
    cfc_fecreg timestamp without time zone DEFAULT now(),
    cfc_ticket integer,
    cfc_ptov smallint DEFAULT 1,
    cfc_usureal integer,
    cfc_idalm integer
);


ALTER TABLE confactur OWNER TO zona;

--
-- Name: confactur1; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE confactur1 (
    cfc1_id integer NOT NULL,
    cfc1_usuario integer NOT NULL,
    cfc1_fecha date,
    cfc1_anio smallint NOT NULL,
    cfc1_mes smallint NOT NULL,
    cfc1_idart integer NOT NULL,
    cfc1_canti numeric(15,5),
    cfc1_precio numeric(15,2),
    cfc1_importe numeric(15,2),
    cfc1_dias smallint,
    cfc1_leyen character varying(300),
    cfc1_idoper integer,
    cfc1_estado smallint DEFAULT 1,
    cfc1_idemiti integer,
    cfc1_indirecto integer,
    cfc1_fecreg timestamp without time zone DEFAULT now(),
    cfc1_ticket integer,
    cfc1_ptov smallint DEFAULT 1,
    cfc1_usureal integer,
    cfc_idalm1 integer,
    cfc1_idoperv integer
);


ALTER TABLE confactur1 OWNER TO zona;

--
-- Name: confactur1_cfc1_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE confactur1_cfc1_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE confactur1_cfc1_id_seq OWNER TO zona;

--
-- Name: confactur1_cfc1_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE confactur1_cfc1_id_seq OWNED BY confactur1.cfc1_id;


SET default_with_oids = false;

--
-- Name: confactur1aux; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE confactur1aux (
    cfc1_id integer NOT NULL,
    cfc1_usuario integer NOT NULL,
    cfc1_fecha date,
    cfc1_anio smallint NOT NULL,
    cfc1_mes smallint NOT NULL,
    cfc1_idart integer NOT NULL,
    cfc1_canti numeric(15,5),
    cfc1_precio numeric(15,2),
    cfc1_importe numeric(15,2),
    cfc1_dias smallint,
    cfc1_leyen character varying(300),
    cfc1_idoper integer,
    cfc1_estado smallint DEFAULT 1,
    cfc1_idemiti integer,
    cfc1_indirecto integer,
    cfc1_fecreg timestamp without time zone DEFAULT now(),
    cfc1_ticket integer,
    cfc1_ptov smallint DEFAULT 1,
    cfc1_usureal integer,
    cfc_idalm1 integer,
    cfc1_idoperv integer
);


ALTER TABLE confactur1aux OWNER TO zona;

--
-- Name: confactur1aux_cfc1_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE confactur1aux_cfc1_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE confactur1aux_cfc1_id_seq OWNER TO zona;

--
-- Name: confactur1aux_cfc1_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE confactur1aux_cfc1_id_seq OWNED BY confactur1aux.cfc1_id;


--
-- Name: confactur_cfc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE confactur_cfc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE confactur_cfc_id_seq OWNER TO zona;

--
-- Name: confactur_cfc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE confactur_cfc_id_seq OWNED BY confactur.cfc_id;


SET default_with_oids = true;

--
-- Name: coniva; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(30) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


ALTER TABLE coniva OWNER TO zona;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_nombre character varying(40) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE conpag OWNER TO zona;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE conpag_cdp_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conpag_cdp_codigo_seq OWNER TO zona;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE conpag_cdp_codigo_seq OWNED BY conpag.cdp_codigo;


--
-- Name: consig; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE consig (
    csg_id integer NOT NULL,
    csg_nrocuit character varying(13) DEFAULT '0'::character varying NOT NULL,
    csg_nombre character varying(40),
    csg_fecvto date DEFAULT date(now()),
    csg_directo integer,
    csg_indirecto integer,
    csg_estado integer DEFAULT 1,
    csg_idold integer,
    csg_pais integer,
    csg_dispos character varying(40),
    csg_fecdes date DEFAULT date(now()),
    csg_histor character varying(240),
    csg_telef character varying(90),
    csg_email character varying(90),
    csg_cargo character varying(90),
    csg_domicilio character varying(90),
    csg_contacto character varying(90)
);


ALTER TABLE consig OWNER TO zona;

--
-- Name: consig_csg_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE consig_csg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE consig_csg_id_seq OWNER TO zona;

--
-- Name: consig_csg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE consig_csg_id_seq OWNED BY consig.csg_id;


SET default_with_oids = false;

--
-- Name: consufac; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE consufac (
    cfac_id integer NOT NULL,
    cfac_fecha date NOT NULL,
    cfac_anio smallint NOT NULL,
    cfac_mes smallint NOT NULL,
    cfac_idoper integer,
    cfac_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    cfac_leyen text
);


ALTER TABLE consufac OWNER TO zona;

--
-- Name: consufac_cfac_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE consufac_cfac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE consufac_cfac_id_seq OWNER TO zona;

--
-- Name: consufac_cfac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE consufac_cfac_id_seq OWNED BY consufac.cfac_id;


SET default_with_oids = true;

--
-- Name: contene; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE contene (
    cont_idopv integer NOT NULL,
    cont_marcont integer NOT NULL,
    cont_nrocont integer NOT NULL,
    cont_clacont integer NOT NULL,
    cont_idoper integer,
    cont_estado smallint DEFAULT 1,
    cont_preori character varying(20),
    cont_preana character varying(20),
    cont_presatel character varying(20)
);


ALTER TABLE contene OWNER TO zona;

--
-- Name: conteven; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE conteven (
    contev_codigo integer NOT NULL,
    contev_descrip character varying(40) NOT NULL
);


ALTER TABLE conteven OWNER TO zona;

--
-- Name: conteven_contev_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE conteven_contev_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conteven_contev_codigo_seq OWNER TO zona;

--
-- Name: conteven_contev_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE conteven_contev_codigo_seq OWNED BY conteven.contev_codigo;


--
-- Name: contratos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE contratos (
    contr_id integer NOT NULL,
    contr_locador integer NOT NULL,
    contr_locatario integer NOT NULL,
    contr_idsubt integer,
    contr_unifun smallint,
    contr_garantia numeric(15,2) DEFAULT 0,
    contr_step smallint DEFAULT 1,
    contr_facturable smallint DEFAULT 1,
    contr_leyenda text,
    contr_estado smallint DEFAULT 1,
    contr_metros numeric(15,5) DEFAULT 0,
    contr_puxmtro numeric(15,2) DEFAULT 0,
    contr_inter numeric(15,5) DEFAULT 1.5,
    contr_fecha1 date,
    contr_fecha2 date,
    contr_fecha3 date,
    contr_fecha4 date,
    contr_fecha5 date,
    contr_fecha6 date,
    contr_fecha7 date,
    contr_fecha8 date,
    contr_dispos character varying(20)
);


ALTER TABLE contratos OWNER TO zona;

SET default_with_oids = false;

--
-- Name: contratos1; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE contratos1 (
    contr1_id integer NOT NULL,
    contr1_locador integer NOT NULL,
    contr1_locatario integer NOT NULL,
    contr1_idsubt integer,
    contr1_unifun smallint,
    contr1_garantia numeric(15,2) DEFAULT 0,
    contr1_step smallint DEFAULT 1,
    contr1_facturable smallint DEFAULT 1,
    contr1_leyenda text,
    contr1_estado smallint DEFAULT 1,
    contr1_metros numeric(15,5) DEFAULT 0,
    contr1_puxmtro numeric(15,2) DEFAULT 0,
    contr1_inter numeric(15,5) DEFAULT 1.5,
    contr1_fecha1 date,
    contr1_fecha2 date,
    contr1_fecha3 date,
    contr1_fecha4 date,
    contr1_fecha5 date,
    contr1_fecha6 date,
    contr1_fecha7 date,
    contr1_fecha8 date,
    contr1_dispos character varying(20)
);


ALTER TABLE contratos1 OWNER TO zona;

--
-- Name: contratos_contr_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE contratos_contr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contratos_contr_id_seq OWNER TO zona;

--
-- Name: contratos_contr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE contratos_contr_id_seq OWNED BY contratos.contr_id;


SET default_with_oids = true;

--
-- Name: cotiza; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


ALTER TABLE cotiza OWNER TO zona;

--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer,
    cbl_codigo integer NOT NULL,
    cbl_nombre character varying(100) NOT NULL,
    cbl_identi integer,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint,
    cbl_present character varying(15),
    cbl_imputable integer DEFAULT 1,
    cbl_estado integer DEFAULT 1,
    cbl_monetaria integer DEFAULT 1,
    cbl_caldifcam integer DEFAULT 1,
    cbl_ctarei integer,
    cbl_ctaajus integer,
    cbl_fechautil integer DEFAULT 1,
    cbl_discrimina integer DEFAULT 1,
    cbl_leyend character varying(160),
    cbl_leyenh character varying(160),
    cbl_ent1 integer,
    cbl_ent2 integer,
    cbl_ent3 integer,
    cbl_ent4 integer,
    cbl_ent5 integer
);


ALTER TABLE ctacble OWNER TO zona;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctacble_cbl_id_seq OWNER TO zona;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(40),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1
);


ALTER TABLE ctes OWNER TO zona;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctes_cte_id_seq OWNER TO zona;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


--
-- Name: despach; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE despach (
    desp_id integer NOT NULL,
    desp_tipo smallint DEFAULT 1 NOT NULL,
    desp_nrcuit character(13) NOT NULL,
    desp_nroreg character(8) NOT NULL,
    desp_nombre character varying(40) NOT NULL
);


ALTER TABLE despach OWNER TO zona;

--
-- Name: despach_desp_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE despach_desp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE despach_desp_id_seq OWNER TO zona;

--
-- Name: despach_desp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE despach_desp_id_seq OWNED BY despach.desp_id;


SET default_with_oids = false;

--
-- Name: difcta; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE difcta (
    dc_id integer NOT NULL,
    dc_codemp integer,
    dc_idptov integer,
    dc_mes integer,
    dc_anio integer,
    dc_ctacble integer,
    dc_importeacum numeric,
    dc_fecreg timestamp without time zone DEFAULT now(),
    dc_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE difcta OWNER TO zona;

--
-- Name: difcta_dc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE difcta_dc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE difcta_dc_id_seq OWNER TO zona;

--
-- Name: difcta_dc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE difcta_dc_id_seq OWNED BY difcta.dc_id;


SET default_with_oids = true;

--
-- Name: division; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE division (
    div_id integer NOT NULL,
    div_codemp integer DEFAULT 1 NOT NULL,
    div_idptov integer DEFAULT 1 NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(30)
);


ALTER TABLE division OWNER TO zona;

--
-- Name: division_div_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE division_div_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE division_div_id_seq OWNER TO zona;

--
-- Name: division_div_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE division_div_id_seq OWNED BY division.div_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer NOT NULL,
    doc_idptov integer,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE docum OWNER TO zona;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE docum_doc_id_seq OWNER TO zona;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


--
-- Name: embalajes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE embalajes (
    emb_codigo smallint NOT NULL,
    emb_nombre character varying(40) NOT NULL,
    emb_coef numeric(15,5)
);


ALTER TABLE embalajes OWNER TO zona;

--
-- Name: emiti; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer NOT NULL,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcli integer,
    emi_succli integer,
    emi_nomcli character varying(40),
    emi_conivac smallint,
    emi_nrocuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_zona integer,
    emi_desre numeric(15,2) DEFAULT 0,
    emi_total numeric(15,2) DEFAULT 0,
    emi_retiro integer,
    emi_estado smallint DEFAULT 1,
    emi_leyen text,
    emi_cae character varying(14),
    emi_idfe integer
);


ALTER TABLE emiti OWNER TO zona;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE emiti_emi_id_seq OWNER TO zona;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(60),
    emp_direcc character varying(60),
    emp_locali character varying(60),
    emp_codpos character varying(10),
    emp_provin integer,
    emp_pais smallint,
    emp_nrcuit character varying(20),
    emp_estado smallint DEFAULT 1,
    emp_tipo smallint,
    emp_coniva smallint,
    emp_anti date,
    emp_fecint date,
    emp_grupo integer,
    emp_redond smallint,
    emp_nomabr character varying(7)
);


ALTER TABLE empresa OWNER TO zona;

--
-- Name: entidad; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE entidad (
    ent_id integer NOT NULL,
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(100)
);


ALTER TABLE entidad OWNER TO zona;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE entidad_ent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE entidad_ent_id_seq OWNER TO zona;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE entidad_ent_id_seq OWNED BY entidad.ent_id;


--
-- Name: esclisp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE esclisp (
    elp_idart integer NOT NULL,
    elp_orden smallint DEFAULT 1 NOT NULL,
    elp_nombre character varying(40) DEFAULT '1'::character varying,
    elp_precio numeric(15,2) NOT NULL
);


ALTER TABLE esclisp OWNER TO zona;

--
-- Name: escvalcont; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE escvalcont (
    escval_idcontrat integer NOT NULL,
    escval_fdesde date NOT NULL,
    escval_fhasta date NOT NULL,
    escval_importe numeric(15,2)
);


ALTER TABLE escvalcont OWNER TO zona;

--
-- Name: estiba; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE estiba (
    est_id integer NOT NULL,
    est_tipo integer,
    est_codigo character varying(5),
    est_numero integer,
    est_fecha date,
    est_destino integer,
    est_canti integer,
    est_importe numeric(15,2),
    est_codcli integer,
    est_directo integer,
    est_compbte character varying(20)
);


ALTER TABLE estiba OWNER TO zona;

--
-- Name: estiba_est_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE estiba_est_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE estiba_est_id_seq OWNER TO zona;

--
-- Name: estiba_est_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE estiba_est_id_seq OWNED BY estiba.est_id;


--
-- Name: estoper; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE estoper (
    eto_codigo smallint NOT NULL,
    eto_nombre character varying(40) NOT NULL
);


ALTER TABLE estoper OWNER TO zona;

--
-- Name: estunif; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE estunif (
    etu_codigo smallint NOT NULL,
    etu_nombre character varying(30)
);


ALTER TABLE estunif OWNER TO zona;

--
-- Name: estusu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE estusu (
    esc_codigo smallint NOT NULL,
    esc_nombre character varying(30) NOT NULL
);


ALTER TABLE estusu OWNER TO zona;

--
-- Name: eventos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE eventos (
    eve_codigo smallint NOT NULL,
    eve_nombre character varying(30) NOT NULL
);


ALTER TABLE eventos OWNER TO zona;

--
-- Name: evindi; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE evindi (
    evi_indice integer NOT NULL,
    evi_fecha date DEFAULT date(now()) NOT NULL,
    evi_valor numeric(15,8) DEFAULT 1,
    evi_estado integer DEFAULT 1,
    evi_tipo integer DEFAULT 1
);


ALTER TABLE evindi OWNER TO zona;

--
-- Name: facturacion; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE facturacion (
    fac_id integer NOT NULL,
    fac_codemp integer NOT NULL,
    fac_ptov smallint DEFAULT 1,
    fac_cliente integer NOT NULL,
    fac_fecha date DEFAULT date(now()),
    fac_fecfac date,
    fac_fecdes date,
    fac_fechas date,
    fac_anio smallint,
    fac_mes smallint,
    fac_idart integer NOT NULL,
    fac_canti numeric(15,5) DEFAULT 1,
    fac_dias smallint DEFAULT 1,
    fac_importe numeric(15,2) DEFAULT 0,
    fac_estado smallint DEFAULT 1,
    fac_fecreg timestamp without time zone DEFAULT now(),
    fac_idoper integer,
    fac_idemiti integer,
    fac_clireal integer,
    fac_leyen text,
    fac_precio numeric(15,5)
);


ALTER TABLE facturacion OWNER TO zona;

--
-- Name: facturacion_fac_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE facturacion_fac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE facturacion_fac_id_seq OWNER TO zona;

--
-- Name: facturacion_fac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE facturacion_fac_id_seq OWNED BY facturacion.fac_id;


--
-- Name: feccontra; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE feccontra (
    fechac_idcontra integer NOT NULL,
    fechac_codevent integer NOT NULL,
    fechac_fecha date NOT NULL,
    fechac_aviso text
);


ALTER TABLE feccontra OWNER TO zona;

--
-- Name: firman; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(60) NOT NULL,
    fir_direcc character varying(60),
    fir_locali character varying(60),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE firman OWNER TO zona;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE firman_fir_id_seq OWNER TO zona;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


--
-- Name: gente; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE gente (
    gte_id integer NOT NULL,
    gte_tdoc character varying(5) NOT NULL,
    gte_nrodoc integer DEFAULT 0 NOT NULL,
    gte_cuitl character varying(20),
    gte_nombre character varying(60) DEFAULT 'NN'::character varying NOT NULL,
    gte_fecnac date,
    gte_nacion smallint,
    gte_direcc character varying(60),
    gte_locali character varying(60),
    gte_codpos character varying(10),
    gte_provin integer,
    gte_pais smallint,
    gte_telefon character varying(200),
    gte_mail character varying(200),
    gte_estado smallint DEFAULT 1,
    gte_fecdes date DEFAULT date(now()),
    gte_fechas date DEFAULT '2025-12-31'::date,
    gte_horades time without time zone,
    gte_horahas time without time zone,
    gte_bandah integer DEFAULT 0 NOT NULL,
    gte_tarjeta integer,
    gte_grupo integer,
    gte_tipo integer DEFAULT 0,
    gte_usu integer,
    gte_foto character varying(160),
    gte_fecalta timestamp without time zone DEFAULT now(),
    gte_obs text,
    gte_operad integer,
    gte_leyen text
);


ALTER TABLE gente OWNER TO zona;

--
-- Name: gente_gte_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE gente_gte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gente_gte_id_seq OWNER TO zona;

--
-- Name: gente_gte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE gente_gte_id_seq OWNED BY gente.gte_id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(30) NOT NULL
);


ALTER TABLE grupos OWNER TO zona;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE grupos_gpo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupos_gpo_id_seq OWNER TO zona;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE grupos_gpo_id_seq OWNED BY grupos.gpo_id;


--
-- Name: histarifas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE histarifas (
    htari_idart integer NOT NULL,
    htari_usuario integer NOT NULL,
    htari_orden smallint DEFAULT 1 NOT NULL,
    htari_fecha date DEFAULT now() NOT NULL,
    htari_tipo smallint DEFAULT 1 NOT NULL,
    htari_fdesde date,
    htari_fhasta date,
    htari_cdesde numeric(15,5) DEFAULT 0,
    htari_chasta numeric(15,5) DEFAULT 0,
    htari_ddesde smallint,
    htari_dhasta smallint,
    htari_importe numeric(15,5) DEFAULT 0,
    htari_formula character varying(100)
);


ALTER TABLE histarifas OWNER TO zona;

SET default_with_oids = false;

--
-- Name: histfac; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE histfac (
    hfac_id integer NOT NULL,
    hfac_fecha date NOT NULL,
    hfac_anio smallint NOT NULL,
    hfac_mes smallint NOT NULL,
    hfac_idoper integer,
    hfac_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    hfac_leyen text
);


ALTER TABLE histfac OWNER TO zona;

--
-- Name: histfac_hfac_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE histfac_hfac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE histfac_hfac_id_seq OWNER TO zona;

--
-- Name: histfac_hfac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE histfac_hfac_id_seq OWNED BY histfac.hfac_id;


--
-- Name: importeo; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE importeo (
    sum numeric
);


ALTER TABLE importeo OWNER TO zona;

SET default_with_oids = true;

--
-- Name: impresiones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE impresiones (
    imp_codigo smallint NOT NULL,
    imp_name text,
    imp_query text,
    imp_enscript text,
    imp_filter text,
    imp_shell text
);


ALTER TABLE impresiones OWNER TO zona;

--
-- Name: indices; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE indices (
    ind_codigo integer NOT NULL,
    ind_nombre character varying(100) NOT NULL
);


ALTER TABLE indices OWNER TO zona;

SET default_with_oids = false;

--
-- Name: inflacion; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE inflacion (
    inf_id integer NOT NULL,
    inf_mes integer,
    inf_anio integer,
    inf_coef numeric,
    inf_fecreg timestamp without time zone DEFAULT now(),
    inf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE inflacion OWNER TO zona;

--
-- Name: inflacion_inf_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inflacion_inf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inflacion_inf_id_seq OWNER TO zona;

--
-- Name: inflacion_inf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inflacion_inf_id_seq OWNED BY inflacion.inf_id;


SET default_with_oids = true;

--
-- Name: ingxl; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ingxl (
    igxl_iol integer NOT NULL,
    igxl_io integer NOT NULL,
    igxl_estado smallint DEFAULT 1
);


ALTER TABLE ingxl OWNER TO zona;

--
-- Name: ingzpa; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ingzpa (
    i_id integer NOT NULL,
    i_indirecto integer NOT NULL,
    i_fecreg timestamp without time zone DEFAULT now(),
    i_fecing date,
    i_fecegr date,
    i_compbte character varying(16),
    i_voling numeric(15,2) DEFAULT 0,
    i_volegr numeric(15,2) DEFAULT 0,
    i_fob numeric(15,2) DEFAULT 0,
    i_flete numeric(15,2) DEFAULT 0,
    i_seg numeric(15,2) DEFAULT 0,
    i_cif numeric(15,2) DEFAULT 0,
    i_estado integer DEFAULT 1 NOT NULL,
    i_obs text,
    i_paletiz integer DEFAULT 1
);


ALTER TABLE ingzpa OWNER TO zona;

--
-- Name: ingzpa_i_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE ingzpa_i_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ingzpa_i_id_seq OWNER TO zona;

--
-- Name: ingzpa_i_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE ingzpa_i_id_seq OWNED BY ingzpa.i_id;


SET default_with_oids = false;

--
-- Name: inhabilit; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE inhabilit (
    inh_id integer NOT NULL,
    inh_usuario integer,
    inh_deposito integer,
    inh_estado smallint DEFAULT 1,
    inh_fecdes timestamp without time zone DEFAULT now(),
    inh_fechas timestamp without time zone,
    inh_operadi integer,
    inh_operadh integer,
    inh_motivo text
);


ALTER TABLE inhabilit OWNER TO zona;

--
-- Name: inhabilit_inh_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inhabilit_inh_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inhabilit_inh_id_seq OWNER TO zona;

--
-- Name: inhabilit_inh_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inhabilit_inh_id_seq OWNED BY inhabilit.inh_id;


SET default_with_oids = true;

--
-- Name: inout; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE "inout" (
    io_id integer NOT NULL,
    io_gente integer NOT NULL,
    io_tarje integer,
    io_fecin timestamp without time zone DEFAULT now(),
    io_fecout timestamp without time zone,
    io_estado smallint DEFAULT 1,
    io_visita integer,
    io_barrei integer NOT NULL,
    io_barreo integer,
    io_operin integer,
    io_operout integer,
    io_obs text
);


ALTER TABLE "inout" OWNER TO zona;

--
-- Name: inout_io_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inout_io_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inout_io_id_seq OWNER TO zona;

--
-- Name: inout_io_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inout_io_id_seq OWNED BY "inout".io_id;


--
-- Name: inoutliv; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE inoutliv (
    iol_id integer NOT NULL,
    iol_liviano integer NOT NULL,
    iol_fecin timestamp without time zone DEFAULT now(),
    iol_fecout timestamp without time zone,
    iol_estado smallint DEFAULT 1,
    iol_barrei integer NOT NULL,
    iol_barreo integer,
    iol_obs text
);


ALTER TABLE inoutliv OWNER TO zona;

--
-- Name: inoutliv_iol_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inoutliv_iol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inoutliv_iol_id_seq OWNER TO zona;

--
-- Name: inoutliv_iol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inoutliv_iol_id_seq OWNED BY inoutliv.iol_id;


--
-- Name: interes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer NOT NULL,
    int_fecha date NOT NULL,
    int_valor numeric(15,4) DEFAULT 0
);


ALTER TABLE interes OWNER TO zona;

--
-- Name: item; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE item (
    item_id integer NOT NULL,
    item_idoper integer NOT NULL,
    item_item smallint DEFAULT 1 NOT NULL,
    item_existe_sitem smallint DEFAULT 0 NOT NULL,
    item_moneda smallint,
    item_tipprod integer,
    item_unimed smallint,
    item_posa character varying(15) DEFAULT 'DESCONOCIDA'::character varying,
    item_bloqueado smallint DEFAULT 1,
    item_paisorigen smallint,
    item_proced smallint,
    item_tipitem character(1),
    item_insimptemp numeric(15,2),
    item_insimpcons numeric(10,2)
);


ALTER TABLE item OWNER TO zona;

--
-- Name: item_item_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE item_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE item_item_id_seq OWNER TO zona;

--
-- Name: item_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE item_item_id_seq OWNED BY item.item_id;


--
-- Name: items; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE items (
    items_id integer NOT NULL,
    items_idcaratula integer,
    items_despacho text NOT NULL,
    items_transito text NOT NULL,
    nro_item text,
    tipo_item text,
    posic_arancelaria text,
    fecha_imponible date,
    existencia_subitem text,
    estado_mercaderia text,
    peso_neto_kgr text,
    pais_origen text,
    pais_procedencia text,
    unidad_declarada text,
    cant_declarada text DEFAULT '0'::text,
    monto_fob_divisa text DEFAULT '0'::text,
    monto_fob_dolar text DEFAULT '0'::text,
    numero_subitem text,
    s_monto_fob_dolar text DEFAULT '0'::text,
    s_cant_declarada text DEFAULT '0'::text,
    s_monto_fob_divisa text DEFAULT '0'::text,
    codigo_articulo text,
    marca_articulo text,
    modelo_articulo text,
    descrip_articulo text,
    present_articulo text,
    items_estado smallint DEFAULT 1
);


ALTER TABLE items OWNER TO zona;

--
-- Name: items_items_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE items_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE items_items_id_seq OWNER TO zona;

--
-- Name: items_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE items_items_id_seq OWNED BY items.items_id;


--
-- Name: lecting; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE lecting (
    let_id integer NOT NULL,
    let_placa integer NOT NULL,
    let_barrera integer NOT NULL,
    let_tarje integer NOT NULL,
    let_fecha character varying(40),
    let_fecin timestamp without time zone DEFAULT now(),
    let_estado smallint DEFAULT 1
);


ALTER TABLE lecting OWNER TO zona;

--
-- Name: lecting_fallas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE lecting_fallas (
    let_id integer NOT NULL,
    let_placa integer,
    let_barrera integer,
    let_tarje integer,
    let_fecha timestamp without time zone
);


ALTER TABLE lecting_fallas OWNER TO zona;

--
-- Name: lecting_fallas_let_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE lecting_fallas_let_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE lecting_fallas_let_id_seq OWNER TO zona;

--
-- Name: lecting_fallas_let_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE lecting_fallas_let_id_seq OWNED BY lecting_fallas.let_id;


--
-- Name: lecting_let_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE lecting_let_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE lecting_let_id_seq OWNER TO zona;

--
-- Name: lecting_let_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE lecting_let_id_seq OWNED BY lecting.let_id;


--
-- Name: leyenrexp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE leyenrexp (
    leyr_id integer NOT NULL,
    leyr_idoper integer NOT NULL,
    leyr_nro smallint,
    leyr_leyenda character varying(180)
);


ALTER TABLE leyenrexp OWNER TO zona;

--
-- Name: leyenrexp_leyr_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE leyenrexp_leyr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE leyenrexp_leyr_id_seq OWNER TO zona;

--
-- Name: leyenrexp_leyr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE leyenrexp_leyr_id_seq OWNED BY leyenrexp.leyr_id;


--
-- Name: listpre; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE listpre (
    ltp_id integer NOT NULL,
    ltp_idcli integer,
    ltp_idart integer NOT NULL,
    ltp_orden integer,
    ltp_precio numeric(15,5) DEFAULT 0
);


ALTER TABLE listpre OWNER TO zona;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE listpre_ltp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE listpre_ltp_id_seq OWNER TO zona;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE listpre_ltp_id_seq OWNED BY listpre.ltp_id;


--
-- Name: livianos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE livianos (
    lv_id integer NOT NULL,
    lv_patente character varying(40),
    lv_gente integer,
    lv_marca integer,
    lv_modelo integer,
    lv_anio smallint,
    lv_motor character varying(60),
    lv_chassis character varying(60),
    lv_color character varying(60),
    lv_estado smallint DEFAULT 1,
    lv_obs text
);


ALTER TABLE livianos OWNER TO zona;

--
-- Name: livianos_lv_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE livianos_lv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE livianos_lv_id_seq OWNER TO zona;

--
-- Name: livianos_lv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE livianos_lv_id_seq OWNED BY livianos.lv_id;


--
-- Name: lotes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE lotes (
    lot_id integer NOT NULL,
    lot_codseccion smallint,
    lot_codmza smallint,
    lot_codigo smallint NOT NULL,
    lot_nombre character varying(40)
);


ALTER TABLE lotes OWNER TO zona;

--
-- Name: lotes_lot_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE lotes_lot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE lotes_lot_id_seq OWNER TO zona;

--
-- Name: lotes_lot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE lotes_lot_id_seq OWNED BY lotes.lot_id;


--
-- Name: manzana; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE manzana (
    mza_codigo smallint NOT NULL,
    mza_codseccion smallint NOT NULL,
    mza_nombre character varying(40) NOT NULL
);


ALTER TABLE manzana OWNER TO zona;

--
-- Name: marauto; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE marauto (
    mar_codigo integer NOT NULL,
    mar_nombre character varying(60) NOT NULL
);


ALTER TABLE marauto OWNER TO zona;

--
-- Name: marcont; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE marcont (
    marc_codigo integer NOT NULL,
    marc_descrip character(4) NOT NULL
);


ALTER TABLE marcont OWNER TO zona;

--
-- Name: marcont_marc_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE marcont_marc_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE marcont_marc_codigo_seq OWNER TO zona;

--
-- Name: marcont_marc_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE marcont_marc_codigo_seq OWNED BY marcont.marc_codigo;


SET default_with_oids = false;

--
-- Name: menues; Type: TABLE; Schema: public; Owner: zonab; Tablespace: 
--

CREATE TABLE menues (
    men_id integer NOT NULL,
    men_titulo text NOT NULL,
    men_alias text NOT NULL,
    men_tipo smallint DEFAULT 1,
    men_idmenu integer,
    men_orden integer,
    men_estado smallint DEFAULT 1
);


ALTER TABLE menues OWNER TO zonab;

--
-- Name: menues_men_id_seq; Type: SEQUENCE; Schema: public; Owner: zonab
--

CREATE SEQUENCE menues_men_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE menues_men_id_seq OWNER TO zonab;

--
-- Name: menues_men_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zonab
--

ALTER SEQUENCE menues_men_id_seq OWNED BY menues.men_id;


SET default_with_oids = true;

--
-- Name: mercaestad; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE mercaestad (
    mestad_codigo integer NOT NULL,
    mestad_descrip character varying(40) NOT NULL
);


ALTER TABLE mercaestad OWNER TO zona;

--
-- Name: modauto; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE modauto (
    mod_id integer NOT NULL,
    mod_marca integer NOT NULL,
    mod_nombre character varying(80) NOT NULL
);


ALTER TABLE modauto OWNER TO zona;

--
-- Name: modauto_mod_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE modauto_mod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE modauto_mod_id_seq OWNER TO zona;

--
-- Name: modauto_mod_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE modauto_mod_id_seq OWNED BY modauto.mod_id;


--
-- Name: modopub; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE modopub (
    mod_id integer NOT NULL,
    mod_idoperador integer,
    mod_idoper integer,
    mod_modalidad smallint DEFAULT 2 NOT NULL,
    mod_idret integer,
    mod_idsitem integer,
    mod_fecha timestamp without time zone DEFAULT now() NOT NULL,
    mod_cantanter numeric(15,5),
    mod_cantnueva numeric(15,5),
    mod_autoriz1 integer,
    mod_fecaut1 timestamp without time zone,
    mod_autoriz2 integer,
    mod_fecaut2 timestamp without time zone,
    mod_autoriz3 integer,
    mod_fecaut3 timestamp without time zone,
    mod_estado smallint DEFAULT 1 NOT NULL,
    mod_texto text
);


ALTER TABLE modopub OWNER TO zona;

--
-- Name: modopub_mod_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE modopub_mod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE modopub_mod_id_seq OWNER TO zona;

--
-- Name: modopub_mod_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE modopub_mod_id_seq OWNED BY modopub.mod_id;


--
-- Name: moneda; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(30) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE moneda OWNER TO zona;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(30),
    mne_valor numeric(15,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE monex OWNER TO zona;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE monex_mne_id_seq OWNER TO zona;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsleyen; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE movsleyen (
    mvl_id integer NOT NULL,
    mvl_idmovs integer NOT NULL,
    mvl_leyen character varying(350) NOT NULL
);


ALTER TABLE movsleyen OWNER TO zona;

--
-- Name: movsleyen_mvl_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE movsleyen_mvl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsleyen_mvl_id_seq OWNER TO zona;

--
-- Name: movsleyen_mvl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE movsleyen_mvl_id_seq OWNED BY movsleyen.mvl_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_idastoh integer NOT NULL,
    movs_idemiti integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer,
    movs_fecval date,
    movs_artic integer,
    movs_canti numeric(15,5) DEFAULT 0,
    movs_dias numeric(15,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(15,2) DEFAULT 0,
    movs_tasa numeric(15,5) DEFAULT 0,
    movs_peso numeric(15,2) DEFAULT 0,
    movs_volum numeric(15,2) DEFAULT 0,
    movs_entreg numeric(15,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado smallint DEFAULT 1,
    movs_codcli integer,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer,
    movs_compbte character varying(16)
);


ALTER TABLE movsto OWNER TO zona;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsto_movs_id_seq OWNER TO zona;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: movstoc; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE movstoc (
    movc_id integer NOT NULL,
    movc_idastoh integer NOT NULL,
    movc_idcompra integer NOT NULL,
    movc_codemp integer NOT NULL,
    movc_idptov integer,
    movc_fecval date,
    movc_artic integer,
    movc_canti numeric(15,5) DEFAULT 0,
    movc_precio numeric(15,2) DEFAULT 0,
    movc_importe numeric(15,2) DEFAULT 0,
    movc_tasa numeric(15,5) DEFAULT 0,
    movc_peso numeric(15,2) DEFAULT 0,
    movc_volum numeric(15,2) DEFAULT 0,
    movc_entreg numeric(15,2) DEFAULT 0,
    movc_fecrep date,
    movc_estado smallint DEFAULT 1,
    movc_codpro integer,
    movc_leyen text
);


ALTER TABLE movstoc OWNER TO zona;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE movstoc_movc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movstoc_movc_id_seq OWNER TO zona;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE movstoc_movc_id_seq OWNED BY movstoc.movc_id;


SET default_with_oids = false;

--
-- Name: notdeb; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE notdeb (
    nd_id integer NOT NULL,
    nd_idasho integer NOT NULL,
    nd_codemp integer NOT NULL,
    nd_idptov integer,
    nd_fecval date,
    nd_grupo integer,
    nd_codcli integer,
    nd_estado integer DEFAULT 1,
    nd_tpago numeric(15,2) DEFAULT 0,
    nd_tnd numeric(15,2) DEFAULT 0,
    nd_interes numeric(15,2) DEFAULT 0,
    nd_operadb integer
);


ALTER TABLE notdeb OWNER TO zona;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE notdeb_nd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notdeb_nd_id_seq OWNER TO zona;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE notdeb_nd_id_seq OWNED BY notdeb.nd_id;


SET default_with_oids = true;

--
-- Name: noticias; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE noticias (
    not_id integer NOT NULL,
    not_tipo smallint DEFAULT 1 NOT NULL,
    not_numero integer NOT NULL,
    not_texto text,
    not_fecha timestamp without time zone DEFAULT now()
);


ALTER TABLE noticias OWNER TO zona;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE noticias_not_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE noticias_not_id_seq OWNER TO zona;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE noticias_not_id_seq OWNED BY noticias.not_id;


--
-- Name: operaciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE operaciones (
    op_id integer NOT NULL,
    op_tipoper integer NOT NULL,
    op_directo integer NOT NULL,
    op_indirecto integer NOT NULL,
    op_consig integer,
    op_compbte character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar NOT NULL,
    op_comptrans character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar,
    op_fechain date DEFAULT date(now()),
    op_nrotalzon integer NOT NULL,
    op_nrotaldir integer NOT NULL,
    op_estado smallint DEFAULT 11 NOT NULL,
    op_deposito smallint,
    op_conocim character(18),
    op_pmedtrans smallint,
    op_canal smallint DEFAULT 1,
    op_iddespach integer,
    op_verificador integer,
    op_volumen numeric(15,5) DEFAULT 0,
    op_peso numeric(15,5) DEFAULT 0,
    op_bultos integer DEFAULT 0,
    op_moneda smallint,
    op_importe numeric(15,2) DEFAULT 0,
    op_impdolar numeric(15,2) DEFAULT 0,
    op_tipo_cambio numeric(15,6) DEFAULT 0,
    op_destino smallint,
    op_proced smallint,
    op_embalaje smallint,
    op_fecha_close date,
    op_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    op_idopw integer DEFAULT 0,
    op_operador integer DEFAULT 0,
    op_vence smallint DEFAULT 1,
    op_impdolar_old numeric
);


ALTER TABLE operaciones OWNER TO zona;

--
-- Name: operaciones_op_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE operaciones_op_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operaciones_op_id_seq OWNER TO zona;

--
-- Name: operaciones_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE operaciones_op_id_seq OWNED BY operaciones.op_id;


--
-- Name: operadores; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(40) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(40),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count integer DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente integer,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(90),
    operad_telefono character varying(90),
    operad_codemp integer,
    operad_ptovta integer
);


ALTER TABLE operadores OWNER TO zona;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operadores_operad_id_seq OWNER TO zona;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


SET default_with_oids = false;

--
-- Name: operest; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE operest (
    opr_idoper integer NOT NULL,
    opr_compbte character(16) NOT NULL,
    opr_estado smallint DEFAULT 1 NOT NULL,
    opr_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    opr_fechac timestamp without time zone,
    opr_operador integer
);


ALTER TABLE operest OWNER TO zona;

SET default_with_oids = true;

--
-- Name: opervehi; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE opervehi (
    opv_id integer NOT NULL,
    opv_idoper integer,
    opv_pat_chasis character varying(15),
    opv_pat_tractor character varying(15),
    opv_est_camion smallint DEFAULT 0,
    opv_chofer character varying(40),
    opv_codtd character varying(5),
    opv_nro_doc bigint,
    opv_fecha_ing timestamp without time zone,
    opv_fecha_egr timestamp without time zone,
    opv_pesa character(1),
    opv_peso_ing numeric(15,5),
    opv_peso_egr numeric(15,5),
    opv_nro_ticket integer,
    opv_obs text,
    opv_fecha_reg timestamp without time zone DEFAULT now() NOT NULL,
    opv_verif integer DEFAULT 1,
    opv_cantv integer,
    opv_inout integer DEFAULT 1,
    opv_remito character varying(40),
    opv_comercio character varying(60),
    opv_unifun integer,
    opv_bultos numeric,
    opv_pesoteorico numeric
);


ALTER TABLE opervehi OWNER TO zona;

--
-- Name: opervehi_opv_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE opervehi_opv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE opervehi_opv_id_seq OWNER TO zona;

--
-- Name: opervehi_opv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE opervehi_opv_id_seq OWNED BY opervehi.opv_id;


SET default_with_oids = false;

--
-- Name: ordenpag; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ordenpag (
    orp_idastoh integer NOT NULL,
    orp_texto text,
    orp_importe numeric(15,2) DEFAULT 0
);


ALTER TABLE ordenpag OWNER TO zona;

SET default_with_oids = true;

--
-- Name: outgxl; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE outgxl (
    ogxl_iol integer NOT NULL,
    ogxl_io integer NOT NULL,
    ogxl_estado smallint DEFAULT 1
);


ALTER TABLE outgxl OWNER TO zona;

--
-- Name: pais; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(40) NOT NULL
);


ALTER TABLE pais OWNER TO zona;

--
-- Name: posaran; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE posaran (
    posa_codigo character varying(15) NOT NULL,
    posa_nombre character varying(40) NOT NULL
);


ALTER TABLE posaran OWNER TO zona;

SET default_with_oids = false;

--
-- Name: posarest; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE posarest (
    posar_codigo character varying(15) NOT NULL,
    posar_desc character varying(200),
    posar_estado smallint DEFAULT 1
);


ALTER TABLE posarest OWNER TO zona;

SET default_with_oids = true;

--
-- Name: problimp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE problimp (
    pim_id integer NOT NULL,
    pim_tipo smallint DEFAULT 1 NOT NULL,
    pim_numero integer NOT NULL,
    pim_texto text,
    pim_fecha timestamp without time zone DEFAULT now()
);


ALTER TABLE problimp OWNER TO zona;

--
-- Name: problimp_pim_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE problimp_pim_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE problimp_pim_id_seq OWNER TO zona;

--
-- Name: problimp_pim_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE problimp_pim_id_seq OWNED BY problimp.pim_id;


--
-- Name: prove; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_nrcuit character varying(20),
    prov_codemp integer,
    prov_idptov integer,
    prov_codigo integer,
    prov_nombre character varying(40),
    prov_direcc character varying(40),
    prov_locali character varying(40),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(90),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE prove OWNER TO zona;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE prove_prov_id_seq OWNER TO zona;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(40) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE provin OWNER TO zona;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE provin_pro_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE provin_pro_codigo_seq OWNER TO zona;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE provin_pro_codigo_seq OWNED BY provin.pro_codigo;


--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_nombre character varying(40),
    ptv_codemp integer,
    ptv_codigo integer NOT NULL,
    ptv_direcc character varying(60),
    ptv_locali character varying(60),
    ptv_codpos character varying(10),
    ptv_provin integer,
    ptv_pais smallint,
    ptv_estado smallint DEFAULT 1
);


ALTER TABLE ptovta OWNER TO zona;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ptovta_ptv_id_seq OWNER TO zona;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


--
-- Name: puertos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE puertos (
    pue_codigo character varying(5) NOT NULL,
    pue_nombre character varying(40) NOT NULL,
    pue_pais smallint
);


ALTER TABLE puertos OWNER TO zona;

SET default_with_oids = false;

--
-- Name: relmenu; Type: TABLE; Schema: public; Owner: zonab; Tablespace: 
--

CREATE TABLE relmenu (
    rmen_id integer NOT NULL,
    rmen_titulo text NOT NULL,
    rmen_link text NOT NULL,
    rmen_tipo smallint DEFAULT 1,
    rmen_idmenu integer,
    rmen_nivel smallint DEFAULT 0,
    rmen_estado smallint DEFAULT 1
);


ALTER TABLE relmenu OWNER TO zonab;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE; Schema: public; Owner: zonab
--

CREATE SEQUENCE relmenu_rmen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relmenu_rmen_id_seq OWNER TO zonab;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zonab
--

ALTER SEQUENCE relmenu_rmen_id_seq OWNED BY relmenu.rmen_id;


SET default_with_oids = true;

--
-- Name: retiros; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE retiros (
    ret_id integer NOT NULL,
    ret_idopera integer NOT NULL,
    ret_idsitem integer NOT NULL,
    ret_item smallint DEFAULT 1 NOT NULL,
    ret_sitem smallint DEFAULT 0 NOT NULL,
    ret_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    ret_idsitemc integer
);


ALTER TABLE retiros OWNER TO zona;

--
-- Name: retiros_ret_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE retiros_ret_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE retiros_ret_id_seq OWNER TO zona;

--
-- Name: retiros_ret_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE retiros_ret_id_seq OWNED BY retiros.ret_id;


--
-- Name: retirosd; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE retirosd (
    retd_id integer NOT NULL,
    retd_idopera integer NOT NULL,
    retd_idsitem integer NOT NULL,
    retd_item smallint DEFAULT 1 NOT NULL,
    retd_sitem smallint DEFAULT 0 NOT NULL,
    retd_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    retd_idsitemc integer,
    retd_cantdif numeric(15,5) DEFAULT 0 NOT NULL
);


ALTER TABLE retirosd OWNER TO zona;

--
-- Name: retirosd_retd_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE retirosd_retd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE retirosd_retd_id_seq OWNER TO zona;

--
-- Name: retirosd_retd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE retirosd_retd_id_seq OWNED BY retirosd.retd_id;


--
-- Name: retstock; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE retstock (
    rstk_id integer NOT NULL,
    rstk_idretd integer NOT NULL,
    rstk_idopera integer NOT NULL,
    rstk_idstk integer NOT NULL,
    rstk_item smallint DEFAULT 1 NOT NULL,
    rstk_sitem smallint DEFAULT 0 NOT NULL,
    rstk_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    rstk_idsitemc integer
);


ALTER TABLE retstock OWNER TO zona;

--
-- Name: retstock_rstk_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE retstock_rstk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE retstock_rstk_id_seq OWNER TO zona;

--
-- Name: retstock_rstk_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE retstock_rstk_id_seq OWNED BY retstock.rstk_id;


--
-- Name: retstock_rstk_idretd_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE retstock_rstk_idretd_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE retstock_rstk_idretd_seq OWNER TO zona;

--
-- Name: retstock_rstk_idretd_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE retstock_rstk_idretd_seq OWNED BY retstock.rstk_idretd;


--
-- Name: rubros; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(30) NOT NULL
);


ALTER TABLE rubros OWNER TO zona;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubros_rub_id_seq OWNER TO zona;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: seccion; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(40) NOT NULL
);


ALTER TABLE seccion OWNER TO zona;

--
-- Name: seguros; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE seguros (
    seg_unifun smallint NOT NULL,
    seg_poliza character varying(40) NOT NULL,
    seg_fechad timestamp without time zone NOT NULL,
    seg_hasta timestamp without time zone NOT NULL,
    seg_importei numeric(15,2) DEFAULT 0,
    seg_importerc numeric(15,2) DEFAULT 0,
    seg_estado smallint DEFAULT 1,
    seg_cia character varying(100),
    seg_moneda smallint DEFAULT 1 NOT NULL,
    seg_impmoncte numeric(15,2) DEFAULT 0
);


ALTER TABLE seguros OWNER TO zona;

--
-- Name: seq_logs; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_logs
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seq_logs OWNER TO zona;

--
-- Name: seq_qpaso; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_qpaso
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seq_qpaso OWNER TO zona;

--
-- Name: seq_tipl; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_tipl
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seq_tipl OWNER TO zona;

SET default_with_oids = false;

--
-- Name: sitemxvehi; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE sitemxvehi (
    sv_id integer NOT NULL,
    sv_idsitem integer NOT NULL,
    sv_obs text,
    sv_estado integer DEFAULT 1,
    sv_fecreg timestamp without time zone DEFAULT now(),
    sv_idopving integer NOT NULL,
    sv_peso numeric(15,5),
    sv_idopvegr integer,
    sv_fechaing date,
    sv_fechaegr date,
    sv_fechafac date
);


ALTER TABLE sitemxvehi OWNER TO zona;

--
-- Name: sitemxvehi_sv_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE sitemxvehi_sv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sitemxvehi_sv_id_seq OWNER TO zona;

--
-- Name: sitemxvehi_sv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE sitemxvehi_sv_id_seq OWNED BY sitemxvehi.sv_id;


SET default_with_oids = true;

--
-- Name: stock; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE stock (
    stk_id integer NOT NULL,
    stk_idsitem integer NOT NULL,
    stk_iditem integer NOT NULL,
    stk_idoper integer,
    stk_codigo smallint DEFAULT 0 NOT NULL,
    stk_artic integer,
    stk_canting numeric(15,5) DEFAULT 0 NOT NULL,
    stk_cantret numeric(15,5) DEFAULT 0,
    stk_cantcomp numeric(15,5) DEFAULT 0,
    stk_cantmala numeric(15,5) DEFAULT 0,
    stk_importe numeric(15,2) DEFAULT 0 NOT NULL,
    stk_imp_dolar numeric(15,2) DEFAULT 0,
    stk_volumen numeric(15,5) DEFAULT 0,
    stk_peso numeric(15,5) DEFAULT 0,
    stk_tipemb smallint,
    stk_deposito smallint,
    stk_idacta integer,
    stk_estado integer DEFAULT 1,
    stk_directo integer NOT NULL,
    stk_indirecto integer NOT NULL,
    stk_compbte character varying(16),
    stk_cliente integer,
    stk_comptras character varying(16)
);


ALTER TABLE stock OWNER TO zona;

--
-- Name: subitem; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subitem (
    sitem_id integer NOT NULL,
    sitem_iditem integer NOT NULL,
    sitem_idoper integer,
    sitem_codigo smallint DEFAULT 0 NOT NULL,
    sitem_artic integer,
    sitem_canting numeric(15,5) DEFAULT 0 NOT NULL,
    sitem_cantret numeric(15,5) DEFAULT 0,
    sitem_cantcomp numeric(15,5) DEFAULT 0,
    sitem_cantmala numeric(15,5) DEFAULT 0,
    sitem_importe numeric(15,2) DEFAULT 0 NOT NULL,
    sitem_imp_dolar numeric(15,2) DEFAULT 0,
    sitem_volumen numeric(15,5) DEFAULT 0,
    sitem_peso numeric(15,5) DEFAULT 0,
    sitem_tipemb smallint,
    sitem_deposito smallint,
    sitem_idacta integer,
    sitem_estado integer DEFAULT 1,
    sitem_directo integer NOT NULL,
    sitem_indirecto integer NOT NULL,
    sitem_compbte character varying(16),
    sitem_pesoadu numeric(15,5)
);


ALTER TABLE subitem OWNER TO zona;

--
-- Name: stock1; Type: VIEW; Schema: public; Owner: zona
--

CREATE VIEW stock1 AS
 SELECT o.op_directo AS directo,
    nomusu(o.op_directo) AS nomclid,
    o.op_indirecto AS indirecto,
    nomusu(o.op_indirecto) AS nomcli,
    o.op_compbte AS comprobante,
    traigo_codarticu(a.sitem_artic) AS traigo_codarticu,
    traigo_nomarticu(a.sitem_artic) AS traigo_nomarticu,
    precio_unitario(a.sitem_id) AS precio_unitario,
    traigo_moneda(a.sitem_iditem) AS traigo_moneda,
    a.sitem_deposito AS deposito,
    a.sitem_canting AS ingresada,
    a.sitem_cantcomp AS comprometida,
    a.sitem_cantret AS retirada,
    a.sitem_cantmala AS malacondi,
    (a.sitem_canting - a.sitem_cantret) AS stock,
    cantidad_disponible(a.sitem_id) AS disponible,
    b.item_tipprod AS tipoprod,
    a.sitem_artic AS articulo
   FROM operaciones o,
    subitem a,
    item b
  WHERE (((o.op_id = a.sitem_idoper) AND (a.sitem_estado = 1)) AND (a.sitem_iditem = b.item_id));


ALTER TABLE stock1 OWNER TO zona;

--
-- Name: stock_stk_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE stock_stk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE stock_stk_id_seq OWNER TO zona;

--
-- Name: stock_stk_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE stock_stk_id_seq OWNED BY stock.stk_id;


--
-- Name: subd; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer DEFAULT 0 NOT NULL,
    subd_idptov integer DEFAULT 0,
    subd_nombre character varying(40),
    subd_titulo character varying(40),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer,
    subd_orden integer
);


ALTER TABLE subd OWNER TO zona;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subd_subd_id_seq OWNER TO zona;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subitem_sitem_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE subitem_sitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subitem_sitem_id_seq OWNER TO zona;

--
-- Name: subitem_sitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE subitem_sitem_id_seq OWNED BY subitem.sitem_id;


--
-- Name: subitemd; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subitemd (
    sitemd_id integer NOT NULL,
    sitemd_iditem integer NOT NULL,
    sitemd_idoper integer,
    sitemd_codigo smallint DEFAULT 0 NOT NULL,
    sitemd_artic integer,
    sitemd_canting numeric(15,5) DEFAULT 0 NOT NULL,
    sitemd_cantret numeric(15,5) DEFAULT 0,
    sitemd_cantcomp numeric(15,5) DEFAULT 0,
    sitemd_cantmala numeric(15,5) DEFAULT 0,
    sitemd_importe numeric(15,2) DEFAULT 0 NOT NULL,
    sitemd_imp_dolar numeric(15,2) DEFAULT 0,
    sitemd_volumen numeric(15,5) DEFAULT 0,
    sitemd_peso numeric(15,5) DEFAULT 0,
    sitemd_tipemb smallint,
    sitemd_deposito smallint,
    sitemd_idacta integer,
    sitemd_estado integer DEFAULT 1,
    sitemd_directo integer NOT NULL,
    sitemd_indirecto integer NOT NULL,
    sitemd_compbte character varying(16),
    sitemd_cliente integer,
    sitemd_comptras character varying(16),
    sitemd_cantdif numeric(15,5) DEFAULT 0
);


ALTER TABLE subitemd OWNER TO zona;

--
-- Name: subitemd_sitemd_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE subitemd_sitemd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subitemd_sitemd_id_seq OWNER TO zona;

--
-- Name: subitemd_sitemd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE subitemd_sitemd_id_seq OWNED BY subitemd.sitemd_id;


--
-- Name: subrub; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subrub (
    srb_id integer NOT NULL,
    srb_rubro integer NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(40) NOT NULL,
    srb_precio numeric(15,2) DEFAULT 0,
    srb_leyen text,
    srb_codtg smallint DEFAULT 1,
    srb_conper smallint DEFAULT 1
);


ALTER TABLE subrub OWNER TO zona;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE subrub_srb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subrub_srb_id_seq OWNER TO zona;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE subrub_srb_id_seq OWNED BY subrub.srb_id;


--
-- Name: subtcontrat; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subtcontrat (
    subt_id integer NOT NULL,
    subt_idtipc integer NOT NULL,
    subt_codigo smallint,
    subt_descrip character(30) NOT NULL,
    art_id integer
);


ALTER TABLE subtcontrat OWNER TO zona;

--
-- Name: subtcontrat_subt_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE subtcontrat_subt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subtcontrat_subt_id_seq OWNER TO zona;

--
-- Name: subtcontrat_subt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE subtcontrat_subt_id_seq OWNED BY subtcontrat.subt_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL
);


ALTER TABLE subxcomp OWNER TO zona;

--
-- Name: sucursal; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE sucursal (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(40) NOT NULL,
    sucu_direcc character varying(180),
    sucu_locali character varying(40),
    sucu_codpos character varying(15),
    sucu_provin integer,
    sucu_pais smallint,
    sucu_repres character varying(40),
    sucu_contacto character varying(40),
    sucu_observ text,
    sucu_direccl character varying(180),
    sucu_localil character varying(40),
    sucu_codposl character varying(15),
    sucu_codprovl integer,
    sucu_paisl smallint
);


ALTER TABLE sucursal OWNER TO zona;

--
-- Name: sucursales; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE sucursales (
    suc_cliente integer NOT NULL,
    suc_codigo smallint DEFAULT 1 NOT NULL,
    suc_nombre character varying(40) NOT NULL,
    suc_direcc character varying(40),
    suc_locali character varying(40),
    suc_codpos character varying(15),
    suc_codprov integer,
    suc_pais smallint,
    suc_repres character varying(40),
    suc_contacto character varying(40),
    suc_observ text,
    suc_direccl character varying(40),
    suc_localil character varying(40),
    suc_codposl character varying(15),
    suc_codprovl integer,
    suc_paisl smallint
);


ALTER TABLE sucursales OWNER TO zona;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_idptov integer,
    tal_comprob integer,
    tal_nombre character varying(40) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date,
    tal_codemp integer DEFAULT 1 NOT NULL
);


ALTER TABLE talon OWNER TO zona;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE talon_tal_id_seq OWNER TO zona;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: talonop; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE talonop (
    talop_usuario integer NOT NULL,
    talop_tipoper integer NOT NULL,
    talop_numero integer DEFAULT 1 NOT NULL
);


ALTER TABLE talonop OWNER TO zona;

--
-- Name: tarifas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tarifas (
    tari_idart integer NOT NULL,
    tari_idcontr integer NOT NULL,
    tari_usuario integer NOT NULL,
    tari_orden smallint DEFAULT 1 NOT NULL,
    tari_tipo smallint DEFAULT 1 NOT NULL,
    tari_fdesde date,
    tari_fhasta date,
    tari_cdesde numeric(15,5),
    tari_chasta numeric(15,5),
    tari_ddesde smallint,
    tari_dhasta smallint,
    tari_importe numeric(15,5) DEFAULT 0 NOT NULL,
    tari_formula character varying(100),
    tari_imp_dolar numeric(15,5) DEFAULT 0,
    tari_cot_dolar numeric(15,5) DEFAULT 0,
    tari_uc numeric(15,5) DEFAULT 0
);


ALTER TABLE tarifas OWNER TO zona;

--
-- Name: tarjeta; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tarjeta (
    tar_id integer NOT NULL,
    tar_estado smallint DEFAULT 1,
    tar_obs text
);


ALTER TABLE tarjeta OWNER TO zona;

--
-- Name: telefon; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(60) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE telefon OWNER TO zona;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE telefon_tel_id_seq OWNER TO zona;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


--
-- Name: temporalweb; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE temporalweb (
    wtmp_id integer NOT NULL,
    wtmp_idsitem integer NOT NULL,
    wtmp_idret integer NOT NULL,
    wtmp_valor numeric(15,5) DEFAULT 0,
    wtmp_disponib numeric(15,5) DEFAULT 0,
    wtmp_compweb numeric(15,5) DEFAULT 0,
    wtmp_idwop integer
);


ALTER TABLE temporalweb OWNER TO zona;

--
-- Name: temporalweb_wtmp_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE temporalweb_wtmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE temporalweb_wtmp_id_seq OWNER TO zona;

--
-- Name: temporalweb_wtmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE temporalweb_wtmp_id_seq OWNED BY temporalweb.wtmp_id;


--
-- Name: tipcontrat; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipcontrat (
    tipc_codigo integer NOT NULL,
    tipc_descrip character varying(40) NOT NULL,
    tipc_concon smallint DEFAULT 1 NOT NULL,
    tipc_afunif smallint DEFAULT 1 NOT NULL,
    tipc_t1 character varying(40),
    tipc_t2 character varying(40)
);


ALTER TABLE tipcontrat OWNER TO zona;

--
-- Name: tipcontrat_tipc_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipcontrat_tipc_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipcontrat_tipc_codigo_seq OWNER TO zona;

--
-- Name: tipcontrat_tipc_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipcontrat_tipc_codigo_seq OWNED BY tipcontrat.tipc_codigo;


--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(30) NOT NULL
);


ALTER TABLE tipcta OWNER TO zona;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipcta_tct_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipcta_tct_codigo_seq OWNER TO zona;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipcta_tct_codigo_seq OWNED BY tipcta.tct_codigo;


--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(40) NOT NULL
);


ALTER TABLE tipdocu OWNER TO zona;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(40) NOT NULL
);


ALTER TABLE tipemp OWNER TO zona;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(30) NOT NULL
);


ALTER TABLE tipentid OWNER TO zona;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipentid_tet_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipentid_tet_codigo_seq OWNER TO zona;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipentid_tet_codigo_seq OWNED BY tipentid.tet_codigo;


--
-- Name: tipgente; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipgente (
    tgte_id integer NOT NULL,
    tgte_tipo integer NOT NULL,
    tgte_codigo integer NOT NULL,
    tgte_nombre character varying(60) NOT NULL,
    tgte_trato smallint DEFAULT 1
);


ALTER TABLE tipgente OWNER TO zona;

--
-- Name: tipgente_tgte_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipgente_tgte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipgente_tgte_id_seq OWNER TO zona;

--
-- Name: tipgente_tgte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipgente_tgte_id_seq OWNED BY tipgente.tgte_id;


--
-- Name: tiplog; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tiplog (
    tipl_codigo smallint DEFAULT nextval(('seq_tipl'::text)::regclass) NOT NULL,
    tipl_tipo smallint,
    tipl_modistock smallint DEFAULT 2,
    tipl_modiubic smallint DEFAULT 2,
    tipl_estado smallint,
    tipl_nombre character varying(50),
    tipl_sumaresta smallint DEFAULT 1,
    tipl_prefact smallint DEFAULT 2
);


ALTER TABLE tiplog OWNER TO zona;

--
-- Name: tipoper; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipoper (
    top_codigo integer NOT NULL,
    top_nombre character varying(40) NOT NULL,
    top_comprob character(3)
);


ALTER TABLE tipoper OWNER TO zona;

--
-- Name: tipoper_top_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipoper_top_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipoper_top_codigo_seq OWNER TO zona;

--
-- Name: tipoper_top_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipoper_top_codigo_seq OWNED BY tipoper.top_codigo;


--
-- Name: tipprod; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipprod (
    tip_codigo integer NOT NULL,
    tip_descrip character varying(40) NOT NULL,
    tip_imo smallint
);


ALTER TABLE tipprod OWNER TO zona;

--
-- Name: tipprod_tip_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipprod_tip_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipprod_tip_codigo_seq OWNER TO zona;

--
-- Name: tipprod_tip_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipprod_tip_codigo_seq OWNED BY tipprod.tip_codigo;


--
-- Name: tippxunif; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tippxunif (
    txu_codtipp integer NOT NULL,
    txu_codunif smallint NOT NULL
);


ALTER TABLE tippxunif OWNER TO zona;

--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(30) NOT NULL
);


ALTER TABLE tiptel OWNER TO zona;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tiptel_ttl_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tiptel_ttl_codigo_seq OWNER TO zona;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tiptel_ttl_codigo_seq OWNED BY tiptel.ttl_codigo;


--
-- Name: tipusu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipusu (
    tpu_codigo smallint NOT NULL,
    tpu_nombre character varying(30) NOT NULL
);


ALTER TABLE tipusu OWNER TO zona;

--
-- Name: unifun; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE unifun (
    unif_codigo smallint NOT NULL,
    unif_nombre character varying(40) NOT NULL,
    unif_tipo smallint,
    unif_usuario integer,
    unif_superf numeric(15,5),
    unif_codmaria smallint,
    unif_seguro numeric(15,2) DEFAULT 0,
    unif_valormerca numeric(15,2) DEFAULT 0,
    unif_vensta date,
    unif_estado smallint DEFAULT 1 NOT NULL,
    unif_direc character varying(90),
    unif_habilit text,
    unif_oldcod text,
    unif_newcod character varying(15)
);


ALTER TABLE unifun OWNER TO zona;

--
-- Name: unilot; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE unilot (
    unil_codunifun smallint NOT NULL,
    unit_idlote integer NOT NULL
);


ALTER TABLE unilot OWNER TO zona;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_coef numeric(15,5),
    uni_nombre character varying(140),
    uni_simbolo character varying(140)
);


ALTER TABLE unimed OWNER TO zona;

SET default_with_oids = false;

--
-- Name: usermenu; Type: TABLE; Schema: public; Owner: zonab; Tablespace: 
--

CREATE TABLE usermenu (
    umen_id integer NOT NULL,
    umen_operador integer NOT NULL,
    umen_idmenu integer,
    umen_menufinal integer,
    umen_estado smallint DEFAULT 1
);


ALTER TABLE usermenu OWNER TO zonab;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE; Schema: public; Owner: zonab
--

CREATE SEQUENCE usermenu_umen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE usermenu_umen_id_seq OWNER TO zonab;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zonab
--

ALTER SEQUENCE usermenu_umen_id_seq OWNED BY usermenu.umen_id;


SET default_with_oids = true;

--
-- Name: usuarios; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE usuarios (
    usu_codigo integer NOT NULL,
    usu_nrocuit character varying(13) NOT NULL,
    usu_tipusu smallint NOT NULL,
    usu_nombre character varying(40) NOT NULL,
    usu_fantasy character varying(40),
    usu_nomabre character varying(5),
    usu_coniva smallint,
    usu_conpago integer,
    usu_catego integer,
    usu_limcred numeric(15,2) DEFAULT 0,
    usu_tasaint numeric(15,5),
    usu_grupo integer DEFAULT 1,
    usu_saldo numeric(15,2) DEFAULT 0,
    usu_estado smallint DEFAULT 1
);


ALTER TABLE usuarios OWNER TO zona;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(40) NOT NULL,
    var_nombre character varying(40) NOT NULL,
    var_valor character varying(40)
);


ALTER TABLE varamb OWNER TO zona;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(40) NOT NULL,
    vari_nombre character varying(40) NOT NULL,
    vari_valor character varying(40),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE varambi OWNER TO zona;

--
-- Name: vendedor; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE vendedor (
    ven_id integer NOT NULL,
    ven_codemp integer NOT NULL,
    ven_nombre character varying(60) NOT NULL,
    ven_direcc character varying(60),
    ven_locali character varying(60),
    ven_codpos character varying(10),
    ven_provin integer,
    ven_pais smallint,
    ven_nrcuit character varying(20),
    ven_estado smallint DEFAULT 1,
    ven_comis numeric(15,5) DEFAULT 0
);


ALTER TABLE vendedor OWNER TO zona;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE vendedor_ven_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE vendedor_ven_id_seq OWNER TO zona;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE vendedor_ven_id_seq OWNED BY vendedor.ven_id;


--
-- Name: visita; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE visita (
    vt_id integer NOT NULL,
    vt_inout integer NOT NULL,
    vt_fecin timestamp without time zone DEFAULT now(),
    vt_fecout timestamp without time zone,
    vt_estado smallint DEFAULT 1,
    vt_gente integer,
    vt_usuario integer,
    vt_operout integer,
    vt_obs text
);


ALTER TABLE visita OWNER TO zona;

--
-- Name: visita_vt_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE visita_vt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE visita_vt_id_seq OWNER TO zona;

--
-- Name: visita_vt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE visita_vt_id_seq OWNED BY visita.vt_id;


SET default_with_oids = false;

--
-- Name: volegr; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE volegr (
    vole_idoper integer NOT NULL,
    vole_idoperi integer NOT NULL,
    vole_directo integer NOT NULL,
    vole_indirecto integer NOT NULL,
    vole_cliente integer,
    vole_compbte character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar NOT NULL,
    vole_fechaeg date DEFAULT date(now()),
    vole_estado smallint DEFAULT 11 NOT NULL,
    vole_cantret numeric(15,2) DEFAULT 0 NOT NULL,
    vole_factu integer DEFAULT 1,
    vole_paletiz integer
);


ALTER TABLE volegr OWNER TO zona;

--
-- Name: voling; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE voling (
    vol_idoper integer NOT NULL,
    vol_directo integer NOT NULL,
    vol_indirecto integer NOT NULL,
    vol_cliente integer,
    vol_compbte character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar NOT NULL,
    vol_comptrans character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar,
    vol_fechain date DEFAULT date(now()),
    vol_estado smallint DEFAULT 11 NOT NULL,
    vol_canting numeric(15,2) DEFAULT 0 NOT NULL,
    vol_cantcomp numeric(15,2) DEFAULT 0 NOT NULL,
    vol_cantret numeric(15,2) DEFAULT 0 NOT NULL,
    vol_cantmala numeric(15,2) DEFAULT 0 NOT NULL,
    vol_modo smallint DEFAULT 1 NOT NULL,
    vol_ultfac date DEFAULT date(now()),
    vol_factu integer DEFAULT 1,
    vol_paletiz smallint
);


ALTER TABLE voling OWNER TO zona;

SET default_with_oids = true;

--
-- Name: wleyenrexp; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE wleyenrexp (
    wleyr_id integer NOT NULL,
    wleyr_idoper integer NOT NULL,
    wleyr_nro smallint,
    wleyr_leyenda character varying(180)
);


ALTER TABLE wleyenrexp OWNER TO zona;

--
-- Name: wleyenrexp_wleyr_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE wleyenrexp_wleyr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE wleyenrexp_wleyr_id_seq OWNER TO zona;

--
-- Name: wleyenrexp_wleyr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE wleyenrexp_wleyr_id_seq OWNED BY wleyenrexp.wleyr_id;


--
-- Name: wnoticias; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE wnoticias (
    wnot_id integer NOT NULL,
    wnot_estado smallint DEFAULT 1 NOT NULL,
    wnot_tipoper integer DEFAULT 1 NOT NULL,
    wnot_directo integer DEFAULT 1 NOT NULL,
    wnot_indirecto integer DEFAULT 1 NOT NULL,
    wnot_feclect timestamp without time zone,
    wnot_operadlec integer,
    wnot_operadcar integer,
    wnot_prioridad integer DEFAULT 10,
    wnot_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    wnot_texto text,
    wnot_titulo character varying(80)
);


ALTER TABLE wnoticias OWNER TO zona;

--
-- Name: wnoticias_wnot_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE wnoticias_wnot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE wnoticias_wnot_id_seq OWNER TO zona;

--
-- Name: wnoticias_wnot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE wnoticias_wnot_id_seq OWNED BY wnoticias.wnot_id;


--
-- Name: woperaciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE woperaciones (
    wop_id integer NOT NULL,
    wop_tipoper integer NOT NULL,
    wop_directo integer NOT NULL,
    wop_indirecto integer NOT NULL,
    wop_consig integer,
    wop_fechain date DEFAULT date(now()),
    wop_estado smallint DEFAULT 11 NOT NULL,
    wop_importe numeric(15,2) DEFAULT 0,
    wop_impdolar numeric(15,2) DEFAULT 0,
    wop_destino smallint,
    wop_proced smallint,
    wop_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    wop_operador integer,
    wop_auxo_fact character varying(90),
    wop_deposito smallint,
    wop_clasemer character varying(90),
    wop_transito character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar,
    wop_compbte character(16),
    wop_tipemb smallint,
    wop_volumen numeric(15,5) DEFAULT 0,
    wop_peso numeric(15,5) DEFAULT 0,
    wop_bultos integer DEFAULT 0,
    wop_moneda smallint,
    wop_nomconsig character varying(90),
    wop_nrocuitcsg character varying(13),
    wop_contacto character varying(90),
    wop_telefono character varying(90),
    wop_tiprod integer,
    wop_fechaest date DEFAULT date(now()),
    wop_vence smallint DEFAULT 1,
    wop_docbl character varying(40),
    wop_factnro character varying(40),
    wop_corigen character varying(90)
);


ALTER TABLE woperaciones OWNER TO zona;

--
-- Name: woperaciones_wop_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE woperaciones_wop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE woperaciones_wop_id_seq OWNER TO zona;

--
-- Name: woperaciones_wop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE woperaciones_wop_id_seq OWNED BY woperaciones.wop_id;


--
-- Name: wret2; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE wret2 (
    wret2_id integer NOT NULL,
    wret2_idopera integer NOT NULL,
    wret2_idsitem integer NOT NULL,
    wret2_item smallint DEFAULT 1 NOT NULL,
    wret2_sitem smallint DEFAULT 0 NOT NULL,
    wret2_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    wret2_idsitemc integer,
    wret2_estado smallint DEFAULT 1 NOT NULL
);


ALTER TABLE wret2 OWNER TO zona;

--
-- Name: wret2_wret2_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE wret2_wret2_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE wret2_wret2_id_seq OWNER TO zona;

--
-- Name: wret2_wret2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE wret2_wret2_id_seq OWNED BY wret2.wret2_id;


SET default_with_oids = false;

--
-- Name: wretiros; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE wretiros (
    wret_id integer NOT NULL,
    wret_idopera integer NOT NULL,
    wret_idsitem integer NOT NULL,
    wret_item smallint DEFAULT 1 NOT NULL,
    wret_sitem smallint DEFAULT 0 NOT NULL,
    wret_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    wret_idsitemc integer,
    wret_compbte character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar,
    wret_tipoper integer,
    wret_nrotaldir integer NOT NULL,
    wret_fecha date DEFAULT '2012-11-27'::date,
    wret_estado smallint DEFAULT 1
);


ALTER TABLE wretiros OWNER TO zona;

--
-- Name: wretiros_wret_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE wretiros_wret_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE wretiros_wret_id_seq OWNER TO zona;

--
-- Name: wretiros_wret_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE wretiros_wret_id_seq OWNED BY wretiros.wret_id;


--
-- Name: wsubitem; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE wsubitem (
    wsitem_id integer NOT NULL,
    wsitem_iditem integer NOT NULL,
    wsitem_idoper integer,
    wsitem_codigo smallint DEFAULT 0 NOT NULL,
    wsitem_artic integer,
    wsitem_canting numeric(15,5) DEFAULT 0 NOT NULL,
    wsitem_cantret numeric(15,5) DEFAULT 0,
    wsitem_cantcomp numeric(15,5) DEFAULT 0,
    wsitem_cantmala numeric(15,5) DEFAULT 0,
    wsitem_importe numeric(15,2) DEFAULT 0 NOT NULL,
    wsitem_imp_dolar numeric(15,2) DEFAULT 0,
    wsitem_volumen numeric(15,5) DEFAULT 0,
    wsitem_peso numeric(15,5) DEFAULT 0,
    wsitem_tipemb smallint,
    wsitem_deposito smallint,
    wsitem_idacta integer,
    wsitem_estado integer DEFAULT 1,
    wsitem_directo integer NOT NULL,
    wsitem_indirecto integer NOT NULL,
    wsitem_consig integer,
    wsitem_compbte character varying(16),
    wsitem_item smallint DEFAULT 0 NOT NULL,
    wsitem_moneda smallint,
    wsitem_unimed smallint,
    wsitem_comptrans character(16) DEFAULT 'DATO DESCONOCIDO'::bpchar,
    wsitem_tipoper integer,
    wsitem_nrotaldir integer NOT NULL,
    wsitem_codart character varying(40) NOT NULL,
    wsitem_marca character varying(40),
    wsitem_modelo character varying(40),
    wsitem_descrip character varying(40),
    wsitem_posa character varying(15),
    wsitem_cantcompw numeric(15,5) DEFAULT 0
);


ALTER TABLE wsubitem OWNER TO zona;

SET default_with_oids = true;

--
-- Name: zona; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(40) NOT NULL
);


ALTER TABLE zona OWNER TO zona;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE zona_zon_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE zona_zon_codigo_seq OWNER TO zona;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE zona_zon_codigo_seq OWNED BY zona.zon_codigo;


--
-- Name: acta_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY actas ALTER COLUMN acta_id SET DEFAULT nextval('actas_acta_id_seq'::regclass);


--
-- Name: alm_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacen ALTER COLUMN alm_id SET DEFAULT nextval('almacen_alm_id_seq'::regclass);


--
-- Name: al_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacenaje ALTER COLUMN al_id SET DEFAULT nextval('almacenaje_al_id_seq'::regclass);


--
-- Name: artic_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu ALTER COLUMN artic_id SET DEFAULT nextval('articu_artic_id_seq'::regclass);


--
-- Name: articd_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articud ALTER COLUMN articd_id SET DEFAULT nextval('articud_articd_id_seq'::regclass);


--
-- Name: articd_idartic; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articud ALTER COLUMN articd_idartic SET DEFAULT nextval('articud_articd_idartic_seq'::regclass);


--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: as_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY artseg ALTER COLUMN as_id SET DEFAULT nextval('artseg_as_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: aut_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY autorizados ALTER COLUMN aut_id SET DEFAULT nextval('autorizados_aut_id_seq'::regclass);


--
-- Name: fe_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxfe ALTER COLUMN fe_id SET DEFAULT nextval('auxfe_fe_id_seq'::regclass);


--
-- Name: avh_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxoperv ALTER COLUMN avh_id SET DEFAULT nextval('auxoperv_avh_id_seq'::regclass);


--
-- Name: car_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY caratula ALTER COLUMN car_id SET DEFAULT nextval('caratula_car_id_seq'::regclass);


--
-- Name: cvt_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY carvis ALTER COLUMN cvt_id SET DEFAULT nextval('carvis_cvt_id_seq'::regclass);


--
-- Name: cat_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY catego ALTER COLUMN cat_codigo SET DEFAULT nextval('catego_cat_codigo_seq'::regclass);


--
-- Name: cco_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY centroc ALTER COLUMN cco_id SET DEFAULT nextval('centroc_cco_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: chqr_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY chqrech ALTER COLUMN chqr_id SET DEFAULT nextval('chqrech_chqr_id_seq'::regclass);


--
-- Name: cs_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ciaseg ALTER COLUMN cs_id SET DEFAULT nextval('ciaseg_cs_id_seq'::regclass);


--
-- Name: clac_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY clacont ALTER COLUMN clac_codigo SET DEFAULT nextval('clacont_clac_codigo_seq'::regclass);


--
-- Name: cli_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY clientes ALTER COLUMN cli_id SET DEFAULT nextval('clientes_cli_id_seq'::regclass);


--
-- Name: cfac_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY complfac ALTER COLUMN cfac_id SET DEFAULT nextval('complfac_cfac_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: cfc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur ALTER COLUMN cfc_id SET DEFAULT nextval('confactur_cfc_id_seq'::regclass);


--
-- Name: cfc1_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur1 ALTER COLUMN cfc1_id SET DEFAULT nextval('confactur1_cfc1_id_seq'::regclass);


--
-- Name: cdp_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY conpag ALTER COLUMN cdp_codigo SET DEFAULT nextval('conpag_cdp_codigo_seq'::regclass);


--
-- Name: csg_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY consig ALTER COLUMN csg_id SET DEFAULT nextval('consig_csg_id_seq'::regclass);


--
-- Name: contev_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY conteven ALTER COLUMN contev_codigo SET DEFAULT nextval('conteven_contev_codigo_seq'::regclass);


--
-- Name: contr_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos ALTER COLUMN contr_id SET DEFAULT nextval('contratos_contr_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: desp_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY despach ALTER COLUMN desp_id SET DEFAULT nextval('despach_desp_id_seq'::regclass);


--
-- Name: dc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY difcta ALTER COLUMN dc_id SET DEFAULT nextval('difcta_dc_id_seq'::regclass);


--
-- Name: div_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY division ALTER COLUMN div_id SET DEFAULT nextval('division_div_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: ent_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY entidad ALTER COLUMN ent_id SET DEFAULT nextval('entidad_ent_id_seq'::regclass);


--
-- Name: est_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY estiba ALTER COLUMN est_id SET DEFAULT nextval('estiba_est_id_seq'::regclass);


--
-- Name: fac_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY facturacion ALTER COLUMN fac_id SET DEFAULT nextval('facturacion_fac_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: gte_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY gente ALTER COLUMN gte_id SET DEFAULT nextval('gente_gte_id_seq'::regclass);


--
-- Name: gpo_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY grupos ALTER COLUMN gpo_id SET DEFAULT nextval('grupos_gpo_id_seq'::regclass);


--
-- Name: hfac_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY histfac ALTER COLUMN hfac_id SET DEFAULT nextval('histfac_hfac_id_seq'::regclass);


--
-- Name: inf_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inflacion ALTER COLUMN inf_id SET DEFAULT nextval('inflacion_inf_id_seq'::regclass);


--
-- Name: i_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ingzpa ALTER COLUMN i_id SET DEFAULT nextval('ingzpa_i_id_seq'::regclass);


--
-- Name: inh_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inhabilit ALTER COLUMN inh_id SET DEFAULT nextval('inhabilit_inh_id_seq'::regclass);


--
-- Name: io_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY "inout" ALTER COLUMN io_id SET DEFAULT nextval('inout_io_id_seq'::regclass);


--
-- Name: iol_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inoutliv ALTER COLUMN iol_id SET DEFAULT nextval('inoutliv_iol_id_seq'::regclass);


--
-- Name: item_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item ALTER COLUMN item_id SET DEFAULT nextval('item_item_id_seq'::regclass);


--
-- Name: items_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY items ALTER COLUMN items_id SET DEFAULT nextval('items_items_id_seq'::regclass);


--
-- Name: let_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY lecting ALTER COLUMN let_id SET DEFAULT nextval('lecting_let_id_seq'::regclass);


--
-- Name: let_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY lecting_fallas ALTER COLUMN let_id SET DEFAULT nextval('lecting_fallas_let_id_seq'::regclass);


--
-- Name: leyr_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY leyenrexp ALTER COLUMN leyr_id SET DEFAULT nextval('leyenrexp_leyr_id_seq'::regclass);


--
-- Name: ltp_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY listpre ALTER COLUMN ltp_id SET DEFAULT nextval('listpre_ltp_id_seq'::regclass);


--
-- Name: lv_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY livianos ALTER COLUMN lv_id SET DEFAULT nextval('livianos_lv_id_seq'::regclass);


--
-- Name: lot_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY lotes ALTER COLUMN lot_id SET DEFAULT nextval('lotes_lot_id_seq'::regclass);


--
-- Name: marc_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY marcont ALTER COLUMN marc_codigo SET DEFAULT nextval('marcont_marc_codigo_seq'::regclass);


--
-- Name: men_id; Type: DEFAULT; Schema: public; Owner: zonab
--

ALTER TABLE ONLY menues ALTER COLUMN men_id SET DEFAULT nextval('menues_men_id_seq'::regclass);


--
-- Name: mod_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modauto ALTER COLUMN mod_id SET DEFAULT nextval('modauto_mod_id_seq'::regclass);


--
-- Name: mod_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub ALTER COLUMN mod_id SET DEFAULT nextval('modopub_mod_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: mvl_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY movsleyen ALTER COLUMN mvl_id SET DEFAULT nextval('movsleyen_mvl_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: movc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY movstoc ALTER COLUMN movc_id SET DEFAULT nextval('movstoc_movc_id_seq'::regclass);


--
-- Name: nd_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY notdeb ALTER COLUMN nd_id SET DEFAULT nextval('notdeb_nd_id_seq'::regclass);


--
-- Name: not_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY noticias ALTER COLUMN not_id SET DEFAULT nextval('noticias_not_id_seq'::regclass);


--
-- Name: op_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones ALTER COLUMN op_id SET DEFAULT nextval('operaciones_op_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: opv_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY opervehi ALTER COLUMN opv_id SET DEFAULT nextval('opervehi_opv_id_seq'::regclass);


--
-- Name: pim_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY problimp ALTER COLUMN pim_id SET DEFAULT nextval('problimp_pim_id_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: pro_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY provin ALTER COLUMN pro_codigo SET DEFAULT nextval('provin_pro_codigo_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: rmen_id; Type: DEFAULT; Schema: public; Owner: zonab
--

ALTER TABLE ONLY relmenu ALTER COLUMN rmen_id SET DEFAULT nextval('relmenu_rmen_id_seq'::regclass);


--
-- Name: ret_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retiros ALTER COLUMN ret_id SET DEFAULT nextval('retiros_ret_id_seq'::regclass);


--
-- Name: retd_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retirosd ALTER COLUMN retd_id SET DEFAULT nextval('retirosd_retd_id_seq'::regclass);


--
-- Name: rstk_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retstock ALTER COLUMN rstk_id SET DEFAULT nextval('retstock_rstk_id_seq'::regclass);


--
-- Name: rstk_idretd; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retstock ALTER COLUMN rstk_idretd SET DEFAULT nextval('retstock_rstk_idretd_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: sv_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sitemxvehi ALTER COLUMN sv_id SET DEFAULT nextval('sitemxvehi_sv_id_seq'::regclass);


--
-- Name: stk_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY stock ALTER COLUMN stk_id SET DEFAULT nextval('stock_stk_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: sitem_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem ALTER COLUMN sitem_id SET DEFAULT nextval('subitem_sitem_id_seq'::regclass);


--
-- Name: sitemd_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitemd ALTER COLUMN sitemd_id SET DEFAULT nextval('subitemd_sitemd_id_seq'::regclass);


--
-- Name: srb_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subrub ALTER COLUMN srb_id SET DEFAULT nextval('subrub_srb_id_seq'::regclass);


--
-- Name: subt_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subtcontrat ALTER COLUMN subt_id SET DEFAULT nextval('subtcontrat_subt_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: wtmp_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY temporalweb ALTER COLUMN wtmp_id SET DEFAULT nextval('temporalweb_wtmp_id_seq'::regclass);


--
-- Name: tipc_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipcontrat ALTER COLUMN tipc_codigo SET DEFAULT nextval('tipcontrat_tipc_codigo_seq'::regclass);


--
-- Name: tct_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipcta ALTER COLUMN tct_codigo SET DEFAULT nextval('tipcta_tct_codigo_seq'::regclass);


--
-- Name: tet_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipentid ALTER COLUMN tet_codigo SET DEFAULT nextval('tipentid_tet_codigo_seq'::regclass);


--
-- Name: tgte_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipgente ALTER COLUMN tgte_id SET DEFAULT nextval('tipgente_tgte_id_seq'::regclass);


--
-- Name: top_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipoper ALTER COLUMN top_codigo SET DEFAULT nextval('tipoper_top_codigo_seq'::regclass);


--
-- Name: tip_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipprod ALTER COLUMN tip_codigo SET DEFAULT nextval('tipprod_tip_codigo_seq'::regclass);


--
-- Name: ttl_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tiptel ALTER COLUMN ttl_codigo SET DEFAULT nextval('tiptel_ttl_codigo_seq'::regclass);


--
-- Name: umen_id; Type: DEFAULT; Schema: public; Owner: zonab
--

ALTER TABLE ONLY usermenu ALTER COLUMN umen_id SET DEFAULT nextval('usermenu_umen_id_seq'::regclass);


--
-- Name: ven_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY vendedor ALTER COLUMN ven_id SET DEFAULT nextval('vendedor_ven_id_seq'::regclass);


--
-- Name: vt_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY visita ALTER COLUMN vt_id SET DEFAULT nextval('visita_vt_id_seq'::regclass);


--
-- Name: wleyr_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wleyenrexp ALTER COLUMN wleyr_id SET DEFAULT nextval('wleyenrexp_wleyr_id_seq'::regclass);


--
-- Name: wnot_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wnoticias ALTER COLUMN wnot_id SET DEFAULT nextval('wnoticias_wnot_id_seq'::regclass);


--
-- Name: wop_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY woperaciones ALTER COLUMN wop_id SET DEFAULT nextval('woperaciones_wop_id_seq'::regclass);


--
-- Name: wret2_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wret2 ALTER COLUMN wret2_id SET DEFAULT nextval('wret2_wret2_id_seq'::regclass);


--
-- Name: wret_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wretiros ALTER COLUMN wret_id SET DEFAULT nextval('wretiros_wret_id_seq'::regclass);


--
-- Name: zon_codigo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY zona ALTER COLUMN zon_codigo SET DEFAULT nextval('zona_zon_codigo_seq'::regclass);


--
-- Name: actas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY actas
    ADD CONSTRAINT actas_pkey PRIMARY KEY (acta_id);


--
-- Name: aduanas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY aduanas
    ADD CONSTRAINT aduanas_pkey PRIMARY KEY (adu_codigo);


--
-- Name: almacen_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY almacen
    ADD CONSTRAINT almacen_pkey PRIMARY KEY (alm_id);


--
-- Name: articu1_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY articu1
    ADD CONSTRAINT articu1_pkey PRIMARY KEY (artic_id);


--
-- Name: articu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT articu_pkey PRIMARY KEY (artic_id);


--
-- Name: articud_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY articud
    ADD CONSTRAINT articud_pkey PRIMARY KEY (articd_id);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: artseg_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY artseg
    ADD CONSTRAINT artseg_pkey PRIMARY KEY (as_id);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: autorizados_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY autorizados
    ADD CONSTRAINT autorizados_pkey PRIMARY KEY (aut_id);


--
-- Name: auxfe_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY auxfe
    ADD CONSTRAINT auxfe_pkey PRIMARY KEY (fe_id);


--
-- Name: auxoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY auxoper
    ADD CONSTRAINT auxoper_pkey PRIMARY KEY (auxo_idoper);


--
-- Name: auxoperv_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY auxoperv
    ADD CONSTRAINT auxoperv_pkey PRIMARY KEY (avh_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: caratula_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY caratula
    ADD CONSTRAINT caratula_pkey PRIMARY KEY (car_id);


--
-- Name: carvis_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY carvis
    ADD CONSTRAINT carvis_pkey PRIMARY KEY (cvt_id);


--
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- Name: catimo_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY catimo
    ADD CONSTRAINT catimo_pkey PRIMARY KEY (imo_codigo);


--
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: ciaseg_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ciaseg
    ADD CONSTRAINT ciaseg_pkey PRIMARY KEY (cs_id);


--
-- Name: clacont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY clacont
    ADD CONSTRAINT clacont_pkey PRIMARY KEY (clac_codigo);


--
-- Name: clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT clientes_pkey PRIMARY KEY (cli_id);


--
-- Name: compadu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY compadu
    ADD CONSTRAINT compadu_pkey PRIMARY KEY (cad_codigo);


--
-- Name: complcfac_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY complfac
    ADD CONSTRAINT complcfac_pkey PRIMARY KEY (cfac_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: confactur_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT confactur_pkey PRIMARY KEY (cfc_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: consig_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY consig
    ADD CONSTRAINT consig_pkey PRIMARY KEY (csg_id);


--
-- Name: contene_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY contene
    ADD CONSTRAINT contene_pkey PRIMARY KEY (cont_idopv, cont_marcont, cont_nrocont);


--
-- Name: conteven_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY conteven
    ADD CONSTRAINT conteven_pkey PRIMARY KEY (contev_codigo);


--
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (contr_id);


--
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: despach_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY despach
    ADD CONSTRAINT despach_pkey PRIMARY KEY (desp_id);


--
-- Name: difcta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY difcta
    ADD CONSTRAINT difcta_pkey PRIMARY KEY (dc_id);


--
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: embalajes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY embalajes
    ADD CONSTRAINT embalajes_pkey PRIMARY KEY (emb_codigo);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_id);


--
-- Name: esclisp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY esclisp
    ADD CONSTRAINT esclisp_pkey PRIMARY KEY (elp_idart, elp_orden);


--
-- Name: escvalcont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY escvalcont
    ADD CONSTRAINT escvalcont_pkey PRIMARY KEY (escval_idcontrat, escval_fdesde);


--
-- Name: estiba_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY estiba
    ADD CONSTRAINT estiba_pkey PRIMARY KEY (est_id);


--
-- Name: estoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY estoper
    ADD CONSTRAINT estoper_pkey PRIMARY KEY (eto_codigo);


--
-- Name: estunif_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY estunif
    ADD CONSTRAINT estunif_pkey PRIMARY KEY (etu_codigo);


--
-- Name: estusu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY estusu
    ADD CONSTRAINT estusu_pkey PRIMARY KEY (esc_codigo);


--
-- Name: eventos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT eventos_pkey PRIMARY KEY (eve_codigo);


--
-- Name: evindi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY evindi
    ADD CONSTRAINT evindi_pkey PRIMARY KEY (evi_indice, evi_fecha);


--
-- Name: facturacion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY facturacion
    ADD CONSTRAINT facturacion_pkey PRIMARY KEY (fac_id);


--
-- Name: feccontra_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY feccontra
    ADD CONSTRAINT feccontra_pkey PRIMARY KEY (fechac_idcontra, fechac_codevent);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: gente_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY gente
    ADD CONSTRAINT gente_pkey PRIMARY KEY (gte_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: impresiones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY impresiones
    ADD CONSTRAINT impresiones_pkey PRIMARY KEY (imp_codigo);


--
-- Name: indices_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY indices
    ADD CONSTRAINT indices_pkey PRIMARY KEY (ind_codigo);


--
-- Name: inflacion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY inflacion
    ADD CONSTRAINT inflacion_pkey PRIMARY KEY (inf_id);


--
-- Name: ingzpa_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ingzpa
    ADD CONSTRAINT ingzpa_pkey PRIMARY KEY (i_id);


--
-- Name: inigxl_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ingxl
    ADD CONSTRAINT inigxl_pkey PRIMARY KEY (igxl_iol, igxl_io);


--
-- Name: inout_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY "inout"
    ADD CONSTRAINT inout_pkey PRIMARY KEY (io_id);


--
-- Name: inoutliv_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY inoutliv
    ADD CONSTRAINT inoutliv_pkey PRIMARY KEY (iol_id);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_codemp, int_fecha);


--
-- Name: item_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY item
    ADD CONSTRAINT item_pkey PRIMARY KEY (item_id);


--
-- Name: items_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY items
    ADD CONSTRAINT items_pkey PRIMARY KEY (items_id);


--
-- Name: lecting_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY lecting
    ADD CONSTRAINT lecting_pkey PRIMARY KEY (let_id);


--
-- Name: leyenrexp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY leyenrexp
    ADD CONSTRAINT leyenrexp_pkey PRIMARY KEY (leyr_id);


--
-- Name: listpre_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT listpre_pkey PRIMARY KEY (ltp_id);


--
-- Name: livianos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY livianos
    ADD CONSTRAINT livianos_pkey PRIMARY KEY (lv_id);


--
-- Name: lotes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY lotes
    ADD CONSTRAINT lotes_pkey PRIMARY KEY (lot_id);


--
-- Name: manzana_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY manzana
    ADD CONSTRAINT manzana_pkey PRIMARY KEY (mza_codigo, mza_codseccion);


--
-- Name: marauto_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY marauto
    ADD CONSTRAINT marauto_pkey PRIMARY KEY (mar_codigo);


--
-- Name: marcont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY marcont
    ADD CONSTRAINT marcont_pkey PRIMARY KEY (marc_codigo);


--
-- Name: menues_pkey; Type: CONSTRAINT; Schema: public; Owner: zonab; Tablespace: 
--

ALTER TABLE ONLY menues
    ADD CONSTRAINT menues_pkey PRIMARY KEY (men_id);


--
-- Name: mercaestad_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY mercaestad
    ADD CONSTRAINT mercaestad_pkey PRIMARY KEY (mestad_codigo);


--
-- Name: modauto_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY modauto
    ADD CONSTRAINT modauto_pkey PRIMARY KEY (mod_id);


--
-- Name: modopub_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT modopub_pkey PRIMARY KEY (mod_id);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsleyen_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY movsleyen
    ADD CONSTRAINT movsleyen_pkey PRIMARY KEY (mvl_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: movstoc_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT movstoc_pkey PRIMARY KEY (movc_id);


--
-- Name: noticias_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY noticias
    ADD CONSTRAINT noticias_pkey PRIMARY KEY (not_id);


--
-- Name: operaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT operaciones_pkey PRIMARY KEY (op_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: operest_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY operest
    ADD CONSTRAINT operest_pkey PRIMARY KEY (opr_idoper);


--
-- Name: opervehi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY opervehi
    ADD CONSTRAINT opervehi_pkey PRIMARY KEY (opv_id);


--
-- Name: ordenpag_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ordenpag
    ADD CONSTRAINT ordenpag_pkey PRIMARY KEY (orp_idastoh);


--
-- Name: outogxl_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY outgxl
    ADD CONSTRAINT outogxl_pkey PRIMARY KEY (ogxl_iol, ogxl_io);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: posaran_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY posaran
    ADD CONSTRAINT posaran_pkey PRIMARY KEY (posa_codigo);


--
-- Name: posarest_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY posarest
    ADD CONSTRAINT posarest_pkey PRIMARY KEY (posar_codigo);


--
-- Name: problimp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY problimp
    ADD CONSTRAINT problimp_pkey PRIMARY KEY (pim_id);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: puertos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY puertos
    ADD CONSTRAINT puertos_pkey PRIMARY KEY (pue_codigo);


--
-- Name: relmenu_pkey; Type: CONSTRAINT; Schema: public; Owner: zonab; Tablespace: 
--

ALTER TABLE ONLY relmenu
    ADD CONSTRAINT relmenu_pkey PRIMARY KEY (rmen_id);


--
-- Name: retiros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY retiros
    ADD CONSTRAINT retiros_pkey PRIMARY KEY (ret_id);


--
-- Name: retirosd_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY retirosd
    ADD CONSTRAINT retirosd_pkey PRIMARY KEY (retd_id);


--
-- Name: retstock_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY retstock
    ADD CONSTRAINT retstock_pkey PRIMARY KEY (rstk_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- Name: seguros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY seguros
    ADD CONSTRAINT seguros_pkey PRIMARY KEY (seg_unifun, seg_poliza);


--
-- Name: sitemxvehi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY sitemxvehi
    ADD CONSTRAINT sitemxvehi_pkey PRIMARY KEY (sv_id);


--
-- Name: stock_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT stock_pkey PRIMARY KEY (stk_id);


--
-- Name: subd_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT subd_pkey PRIMARY KEY (subd_id);


--
-- Name: subitem_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT subitem_pkey PRIMARY KEY (sitem_id);


--
-- Name: subitemd_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subitemd
    ADD CONSTRAINT subitemd_pkey PRIMARY KEY (sitemd_id);


--
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_id);


--
-- Name: subtcontrat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subtcontrat
    ADD CONSTRAINT subtcontrat_pkey PRIMARY KEY (subt_id);


--
-- Name: subxcomp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY subxcomp
    ADD CONSTRAINT subxcomp_pkey PRIMARY KEY (subxc_idsub, subxc_comprob);


--
-- Name: sucursal_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY sucursal
    ADD CONSTRAINT sucursal_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: sucursales_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT sucursales_pkey PRIMARY KEY (suc_cliente, suc_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: talonop_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY talonop
    ADD CONSTRAINT talonop_pkey PRIMARY KEY (talop_usuario, talop_tipoper);


--
-- Name: tarjeta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tarjeta
    ADD CONSTRAINT tarjeta_pkey PRIMARY KEY (tar_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipcontrat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipcontrat
    ADD CONSTRAINT tipcontrat_pkey PRIMARY KEY (tipc_codigo);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tipgente_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipgente
    ADD CONSTRAINT tipgente_pkey PRIMARY KEY (tgte_id);


--
-- Name: tiplog_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tiplog
    ADD CONSTRAINT tiplog_pkey PRIMARY KEY (tipl_codigo);


--
-- Name: tipoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipoper
    ADD CONSTRAINT tipoper_pkey PRIMARY KEY (top_codigo);


--
-- Name: tipprod_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipprod
    ADD CONSTRAINT tipprod_pkey PRIMARY KEY (tip_codigo);


--
-- Name: tippxunif_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tippxunif
    ADD CONSTRAINT tippxunif_pkey PRIMARY KEY (txu_codtipp, txu_codunif);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tipusu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipusu
    ADD CONSTRAINT tipusu_pkey PRIMARY KEY (tpu_codigo);


--
-- Name: unifun_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY unifun
    ADD CONSTRAINT unifun_pkey PRIMARY KEY (unif_codigo);


--
-- Name: unilot_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY unilot
    ADD CONSTRAINT unilot_pkey PRIMARY KEY (unil_codunifun, unit_idlote);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: usermenu_pkey; Type: CONSTRAINT; Schema: public; Owner: zonab; Tablespace: 
--

ALTER TABLE ONLY usermenu
    ADD CONSTRAINT usermenu_pkey PRIMARY KEY (umen_id);


--
-- Name: usuarios_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT usuarios_pkey PRIMARY KEY (usu_codigo);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: vendedor_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY vendedor
    ADD CONSTRAINT vendedor_pkey PRIMARY KEY (ven_id);


--
-- Name: visita_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY visita
    ADD CONSTRAINT visita_pkey PRIMARY KEY (vt_id);


--
-- Name: wleyenrexp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY wleyenrexp
    ADD CONSTRAINT wleyenrexp_pkey PRIMARY KEY (wleyr_id);


--
-- Name: woperaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY woperaciones
    ADD CONSTRAINT woperaciones_pkey PRIMARY KEY (wop_id);


--
-- Name: wret2_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY wret2
    ADD CONSTRAINT wret2_pkey PRIMARY KEY (wret2_id);


--
-- Name: zona_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT zona_pkey PRIMARY KEY (zon_codigo);


--
-- Name: artico; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX artico ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente, cfac_estado, cfac_idart);


--
-- Name: barrei; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX barrei ON "inout" USING btree (io_estado, io_barrei, io_fecin);


--
-- Name: barreil; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX barreil ON inoutliv USING btree (iol_estado, iol_barrei, iol_fecin);


--
-- Name: barreo; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX barreo ON "inout" USING btree (io_estado, io_barreo, io_fecin);


--
-- Name: barreol; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX barreol ON inoutliv USING btree (iol_estado, iol_barreo, iol_fecin);


--
-- Name: carvis1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX carvis1 ON carvis USING btree (cvt_gente);


--
-- Name: carvis2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX carvis2 ON carvis USING btree (cvt_estado, cvt_gente, cvt_fecdes, cvt_fechas);


--
-- Name: carvis3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX carvis3 ON carvis USING btree (cvt_estado, cvt_gente, cvt_operad);


--
-- Name: carvis4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX carvis4 ON carvis USING btree (cvt_estado, cvt_gente, cvt_usuario, cvt_operad);


--
-- Name: cfac_empresa; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cfac_empresa ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente);


--
-- Name: cfac_estado; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cfac_estado ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente, cfac_estado);


--
-- Name: cuando; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cuando ON "inout" USING btree (io_gente, io_fecin);


--
-- Name: cuandol; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cuandol ON inoutliv USING btree (iol_liviano, iol_fecin);


--
-- Name: cuandov; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cuandov ON visita USING btree (vt_gente, vt_fecin);


--
-- Name: cuitl; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX cuitl ON gente USING btree (gte_cuitl);


--
-- Name: dequienl; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX dequienl ON livianos USING btree (lv_estado, lv_gente);


--
-- Name: despachantes; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX despachantes ON despach USING btree (desp_tipo, desp_nrcuit);


--
-- Name: docu; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX docu ON gente USING btree (gte_tdoc, gte_nrodoc);


--
-- Name: embalaje; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX embalaje ON embalajes USING btree (emb_codigo);


--
-- Name: est_comp; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX est_comp ON estiba USING btree (est_tipo, est_codigo, est_numero);


--
-- Name: est_directo; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX est_directo ON estiba USING btree (est_directo, est_codigo, est_numero, est_fecha);


--
-- Name: est_fecha; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX est_fecha ON estiba USING btree (est_fecha);


--
-- Name: estado; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX estado ON facturacion USING btree (fac_codemp, fac_ptov, fac_cliente, fac_estado);


--
-- Name: estan; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX estan ON "inout" USING btree (io_estado, io_fecin);


--
-- Name: estanl; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX estanl ON inoutliv USING btree (iol_estado, iol_fecin);


--
-- Name: estanv; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX estanv ON visita USING btree (vt_estado, vt_fecin);


--
-- Name: evento; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX evento ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente, cfac_estado, cfac_evento);


--
-- Name: idx_almacen1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_almacen1 ON almacen USING btree (alm_leyenda);


--
-- Name: idx_articu_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_articu_1 ON articu USING btree (artic_indirecto, artic_codigo);


--
-- Name: idx_articud_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_articud_1 ON articud USING btree (articd_indirecto, articd_codigo);


--
-- Name: idx_articud_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_articud_2 ON articud USING btree (articd_idartic);


--
-- Name: idx_articud_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_articud_3 ON articud USING btree (articd_idartic, articd_indirecto, articd_codigo);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_tipoper, art_codigo);


--
-- Name: idx_articvta_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_2 ON articvta USING btree (art_idptov, art_codi);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_fecomp);


--
-- Name: idx_autorizados_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_autorizados_1 ON autorizados USING btree (aut_usuario);


--
-- Name: idx_auxfe_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_auxfe_1 ON auxfe USING btree (fe_estado, fe_fechaf, fe_idcli);


--
-- Name: idx_caratula_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_caratula_3 ON caratula USING btree (transito);


--
-- Name: idx_caratula_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_caratula_4 ON caratula USING btree (despacho);


--
-- Name: idx_centroc_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_centroc_1 ON centroc USING btree (cco_codemp, cco_idptov, cco_coddiv, cco_codigo);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_clientes_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_clientes_1 ON clientes USING btree (cli_codemp, cli_idptov, cli_codigo);


--
-- Name: idx_clientes_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_clientes_2 ON clientes USING btree (cli_codemp, cli_codaso);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_comprob_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_comprob_1 ON comprob USING btree (comp_idptov, comp_codigo);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_siste, comp_idptov, comp_codigo);


--
-- Name: idx_confac_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_confac_2 ON confactur USING btree (cfc_fecha);


--
-- Name: idx_confac_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_confac_3 ON confactur USING btree (cfc_anio, cfc_mes, cfc_usuario);


--
-- Name: idx_confac_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_confac_4 ON confactur USING btree (cfc_anio, cfc_mes, cfc_ptov);


--
-- Name: idx_confac_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_confac_5 ON confactur USING btree (cfc_anio, cfc_mes, cfc_ptov, cfc_idart);


--
-- Name: idx_confac_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_confac_6 ON confactur USING btree (cfc_anio, cfc_mes, cfc_ptov, cfc_usuario);


--
-- Name: idx_consig_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_consig_1 ON consig USING btree (csg_nrocuit);


--
-- Name: idx_contratos_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_contratos_1 ON contratos USING btree (contr_locador, contr_id);


--
-- Name: idx_contratos_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_2 ON contratos USING btree (contr_estado, contr_locador);


--
-- Name: idx_contratos_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_3 ON contratos USING btree (contr_estado, contr_locatario);


--
-- Name: idx_contratos_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_4 ON contratos USING btree (contr_estado, contr_locador, contr_locatario);


--
-- Name: idx_contratos_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_5 ON contratos USING btree (contr_locador, contr_locatario, contr_idsubt);


--
-- Name: idx_contratos_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_6 ON contratos USING btree (contr_locador, contr_idsubt);


--
-- Name: idx_contratos_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_contratos_7 ON contratos USING btree (contr_locatario, contr_idsubt);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_codigo);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_division_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_division_1 ON division USING btree (div_codemp, div_idptov, div_codigo);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_item_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_item_1 ON item USING btree (item_idoper, item_item);


--
-- Name: idx_items_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_items_2 ON items USING btree (items_despacho);


--
-- Name: idx_items_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_items_3 ON items USING btree (items_transito);


--
-- Name: idx_items_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_items_4 ON items USING btree (items_despacho, nro_item, numero_subitem);


--
-- Name: idx_listpre_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_listpre_1 ON listpre USING btree (ltp_idcli, ltp_idart);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_movstoc_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movstoc_1 ON movstoc USING btree (movc_idcompra);


--
-- Name: idx_movstoc_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movstoc_2 ON movstoc USING btree (movc_idastoh);


--
-- Name: idx_movstoc_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movstoc_3 ON movstoc USING btree (movc_artic);


--
-- Name: idx_movstoc_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movstoc_4 ON movstoc USING btree (movc_codemp, movc_idptov, movc_artic);


--
-- Name: idx_movstoc_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_movstoc_5 ON movstoc USING btree (movc_idastoh, movc_artic);


--
-- Name: idx_noticias_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_noticias_1 ON noticias USING btree (not_tipo, not_numero);


--
-- Name: idx_noticias_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_noticias_2 ON noticias USING btree (not_numero);


--
-- Name: idx_operaciones_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_1 ON operaciones USING btree (op_compbte);


--
-- Name: idx_operaciones_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_10 ON operaciones USING btree (op_indirecto, op_estado, op_tipoper, op_fechain, op_deposito);


--
-- Name: idx_operaciones_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_11 ON operaciones USING btree (op_indirecto, op_estado, op_tipoper, op_fechain, op_deposito, op_id);


--
-- Name: idx_operaciones_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_2 ON operaciones USING btree (op_directo, op_consig);


--
-- Name: idx_operaciones_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_5 ON operaciones USING btree (op_estado, op_tipoper);


--
-- Name: idx_operaciones_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_6 ON operaciones USING btree (op_idopw);


--
-- Name: idx_operaciones_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_7 ON operaciones USING btree (op_estado, op_tipoper, op_fechain);


--
-- Name: idx_operaciones_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_8 ON operaciones USING btree (op_estado, op_directo, op_indirecto);


--
-- Name: idx_operaciones_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_operaciones_9 ON operaciones USING btree (op_directo, op_indirecto);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_opervehi_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_opervehi_1 ON opervehi USING btree (opv_idoper);


--
-- Name: idx_opervehi_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_opervehi_2 ON opervehi USING btree (opv_est_camion, opv_id);


--
-- Name: idx_opervehi_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_opervehi_3 ON opervehi USING btree (opv_est_camion, opv_fecha_egr);


--
-- Name: idx_opervehi_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_opervehi_4 ON opervehi USING btree (opv_pat_tractor);


--
-- Name: idx_opervehi_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_opervehi_5 ON opervehi USING btree (opv_est_camion, opv_pat_tractor);


--
-- Name: idx_prove_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_prove_1 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_retiros_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_retiros_1 ON retiros USING btree (ret_idopera, ret_idsitem, ret_id);


--
-- Name: idx_retiros_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retiros_2 ON retiros USING btree (ret_idopera);


--
-- Name: idx_retiros_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retiros_3 ON retiros USING btree (ret_idsitem);


--
-- Name: idx_retiros_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retiros_4 ON retiros USING btree (ret_cantidad, ret_idsitem, ret_idopera);


--
-- Name: idx_retiros_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retiros_5 ON retiros USING btree (ret_idsitem, ret_idopera);


--
-- Name: idx_retirosd_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_retirosd_1 ON retirosd USING btree (retd_idopera, retd_idsitem, retd_id);


--
-- Name: idx_retirosd_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retirosd_2 ON retirosd USING btree (retd_idopera);


--
-- Name: idx_retirosd_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retirosd_3 ON retirosd USING btree (retd_idsitem);


--
-- Name: idx_retstock_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_retstock_1 ON retstock USING btree (rstk_idopera, rstk_idstk, rstk_id);


--
-- Name: idx_retstock_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retstock_2 ON retstock USING btree (rstk_idopera);


--
-- Name: idx_retstock_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retstock_3 ON retstock USING btree (rstk_idretd);


--
-- Name: idx_retstock_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_retstock_4 ON retstock USING btree (rstk_idstk);


--
-- Name: idx_rubros_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_rubros_1 ON rubros USING btree (rub_tipo, rub_codigo);


--
-- Name: idx_stock_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_stock_1 ON stock USING btree (stk_idoper, stk_id);


--
-- Name: idx_stock_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_10 ON stock USING btree (stk_comptras);


--
-- Name: idx_stock_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_11 ON stock USING btree (stk_estado, stk_cliente);


--
-- Name: idx_stock_12; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_12 ON stock USING btree (stk_cliente);


--
-- Name: idx_stock_13; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_13 ON stock USING btree (stk_idsitem);


--
-- Name: idx_stock_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_2 ON stock USING btree (stk_estado, stk_idsitem);


--
-- Name: idx_stock_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_3 ON stock USING btree (stk_estado, stk_directo, stk_indirecto, stk_compbte, stk_artic);


--
-- Name: idx_stock_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_4 ON stock USING btree (stk_estado, stk_compbte);


--
-- Name: idx_stock_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_5 ON stock USING btree (stk_estado, stk_deposito);


--
-- Name: idx_stock_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_6 ON stock USING btree (stk_estado, stk_directo, stk_indirecto, stk_artic);


--
-- Name: idx_stock_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_7 ON stock USING btree (stk_estado, stk_indirecto);


--
-- Name: idx_stock_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_8 ON stock USING btree (stk_estado, stk_artic);


--
-- Name: idx_stock_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_stock_9 ON stock USING btree (stk_artic);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_subitem_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_subitem_1 ON subitem USING btree (sitem_idoper, sitem_id);


--
-- Name: idx_subitem_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_10 ON subitem USING btree (sitem_compbte);


--
-- Name: idx_subitem_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_11 ON subitem USING btree (sitem_estado, sitem_directo, sitem_indirecto, sitem_compbte);


--
-- Name: idx_subitem_12; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_12 ON subitem USING btree (sitem_deposito);


--
-- Name: idx_subitem_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_2 ON subitem USING btree (sitem_estado, sitem_id);


--
-- Name: idx_subitem_20; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_20 ON subitem USING btree (sitem_idoper, sitem_cantret, sitem_canting, sitem_imp_dolar);


--
-- Name: idx_subitem_21; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_21 ON subitem USING btree (sitem_idoper, sitem_cantret, sitem_canting, sitem_imp_dolar, sitem_id);


--
-- Name: idx_subitem_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_3 ON subitem USING btree (sitem_estado, sitem_directo, sitem_indirecto, sitem_compbte, sitem_artic);


--
-- Name: idx_subitem_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_5 ON subitem USING btree (sitem_estado, sitem_deposito);


--
-- Name: idx_subitem_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_6 ON subitem USING btree (sitem_estado, sitem_directo, sitem_indirecto, sitem_artic);


--
-- Name: idx_subitem_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_7 ON subitem USING btree (sitem_estado, sitem_indirecto);


--
-- Name: idx_subitem_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_8 ON subitem USING btree (sitem_estado, sitem_artic);


--
-- Name: idx_subitem_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitem_9 ON subitem USING btree (sitem_artic);


--
-- Name: idx_subitemd_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_subitemd_1 ON subitemd USING btree (sitemd_idoper, sitemd_id);


--
-- Name: idx_subitemd_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_10 ON subitemd USING btree (sitemd_comptras);


--
-- Name: idx_subitemd_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_11 ON subitemd USING btree (sitemd_estado, sitemd_cliente);


--
-- Name: idx_subitemd_12; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_12 ON subitemd USING btree (sitemd_cliente);


--
-- Name: idx_subitemd_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_2 ON subitemd USING btree (sitemd_estado, sitemd_id);


--
-- Name: idx_subitemd_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_3 ON subitemd USING btree (sitemd_estado, sitemd_directo, sitemd_indirecto, sitemd_compbte, sitemd_artic);


--
-- Name: idx_subitemd_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_4 ON subitemd USING btree (sitemd_estado, sitemd_compbte);


--
-- Name: idx_subitemd_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_5 ON subitemd USING btree (sitemd_estado, sitemd_deposito);


--
-- Name: idx_subitemd_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_6 ON subitemd USING btree (sitemd_estado, sitemd_directo, sitemd_indirecto, sitemd_artic);


--
-- Name: idx_subitemd_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_7 ON subitemd USING btree (sitemd_estado, sitemd_indirecto);


--
-- Name: idx_subitemd_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_8 ON subitemd USING btree (sitemd_estado, sitemd_artic);


--
-- Name: idx_subitemd_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subitemd_9 ON subitemd USING btree (sitemd_artic);


--
-- Name: idx_subrub_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_subrub_1 ON subrub USING btree (srb_rubro, srb_codigo);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: idx_usuarios_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_usuarios_1 ON usuarios USING btree (usu_nrocuit);


--
-- Name: idx_usuarios_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_usuarios_2 ON usuarios USING btree (usu_tipusu, usu_codigo);


--
-- Name: idx_usuarios_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_usuarios_3 ON usuarios USING btree (usu_estado, usu_tipusu, usu_codigo);


--
-- Name: idx_volegr_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_volegr_1 ON volegr USING btree (vole_idoperi, vole_fechaeg, vole_estado);


--
-- Name: idx_volegr_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_volegr_2 ON volegr USING btree (vole_idoperi, vole_fechaeg, vole_estado, vole_cantret);


--
-- Name: idx_voling_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_voling_1 ON voling USING btree (vol_idoper, vol_indirecto, vol_canting, vol_cantret, vol_ultfac);


--
-- Name: idx_voling_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_voling_2 ON voling USING btree (vol_idoper, vol_indirecto, vol_canting, vol_cantret);


--
-- Name: idx_voling_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_voling_3 ON voling USING btree (vol_idoper, vol_indirecto, vol_canting);


--
-- Name: idx_voling_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_voling_4 ON voling USING btree (vol_indirecto, vol_directo, vol_ultfac, vol_factu, vol_idoper);


--
-- Name: idx_voling_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_voling_5 ON voling USING btree (vol_indirecto, vol_ultfac, vol_factu, vol_idoper, vol_estado, vol_fechain);


--
-- Name: idx_wnoticias_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wnoticias_2 ON wnoticias USING btree (wnot_estado, wnot_directo);


--
-- Name: idx_woperaciones_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_woperaciones_2 ON woperaciones USING btree (wop_directo, wop_indirecto);


--
-- Name: idx_woperaciones_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_woperaciones_3 ON woperaciones USING btree (wop_estado, wop_directo, wop_indirecto);


--
-- Name: idx_woperaciones_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_woperaciones_4 ON woperaciones USING btree (wop_directo, wop_indirecto, wop_tipoper, wop_estado);


--
-- Name: idx_wret2_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wret2_2 ON wret2 USING btree (wret2_idopera);


--
-- Name: idx_wret2_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wret2_3 ON wret2 USING btree (wret2_idsitem);


--
-- Name: idx_wret2_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wret2_4 ON wret2 USING btree (wret2_estado);


--
-- Name: idx_wretiros_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_wretiros_1 ON wretiros USING btree (wret_id);


--
-- Name: idx_wretiros_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wretiros_2 ON wretiros USING btree (wret_idsitem);


--
-- Name: idx_wretiros_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wretiros_3 ON wretiros USING btree (wret_compbte);


--
-- Name: idx_wsubitem_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_wsubitem_1 ON wsubitem USING btree (wsitem_id);


--
-- Name: idx_wsubitem_10; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_10 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_artic);


--
-- Name: idx_wsubitem_11; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_11 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte, wsitem_artic);


--
-- Name: idx_wsubitem_12; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_12 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_codart);


--
-- Name: idx_wsubitem_13; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_13 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_idoper);


--
-- Name: idx_wsubitem_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_2 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto);


--
-- Name: idx_wsubitem_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_3 ON wsubitem USING btree (wsitem_compbte);


--
-- Name: idx_wsubitem_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_4 ON wsubitem USING btree (wsitem_comptrans);


--
-- Name: idx_wsubitem_5; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_5 ON wsubitem USING btree (wsitem_codart);


--
-- Name: idx_wsubitem_6; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_6 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_consig);


--
-- Name: idx_wsubitem_7; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_7 ON wsubitem USING btree (wsitem_directo, wsitem_consig);


--
-- Name: idx_wsubitem_8; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_8 ON wsubitem USING btree (wsitem_indirecto, wsitem_codart);


--
-- Name: idx_wsubitem_9; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_wsubitem_9 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte);


--
-- Name: iolfecin; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX iolfecin ON inoutliv USING btree (iol_fecin);


--
-- Name: iolfecout; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX iolfecout ON inoutliv USING btree (iol_fecout);


--
-- Name: let_estado; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX let_estado ON lecting USING btree (let_estado, let_placa, let_barrera);


--
-- Name: nombreg; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX nombreg ON gente USING btree (gte_nombre);


--
-- Name: operest1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX operest1 ON operest USING btree (opr_estado, opr_compbte, opr_idoper);


--
-- Name: patente; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX patente ON livianos USING btree (lv_patente);


--
-- Name: periodo; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX periodo ON facturacion USING btree (fac_codemp, fac_ptov, fac_cliente, fac_anio, fac_mes);


--
-- Name: subitem_4; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX subitem_4 ON subitem USING btree (sitem_estado, sitem_compbte);


--
-- Name: subt_contrato; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX subt_contrato ON subtcontrat USING btree (subt_idtipc, subt_codigo);


--
-- Name: tarjet; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX tarjet ON gente USING btree (gte_estado, gte_tarjeta);


--
-- Name: tarjetas; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX tarjetas ON gente USING btree (gte_tarjeta, gte_estado);


--
-- Name: tip_contrato; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX tip_contrato ON tipcontrat USING btree (tipc_codigo);


--
-- Name: verificacion; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX verificacion ON opervehi USING btree (opv_verif);


--
-- Name: xpkdesdes; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX xpkdesdes ON subitem USING btree (sitem_id);


--
-- Name: xpkmercaestad; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX xpkmercaestad ON mercaestad USING btree (mestad_codigo);


--
-- Name: xpkoperacion; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX xpkoperacion ON operaciones USING btree (op_id);


--
-- Name: xpktipmovim; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX xpktipmovim ON tipoper USING btree (top_codigo);


--
-- Name: ad_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_retiros AFTER DELETE ON retiros FOR EACH ROW EXECUTE PROCEDURE f_ad_retiros();


--
-- Name: ad_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_seguros AFTER DELETE ON seguros FOR EACH ROW EXECUTE PROCEDURE f_ad_seguros();


--
-- Name: ad_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_subitem AFTER DELETE ON subitem FOR EACH ROW EXECUTE PROCEDURE f_ad_subitem();


--
-- Name: ad_volegr; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_volegr AFTER DELETE ON volegr FOR EACH ROW EXECUTE PROCEDURE f_ad_volegr();


--
-- Name: ad_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_wret2 AFTER DELETE ON wret2 FOR EACH ROW EXECUTE PROCEDURE f_ad_wret2();


--
-- Name: ai_artseg; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_artseg AFTER INSERT ON artseg FOR EACH ROW EXECUTE PROCEDURE f_ai_artseg();


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_astoctas AFTER INSERT ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_clientes; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_clientes AFTER INSERT ON clientes FOR EACH ROW EXECUTE PROCEDURE f_ai_clientes();


--
-- Name: ai_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_contratos AFTER INSERT ON contratos FOR EACH ROW EXECUTE PROCEDURE f_ai_contratos();


--
-- Name: ai_ingzpa; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_ingzpa AFTER INSERT ON ingzpa FOR EACH ROW EXECUTE PROCEDURE f_ai_ingzpa();


--
-- Name: ai_item; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_item AFTER INSERT ON item FOR EACH ROW EXECUTE PROCEDURE f_ai_item();


--
-- Name: ai_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_operaciones AFTER INSERT ON operaciones FOR EACH ROW EXECUTE PROCEDURE f_ai_operaciones();


--
-- Name: ai_prove; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_prove AFTER INSERT ON prove FOR EACH ROW EXECUTE PROCEDURE f_ai_prove();


--
-- Name: ai_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_retiros AFTER INSERT ON retiros FOR EACH ROW EXECUTE PROCEDURE f_ai_retiros();


--
-- Name: ai_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_seguros AFTER INSERT ON seguros FOR EACH ROW EXECUTE PROCEDURE f_ai_seguros();


--
-- Name: ai_usuarios; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_usuarios AFTER INSERT ON usuarios FOR EACH ROW EXECUTE PROCEDURE f_ai_usuarios();


--
-- Name: ai_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_wret2 AFTER INSERT ON wret2 FOR EACH ROW EXECUTE PROCEDURE f_ai_wret2();


--
-- Name: au_artseg; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_artseg AFTER UPDATE ON artseg FOR EACH ROW EXECUTE PROCEDURE f_au_artseg();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_astoctas AFTER UPDATE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_astoh AFTER UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_auxoper; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_auxoper AFTER UPDATE ON auxoper FOR EACH ROW EXECUTE PROCEDURE f_au_auxoper();


--
-- Name: au_clientes; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_clientes AFTER UPDATE ON clientes FOR EACH ROW EXECUTE PROCEDURE f_au_clientes();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_compra AFTER UPDATE ON compra FOR EACH ROW EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_contratos AFTER UPDATE ON contratos FOR EACH ROW EXECUTE PROCEDURE f_au_contratos();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_emiti AFTER UPDATE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_feccontra; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_feccontra AFTER UPDATE ON feccontra FOR EACH ROW EXECUTE PROCEDURE f_au_feccontra();


--
-- Name: au_gente; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_gente AFTER UPDATE ON gente FOR EACH ROW EXECUTE PROCEDURE f_au_gente();


--
-- Name: au_ingzpa; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_ingzpa AFTER UPDATE ON ingzpa FOR EACH ROW EXECUTE PROCEDURE f_au_ingzpa();


--
-- Name: au_inout; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_inout AFTER UPDATE ON "inout" FOR EACH ROW EXECUTE PROCEDURE f_au_inout();


--
-- Name: au_item; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_item BEFORE UPDATE ON item FOR EACH ROW EXECUTE PROCEDURE f_au_item();


--
-- Name: au_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_operaciones AFTER UPDATE ON operaciones FOR EACH ROW EXECUTE PROCEDURE f_au_operaciones();


--
-- Name: au_opervehi; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_opervehi AFTER UPDATE ON opervehi FOR EACH ROW EXECUTE PROCEDURE f_au_opervehi();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_prove AFTER UPDATE ON prove FOR EACH ROW EXECUTE PROCEDURE f_au_prove();


--
-- Name: au_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_retiros AFTER UPDATE ON retiros FOR EACH ROW EXECUTE PROCEDURE f_au_retiros();


--
-- Name: au_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_seguros AFTER UPDATE ON seguros FOR EACH ROW EXECUTE PROCEDURE f_au_seguros();


--
-- Name: au_sucursales; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_sucursales AFTER UPDATE ON sucursales FOR EACH ROW EXECUTE PROCEDURE f_au_sucursales();


--
-- Name: au_unifun; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_unifun AFTER UPDATE ON unifun FOR EACH ROW EXECUTE PROCEDURE f_au_unifun();


--
-- Name: au_usuarios; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_usuarios AFTER UPDATE ON usuarios FOR EACH ROW EXECUTE PROCEDURE f_au_usuarios();


--
-- Name: au_volegr; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_volegr AFTER UPDATE ON volegr FOR EACH ROW EXECUTE PROCEDURE f_au_volegr();


--
-- Name: au_voling; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_voling AFTER UPDATE ON voling FOR EACH ROW EXECUTE PROCEDURE f_au_voling();


--
-- Name: au_woperaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_woperaciones AFTER UPDATE ON woperaciones FOR EACH ROW EXECUTE PROCEDURE f_au_woperaciones();


--
-- Name: au_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_wret2 AFTER UPDATE ON wret2 FOR EACH ROW EXECUTE PROCEDURE f_au_wret2();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bd_astoctas BEFORE DELETE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bd_astoh BEFORE DELETE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bd_emiti BEFORE DELETE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bd_subitem BEFORE DELETE ON subitem FOR EACH ROW EXECUTE PROCEDURE f_bd_subitem();


--
-- Name: bi_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_contratos BEFORE INSERT ON contratos FOR EACH ROW EXECUTE PROCEDURE f_bi_contratos();


--
-- Name: bi_item; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_item BEFORE INSERT ON item FOR EACH ROW EXECUTE PROCEDURE f_bi_item();


--
-- Name: bi_lecting; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_lecting BEFORE INSERT ON lecting FOR EACH ROW EXECUTE PROCEDURE f_bi_lecting();


--
-- Name: bi_puertos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_puertos BEFORE INSERT ON puertos FOR EACH ROW EXECUTE PROCEDURE f_bi_puertos();


--
-- Name: bi_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_retiros BEFORE INSERT ON retiros FOR EACH ROW EXECUTE PROCEDURE f_bi_retiros();


--
-- Name: bi_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_subitem BEFORE INSERT ON subitem FOR EACH ROW EXECUTE PROCEDURE f_bi_subitem();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_astoh BEFORE UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_caratula; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_caratula BEFORE UPDATE ON caratula FOR EACH ROW EXECUTE PROCEDURE f_bu_caratula();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_cheques BEFORE UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: bu_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_operaciones BEFORE UPDATE ON operaciones FOR EACH ROW EXECUTE PROCEDURE f_bu_operaciones();


--
-- Name: bu_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_retiros BEFORE UPDATE ON retiros FOR EACH ROW EXECUTE PROCEDURE f_bu_retiros();


--
-- Name: bu_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_seguros BEFORE UPDATE ON seguros FOR EACH ROW EXECUTE PROCEDURE f_bu_seguros();


--
-- Name: bu_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_subitem BEFORE UPDATE ON subitem FOR EACH ROW EXECUTE PROCEDURE f_bu_subitem();


--
-- Name: bu_volegr; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_volegr BEFORE UPDATE ON volegr FOR EACH ROW EXECUTE PROCEDURE f_bu_volegr();


--
-- Name: bu_voling; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_voling AFTER UPDATE ON voling FOR EACH ROW EXECUTE PROCEDURE f_bu_voling();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$1" FOREIGN KEY (tal_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inhabilit
    ADD CONSTRAINT "$1" FOREIGN KEY (inh_usuario) REFERENCES usuarios(usu_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wretiros
    ADD CONSTRAINT "$1" FOREIGN KEY (wret_idsitem) REFERENCES wsubitem(wsitem_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wret2
    ADD CONSTRAINT "$1" FOREIGN KEY (wret2_idsitem) REFERENCES subitem(sitem_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inhabilit
    ADD CONSTRAINT "$2" FOREIGN KEY (inh_deposito) REFERENCES unifun(unif_codigo);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inhabilit
    ADD CONSTRAINT "$3" FOREIGN KEY (inh_operadi) REFERENCES operadores(operad_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inhabilit
    ADD CONSTRAINT "$4" FOREIGN KEY (inh_operadh) REFERENCES operadores(operad_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: actas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE actas FROM PUBLIC;
REVOKE ALL ON TABLE actas FROM zona;
GRANT ALL ON TABLE actas TO zona;
GRANT ALL ON TABLE actas TO nobody;


--
-- Name: actas_acta_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE actas_acta_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE actas_acta_id_seq FROM zona;
GRANT ALL ON SEQUENCE actas_acta_id_seq TO zona;
GRANT UPDATE ON SEQUENCE actas_acta_id_seq TO nobody;


--
-- Name: aduanas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE aduanas FROM PUBLIC;
REVOKE ALL ON TABLE aduanas FROM zona;
GRANT ALL ON TABLE aduanas TO zona;
GRANT ALL ON TABLE aduanas TO nobody;


--
-- Name: almacen; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE almacen FROM PUBLIC;
REVOKE ALL ON TABLE almacen FROM zona;
GRANT ALL ON TABLE almacen TO zona;
GRANT ALL ON TABLE almacen TO nobody;


--
-- Name: almacen_alm_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE almacen_alm_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE almacen_alm_id_seq FROM zona;
GRANT ALL ON SEQUENCE almacen_alm_id_seq TO zona;
GRANT UPDATE ON SEQUENCE almacen_alm_id_seq TO nobody;


--
-- Name: articu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articu FROM PUBLIC;
REVOKE ALL ON TABLE articu FROM zona;
GRANT ALL ON TABLE articu TO zona;
GRANT ALL ON TABLE articu TO nobody;


--
-- Name: articu1; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articu1 FROM PUBLIC;
REVOKE ALL ON TABLE articu1 FROM zona;
GRANT ALL ON TABLE articu1 TO zona;
GRANT ALL ON TABLE articu1 TO nobody;


--
-- Name: articu_artic_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE articu_artic_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articu_artic_id_seq FROM zona;
GRANT ALL ON SEQUENCE articu_artic_id_seq TO zona;
GRANT UPDATE ON SEQUENCE articu_artic_id_seq TO nobody;


--
-- Name: articud; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articud FROM PUBLIC;
REVOKE ALL ON TABLE articud FROM zona;
GRANT ALL ON TABLE articud TO zona;
GRANT ALL ON TABLE articud TO nobody;


--
-- Name: articud_articd_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE articud_articd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articud_articd_id_seq FROM zona;
GRANT ALL ON SEQUENCE articud_articd_id_seq TO zona;
GRANT UPDATE ON SEQUENCE articud_articd_id_seq TO nobody;


--
-- Name: articud_articd_idartic_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE articud_articd_idartic_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articud_articd_idartic_seq FROM zona;
GRANT ALL ON SEQUENCE articud_articd_idartic_seq TO zona;
GRANT UPDATE ON SEQUENCE articud_articd_idartic_seq TO nobody;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM zona;
GRANT ALL ON TABLE articvta TO zona;
GRANT ALL ON TABLE articvta TO nobody;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM zona;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO zona;
GRANT UPDATE ON SEQUENCE articvta_art_id_seq TO nobody;


--
-- Name: artseg; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE artseg FROM PUBLIC;
REVOKE ALL ON TABLE artseg FROM zona;
GRANT ALL ON TABLE artseg TO zona;
GRANT ALL ON TABLE artseg TO nobody;


--
-- Name: artseg_as_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE artseg_as_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE artseg_as_id_seq FROM zona;
GRANT ALL ON SEQUENCE artseg_as_id_seq TO zona;
GRANT UPDATE ON SEQUENCE artseg_as_id_seq TO nobody;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM zona;
GRANT ALL ON TABLE astoctas TO zona;
GRANT ALL ON TABLE astoctas TO nobody;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM zona;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE astoctas_astc_id_seq TO nobody;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM zona;
GRANT ALL ON TABLE astoh TO zona;
GRANT ALL ON TABLE astoh TO nobody;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM zona;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO zona;
GRANT UPDATE ON SEQUENCE astoh_ash_id_seq TO nobody;


--
-- Name: autorizados; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE autorizados FROM PUBLIC;
REVOKE ALL ON TABLE autorizados FROM zona;
GRANT ALL ON TABLE autorizados TO zona;
GRANT ALL ON TABLE autorizados TO nobody;


--
-- Name: autorizados_aut_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE autorizados_aut_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE autorizados_aut_id_seq FROM zona;
GRANT ALL ON SEQUENCE autorizados_aut_id_seq TO zona;
GRANT UPDATE ON SEQUENCE autorizados_aut_id_seq TO nobody;


--
-- Name: auxfe; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxfe FROM PUBLIC;
REVOKE ALL ON TABLE auxfe FROM zona;
GRANT ALL ON TABLE auxfe TO zona;
GRANT ALL ON TABLE auxfe TO nobody;


--
-- Name: auxfe_fe_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE auxfe_fe_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxfe_fe_id_seq FROM zona;
GRANT ALL ON SEQUENCE auxfe_fe_id_seq TO zona;
GRANT UPDATE ON SEQUENCE auxfe_fe_id_seq TO nobody;


--
-- Name: auxoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxoper FROM PUBLIC;
REVOKE ALL ON TABLE auxoper FROM zona;
GRANT ALL ON TABLE auxoper TO zona;
GRANT ALL ON TABLE auxoper TO nobody;


--
-- Name: auxoperv; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxoperv FROM PUBLIC;
REVOKE ALL ON TABLE auxoperv FROM zona;
GRANT ALL ON TABLE auxoperv TO zona;
GRANT ALL ON TABLE auxoperv TO nobody;


--
-- Name: auxoperv_avh_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE auxoperv_avh_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxoperv_avh_id_seq FROM zona;
GRANT ALL ON SEQUENCE auxoperv_avh_id_seq TO zona;
GRANT UPDATE ON SEQUENCE auxoperv_avh_id_seq TO nobody;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM zona;
GRANT ALL ON TABLE bancos TO zona;
GRANT ALL ON TABLE bancos TO nobody;


--
-- Name: caratula; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE caratula FROM PUBLIC;
REVOKE ALL ON TABLE caratula FROM zona;
GRANT ALL ON TABLE caratula TO zona;
GRANT ALL ON TABLE caratula TO nobody;


--
-- Name: caratula_car_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE caratula_car_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE caratula_car_id_seq FROM zona;
GRANT ALL ON SEQUENCE caratula_car_id_seq TO zona;
GRANT UPDATE ON SEQUENCE caratula_car_id_seq TO nobody;


--
-- Name: carvis; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE carvis FROM PUBLIC;
REVOKE ALL ON TABLE carvis FROM zona;
GRANT ALL ON TABLE carvis TO zona;
GRANT ALL ON TABLE carvis TO nobody;


--
-- Name: carvis_cvt_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE carvis_cvt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE carvis_cvt_id_seq FROM zona;
GRANT ALL ON SEQUENCE carvis_cvt_id_seq TO zona;
GRANT UPDATE ON SEQUENCE carvis_cvt_id_seq TO nobody;


--
-- Name: catego; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
REVOKE ALL ON TABLE catego FROM zona;
GRANT ALL ON TABLE catego TO zona;
GRANT ALL ON TABLE catego TO nobody;


--
-- Name: catego_cat_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE catego_cat_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE catego_cat_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE catego_cat_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE catego_cat_codigo_seq TO nobody;


--
-- Name: catimo; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE catimo FROM PUBLIC;
REVOKE ALL ON TABLE catimo FROM zona;
GRANT ALL ON TABLE catimo TO zona;
GRANT ALL ON TABLE catimo TO nobody;


--
-- Name: centroc; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
REVOKE ALL ON TABLE centroc FROM zona;
GRANT ALL ON TABLE centroc TO zona;
GRANT ALL ON TABLE centroc TO nobody;


--
-- Name: centroc_cco_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM zona;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO zona;
GRANT UPDATE ON SEQUENCE centroc_cco_id_seq TO nobody;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM zona;
GRANT ALL ON TABLE cheques TO zona;
GRANT ALL ON TABLE cheques TO nobody;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM zona;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO zona;
GRANT UPDATE ON SEQUENCE cheques_chq_id_seq TO nobody;


--
-- Name: chqrech; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE chqrech FROM PUBLIC;
REVOKE ALL ON TABLE chqrech FROM zona;
GRANT ALL ON TABLE chqrech TO zona;
GRANT ALL ON TABLE chqrech TO nobody;


--
-- Name: chqrech_chqr_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM zona;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO zona;
GRANT UPDATE ON SEQUENCE chqrech_chqr_id_seq TO nobody;


--
-- Name: ciaseg; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ciaseg FROM PUBLIC;
REVOKE ALL ON TABLE ciaseg FROM zona;
GRANT ALL ON TABLE ciaseg TO zona;
GRANT ALL ON TABLE ciaseg TO nobody;


--
-- Name: ciaseg_cs_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE ciaseg_cs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ciaseg_cs_id_seq FROM zona;
GRANT ALL ON SEQUENCE ciaseg_cs_id_seq TO zona;
GRANT UPDATE ON SEQUENCE ciaseg_cs_id_seq TO nobody;


--
-- Name: clacont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE clacont FROM PUBLIC;
REVOKE ALL ON TABLE clacont FROM zona;
GRANT ALL ON TABLE clacont TO zona;
GRANT ALL ON TABLE clacont TO nobody;


--
-- Name: clacont_clac_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE clacont_clac_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE clacont_clac_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE clacont_clac_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE clacont_clac_codigo_seq TO nobody;


--
-- Name: clientes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE clientes FROM PUBLIC;
REVOKE ALL ON TABLE clientes FROM zona;
GRANT ALL ON TABLE clientes TO zona;
GRANT ALL ON TABLE clientes TO nobody;


--
-- Name: clientes_cli_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM zona;
GRANT ALL ON SEQUENCE clientes_cli_id_seq TO zona;
GRANT UPDATE ON SEQUENCE clientes_cli_id_seq TO nobody;


--
-- Name: compadu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE compadu FROM PUBLIC;
REVOKE ALL ON TABLE compadu FROM zona;
GRANT ALL ON TABLE compadu TO zona;
GRANT ALL ON TABLE compadu TO nobody;


--
-- Name: complfac; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE complfac FROM PUBLIC;
REVOKE ALL ON TABLE complfac FROM zona;
GRANT ALL ON TABLE complfac TO zona;
GRANT ALL ON TABLE complfac TO nobody;


--
-- Name: complfac_cfac_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE complfac_cfac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE complfac_cfac_id_seq FROM zona;
GRANT ALL ON SEQUENCE complfac_cfac_id_seq TO zona;
GRANT UPDATE ON SEQUENCE complfac_cfac_id_seq TO nobody;


--
-- Name: compra; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM zona;
GRANT ALL ON TABLE compra TO zona;
GRANT ALL ON TABLE compra TO nobody;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM zona;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO zona;
GRANT UPDATE ON SEQUENCE compra_cpra_id_seq TO nobody;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM zona;
GRANT ALL ON TABLE comprob TO zona;
GRANT ALL ON TABLE comprob TO nobody;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM zona;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO zona;
GRANT UPDATE ON SEQUENCE comprob_comp_id_seq TO nobody;


--
-- Name: confactur; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE confactur FROM PUBLIC;
REVOKE ALL ON TABLE confactur FROM zona;
GRANT ALL ON TABLE confactur TO zona;
GRANT ALL ON TABLE confactur TO nobody;


--
-- Name: confactur1; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE confactur1 FROM PUBLIC;
REVOKE ALL ON TABLE confactur1 FROM zona;
GRANT ALL ON TABLE confactur1 TO zona;
GRANT ALL ON TABLE confactur1 TO nobody;


--
-- Name: confactur1_cfc1_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE confactur1_cfc1_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE confactur1_cfc1_id_seq FROM zona;
GRANT ALL ON SEQUENCE confactur1_cfc1_id_seq TO zona;
GRANT UPDATE ON SEQUENCE confactur1_cfc1_id_seq TO nobody;


--
-- Name: confactur_cfc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE confactur_cfc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE confactur_cfc_id_seq FROM zona;
GRANT ALL ON SEQUENCE confactur_cfc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE confactur_cfc_id_seq TO nobody;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM zona;
GRANT ALL ON TABLE coniva TO zona;
GRANT ALL ON TABLE coniva TO nobody;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM zona;
GRANT ALL ON TABLE conpag TO zona;
GRANT ALL ON TABLE conpag TO nobody;


--
-- Name: conpag_cdp_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE conpag_cdp_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE conpag_cdp_codigo_seq TO nobody;


--
-- Name: consig; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE consig FROM PUBLIC;
REVOKE ALL ON TABLE consig FROM zona;
GRANT ALL ON TABLE consig TO zona;
GRANT ALL ON TABLE consig TO nobody;


--
-- Name: consig_csg_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE consig_csg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE consig_csg_id_seq FROM zona;
GRANT ALL ON SEQUENCE consig_csg_id_seq TO zona;
GRANT UPDATE ON SEQUENCE consig_csg_id_seq TO nobody;


--
-- Name: contene; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contene FROM PUBLIC;
REVOKE ALL ON TABLE contene FROM zona;
GRANT ALL ON TABLE contene TO zona;
GRANT ALL ON TABLE contene TO nobody;


--
-- Name: conteven; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE conteven FROM PUBLIC;
REVOKE ALL ON TABLE conteven FROM zona;
GRANT ALL ON TABLE conteven TO zona;
GRANT ALL ON TABLE conteven TO nobody;


--
-- Name: conteven_contev_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE conteven_contev_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conteven_contev_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE conteven_contev_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE conteven_contev_codigo_seq TO nobody;


--
-- Name: contratos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
REVOKE ALL ON TABLE contratos FROM zona;
GRANT ALL ON TABLE contratos TO zona;
GRANT ALL ON TABLE contratos TO nobody;


--
-- Name: contratos_contr_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE contratos_contr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contratos_contr_id_seq FROM zona;
GRANT ALL ON SEQUENCE contratos_contr_id_seq TO zona;
GRANT UPDATE ON SEQUENCE contratos_contr_id_seq TO nobody;


--
-- Name: cotiza; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
REVOKE ALL ON TABLE cotiza FROM zona;
GRANT ALL ON TABLE cotiza TO zona;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM zona;
GRANT ALL ON TABLE ctacble TO zona;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM zona;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO zona;
GRANT UPDATE ON SEQUENCE ctacble_cbl_id_seq TO nobody;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM zona;
GRANT ALL ON TABLE ctes TO zona;
GRANT ALL ON TABLE ctes TO nobody;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM zona;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO zona;
GRANT UPDATE ON SEQUENCE ctes_cte_id_seq TO nobody;


--
-- Name: despach; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE despach FROM PUBLIC;
REVOKE ALL ON TABLE despach FROM zona;
GRANT ALL ON TABLE despach TO zona;
GRANT ALL ON TABLE despach TO nobody;


--
-- Name: despach_desp_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE despach_desp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE despach_desp_id_seq FROM zona;
GRANT ALL ON SEQUENCE despach_desp_id_seq TO zona;
GRANT UPDATE ON SEQUENCE despach_desp_id_seq TO nobody;


--
-- Name: difcta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE difcta FROM PUBLIC;
REVOKE ALL ON TABLE difcta FROM zona;
GRANT ALL ON TABLE difcta TO zona;
GRANT ALL ON TABLE difcta TO nobody;


--
-- Name: difcta_dc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE difcta_dc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE difcta_dc_id_seq FROM zona;
GRANT ALL ON SEQUENCE difcta_dc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE difcta_dc_id_seq TO nobody;


--
-- Name: division; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE division FROM PUBLIC;
REVOKE ALL ON TABLE division FROM zona;
GRANT ALL ON TABLE division TO zona;
GRANT ALL ON TABLE division TO nobody;


--
-- Name: division_div_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE division_div_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE division_div_id_seq FROM zona;
GRANT ALL ON SEQUENCE division_div_id_seq TO zona;
GRANT UPDATE ON SEQUENCE division_div_id_seq TO nobody;


--
-- Name: docum; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM zona;
GRANT ALL ON TABLE docum TO zona;
GRANT ALL ON TABLE docum TO nobody;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM zona;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE docum_doc_id_seq TO nobody;


--
-- Name: embalajes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE embalajes FROM PUBLIC;
REVOKE ALL ON TABLE embalajes FROM zona;
GRANT ALL ON TABLE embalajes TO zona;
GRANT ALL ON TABLE embalajes TO nobody;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM zona;
GRANT ALL ON TABLE emiti TO zona;
GRANT ALL ON TABLE emiti TO nobody;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM zona;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO zona;
GRANT UPDATE ON SEQUENCE emiti_emi_id_seq TO nobody;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM zona;
GRANT ALL ON TABLE empresa TO zona;
GRANT ALL ON TABLE empresa TO nobody;


--
-- Name: entidad; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
REVOKE ALL ON TABLE entidad FROM zona;
GRANT ALL ON TABLE entidad TO zona;
GRANT ALL ON TABLE entidad TO nobody;


--
-- Name: entidad_ent_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM zona;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO zona;
GRANT UPDATE ON SEQUENCE entidad_ent_id_seq TO nobody;


--
-- Name: esclisp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE esclisp FROM PUBLIC;
REVOKE ALL ON TABLE esclisp FROM zona;
GRANT ALL ON TABLE esclisp TO zona;
GRANT ALL ON TABLE esclisp TO nobody;


--
-- Name: escvalcont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE escvalcont FROM PUBLIC;
REVOKE ALL ON TABLE escvalcont FROM zona;
GRANT ALL ON TABLE escvalcont TO zona;
GRANT ALL ON TABLE escvalcont TO nobody;


--
-- Name: estiba; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estiba FROM PUBLIC;
REVOKE ALL ON TABLE estiba FROM zona;
GRANT ALL ON TABLE estiba TO zona;
GRANT ALL ON TABLE estiba TO nobody;


--
-- Name: estiba_est_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE estiba_est_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE estiba_est_id_seq FROM zona;
GRANT ALL ON SEQUENCE estiba_est_id_seq TO zona;
GRANT UPDATE ON SEQUENCE estiba_est_id_seq TO nobody;


--
-- Name: estoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estoper FROM PUBLIC;
REVOKE ALL ON TABLE estoper FROM zona;
GRANT ALL ON TABLE estoper TO zona;
GRANT ALL ON TABLE estoper TO nobody;


--
-- Name: estunif; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estunif FROM PUBLIC;
REVOKE ALL ON TABLE estunif FROM zona;
GRANT ALL ON TABLE estunif TO zona;
GRANT ALL ON TABLE estunif TO nobody;


--
-- Name: estusu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estusu FROM PUBLIC;
REVOKE ALL ON TABLE estusu FROM zona;
GRANT ALL ON TABLE estusu TO zona;
GRANT ALL ON TABLE estusu TO nobody;


--
-- Name: eventos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE eventos FROM PUBLIC;
REVOKE ALL ON TABLE eventos FROM zona;
GRANT ALL ON TABLE eventos TO zona;
GRANT ALL ON TABLE eventos TO nobody;


--
-- Name: evindi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE evindi FROM PUBLIC;
REVOKE ALL ON TABLE evindi FROM zona;
GRANT ALL ON TABLE evindi TO zona;
GRANT ALL ON TABLE evindi TO nobody;


--
-- Name: facturacion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE facturacion FROM PUBLIC;
REVOKE ALL ON TABLE facturacion FROM zona;
GRANT ALL ON TABLE facturacion TO zona;
GRANT ALL ON TABLE facturacion TO nobody;


--
-- Name: facturacion_fac_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE facturacion_fac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE facturacion_fac_id_seq FROM zona;
GRANT ALL ON SEQUENCE facturacion_fac_id_seq TO zona;
GRANT UPDATE ON SEQUENCE facturacion_fac_id_seq TO nobody;


--
-- Name: feccontra; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE feccontra FROM PUBLIC;
REVOKE ALL ON TABLE feccontra FROM zona;
GRANT ALL ON TABLE feccontra TO zona;
GRANT ALL ON TABLE feccontra TO nobody;


--
-- Name: firman; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM zona;
GRANT ALL ON TABLE firman TO zona;
GRANT ALL ON TABLE firman TO nobody;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM zona;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO zona;
GRANT UPDATE ON SEQUENCE firman_fir_id_seq TO nobody;


--
-- Name: gente; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE gente FROM PUBLIC;
REVOKE ALL ON TABLE gente FROM zona;
GRANT ALL ON TABLE gente TO zona;
GRANT ALL ON TABLE gente TO nobody;


--
-- Name: gente_gte_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE gente_gte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gente_gte_id_seq FROM zona;
GRANT ALL ON SEQUENCE gente_gte_id_seq TO zona;
GRANT UPDATE ON SEQUENCE gente_gte_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM zona;
GRANT ALL ON TABLE grupos TO zona;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: grupos_gpo_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM zona;
GRANT ALL ON SEQUENCE grupos_gpo_id_seq TO zona;
GRANT UPDATE ON SEQUENCE grupos_gpo_id_seq TO nobody;


--
-- Name: histarifas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE histarifas FROM PUBLIC;
REVOKE ALL ON TABLE histarifas FROM zona;
GRANT ALL ON TABLE histarifas TO zona;
GRANT ALL ON TABLE histarifas TO nobody;


--
-- Name: histfac; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE histfac FROM PUBLIC;
REVOKE ALL ON TABLE histfac FROM zona;
GRANT ALL ON TABLE histfac TO zona;
GRANT ALL ON TABLE histfac TO nobody;


--
-- Name: histfac_hfac_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE histfac_hfac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE histfac_hfac_id_seq FROM zona;
GRANT ALL ON SEQUENCE histfac_hfac_id_seq TO zona;
GRANT UPDATE ON SEQUENCE histfac_hfac_id_seq TO nobody;


--
-- Name: impresiones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE impresiones FROM PUBLIC;
REVOKE ALL ON TABLE impresiones FROM zona;
GRANT ALL ON TABLE impresiones TO zona;
GRANT ALL ON TABLE impresiones TO nobody;


--
-- Name: indices; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE indices FROM PUBLIC;
REVOKE ALL ON TABLE indices FROM zona;
GRANT ALL ON TABLE indices TO zona;
GRANT ALL ON TABLE indices TO nobody;


--
-- Name: inflacion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE inflacion FROM PUBLIC;
REVOKE ALL ON TABLE inflacion FROM zona;
GRANT ALL ON TABLE inflacion TO zona;
GRANT ALL ON TABLE inflacion TO nobody;


--
-- Name: inflacion_inf_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE inflacion_inf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inflacion_inf_id_seq FROM zona;
GRANT ALL ON SEQUENCE inflacion_inf_id_seq TO zona;
GRANT UPDATE ON SEQUENCE inflacion_inf_id_seq TO nobody;


--
-- Name: ingxl; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ingxl FROM PUBLIC;
REVOKE ALL ON TABLE ingxl FROM zona;
GRANT ALL ON TABLE ingxl TO zona;
GRANT ALL ON TABLE ingxl TO nobody;


--
-- Name: ingzpa; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ingzpa FROM PUBLIC;
REVOKE ALL ON TABLE ingzpa FROM zona;
GRANT ALL ON TABLE ingzpa TO zona;
GRANT ALL ON TABLE ingzpa TO nobody;


--
-- Name: ingzpa_i_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE ingzpa_i_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ingzpa_i_id_seq FROM zona;
GRANT ALL ON SEQUENCE ingzpa_i_id_seq TO zona;
GRANT UPDATE ON SEQUENCE ingzpa_i_id_seq TO nobody;


--
-- Name: inhabilit; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE inhabilit FROM PUBLIC;
REVOKE ALL ON TABLE inhabilit FROM zona;
GRANT ALL ON TABLE inhabilit TO zona;
GRANT ALL ON TABLE inhabilit TO nobody;


--
-- Name: inout; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE "inout" FROM PUBLIC;
REVOKE ALL ON TABLE "inout" FROM zona;
GRANT ALL ON TABLE "inout" TO zona;
GRANT ALL ON TABLE "inout" TO nobody;


--
-- Name: inout_io_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE inout_io_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inout_io_id_seq FROM zona;
GRANT ALL ON SEQUENCE inout_io_id_seq TO zona;
GRANT UPDATE ON SEQUENCE inout_io_id_seq TO nobody;


--
-- Name: inoutliv; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE inoutliv FROM PUBLIC;
REVOKE ALL ON TABLE inoutliv FROM zona;
GRANT ALL ON TABLE inoutliv TO zona;
GRANT ALL ON TABLE inoutliv TO nobody;


--
-- Name: inoutliv_iol_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE inoutliv_iol_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inoutliv_iol_id_seq FROM zona;
GRANT ALL ON SEQUENCE inoutliv_iol_id_seq TO zona;
GRANT UPDATE ON SEQUENCE inoutliv_iol_id_seq TO nobody;


--
-- Name: interes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM zona;
GRANT ALL ON TABLE interes TO zona;
GRANT ALL ON TABLE interes TO nobody;


--
-- Name: item; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE item FROM PUBLIC;
REVOKE ALL ON TABLE item FROM zona;
GRANT ALL ON TABLE item TO zona;
GRANT ALL ON TABLE item TO nobody;


--
-- Name: item_item_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE item_item_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE item_item_id_seq FROM zona;
GRANT ALL ON SEQUENCE item_item_id_seq TO zona;
GRANT UPDATE ON SEQUENCE item_item_id_seq TO nobody;


--
-- Name: items; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE items FROM PUBLIC;
REVOKE ALL ON TABLE items FROM zona;
GRANT ALL ON TABLE items TO zona;
GRANT ALL ON TABLE items TO nobody;


--
-- Name: items_items_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE items_items_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE items_items_id_seq FROM zona;
GRANT ALL ON SEQUENCE items_items_id_seq TO zona;
GRANT UPDATE ON SEQUENCE items_items_id_seq TO nobody;


--
-- Name: lecting; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE lecting FROM PUBLIC;
REVOKE ALL ON TABLE lecting FROM zona;
GRANT ALL ON TABLE lecting TO zona;
GRANT ALL ON TABLE lecting TO nobody;


--
-- Name: lecting_fallas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE lecting_fallas FROM PUBLIC;
REVOKE ALL ON TABLE lecting_fallas FROM zona;
GRANT ALL ON TABLE lecting_fallas TO zona;
GRANT ALL ON TABLE lecting_fallas TO nobody;


--
-- Name: lecting_fallas_let_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE lecting_fallas_let_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE lecting_fallas_let_id_seq FROM zona;
GRANT ALL ON SEQUENCE lecting_fallas_let_id_seq TO zona;
GRANT UPDATE ON SEQUENCE lecting_fallas_let_id_seq TO nobody;


--
-- Name: lecting_let_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE lecting_let_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE lecting_let_id_seq FROM zona;
GRANT ALL ON SEQUENCE lecting_let_id_seq TO zona;
GRANT UPDATE ON SEQUENCE lecting_let_id_seq TO nobody;


--
-- Name: leyenrexp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE leyenrexp FROM PUBLIC;
REVOKE ALL ON TABLE leyenrexp FROM zona;
GRANT ALL ON TABLE leyenrexp TO zona;
GRANT ALL ON TABLE leyenrexp TO nobody;


--
-- Name: leyenrexp_leyr_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE leyenrexp_leyr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE leyenrexp_leyr_id_seq FROM zona;
GRANT ALL ON SEQUENCE leyenrexp_leyr_id_seq TO zona;
GRANT UPDATE ON SEQUENCE leyenrexp_leyr_id_seq TO nobody;


--
-- Name: listpre; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE listpre FROM PUBLIC;
REVOKE ALL ON TABLE listpre FROM zona;
GRANT ALL ON TABLE listpre TO zona;
GRANT ALL ON TABLE listpre TO nobody;


--
-- Name: listpre_ltp_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM zona;
GRANT ALL ON SEQUENCE listpre_ltp_id_seq TO zona;
GRANT UPDATE ON SEQUENCE listpre_ltp_id_seq TO nobody;


--
-- Name: livianos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE livianos FROM PUBLIC;
REVOKE ALL ON TABLE livianos FROM zona;
GRANT ALL ON TABLE livianos TO zona;
GRANT ALL ON TABLE livianos TO nobody;


--
-- Name: livianos_lv_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE livianos_lv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE livianos_lv_id_seq FROM zona;
GRANT ALL ON SEQUENCE livianos_lv_id_seq TO zona;
GRANT UPDATE ON SEQUENCE livianos_lv_id_seq TO nobody;


--
-- Name: lotes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE lotes FROM PUBLIC;
REVOKE ALL ON TABLE lotes FROM zona;
GRANT ALL ON TABLE lotes TO zona;
GRANT ALL ON TABLE lotes TO nobody;


--
-- Name: lotes_lot_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE lotes_lot_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE lotes_lot_id_seq FROM zona;
GRANT ALL ON SEQUENCE lotes_lot_id_seq TO zona;
GRANT UPDATE ON SEQUENCE lotes_lot_id_seq TO nobody;


--
-- Name: manzana; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE manzana FROM PUBLIC;
REVOKE ALL ON TABLE manzana FROM zona;
GRANT ALL ON TABLE manzana TO zona;
GRANT ALL ON TABLE manzana TO nobody;


--
-- Name: marauto; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE marauto FROM PUBLIC;
REVOKE ALL ON TABLE marauto FROM zona;
GRANT ALL ON TABLE marauto TO zona;
GRANT ALL ON TABLE marauto TO nobody;


--
-- Name: marcont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE marcont FROM PUBLIC;
REVOKE ALL ON TABLE marcont FROM zona;
GRANT ALL ON TABLE marcont TO zona;
GRANT ALL ON TABLE marcont TO nobody;


--
-- Name: marcont_marc_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE marcont_marc_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE marcont_marc_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE marcont_marc_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE marcont_marc_codigo_seq TO nobody;


--
-- Name: menues; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON TABLE menues FROM PUBLIC;
REVOKE ALL ON TABLE menues FROM zonab;
GRANT ALL ON TABLE menues TO zonab;
GRANT ALL ON TABLE menues TO nobody;


--
-- Name: menues_men_id_seq; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON SEQUENCE menues_men_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE menues_men_id_seq FROM zonab;
GRANT ALL ON SEQUENCE menues_men_id_seq TO zonab;
GRANT UPDATE ON SEQUENCE menues_men_id_seq TO nobody;


--
-- Name: mercaestad; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE mercaestad FROM PUBLIC;
REVOKE ALL ON TABLE mercaestad FROM zona;
GRANT ALL ON TABLE mercaestad TO zona;
GRANT ALL ON TABLE mercaestad TO nobody;


--
-- Name: modauto; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE modauto FROM PUBLIC;
REVOKE ALL ON TABLE modauto FROM zona;
GRANT ALL ON TABLE modauto TO zona;
GRANT ALL ON TABLE modauto TO nobody;


--
-- Name: modauto_mod_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE modauto_mod_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE modauto_mod_id_seq FROM zona;
GRANT ALL ON SEQUENCE modauto_mod_id_seq TO zona;
GRANT UPDATE ON SEQUENCE modauto_mod_id_seq TO nobody;


--
-- Name: modopub; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE modopub FROM PUBLIC;
REVOKE ALL ON TABLE modopub FROM zona;
GRANT ALL ON TABLE modopub TO zona;
GRANT ALL ON TABLE modopub TO nobody;


--
-- Name: modopub_mod_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE modopub_mod_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE modopub_mod_id_seq FROM zona;
GRANT ALL ON SEQUENCE modopub_mod_id_seq TO zona;
GRANT UPDATE ON SEQUENCE modopub_mod_id_seq TO nobody;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM zona;
GRANT ALL ON TABLE moneda TO zona;
GRANT ALL ON TABLE moneda TO nobody;


--
-- Name: monex; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM zona;
GRANT ALL ON TABLE monex TO zona;
GRANT ALL ON TABLE monex TO nobody;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM zona;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO zona;
GRANT UPDATE ON SEQUENCE monex_mne_id_seq TO nobody;


--
-- Name: movsleyen; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE movsleyen FROM PUBLIC;
REVOKE ALL ON TABLE movsleyen FROM zona;
GRANT ALL ON TABLE movsleyen TO zona;
GRANT ALL ON TABLE movsleyen TO nobody;


--
-- Name: movsleyen_mvl_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE movsleyen_mvl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsleyen_mvl_id_seq FROM zona;
GRANT ALL ON SEQUENCE movsleyen_mvl_id_seq TO zona;
GRANT UPDATE ON SEQUENCE movsleyen_mvl_id_seq TO nobody;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM zona;
GRANT ALL ON TABLE movsto TO zona;
GRANT ALL ON TABLE movsto TO nobody;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM zona;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO zona;
GRANT UPDATE ON SEQUENCE movsto_movs_id_seq TO nobody;


--
-- Name: movstoc; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE movstoc FROM PUBLIC;
REVOKE ALL ON TABLE movstoc FROM zona;
GRANT ALL ON TABLE movstoc TO zona;
GRANT ALL ON TABLE movstoc TO nobody;


--
-- Name: movstoc_movc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM zona;
GRANT ALL ON SEQUENCE movstoc_movc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE movstoc_movc_id_seq TO nobody;


--
-- Name: notdeb; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE notdeb FROM PUBLIC;
REVOKE ALL ON TABLE notdeb FROM zona;
GRANT ALL ON TABLE notdeb TO zona;
GRANT ALL ON TABLE notdeb TO nobody;


--
-- Name: notdeb_nd_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM zona;
GRANT ALL ON SEQUENCE notdeb_nd_id_seq TO zona;
GRANT UPDATE ON SEQUENCE notdeb_nd_id_seq TO nobody;


--
-- Name: noticias; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
REVOKE ALL ON TABLE noticias FROM zona;
GRANT ALL ON TABLE noticias TO zona;
GRANT ALL ON TABLE noticias TO nobody;


--
-- Name: noticias_not_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM zona;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO zona;
GRANT UPDATE ON SEQUENCE noticias_not_id_seq TO nobody;


--
-- Name: operaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE operaciones FROM PUBLIC;
REVOKE ALL ON TABLE operaciones FROM zona;
GRANT ALL ON TABLE operaciones TO zona;
GRANT ALL ON TABLE operaciones TO nobody;


--
-- Name: operaciones_op_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE operaciones_op_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operaciones_op_id_seq FROM zona;
GRANT ALL ON SEQUENCE operaciones_op_id_seq TO zona;
GRANT UPDATE ON SEQUENCE operaciones_op_id_seq TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM zona;
GRANT ALL ON TABLE operadores TO zona;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM zona;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO zona;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: operest; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE operest FROM PUBLIC;
REVOKE ALL ON TABLE operest FROM zona;
GRANT ALL ON TABLE operest TO zona;
GRANT ALL ON TABLE operest TO nobody;


--
-- Name: opervehi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE opervehi FROM PUBLIC;
REVOKE ALL ON TABLE opervehi FROM zona;
GRANT ALL ON TABLE opervehi TO zona;
GRANT ALL ON TABLE opervehi TO nobody;


--
-- Name: opervehi_opv_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE opervehi_opv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE opervehi_opv_id_seq FROM zona;
GRANT ALL ON SEQUENCE opervehi_opv_id_seq TO zona;
GRANT UPDATE ON SEQUENCE opervehi_opv_id_seq TO nobody;


--
-- Name: ordenpag; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ordenpag FROM PUBLIC;
REVOKE ALL ON TABLE ordenpag FROM zona;
GRANT ALL ON TABLE ordenpag TO zona;
GRANT ALL ON TABLE ordenpag TO nobody;


--
-- Name: outgxl; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE outgxl FROM PUBLIC;
REVOKE ALL ON TABLE outgxl FROM zona;
GRANT ALL ON TABLE outgxl TO zona;
GRANT ALL ON TABLE outgxl TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM zona;
GRANT ALL ON TABLE pais TO zona;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: posaran; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE posaran FROM PUBLIC;
REVOKE ALL ON TABLE posaran FROM zona;
GRANT ALL ON TABLE posaran TO zona;
GRANT ALL ON TABLE posaran TO nobody;


--
-- Name: posarest; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE posarest FROM PUBLIC;
REVOKE ALL ON TABLE posarest FROM zona;
GRANT ALL ON TABLE posarest TO zona;
GRANT ALL ON TABLE posarest TO nobody;


--
-- Name: problimp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE problimp FROM PUBLIC;
REVOKE ALL ON TABLE problimp FROM zona;
GRANT ALL ON TABLE problimp TO zona;
GRANT ALL ON TABLE problimp TO nobody;


--
-- Name: problimp_pim_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE problimp_pim_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE problimp_pim_id_seq FROM zona;
GRANT ALL ON SEQUENCE problimp_pim_id_seq TO zona;
GRANT UPDATE ON SEQUENCE problimp_pim_id_seq TO nobody;


--
-- Name: prove; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM zona;
GRANT ALL ON TABLE prove TO zona;
GRANT ALL ON TABLE prove TO nobody;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM zona;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO zona;
GRANT UPDATE ON SEQUENCE prove_prov_id_seq TO nobody;


--
-- Name: provin; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM zona;
GRANT ALL ON TABLE provin TO zona;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: provin_pro_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE provin_pro_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE provin_pro_codigo_seq TO nobody;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM zona;
GRANT ALL ON TABLE ptovta TO zona;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM zona;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO zona;
GRANT UPDATE ON SEQUENCE ptovta_ptv_id_seq TO nobody;


--
-- Name: puertos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE puertos FROM PUBLIC;
REVOKE ALL ON TABLE puertos FROM zona;
GRANT ALL ON TABLE puertos TO zona;
GRANT ALL ON TABLE puertos TO nobody;


--
-- Name: relmenu; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON TABLE relmenu FROM PUBLIC;
REVOKE ALL ON TABLE relmenu FROM zonab;
GRANT ALL ON TABLE relmenu TO zonab;
GRANT ALL ON TABLE relmenu TO nobody;


--
-- Name: relmenu_rmen_id_seq; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM zonab;
GRANT ALL ON SEQUENCE relmenu_rmen_id_seq TO zonab;
GRANT UPDATE ON SEQUENCE relmenu_rmen_id_seq TO nobody;


--
-- Name: retiros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE retiros FROM PUBLIC;
REVOKE ALL ON TABLE retiros FROM zona;
GRANT ALL ON TABLE retiros TO zona;
GRANT ALL ON TABLE retiros TO nobody;


--
-- Name: retiros_ret_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE retiros_ret_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE retiros_ret_id_seq FROM zona;
GRANT ALL ON SEQUENCE retiros_ret_id_seq TO zona;
GRANT UPDATE ON SEQUENCE retiros_ret_id_seq TO nobody;


--
-- Name: retirosd; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE retirosd FROM PUBLIC;
REVOKE ALL ON TABLE retirosd FROM zona;
GRANT ALL ON TABLE retirosd TO zona;
GRANT ALL ON TABLE retirosd TO nobody;


--
-- Name: retirosd_retd_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE retirosd_retd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE retirosd_retd_id_seq FROM zona;
GRANT ALL ON SEQUENCE retirosd_retd_id_seq TO zona;
GRANT UPDATE ON SEQUENCE retirosd_retd_id_seq TO nobody;


--
-- Name: retstock; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE retstock FROM PUBLIC;
REVOKE ALL ON TABLE retstock FROM zona;
GRANT ALL ON TABLE retstock TO zona;
GRANT ALL ON TABLE retstock TO nobody;


--
-- Name: retstock_rstk_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE retstock_rstk_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE retstock_rstk_id_seq FROM zona;
GRANT ALL ON SEQUENCE retstock_rstk_id_seq TO zona;
GRANT UPDATE ON SEQUENCE retstock_rstk_id_seq TO nobody;


--
-- Name: retstock_rstk_idretd_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE retstock_rstk_idretd_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE retstock_rstk_idretd_seq FROM zona;
GRANT ALL ON SEQUENCE retstock_rstk_idretd_seq TO zona;
GRANT UPDATE ON SEQUENCE retstock_rstk_idretd_seq TO nobody;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM zona;
GRANT ALL ON TABLE rubros TO zona;
GRANT ALL ON TABLE rubros TO nobody;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM zona;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO zona;
GRANT UPDATE ON SEQUENCE rubros_rub_id_seq TO nobody;


--
-- Name: seccion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
REVOKE ALL ON TABLE seccion FROM zona;
GRANT ALL ON TABLE seccion TO zona;
GRANT ALL ON TABLE seccion TO nobody;


--
-- Name: seguros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE seguros FROM PUBLIC;
REVOKE ALL ON TABLE seguros FROM zona;
GRANT ALL ON TABLE seguros TO zona;
GRANT ALL ON TABLE seguros TO nobody;


--
-- Name: seq_logs; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE seq_logs FROM PUBLIC;
REVOKE ALL ON SEQUENCE seq_logs FROM zona;
GRANT ALL ON SEQUENCE seq_logs TO zona;
GRANT UPDATE ON SEQUENCE seq_logs TO nobody;


--
-- Name: seq_tipl; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE seq_tipl FROM PUBLIC;
REVOKE ALL ON SEQUENCE seq_tipl FROM zona;
GRANT ALL ON SEQUENCE seq_tipl TO zona;
GRANT UPDATE ON SEQUENCE seq_tipl TO nobody;


--
-- Name: sitemxvehi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE sitemxvehi FROM PUBLIC;
REVOKE ALL ON TABLE sitemxvehi FROM zona;
GRANT ALL ON TABLE sitemxvehi TO zona;
GRANT ALL ON TABLE sitemxvehi TO nobody;


--
-- Name: sitemxvehi_sv_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE sitemxvehi_sv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE sitemxvehi_sv_id_seq FROM zona;
GRANT ALL ON SEQUENCE sitemxvehi_sv_id_seq TO zona;
GRANT UPDATE ON SEQUENCE sitemxvehi_sv_id_seq TO nobody;


--
-- Name: stock; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE stock FROM PUBLIC;
REVOKE ALL ON TABLE stock FROM zona;
GRANT ALL ON TABLE stock TO zona;
GRANT ALL ON TABLE stock TO nobody;


--
-- Name: subitem; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subitem FROM PUBLIC;
REVOKE ALL ON TABLE subitem FROM zona;
GRANT ALL ON TABLE subitem TO zona;
GRANT ALL ON TABLE subitem TO nobody;


--
-- Name: stock_stk_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE stock_stk_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE stock_stk_id_seq FROM zona;
GRANT ALL ON SEQUENCE stock_stk_id_seq TO zona;
GRANT UPDATE ON SEQUENCE stock_stk_id_seq TO nobody;


--
-- Name: subd; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM zona;
GRANT ALL ON TABLE subd TO zona;
GRANT ALL ON TABLE subd TO nobody;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM zona;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO zona;
GRANT UPDATE ON SEQUENCE subd_subd_id_seq TO nobody;


--
-- Name: subitem_sitem_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE subitem_sitem_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subitem_sitem_id_seq FROM zona;
GRANT ALL ON SEQUENCE subitem_sitem_id_seq TO zona;
GRANT UPDATE ON SEQUENCE subitem_sitem_id_seq TO nobody;


--
-- Name: subitemd; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subitemd FROM PUBLIC;
REVOKE ALL ON TABLE subitemd FROM zona;
GRANT ALL ON TABLE subitemd TO zona;
GRANT ALL ON TABLE subitemd TO nobody;


--
-- Name: subitemd_sitemd_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE subitemd_sitemd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subitemd_sitemd_id_seq FROM zona;
GRANT ALL ON SEQUENCE subitemd_sitemd_id_seq TO zona;
GRANT UPDATE ON SEQUENCE subitemd_sitemd_id_seq TO nobody;


--
-- Name: subrub; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
REVOKE ALL ON TABLE subrub FROM zona;
GRANT ALL ON TABLE subrub TO zona;
GRANT ALL ON TABLE subrub TO nobody;


--
-- Name: subrub_srb_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM zona;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO zona;
GRANT UPDATE ON SEQUENCE subrub_srb_id_seq TO nobody;


--
-- Name: subtcontrat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subtcontrat FROM PUBLIC;
REVOKE ALL ON TABLE subtcontrat FROM zona;
GRANT ALL ON TABLE subtcontrat TO zona;
GRANT ALL ON TABLE subtcontrat TO nobody;


--
-- Name: subtcontrat_subt_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE subtcontrat_subt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subtcontrat_subt_id_seq FROM zona;
GRANT ALL ON SEQUENCE subtcontrat_subt_id_seq TO zona;
GRANT UPDATE ON SEQUENCE subtcontrat_subt_id_seq TO nobody;


--
-- Name: subxcomp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subxcomp FROM PUBLIC;
REVOKE ALL ON TABLE subxcomp FROM zona;
GRANT ALL ON TABLE subxcomp TO zona;
GRANT ALL ON TABLE subxcomp TO nobody;


--
-- Name: sucursal; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE sucursal FROM PUBLIC;
REVOKE ALL ON TABLE sucursal FROM zona;
GRANT ALL ON TABLE sucursal TO zona;
GRANT ALL ON TABLE sucursal TO nobody;


--
-- Name: sucursales; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE sucursales FROM PUBLIC;
REVOKE ALL ON TABLE sucursales FROM zona;
GRANT ALL ON TABLE sucursales TO zona;
GRANT ALL ON TABLE sucursales TO nobody;


--
-- Name: talon; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM zona;
GRANT ALL ON TABLE talon TO zona;
GRANT ALL ON TABLE talon TO nobody;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM zona;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO zona;
GRANT UPDATE ON SEQUENCE talon_tal_id_seq TO nobody;


--
-- Name: talonop; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE talonop FROM PUBLIC;
REVOKE ALL ON TABLE talonop FROM zona;
GRANT ALL ON TABLE talonop TO zona;
GRANT ALL ON TABLE talonop TO nobody;


--
-- Name: tarifas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tarifas FROM PUBLIC;
REVOKE ALL ON TABLE tarifas FROM zona;
GRANT ALL ON TABLE tarifas TO zona;
GRANT ALL ON TABLE tarifas TO nobody;


--
-- Name: tarjeta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tarjeta FROM PUBLIC;
REVOKE ALL ON TABLE tarjeta FROM zona;
GRANT ALL ON TABLE tarjeta TO zona;
GRANT ALL ON TABLE tarjeta TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM zona;
GRANT ALL ON TABLE telefon TO zona;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM zona;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO zona;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: temporalweb; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE temporalweb FROM PUBLIC;
REVOKE ALL ON TABLE temporalweb FROM zona;
GRANT ALL ON TABLE temporalweb TO zona;
GRANT ALL ON TABLE temporalweb TO nobody;


--
-- Name: temporalweb_wtmp_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE temporalweb_wtmp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE temporalweb_wtmp_id_seq FROM zona;
GRANT ALL ON SEQUENCE temporalweb_wtmp_id_seq TO zona;
GRANT UPDATE ON SEQUENCE temporalweb_wtmp_id_seq TO nobody;


--
-- Name: tipcontrat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipcontrat FROM PUBLIC;
REVOKE ALL ON TABLE tipcontrat FROM zona;
GRANT ALL ON TABLE tipcontrat TO zona;
GRANT ALL ON TABLE tipcontrat TO nobody;


--
-- Name: tipcontrat_tipc_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipcontrat_tipc_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipcontrat_tipc_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tipcontrat_tipc_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tipcontrat_tipc_codigo_seq TO nobody;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM zona;
GRANT ALL ON TABLE tipcta TO zona;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- Name: tipcta_tct_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tipcta_tct_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tipcta_tct_codigo_seq TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM zona;
GRANT ALL ON TABLE tipdocu TO zona;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM zona;
GRANT ALL ON TABLE tipemp TO zona;
GRANT ALL ON TABLE tipemp TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM zona;
GRANT ALL ON TABLE tipentid TO zona;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipentid_tet_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tipentid_tet_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tipentid_tet_codigo_seq TO nobody;


--
-- Name: tipgente; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipgente FROM PUBLIC;
REVOKE ALL ON TABLE tipgente FROM zona;
GRANT ALL ON TABLE tipgente TO zona;
GRANT ALL ON TABLE tipgente TO nobody;


--
-- Name: tipgente_tgte_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipgente_tgte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipgente_tgte_id_seq FROM zona;
GRANT ALL ON SEQUENCE tipgente_tgte_id_seq TO zona;
GRANT UPDATE ON SEQUENCE tipgente_tgte_id_seq TO nobody;


--
-- Name: tiplog; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tiplog FROM PUBLIC;
REVOKE ALL ON TABLE tiplog FROM zona;
GRANT ALL ON TABLE tiplog TO zona;
GRANT ALL ON TABLE tiplog TO nobody;


--
-- Name: tipoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipoper FROM PUBLIC;
REVOKE ALL ON TABLE tipoper FROM zona;
GRANT ALL ON TABLE tipoper TO zona;
GRANT ALL ON TABLE tipoper TO nobody;


--
-- Name: tipoper_top_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipoper_top_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipoper_top_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tipoper_top_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tipoper_top_codigo_seq TO nobody;


--
-- Name: tipprod; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipprod FROM PUBLIC;
REVOKE ALL ON TABLE tipprod FROM zona;
GRANT ALL ON TABLE tipprod TO zona;
GRANT ALL ON TABLE tipprod TO nobody;


--
-- Name: tipprod_tip_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipprod_tip_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipprod_tip_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tipprod_tip_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tipprod_tip_codigo_seq TO nobody;


--
-- Name: tippxunif; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tippxunif FROM PUBLIC;
REVOKE ALL ON TABLE tippxunif FROM zona;
GRANT ALL ON TABLE tippxunif TO zona;
GRANT ALL ON TABLE tippxunif TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM zona;
GRANT ALL ON TABLE tiptel TO zona;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tiptel_ttl_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE tiptel_ttl_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE tiptel_ttl_codigo_seq TO nobody;


--
-- Name: tipusu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipusu FROM PUBLIC;
REVOKE ALL ON TABLE tipusu FROM zona;
GRANT ALL ON TABLE tipusu TO zona;
GRANT ALL ON TABLE tipusu TO nobody;


--
-- Name: unifun; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unifun FROM PUBLIC;
REVOKE ALL ON TABLE unifun FROM zona;
GRANT ALL ON TABLE unifun TO zona;
GRANT ALL ON TABLE unifun TO nobody;


--
-- Name: unilot; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unilot FROM PUBLIC;
REVOKE ALL ON TABLE unilot FROM zona;
GRANT ALL ON TABLE unilot TO zona;
GRANT ALL ON TABLE unilot TO nobody;


--
-- Name: unimed; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unimed FROM PUBLIC;
REVOKE ALL ON TABLE unimed FROM zona;
GRANT ALL ON TABLE unimed TO zona;
GRANT ALL ON TABLE unimed TO nobody;


--
-- Name: usermenu; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON TABLE usermenu FROM PUBLIC;
REVOKE ALL ON TABLE usermenu FROM zonab;
GRANT ALL ON TABLE usermenu TO zonab;
GRANT ALL ON TABLE usermenu TO nobody;


--
-- Name: usermenu_umen_id_seq; Type: ACL; Schema: public; Owner: zonab
--

REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM zonab;
GRANT ALL ON SEQUENCE usermenu_umen_id_seq TO zonab;
GRANT UPDATE ON SEQUENCE usermenu_umen_id_seq TO nobody;


--
-- Name: usuarios; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE usuarios FROM PUBLIC;
REVOKE ALL ON TABLE usuarios FROM zona;
GRANT ALL ON TABLE usuarios TO zona;
GRANT ALL ON TABLE usuarios TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM zona;
GRANT ALL ON TABLE varamb TO zona;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM zona;
GRANT ALL ON TABLE varambi TO zona;
GRANT ALL ON TABLE varambi TO nobody;


--
-- Name: vendedor; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE vendedor FROM PUBLIC;
REVOKE ALL ON TABLE vendedor FROM zona;
GRANT ALL ON TABLE vendedor TO zona;
GRANT ALL ON TABLE vendedor TO nobody;


--
-- Name: vendedor_ven_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM zona;
GRANT ALL ON SEQUENCE vendedor_ven_id_seq TO zona;
GRANT UPDATE ON SEQUENCE vendedor_ven_id_seq TO nobody;


--
-- Name: visita; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE visita FROM PUBLIC;
REVOKE ALL ON TABLE visita FROM zona;
GRANT ALL ON TABLE visita TO zona;
GRANT ALL ON TABLE visita TO nobody;


--
-- Name: visita_vt_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE visita_vt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE visita_vt_id_seq FROM zona;
GRANT ALL ON SEQUENCE visita_vt_id_seq TO zona;
GRANT UPDATE ON SEQUENCE visita_vt_id_seq TO nobody;


--
-- Name: volegr; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE volegr FROM PUBLIC;
REVOKE ALL ON TABLE volegr FROM zona;
GRANT ALL ON TABLE volegr TO zona;
GRANT ALL ON TABLE volegr TO nobody;


--
-- Name: voling; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE voling FROM PUBLIC;
REVOKE ALL ON TABLE voling FROM zona;
GRANT ALL ON TABLE voling TO zona;
GRANT ALL ON TABLE voling TO nobody;


--
-- Name: wleyenrexp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wleyenrexp FROM PUBLIC;
REVOKE ALL ON TABLE wleyenrexp FROM zona;
GRANT ALL ON TABLE wleyenrexp TO zona;
GRANT ALL ON TABLE wleyenrexp TO nobody;


--
-- Name: wleyenrexp_wleyr_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE wleyenrexp_wleyr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE wleyenrexp_wleyr_id_seq FROM zona;
GRANT ALL ON SEQUENCE wleyenrexp_wleyr_id_seq TO zona;
GRANT UPDATE ON SEQUENCE wleyenrexp_wleyr_id_seq TO nobody;


--
-- Name: wnoticias; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wnoticias FROM PUBLIC;
REVOKE ALL ON TABLE wnoticias FROM zona;
GRANT ALL ON TABLE wnoticias TO zona;
GRANT ALL ON TABLE wnoticias TO nobody;


--
-- Name: wnoticias_wnot_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE wnoticias_wnot_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE wnoticias_wnot_id_seq FROM zona;
GRANT ALL ON SEQUENCE wnoticias_wnot_id_seq TO zona;
GRANT UPDATE ON SEQUENCE wnoticias_wnot_id_seq TO nobody;


--
-- Name: woperaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE woperaciones FROM PUBLIC;
REVOKE ALL ON TABLE woperaciones FROM zona;
GRANT ALL ON TABLE woperaciones TO zona;
GRANT ALL ON TABLE woperaciones TO nobody;


--
-- Name: woperaciones_wop_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE woperaciones_wop_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE woperaciones_wop_id_seq FROM zona;
GRANT ALL ON SEQUENCE woperaciones_wop_id_seq TO zona;
GRANT UPDATE ON SEQUENCE woperaciones_wop_id_seq TO nobody;


--
-- Name: wret2; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wret2 FROM PUBLIC;
REVOKE ALL ON TABLE wret2 FROM zona;
GRANT ALL ON TABLE wret2 TO zona;
GRANT ALL ON TABLE wret2 TO nobody;


--
-- Name: wret2_wret2_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE wret2_wret2_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE wret2_wret2_id_seq FROM zona;
GRANT ALL ON SEQUENCE wret2_wret2_id_seq TO zona;
GRANT UPDATE ON SEQUENCE wret2_wret2_id_seq TO nobody;


--
-- Name: wretiros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wretiros FROM PUBLIC;
REVOKE ALL ON TABLE wretiros FROM zona;
GRANT ALL ON TABLE wretiros TO zona;
GRANT ALL ON TABLE wretiros TO nobody;


--
-- Name: wretiros_wret_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE wretiros_wret_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE wretiros_wret_id_seq FROM zona;
GRANT ALL ON SEQUENCE wretiros_wret_id_seq TO zona;
GRANT UPDATE ON SEQUENCE wretiros_wret_id_seq TO nobody;


--
-- Name: wsubitem; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wsubitem FROM PUBLIC;
REVOKE ALL ON TABLE wsubitem FROM zona;
GRANT ALL ON TABLE wsubitem TO zona;
GRANT ALL ON TABLE wsubitem TO nobody;


--
-- Name: zona; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM zona;
GRANT ALL ON TABLE zona TO zona;
GRANT ALL ON TABLE zona TO nobody;


--
-- Name: zona_zon_codigo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM zona;
GRANT ALL ON SEQUENCE zona_zon_codigo_seq TO zona;
GRANT UPDATE ON SEQUENCE zona_zon_codigo_seq TO nobody;


--
-- PostgreSQL database dump complete
--

