/*
 *  AUTHOR: Michael Nino (mnino@insight.com)
 *    DATE: Feb 21, 2000
 * PURPOSE: JavaScript Form Validation Library
 *    NOTE: Save this file as validate.js
 *
 */

/*
 * FUNCTION: Match( field, value, equals)
 *  PURPOSE: Returns true if field's value matches/equals the 
 *           value argument otherwise returns false. Setting the
 *           the equal argument to true indicates you wish the
 *           the value argument to equal the field's value. 
 *
 */
  function Match( field, value, equals ) {
  var pattern;
  var r;
  var checked = 0;
  var blank = new RegExp("^[ ]*$");


  if ( equals ) {
     pattern = new RegExp("^"+value+"$");
  } else {
     pattern = new RegExp(value);
  } // if else

  /* Text Fields/Areas/Hidden */
  /* 
	NOTE: DOES NOT SUPPORT MULTIPLE HIDDEN FIELDS 
	WITH THE SAME NAME NOR DOES IT SUPPORT FIELDS
	WITH DIFFERENT TYPES AND USING THE SAME NAME.
	THIS IS A FEATURE TO BE IMPLEMENTED IN THE
	NEXT RELEASE OF THIS LIBRARY!
  */
  
  if ( (field.type == "text") 
		|| 
       (field.type == "textarea") 
		|| 
       (field.type == "password") 
		|| 
       (field.type == "hidden") 
     ) 
  {
     return field.value.match(pattern);
  } // if

  /* Select Fields */
  if ( (field.type == "select-one") || ( field.type == "select" ) ) {
     if (field.selectedIndex == -1) {
        return false;
     } // if
     return field.options[field.selectedIndex].value.match(pattern);
  } // if

  /* Radio Button Groups */
  if ( field[0].type == "radio" ) {
     for (r=0; r<field.length; r++) {
        if ( field[r].checked ) {
           checked++;
        } // if 
        if ( (field[r].checked) && (field[r].value.match(pattern)) ) {
           return true;
        } // if
     } // for 
     return false;
  } // if


  } // fn

/*
 * FUNCTION: Equal( field, value )
 *  PURPOSE: Returns true if field's value is equals 
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified. 
 *
 */
  function Equal( field, value ) {
  return Match(field,value,true);
  } // fn

/*
 * FUNCTION: Number( field )
 *  PURPOSE: Returns true if field's value is a integer 
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function Number( field ) {
  return Match(field,'[0-9]+',true);
  } // fn

/*
 * FUNCTION: DateValue( field )
 *  PURPOSE: Returns true if field's value is a valid date string
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function DateValue( field ) {
  if (
	Match(field,'(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|30|31)-[1-9][0-9][0-9][0-9]',true) 
		||
	Match(field,'(0[1-9]|1[0-2])\\/(0[1-9]|[1-2][0-9]|30|31)\\/[1-9][0-9][0-9][0-9]',true) 
     )
  { return true; } else { return false; }
  } // fn

/*
 * FUNCTION: DateValue( field )
 *  PURPOSE: Returns true if field's value is a valid date string
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function TimeValue( field ) {
  return Match(field,'(0[0-9]|1[0-2]):[0-5][0-9](:[0-5][0-9]){0,1}',true);
  } // fn

  function XTimeValue( field ) {
    return Match(field,'(0[0-9]|1[0-9]|2[0-3])([0-5][0-9]){0,1}',true);
  } // fn


  function XDateValue( field ) {
  if(Match(field,'(0[1-9]|[1-2][0-9]|30|31)-0[1-9]|1[0-2])-[0-9][0-9]',true) 
		||
	Match(field,'(0[1-9]|[1-2][0-9]|30|31)\\/(0[1-9]|1[0-2])\\/[0-9][0-9]',true) 
     )
  { return true; } else { return false; }
  } // fn



  function XTimeValueFull( field ) { // Valida HHMMSS
    return Match(field,'(0[0-9]|1[0-9]|2[0-3])([0-5][0-9])([0-5][0-9])',true);
  } // fn




/*
 * FUNCTION: Currency( field )
 *  PURPOSE: Returns true if field's value is a currency value 
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function Currency( field ) {
  return Match(field,'[$]*([0-9]{1,3}[,])*[0-9]{0,3}\.[0-9]{2}',true);
  } // fn

/*
 * FUNCTION: SSN( field )
 *  PURPOSE: Returns true if field's value is a currency value
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function SSN( field ) {
  return Match(field,'[0-9]{3}-[0-9]{2}-[0-9]{4}',true);
  } // fn

/*
 * FUNCTION: Phone( field )
 *  PURPOSE: Returns true if field's value is a currency value
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function Phone( field ) {
  if (
	Match(field,'(1-|1 ){0,1}[0-9]{3}-[0-9]{3}-[0-9]{4}',true) 
	||
	Match(field,'(1-|1 ){0,1}\\([0-9]{3}\\) [0-9]{3}-[0-9]{4}',true) 
     )
  { return true; } else { return false; } 
  } // fn


/*
 * FUNCTION: Email( field )
 *  PURPOSE: Returns true if field's value is a currency value
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function Email( field ) {
  // Regular Expression is closer to RFC822
  return Match(field,'[^ \\(\\)\\<\\>\\[\\]@,;:"\'\\\\]+[@][^ \\(\\)\\<\\>\\[\\]@,;:"\'\\\\]+(\\.[^ \\(\\)\\<\\>\\[\\]@,;:"\'\\\\]+)+',true);
  } // fn


/*
 * FUNCTION: Blank( field )
 *  PURPOSE: Returns true if field's value is blank or 
 *           contains spaces otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the value argument specified.
 *
 */
  function Blank( field ) {
  var r;

  if ( typeof(field.type) == "indefinido" ) { // radio button group
     for (r=0; r<field.length; r++) {
        if (field[r].checked) {
           return false;
        } // if
     } // for
     return true;
  } else {
     return Match(field,"[ ]*",true);
  } // if else

  } // fn




/*
 * FUNCTION: CUIT( field )
 *  PURPOSE: Returns true if field's value is a currency value
 *           the value argument otherwise returns false.
 *           This function is a wrapper to a Match function
 *           call with the equal argument specified.
 *
 */
  function CUIT( field ) {
  return Match(field,'[0-9]{2}-[0-9]{8}-[0-9]{1}',true);
  } // fn





function LeapYear(intYear) {
    
if(intYear % 100 == 0) {
	if (intYear % 400 == 0) {
	    return true; 
	    }
        }
    
else {
	
if ((intYear % 4) == 0) {
	     return true; 
	 }
     
}
 
return false;
 
}



function ValidateFecha(frm,boton){
var intDay=frm.DesdeDay.value;
var intMonth=frm.DesdeMonth.value;
var intYear=frm.DesdeYear.value;
var mensa;
var MonthLiteral;
var strMonthArray = new Array(12);
strMonthArray[0] = "Enero";
strMonthArray[1] = "Febrero";
strMonthArray[2] = "Marzo";
strMonthArray[3] = "Abril";
strMonthArray[4] = "Mayo";
strMonthArray[5] = "Junio";
strMonthArray[6] = "Julio";
strMonthArray[7] = "Agosto";
strMonthArray[8] = "Septiembre";
strMonthArray[9] = "Octubre";
strMonthArray[10] = "Noviembre";
strMonthArray[11] = "Diciembre";

MonthLiteral=strMonthArray[intMonth - 1 ]; 

switch(boton){
	default:
	FechaParam= new Date(frm.DesdeYear.value,frm.DesdeMonth.value - 1,frm.DesdeDay.value)
	hoy= new Date()

	if( FechaParam <= hoy){
	    alert('La fecha del turno debera ser posterior a la fecha de hoy')	
	return(false);
	}


	if((intMonth == 1 || intMonth == 3 || intMonth == 5 || intMonth == 7 || intMonth == 8 || intMonth == 10 || intMonth == 12) && (intDay > 31 || intDay < 1))     {
	    alert('Error en la fecha.')	
	return false;
	
}


if ((intMonth == 4 || intMonth == 6 || intMonth == 9 || intMonth == 11) && (intDay > 30 || intDay < 1))     {
    mensa= 'El Mes  ' + MonthLiteral + ' no tiene mas de 30 dias.'; 
    alert(mensa)	    
    return false;
	
}



if (intMonth == 2) {
    
if (LeapYear(intYear) == true){
	
if (intDay > 29) {
	mensa= 'Febrero en  ' + intYear + 'no tiene mas de 28 dias ok?'; 
	alert(mensa)	    
	    
return false;
	    
}
        
}
    else 
	{
	
if (intDay > 28) {
	mensa= 'Febrero en  ' + intYear + '  tiene solo 28 dias.'; 
	alert(mensa)	    

	    return false;
	    
}
    
	}
    }
    
/*
document.write('fecha de pantalla = ',fecha1,' < Hoy= ',hoy)
*/
    break;
}

}

