--
-- PostgreSQL database dump
--

\connect - zona

SET search_path = public, pg_catalog;

--
-- TOC entry 355 (OID 19351631)
-- Name: plpgsql_call_handler (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION plpgsql_call_handler () RETURNS language_handler
    AS '/usr/lib/pgsql/plpgsql.so', 'plpgsql_call_handler'
    LANGUAGE c;


--
-- TOC entry 354 (OID 19351632)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler;


--
-- TOC entry 5 (OID 19351633)
-- Name: usuarios; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE usuarios (
    usu_codigo integer NOT NULL,
    usu_nrocuit character varying(13) NOT NULL,
    usu_tipusu smallint NOT NULL,
    usu_nombre character varying(40) NOT NULL,
    usu_fantasy character varying(40),
    usu_nomabre character varying(5),
    usu_coniva smallint,
    usu_conpago integer,
    usu_catego integer,
    usu_limcred numeric(15,2) DEFAULT 0,
    usu_tasaint numeric(15,5),
    usu_grupo integer DEFAULT 1,
    usu_saldo numeric(15,2) DEFAULT 0,
    usu_estado smallint DEFAULT 1
);


--
-- TOC entry 6 (OID 19351633)
-- Name: usuarios; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE usuarios FROM PUBLIC;
GRANT ALL ON TABLE usuarios TO nobody;


--
-- TOC entry 7 (OID 19351639)
-- Name: telefon; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE telefon (
    tel_tipentid integer NOT NULL,
    tel_cliente integer NOT NULL,
    tel_sucurs smallint NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_orden smallint NOT NULL,
    tel_dato character varying(30) NOT NULL
);


--
-- TOC entry 8 (OID 19351639)
-- Name: telefon; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
GRANT ALL ON TABLE telefon TO nobody;


--
-- TOC entry 9 (OID 19351641)
-- Name: tipusu; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipusu (
    tpu_codigo smallint NOT NULL,
    tpu_nombre character varying(30) NOT NULL
);


--
-- TOC entry 10 (OID 19351641)
-- Name: tipusu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipusu FROM PUBLIC;
GRANT ALL ON TABLE tipusu TO nobody;


--
-- TOC entry 11 (OID 19351643)
-- Name: coniva; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(30) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


--
-- TOC entry 12 (OID 19351643)
-- Name: coniva; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
GRANT ALL ON TABLE coniva TO nobody;


--
-- TOC entry 13 (OID 19351648)
-- Name: conpag; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE conpag (
    cdp_codigo serial NOT NULL,
    cdp_nombre character varying(40) NOT NULL,
    cdp_dias smallint
);


--
-- TOC entry 14 (OID 19351648)
-- Name: conpag; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
GRANT ALL ON TABLE conpag TO nobody;


--
-- TOC entry 15 (OID 19351653)
-- Name: catego; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE catego (
    cat_codigo serial NOT NULL,
    cat_nombre character varying(40) NOT NULL
);


--
-- TOC entry 16 (OID 19351653)
-- Name: catego; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
GRANT ALL ON TABLE catego TO nobody;


--
-- TOC entry 17 (OID 19351658)
-- Name: provin; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE provin (
    pro_codigo serial NOT NULL,
    pro_nombre character varying(40) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5)
);


--
-- TOC entry 18 (OID 19351658)
-- Name: provin; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
GRANT ALL ON TABLE provin TO nobody;


--
-- TOC entry 19 (OID 19351661)
-- Name: pais; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(40) NOT NULL
);


--
-- TOC entry 20 (OID 19351661)
-- Name: pais; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
GRANT ALL ON TABLE pais TO nobody;


--
-- TOC entry 21 (OID 19351665)
-- Name: tipentid; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipentid (
    tet_codigo serial NOT NULL,
    tet_nombre character varying(30) NOT NULL
);


--
-- TOC entry 22 (OID 19351665)
-- Name: tipentid; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- TOC entry 23 (OID 19351670)
-- Name: tiptel; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tiptel (
    ttl_codigo serial NOT NULL,
    ttl_nombre character varying(30) NOT NULL
);


--
-- TOC entry 24 (OID 19351670)
-- Name: tiptel; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- TOC entry 25 (OID 19351673)
-- Name: estusu; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE estusu (
    esc_codigo smallint NOT NULL,
    esc_nombre character varying(30) NOT NULL
);


--
-- TOC entry 26 (OID 19351673)
-- Name: estusu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estusu FROM PUBLIC;
GRANT ALL ON TABLE estusu TO nobody;


--
-- TOC entry 27 (OID 19351675)
-- Name: moneda; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(30) NOT NULL,
    mon_simbol character varying(5)
);


--
-- TOC entry 28 (OID 19351675)
-- Name: moneda; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
GRANT ALL ON TABLE moneda TO nobody;


--
-- TOC entry 29 (OID 19351677)
-- Name: cotiza; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


--
-- TOC entry 30 (OID 19351677)
-- Name: cotiza; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- TOC entry 31 (OID 19351680)
-- Name: ctacble; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE ctacble (
    cbl_codigo smallint NOT NULL,
    cbl_idptovta integer DEFAULT 1,
    cbl_nombre character varying(30) NOT NULL,
    cbl_niv1 smallint NOT NULL,
    cbl_niv2 smallint NOT NULL,
    cbl_niv3 smallint NOT NULL,
    cbl_niv4 smallint NOT NULL,
    cbl_niv5 smallint NOT NULL,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer NOT NULL,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint NOT NULL,
    cbl_present character varying(15)
);


--
-- TOC entry 32 (OID 19351680)
-- Name: ctacble; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- TOC entry 33 (OID 19351684)
-- Name: indices; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE indices (
    ind_codigo smallint NOT NULL,
    ind_nombre character varying(30) NOT NULL
);


--
-- TOC entry 34 (OID 19351684)
-- Name: indices; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE indices FROM PUBLIC;
GRANT ALL ON TABLE indices TO nobody;


--
-- TOC entry 35 (OID 19351686)
-- Name: evindi; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE evindi (
    evi_indice smallint NOT NULL,
    evi_fecha date NOT NULL,
    evi_valor numeric(15,5) DEFAULT 1
);


--
-- TOC entry 36 (OID 19351686)
-- Name: evindi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE evindi FROM PUBLIC;
GRANT ALL ON TABLE evindi TO nobody;


--
-- TOC entry 37 (OID 19351689)
-- Name: entidad; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE entidad (
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(30)
);


--
-- TOC entry 38 (OID 19351689)
-- Name: entidad; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
GRANT ALL ON TABLE entidad TO nobody;


--
-- TOC entry 39 (OID 19351698)
-- Name: tipcta; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipcta (
    tct_codigo serial NOT NULL,
    tct_nombre character varying(30) NOT NULL
);


--
-- TOC entry 40 (OID 19351698)
-- Name: tipcta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- TOC entry 41 (OID 19351703)
-- Name: articvta; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE articvta (
    art_id serial NOT NULL,
    art_codigo smallint,
    art_nombre character varying(40) NOT NULL,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_leyen character varying(90),
    art_stock numeric(15,5),
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_present numeric(15,5),
    art_peso numeric(15,5),
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_codsrb smallint,
    art_codcbl smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_idptovta integer,
    art_funcion character varying(100),
    art_precio_unique numeric(15,5)
);


--
-- TOC entry 42 (OID 19351703)
-- Name: articvta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
GRANT ALL ON TABLE articvta TO nobody;


--
-- TOC entry 43 (OID 19351710)
-- Name: rubros; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE rubros (
    rub_codigo serial NOT NULL,
    rub_nombre character varying(30) NOT NULL
);


--
-- TOC entry 44 (OID 19351710)
-- Name: rubros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
GRANT ALL ON TABLE rubros TO nobody;


--
-- TOC entry 45 (OID 19351713)
-- Name: subrub; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE subrub (
    srb_rubro integer NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(30) NOT NULL
);


--
-- TOC entry 46 (OID 19351713)
-- Name: subrub; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
GRANT ALL ON TABLE subrub TO nobody;


--
-- TOC entry 47 (OID 19351722)
-- Name: division; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE division (
    div_codemp integer NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(30)
);


--
-- TOC entry 48 (OID 19351722)
-- Name: division; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE division FROM PUBLIC;
GRANT ALL ON TABLE division TO nobody;


--
-- TOC entry 49 (OID 19351724)
-- Name: centroc; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE centroc (
    cco_codemp integer NOT NULL,
    cco_coddiv smallint NOT NULL,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(30)
);


--
-- TOC entry 50 (OID 19351724)
-- Name: centroc; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
GRANT ALL ON TABLE centroc TO nobody;


--
-- TOC entry 51 (OID 19351726)
-- Name: bancos; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(40) NOT NULL
);


--
-- TOC entry 52 (OID 19351726)
-- Name: bancos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
GRANT ALL ON TABLE bancos TO nobody;


--
-- TOC entry 53 (OID 19351728)
-- Name: sucursales; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE sucursales (
    suc_cliente integer NOT NULL,
    suc_codigo smallint DEFAULT 1 NOT NULL,
    suc_nombre character varying(40) NOT NULL,
    suc_direcc character varying(40),
    suc_locali character varying(40),
    suc_codpos character varying(15),
    suc_codprov integer,
    suc_pais smallint,
    suc_repres character varying(40),
    suc_contacto character varying(40),
    suc_observ text,
    suc_direccl character varying(40),
    suc_localil character varying(40),
    suc_codposl character varying(15),
    suc_codprovl integer,
    suc_paisl smallint
);


--
-- TOC entry 54 (OID 19351728)
-- Name: sucursales; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE sucursales FROM PUBLIC;
GRANT ALL ON TABLE sucursales TO nobody;


--
-- TOC entry 55 (OID 19351734)
-- Name: unimed; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_nombre character varying(40) NOT NULL,
    uni_coef numeric(15,5),
    uni_simbolo character(3)
);


--
-- TOC entry 56 (OID 19351734)
-- Name: unimed; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unimed FROM PUBLIC;
GRANT ALL ON TABLE unimed TO nobody;


--
-- TOC entry 57 (OID 19351738)
-- Name: actas; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE actas (
    acta_id serial NOT NULL,
    acta_subitem integer DEFAULT 1,
    acta_texto text,
    acta_canti numeric(15,5) DEFAULT 0,
    acta_tipo smallint,
    acta_estado smallint DEFAULT 1,
    acta_fecha date,
    acta_nroexped character varying(40)
);


--
-- TOC entry 58 (OID 19351738)
-- Name: actas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE actas FROM PUBLIC;
GRANT ALL ON TABLE actas TO nobody;


--
-- TOC entry 59 (OID 19351747)
-- Name: aduanas; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE aduanas (
    adu_codigo smallint NOT NULL,
    adu_nombre character varying(40) NOT NULL
);


--
-- TOC entry 60 (OID 19351747)
-- Name: aduanas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE aduanas FROM PUBLIC;
GRANT ALL ON TABLE aduanas TO nobody;


--
-- TOC entry 61 (OID 19351749)
-- Name: auxoper; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE auxoper (
    auxo_idoper integer NOT NULL,
    auxo_compremb character varying(16),
    auxo_facturas character varying(90),
    auxo_monflet smallint,
    auxo_impflet numeric(15,2),
    auxo_impfletdol numeric(15,2),
    auxo_monseg smallint,
    auxo_impseg numeric(15,2),
    auxo_impsegdol numeric(15,2),
    auxo_plazo_suspens smallint,
    auxo_base_imponibl numeric(15,2),
    auxo_medio_transpo smallint,
    auxo_mat_medtransp character varying(40),
    auxo_fecha_oficial date,
    auxo_fecha_arribtr date,
    auxo_puerto character varying(5),
    auxo_fojas smallint
);


--
-- TOC entry 62 (OID 19351749)
-- Name: auxoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxoper FROM PUBLIC;
GRANT ALL ON TABLE auxoper TO nobody;


--
-- TOC entry 63 (OID 19351753)
-- Name: clacont; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE clacont (
    clac_codigo serial NOT NULL,
    clac_nombre character(5) NOT NULL,
    clac_descrip character varying(40),
    clac_medida smallint,
    clac_altura numeric(15,5),
    clac_dimint_largo numeric(15,5),
    clac_dimint_ancho numeric(15,5),
    clac_dimint_alto numeric(15,5),
    clac_appuert_ancho numeric(15,5),
    clac_appuert_alto numeric(15,5),
    clac_capmax_peso numeric(15,5),
    clac_capmax_tara numeric(15,5),
    clac_capmax_neto numeric(15,5),
    clac_capmax_volume numeric(15,5)
);


--
-- TOC entry 64 (OID 19351753)
-- Name: clacont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE clacont FROM PUBLIC;
GRANT ALL ON TABLE clacont TO nobody;


--
-- TOC entry 65 (OID 19351758)
-- Name: conteven; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE conteven (
    contev_codigo serial NOT NULL,
    contev_descrip character varying(40) NOT NULL
);


--
-- TOC entry 66 (OID 19351758)
-- Name: conteven; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE conteven FROM PUBLIC;
GRANT ALL ON TABLE conteven TO nobody;


--
-- TOC entry 67 (OID 19351763)
-- Name: contratos; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE contratos (
    contr_id serial NOT NULL,
    contr_locador integer NOT NULL,
    contr_locatario integer NOT NULL,
    contr_idsubt integer,
    contr_unifun smallint,
    contr_garantia numeric(15,2) DEFAULT 0,
    contr_step smallint DEFAULT 1,
    contr_facturable smallint DEFAULT 1,
    contr_leyenda text,
    contr_estado smallint DEFAULT 1,
    contr_metros numeric(15,5) DEFAULT 0,
    contr_puxmtro numeric(15,2) DEFAULT 0
);


--
-- TOC entry 68 (OID 19351763)
-- Name: contratos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
GRANT ALL ON TABLE contratos TO nobody;


--
-- TOC entry 69 (OID 19351777)
-- Name: despach; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE despach (
    desp_id serial NOT NULL,
    desp_tipo smallint DEFAULT 1 NOT NULL,
    desp_nrcuit character(13) NOT NULL,
    desp_nroreg character(8) NOT NULL,
    desp_nombre character varying(40) NOT NULL
);


--
-- TOC entry 70 (OID 19351777)
-- Name: despach; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE despach FROM PUBLIC;
GRANT ALL ON TABLE despach TO nobody;


--
-- TOC entry 71 (OID 19351781)
-- Name: embalajes; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE embalajes (
    emb_codigo smallint NOT NULL,
    emb_nombre character varying(40) NOT NULL,
    emb_coef numeric(15,5)
);


--
-- TOC entry 72 (OID 19351781)
-- Name: embalajes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE embalajes FROM PUBLIC;
GRANT ALL ON TABLE embalajes TO nobody;


--
-- TOC entry 73 (OID 19351783)
-- Name: escvalcont; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE escvalcont (
    escval_idcontrat integer NOT NULL,
    escval_fdesde date NOT NULL,
    escval_fhasta date NOT NULL,
    escval_importe numeric(15,2)
);


--
-- TOC entry 74 (OID 19351783)
-- Name: escvalcont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE escvalcont FROM PUBLIC;
GRANT ALL ON TABLE escvalcont TO nobody;


--
-- TOC entry 75 (OID 19351785)
-- Name: feccontra; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE feccontra (
    fechac_idcontra integer NOT NULL,
    fechac_codevent integer NOT NULL,
    fechac_fecha date NOT NULL,
    fechac_aviso text
);


--
-- TOC entry 76 (OID 19351785)
-- Name: feccontra; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE feccontra FROM PUBLIC;
GRANT ALL ON TABLE feccontra TO nobody;


--
-- TOC entry 77 (OID 19351792)
-- Name: item; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE item (
    item_id serial NOT NULL,
    item_idoper integer NOT NULL,
    item_item smallint DEFAULT 1 NOT NULL,
    item_existe_sitem smallint DEFAULT 0 NOT NULL,
    item_moneda smallint,
    item_tipprod integer,
    item_unimed smallint,
    item_posa character varying(15) DEFAULT 'DESCONOCIDA',
    item_bloqueado smallint DEFAULT 1,
    item_paisorigen smallint,
    item_proced smallint,
    item_tipitem character(1),
    item_insimptemp numeric(15,2),
    item_insimpcons numeric(10,2)
);


--
-- TOC entry 78 (OID 19351792)
-- Name: item; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE item FROM PUBLIC;
GRANT ALL ON TABLE item TO nobody;


--
-- TOC entry 79 (OID 19351801)
-- Name: operadores; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE operadores (
    operad_id serial NOT NULL,
    operad_nombre character varying(40) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(40),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO' NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO' NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT 'today',
    operad_contacto character varying(90),
    operad_telefono character varying(90)
);


--
-- TOC entry 80 (OID 19351801)
-- Name: operadores; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
GRANT ALL ON TABLE operadores TO nobody;


--
-- TOC entry 81 (OID 19351811)
-- Name: grupos; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE grupos (
    gpo_id serial NOT NULL,
    gpo_nombre character varying(30) NOT NULL
);


--
-- TOC entry 82 (OID 19351811)
-- Name: grupos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
GRANT ALL ON TABLE grupos TO nobody;


--
-- TOC entry 83 (OID 19351816)
-- Name: lotes; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE lotes (
    lot_id serial NOT NULL,
    lot_codseccion smallint,
    lot_codmza smallint,
    lot_codigo smallint NOT NULL,
    lot_nombre character varying(40)
);


--
-- TOC entry 84 (OID 19351816)
-- Name: lotes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE lotes FROM PUBLIC;
GRANT ALL ON TABLE lotes TO nobody;


--
-- TOC entry 85 (OID 19351819)
-- Name: manzana; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE manzana (
    mza_codigo smallint NOT NULL,
    mza_codseccion smallint NOT NULL,
    mza_nombre character varying(40) NOT NULL
);


--
-- TOC entry 86 (OID 19351819)
-- Name: manzana; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE manzana FROM PUBLIC;
GRANT ALL ON TABLE manzana TO nobody;


--
-- TOC entry 87 (OID 19351823)
-- Name: marcont; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE marcont (
    marc_codigo serial NOT NULL,
    marc_descrip character(4) NOT NULL
);


--
-- TOC entry 88 (OID 19351823)
-- Name: marcont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE marcont FROM PUBLIC;
GRANT ALL ON TABLE marcont TO nobody;


--
-- TOC entry 89 (OID 19351826)
-- Name: mercaestad; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE mercaestad (
    mestad_codigo integer NOT NULL,
    mestad_descrip character varying(40) NOT NULL
);


--
-- TOC entry 90 (OID 19351826)
-- Name: mercaestad; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE mercaestad FROM PUBLIC;
GRANT ALL ON TABLE mercaestad TO nobody;


--
-- TOC entry 91 (OID 19351830)
-- Name: opervehi; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE opervehi (
    opv_id serial NOT NULL,
    opv_idoper integer,
    opv_pat_chasis character(8),
    opv_pat_tractor character(8),
    opv_est_camion smallint DEFAULT 0,
    opv_chofer character varying(40),
    opv_codtd character varying(5),
    opv_nro_doc integer,
    opv_fecha_ing timestamp without time zone,
    opv_fecha_egr timestamp without time zone,
    opv_pesa character(1),
    opv_peso_ing numeric(15,5),
    opv_peso_egr numeric(15,5),
    opv_nro_ticket integer,
    opv_obs text,
    opv_fecha_reg timestamp without time zone DEFAULT 'now()' NOT NULL
);


--
-- TOC entry 92 (OID 19351830)
-- Name: opervehi; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE opervehi FROM PUBLIC;
GRANT ALL ON TABLE opervehi TO nobody;


--
-- TOC entry 93 (OID 19351840)
-- Name: operaciones; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE operaciones (
    op_id serial NOT NULL,
    op_tipoper integer NOT NULL,
    op_directo integer NOT NULL,
    op_indirecto integer NOT NULL,
    op_consig integer,
    op_compbte character(16) DEFAULT 'DATO DESCONOCIDO' NOT NULL,
    op_comptrans character(16) DEFAULT 'DATO DESCONOCIDO',
    op_fechain date DEFAULT 'today()',
    op_nrotalzon integer NOT NULL,
    op_nrotaldir integer NOT NULL,
    op_estado smallint DEFAULT 11 NOT NULL,
    op_deposito smallint,
    op_conocim character(18),
    op_pmedtrans smallint,
    op_canal smallint DEFAULT 1,
    op_iddespach integer,
    op_verificador integer,
    op_volumen numeric(15,5) DEFAULT 0,
    op_peso numeric(15,5) DEFAULT 0,
    op_bultos integer DEFAULT 0,
    op_moneda smallint,
    op_importe numeric(15,2) DEFAULT 0,
    op_impdolar numeric(15,2) DEFAULT 0,
    op_tipo_cambio numeric(15,6) DEFAULT 0,
    op_destino smallint,
    op_proced smallint,
    op_embalaje smallint,
    op_fecha_close date,
    op_fecreg timestamp without time zone DEFAULT 'now()' NOT NULL,
    op_idopw integer DEFAULT 0,
    op_operador integer DEFAULT 0
);


--
-- TOC entry 94 (OID 19351840)
-- Name: operaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE operaciones FROM PUBLIC;
GRANT ALL ON TABLE operaciones TO nobody;


--
-- TOC entry 95 (OID 19351855)
-- Name: puertos; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE puertos (
    pue_codigo character varying(5) NOT NULL,
    pue_nombre character varying(40) NOT NULL,
    pue_pais smallint
);


--
-- TOC entry 96 (OID 19351855)
-- Name: puertos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE puertos FROM PUBLIC;
GRANT ALL ON TABLE puertos TO nobody;


--
-- TOC entry 97 (OID 19351857)
-- Name: seccion; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(40) NOT NULL
);


--
-- TOC entry 98 (OID 19351857)
-- Name: seccion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
GRANT ALL ON TABLE seccion TO nobody;


--
-- TOC entry 99 (OID 19351861)
-- Name: subitem; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE subitem (
    sitem_id serial NOT NULL,
    sitem_iditem integer NOT NULL,
    sitem_idoper integer,
    sitem_codigo smallint DEFAULT 0 NOT NULL,
    sitem_artic integer,
    sitem_canting numeric(15,5) DEFAULT 0 NOT NULL,
    sitem_cantret numeric(15,5) DEFAULT 0,
    sitem_cantcomp numeric(15,5) DEFAULT 0,
    sitem_cantmala numeric(15,5) DEFAULT 0,
    sitem_importe numeric(15,2) DEFAULT 0 NOT NULL,
    sitem_imp_dolar numeric(15,2) DEFAULT 0,
    sitem_volumen numeric(15,5) DEFAULT 0,
    sitem_peso numeric(15,5) DEFAULT 0,
    sitem_tipemb smallint,
    sitem_deposito smallint,
    sitem_idacta integer,
    sitem_estado integer DEFAULT 1,
    sitem_directo integer NOT NULL,
    sitem_indirecto integer NOT NULL,
    sitem_compbte character varying(16)
);


--
-- TOC entry 100 (OID 19351861)
-- Name: subitem; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subitem FROM PUBLIC;
GRANT ALL ON TABLE subitem TO nobody;


--
-- TOC entry 101 (OID 19351876)
-- Name: subtcontrat; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE subtcontrat (
    subt_id serial NOT NULL,
    subt_idtipc integer NOT NULL,
    subt_codigo smallint,
    subt_descrip character(30) NOT NULL,
    art_id integer
);


--
-- TOC entry 102 (OID 19351876)
-- Name: subtcontrat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE subtcontrat FROM PUBLIC;
GRANT ALL ON TABLE subtcontrat TO nobody;


--
-- TOC entry 103 (OID 19351881)
-- Name: tipoper; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipoper (
    top_codigo serial NOT NULL,
    top_nombre character varying(40) NOT NULL,
    top_comprob character(3)
);


--
-- TOC entry 104 (OID 19351881)
-- Name: tipoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipoper FROM PUBLIC;
GRANT ALL ON TABLE tipoper TO nobody;


--
-- TOC entry 105 (OID 19351886)
-- Name: tipprod; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipprod (
    tip_codigo serial NOT NULL,
    tip_descrip character varying(40) NOT NULL,
    tip_imo smallint
);


--
-- TOC entry 106 (OID 19351886)
-- Name: tipprod; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipprod FROM PUBLIC;
GRANT ALL ON TABLE tipprod TO nobody;


--
-- TOC entry 107 (OID 19351891)
-- Name: tipcontrat; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipcontrat (
    tipc_codigo serial NOT NULL,
    tipc_descrip character varying(40) NOT NULL,
    tipc_concon smallint DEFAULT 1 NOT NULL,
    tipc_afunif smallint DEFAULT 1 NOT NULL,
    tipc_t1 character varying(40),
    tipc_t2 character varying(40)
);


--
-- TOC entry 108 (OID 19351891)
-- Name: tipcontrat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipcontrat FROM PUBLIC;
GRANT ALL ON TABLE tipcontrat TO nobody;


--
-- TOC entry 109 (OID 19351896)
-- Name: unifun; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE unifun (
    unif_codigo smallint NOT NULL,
    unif_nombre character varying(40) NOT NULL,
    unif_tipo smallint,
    unif_usuario integer,
    unif_superf numeric(15,5),
    unif_codmaria smallint,
    unif_seguro numeric(15,2) DEFAULT 0,
    unif_valormerca numeric(15,2) DEFAULT 0,
    unif_vensta date,
    unif_estado smallint DEFAULT 1 NOT NULL
);


--
-- TOC entry 110 (OID 19351896)
-- Name: unifun; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unifun FROM PUBLIC;
GRANT ALL ON TABLE unifun TO nobody;


--
-- TOC entry 111 (OID 19351901)
-- Name: unilot; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE unilot (
    unil_codunifun smallint NOT NULL,
    unit_idlote integer NOT NULL
);


--
-- TOC entry 112 (OID 19351901)
-- Name: unilot; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE unilot FROM PUBLIC;
GRANT ALL ON TABLE unilot TO nobody;


--
-- TOC entry 113 (OID 19351905)
-- Name: consig; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE consig (
    csg_id serial NOT NULL,
    csg_nrocuit character varying(13) DEFAULT '0' NOT NULL,
    csg_nombre character varying(40)
);


--
-- TOC entry 114 (OID 19351905)
-- Name: consig; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE consig FROM PUBLIC;
GRANT ALL ON TABLE consig TO nobody;


--
-- TOC entry 115 (OID 19351909)
-- Name: estoper; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE estoper (
    eto_codigo smallint NOT NULL,
    eto_nombre character varying(40) NOT NULL
);


--
-- TOC entry 116 (OID 19351909)
-- Name: estoper; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estoper FROM PUBLIC;
GRANT ALL ON TABLE estoper TO nobody;


--
-- TOC entry 117 (OID 19351911)
-- Name: catimo; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE catimo (
    imo_codigo integer NOT NULL,
    imo_nombre character varying(40) NOT NULL
);


--
-- TOC entry 118 (OID 19351911)
-- Name: catimo; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE catimo FROM PUBLIC;
GRANT ALL ON TABLE catimo TO nobody;


--
-- TOC entry 119 (OID 19351913)
-- Name: posaran; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE posaran (
    posa_codigo character varying(15) NOT NULL,
    posa_nombre character varying(40) NOT NULL
);


--
-- TOC entry 120 (OID 19351913)
-- Name: posaran; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE posaran FROM PUBLIC;
GRANT ALL ON TABLE posaran TO nobody;


--
-- TOC entry 121 (OID 19351915)
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(40) NOT NULL
);


--
-- TOC entry 122 (OID 19351915)
-- Name: tipdocu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- TOC entry 123 (OID 19351919)
-- Name: emiti; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE emiti (
    emit_id serial NOT NULL,
    emit_comprob smallint,
    emit_numero smallint,
    emit_cliente integer,
    emit_sucursal smallint,
    emit_fecha date,
    emit_fecreg timestamp without time zone,
    emit_total numeric(15,2),
    emit_estado smallint DEFAULT 1,
    emit_idptovta integer
);


--
-- TOC entry 124 (OID 19351919)
-- Name: emiti; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
GRANT ALL ON TABLE emiti TO nobody;


--
-- TOC entry 125 (OID 19351925)
-- Name: retiros; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE retiros (
    ret_id serial NOT NULL,
    ret_idopera integer NOT NULL,
    ret_idsitem integer NOT NULL,
    ret_item smallint DEFAULT 1 NOT NULL,
    ret_sitem smallint DEFAULT 0 NOT NULL,
    ret_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    ret_idsitemc integer
);


--
-- TOC entry 126 (OID 19351925)
-- Name: retiros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE retiros FROM PUBLIC;
GRANT ALL ON TABLE retiros TO nobody;


--
-- TOC entry 127 (OID 19351933)
-- Name: articu; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE articu (
    artic_id serial NOT NULL,
    artic_indirecto integer NOT NULL,
    artic_codigo character varying(40) NOT NULL,
    artic_marca character varying(40),
    artic_modelo character varying(40),
    artic_descrip character varying(40),
    artic_present character varying(40),
    artic_tiprod integer,
    artic_posa character varying(15),
    artic_unimed smallint
);


--
-- TOC entry 128 (OID 19351933)
-- Name: articu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE articu FROM PUBLIC;
GRANT ALL ON TABLE articu TO nobody;


--
-- TOC entry 129 (OID 19351936)
-- Name: talonop; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE talonop (
    talop_usuario integer NOT NULL,
    talop_tipoper integer NOT NULL,
    talop_numero integer DEFAULT 1 NOT NULL
);


--
-- TOC entry 130 (OID 19351936)
-- Name: talonop; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE talonop FROM PUBLIC;
GRANT ALL ON TABLE talonop TO nobody;


--
-- TOC entry 131 (OID 19351941)
-- Name: ptovta; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE ptovta (
    ptov_id serial NOT NULL,
    ptov_empresa smallint NOT NULL,
    ptov_codigo smallint DEFAULT 1 NOT NULL,
    ptov_nombre character varying(40)
);


--
-- TOC entry 132 (OID 19351941)
-- Name: ptovta; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- TOC entry 133 (OID 19351945)
-- Name: empresa; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE empresa (
    emp_codigo smallint NOT NULL,
    emp_nombre character varying(40)
);


--
-- TOC entry 134 (OID 19351945)
-- Name: empresa; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
GRANT ALL ON TABLE empresa TO nobody;


--
-- TOC entry 135 (OID 19351949)
-- Name: comprob; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE comprob (
    comp_id serial NOT NULL,
    comp_idptovta integer,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(40) NOT NULL,
    comp_sistema smallint DEFAULT 4
);


--
-- TOC entry 136 (OID 19351949)
-- Name: comprob; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
GRANT ALL ON TABLE comprob TO nobody;


--
-- TOC entry 137 (OID 19351953)
-- Name: seguros; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE seguros (
    seg_unifun smallint NOT NULL,
    seg_poliza character varying(40) NOT NULL,
    seg_fechad timestamp without time zone NOT NULL,
    seg_hasta timestamp without time zone NOT NULL,
    seg_importei numeric(15,2) DEFAULT 0,
    seg_importerc numeric(15,2) DEFAULT 0,
    seg_estado smallint DEFAULT 1,
    seg_cia character varying(40),
    seg_moneda smallint DEFAULT 1 NOT NULL,
    seg_impmoncte numeric(15,2) DEFAULT 0
);


--
-- TOC entry 138 (OID 19351953)
-- Name: seguros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE seguros FROM PUBLIC;
GRANT ALL ON TABLE seguros TO nobody;


--
-- TOC entry 139 (OID 19351960)
-- Name: varamb; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE varamb (
    var_codigo character varying(40) NOT NULL,
    var_nombre character varying(40) NOT NULL,
    var_valor character varying(40)
);


--
-- TOC entry 140 (OID 19351960)
-- Name: varamb; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
GRANT ALL ON TABLE varamb TO nobody;


--
-- TOC entry 141 (OID 19351964)
-- Name: modopub; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE modopub (
    mod_id serial NOT NULL,
    mod_idoperador integer,
    mod_idoper integer,
    mod_modalidad smallint DEFAULT 2 NOT NULL,
    mod_idret integer,
    mod_idsitem integer,
    mod_fecha timestamp without time zone DEFAULT 'now()' NOT NULL,
    mod_cantanter numeric(15,5),
    mod_cantnueva numeric(15,5),
    mod_autoriz1 integer,
    mod_fecaut1 timestamp without time zone,
    mod_autoriz2 integer,
    mod_fecaut2 timestamp without time zone,
    mod_autoriz3 integer,
    mod_fecaut3 timestamp without time zone,
    mod_estado smallint DEFAULT 1 NOT NULL
);


--
-- TOC entry 142 (OID 19351964)
-- Name: modopub; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE modopub FROM PUBLIC;
GRANT ALL ON TABLE modopub TO nobody;


--
-- TOC entry 143 (OID 19351970)
-- Name: tippxunif; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tippxunif (
    txu_codtipp integer NOT NULL,
    txu_codunif smallint NOT NULL
);


--
-- TOC entry 144 (OID 19351970)
-- Name: tippxunif; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tippxunif FROM PUBLIC;
GRANT ALL ON TABLE tippxunif TO nobody;


--
-- TOC entry 145 (OID 19351972)
-- Name: compadu; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE compadu (
    cad_codigo character(4) NOT NULL,
    cad_nombre character varying(40) NOT NULL,
    cad_destino character(1),
    cad_tipoper integer
);


--
-- TOC entry 146 (OID 19351972)
-- Name: compadu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE compadu FROM PUBLIC;
GRANT ALL ON TABLE compadu TO nobody;


--
-- TOC entry 147 (OID 19351974)
-- Name: esclisp; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE esclisp (
    elp_idart integer NOT NULL,
    elp_orden smallint DEFAULT 1 NOT NULL,
    elp_nombre character varying(40) DEFAULT '1',
    elp_precio numeric(15,2) NOT NULL
);


--
-- TOC entry 148 (OID 19351974)
-- Name: esclisp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE esclisp FROM PUBLIC;
GRANT ALL ON TABLE esclisp TO nobody;


--
-- TOC entry 149 (OID 19351980)
-- Name: noticias; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE noticias (
    not_id serial NOT NULL,
    not_tipo smallint DEFAULT 1 NOT NULL,
    not_numero integer NOT NULL,
    not_texto text,
    not_fecha timestamp without time zone DEFAULT 'now()'
);


--
-- TOC entry 150 (OID 19351980)
-- Name: noticias; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
GRANT ALL ON TABLE noticias TO nobody;


--
-- TOC entry 151 (OID 19351990)
-- Name: talon; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE talon (
    tal_id serial NOT NULL,
    tal_idptovta integer,
    tal_comprob integer,
    tal_nombre character varying(40) NOT NULL,
    tal_valor integer,
    tal_fecha date
);


--
-- TOC entry 152 (OID 19351990)
-- Name: talon; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
GRANT ALL ON TABLE talon TO nobody;


--
-- TOC entry 153 (OID 19351993)
-- Name: estunif; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE estunif (
    etu_codigo smallint NOT NULL,
    etu_nombre character varying(30)
);


--
-- TOC entry 154 (OID 19351993)
-- Name: estunif; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE estunif FROM PUBLIC;
GRANT ALL ON TABLE estunif TO nobody;


--
-- TOC entry 155 (OID 19352007)
-- Name: contene; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE contene (
    cont_idopv integer NOT NULL,
    cont_marcont integer NOT NULL,
    cont_nrocont integer NOT NULL,
    cont_clacont integer NOT NULL,
    cont_idoper integer,
    cont_estado smallint DEFAULT 1,
    cont_preori character varying(20),
    cont_preana character varying(20),
    cont_presatel character varying(20)
);


--
-- TOC entry 156 (OID 19352007)
-- Name: contene; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contene FROM PUBLIC;
GRANT ALL ON TABLE contene TO nobody;


--
-- TOC entry 2 (OID 19352010)
-- Name: seq_logs; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_logs
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 157 (OID 19352012)
-- Name: tiplog; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tiplog (
    tipl_codigo smallint DEFAULT nextval('seq_tipl'::text) NOT NULL,
    tipl_tipo smallint,
    tipl_modistock smallint DEFAULT 2,
    tipl_modiubic smallint DEFAULT 2,
    tipl_estado smallint,
    tipl_nombre character varying(50),
    tipl_sumaresta smallint DEFAULT 1,
    tipl_prefact smallint DEFAULT 2
);


--
-- TOC entry 158 (OID 19352012)
-- Name: tiplog; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tiplog FROM PUBLIC;
GRANT ALL ON TABLE tiplog TO nobody;


--
-- TOC entry 3 (OID 19352019)
-- Name: seq_tipl; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_tipl
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 159 (OID 19352023)
-- Name: intotal; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE intotal (
    int_id serial NOT NULL,
    int_fecha text,
    int_directo text,
    int_indirecto text,
    int_tipoper text,
    int_numero text,
    int_lote text,
    int_compbte text,
    int_articod text,
    int_artidesc text,
    int_chasis text,
    int_canting text,
    int_cantret text,
    int_cantstock text,
    int_unimed text,
    int_valori text,
    int_moneda text,
    int_valcte text,
    int_deposito text,
    int_reloper text,
    int_consig text,
    int_estado text,
    int_conocim text,
    int_bultos text,
    int_embalaje text,
    int_peso text,
    int_tiprod text,
    int_cantcomp text,
    int_fobt text,
    int_tipcbo text,
    int_lotenum smallint,
    int_idoper integer DEFAULT -1,
    int_iditem integer DEFAULT -1,
    int_idsitem integer DEFAULT -1,
    int_idret integer DEFAULT -1,
    int_esta integer DEFAULT -1
);


--
-- TOC entry 160 (OID 19352023)
-- Name: intotal; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE intotal FROM PUBLIC;
GRANT ALL ON TABLE intotal TO nobody;


--
-- TOC entry 518 (OID 19352034)
-- Name: cantitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantitem (integer) RETURNS integer
    AS '
declare
opid		 alias for $1;
ret 		 int4;
begin
select count(*) into ret from item where item_idoper= opid;
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 502 (OID 19352035)
-- Name: chkmigra (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION chkmigra (character varying) RETURNS boolean
    AS '
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
auxoid 		 int4;
primera		 int4;
begin
primera:=-1;
for registro in select 
    oid as oid 
     from usuarios
	loop
	if(primera<0) then 
		primera:=registro.oid;
	    else
		primera:= primera+1;
	end if;

	if(registro.oid!=primera) then 
		ret:=''t'';
		primera:=registro.oid;
	    else
		ret:=''f'';
	end if;
end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 486 (OID 19352036)
-- Name: ulticont (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ulticont (integer) RETURNS integer
    AS '
declare
opid		 alias for $1;
ret 		 int4;
begin
select max(contr_id) into ret from contratos;
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 487 (OID 19352037)
-- Name: grabocontrapart (integer, integer, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabocontrapart (integer, integer, numeric, numeric) RETURNS integer
    AS '
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:=''DESCONOCIDA''; end if;
if(registro_artic.marca is null) then registro_artic.marca:=''DESCONOCIDA''; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:=''DESCONOCIDA''; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:=''DESCONOCIDA''; end if;
if(registro_artic.present is null) then registro_artic.present:=''DESCONOCIDA''; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 488 (OID 19352038)
-- Name: get_idopera (integer, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION get_idopera (integer, integer, smallint, integer) RETURNS integer
    AS '
declare
directo	 	 alias for $1;
indirecto	 alias for $2;
tipoper		 alias for $3;
nro		 alias for $4;
ret 		 int4;
begin
select op_id into ret from operaciones where
op_directo=directo and op_indirecto=indirecto and
op_tipoper=tipoper and op_nrotaldir=nro ;
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 519 (OID 19352039)
-- Name: pg_system (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pg_system () RETURNS void
    AS '/usr/lib/pgsql/pg_system.so', 'pg_system'
    LANGUAGE c;


--
-- TOC entry 489 (OID 19352040)
-- Name: trae_cotiza (smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION trae_cotiza (smallint, date) RETURNS numeric
    AS '
declare
moneda		 alias for $1;
fecha		 alias for $2;
ret 		 numeric;
begin
     SELECT  cot_cotiz  INTO     ret 
	    FROM cotiza    
		WHERE int2eq(moneda,cot_moneda) and  
		    date_le(cot_fecha,fecha) 
	    order by cot_fecha desc limit 1;
return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 490 (OID 19352041)
-- Name: valor_moncte (smallint, date, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valor_moncte (smallint, date, numeric, numeric) RETURNS numeric
    AS '
declare
moneda		 alias for $1;
fecha		 alias for $2;
cuanto		 alias for $3;
tipo_de_cambio	 alias for $4;
aux_mon		 int2;
cotiz		 numeric;
ret 		 numeric;
begin

 SELECT  var_valor 
 INTO     aux_mon -- Codigo Moneda Homogenea
    FROM varamb    WHERE var_codigo like ''MONH%'';

if int2eq(aux_mon,moneda) then
	    ret:= cuanto;
   else
     if numeric_eq(tipo_de_cambio,0::numeric) then -- busco la cotizacion
	    cotiz:=trae_cotiza(moneda,fecha)::numeric;
	    if(cotiz) then 
		    ret:=cuanto / cotiz;
		else
		    ret:=0;
	    end if;
	else

	    ret:= cuanto / tipo_de_cambio;

--	    cotiz:=trae_cotiza(1::int2,fecha)::numeric;
--	    if(cotiz) then 
--		    ret:= cuanto * (tipo_de_cambio / cotiz);
--		else
--		    ret:=0;
--	    end if;
    end if;

end if;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 491 (OID 19352042)
-- Name: cambioparientes (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cambioparientes (integer) RETURNS boolean
    AS '
declare
operacion	alias for $1; 	
registro	RECORD;
operacion	int4;
ret 		boolean;
begin

/* ACA */

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 492 (OID 19352043)
-- Name: monctesitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monctesitem (integer) RETURNS numeric
    AS '
declare
sitem		alias for $1; 	--Id del Subitem
registro	RECORD;
operacion	int4;
ret 		numeric;
begin

select sitem_idoper into operacion from subitem where sitem_id=sitem;

for registro in select 
    op_impdolar as impdolar, 
    op_importe as importe 
     from operaciones where op_id=operacion
	loop

	if(registro.impdolar is null or numeric_eq(registro.impdolar,0::numeric) or registro.importe is null or numeric_eq(registro.importe,0::numeric)) then   
	    registro.importe=1; registro.impdolar=1;
	end if;

	ret:=registro.impdolar / registro.importe;

	end loop; 

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 493 (OID 19352044)
-- Name: moncteopera (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION moncteopera (integer) RETURNS numeric
    AS '
declare
operacion	alias for $1; 	--operacion
registro	RECORD;
ret 		numeric;
begin


for registro in select 
    op_impdolar as impdolar, 
    op_importe as importe 
     from operaciones where op_id=operacion
	loop

	if(registro.impdolar is null or numeric_eq(registro.impdolar,0::numeric) or registro.importe is null or numeric_eq(registro.importe,0::numeric)) then   
	    registro.importe=1; registro.impdolar=1;
	end if;

	ret:=registro.impdolar / registro.importe;

	end loop; 

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 531 (OID 19352045)
-- Name: hay_contrato (integer, integer, smallint, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_contrato (integer, integer, smallint, integer, smallint) RETURNS boolean
    AS '
declare
directo		 alias for $1;
indirecto	 alias for $2;
caso 		 alias for $3;  -- 1 valida que exista contrato
				-- 2 valida que exista y este aprobado
				-- 3 valida que exista contrato y no graba noticias
				-- 4 valida que exista y este aprobado y no graba noticias
				-- 43 valida que exista y este aprobado y no graba noticias
				-- 5 valida que exista y este aprobado y no haya ni reprocidad ni indirecto locador ni
operacion	 alias for $4;
tipo_contrato alias for $5;
aux_texto	 text;
ret 		 boolean;
registro	 RECORD;
estado		 int2;
unifun		 int2;
hayuno	 	 int2;
hayunoaprob	 int2;

begin
ret:=''f'';
hayuno:=0;
hayunoaprob:=0;

if(int4ne(directo,indirecto)) then
    if caso!=5 then
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt)=tipo_contrato
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;
      else
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt) in (4::int2,5::int2)
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;

    end if;

  else

	hayuno:=1;
	hayunoaprob:=1;
 end if;

if caso=1 and hayuno=1 then
    ret:=true;
end if;

if int2ne(caso,1::int2) and hayunoaprob=1 then     
    ret:=true;
end if;

if caso=2 and hayuno=1  and hayunoaprob=0 then
    aux_texto:=''No Existe Contrato Aprobado  tipo  ''||nomtipc(tipo_contrato)||'' entre ''||nomusu(directo) ||'' y ''||nomusu(indirecto)||'' !!!!!!!'';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;

if  hayuno=0  and hayunoaprob=0 and int2ne(caso,4::int2) and int4ne(directo,1) then
    aux_texto:=''No Existe Contrato Aprobado  de tipo  ''||nomtipc(tipo_contrato)||'' entre ''||nomusu(directo) ||'' y ''||nomusu(indirecto)||'' !!!!!!!'';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;
return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 477 (OID 19352046)
-- Name: contindlocador (integer, integer, smallint, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contindlocador (integer, integer, smallint, smallint, smallint) RETURNS boolean
    AS '
declare
unifusu		 alias for $1;
indlocad	 alias for $2;
unifun		 alias for $3;
tipo_contrato 	 alias for $4;
modo 		 alias for $5; 	-- 1 solo busca indirecto locador
				-- 2 busca Indirecto locador o reciprocidad
unicont		 int2;
tipusu		 int2;
pame		 int2;
ret 		 boolean;
registro	 RECORD;
hayuno	 	 int2;
hayunoaprob	 int2;

begin

pame:=2;
ret:=''f'';
hayuno:=0;
hayunoaprob:=0;


select usu_tipusu into tipusu from usuarios where usu_codigo=indlocad;
if(int2eq(tipusu,3::int2)) then
    pame:=1;
end if; 


if(unifusu!=indlocad) then

    if(int2eq(pame,1::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu and contr_locatario=indlocad and tipo_de_contrato(contr_idsubt)=tipo_contrato and int2eq(contr_estado,1::int2)
	    loop
		if int2eq(unifun,registro.contr_unifun::int2) then  
		hayunoaprob:=1;
		ret:=''t''; 
		end if;
	    end loop;
    end if;


    if(int2eq(modo,2::int2) and int2eq(pame,2::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu 
		and contr_locatario=indlocad 
		and tipo_de_contrato(contr_idsubt) in (2::int2,4::int2,5::int2) 
		and int2eq(contr_estado,1::int2)
	    loop
		ret:=''t'';
	    end loop;

    end if;

end if;

if(int4eq(unifusu,indlocad)) then
    ret:=''t'';
end if;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 478 (OID 19352047)
-- Name: seg_disponible (smallint, numeric, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION seg_disponible (smallint, numeric, smallint) RETURNS boolean
    AS '
    DECLARE
	cod_unifun	ALIAS FOR $1; -- id dela unifun
	valorfob	ALIAS FOR $2; -- Valor Fob
	caso		ALIAS FOR $3; -- Caso 
	
		    --  0=compara parametro contra monto UNIFUN
		    --  1=compara contra la oper (INSERTO DE OP FUTURO)
 
	compara 	numeric;
	aux_seg 	varchar;
	retval 		boolean;
    BEGIN
	if caso=0 then
		SELECT  unif_seguro - unif_valormerca INTO compara FROM unifun   
		    WHERE cod_unifun = unif_codigo;
			retval:=numeric_le(valorfob,compara); 
	    elsif	
	    caso=1 then
		 SELECT  var_valor  INTO     aux_seg 	-- Controla seguro??
		    FROM varamb    WHERE var_codigo like ''SEGURO%'';
	    
		 if varchareq(aux_seg,''NO'') then
			return true;
	        else
	    	SELECT  unif_seguro - unif_valormerca INTO compara FROM unifun   
			WHERE cod_unifun = unif_codigo;
	    	retval:=numeric_le(valorfob,compara); 
	        end if;	
	    
	    end if;


    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 479 (OID 19352048)
-- Name: seg_ok (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION seg_ok (integer, smallint) RETURNS boolean
    AS '
    DECLARE
	cod_operacion	ALIAS FOR $1; -- id dela operacion
	cod_modo	ALIAS FOR $2; -- modo de operacion
-- modo =	1 valido para notificar y devuelvo true
--		2 valido pulenta (notifico y devuelvo true/false segun)
	compara 	numeric;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
	aux_texto 	text;
    BEGIN
    retval:=''t'';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla seguro??
	    FROM varamb    WHERE var_codigo like ''SEGURO%'';
	
    if varchareq(aux_seg,''NO'') 
	then return true;
    end if;

    for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
     from subitem where sitem_idoper=cod_operacion group by sitem_deposito
	loop
	trans:=seg_disponible(registro.x,registro.y,0::int2);

	if booleq(trans,''f'') then 
		retval:=trans;	
		aux_texto:=''Con la unifun ''||registro.x ||'' existen problemas de seguro por ''||registro.y ||'' !!!!!!!!!!'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,cod_operacion,aux_texto);
	    end if;
	end loop; 

	if  varchareq(aux_seg,''NI'') or (int2eq(cod_modo,1::int2)) then
--	if  varchareq(aux_seg,''NI'') then
--	if   (int2eq(cod_modo,1::int2)) then
	    retval:=''t'';		
	end if;
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 480 (OID 19352049)
-- Name: valmer_unifun (integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valmer_unifun (integer, smallint, smallint) RETURNS boolean
    AS '
DECLARE
operacion	ALIAS FOR $1; 	-- id de la operacion
caso		ALIAS FOR $2; 	-- Caso 
				--  1=arregla valormerca de unifun por ingreso
				--  2=arregla valormerca de unifun por egreso
modalidad	ALIAS FOR $3; 	-- Modalidad sumo o resto 
				--  1=actualizo normal
				--  2=Me arrepiento y corrijo lo ya hecho
compara 	numeric;
deposito 	int2;
registro 	RECORD;
retval 		boolean;
trans 		boolean;
aux_texto 	text;
BEGIN
retval:=''t'';		

if modalidad=1 then
	if caso=1 then
		for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
    		    from subitem where sitem_idoper=operacion group by sitem_deposito
			loop
			    update unifun set unif_valormerca=unif_valormerca+registro.y
				where unif_codigo=registro.x;
			end loop; 
	    else
		for registro in select ret_idsitem as x,sum(ret_cantidad*precio_unitariod(ret_idsitem)) as y
    		    from retiros where ret_idopera=operacion group by x
			loop
			    select sitem_deposito into deposito from subitem where sitem_id=registro.x;
			    update unifun set unif_valormerca=unif_valormerca-registro.y
				where unif_codigo=deposito;
			end loop; 
	end if;

    else
	if caso=1 then
		for registro in select sitem_deposito as x,sum(sitem_imp_dolar) as y
    		    from subitem where sitem_idoper=operacion group by sitem_deposito
			loop
			    update unifun set unif_valormerca=unif_valormerca-registro.y
				where unif_codigo=registro.x;
			end loop; 
	    else
		for registro in select ret_idsitem as x,sum(ret_cantidad*precio_unitariod(ret_idsitem)) as y
    		    from retiros where ret_idopera=operacion group by x
			loop
			    select sitem_deposito into deposito from subitem where sitem_id=registro.x;
			    update unifun set unif_valormerca=unif_valormerca+registro.y
				where unif_codigo=deposito;
			end loop; 
	end if;
end if;


RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 481 (OID 19352050)
-- Name: tipprod_posible (smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_posible (smallint, integer) RETURNS boolean
    AS '
    DECLARE
	unifun		ALIAS FOR $1; -- id de Unifun.
	tipmerc		ALIAS FOR $2; -- tipo de Mercaderia
	compara 	numeric;
	registro 	RECORD;
	kk 		int2;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
    BEGIN
    retval:=''t'';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla Tipo de Merca??
	    FROM varamb    WHERE var_codigo like ''VALID_TIPMERC%'';
	
    if varchareq(aux_seg,''NO'') 
	then return true;
    end if;


    select txu_codtipp into kk from tippxunif where 
	    int4eq(txu_codtipp,tipmerc) and 
		int2eq(txu_codunif,unifun);
    if not found then 
	return false;
    end if;


    if varchareq(aux_seg,''NI'')  then
	    retval:=''t'';		
	end if;
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 475 (OID 19352051)
-- Name: tipprod_item (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_item (integer) RETURNS integer
    AS '
    DECLARE
	itemc	ALIAS FOR $1; -- id del Item
	tipo	int4;
    BEGIN
    SELECT item_tipprod into tipo
	FROM item WHERE item_id = itemc;
    RETURN tipo;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 521 (OID 19352052)
-- Name: cambio_estado (integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cambio_estado (integer, smallint, smallint) RETURNS boolean
    AS '
    DECLARE
	operacion	ALIAS FOR $1; 	-- operacion
	estado		ALIAS FOR $2; 	-- estado
	modo		ALIAS FOR $3; 	-- 1 cambia estado
					-- Solo verifica sin cambiar estado 
	viejo_estado	int2;
	directo		int4;
	tipoper		int4;
	indirecto	int4;
	consig		int4;
	duedepo		int4;
	nrotalzon	int4;
	nrotaldir	int4;
	deposito	int2;
	importe		numeric;
	aux_texto 	text;
	mal		int2;
	trans 		boolean;
	trans1 		boolean;
	notid		int4;
	fobopera	numeric;
	foboperai	numeric;
	ret		boolean;
    BEGIN

select 	op_estado,op_tipoper,op_directo,op_indirecto,op_nrotalzon,op_nrotaldir,op_deposito,op_importe,op_consig
into viejo_estado,tipoper,directo,indirecto,nrotalzon,nrotaldir,deposito,importe,consig
	    from operaciones where op_id=operacion;

select unif_usuario into duedepo from unifun where unif_codigo=deposito;

if consig is null then
    consig:=-1;
end if;

------------------- I N G R E S O S


if(int4lt(tipoper,100::int2))  THEN 



------------------- PUBLICACION 
--falta ver los contratos por unidad funcional que salen de subitem

    if(( int2eq(estado,101::int2)and int2eq(viejo_estado,1::int2) )
	or 
	(int2eq(estado,102::int2)and int2eq(viejo_estado,101::int2) )
	or 
	(int2eq(estado,1::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2) )
		or
	(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if(int4eq(tipoper,10::int2) or int4eq(tipoper,30::int2))  THEN 
		foboperai:=fob_hijos1(operacion,2::int2);
		update operaciones set op_importe=foboperai,op_impdolar=foboperai WHERE op_id = operacion;
	    END IF;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
	    aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' no existe contrato entre el directo ''||directo||''  (''||nomusu(directo) ||'')     y el indirecto ''||indirecto||''  (''||nomusu(indirecto)||'')'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (numeric_ne(fobpadre_vs_fobhijos(operacion,1::int2),0)) THEN 
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' el valor FOB de los SUBITEMS es distinto al FOB de la operacion, debera modificar este error antes de oficializar'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if (seg_disponible(deposito, importe,1::int2)!=true) THEN 
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' el deposito ''||deposito||''  (''||traigo_nomunifun(deposito::int2)||'') no tiene el seguro necesario'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    trans1:=tipprod_ok(operacion,1::int2,2::int2);

	    if (int4ne(duedepo,directo)) THEN
		trans1:=hay_contrato(duedepo,directo,5::int2,operacion,5::int2);
	    END IF;
	    
	    if(tipoper=5 and consig=-1) then
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' no se ha definifo el consignatario'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	END IF;
	
    else

------------------- E G R E S O S
------------------- PUBLICACION 
        if ((int2eq(estado,101::int2) and int2eq(viejo_estado,1::int2)) 
		or 
    	    (int2eq(estado,102::int2) and int2eq(viejo_estado,101::int2))
		or 
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,101::int2)and int2eq(viejo_estado,11::int2))
		or
	    (int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2))) THEN 

	    delete from noticias where not_tipo=1 and not_numero=operacion;

	    if (hay_cont_valido(directo,indirecto,4::int2)!=true )THEN 
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' no existe contrato entre el directo ''||directo||''  (''||nomusu(directo) ||'')     y el indirecto ''||indirecto||''  (''||nomusu(indirecto)||'')'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    if ctacte_ok(directo)!=true THEN 
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' el usuario directo ''||directo||''  (''||nomusu(directo) ||'')  esta inhabilitado por falta de pago   '';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;
	    
	    if(tipoper=105 and consig=-1) then
		aux_texto:=''En la Operacion ''||traigo_simbtipoper(tipoper)||'' ''||nrotaldir||'' no se ha definifo el consignatario'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    END IF;

	    fobopera:=fob_hijos2(operacion,2::int2);

	END IF;
END IF;

select not_id into notid from noticias where not_tipo=1 and not_numero=operacion;

if found then 
    	    ret:=''f'';
	    if(int2eq(estado,1::int2) and int2eq(viejo_estado,1::int2)) THEN 
		    update operaciones set op_estado=11::int2 WHERE op_id = operacion;
	    end if;

	else

	    ret:=''t'';

    	    if (int2eq(estado,101::int2) and int2eq(viejo_estado,1::int2) and (fobopera>0)) then
		update operaciones set op_impdolar=fobopera WHERE op_id = operacion;
	    end if;
	
	    if(int2eq(modo,1::int2)) then	
	    update operaciones set op_estado=estado WHERE op_id = operacion;
	    end if;

end if;

if int2eq(estado,999::int2) then
    update operaciones set op_estado=estado WHERE op_id = operacion;
end if;


RETURN ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 470 (OID 19352053)
-- Name: tipprod_ok (integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprod_ok (integer, smallint, smallint) RETURNS boolean
    AS '
    DECLARE
	operacion	ALIAS FOR $1; -- id dela operacion
	unifun		ALIAS FOR $2; -- id unifun
	modo		ALIAS FOR $3; -- modo
-- modo =	1 valido para notificar y devuelvo true
--		2 valido pulenta (notifico y devuelvo true/false segun)
	compara 	numeric;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_seg 	varchar;
	aux_texto 	text;
    BEGIN
    retval:=''t'';		
    SELECT  var_valor  INTO     aux_seg 	-- Controla tipo de merca?
	    FROM varamb    WHERE var_codigo like ''VALID_TIPMERC%'';
	
    if varchareq(aux_seg,''NO'') 
	then return true;
    end if;

    for registro in select sitem_iditem as x,sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by x,y
	loop
	trans:=tipprod_posible(registro.y::int2,tipprod_item(registro.x));

	if booleq(trans,''f'') then 
		retval:=trans;	
		aux_texto:=''La unidad funcional ''||registro.y||''  (''||traigo_nomunifun(registro.y) ||'')  no tolera el ingreso de mercaderia del tipo ''||tipprod_item(registro.x) ||'' debera cambiar de ubicacion la misma. Notifique al usuario '';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
	    end if;
	end loop; 

	if  varchareq(aux_seg,''NI'') or (int2eq(modo,1::int2)) then
	    retval:=''t'';		
	end if;

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 471 (OID 19352054)
-- Name: hay_cont_recipro (integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_recipro (integer, integer, smallint) RETURNS boolean
    AS '
    DECLARE
	operacion	ALIAS FOR $1; 	-- id dela operacion
	directo		ALIAS FOR $2; 	-- Usuario Directo
	modo		ALIAS FOR $3; 	-- modo
					--1 valido en publicacion
					--2 valido solo
	indirecto 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:=''t'';		
    for registro in select sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by y
	loop
	select unif_usuario into indirecto from unifun where unif_codigo=registro.y;
	    if int4ne(directo,indirecto) then
		    trans:=hay_contrato(directo,indirecto,2::int2,operacion,5::int2);
		else
		    trans:=''t'';		
	    end if;
	end loop; 

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 472 (OID 19352055)
-- Name: hay_cont_valido (integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_valido (integer, integer, smallint) RETURNS boolean
    AS '
    DECLARE
	usuario		ALIAS FOR $1; 	-- Titular de la unifun 
	directo		ALIAS FOR $2; 	-- Usuario Directo o indirecto
	modo 		alias for $3;  	-- 1  valida que exista contrato
					-- 2 valida que exista y este aprobado
					-- 3 valida que exista contrato y no graba noticias
					-- 4 valida que exista y este aprobado y no graba noticias
					-- 43 valida que exista  tipo contrato 3 y este aprobado y no graba noticias
					-- 443 valida que exista  tipo contrato 4 y este aprobado y no graba noticias
	indirecto 	int4;
	operacion 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:=''f'';		
    operacion=1;

if(usuario!=directo) then
    if usuario then
	if int4ne(directo,usuario) then
	        if int2eq(modo,43::int2) then
	    		trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
		    else
	    		if int2eq(modo,443::int2) then
	    			trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				if booleq(trans,''f'')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				end if;
			    else
				trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				if booleq(trans,''f'')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				    if booleq(trans,''f'')then
					trans:=hay_contrato(usuario,directo,modo::int2,operacion,5::int2);
					if booleq(trans,''f'')then
					    trans:=hay_contrato(usuario,directo,modo::int2,operacion,2::int2);
					end if;
				    end if;
				end if;
			end if;
		end if;
	    else
		trans:=''t'';		
	end if;
	retval:=trans;
    end if;
else
    retval:=''t'';		
end if;

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 473 (OID 19352056)
-- Name: precio_unitario (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION precio_unitario (integer) RETURNS numeric
    AS '
    DECLARE
	item		ALIAS FOR $1; -- id del Sub Item.
	retval 		numeric;
	importe		numeric;
	cantidad	numeric;
    BEGIN
    retval:=0;
    SELECT   sitem_importe,sitem_canting INTO importe,cantidad
	    FROM subitem   WHERE int4eq(sitem_id,item);
    if(importe!=0 and cantidad!=0) then
	retval:= importe / cantidad::numeric;
    end if;	    
	    
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 474 (OID 19352057)
-- Name: precio_unitariod (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION precio_unitariod (integer) RETURNS numeric
    AS '
    DECLARE
	item		ALIAS FOR $1; -- id del Sub Item.
	retval 		numeric;
	importe		numeric;
	cantidad	numeric;
    BEGIN
    retval:=0;
    SELECT   sitem_imp_dolar,sitem_canting INTO importe,cantidad
	    FROM subitem   WHERE int4eq(sitem_id,item);

    if(importe!=0 and cantidad!=0) then
	retval:= importe / cantidad::numeric;
    end if;	    

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 456 (OID 19352058)
-- Name: fob_hijos1 (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_hijos1 (integer, smallint) RETURNS numeric
    AS '
    DECLARE
	operacion	ALIAS FOR $1; 	-- id dela Operacion.
	caso		ALIAS FOR $2; 	-- retorna sitem_importe
					-- retorna sitem_imp_dolar
	retval 		numeric;
    BEGIN
	if(int2eq(caso,1::int2)) then
		select sum(sitem_importe) into retval from subitem where 
		    int4eq(sitem_idoper,operacion);
	    else
		select sum(sitem_imp_dolar) into retval from subitem where 
		    int4eq(sitem_idoper,operacion);
	end if;
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 443 (OID 19352059)
-- Name: fob_hijos2 (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_hijos2 (integer, smallint) RETURNS numeric
    AS '
    DECLARE
	operacion	ALIAS FOR $1; -- id dela Operacion.
	caso		ALIAS FOR $2; 	-- retorna sitem_importe
					-- retorna sitem_imp_dolar
	retval 		numeric;
	registro 	RECORD;
    BEGIN
	if(int2eq(caso,1::int2)) then
		select sum(ret_cantidad*precio_unitario(ret_idsitem)) into retval from
    		    retiros where int4eq(operacion,ret_idopera);
	    else
		select sum(ret_cantidad*precio_unitariod(ret_idsitem)) into retval from
    		    retiros where int4eq(operacion,ret_idopera);
	end if;
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 458 (OID 19352060)
-- Name: fobpadre_vs_fobhijos (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fobpadre_vs_fobhijos (integer, smallint) RETURNS numeric
    AS '
    DECLARE
	id		ALIAS FOR $1; -- id dela OP.
	modo		ALIAS FOR $2; -- Modalidad de Operacion.
	fobt 		numeric;
	fobs 		numeric;
	retval 		numeric;
	cantidad	numeric;
    BEGIN
    SELECT   op_importe INTO fobt FROM operaciones WHERE op_id=id;
    
    if  int2eq(modo,1::int2) then
	 fobs := fob_hijos1(id,1::int2);
	 else
	 fobs := fob_hijos2(id,2::int2);
    end if;

    if (fobs) then cantidad=1::numeric; else fobs=0; end if;

    retval := fobt - fobs;
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 467 (OID 19352061)
-- Name: ctacte_ok (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ctacte_ok (integer) RETURNS boolean
    AS '
    DECLARE
	usuario		ALIAS FOR $1; -- id del Usuario.
	retval 		boolean;
	estado 		int2;
    BEGIN
    retval:=''f'';
    select usu_estado into estado from
    	 usuarios where int4eq(usuario,usu_codigo);
	 if int2eq(estado,1::int2) then
	 	    retval:=''t'';
	 end if;		
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 459 (OID 19352062)
-- Name: mismo_consig (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION mismo_consig (integer, integer) RETURNS boolean
    AS '
    DECLARE
	op_ing		ALIAS FOR $1; -- id  Op.ING.
	op_egr		ALIAS FOR $2; -- id  Op.EGR.
	retval 		boolean;
    BEGIN
    retval:=''f'';
    if  int4eq((select op_consig from operaciones where op_id=op_ing),(select op_consig from operaciones where op_id=op_egr)) 
        then retval:=''t'';
    end if;		

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 460 (OID 19352063)
-- Name: check_autorizacion (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION check_autorizacion (integer, integer) RETURNS boolean
    AS '
    DECLARE
	operacion	ALIAS FOR $1; -- id  Operacion
	operador	ALIAS FOR $2; -- id  Operador
	autorizadopor 	int4;
	retval 		boolean;
	aux_texto 	text;
    BEGIN
    retval:=''f'';
    select mod_autoriz1 into autorizadopor from modopub where mod_idoper=operacion;
    if autorizadopor is null then
    	    update modopub set mod_autoriz1=operador,mod_fecaut1=''now'' where mod_idoper=operacion;
	else
	    if int4eq(autorizadopor,operador) then
		    aux_texto:=''Ya fue autorizado por usted anteriormente hace falta la autorizacion de otra persona para numericizar el cambio definitivo!!'';
		    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
		else
		    update modopub set mod_autoriz2=operador,mod_fecaut2=''now'' where 
		    mod_idoper=operacion;	
		    retval:=''t'';
	    end if;
    end if;		
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 461 (OID 19352064)
-- Name: existe_modopub (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION existe_modopub (integer) RETURNS boolean
    AS '
    DECLARE
	operacion	ALIAS FOR $1; -- id  Operacion
	operador	int4;
	retval 		boolean;
    BEGIN
    retval:=''f'';
    select mod_idoperador into operador from modopub where mod_idoper=operacion;
    if found then
	retval:=''t'';
    end if;		
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 462 (OID 19352065)
-- Name: borro_todo_ingre (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION borro_todo_ingre (integer, integer) RETURNS boolean
    AS '
    DECLARE
	operacion		ALIAS FOR $1; -- id  Operacion
	cholo			ALIAS FOR $2; -- id  Operador
	estado_operacion	int2;
	salidas 		numeric;
	ret boolean;
	aux_text 		text;
    BEGIN
    ret:=true;
    select op_estado into estado_operacion from
	 operaciones where op_id=operacion;

    if int2eq(estado_operacion,1::int2) 	-- A Futuro
	then
	delete from subitem where sitem_idoper=operacion;	
	delete from item where item_idoper=operacion;	
    	update operacion set op_estado=999 where op_id=operacion;
    end if;

    if int2eq(estado_operacion,101::int2) 	-- Oficializada
	then
	select sum(sitem_cantret)+sum(sitem_cantcomp) into salidas 
	    from subitem where sitem_idoper=operacion;
--	raise notice ''oficializada '';
	if(numeric_ne(salidas,0::numeric)) then
	aux_texto:=''No se puede Anular esta operacion por existir retiros o reexpediciones '';
	insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
--      raise notice ''No se puede Anular esta operacion por existir retiros o reexpediciones '';
	else
    	    update operaciones set op_estado=102 where op_id=operacion;
	    update subitem set sitem_estado=3 where sitem_idoper=operacion;
	    insert into modopub (mod_idoperador,mod_idoper,mod_modalidad,mod_estado) values(cholo,operacion,''A'', 1);
--	    raise notice ''la op paso a 102 '';
	end if;

    end if;

    if int2eq(estado_operacion,102::int2) 	-- Modificada
	then
	    if(check_autorizacion(operacion,cholo))
	    then
    	    update operaciones set op_estado=999 where op_id=operacion;
	    delete from subitem where sitem_idoper=operacion;	
	    delete from item where item_idoper=operacion;	
--	    raise notice ''la op paso a 999 '';
	    end if;
    end if;

return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 463 (OID 19352066)
-- Name: val_talon (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION val_talon (integer, integer) RETURNS integer
    AS '
declare
tipoper		 alias for $1;
usuario		 alias for $2;
ret 		 int4;
begin

 SELECT  talop_numero  INTO     ret 
    FROM talonop   WHERE talop_usuario=usuario and talop_tipoper=tipoper;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 442 (OID 19352067)
-- Name: cantidad_disponible (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidad_disponible (integer) RETURNS numeric
    AS '
    DECLARE
	sitem		ALIAS FOR $1; -- id del SubItem.
	retval 		numeric;
    BEGIN
	
    SELECT  
	sitem_canting-sitem_cantret-sitem_cantcomp-sitem_cantmala 
	    INTO retval
	    FROM subitem   WHERE int4eq(sitem_id,sitem);
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 444 (OID 19352068)
-- Name: cantcomp_cantret (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcomp_cantret (integer, smallint) RETURNS boolean
    AS '
DECLARE
operacion	ALIAS FOR $1; 	-- id de la Operacion
modalidad	ALIAS FOR $2; 	-- Modalidad sumo o resto 
				--  1=actualizo normal
				--  2=Me arrepiento y corrijo lo ya hecho
registro 	RECORD;
retval 		boolean;
BEGIN

if modalidad=1 then    

	for registro in select ret_idsitem as x, ret_cantidad as y
    	    from retiros where ret_idopera=operacion
		loop
		    update subitem set sitem_cantcomp=sitem_cantcomp - registro.y,
				   sitem_cantret=sitem_cantret + registro.y
			where sitem_id=registro.x;
		end loop; 

    else

	for registro in select ret_idsitem as x, ret_cantidad as y
    	    from retiros where ret_idopera=operacion
		loop
		    update subitem set sitem_cantcomp=sitem_cantcomp + registro.y,
		    	    sitem_cantret=sitem_cantret - registro.y
				where sitem_id=registro.x;
		end loop; 

end if;    
RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 445 (OID 19352069)
-- Name: opera_publicada (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opera_publicada (integer) RETURNS boolean
    AS '
    DECLARE
	sitem		ALIAS FOR $1; -- id del SubItem.
	estado		int2;
	operacion	int4;
	retval 		boolean;
    BEGIN

    SELECT  sitem_idoper INTO operacion
	    FROM subitem   WHERE int4eq(sitem_id,sitem);

    SELECT  op_estado INTO estado
	    FROM operaciones   WHERE int4eq(op_id,operacion);

    if int2eq(estado,101::int2) then
    	    retval:=''t'';
	else
	    retval:=''f'';
    end if;

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 446 (OID 19352070)
-- Name: estado_opera (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estado_opera (integer) RETURNS smallint
    AS '
    DECLARE
	operacion	ALIAS FOR $1; -- id de la Operacion.
	retval		int2;
    BEGIN

    SELECT  op_estado INTO retval
	    FROM operaciones   WHERE int4eq(op_id,operacion);

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 448 (OID 19352071)
-- Name: orden_tarifa (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION orden_tarifa (integer, integer) RETURNS smallint
    AS '
    DECLARE
	usuario		ALIAS FOR $1;  
	articulo	ALIAS FOR $2; 
	orden		int2;
	retval		int2;
    BEGIN

    retval:=1;
    SELECT  max(tari_orden) INTO orden
	    FROM tarifas   WHERE int4eq(tari_idart,articulo) and int4eq(tari_usuario,usuario);

    if int2gt(orden,0::int2) then
	    retval:= orden + 1;
    end if;

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 449 (OID 19352072)
-- Name: conocimsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION conocimsitem (integer) RETURNS character varying
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	operacion	int4;
	retval		varchar;
    BEGIN

    SELECT  sitem_idoper INTO operacion
	    FROM subitem   WHERE int4eq(sitem_id,sitem);

    SELECT  op_conocim INTO retval
	    FROM operaciones   WHERE int4eq(op_id,operacion);

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 450 (OID 19352073)
-- Name: marcasitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcasitem (integer) RETURNS character varying
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	articulo	int4;
	retval		varchar;
    BEGIN

    SELECT  sitem_artic INTO articulo
	    FROM subitem   WHERE int4eq(sitem_id,sitem);

    SELECT  artic_marca INTO retval
	    FROM articu   WHERE int4eq(artic_id,articulo);

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 451 (OID 19352074)
-- Name: nomunifsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomunifsitem (integer) RETURNS character varying
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	deposito	int2;
	retval		varchar;
    BEGIN

    SELECT  sitem_deposito INTO deposito
	    FROM subitem   WHERE int4eq(sitem_id,sitem);

    SELECT  unif_nombre INTO retval
	    FROM unifun   WHERE int2eq(unif_codigo,deposito);

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 454 (OID 19352075)
-- Name: nomconsig (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomconsig (integer) RETURNS character varying
    AS 'select csg_nombre from consig where csg_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 455 (OID 19352076)
-- Name: nomusu (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomusu (integer) RETURNS character varying
    AS 'select usu_nombre from usuarios where usu_codigo = $1;'
    LANGUAGE sql;


--
-- TOC entry 420 (OID 19352077)
-- Name: cuitusu (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuitusu (integer) RETURNS character varying
    AS 'select usu_nrocuit from usuarios where usu_codigo = $1;'
    LANGUAGE sql;


--
-- TOC entry 421 (OID 19352078)
-- Name: compbtesitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbtesitem (integer) RETURNS character varying
    AS 'select sitem_compbte from subitem where sitem_id = $1;'
    LANGUAGE sql;


--
-- TOC entry 422 (OID 19352079)
-- Name: codartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codartic (integer) RETURNS smallint
    AS 'select art_codigo from articvta where art_id = $1;'
    LANGUAGE sql;


--
-- TOC entry 423 (OID 19352080)
-- Name: nomtipc (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtipc (integer) RETURNS character varying
    AS 'select tipc_descrip from tipcontrat where tipc_codigo = $1;'
    LANGUAGE sql;


--
-- TOC entry 424 (OID 19352081)
-- Name: traigo_compbte (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_compbte (integer) RETURNS character varying
    AS 'select op_compbte from operaciones a, subitem b where b.sitem_id= $1 and b.sitem_idoper=a.op_id ;'
    LANGUAGE sql;


--
-- TOC entry 425 (OID 19352082)
-- Name: compbteoper (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbteoper (integer) RETURNS character varying
    AS 'select op_compbte from operaciones  where op_id= $1;'
    LANGUAGE sql;


--
-- TOC entry 426 (OID 19352083)
-- Name: traigo_moneda (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_moneda (integer) RETURNS character varying
    AS 'select mon_simbol from moneda a, item b where a.mon_codigo=b.item_moneda and b.item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 431 (OID 19352084)
-- Name: nomtipusu (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtipusu (smallint) RETURNS character varying
    AS 'select tpu_nombre from tipusu where tpu_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 432 (OID 19352085)
-- Name: nomprov (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomprov (integer) RETURNS character varying
    AS 'select pro_nombre from provin where pro_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 433 (OID 19352086)
-- Name: nompais (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nompais (smallint) RETURNS character varying
    AS 'select pai_nombre from pais where pai_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 434 (OID 19352087)
-- Name: nomestusu (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomestusu (smallint) RETURNS character varying
    AS 'select esc_nombre from estusu where esc_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 435 (OID 19352088)
-- Name: simbmoneda (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbmoneda (smallint) RETURNS character varying
    AS 'select mon_simbol from moneda where mon_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 436 (OID 19352089)
-- Name: traigo_nomarticu (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomarticu (integer) RETURNS character varying
    AS 'select artic_descrip from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 439 (OID 19352090)
-- Name: traigo_codarticu (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_codarticu (integer) RETURNS character varying
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	idart		int4;
	retval		varchar;
    BEGIN

    select sitem_artic into idart from subitem where sitem_id= $1 ;

    select artic_codigo into retval from articu where artic_id=idart;
    
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 387 (OID 19352091)
-- Name: traigo_simbtipoper (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_simbtipoper (integer) RETURNS character varying
    AS 'select top_comprob from tipoper where top_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 408 (OID 19352092)
-- Name: traigo_nomtipoper (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomtipoper (integer) RETURNS character varying
    AS 'select top_nombre from tipoper where top_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 410 (OID 19352093)
-- Name: nomdespach (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomdespach (integer) RETURNS character varying
    AS 'select desp_nombre from despach where desp_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 411 (OID 19352094)
-- Name: traigo_nomunifun (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION traigo_nomunifun (smallint) RETURNS character varying
    AS 'select unif_nombre from unifun where unif_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 412 (OID 19352095)
-- Name: tipoperdeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipoperdeop (integer) RETURNS integer
    AS 'select op_tipoper from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 520 (OID 19352096)
-- Name: consigdeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION consigdeop (integer) RETURNS integer
    AS 'select op_consig from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 413 (OID 19352097)
-- Name: closeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION closeop (integer) RETURNS date
    AS 'select op_fecha_close from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 414 (OID 19352098)
-- Name: tipo_de_contrato (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipo_de_contrato (integer) RETURNS integer
    AS 'select subt_idtipc from subtcontrat where subt_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 415 (OID 19352099)
-- Name: nomsubtc (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomsubtc (integer) RETURNS character varying
    AS 'select subt_descrip from subtcontrat where subt_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 416 (OID 19352100)
-- Name: opera_de_dir_ind (integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION opera_de_dir_ind (integer, integer, integer, integer) RETURNS boolean
    AS '
    DECLARE
	directo		ALIAS FOR $1; 
	indirecto	ALIAS FOR $2; 
	tipoper		ALIAS FOR $3; 
	operacion	ALIAS FOR $4; 
	esta 		int4;
	retval 		boolean;
    BEGIN
    retval:=''t'';

    select op_id into esta from operaciones where
	op_directo=directo and 
	op_indirecto=indirecto and 
	op_tipoper=tipoper and 
	op_id=operacion ;

    if not found  
        then retval:=''f'';
    end if;		

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 524 (OID 19352101)
-- Name: f_bi_operaciones (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_operaciones () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
BEGIN
--	if (hay_contrato (NEW.op_directo, NEW.op_indirecto, 1::int2,0,3::int2)!=true )THEN 
--	    aux_texto:=''En la Operacion ''||traigo_simbtipoper(NEW.op_tipoper)||'' ''||NEW.op_nrotalzon||'' no existe contrato entre el directo ''||NEW.op_directo||''  (''||nomusu(NEW.op_directo) ||'')     y el indirecto ''||NEW.op_indirecto||''  (''||nomusu(NEW.op_indirecto)||'')'';
--	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;

--    if ( NEW.op_tipoper<100 and seg_disponible(NEW.op_deposito, NEW.op_importe,1::int2)!=true) THEN 
--	aux_texto:=''En la Operacion ''||traigo_simbtipoper(NEW.op_tipoper)||'' ''||NEW.op_nrotalzon||'' el deposito ''||NEW.op_deposito||''  (''||traigo_nomunifun(NEW.op_deposito::int2)||'') no tiene el seguro necesario'';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;

--    if ( NEW.op_tipoper>100 and ctacte_ok(NEW.op_directo)!=true) THEN 
--	aux_texto:=''En la Operacion ''||traigo_simbtipoper(NEW.op_tipoper)||'' ''||NEW.op_nrotalzon||'' el usuario directo ''||NEW.op_directo||''  (''||nomusu(NEW.op_directo) ||'')  esta inhabilitado por falta de pago   '';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
--	END IF;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 529 (OID 19352102)
-- Name: f_ai_operaciones (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_operaciones () RETURNS "trigger"
    AS '
    DECLARE
	operacion	int4;
    BEGIN
    update talonop set talop_numero=talop_numero+1 where talop_usuario=NEW.op_directo and talop_tipoper=NEW.op_tipoper;
    update talonop set talop_numero=talop_numero+1 where talop_usuario=1 and talop_tipoper=NEW.op_tipoper;
    select auxo_idoper into operacion from auxoper where auxo_idoper=NEW.op_id;
    if not found then
	insert into auxoper(auxo_idoper) values(NEW.op_id);
    end if;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 532 (OID 19352103)
-- Name: f_bu_operaciones (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_operaciones () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
mal		int2;
salidas		numeric;
trans 		boolean;
notid		int4;
BEGIN
if(int2eq(NEW.op_estado,1::int2)and int2eq(OLD.op_estado,101::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	select sum(sitem_cantret)+sum(sitem_cantcomp) into salidas 
	    from subitem where sitem_idoper=NEW.op_id;
	if(numeric_ne(salidas,0::numeric)) then
	    RAISE EXCEPTION  ''NO SE PUEDE MODIFICAR ESTA OPERACION POR EXISTIR RETIROS O REEXPEDICIONES QUE AFECTAN LA MISMA'';
	END IF;
    END IF;
END IF;

RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 544 (OID 19352104)
-- Name: f_au_operaciones (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_operaciones () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
BEGIN

if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,100::int2) 
    and int4lt(NEW.op_tipoper,100::int4)) THEN 
    delete from subitem where sitem_idoper=NEW.op_id;
    delete from item where item_idoper=NEW.op_id;
end if;

if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,100::int2) 
    and (int4eq(NEW.op_tipoper,101::int4) or int4eq(NEW.op_tipoper,105::int4)) ) THEN 
    delete from retiros where ret_idopera=NEW.op_id;
end if;

if(int2eq(NEW.op_estado,999::int2) and int2lt(OLD.op_estado,100::int2) and int4gt(NEW.op_id,83880) ) THEN
    if(int4eq(NEW.op_tipoper,110::int4) or int4eq(NEW.op_tipoper,120::int4) or int4eq(NEW.op_tipoper,130::int4)) THEN 
    update operaciones set op_estado=999 where op_id=NEW.op_id+1;
    delete from retiros where ret_idopera=NEW.op_id;
    end if;
end if;


if(int2eq(NEW.op_estado,101::int2) and int2eq(OLD.op_estado,1::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	    trans:=valmer_unifun(NEW.op_id,1::int2,1::int2);
	else                                  -- es egreso     
	    trans:=valmer_unifun(NEW.op_id,2::int2,1::int2);
	    trans:=cantcomp_cantret(NEW.op_id,1::int2);
	END IF;
END IF;

if(int2eq(NEW.op_estado,1::int2)and int2eq(OLD.op_estado,101::int2)) THEN 
    if int4lt(NEW.op_tipoper,100::int4)  THEN -- es ingreso
	    trans:=valmer_unifun(NEW.op_id,1::int2,2::int2);
	else                                  -- es egreso     
	    trans:=valmer_unifun(NEW.op_id,2::int2,2::int2);
	    trans:=cantcomp_cantret(NEW.op_id,2::int2);
	END IF;
END IF;


if(int2eq(NEW.op_estado,101::int2)and int2eq(OLD.op_estado,101::int2)) THEN 
	if (int4ne(NEW.op_directo,OLD.op_directo) or
	    int4ne(NEW.op_indirecto,OLD.op_indirecto) or
	    int4ne(NEW.op_tipoper,OLD.op_tipoper) or
	    int4ne(NEW.op_consig,OLD.op_consig) or
	    numeric_ne(NEW.op_importe,OLD.op_importe) or
	    varcharne(NEW.op_compbte,OLD.op_compbte))  then
		aux_texto:=''El usuario autorizado ha modificado la operacion publicada ''||NEW.op_id||	'' de importe ''||OLD.op_importe||'' a importe ''||NEW.op_importe||'' de directo ''||OLD.op_directo||'' a directo ''||NEW.op_directo||'' de indirecto ''||OLD.op_indirecto||'' a indirecto ''||NEW.op_indirecto||'' de tipoper ''||OLD.op_tipoper||'' a tipoper ''||NEW.op_tipoper||'' de compbte ''||OLD.op_compbte||'' a compbte ''||NEW.op_compbte||'' de consignatario ''||OLD.op_consig||'' a consiganatario ''||NEW.op_consig||'' el dia de hoy'';
		insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.op_id,aux_texto);
	END IF;
END IF;

if(varcharne(NEW.op_compbte,OLD.op_compbte)) THEN 
    update subitem set sitem_compbte=NEW.op_compbte where sitem_idoper=NEW.op_id;
END IF;

RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 482 (OID 19352105)
-- Name: f_bi_item (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_item () RETURNS "trigger"
    AS '
    DECLARE
	usu1 		int4;
	usu2 		int4;
	aux_texto 	text;
BEGIN

--	NEW.item_item=cantitem(NEW.item_idoper)+1;

RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 541 (OID 19352106)
-- Name: f_bi_subitem (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_subitem () RETURNS "trigger"
    AS '
    DECLARE
	usu1 		int4;
	usu2 		int4;
	aux_texto 	text;
BEGIN

if numeric_eq(NEW.sitem_imp_dolar,0::numeric) then
    NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
end if;

--     if(tipprod_posible(NEW.sitem_deposito,(select item_tipprod from item where item_id=NEW.sitem_iditem)) !=true) then	
--	aux_texto:=''El tipo de mercaderia no puede ser almacenada en la unidad funcional ''||NEW.sitem_deposito||''  (''||traigo_nomunifun(NEW.sitem_deposito)||'')'';	 
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.sitem_idoper,aux_texto);
--	END IF;

--    select unif_usuario into usu1 from unifun where int2eq(unif_codigo,NEW.sitem_deposito);
--    select op_directo into usu2 from operaciones where op_id=NEW.sitem_idoper;
--    if (hay_contrato(usu1, usu2, 1::int2 ,NEW.sitem_idoper, 2::int2)!=true ) THEN 
--	aux_texto:=''No Hay CONTRATO DE SERVICIO(2) PARA EL SUBITEM entre  ''||usu1||''  (''||nomusu(usu1) ||'')  y  ''||usu2 ||''  (''||nomusu(usu2)||'') '';
--	insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.sitem_idoper,aux_texto);
--	END IF;

RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 402 (OID 19352107)
-- Name: f_bu_subitem (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_subitem () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
BEGIN

if int2lt(estadop(NEW.sitem_idoper),100::int2) THEN
    if numeric_ne(NEW.sitem_importe,OLD.sitem_importe) then
	NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
    end if;
end if;

if int2gt(estadop(NEW.sitem_idoper),100::int2) THEN
    if numeric_ne(NEW.sitem_importe,OLD.sitem_importe) then
	NEW.sitem_imp_dolar:=moncteopera(NEW.sitem_idoper) * NEW.sitem_importe;
	if (numeric_ne(fobpadre_vs_fobhijos(NEW.sitem_idoper,1::int2),0)) THEN 
	    update operaciones set op_importe=fob_hijos1(NEW.sitem_idoper,1::int2) where op_id=NEW.sitem_idoper;
	    update operaciones set op_impdolar=fob_hijos1(NEW.sitem_idoper,2::int2) where op_id=NEW.sitem_idoper;
	    aux_texto:=''El usuario autorizado ha modificado el importe del subitem ''||NEW.sitem_id ||'' de la operacion publicada ''||NEW.sitem_idoper||'' que tenia un importe de ''||OLD.sitem_importe||'' por un importe de ''||NEW.sitem_importe||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(41,NEW.sitem_idoper,aux_texto);
        end if;
    end if;

    if (int2ne(NEW.sitem_codigo,OLD.sitem_codigo)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  subitem ''||NEW.sitem_id ||'' de la operacion publicada ''||NEW.sitem_idoper||'' que tenia un codigo ''||OLD.sitem_codigo||'' por el codigo ''||NEW.sitem_codigo||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(42,NEW.sitem_idoper,aux_texto);
        end if;

    if (int4ne(NEW.sitem_artic,OLD.sitem_artic)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  subitem ''||NEW.sitem_id ||'' de la operacion publicada ''||NEW.sitem_idoper||'' que tenia el articulo ''||OLD.sitem_artic||'' por el articulo ''||NEW.sitem_artic||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(43,NEW.sitem_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.sitem_canting,OLD.sitem_canting)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  subitem ''||NEW.sitem_id ||'' de la operacion publicada ''||NEW.sitem_idoper||'' que tenia la cantidad ''||OLD.sitem_canting||'' por la cantidad ''||NEW.sitem_canting||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(44,NEW.sitem_idoper,aux_texto);
        end if;

    if (int2ne(NEW.sitem_deposito,OLD.sitem_deposito)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  subitem ''||NEW.sitem_id ||'' de la operacion publicada ''||NEW.sitem_idoper||'' que estaba en el deposito ''||OLD.sitem_deposito||'' por el deposito ''||NEW.sitem_deposito||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(45,NEW.sitem_idoper,aux_texto);
        end if;
end if;
RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 403 (OID 19352108)
-- Name: f_bd_subitem (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_subitem () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
salidas		numeric;

BEGIN

-- if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
--    if booleq(existe_modopub(OLD.sitem_idoper),''f'') THEN 
--	    RAISE EXCEPTION  ''USTED NO ESTA AUTORIZADO A MODIFICAR UNA OPERACION PUBLICADA'';
--	else
--	    update operaciones set op_estado=102 where op_id=OLD.sitem_idoper;
--    end if;
-- end if;

-- if int2eq(estadop(OLD.sitem_idoper),1::int2) THEN
--    aux_texto:=''Ha modificado un subitem de la operacion ''||OLD.sitem_idoper||''  debera corroborar nuevamente si se puede oficializar'';
--    insert into noticias(not_tipo,not_numero,not_texto)values(1,OLD.sitem_idoper,aux_texto);
--    update operaciones set op_estado=11 where op_id=OLD.sitem_idoper;
-- end if;

if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
    salidas:=OLD.sitem_cantret+OLD.sitem_cantcomp;
    if(numeric_ne(salidas,0::numeric)) then
        RAISE EXCEPTION  ''NO SE PUEDE BORRAR ESTE SUBITEM POR EXISTIR RETIROS O REEXPEDICIONES QUE AFECTAN AL MISMO'';
    END IF;
END IF;
RETURN OLD;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 405 (OID 19352109)
-- Name: f_bi_retiros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_retiros () RETURNS "trigger"
    AS '
    DECLARE
    BEGIN
    if cantidad_disponible(NEW.ret_idsitem)<NEW.ret_cantidad then
	RAISE EXCEPTION  ''LA CANTIDAD A RETIRAR ES MAYOR A LAS DISPONIBILIDADES'';
    END IF;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 406 (OID 19352110)
-- Name: f_ai_retiros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_retiros () RETURNS "trigger"
    AS '
    DECLARE
    BEGIN
        update subitem set sitem_cantcomp=sitem_cantcomp+NEW.ret_cantidad where sitem_id=NEW.ret_idsitem;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 417 (OID 19352111)
-- Name: f_au_retiros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_retiros () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
    BEGIN

	if(estadop(NEW.ret_idopera)<100 and numeric_ne(NEW.ret_cantidad,OLD.ret_cantidad)) then
    	    update subitem set sitem_cantcomp=sitem_cantcomp + NEW.ret_cantidad - OLD.ret_cantidad where sitem_id=NEW.ret_idsitem;
	end if;

	if(int2gt(estadop(NEW.ret_idopera),100::int2))then

	    if(numeric_ne(NEW.ret_cantidad,OLD.ret_cantidad)) then
    		update subitem set sitem_cantret=sitem_cantret + NEW.ret_cantidad - OLD.ret_cantidad where sitem_id=NEW.ret_idsitem;
		aux_texto:=''El usuario autorizado ha modificado la cantidad del retiro de la operacion publicada ''||NEW.ret_idopera||'' cambiandola de ''||OLD.ret_cantidad ||'' a ''||NEW.ret_cantidad ||'' el dia de hoy'';
		insert into noticias(not_tipo,not_numero,not_texto)values(51,NEW.ret_idopera,aux_texto);
	    end if;

	    if(int4ne(NEW.ret_idsitem,OLD.ret_idsitem)) then
    		update subitem set sitem_cantret=sitem_cantret - OLD.ret_cantidad where sitem_id=OLD.ret_idsitem;
    		update subitem set sitem_cantret=sitem_cantret + NEW.ret_cantidad where sitem_id=NEW.ret_idsitem;
		aux_texto:=''El usuario autorizado ha modificado el articulo del retiro de la operacion publicada ''||NEW.ret_idopera||'' cambiandolo del articulo ''||OLD.ret_idsitem ||'' a ''||NEW.ret_idsitem ||'' el dia de hoy'';
		insert into noticias(not_tipo,not_numero,not_texto)values(52,NEW.ret_idopera,aux_texto);
	    end if;

	end if;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 419 (OID 19352112)
-- Name: f_ad_retiros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_retiros () RETURNS "trigger"
    AS '
    DECLARE
    estado 		int2;
    dato 		varchar;
    aux_texto 		text;
    BEGIN

    select op_estado into estado from operaciones 
	where OLD.ret_idopera = op_id;

    if (int2lt(estado,100::int2)) then
        update subitem 
	set sitem_cantcomp= sitem_cantcomp - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
    END IF;

    if(int2eq(estado,999::int2) ) then
        update subitem 
	set sitem_cantcomp= sitem_cantcomp - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
    END IF;

    if(int2gt(estado,100::int2) and int2ne(estado,999::int2)) then
        update subitem 
	set sitem_cantret= sitem_cantret - OLD.ret_cantidad 
	where sitem_id=OLD.ret_idsitem;
	aux_texto:=''El usuario autorizado ha borrado el retiro de la operacion publicada ''||OLD.ret_idopera||'' que era del subitem ''||OLD.ret_idsitem ||'' con una cantidad de ''||OLD.ret_cantidad ||'' el dia de hoy'';
	insert into noticias(not_tipo,not_numero,not_texto)values(59,OLD.ret_idopera,aux_texto);
    END IF;

    RETURN OLD;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 409 (OID 19352113)
-- Name: f_ai_seguros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_seguros () RETURNS "trigger"
    AS '
    DECLARE
    segvie 		numeric;
    BEGIN

    select unif_seguro into segvie from unifun where unif_codigo=NEW.seg_unifun;
    if segvie is null then segvie:=0; end if;

    update unifun set unif_seguro= segvie + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 542 (OID 19352114)
-- Name: f_bu_seguros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_seguros () RETURNS "trigger"
    AS '
    BEGIN

--    if(date_lt(date(NEW.seg_hasta),date(''now()''))) then 
--	RAISE EXCEPTION  ''LA FECHA DE EXPIRACION NO PUEDE SER MENOR A LA ACTUAL'';
--    END IF;

    if(date_lt(date(NEW.seg_hasta),date(NEW.seg_fechad))) then 
	RAISE EXCEPTION  ''LA FECHA DE VIGENCIA NO PUEDE SER MENOR O IGUAL A LA COMIENZO'';
    END IF;

--    if(date_lt(date(OLD.seg_hasta),date(''now()''))) then 
--	RAISE EXCEPTION  ''DEBERA ANULAR ESTE CONTRATO Y CARGARLO NUEVAMENTE'';
--    END IF;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 388 (OID 19352115)
-- Name: f_au_seguros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_seguros () RETURNS "trigger"
    AS '
    BEGIN

--cambio el importe pero siempre en estado 1 (vigente)
    if(numeric_ne(OLD.seg_importei,NEW.seg_importei)) then
	if(int2eq(NEW.seg_estado,OLD.seg_estado)) then 
	    update unifun set unif_seguro=unif_seguro - OLD.seg_impmoncte where unif_codigo=OLD.seg_unifun;
	    update unifun set unif_seguro=unif_seguro + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;
	END IF;
    END IF;

-- pasa de estado 1 (vigente) a 2 (inactivo o anulado)
    if(int2eq(OLD.seg_estado,1::int2) and int2ne(NEW.seg_estado,1::int2)) then 
	    update unifun set unif_seguro=unif_seguro - OLD.seg_impmoncte where unif_codigo=NEW.seg_unifun;
    END IF;

-- pasa de estado  2 (inactivo o anulado) a 1 (vigente)
    if(int2ne(OLD.seg_estado,1::int2)) then
	if(int2eq(NEW.seg_estado,1::int2)) then 
	    update unifun set unif_seguro=unif_seguro + NEW.seg_impmoncte where unif_codigo=NEW.seg_unifun;
        END IF;
    END IF;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 389 (OID 19352116)
-- Name: f_ad_seguros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_seguros () RETURNS "trigger"
    AS '
    BEGIN

    if(int2ne(OLD.seg_estado,1::int2)) then
    update unifun set unif_seguro=unif_seguro-OLD.seg_impmoncte where unif_codigo=OLD.seg_unifun;
    end if;
    
    RETURN OLD;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 390 (OID 19352117)
-- Name: f_ai_usuarios (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_usuarios () RETURNS "trigger"
    AS '
    BEGIN
    insert into talonop values(NEW.usu_codigo,1,1);
    insert into talonop values(NEW.usu_codigo,5,1);
    insert into talonop values(NEW.usu_codigo,10,1);
    insert into talonop values(NEW.usu_codigo,20,1);
    insert into talonop values(NEW.usu_codigo,30,1);
    insert into talonop values(NEW.usu_codigo,101,1);
    insert into talonop values(NEW.usu_codigo,105,1);
    insert into talonop values(NEW.usu_codigo,110,1);
    insert into talonop values(NEW.usu_codigo,120,1);
    insert into talonop values(NEW.usu_codigo,130,1);
    insert into talonop values(NEW.usu_codigo,2,1);
    insert into talonop values(NEW.usu_codigo,3,1);
    insert into talonop values(NEW.usu_codigo,4,1);
    insert into talonop values(NEW.usu_codigo,102,1);
    insert into talonop values(NEW.usu_codigo,103,1);

    insert into sucursales (suc_cliente,suc_codigo,suc_nombre) values(NEW.usu_codigo,1::int2,NEW.usu_nombre);

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 391 (OID 19352118)
-- Name: f_bi_contratos (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_contratos () RETURNS "trigger"
    AS '
    DECLARE
    ale 		int2;
    usua 		int4;
    BEGIN
    select unif_codigo into ale from unifun where unif_codigo=NEW.contr_unifun;
    if not found then
	NEW.contr_unifun:=0;
    end if;

    select usu_codigo into usua from usuarios where usu_codigo=NEW.contr_locador;
    if not found then
	NEW.contr_locador:=1;
    end if;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 392 (OID 19352119)
-- Name: f_ai_contratos (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_contratos () RETURNS "trigger"
    AS '
    BEGIN
    if int4eq(tipo_de_contrato(NEW.contr_idsubt),1) then
	update unifun set unif_usuario=NEW.contr_locatario, unif_estado=1::int2
	where unif_codigo=NEW.contr_unifun;

    end if;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 398 (OID 19352120)
-- Name: f_bi_puertos (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_puertos () RETURNS "trigger"
    AS '
    DECLARE
    nompais 		varchar;
    BEGIN
    select pai_nombre into nompais from pais where pai_codigo=NEW.pue_pais;
    if not found then
	insert into pais values(NEW.pue_pais,''DATO DESCONOCIDO'');
    end if;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 395 (OID 19352121)
-- Name: migracion1 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion1 () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select distinct on (int_directo,int_indirecto,int_tipoper,int_numero) * from intotal
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,op_deposito,op_conocim,op_peso,op_bultos,op_moneda,op_importe,op_impdolar,op_tipo_cambio,op_embalaje) 
	values
	(regi.int_tipoper::int4,regi.int_directo::int4,regi.int_indirecto::int4,regi.int_compbte::varchar,val_talon(regi.int_tipoper::int4,1),regi.int_numero::int4,regi.int_estado::int2,regi.int_consig::int4,regi.int_fecha::date,regi.int_deposito::int2,regi.int_conocim::varchar,regi.int_peso::numeric,regi.int_bultos::int4,regi.int_moneda::int2,regi.int_fobt::numeric,regi.int_valcte::numeric,regi.int_tipcbo::numeric,regi.int_embalaje::int2);
--	ret:=ret+1;		
        end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 396 (OID 19352122)
-- Name: migracion2 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion2 () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;


for regi in select distinct on (int_articod,int_directo,int_indirecto) * from intotal
	loop
	select artic_id into ruflo from articu where artic_indirecto=regi.int_indirecto::int4 and artic_codigo=regi.int_articod::varchar;

	if not found then
	insert into articu (artic_indirecto,artic_codigo,artic_descrip,artic_tiprod,artic_unimed) 
	values
	(regi.int_indirecto::int4,regi.int_articod::varchar,regi.int_artidesc::varchar,trim(regi.int_tiprod)::int4,regi.int_unimed::int2);
ret:=ret+1;
	end if;
        end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 379 (OID 19352123)
-- Name: migracion (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo1 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from intotal order by int_directo,int_indirecto,int_tipoper,int_numero,int_articod,int_lotenum
	loop
	rowintotal:=regi.int_id;
	operid:=cidop(regi.int_directo::int4,regi.int_indirecto::int4,regi.int_tipoper::int4,	regi.int_numero::int4);	

	if(regi.int_id<270554) then
		ruflo1:=regi.int_idret::int4;
	    else
		ruflo1:=cidart(regi.int_indirecto::int4,regi.int_articod::varchar);
	end if;


	
	if regi.int_lotenum::int2 < 1  then
		insert into item (
    		item_idoper,item_existe_sitem,item_moneda,item_tipprod,item_unimed) 
		values	(operid,0,regi.int_moneda::int2,trim(regi.int_tiprod)::int4,regi.int_unimed::int2);
		select max(item_id) into ruflo from item; 
	end if;
	

	insert into subitem (sitem_iditem,sitem_idoper,sitem_codigo,
			sitem_artic,sitem_canting,sitem_cantret,
			sitem_cantcomp,sitem_importe,sitem_tipemb,
			sitem_deposito,sitem_directo,sitem_indirecto,sitem_compbte)
		values
(ruflo,operid,regi.int_lotenum,ruflo1,	
    regi.int_canting::numeric,regi.int_cantret::numeric,regi.int_cantcomp::numeric,
    regi.int_valori::numeric,regi.int_embalaje::int2,regi.int_deposito::int2,
    regi.int_directo::int4,regi.int_indirecto::int4,regi.int_compbte);

    end loop; 
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 380 (OID 19352124)
-- Name: cidop (integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidop (integer, integer, integer, integer) RETURNS integer
    AS '
declare
directo		 alias for $1;
indirecto	 alias for $2;
tipoper		 alias for $3;
numero		 alias for $4;
ret		int4;
begin

select op_id into ret from operaciones where op_directo=directo and
op_indirecto=indirecto and op_tipoper=tipoper and op_nrotaldir=numero;

if ret is null then
select op_id into ret from operaciones where op_directo=directo and
op_indirecto=indirecto and op_tipoper=5 and op_nrotaldir=numero;
end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 381 (OID 19352125)
-- Name: cidart (integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidart (integer, character varying) RETURNS integer
    AS '
declare

indirecto	 alias for $1;
codigo		 alias for $2;
ret		int4;
begin

select artic_id into ret from articu where artic_indirecto=indirecto and
varchareq(trim(artic_codigo),trim(codigo)) order by artic_id limit 1;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 382 (OID 19352126)
-- Name: cidsitem (integer, smallint, character varying, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cidsitem (integer, smallint, character varying, integer) RETURNS integer
    AS '
declare
operacion	 alias for $1;
lote		 alias for $2;
compbte		 alias for $3;
articid		 alias for $4;
ret		int4;
begin

    select sitem_id into ret from subitem where 
	sitem_idoper=operacion and
	sitem_artic=articid and
	sitem_codigo=lote and
	varchareq(sitem_compbte,compbte);
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 383 (OID 19352127)
-- Name: migracion_e (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_e () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;
for regi in select distinct on (egt_directo,egt_indirecto,egt_tipoper,egt_numero) * from egretot
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,
	op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,
	op_comptrans,op_peso,op_bultos,op_moneda,op_importe,
	op_impdolar,op_embalaje) 
	values
	(regi.egt_tipoper::int4,regi.egt_directo::int4,regi.egt_indirecto::int4,
	regi.egt_compbte,val_talon(regi.egt_tipoper::int4,1),regi.egt_numero::int4,
	101::int2,regi.egt_consig::int4,regi.egt_fecha::date,
	regi.egt_combteeg::char,regi.egt_peso::numeric,regi.egt_bultos::int4,
	regi.egt_moneda::int2,regi.egt_fobt::numeric,regi.egt_valcte::numeric,
	regi.egt_embalaje::int2	);
	ret:=ret+1;		
        end loop; 

for regi in select * from egretot 
	loop
	operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,	regi.egt_numero::int4);	
	artic_id:=cidart(regi.egt_indirecto::int4,regi.egt_articod::varchar);
	
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,cidsitem(operid,regi.egt_lotenum::int2,regi.egt_compbte::varchar,artic_id),1::int2,0::int2,regi.egt_cantret::numeric);

--	ret:=ret+1;		

    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 384 (OID 19352128)
-- Name: arrecono (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arrecono () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
idoper		int4;
itemid		int4;
rowintotal 	int4;
ruflo 	int4;
conocim 	varchar;
ruflo2 	int4;
begin
ret:=0;
idoper:=1;

for regi in select distinct on (int_directo,int_indirecto,int_tipoper,int_numero) * from intotal
	loop
	conocim:=trim(regi.int_conocim);
	update operaciones  set op_conocim=conocim where op_id=idoper;
	idoper:=idoper+1;
        end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 385 (OID 19352129)
-- Name: arreart (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreart () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
idart		int4;
rowintotal 	int4;
ruflo 	int4;
idsitem 	int4;
begin
ret:=0;

idsitem:=1;
for regi in select * from intotal order by int_directo,int_indirecto,int_tipoper,int_numero,int_articod,int_lotenum
	loop
	idart=cidart(regi.int_indirecto::int4,regi.int_articod::varchar)
	update subitem set sitem_artic=idart where sitem_id=idsitem;
	idsitem:=idsitem+1;
    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 386 (OID 19352130)
-- Name: migracion_ep (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_ep () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;
for regi in select distinct on (trim(egt_directo),trim(egt_indirecto),trim(egt_tipoper),trim(egt_numero)) * from egretot where egt_id>6499
	loop
	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_compbte,
	op_nrotalzon,op_nrotaldir,op_estado,op_consig,op_fechain,
	op_comptrans,op_peso,op_bultos,op_moneda,op_importe,
	op_impdolar,op_embalaje) 
	values
	(trim(regi.egt_tipoper)::int4,trim(regi.egt_directo)::int4,trim(regi.egt_indirecto)::int4,
	trim(regi.egt_compbte)::varchar,val_talon(trim(regi.egt_tipoper)::int4,1),trim(regi.egt_numero)::int4,
	trim(regi.egt_esta)::int2,trim(regi.egt_consig)::int4,trim(regi.egt_fecha)::date,
	trim(regi.egt_combteeg)::varchar,trim(regi.egt_peso)::numeric,trim(regi.egt_bultos)::int4,
	trim(regi.egt_moneda)::int2,trim(regi.egt_fobt)::numeric,trim(regi.egt_valcte)::numeric,
	trim(regi.egt_embalaje)::int2	);
	ret:=ret+1;		
        end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 362 (OID 19352131)
-- Name: migracion_ep1 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_ep1 () RETURNS integer
    AS '
declare
regi 		RECORD;
ret		int4;
operid		int4;
operidi		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from egretot 
    loop
    operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,regi.egt_numero::int4);

    operidi:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoperin::int4,regi.egt_numeroin::int4);
    artic_id:=cidart(regi.egt_indirecto::int4,trim(regi.egt_articod)::varchar);
    ruflo2=cidsitem(operidi::int4,regi.egt_lotenum::int2,trim(regi.egt_compbte)::varchar,artic_id::int4);
    if ruflo2 is null then ruflo2=0; end if;
	
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,ruflo2,1::int2,0::int2,regi.egt_cantret::numeric);
    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 363 (OID 19352132)
-- Name: cierroop (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cierroop () RETURNS boolean
    AS '
declare
ret 		 boolean;
registro	 record;
regi1		 record;
auxoid 		 int4;
primera		 int4;
cerrada		 date;
hayalgo		 numeric;
begin
primera:=-1;
ret:=''t'';
for registro in select 
    auxo_idoper as auxoid from auxoper where auxo_idoper<100
	loop
	select op_fecha_close in cerrada from operaciones where op_id=registro.auxoid;
	if(cerrada is null) then 
	    select sum(sitem_canting)-sum(sitem_cantret) as hayalgo from subitem where sitem_idoper=registro.auxoid;
	    if(numeric_eq(hayalgo,0)) then
		update operaciones set op_fecha_close=date(now) where op_id=registro.auxoid;
	    end if;
	end if;
end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 161 (OID 19352135)
-- Name: egretot; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE egretot (
    egt_id serial NOT NULL,
    egt_fecha text,
    egt_directo text,
    egt_indirecto text,
    egt_tipoper text,
    egt_numero text,
    egt_lote text,
    egt_compbte text,
    egt_articod text,
    egt_artidesc text,
    egt_chasis text,
    egt_combteeg text,
    egt_cantret text,
    egt_consig text,
    egt_reloper text,
    egt_despach text,
    egt_peso text,
    egt_bultos text,
    egt_embalaje text,
    egt_fobt text,
    egt_moneda text,
    egt_valcte text,
    egt_lotenum smallint,
    egt_idoper integer DEFAULT -1,
    egt_iditem integer DEFAULT -1,
    egt_idsitem integer DEFAULT -1,
    egt_idret integer DEFAULT -1,
    egt_esta integer DEFAULT -1,
    egt_tipoperin text,
    egt_reloperin text,
    egt_numeroin text,
    egt_consigin text
);


--
-- TOC entry 162 (OID 19352146)
-- Name: articu1; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE articu1 (
    artic_id integer NOT NULL,
    artic_indirecto integer NOT NULL,
    artic_codigo character varying(40) NOT NULL,
    artic_marca character varying(40),
    artic_modelo character varying(40),
    artic_descrip character varying(40),
    artic_present character varying(40),
    artic_tiprod integer,
    artic_posa character varying(15),
    artic_unimed smallint
);


--
-- TOC entry 364 (OID 19352148)
-- Name: arreartic (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreartic (integer, integer) RETURNS integer
    AS '
declare

mal		alias for $1;
bien		alias for $2;
codigobien	varchar;
codigomal	varchar;
ret		int4;

begin
ret:=20;

select sitem_id into ret from subitem where sitem_artic=mal; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 365 (OID 19352149)
-- Name: genimpre (text, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION genimpre (text, integer, integer) RETURNS integer
    AS '/usr/lib/pgsql/genimpre.so', 'genimpre'
    LANGUAGE c;


--
-- TOC entry 368 (OID 19352155)
-- Name: migracion_e1 (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION migracion_e1 (integer, integer) RETURNS integer
    AS '
declare
desde	 	alias for $1;
hasta		alias for $2;
regi 		RECORD;
ret		int4;
operid		int4;
operidi		int4;
artic_id		int4;
rowintotal 	int4;
ruflo 	int4;
ruflo2 	int4;
begin
ret:=0;

for regi in select * from egretot where egt_id between desde and hasta
    loop
    operid:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoper::int4,regi.egt_numero::int4);
    operidi:=cidop(regi.egt_directo::int4,regi.egt_indirecto::int4,regi.egt_tipoperin::int4,regi.egt_numeroin::int4);
    artic_id:=cidart(regi.egt_indirecto::int4,trim(regi.egt_articod)::varchar);
    ruflo2=cidsitem(operidi::int4,regi.egt_lotenum::int2,trim(regi.egt_compbte)::varchar,artic_id::int4);
    if ruflo2 is null then ruflo2=0; end if;
	insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad)
		values	(operid,ruflo2,1::int2,0::int2,regi.egt_cantret::numeric);

ret:=1;
    end loop; 


return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 370 (OID 19352156)
-- Name: cambioestadoatodos (smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cambioestadoatodos (smallint, smallint) RETURNS integer
    AS '
declare
modalidad	alias for $1;	-- 1 cambia de 11 a   1
				-- 2 cambia de  1 a 101
tipoper		alias for $2;	-- 1 Operaciones de Ingreso
				-- 2 Operaciones de Egreso

registro	RECORD;
operacion	int4;
bien		boolean;
ret 		int4;
begin
ret:=0;

if(int2eq(modalidad,1::int2) and int2eq(tipoper,1::int2))  THEN 
    for registro in select * from operaciones where op_estado=11 and op_tipoper<100
	loop
	    bien:=cambio_estado(registro.op_id,1::int2,1::int2);
	    ret:= ret+1;
	end loop; 
end if;

if(int2eq(modalidad,1::int2) and int2eq(tipoper,2::int2))  THEN 
    for registro in select * from operaciones where op_estado=11 and op_tipoper>100
	loop
	    bien:=cambio_estado(registro.op_id,1::int2,1::int2);
	    ret:= ret+1;
	end loop; 
end if;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 371 (OID 19352157)
-- Name: nomestadodeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomestadodeop (integer) RETURNS character varying
    AS 'select eto_nombre from estoper where eto_codigo=estado_opera($1);'
    LANGUAGE sql;


--
-- TOC entry 372 (OID 19352158)
-- Name: nrotaldiroper (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nrotaldiroper (integer) RETURNS integer
    AS 'select op_nrotaldir from operaciones  where op_id= $1;'
    LANGUAGE sql;


--
-- TOC entry 373 (OID 19352159)
-- Name: directodeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodeop (integer) RETURNS integer
    AS 'select op_directo from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 374 (OID 19352160)
-- Name: indirectodeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodeop (integer) RETURNS integer
    AS 'select op_indirecto from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 375 (OID 19352161)
-- Name: fechainop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainop (integer) RETURNS date
    AS 'select op_fechain from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 163 (OID 19352164)
-- Name: stock1; Type: VIEW; Schema: public; Owner: zona
--

CREATE VIEW stock1 AS
    SELECT o.op_directo AS directo, nomusu(o.op_directo) AS nomclid, o.op_indirecto AS indirecto, nomusu(o.op_indirecto) AS nomcli, o.op_compbte AS comprobante, traigo_codarticu(a.sitem_artic) AS traigo_codarticu, traigo_nomarticu(a.sitem_artic) AS traigo_nomarticu, precio_unitario(a.sitem_id) AS precio_unitario, traigo_moneda(a.sitem_iditem) AS traigo_moneda, a.sitem_deposito AS deposito, a.sitem_canting AS ingresada, a.sitem_cantcomp AS comprometida, a.sitem_cantret AS retirada, a.sitem_cantmala AS malacondi, (a.sitem_canting - a.sitem_cantret) AS stock, cantidad_disponible(a.sitem_id) AS disponible, b.item_tipprod AS tipoprod, a.sitem_artic AS articulo FROM operaciones o, subitem a, item b WHERE (((o.op_id = a.sitem_idoper) AND (a.sitem_estado = 1)) AND (a.sitem_iditem = b.item_id));


--
-- TOC entry 378 (OID 19352166)
-- Name: tipprodsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tipprodsitem (integer) RETURNS integer
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	iditem		int4;
	retval		int4;
    BEGIN

    select sitem_iditem into iditem from subitem where sitem_id= $1 ;

    select item_tipprod into retval from item where item_id=iditem;
    
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 358 (OID 19352167)
-- Name: simbunimeditem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimeditem (integer) RETURNS character varying
    AS '
    DECLARE
	sitem		ALIAS FOR $1;  
	deposito	int2;
	retval		varchar;
    BEGIN

    SELECT  item_unimed INTO deposito
	    FROM item   WHERE int4eq(item_id,sitem);

    SELECT  uni_simbolo INTO retval
	    FROM unimed   WHERE int2eq(uni_codigo,deposito);

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 359 (OID 19352168)
-- Name: monedasitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedasitem (integer) RETURNS smallint
    AS 'select item_moneda from subitem a, item b where a.sitem_iditem=b.item_id and a.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 360 (OID 19352169)
-- Name: fechainsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainsitem (integer) RETURNS date
    AS 'select op_fechain from operaciones a,subitem b where a.op_id=b.sitem_idoper and b.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 164 (OID 21120150)
-- Name: impresiones; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE impresiones (
    imp_codigo smallint NOT NULL,
    imp_name text,
    imp_query text,
    imp_enscript text,
    imp_filter text,
    imp_shell text
);


--
-- TOC entry 369 (OID 21120200)
-- Name: sibunimedsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sibunimedsitem (integer) RETURNS character varying
    AS 'select uni_simbolo from unimed a, item b where a.uni_codigo=b.item_unimed and b.item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 430 (OID 21120209)
-- Name: simbunimedsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedsitem (integer) RETURNS character varying
    AS 'select a.uni_simbolo from unimed a, item b ,subitem c where int2eq(a.uni_codigo,b.item_unimed) and b.item_id=c.sitem_iditem and c.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 366 (OID 21120574)
-- Name: grabocontrapart (integer, integer, real, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabocontrapart (integer, integer, real, numeric) RETURNS integer
    AS '
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:=''DESCONOCIDA''; end if;
if(registro_artic.marca is null) then registro_artic.marca:=''DESCONOCIDA''; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:=''DESCONOCIDA''; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:=''DESCONOCIDA''; end if;
if(registro_artic.present is null) then registro_artic.present:=''DESCONOCIDA''; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 367 (OID 21120575)
-- Name: valor_moncte (smallint, date, numeric, real); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valor_moncte (smallint, date, numeric, real) RETURNS numeric
    AS '
declare
moneda		 alias for $1;
fecha		 alias for $2;
cuanto		 alias for $3;
tipo_de_cambio	 alias for $4;
aux_mon		 int2;
cotiz		 numeric;
ret 		 numeric;
begin

 SELECT  var_valor 
 INTO     aux_mon -- Codigo Moneda Homogenea
    FROM varamb    WHERE var_codigo like ''MONH%'';

if int2eq(aux_mon,moneda) then
	    ret:= cuanto;
   else
     if float4eq(tipo_de_cambio,0::float4) then -- busco la cotizacion
	    cotiz:=trae_cotiza(moneda,fecha)::numeric;
	    if(cotiz) then 
		    ret:=cuanto / cotiz;
		else
		    ret:=0;
	    end if;
	else

	    cotiz:=trae_cotiza(1::int2,fecha)::numeric;
	    if(cotiz) then 
		    ret:= cuanto * (tipo_de_cambio / cotiz);
		else
		    ret:=0;
	    end if;
    end if;

end if;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 438 (OID 21120814)
-- Name: leyrexp (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION leyrexp (integer, smallint) RETURNS character varying
    AS 'select leyr_leyenda from leyenrexp where leyr_nro= $2 and leyr_idoper= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 440 (OID 21130105)
-- Name: marcontdeopv (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcontdeopv (integer) RETURNS character varying
    AS '
    DECLARE
	idopv		ALIAS FOR $1;  
	codmarcont	int4;
	indi		int4;
	regi		RECORD;
	trans		varchar;
	trans1		varchar;
	retval		varchar;
    BEGIN

    indi=1;
    for regi in select * from contene where cont_idopv= $1 
    loop
    select marc_descrip into trans from marcont where marc_codigo=regi.cont_marcont;
	trans1:= trans||''-''||regi.cont_nrocont;

	if indi>1 then
		retval:= trans1||'' / ''||trans||''-''||regi.cont_nrocont;
	    else
		retval:= trans1;
	end if;
	indi:=indi+1;
    end loop;
    
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 397 (OID 21130174)
-- Name: presintdeopv (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION presintdeopv (integer) RETURNS character varying
    AS '
    DECLARE
	idopv		ALIAS FOR $1;  
	codmarcont	int4;
	indi		int4;
	regi		RECORD;
	trans		varchar;
	trans1		varchar;
	retval		varchar;
    BEGIN

    indi=1;
    for regi in select * from contene where cont_idopv= $1 
    loop
	trans1:= regi.cont_preori||''-''||regi.cont_preana;

	if indi>1 then
		retval:= trans1||'' / ''||regi.cont_preori||''-''||regi.cont_preana;
	    else
		retval:= trans1;
	end if;
	indi:=indi+1;
    end loop;
    
    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 464 (OID 21130473)
-- Name: act_talon (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION act_talon (integer) RETURNS integer
    AS 'select tal_valor from talon where tal_id = $1;'
    LANGUAGE sql;


--
-- TOC entry 441 (OID 21130479)
-- Name: usucontrapart (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usucontrapart (integer, integer) RETURNS integer
    AS '
declare
operacion	 alias for $1;
modo		 alias for $2;
directo		 int4;
indirecto	 int4;
deposito	 int4;
ret 		 int4;
begin

 SELECT  op_directo,op_indirecto,op_deposito  INTO  directo,indirecto,deposito    
    FROM operaciones   WHERE op_id= operacion+1;

if int4eq(modo,1) then ret:=directo; end if;
if int4eq(modo,2) then ret:=indirecto; end if;
if int4eq(modo,3) then ret:=deposito; end if;

return ret;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 165 (OID 21131801)
-- Name: leyenrexp; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE leyenrexp (
    leyr_id serial NOT NULL,
    leyr_idoper integer NOT NULL,
    leyr_nro smallint,
    leyr_leyenda character varying(180)
);


--
-- TOC entry 465 (OID 21133031)
-- Name: compadunombre (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compadunombre (character varying) RETURNS character varying
    AS 'select cad_nombre from compadu where varchareq(cad_codigo::varchar, $1::varchar );'
    LANGUAGE sql;


--
-- TOC entry 437 (OID 21133670)
-- Name: nomarticusitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomarticusitem (integer) RETURNS character varying
    AS 'select articu.artic_descrip from articu,subitem where subitem.sitem_artic=artic_id and sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 166 (OID 21136967)
-- Name: histarifas; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE histarifas (
    htari_idart integer NOT NULL,
    htari_usuario integer NOT NULL,
    htari_orden smallint DEFAULT 1 NOT NULL,
    htari_fecha date DEFAULT 'now()' NOT NULL,
    htari_tipo smallint DEFAULT 1 NOT NULL,
    htari_fdesde date,
    htari_fhasta date,
    htari_cdesde numeric(15,5) DEFAULT 0,
    htari_chasta numeric(15,5) DEFAULT 0,
    htari_ddesde smallint,
    htari_dhasta smallint,
    htari_importe numeric(15,5) DEFAULT 0,
    htari_formula character varying(100)
);


--
-- TOC entry 447 (OID 21137371)
-- Name: publico (date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION publico (date) RETURNS integer
    AS '
    DECLARE
	fecha		ALIAS FOR $1; -- fecha
	registro	RECORD;
	regi		RECORD;
	primera		int4;
	estado		int2;
	operacion	int4;
	fecsal		date;
	operaciono	int4;
	fecsalo		date;
	trans		boolean;
	retval		int4;

    BEGIN

    primera:=1;
    estado:=0;
    for registro in
	select * from opervehi where opv_est_camion < 50 order by opv_idoper
	loop
	operacion:=registro.opv_idoper;
	fecsal:=registro.opv_fecha_egr;
	if(int4eq(primera,1) or int4ne(operacion,operaciono)) then
		primera:=0;

		if(int2eq(estado,1::int2)) then
		    insert into auxoperv (avh_idoper,avh_fecha_pub) values (operaciono,fecsalo);
		end if;
		estado:=0;

		if(int2eq(registro.opv_est_camion,2::int2) and int2ne(estado,2::int2) and date_le(date(registro.opv_fecha_egr),fecha)) then
		        estado:=1;
		    else
			estado:=2;
		end if;

	    else

		if(int2ne(estado,2::int2) and int2eq(registro.opv_est_camion,2::int2) and date_le(date(registro.opv_fecha_egr),fecha)) then
		        estado:=1;
		    else
			estado:=2;
		end if;

	end if;

	operaciono:=registro.opv_idoper;
	fecsalo:=registro.opv_fecha_egr;

	end loop;

	if(int2eq(estado,1::int2)) then
	    insert into auxoperv (avh_idoper,avh_fecha_pub) values (operaciono,fecsalo);
	    retval:=operaciono;
	end if;


    for regi in
	select * from auxoperv  
	loop
	    if(int2lt(estado_opera(regi.avh_idoper),100::int2)) then
		trans:=cambio_estado(regi.avh_idoper,101::int2,1::int2);
		update opervehi set opv_est_camion=50 where opv_idoper=regi.avh_idoper and opv_est_camion < 50;
		if(int4lt(tipoperdeop(regi.avh_idoper),100)) then
			update operaciones set op_fechain=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		    else
			update operaciones set op_fechain=regi.avh_fecha_pub, op_fecha_close=regi.avh_fecha_pub where op_id=regi.avh_idoper;
		end if;
	    end if;
	end loop;


    delete from auxoperv;


    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 167 (OID 21137479)
-- Name: auxoperv; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE auxoperv (
    avh_id serial NOT NULL,
    avh_idoper integer NOT NULL,
    avh_fecha_pub date,
    avh_fecha timestamp without time zone DEFAULT 'now()' NOT NULL
);


--
-- TOC entry 427 (OID 21138395)
-- Name: nomtiproditem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtiproditem (integer) RETURNS character varying
    AS 'select tip_descrip from tipprod a, item b where a.tip_codigo=b.item_tipprod and b.item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 466 (OID 21475222)
-- Name: chkcompvsret (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION chkcompvsret (integer) RETURNS boolean
    AS '
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
cantidad	 numeric(15,5);

begin
for registro in select 
    * from subitem where sitem_estado=1 and sitem_cantcomp!=0
    loop
	select sum(ret_cantidad) into cantidad from retiros where ret_idsitem=registro.sitem_id and estado_opera(ret_idopera)<100 group by ret_idsitem;
	if not found then 
		insert into auxoperv (avh_idoper) values (registro.sitem_id);
	    else
		if (numeric_ne(cantidad,registro.sitem_cantcomp)) then
		    insert into auxoperv (avh_idoper) values (registro.sitem_id * -1);
		end if;
	end if;
end loop; 

ret:=''t'';
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 485 (OID 21476002)
-- Name: arrcompvsret (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arrcompvsret (integer) RETURNS boolean
    AS '
declare
opid		 alias for $1;
ret 		 boolean;
registro	 record;
cantidad	 numeric(15,5);

begin
for registro in select 
    * from auxoperv
    loop
	if int4gt(registro.avh_idoper,0) then 
		update subitem set sitem_cantcomp=0 where sitem_id=registro.avh_idoper;
	end if;
end loop; 

delete from auxoperv where avh_idoper>0;

ret:=''t'';
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 530 (OID 21623208)
-- Name: gtutti (integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gtutti (integer, character varying) RETURNS boolean
    AS '
declare
opid		 alias for $1;
compbte	 	 alias for $2;
ret 		 boolean;
registro	 record;
disponible	 numeric;
primera		 int4;
directo		 int4;
haycuantos	 int2;
elmayor		 int2;
indirecto	 int4;
begin
primera:=-1;

select op_directo,op_indirecto into directo,indirecto from operaciones where op_id=opid;

	select count(*) into haycuantos from retiros where ret_idopera=opid;
	if(int2eq(haycuantos,0::int2)) then
	    haycuantos:=0;
	end if;

	select max(ret_item) into elmayor from retiros where ret_idopera=opid;

	if(int2lt(haycuantos,elmayor)) then
	    haycuantos:=elmayor;
	end if;

for registro in select 
     * from subitem where sitem_estado=1 and varchareq(sitem_compbte,compbte) and sitem_directo=directo and sitem_indirecto=indirecto and estadop(sitem_idoper)=101
	loop
	disponible:=registro.sitem_canting-registro.sitem_cantcomp-registro.sitem_cantret-registro.sitem_cantmala;
	if(disponible>0) then 

	    haycuantos:=haycuantos+1;
	    insert into retiros (ret_item,ret_idopera,ret_idsitem,ret_cantidad) values (haycuantos,opid,registro.sitem_id,disponible);
	end if;
end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 428 (OID 21986718)
-- Name: nomtiprodsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nomtiprodsitem (integer) RETURNS character varying
    AS 'select tip_descrip from tipprod a, item b,subitem c where a.tip_codigo=b.item_tipprod and b.item_id=c.sitem_iditem and c.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 452 (OID 21987615)
-- Name: nombunifsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombunifsitem (integer) RETURNS character varying
    AS 'select unif_nombre from unifun a, subitem b where b.sitem_id= $1 and b.sitem_deposito=a.unif_codigo ;'
    LANGUAGE sql;


--
-- TOC entry 453 (OID 21987633)
-- Name: depositem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION depositem (integer) RETURNS smallint
    AS 'select sitem_deposito from subitem where sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 429 (OID 21987672)
-- Name: tiprodsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION tiprodsitem (integer) RETURNS integer
    AS 'select item_tipprod from item b, subitem c where  b.item_id=c.sitem_iditem and c.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 357 (OID 21994905)
-- Name: bzaconfactur (date, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION bzaconfactur (date, date) RETURNS boolean
    AS '
declare
desde		 alias for $1;
hasta		 alias for $2;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:=''t'';
for registro in select 
    * from opervehi where opv_est_camion=50 and opv_fecha_egr between desde and hasta and opv_pesa=''S'' and opv_nro_ticket is not null
	loop

	ret:=''f'';
	select op_directo,op_indirecto,op_tipoper into directo,indirecto,tipoper from operaciones where op_id=registro.opv_idoper;

	select cfc_id into hay from confactur where cfc_idoper=registro.opv_idoper and cfc_ticket=registro.opv_nro_ticket;
	if not found then
	    auxot:=substr(nomusu(indirecto),1,25) || '' / '' || substr(traigo_simbtipoper(tipoper),1,3) || ''-''|| nrotaldiroper(registro.opv_idoper);
--	    auxot:=nomusu(indirecto) ;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_ticket) values (directo,registro.opv_fecha_egr,40::int4,1::numeric,20::numeric,20::numeric,registro.opv_idoper,auxot,1::int2,registro.opv_nro_ticket);
	end if;

end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 356 (OID 21996205)
-- Name: rexpconfactur (date, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION rexpconfactur (date, date) RETURNS boolean
    AS '
declare
desde		 alias for $1;
hasta		 alias for $2;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:=''t'';
for registro in select 
    * from operaciones where op_estado=101 and op_fechain between desde and hasta and op_tipoper in (101,105) 
	loop

	ret:=''f'';
	select cfc_id into hay from confactur where cfc_idoper=registro.op_id and cfc_idart=35 and cfc_fecha=registro.op_fechain;
	if not found then
	    auxot:=substr(nomusu(registro.op_indirecto),1,25) || '' / '' || substr(traigo_simbtipoper(registro.op_tipoper),1,3) || ''-''|| registro.op_nrotaldir;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,20::numeric,20::numeric,registro.op_id,auxot,1::int2);
	end if;

end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 498 (OID 22001681)
-- Name: bzaconfactur (date, date, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION bzaconfactur (date, date, smallint, smallint) RETURNS boolean
    AS '
declare
desde		 alias for $1;
hasta		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin
ret:=''t'';
for registro in select 
    * from opervehi where opv_est_camion=50 and opv_fecha_egr between desde and hasta and opv_pesa=''S'' and opv_nro_ticket is not null
	loop

	ret:=''f'';
	select op_directo,op_indirecto,op_tipoper into directo,indirecto,tipoper from operaciones where op_id=registro.opv_idoper;

	select cfc_id into hay from confactur where cfc_idoper=registro.opv_idoper and cfc_ticket=registro.opv_nro_ticket;
	if not found then
	    auxot:=substr(nomusu(indirecto),1,25) || '' / '' || substr(traigo_simbtipoper(tipoper),1,3) || ''-''|| nrotaldiroper(registro.opv_idoper);
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_ticket,cfc_anio,cfc_mes,cfc_indirecto) values (directo,registro.opv_fecha_egr,40::int4,1::numeric,15::numeric,15::numeric,registro.opv_idoper,auxot,1::int2,registro.opv_nro_ticket,anio,mes,indirecto);
	end if;

end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 538 (OID 22001682)
-- Name: otrconfactur (integer, integer, smallint, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION otrconfactur (integer, integer, smallint, smallint, date) RETURNS boolean
    AS '
declare
usuario		 alias for $1;
articulo	 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
fecha		 alias for $5;
ret 		 boolean;
registro	 record;
hay	 	 int4;
importe 	 numeric;
begin

ret:=''f'';

if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart=articulo and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from tarifas where tari_idart=articulo
		and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:=''t'';
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
	end loop; 

    else

	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=articulo;
	select tari_importe into importe from tarifas where tari_idart=articulo and tari_usuario=usuario and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha);
	insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (usuario,fecha,articulo::int4,1::numeric,importe::numeric,importe::numeric,1::int2,anio,mes);
end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 500 (OID 22001683)
-- Name: rexpconfactur (date, date, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION rexpconfactur (date, date, smallint, smallint) RETURNS boolean
    AS '
declare
desde		 alias for $1;
hasta		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
ret 		 boolean;
registro	 record;
directo		 int4;
indirecto	 int4;
tipoper		 int4;
hay	 	 int4;
auxot		 varchar;
begin

ret:=''t'';
for registro in select 
    * from operaciones where op_estado=101 and op_fechain between desde and hasta and op_tipoper in (101,105) 
	loop

	ret:=''f'';
	select cfc_id into hay from confactur where cfc_idoper=registro.op_id and cfc_idart=35 and cfc_fecha=registro.op_fechain;
	if not found then
	    auxot:=substr(nomusu(registro.op_indirecto),1,25) || '' / '' || substr(traigo_simbtipoper(registro.op_tipoper),1,3) || ''-''|| registro.op_nrotaldir;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_idoper,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_indirecto) values (registro.op_directo,registro.op_fechain,35::int4,1::numeric,20::numeric,20::numeric,registro.op_id,auxot,1::int2,anio,mes,registro.op_indirecto);
	end if;

end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 376 (OID 22004129)
-- Name: estadop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadop (integer) RETURNS smallint
    AS 'select op_estado from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 501 (OID 22004237)
-- Name: almconfactur (date, smallint, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION almconfactur (date, smallint, smallint, smallint, integer) RETURNS boolean
    AS '
declare
fecha		 alias for $1;
estado		 alias for $2;
anio 		 alias for $3;
mes 		 alias for $4;
usuario		 alias for $5;
ret 		 boolean;
ultfec 		 date;
registro	 record;
hay	 	 int4;
begin

ret:=''t'';

if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart in (5,7,11) and cfc_anio=anio and cfc_mes=mes;

	for registro in select 
	    * from almacen where alm_estado=estado  
	    loop
	    ret:=''f'';
	    if(registro.alm_retiro is NULL) then ultfec:=fecha; else ultfec:=registro.alm_retiro; end if;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias) values (registro.alm_idusu,fecha,idartdetipp(registro.alm_tiprod),1::numeric,registro.alm_tarifa::numeric,registro.alm_tarifa*date_mi(ultfec,registro.alm_ultfac)::numeric,registro.alm_leyenda,1::int2,anio,mes,date_mi(ultfec,registro.alm_ultfac));
	    end loop; 

    else
	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart in (5,7,11);
	for registro in select 
	    * from almacen where alm_estado=estado and alm_idusu=usuario 
	    loop
	    ret:=''f'';
	    if(registro.alm_retiro is NULL) then ultfec:=fecha; else ultfec:=registro.alm_retiro; end if;
	    insert into confactur (cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_leyen,cfc_estado,cfc_anio,cfc_mes,cfc_dias) values (registro.alm_idusu,fecha,idartdetipp(registro.alm_tiprod),1::numeric,registro.alm_tarifa::numeric,registro.alm_tarifa*date_mi(ultfec,registro.alm_ultfac)::numeric,registro.alm_leyenda,1::int2,anio,mes,date_mi(ultfec,registro.alm_ultfac));
	    end loop; 

end if;



return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 377 (OID 22004238)
-- Name: idartdetipp (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idartdetipp (integer) RETURNS smallint
    AS 'select tip_imo from tipprod where tip_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 543 (OID 22006898)
-- Name: valmerxunif (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION valmerxunif (smallint) RETURNS boolean
    AS '
declare
deposito	 alias for $1;
ret 		 boolean;
total 		 numeric;
depo 		 int2;
registro	 record;
begin

ret:=''f'';

if(int2eq(deposito,0::int2)) then
    for registro in select 
	sitem_deposito as depos, sum((sitem_canting-sitem_cantret)*(sitem_imp_dolar/sitem_canting)) as totals from subitem where sitem_estado=1 group by sitem_deposito
	loop
	    ret:=''t'';
	    update unifun set unif_valormerca=registro.totals where unif_codigo=registro.depos;
	end loop; 

else

    select sum((sitem_canting-sitem_cantret)*(sitem_imp_dolar/sitem_canting)) into total from subitem where sitem_estado=1 and sitem_deposito=deposito;
    ret:=''t'';
    update unifun set unif_valormerca=total where unif_codigo=deposito;

end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 457 (OID 22013919)
-- Name: contrid_almacen (integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contrid_almacen (integer, smallint) RETURNS integer
    AS 'select contr_id from contratos where contr_estado= $2 and contr_locador=1  and contr_idsubt in (7,8) and contr_locatario = $1 order by contr_id desc limit 1;'
    LANGUAGE sql;


--
-- TOC entry 468 (OID 22014054)
-- Name: estadocontr (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadocontr (integer) RETURNS smallint
    AS 'select contr_estado from contratos where contr_id= $1;'
    LANGUAGE sql;


--
-- TOC entry 494 (OID 22014055)
-- Name: stepcontr (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION stepcontr (integer) RETURNS smallint
    AS 'select contr_step from contratos where contr_id= $1;'
    LANGUAGE sql;


--
-- TOC entry 507 (OID 22014057)
-- Name: fechainretsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechainretsitem (integer) RETURNS date
    AS 'select op_fechain from operaciones a,retiros b where a.op_id=b.ret_idopera and a.op_estado>100 and b.ret_idsitem= $1 order by ret_id desc limit 1;'
    LANGUAGE sql;


--
-- TOC entry 495 (OID 22014074)
-- Name: fechaevento (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechaevento (integer, integer) RETURNS date
    AS 'select fechac_fecha from feccontra where fechac_idcontra= $1 and fechac_codevent= $2;'
    LANGUAGE sql;


--
-- TOC entry 523 (OID 22014075)
-- Name: cargoalmacen (date, date, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cargoalmacen (date, date, integer) RETURNS boolean
    AS '
declare
desde		 alias for $1;
hasta		 alias for $2;
usuario		 alias for $3;
ret 		 boolean;
registro	 record;
regi		 record;
regi2		 record;
contrato	 int4;
tarifa	 	 numeric;
begin

ret:=''f'';
contrato:=1;
tarifa:=-1;

for registro in select 
    * from unifun where unif_usuario=1
    loop
    if(int4eq(usuario,0::int4)) then
	    for regi in select 
		* from subitem where sitem_deposito=registro.unif_codigo and tiprodsitem(sitem_id) between 4 and 9 and fechainop(sitem_idoper) between desde and hasta and estadop(sitem_idoper)>100
		loop
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),contrato,tarifa,stepcontr(contrato));
		  else
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),3520,1000000::numeric,stepcontr(contrato));
		end if;

	    end loop; 
	else
	    for regi in select 
		* from subitem where sitem_deposito=registro.unif_codigo and tiprodsitem(sitem_id) between 4 and 9 and fechainop(sitem_idoper) between desde and hasta and sitem_directo=usuario and estadop(sitem_idoper)>100
		loop
		ret:=''t'';
		select tari_idcontr,tari_importe into contrato,tarifa from tarifas where tari_usuario=regi.sitem_directo and idartdetipp(tiprodsitem(regi.sitem_id))=tari_idart	and estadocontr(tari_idcontr)=1 and tari_fhasta>=hasta;
		if found then 
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),contrato,tarifa,stepcontr(contrato));
		  else
		    insert into almacen (alm_idusu,alm_idsitem,alm_ultfac,alm_tiprod,alm_leyenda,alm_idcontr,alm_tarifa,alm_estado) values (regi.sitem_directo,regi.sitem_id,fechainop(regi.sitem_idoper),tiprodsitem(regi.sitem_id),traigo_codarticu(regi.sitem_id),3520,1000000::numeric,stepcontr(contrato));
		end if;
	    end loop; 
    end if;
end loop; 

update almacen set alm_retiro=fechainretsitem(alm_idsitem) where alm_estado in (1,100,3);

update almacen set alm_estado=1 where alm_estado in (100,3) and alm_retiro between desde and hasta;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 4 (OID 22034058)
-- Name: seq_qpaso; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE seq_qpaso
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 510 (OID 22096437)
-- Name: alqconfactur (integer, smallint, smallint, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION alqconfactur (integer, smallint, smallint, date) RETURNS boolean
    AS '
declare
usuario		 alias for $1;
anio 		 alias for $2;
mes 		 alias for $3;
fecha		 alias for $4;
ret 		 boolean;
registro	 record;
aux_iva		 numeric;
hay	 	 int4;
importe 	 numeric;
articulo 	 int4;
begin

ret:=''f'';

SELECT  var_valor 
INTO     aux_iva -- Monto no grabado de alquileres
FROM varamb    WHERE var_codigo like ''IMP_SIN_IVA%'';



if(int4eq(usuario,0::int4)) then
	delete from confactur where cfc_idart between 22 and 31 and cfc_anio=anio and cfc_mes=mes;
	for registro in select 
	    * from tarifas where tari_idart between 22 and 31  
		and estadocontr(tari_idcontr)=1 and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:=''t'';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		if(registro.tari_importe < aux_iva) then articulo:=articulo + 5; end if;
		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
	    end if; 
	end loop; 

    else

	delete from confactur where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart between 22 and 31;
	for registro in select 
	    * from tarifas where tari_idart between 22 and 31 and tari_usuario=usuario and estadocontr(tari_idcontr)=1 
		and date_ge(tari_fhasta,fecha) and date_le(tari_fdesde,fecha)
	loop
	    ret:=''t'';
	    if(int2eq(facturacontr(registro.tari_idcontr),1::int2)) then
    		articulo:=registro.tari_idart;
		if(registro.tari_importe < aux_iva) then articulo:=articulo + 5; end if;
		insert into confactur (cfc_ptov,cfc_usuario,cfc_fecha,cfc_idart,cfc_canti,cfc_precio,cfc_importe,cfc_estado,cfc_anio,cfc_mes) values (1::int2,registro.tari_usuario,fecha,articulo::int4,1::numeric,registro.tari_importe::numeric,registro.tari_importe::numeric,1::int2,anio,mes);
    	    end if; 
	end loop; 
end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 496 (OID 22096637)
-- Name: facturacontr (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION facturacontr (integer) RETURNS smallint
    AS 'select contr_facturable from contratos where contr_id= $1;'
    LANGUAGE sql;


--
-- TOC entry 168 (OID 22116345)
-- Name: confactur; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE confactur (
    cfc_id serial NOT NULL,
    cfc_usuario integer NOT NULL,
    cfc_fecha date,
    cfc_anio smallint NOT NULL,
    cfc_mes smallint NOT NULL,
    cfc_idart integer NOT NULL,
    cfc_canti numeric(15,5),
    cfc_precio numeric(15,2),
    cfc_importe numeric(15,2),
    cfc_dias smallint,
    cfc_leyen character varying(40),
    cfc_idoper integer,
    cfc_estado smallint DEFAULT 1,
    cfc_idemiti integer,
    cfc_indirecto integer,
    cfc_fecreg timestamp without time zone DEFAULT 'now()',
    cfc_ticket integer,
    cfc_ptov smallint DEFAULT 2,
    cfc_usureal integer
);


--
-- TOC entry 511 (OID 22122560)
-- Name: usureal_confactur (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usureal_confactur (integer) RETURNS integer
    AS '
declare
cfcid		 alias for $1;
ret 		 int4;
auxreal		 int4;
auxusu 		 int4;

begin
    select cfc_usuario,cfc_usureal into auxusu,auxreal  
     from confactur where cfc_id=cfcid;

	if auxreal is null then 
		ret:=auxusu;
	    else
		ret:= auxreal;
	end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 512 (OID 22123737)
-- Name: totfactu (integer, smallint, smallint, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION totfactu (integer, smallint, smallint, integer) RETURNS numeric
    AS '
declare
usuario		 alias for $1;
anio		 alias for $2;
mes		 alias for $3;
articulo	 alias for $4;
ret 		 numeric;

begin

if int4eq(articulo,0) then 
    select sum(cfc_importe) into ret from confactur where cfc_usuario=usuario and cfc_anio=anio and cfc_mes=mes;
  else
    select sum(cfc_importe) into ret from confactur where cfc_usuario=usuario and cfc_anio=anio and cfc_mes=mes and cfc_idart=articulo;
end if;

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 509 (OID 22139530)
-- Name: cual_moneda (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_moneda (character varying) RETURNS smallint
    AS 'select mon_codigo from moneda where varchareq(trim(mon_simbol),trim($1));'
    LANGUAGE sql;


--
-- TOC entry 469 (OID 22139531)
-- Name: importo_ingreso (integer, integer, integer, integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION importo_ingreso (integer, integer, integer, integer, integer, smallint) RETURNS boolean
    AS '
    DECLARE
	caratul		ALIAS FOR $1; -- id de la Caratula.
	directo		ALIAS FOR $2; -- Directo.
	indirecto	ALIAS FOR $3; -- Indirecto.
	tipoper		ALIAS FOR $4; -- Tipoper.
	consig		ALIAS FOR $5; -- Consignatario.
	deposito	ALIAS FOR $6; -- Deposito.
	operacion	int4;
	elitem		int4;
	articulo	int4;
	monedi		int2;
	moned		int2;
	posafab		varchar;
	despachos	text ;
	retval		boolean;
	registro	record;
    BEGIN
	retval:=''f'';

	select cual_moneda(divisa_fob) into monedi from caratula where car_id=caratul;

	if(monedi is null) then 
	    select divisa_fob::int2 into monedi from caratula where car_id=caratul;
	end if;

	select mon_codigo into moned from moneda where mon_codigo=monedi;
	if not found then
	    moned=2;
	end if;

	select despacho into despachos from caratula where car_id=caratul;

	insert into operaciones (op_tipoper,op_directo,op_indirecto,op_consig,op_compbte,op_comptrans,op_nrotalzon,op_nrotaldir,op_deposito,op_iddespach,op_peso,op_bultos,op_moneda,op_importe,op_impdolar,op_tipo_cambio,op_embalaje) select tipoper,directo,indirecto,consig,despachos,transito,val_talon(tipoper,1),val_talon(tipoper,directo),deposito,cual_despachante(cuit_despachante),peso_bruto_bultos::numeric,cant_bultos_declar::integer,moned::int2,monto_fob::numeric(15,2),valor_moncte(moned,fecha_oficializ::date,monto_fob::numeric,0::numeric),monto_fob::numeric/valor_moncte(moned,fecha_oficializ::date,monto_fob::numeric,0::numeric),codigo_embalaje::smallint from caratula where car_id=caratul;
	
	select max(op_id) into operacion from operaciones;

	delete from auxoper where auxo_idoper=operacion;
	insert into auxoper(auxo_idoper,auxo_facturas,auxo_fecha_oficial,auxo_monflet,auxo_impflet,auxo_monseg,auxo_impseg,auxo_plazo_suspens,auxo_medio_transpo) select operacion,referencias::varchar(90),fecha_oficializ,cual_moneda(divisa_flete),monto_flete::numeric,cual_moneda(divisa_seguro),monto_seguro::numeric,plazo_suspensiva::int2,medio_transporte::int2 from caratula where car_id=caratul;


	for registro in select * from items where items_despacho=despachos
	    loop

	    select item_id into elitem from item where item_idoper=operacion and item_item=registro.nro_item::int2;
		if not found then
		    insert into item (item_idoper,item_item,item_existe_sitem,item_moneda,item_tipprod,item_unimed,item_posa,item_bloqueado,item_paisorigen,item_proced,item_tipitem) values (operacion,registro.nro_item::int2,registro.numero_subitem::int2,moned,1,registro.unidad_declarada::int2,trim(registro.posic_arancelaria),1,registro.pais_origen::int2,registro.pais_procedencia::int2,trim(registro.tipo_item));
		    select max(item_id) into elitem from item;
		end if;

	    select posa_codigo into posafab from posaran where varchareq(posa_codigo,trim(registro.posic_arancelaria)::varchar);
		if not found then
		    insert into posaran (posa_codigo,posa_nombre) values (trim(registro.posic_arancelaria),''NN'');
		end if;

	    select artic_id into articulo from articu where artic_indirecto=indirecto and varchareq(artic_codigo,trim(registro.codigo_articulo)::varchar);
		if not found then
		    insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) values (indirecto,trim(registro.codigo_articulo),trim(registro.marca_articulo),trim(registro.modelo_articulo),trim(registro.descrip_articulo),trim(registro.present_articulo),1,trim(registro.posic_arancelaria),registro.unidad_declarada::int2);
		    select artic_id into articulo from articu where artic_indirecto=indirecto and varchareq(artic_codigo,trim(registro.codigo_articulo));
		end if;

	    insert into subitem (sitem_iditem,sitem_idoper,sitem_codigo,sitem_artic,sitem_canting,sitem_importe,sitem_imp_dolar,sitem_tipemb,sitem_deposito,sitem_directo,sitem_indirecto,sitem_compbte) values (elitem,operacion,registro.numero_subitem::int2,articulo,registro.s_cant_declarada::numeric,registro.s_monto_fob_divisa::numeric,registro.s_monto_fob_dolar::numeric,0::int2,deposito,directo,indirecto,despachos);

	    end loop;

	retval:=''t'';

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 418 (OID 22139992)
-- Name: cual_despachante (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_despachante (character varying) RETURNS integer
    AS '
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit Despachante
	despa		int4;
    BEGIN
	select desp_id into despa from despach where varchareq(desp_nrcuit,cuit);
		if not found then
		    insert into despach (desp_tipo,desp_nrcuit,desp_nroreg,desp_nombre) values (1,cuit,''S/D'',''DATO DESCONOCIDO'');
		    select desp_id into despa from despach where varchareq(desp_nrcuit,cuit);
		end if;

	RETURN despa;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 508 (OID 22169025)
-- Name: arreglo_importo (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo_importo (integer) RETURNS boolean
    AS '
    DECLARE
	caratul		ALIAS FOR $1; -- id de la Caratula.
	despachos	text;
	xx		int4;
	retval		boolean;
	registro	record;
    BEGIN
	
	select despacho into despachos from caratula where car_id=caratul;

	select items_idcaratula into xx from items where items_idcaratula=caratul;
	if not found then
		update items set items_idcaratula=caratul where varchareq(despachos,items_despacho);
		update items set codigo_articulo=modelo_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '''';
		update items set codigo_articulo=descrip_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '''';
		update items set codigo_articulo=marca_articulo where items_idcaratula=caratul and trim(codigo_articulo) like '''';
		update items set codigo_articulo=''S/C'' where items_idcaratula=caratul and trim(codigo_articulo) like '''';
	end if;

	retval:=''t'';

    RETURN retval;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 513 (OID 22189105)
-- Name: usupordepo (text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usupordepo (text) RETURNS integer
    AS 'select unif_usuario from unifun where unif_codmaria=trim($1)::int2;'
    LANGUAGE sql;


--
-- TOC entry 514 (OID 22189106)
-- Name: nombredepo (text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nombredepo (text) RETURNS character varying
    AS 'select unif_nombre from unifun where unif_codmaria=trim($1)::int2;'
    LANGUAGE sql;


--
-- TOC entry 515 (OID 22189107)
-- Name: usuporcuit (text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION usuporcuit (text) RETURNS integer
    AS 'select usu_codigo from usuarios where varchareq(usu_nrocuit,trim($1));'
    LANGUAGE sql;


--
-- TOC entry 528 (OID 22190028)
-- Name: codigopordepo (text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codigopordepo (text) RETURNS smallint
    AS 'select unif_codigo from unifun where unif_codmaria=trim($1)::int2;'
    LANGUAGE sql;


--
-- TOC entry 506 (OID 22195154)
-- Name: cual_consignatario (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cual_consignatario (character varying) RETURNS integer
    AS '
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit 
	consi		int4;
    BEGIN
	select csg_id into consi from consig where varchareq(csg_nrocuit,cuit);
		if not found then
		    insert into consig (csg_nrocuit,csg_nombre) values (cuit,''DATO DESCONOCIDO'');
		    select csg_id into consi from consig where varchareq(csg_nrocuit,cuit);
		end if;

	RETURN consi;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 361 (OID 22195155)
-- Name: borro_la_operacion (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION borro_la_operacion (integer) RETURNS integer
    AS '
    DECLARE
	cuit		ALIAS FOR $1; -- Cuit 
	consi		int4;
    BEGIN
	select csg_id into consi from consig where varchareq(csg_nrocuit,cuit);
		if not found then
		    insert into consig (csg_nrocuit,csg_nombre) values (cuit,''DATO DESCONOCIDO'');
		    select csg_id into consi from consig where varchareq(csg_nrocuit,cuit);
		end if;

	RETURN consi;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 169 (OID 22195498)
-- Name: caratula; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE caratula (
    car_id serial NOT NULL,
    despacho text NOT NULL,
    destinacion text,
    cod_aduana text,
    cuit_despachante text,
    estado_declaracion text,
    tipo_impo_expo text,
    nro_reg_manifiesto text,
    motivo_suspensiva text,
    cuit_impo_expo text,
    nombre_impo_expo text,
    divisa_seguro text,
    divisa_flete text,
    divisa_fob text,
    plazo_suspensiva text,
    peso_bruto_bultos text,
    cantidad_bultos text,
    monto_seguro text,
    monto_flete text,
    monto_fob text,
    base_imponible text,
    medio_transporte text,
    marca_bultos text,
    condicion_venta text,
    codigo_deposito text,
    fecha_oficializ date,
    fecha_llegada_trans date,
    inscripto_en_iva text,
    cotizacion_pagos text,
    peso_guia text,
    transito text,
    codigo_embalaje text,
    tipo_embalaje text,
    nro_bultos text,
    cant_bultos_declar text,
    cant_unidad_medida text,
    unidad_medida text,
    cant_declarada text,
    cant_disponible text,
    referencias text,
    fecreg timestamp without time zone DEFAULT 'now()',
    estado smallint DEFAULT 1
);


--
-- TOC entry 170 (OID 22195498)
-- Name: caratula; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE caratula FROM PUBLIC;
GRANT ALL ON TABLE caratula TO nobody;


--
-- TOC entry 171 (OID 22195510)
-- Name: items; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE items (
    items_id serial NOT NULL,
    items_idcaratula integer,
    items_despacho text NOT NULL,
    items_transito text NOT NULL,
    nro_item text,
    tipo_item text,
    posic_arancelaria text,
    fecha_imponible date,
    existencia_subitem text,
    estado_mercaderia text,
    peso_neto_kgr text,
    pais_origen text,
    pais_procedencia text,
    unidad_declarada text,
    cant_declarada text,
    monto_fob_divisa text,
    monto_fob_dolar text,
    numero_subitem text,
    s_monto_fob_dolar text,
    s_cant_declarada text,
    s_monto_fob_divisa text,
    codigo_articulo text,
    marca_articulo text,
    modelo_articulo text,
    descrip_articulo text,
    present_articulo text,
    items_estado smallint DEFAULT 1
);


--
-- TOC entry 172 (OID 22195510)
-- Name: items; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE items FROM PUBLIC;
GRANT ALL ON TABLE items TO nobody;


--
-- TOC entry 173 (OID 22195521)
-- Name: problimp; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE problimp (
    pim_id serial NOT NULL,
    pim_tipo smallint DEFAULT 1 NOT NULL,
    pim_numero integer NOT NULL,
    pim_texto text,
    pim_fecha timestamp without time zone DEFAULT 'now()'
);


--
-- TOC entry 174 (OID 22267401)
-- Name: almacen; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE almacen (
    alm_id serial NOT NULL,
    alm_idusu integer NOT NULL,
    alm_idsitem integer NOT NULL,
    alm_idcontr integer NOT NULL,
    alm_ultfac date DEFAULT 'now()' NOT NULL,
    alm_retiro date,
    alm_tiprod integer NOT NULL,
    alm_tarifa numeric(15,5) NOT NULL,
    alm_estado smallint,
    alm_leyenda character varying(180)
);


--
-- TOC entry 399 (OID 22268118)
-- Name: f_au_feccontra (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_feccontra () RETURNS "trigger"
    AS '
    DECLARE
    BEGIN

	if(int4eq(NEW.fechac_codevent,5) and date_ne(OLD.fechac_fecha,NEW.fechac_fecha)) then
    	    update tarifas set tari_fhasta=NEW.fechac_fecha where tari_idcontr=NEW.fechac_idcontra;
	end if;

RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 175 (OID 22268551)
-- Name: tarifas; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE tarifas (
    tari_idart integer NOT NULL,
    tari_idcontr integer NOT NULL,
    tari_usuario integer NOT NULL,
    tari_orden smallint DEFAULT 1 NOT NULL,
    tari_tipo smallint DEFAULT 1 NOT NULL,
    tari_fdesde date,
    tari_fhasta date,
    tari_cdesde numeric(15,5),
    tari_chasta numeric(15,5),
    tari_ddesde smallint,
    tari_dhasta smallint,
    tari_importe numeric(15,5) DEFAULT 0 NOT NULL,
    tari_formula character varying(100)
);


--
-- TOC entry 476 (OID 22269630)
-- Name: copio_artic_descrip (integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION copio_artic_descrip (integer, integer, character varying) RETURNS boolean
    AS '
declare
operacion	 alias for $1;
item_a_modificar alias for $2;
ladesc	 	 alias for $3;
ret 		 boolean;
registro	 record;
begin

ret:=''f'';

for registro in select 
    * from subitem where sitem_idoper=operacion and sitem_iditem=item_a_modificar
    loop
	update articu set artic_descrip=ladesc where trim(artic_descrip) like '''' and artic_id=registro.sitem_artic;
    ret:=''t'';
    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 525 (OID 22279936)
-- Name: sitemid_de_almacen (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sitemid_de_almacen (character varying) RETURNS integer
    AS 'select alm_idsitem from almacen where trim(alm_leyenda)= $1 limit 1;'
    LANGUAGE sql;


--
-- TOC entry 483 (OID 22279958)
-- Name: nrotaldirsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION nrotaldirsitem (integer) RETURNS integer
    AS 'select op_nrotaldir from operaciones a,subitem b where a.op_id=b.sitem_idoper and b.sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 484 (OID 22279965)
-- Name: compbteret_idsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbteret_idsitem (integer) RETURNS character varying
    AS 'select op_compbte from operaciones a, retiros b where b.ret_idsitem= $1 and b.ret_idopera=a.op_id order by ret_id desc limit 1;'
    LANGUAGE sql;


--
-- TOC entry 504 (OID 22279991)
-- Name: fecegre_de_almacen (character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecegre_de_almacen (character varying) RETURNS date
    AS 'select alm_retiro from almacen where trim(alm_leyenda)= $1 limit 1;'
    LANGUAGE sql;


--
-- TOC entry 393 (OID 22280803)
-- Name: f_au_contratos (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_contratos () RETURNS "trigger"
    AS '
    DECLARE
	operacion	int4;
    BEGIN

    if(int2eq(OLD.contr_estado,1::int2) and int2ne(NEW.contr_estado,1::int2) and int4lt(NEW.contr_idsubt,7)) then 
	select contr_id into operacion from contratos where int4lt(contr_idsubt,7) and contr_locatario=NEW.contr_locatario and contr_locador=NEW.contr_locador and contr_estado=1 and contr_id!=OLD.contr_id;
	if not found then
	    select contr_id into operacion from contratos where int4eq(contr_idsubt,11) and contr_locatario=NEW.contr_locatario and contr_estado=1;
	    if not found then
		update contratos set contr_estado=14 where contr_locador=OLD.contr_locatario and contr_estado=1;
	    end if;
	end if;
    END IF;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 526 (OID 22291844)
-- Name: elimino_op_malas (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elimino_op_malas (smallint) RETURNS boolean
    AS '
    DECLARE
	estado		ALIAS FOR $1; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:=''f'';

    for registro in select op_id as x
    	    from operaciones where op_estado in (1,11) and op_tipoper>100
		loop

		    select ret_id into operacion from retiros where ret_idopera=registro.x;
		    if not found then
			update operaciones set op_fecha_close=date(''now()'') where op_id=registro.x and op_fecha_close is null;
			ret:=''t'';
		    end if;		
		end loop; 
    
    update operaciones set op_estado=estado where op_estado in (1,11) and op_tipoper>100 and op_fecha_close=date(''now()'') ;

return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 503 (OID 22306837)
-- Name: imprim_fact_deta (character varying, integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta (character varying, integer, integer, smallint) RETURNS boolean
    AS '
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:=''f'';

    for registro in select cfc_usuario as x
    	    from confactur where cfc_mes=11 and cfc_anio=2004 and cfc_ptov=2 group by cfc_usuario
		loop
		    operacion:=genimpre(''lexmark'',501,registro.x);
		    ret:=''t'';
		end loop; 
return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 535 (OID 22465915)
-- Name: fob_a_fecha_directo (integer, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_directo (integer, date) RETURNS numeric
    AS '
DECLARE
directo		ALIAS FOR $1; 	-- id del directo
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where op_directo=directo and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	for registror in select *
	    from subitem where sitem_idoper=registro.x
		loop

		retval:=retval+registror.sitem_imp_dolar;

		if(registror.sitem_cantret) then
		    if(registror.sitem_canting) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;


		select sum(ret_cantidad) into cantret from
    		    retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;

		    if(retirado) then   retval:=retval-retirado; end if;

		end if;

		end loop; 

	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 400 (OID 22484455)
-- Name: f_bu_caratula (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_caratula () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
BEGIN

    if(textne(NEW.despacho,OLD.despacho))
    then
	update items set items_despacho=NEW.despacho where items_idcaratula=NEW.car_id;
    END IF;

    if(textne(NEW.transito,OLD.transito))
    then
	update items set items_transito=NEW.transito where items_idcaratula=NEW.car_id;
    END IF;
	
RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 522 (OID 22484457)
-- Name: fob_a_fecha_compbte (character varying, date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fob_a_fecha_compbte (character varying, date) RETURNS numeric
    AS '
DECLARE
compbte		ALIAS FOR $1; 	-- Comprobante
fecha		ALIAS FOR $2;	-- fecha hasta
registro 	RECORD;
registror 	RECORD;
retirado	numeric;
cantret		numeric;
precio		numeric;
retval 		numeric;
BEGIN

retval:=0;

for registro in select op_id as x
    from operaciones where varchareq(op_compbte,compbte::varchar) and op_estado=101 and int4lt(op_tipoper,100::int4) and date_le(op_fechain,fecha) 
	loop
	for registror in select *
	    from subitem where sitem_idoper=registro.x
		loop

		retval:=retval+registror.sitem_imp_dolar;

		if(registror.sitem_cantret) then
		    if(registror.sitem_canting) then
			precio:=registror.sitem_imp_dolar/registror.sitem_canting;
		    end if;


		select sum(ret_cantidad) into cantret from
    		    retiros where registror.sitem_id=ret_idsitem and date_le(closeop(ret_idopera),fecha) and estadop(ret_idopera)=101;

		    if not found then 
			    retirado:=0;
			else
			    retirado:=cantret*precio;
		    end if;

		    if(retirado) then   retval:=retval-retirado; end if;

		end if;

		end loop; 

	end loop; 
retval:=retval::numeric(15,2);

RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 536 (OID 22484985)
-- Name: imprim_fact_deta (character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta (character varying, integer, smallint, smallint) RETURNS boolean
    AS '
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:=''f'';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_mes=mes and cfc_anio=anio and cfc_ptov=2 group by cfc_usuario
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:=''t'';
		end loop; 
return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 533 (OID 22509155)
-- Name: imprim_fact_deta_alm (character varying, integer, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION imprim_fact_deta_alm (character varying, integer, smallint, smallint) RETURNS boolean
    AS '
    DECLARE
	impresora	ALIAS FOR $1; 
	reporte		ALIAS FOR $2; 
	mes		ALIAS FOR $3; 
	anio		ALIAS FOR $4; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:=''f'';

    for registro in select cfc_usuario as x, count(*) as y
    	    from confactur where cfc_mes=mes and cfc_anio=anio and cfc_ptov=2 and cfc_idart in (5,7,11) group by cfc_usuario
		loop
		    operacion:=genimpre(impresora,reporte,registro.x);
		    ret:=''t'';
		end loop; 
return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 537 (OID 22509744)
-- Name: transitositem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transitositem (integer) RETURNS character varying
    AS 'select op_comptrans from operaciones a, subitem b where b.sitem_id= $1 and b.sitem_idoper=a.op_id ;'
    LANGUAGE sql;


--
-- TOC entry 534 (OID 22524431)
-- Name: f_au_item (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_item () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
BEGIN
if int2gt(estadop(NEW.item_idoper),100::int2) THEN

    if (int2ne(NEW.item_item,OLD.item_item)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  item ''||NEW.item_id ||'' de la operacion publicada ''||NEW.item_idoper||'' que tenia un codigo ''||OLD.item_item||'' por el codigo ''||NEW.item_item||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(31,NEW.item_idoper,aux_texto);
        end if;

    if (int2ne(NEW.item_moneda,OLD.item_moneda)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  item ''||NEW.item_id ||'' de la operacion publicada ''||NEW.item_idoper||'' que tenia la moneda ''||OLD.item_moneda||'' por la moneda ''||NEW.item_moneda||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(32,NEW.item_idoper,aux_texto);
        end if;

    if (int4ne(NEW.item_tipprod,OLD.item_tipprod)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  item ''||NEW.item_id ||'' de la operacion publicada ''||NEW.item_idoper||'' que tenia tipo de producto ''||OLD.item_tipprod||'' por el tipo de producto ''||NEW.item_tipprod||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(33,NEW.item_idoper,aux_texto);
        end if;

    if (int2ne(NEW.item_unimed,OLD.item_unimed)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  item ''||NEW.item_id ||'' de la operacion publicada ''||NEW.item_idoper||'' que tenia unimed ''||OLD.item_unimed||'' por la unimed ''||NEW.item_unimed||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(34,NEW.item_idoper,aux_texto);
        end if;

    if (varcharne(NEW.item_posa,OLD.item_posa)) then
	    aux_texto:=''El usuario autorizado ha modificado el numero de  item ''||NEW.item_id ||'' de la operacion publicada ''||NEW.item_idoper||'' que tenia posicion arancelaria ''||OLD.item_posa||'' por la pocision arancelaria ''||NEW.item_posa||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(35,NEW.item_idoper,aux_texto);
        end if;
end if;
RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 404 (OID 22524434)
-- Name: f_ad_subitem (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_subitem () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
BEGIN

if int2eq(estadop(OLD.sitem_idoper),101::int2) THEN
    aux_texto:=''El usuario autorizado ha borrado el subitem ''||OLD.sitem_id ||'' de la operacion publicada ''||OLD.sitem_idoper||'' que tenia un importe de ''||OLD.sitem_importe||'' del articulo ''||OLD.sitem_artic||'' con una cantidad de ''||OLD.sitem_canting||'' el dia de hoy'';
    insert into noticias(not_tipo,not_numero,not_texto)values(49,OLD.sitem_idoper,aux_texto);
end if;

RETURN OLD;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 407 (OID 22524439)
-- Name: f_bu_retiros (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bu_retiros () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
BEGIN

    if ((cantidad_disponible(NEW.ret_idsitem)+OLD.ret_cantidad)<NEW.ret_cantidad) then
	RAISE EXCEPTION  ''LA CANTIDAD A RETIRAR ES MAYOR A LAS DISPONIBILIDADES'';
    END IF;
	
RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 401 (OID 22547437)
-- Name: f_au_opervehi (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_opervehi () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
BEGIN



if(int2eq(OLD.opv_est_camion,50::int2) or (int2eq(OLD.opv_est_camion,2::int2) and int2eq(NEW.opv_est_camion,2::int2)) or (int2eq(OLD.opv_est_camion,1::int2) and int2eq(NEW.opv_est_camion,1::int2))) THEN 

    if (int4ne(NEW.opv_idoper,OLD.opv_idoper)) then
	    update contene set cont_idoper=NEW.opv_idoper where cont_idopv=OLD.opv_id;
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia un la operacion ''||OLD.opv_idoper||'' por la operacion ''||NEW.opv_idoper||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(81,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_pat_chasis,OLD.opv_pat_chasis)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como chasis ''||OLD.opv_pat_chasis||'' por el chasis ''||NEW.opv_pat_chasis||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(82,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_pat_tractor,OLD.opv_pat_tractor)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como tractor ''||OLD.opv_pat_tractor||'' por el tractor ''||NEW.opv_pat_tractor||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(83,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_chofer,OLD.opv_chofer)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como chofer ''||OLD.opv_chofer||'' por el chofer ''||NEW.opv_chofer||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(84,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_pat_chasis,OLD.opv_pat_chasis)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como chasis ''||OLD.opv_pat_chasis||'' por el chasis ''||NEW.opv_pat_chasis||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(85,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_codtd,OLD.opv_codtd)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como tipo de documento ''||OLD.opv_codtd||'' por el tipo de documento ''||NEW.opv_codtd||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(86,OLD.opv_idoper,aux_texto);
        end if;

    if (int2ne(NEW.opv_est_camion,OLD.opv_est_camion)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como estado ''||OLD.opv_est_camion||'' por el estado ''||NEW.opv_est_camion||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(87,OLD.opv_idoper,aux_texto);
        end if;

    if (int4ne(NEW.opv_nro_ticket,OLD.opv_nro_ticket)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como ticket ''||OLD.opv_nro_ticket||'' por el ticket ''||NEW.opv_nro_ticket||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(88,OLD.opv_idoper,aux_texto);
        end if;

    if (varcharne(NEW.opv_pesa,OLD.opv_pesa)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia pesa ''||OLD.opv_pesa||'' por pesa ''||NEW.opv_pesa||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(89,OLD.opv_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.opv_peso_ing,OLD.opv_peso_ing)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como peso ing ''||OLD.opv_peso_ing||'' por el peso ''||NEW.opv_peso_ing||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(90,OLD.opv_idoper,aux_texto);
        end if;

    if (numeric_ne(NEW.opv_peso_egr,OLD.opv_peso_egr)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como peso egr ''||OLD.opv_peso_egr||'' por el peso ''||NEW.opv_peso_egr||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(91,OLD.opv_idoper,aux_texto);
        end if;

    if (timestamp_ne(NEW.opv_fecha_egr,OLD.opv_fecha_egr)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como fecha egr ''||OLD.opv_fecha_egr||'' por la fecha ''||NEW.opv_fecha_egr||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(92,OLD.opv_idoper,aux_texto);
        end if;

    if (timestamp_ne(NEW.opv_fecha_ing,OLD.opv_fecha_ing)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como fecha ing ''||OLD.opv_fecha_ing||'' por la fecha ''||NEW.opv_fecha_ing||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(93,OLD.opv_idoper,aux_texto);
        end if;


    if (int4ne(NEW.opv_nro_doc,OLD.opv_nro_doc)) then
	    aux_texto:=''El usuario autorizado ha modificado el vehiculo ''||OLD.opv_id ||'' de la operacion publicada ''||OLD.opv_idoper||'' que tenia como doc ''||OLD.opv_nro_doc||'' por el doc ''||NEW.opv_nro_doc||'' el dia de hoy'';
	    insert into noticias(not_tipo,not_numero,not_texto)values(94,OLD.opv_idoper,aux_texto);
        end if;

END IF;


RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 499 (OID 22560409)
-- Name: arreglo4030 (integer, integer, numeric, numeric, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo4030 (integer, integer, numeric, numeric, smallint, smallint) RETURNS integer
    AS '
    DECLARE
	usuario		ALIAS FOR $1; 
	tope		ALIAS FOR $2; 
	tarifamayor	ALIAS FOR $3; 
	tarifamenor	ALIAS FOR $4; 
	anio		ALIAS FOR $5; 
	mes		ALIAS FOR $6; 
	ret 		integer;
	cuantos		int4;
    BEGIN
    ret:=0;

    select count(*) into cuantos from almacen where alm_estado=1 and alm_idusu=usuario and alm_retiro is null;

    ret:=cuantos;

    if int4gt(cuantos,tope) then
	    update almacen set alm_tarifa=tarifamayor where alm_estado=1 and alm_idusu=usuario;    
	    update confactur set cfc_precio=tarifamayor,cfc_importe=cfc_dias*tarifamayor where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=11 and cfc_ptov=2;
	else    
	    update almacen set alm_tarifa=tarifamenor where alm_estado=1 and alm_idusu=usuario;    
	    update confactur set cfc_precio=tarifamenor,cfc_importe=cfc_dias*tarifamenor where cfc_anio=anio and cfc_mes=mes and cfc_usuario=usuario and cfc_idart=11 and cfc_ptov=2;
    end if;    
    
return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 516 (OID 22589257)
-- Name: arreglo_cantcompret (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION arreglo_cantcompret (integer, integer) RETURNS boolean
    AS '
DECLARE
operacion	ALIAS FOR $1; 	-- id de la Operacion
modo		ALIAS FOR $2; 	-- 1 arregla cantcomp
				-- 2 arregla cantret
cuantos		numeric;
registro 	RECORD;
retval 		boolean;
BEGIN

retval:=''f'';

if int4ne(operacion,0) then    
	if int4eq(modo,2) then        

		for registro in select sitem_id as x
    		    from subitem where sitem_idoper = operacion
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2eq(estadop(ret_idopera),101::int2);

			    update subitem set sitem_cantret=cuantos
				where sitem_id=registro.x;
			end loop; 

	    else

		for registro in select sitem_id as x
    		    from subitem where sitem_idoper = operacion
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2lt(estadop(ret_idopera),100::int2);

			    update subitem set sitem_cantcomp=cuantos
				where sitem_id=registro.x;
			end loop; 

retval:=''t'';

	end if;    

    else

	if int4eq(modo,2) then        

		for registro in select sitem_id as x
    		    from subitem 
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2eq(estadop(ret_idopera),101::int2);

			    update subitem set sitem_cantret=cuantos
				where sitem_id=registro.x;
			end loop; 

	    else

		for registro in select sitem_id as x
    		    from subitem 
			loop
			    cuantos:=0;
			    select sum(ret_cantidad) into cuantos from retiros 
				where ret_idsitem=registro.x 
				      and int2lt(estadop(ret_idopera),100::int2);

			    update subitem set sitem_cantcomp=cuantos
				where sitem_id=registro.x;
			end loop; 

retval:=''t'';

	end if;    


end if;    

RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 573 (OID 22771353)
-- Name: f_ai_wret2 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_wret2 () RETURNS "trigger"
    AS '
    DECLARE
    BEGIN
        update wsubitem set wsitem_cantcompw=wsitem_cantcompw+NEW.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 505 (OID 22771355)
-- Name: cantidispw (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidispw (integer) RETURNS numeric
    AS 'select wsitem_canting-wsitem_cantret-wsitem_cantcomp-wsitem_cantmala-wsitem_cantcompw from wsubitem where wsitem_id = $1;'
    LANGUAGE sql;


--
-- TOC entry 576 (OID 22771357)
-- Name: f_au_woperaciones (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_woperaciones () RETURNS "trigger"
    AS '
DECLARE
aux_texto 	text;
mal		int2;
trans 		boolean;
notid		int4;
BEGIN

if(int2ne(NEW.wop_estado,OLD.wop_estado)) THEN 
    update wret2 set wret2_estado=NEW.wop_estado where wret2_idopera=NEW.wop_id;
end if;

if(int2eq(NEW.wop_estado,999::int2)) THEN 
    delete from wret2 where wret2_idopera=NEW.wop_id;
end if;


RETURN NEW;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 575 (OID 22771367)
-- Name: f_au_wret2 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_wret2 () RETURNS "trigger"
    AS '
    DECLARE
	aux_texto 	text;
    BEGIN

	if(numeric_ne(NEW.wret2_cantidad,OLD.wret2_cantidad)) then
	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw + NEW.wret2_cantidad - OLD.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
	end if;

	if(int4ne(NEW.wret2_idsitem,OLD.wret2_idsitem)) then
    	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw - OLD.wret2_cantidad where wsitem_id=OLD.wret2_idsitem;
    	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw + NEW.wret2_cantidad where wsitem_id=NEW.wret2_idsitem;
	end if;

    RETURN NEW;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 574 (OID 22771368)
-- Name: f_ad_wret2 (); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_wret2 () RETURNS "trigger"
    AS '
    DECLARE
    estado 		int2;
    dato 		varchar;
    aux_texto 		text;
    BEGIN

        update wsubitem set wsitem_cantcompw= wsitem_cantcompw - OLD.wret2_cantidad where wsitem_id=OLD.wret2_idsitem;

    RETURN OLD;
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 394 (OID 22777602)
-- Name: simbunimedwsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedwsitem (integer) RETURNS character varying
    AS 'select uni_simbolo from unimed where uni_codigo= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 517 (OID 22777603)
-- Name: simbunimedwsitem2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION simbunimedwsitem2 (integer) RETURNS character varying
    AS 'select a.uni_simbolo from unimed a,wsubitem b where a.uni_codigo=b.wsitem_unimed and b.wsitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 552 (OID 23081798)
-- Name: gtuttiw (integer, character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION gtuttiw (integer, character varying) RETURNS boolean
    AS '
declare
opid		 alias for $1;
compbte	 	 alias for $2;
ret 		 boolean;
registro	 record;
disponible	 numeric;
primera		 int4;
directo		 int4;
haycuantos	 int2;
elmayor		 int2;
indirecto	 int4;
begin
primera:=-1;

    select wop_directo,wop_indirecto into directo,indirecto from woperaciones where wop_id=opid;

    select count(*) into haycuantos from wret2 where wret2_idopera=opid;
    if(int2eq(haycuantos,0::int2)) then
        haycuantos:=0;
    end if;

    select max(wret2_item) into elmayor from wret2 where wret2_idopera=opid;
    if(int2lt(haycuantos,elmayor)) then
        haycuantos:=elmayor;
    end if;

for registro in select 
     * from wsubitem where wsitem_directo=directo and wsitem_indirecto=indirecto and varchareq(wsitem_compbte,compbte) 
    loop
	disponible:=registro.wsitem_canting-registro.wsitem_cantcomp-registro.wsitem_cantcompw-registro.wsitem_cantret-registro.wsitem_cantmala;
	if(disponible>0) then 

	    haycuantos:=haycuantos+1;
	    insert into wret2 (wret2_item,wret2_idopera,wret2_idsitem,wret2_cantidad) values (haycuantos,opid,registro.wsitem_id,disponible);
	end if;
    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 553 (OID 23081799)
-- Name: grabonotiweb (integer, integer, integer, character varying, text); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION grabonotiweb (integer, integer, integer, character varying, text) RETURNS boolean
    AS '
DECLARE
directo		ALIAS FOR $1; 	-- id del directo si es cero a todos
operador	ALIAS FOR $2;	-- Operador de carga
prioridad	ALIAS FOR $3;	 
titulo		ALIAS FOR $4;	 
texto		ALIAS FOR $5; 	-- texto
registro 	RECORD;
retval 		boolean;
BEGIN
retval:=''t'';		

if directo=0 then
	for registro in select usu_codigo as x
	    from usuarios where usu_tipusu=1 and usu_codigo>3
		loop
		    insert into wnoticias (wnot_directo,wnot_operadcar,wnot_prioridad,wnot_titulo,wnot_texto) values (registro.x,operador,prioridad,titulo::varchar,texto::text);
		end loop; 
    else
	insert into wnoticias (wnot_directo,wnot_operadcar,wnot_prioridad,wnot_titulo,wnot_texto) values (directo,operador,prioridad,titulo::varchar,texto::text);

end if;

RETURN retval;
END;'
    LANGUAGE plpgsql;


--
-- TOC entry 176 (OID 23122843)
-- Name: woperaciones; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE woperaciones (
    wop_id serial NOT NULL,
    wop_tipoper integer NOT NULL,
    wop_directo integer NOT NULL,
    wop_indirecto integer NOT NULL,
    wop_consig integer,
    wop_fechain date DEFAULT 'today()',
    wop_estado smallint DEFAULT 11 NOT NULL,
    wop_importe numeric(15,2) DEFAULT 0,
    wop_impdolar numeric(15,2) DEFAULT 0,
    wop_destino smallint,
    wop_proced smallint,
    wop_fecreg timestamp without time zone DEFAULT 'now()' NOT NULL,
    wop_operador integer,
    wop_auxo_fact character varying(90),
    wop_deposito smallint,
    wop_clasemer character varying(90),
    wop_transito character(16) DEFAULT 'DATO DESCONOCIDO',
    wop_compbte character(16),
    wop_tipemb smallint,
    wop_volumen numeric(15,5) DEFAULT 0,
    wop_peso numeric(15,5) DEFAULT 0,
    wop_bultos integer DEFAULT 0,
    wop_moneda smallint,
    wop_nomconsig character varying(90),
    wop_nrocuitcsg character varying(13),
    wop_contacto character varying(90),
    wop_telefono character varying(90),
    wop_tiprod integer,
    wop_fechaest date DEFAULT 'today()'
);


--
-- TOC entry 177 (OID 23122843)
-- Name: woperaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE woperaciones FROM PUBLIC;
GRANT ALL ON TABLE woperaciones TO nobody;


--
-- TOC entry 178 (OID 23122867)
-- Name: wret2; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE wret2 (
    wret2_id serial NOT NULL,
    wret2_idopera integer NOT NULL,
    wret2_idsitem integer NOT NULL,
    wret2_item smallint DEFAULT 1 NOT NULL,
    wret2_sitem smallint DEFAULT 0 NOT NULL,
    wret2_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    wret2_idsitemc integer,
    wret2_estado smallint DEFAULT 1 NOT NULL
);


--
-- TOC entry 179 (OID 23122867)
-- Name: wret2; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wret2 FROM PUBLIC;
GRANT ALL ON TABLE wret2 TO nobody;


--
-- TOC entry 180 (OID 23122889)
-- Name: wnoticias; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE wnoticias (
    wnot_id serial NOT NULL,
    wnot_estado smallint DEFAULT 1 NOT NULL,
    wnot_tipoper integer DEFAULT 1 NOT NULL,
    wnot_directo integer DEFAULT 1 NOT NULL,
    wnot_indirecto integer DEFAULT 1 NOT NULL,
    wnot_feclect timestamp without time zone,
    wnot_operadlec integer,
    wnot_operadcar integer,
    wnot_prioridad integer DEFAULT 10,
    wnot_fecreg timestamp without time zone DEFAULT 'now()' NOT NULL,
    wnot_texto text,
    wnot_titulo character varying(80)
);


--
-- TOC entry 181 (OID 23122889)
-- Name: wnoticias; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wnoticias FROM PUBLIC;
GRANT ALL ON TABLE wnoticias TO nobody;


--
-- TOC entry 182 (OID 23122904)
-- Name: wleyenrexp; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE wleyenrexp (
    wleyr_id serial NOT NULL,
    wleyr_idoper integer NOT NULL,
    wleyr_nro smallint,
    wleyr_leyenda character varying(180)
);


--
-- TOC entry 183 (OID 23122904)
-- Name: wleyenrexp; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wleyenrexp FROM PUBLIC;
GRANT ALL ON TABLE wleyenrexp TO nobody;


--
-- TOC entry 557 (OID 23122918)
-- Name: pruebaindi (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pruebaindi (integer, integer) RETURNS boolean
    AS 'select ''t''::boolean as temporal from contratos where contr_locador = $1 and contr_locatario = $2 and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;'
    LANGUAGE sql;


--
-- TOC entry 527 (OID 23122919)
-- Name: cantidisponib (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantidisponib (integer) RETURNS numeric
    AS 'select sitem_canting-sitem_cantret-sitem_cantcomp-sitem_cantmala from subitem where sitem_id = $1;'
    LANGUAGE sql;


--
-- TOC entry 540 (OID 23122920)
-- Name: transitodeop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transitodeop (integer) RETURNS character varying
    AS 'select op_comptrans from operaciones where op_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 497 (OID 23122921)
-- Name: monedadeitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION monedadeitem (integer) RETURNS smallint
    AS 'select item_moneda from item where item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 545 (OID 23122922)
-- Name: itemdeitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION itemdeitem (integer) RETURNS smallint
    AS 'select item_item from item where item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 555 (OID 23122923)
-- Name: unimeddeitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION unimeddeitem (integer) RETURNS smallint
    AS 'select item_unimed from item where item_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 558 (OID 23122924)
-- Name: codigodeartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codigodeartic (integer) RETURNS character varying
    AS 'select artic_codigo from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 565 (OID 23122925)
-- Name: marcadeartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION marcadeartic (integer) RETURNS character varying
    AS 'select artic_marca from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 566 (OID 23122926)
-- Name: modelodeartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION modelodeartic (integer) RETURNS character varying
    AS 'select artic_modelo from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 567 (OID 23122927)
-- Name: descripdeartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descripdeartic (integer) RETURNS character varying
    AS 'select artic_descrip from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 568 (OID 23122928)
-- Name: posadeartic (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION posadeartic (integer) RETURNS character varying
    AS 'select artic_posa from articu where artic_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 554 (OID 23122929)
-- Name: sepuedeimportar (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION sepuedeimportar (integer) RETURNS boolean
    AS '
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
begin

ret:=''t'';

for registro in select 
    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
    from wret2 where wret2_idopera=wopid 
    loop
	if(booleq(ret,''t'')) then
	    if(registro.x < registro.y) then
		ret:=''f'';
	    end if;
	end if;
    end loop; 

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 556 (OID 23122931)
-- Name: indiconcontr (integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indiconcontr (integer, integer) RETURNS boolean
    AS '
declare
locador		 alias for $1;
locatario	 alias for $2;
temporal	 integer;
ret 		 boolean;
begin
ret:=''f'';

select contr_locatario into temporal from contratos where contr_locador=locador and contr_locatario =locatario and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;

if found then
    ret:=''t'';
end if;

return ret;

end;'
    LANGUAGE plpgsql;


--
-- TOC entry 550 (OID 23122944)
-- Name: actualizoweb (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION actualizoweb (integer) RETURNS boolean
    AS '
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
begin


update wsubitem set wsitem_estado=7;

for registro in select 
     * from subitem where sitem_estado=1 and estadop(sitem_idoper)=101
    loop

	select cantidispw(wsitem_id),wsitem_cantcompw into disponible,compromweb  from wsubitem where wsitem_id=registro.sitem_id;
	if not found then
		insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
		    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),0);

		for regist in select 
		    * from retiros where ret_idsitem=registro.sitem_id
		    loop
			insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
			    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
		    end loop; 

	    else

		dispon:=registro.sitem_canting-registro.sitem_cantcomp-registro.sitem_cantret-registro.sitem_cantmala;

		if(compromweb<=dispon) then 

			delete from wretiros where wret_idsitem=registro.sitem_id;
			delete from wsubitem where wsitem_id=registro.sitem_id;

			insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
			    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),compromweb);

			for regist in select 
			    * from retiros where ret_idsitem=registro.sitem_id
			    loop
				insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			    end loop; 
		
		    else

			delete from wretiros where wret_idsitem=registro.sitem_id;
			delete from wsubitem where wsitem_id=registro.sitem_id;

			insert into wsubitem (wsitem_id,wsitem_iditem,wsitem_idoper,wsitem_codigo,wsitem_artic,wsitem_canting,wsitem_cantret,wsitem_cantcomp,wsitem_cantmala,wsitem_importe,wsitem_imp_dolar,wsitem_volumen,wsitem_peso,wsitem_tipemb,wsitem_deposito,wsitem_idacta,wsitem_estado,wsitem_directo,wsitem_indirecto,wsitem_compbte,wsitem_consig,wsitem_item,wsitem_moneda,wsitem_unimed,wsitem_comptrans,wsitem_tipoper,wsitem_nrotaldir,wsitem_codart,wsitem_marca,wsitem_modelo,wsitem_descrip,wsitem_posa,wsitem_cantcompw) 
			    values (registro.sitem_id,registro.sitem_iditem,registro.sitem_idoper,registro.sitem_codigo,registro.sitem_artic,registro.sitem_canting,registro.sitem_cantret,registro.sitem_cantcomp,registro.sitem_cantmala,registro.sitem_importe,registro.sitem_imp_dolar,registro.sitem_volumen,registro.sitem_peso,registro.sitem_tipemb,registro.sitem_deposito,registro.sitem_idacta,registro.sitem_estado,registro.sitem_directo,registro.sitem_indirecto,registro.sitem_compbte,consigdeop(registro.sitem_idoper),itemdeitem(registro.sitem_iditem),monedadeitem(registro.sitem_iditem),unimeddeitem(registro.sitem_iditem),transitodeop(registro.sitem_idoper),tipoperdeop(registro.sitem_idoper),nrotaldiroper(registro.sitem_idoper),codigodeartic(registro.sitem_artic),marcadeartic(registro.sitem_artic),modelodeartic(registro.sitem_artic),descripdeartic(registro.sitem_artic),posadeartic(registro.sitem_artic),0);

			for regist in select 
			    * from retiros where ret_idsitem=registro.sitem_id
			    loop
				insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				    values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			    end loop; 

			--grabo temporalweb

			llevo:=0;
			elultimo:=0;

			for registw2 in select 
    			    * from wret2 where wret2_idsitem=registro.sitem_id and wret2_estado<50
    			    loop
				elultimo:=registw2.wret2_cantidad;
				llevo:=llevo+registw2.wret2_cantidad;
				if(llevo<=dispon) then
					update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;
				    else
					if((dispon+registw2.wret2_cantidad-llevo) > 0) then
						insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registro.sitem_id,dispon,compromweb,registw2.wret2_id,dispon+registw2.wret2_cantidad-llevo);
					    else
						insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registro.sitem_id,dispon,compromweb,registw2.wret2_id,-1);
					end if;
				end if;
			    end loop; 
		end if;
	end if;
    end loop; 


delete from wsubitem where wsitem_estado=7;

ret:=''t'';

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 579 (OID 23122945)
-- Name: reparoweb (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION reparoweb (integer) RETURNS boolean
    AS '
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
aux_texto	 text;
indirecto	 integer;
operacion	 integer;

begin


lock wret2 in access exclusive mode;

drop trigger au_wret2 ON wret2;


for registro in select 
     * from temporalweb
loop


    if(registro.wtmp_valor>0) then
	    update wret2 set wret2_cantidad=registro.wtmp_valor where wret2_id=registro.wtmp_idret;
--	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw-registro.wtmp_compweb+registro.wtmp_valor where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw+registro.wtmp_valor where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    aux_texto:=''SE LE COMUNICA QUE SE HA MODIFICADO LA REEXPEDICION NUMERO:  <b>''||idwopdewret2(registro.wtmp_idret)||''</b> QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO <b>''||nomusu(indirectodewret2(registro.wtmp_idret)) ||''</b>.  EL MOTIVO DE ESTA MODIFICACION RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN AL ARTICULO:  <b>''||articulodewret2(registro.wtmp_idret)||''</b> QUE TAMBIEN FUERA COMPROMETIDO POR USTED.  VERIQUE LA CANTIDAD A RETIRAR DE ESE ARTICULO Y FINALIZE NUEVAMENTE LA OPERACION !!!!!!!'';
	    ret:=grabonotiweb(directodewret2(registro.wtmp_idret),5,10,''ARTICULOS PARCIALMENTE COMPROMETIDOS'',aux_texto);
	    update woperaciones set wop_estado=11 where wop_id=idwopdewret2(registro.wtmp_idret);

	else
	    aux_texto:=''SE LE COMUNICA QUE SE HA ELIMINADO DE LA REEXPEDICION NUMERO:  <b>''||idwopdewret2(registro.wtmp_idret)||''</b> QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO <b>''||nomusu(indirectodewret2(registro.wtmp_idret)) ||''</b>.   EL ARTICULO:  <b>''||articulodewret2(registro.wtmp_idret)||'' </b> QUE TAMBIEN FUERA COMPROMETIDO POR USTED.  EL MOTIVO RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN DICHO ARTICULO VERIFIQUE NUEVAMENTE LA OPERACION !!!!!!!'';
	    ret:=grabonotiweb(directodewret2(registro.wtmp_idret),5,10,''ITEMS DE REEXPEDICIONES ELIMINADOS'',aux_texto);
--	    update wsubitem set wsitem_cantcompw=wsitem_cantcompw-registro.wtmp_compweb where wsitem_id=idsitemdewret2(registro.wtmp_idret);
	    delete from wret2 where wret2_id=registro.wtmp_idret;
	    update woperaciones set wop_estado=11 where wop_id=idwopdewret2(registro.wtmp_idret);

    end if;
end loop; 

CREATE TRIGGER au_wret2 AFTER UPDATE ON wret2 FOR EACH ROW EXECUTE PROCEDURE f_au_wret2();
			
 delete from temporalweb;
ret:=''t'';
return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 580 (OID 23538838)
-- Name: actualizowebnew (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION actualizowebnew (integer) RETURNS boolean
    AS '
declare
modo		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
begin


for registw2 in select 
    * from wret2 where wret2_estado<50
    loop

	elultimo:=0;
	dispon:=0;
	dispon:=cantidispw(registw2.wret2_idsitem);
	elultimo:=registw2.wret2_cantidad;

	if(elultimo<=dispon) then
		update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;
	    else
		if(dispon <= 0) then
			insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,-1);
		    else
			insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,dispon);
		end if;
	end if;
    end loop; 

ret:=''t'';

return ret;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 569 (OID 23678101)
-- Name: directodewsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewsitem (integer) RETURNS integer
    AS 'select wsitem_directo from wsubitem where wsitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 570 (OID 23678104)
-- Name: directodewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewret2 (integer) RETURNS integer
    AS 'select a.wsitem_directo from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 571 (OID 23678107)
-- Name: indirectodewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodewret2 (integer) RETURNS integer
    AS 'select a.wsitem_indirecto from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 572 (OID 23678111)
-- Name: idwopdewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idwopdewret2 (integer) RETURNS integer
    AS 'select wret2_idopera from wret2 where wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 551 (OID 23678114)
-- Name: articulodewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION articulodewret2 (integer) RETURNS character varying
    AS 'select a.wsitem_codart from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 577 (OID 25078206)
-- Name: idsitemdewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION idsitemdewret2 (integer) RETURNS integer
    AS 'select a.wsitem_id from wsubitem a, wret2 b where a.wsitem_id=b.wret2_idsitem and b.wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 563 (OID 25223227)
-- Name: transfreexpdeweb (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transfreexpdeweb (integer) RETURNS integer
    AS '
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registleye	 record;
registwr	 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
idop		 integer;
primera		 integer;
entre		 integer;
elestado	 smallint;
aux_texto	 text;
aux_texto1	 text;
aux_texto2	 text;
aux_texto3	 text;
begin

ret:=''t'';
entre:=0;
idop:=0;

select wop_estado into elestado from woperaciones where wop_id=wopid;

if found then
    if int2eq(elestado,1::int2) then
	for registro in select 
	    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
	    from wret2 where wret2_idopera=wopid 
	    loop
		entre:=1;
		if(booleq(ret,''t'')) then
		    if(registro.x < registro.y) then
			ret:=''f'';
		    end if;
		end if;
	    end loop; 


    if int4eq(entre,0) then
	ret:=''f'';
    end if;


	if(booleq(ret,''t'')) then

		insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo) from woperaciones where wop_id = wopid;

		select op_id into idop from operaciones where op_idopw=wopid;

		for regist in select 
		    * from wret2 where wret2_idopera=wopid
		loop
		    insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad) values (idop,regist.wret2_idsitem,regist.wret2_item,regist.wret2_sitem,regist.wret2_cantidad);
		    update wsubitem set wsitem_cantcomp=wsitem_cantcomp+regist.wret2_cantidad, wsitem_cantcompw=wsitem_cantcompw-regist.wret2_cantidad where wsitem_id=regist.wret2_idsitem;
		end loop; 

		for registleye in select 
		    * from wleyenrexp where wleyr_idoper=wopid
		loop
		    insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
		end loop; 

		update woperaciones set wop_estado=50 where wop_id=wopid;

		for registwr in select 
		    * from retiros where ret_idopera=idop
		loop
		    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir,wret_estado) 
			values (registwr.ret_id,registwr.ret_idopera,registwr.ret_idsitem,registwr.ret_item,registwr.ret_sitem,registwr.ret_cantidad,registwr.ret_idsitemc,compbteoper(registwr.ret_idopera),tipoperdeop(registwr.ret_idopera),nrotaldiroper(registwr.ret_idopera),1::int2);
		end loop; 


	    else


		for registro in select 
		    * from wret2 where wret2_idopera=wopid 
		loop

		    delete from wretiros where wret_idsitem=registro.wret2_idsitem; 

		    for regist in select 
			* from retiros where ret_idsitem=registro.wret2_idsitem
			loop
			    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir) 
				values (regist.ret_id,regist.ret_idopera,regist.ret_idsitem,regist.ret_item,regist.ret_sitem,regist.ret_cantidad,regist.ret_idsitemc,compbteoper(regist.ret_idopera),tipoperdeop(regist.ret_idopera),nrotaldiroper(regist.ret_idopera));
			end loop; 


		    if(registro.wret2_cantidad<=cantidisponib(registro.wret2_idsitem)) then

			    update wsubitem set wsitem_cantcompw=cantcompwdeidwsitem(registro.wret2_idsitem),wsitem_canting=cantingdeidsitem(registro.wret2_idsitem),wsitem_cantcomp=cantcompdeidsitem(registro.wret2_idsitem),wsitem_cantret=cantretdeidsitem(registro.wret2_idsitem),wsitem_cantmala=cantmaladeidsitem(registro.wret2_idsitem) where wsitem_id=registro.wret2_idsitem;

			else

			    aux_texto2:=''<br> SE HA ELIMINADO EL ARTICULO  <B> ''||codartdewret2(registro.wret2_id)||''</B> EL CUAL USTED HABIA COMPROMETIDO POR UNA CANTIDAD DE : <B>''||registro.wret2_cantidad||''</B> '';
			    insert into temporalweb (wtmp_idwop,wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (wopid,registro.wret2_idsitem,cantidisponib(registro.wret2_idsitem),registro.wret2_cantidad,registro.wret2_id,-1);

		    end if;

		end loop; 

		aux_texto:=''SE LE COMUNICA QUE NO SE HA PODIDO PROCESAR LA REEXPEDICION NUMERO:  <b>''||wopid||'' </b>QUE USTED HA CARGADO EN ESTE SISTEMA OPORTUNAMENTE RELACIONADA AL USUARIO INDIRECTO  <b>''||nomusu(indirectodewop(wopid))||'' </b>.  EL MOTIVO DE ESTA MODIFICACION RESPONDE AL PROCESAMIENTO POR PARTE DE OPERADORES DE LA CONCESIONARIA DE REEXPEDICIONES QUE AFECTAN AL/LOS SIGUIENTES ARTICULOS POR USTED COMPROMETIDOS ''||aux_texto2||''<BR>   VERIQUE NUEVAMENTE LA OPERACION Y FINALICELA !!!!!!! '';
		ret:=grabonotiweb(directodewop(wopid),5,10,''ERROR EN LA IMPORTACION DE REEXPEDICIONES'',aux_texto);
		update woperaciones set wop_estado=11 where wop_id=wopid;



		for registro in select 
    		    * from temporalweb where wtmp_idwop=wopid
		    loop
			update wsubitem set wsitem_canting=cantingdeidsitem(registro.wtmp_idsitem),wsitem_cantcomp=cantcompdeidsitem(registro.wtmp_idsitem),wsitem_cantret=cantretdeidsitem(registro.wtmp_idsitem),wsitem_cantmala=cantmaladeidsitem(registro.wtmp_idsitem) where wsitem_id=registro.wtmp_idsitem;
			delete from wret2 where wret2_id=registro.wtmp_idret;
		    end loop; 
			
		delete from temporalweb where wtmp_idwop=wopid;

	end if;
    end if;
end if;
return idop;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 546 (OID 25223228)
-- Name: indirectodewop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indirectodewop (integer) RETURNS integer
    AS 'select wop_indirecto from woperaciones where wop_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 547 (OID 25223229)
-- Name: directodewop (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION directodewop (integer) RETURNS integer
    AS 'select wop_directo from woperaciones where wop_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 548 (OID 25224101)
-- Name: cantreweb (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantreweb (integer) RETURNS numeric
    AS 'select sum(wret2_cantidad) from wret2 where wret2_estado<50 and wret2_idsitem= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 578 (OID 25224499)
-- Name: transfieroweb (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION transfieroweb (integer) RETURNS integer
    AS '
declare
wopid		 alias for $1;
ret 		 boolean;
registro	 record;
regist		 record;
registleye	 record;
registwr	 record;
registw2	 record;
disponible	 numeric;
dispon		 numeric;
compromweb	 numeric;
llevo		 numeric;
elultimo	 numeric;
idop		 integer;
primera		 integer;
elestado	 smallint;
begin

ret:=''t'';
idop:=0;

select wop_estado into elestado from woperaciones where wop_id=wopid;

if found then
    if int2eq(elestado,1::int2) then

	for registro in select 
	    cantidisponib(wret2_idsitem) as x, wret2_cantidad as y
	    from wret2 where wret2_idopera=wopid 
	    loop
		if(booleq(ret,''t'')) then
		    if(registro.x < registro.y) then
			ret:=''f'';
		    end if;
		end if;
	    end loop; 


	if(booleq(ret,''t'')) then

		insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo) from woperaciones where wop_id = wopid;

		select op_id into idop from operaciones where op_idopw=wopid;

		for regist in select 
		    * from wret2 where wret2_idopera=wopid
		loop
		    insert into retiros (ret_idopera,ret_idsitem,ret_item,ret_sitem,ret_cantidad) values (idop,regist.wret2_idsitem,regist.wret2_item,regist.wret2_sitem,regist.wret2_cantidad);
		    update wsubitem set wsitem_cantcomp=wsitem_cantcomp+regist.wret2_cantidad, wsitem_cantcompw=wsitem_cantcompw-regist.wret2_cantidad where wsitem_id=regist.wret2_idsitem;
		end loop; 

		for registleye in select 
		    * from wleyenrexp where wleyr_idoper=wopid
		loop
		    insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
		end loop; 

		update woperaciones set wop_estado=50 where wop_id=wopid;

		for registwr in select 
		    * from retiros where ret_idopera=idop
		loop
		    insert into wretiros (wret_id,wret_idopera,wret_idsitem,wret_item,wret_sitem,wret_cantidad,wret_idsitemc,wret_compbte,wret_tipoper,wret_nrotaldir,wret_estado) 
			values (registwr.ret_id,registwr.ret_idopera,registwr.ret_idsitem,registwr.ret_item,registwr.ret_sitem,registwr.ret_cantidad,registwr.ret_idsitemc,compbteoper(registwr.ret_idopera),tipoperdeop(registwr.ret_idopera),nrotaldiroper(registwr.ret_idopera),1::int2);
		end loop; 


	    else


		for registw2 in select 
		    * from wret2 where wret2_idopera=wopid 
	        loop

		primera:=0;
		elultimo:=0;
		dispon:=0;
		dispon:=cantidisponib(registw2.wret2_idsitem);
		elultimo:=registw2.wret2_cantidad;

		if(elultimo<=dispon) then
			if(int4eq(primera,0)) then
			    insert into operaciones(op_directo,op_indirecto,op_tipoper,op_idopw,op_operador,op_nrotalzon,op_nrotaldir) select wop_directo,wop_indirecto,wop_tipoper,wop_id,wop_operador,val_talon(wop_tipoper,1),val_talon(wop_tipoper,wop_directo) from woperaciones where wop_id = wopid;
			    select op_id into idop from operaciones where op_idopw=wopid;
			    for registleye in select 
				* from wleyenrexp where wleyr_idoper=wopid
			    loop
				insert into leyenrexp (leyr_idoper,leyr_nro,leyr_leyenda) values (idop,registleye.wleyr_nro,registleye.wleyr_leyenda);
			    end loop; 
			    primera:=1;
			end if;

			update wsubitem set wsitem_cantcompw=wsitem_cantcompw + registw2.wret2_cantidad where wsitem_id=registw2.wret2_idsitem;

		    else
			if(dispon <= 0) then
				insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,-1);
    			    else
				insert into temporalweb (wtmp_idsitem,wtmp_disponib,wtmp_compweb,wtmp_idret,wtmp_valor) values (registw2.wret2_idsitem,dispon,elultimo,registw2.wret2_id,dispon);
			end if;
		end if;
		end loop; 

		ret:=reparoweb(1);
	end if;
    end if;
end if;
return idop;
end;'
    LANGUAGE plpgsql;


--
-- TOC entry 549 (OID 25224559)
-- Name: cantcompwdeidwsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcompwdeidwsitem (integer) RETURNS numeric
    AS 'select wsitem_cantcompw from wsubitem where wsitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 539 (OID 25224569)
-- Name: codartdewret2 (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION codartdewret2 (integer) RETURNS character varying
    AS 'select codigodeartic(a.sitem_artic) from subitem a, wret2 b where a.sitem_id=b.wret2_idsitem and b.wret2_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 559 (OID 25224607)
-- Name: cantcompdeidsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantcompdeidsitem (integer) RETURNS numeric
    AS 'select sitem_cantcomp from subitem where sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 560 (OID 25224608)
-- Name: cantretdeidsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantretdeidsitem (integer) RETURNS numeric
    AS 'select sitem_cantret from subitem where sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 561 (OID 25224609)
-- Name: cantmaladeidsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantmaladeidsitem (integer) RETURNS numeric
    AS 'select sitem_cantmala from subitem where sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 562 (OID 25224610)
-- Name: cantingdeidsitem (integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cantingdeidsitem (integer) RETURNS numeric
    AS 'select sitem_canting from subitem where sitem_id= $1 ;'
    LANGUAGE sql;


--
-- TOC entry 564 (OID 25642500)
-- Name: elimino_wop_vacias (smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elimino_wop_vacias (smallint) RETURNS boolean
    AS '
    DECLARE
	estado		ALIAS FOR $1; 
	ret 		boolean;
	operacion	int4;
	registro 	RECORD;
    BEGIN
    ret:=''f'';

    for registro in select wop_id as x
    	    from woperaciones where wop_estado in (1,11) and wop_tipoper>100
		loop

		    select wret2_id into operacion from wret2 where wret2_idopera=registro.x;
		    if not found then
			ret:=''t'';
			update woperaciones set wop_bultos=-1 where wop_id=registro.x ;
		    end if;		
		end loop; 
    
    update woperaciones set wop_estado=999 where wop_bultos=-1 ;


return ret;
	
    END;'
    LANGUAGE plpgsql;


--
-- TOC entry 184 (OID 25642503)
-- Name: temporalweb; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE temporalweb (
    wtmp_id serial NOT NULL,
    wtmp_idsitem integer NOT NULL,
    wtmp_idret integer NOT NULL,
    wtmp_valor numeric(15,5) DEFAULT 0,
    wtmp_disponib numeric(15,5) DEFAULT 0,
    wtmp_compweb numeric(15,5) DEFAULT 0,
    wtmp_idwop integer
);


--
-- TOC entry 185 (OID 25642503)
-- Name: temporalweb; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE temporalweb FROM PUBLIC;
GRANT ALL ON TABLE temporalweb TO nobody;


--
-- TOC entry 186 (OID 26069207)
-- Name: wsubitem; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE wsubitem (
    wsitem_id integer NOT NULL,
    wsitem_iditem integer NOT NULL,
    wsitem_idoper integer,
    wsitem_codigo smallint DEFAULT 0 NOT NULL,
    wsitem_artic integer,
    wsitem_canting numeric(15,5) DEFAULT 0 NOT NULL,
    wsitem_cantret numeric(15,5) DEFAULT 0,
    wsitem_cantcomp numeric(15,5) DEFAULT 0,
    wsitem_cantmala numeric(15,5) DEFAULT 0,
    wsitem_importe numeric(15,2) DEFAULT 0 NOT NULL,
    wsitem_imp_dolar numeric(15,2) DEFAULT 0,
    wsitem_volumen numeric(15,5) DEFAULT 0,
    wsitem_peso numeric(15,5) DEFAULT 0,
    wsitem_tipemb smallint,
    wsitem_deposito smallint,
    wsitem_idacta integer,
    wsitem_estado integer DEFAULT 1,
    wsitem_directo integer NOT NULL,
    wsitem_indirecto integer NOT NULL,
    wsitem_consig integer,
    wsitem_compbte character varying(16),
    wsitem_item smallint DEFAULT 0 NOT NULL,
    wsitem_moneda smallint,
    wsitem_unimed smallint,
    wsitem_comptrans character(16) DEFAULT 'DATO DESCONOCIDO',
    wsitem_tipoper integer,
    wsitem_nrotaldir integer NOT NULL,
    wsitem_codart character varying(40) NOT NULL,
    wsitem_marca character varying(40),
    wsitem_modelo character varying(40),
    wsitem_descrip character varying(40),
    wsitem_posa character varying(15),
    wsitem_cantcompw numeric(15,5) DEFAULT 0
);


--
-- TOC entry 187 (OID 26069207)
-- Name: wsubitem; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wsubitem FROM PUBLIC;
GRANT ALL ON TABLE wsubitem TO nobody;


--
-- TOC entry 188 (OID 26069237)
-- Name: wretiros; Type: TABLE; Schema: public; Owner: zona
--

CREATE TABLE wretiros (
    wret_id serial NOT NULL,
    wret_idopera integer NOT NULL,
    wret_idsitem integer NOT NULL,
    wret_item smallint DEFAULT 1 NOT NULL,
    wret_sitem smallint DEFAULT 0 NOT NULL,
    wret_cantidad numeric(15,5) DEFAULT 0 NOT NULL,
    wret_idsitemc integer,
    wret_compbte character(16) DEFAULT 'DATO DESCONOCIDO',
    wret_tipoper integer,
    wret_nrotaldir integer NOT NULL,
    wret_fecha date DEFAULT 'today()',
    wret_estado smallint DEFAULT 1
);


--
-- TOC entry 189 (OID 26069237)
-- Name: wretiros; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE wretiros FROM PUBLIC;
GRANT ALL ON TABLE wretiros TO nobody;


--
-- TOC entry 190 (OID 19352170)
-- Name: idx_usuarios_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_usuarios_1 ON usuarios USING btree (usu_nrocuit);


--
-- TOC entry 191 (OID 19352171)
-- Name: idx_usuarios_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_usuarios_2 ON usuarios USING btree (usu_tipusu, usu_codigo);


--
-- TOC entry 192 (OID 19352172)
-- Name: idx_usuarios_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_usuarios_3 ON usuarios USING btree (usu_estado, usu_tipusu, usu_codigo);


--
-- TOC entry 195 (OID 19352173)
-- Name: xpktelefon; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX xpktelefon ON telefon USING btree (tel_orden);


--
-- TOC entry 208 (OID 19352174)
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_niv1, cbl_niv2, cbl_niv3, cbl_niv4, cbl_niv5, cbl_codigo);


--
-- TOC entry 214 (OID 19352175)
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_tipoper, art_codigo);


--
-- TOC entry 228 (OID 19352177)
-- Name: idx_contratos_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_contratos_1 ON contratos USING btree (contr_locador, contr_id);


--
-- TOC entry 231 (OID 19352178)
-- Name: embalaje; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX embalaje ON embalajes USING btree (emb_codigo);


--
-- TOC entry 235 (OID 19352179)
-- Name: idx_item_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_item_1 ON item USING btree (item_idoper, item_item);


--
-- TOC entry 244 (OID 19352180)
-- Name: xpkmercaestad; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX xpkmercaestad ON mercaestad USING btree (mestad_codigo);


--
-- TOC entry 245 (OID 19352181)
-- Name: idx_opervehi_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_opervehi_1 ON opervehi USING btree (opv_idoper);


--
-- TOC entry 246 (OID 19352182)
-- Name: idx_opervehi_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_opervehi_2 ON opervehi USING btree (opv_est_camion, opv_id);


--
-- TOC entry 253 (OID 19352183)
-- Name: xpkoperacion; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX xpkoperacion ON operaciones USING btree (op_id);


--
-- TOC entry 249 (OID 19352184)
-- Name: idx_operaciones_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_operaciones_2 ON operaciones USING btree (op_directo, op_consig);


--
-- TOC entry 248 (OID 19352185)
-- Name: idx_operaciones_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_operaciones_1 ON operaciones USING btree (op_compbte);


--
-- TOC entry 266 (OID 19352186)
-- Name: xpkdesdes; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX xpkdesdes ON subitem USING btree (sitem_id);


--
-- TOC entry 256 (OID 19352187)
-- Name: idx_subitem_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_subitem_1 ON subitem USING btree (sitem_idoper, sitem_id);


--
-- TOC entry 257 (OID 19352188)
-- Name: idx_subitem_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_2 ON subitem USING btree (sitem_estado, sitem_id);


--
-- TOC entry 258 (OID 19352189)
-- Name: idx_subitem_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_3 ON subitem USING btree (sitem_estado, sitem_directo, sitem_indirecto, sitem_compbte, sitem_artic);


--
-- TOC entry 267 (OID 19352190)
-- Name: subt_contrato; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX subt_contrato ON subtcontrat USING btree (subt_idtipc, subt_codigo);


--
-- TOC entry 270 (OID 19352191)
-- Name: xpktipmovim; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX xpktipmovim ON tipoper USING btree (top_codigo);


--
-- TOC entry 272 (OID 19352192)
-- Name: tip_contrato; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX tip_contrato ON tipcontrat USING btree (tipc_codigo);


--
-- TOC entry 277 (OID 19352193)
-- Name: idx_consig_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_consig_1 ON consig USING btree (csg_nrocuit);


--
-- TOC entry 283 (OID 19352194)
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emit_comprob, emit_numero);


--
-- TOC entry 284 (OID 19352195)
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emit_cliente, emit_sucursal, emit_fecha);


--
-- TOC entry 285 (OID 19352196)
-- Name: idx_retiros_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_retiros_1 ON retiros USING btree (ret_idopera, ret_idsitem, ret_id);


--
-- TOC entry 286 (OID 19352197)
-- Name: idx_retiros_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_retiros_2 ON retiros USING btree (ret_idopera);


--
-- TOC entry 287 (OID 19352198)
-- Name: idx_retiros_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_retiros_3 ON retiros USING btree (ret_idsitem);


--
-- TOC entry 290 (OID 19352199)
-- Name: idx_articu_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_articu_1 ON articu USING btree (artic_indirecto, artic_codigo);


--
-- TOC entry 292 (OID 19352200)
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_ptovta_1 ON ptovta USING btree (ptov_empresa, ptov_codigo);


--
-- TOC entry 302 (OID 19352201)
-- Name: idx_noticias_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_noticias_1 ON noticias USING btree (not_tipo, not_numero);


--
-- TOC entry 308 (OID 19352202)
-- Name: idx_intotal_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_intotal_1 ON intotal USING btree (int_directo, int_indirecto, int_tipoper, int_numero, int_articod, int_lotenum);


--
-- TOC entry 230 (OID 19352203)
-- Name: despachantes; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX despachantes ON despach USING btree (desp_tipo, desp_nrcuit);


--
-- TOC entry 264 (OID 19352204)
-- Name: subitem_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX subitem_4 ON subitem USING btree (sitem_estado, sitem_compbte);


--
-- TOC entry 259 (OID 19352205)
-- Name: idx_subitem_5; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_5 ON subitem USING btree (sitem_estado, sitem_deposito);


--
-- TOC entry 260 (OID 21131808)
-- Name: idx_subitem_6; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_6 ON subitem USING btree (sitem_estado, sitem_directo, sitem_indirecto, sitem_artic);


--
-- TOC entry 316 (OID 22122540)
-- Name: idx_confac_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_confac_2 ON confactur USING btree (cfc_fecha);


--
-- TOC entry 317 (OID 22122541)
-- Name: idx_confac_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_confac_3 ON confactur USING btree (cfc_anio, cfc_mes, cfc_usuario);


--
-- TOC entry 319 (OID 22195532)
-- Name: idx_caratula_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_caratula_3 ON caratula USING btree (transito);


--
-- TOC entry 321 (OID 22195533)
-- Name: idx_items_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_items_2 ON items USING btree (items_despacho);


--
-- TOC entry 322 (OID 22195534)
-- Name: idx_items_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_items_3 ON items USING btree (items_transito);


--
-- TOC entry 320 (OID 22266667)
-- Name: idx_caratula_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_caratula_4 ON caratula USING btree (despacho);


--
-- TOC entry 323 (OID 22266702)
-- Name: idx_items_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_items_4 ON items USING btree (items_despacho, nro_item, numero_subitem);


--
-- TOC entry 327 (OID 22279982)
-- Name: idx_almacen1; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_almacen1 ON almacen USING btree (alm_leyenda);


--
-- TOC entry 250 (OID 22291853)
-- Name: idx_operaciones_5; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_operaciones_5 ON operaciones USING btree (op_estado, op_tipoper);


--
-- TOC entry 261 (OID 22524455)
-- Name: idx_subitem_7; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_7 ON subitem USING btree (sitem_estado, sitem_indirecto);


--
-- TOC entry 262 (OID 22524456)
-- Name: idx_subitem_8; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_8 ON subitem USING btree (sitem_estado, sitem_artic);


--
-- TOC entry 263 (OID 22524457)
-- Name: idx_subitem_9; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_subitem_9 ON subitem USING btree (sitem_artic);


--
-- TOC entry 251 (OID 23081797)
-- Name: idx_operaciones_6; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_operaciones_6 ON operaciones USING btree (op_idopw);


--
-- TOC entry 328 (OID 23122862)
-- Name: idx_woperaciones_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_woperaciones_2 ON woperaciones USING btree (wop_directo, wop_indirecto);


--
-- TOC entry 329 (OID 23122863)
-- Name: idx_woperaciones_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_woperaciones_3 ON woperaciones USING btree (wop_estado, wop_directo, wop_indirecto);


--
-- TOC entry 330 (OID 23122864)
-- Name: idx_woperaciones_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_woperaciones_4 ON woperaciones USING btree (wop_directo, wop_indirecto, wop_tipoper, wop_estado);


--
-- TOC entry 332 (OID 23122876)
-- Name: idx_wret2_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wret2_2 ON wret2 USING btree (wret2_idopera);


--
-- TOC entry 333 (OID 23122877)
-- Name: idx_wret2_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wret2_3 ON wret2 USING btree (wret2_idsitem);


--
-- TOC entry 334 (OID 23122878)
-- Name: idx_wret2_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wret2_4 ON wret2 USING btree (wret2_estado);


--
-- TOC entry 336 (OID 23122901)
-- Name: idx_wnoticias_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wnoticias_2 ON wnoticias USING btree (wnot_estado, wnot_directo);


--
-- TOC entry 237 (OID 23678113)
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- TOC entry 338 (OID 26069222)
-- Name: idx_wsubitem_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_wsubitem_1 ON wsubitem USING btree (wsitem_id);


--
-- TOC entry 343 (OID 26069223)
-- Name: idx_wsubitem_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_2 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto);


--
-- TOC entry 344 (OID 26069224)
-- Name: idx_wsubitem_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_3 ON wsubitem USING btree (wsitem_compbte);


--
-- TOC entry 345 (OID 26069225)
-- Name: idx_wsubitem_4; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_4 ON wsubitem USING btree (wsitem_comptrans);


--
-- TOC entry 346 (OID 26069226)
-- Name: idx_wsubitem_5; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_5 ON wsubitem USING btree (wsitem_codart);


--
-- TOC entry 347 (OID 26069227)
-- Name: idx_wsubitem_6; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_6 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_consig);


--
-- TOC entry 348 (OID 26069228)
-- Name: idx_wsubitem_7; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_7 ON wsubitem USING btree (wsitem_directo, wsitem_consig);


--
-- TOC entry 349 (OID 26069229)
-- Name: idx_wsubitem_8; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_8 ON wsubitem USING btree (wsitem_indirecto, wsitem_codart);


--
-- TOC entry 350 (OID 26069230)
-- Name: idx_wsubitem_9; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_9 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte);


--
-- TOC entry 339 (OID 26069231)
-- Name: idx_wsubitem_10; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_10 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_artic);


--
-- TOC entry 340 (OID 26069232)
-- Name: idx_wsubitem_11; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_11 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte, wsitem_artic);


--
-- TOC entry 341 (OID 26069233)
-- Name: idx_wsubitem_12; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_12 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_codart);


--
-- TOC entry 342 (OID 26069234)
-- Name: idx_wsubitem_13; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wsubitem_13 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_idoper);


--
-- TOC entry 351 (OID 26069246)
-- Name: idx_wretiros_1; Type: INDEX; Schema: public; Owner: zona
--

CREATE UNIQUE INDEX idx_wretiros_1 ON wretiros USING btree (wret_id);


--
-- TOC entry 352 (OID 26069247)
-- Name: idx_wretiros_2; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wretiros_2 ON wretiros USING btree (wret_idsitem);


--
-- TOC entry 353 (OID 26069248)
-- Name: idx_wretiros_3; Type: INDEX; Schema: public; Owner: zona
--

CREATE INDEX idx_wretiros_3 ON wretiros USING btree (wret_compbte);


--
-- TOC entry 193 (OID 19352206)
-- Name: usuarios_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT usuarios_pkey PRIMARY KEY (usu_codigo);


--
-- TOC entry 194 (OID 19352208)
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_tipentid, tel_cliente, tel_sucurs, tel_tiptel, tel_orden);


--
-- TOC entry 196 (OID 19352210)
-- Name: tipusu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipusu
    ADD CONSTRAINT tipusu_pkey PRIMARY KEY (tpu_codigo);


--
-- TOC entry 197 (OID 19352212)
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- TOC entry 198 (OID 19352214)
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- TOC entry 199 (OID 19352216)
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- TOC entry 200 (OID 19352218)
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- TOC entry 201 (OID 19352220)
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- TOC entry 202 (OID 19352222)
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- TOC entry 203 (OID 19352224)
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- TOC entry 204 (OID 19352226)
-- Name: estusu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY estusu
    ADD CONSTRAINT estusu_pkey PRIMARY KEY (esc_codigo);


--
-- TOC entry 205 (OID 19352228)
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- TOC entry 206 (OID 19352230)
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- TOC entry 207 (OID 19352232)
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_codigo);


--
-- TOC entry 209 (OID 19352234)
-- Name: indices_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY indices
    ADD CONSTRAINT indices_pkey PRIMARY KEY (ind_codigo);


--
-- TOC entry 210 (OID 19352236)
-- Name: evindi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY evindi
    ADD CONSTRAINT evindi_pkey PRIMARY KEY (evi_indice, evi_fecha);


--
-- TOC entry 211 (OID 19352238)
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_niv1, ent_niv2, ent_niv3, ent_niv4, ent_niv5);


--
-- TOC entry 212 (OID 19352240)
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- TOC entry 213 (OID 19352242)
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- TOC entry 215 (OID 19352244)
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_codigo);


--
-- TOC entry 216 (OID 19352246)
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_rubro, srb_codigo);


--
-- TOC entry 217 (OID 19352250)
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_codemp, div_codigo);


--
-- TOC entry 218 (OID 19352252)
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_codemp, cco_coddiv, cco_codigo);


--
-- TOC entry 219 (OID 19352254)
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- TOC entry 220 (OID 19352256)
-- Name: sucursales_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT sucursales_pkey PRIMARY KEY (suc_cliente, suc_codigo);


--
-- TOC entry 221 (OID 19352258)
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- TOC entry 222 (OID 19352260)
-- Name: actas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY actas
    ADD CONSTRAINT actas_pkey PRIMARY KEY (acta_id);


--
-- TOC entry 223 (OID 19352262)
-- Name: aduanas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY aduanas
    ADD CONSTRAINT aduanas_pkey PRIMARY KEY (adu_codigo);


--
-- TOC entry 224 (OID 19352264)
-- Name: auxoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxoper
    ADD CONSTRAINT auxoper_pkey PRIMARY KEY (auxo_idoper);


--
-- TOC entry 225 (OID 19352266)
-- Name: clacont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY clacont
    ADD CONSTRAINT clacont_pkey PRIMARY KEY (clac_codigo);


--
-- TOC entry 226 (OID 19352268)
-- Name: conteven_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY conteven
    ADD CONSTRAINT conteven_pkey PRIMARY KEY (contev_codigo);


--
-- TOC entry 227 (OID 19352270)
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (contr_id);


--
-- TOC entry 229 (OID 19352272)
-- Name: despach_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY despach
    ADD CONSTRAINT despach_pkey PRIMARY KEY (desp_id);


--
-- TOC entry 232 (OID 19352274)
-- Name: embalajes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY embalajes
    ADD CONSTRAINT embalajes_pkey PRIMARY KEY (emb_codigo);


--
-- TOC entry 233 (OID 19352276)
-- Name: escvalcont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY escvalcont
    ADD CONSTRAINT escvalcont_pkey PRIMARY KEY (escval_idcontrat, escval_fdesde);


--
-- TOC entry 234 (OID 19352278)
-- Name: feccontra_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY feccontra
    ADD CONSTRAINT feccontra_pkey PRIMARY KEY (fechac_idcontra, fechac_codevent);


--
-- TOC entry 236 (OID 19352280)
-- Name: item_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT item_pkey PRIMARY KEY (item_id);


--
-- TOC entry 238 (OID 19352282)
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- TOC entry 239 (OID 19352284)
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- TOC entry 240 (OID 19352286)
-- Name: lotes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY lotes
    ADD CONSTRAINT lotes_pkey PRIMARY KEY (lot_id);


--
-- TOC entry 241 (OID 19352288)
-- Name: manzana_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY manzana
    ADD CONSTRAINT manzana_pkey PRIMARY KEY (mza_codigo, mza_codseccion);


--
-- TOC entry 242 (OID 19352290)
-- Name: marcont_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY marcont
    ADD CONSTRAINT marcont_pkey PRIMARY KEY (marc_codigo);


--
-- TOC entry 243 (OID 19352292)
-- Name: mercaestad_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY mercaestad
    ADD CONSTRAINT mercaestad_pkey PRIMARY KEY (mestad_codigo);


--
-- TOC entry 247 (OID 19352294)
-- Name: opervehi_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY opervehi
    ADD CONSTRAINT opervehi_pkey PRIMARY KEY (opv_id);


--
-- TOC entry 252 (OID 19352296)
-- Name: operaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT operaciones_pkey PRIMARY KEY (op_id);


--
-- TOC entry 254 (OID 19352298)
-- Name: puertos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY puertos
    ADD CONSTRAINT puertos_pkey PRIMARY KEY (pue_codigo);


--
-- TOC entry 255 (OID 19352300)
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- TOC entry 265 (OID 19352302)
-- Name: subitem_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT subitem_pkey PRIMARY KEY (sitem_id);


--
-- TOC entry 268 (OID 19352304)
-- Name: subtcontrat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subtcontrat
    ADD CONSTRAINT subtcontrat_pkey PRIMARY KEY (subt_id);


--
-- TOC entry 269 (OID 19352306)
-- Name: tipoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipoper
    ADD CONSTRAINT tipoper_pkey PRIMARY KEY (top_codigo);


--
-- TOC entry 271 (OID 19352308)
-- Name: tipprod_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipprod
    ADD CONSTRAINT tipprod_pkey PRIMARY KEY (tip_codigo);


--
-- TOC entry 273 (OID 19352310)
-- Name: tipcontrat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipcontrat
    ADD CONSTRAINT tipcontrat_pkey PRIMARY KEY (tipc_codigo);


--
-- TOC entry 274 (OID 19352312)
-- Name: unifun_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unifun
    ADD CONSTRAINT unifun_pkey PRIMARY KEY (unif_codigo);


--
-- TOC entry 275 (OID 19352314)
-- Name: unilot_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unilot
    ADD CONSTRAINT unilot_pkey PRIMARY KEY (unil_codunifun, unit_idlote);


--
-- TOC entry 276 (OID 19352316)
-- Name: consig_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY consig
    ADD CONSTRAINT consig_pkey PRIMARY KEY (csg_id);


--
-- TOC entry 278 (OID 19352318)
-- Name: estoper_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY estoper
    ADD CONSTRAINT estoper_pkey PRIMARY KEY (eto_codigo);


--
-- TOC entry 279 (OID 19352320)
-- Name: catimo_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY catimo
    ADD CONSTRAINT catimo_pkey PRIMARY KEY (imo_codigo);


--
-- TOC entry 280 (OID 19352322)
-- Name: posaran_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY posaran
    ADD CONSTRAINT posaran_pkey PRIMARY KEY (posa_codigo);


--
-- TOC entry 281 (OID 19352324)
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- TOC entry 282 (OID 19352326)
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emit_id);


--
-- TOC entry 288 (OID 19352328)
-- Name: retiros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retiros
    ADD CONSTRAINT retiros_pkey PRIMARY KEY (ret_id);


--
-- TOC entry 289 (OID 19352330)
-- Name: articu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT articu_pkey PRIMARY KEY (artic_id);


--
-- TOC entry 291 (OID 19352332)
-- Name: talonop_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talonop
    ADD CONSTRAINT talonop_pkey PRIMARY KEY (talop_usuario, talop_tipoper);


--
-- TOC entry 293 (OID 19352334)
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptov_id);


--
-- TOC entry 294 (OID 19352336)
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- TOC entry 295 (OID 19352338)
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- TOC entry 296 (OID 19352340)
-- Name: seguros_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY seguros
    ADD CONSTRAINT seguros_pkey PRIMARY KEY (seg_unifun, seg_poliza);


--
-- TOC entry 297 (OID 19352342)
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- TOC entry 298 (OID 19352344)
-- Name: modopub_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT modopub_pkey PRIMARY KEY (mod_id);


--
-- TOC entry 299 (OID 19352346)
-- Name: tippxunif_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tippxunif
    ADD CONSTRAINT tippxunif_pkey PRIMARY KEY (txu_codtipp, txu_codunif);


--
-- TOC entry 300 (OID 19352348)
-- Name: compadu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY compadu
    ADD CONSTRAINT compadu_pkey PRIMARY KEY (cad_codigo);


--
-- TOC entry 301 (OID 19352350)
-- Name: esclisp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY esclisp
    ADD CONSTRAINT esclisp_pkey PRIMARY KEY (elp_idart, elp_orden);


--
-- TOC entry 303 (OID 19352352)
-- Name: noticias_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY noticias
    ADD CONSTRAINT noticias_pkey PRIMARY KEY (not_id);


--
-- TOC entry 304 (OID 19352354)
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- TOC entry 305 (OID 19352356)
-- Name: estunif_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY estunif
    ADD CONSTRAINT estunif_pkey PRIMARY KEY (etu_codigo);


--
-- TOC entry 306 (OID 19352362)
-- Name: contene_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contene
    ADD CONSTRAINT contene_pkey PRIMARY KEY (cont_idopv, cont_marcont, cont_nrocont);


--
-- TOC entry 307 (OID 19352364)
-- Name: tiplog_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tiplog
    ADD CONSTRAINT tiplog_pkey PRIMARY KEY (tipl_codigo);


--
-- TOC entry 309 (OID 19352366)
-- Name: intotal_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY intotal
    ADD CONSTRAINT intotal_pkey PRIMARY KEY (int_id);


--
-- TOC entry 585 (OID 19352368)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT "$1" FOREIGN KEY (usu_tipusu) REFERENCES tipusu(tpu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 584 (OID 19352372)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT "$2" FOREIGN KEY (usu_coniva) REFERENCES coniva(iva_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 583 (OID 19352376)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT "$3" FOREIGN KEY (usu_conpago) REFERENCES conpag(cdp_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 582 (OID 19352380)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT "$4" FOREIGN KEY (usu_catego) REFERENCES catego(cat_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 581 (OID 19352384)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usuarios
    ADD CONSTRAINT "$5" FOREIGN KEY (usu_estado) REFERENCES estusu(esc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 588 (OID 19352388)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$1" FOREIGN KEY (tel_sucurs, tel_cliente) REFERENCES sucursales(suc_codigo, suc_cliente) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 587 (OID 19352392)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$2" FOREIGN KEY (tel_tipentid) REFERENCES tipentid(tet_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 586 (OID 19352396)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$3" FOREIGN KEY (tel_tiptel) REFERENCES tiptel(ttl_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 589 (OID 19352400)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT "$1" FOREIGN KEY (cot_moneda) REFERENCES moneda(mon_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 594 (OID 19352404)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$1" FOREIGN KEY (cbl_niv1, cbl_niv2, cbl_niv3, cbl_niv4, cbl_niv5) REFERENCES entidad(ent_niv1, ent_niv2, ent_niv3, ent_niv4, ent_niv5) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 593 (OID 19352408)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$2" FOREIGN KEY (cbl_moneda) REFERENCES moneda(mon_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 592 (OID 19352412)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$3" FOREIGN KEY (cbl_indice) REFERENCES indices(ind_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 591 (OID 19352416)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$4" FOREIGN KEY (cbl_tipcta) REFERENCES tipcta(tct_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 590 (OID 19352420)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$5" FOREIGN KEY (cbl_idptovta) REFERENCES ptovta(ptov_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 595 (OID 19352424)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY evindi
    ADD CONSTRAINT "$1" FOREIGN KEY (evi_indice) REFERENCES indices(ind_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 600 (OID 19352428)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$1" FOREIGN KEY (art_codsrb, art_codrub) REFERENCES subrub(srb_codigo, srb_rubro) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 599 (OID 19352432)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$2" FOREIGN KEY (art_codcbl) REFERENCES ctacble(cbl_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 598 (OID 19352436)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$3" FOREIGN KEY (art_unimed) REFERENCES unimed(uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 597 (OID 19352440)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$4" FOREIGN KEY (art_tipoper) REFERENCES tipoper(top_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 596 (OID 19352444)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$5" FOREIGN KEY (art_idptovta) REFERENCES ptovta(ptov_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 601 (OID 19352448)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT "$1" FOREIGN KEY (srb_rubro) REFERENCES rubros(rub_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 606 (OID 19352468)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT "$1" FOREIGN KEY (suc_cliente) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 605 (OID 19352472)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT "$2" FOREIGN KEY (suc_codprov) REFERENCES provin(pro_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 604 (OID 19352476)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT "$3" FOREIGN KEY (suc_pais) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 603 (OID 19352480)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT "$4" FOREIGN KEY (suc_codprovl) REFERENCES provin(pro_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 602 (OID 19352484)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY sucursales
    ADD CONSTRAINT "$5" FOREIGN KEY (suc_paisl) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 608 (OID 19352488)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxoper
    ADD CONSTRAINT "$1" FOREIGN KEY (auxo_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 607 (OID 19352492)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxoper
    ADD CONSTRAINT "$2" FOREIGN KEY (auxo_puerto) REFERENCES puertos(pue_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 612 (OID 19352496)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$1" FOREIGN KEY (contr_locador) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 611 (OID 19352500)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$2" FOREIGN KEY (contr_idsubt) REFERENCES subtcontrat(subt_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 610 (OID 19352504)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$3" FOREIGN KEY (contr_unifun) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 609 (OID 19352508)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$4" FOREIGN KEY (contr_locatario) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 613 (OID 19352512)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY escvalcont
    ADD CONSTRAINT "$1" FOREIGN KEY (escval_idcontrat) REFERENCES contratos(contr_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 615 (OID 19352516)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY feccontra
    ADD CONSTRAINT "$1" FOREIGN KEY (fechac_idcontra) REFERENCES contratos(contr_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 614 (OID 19352520)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY feccontra
    ADD CONSTRAINT "$2" FOREIGN KEY (fechac_codevent) REFERENCES conteven(contev_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 622 (OID 19352524)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$1" FOREIGN KEY (item_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 621 (OID 19352528)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$2" FOREIGN KEY (item_tipprod) REFERENCES tipprod(tip_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 620 (OID 19352532)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$3" FOREIGN KEY (item_unimed) REFERENCES unimed(uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 619 (OID 19352536)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$4" FOREIGN KEY (item_moneda) REFERENCES moneda(mon_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 618 (OID 19352540)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$5" FOREIGN KEY (item_posa) REFERENCES posaran(posa_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 617 (OID 19352544)
-- Name: $6; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$6" FOREIGN KEY (item_paisorigen) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 616 (OID 19352548)
-- Name: $7; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY item
    ADD CONSTRAINT "$7" FOREIGN KEY (item_proced) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 623 (OID 19352552)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY lotes
    ADD CONSTRAINT "$1" FOREIGN KEY (lot_codmza, lot_codseccion) REFERENCES manzana(mza_codigo, mza_codseccion) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 624 (OID 19352556)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY manzana
    ADD CONSTRAINT "$1" FOREIGN KEY (mza_codseccion) REFERENCES seccion(sec_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 626 (OID 19352560)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY opervehi
    ADD CONSTRAINT "$1" FOREIGN KEY (opv_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 625 (OID 19352564)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY opervehi
    ADD CONSTRAINT "$2" FOREIGN KEY (opv_codtd) REFERENCES tipdocu(td_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 639 (OID 19352568)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$1" FOREIGN KEY (op_directo) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 638 (OID 19352572)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$2" FOREIGN KEY (op_consig) REFERENCES consig(csg_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 637 (OID 19352576)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$3" FOREIGN KEY (op_tipoper) REFERENCES tipoper(top_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 636 (OID 19352580)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$4" FOREIGN KEY (op_estado) REFERENCES estoper(eto_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 635 (OID 19352584)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$5" FOREIGN KEY (op_deposito) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 634 (OID 19352588)
-- Name: $6; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$6" FOREIGN KEY (op_moneda) REFERENCES moneda(mon_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 633 (OID 19352592)
-- Name: $7; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$7" FOREIGN KEY (op_embalaje) REFERENCES embalajes(emb_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 632 (OID 19352596)
-- Name: $8; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$8" FOREIGN KEY (op_iddespach) REFERENCES despach(desp_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 631 (OID 19352600)
-- Name: $9; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$9" FOREIGN KEY (op_destino) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 630 (OID 19352604)
-- Name: $10; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$10" FOREIGN KEY (op_proced) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 629 (OID 19352608)
-- Name: $11; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$11" FOREIGN KEY (op_pmedtrans) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 628 (OID 19352612)
-- Name: $12; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$12" FOREIGN KEY (op_indirecto) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 627 (OID 19352616)
-- Name: $13; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY operaciones
    ADD CONSTRAINT "$13" FOREIGN KEY (op_verificador) REFERENCES despach(desp_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 640 (OID 19352620)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY puertos
    ADD CONSTRAINT "$1" FOREIGN KEY (pue_pais) REFERENCES pais(pai_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 649 (OID 19352624)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$1" FOREIGN KEY (sitem_idacta) REFERENCES actas(acta_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 648 (OID 19352628)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$2" FOREIGN KEY (sitem_iditem) REFERENCES item(item_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 647 (OID 19352632)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$3" FOREIGN KEY (sitem_tipemb) REFERENCES embalajes(emb_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 646 (OID 19352636)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$4" FOREIGN KEY (sitem_deposito) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 645 (OID 19352640)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$5" FOREIGN KEY (sitem_artic) REFERENCES articu(artic_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 644 (OID 19352644)
-- Name: $6; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$6" FOREIGN KEY (sitem_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 643 (OID 19352648)
-- Name: $7; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$7" FOREIGN KEY (sitem_estado) REFERENCES mercaestad(mestad_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 642 (OID 19352652)
-- Name: $8; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$8" FOREIGN KEY (sitem_directo) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 641 (OID 19352656)
-- Name: $9; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subitem
    ADD CONSTRAINT "$9" FOREIGN KEY (sitem_indirecto) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 652 (OID 19352660)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subtcontrat
    ADD CONSTRAINT "$1" FOREIGN KEY (subt_idtipc) REFERENCES tipcontrat(tipc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 651 (OID 19352664)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subtcontrat
    ADD CONSTRAINT "$2" FOREIGN KEY (art_id) REFERENCES articvta(art_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 650 (OID 19352668)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY subtcontrat
    ADD CONSTRAINT "$3" FOREIGN KEY (art_id) REFERENCES articvta(art_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 653 (OID 19352672)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipprod
    ADD CONSTRAINT "$1" FOREIGN KEY (tip_imo) REFERENCES catimo(imo_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 655 (OID 19352676)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unifun
    ADD CONSTRAINT "$1" FOREIGN KEY (unif_usuario) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 654 (OID 19352680)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unifun
    ADD CONSTRAINT "$2" FOREIGN KEY (unif_estado) REFERENCES estunif(etu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 657 (OID 19352684)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unilot
    ADD CONSTRAINT "$1" FOREIGN KEY (unil_codunifun) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 656 (OID 19352688)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY unilot
    ADD CONSTRAINT "$2" FOREIGN KEY (unit_idlote) REFERENCES lotes(lot_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 659 (OID 19352692)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT "$1" FOREIGN KEY (emit_cliente, emit_sucursal) REFERENCES sucursales(suc_cliente, suc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 658 (OID 19352696)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT "$2" FOREIGN KEY (emit_idptovta) REFERENCES ptovta(ptov_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 661 (OID 19352700)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retiros
    ADD CONSTRAINT "$1" FOREIGN KEY (ret_idopera) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 660 (OID 19352704)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY retiros
    ADD CONSTRAINT "$2" FOREIGN KEY (ret_idsitem) REFERENCES subitem(sitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 665 (OID 19352708)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT "$1" FOREIGN KEY (artic_indirecto) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 664 (OID 19352712)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT "$2" FOREIGN KEY (artic_tiprod) REFERENCES tipprod(tip_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 663 (OID 19352716)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT "$3" FOREIGN KEY (artic_posa) REFERENCES posaran(posa_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 662 (OID 19352720)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT "$4" FOREIGN KEY (artic_unimed) REFERENCES unimed(uni_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 667 (OID 19352724)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talonop
    ADD CONSTRAINT "$1" FOREIGN KEY (talop_usuario) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 666 (OID 19352728)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talonop
    ADD CONSTRAINT "$2" FOREIGN KEY (talop_tipoper) REFERENCES tipoper(top_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 668 (OID 19352732)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT "$1" FOREIGN KEY (ptov_empresa) REFERENCES empresa(emp_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 669 (OID 19352736)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT "$1" FOREIGN KEY (comp_idptovta) REFERENCES ptovta(ptov_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 671 (OID 19352740)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY seguros
    ADD CONSTRAINT "$1" FOREIGN KEY (seg_unifun) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 670 (OID 19352744)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY seguros
    ADD CONSTRAINT "$2" FOREIGN KEY (seg_moneda) REFERENCES moneda(mon_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 678 (OID 19352748)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$1" FOREIGN KEY (mod_idoperador) REFERENCES operadores(operad_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 677 (OID 19352752)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$2" FOREIGN KEY (mod_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 676 (OID 19352756)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$3" FOREIGN KEY (mod_idret) REFERENCES retiros(ret_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 675 (OID 19352760)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$4" FOREIGN KEY (mod_idsitem) REFERENCES subitem(sitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 674 (OID 19352764)
-- Name: $5; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$5" FOREIGN KEY (mod_autoriz1) REFERENCES operadores(operad_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 673 (OID 19352768)
-- Name: $6; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$6" FOREIGN KEY (mod_autoriz2) REFERENCES operadores(operad_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 672 (OID 19352772)
-- Name: $7; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modopub
    ADD CONSTRAINT "$7" FOREIGN KEY (mod_autoriz3) REFERENCES operadores(operad_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 680 (OID 19352776)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tippxunif
    ADD CONSTRAINT "$1" FOREIGN KEY (txu_codtipp) REFERENCES tipprod(tip_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 679 (OID 19352780)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tippxunif
    ADD CONSTRAINT "$2" FOREIGN KEY (txu_codunif) REFERENCES unifun(unif_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 681 (OID 19352784)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY compadu
    ADD CONSTRAINT "$1" FOREIGN KEY (cad_tipoper) REFERENCES tipoper(top_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 682 (OID 19352788)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY esclisp
    ADD CONSTRAINT "$1" FOREIGN KEY (elp_idart) REFERENCES articvta(art_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 684 (OID 19352792)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$1" FOREIGN KEY (tal_idptovta) REFERENCES ptovta(ptov_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 683 (OID 19352796)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$2" FOREIGN KEY (tal_comprob) REFERENCES comprob(comp_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 687 (OID 19352812)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contene
    ADD CONSTRAINT "$1" FOREIGN KEY (cont_idopv) REFERENCES opervehi(opv_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 686 (OID 19352816)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contene
    ADD CONSTRAINT "$2" FOREIGN KEY (cont_clacont) REFERENCES clacont(clac_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 685 (OID 19352820)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contene
    ADD CONSTRAINT "$3" FOREIGN KEY (cont_marcont) REFERENCES marcont(marc_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 310 (OID 19352824)
-- Name: egretot_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY egretot
    ADD CONSTRAINT egretot_pkey PRIMARY KEY (egt_id);


--
-- TOC entry 311 (OID 19352826)
-- Name: articu1_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY articu1
    ADD CONSTRAINT articu1_pkey PRIMARY KEY (artic_id);


--
-- TOC entry 312 (OID 21120155)
-- Name: impresiones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY impresiones
    ADD CONSTRAINT impresiones_pkey PRIMARY KEY (imp_codigo);


--
-- TOC entry 313 (OID 21131804)
-- Name: leyenrexp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY leyenrexp
    ADD CONSTRAINT leyenrexp_pkey PRIMARY KEY (leyr_id);


--
-- TOC entry 314 (OID 21137483)
-- Name: auxoperv_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxoperv
    ADD CONSTRAINT auxoperv_pkey PRIMARY KEY (avh_id);


--
-- TOC entry 315 (OID 22122542)
-- Name: confactur_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT confactur_pkey PRIMARY KEY (cfc_id);


--
-- TOC entry 691 (OID 22122544)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT "$1" FOREIGN KEY (cfc_idart) REFERENCES articvta(art_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 690 (OID 22122548)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT "$2" FOREIGN KEY (cfc_usuario) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 689 (OID 22122552)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT "$3" FOREIGN KEY (cfc_idoper) REFERENCES operaciones(op_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 688 (OID 22122556)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY confactur
    ADD CONSTRAINT "$4" FOREIGN KEY (cfc_idemiti) REFERENCES emiti(emit_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 318 (OID 22195506)
-- Name: caratula_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY caratula
    ADD CONSTRAINT caratula_pkey PRIMARY KEY (car_id);


--
-- TOC entry 324 (OID 22195517)
-- Name: items_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY items
    ADD CONSTRAINT items_pkey PRIMARY KEY (items_id);


--
-- TOC entry 325 (OID 22195529)
-- Name: problimp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY problimp
    ADD CONSTRAINT problimp_pkey PRIMARY KEY (pim_id);


--
-- TOC entry 326 (OID 22267601)
-- Name: almacen_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacen
    ADD CONSTRAINT almacen_pkey PRIMARY KEY (alm_id);


--
-- TOC entry 694 (OID 22267603)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacen
    ADD CONSTRAINT "$2" FOREIGN KEY (alm_idusu) REFERENCES usuarios(usu_codigo) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 693 (OID 22267607)
-- Name: $3; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacen
    ADD CONSTRAINT "$3" FOREIGN KEY (alm_idsitem) REFERENCES subitem(sitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 692 (OID 22267611)
-- Name: $4; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY almacen
    ADD CONSTRAINT "$4" FOREIGN KEY (alm_idcontr) REFERENCES contratos(contr_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 331 (OID 23122856)
-- Name: woperaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY woperaciones
    ADD CONSTRAINT woperaciones_pkey PRIMARY KEY (wop_id);


--
-- TOC entry 695 (OID 23122858)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY woperaciones
    ADD CONSTRAINT "$2" FOREIGN KEY (wop_consig) REFERENCES consig(csg_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 335 (OID 23122874)
-- Name: wret2_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wret2
    ADD CONSTRAINT wret2_pkey PRIMARY KEY (wret2_id);


--
-- TOC entry 697 (OID 23122883)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wret2
    ADD CONSTRAINT "$2" FOREIGN KEY (wret2_idopera) REFERENCES woperaciones(wop_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 337 (OID 23122907)
-- Name: wleyenrexp_pkey; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wleyenrexp
    ADD CONSTRAINT wleyenrexp_pkey PRIMARY KEY (wleyr_id);


--
-- TOC entry 698 (OID 26069249)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wretiros
    ADD CONSTRAINT "$1" FOREIGN KEY (wret_idsitem) REFERENCES wsubitem(wsitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 696 (OID 26209238)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: zona
--

ALTER TABLE ONLY wret2
    ADD CONSTRAINT "$1" FOREIGN KEY (wret2_idsitem) REFERENCES wsubitem(wsitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 706 (OID 22547439)
-- Name: ai_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_operaciones
    AFTER INSERT ON operaciones
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_operaciones ();


--
-- TOC entry 708 (OID 22547440)
-- Name: bu_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_operaciones
    BEFORE UPDATE ON operaciones
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_operaciones ();


--
-- TOC entry 707 (OID 22547441)
-- Name: au_operaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_operaciones
    AFTER UPDATE ON operaciones
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_operaciones ();


--
-- TOC entry 704 (OID 22547442)
-- Name: bi_item; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_item
    BEFORE INSERT ON item
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_item ();


--
-- TOC entry 703 (OID 22547443)
-- Name: au_item; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_item
    BEFORE UPDATE ON item
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_item ();


--
-- TOC entry 712 (OID 22547444)
-- Name: bi_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_subitem
    BEFORE INSERT ON subitem
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_subitem ();


--
-- TOC entry 713 (OID 22547445)
-- Name: bu_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_subitem
    BEFORE UPDATE ON subitem
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_subitem ();


--
-- TOC entry 711 (OID 22547446)
-- Name: bd_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bd_subitem
    BEFORE DELETE ON subitem
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_subitem ();


--
-- TOC entry 710 (OID 22547447)
-- Name: ad_subitem; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_subitem
    AFTER DELETE ON subitem
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_subitem ();


--
-- TOC entry 717 (OID 22547448)
-- Name: bi_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_retiros
    BEFORE INSERT ON retiros
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_retiros ();


--
-- TOC entry 715 (OID 22547449)
-- Name: ai_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_retiros
    AFTER INSERT ON retiros
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_retiros ();


--
-- TOC entry 718 (OID 22547450)
-- Name: bu_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_retiros
    BEFORE UPDATE ON retiros
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_retiros ();


--
-- TOC entry 716 (OID 22547451)
-- Name: au_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_retiros
    AFTER UPDATE ON retiros
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_retiros ();


--
-- TOC entry 714 (OID 22547452)
-- Name: ad_retiros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_retiros
    AFTER DELETE ON retiros
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_retiros ();


--
-- TOC entry 720 (OID 22547453)
-- Name: ai_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_seguros
    AFTER INSERT ON seguros
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_seguros ();


--
-- TOC entry 722 (OID 22547454)
-- Name: bu_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_seguros
    BEFORE UPDATE ON seguros
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_seguros ();


--
-- TOC entry 721 (OID 22547455)
-- Name: au_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_seguros
    AFTER UPDATE ON seguros
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_seguros ();


--
-- TOC entry 719 (OID 22547456)
-- Name: ad_seguros; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_seguros
    AFTER DELETE ON seguros
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_seguros ();


--
-- TOC entry 699 (OID 22547457)
-- Name: ai_usuarios; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_usuarios
    AFTER INSERT ON usuarios
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_usuarios ();


--
-- TOC entry 700 (OID 22547458)
-- Name: ai_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_contratos
    AFTER INSERT ON contratos
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_contratos ();


--
-- TOC entry 701 (OID 22547459)
-- Name: bi_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_contratos
    BEFORE INSERT ON contratos
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_contratos ();


--
-- TOC entry 709 (OID 22547460)
-- Name: bi_puertos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_puertos
    BEFORE INSERT ON puertos
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_puertos ();


--
-- TOC entry 702 (OID 22547461)
-- Name: au_feccontra; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_feccontra
    AFTER UPDATE ON feccontra
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_feccontra ();


--
-- TOC entry 723 (OID 22547462)
-- Name: bu_caratula; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bu_caratula
    BEFORE UPDATE ON caratula
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_caratula ();


--
-- TOC entry 705 (OID 22547463)
-- Name: au_opervehi; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_opervehi
    AFTER UPDATE ON opervehi
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_opervehi ();


--
-- TOC entry 726 (OID 23122938)
-- Name: ai_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_wret2
    AFTER INSERT ON wret2
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_wret2 ();


--
-- TOC entry 725 (OID 23122940)
-- Name: ad_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ad_wret2
    AFTER DELETE ON wret2
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_wret2 ();


--
-- TOC entry 724 (OID 23122941)
-- Name: au_woperaciones; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_woperaciones
    AFTER UPDATE ON woperaciones
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_woperaciones ();


--
-- TOC entry 727 (OID 26209237)
-- Name: au_wret2; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_wret2
    AFTER UPDATE ON wret2
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_wret2 ();


