Hacer un aplicativo que muestre todos los contratos de un locador-locatario-idsubt







CREATE TABLE contratos (
    contr_id serial NOT NULL,
    contr_locador integer NOT NULL,
    contr_locatario integer NOT NULL,
    contr_idsubt integer,
    contr_unifun smallint,
    contr_garantia numeric(15,2) DEFAULT 0,
    contr_step smallint DEFAULT 1,
    contr_facturable smallint DEFAULT 1,
    contr_leyenda text,
    contr_estado smallint DEFAULT 1,
    contr_metros numeric(15,5) DEFAULT 0,
    contr_puxmtro numeric(15,2) DEFAULT 0,
    contr_inter numeric(15,5) DEFAULT 1.5
);


ALTER TABLE public.contratos OWNER TO zona;




--
-- Name: feccontra; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE feccontra (
    fechac_idcontra integer NOT NULL,
    fechac_codevent integer NOT NULL,
    fechac_fecha date NOT NULL,
    fechac_aviso text
);


ALTER TABLE public.feccontra OWNER TO zona;




--
-- Name: f_ai_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ai_contratos() RETURNS "trigger"
    AS $$
    BEGIN
    if int4eq(tipo_de_contrato(NEW.contr_idsubt),1) then
	update unifun set unif_usuario=NEW.contr_locatario, unif_estado=1::int2
	where unif_codigo=NEW.contr_unifun;

    end if;
    RETURN NEW;
    END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.f_ai_contratos() OWNER TO zona;

--
-- Name: f_au_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_contratos() RETURNS "trigger"
    AS $$
    DECLARE
	operacion	int4;
    BEGIN

    if(int2eq(OLD.contr_estado,1::int2) and int2eq(NEW.contr_estado,2::int2) and int4lt(NEW.contr_idsubt,7)) then 

	select contr_id into operacion from contratos where int4lt(contr_idsubt,7) and contr_locatario=NEW.contr_locatario and contr_locador=NEW.contr_locador and contr_estado=1 and contr_id!=OLD.contr_id;
	if not found then
	    select contr_id into operacion from contratos where int4eq(contr_idsubt,11) and contr_locatario=NEW.contr_locatario and contr_estado=1;
	    if not found then
		update contratos set contr_estado=0 where contr_locador=NEW.contr_locatario and contr_estado=1 and contr_idsubt>6;
	    end if;
	end if;

    END IF;


    RETURN NEW;
    END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.f_au_contratos() OWNER TO zona;

--
-- Name: f_bi_contratos(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bi_contratos() RETURNS "trigger"
    AS $$
    DECLARE
    ale 		int2;
    usua 		int4;
    BEGIN
    select unif_codigo into ale from unifun where unif_codigo=NEW.contr_unifun;
    if not found then
	NEW.contr_unifun:=0;
    end if;

    select usu_codigo into usua from usuarios where usu_codigo=NEW.contr_locador;
    if not found then
	NEW.contr_locador:=1;
    end if;

    RETURN NEW;
    END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.f_bi_contratos() OWNER TO zona;

--
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (contr_id);


--
-- Name: idx_contratos_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE UNIQUE INDEX idx_contratos_1 ON contratos USING btree (contr_locador, contr_id);


--
-- Name: ai_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER ai_contratos
    AFTER INSERT ON contratos
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_contratos();


--
-- Name: au_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_contratos
    AFTER UPDATE ON contratos
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_contratos();


--
-- Name: bi_contratos; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER bi_contratos
    BEFORE INSERT ON contratos
    FOR EACH ROW
    EXECUTE PROCEDURE f_bi_contratos();



--
-- Name: contratos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
REVOKE ALL ON TABLE contratos FROM zona;
GRANT ALL ON TABLE contratos TO zona;
GRANT ALL ON TABLE contratos TO nobody;


--
-- Name: contratos_contr_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contratos_contr_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE contratos_contr_id_seq FROM zona;
GRANT ALL ON TABLE contratos_contr_id_seq TO zona;
GRANT UPDATE ON TABLE contratos_contr_id_seq TO nobody;





--
-- Name: f_au_feccontra(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_au_feccontra() RETURNS "trigger"
    AS $$
    DECLARE
    BEGIN

	if(int4eq(NEW.fechac_codevent,5) and date_ne(OLD.fechac_fecha,NEW.fechac_fecha)) then
    	    update tarifas set tari_fhasta=NEW.fechac_fecha where tari_idcontr=NEW.fechac_idcontra;
	end if;

RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.f_au_feccontra() OWNER TO zona;


--
-- Name: feccontra_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY feccontra
    ADD CONSTRAINT feccontra_pkey PRIMARY KEY (fechac_idcontra, fechac_codevent);


--
-- Name: au_feccontra; Type: TRIGGER; Schema: public; Owner: zona
--

CREATE TRIGGER au_feccontra
    AFTER UPDATE ON feccontra
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_feccontra();


--
-- Name: feccontra; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE feccontra FROM PUBLIC;
REVOKE ALL ON TABLE feccontra FROM zona;
GRANT ALL ON TABLE feccontra TO zona;
GRANT ALL ON TABLE feccontra TO nobody;








--
-- Name: contindlocador(integer, integer, smallint, smallint, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contindlocador(integer, integer, smallint, smallint, smallint) RETURNS boolean
    AS $_$
declare
unifusu		 alias for $1;
indlocad	 alias for $2;
unifun		 alias for $3;
tipo_contrato 	 alias for $4;
modo 		 alias for $5; 	-- 1 solo busca indirecto locador
				-- 2 busca Indirecto locador o reciprocidad
unicont		 int2;
tipusu		 int2;
pame		 int2;
ret 		 boolean;
registro	 RECORD;
hayuno	 	 int2;
hayunoaprob	 int2;

begin

pame:=2;
ret:='f';
hayuno:=0;
hayunoaprob:=0;


select usu_tipusu into tipusu from usuarios where usu_codigo=indlocad;
if(int2eq(tipusu,3::int2)) then
    pame:=1;
end if; 


if(unifusu!=indlocad) then

    if(int2eq(pame,1::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu and contr_locatario=indlocad and tipo_de_contrato(contr_idsubt)=tipo_contrato and int2eq(contr_estado,1::int2)
	    loop
		if int2eq(unifun,registro.contr_unifun::int2) then  
		hayunoaprob:=1;
		ret:='t'; 
		end if;
	    end loop;
    end if;


    if(int2eq(modo,2::int2) and int2eq(pame,2::int2)) then    

	    for registro in select 
		* from contratos where contr_locador=unifusu 
		and contr_locatario=indlocad 
		and tipo_de_contrato(contr_idsubt) in (2::int2,4::int2,5::int2) 
		and int2eq(contr_estado,1::int2)
	    loop
		ret:='t';
	    end loop;

    end if;

end if;

if(int4eq(unifusu,indlocad)) then
    ret:='t';
end if;

return ret;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.contindlocador(integer, integer, smallint, smallint, smallint) OWNER TO zona;

--
-- Name: contrid_almacen(integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION contrid_almacen(integer, smallint) RETURNS integer
    AS $_$select contr_id from contratos where contr_estado= $2 and contr_locador=1  and contr_idsubt in (7,8) and contr_locatario = $1 order by contr_id desc limit 1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.contrid_almacen(integer, smallint) OWNER TO zona;

--
-- Name: estadocontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION estadocontr(integer) RETURNS smallint
    AS $_$select contr_estado from contratos where contr_id= $1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.estadocontr(integer) OWNER TO zona;

--
-- Name: facturacontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION facturacontr(integer) RETURNS smallint
    AS $_$select contr_facturable from contratos where contr_id= $1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.facturacontr(integer) OWNER TO zona;

--
-- Name: genernd(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION genernd(integer, integer, integer, numeric) RETURNS integer
    AS $_$
declare
idastoh		 alias for $1;
elcliente	 alias for $2;
nrogpo		 alias for $3;
totpag		 alias for $4;
ret 		 integer;
registro	 record;
regi		 record;
regi2		 record;
codemp		 integer;
idpto		 integer;
tipct		 integer;
ctadxv		 integer;
ctabco		 integer;
ctachq		 integer;
ctadocu		 integer;
primera		 integer;
salgrup		 numeric;
llevo		 numeric;
interd		 numeric;
prompago	 date;
acum1		 numeric;
acum2		 numeric;
tempor		 numeric;
valmin		 numeric;
begin

ret:=0;
llevo:=0;
acum1:=0;
acum2:=0;
tempor:=0;

select ash_codemp,ash_idptov into codemp,idpto from astoh where ash_id=idastoh;
select idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) into ctadxv;   
select idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) into ctachq;   
select idcbl(codemp,valvaramb(codemp,0,'BANCO')::integer) into ctabco;   
select idcbl(codemp,valvaramb(codemp,0,'DOCUM')::integer) into ctadocu;   
select sum(astc_importe) into salgrup from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo and astc_idastoh!=idastoh;
select (contr_inter * valvaramb(codemp,0,'INTBP')::numeric) into interd from contratos where contr_locatario=codcli(elcliente) and contr_idsubt in (0,1,2,3,4,5,6) and contr_inter is not null order by contr_id desc limit 1;
select valvaramb(codemp,0,'VALMINND') into valmin;   


if interd is null then
interd:= 20000.1;
end if;

for regi in select 
     * from astoctas where astc_idastoh=idastoh
    loop
	if(numeric_gt(regi.astc_importe,0::numeric)) then

	    if(int4eq(regi.astc_ctacble,ctachq)) then
		for regi2 in select * from cheques where chq_idastoc=regi.astc_id
		    loop
			select (regi2.chq_fecheq - '01-01-1900'::date) * regi2.chq_importe into acum1;
			acum2:=acum2 + acum1;
		    end loop; 
		tempor:=acum2;
		acum1:=0;
		acum2:=0;
	      else
		if(int4eq(regi.astc_ctacble,ctadocu)) then
		    for regi2 in select * from docum where doc_idastoc=regi.astc_id
			loop
			    select (regi2.doc_fecdoc - '01-01-1900'::date) * regi2.doc_importe into acum1;
			    acum2:=acum2 + acum1;
			end loop; 
		    tempor:= tempor + acum2;
		    acum1:=0;
		    acum2:=0;
	          else
		    if(int4eq(regi.astc_ctacble,ctabco)) then
			select (regi.astc_fecvto - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
			acum1:=0;
			acum2:=0;
	              else
			select (regi.astc_fecval - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
    		    end if;
    		end if;
    	    end if;
	end if;
    end loop; 

select ('01-01-1900'::date + (tempor / totpag)::integer) into prompago;


primera:=1;
for registro in select 
     * from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo order by astc_fecval,astc_idastoh desc
    loop
	if(numeric_le(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
	    llevo:= llevo + (registro.astc_importe * (prompago - registro.astc_fecvto) * interd / 100 / 30);
	    salgrup:= salgrup - registro.astc_importe;
	  else 
	    if(numeric_gt(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
		llevo:=llevo + (salgrup * (prompago - registro.astc_fecvto) * interd  / 100 / 30);
	    end if;
	end if;
    end loop; 



if numeric_ge(llevo,valmin) then
    insert into notdeb (nd_idasho,nd_codemp,nd_idptov,nd_fecval,nd_grupo,nd_codcli,nd_tpago,nd_tnd,nd_interes) values (idastoh,codemp,idpto,date(now()),nrogpo,elcliente,totpag,llevo,interd);
    select max(nd_id) into ret from notdeb;
end if;


return ret;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.genernd(integer, integer, integer, numeric) OWNER TO zona;

--
-- Name: genernd1(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION genernd1(integer, integer, integer, numeric) RETURNS numeric
    AS $_$
declare
idastoh		 alias for $1;
elcliente	 alias for $2;
nrogpo		 alias for $3;
totpag		 alias for $4;
ret 		 numeric;
registro	 record;
regi		 record;
regi2		 record;
codemp		 integer;
idpto		 integer;
tipct		 integer;
ctadxv		 integer;
ctabco		 integer;
ctachq		 integer;
ctadocu		 integer;
primera		 integer;
salgrup		 numeric;
llevo		 numeric;
interd		 numeric;
prompago	 date;
acum1		 numeric;
acum2		 numeric;
tempor		 numeric;
valmin		 numeric;
begin

ret:=0;
llevo:=0;
acum1:=0;
acum2:=0;
tempor:=0;

select ash_codemp,ash_idptov into codemp,idpto from astoh where ash_id=idastoh;
select idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) into ctadxv;   
select idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) into ctachq;   
select idcbl(codemp,valvaramb(codemp,0,'BANCO')::integer) into ctabco;   
select idcbl(codemp,valvaramb(codemp,0,'DOCUM')::integer) into ctadocu;   
select sum(astc_importe) into salgrup from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo and astc_idastoh!=idastoh;
select (contr_inter * valvaramb(codemp,0,'INTBP')::numeric) into interd from contratos where contr_locatario=codcli(elcliente) and contr_idsubt in (0,1,2,3,4,5,6) and contr_inter is not null order by contr_id desc limit 1;
select valvaramb(codemp,0,'VALMINND') into valmin;   


if interd is null then
interd:= 20000.1;
end if;



for regi in select 
     * from astoctas where astc_idastoh=idastoh
    loop
	if(numeric_gt(regi.astc_importe,0::numeric)) then

	    if(int4eq(regi.astc_ctacble,ctachq)) then
		for regi2 in select * from cheques where chq_idastoc=regi.astc_id
		    loop
			select (regi2.chq_fecheq - '01-01-1900'::date) * regi2.chq_importe into acum1;
			acum2:=acum2 + acum1;
		    end loop; 
		tempor:=acum2;
		acum1:=0;
		acum2:=0;
	      else
		if(int4eq(regi.astc_ctacble,ctadocu)) then
		    for regi2 in select * from docum where doc_idastoc=regi.astc_id
			loop
			    select (regi2.doc_fecdoc - '01-01-1900'::date) * regi2.doc_importe into acum1;
			    acum2:=acum2 + acum1;
			end loop; 
		    tempor:= tempor + acum2;
		    acum1:=0;
		    acum2:=0;
	          else
		    if(int4eq(regi.astc_ctacble,ctabco)) then
			select (regi.astc_fecvto - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
			acum1:=0;
			acum2:=0;
	              else
			select (regi.astc_fecval - '01-01-1900'::date) * regi.astc_importe into acum1;
			tempor:= tempor + acum1;
    		    end if;
    		end if;
    	    end if;
	end if;
    end loop; 


select ('01-01-1900'::date + (tempor / totpag)::integer) into prompago;


primera:=1;
for registro in select 
     * from astoctas where astc_codemp=codemp and astc_ctacble=ctadxv and astc_ctacte=elcliente and astc_grupo=nrogpo order by astc_fecval,astc_idastoh desc
    loop
	if(numeric_le(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
	    llevo:= llevo + (registro.astc_importe * (prompago - registro.astc_fecvto) * interd / 100 / 30);
	    salgrup:= salgrup - registro.astc_importe;
	  else 
	    if(numeric_gt(registro.astc_importe,salgrup) and numeric_gt(registro.astc_importe,0::numeric)) then
		llevo:=llevo + (salgrup * (prompago - registro.astc_fecvto) * interd  / 100 / 30);
	    end if;
	end if;
    end loop; 

ret:=salgrup;


return ret;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.genernd1(integer, integer, integer, numeric) OWNER TO zona;




--
-- Name: hay_cont_recipro(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_recipro(integer, integer, smallint) RETURNS boolean
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; 	-- id dela operacion
	directo		ALIAS FOR $2; 	-- Usuario Directo
	modo		ALIAS FOR $3; 	-- modo
					--1 valido en publicacion
					--2 valido solo
	indirecto 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='t';		
    for registro in select sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by y
	loop
	select unif_usuario into indirecto from unifun where unif_codigo=registro.y;
	    if int4ne(directo,indirecto) then
		    trans:=hay_contrato(directo,indirecto,2::int2,operacion,5::int2);
		else
		    trans:='t';		
	    end if;
	end loop; 

    RETURN retval;
    END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.hay_cont_recipro(integer, integer, smallint) OWNER TO zona;

--
-- Name: hay_cont_valido(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_cont_valido(integer, integer, smallint) RETURNS boolean
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- Titular de la unifun 
	directo		ALIAS FOR $2; 	-- Usuario Directo o indirecto
	modo 		alias for $3;  	-- 1  valida que exista contrato
					-- 2 valida que exista y este aprobado
					-- 3 valida que exista contrato y no graba noticias
					-- 4 valida que exista y este aprobado y no graba noticias
					-- 43 valida que exista  tipo contrato 3 y este aprobado y no graba noticias
					-- 443 valida que exista  tipo contrato 4 y este aprobado y no graba noticias
	indirecto 	int4;
	operacion 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='f';		
    operacion=1;

if(usuario!=directo) then
    if usuario is not null then
	if int4ne(directo,usuario) then
	        if int2eq(modo,43::int2) then
	    		trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
		    else
	    		if int2eq(modo,443::int2) then
	    			trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				end if;
			    else
				trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				    if booleq(trans,'f')then
					trans:=hay_contrato(usuario,directo,modo::int2,operacion,5::int2);
					if booleq(trans,'f')then
					    trans:=hay_contrato(usuario,directo,modo::int2,operacion,2::int2);
					end if;
				    end if;
				end if;
			end if;
		end if;
	    else
		trans:='t';		
	end if;
	retval:=trans;
    end if;
else
    retval:='t';		
end if;

    RETURN retval;
    END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.hay_cont_valido(integer, integer, smallint) OWNER TO zona;

--
-- Name: hay_contrato(integer, integer, smallint, integer, smallint); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION hay_contrato(integer, integer, smallint, integer, smallint) RETURNS boolean
    AS $_$
declare
directo		 alias for $1;
indirecto	 alias for $2;
caso 		 alias for $3;  -- 1 valida que exista contrato
				-- 2 valida que exista y este aprobado
				-- 3 valida que exista contrato y no graba noticias
				-- 4 valida que exista y este aprobado y no graba noticias
				-- 43 valida que exista y este aprobado y no graba noticias
				-- 5 valida que exista y este aprobado y no haya ni reprocidad ni indirecto locador ni
operacion	 alias for $4;
tipo_contrato alias for $5;
aux_texto	 text;
ret 		 boolean;
registro	 RECORD;
estado		 int2;
unifun		 int2;
hayuno	 	 int2;
hayunoaprob	 int2;

begin
ret:='f';
hayuno:=0;
hayunoaprob:=0;

if(int4ne(directo,indirecto)) then
    if caso!=5 then
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt)=tipo_contrato
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;
      else
	for registro in select 
	    * from contratos where contr_locador=directo and contr_locatario=indirecto and tipo_de_contrato(contr_idsubt) in (4::int2,5::int2)
	loop
		    hayuno:=1;
    		    if int2eq(registro.contr_estado,1::int2) then
			hayunoaprob:=1;
		    end if;
	end loop;

    end if;

  else

	hayuno:=1;
	hayunoaprob:=1;
 end if;

if caso=1 and hayuno=1 then
    ret:=true;
end if;

if int2ne(caso,1::int2) and hayunoaprob=1 then     
    ret:=true;
end if;

if caso=2 and hayuno=1  and hayunoaprob=0 then
    aux_texto:='No Existe Contrato Aprobado  tipo  '||nomtipc(tipo_contrato)||' entre '||nomusu(directo) ||' y '||nomusu(indirecto)||' !!!!!!!';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;

if  hayuno=0  and hayunoaprob=0 and int2ne(caso,4::int2) and int4ne(directo,1) then
    aux_texto:='No Existe Contrato Aprobado  de tipo  '||nomtipc(tipo_contrato)||' entre '||nomusu(directo) ||' y '||nomusu(indirecto)||' !!!!!!!';
    insert into noticias(not_tipo,not_numero,not_texto)values(1,operacion,aux_texto);
end if;
return ret;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.hay_contrato(integer, integer, smallint, integer, smallint) OWNER TO zona;

--
-- Name: indiconcontr(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION indiconcontr(integer, integer) RETURNS boolean
    AS $_$
declare
locador		 alias for $1;
locatario	 alias for $2;
temporal	 integer;
ret 		 boolean;
begin
ret:='f';

select contr_locatario into temporal from contratos where contr_locador=locador and contr_locatario =locatario and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;

if found then
    ret:='t';
end if;

return ret;

end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.indiconcontr(integer, integer) OWNER TO zona;

--
-- Name: pruebaindi(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION pruebaindi(integer, integer) RETURNS boolean
    AS $_$select 't'::boolean as temporal from contratos where contr_locador = $1 and contr_locatario = $2 and contr_estado=1 and contr_idsubt in (7,8,9) limit 1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.pruebaindi(integer, integer) OWNER TO zona;


--
-- Name: stepcontr(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION stepcontr(integer) RETURNS smallint
    AS $_$select contr_step from contratos where contr_id= $1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.stepcontr(integer) OWNER TO zona;

--
-- Name: ulticont(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ulticont(integer) RETURNS integer
    AS $_$
declare
opid		 alias for $1;
ret 		 int4;
begin
select max(contr_id) into ret from contratos;
return ret;
end;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.ulticont(integer) OWNER TO zona;

--
-- Name: ultiopeindi(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION ultiopeindi(integer) RETURNS integer
    AS $_$select op_id from operaciones WHERE op_estado=101 and op_tipoper in (101,105) and op_indirecto= $1 order by op_fechain desc limit 1;$_$
    LANGUAGE sql;


ALTER FUNCTION public.ultiopeindi(integer) OWNER TO zona;





--
-- Name: fechaevento(integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fechaevento(integer, integer) RETURNS date
    AS $_$select fechac_fecha from feccontra where fechac_idcontra= $1 and fechac_codevent= $2;$_$
    LANGUAGE sql;


ALTER FUNCTION public.fechaevento(integer, integer) OWNER TO zona;
