CREATE TABLE menues (
    men_id serial NOT NULL,
    men_titulo text NOT NULL,
    men_tipo smallint DEFAULT 1,
    men_idmenu integer,
    men_estado smallint DEFAULT 1
);


ALTER TABLE public.menues OWNER TO zona;


ALTER TABLE ONLY menues
    ADD CONSTRAINT menues_pkey PRIMARY KEY (men_id);


REVOKE ALL ON TABLE menues FROM PUBLIC;
REVOKE ALL ON TABLE menues FROM zona;
GRANT ALL ON TABLE menues TO zona;
GRANT ALL ON TABLE menues TO nobody;

REVOKE ALL ON TABLE menues_men_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE menues_men_id_seq FROM zona;
GRANT ALL ON TABLE menues_men_id_seq TO zona;
GRANT UPDATE ON TABLE menues_men_id_seq TO nobody;

CREATE TABLE relmenu (
    rmen_id serial NOT NULL,
    rmen_titulo text NOT NULL,
    rmen_link text NOT NULL,
    rmen_tipo smallint DEFAULT 1,
    rmen_idmenu integer,
    rmen_nivel smallint DEFAULT 0,
    rmen_estado smallint DEFAULT 1
);


ALTER TABLE public.relmenu OWNER TO zona;


ALTER TABLE ONLY relmenu
    ADD CONSTRAINT relmenu_pkey PRIMARY KEY (rmen_id);


REVOKE ALL ON TABLE relmenu FROM PUBLIC;
REVOKE ALL ON TABLE relmenu FROM zona;
GRANT ALL ON TABLE relmenu TO zona;
GRANT ALL ON TABLE relmenu TO nobody;

REVOKE ALL ON TABLE relmenu_rmen_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE relmenu_rmen_id_seq FROM zona;
GRANT ALL ON TABLE relmenu_rmen_id_seq TO zona;
GRANT UPDATE ON TABLE relmenu_rmen_id_seq TO nobody;

CREATE TABLE usermenu (
    umen_id serial NOT NULL,
    umen_operador integer NOT NULL,
    umen_idmenu integer,
    umen_estado smallint DEFAULT 1
);


ALTER TABLE public.usermenu OWNER TO zona;


ALTER TABLE ONLY usermenu
    ADD CONSTRAINT usermenu_pkey PRIMARY KEY (umen_id);


REVOKE ALL ON TABLE usermenu FROM PUBLIC;
REVOKE ALL ON TABLE usermenu FROM zona;
GRANT ALL ON TABLE usermenu TO zona;
GRANT ALL ON TABLE usermenu TO nobody;

REVOKE ALL ON TABLE usermenu_umen_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE usermenu_umen_id_seq FROM zona;
GRANT ALL ON TABLE usermenu_umen_id_seq TO zona;
GRANT UPDATE ON TABLE usermenu_umen_id_seq TO nobody;

