SET default_with_oids = true;

CREATE TABLE comis (
    com_id serial NOT NULL,
    com_nombre character varying(140) NOT NULL,
    com_idusu integer,
    com_fecini date,
    com_fech date,
    com_deudor smallint DEFAULT 1,
    com_estado smallint DEFAULT 1,
    com_leyenda text
);

ALTER TABLE ONLY comis ADD CONSTRAINT comis_pkey PRIMARY KEY (com_id);

CREATE INDEX idx_comis_1 ON comis USING btree (com_nombre);
CREATE INDEX idx_comis_2 ON comis USING btree (com_idusu);

REVOKE ALL ON TABLE comis FROM PUBLIC;
REVOKE ALL ON TABLE comis FROM zona;
GRANT ALL ON TABLE comis TO zona;
GRANT ALL ON TABLE comis TO nobody;

REVOKE ALL ON TABLE comis_com_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE comis_com_id_seq FROM zona;
GRANT ALL ON TABLE comis_com_id_seq TO zona;
GRANT UPDATE ON TABLE comis_com_id_seq TO nobody;
