CREATE OR REPLACE FUNCTION datos_emp_nueva(integer, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
codempo		 alias for $1;
codempd		 alias for $2;
ptovtao		 alias for $3;
ptovtad		 alias for $4;
ret 		 boolean;
registro	 record;
regi		 record;
elcomprob 	 integer;
eltalon 	 integer;
existe	 	 integer;
subdid	 	 integer;
compid	 	 integer;
compcodigo	character varying;
subdnombre	character varying;
begin
ret:='f';

	for registro in select * from comprob where comp_codemp=codempo and comp_idptov=ptovtao
	    loop
		insert into comprob (comp_codemp,comp_idptov,comp_codigo,comp_nombre,comp_copias) 
		    values (codempd,ptovtad,registro.comp_codigo,registro.comp_nombre,1);

		select comp_id into elcomprob from comprob where comp_codemp=codempd and comp_idptov=ptovtad and comp_codigo=registro.comp_codigo;

		insert into talon (tal_codemp,tal_idptov,tal_comprob,tal_nombre,tal_valor,tal_fecha,tal_vald,tal_valh) values (codempd,ptovtad,elcomprob,registro.comp_nombre,1,'01-01-2015',1,999999);

		select tal_id into eltalon from talon where tal_codemp=codempd and tal_idptov=ptovtad and tal_comprob=elcomprob;

		update comprob set comp_talon=eltalon where comp_id=elcomprob;
		ret:='t';
	    end loop;

	insert into varambi (vari_codemp,vari_idptov,vari_codigo,vari_nombre,vari_valor,vari_tipo) 
	    select codempd,ptovtad,vari_codigo,vari_nombre,vari_valor,vari_tipo from varambi where vari_codemp=codempo and vari_idptov=ptovtao;

    if(int4ne(codempo,codempd)) then

	select vari_codemp into existe from varambi where vari_codemp=codempd and vari_idptov=0 limit 1;
	if not found then
	    insert into varambi (vari_codemp,vari_idptov,vari_codigo,vari_nombre,vari_valor,vari_tipo) select codempd,ptovtad,vari_codigo,vari_nombre,vari_valor,vari_tipo from varambi where vari_codemp=codempo and vari_idptov=0;
	end if;

	insert into ctacble (cbl_codemp,cbl_codigo,cbl_nombre,cbl_identi,cbl_nivel,cbl_posic,cbl_asigna,cbl_moneda,cbl_tipcta,cbl_monetaria,cbl_ajuste,cbl_indice,cbl_ctarei,cbl_ctaaju,cbl_leyed,cbl_leyeh,cbl_present) 
	    select codempd,cbl_codigo,cbl_nombre,cbl_identi,cbl_nivel,cbl_posic,cbl_asigna,cbl_moneda,cbl_tipcta,cbl_monetaria,cbl_ajuste,cbl_indice,cbl_ctarei,cbl_ctaaju,cbl_leyed,cbl_leyeh,cbl_present from ctacble where cbl_codemp=codempo;

	insert into conpag (cdp_codemp,cdp_nombre,cdp_dias) 
	    select codempd,cdp_nombre,cdp_dias from conpag where cdp_codemp=codempo;

	insert into convmult (cmt_codemp,cmt_provin,cmt_tasa,cmt_coef) 
	    select codempd,cmt_provin,cmt_tasa,cmt_coef from convmult where cmt_codemp=codempo;

	insert into cotiza (cot_codemp,cot_moneda,cot_fecha,cot_cotiz) 
	    select codempd,cot_moneda,cot_fecha,cot_cotiz from cotiza where cot_codemp=codempo;

	insert into cblexasi (cxa_codemp,cxa_tipasi,cxa_cble) 
	    select codempd,cxa_tipasi,cxa_cble from cblexasi where cxa_codemp=codempo;

	insert into interes (int_codemp,int_fecha,int_valor) 
	    select codempd,int_fecha,int_valor from interes where int_codemp=codempo;

	insert into subd (subd_codemp,subd_idptov,subd_nombre,subd_titulo,subd_fecd,subd_fech,subd_estado,subd_proxnum,subd_orden,subd_dia) 
	    select codempd,ptovtad,subd_nombre,subd_titulo,subd_fecd,subd_fech,subd_estado,subd_proxnum,subd_orden,subd_dia from subd where subd_codemp=codempo;

	insert into tipasi (tas_codemp,tas_codigo,tas_nombre) 
	    select codempd,tas_codigo,tas_nombre from tipasi where tas_codemp=codempo;

	for regi in select * from subxcomp where subxc_codemp=codempo
	    loop

	    select subd_nombre into subdnombre from subd where subd_id=regi.subxc_idsub;
	    select subd_id into subdid from subd where subd_codemp=codempd and bpchareq(subd_nombre,subdnombre);

	    select comp_codigo into compcodigo from comprob where comp_id=regi.subxc_comprob;
	    select comp_id into compid from comprob where comp_codemp=codempd and bpchareq(comp_codigo,compcodigo);

	    insert into subxcomp (subxc_idsub,subxc_comprob,subxc_codemp) values (subdid,compid,codempd);
	end loop;
    end if;

    return ret;
end;$_$;


ALTER FUNCTION public.datos_emp_nueva(integer, integer, integer, integer) OWNER TO elm;
