DROP TABLE inflacion;
CREATE TABLE inflacion (
    inf_id integer NOT NULL,
    inf_mes integer,
    inf_anio integer,
    inf_coef numeric,
    inf_fecreg timestamp without time zone DEFAULT now(),
    inf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE inflacion OWNER TO zona;

--
-- Name: inflacion_inf_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inflacion_inf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inflacion_inf_id_seq OWNER TO zona;

--
-- Name: inflacion_inf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inflacion_inf_id_seq OWNED BY inflacion.inf_id;


--
-- Name: inf_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inflacion ALTER COLUMN inf_id SET DEFAULT nextval('inflacion_inf_id_seq'::regclass);


--
-- Data for Name: inflacion; Type: TABLE DATA; Schema: public; Owner: zona
--

COPY inflacion (inf_id, inf_mes, inf_anio, inf_coef, inf_fecreg, inf_estado) FROM stdin;
1	1	1993	7.4671	2019-06-05 15:07:46.985141	1
2	2	1993	7.501	2019-06-05 15:07:46.999026	1
3	3	1993	7.5229	2019-06-05 15:07:47.007296	1
4	4	1993	7.562	2019-06-05 15:07:47.015621	1
5	5	1993	7.538	2019-06-05 15:07:47.023954	1
6	6	1993	7.5523	2019-06-05 15:07:47.032395	1
7	7	1993	7.56	2019-06-05 15:07:47.040663	1
8	8	1993	7.5932	2019-06-05 15:07:47.048997	1
9	9	1993	7.5642	2019-06-05 15:07:47.057325	1
10	10	1993	7.5769	2019-06-05 15:07:47.065651	1
11	11	1993	7.5111	2019-06-05 15:07:47.073983	1
12	12	1993	7.4489	2019-06-05 15:07:47.082318	1
13	1	1994	7.4126	2019-06-05 15:07:47.090655	1
14	2	1994	7.3659	2019-06-05 15:07:47.098986	1
15	3	1994	7.3719	2019-06-05 15:07:47.10732	1
16	4	1994	7.3983	2019-06-05 15:07:47.115684	1
17	5	1994	7.4849	2019-06-05 15:07:47.123987	1
18	6	1994	7.5437	2019-06-05 15:07:47.13232	1
19	7	1994	7.5813	2019-06-05 15:07:47.140649	1
20	8	1994	7.5738	2019-06-05 15:07:47.148987	1
21	9	1994	7.573	2019-06-05 15:07:47.15732	1
22	10	1994	7.5941	2019-06-05 15:07:47.165653	1
23	11	1994	7.6559	2019-06-05 15:07:47.173988	1
24	12	1994	7.6687	2019-06-05 15:07:47.182321	1
25	1	1995	7.7772	2019-06-05 15:07:47.19065	1
26	2	1995	7.8073	2019-06-05 15:07:47.198986	1
27	3	1995	7.7606	2019-06-05 15:07:47.207319	1
28	4	1995	8.0205	2019-06-05 15:07:47.215658	1
29	5	1995	8.0303	2019-06-05 15:07:47.223982	1
30	6	1995	8.0552	2019-06-05 15:07:47.232315	1
31	7	1995	8.0853	2019-06-05 15:07:47.240652	1
32	8	1995	8.1102	2019-06-05 15:07:47.248983	1
33	9	1995	8.1117	2019-06-05 15:07:47.257319	1
34	10	1995	8.1026	2019-06-05 15:07:47.265651	1
35	11	1995	8.0883	2019-06-05 15:07:47.273985	1
36	12	1995	8.1154	2019-06-05 15:07:47.28232	1
37	1	1996	8.1335	2019-06-05 15:07:47.290853	1
38	2	1996	8.1252	2019-06-05 15:07:47.298989	1
39	3	1996	8.1885	2019-06-05 15:07:47.30732	1
40	4	1996	8.3105	2019-06-05 15:07:47.315655	1
41	5	1996	8.3294	2019-06-05 15:07:47.323985	1
42	6	1996	8.2668	2019-06-05 15:07:47.332316	1
43	7	1996	8.2571	2019-06-05 15:07:47.340696	1
44	8	1996	8.2314	2019-06-05 15:07:47.349029	1
45	9	1996	8.3256	2019-06-05 15:07:47.35736	1
46	10	1996	8.3595	2019-06-05 15:07:47.365695	1
47	11	1996	8.294	2019-06-05 15:07:47.374025	1
48	12	1996	8.2827	2019-06-05 15:07:47.38236	1
49	1	1997	8.3128	2019-06-05 15:07:47.390693	1
50	2	1997	8.2985	2019-06-05 15:07:47.399028	1
51	3	1997	8.2744	2019-06-05 15:07:47.40736	1
52	4	1997	8.2382	2019-06-05 15:07:47.415693	1
53	5	1997	8.2902	2019-06-05 15:07:47.424042	1
54	6	1997	8.2571	2019-06-05 15:07:47.43238	1
55	7	1997	8.2209	2019-06-05 15:07:47.440714	1
56	8	1997	8.2774	2019-06-05 15:07:47.449042	1
57	9	1997	8.2879	2019-06-05 15:07:47.45738	1
58	10	1997	8.2781	2019-06-05 15:07:47.465717	1
59	11	1997	8.2608	2019-06-05 15:07:47.474047	1
60	12	1997	8.2066	2019-06-05 15:07:47.482377	1
61	1	1998	8.1026	2019-06-05 15:07:47.490714	1
62	2	1998	8.1312	2019-06-05 15:07:47.499048	1
63	3	1998	8.1102	2019-06-05 15:07:47.50738	1
64	4	1998	8.1169	2019-06-05 15:07:47.515713	1
65	5	1998	8.1004	2019-06-05 15:07:47.524074	1
66	6	1998	8.1004	2019-06-05 15:07:47.532379	1
67	7	1998	8.0763	2019-06-05 15:07:47.540706	1
68	8	1998	8.025	2019-06-05 15:07:47.549044	1
69	9	1998	7.9407	2019-06-05 15:07:47.557377	1
70	10	1998	7.8548	2019-06-05 15:07:47.565714	1
71	11	1998	7.7817	2019-06-05 15:07:47.574042	1
72	12	1998	7.6928	2019-06-05 15:07:47.582452	1
73	1	1999	7.6582	2019-06-05 15:07:47.5908	1
74	2	1999	7.5949	2019-06-05 15:07:47.599128	1
75	3	1999	7.6107	2019-06-05 15:07:47.607387	1
76	4	1999	7.6845	2019-06-05 15:07:47.615738	1
77	5	1999	7.6815	2019-06-05 15:07:47.624061	1
78	6	1999	7.6747	2019-06-05 15:07:47.632342	1
79	7	1999	7.6891	2019-06-05 15:07:47.640712	1
80	8	1999	7.7086	2019-06-05 15:07:47.649112	1
81	9	1999	7.7734	2019-06-05 15:07:47.65744	1
82	10	1999	7.7644	2019-06-05 15:07:47.665774	1
83	11	1999	7.7478	2019-06-05 15:07:47.674107	1
84	12	1999	7.7855	2019-06-05 15:07:47.682439	1
85	1	2000	7.8789	2019-06-05 15:07:47.690774	1
86	2	2000	7.9474	2019-06-05 15:07:47.699105	1
87	3	2000	7.9881	2019-06-05 15:07:47.707433	1
88	4	2000	7.8909	2019-06-05 15:07:47.715771	1
89	5	2000	7.9738	2019-06-05 15:07:47.724139	1
90	6	2000	8.016	2019-06-05 15:07:47.732446	1
91	7	2000	8.0047	2019-06-05 15:07:47.740772	1
92	8	2000	8.019	2019-06-05 15:07:47.749111	1
93	9	2000	8.1162	2019-06-05 15:07:47.757447	1
94	10	2000	8.1328	2019-06-05 15:07:47.765773	1
95	11	2000	8.123	2019-06-05 15:07:47.774109	1
96	12	2000	7.9723	2019-06-05 15:07:47.782441	1
97	1	2001	7.9753	2019-06-05 15:07:47.791345	1
98	2	2001	7.9844	2019-06-05 15:07:47.799149	1
99	3	2001	7.9316	2019-06-05 15:07:47.807446	1
100	4	2001	7.9166	2019-06-05 15:07:47.815814	1
101	5	2001	7.9226	2019-06-05 15:07:47.824142	1
102	6	2001	7.8872	2019-06-05 15:07:47.832436	1
103	7	2001	7.8593	2019-06-05 15:07:47.840773	1
104	8	2001	7.8209	2019-06-05 15:07:47.849106	1
105	9	2001	7.787	2019-06-05 15:07:47.857441	1
106	10	2001	7.6702	2019-06-05 15:07:47.865772	1
107	11	2001	7.5633	2019-06-05 15:07:47.874106	1
108	12	2001	7.5497	2019-06-05 15:07:47.882441	1
109	1	2002	8.0303	2019-06-05 15:07:47.890773	1
110	2	2002	9.0202	2019-06-05 15:07:47.899108	1
111	3	2002	10.1546	2019-06-05 15:07:47.907442	1
112	4	2002	12.1765	2019-06-05 15:07:47.915771	1
113	5	2002	13.6779	2019-06-05 15:07:47.924121	1
114	6	2002	14.8463	2019-06-05 15:07:47.932519	1
115	7	2002	15.5363	2019-06-05 15:07:47.940785	1
116	8	2002	16.3197	2019-06-05 15:07:47.94911	1
117	9	2002	16.7175	2019-06-05 15:07:47.957485	1
118	10	2002	16.8004	2019-06-05 15:07:47.96582	1
119	11	2002	16.5216	2019-06-05 15:07:47.974146	1
120	12	2002	16.4553	2019-06-05 15:07:47.982483	1
121	1	2003	16.5246	2019-06-05 15:07:47.990812	1
122	2	2003	16.5887	2019-06-05 15:07:47.999159	1
123	3	2003	16.4749	2019-06-05 15:07:48.007559	1
124	4	2003	16.1736	2019-06-05 15:07:48.015893	1
125	5	2003	16.0704	2019-06-05 15:07:48.024216	1
126	6	2003	16.0486	2019-06-05 15:07:48.032474	1
127	7	2003	16.0425	2019-06-05 15:07:48.040801	1
128	8	2003	16.2617	2019-06-05 15:07:48.049133	1
129	9	2003	16.2339	2019-06-05 15:07:48.057466	1
130	10	2003	16.3205	2019-06-05 15:07:48.065798	1
131	11	2003	16.49	2019-06-05 15:07:48.074129	1
132	12	2003	16.777	2019-06-05 15:07:48.082464	1
133	1	2004	16.7205	2019-06-05 15:07:48.090798	1
134	2	2004	16.9533	2019-06-05 15:07:48.099131	1
135	3	2004	17.0271	2019-06-05 15:07:48.107466	1
136	4	2004	17.1635	2019-06-05 15:07:48.11582	1
137	5	2004	17.3842	2019-06-05 15:07:48.124148	1
138	6	2004	17.4233	2019-06-05 15:07:48.132464	1
139	7	2004	17.5831	2019-06-05 15:07:48.140798	1
140	8	2004	18.0087	2019-06-05 15:07:48.149131	1
141	9	2004	18.0509	2019-06-05 15:07:48.157463	1
142	10	2004	18.1563	2019-06-05 15:07:48.165797	1
143	11	2004	17.9401	2019-06-05 15:07:48.17413	1
144	12	2004	18.0968	2019-06-05 15:07:48.182467	1
145	1	2005	17.9235	2019-06-05 15:07:48.190796	1
146	2	2005	18.1141	2019-06-05 15:07:48.199128	1
147	3	2005	18.4712	2019-06-05 15:07:48.207462	1
148	4	2005	18.7409	2019-06-05 15:07:48.215795	1
149	5	2005	18.7273	2019-06-05 15:07:48.224147	1
150	6	2005	18.7718	2019-06-05 15:07:48.232464	1
151	7	2005	19.0068	2019-06-05 15:07:48.2408	1
152	8	2005	19.2441	2019-06-05 15:07:48.249131	1
153	9	2005	19.608	2019-06-05 15:07:48.257463	1
154	10	2005	19.8287	2019-06-05 15:07:48.265841	1
155	11	2005	19.8445	2019-06-05 15:07:48.274173	1
156	12	2005	20.0223	2019-06-05 15:07:48.474178	1
157	1	2006	20.2942	2019-06-05 15:07:48.482503	1
158	2	2006	20.6151	2019-06-05 15:07:48.490836	1
159	3	2006	20.4871	2019-06-05 15:07:48.499173	1
160	4	2006	20.7839	2019-06-05 15:07:48.507525	1
161	5	2006	20.8667	2019-06-05 15:07:48.515843	1
162	6	2006	21.0347	2019-06-05 15:07:48.524189	1
163	7	2006	21.1846	2019-06-05 15:07:48.532524	1
164	8	2006	21.321	2019-06-05 15:07:48.540854	1
165	9	2006	21.2652	2019-06-05 15:07:48.549194	1
166	10	2006	21.3534	2019-06-05 15:07:48.557522	1
167	11	2006	21.3737	2019-06-05 15:07:48.565854	1
168	12	2006	21.4581	2019-06-05 15:07:48.574189	1
169	1	2007	21.5334	2019-06-05 15:07:48.582607	1
170	2	2007	21.712	2019-06-05 15:07:48.590958	1
171	3	2007	21.8475	2019-06-05 15:07:48.599232	1
172	4	2007	22.2257	2019-06-05 15:07:48.607543	1
173	5	2007	22.5707	2019-06-05 15:07:48.615903	1
174	6	2007	23.0099	2019-06-05 15:07:48.624217	1
175	7	2007	23.532	2019-06-05 15:07:48.632605	1
176	8	2007	23.7112	2019-06-05 15:07:48.640929	1
177	9	2007	23.9546	2019-06-05 15:07:48.649195	1
178	10	2007	24.1753	2019-06-05 15:07:48.657536	1
179	11	2007	24.4284	2019-06-05 15:07:48.665859	1
180	12	2007	24.5821	2019-06-05 15:07:48.674176	1
181	1	2008	24.7764	2019-06-05 15:07:48.682504	1
182	2	2008	25.0062	2019-06-05 15:07:48.690848	1
183	3	2008	25.2857	2019-06-05 15:07:48.715904	1
184	4	2008	25.5975	2019-06-05 15:07:48.724234	1
185	5	2008	25.871	2019-06-05 15:07:48.732609	1
186	6	2008	26.1806	2019-06-05 15:07:48.740989	1
187	7	2008	26.3787	2019-06-05 15:07:48.749249	1
188	8	2008	26.5987	2019-06-05 15:07:48.75758	1
189	9	2008	26.7471	2019-06-05 15:07:48.765831	1
190	10	2008	26.8947	2019-06-05 15:07:48.77416	1
191	11	2008	26.8202	2019-06-05 15:07:48.782533	1
192	12	2008	26.7501	2019-06-05 15:07:48.790864	1
193	1	2009	26.7283	2019-06-05 15:07:48.799198	1
194	2	2009	26.7659	2019-06-05 15:07:48.807528	1
195	3	2009	27.0725	2019-06-05 15:07:48.815879	1
196	4	2009	27.2006	2019-06-05 15:07:48.832636	1
197	5	2009	27.3302	2019-06-05 15:07:48.840964	1
198	6	2009	27.639	2019-06-05 15:07:48.849232	1
199	7	2009	27.9833	2019-06-05 15:07:48.857564	1
200	8	2009	28.2748	2019-06-05 15:07:48.865894	1
201	9	2009	28.5641	2019-06-05 15:07:48.874217	1
202	10	2009	28.8285	2019-06-05 15:07:48.882557	1
203	11	2009	29.1321	2019-06-05 15:07:48.890885	1
204	12	2009	29.4967	2019-06-05 15:07:48.899222	1
205	1	2010	29.8944	2019-06-05 15:07:48.907554	1
206	2	2010	30.3539	2019-06-05 15:07:48.915888	1
207	3	2010	30.815	2019-06-05 15:07:48.924232	1
208	4	2010	31.1713	2019-06-05 15:07:48.93263	1
209	5	2010	31.5479	2019-06-05 15:07:48.9409	1
210	6	2010	31.9314	2019-06-05 15:07:48.949228	1
211	7	2010	32.2402	2019-06-05 15:07:48.95755	1
212	8	2010	32.5619	2019-06-05 15:07:48.96589	1
213	9	2010	32.8655	2019-06-05 15:07:48.974224	1
214	10	2010	33.163	2019-06-05 15:07:48.982555	1
215	11	2010	33.4757	2019-06-05 15:07:48.990885	1
216	12	2010	33.7913	2019-06-05 15:07:48.999224	1
217	1	2011	34.1612	2019-06-05 15:07:49.007555	1
218	2	2011	34.4791	2019-06-05 15:07:49.015882	1
219	3	2011	34.8105	2019-06-05 15:07:49.024231	1
220	4	2011	35.1601	2019-06-05 15:07:49.032625	1
221	5	2011	35.5217	2019-06-05 15:07:49.040895	1
222	6	2011	35.9269	2019-06-05 15:07:49.049225	1
223	7	2011	36.2885	2019-06-05 15:07:49.057627	1
224	8	2011	36.6569	2019-06-05 15:07:49.065893	1
225	9	2011	37.0328	2019-06-05 15:07:49.074223	1
226	10	2011	37.3703	2019-06-05 15:07:49.082561	1
227	11	2011	37.7266	2019-06-05 15:07:49.090886	1
228	12	2011	38.0739	2019-06-05 15:07:49.099259	1
229	1	2012	38.4385	2019-06-05 15:07:49.107595	1
230	2	2012	38.8182	2019-06-05 15:07:49.115945	1
231	3	2012	39.2769	2019-06-05 15:07:49.124268	1
232	4	2012	39.7214	2019-06-05 15:07:49.132595	1
233	5	2012	40.1267	2019-06-05 15:07:49.140921	1
234	6	2012	40.5244	2019-06-05 15:07:49.149263	1
235	7	2012	40.9176	2019-06-05 15:07:49.157591	1
236	8	2012	41.341	2019-06-05 15:07:49.165927	1
237	9	2012	41.8013	2019-06-05 15:07:49.174264	1
238	10	2012	42.2337	2019-06-05 15:07:49.182594	1
239	11	2012	42.6578	2019-06-05 15:07:49.190923	1
240	12	2012	43.0721	2019-06-05 15:07:49.199259	1
241	1	2013	43.5098	2019-06-05 15:07:49.207594	1
242	2	2013	43.9693	2019-06-05 15:07:49.215931	1
243	3	2013	44.4123	2019-06-05 15:07:49.224268	1
244	4	2013	44.8386	2019-06-05 15:07:49.232594	1
245	5	2013	45.4021	2019-06-05 15:07:49.240925	1
246	6	2013	46.013	2019-06-05 15:07:49.249266	1
247	7	2013	46.5343	2019-06-05 15:07:49.257589	1
248	8	2013	47.0609	2019-06-05 15:07:49.265925	1
249	9	2013	47.5754	2019-06-05 15:07:49.274256	1
250	10	2013	48.1178	2019-06-05 15:07:49.282594	1
251	11	2013	48.7031	2019-06-05 15:07:49.290978	1
252	12	2013	49.4301	2019-06-05 15:07:49.299281	1
253	1	2014	51.8783	2019-06-05 15:07:49.307599	1
254	2	2014	54.5353	2019-06-05 15:07:49.315929	1
255	3	2014	55.8626	2019-06-05 15:07:49.324264	1
256	4	2014	56.8231	2019-06-05 15:07:49.332594	1
257	5	2014	57.8845	2019-06-05 15:07:49.340926	1
258	6	2014	58.7561	2019-06-05 15:07:49.349258	1
259	7	2014	59.547	2019-06-05 15:07:49.35759	1
260	8	2014	60.5188	2019-06-05 15:07:49.365924	1
261	9	2014	61.4838	2019-06-05 15:07:49.374256	1
262	10	2014	62.2371	2019-06-05 15:07:49.38259	1
263	11	2014	62.8051	2019-06-05 15:07:49.390923	1
264	12	2014	63.4032	2019-06-05 15:07:49.399256	1
265	1	2015	63.5306	2019-06-05 15:07:49.407634	1
266	2	2015	63.6887	2019-06-05 15:07:49.415964	1
267	3	2015	64.3132	2019-06-05 15:07:49.424299	1
268	4	2015	64.7923	2019-06-05 15:07:49.457708	1
269	5	2015	65.7528	2019-06-05 15:07:49.473428	1
270	6	2015	66.6176	2019-06-05 15:07:49.490973	1
271	7	2015	67.5751	2019-06-05 15:07:49.499308	1
272	8	2015	68.5401	2019-06-05 15:07:49.507636	1
273	9	2015	69.4659	2019-06-05 15:07:49.51597	1
274	10	2015	70.11	2019-06-05 15:07:49.524305	1
275	11	2015	71.5122	2019-06-05 15:07:49.532707	1
276	12	2015	74.3012	2019-06-05 15:07:49.540977	1
277	1	2016	80.9883	2019-06-05 15:07:49.549306	1
278	2	2016	85.0377	2019-06-05 15:07:49.557634	1
279	3	2016	87.0786	2019-06-05 15:07:49.565971	1
280	4	2016	88.3847	2019-06-05 15:07:49.574302	1
281	5	2016	91.5666	2019-06-05 15:07:49.582639	1
282	6	2016	94.222	2019-06-05 15:07:49.591069	1
283	7	2016	96.766	2019-06-05 15:07:49.599403	1
284	8	2016	97.1531	2019-06-05 15:07:49.607674	1
285	9	2016	97.5417	2019-06-05 15:07:49.616079	1
286	10	2016	98.127	2019-06-05 15:07:49.624336	1
287	11	2016	99.2063	2019-06-05 15:07:49.63266	1
288	12	2016	100	2019-06-05 15:07:49.641065	1
289	1	2017	101.5859	2019-06-05 15:07:49.649383	1
290	2	2017	103.6859	2019-06-05 15:07:49.657643	1
291	3	2017	106.1476	2019-06-05 15:07:49.665978	1
292	4	2017	108.9667	2019-06-05 15:07:49.67431	1
293	5	2017	110.5301	2019-06-05 15:07:49.682642	1
294	6	2017	111.8477	2019-06-05 15:07:49.690975	1
295	7	2017	113.7852	2019-06-05 15:07:49.699304	1
296	8	2017	115.3819	2019-06-05 15:07:49.707636	1
297	9	2017	117.5719	2019-06-05 15:07:49.715978	1
298	10	2017	119.3528	2019-06-05 15:07:49.724313	1
299	11	2017	120.994	2019-06-05 15:07:49.732627	1
300	12	2017	124.7956	2019-06-05 15:07:49.741036	1
301	1	2018	126.9887	2019-06-05 15:07:49.749413	1
302	2	2018	130.0606	2019-06-05 15:07:49.75767	1
303	3	2018	133.1054	2019-06-05 15:07:49.765999	1
304	4	2018	136.7512	2019-06-05 15:07:49.774334	1
305	5	2018	139.5893	2019-06-05 15:07:49.782666	1
306	6	2018	144.8053	2019-06-05 15:07:49.790998	1
307	7	2018	149.2966	2019-06-05 15:07:49.799333	1
308	8	2018	155.1034	2019-06-05 15:07:49.807665	1
309	9	2018	165.2383	2019-06-05 15:07:49.816013	1
310	10	2018	174.1473	2019-06-05 15:07:49.82435	1
311	11	2018	179.6388	2019-06-05 15:07:49.832683	1
312	12	2018	184.2552	2019-06-05 15:07:49.841019	1
313	1	2019	189.6101	2019-06-05 15:07:49.84935	1
314	2	2019	196.7501	2019-06-05 15:07:49.857681	1
315	3	2019	205.9571	2019-07-17 16:14:07.383276	1
316	4	2019	213.0517	2019-07-17 16:14:11.455046	1
317	5	2019	219.5691	2019-07-17 16:14:15.927077	1
318	6	2019	225.5370	2019-07-17 16:14:21.60687	1
319	7	2019	230.4990	2020-02-11 14:37:42.907027	1
320	8	2019	239.6077	2020-02-11 14:38:07.317171	1
321	9	2019	253.7102	2020-02-11 14:38:27.646554	1
322	10	2019	262.0661	2020-02-11 14:38:51.675224	1
323	11	2019	273.2158	2020-02-11 14:39:14.499733	1
324	12	2019	283.4442	2020-02-11 14:39:35.636527	1
327	1	2020	289.8299	2020-03-10 09:07:51.892717	1
\.


--
-- Name: inflacion_inf_id_seq; Type: SEQUENCE SET; Schema: public; Owner: zona
--

SELECT pg_catalog.setval('inflacion_inf_id_seq', 327, true);


--
-- Name: inflacion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY inflacion
    ADD CONSTRAINT inflacion_pkey PRIMARY KEY (inf_id);


--
-- Name: inflacion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE inflacion FROM PUBLIC;
REVOKE ALL ON TABLE inflacion FROM zona;
GRANT ALL ON TABLE inflacion TO zona;
GRANT ALL ON TABLE inflacion TO nobody;


--
-- Name: inflacion_inf_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE inflacion_inf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inflacion_inf_id_seq FROM zona;
GRANT ALL ON SEQUENCE inflacion_inf_id_seq TO zona;
GRANT UPDATE ON SEQUENCE inflacion_inf_id_seq TO nobody;


--
-- PostgreSQL database dump complete
--

