/*
create or replace function nomusu (int4) 
    returns varchar
    AS 'select usu_nombre from usuarios where usu_codigo = $1;'
    language 'sql';

create or replace function nomart (int4) 
    returns varchar
    AS 'select artic_descrip from articu where artic_id = $1;'
    language 'sql';
*/
drop VIEW stock1; 	
CREATE VIEW stock1 as 	
    select  
	    o.op_directo as directo,
	    nomusu(o.op_directo::int4) as nomclid,
	    o.op_indirecto as indirecto,
	    nomusu(o.op_indirecto::int4) as nomcli,
	    o.op_compbte as comprobante,
	    traigo_codarticu(a.sitem_artic), 
	    traigo_nomarticu(a.sitem_artic), 
	    precio_unitario(a.sitem_id),
	    traigo_moneda(a.sitem_iditem),
	    a.sitem_deposito as deposito,
	    a.sitem_canting as ingresada,
	    a.sitem_cantcomp as comprometida,
	    a.sitem_cantret as retirada,
	    a.sitem_cantmala as malacondi,
	    a.sitem_canting -  a.sitem_cantret as stock,
	    cantidad_disponible(a.sitem_id) as disponible,
	    b.item_tipprod as tipoprod,
	    a.sitem_artic as articulo
	    from operaciones o,subitem a, item b
	    where o.op_id=a.sitem_idoper
	    and a.sitem_estado=1
	    and a.sitem_iditem=b.item_id;
