drop table wretiros;
drop table wsubitem;

CREATE TABLE wsubitem (
    wsitem_id        integer NOT NULL,
    wsitem_iditem    integer NOT NULL,
    wsitem_idoper    integer,
    wsitem_codigo    smallint DEFAULT 0 NOT NULL,
    wsitem_artic     integer,
    wsitem_canting   numeric(15,5) DEFAULT 0 NOT NULL,
    wsitem_cantret   numeric(15,5) DEFAULT 0,
    wsitem_cantcomp  numeric(15,5) DEFAULT 0,
    wsitem_cantmala  numeric(15,5) DEFAULT 0,
    wsitem_importe   numeric(15,2) DEFAULT 0 NOT NULL,
    wsitem_imp_dolar numeric(15,2) DEFAULT 0,
    wsitem_volumen   numeric(15,5) DEFAULT 0,
    wsitem_peso      numeric(15,5) DEFAULT 0,
    wsitem_tipemb    smallint,
    wsitem_deposito  smallint,
    wsitem_idacta    integer,
    wsitem_estado    integer DEFAULT 1,
    wsitem_directo   integer NOT NULL,
    wsitem_indirecto integer NOT NULL,
    wsitem_consig    integer,
    wsitem_compbte   character varying(16),
    wsitem_item      smallint DEFAULT 0 NOT NULL,
    wsitem_moneda    smallint,
    wsitem_unimed    smallint,
    wsitem_comptrans character(16) DEFAULT 'DATO DESCONOCIDO',
    wsitem_tipoper   integer,
    wsitem_nrotaldir integer NOT NULL,
    wsitem_codart    character varying(40) NOT NULL,
    wsitem_marca     character varying(40),
    wsitem_modelo    character varying(40),
    wsitem_descrip   character varying(40),
    wsitem_posa      character varying(15),
    wsitem_cantcompw numeric(15,5) DEFAULT 0
);


REVOKE ALL ON TABLE wsubitem FROM PUBLIC;
GRANT ALL ON TABLE wsubitem TO nobody;

CREATE UNIQUE INDEX idx_wsubitem_1 ON wsubitem USING btree (wsitem_id);
CREATE INDEX idx_wsubitem_2 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto);
CREATE INDEX idx_wsubitem_3 ON wsubitem USING btree (wsitem_compbte);
CREATE INDEX idx_wsubitem_4 ON wsubitem USING btree (wsitem_comptrans);
CREATE INDEX idx_wsubitem_5 ON wsubitem USING btree (wsitem_codart);
CREATE INDEX idx_wsubitem_6 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_consig);
CREATE INDEX idx_wsubitem_7 ON wsubitem USING btree (wsitem_directo, wsitem_consig);
CREATE INDEX idx_wsubitem_8 ON wsubitem USING btree (wsitem_indirecto, wsitem_codart);
CREATE INDEX idx_wsubitem_9 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte);
CREATE INDEX idx_wsubitem_10 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_artic);
CREATE INDEX idx_wsubitem_11 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_compbte, wsitem_artic);
CREATE INDEX idx_wsubitem_12 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_codart);
CREATE INDEX idx_wsubitem_13 ON wsubitem USING btree (wsitem_directo, wsitem_indirecto, wsitem_idoper);


CREATE TABLE wretiros (
    wret_id          serial NOT NULL,
    wret_idopera     integer NOT NULL,
    wret_idsitem     integer NOT NULL,
    wret_item        smallint DEFAULT 1 NOT NULL,
    wret_sitem       smallint DEFAULT 0 NOT NULL,
    wret_cantidad    numeric(15,5) DEFAULT 0 NOT NULL,
    wret_idsitemc    integer,
    wret_compbte     character(16) DEFAULT 'DATO DESCONOCIDO',
    wret_tipoper     integer,
    wret_nrotaldir   integer NOT NULL,
    wret_fecha       date DEFAULT 'today()',
    wret_estado      smallint DEFAULT 1
);


REVOKE ALL ON TABLE wretiros FROM PUBLIC;
GRANT ALL ON TABLE wretiros TO nobody;
GRANT UPDATE ON wretiros_wret_id_seq TO nobody;

CREATE UNIQUE INDEX idx_wretiros_1 ON wretiros USING btree (wret_id);
CREATE INDEX idx_wretiros_2 ON wretiros USING btree (wret_idsitem);
CREATE INDEX idx_wretiros_3 ON wretiros USING btree (wret_compbte);

ALTER TABLE ONLY wretiros
    ADD CONSTRAINT "$1" FOREIGN KEY (wret_idsitem) REFERENCES wsubitem (wsitem_id) ON UPDATE NO ACTION ON DELETE NO ACTION;

