CREATE OR REPLACE FUNCTION procdif(integer, integer, date, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idptov		ALIAS FOR $1; 
	ctacble		ALIAS FOR $2;
	fechad		ALIAS FOR $3;
	fechah		ALIAS FOR $4;
	codemp		integer;
	saldo 		numeric;
	coef		numeric;
	coefref		numeric;
	coefaa		numeric;
	coefrel		numeric;
	auximp		numeric;
	mesd		integer;
	aniod		integer;
	mesh		integer;
	anioh		integer;
	mesa		integer;
	anioa		integer;
	tipcta		integer;
	registro	record;
    BEGIN

    select ptv_codemp into codemp from ptovta where ptv_id=idptov;

    select date_part('month',fechad)::integer,date_part('year',fechad)::integer into mesd,aniod;
    select date_part('month',fechah)::integer,date_part('year',fechah)::integer into mesh,anioh;

    mesa:=mesd;
    anioa:=aniod;

    if int4eq(mesd,1) then
	mesa:=12;
	anioa:=anioa-1;
    else
	mesa:=mesa-1;
    end if;

    select inf_coef into coefaa from inflacion where inf_mes=mesa and inf_anio=anioa;
    if coefaa is null then
	coefaa:=1;
    end if;

    RAISE NOTICE 'COEFAA %, PERIODO %-%',coefaa,mesa,anioa;

    mesa:=mesd;
    anioa:=aniod;


    select inf_coef into coefref from inflacion where inf_mes=mesh and inf_anio=anioh;
    if coefref is null then
	coefref:=1;
    end if;


    coefaa:=coefref/coefaa;
    RAISE NOTICE 'COEFAA %',coefaa;
    coefaa:=coefaa-1;
    RAISE NOTICE 'COEFAA %',coefaa;

    if int4lt(mesh,12) then
	mesh:=mesh+1;
    else
	mesh:=1;
	anioh:=anioh+1;
    end if;

    saldo:=0;

    while int4ne(mesa,mesh) or int4ne(anioa,anioh) loop

	RAISE NOTICE 'PERIODO AVANZO %-%, HASTA %-%',mesa,anioa,mesh,anioh;

	select inf_coef into coef from inflacion where inf_mes=mesa and inf_anio=anioa;
	if coef is null then
	    coef:=1;
	end if;


	RAISE NOTICE 'SALDO % ',saldo;

	saldo:=0;

	if int4eq(mesa,mesd) and int4eq(anioa,aniod) then
	    RAISE NOTICE 'PERIODO AVANZO AA %-%, DESDE %-%',mesa,anioa,mesd,aniod;
	    if int4gt(idptov,0) then
		select astc_importe into saldo from astoctas where codcomp(astc_comprob)='AA' and astc_idptov=idptov and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesd and date_part('year',astc_fecval)::integer=aniod;
	    else
		select astc_importe into saldo from astoctas where codcomp(astc_comprob)='AA' and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesd and date_part('year',astc_fecval)::integer=aniod;
	    end if;
	    if saldo is not null then
		saldo:=saldo*coefaa;
	    end if;
	end if;

	if saldo is null then
	    saldo:=0;
	end if;

	coefrel:=coefref/coef;
	coefrel:=coefrel-1;

	if int4gt(idptov,0) then
	    for registro in select * from astoctas where codcomp(astc_comprob) not in ('AA') and astc_idptov=idptov and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesa and date_part('year',astc_fecval)::integer=anioa order by 1 loop 
		saldo:=saldo+(registro.astc_importe*coefrel);
	    end loop;
	    insert into difcta (dc_mes,dc_anio,dc_ctacble,dc_importeacum,dc_codemp,dc_idptov) values (mesa,anioa,ctacble,saldo,codemp,idptov);
	else
	    for registro in select * from astoctas where codcomp(astc_comprob) not in ('AA') and astc_estado=2 and astc_ctacble=ctacble and date_part('month',astc_fecval)::integer=mesa and date_part('year',astc_fecval)::integer=anioa order by 1 loop 
		saldo:=saldo+(registro.astc_importe*coefrel);
	    end loop;
	    insert into difcta (dc_mes,dc_anio,dc_ctacble,dc_importeacum,dc_codemp,dc_idptov) values (mesa,anioa,ctacble,saldo,codemp,idptov);
	end if;

	RAISE NOTICE 'SALDO % ',saldo;

	if int4lt(mesa,12) then
	    mesa:=mesa+1;
	else
	    mesa:=1;
	    anioa:=anioa+1;
	end if;

    end loop;

    RETURN 1;
    END;$_$;


ALTER FUNCTION public.procdif(integer, integer, date, date) OWNER TO zona;
