--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: acciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE acciones (
    acc_id integer NOT NULL,
    acc_iduser integer,
    acc_idtipo integer,
    acc_fecha date,
    acc_anio integer,
    acc_mes integer,
    acc_dow integer,
    acc_obs text,
    acc_fecreg timestamp without time zone DEFAULT now(),
    acc_estado integer DEFAULT 1 NOT NULL,
    acc_idcli integer,
    acc_woy integer
);


ALTER TABLE acciones OWNER TO zona;

--
-- Name: acciones_acc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE acciones_acc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE acciones_acc_id_seq OWNER TO zona;

--
-- Name: acciones_acc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE acciones_acc_id_seq OWNED BY acciones.acc_id;


--
-- Name: adjuntos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE adjuntos (
    a_id integer NOT NULL,
    a_idinbox integer,
    a_file text,
    a_fecreg timestamp without time zone DEFAULT now(),
    a_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE adjuntos OWNER TO zona;

--
-- Name: adjuntos_a_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE adjuntos_a_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE adjuntos_a_id_seq OWNER TO zona;

--
-- Name: adjuntos_a_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE adjuntos_a_id_seq OWNED BY adjuntos.a_id;


--
-- Name: agencias; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE agencias (
    ag_id integer NOT NULL,
    ag_nombre text,
    ag_fecreg timestamp without time zone DEFAULT now(),
    ag_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE agencias OWNER TO zona;

--
-- Name: agencias_ag_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE agencias_ag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agencias_ag_id_seq OWNER TO zona;

--
-- Name: agencias_ag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE agencias_ag_id_seq OWNED BY agencias.ag_id;


--
-- Name: agxgpo; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE agxgpo (
    ag_id integer NOT NULL,
    ag_idgpo integer,
    ag_iduser integer,
    ag_fecreg timestamp without time zone DEFAULT now(),
    ag_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE agxgpo OWNER TO zona;

--
-- Name: agxgpo_ag_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE agxgpo_ag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agxgpo_ag_id_seq OWNER TO zona;

--
-- Name: agxgpo_ag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE agxgpo_ag_id_seq OWNED BY agxgpo.ag_id;


--
-- Name: cal; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cal (
    c_id integer NOT NULL,
    c_titulo text NOT NULL,
    c_inicio timestamp without time zone NOT NULL,
    c_fin timestamp without time zone NOT NULL,
    c_operador integer NOT NULL,
    c_clase text NOT NULL,
    c_estado integer DEFAULT 1,
    c_idacc integer,
    c_tipoacc integer
);


ALTER TABLE cal OWNER TO zona;

--
-- Name: cal_c_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE cal_c_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cal_c_id_seq OWNER TO zona;

--
-- Name: cal_c_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE cal_c_id_seq OWNED BY cal.c_id;


--
-- Name: clientes; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE clientes (
    cli_id integer NOT NULL,
    cli_iduser integer,
    cli_titulo character varying(15),
    cli_nombre text,
    cli_necesidades text,
    cli_personalidad text,
    cli_horarios text,
    cli_estilovida text,
    cli_preferencias text,
    cli_empresa text,
    cli_puesto text,
    cli_pasion text,
    cli_nivel text,
    cli_viajes text,
    cli_fecreg timestamp without time zone DEFAULT now(),
    cli_estado integer DEFAULT 1 NOT NULL,
    cli_genero character varying(1),
    cli_nacimiento date,
    cli_categoria character varying(1),
    cli_lastcontact date,
    cli_telefono text,
    cli_mail text,
    cli_operbaja integer,
    cli_fecbaja timestamp without time zone,
    cli_obs text,
    cli_profesion text,
    cli_civil text,
    cli_hijos text,
    cli_mascotas text,
    cli_escritura text,
    cli_prov text
);


ALTER TABLE clientes OWNER TO zona;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE clientes_cli_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE clientes_cli_id_seq OWNER TO zona;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE clientes_cli_id_seq OWNED BY clientes.cli_id;


--
-- Name: country; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE country (
    id integer NOT NULL,
    name text NOT NULL,
    status integer NOT NULL
);


ALTER TABLE country OWNER TO zona;

--
-- Name: country_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE country_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE country_id_seq OWNER TO zona;

--
-- Name: country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE country_id_seq OWNED BY country.id;


--
-- Name: diaslaborales; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE diaslaborales (
    dl_id integer NOT NULL,
    dl_agencia integer,
    dl_dow integer,
    dl_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE diaslaborales OWNER TO zona;

--
-- Name: diaslaborales_dl_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE diaslaborales_dl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE diaslaborales_dl_id_seq OWNER TO zona;

--
-- Name: diaslaborales_dl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE diaslaborales_dl_id_seq OWNED BY diaslaborales.dl_id;


--
-- Name: domicilio; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE domicilio (
    d_id integer NOT NULL,
    d_idcli integer,
    d_calle text,
    d_ciudad text,
    d_provincia text,
    d_codpos text,
    d_fecreg timestamp without time zone DEFAULT now(),
    d_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE domicilio OWNER TO zona;

--
-- Name: domicilio_d_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE domicilio_d_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE domicilio_d_id_seq OWNER TO zona;

--
-- Name: domicilio_d_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE domicilio_d_id_seq OWNED BY domicilio.d_id;


--
-- Name: feriados; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE feriados (
    f_id integer NOT NULL,
    f_dia integer,
    f_mes integer,
    f_anio integer,
    f_modo integer DEFAULT 1,
    f_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE feriados OWNER TO zona;

--
-- Name: feriados_f_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE feriados_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE feriados_f_id_seq OWNER TO zona;

--
-- Name: feriados_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE feriados_f_id_seq OWNED BY feriados.f_id;


--
-- Name: groups; Type: TABLE; Schema: public; Owner: nobody; Tablespace: 
--

CREATE TABLE groups (
    id integer NOT NULL,
    name character varying(20) NOT NULL,
    description character varying(100) NOT NULL,
    root text DEFAULT '/'::text,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE groups OWNER TO nobody;

--
-- Name: groups_id_seq; Type: SEQUENCE; Schema: public; Owner: nobody
--

CREATE SEQUENCE groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE groups_id_seq OWNER TO nobody;

--
-- Name: groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: nobody
--

ALTER SEQUENCE groups_id_seq OWNED BY groups.id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE grupos (
    g_id integer NOT NULL,
    g_nombre text,
    g_fecreg timestamp without time zone DEFAULT now(),
    g_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE grupos OWNER TO zona;

--
-- Name: grupos_g_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE grupos_g_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupos_g_id_seq OWNER TO zona;

--
-- Name: grupos_g_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE grupos_g_id_seq OWNED BY grupos.g_id;


--
-- Name: inbox; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE inbox (
    i_id integer NOT NULL,
    i_de integer,
    i_para integer,
    i_asunto text,
    i_mensaje text,
    i_dia date DEFAULT (now())::date,
    i_hora time without time zone DEFAULT (now())::time without time zone,
    i_fecreg timestamp without time zone DEFAULT now(),
    i_estado integer DEFAULT 1 NOT NULL,
    i_respuesta integer,
    i_fwd integer,
    i_estadosend integer DEFAULT 1
);


ALTER TABLE inbox OWNER TO zona;

--
-- Name: inbox_i_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE inbox_i_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE inbox_i_id_seq OWNER TO zona;

--
-- Name: inbox_i_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE inbox_i_id_seq OWNED BY inbox.i_id;


--
-- Name: objetivos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE objetivos (
    obj_id integer NOT NULL,
    obj_role character varying(255),
    obj_tipoaccion integer,
    obj_periodicidad integer,
    obj_orden integer,
    obj_objetivo integer,
    obj_fecreg timestamp without time zone DEFAULT now(),
    obj_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE objetivos OWNER TO zona;

--
-- Name: objetivos_obj_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE objetivos_obj_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE objetivos_obj_id_seq OWNER TO zona;

--
-- Name: objetivos_obj_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE objetivos_obj_id_seq OWNED BY objetivos.obj_id;


--
-- Name: settings; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE settings (
    settings_id integer NOT NULL,
    type text NOT NULL,
    description text NOT NULL
);


ALTER TABLE settings OWNER TO zona;

--
-- Name: settings_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE settings_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE settings_settings_id_seq OWNER TO zona;

--
-- Name: settings_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE settings_settings_id_seq OWNED BY settings.settings_id;


--
-- Name: telefonos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE telefonos (
    t_id integer NOT NULL,
    t_idcli integer,
    t_entidad integer,
    t_valor character varying(300),
    t_obs text,
    t_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE telefonos OWNER TO zona;

--
-- Name: telefonos_t_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE telefonos_t_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE telefonos_t_id_seq OWNER TO zona;

--
-- Name: telefonos_t_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE telefonos_t_id_seq OWNED BY telefonos.t_id;


--
-- Name: tipoaccion; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipoaccion (
    ta_id integer NOT NULL,
    ta_nombre character varying(300),
    ta_estado integer DEFAULT 1 NOT NULL,
    ta_cliente integer,
    ta_calendar integer,
    ta_icon character varying(50),
    ta_class text,
    ta_duracion text
);


ALTER TABLE tipoaccion OWNER TO zona;

--
-- Name: tipoaccion_ta_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipoaccion_ta_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipoaccion_ta_id_seq OWNER TO zona;

--
-- Name: tipoaccion_ta_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipoaccion_ta_id_seq OWNED BY tipoaccion.ta_id;


--
-- Name: tipoentidad; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE tipoentidad (
    te_id integer NOT NULL,
    te_nombre character varying(300),
    te_estado integer DEFAULT 1 NOT NULL,
    te_logo text
);


ALTER TABLE tipoentidad OWNER TO zona;

--
-- Name: tipoentidad_te_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE tipoentidad_te_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipoentidad_te_id_seq OWNER TO zona;

--
-- Name: tipoentidad_te_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE tipoentidad_te_id_seq OWNED BY tipoentidad.te_id;


--
-- Name: user_rel_ptovta_rel_ufs; Type: TABLE; Schema: public; Owner: nobody; Tablespace: 
--

CREATE TABLE user_rel_ptovta_rel_ufs (
    id integer NOT NULL,
    id_user integer NOT NULL,
    ptv_id integer NOT NULL,
    ufd integer NOT NULL,
    estado integer NOT NULL,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE user_rel_ptovta_rel_ufs OWNER TO nobody;

--
-- Name: user_rel_ptovta_rel_ufs_id_seq; Type: SEQUENCE; Schema: public; Owner: nobody
--

CREATE SEQUENCE user_rel_ptovta_rel_ufs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE user_rel_ptovta_rel_ufs_id_seq OWNER TO nobody;

--
-- Name: user_rel_ptovta_rel_ufs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: nobody
--

ALTER SEQUENCE user_rel_ptovta_rel_ufs_id_seq OWNED BY user_rel_ptovta_rel_ufs.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: nobody; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    ip_address character varying(45),
    username character varying(100),
    password character varying(255) NOT NULL,
    salt character varying(255),
    email character varying(100) NOT NULL,
    activation_code character varying(40),
    forgotten_password_code character varying(40),
    forgotten_password_time integer,
    remember_code character varying(40),
    created_on integer NOT NULL,
    last_login integer,
    active integer,
    first_name character varying(50),
    last_name character varying(50),
    company character varying(100),
    phone character varying(20),
    CONSTRAINT check_active CHECK ((active >= 0)),
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE users OWNER TO nobody;

--
-- Name: users_groups; Type: TABLE; Schema: public; Owner: nobody; Tablespace: 
--

CREATE TABLE users_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL,
    CONSTRAINT users_groups_check_group_id CHECK ((group_id >= 0)),
    CONSTRAINT users_groups_check_id CHECK ((id >= 0)),
    CONSTRAINT users_groups_check_user_id CHECK ((user_id >= 0))
);


ALTER TABLE users_groups OWNER TO nobody;

--
-- Name: users_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: nobody
--

CREATE SEQUENCE users_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE users_groups_id_seq OWNER TO nobody;

--
-- Name: users_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: nobody
--

ALTER SEQUENCE users_groups_id_seq OWNED BY users_groups.id;


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: nobody
--

CREATE SEQUENCE users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE users_id_seq OWNER TO nobody;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: nobody
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: acc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY acciones ALTER COLUMN acc_id SET DEFAULT nextval('acciones_acc_id_seq'::regclass);


--
-- Name: a_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY adjuntos ALTER COLUMN a_id SET DEFAULT nextval('adjuntos_a_id_seq'::regclass);


--
-- Name: ag_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY agencias ALTER COLUMN ag_id SET DEFAULT nextval('agencias_ag_id_seq'::regclass);


--
-- Name: ag_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY agxgpo ALTER COLUMN ag_id SET DEFAULT nextval('agxgpo_ag_id_seq'::regclass);


--
-- Name: c_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY cal ALTER COLUMN c_id SET DEFAULT nextval('cal_c_id_seq'::regclass);


--
-- Name: cli_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY clientes ALTER COLUMN cli_id SET DEFAULT nextval('clientes_cli_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY country ALTER COLUMN id SET DEFAULT nextval('country_id_seq'::regclass);


--
-- Name: dl_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY diaslaborales ALTER COLUMN dl_id SET DEFAULT nextval('diaslaborales_dl_id_seq'::regclass);


--
-- Name: d_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY domicilio ALTER COLUMN d_id SET DEFAULT nextval('domicilio_d_id_seq'::regclass);


--
-- Name: f_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY feriados ALTER COLUMN f_id SET DEFAULT nextval('feriados_f_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: nobody
--

ALTER TABLE ONLY groups ALTER COLUMN id SET DEFAULT nextval('groups_id_seq'::regclass);


--
-- Name: g_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY grupos ALTER COLUMN g_id SET DEFAULT nextval('grupos_g_id_seq'::regclass);


--
-- Name: i_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY inbox ALTER COLUMN i_id SET DEFAULT nextval('inbox_i_id_seq'::regclass);


--
-- Name: obj_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY objetivos ALTER COLUMN obj_id SET DEFAULT nextval('objetivos_obj_id_seq'::regclass);


--
-- Name: settings_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY settings ALTER COLUMN settings_id SET DEFAULT nextval('settings_settings_id_seq'::regclass);


--
-- Name: t_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY telefonos ALTER COLUMN t_id SET DEFAULT nextval('telefonos_t_id_seq'::regclass);


--
-- Name: ta_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipoaccion ALTER COLUMN ta_id SET DEFAULT nextval('tipoaccion_ta_id_seq'::regclass);


--
-- Name: te_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY tipoentidad ALTER COLUMN te_id SET DEFAULT nextval('tipoentidad_te_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: nobody
--

ALTER TABLE ONLY user_rel_ptovta_rel_ufs ALTER COLUMN id SET DEFAULT nextval('user_rel_ptovta_rel_ufs_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: nobody
--

ALTER TABLE ONLY users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: nobody
--

ALTER TABLE ONLY users_groups ALTER COLUMN id SET DEFAULT nextval('users_groups_id_seq'::regclass);


--
-- Name: acciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY acciones
    ADD CONSTRAINT acciones_pkey PRIMARY KEY (acc_id);


--
-- Name: adjuntos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY adjuntos
    ADD CONSTRAINT adjuntos_pkey PRIMARY KEY (a_id);


--
-- Name: agencias_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY agencias
    ADD CONSTRAINT agencias_pkey PRIMARY KEY (ag_id);


--
-- Name: agxgpo_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY agxgpo
    ADD CONSTRAINT agxgpo_pkey PRIMARY KEY (ag_id);


--
-- Name: cal_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY cal
    ADD CONSTRAINT cal_pkey PRIMARY KEY (c_id);


--
-- Name: clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT clientes_pkey PRIMARY KEY (cli_id);


--
-- Name: country_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY country
    ADD CONSTRAINT country_pkey PRIMARY KEY (id);


--
-- Name: diaslaborales_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY diaslaborales
    ADD CONSTRAINT diaslaborales_pkey PRIMARY KEY (dl_id);


--
-- Name: domicilio_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY domicilio
    ADD CONSTRAINT domicilio_pkey PRIMARY KEY (d_id);


--
-- Name: feriados_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY feriados
    ADD CONSTRAINT feriados_pkey PRIMARY KEY (f_id);


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: nobody; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (g_id);


--
-- Name: inbox_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY inbox
    ADD CONSTRAINT inbox_pkey PRIMARY KEY (i_id);


--
-- Name: objetivos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY objetivos
    ADD CONSTRAINT objetivos_pkey PRIMARY KEY (obj_id);


--
-- Name: settings_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY settings
    ADD CONSTRAINT settings_pkey PRIMARY KEY (settings_id);


--
-- Name: telefonos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY telefonos
    ADD CONSTRAINT telefonos_pkey PRIMARY KEY (t_id);


--
-- Name: tipoaccion_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipoaccion
    ADD CONSTRAINT tipoaccion_pkey PRIMARY KEY (ta_id);


--
-- Name: tipoentidad_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY tipoentidad
    ADD CONSTRAINT tipoentidad_pkey PRIMARY KEY (te_id);


--
-- Name: uc_users_groups; Type: CONSTRAINT; Schema: public; Owner: nobody; Tablespace: 
--

ALTER TABLE ONLY users_groups
    ADD CONSTRAINT uc_users_groups UNIQUE (user_id, group_id);


--
-- Name: user_rel_ptovta_rel_ufs_pkey; Type: CONSTRAINT; Schema: public; Owner: nobody; Tablespace: 
--

ALTER TABLE ONLY user_rel_ptovta_rel_ufs
    ADD CONSTRAINT user_rel_ptovta_rel_ufs_pkey PRIMARY KEY (id);


--
-- Name: users_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: nobody; Tablespace: 
--

ALTER TABLE ONLY users_groups
    ADD CONSTRAINT users_groups_pkey PRIMARY KEY (id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: nobody; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: acciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE acciones FROM PUBLIC;
REVOKE ALL ON TABLE acciones FROM zona;
GRANT ALL ON TABLE acciones TO zona;
GRANT ALL ON TABLE acciones TO nobody;


--
-- Name: acciones_acc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE acciones_acc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE acciones_acc_id_seq FROM zona;
GRANT ALL ON SEQUENCE acciones_acc_id_seq TO zona;
GRANT ALL ON SEQUENCE acciones_acc_id_seq TO nobody;


--
-- Name: adjuntos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE adjuntos FROM PUBLIC;
REVOKE ALL ON TABLE adjuntos FROM zona;
GRANT ALL ON TABLE adjuntos TO zona;
GRANT ALL ON TABLE adjuntos TO nobody;


--
-- Name: adjuntos_a_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE adjuntos_a_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE adjuntos_a_id_seq FROM zona;
GRANT ALL ON SEQUENCE adjuntos_a_id_seq TO zona;
GRANT ALL ON SEQUENCE adjuntos_a_id_seq TO nobody;


--
-- Name: agencias; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE agencias FROM PUBLIC;
REVOKE ALL ON TABLE agencias FROM zona;
GRANT ALL ON TABLE agencias TO zona;
GRANT ALL ON TABLE agencias TO nobody;


--
-- Name: agencias_ag_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE agencias_ag_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE agencias_ag_id_seq FROM zona;
GRANT ALL ON SEQUENCE agencias_ag_id_seq TO zona;
GRANT ALL ON SEQUENCE agencias_ag_id_seq TO nobody;


--
-- Name: agxgpo; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE agxgpo FROM PUBLIC;
REVOKE ALL ON TABLE agxgpo FROM zona;
GRANT ALL ON TABLE agxgpo TO zona;
GRANT ALL ON TABLE agxgpo TO nobody;


--
-- Name: agxgpo_ag_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE agxgpo_ag_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE agxgpo_ag_id_seq FROM zona;
GRANT ALL ON SEQUENCE agxgpo_ag_id_seq TO zona;
GRANT ALL ON SEQUENCE agxgpo_ag_id_seq TO nobody;


--
-- Name: cal; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cal FROM PUBLIC;
REVOKE ALL ON TABLE cal FROM zona;
GRANT ALL ON TABLE cal TO zona;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE cal TO nobody;


--
-- Name: cal_c_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE cal_c_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cal_c_id_seq FROM zona;
GRANT ALL ON SEQUENCE cal_c_id_seq TO zona;
GRANT SELECT,USAGE ON SEQUENCE cal_c_id_seq TO nobody;


--
-- Name: clientes; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE clientes FROM PUBLIC;
REVOKE ALL ON TABLE clientes FROM zona;
GRANT ALL ON TABLE clientes TO zona;
GRANT ALL ON TABLE clientes TO nobody;


--
-- Name: clientes_cli_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM zona;
GRANT ALL ON SEQUENCE clientes_cli_id_seq TO zona;
GRANT ALL ON SEQUENCE clientes_cli_id_seq TO nobody;


--
-- Name: country; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE country FROM PUBLIC;
REVOKE ALL ON TABLE country FROM zona;
GRANT ALL ON TABLE country TO zona;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE country TO nobody;


--
-- Name: country_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE country_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE country_id_seq FROM zona;
GRANT ALL ON SEQUENCE country_id_seq TO zona;
GRANT SELECT,USAGE ON SEQUENCE country_id_seq TO nobody;


--
-- Name: diaslaborales; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE diaslaborales FROM PUBLIC;
REVOKE ALL ON TABLE diaslaborales FROM zona;
GRANT ALL ON TABLE diaslaborales TO zona;
GRANT ALL ON TABLE diaslaborales TO nobody;


--
-- Name: diaslaborales_dl_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE diaslaborales_dl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE diaslaborales_dl_id_seq FROM zona;
GRANT ALL ON SEQUENCE diaslaborales_dl_id_seq TO zona;
GRANT ALL ON SEQUENCE diaslaborales_dl_id_seq TO nobody;


--
-- Name: domicilio; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE domicilio FROM PUBLIC;
REVOKE ALL ON TABLE domicilio FROM zona;
GRANT ALL ON TABLE domicilio TO zona;
GRANT ALL ON TABLE domicilio TO nobody;


--
-- Name: domicilio_d_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE domicilio_d_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE domicilio_d_id_seq FROM zona;
GRANT ALL ON SEQUENCE domicilio_d_id_seq TO zona;
GRANT ALL ON SEQUENCE domicilio_d_id_seq TO nobody;


--
-- Name: feriados; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE feriados FROM PUBLIC;
REVOKE ALL ON TABLE feriados FROM zona;
GRANT ALL ON TABLE feriados TO zona;
GRANT ALL ON TABLE feriados TO nobody;


--
-- Name: feriados_f_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE feriados_f_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE feriados_f_id_seq FROM zona;
GRANT ALL ON SEQUENCE feriados_f_id_seq TO zona;
GRANT ALL ON SEQUENCE feriados_f_id_seq TO nobody;


--
-- Name: groups_id_seq; Type: ACL; Schema: public; Owner: nobody
--

REVOKE ALL ON SEQUENCE groups_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE groups_id_seq FROM nobody;
GRANT ALL ON SEQUENCE groups_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM zona;
GRANT ALL ON TABLE grupos TO zona;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: grupos_g_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE grupos_g_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupos_g_id_seq FROM zona;
GRANT ALL ON SEQUENCE grupos_g_id_seq TO zona;
GRANT ALL ON SEQUENCE grupos_g_id_seq TO nobody;


--
-- Name: inbox; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE inbox FROM PUBLIC;
REVOKE ALL ON TABLE inbox FROM zona;
GRANT ALL ON TABLE inbox TO zona;
GRANT ALL ON TABLE inbox TO nobody;


--
-- Name: inbox_i_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE inbox_i_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inbox_i_id_seq FROM zona;
GRANT ALL ON SEQUENCE inbox_i_id_seq TO zona;
GRANT ALL ON SEQUENCE inbox_i_id_seq TO nobody;


--
-- Name: objetivos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE objetivos FROM PUBLIC;
REVOKE ALL ON TABLE objetivos FROM zona;
GRANT ALL ON TABLE objetivos TO zona;
GRANT ALL ON TABLE objetivos TO nobody;


--
-- Name: objetivos_obj_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE objetivos_obj_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE objetivos_obj_id_seq FROM zona;
GRANT ALL ON SEQUENCE objetivos_obj_id_seq TO zona;
GRANT ALL ON SEQUENCE objetivos_obj_id_seq TO nobody;


--
-- Name: settings; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE settings FROM PUBLIC;
REVOKE ALL ON TABLE settings FROM zona;
GRANT ALL ON TABLE settings TO zona;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE settings TO nobody;


--
-- Name: settings_settings_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE settings_settings_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE settings_settings_id_seq FROM zona;
GRANT ALL ON SEQUENCE settings_settings_id_seq TO zona;
GRANT SELECT,USAGE ON SEQUENCE settings_settings_id_seq TO nobody;


--
-- Name: telefonos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE telefonos FROM PUBLIC;
REVOKE ALL ON TABLE telefonos FROM zona;
GRANT ALL ON TABLE telefonos TO zona;
GRANT ALL ON TABLE telefonos TO nobody;


--
-- Name: telefonos_t_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE telefonos_t_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefonos_t_id_seq FROM zona;
GRANT ALL ON SEQUENCE telefonos_t_id_seq TO zona;
GRANT ALL ON SEQUENCE telefonos_t_id_seq TO nobody;


--
-- Name: tipoaccion; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipoaccion FROM PUBLIC;
REVOKE ALL ON TABLE tipoaccion FROM zona;
GRANT ALL ON TABLE tipoaccion TO zona;
GRANT ALL ON TABLE tipoaccion TO nobody;


--
-- Name: tipoaccion_ta_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipoaccion_ta_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipoaccion_ta_id_seq FROM zona;
GRANT ALL ON SEQUENCE tipoaccion_ta_id_seq TO zona;
GRANT ALL ON SEQUENCE tipoaccion_ta_id_seq TO nobody;


--
-- Name: tipoentidad; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE tipoentidad FROM PUBLIC;
REVOKE ALL ON TABLE tipoentidad FROM zona;
GRANT ALL ON TABLE tipoentidad TO zona;
GRANT ALL ON TABLE tipoentidad TO nobody;


--
-- Name: tipoentidad_te_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE tipoentidad_te_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipoentidad_te_id_seq FROM zona;
GRANT ALL ON SEQUENCE tipoentidad_te_id_seq TO zona;
GRANT ALL ON SEQUENCE tipoentidad_te_id_seq TO nobody;


--
-- Name: user_rel_ptovta_rel_ufs_id_seq; Type: ACL; Schema: public; Owner: nobody
--

REVOKE ALL ON SEQUENCE user_rel_ptovta_rel_ufs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE user_rel_ptovta_rel_ufs_id_seq FROM nobody;
GRANT ALL ON SEQUENCE user_rel_ptovta_rel_ufs_id_seq TO nobody;


--
-- Name: users_groups_id_seq; Type: ACL; Schema: public; Owner: nobody
--

REVOKE ALL ON SEQUENCE users_groups_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_groups_id_seq FROM nobody;
GRANT ALL ON SEQUENCE users_groups_id_seq TO nobody;


--
-- Name: users_id_seq; Type: ACL; Schema: public; Owner: nobody
--

REVOKE ALL ON SEQUENCE users_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_id_seq FROM nobody;
GRANT ALL ON SEQUENCE users_id_seq TO nobody;


--
-- PostgreSQL database dump complete
--

