--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: act_talon(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION act_talon(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select tal_valor from talon where tal_id = $1;$_$;


ALTER FUNCTION public.act_talon(integer) OWNER TO artl;

--
-- Name: anioastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION anioastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_anio from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.anioastoh(integer) OWNER TO artl;

--
-- Name: ashdeastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ashdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idastoh from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ashdeastc(integer) OWNER TO artl;

--
-- Name: astcdecomp(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION astcdecomp(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 limit 1 ;$_$;


ALTER FUNCTION public.astcdecomp(integer, integer) OWNER TO artl;

--
-- Name: astcdecompximp(integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION astcdecompximp(integer, integer, numeric) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_importe= $3 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompximp(integer, integer, numeric) OWNER TO artl;

--
-- Name: cantchq(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cantchq(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques where chq_idastoc= $1;$_$;


ALTER FUNCTION public.cantchq(integer) OWNER TO artl;

--
-- Name: cantchq(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cantchq(integer, integer) RETURNS bigint
    LANGUAGE plpgsql
    AS $_$
declare
astc	 alias for $1;
modo	 alias for $2;
ret	 integer;
begin

ret:=0;

if(int4eq(modo,1)) then
    select count(*) into ret from cheques where chq_idastoc= astc;
else
    select count(*) into ret from cheques where chq_idastoce= astc;
end if;

return ret;
end;$_$;


ALTER FUNCTION public.cantchq(integer, integer) OWNER TO artl;

--
-- Name: cargo_articu_receta(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cargo_articu_receta(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
elcodemp	 alias for $1;
ret		 boolean;
registro	 record;
codigoart	 character varying;
elidarticu	 integer;
begin
ret:='f';

	for registro in select * from articvta where art_codemp=elcodemp order by 1
	    loop
		insert into articu (artc_codemp,artc_idptov,artc_codigo,artc_tasa,artc_stock,artc_nivrep,artc_unimed,artc_present,artc_peso,artc_estado,artc_codrub,artc_codsrb,artc_automatoper,artc_nombre,artc_leyen,artc_tipo,artc_codcbl,artc_funcion,artc_precio,artc_idcbl)
		     values (registro.art_codemp,registro.art_idptov,registro.art_codigo,registro.art_tasa,registro.art_stock,registro.art_nivrep,registro.art_unimed,registro.art_present,registro.art_peso,registro.art_estado,registro.art_codrub,registro.art_codsrb,registro.art_automatoper,registro.art_nombre,registro.art_leyen,registro.art_tipo,registro.art_codcbl,registro.art_funcion,registro.art_precio,registro.art_idcbl);

		select artc_id into elidarticu from articu where artc_codigo=registro.art_codigo;

		insert into receta (re_codemp,re_idptov,re_articv,re_articc,re_canti,re_estado) values (elcodemp,registro.art_idptov,registro.art_id,elidarticu,1,1);

		ret:='t';
	    end loop;
    return ret;
end;$_$;


ALTER FUNCTION public.cargo_articu_receta(integer) OWNER TO artl;

--
-- Name: cblarticu(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cblarticu(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select artc_idcbl from articu where artc_id=$1;$_$;


ALTER FUNCTION public.cblarticu(integer) OWNER TO artl;

--
-- Name: cierre_ejercicio(character varying, date, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cierre_ejercicio(character varying, date, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
tipo		 alias for $3; -- 1 Resultado, 2 Patrimoniales
codemp		 alias for $4;
idptov		 alias for $5;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
begin
ret:='f';
    select idcomp(comprobante,idptov) into elcomprob;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' EJERCICIO CERRADO AL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,date_part('year',fecha)::int2,date_part('month',fecha)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Cierre de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select idcbl(codemp,valvaramb(codemp,0,'CTARDOE')::integer)  into cuentardo;   

    if(int4eq(tipo,1::int4)) then
	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and date_le(astc_fecval,fecha) and codcble(astc_ctacble)>=3000 and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'30-06-2008' group by 1  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	select sum(astc_importe * -1) into resultad from astoctas where astc_idastoh=idastoh;

	
	if(resultad != 0) then
	    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	     values (idastoh,cuentardo,resultad,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
	end if;
	ret:='t';


      else

	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and astc_idptov=idptov and date_le(astc_fecval,fecha) and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'31-12-2011'  group by 1
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
		     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	ret:='t';

    end if;
    return ret;
end;$_$;


ALTER FUNCTION public.cierre_ejercicio(character varying, date, integer, integer, integer) OWNER TO artl;

--
-- Name: cliedeastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cliedeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_ctacte from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'DEUDXV')::integer) limit 1;$_$;


ALTER FUNCTION public.cliedeastc(integer) OWNER TO artl;

--
-- Name: clienteemi(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION clienteemi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_codcli from emiti where emi_id = $1 ;$_$;


ALTER FUNCTION public.clienteemi(integer) OWNER TO artl;

--
-- Name: climodfac(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION climodfac(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_modfac from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.climodfac(integer) OWNER TO artl;

--
-- Name: codartic(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_codigo from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.codartic(integer) OWNER TO artl;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codcble(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_codigo::int2 from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO artl;

--
-- Name: codcli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codcli(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cli_codigo from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.codcli(integer) OWNER TO artl;

--
-- Name: codclideastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codclideastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_codcli from emiti where emi_idastoh= $1 ;$_$;


ALTER FUNCTION public.codclideastoh(integer) OWNER TO artl;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO artl;

--
-- Name: codcompash(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codcompash(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoh where comp_id=ash_comprob and ash_id= $1 ;$_$;


ALTER FUNCTION public.codcompash(integer) OWNER TO artl;

--
-- Name: codcompastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codcompastc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.codcompastc(integer) OWNER TO artl;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO artl;

--
-- Name: codempcli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codempcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_codemp from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.codempcli(integer) OWNER TO artl;

--
-- Name: codprov(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codprov(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select prov_codigo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.codprov(integer) OWNER TO artl;

--
-- Name: codprovdeastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codprovdeastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cpra_prove from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.codprovdeastoh(integer) OWNER TO artl;

--
-- Name: codptv(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION codptv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_codigo from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.codptv(integer) OWNER TO artl;

--
-- Name: compbte_fe(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbte_fe(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	comp		ALIAS FOR $1; -- Comprobante 
    BEGIN
	if trim(comp)='FA' then
	    RETURN 1;
	  else
	    if trim(comp)='DA' then
		RETURN 2;
	      else
		if trim(comp)='CA' then
		    RETURN 3;
		  else
		    if trim(comp)='FB' then
			RETURN 6;
		      else
			if trim(comp)='DB' then
			    RETURN 7;
			  else
			    if trim(comp)='CB' then
				RETURN 8;
			    else
				if trim(comp)='FM' then
				    RETURN 51;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
    END;$_$;


ALTER FUNCTION public.compbte_fe(character varying) OWNER TO zona;

--
-- Name: compbte_fec(character varying, character varying, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION compbte_fec(character varying, character varying, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	comp		ALIAS FOR $1; -- Comprobante 
	letra		ALIAS FOR $2; -- letra 
	iva		ALIAS FOR $3; -- importe iva 
    BEGIN
	if trim(comp)!='NK' and trim(comp)!='DK' then
	    if trim(letra)='A' then
		RETURN 1;
	    else
		if trim(letra)='B' then
		    RETURN 6;
		else
		    if trim(letra)='C' then
			RETURN 11;
		    else
			if trim(letra)='E' then
			    RETURN 19;
			else
			    if trim(letra)='G' then
				RETURN 39;
			    else
				if trim(letra)='M' then
				    RETURN 51;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 81;
					else
					    RETURN 83;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	else
	    if trim(comp)='NK' then
		if trim(letra)='A' then
		    RETURN 3;
		else
		    if trim(letra)='B' then
			RETURN 8;
		    else
			if trim(letra)='C' then
			    RETURN 13;
			else
			    if trim(letra)='E' then
				RETURN 21;
			    else
				if trim(letra)='M' then
				    RETURN 53;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 112;
					else
					    RETURN 111;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    else
		if trim(letra)='A' then
		    RETURN 2;
		else
		    if trim(letra)='B' then
			RETURN 7;
		    else
			if trim(letra)='C' then
			    RETURN 12;
			else
			    if trim(letra)='E' then
				RETURN 20;
			    else
				if trim(letra)='M' then
				    RETURN 52;
				else
				    if trim(letra)='T' then
					if iva!=0 then
					    RETURN 115;
					else
					    RETURN 116;
					end if;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
    END;$_$;


ALTER FUNCTION public.compbte_fec(character varying, character varying, numeric) OWNER TO zona;

--
-- Name: compdeastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION compdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_comprob from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.compdeastc(integer) OWNER TO artl;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO artl;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO artl;

--
-- Name: comprobemi(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION comprobemi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_comprob from emiti where emi_id = $1 ;$_$;


ALTER FUNCTION public.comprobemi(integer) OWNER TO artl;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO artl;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO artl;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO artl;

--
-- Name: conivacli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION conivacli(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_coniva from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conivacli(integer) OWNER TO artl;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO artl;

--
-- Name: conivash(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION conivash(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select conivacli(astc_ctacte) from astoctas where astc_idastoh= $1 and astc_tipcta=99 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,1,'DEUDXV')::integer);$_$;


ALTER FUNCTION public.conivash(integer) OWNER TO artl;

--
-- Name: conpagcli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION conpagcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_conpag from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conpagcli(integer) OWNER TO artl;

--
-- Name: ctonetoib(integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ctonetoib(integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
idpago		 alias for $1;
alicuota	 alias for $2;
neto		 numeric(15,2);
totaux		 numeric(15,2);
codemp		 integer;
idptov		 integer;
cta_retib	 integer;
cta_retibc	 integer;
cta_retiva	 integer;
cta_retiva1	 integer;
cta_iva		 integer;
codcomp		 character varying;
r		 record;
begin
    neto:=0;
    select ash_codemp,ash_idptov into codemp,idptov from astoh where ash_id=idpago;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIB')::integer) into cta_retib;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIBC')::integer) into cta_retibc;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA')::integer) into cta_retiva;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA1')::integer) into cta_retiva1;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAIVAC')::integer) into cta_iva;
    for r in select * from agrupa where ag_idpago=idpago order by 1
	loop
	    select trim(codcompash(r.ag_idastoh)) into codcomp;
	    if codcomp is distinct from 'PP' and codcomp is distinct from 'OP' then
		select sum(astc_importe) into totaux from astoctas where astc_idastoh=r.ag_idastoh and astc_ctacble not in (cta_iva,cta_retib,cta_retibc,cta_retiva,cta_retiva1) and astc_tasa is not null;
		neto:=neto + totaux;
	    end if;
	end loop;
    return neto;
end;$_$;


ALTER FUNCTION public.ctonetoib(integer, numeric) OWNER TO artl;

--
-- Name: ctoretib(integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ctoretib(integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
idpago		 alias for $1;
alicuota	 alias for $2;
neto		 numeric(15,2);
reten		 numeric(15,2);
deboreten	 numeric(15,2);
totpag		 numeric(15,2);
totfac		 numeric(15,2);
totaux		 numeric(15,2);
imppag		 numeric(15,2);
tasa		 numeric(15,2);
codemp		 integer;
idptov		 integer;
cta_retib	 integer;
cta_retibc	 integer;
cta_retiva	 integer;
cta_retiva1	 integer;
cta_iva		 integer;
codcomp		 character varying;
r		 record;
begin
    neto:=0;
    select sum(ag_importe) into totpag from agrupa where ag_idpago=idpago;
    select ash_codemp,ash_idptov into codemp,idptov from astoh where ash_id=idpago;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIB')::integer) into cta_retib;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIBC')::integer) into cta_retibc;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA')::integer) into cta_retiva;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA1')::integer) into cta_retiva1;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAIVAC')::integer) into cta_iva;
    for r in select * from agrupa where ag_idpago=idpago order by 1
	loop
	    deboreten:=0;
	    select trim(codcompash(r.ag_idastoh)) into codcomp;
	    if codcomp is distinct from 'PP' and codcomp is distinct from 'OP' then
		select sum(astc_importe) into totaux from astoctas where astc_idastoh=r.ag_idastoh and astc_ctacble not in (cta_iva,cta_retib,cta_retibc,cta_retiva,cta_retiva1) and astc_tasa is not null;
		deboreten:=totaux * alicuota / 100;
		if(numeric_ne(r.ag_retenido,0)) then
		    deboreten:=deboreten - r.ag_retenido;
		end if;
		neto:=neto + deboreten;
	    end if;
	end loop;
    return neto;
end;$_$;


ALTER FUNCTION public.ctoretib(integer, numeric) OWNER TO artl;

--
-- Name: cual_comprob(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cual_comprob(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empori		ALIAS FOR $1; 
	empdest		ALIAS FOR $2;
	dato		ALIAS FOR $3;
	cual		character varying;
	retorna		integer;
    BEGIN
	select comp_codigo into cual from comprob where comp_id=dato;
	select comp_id into retorna from comprob where comp_codemp=empdest and bpchareq(comp_codigo,cual);
	RETURN retorna;
    END;$_$;


ALTER FUNCTION public.cual_comprob(integer, integer, integer) OWNER TO artl;

--
-- Name: cual_cuenta(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cual_cuenta(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empori		ALIAS FOR $1; 
	empdest		ALIAS FOR $2;
	dato		ALIAS FOR $3;
	cual		integer;
	retorna		integer;
    BEGIN
	select codcble(comp_cuenta) into cual from comprob where comp_codemp=empori and bpchareq(comp_codigo,dato);
	select cbl_id into retorna from ctacble where cbl_codemp=empdest and int4eq(cbl_codigo::integer,cual);
	RETURN retorna;
    END;$_$;


ALTER FUNCTION public.cual_cuenta(integer, integer, character varying) OWNER TO artl;

--
-- Name: cual_idsub(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cual_idsub(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empori		ALIAS FOR $1; 
	empdest		ALIAS FOR $2;
	dato		ALIAS FOR $3;
	cual		character varying;
	retorna		integer;
    BEGIN
	select subd_nombre into cual from subd where subd_id=dato;
	select subd_id into retorna from subd where subd_codemp=empdest and bpchareq(subd_nombre,cual);
	RETURN retorna;
    END;$_$;


ALTER FUNCTION public.cual_idsub(integer, integer, integer) OWNER TO artl;

--
-- Name: cual_moneda(character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cual_moneda(character varying) RETURNS smallint
    LANGUAGE sql
    AS $_$select mon_codigo from moneda where bpchareq(trim(mon_simbol),trim($1));$_$;


ALTER FUNCTION public.cual_moneda(character varying) OWNER TO artl;

--
-- Name: cuanto_facturep(integer, integer, date, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cuanto_facturep(integer, integer, date, date) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idptov= $1 and astc_estado=2 and astc_tipcta=99 and astc_ctacte= $2 and date_ge(astc_fecval,$3) and date_lt(astc_fecval,$4) and codcomp(astc_comprob) in ('FA','FB','CA','RE');$_$;


ALTER FUNCTION public.cuanto_facturep(integer, integer, date, date) OWNER TO artl;

--
-- Name: cuit_fe(character varying); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION cuit_fe(character varying) RETURNS character
    LANGUAGE sql
    AS $_$select regexp_replace(regexp_replace(trim($1), '-', ''),'-','');$_$;


ALTER FUNCTION public.cuit_fe(character varying) OWNER TO zona;

--
-- Name: cuitcli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cuitcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nrcuit from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.cuitcli(integer) OWNER TO artl;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO artl;

--
-- Name: datos_emp_nueva(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION datos_emp_nueva(integer, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
codempo		 alias for $1;
codempd		 alias for $2;
ptovtao		 alias for $3;
ptovtad		 alias for $4;
ret 		 boolean;
registro	 record;
regi		 record;
elcomprob 	 integer;
eltalon 	 integer;
existe	 	 integer;
subdid	 	 integer;
compid	 	 integer;
compcodigo	character varying;
subdnombre	character varying;
begin
ret:='f';

	for registro in select * from comprob where comp_codemp=codempo and comp_idptov=ptovtao
	    loop
		insert into comprob (comp_codemp,comp_idptov,comp_codigo,comp_nombre,comp_copias) 
		    values (codempd,ptovtad,registro.comp_codigo,registro.comp_nombre,1);

		select comp_id into elcomprob from comprob where comp_codemp=codempd and comp_idptov=ptovtad and comp_codigo=registro.comp_codigo;

		insert into talon (tal_codemp,tal_idptov,tal_comprob,tal_nombre,tal_valor,tal_fecha,tal_vald,tal_valh) values (codempd,ptovtad,elcomprob,registro.comp_nombre,1,'01-01-2015',1,999999);

		select tal_id into eltalon from talon where tal_codemp=codempd and tal_idptov=ptovtad and tal_comprob=elcomprob;

		update comprob set comp_talon=eltalon where comp_id=elcomprob;
		ret:='t';
	    end loop;

	insert into varambi (vari_codemp,vari_idptov,vari_codigo,vari_nombre,vari_valor,vari_tipo) 
	    select codempd,ptovtad,vari_codigo,vari_nombre,vari_valor,vari_tipo from varambi where vari_codemp=codempo and vari_idptov=ptovtao;

	select vari_codemp into existe from varambi where vari_codemp=codempd and vari_idptov=0 limit 1;
	if not found then
	    insert into varambi (vari_codemp,vari_idptov,vari_codigo,vari_nombre,vari_valor,vari_tipo) select codempd,ptovtad,vari_codigo,vari_nombre,vari_valor,vari_tipo from varambi where vari_codemp=codempo and vari_idptov=0;
	end if;

	insert into ctacble (cbl_codemp,cbl_codigo,cbl_nombre,cbl_identi,cbl_nivel,cbl_posic,cbl_asigna,cbl_moneda,cbl_tipcta,cbl_monetaria,cbl_ajuste,cbl_indice,cbl_ctarei,cbl_ctaaju,cbl_leyed,cbl_leyeh,cbl_present) 
	    select codempd,cbl_codigo,cbl_nombre,cbl_identi,cbl_nivel,cbl_posic,cbl_asigna,cbl_moneda,cbl_tipcta,cbl_monetaria,cbl_ajuste,cbl_indice,cbl_ctarei,cbl_ctaaju,cbl_leyed,cbl_leyeh,cbl_present from ctacble where cbl_codemp=codempo;

	insert into conpag (cdp_codemp,cdp_nombre,cdp_dias) 
	    select codempd,cdp_nombre,cdp_dias from conpag where cdp_codemp=codempo;

	insert into convmult (cmt_codemp,cmt_provin,cmt_tasa,cmt_coef) 
	    select codempd,cmt_provin,cmt_tasa,cmt_coef from convmult where cmt_codemp=codempo;

	insert into cotiza (cot_codemp,cot_moneda,cot_fecha,cot_cotiz) 
	    select codempd,cot_moneda,cot_fecha,cot_cotiz from cotiza where cot_codemp=codempo;

	insert into cblexasi (cxa_codemp,cxa_tipasi,cxa_cble) 
	    select codempd,cxa_tipasi,cxa_cble from cblexasi where cxa_codemp=codempo;

	insert into interes (int_codemp,int_fecha,int_valor) 
	    select codempd,int_fecha,int_valor from interes where int_codemp=codempo;

	insert into subd (subd_codemp,subd_idptov,subd_nombre,subd_titulo,subd_fecd,subd_fech,subd_estado,subd_proxnum,subd_orden,subd_dia) 
	    select codempd,ptovtad,subd_nombre,subd_titulo,subd_fecd,subd_fech,subd_estado,subd_proxnum,subd_orden,subd_dia from subd where subd_codemp=codempo;

	insert into tipasi (tas_codemp,tas_codigo,tas_nombre) 
	    select codempd,tas_codigo,tas_nombre from tipasi where tas_codemp=codempo;

	for regi in select * from subxcomp where subxc_codemp=codempo
	    loop

	    select subd_nombre into subdnombre from subd where subd_id=regi.subxc_idsub;
	    select subd_id into subdid from subd where subd_codemp=codempd and bpchareq(subd_nombre,subdnombre);

	    select comp_codigo into compcodigo from comprob where comp_id=regi.subxc_comprob;
	    select comp_id into compid from comprob where comp_codemp=codempd and bpchareq(comp_codigo,compcodigo);

	    insert into subxcomp (subxc_idsub,subxc_comprob,subxc_codemp) values (subdid,compid,codempd);
	    end loop;
    return ret;
end;$_$;


ALTER FUNCTION public.datos_emp_nueva(integer, integer, integer, integer) OWNER TO artl;

--
-- Name: descartic(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_codigo||'  -  '||art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.descartic(integer) OWNER TO artl;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO artl;

--
-- Name: desccblep(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccblep(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_present||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccblep(integer) OWNER TO artl;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO artl;

--
-- Name: descchqf(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descchqf(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select bco_nombre||'  - Nro: '||chq_nucheq||'  - Fecha: '||chq_fecheq||'  - Importe: $ '||chq_importe from cheques,bancos where chq_codbco=bco_codigo and chq_id= $1 ;$_$;


ALTER FUNCTION public.descchqf(integer) OWNER TO artl;

--
-- Name: descchqt(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descchqt(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select bco_nombre||'  - Nro: '||chq_nucheq||'  - Fecha: '||chq_fecheq||'  - Importe: $ '||chq_importe from cheques,bancos where chq_codbco=bco_codigo and chq_id= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.descchqt(integer) OWNER TO artl;

--
-- Name: desccli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_codigo||'  -  '||cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.desccli(integer) OWNER TO artl;

--
-- Name: desccli(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccli(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	sucursal	ALIAS FOR $2; 
	cuantos 	integer;
	nomcli 		varchar;
	nomsuc 		varchar;
	codcli		varchar;
	retval 		varchar;
    BEGIN

    select count(*) into cuantos from sucursalc where int4eq(cliente,sucu_cliente);
     if int4eq(cuantos,1) then
	select cli_codigo,cli_nombre into codcli,nomcli from clientes where cli_id=cliente;
	retval:= codcli ||'  -  '|| nomcli;
    else
	select cli_codigo,cli_nombre into codcli,nomcli from clientes where int4eq(cli_id,cliente);
	select sucu_nombre into nomsuc from sucursalc where int4eq(sucu_cliente,cliente::int4) and int2eq(sucu_codigo,sucursal::int2);
	retval:= codcli ||'  -  '|| nomcli ||' - '|| nomsuc;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.desccli(integer, integer) OWNER TO artl;

--
-- Name: desccli_emiti(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccli_emiti(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.cli_codigo||'  -  '||a.cli_nombre from clientes a, emiti b where a.cli_id=b.emi_codcli and b.emi_id= $1 ;$_$;


ALTER FUNCTION public.desccli_emiti(integer) OWNER TO artl;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select trim(comp_codigo)::character varying||'  -  '||rpad(comp_nombre,40,' ') from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO artl;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO artl;

--
-- Name: desccompdeastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION desccompdeastoh(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||ash_numero 
    from comprob,astoh where comp_id=ash_comprob and ash_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoh(integer) OWNER TO artl;

--
-- Name: descctes(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_codigo||'  -  '||cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.descctes(integer) OWNER TO artl;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO artl;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO artl;

--
-- Name: descfacg(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descfacg(integer, integer, integer, integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select desccomp(astc_comprob)||'  Nro  '||astc_numero from astoctas where astc_codemp= $1 and astc_tipcta= $2 and astc_ctacte= $3 and astc_grupo= $4 order by astc_fecval asc,astc_importe desc limit 1;$_$;


ALTER FUNCTION public.descfacg(integer, integer, integer, integer) OWNER TO artl;

--
-- Name: descfactcpra(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descfactcpra(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Prov: '|| cpra_nomprov || '  Factura:  '|| cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0') ||' - '|| lpad(cpra_nucomp::text,8,'0') from compra where cpra_id= $1 ;$_$;


ALTER FUNCTION public.descfactcpra(integer) OWNER TO artl;

--
-- Name: descfc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descfc(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0') ||' - '|| lpad(cpra_nucomp::text,8,'0') from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.descfc(integer) OWNER TO artl;

--
-- Name: descmon(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descmon(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_codigo||'  -  '||mon_nombre from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.descmon(smallint) OWNER TO artl;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO artl;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO artl;

--
-- Name: deudsinvencer(integer, integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION deudsinvencer(integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
codemp		 alias for $1;
cliente		 alias for $2;
fechah		 alias for $3;
ret 		 numeric;
registro	 record;
cuanto		 numeric;
ctadxv		 integer;
begin

ret:=0;

select idcbl(codemp, valvaramb(codemp,0,'DEUDXV')::smallint) into ctadxv;

cuanto:=0;

	for registro in select astc_importe from astoctas,emiti,conpag 
	    where astc_idastoh=emi_idastoh 
		and emi_conpag=cdp_codigo 
		and astc_estado=2 
		and astc_codemp=codemp 
		and astc_ctacble=ctadxv 
		and astc_tipcta=99 
		and astc_ctacte=cliente
		and astc_cierra=1 
		and date_gt((astc_fecval + cdp_dias),fechah)
		order by 1 desc
	    loop
	    cuanto:=registro.astc_importe + cuanto;
	    end loop;

    ret:=cuanto;
    return ret;
end;$_$;


ALTER FUNCTION public.deudsinvencer(integer, integer, date) OWNER TO artl;

--
-- Name: diasconpag(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION diasconpag(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cdp_dias from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.diasconpag(integer) OWNER TO artl;

--
-- Name: dsctocli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION dsctocli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cli_descto from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.dsctocli(integer) OWNER TO artl;

--
-- Name: elclinew(integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION elclinew(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_id from clientes where cli_codemp= $1 and bpchareq(trim(cli_nombre),trim($2));$_$;


ALTER FUNCTION public.elclinew(integer, character varying) OWNER TO artl;

--
-- Name: elprecio(integer, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION elprecio(integer, integer, integer, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1;
	ptovta		ALIAS FOR $2;
	cli		ALIAS FOR $3;
	articulo	ALIAS FOR $4;
	idart 		integer;
	retval 		numeric(15,2);
    BEGIN

	select idarticvta(codemp, ptovta, articulo) into idart;
	if not found then
	    select idarticvta(codemp, -1, articulo) into idart;
	end if;

	select ltp_precio into retval from listpre where int4eq(ltp_codemp,codemp) and int4eq(ltp_idptov,ptovta) and ltp_estado=1 and int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);
	if not found then
	    select ltp_precio into retval from listpre where int4eq(ltp_codemp,codemp) and int4eq(ltp_idptov,-1) and ltp_estado=1 and int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);
	    if not found then
		select art_precio into retval from articvta where int4eq(idart,art_id);
	    end if;
	end if;

	if retval is null then
	    retval:=0;
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecio(integer, integer, integer, character varying) OWNER TO artl;

--
-- Name: elprecioid(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: elm
--

CREATE FUNCTION elprecioid(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1;
	ptovta		ALIAS FOR $2;
	cli		ALIAS FOR $3;
	idart		ALIAS FOR $4;
	nrolista	integer;
	retval 		numeric;
    BEGIN
	select cli_listpre into nrolista from clientes where cli_id=cli;
	select ltp_precio into retval from listpre where ltp_estado=1 and int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart) and ltp_nrolista=nrolista and ltp_codemp=codemp and ltp_idptov in (-1,ptovta);
	if not found then
	    select ltp_precio into retval from listpre where ltp_estado=1 and int4eq(idart,ltp_idart) and ltp_codemp=codemp and ltp_idptov in (-1,ptovta) and ltp_nrolista=nrolista and ltp_idcli is null;
	end if;

	if retval is null then
	    retval:=0;
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecioid(integer, integer, integer, integer) OWNER TO elm;

--
-- Name: elprecioid(integer, integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: elm
--

CREATE FUNCTION elprecioid(integer, integer, integer, integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1;
	ptovta		ALIAS FOR $2;
	cli		ALIAS FOR $3;
	idart		ALIAS FOR $4;
	cotiza		ALIAS FOR $5;
	nrolista	integer;
	moneda		integer;
	precio 		numeric;
	retval 		numeric;
    BEGIN
	select cli_listpre into nrolista from clientes where cli_id=cli;
	select ltp_precio,ltp_moneda into precio,moneda from listpre where ltp_estado=1 and int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart) and ltp_nrolista=nrolista and ltp_codemp=codemp and ltp_idptov in (-1,ptovta);
	if not found then
	    select ltp_precio,ltp_moneda into precio,moneda from listpre where ltp_estado=1 and int4eq(idart,ltp_idart) and ltp_codemp=codemp and ltp_idptov in (-1,ptovta) and ltp_nrolista=nrolista and ltp_idcli is null;
	end if;

	if precio is null then
	    precio:=0;
	end if;

	if int4eq(moneda,2) then
	    retval:=precio*cotiza;
	else
	    retval:=precio;
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecioid(integer, integer, integer, integer, numeric) OWNER TO elm;

--
-- Name: elptovnew(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION elptovnew(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
codemp 		 alias for $1;
oldptv 		 alias for $2;
ptov1		 integer;
ptov2		 integer;
ret		 integer;
begin

select ptv_id into ptov2 from ptovta where ptv_codemp=codemp and bpchareq(trim(ptv_nombre),'PUNTO DE VENTA 2');
select ptv_id into ptov1 from ptovta where ptv_codemp=codemp and bpcharne(trim(ptv_nombre),'PUNTO DE VENTA 2');

if int4eq(oldptv,4) then
    ret:=ptov1;
  else
    ret:=ptov2;
end if;
return ret;

end;$_$;


ALTER FUNCTION public.elptovnew(integer, integer) OWNER TO artl;

--
-- Name: eltalonnew(integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION eltalonnew(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select tal_id from talon where tal_codemp= $1 and bpchareq(trim(tal_nombre),trim($2));$_$;


ALTER FUNCTION public.eltalonnew(integer, character varying) OWNER TO artl;

--
-- Name: esunico(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION esunico(integer, integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
    codemp	 alias for $1;
    ptovta	 alias for $2;
    articv	 alias for $3;
    articc	 alias for $4;
    cuantos	 integer;
    registro	 record;
    ret		 integer;
    begin
    ret:=2;

	for registro in select 
	    * from receta where re_codemp=codemp and re_idptov=ptovta and re_articc=articc
	loop
	    if int4eq(registro.re_articv,articv) then
		select count(re_articc) into cuantos from receta where re_codemp=codemp and re_idptov=ptovta and re_articv=registro.re_articv;
		if int4eq(cuantos,1) then
		    ret:=1; 
		end if;
	    end if;
	end loop;
    return ret;
end;$_$;


ALTER FUNCTION public.esunico(integer, integer, integer, integer) OWNER TO artl;

--
-- Name: eval_funcion(text); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION eval_funcion(text) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	res		record;
    BEGIN
	for res in execute 'select '||$1||' as result' loop
	return res.result;
	end loop;
END;$_$;


ALTER FUNCTION public.eval_funcion(text) OWNER TO artl;

--
-- Name: f_ai_articvta(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_articvta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
regi		record;
BEGIN
	for regi in select * from listas where li_codemp=NEW.art_codemp 
	    loop
		insert into listpre (ltp_codemp,ltp_idptov,ltp_nrolista,ltp_idart,ltp_orden,ltp_precio) 
			values (NEW.art_codemp,NEW.art_idptov,regi.li_codigo,NEW.art_id,NEW.art_codrub,0);
	    end loop;
    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_articvta() OWNER TO artl;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcbl(NEW.astc_codemp, valvaramb(NEW.astc_codemp,NEW.astc_idptov,'BANCO')::smallint) into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;

    if(int4eq(NEW.astc_ctacble,ctabco))  THEN 

	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;

	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;

    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO artl;

--
-- Name: f_ai_clientes(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into sucursalc (sucu_cliente,sucu_nombre) values (NEW.cli_id,NEW.cli_nombre);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_clientes() OWNER TO artl;

--
-- Name: f_ai_empresa(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
    insert into ptovta (ptv_codemp,ptv_codigo,ptv_nombre,ptv_direcc,ptv_locali,ptv_codpos,ptv_provin,ptv_pais,ptv_codact,ptv_descact)
	 values (NEW.emp_codigo,1,NEW.emp_nombre,NEW.emp_direcc,NEW.emp_locali,NEW.emp_codpos,NEW.emp_provin,NEW.emp_pais,NEW.emp_codact,NEW.emp_descact);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_empresa() OWNER TO artl;

--
-- Name: f_ai_movsto(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_movsto() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	llevastock	integer;
	registro	record;
    BEGIN

    select valvaramb(NEW.movs_codemp,0,'STOCK') into llevastock;
    if int4ne(llevastock,1) THEN 

	for registro in select * from receta 
	      where re_estado=1 and re_codemp=NEW.novs_codemp and re_articv=NEW.movs_artic
	    loop
		if found then
		    insert into stock (stc_codemp,stc_idptov,stc_idart,stc_idemiti,stc_idastoh,stc_idmovsto,stc_tipo,stc_fecval,stc_cantegr,stc_estado)
			values (NEW.movs_codemp,NEW.movs_idptov,registro.re_articc,NEW.movs_idemiti,NEW.movs_idastoh,NEW.movs_id,1,NEW.movs_fecval,(registro.re_canti * NEW.movs_canti),NEW.movs_estado);
		end if;
	    end loop; 

	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_movsto() OWNER TO artl;

--
-- Name: f_ai_movstoc(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_ai_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into stock (stc_codemp,stc_idptov,stc_idartc,stc_idcompra,stc_idastoh,stc_idmovstoc,stc_tipo,stc_fecval,stc_canting,stc_precio,stc_estado)
	    values (NEW.movc_codemp,NEW.movc_idptov,NEW.movc_artic,NEW.movc_idcompra,NEW.movc_idastoh,NEW.movc_id,2,NEW.movc_fecval,NEW.movc_canti,NEW.movc_precio,NEW.movc_estado);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_movstoc() OWNER TO artl;

--
-- Name: f_au_articvta(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_articvta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    articuid		integer;
BEGIN

    select artc_id into articuid from articu where artc_codigo=OLD.art_codigo;
    if found then
	    update articu set
		artc_codemp=NEW.art_codemp,
		artc_idptov=NEW.art_idptov,
		artc_codigo=NEW.art_codigo,
		artc_tasa=NEW.art_tasa,
		artc_codrub=NEW.art_codrub,
		artc_nombre=NEW.art_nombre,
		artc_present=NEW.art_present,
		artc_unimed=NEW.art_unimed,
		artc_leyen=NEW.art_leyen where artc_id=articuid;
    end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_articvta() OWNER TO artl;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total	numeric;
	dias	numeric;
	cont	integer;
BEGIN

    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=OLD.astc_id and chq_idastoce is null;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=OLD.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=OLD.astc_id;
	END IF;

    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	if int4eq(OLD.astc_ctacble,idcbl(OLD.astc_codemp,valvaramb(OLD.astc_codemp,OLD.astc_idptov,'DEUDXV')::integer)) THEN 
	    update emiti set emi_codcli=NEW.astc_ctacte where emi_idastoh=OLD.astc_idastoh;
	END IF;
	
	if int4eq(OLD.astc_ctacble,idcbl(OLD.astc_codemp,valvaramb(OLD.astc_codemp,OLD.astc_idptov,'DEUDXC')::integer)) THEN 
		update compra set cpra_prove=NEW.astc_ctacte where cpra_idastoh=OLD.astc_idastoh;
	END IF;
    END IF;

    if (int4ne(NEW.astc_estado,OLD.astc_estado) and int4eq(NEW.astc_estado,2)) THEN 
	select sum(astc_importe) into total from astoctas where astc_idastoh=OLD.astc_idastoh and astc_importe>0;
	update compra set cpra_total=total where cpra_idastoh=OLD.astc_idastoh;
    END IF;


    if (int4eq(NEW.astc_estado,999) and int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer)) or int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXC')::integer))))  THEN 
	update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=OLD.astc_idastoh;
    END IF;

    if (int4eq(NEW.astc_estado,999))  THEN 
	update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
	update cheques set chq_estado=999,chq_idastoce=NULL where int4eq(chq_idastoc,OLD.astc_id);
    END IF;


    if (int4ne(NEW.astc_estado,OLD.astc_estado)  and int2eq(NEW.astc_cierra,2::int2) and int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer))) THEN 
	select diasconpag(emi_conpag) into dias from emiti where emi_idastoh=NEW.astc_idastoh;
	    if found then
		update astoctas set astc_fecvto=astc_fecval+dias::integer where astc_id=NEW.astc_id;
	    end if;
    END IF;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=NEW.astc_id;
	if cont is null then
	    cont:=1;
	end if;
	if (numeric_ne(NEW.astc_importe,OLD.astc_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_importe',OLD.astc_importe,NEW.astc_importe,cont);
	end if;
	if (int4ne(NEW.astc_ctacte,OLD.astc_ctacte)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_ctacte',OLD.astc_ctacte,NEW.astc_ctacte,cont);
	end if;
	if (int4ne(NEW.astc_ctacble,OLD.astc_ctacble)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_ctacble',OLD.astc_ctacble,NEW.astc_ctacble,cont);
	end if;
	if (int4ne(NEW.astc_cierra,OLD.astc_cierra)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_cierra',OLD.astc_cierra,NEW.astc_cierra,cont);
	end if;
	if (int4ne(NEW.astc_estado,OLD.astc_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_estado',OLD.astc_estado,NEW.astc_estado,cont);
	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO artl;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont	integer;
BEGIN

    if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	update emiti set emi_estado=NEW.ash_estado where emi_idastoh=OLD.ash_id;
	delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;

    if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	delete from agrupa where ag_idpago=OLD.ash_id;
    END IF;

    if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	update compra set cpra_fecval=NEW.ash_fecval where cpra_idastoh=OLD.ash_id;
	update emiti set emi_fecval=NEW.ash_fecval where emi_idastoh=OLD.ash_id;
	update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;

    if date_ne(NEW.ash_fecomp,OLD.ash_fecomp) THEN 
	update compra set cpra_fecori=NEW.ash_fecomp where cpra_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	update compra set cpra_comprob=NEW.ash_comprob where cpra_idastoh=OLD.ash_id;
	update emiti set emi_comprob=NEW.ash_comprob where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	update compra set cpra_numero=NEW.ash_numero where cpra_idastoh=OLD.ash_id;
	update emiti set emi_numero=NEW.ash_numero where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	update compra set cpra_codemp=NEW.ash_codemp where cpra_idastoh=OLD.ash_id;
	update emiti set emi_codemp=NEW.ash_codemp where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	update compra set cpra_idptov=NEW.ash_idptov where cpra_idastoh=OLD.ash_id;
	update emiti set emi_idptov=NEW.ash_idptov where emi_idastoh=OLD.ash_id;
	END IF;


	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=NEW.ash_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.ash_anio,OLD.ash_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_anio',OLD.ash_anio,NEW.ash_anio,cont);
	end if;
	if (int4ne(NEW.ash_mes,OLD.ash_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_mes',OLD.ash_mes,NEW.ash_mes,cont);
	end if;
	if (int4ne(NEW.ash_estado,OLD.ash_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_estado',OLD.ash_estado,NEW.ash_estado,cont);
	end if;
	if (date_ne(NEW.ash_fecomp,OLD.ash_fecomp)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecomp',OLD.ash_fecomp,NEW.ash_fecomp,cont);
	end if;
	if (date_ne(NEW.ash_fecval,OLD.ash_fecval)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecval',OLD.ash_fecval,NEW.ash_fecval,cont);
	end if;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO artl;

--
-- Name: f_au_cheques(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont	integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='cheques' and log_idtabla=NEW.chq_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.chq_nucheq,OLD.chq_nucheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_nucheq',OLD.chq_nucheq,NEW.chq_nucheq,cont);
	end if;
	if (int4ne(NEW.chq_codbco,OLD.chq_codbco)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_codbco',OLD.chq_codbco,NEW.chq_codbco,cont);
	end if;
	if (int4ne(NEW.chq_idastoc,OLD.chq_idastoc)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_idastoc',OLD.chq_idastoc,NEW.chq_idastoc,cont);
	end if;
	if (int4ne(NEW.chq_idastoce,OLD.chq_idastoce)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_idastoce',OLD.chq_idastoce,NEW.chq_idastoce,cont);
	end if;
	if (date_ne(NEW.chq_fecheq,OLD.chq_fecheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_fecheq',OLD.chq_fecheq,NEW.chq_fecheq,cont);
	end if;
	if (int4ne(NEW.chq_estado,OLD.chq_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_estado',OLD.chq_estado,NEW.chq_estado,cont);
	end if;
	if (numeric_ne(NEW.chq_importe,OLD.chq_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,1,1,'cheques',NEW.chq_id,'chq_importe',OLD.chq_importe,NEW.chq_importe,cont);
	end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_cheques() OWNER TO artl;

--
-- Name: f_au_clientes(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.cli_nombre,OLD.cli_nombre) THEN 
	update sucursalc set sucu_nombre=NEW.cli_nombre where sucu_cliente=OLD.cli_id and sucu_nombre=OLD.cli_nombre;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_clientes() OWNER TO artl;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;

    if int4ne(NEW.cpra_estado,OLD.cpra_estado) THEN 
	update movstoc set movc_estado=NEW.cpra_estado where movc_idcompra=OLD.cpra_id;
    END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO artl;

--
-- Name: f_au_concilia(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_concilia() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.clia_estado,OLD.clia_estado) THEN 
	update conxclia set cxlia_estado=NEW.clia_estado where cxlia_idclia=OLD.cxlia_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_concilia() OWNER TO artl;

--
-- Name: f_au_contratos(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_contratos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
registro	 record;
BEGIN

-- Estado 999 ANUALADO CON DEVOLUCION DE DISPENSER
-- Estado 9 ANUALADO SIN DEVOLUCION DE DISPENSER

    if (int4ne(NEW.ctr_idcli,OLD.ctr_idcli))  THEN 
	    update contrb set ctrb_estado=NEW.ctr_idcli where ctrb_idcontr=OLD.ctr_id;
    END IF;

    if (int4ne(NEW.ctr_numero,OLD.ctr_numero))  THEN 
	    update contrb set ctrb_numero=NEW.ctr_numero where ctrb_idcontr=OLD.ctr_id;
	    update dispenser set dis_numero=NEW.ctr_numero where dis_idcontr=OLD.ctr_id;
    END IF;

    if (date_ne(NEW.ctr_fecvto,OLD.ctr_fecvto))  THEN 
	    update contrb set ctrb_fecvto=NEW.ctr_fecvto where ctrb_idcontr=OLD.ctr_id;
	    update dispenser set dis_fecvto=NEW.ctr_fecvto where dis_idcontr=OLD.ctr_id;
    END IF;

    if (date_ne(NEW.ctr_fecha,OLD.ctr_fecha))  THEN 
	    update contrb set ctrb_fecha=NEW.ctr_fecha where ctrb_idcontr=OLD.ctr_id;
	    update dispenser set dis_fecha=NEW.ctr_fecha where dis_idcontr=OLD.ctr_id;
    END IF;

    if int4ne(NEW.ctr_estado,OLD.ctr_estado) THEN 
	if (int4eq(NEW.ctr_estado,999))  THEN 
	    update dispenser set dis_idcontr=NULL, dis_idcontrb=-1, dis_estado=1 where dis_idcontr=OLD.ctr_id;
	    update contrb set ctrb_estado=NEW.ctr_estado where ctrb_idcontr=OLD.ctr_id;
	END IF;

	if (int4eq(NEW.ctr_estado,9))  THEN 
	    update dispenser set dis_estado=9 where dis_idcontr=OLD.ctr_id;
	    update contrb set ctrb_estado=NEW.ctr_estado where ctrb_idcontr=OLD.ctr_id;
	END IF;

	if (int4eq(NEW.ctr_estado,9) and int4eq(OLD.ctr_estado,999))  THEN 
	    update contrb set ctrb_estado=NEW.ctr_estado where ctrb_idcontr=OLD.ctr_id;
	    for registro in select * from contrb where ctrb_idcontr=OLD.ctr_id
		loop
		update dispenser set dis_idcontr=OLD.ctr_id, dis_idcontrb=registro.ctrb_id, dis_estado=NEW.ctr_estado where dis_id=registro.ctrb_iddispen;
	    end loop;
	END IF;

	if (int4eq(NEW.ctr_estado,1))  THEN 
	    update contrb set ctrb_estado=NEW.ctr_estado where ctrb_idcontr=OLD.ctr_id;
	    for registro in select * from contrb where ctrb_idcontr=OLD.ctr_id
		loop
		update dispenser set dis_idcontr=OLD.ctr_id, dis_idcontrb=registro.ctrb_id, dis_estado=NEW.ctr_estado where dis_id=registro.ctrb_iddispen;
	    end loop;
	END IF;



    END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_contratos() OWNER TO artl;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;

	if int4eq(NEW.emi_estado,2) THEN 
	    update astoctas set astc_fecvto=astc_fecval+diasconpag(NEW.emi_conpag) where astc_idastoh=OLD.emi_idastoh and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,0,'DEUDXV')::integer);
	    END IF;

	END IF;

    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrcuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;



    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO artl;

--
-- Name: f_au_listpre(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_listpre() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont	integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='listpre' and log_idtabla=NEW.ltp_id;
	if cont is null then
	    cont:=1;
	end if;
	if (numeric_ne(NEW.ltp_precio,OLD.ltp_precio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ltp_idptov,1,1,'listpre',NEW.ltp_id,'ltp_precio',OLD.ltp_precio,NEW.ltp_precio,cont);
	end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_listpre() OWNER TO artl;

--
-- Name: f_au_movsto(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_movsto() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	llevastock	integer;
	registro	record;
    BEGIN

    if int4ne(NEW.movs_estado,OLD.movs_estado) THEN 
	update stock set stc_estado=NEW.movs_estado where stc_idmovsto=OLD.movs_id;
	END IF;

    if int4ne(NEW.movs_idastoh,OLD.movs_idastoh) THEN 
	update stock set stc_idastoh=NEW.movs_idastoh where stc_idmovsto=OLD.movs_id;
	END IF;

    if int4ne(NEW.movs_idemiti,OLD.movs_idemiti) THEN 
	update stock set stc_idemiti=NEW.movs_idemiti where stc_idmovsto=OLD.movs_id;
	END IF;

    if int4ne(NEW.movs_idptov,OLD.movs_idptov) THEN 
	update stock set stc_idptov=NEW.movs_idptov where stc_idmovsto=OLD.movs_id;
	END IF;

    if date_ne(NEW.movs_fecval,OLD.movs_fecval) THEN 
	update stock set stc_fecval=NEW.movs_fecval where stc_idmovsto=OLD.movs_id;
	END IF;


    if (numeric_ne(NEW.movs_canti,OLD.movs_canti)) then
	select valvaramb(NEW.movs_codemp,0,'STOCK') into llevastock;
	if int4ne(llevastock,1) THEN 
	    delete from stock where int4eq(stc_idmovsto,NEW.movs_id);
	    for registro in select * from receta 
		where re_estado=1 and re_codemp=NEW.novs_codemp and re_articv=NEW.movs_artic
		loop
		if found then
		    insert into stock (stc_codemp,stc_idptov,stc_idart,stc_idemiti,stc_idastoh,stc_idmovsto,stc_tipo,stc_fecval,stc_cantegr,stc_estado)
			values (NEW.movs_codemp,NEW.movs_idptov,registro.re_articc,NEW.movs_idemiti,NEW.movs_idastoh,NEW.movs_id,1,NEW.movs_fecval,(registro.re_canti * NEW.movs_canti),NEW.movs_estado);
		    end if;
		end loop; 
	    END IF;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_movsto() OWNER TO artl;

--
-- Name: f_au_movstoc(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN

    if int4ne(NEW.movc_estado,OLD.movc_estado) THEN 
	update stock set stc_estado=NEW.movc_estado where stc_idmovstoc=OLD.movc_id;
	END IF;

    if int4ne(NEW.movc_idastoh,OLD.movc_idastoh) THEN 
	update stock set stc_idastoh=NEW.movc_idastoh where stc_idmovstoc=OLD.movc_id;
	END IF;

    if int4ne(NEW.movc_idcompra,OLD.movc_idcompra) THEN 
	update stock set stc_idcompra=NEW.movc_idcompra where stc_idmovstoc=OLD.movc_id;
	END IF;

    if int4ne(NEW.movc_idptov,OLD.movc_idptov) THEN 
	update stock set stc_idptov=NEW.movc_idptov where stc_idmovstoc=OLD.movc_id;
	END IF;

    if date_ne(NEW.movc_fecval,OLD.movc_fecval) THEN 
	update stock set stc_fecval=NEW.movc_fecval where stc_idmovstoc=OLD.movc_id;
	END IF;

    if (numeric_ne(NEW.movc_canti,OLD.movc_canti)) then
	update stock set stc_canting=NEW.movc_canti where stc_idmovstoc=OLD.movc_id;
	END IF;

    if (numeric_ne(NEW.movc_precio,OLD.movc_precio)) then
	update stock set stc_precio=NEW.movc_precio where stc_idmovstoc=OLD.movc_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_movstoc() OWNER TO artl;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	update ctes set cte_nombre=NEW.prov_nombre where cte_codigo=OLD.prov_id and cte_codemp=OLD.prov_codemp and cte_tipcta=eval_funcion(valvaramb(NEW.prov_codemp,ptovdefault(NEW.prov_codemp),'TIPCTADXC'));
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO artl;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    cont		integer;
    BEGIN

----------------------------  CHEQUES ---------------------------------------    
	
    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	END IF;
    END IF;


    select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
    if found then
	update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
    END IF;

----------------------------  MONEX ---------------------------------------    

    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
    if found then
	update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
    END IF;


----------------------------  DOCUM ---------------------------------------    

    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
    if found then
	update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
    END IF;

---------------------------- CIERRA Y GRUPO -----------------------------

    if (int2eq(OLD.astc_cierra,2::int2) and (int4eq(OLD.astc_ctacble,idcbl(OLD.astc_codemp,valvaramb(OLD.astc_codemp,OLD.astc_idptov,'DEUDXV')::integer)) or int4eq(OLD.astc_ctacble,idcbl(OLD.astc_codemp,valvaramb(OLD.astc_codemp,OLD.astc_idptov,'DEUDXC')::integer))))  THEN 
	update astoctas set astc_cierra=1 where astc_ctacble=OLD.astc_ctacble and astc_tipcta=OLD.astc_tipcta and astc_ctacte=OLD.astc_ctacte and astc_grupo=OLD.astc_grupo and astc_idastoh!=OLD.astc_idastoh;
    END IF;


	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=OLD.astc_id;
	if cont is null then
	    cont:=1;
	end if;
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_idastoh',OLD.astc_idastoh,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_importe',OLD.astc_importe,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_ctacble',OLD.astc_ctacble,'delete',cont);


    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO artl;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    cont		integer;
    BEGIN

    delete from emiti where int4eq(emi_idastoh,OLD.ash_id);
    delete from compra where int4eq(cpra_idastoh,OLD.ash_id);
    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
    delete from relrem where int4eq(rr_idastohp,OLD.ash_id);
    delete from relrem where int4eq(rr_idastohh,OLD.ash_id);
    delete from agrupa where ag_idpago=OLD.ash_id;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=OLD.ash_id;
	if cont is null then
	    cont:=1;
	end if;
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_titulo',OLD.ash_titulo,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_fecval',OLD.ash_fecval,'delete',cont);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO artl;

--
-- Name: f_bd_clientes(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from sucursalc where int4eq(sucu_cliente,OLD.cli_id);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_clientes() OWNER TO artl;

--
-- Name: f_bd_compra(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
    delete from movstoc where int4eq(movc_idcompra,OLD.cpra_id);
RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_compra() OWNER TO artl;

--
-- Name: f_bd_contratos(); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION f_bd_contratos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    registro	 record;
    BEGIN

	delete from contrb where int4eq(ctrb_idcontr,OLD.ctr_id);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_contratos() OWNER TO estlm;

--
-- Name: f_bd_contrb(); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION f_bd_contrb() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    registro	 record;
    BEGIN

	update dispenser set dis_idcontr=NULL, dis_idcontrb=-1, dis_estado=1 where dis_id=OLD.ctrb_iddispen;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_contrb() OWNER TO estlm;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos	int4;
    BEGIN

    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    delete from relnotp where int4eq(rn_idemitih,OLD.emi_id);
    delete from relnotp where int4eq(rn_idemitip,OLD.emi_id);
    delete from relcotnot where int4eq(rn_idemitih,OLD.emi_id);
    delete from relcotnot where int4eq(rn_idemitip,OLD.emi_id);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO artl;

--
-- Name: f_bd_empresa(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from zona where int4eq(zon_codemp,OLD.emp_codigo);
    delete from vendedor where int4eq(ven_codemp,OLD.emp_codigo);
    delete from varambi where int4eq(vari_codemp,OLD.emp_codigo);
    delete from telefon where int4eq(tel_codemp,OLD.emp_codigo);
    delete from talon where int4eq(tal_codemp,OLD.emp_codigo);
    delete from subd where int4eq(subd_codemp,OLD.emp_codigo);
    delete from prove where int4eq(prov_codemp,OLD.emp_codigo);
    delete from clientes where int4eq(cli_codemp,OLD.emp_codigo);
    delete from ctes where int4eq(cte_codemp,OLD.emp_codigo);
    delete from ctacble where int4eq(cbl_codemp,OLD.emp_codigo);
    delete from conpag where int4eq(cdp_codemp,OLD.emp_codigo);
    delete from interes where int4eq(int_codemp,OLD.emp_codigo);
    delete from listpre where int4eq(ltp_codemp,OLD.emp_codigo);
    delete from articvta where int4eq(art_codemp,OLD.emp_codigo);
    delete from comprob where int4eq(comp_codemp,OLD.emp_codigo);
    delete from ptovta where int4eq(ptv_codemp,OLD.emp_codigo);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_empresa() OWNER TO artl;

--
-- Name: f_bd_movsto(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_movsto() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cont		integer;
    BEGIN

    delete from stock where int4eq(stc_idmovsto,OLD.movs_id);

	select max(log_cont)+1 into cont from modlogs where log_tabla='movsto' and log_idtabla=OLD.movs_id;
	if cont is null then
	    cont:=1;
	end if;
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_idemiti',OLD.movs_idemiti,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_fecval',OLD.movs_fecval,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_artic',OLD.movs_artic,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_precio',OLD.movs_precio,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_canti',OLD.movs_canti,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_importe',OLD.movs_importe,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movs_idptov,1,1,'movsto',OLD.movs_id,'movs_codcli',OLD.movs_codcli,'delete',cont);


    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_movsto() OWNER TO artl;

--
-- Name: f_bd_movstoc(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bd_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cont		integer;
    BEGIN

    delete from stock where int4eq(stc_idmovstoc,OLD.movc_id);

	select max(log_cont)+1 into cont from modlogs where log_tabla='movstoc' and log_idtabla=OLD.movc_id;
	if cont is null then
	    cont:=1;
	end if;
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_idcompra',OLD.movc_idcompra,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_fecval',OLD.movc_fecval,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_artic',OLD.movc_artic,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_precio',OLD.movc_precio,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_canti',OLD.movc_canti,'delete',cont);
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (OLD.movc_idptov,1,1,'movstoc',OLD.movc_id,'movc_importe',OLD.movc_importe,'delete',cont);

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_movstoc() OWNER TO artl;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 


------------------ PARTIDA DOBLE -----------------------------------

    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;

------------------ CASO CHEQUES -----------------------------------



END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO artl;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 


    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;

END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO artl;

--
-- Name: facturadoemi(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION facturadoemi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_facturado from emiti where emi_id = $1 ;$_$;


ALTER FUNCTION public.facturadoemi(integer) OWNER TO artl;

--
-- Name: fecdechq(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION fecdechq(integer) RETURNS date
    LANGUAGE sql
    AS $_$select chq_fecheq from cheques where chq_id= $1 ;$_$;


ALTER FUNCTION public.fecdechq(integer) OWNER TO artl;

--
-- Name: fecha_fe(date); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION fecha_fe(date) RETURNS character
    LANGUAGE sql
    AS $_$select date_part('Y',$1)::character varying||lpad(date_part('Month',$1)::text,2,'0'::text)::character varying||lpad(date_part('D',$1)::text,2,'0'::text)::character varying;$_$;


ALTER FUNCTION public.fecha_fe(date) OWNER TO zona;

--
-- Name: fecvalash(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION fecvalash(integer) RETURNS date
    LANGUAGE sql
    AS $_$select ash_fecval from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.fecvalash(integer) OWNER TO artl;

--
-- Name: fecvalastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION fecvalastc(integer) RETURNS date
    LANGUAGE sql
    AS $_$select astc_fecval from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.fecvalastc(integer) OWNER TO artl;

--
-- Name: gastoct(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION gastoct(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then

	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1 
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct(integer, integer, integer, numeric) OWNER TO artl;

--
-- Name: gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctacte		ALIAS FOR $6; 
	nucheq		ALIAS FOR $7; 
	fecvto		ALIAS FOR $8; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then
	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte,astc_nucheq,astc_fecvto) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1,tipcta,ctacte,nucheq,fecvto
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) OWNER TO artl;

--
-- Name: graboastocta(integer, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastocta(integer, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	succli		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,1,'DEUDXV')::smallint) into ctadeud;
if ctadeud is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
end if;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
if tctdepg is null then
    select valvaramb(codemp,idptov,'TIPCTADEPG')::integer into tctdepg;
end if;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo,emi_succli into elcli,grupo,succli from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,1,'CTAIVA')::smallint) into ctaiva;
		if ctaiva is null then
		    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
		end if;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,1,'CTAIVAST')::smallint) into ctaivast;
if ctaivast is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,1,'CTADESCTO')::smallint) into ctadescto;
if ctadescto is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_succli,astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (succli,grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastocta(integer, numeric, numeric, numeric) OWNER TO artl;

--
-- Name: graboastocta(integer, numeric, numeric, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastocta(integer, numeric, numeric, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	iibb		ALIAS FOR $5; 
	alic		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	succli		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	ctaiibb		integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,1,'DEUDXV')::smallint) into ctadeud;
if ctadeud is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
end if;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
if tctdepg is null then
    select valvaramb(codemp,idptov,'TIPCTADEPG')::integer into tctdepg;
end if;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo,emi_succli into elcli,grupo,succli from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,1,'CTAIVA')::smallint) into ctaiva;
		if ctaiva is null then
		    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
		end if;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,1,'CTAIVAST')::smallint) into ctaivast;
if ctaivast is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,1,'CTADESCTO')::smallint) into ctadescto;
if ctadescto is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

if numeric_ne(iibb,0::numeric) then
    select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
    if ctaiibb is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTAPERIBD')::smallint) into ctaiibb;
    end if;
    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (alic,ctaiibb,(iibb * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
    total:=total + iibb;
end if;


insert into astoctas (astc_succli,astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (succli,grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastocta(integer, numeric, numeric, numeric, numeric, numeric) OWNER TO artl;

--
-- Name: graboastoctac(integer, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastoctac(integer, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva21		ALIAS FOR $2; 
	iva27		ALIAS FOR $3; 
	iva105		ALIAS FOR $4; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	totalcpra	numeric;
	otros		numeric;
	impiva		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	ctaiibb		integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,1,'DEUDXC')::smallint) into ctadeud;
if ctadeud is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXC')::smallint) into ctadeud;
end if;
select tipctacbl(ctadeud) into tipct;
select cpra_prove into elcli from compra where cpra_idastoh=idastoh;
select grupoprov(elcli,1) into grupo;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'NK')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;

select sum(astc_importe)::numeric(15,2) into otros from astoctas where astc_idastoh=idastoh;
if numeric_ne(otros,0::numeric) then
    if (bpchareq(codcompr,'NK')) then
	otros:=otros*-1;
    end if;
    total:= total - otros;
end if;


for registro in select a.artc_idcbl as cuenta, b.movc_tasa as latasa, tipctacbl(a.artc_idcbl) as cualtipcta, sum(b.movc_importe) as cuanto 
     from movstoc b, articu a where b.movc_idastoh=idastoh 
        and b.movc_artic=a.artc_id group by 1,2,3
	loop
	if found then 
	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    total:=total - registro.cuanto;
	end if;
end loop; 


for regis in select movc_tasa as vlatasa, sum(movc_importe) as vcuanto
     from movstoc where movc_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,1,'CTAIVAC')::smallint) into ctaiva;
		if ctaiva is null then
		    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAC')::smallint) into ctaiva;
		end if;

		if(numeric_eq(regis.vlatasa,21::numeric)) then
		    impiva:=iva21;
		else
		    if(numeric_eq(regis.vlatasa,27::numeric)) then
			impiva:=iva27;
		    else
			if(numeric_eq(regis.vlatasa,10.5::numeric)) then
			    impiva:=iva105;
			end if;
		    end if;
		end if;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(signo * impiva)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 

if numeric_ne(iva21,0::numeric) then
    total:=total - iva21;
end if;
if numeric_ne(iva27,0::numeric) then
    total:=total - iva27;
end if;
if numeric_ne(iva105,0::numeric) then
    total:=total - iva105;
end if;


insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,(total*signo)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

select cpra_total into totalcpra from compra where cpra_idastoh=idastoh;
if(numeric_ne(totalcpra,total))then
    if (bpchareq(codcompr,'NK')) then
	if(numeric_ge(total,0::numeric)) then
	    total:=total*-1;
	    update compra set cpra_total=total where cpra_idastoh=idastoh;
	end if;
    else
	if(numeric_le(total,0::numeric)) then
	    total:=total*-1;
	    update compra set cpra_total=total where cpra_idastoh=idastoh;
	end if;
    end if;
end if;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctac(integer, numeric, numeric, numeric) OWNER TO artl;

--
-- Name: graboastoctac(integer, numeric, numeric, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastoctac(integer, numeric, numeric, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctact		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
	    if(int4eq(registro.cualtipcta, tipcta)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (ctact,tipcta,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctac(integer, numeric, numeric, numeric, integer, integer) OWNER TO artl;

--
-- Name: graboastoctaj(integer, numeric, numeric, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION graboastoctaj(integer, numeric, numeric, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	iibb		ALIAS FOR $5; 
	alic		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	auximp		numeric(15,2);
	auxiva		numeric(15,2);
	difiva		numeric(15,2);
	iibbp		numeric(15,2);
	ivap		numeric(15,2);
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	ctaiibb		integer;
	codcompr	character varying;
    BEGIN

delete from astoctas where astc_idastoh=idastoh;
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;

select idcbl(codemp, valvaramb(codemp,1,'DEUDXV')::smallint) into ctadeud;
if ctadeud is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
end if;
select tipctacbl(ctadeud) into tipct;

select idcbl(codemp, valvaramb(codemp,1,'CTAIVA')::smallint) into ctaiva;
if ctaiva is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
end if;

select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select trim(codcomp(ash_comprob)) into codcompr from astoh where ash_id=idastoh;

if ((codcompr is not distinct from 'CA') or (codcompr is not distinct from 'CB') or (codcompr is not distinct from 'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;



total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		auximp:=registro.cuanto / (1 + registro.latasa/100);
	    else
		auximp:=registro.cuanto;
	    end if;
	    if (auximp<0) then auximp:=auximp*-1; end if;

	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(auximp * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    total:=total + (auximp * signo);
	end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		auximp:=regis.vcuanto / (1 + regis.vlatasa/100);
	    else
		auximp:=regis.vcuanto;
	    end if;

	    if (auximp<0) then auximp:=auximp*-1; end if;

	    if numeric_ne(regis.vlatasa,0::numeric) then 
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(auximp * -1 * signo * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end loop; 

select sum(astc_importe) into auxiva from astoctas where astc_idastoh=idastoh and astc_ctacble=ctaiva;

if (iva<0) then ivap:=iva*-1; else ivap:=iva; end if;

if (numeric_ne(ivap,auxiva)) then
    difiva:=ivap-auxiva;
    if numeric_le(difiva,0) then
	difiva:=difiva*-1;
    end if;
    update astoctas set astc_importe=(ivap*-1*signo) where astc_idastoh=idastoh and astc_ctacble=ctaiva;
end if;

if numeric_ne(ivap,0::numeric) then
    total:=total + (ivap * signo);
end if;

if numeric_ne(ivast,0::numeric) then
    select idcbl(codemp, valvaramb(codemp,1,'CTAIVAST')::smallint) into ctaivast;
    if ctaivast is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
    end if;

    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

    total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
    select idcbl(codemp, valvaramb(codemp,1,'CTADESCTO')::smallint) into ctadescto;
    if ctadescto is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
    total:=total + (descto * signo);
end if;

if numeric_ne(iibb,0::numeric) then
    if(iibb<0) then iibbp:=iibb*-1; else iibbp:=iibb; end if;
    select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
    if ctaiibb is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTAPERIBD')::smallint) into ctaiibb;
    end if;
    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (alic,ctaiibb,(iibbp * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
    total:=total + (iibbp * signo);
end if;


insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

RETURN signo;
END;$_$;


ALTER FUNCTION public.graboastoctaj(integer, numeric, numeric, numeric, numeric, numeric) OWNER TO zona;

--
-- Name: graboastoctan(integer, numeric, numeric, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION graboastoctan(integer, numeric, numeric, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	iibb		ALIAS FOR $5; 
	alic		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	auximp		numeric(15,2);
	auxiva		numeric(15,2);
	difiva		numeric(15,2);
	iibbp		numeric(15,2);
	ivap		numeric(15,2);
	tasamay		numeric(15,2);
	impmay		numeric(15,2);
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	ctaiibb		integer;
	codcompr	character varying;
    BEGIN

delete from astoctas where astc_idastoh=idastoh;
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;

select idcbl(codemp, valvaramb(codemp,1,'DEUDXV')::smallint) into ctadeud;
if ctadeud is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
end if;
select tipctacbl(ctadeud) into tipct;

select idcbl(codemp, valvaramb(codemp,1,'CTAIVA')::smallint) into ctaiva;
if ctaiva is null then
    select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
end if;

select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select trim(codcomp(ash_comprob)) into codcompr from astoh where ash_id=idastoh;

if ((codcompr is not distinct from 'CA') or (codcompr is not distinct from 'CB') or (codcompr is not distinct from 'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;



total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		auximp:=registro.cuanto / (1 + registro.latasa/100);
	    else
		auximp:=registro.cuanto;
	    end if;
	    if (auximp<0) then auximp:=auximp*-1; end if;

	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(auximp * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    total:=total + (auximp * signo);
	end loop; 

select movs_tasa,sum(movs_importe) into tasamay,impmay from movsto where movs_idastoh=idastoh group by 1 order by 2 desc limit 1;

for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	    auximp:=0;
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		auximp:=regis.vcuanto / (1 + regis.vlatasa/100);
	    else
		auximp:=regis.vcuanto;
	    end if;

	    if (auximp<0) then auximp:=auximp*-1; end if;

	    RAISE NOTICE 'base imponible %',auximp;
	    auximp:=(auximp * -1 * signo * regis.vlatasa)/100;
	    RAISE NOTICE 'tasa % iva %',regis.vlatasa,auximp;

	    if numeric_ne(regis.vlatasa,0::numeric) then 
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(auximp)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end loop; 

select sum(astc_importe) into auxiva from astoctas where astc_idastoh=idastoh and astc_ctacble=ctaiva;

if (iva<0) then ivap:=iva*-1; else ivap:=iva; end if;
if (auxiva<0) then auxiva:=auxiva*-1; end if;

if (numeric_ne(ivap,auxiva)) then
    difiva:=ivap-auxiva;
    update astoctas set astc_importe=astc_importe+difiva where astc_idastoh=idastoh and astc_ctacble=ctaiva and astc_tasa=tasamay;
end if;

if numeric_ne(ivap,0::numeric) then
    total:=total + (ivap * signo);
end if;

if numeric_ne(ivast,0::numeric) then
    select idcbl(codemp, valvaramb(codemp,1,'CTAIVAST')::smallint) into ctaivast;
    if ctaivast is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
    end if;

    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

    total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
    select idcbl(codemp, valvaramb(codemp,1,'CTADESCTO')::smallint) into ctadescto;
    if ctadescto is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    end if;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
    total:=total + (descto * signo);
end if;

if numeric_ne(iibb,0::numeric) then
    if(iibb<0) then iibbp:=iibb*-1; else iibbp:=iibb; end if;
    select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
    if ctaiibb is null then
	select idcbl(codemp, valvaramb(codemp,idptov,'CTAPERIBD')::smallint) into ctaiibb;
    end if;
    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (alic,ctaiibb,(iibbp * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
    total:=total + (iibbp * signo);
end if;


insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

RETURN signo;
END;$_$;


ALTER FUNCTION public.graboastoctan(integer, numeric, numeric, numeric, numeric, numeric) OWNER TO estlm;

--
-- Name: graboastoctasi(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastoctasi(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	succli		integer;
	numero		integer;
	fecval		date;
	total		numeric;
	iva		numeric;
	ivap		numeric;
	otros		numeric;
	ctadeud		integer;
	ctaiva		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN

select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcble(codemp, valvaramb(codemp,idptov,'DEUDXV')) into ctadeud;
select idcble(codemp, valvaramb(codemp,idptov,'CTAIVA')) into ctaiva;
-- select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo,emi_succli into elcli,grupo,succli from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= 1;
    else
	signo= 1;
end if;

total:=0;
iva:=0;
for registro in select a.art_codcbl as cuenta, b.movs_tasa as latasa, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh
        and b.movs_artic=a.art_id group by 1,2
	loop
	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);
	    total:=total + (registro.cuanto * signo);
	end loop; 


for regis in select b.movs_tasa as latasa, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh and bpcharne(codcompash(movs_idastoh),'RE') and b.movs_artic=a.art_id group by 1
	loop
	    select (regis.cuanto * regis.latasa / 100 * signo)::numeric(15,2) into ivap;
	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.latasa,ctaiva,(ivap * -1),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);

	    iva:=iva + ivap ;
	end loop; 


if numeric_ne(iva,0) then
    total:=total + iva;
end if;

insert into astoctas (astc_succli,astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (succli,grupo,elcli,tipct,ctadeud,total,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctasi(integer) OWNER TO artl;

--
-- Name: graboastoctasi(integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboastoctasi(integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	alicuota	ALIAS FOR $2;
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	succli		integer;
	numero		integer;
	fecval		date;
	total		numeric;
	iva		numeric;
	ivap		numeric;
	otros		numeric;
	impaux		numeric;
	bimp	 	numeric;
	miniibb	 	numeric;
	baux	 	numeric;
	alic	 	numeric;
	totalic	 	numeric;
	ctadeud		integer;
	ctaiva		integer;
	tipct		integer;
	ctaiibb		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN

select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcble(codemp, valvaramb(codemp,idptov,'DEUDXV')) into ctadeud;
select idcble(codemp, valvaramb(codemp,idptov,'CTAIVA')) into ctaiva;
select valvaramb(codemp,idptov,'MINIIBB') into miniibb;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo,emi_succli into elcli,grupo,succli from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

total:=0;
iva:=0;
for registro in select a.art_codcbl as cuenta, b.movs_tasa as latasa, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh
        and b.movs_artic=a.art_id group by 1,2
	loop
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		impaux:=(registro.cuanto / (1 + (registro.latasa / 100)))::numeric(15,2);
	    else
		impaux:=registro.cuanto::numeric(15,2);
	    end if;
	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(impaux * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);
	    total:=total + (impaux);
	end loop; 


for regis in select b.movs_tasa as latasa, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh and bpcharne(codcompash(movs_idastoh),'RE') and b.movs_artic=a.art_id group by 1
	loop
	    if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
		select (regis.cuanto - (regis.cuanto / (1 + (regis.latasa / 100))))::numeric(15,2) into ivap;
	    else
		select (regis.cuanto * regis.latasa / 100)::numeric(15,2) into ivap;
	    end if;
	    insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.latasa,ctaiva,(ivap * -1),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);

	    iva:=iva + ivap ;
	end loop; 

bimp:=total;

if numeric_ne(iva,0) then
    total:=total + iva;
end if;

if (bpchareq(codcompr,'FB') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'DB')) then
    bimp:=total;
end if;

baux:=bimp;
if (numeric_le(baux,0)) then
    baux:=baux*-1;
end if;

if (numeric_gt(alicuota,0) and numeric_gt(baux,miniibb)) then
    alic:= alicuota / 100;
    totalic:= (bimp * alic)::numeric(15,2);
    if (numeric_ne(totalic,0)) then
	select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
	if ctaiibb is null then
	    select idcbl(codemp, valvaramb(codemp,idptov,'CTAPERIBD')::smallint) into ctaiibb;
	end if;
	insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	    values (alicuota,ctaiibb,(totalic * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	total:=total + totalic;
    end if;
end if;

insert into astoctas (astc_succli,astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (succli,grupo,elcli,tipct,ctadeud,total,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctasi(integer, numeric) OWNER TO artl;

--
-- Name: graboauxfe(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboauxfe(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	idemiti		integer;
	idfe		integer;
	codemp 		integer;
	ptovta 		integer;
	elcompbte	integer;
	idcli 		integer;
	nrcuit 		character varying;
	cdpag 		integer;
	diasconpag	integer;
	compbte		integer;
	numero 		integer;
	mes	 	integer;
	anio	 	integer;
	ctaiibb	 	integer;
	fecval	 	date;
	ngrav	 	numeric(15,2);
	grav	 	numeric(15,2);
	ivatot	 	numeric(15,2);
	total	 	numeric(15,2);
	ivaex	 	numeric(15,2);
	iva21	 	numeric(15,2);
	auxiva	 	numeric(15,2);
	iva105	 	numeric(15,2);
	tributo	 	numeric(15,2);
	fechaf	 	character varying;
	inserv	 	character varying;
	finserv	 	character varying;
	fecvto	 	character varying;
	regis		record;
	registro	record;
	comporig	character varying;
    BEGIN

	select ash_codemp,ash_idptov,emi_codcli,trim(codcomp(ash_comprob)),ash_fecval,emi_id,emi_conpag,emi_total into codemp,ptovta,idcli,comporig,fecval,idemiti,cdpag,total from astoh,emiti where ash_id=idastoh and emi_idastoh=ash_id;

	select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
	if ctaiibb is null then
	    select idcbl(codemp, valvaramb(codemp,ptovta,'CTAPERIBD')::smallint) into ctaiibb;
	end if;

	select (astc_importe*-1) into tributo from astoctas where astc_idastoh=idastoh and astc_ctacble=ctaiibb;
	if not found then
	    tributo:=0;
	end if;

	select fecha_fe(fecval) into fechaf;
	select date_part('month',fecval) into mes;
	select date_part('year',fecval) into anio;
	inserv:='01'||'-'||mes::text||'-'||anio::text;
	select fecha_fe((date(inserv::date + '1 month'::interval)-1)::date) into finserv;
	select fecha_fe(inserv::date) into inserv;
	select cuit_fe(cuitcli(idcli)) into nrcuit;
	select cdp_dias into diasconpag from conpag where cdp_codigo=cdpag;
	select fecha_fe(date(fecval::date + diasconpag)) into fecvto;
	select compbte_fe(comporig) into compbte;

	grav:=0;
	ivatot:=0;
	ngrav:=0;
	ivaex:=0;
	iva21:=0;
	iva105:=0;
	for regis in select movs_importe,movs_tasa from movsto where movs_idastoh=idastoh 
	    loop
		if (numeric_eq(regis.movs_tasa,(21)::numeric)) then
		    grav:=grav+regis.movs_importe;
		    auxiva:=regis.movs_importe*0.21;
		    iva21:=iva21+auxiva;
		    ivatot:=ivatot+auxiva;
		else
		    if (numeric_eq(regis.movs_tasa,(10.5)::numeric)) then
			grav:=grav+regis.movs_importe;
			auxiva:=regis.movs_importe*0.105;
			iva105:=iva105+auxiva;
			ivatot:=ivatot+auxiva;
		    else
			ngrav:=ngrav+regis.movs_importe;
		    end if;
		end if;
	    end loop;

	insert into auxfe (fe_idcli,fe_cuit,fe_cbte,fe_codemp,fe_ptovta,fe_fechaf,fe_iniserv,fe_finserv,fe_fechavp,fe_nograv,fe_grav,fe_ivatot,fe_total,fe_tributo,fe_ivaex,fe_iva21,fe_iva105) values 
			    (idcli,nrcuit,compbte,codemp,ptovta,fechaf,inserv,finserv,fecvto,ngrav,grav,ivatot,total,tributo,ivaex,iva21,iva105);
	select fe_id into idfe from auxfe where fe_idcli=idcli and fe_fechaf=fechaf and fe_grav=grav and fe_total=total and fe_iva21=iva21 order by 1 desc limit 1;

	update emiti set emi_idfe=idfe where emi_id=idemiti;
    RETURN;
    END;$_$;


ALTER FUNCTION public.graboauxfe(integer) OWNER TO artl;

--
-- Name: graboauxfe(integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION graboauxfe(integer, numeric) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	alic		ALIAS FOR $2;
	idemiti		integer;
	idfe		integer;
	codemp 		integer;
	ptovta 		integer;
	elcompbte	integer;
	idcli 		integer;
	nrcuit 		character varying;
	cdpag 		integer;
	diasconpag	integer;
	compbte		integer;
	numero 		integer;
	mes	 	integer;
	anio	 	integer;
	ctaiibb	 	integer;
	fecval	 	date;
	ngrav	 	numeric(15,2);
	grav	 	numeric(15,2);
	ivatot	 	numeric(15,5);
	total	 	numeric(15,2);
	ivaex	 	numeric(15,2);
	iva21	 	numeric(15,5);
	auxiva	 	numeric(15,2);
	iva105	 	numeric(15,2);
	bimp	 	numeric(15,2);
	tributo	 	numeric(15,2);
	auximp	 	numeric(15,2);
	auxtot	 	numeric(15,2);
	dif	 	numeric(15,2);
	fechaf	 	character varying;
	inserv	 	character varying;
	finserv	 	character varying;
	fecvto	 	character varying;
	regis		record;
	registro	record;
	comporig	character varying;
    BEGIN

	select ash_codemp,ash_idptov,emi_codcli,trim(codcomp(ash_comprob)),ash_fecval,emi_id,emi_conpag,emi_total into codemp,ptovta,idcli,comporig,fecval,idemiti,cdpag,total from astoh,emiti where ash_id=idastoh and emi_idastoh=ash_id;

	select idcbl(codemp,valvaramb(codemp,1,'CTAPERIBD')::smallint) into ctaiibb;
	if ctaiibb is null then
	    select idcbl(codemp, valvaramb(codemp,ptovta,'CTAPERIBD')::smallint) into ctaiibb;
	end if;

	select (astc_importe*-1) into tributo from astoctas where astc_idastoh=idastoh and astc_ctacble=ctaiibb;
	if not found then
	    tributo:=0;
	end if;

	select fecha_fe(fecval) into fechaf;
	select date_part('month',fecval) into mes;
	select date_part('year',fecval) into anio;
	inserv:='01'||'-'||mes::text||'-'||anio::text;
	select fecha_fe((date(inserv::date + '1 month'::interval)-1)::date) into finserv;
	select fecha_fe(inserv::date) into inserv;
	select cuit_fe(cuitcli(idcli)) into nrcuit;
	select cdp_dias into diasconpag from conpag where cdp_codigo=cdpag;
	select fecha_fe(date(fecval::date + diasconpag)) into fecvto;
	select compbte_fe(comporig) into compbte;

	grav:=0;
	ivatot:=0;
	ngrav:=0;
	ivaex:=0;
	iva21:=0;
	iva105:=0;
	for regis in select movs_tasa,sum(movs_importe) as importe from movsto where movs_idastoh=idastoh group by 1 
	    loop
		if (numeric_eq(regis.movs_tasa,(21)::numeric)) then
		    if (bpchareq(comporig,'FB') or bpchareq(comporig,'CB') or bpchareq(comporig,'DB')) then
			auximp:=regis.importe / 1.21;
		    else
			auximp:=regis.importe;
		    end if;
		    grav:=grav+auximp;
		    auxiva:=auximp*0.21;
		    iva21:=iva21+auxiva;
		    ivatot:=ivatot+auxiva;
		else
		    if (numeric_eq(regis.movs_tasa,(10.5)::numeric)) then
			if (bpchareq(comporig,'FB') or bpchareq(comporig,'CB') or bpchareq(comporig,'DB')) then
			    auximp:=regis.importe / 1.105;
			else
			    auximp:=regis.importe;
			end if;
			grav:=grav+auximp;
			auxiva:=auximp*0.105;
			iva105:=iva105+auxiva;
			ivatot:=ivatot+auxiva;
		    else
			ngrav:=ngrav+regis.importe;
		    end if;
		end if;
	    end loop;

	auxtot:=grav+iva21+iva105+tributo;
	if (numeric_ne(auxtot,total)) then
	    dif:=auxtot-total;
	    if(numeric_le(dif,0))then
		dif:=dif*-1;
		iva21:=iva21+dif;
		ivatot:=ivatot+dif;
	    else
		iva21:=iva21-dif;
		ivatot:=ivatot-dif;
	    end if;
	end if;

	insert into auxfe (fe_idcli,fe_cuit,fe_cbte,fe_codemp,fe_ptovta,fe_fechaf,fe_iniserv,fe_finserv,fe_fechavp,fe_nograv,fe_grav,fe_ivatot,fe_total,fe_tributo,fe_ivaex,fe_iva21,fe_iva105) values 
			    (idcli,nrcuit,compbte,codemp,ptovta,fechaf,inserv,finserv,fecvto,ngrav,grav,ivatot::numeric(15,2),total,tributo,ivaex,iva21::numeric(15,2),iva105);
	select fe_id into idfe from auxfe where fe_idcli=idcli and fe_fechaf=fechaf and fe_grav=grav and fe_total=total and fe_iva21=iva21 order by 1 desc limit 1;

    if (bpchareq(comporig,'FB') or bpchareq(comporig,'CB') or bpchareq(comporig,'DB')) then
	bimp:=total;
    else
	bimp:=grav;
    end if;

    if(numeric_ne(tributo,0)) then
	insert into tributosfe (t_idfe,t_cod,t_desc,t_baseimp,t_alic,t_imp) values (idfe, 2, 'Percep IIBB Pcia de Bs As', bimp, alic, tributo);
    end if;

    update emiti set emi_idfe=idfe where emi_id=idemiti;

    RETURN;
    END;$_$;


ALTER FUNCTION public.graboauxfe(integer, numeric) OWNER TO artl;

--
-- Name: grbretib(integer, numeric, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION grbretib(integer, numeric, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
idpago		 alias for $1;
alicuota	 alias for $2;
retfinal	 alias for $3;
neto		 numeric(15,2);
reten		 numeric(15,2);
deboreten	 numeric(15,2);
totpag		 numeric(15,2);
totfac		 numeric(15,2);
totaux		 numeric(15,2);
imppag		 numeric(15,2);
tasa		 numeric(15,2);
codemp		 integer;
idptov		 integer;
cta_retib	 integer;
cta_retibc	 integer;
cta_retiva	 integer;
cta_retiva1	 integer;
cta_iva		 integer;
codcomp		 character varying;
r		 record;
begin
    neto:=0;
    select sum(ag_importe) into totpag from agrupa where ag_idpago=idpago;

    select ash_codemp,ash_idptov into codemp,idptov from astoh where ash_id=idpago;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIB')::integer) into cta_retib;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIBC')::integer) into cta_retibc;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA')::integer) into cta_retiva;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAPERIVA1')::integer) into cta_retiva1;
    select idcbl(codemp,valvaramb(codemp,idptov,'CTAIVAC')::integer) into cta_iva;
    for r in select * from agrupa where ag_idpago=idpago order by 1
	loop
	    select trim(codcompash(r.ag_idastoh)) into codcomp;
	    if codcomp is distinct from 'PP' and codcomp is distinct from 'OP' then
		select sum(astc_importe) into totaux from astoctas where astc_idastoh=r.ag_idastoh and astc_ctacble not in (cta_iva,cta_retib,cta_retibc,cta_retiva,cta_retiva1) and astc_tasa is not null;
		deboreten:=totaux * alicuota / 100;
		if(numeric_ne(r.ag_retenido,0)) then
		    deboreten:=deboreten - r.ag_retenido;
		end if;
		neto:=neto + deboreten;
	    end if;
	end loop;

    if(numeric_eq(retfinal,neto)) then
	for r in select * from agrupa where ag_idpago=idpago order by 1
	    loop
		select trim(codcompash(r.ag_idastoh)) into codcomp;
		if codcomp is distinct from 'PP' and codcomp is distinct from 'OP' then
		    select sum(astc_importe) into totaux from astoctas where astc_idastoh=r.ag_idastoh and astc_ctacble not in (cta_iva,cta_retib,cta_retibc,cta_retiva,cta_retiva1) and astc_tasa is not null;
		    deboreten:=totaux * alicuota / 100;
		    update agrupa set ag_retenido=deboreten where ag_id=r.ag_id;
		end if;
	    end loop;
    else
	imppag:=retfinal;
	for r in select * from agrupa where ag_idpago=idpago order by 1
	    loop
		select trim(codcompash(r.ag_idastoh)) into codcomp;
		if codcomp is distinct from 'PP' and codcomp is distinct from 'OP' then
		    select sum(astc_importe) into totaux from astoctas where astc_idastoh=r.ag_idastoh and astc_ctacble not in (cta_iva,cta_retib,cta_retibc,cta_retiva,cta_retiva1) and astc_tasa is not null;
		    deboreten:=totaux * alicuota / 100;
		    if(numeric_ne(r.ag_retenido,0)) then
			deboreten:=deboreten - r.ag_retenido;
		    end if;
		    if(numeric_gt(imppag,deboreten)) then
			if(numeric_ne(r.ag_retenido,0)) then
			    deboreten:=deboreten + r.ag_retenido;
			end if;
			update agrupa set ag_retenido=deboreten where ag_id=r.ag_id;
			imppag:=imppag - deboreten;
		    else
			if(numeric_gt(imppag,0)) then
			    if(numeric_ne(r.ag_retenido,0)) then
				imppag:=imppag + r.ag_retenido;
			    end if;
			    update agrupa set ag_retenido=imppag where ag_id=r.ag_id;
			    imppag:=0;
			end if;
		    end if;
		end if;
	    end loop;
    end if;

    return neto;
end;$_$;


ALTER FUNCTION public.grbretib(integer, numeric, numeric) OWNER TO artl;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cli_grupo into retval from
    	 clientes where int4eq(cliente,cli_id);

    if found then
	if int4eq(modo,1) then
	    update clientes set cli_grupo=cli_grupo+1 where int4eq(cliente,cli_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO artl;

--
-- Name: grupoprov(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION grupoprov(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select prov_grupo into retval from
    	 prove where int4eq(provd,prov_id);

    if found then
	if int4eq(modo,1) then
	    update prove set prov_grupo=prov_grupo+1 where int4eq(provd,prov_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupoprov(integer, integer) OWNER TO artl;

--
-- Name: habro_ejercicio(character varying, date, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION habro_ejercicio(character varying, date, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
codemp		 alias for $3;
idptov		 alias for $4;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
compcierre 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
idashcierre 	 integer;
begin
ret:='f';
    select idcomp(comprobante,idptov) into elcomprob;
    select idcomp('ZZ',idptov) into compcierre;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' INICIADO EL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,date_part('year',fecha)::int2,date_part('month',fecha)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Apertura de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select ash_id into idashcierre from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=compcierre and date_le(ash_fecval,fecha) order by ash_id desc limit 1;

    for registro in select 
	    astc_ctacble, astc_tipcta, astc_ctacte, (astc_importe * -1) as cuanto from astoctas 
	      where astc_idastoh=idashcierre  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1,registro.astc_tipcta,registro.astc_ctacte);	
		end if;
	ret:='t';
    end loop; 
    return ret;
end;$_$;


ALTER FUNCTION public.habro_ejercicio(character varying, date, integer, integer) OWNER TO artl;

--
-- Name: idarticvta(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idarticvta(integer, integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select art_id from articvta where art_codemp= $1 and art_idptov= $2 and bpchareq(trim( $3 ),art_codigo);$_$;


ALTER FUNCTION public.idarticvta(integer, integer, character varying) OWNER TO artl;

--
-- Name: idashdecomp(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idashdecomp(integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_id from astoh where ash_codemp= $1 and ash_idptov= $2 and ash_comprob= $3 and ash_numero= $4;$_$;


ALTER FUNCTION public.idashdecomp(integer, integer, integer, integer) OWNER TO artl;

--
-- Name: idcbl(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcbl(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_id from ctacble where cbl_codemp in ( $1,0) and int4eq(cbl_codigo::integer, $2) order by cbl_codemp desc limit 1;$_$;


ALTER FUNCTION public.idcbl(integer, integer) OWNER TO artl;

--
-- Name: idcble(integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcble(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_id from ctacble where cbl_codemp= $1 and bpchareq(cbl_codigo, $2);$_$;


ALTER FUNCTION public.idcble(integer, character varying) OWNER TO artl;

--
-- Name: idcli(integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcli(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_id from clientes where cli_codemp= $1 and bpchareq(cli_codigo, $2);$_$;


ALTER FUNCTION public.idcli(integer, character varying) OWNER TO artl;

--
-- Name: idcli(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcli(integer, integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_id from clientes where cli_codemp= $1 and cli_idptov= $2 and bpchareq(cli_codigo, $3);$_$;


ALTER FUNCTION public.idcli(integer, integer, character varying) OWNER TO artl;

--
-- Name: idcomp(character varying, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcomp(character varying, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select comp_id from comprob where bpchareq(trim(comp_codigo),trim( $1 )) and comp_idptov in ( $2 ,0, -1) order by comp_idptov desc limit 1;$_$;


ALTER FUNCTION public.idcomp(character varying, integer) OWNER TO artl;

--
-- Name: idcomp(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idcomp(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select comp_id from comprob where bpchareq(trim(comp_codigo),trim( $1 )) and comp_idptov in ( $2 , -1) and comp_codemp= $3 order by comp_idptov desc limit 1;$_$;


ALTER FUNCTION public.idcomp(character varying, integer, integer) OWNER TO artl;

--
-- Name: idctes(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idctes(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_id from ctes where cte_tipcta= $1 and cte_codigo= $2;$_$;


ALTER FUNCTION public.idctes(integer, integer) OWNER TO artl;

--
-- Name: idemitiash(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idemitiash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_id from emiti where emi_idastoh = $1 ;$_$;


ALTER FUNCTION public.idemitiash(integer) OWNER TO artl;

--
-- Name: idprov(integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idprov(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_id from prove where prov_codemp= $1 and bpchareq(prov_codigo, $2);$_$;


ALTER FUNCTION public.idprov(integer, character varying) OWNER TO artl;

--
-- Name: idptov(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION idptov(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 and ptv_codigo= $2;$_$;


ALTER FUNCTION public.idptov(integer, integer) OWNER TO artl;

--
-- Name: importe_fe(numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION importe_fe(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	imp		ALIAS FOR $1;
	retval		text;
    BEGIN
	select lpad((imp::numeric(15,2)*100)::numeric(15,0)::text,15,'0') into retval;
	RETURN retval;
    END;$_$;


ALTER FUNCTION public.importe_fe(numeric) OWNER TO artl;

--
-- Name: importedeleyen(integer, integer, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION importedeleyen(integer, integer, integer, integer, character varying) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_estado=2 and astc_idptov=$1 and astc_ctacble=$2 and date_part('month',astc_fecval)=$3 and date_part('year',astc_fecval)=$4 and trim(astc_leyen) like trim($5);$_$;


ALTER FUNCTION public.importedeleyen(integer, integer, integer, integer, character varying) OWNER TO artl;

--
-- Name: leyartic(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION leyartic(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select art_leyen from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.leyartic(integer) OWNER TO artl;

--
-- Name: llevastock(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION llevastock(integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from varambi where vari_codemp= $1 and vari_codigo='STOCK' and vari_valor='1' limit 1;$_$;


ALTER FUNCTION public.llevastock(integer) OWNER TO artl;

--
-- Name: mesastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION mesastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_mes from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.mesastoh(integer) OWNER TO artl;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO artl;

--
-- Name: monedeempre(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION monedeempre(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from monex a, astoctas b where a.mne_id= $2 and a.mne_idastoc=b.astc_id and b.astc_codemp= $1 ;$_$;


ALTER FUNCTION public.monedeempre(integer, integer) OWNER TO artl;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO artl;

--
-- Name: nomarticc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomarticc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select artc_nombre from articu where artc_id= $1 ;$_$;


ALTER FUNCTION public.nomarticc(integer) OWNER TO artl;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO artl;

--
-- Name: nomcli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.nomcli(integer) OWNER TO artl;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO artl;

--
-- Name: nomconpag(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomconpag(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cdp_nombre from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomconpag(integer) OWNER TO artl;

--
-- Name: nomctes(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.nomctes(integer) OWNER TO artl;

--
-- Name: nomelm(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomelm(integer) RETURNS character
    LANGUAGE sql
    AS $_$select zon_nombre from zona where zon_codigo= $1 ;$_$;


ALTER FUNCTION public.nomelm(integer) OWNER TO artl;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO artl;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO artl;

--
-- Name: nomivacli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomivacli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva,clientes where iva_codigo=cli_coniva and cli_id= $1 ;$_$;


ALTER FUNCTION public.nomivacli(integer) OWNER TO artl;

--
-- Name: nommoneda(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nommoneda(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_nombre from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.nommoneda(smallint) OWNER TO artl;

--
-- Name: nomopera(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomopera(integer) RETURNS character
    LANGUAGE sql
    AS $_$select operad_nombre from operadores where operad_id= $1 ;$_$;


ALTER FUNCTION public.nomopera(integer) OWNER TO artl;

--
-- Name: nompais(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nompais(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais where pai_codigo= $1 ;$_$;


ALTER FUNCTION public.nompais(smallint) OWNER TO artl;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO artl;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO artl;

--
-- Name: nomptv(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.nomptv(integer) OWNER TO artl;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomtipcta(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO artl;

--
-- Name: nomvend(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nomvend(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ven_nombre from vendedor where ven_id= $1 ;$_$;


ALTER FUNCTION public.nomvend(integer) OWNER TO artl;

--
-- Name: nroastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION nroastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_numero from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.nroastc(integer) OWNER TO artl;

--
-- Name: numash(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION numash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_numero from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.numash(integer) OWNER TO artl;

--
-- Name: numemiti(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION numemiti(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_numero from emiti where emi_id = $1 ;$_$;


ALTER FUNCTION public.numemiti(integer) OWNER TO artl;

--
-- Name: numero_letras(numeric); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION numero_letras(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
     numero	ALIAS FOR $1;
     lnEntero INTEGER;
     lcRetorno TEXT = '';
     lnTerna INTEGER = 1;
     lcMiles TEXT;
     lcCadena TEXT;
     maxi TEXT;
     lnUnidades INTEGER;
     lnDecenas INTEGER;
     lnCentenas INTEGER;
     lnFraccion INTEGER;
     lnSw INTEGER;
BEGIN
     lnEntero := FLOOR(numero)::INTEGER;--Obtenemos la parte Entera
     lnFraccion := FLOOR(((numero - lnEntero) * 100))::INTEGER;--Obtenemos la Fraccion del Monto
    -- lcRetorno := '';
    -- lnTerna := 1;
     IF lnEntero > 0 THEN
     lnSw := LENGTH(lnEntero::varchar);
     WHILE lnTerna <= lnSw LOOP
        -- Recorro terna por terna
        lcCadena = '';
        lnUnidades = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnDecenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnCentenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
       SELECT
         CASE /* UNIDADES */
           WHEN lnUnidades = 1 AND lnTerna = 1 THEN 'UNO ' || lcCadena
           WHEN lnUnidades = 1 AND lnTerna <> 1 THEN 'UN ' || lcCadena
           WHEN lnUnidades = 2 THEN 'DOS ' || lcCadena
           WHEN lnUnidades = 3 THEN 'TRES ' || lcCadena
           WHEN lnUnidades = 4 THEN 'CUATRO ' || lcCadena
           WHEN lnUnidades = 5 THEN 'CINCO ' || lcCadena
           WHEN lnUnidades = 6 THEN 'SEIS ' || lcCadena
           WHEN lnUnidades = 7 THEN 'SIETE ' || lcCadena
           WHEN lnUnidades = 8 THEN 'OCHO ' || lcCadena
           WHEN lnUnidades = 9 THEN 'NUEVE ' || lcCadena
           ELSE lcCadena
          END INTO lcCadena;
          /* UNIDADES */
    -- Analizo las decenas
    SELECT
    CASE /* DECENAS */
      WHEN lnDecenas = 1 THEN
        CASE lnUnidades
          WHEN 0 THEN 'DIEZ '
          WHEN 1 THEN 'ONCE '
          WHEN 2 THEN 'DOCE '
          WHEN 3 THEN 'TRECE '
          WHEN 4 THEN 'CATORCE '
          WHEN 5 THEN 'QUINCE '
          ELSE 'DIECI' || lcCadena
        END
      WHEN lnDecenas = 2 AND lnUnidades = 0 THEN 'VEINTE ' || lcCadena
      WHEN lnDecenas = 2 AND lnUnidades <> 0 THEN 'VEINTI' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades = 0 THEN 'TREINTA ' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades <> 0 THEN 'TREINTA Y ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades = 0 THEN 'CUARENTA ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades <> 0 THEN 'CUARENTA Y ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades = 0 THEN 'CINCUENTA ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades <> 0 THEN 'CINCUENTA Y ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades = 0 THEN 'SESENTA ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades <> 0 THEN 'SESENTA Y ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades = 0 THEN 'SETENTA ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades <> 0 THEN 'SETENTA Y ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades = 0 THEN 'OCHENTA ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades <> 0 THEN 'OCHENTA Y ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades = 0 THEN 'NOVENTA ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades <> 0 THEN 'NOVENTA Y ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena; /* DECENAS */
    -- Analizo las centenas
    SELECT
    CASE /* CENTENAS */
      WHEN lnCentenas = 1 AND lnUnidades = 0 AND lnDecenas = 0 THEN 'CIEN ' || lcCadena
      WHEN lnCentenas = 1 AND NOT(lnUnidades = 0 AND lnDecenas = 0) THEN 'CIENTO ' || lcCadena
      WHEN lnCentenas = 2 THEN 'DOSCIENTOS ' || lcCadena
      WHEN lnCentenas = 3 THEN 'TRESCIENTOS ' || lcCadena
      WHEN lnCentenas = 4 THEN 'CUATROCIENTOS ' || lcCadena
      WHEN lnCentenas = 5 THEN 'QUINIENTOS ' || lcCadena
      WHEN lnCentenas = 6 THEN 'SEISCIENTOS ' || lcCadena
      WHEN lnCentenas = 7 THEN 'SETECIENTOS ' || lcCadena
      WHEN lnCentenas = 8 THEN 'OCHOCIENTOS ' || lcCadena
      WHEN lnCentenas = 9 THEN 'NOVECIENTOS ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena;/* CENTENAS */
    -- Analizo la terna
    SELECT
    CASE /* TERNA */
      WHEN lnTerna = 1 THEN lcCadena
      WHEN lnTerna = 2 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0 THEN lcCadena || ' MILLON '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        NOT (lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0) THEN lcCadena || ' MILLONES '
      WHEN lnTerna = 4 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL MILLONES '
      ELSE ''
    END INTO lcCadena;/* TERNA */
 
    --Retornamos los Valores Obtenidos
    lcRetorno = lcCadena  || lcRetorno;
    lnTerna = lnTerna + 1;
    END LOOP;
  END IF;
  IF lnTerna = 1 THEN
    lcRetorno := 'CERO';
  END IF;

  
  IF lnFraccion!= 0  THEN
	lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' CON ' || LTRIM(lnFraccion::varchar) || '/100 CENTAVOS ------';
    else
	lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' ------';
  END IF;

RETURN lcRetorno;
end;$_$;


ALTER FUNCTION public.numero_letras(numeric) OWNER TO zona;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO artl;

--
-- Name: numtalonf(integer, integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION numtalonf(integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comprob		ALIAS FOR $2; 
	fecha		ALIAS FOR $3;
	otro 		integer;
	anter		date;
	retval 		integer;
    BEGIN

    select tal_fecha into anter from
    	 talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);

    if(date_le(anter,fecha)) then
	select tal_valor into retval from
    	    talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	if not found then
		otro:=0;
		select tal_valor into retval from talon where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
	     else
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	end if;
      else
        retval:=-1;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalonf(integer, integer, date) OWNER TO artl;

--
-- Name: pagfac1(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION pagfac1(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
ret 		 varchar;
aux1 		 varchar;
aux2 		 varchar;
codemp	 	 integer;
cuantchq 	 integer;
pago	 	 numeric;
eneft	 	 numeric;
enchq	 	 numeric;
enotr	 	 numeric;
begin
codemp:=1;

    select sum(astc_importe) into pago from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) and astc_importe<0 and codcomp(astc_comprob) not in ('CA','CB');

    if pago is not null then
	ret:='Forma de Pago:';
	select sum(astc_importe) into eneft from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer) and astc_importe>0;
	select sum(astc_importe) into enchq from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
	select sum(astc_importe) into enotr from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
	if eneft is not null then
	    ret:= ret || '  Efectivo                                                      $'|| eneft ;
	  else	    
	    if enchq is not null then
		select count(*) into cuantchq from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
		if (cuantchq>2) then
		    ret:= ret || '  Cheques segun detalle al dorso                                 $'|| enchq ;
		    end if;
		if (cuantchq<3) then
		    select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 order by chq_id asc limit 1;
		    ret:= ret ||' Cheque '|| aux1;
		    end if;
	      else	    
		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;
	    end if;
	end if;

if ret is null then 
    ret:='   ';
end if;

return ret;
end;$_$;


ALTER FUNCTION public.pagfac1(integer) OWNER TO artl;

--
-- Name: pagfac2(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION pagfac2(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
declare
idastoh		 alias for $1;
ret 		 varchar;
aux1 		 varchar;
aux2 		 varchar;
codemp	 	 integer;
cuantchq 	 integer;
pago	 	 numeric;
eneft	 	 numeric;
enchq	 	 numeric;
enotr	 	 numeric;
begin
codemp:=1;

    select sum(astc_importe) into pago from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer) and astc_importe<0 and codcomp(astc_comprob) not in ('CA','CB');

    if pago is not null then
	select sum(astc_importe) into eneft from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer) and astc_importe>0;
	select sum(astc_importe) into enchq from astoctas where astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
	select sum(astc_importe) into enotr from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
	if eneft is not null then
	    if enchq is not null then
		select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 limit 1;
		ret:= ret ||' Cheque '|| aux1;
	      else	    
		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;

	  else    

	    if enchq is not null then
		select count(*) into cuantchq from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0;
		if int4eq(cuantchq,2) then
		    select descchqf(chq_id) into aux1 from cheques, astoctas where chq_idastoc=astc_id and astc_idastoh=idastoh and astc_ctacble=idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer) and astc_importe>0 order by chq_id desc limit 1;
		    ret:= ret ||' Cheque '|| aux1;
	    	  else	    
		    if enotr is not null then
			select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
			ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
			end if;
		    end if;

	      else	    

		if enotr is not null then
		    select descble(astc_ctacble) into aux2 from astoctas where astc_idastoh=idastoh and astc_ctacble not in (idcbl(codemp,valvaramb(codemp,0,'CHEQUE')::integer),idcbl(codemp,valvaramb(codemp,0,'CAJA')::integer),idcbl(codemp,valvaramb(codemp,0,'DEUDXV')::integer)) and astc_importe>0;
		    ret:= ret ||'  '|| aux2 ||'                 $'||  enotr;
		    end if;
		end if;
	    end if;
	end if;

if ret is null then 
    ret:='   ';
end if;

return ret;
end;$_$;


ALTER FUNCTION public.pagfac2(integer) OWNER TO artl;

--
-- Name: pedirem(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION pedirem(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idemiti		ALIAS FOR $1;
	compara 	integer;
	retval 		boolean;
    BEGIN
    retval:='f';

    select rn_idemitip into compara from relnotp where rn_idemitih=idemiti limit 1;
    if not found then 
	retval:='t';
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.pedirem(integer) OWNER TO artl;

--
-- Name: prescble(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION prescble(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
origen 		 alias for $1;
destino		 alias for $2;
ret 		 boolean;
registro	 record;
auxo		 varchar;
begin
ret:='t';
	for registro in select * from ctacble 
	      where cbl_codemp=destino and cbl_present is null 
	    loop
		select cbl_present into auxo from ctacble where cbl_codemp=origen and bpchareq(cbl_codigo,registro.cbl_codigo);
		if auxo is not null then
		    update ctacble set cbl_present=auxo where cbl_id=registro.cbl_id;
		end if;
	    end loop; 
return ret;
end;$_$;


ALTER FUNCTION public.prescble(integer, integer) OWNER TO artl;

--
-- Name: provastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION provastoh(integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
declare
astc	 alias for $1;
ret	 varchar;
begin

ret:='';
select descprov(astc_ctacte) into ret from astoctas where astc_idastoh= astc and astc_tipcta=98 and astc_ctacble=1766;
return ret;
end;$_$;


ALTER FUNCTION public.provastoh(integer) OWNER TO artl;

--
-- Name: provedemovc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION provedemovc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cpra_prove from compra where cpra_id = (select movc_idcompra from movstoc where movc_id = $1) ;$_$;


ALTER FUNCTION public.provedemovc(integer) OWNER TO artl;

--
-- Name: provinclie(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION provinclie(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sucu_provin from sucursalc where sucu_cliente= $1 and sucu_codigo= $2 ;$_$;


ALTER FUNCTION public.provinclie(integer, integer) OWNER TO artl;

--
-- Name: proxgpocli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION proxgpocli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(astc_grupo)+1 from astoctas where astc_codemp=1 and astc_ctacble=18 and astc_ctacte= $1 ;$_$;


ALTER FUNCTION public.proxgpocli(integer) OWNER TO artl;

--
-- Name: proxgpocte(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION proxgpocte(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(astc_grupo)+1 from astoctas where astc_ctacte= $1 ;$_$;


ALTER FUNCTION public.proxgpocte(integer) OWNER TO artl;

--
-- Name: ptovdeastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ptovdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idptov from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ptovdeastc(integer) OWNER TO artl;

--
-- Name: ptovdeastoc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ptovdeastoc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idptov from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ptovdeastoc(integer) OWNER TO artl;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO artl;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO artl;

--
-- Name: remitofactur(integer, date, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION remitofactur(integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	fecfactu	ALIAS FOR $2;
	modo		ALIAS FOR $3;
	retval 		integer;
	retvalc		character;
	civaemp		integer;
	civacli		integer;
	codemp 		integer;
	idptov 		integer;
	elcompbte	integer;
	compremito	integer;
	idcli 		integer;
	tipiva 		integer;
	succli 		integer;
	numero 		integer;
	newidastoh 	integer;
	newidemiti 	integer;
	fecfact 	date;
	ultfecfact 	date;
	anio		smallint;
	mes		smallint;
	regis		record;
	registro	record;
	titulo 		character varying;
	nomclie		character varying;
	comporig	character varying;
    BEGIN

	retval:=0;
	fecfact:=fecfactu;

	select ash_codemp,ash_idptov,emi_codcli,emi_succli,trim(codcomp(ash_comprob)) into codemp,idptov,idcli,succli,comporig from astoh,emiti where ash_id=idastoh and emi_idastoh=ash_id;
	select ptv_tipiva::int4 into tipiva from ptovta where ptv_id=idptov;
	select emp_coniva::int4 into civaemp from empresa where emp_codigo=codemp;
	select cli_coniva::int4 into civacli from clientes where cli_id=idcli;

	select date_part('Y',fecfact) into anio;
	select date_part('month',fecfact) into mes;

	if int4eq(civaemp,1) then
	    if (int4eq(civacli,1) or int4eq(civacli,8))then
		if bpchareq(comporig,'DV') then
		    select idcomp('CA',idptov,codemp) into elcompbte;
		  else
		    if (int4eq(codemp,2)) then
			select idcomp('FM',idptov,codemp) into elcompbte;
		    else
			select idcomp('FA',idptov,codemp) into elcompbte;
		    end if;
		end if;

	      else

		if bpchareq(comporig,'DV') then
		    select idcomp('CB',idptov,codemp) into elcompbte;
		  else
		    select idcomp('FB',idptov,codemp) into elcompbte;
		end if;
	    end if;
	end if;

	if bpchareq(comporig,'DV') then
	    select idcomp('DV',idptov,codemp) into compremito;
	  else
	    select idcomp('RE',idptov,codemp) into compremito;
	end if;

	select ash_fecval into ultfecfact from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_estado=2 and ash_comprob=elcompbte order by 1 desc limit 1;
	if(date_lt(fecfact,ultfecfact)) then
	    fecfact:=ultfecfact;
	end if;

	select desccli(idcli,succli) into nomclie;

	select nomcomp(elcompbte) ||' DE '|| nomclie into titulo;

	select numtalon(idptov,elcompbte,1) into numero;

	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_nro2,ash_estado) 
	    values (codemp,idptov,anio,mes,elcompbte,numero,titulo,fecfact,fecfact,0,-1);

	select ash_id into newidastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcompbte and ash_numero=numero;

	insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrcuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado) 
	    select newidastoh,emi_codemp,emi_idptov,elcompbte,numero,fecfact,emi_codcli,emi_nomcli,emi_nrcuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,-1 from emiti where emi_idastoh=idastoh;

	select emi_id into newidemiti from emiti where emi_idastoh=newidastoh;

	if int4eq(modo,1) then
	    insert into relrem (rr_idastohp,rr_idastohh) values (newidastoh,idastoh);

	    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		select newidastoh,newidemiti,movs_codemp,movs_idptov,fecfact,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,-1,movs_codcli,movs_tasa from movsto where movs_idastoh=idastoh;

	    update astoh set ash_idemiti=newidemiti where ash_id=newidastoh;

	    update emiti set emi_facturado=2 where emi_idastoh=idastoh;

	    update astoh set ash_estado=100 where ash_id=idastoh;
	end if;



	if int4eq(modo,2) then
	    for regis in select emi_idastoh from emiti where emi_codemp=codemp and emi_idptov=idptov and emi_comprob=compremito and emi_facturado=1 and date_le(emi_fecval,fecfact) and emi_codcli=idcli and emi_succli=succli and emi_estado=2 order by emi_numero
		loop
		insert into relrem (rr_idastohp,rr_idastohh) values (newidastoh,regis.emi_idastoh);

		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		    select newidastoh,newidemiti,movs_codemp,movs_idptov,fecfact,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,-2,movs_codcli,movs_tasa from movsto where movs_idastoh=regis.emi_idastoh;

		update emiti set emi_facturado=2 where emi_idastoh=regis.emi_idastoh;
		update astoh set ash_estado=100 where ash_id=regis.emi_idastoh;
		end loop;

	    for registro in select movs_artic,movs_precio,movs_tasa,sum(movs_canti) as lacanti,sum(movs_importe) as elimporte from movsto where movs_idastoh=newidastoh group by 1,2,3
		loop
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		    values (newidastoh,newidemiti,codemp,idptov,fecfact,registro.movs_artic,registro.lacanti,1,registro.movs_precio,registro.elimporte,-1,idcli,registro.movs_tasa);
		end loop;

	    delete from movsto where movs_idastoh=newidastoh and movs_estado=-2;

	    update astoh set ash_idemiti=newidemiti where ash_id=newidastoh;
	end if;



	select graboastoctasi(newidastoh) into retval;

	update astoh set ash_estado=2 where ash_id=newidastoh;

	update astoh set ash_estado=2 where ash_estado=35 and int4eq(codclideastoh(ash_id),idcli);

	if(date_ge(fecfactu,'01-07-2015'::date) and int4eq(tipiva,1)) then
	    select graboauxfe(newidastoh) into retvalc;
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.remitofactur(integer, date, integer) OWNER TO artl;

--
-- Name: remitofactur(integer, date, integer, numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION remitofactur(integer, date, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1;
	fecfactu	ALIAS FOR $2;
	modo		ALIAS FOR $3;
	alicuota	ALIAS FOR $4;
	retval 		integer;
	retvalc		character;
	civaemp		integer;
	civacli		integer;
	codemp 		integer;
	idptov 		integer;
	elcompbte	integer;
	compremito	integer;
	idcli 		integer;
	tipiva 		integer;
	succli 		integer;
	numero 		integer;
	maxnum 		integer;
	minnum 		integer;
	newidastoh 	integer;
	newidemiti 	integer;
	fecfact 	date;
	ultfecfact 	date;
	anio		smallint;
	mes		smallint;
	regis		record;
	registro	record;
	titulo 		character varying;
	nomclie		character varying;
	comporig	character varying;
    BEGIN

	retval:=0;
	fecfact:=fecfactu;

	select ash_codemp,ash_idptov,emi_codcli,emi_succli,trim(codcomp(ash_comprob)) into codemp,idptov,idcli,succli,comporig from astoh,emiti where ash_id=idastoh and emi_idastoh=ash_id;
	select ptv_tipiva::int4 into tipiva from ptovta where ptv_id=idptov;
	select emp_coniva::int4 into civaemp from empresa where emp_codigo=codemp;
	select cli_coniva::int4 into civacli from clientes where cli_id=idcli;

	select date_part('Y',fecfact) into anio;
	select date_part('month',fecfact) into mes;

	if int4eq(civaemp,1) then
	    if (int4eq(civacli,1) or int4eq(civacli,8))then
		if bpchareq(comporig,'DV') then
		    select idcomp('CA',idptov,codemp) into elcompbte;
		  else
		    select idcomp('FA',idptov,codemp) into elcompbte;
		end if;

	      else

		if bpchareq(comporig,'DV') then
		    select idcomp('CB',idptov,codemp) into elcompbte;
		  else
		    select idcomp('FB',idptov,codemp) into elcompbte;
		end if;
	    end if;
	end if;

	if bpchareq(comporig,'DV') then
	    select idcomp('DV',idptov,codemp) into compremito;
	  else
	    select idcomp('RE',idptov,codemp) into compremito;
	end if;

	select ash_fecval into ultfecfact from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_estado=2 and ash_comprob=elcompbte order by 1 desc limit 1;
	if(date_lt(fecfact,ultfecfact)) then
	    fecfact:=ultfecfact;
	end if;

	select desccli(idcli,succli) into nomclie;

	select nomcomp(elcompbte) ||' DE '|| nomclie into titulo;

	select ash_numero into maxnum from astoh where ash_comprob=elcompbte and ash_idptov=idptov order by ash_numero desc limit 1;
	select ash_numero into minnum from astoh where ash_comprob=elcompbte and ash_idptov=idptov order by ash_numero asc limit 1;
	if (numeric_le(minnum,0)) then
	    minnum:= minnum*-1;
	end if;

	if maxnum is null then
	    numero=-1;
	else
	    if(numeric_ge(maxnum,minnum)) then
		numero:=(maxnum+1)*-1;
	    else
		numero:=(minnum*-1)-1;
	    end if;
	end if;

	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_nro2,ash_estado) 
	    values (codemp,idptov,anio,mes,elcompbte,numero,titulo,fecfact,fecfact,0,-1);

	select ash_id into newidastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcompbte and ash_numero=numero;

	insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrcuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado,emi_leyen,emi_ordencompra) 
	    select newidastoh,emi_codemp,emi_idptov,elcompbte,numero,fecfact,emi_codcli,emi_nomcli,emi_nrcuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,-1,emi_leyen,emi_ordencompra from emiti where emi_idastoh=idastoh;
	select emi_id into newidemiti from emiti where emi_idastoh=newidastoh;

	update emiti set emi_grupo=grupocli(idcli,1) where emi_id=newidastoh;


	if int4eq(modo,1) then
	    insert into relrem (rr_idastohp,rr_idastohh) values (newidastoh,idastoh);

	    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		select newidastoh,newidemiti,movs_codemp,movs_idptov,fecfact,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,-1,movs_codcli,movs_tasa from movsto where movs_idastoh=idastoh;

	    update astoh set ash_idemiti=newidemiti where ash_id=newidastoh;

	    update emiti set emi_facturado=2 where emi_idastoh=idastoh;

	    update astoh set ash_estado=100 where ash_id=idastoh;
	end if;



	if int4eq(modo,2) then
	    for regis in select emi_idastoh from emiti where emi_codemp=codemp and emi_idptov=idptov and emi_comprob=compremito and emi_facturado=1 and date_le(emi_fecval,fecfact) and emi_codcli=idcli and emi_succli=succli and emi_estado=2 order by emi_numero
		loop
		insert into relrem (rr_idastohp,rr_idastohh) values (newidastoh,regis.emi_idastoh);

		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		    select newidastoh,newidemiti,movs_codemp,movs_idptov,fecfact,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,-2,movs_codcli,movs_tasa from movsto where movs_idastoh=regis.emi_idastoh;

		update emiti set emi_facturado=2 where emi_idastoh=regis.emi_idastoh;
		update astoh set ash_estado=100 where ash_id=regis.emi_idastoh;
		end loop;

	    for registro in select movs_artic,movs_precio,movs_tasa,sum(movs_canti) as lacanti,sum(movs_importe) as elimporte from movsto where movs_idastoh=newidastoh group by 1,2,3
		loop
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_estado,movs_codcli,movs_tasa) 
		    values (newidastoh,newidemiti,codemp,idptov,fecfact,registro.movs_artic,registro.lacanti,1,registro.movs_precio,registro.elimporte,-1,idcli,registro.movs_tasa);
		end loop;

	    delete from movsto where movs_idastoh=newidastoh and movs_estado=-2;

	    update astoh set ash_idemiti=newidemiti where ash_id=newidastoh;
	end if;



	select graboastoctasi(newidastoh,alicuota) into retval;

	retval:=newidastoh;

	update astoh set ash_estado=2 where ash_id=newidastoh;

	update astoh set ash_estado=2 where ash_estado=35 and int4eq(codclideastoh(ash_id),idcli);

	if(date_ge(fecfactu,'01-07-2015'::date) and int4eq(tipiva,1)) then
	    select graboauxfe(newidastoh,alicuota) into retvalc;
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.remitofactur(integer, date, integer, numeric) OWNER TO artl;

--
-- Name: retenig(integer, numeric, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION retenig(integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	imppago		ALIAS FOR $2;
	fecha		ALIAS FOR $3;
	codemp		integer;
	ptov		integer;
	tipct		integer;
	retsn		integer;
	idastoh		integer;
	deudxc		integer;
	ctaretig	integer;
	compnk		integer;
	registro	record;
	totpagt		numeric;
	totrett		numeric;
	totpag 		numeric;
	totret 		numeric;
	mnoi 		numeric;
	tasa 		numeric;
	retval 		numeric;
    BEGIN
    select prov_codemp into codemp from prove where prov_id=provd;
    select prov_idptov into ptov from prove where prov_id=provd;
    select valvaramb(codemp,ptov,'TIPCTADXC') into tipct;	
    select idcbl(codemp,valvaramb(codemp,ptov,'DEUDXC')::int4) into deudxc;
    select idcbl(codemp,valvaramb(codemp,ptov,'CTARETIG')::int4) into ctaretig;
    select valvaramb(codemp,ptov,'MNIRETIG') into mnoi;
    select valvaramb(codemp,ptov,'TASARIG') into tasa;
    select prov_retig into retsn from prove where prov_id=provd;
    select idcomp('NK',1) into compnk;

    totrett:=0;
    totpagt:=0;
    totret:=0;
    totpag:=0;
    retval:=0;


    if int4eq(retsn,1) then

	for registro in select 
         * from astoctas where astc_estado=2 and astc_ctacble=deudxc and astc_tipcta=tipct and astc_ctacte=provd and date_part('year',astc_fecval)=date_part('year',fecha::date) and date_part('month',astc_fecval)=date_part('month',fecha::date) and astc_importe>0 and astc_comprob!=compnk  
	    loop 
	    select sum(astc_importe*-1) into totrett from astoctas where astc_idastoh=registro.astc_idastoh and astc_ctacble=ctaretig and astc_importe<0; 
	    select sum(astc_importe*-1) into totpagt from astoctas where astc_idastoh=registro.astc_idastoh and astc_importe<0; 
	
	    if totpagt is null then
		totpagt:=0;
	    end if;

	    if totrett is null then
		totrett:=0;
	    end if;

	    totpag:= totpag + totpagt;
	    totret:= totret + totrett;
	    
	    end loop;

	    
	if totpag is null then
	    totpag:=0;
	end if;

	if totret is null then
	    totret:=0;
	end if;

	totpag:= ((totpag + imppago)/1.21) - mnoi;


	if(totpag > 0 ) then
	    retval:= ( totpag * tasa / 100) - totret;
	end if;

	if(retval < 0 ) then
	end if;

    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.retenig(integer, numeric, date) OWNER TO artl;

--
-- Name: rubdeart(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION rubdeart(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select art_codrub from articvta where art_id = $1;$_$;


ALTER FUNCTION public.rubdeart(integer) OWNER TO artl;

--
-- Name: saldoal(integer, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION saldoal(integer, integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	tipcta		ALIAS FOR $3; 
	ctacte		ALIAS FOR $4;
	fechad		ALIAS FOR $5;
	salant 		numeric;
	retval 		numeric;
    BEGIN
    select sum(astc_importe) into retval from astoctas 
	where astc_codemp=codemp and astc_idptov=ptovta and astc_tipcta=tipcta 
	and astc_ctacte=ctacte and astc_fecval< fechad and astc_cierra= 1
	and astc_estado=2;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldoal(integer, integer, integer, integer, date) OWNER TO artl;

--
-- Name: saldocbl(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION saldocbl(integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	cuenta		ALIAS FOR $3; 
	fechad		ALIAS FOR $4;
	retval 		numeric;
    BEGIN
    if int4eq(codemp,-1) then
	    select sum(astc_importe) into retval from astoctas 
		where astc_ctacble=cuenta and astc_fecval< fechad and astc_estado=2 and codcomp(astc_comprob)!='AR' ;
        else
	    if int4eq(ptovta,0) then
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_ctacble=cuenta 
			    and astc_estado=2 and astc_comprob not in (6,7,147,157) and astc_fecval< fechad;
    		else
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_idptov=ptovta  
			    and astc_ctacble=cuenta and astc_estado=2 and astc_comprob not in (6,7,147,157) 
			    and astc_fecval< fechad ;
	    end if;
    end if;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldocbl(integer, integer, integer, date) OWNER TO artl;

--
-- Name: salgrup(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION salgrup(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	tipcta		ALIAS FOR $2;
	ctacte		ALIAS FOR $3;
	grupo		ALIAS FOR $4;
	esisti		integer;
	retval 		numeric;
    BEGIN
    if int4eq(grupo,0) then
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo is null;
	else
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo=grupo;
    end if;

    if not found then
	retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.salgrup(integer, integer, integer, integer) OWNER TO artl;

--
-- Name: simbmoneda(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION simbmoneda(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_simbol from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.simbmoneda(smallint) OWNER TO artl;

--
-- Name: stasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION stasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_stasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.stasaconiva(smallint) OWNER TO artl;

--
-- Name: stivacli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION stivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select stasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.stivacli(integer) OWNER TO artl;

--
-- Name: stockafecha(integer, date); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION stockafecha(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	artVenta	ALIAS FOR $1;
	fechah		ALIAS FOR $2;
	retval 		numeric;
	artCompra	integer;
	cantReceta	integer;
	cantIni		numeric;
	cantRem		numeric;
	fecIni 		date;
	fecRem		date;
	ok		integer;
	cantComp	numeric;
	cantVend	numeric;
	reg		record;
	regis		record;
    BEGIN

	retval:=0;
	cantIni:=0;
	cantComp:=0;
	cantVend:=0;

	select count(*) into cantReceta from receta where re_articv=artVenta;
	if (int4gt(cantReceta,1)) then
	    RAISE EXCEPTION 'Esta funcion es para relaciones 1 a 1';
	end if;

	select re_articc into artCompra from receta where re_articv=artVenta limit 1;

	select stk_cantidad,stk_fecval into cantIni,fecIni from stockinicial where stk_artic=artCompra order by stk_fecval desc limit 1;

	if (cantIni is not null) then
	    RAISE NOTICE 'STOCK INICIAL %, FECHA %',cantIni,fecIni;
	    select sum(movc_canti) into cantComp from movstoc where date_gt(movc_fecval,fecIni) and date_le(movc_fecval,fechah) and movc_estado=2 and movc_artic=artCompra;
	    if cantComp is null then
		cantComp:=0;
	    end if;
	    RAISE NOTICE 'COMPRADOS %',cantComp;

	    for reg in select * from movsto where date_gt(movs_fecval,fecini) and date_le(movs_fecval,fechah) and movs_estado=2 and movs_artic=artVenta and codcomp(comprobemi(movs_idemiti)) not in ('COT','NP') order by movs_id loop
		ok:=1;
		for regis in select * from relrem where rr_idastohp=reg.movs_idastoh loop
		    select ash_fecval into fecRem from astoh where ash_id=regis.rr_idastohh;
		    select movs_canti into cantRem from movsto where movs_idastoh=regis.rr_idastohh and movs_artic=artVenta;
		    if(date_le(fecIni,fecRem))then
			ok:=2;
			if(cantRem is not null) then
			    cantVend:=cantVend+cantRem;
			    RAISE NOTICE 'Vendidos A %, Idastoh F/R: %/%',cantRem,reg.movs_idastoh,regis.rr_idastohh;
			end if;
		    else
			ok:=2;
		    end if;
		end loop;
		if(int4eq(ok,1)) then
		    cantVend:=cantVend+reg.movs_canti;
		    RAISE NOTICE 'Vendidos B %, Idastoh: %',reg.movs_canti,reg.movs_idastoh;
		end if;
	    end loop;
	    retval:=cantIni+cantComp-cantVend;
	else
	    select sum(movc_canti) into cantComp from movstoc where movc_estado=2 and movc_artic=artCompra and date_le(movc_fecval,fechah);
	    if cantComp is null then
		cantComp:=0;
	    end if;
	    select sum(movs_canti) into cantVend from movsto where movs_estado=2 and movs_artic=artVenta and codcomp(comprobemi(movs_idemiti)) not in ('COT','NP') and date_le(movs_fecval,fechah);
	    if cantVend is null then
		cantVend:=0;
	    end if;
	    RAISE NOTICE '// COMPRADOS %, VENDIDOS %',cantComp,cantVend;
	    retval:=cantComp-cantVend;
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.stockafecha(integer, date) OWNER TO artl;

--
-- Name: stockhistorico(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION stockhistorico(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	artVenta	ALIAS FOR $1;
	retval 		numeric;
	artCompra	integer;
	cantReceta	integer;
	cantIni		numeric;
	cantRem		numeric;
	fecIni 		date;
	fecRem		date;
	ok		integer;
	cantComp	numeric;
	cantVend	numeric;
	reg		record;
	regis		record;
    BEGIN

	retval:=0;
	cantIni:=0;
	cantComp:=0;
	cantVend:=0;

	select count(*) into cantReceta from receta where re_articv=artVenta;
	if (int4gt(cantReceta,1)) then
	    RAISE EXCEPTION 'Esta funcion es para relaciones 1 a 1';
	end if;

	select re_articc into artCompra from receta where re_articv=artVenta limit 1;

	select stk_cantidad,stk_fecval into cantIni,fecIni from stockinicial where stk_artic=artCompra order by stk_fecval desc limit 1;

	if (cantIni is not null) then
	    RAISE NOTICE 'STOCK INICIAL %, FECHA %',cantIni,fecIni;
	    select sum(movc_canti) into cantComp from movstoc where date_gt(movc_fecval,fecIni) and movc_estado=2 and movc_artic=artCompra;
	    if cantComp is null then
		cantComp:=0;
	    end if;
	    RAISE NOTICE 'COMPRADOS %',cantComp;

	    for reg in select * from movsto where date_gt(movs_fecval,fecini) and movs_estado=2 and movs_artic=artVenta and codcomp(comprobemi(movs_idemiti)) not in ('COT','NP') order by movs_id loop
		ok:=1;
		for regis in select * from relrem where rr_idastohp=reg.movs_idastoh loop
		    select ash_fecval into fecRem from astoh where ash_id=regis.rr_idastohh;
		    select movs_canti into cantRem from movsto where movs_idastoh=regis.rr_idastohh and movs_artic=artVenta;
		    if(date_le(fecIni,fecRem))then
			ok:=2;
			if(cantRem is not null) then
			    cantVend:=cantVend+cantRem;
			    RAISE NOTICE 'Vendidos A %, Idastoh F/R: %/%',cantRem,reg.movs_idastoh,regis.rr_idastohh;
			end if;
		    else
			ok:=2;
		    end if;
		end loop;
		if(int4eq(ok,1)) then
		    cantVend:=cantVend+reg.movs_canti;
		    RAISE NOTICE 'Vendidos B %, Idastoh: %',reg.movs_canti,reg.movs_idastoh;
		end if;
	    end loop;
	    retval:=cantIni+cantComp-cantVend;
	else
	    select sum(movc_canti) into cantComp from movstoc where movc_estado=2 and movc_artic=artCompra;
	    if cantComp is null then
		cantComp:=0;
	    end if;
	    select sum(movs_canti) into cantVend from movsto where movs_estado=2 and movs_artic=artVenta and codcomp(comprobemi(movs_idemiti)) not in ('COT','NP');
	    if cantVend is null then
		cantVend:=0;
	    end if;
	    RAISE NOTICE '// COMPRADOS %, VENDIDOS %',cantComp,cantVend;
	    retval:=cantComp-cantVend;
	end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.stockhistorico(integer) OWNER TO artl;

--
-- Name: subtotf(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION subtotf(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(movs_importe) from movsto where movs_idastoh= $1 ;$_$;


ALTER FUNCTION public.subtotf(integer) OWNER TO artl;

--
-- Name: sucuemi(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION sucuemi(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_succli from emiti where emi_id = $1 ;$_$;


ALTER FUNCTION public.sucuemi(integer) OWNER TO artl;

--
-- Name: sumchq(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION sumchq(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
astc	 alias for $1;
modo	 alias for $2;
ret	 numeric;
begin

ret:=0;

if(int4eq(modo,1)) then
    select sum(chq_importe) into ret from cheques where chq_idastoc= astc;
else
    select sum(chq_importe) into ret from cheques where chq_idastoce= astc;
end if;

return ret;
end;$_$;


ALTER FUNCTION public.sumchq(integer, integer) OWNER TO artl;

--
-- Name: taldecomp(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION taldecomp(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select tal_id from talon where tal_codemp = $1 and tal_comprob= $2;$_$;


ALTER FUNCTION public.taldecomp(integer, integer) OWNER TO artl;

--
-- Name: tasaartic(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tasaartic(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select art_tasa from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.tasaartic(integer) OWNER TO artl;

--
-- Name: tasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_tasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.tasaconiva(smallint) OWNER TO artl;

--
-- Name: tasaiva_fe(numeric); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tasaiva_fe(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	imp		ALIAS FOR $1;
	inte		integer;
	retval		text;
    BEGIN
	if (numeric_eq(imp,0)) then
	    inte:=3;
	else
	    if (numeric_eq(imp,10.5)) then
		inte:=4;
	    else
		if (numeric_eq(imp,21)) then
		    inte:=5;
		else
		    if (numeric_eq(imp,27)) then
			inte:=6;
		    else
			if (numeric_eq(imp,5)) then
			    inte:=8;
			else
			    if (numeric_eq(imp,2.5)) then
				inte:=9;
			    end if;
			end if;
		    end if;
		end if;
	    end if;
	end if;
	select lpad(inte::text,4,'0') into retval;
	RETURN retval;
    END;$_$;


ALTER FUNCTION public.tasaiva_fe(numeric) OWNER TO artl;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO artl;

--
-- Name: tipprove(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tipprove(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_tipo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.tipprove(integer) OWNER TO artl;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO artl;

--
-- Name: tivacli(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select tasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.tivacli(integer) OWNER TO artl;

--
-- Name: totdescto(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totdescto(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTADESCTO')::integer);$_$;


ALTER FUNCTION public.totdescto(integer) OWNER TO artl;

--
-- Name: totdesctoa(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totdesctoa(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,1,'CTADESCTO')::integer);$_$;


ALTER FUNCTION public.totdesctoa(integer) OWNER TO artl;

--
-- Name: totimpastc(integer, integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totimpastc(integer, integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select astc_importe from astoctas where astc_ctacble= $1 and astc_idastoh= $2 ;$_$;


ALTER FUNCTION public.totimpastc(integer, integer) OWNER TO artl;

--
-- Name: totiva21(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totiva21(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTAIVA')::integer);$_$;


ALTER FUNCTION public.totiva21(integer) OWNER TO artl;

--
-- Name: totiva21a(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totiva21a(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,1,'CTAIVA')::integer);$_$;


ALTER FUNCTION public.totiva21a(integer) OWNER TO artl;

--
-- Name: totivast(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totivast(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'CTAIVAST')::integer);$_$;


ALTER FUNCTION public.totivast(integer) OWNER TO artl;

--
-- Name: totivasta(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION totivasta(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,1,'CTAIVAST')::integer);$_$;


ALTER FUNCTION public.totivasta(integer) OWNER TO artl;

--
-- Name: tposastc(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION tposastc(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_importe>0 ;$_$;


ALTER FUNCTION public.tposastc(integer) OWNER TO artl;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO artl;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: artl
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	codigo		ALIAS FOR $3; 
	otro 		varchar;
	retval 		varchar;
    BEGIN

    select vari_valor into otro from
	 varambi where int4eq(codemp,vari_codemp) and bpchareq('PTOVEMP',vari_codigo);


    select vari_valor into retval from
	 varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);

    if not found then
	select vari_valor into retval from
	    varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from
		varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	    if not found then
		select vari_valor into retval from
		    varambi where int4eq(otro::integer,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	    end if;
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO artl;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: agrupa; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE agrupa (
    ag_id integer NOT NULL,
    ag_idpago integer NOT NULL,
    ag_idastoh integer,
    ag_importe numeric(15,2),
    ag_imppago numeric(15,2) DEFAULT 0,
    ag_estado integer DEFAULT 1 NOT NULL,
    ag_leyenda text,
    ag_grupo integer,
    ag_retenido numeric(15,2) DEFAULT 0
);


ALTER TABLE agrupa OWNER TO artl;

--
-- Name: agrupa_ag_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE agrupa_ag_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE agrupa_ag_id_seq OWNER TO artl;

--
-- Name: agrupa_ag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE agrupa_ag_id_seq OWNED BY agrupa.ag_id;


--
-- Name: articu; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE articu (
    artc_id integer NOT NULL,
    artc_codemp integer NOT NULL,
    artc_idptov integer,
    artc_codigo character varying(160),
    artc_tasa numeric(20,5) DEFAULT 21,
    artc_stock numeric(20,5) DEFAULT 0,
    artc_nivrep numeric(20,5) DEFAULT 0,
    artc_unimed smallint,
    artc_present character varying(50) DEFAULT 0,
    artc_peso numeric(20,5) DEFAULT 0,
    artc_estado smallint DEFAULT 1,
    artc_codrub smallint,
    artc_codsrb integer,
    artc_automatoper character varying(100),
    artc_nombre character varying(260),
    artc_leyen text,
    artc_tipo smallint DEFAULT 1,
    artc_codcbl integer,
    artc_funcion text,
    artc_precio numeric(20,5) DEFAULT 0,
    artc_idcbl integer,
    artc_moneda integer DEFAULT 1
);


ALTER TABLE articu OWNER TO artl;

--
-- Name: articu_artc_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE articu_artc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articu_artc_id_seq OWNER TO artl;

--
-- Name: articu_artc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE articu_artc_id_seq OWNED BY articu.artc_id;


--
-- Name: articvta; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codemp integer NOT NULL,
    art_idptov integer,
    art_codigo character varying(160),
    art_tasa numeric(20,5) DEFAULT 0.21,
    art_stock numeric(20,5) DEFAULT 0,
    art_nivrep numeric(20,5) DEFAULT 0,
    art_unimed smallint,
    art_present character varying(50) DEFAULT 0,
    art_peso numeric(20,5) DEFAULT 0,
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_precio_unique numeric(20,5) DEFAULT 0,
    art_nombre character varying(160),
    art_leyen text,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codsrb integer,
    art_codcbl integer,
    art_funcion text,
    art_precio numeric(20,5) DEFAULT 0,
    art_idcbl integer,
    art_moneda integer DEFAULT 1
);


ALTER TABLE articvta OWNER TO artl;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articvta_art_id_seq OWNER TO artl;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer,
    astc_iddiv integer,
    astc_idcco integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(20,2) DEFAULT 0,
    astc_cotiza numeric(20,5) DEFAULT 0,
    astc_importe numeric(20,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(20,5),
    astc_leyen character varying(160),
    astc_idashce integer,
    astc_succli integer DEFAULT 1
);


ALTER TABLE astoctas OWNER TO artl;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoctas_astc_id_seq OWNER TO artl;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer,
    ash_anio smallint NOT NULL,
    ash_mes smallint NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer NOT NULL,
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_nro2 integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date,
    ash_titulo character varying(200)
);


ALTER TABLE astoh OWNER TO artl;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoh_ash_id_seq OWNER TO artl;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


--
-- Name: auxfe; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE auxfe (
    fe_id integer NOT NULL,
    fe_idcli integer NOT NULL,
    fe_cuit character varying(11) NOT NULL,
    fe_cbte smallint DEFAULT 1 NOT NULL,
    fe_ptovta smallint DEFAULT 1 NOT NULL,
    fe_nograv numeric(15,2),
    fe_grav numeric(15,2),
    fe_ivatot numeric(15,2),
    fe_total numeric(15,2),
    fe_tributo numeric(15,2),
    fe_ivaex numeric(15,2),
    fe_iva21 numeric(15,2),
    fe_iva105 numeric(15,2),
    fe_fechaf character varying(8),
    fe_iniserv character varying(8),
    fe_finserv character varying(8),
    fe_fechavp character varying(8),
    fe_cae character varying(14),
    fe_fechavtocae character varying(8),
    fe_numero integer,
    fe_estado integer DEFAULT 1 NOT NULL,
    fe_errores text,
    fe_codemp integer DEFAULT 1 NOT NULL,
    fe_observ text
);


ALTER TABLE auxfe OWNER TO zona;

--
-- Name: auxfe_fe_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE auxfe_fe_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxfe_fe_id_seq OWNER TO zona;

--
-- Name: auxfe_fe_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE auxfe_fe_id_seq OWNED BY auxfe.fe_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(160) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE bancos OWNER TO artl;

SET default_with_oids = false;

--
-- Name: cblexasi; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE cblexasi (
    cxa_codemp integer NOT NULL,
    cxa_tipasi integer NOT NULL,
    cxa_cble integer NOT NULL
);


ALTER TABLE cblexasi OWNER TO artl;

--
-- Name: chat; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE chat (
    c_id integer NOT NULL,
    c_codemp integer NOT NULL,
    c_message text NOT NULL,
    c_sent timestamp without time zone DEFAULT now() NOT NULL,
    c_recd integer DEFAULT 0 NOT NULL,
    c_from integer,
    c_to integer
);


ALTER TABLE chat OWNER TO zona;

--
-- Name: chat_c_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE chat_c_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chat_c_id_seq OWNER TO zona;

--
-- Name: chat_c_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE chat_c_id_seq OWNED BY chat.c_id;


SET default_with_oids = true;

--
-- Name: cheques; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(20,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text
);


ALTER TABLE cheques OWNER TO artl;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cheques_chq_id_seq OWNER TO artl;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


--
-- Name: clientes; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE clientes (
    cli_id integer NOT NULL,
    cli_codemp integer NOT NULL,
    cli_idptov integer,
    cli_codigo character varying(40) NOT NULL,
    cli_nrcuit character varying(20) NOT NULL,
    cli_tipcli smallint,
    cli_nombre character varying(160),
    cli_fantasy character varying(160),
    cli_nomabre character varying(40),
    cli_coniva smallint NOT NULL,
    cli_descto numeric(20,5) DEFAULT 0,
    cli_conpag integer,
    cli_catego integer,
    cli_limcred numeric(20,2) DEFAULT 0,
    cli_interes numeric(20,5) DEFAULT 0,
    cli_grupo integer,
    cli_saldo numeric(20,2),
    cli_estado smallint DEFAULT 1 NOT NULL,
    cli_modfac smallint DEFAULT 1,
    cli_listpre integer DEFAULT 1,
    cli_comentarios text
);


ALTER TABLE clientes OWNER TO artl;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE clientes_cli_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE clientes_cli_id_seq OWNER TO artl;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE clientes_cli_id_seq OWNED BY clientes.cli_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(160),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(20,2) DEFAULT 0,
    cpra_stock integer DEFAULT 0,
    cpra_cotiza numeric DEFAULT 1
);


ALTER TABLE compra OWNER TO artl;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compra_cpra_id_seq OWNER TO artl;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codemp integer NOT NULL,
    comp_idptov integer,
    comp_codigo character(10) NOT NULL,
    comp_nombre character varying(160) NOT NULL,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text
);


ALTER TABLE comprob OWNER TO artl;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprob_comp_id_seq OWNER TO artl;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: concilia; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE concilia (
    clia_id integer NOT NULL,
    clia_cte integer NOT NULL,
    clia_fecha timestamp without time zone DEFAULT now() NOT NULL,
    clia_idastcg integer,
    clia_salant numeric(20,5) DEFAULT 0,
    clia_salcon numeric(20,5) DEFAULT 0,
    clia_grav numeric(20,5) DEFAULT 0,
    clia_iva numeric(20,5) DEFAULT 0,
    clia_ngrab numeric(20,5) DEFAULT 0,
    clia_piibb numeric(20,5) DEFAULT 0,
    clia_sircreb numeric(20,5) DEFAULT 0,
    clia_leyd numeric(20,5) DEFAULT 0,
    clia_leyc numeric(20,5) DEFAULT 0,
    clia_operad integer NOT NULL,
    clia_estado integer DEFAULT 1
);


ALTER TABLE concilia OWNER TO artl;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE concilia_clia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE concilia_clia_id_seq OWNER TO artl;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE concilia_clia_id_seq OWNED BY concilia.clia_id;


--
-- Name: coniva; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(160) NOT NULL,
    iva_tasa numeric(20,5) DEFAULT 0,
    iva_stasa numeric(20,5) DEFAULT 0,
    iva_discrim smallint DEFAULT 1,
    iva_estado integer DEFAULT 1
);


ALTER TABLE coniva OWNER TO artl;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_codemp integer NOT NULL,
    cdp_nombre character varying(160) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE conpag OWNER TO artl;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE conpag_cdp_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conpag_cdp_codigo_seq OWNER TO artl;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE conpag_cdp_codigo_seq OWNED BY conpag.cdp_codigo;


SET default_with_oids = false;

--
-- Name: cont; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cont (
    "?column?" integer
);


ALTER TABLE cont OWNER TO zona;

SET default_with_oids = true;

--
-- Name: contratos; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE contratos (
    ctr_id integer NOT NULL,
    ctr_codemp integer NOT NULL,
    ctr_idptov integer NOT NULL,
    ctr_idcli integer NOT NULL,
    ctr_fecha date DEFAULT date(now()) NOT NULL,
    ctr_idastoh integer,
    ctr_comprob integer,
    ctr_numero integer,
    ctr_fecvto date,
    ctr_estado integer DEFAULT 1 NOT NULL,
    ctr_leyenda text
);


ALTER TABLE contratos OWNER TO artl;

--
-- Name: contratos_ctr_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE contratos_ctr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contratos_ctr_id_seq OWNER TO artl;

--
-- Name: contratos_ctr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE contratos_ctr_id_seq OWNED BY contratos.ctr_id;


--
-- Name: contrb; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE contrb (
    ctrb_id integer NOT NULL,
    ctrb_idcontr integer NOT NULL,
    ctrb_idcli integer NOT NULL,
    ctrb_idartic integer,
    ctrb_iddispen integer NOT NULL,
    ctrb_fecha date DEFAULT date(now()) NOT NULL,
    ctrb_idastoh integer,
    ctrb_comprob integer,
    ctrb_numero integer,
    ctrb_fecvto date,
    ctrb_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE contrb OWNER TO artl;

--
-- Name: contrb_ctrb_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE contrb_ctrb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contrb_ctrb_id_seq OWNER TO artl;

--
-- Name: contrb_ctrb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE contrb_ctrb_id_seq OWNED BY contrb.ctrb_id;


--
-- Name: conxclia; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE conxclia (
    cxlia_id integer NOT NULL,
    cxlia_idclia integer NOT NULL,
    cxlia_idastc integer NOT NULL,
    cxlia_importe numeric(20,5) DEFAULT 0,
    cxlia_estado integer DEFAULT 1
);


ALTER TABLE conxclia OWNER TO artl;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE conxcxlia_cxlia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conxcxlia_cxlia_id_seq OWNER TO artl;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE conxcxlia_cxlia_id_seq OWNED BY conxclia.cxlia_id;


--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer,
    cbl_codigo character varying(60) NOT NULL,
    cbl_nombre character varying(160) NOT NULL,
    cbl_identi integer,
    cbl_nivel integer,
    cbl_posic integer,
    cbl_asigna integer DEFAULT 1,
    cbl_moneda smallint DEFAULT 1 NOT NULL,
    cbl_tipcta integer,
    cbl_monetaria smallint DEFAULT 1,
    cbl_ajuste smallint DEFAULT 1,
    cbl_indice smallint DEFAULT 1,
    cbl_ctarei integer,
    cbl_ctaaju integer,
    cbl_leyed character varying(160),
    cbl_leyeh character varying(160),
    cbl_present character varying(60)
);


ALTER TABLE ctacble OWNER TO artl;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctacble_cbl_id_seq OWNER TO artl;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer NOT NULL,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(160),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1,
    cte_idptov integer DEFAULT (-1)
);


ALTER TABLE ctes OWNER TO artl;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctes_cte_id_seq OWNER TO artl;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


--
-- Name: dispenser; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE dispenser (
    dis_id integer NOT NULL,
    dis_idprov integer,
    dis_codemp integer NOT NULL,
    dis_idptov integer NOT NULL,
    dis_idartic integer,
    dis_idcontr integer,
    dis_idcontrb integer DEFAULT (-1),
    dis_fecha date DEFAULT date(now()) NOT NULL,
    dis_idastoh integer,
    dis_comprob integer,
    dis_numero integer,
    dis_fecvto date,
    dis_estado integer DEFAULT 1 NOT NULL,
    dis_leyen text
);


ALTER TABLE dispenser OWNER TO artl;

--
-- Name: dispenser_dis_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE dispenser_dis_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE dispenser_dis_id_seq OWNER TO artl;

--
-- Name: dispenser_dis_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE dispenser_dis_id_seq OWNED BY dispenser.dis_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer NOT NULL,
    doc_idptov integer,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(20,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE docum OWNER TO artl;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE docum_doc_id_seq OWNER TO artl;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


--
-- Name: emiti; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcli integer,
    emi_succli integer,
    emi_nomcli character varying(160),
    emi_conivac smallint,
    emi_nrcuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_elm integer,
    emi_desre numeric(20,2) DEFAULT 0,
    emi_total numeric(20,2) DEFAULT 0,
    emi_retiro integer DEFAULT 1,
    emi_estado smallint DEFAULT 1,
    emi_leyen text,
    emi_idfe integer,
    emi_cae character varying(14),
    emi_facturado integer DEFAULT 1,
    emi_idoper integer,
    emi_stock integer DEFAULT 1,
    emi_ordencompra character varying(40),
    emi_cotiza numeric(15,5) DEFAULT 1 NOT NULL
);


ALTER TABLE emiti OWNER TO artl;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE emiti_emi_id_seq OWNER TO artl;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(160),
    emp_direcc character varying(160),
    emp_locali character varying(160),
    emp_codpos character varying(10),
    emp_provin integer DEFAULT 1,
    emp_pais smallint DEFAULT 200,
    emp_nrcuit character varying(20) NOT NULL,
    emp_estado smallint DEFAULT 1,
    emp_codact character varying(60),
    emp_descact character varying(160),
    emp_respons character varying(160),
    emp_respcargo character varying(160),
    emp_nroanses character varying(60),
    emp_nroigj character varying(60),
    emp_fecigj date,
    emp_vtocont date DEFAULT '2028-12-31'::date,
    emp_tipo smallint DEFAULT 1,
    emp_coniva smallint DEFAULT 1,
    emp_anti date DEFAULT date(now()),
    emp_fecint date,
    emp_grupo integer DEFAULT 1,
    emp_redond smallint DEFAULT 0,
    emp_nomabr character varying(10),
    emp_codcli integer DEFAULT 1,
    emp_codprov integer DEFAULT 1
);


ALTER TABLE empresa OWNER TO artl;

SET default_with_oids = false;

--
-- Name: estcivil; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE estcivil (
    ec_codigo smallint NOT NULL,
    ec_nombre character varying(160) NOT NULL
);


ALTER TABLE estcivil OWNER TO artl;

SET default_with_oids = true;

--
-- Name: firman; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_codemp integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(160) NOT NULL,
    fir_direcc character varying(160),
    fir_locali character varying(160),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE firman OWNER TO artl;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE firman_fir_id_seq OWNER TO artl;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(160) NOT NULL
);


ALTER TABLE grupos OWNER TO artl;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE grupos_gpo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupos_gpo_id_seq OWNER TO artl;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE grupos_gpo_id_seq OWNED BY grupos.gpo_id;


--
-- Name: hojaruta; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE hojaruta (
    hr_id integer NOT NULL,
    hr_fecha date DEFAULT now(),
    hr_chofer character varying(80),
    hr_camion integer,
    hr_controla character varying(80),
    hr_operador integer,
    hr_estado integer DEFAULT 1,
    hr_fecreg timestamp without time zone DEFAULT now()
);


ALTER TABLE hojaruta OWNER TO artl;

--
-- Name: hojaruta_hr_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE hojaruta_hr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE hojaruta_hr_id_seq OWNER TO artl;

--
-- Name: hojaruta_hr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE hojaruta_hr_id_seq OWNED BY hojaruta.hr_id;


SET default_with_oids = false;

--
-- Name: iibbfile; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE iibbfile (
    if_id integer NOT NULL,
    if_mes integer NOT NULL,
    if_anio integer NOT NULL,
    if_url text NOT NULL,
    if_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE iibbfile OWNER TO artl;

--
-- Name: iibbfile_if_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE iibbfile_if_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE iibbfile_if_id_seq OWNER TO artl;

--
-- Name: iibbfile_if_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE iibbfile_if_id_seq OWNED BY iibbfile.if_id;


SET default_with_oids = true;

--
-- Name: indices; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE indices (
    ind_codigo smallint NOT NULL,
    ind_nombre character varying(160) NOT NULL
);


ALTER TABLE indices OWNER TO artl;

--
-- Name: interes; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer NOT NULL,
    int_fecha date DEFAULT date(now()) NOT NULL,
    int_valor numeric(20,5) DEFAULT 0
);


ALTER TABLE interes OWNER TO artl;

--
-- Name: listas; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE listas (
    li_codigo integer NOT NULL,
    li_codemp integer DEFAULT 0 NOT NULL,
    li_nombre character varying(140) NOT NULL
);


ALTER TABLE listas OWNER TO artl;

--
-- Name: listas_li_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE listas_li_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE listas_li_codigo_seq OWNER TO artl;

--
-- Name: listas_li_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE listas_li_codigo_seq OWNED BY listas.li_codigo;


SET default_with_oids = false;

--
-- Name: listpre; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE listpre (
    ltp_id integer NOT NULL,
    ltp_codemp integer NOT NULL,
    ltp_idptov integer,
    ltp_idcli integer,
    ltp_nrolista integer,
    ltp_idart integer NOT NULL,
    ltp_orden integer,
    ltp_precio numeric(20,5) DEFAULT 0,
    ltp_fecmod date DEFAULT date(now()),
    ltp_estado integer DEFAULT 1 NOT NULL,
    ltp_moneda integer DEFAULT 1
);


ALTER TABLE listpre OWNER TO artl;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE listpre_ltp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE listpre_ltp_id_seq OWNER TO artl;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE listpre_ltp_id_seq OWNED BY listpre.ltp_id;


SET default_with_oids = true;

--
-- Name: logs; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE logs (
    lg_id integer NOT NULL,
    lg_codemp integer NOT NULL,
    lg_idptov integer NOT NULL,
    lg_tabla character varying(200) NOT NULL,
    lg_idregistro integer NOT NULL,
    lg_accion text,
    lg_operador integer,
    lg_motivo text
);


ALTER TABLE logs OWNER TO artl;

--
-- Name: logs_lg_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE logs_lg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs_lg_id_seq OWNER TO artl;

--
-- Name: logs_lg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE logs_lg_id_seq OWNED BY logs.lg_id;


SET default_with_oids = false;

--
-- Name: margenxarticu; Type: TABLE; Schema: public; Owner: estlm; Tablespace: 
--

CREATE TABLE margenxarticu (
    mxa_id integer NOT NULL,
    mxa_codemp integer NOT NULL,
    mxa_idptov integer NOT NULL,
    mxa_idart integer NOT NULL,
    mxa_lista integer,
    mxa_margen numeric(15,2),
    mxa_fecha date DEFAULT date(now()),
    mxa_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE margenxarticu OWNER TO estlm;

--
-- Name: margenxarticu_mxa_id_seq; Type: SEQUENCE; Schema: public; Owner: estlm
--

CREATE SEQUENCE margenxarticu_mxa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE margenxarticu_mxa_id_seq OWNER TO estlm;

--
-- Name: margenxarticu_mxa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: estlm
--

ALTER SEQUENCE margenxarticu_mxa_id_seq OWNED BY margenxarticu.mxa_id;


SET default_with_oids = true;

--
-- Name: modlogs; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE modlogs (
    log_id integer NOT NULL,
    log_idptov integer NOT NULL,
    log_comprob integer NOT NULL,
    log_numero integer NOT NULL,
    log_tabla character varying(60),
    log_idtabla integer DEFAULT 1 NOT NULL,
    log_campo character varying(60),
    log_valant text,
    log_valpos text,
    log_fecha timestamp without time zone DEFAULT now() NOT NULL,
    log_operador integer,
    log_cont integer DEFAULT 1,
    log_leyen text
);


ALTER TABLE modlogs OWNER TO zona;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE modlogs_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE modlogs_log_id_seq OWNER TO zona;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE modlogs_log_id_seq OWNED BY modlogs.log_id;


--
-- Name: moneda; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(160) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE moneda OWNER TO artl;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_codemp integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(30),
    mne_valor numeric(20,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE monex OWNER TO artl;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE monex_mne_id_seq OWNER TO artl;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsleyen; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE movsleyen (
    mvl_id integer NOT NULL,
    mvl_idmovs integer NOT NULL,
    mvl_leyen character varying(350) NOT NULL
);


ALTER TABLE movsleyen OWNER TO zona;

--
-- Name: movsleyen_mvl_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE movsleyen_mvl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsleyen_mvl_id_seq OWNER TO zona;

--
-- Name: movsleyen_mvl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE movsleyen_mvl_id_seq OWNED BY movsleyen.mvl_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer,
    movs_idastoh integer,
    movs_idemiti integer NOT NULL,
    movs_fecval date,
    movs_artic integer NOT NULL,
    movs_canti numeric(20,5) DEFAULT 0,
    movs_dias numeric(20,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(20,2) DEFAULT 0,
    movs_tasa numeric(20,5) DEFAULT 0,
    movs_peso numeric(20,2) DEFAULT 0,
    movs_volum numeric(20,2) DEFAULT 0,
    movs_entreg numeric(20,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado integer DEFAULT 1,
    movs_codcli integer,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer,
    movs_compbte character varying(40),
    movs_cantret numeric(20,5) DEFAULT 0
);


ALTER TABLE movsto OWNER TO artl;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsto_movs_id_seq OWNER TO artl;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: movstoc; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE movstoc (
    movc_id integer NOT NULL,
    movc_codemp integer NOT NULL,
    movc_idptov integer,
    movc_idastoh integer NOT NULL,
    movc_idcompra integer NOT NULL,
    movc_fecval date,
    movc_artic integer,
    movc_canti numeric(20,5) DEFAULT 0,
    movc_precio numeric(15,5) DEFAULT 0,
    movc_importe numeric(20,2) DEFAULT 0,
    movc_tasa numeric(20,5) DEFAULT 0,
    movc_peso numeric(20,2) DEFAULT 0,
    movc_volum numeric(20,2) DEFAULT 0,
    movc_entreg numeric(20,2) DEFAULT 0,
    movc_fecrep date,
    movc_estado integer DEFAULT 1,
    movc_codpro integer,
    movc_leyen text
);


ALTER TABLE movstoc OWNER TO artl;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE movstoc_movc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movstoc_movc_id_seq OWNER TO artl;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE movstoc_movc_id_seq OWNED BY movstoc.movc_id;


SET default_with_oids = false;

--
-- Name: nrolista; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE nrolista (
    cli_listpre integer
);


ALTER TABLE nrolista OWNER TO zona;

SET default_with_oids = true;

--
-- Name: operadores; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(160) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(160),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(190),
    operad_telefono character varying(190),
    operad_codemp integer,
    operad_ptovta integer
);


ALTER TABLE operadores OWNER TO artl;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operadores_operad_id_seq OWNER TO artl;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(160) NOT NULL
);


ALTER TABLE pais OWNER TO artl;

SET default_with_oids = false;

--
-- Name: periibb; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE periibb (
    pb_id integer NOT NULL,
    pb_fecdes date DEFAULT date(now()) NOT NULL,
    pb_fechas date DEFAULT date(now()) NOT NULL,
    pb_cuit character varying(15) NOT NULL,
    pb_situacion character varying(1),
    pb_alicuota numeric(15,5) NOT NULL,
    pb_grupo integer,
    pb_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE periibb OWNER TO artl;

--
-- Name: periibb_pb_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE periibb_pb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE periibb_pb_id_seq OWNER TO artl;

--
-- Name: periibb_pb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE periibb_pb_id_seq OWNED BY periibb.pb_id;


SET default_with_oids = true;

--
-- Name: prove; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_codemp integer,
    prov_idptov integer,
    prov_nrcuit character varying(20),
    prov_codigo character varying(40),
    prov_nombre character varying(160),
    prov_direcc character varying(160),
    prov_locali character varying(160),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(160),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE prove OWNER TO artl;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE prove_prov_id_seq OWNER TO artl;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(160) NOT NULL,
    pro_tasa numeric(20,5) DEFAULT 0,
    pro_coef numeric(20,5) DEFAULT 0,
    pro_valor numeric(20,2) DEFAULT 0
);


ALTER TABLE provin OWNER TO artl;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE provin_pro_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE provin_pro_codigo_seq OWNER TO artl;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE provin_pro_codigo_seq OWNED BY provin.pro_codigo;


--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_codemp integer,
    ptv_codigo integer NOT NULL,
    ptv_nombre character varying(160),
    ptv_direcc character varying(160),
    ptv_locali character varying(160),
    ptv_codpos character varying(10),
    ptv_provin integer,
    ptv_pais smallint,
    ptv_estado smallint DEFAULT 1,
    ptv_codact character varying(60),
    ptv_descact character varying(160),
    ptv_porcib numeric(15,5),
    ptv_tipiva integer DEFAULT 1
);


ALTER TABLE ptovta OWNER TO artl;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ptovta_ptv_id_seq OWNER TO artl;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


SET default_with_oids = false;

--
-- Name: pxarticu; Type: TABLE; Schema: public; Owner: estlm; Tablespace: 
--

CREATE TABLE pxarticu (
    pxa_id integer NOT NULL,
    pxa_codemp integer NOT NULL,
    pxa_idptov integer DEFAULT (-1) NOT NULL,
    pxa_idart integer NOT NULL,
    pxa_idprov integer,
    pxa_precio numeric(15,5),
    pxa_fecha date DEFAULT date(now()),
    pxa_estado integer DEFAULT 1 NOT NULL,
    pxa_moneda integer DEFAULT 1
);


ALTER TABLE pxarticu OWNER TO estlm;

--
-- Name: pxarticu_pxa_id_seq; Type: SEQUENCE; Schema: public; Owner: estlm
--

CREATE SEQUENCE pxarticu_pxa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE pxarticu_pxa_id_seq OWNER TO estlm;

--
-- Name: pxarticu_pxa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: estlm
--

ALTER SEQUENCE pxarticu_pxa_id_seq OWNED BY pxarticu.pxa_id;


SET default_with_oids = true;

--
-- Name: receta; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE receta (
    re_id integer NOT NULL,
    re_codemp integer NOT NULL,
    re_idptov integer DEFAULT 1,
    re_articv integer NOT NULL,
    re_articc integer NOT NULL,
    re_canti numeric(20,5) DEFAULT 1 NOT NULL,
    re_estado integer DEFAULT 1
);


ALTER TABLE receta OWNER TO artl;

--
-- Name: receta_re_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE receta_re_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE receta_re_id_seq OWNER TO artl;

--
-- Name: receta_re_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE receta_re_id_seq OWNED BY receta.re_id;


SET default_with_oids = false;

--
-- Name: relcotnot; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE relcotnot (
    rn_id integer NOT NULL,
    rn_idemitip integer NOT NULL,
    rn_idemitih integer NOT NULL,
    rn_operador integer,
    rn_estado integer DEFAULT 1
);


ALTER TABLE relcotnot OWNER TO artl;

--
-- Name: relcotnot_rn_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE relcotnot_rn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relcotnot_rn_id_seq OWNER TO artl;

--
-- Name: relcotnot_rn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE relcotnot_rn_id_seq OWNED BY relcotnot.rn_id;


--
-- Name: relnotp; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE relnotp (
    rn_id integer NOT NULL,
    rn_idemitip integer NOT NULL,
    rn_idemitih integer NOT NULL,
    rn_operador integer,
    rn_estado integer DEFAULT 1
);


ALTER TABLE relnotp OWNER TO artl;

--
-- Name: relnotp_rn_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE relnotp_rn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relnotp_rn_id_seq OWNER TO artl;

--
-- Name: relnotp_rn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE relnotp_rn_id_seq OWNED BY relnotp.rn_id;


--
-- Name: relrem; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE relrem (
    rr_id integer NOT NULL,
    rr_idastohp integer NOT NULL,
    rr_idastohh integer NOT NULL,
    rr_operador integer,
    rr_estado integer DEFAULT 1
);


ALTER TABLE relrem OWNER TO artl;

--
-- Name: relrem_rr_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE relrem_rr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relrem_rr_id_seq OWNER TO artl;

--
-- Name: relrem_rr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE relrem_rr_id_seq OWNED BY relrem.rr_id;


--
-- Name: relremc; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE relremc (
    rr_id integer NOT NULL,
    rr_idastohp integer NOT NULL,
    rr_idastohh integer NOT NULL,
    rr_operador integer,
    rr_estado integer DEFAULT 1
);


ALTER TABLE relremc OWNER TO artl;

--
-- Name: relremc_rr_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE relremc_rr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relremc_rr_id_seq OWNER TO artl;

--
-- Name: relremc_rr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE relremc_rr_id_seq OWNED BY relremc.rr_id;


--
-- Name: rtoxcontr; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE rtoxcontr (
    rtc_idcontr integer,
    rtc_idemiti integer,
    rtc_numrem integer
);


ALTER TABLE rtoxcontr OWNER TO artl;

--
-- Name: rubros; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_codemp integer DEFAULT 0 NOT NULL,
    rub_idptov integer DEFAULT (-1) NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(140) NOT NULL,
    rub_abrevi character varying(10)
);


ALTER TABLE rubros OWNER TO artl;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubros_rub_id_seq OWNER TO artl;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: rutaxastoh; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE rutaxastoh (
    ra_id integer NOT NULL,
    ra_idruta integer NOT NULL,
    ra_idastoh integer NOT NULL,
    ra_estado integer DEFAULT 1,
    ra_codcli integer,
    ra_mano integer DEFAULT 0
);


ALTER TABLE rutaxastoh OWNER TO artl;

--
-- Name: rutaxastoh_ra_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE rutaxastoh_ra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rutaxastoh_ra_id_seq OWNER TO artl;

--
-- Name: rutaxastoh_ra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE rutaxastoh_ra_id_seq OWNED BY rutaxastoh.ra_id;


SET default_with_oids = true;

--
-- Name: stock; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE stock (
    stc_id integer NOT NULL,
    stc_codemp integer NOT NULL,
    stc_idptov integer,
    stc_idart integer,
    stc_idartc integer,
    stc_idemiti integer,
    stc_idcompra integer,
    stc_idastoh integer,
    stc_idmovsto integer,
    stc_idmovstoc integer,
    stc_tipo integer DEFAULT 1,
    stc_fecval date,
    stc_canting numeric(20,5),
    stc_cantegr numeric(20,5),
    stc_precio numeric(20,5) DEFAULT 0,
    stc_estado integer DEFAULT 1
);


ALTER TABLE stock OWNER TO artl;

--
-- Name: stock_stc_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE stock_stc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE stock_stc_id_seq OWNER TO artl;

--
-- Name: stock_stc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE stock_stc_id_seq OWNED BY stock.stc_id;


--
-- Name: stockinicial; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE stockinicial (
    stk_id integer NOT NULL,
    stk_codemp integer NOT NULL,
    stk_idptov integer NOT NULL,
    stk_artic integer NOT NULL,
    stk_fecval date NOT NULL,
    stk_cantidad numeric(15,2) NOT NULL,
    stk_cantant numeric(15,2),
    stk_diferencia numeric(15,2),
    stk_estado integer DEFAULT 1
);


ALTER TABLE stockinicial OWNER TO zona;

--
-- Name: stockinicial_stk_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE stockinicial_stk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE stockinicial_stk_id_seq OWNER TO zona;

--
-- Name: stockinicial_stk_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE stockinicial_stk_id_seq OWNED BY stockinicial.stk_id;


SET default_with_oids = false;

--
-- Name: subd; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer NOT NULL,
    subd_idptov integer,
    subd_nombre character varying(160),
    subd_titulo character varying(160),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer,
    subd_orden integer,
    subd_dia integer
);


ALTER TABLE subd OWNER TO artl;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subd_subd_id_seq OWNER TO artl;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL,
    subxc_codemp integer
);


ALTER TABLE subxcomp OWNER TO artl;

SET default_with_oids = true;

--
-- Name: sucursalc; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE sucursalc (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(160) NOT NULL,
    sucu_direcc character varying(160),
    sucu_locali character varying(160),
    sucu_codpos character varying(15),
    sucu_provin integer DEFAULT 1,
    sucu_pais smallint,
    sucu_repres character varying(160),
    sucu_contacto character varying(160),
    sucu_observ text,
    sucu_direccl character varying(160),
    sucu_localil character varying(160),
    sucu_codposl character varying(15),
    sucu_codprovl integer,
    sucu_paisl smallint,
    sucu_mail character varying(160)
);


ALTER TABLE sucursalc OWNER TO artl;

--
-- Name: sucursalp; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE sucursalp (
    suc_prove integer NOT NULL,
    suc_codigo smallint DEFAULT 1 NOT NULL,
    suc_nombre character varying(160) NOT NULL,
    suc_direcc character varying(160),
    suc_locali character varying(160),
    suc_codpos character varying(15),
    suc_codprov integer,
    suc_pais smallint,
    suc_repres character varying(160),
    suc_contacto character varying(160),
    suc_observ text,
    suc_direccl character varying(160),
    suc_localil character varying(160),
    suc_codposl character varying(15),
    suc_codprovl integer,
    suc_paisl smallint
);


ALTER TABLE sucursalp OWNER TO artl;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_codemp integer NOT NULL,
    tal_idptov integer,
    tal_comprob integer,
    tal_nombre character varying(160) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date
);


ALTER TABLE talon OWNER TO artl;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE talon_tal_id_seq OWNER TO artl;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: telefon; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_codemp integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(160) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE telefon OWNER TO artl;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE telefon_tel_id_seq OWNER TO artl;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


SET default_with_oids = false;

--
-- Name: tipasi; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tipasi (
    tas_codemp integer NOT NULL,
    tas_codigo integer NOT NULL,
    tas_nombre character varying(160) NOT NULL
);


ALTER TABLE tipasi OWNER TO artl;

SET default_with_oids = true;

--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(160) NOT NULL
);


ALTER TABLE tipcta OWNER TO artl;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE tipcta_tct_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipcta_tct_codigo_seq OWNER TO artl;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE tipcta_tct_codigo_seq OWNED BY tipcta.tct_codigo;


--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(160) NOT NULL
);


ALTER TABLE tipdocu OWNER TO artl;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(160) NOT NULL
);


ALTER TABLE tipemp OWNER TO artl;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(30) NOT NULL
);


ALTER TABLE tipentid OWNER TO artl;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE tipentid_tet_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipentid_tet_codigo_seq OWNER TO artl;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE tipentid_tet_codigo_seq OWNED BY tipentid.tet_codigo;


--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(160) NOT NULL
);


ALTER TABLE tiptel OWNER TO artl;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE tiptel_ttl_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tiptel_ttl_codigo_seq OWNER TO artl;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE tiptel_ttl_codigo_seq OWNED BY tiptel.ttl_codigo;


SET default_with_oids = false;

--
-- Name: tributosfe; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE tributosfe (
    t_id integer NOT NULL,
    t_idfe integer NOT NULL,
    t_cod integer,
    t_desc character varying(200),
    t_alic numeric(15,2),
    t_imp numeric(15,2) DEFAULT 0,
    t_baseimp numeric(15,2)
);


ALTER TABLE tributosfe OWNER TO artl;

--
-- Name: tributosfe_t_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE tributosfe_t_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tributosfe_t_id_seq OWNER TO artl;

--
-- Name: tributosfe_t_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE tributosfe_t_id_seq OWNED BY tributosfe.t_id;


SET default_with_oids = true;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_coef numeric(20,5) DEFAULT 0,
    uni_nombre character varying(160),
    uni_simbolo character varying(160)
);


ALTER TABLE unimed OWNER TO artl;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(160) NOT NULL,
    vari_nombre character varying(160) NOT NULL,
    vari_valor character varying(160),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE varambi OWNER TO artl;

--
-- Name: vendedor; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE vendedor (
    ven_id integer NOT NULL,
    ven_codemp integer NOT NULL,
    ven_nombre character varying(160) NOT NULL,
    ven_direcc character varying(160),
    ven_locali character varying(160),
    ven_codpos character varying(10),
    ven_provin integer,
    ven_pais smallint,
    ven_nrcuit character varying(20),
    ven_estado smallint DEFAULT 1,
    ven_comis numeric(20,5) DEFAULT 0
);


ALTER TABLE vendedor OWNER TO artl;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE vendedor_ven_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE vendedor_ven_id_seq OWNER TO artl;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE vendedor_ven_id_seq OWNED BY vendedor.ven_id;


--
-- Name: zona; Type: TABLE; Schema: public; Owner: artl; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_codemp integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(160) NOT NULL
);


ALTER TABLE zona OWNER TO artl;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE; Schema: public; Owner: artl
--

CREATE SEQUENCE zona_zon_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE zona_zon_codigo_seq OWNER TO artl;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: artl
--

ALTER SEQUENCE zona_zon_codigo_seq OWNED BY zona.zon_codigo;


--
-- Name: ag_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY agrupa ALTER COLUMN ag_id SET DEFAULT nextval('agrupa_ag_id_seq'::regclass);


--
-- Name: artc_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY articu ALTER COLUMN artc_id SET DEFAULT nextval('articu_artc_id_seq'::regclass);


--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: fe_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxfe ALTER COLUMN fe_id SET DEFAULT nextval('auxfe_fe_id_seq'::regclass);


--
-- Name: c_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY chat ALTER COLUMN c_id SET DEFAULT nextval('chat_c_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: cli_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY clientes ALTER COLUMN cli_id SET DEFAULT nextval('clientes_cli_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: clia_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY concilia ALTER COLUMN clia_id SET DEFAULT nextval('concilia_clia_id_seq'::regclass);


--
-- Name: cdp_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY conpag ALTER COLUMN cdp_codigo SET DEFAULT nextval('conpag_cdp_codigo_seq'::regclass);


--
-- Name: ctr_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contratos ALTER COLUMN ctr_id SET DEFAULT nextval('contratos_ctr_id_seq'::regclass);


--
-- Name: ctrb_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contrb ALTER COLUMN ctrb_id SET DEFAULT nextval('contrb_ctrb_id_seq'::regclass);


--
-- Name: cxlia_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY conxclia ALTER COLUMN cxlia_id SET DEFAULT nextval('conxcxlia_cxlia_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: dis_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY dispenser ALTER COLUMN dis_id SET DEFAULT nextval('dispenser_dis_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: gpo_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY grupos ALTER COLUMN gpo_id SET DEFAULT nextval('grupos_gpo_id_seq'::regclass);


--
-- Name: hr_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY hojaruta ALTER COLUMN hr_id SET DEFAULT nextval('hojaruta_hr_id_seq'::regclass);


--
-- Name: if_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY iibbfile ALTER COLUMN if_id SET DEFAULT nextval('iibbfile_if_id_seq'::regclass);


--
-- Name: li_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY listas ALTER COLUMN li_codigo SET DEFAULT nextval('listas_li_codigo_seq'::regclass);


--
-- Name: ltp_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY listpre ALTER COLUMN ltp_id SET DEFAULT nextval('listpre_ltp_id_seq'::regclass);


--
-- Name: lg_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY logs ALTER COLUMN lg_id SET DEFAULT nextval('logs_lg_id_seq'::regclass);


--
-- Name: mxa_id; Type: DEFAULT; Schema: public; Owner: estlm
--

ALTER TABLE ONLY margenxarticu ALTER COLUMN mxa_id SET DEFAULT nextval('margenxarticu_mxa_id_seq'::regclass);


--
-- Name: log_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modlogs ALTER COLUMN log_id SET DEFAULT nextval('modlogs_log_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: mvl_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY movsleyen ALTER COLUMN mvl_id SET DEFAULT nextval('movsleyen_mvl_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: movc_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movstoc ALTER COLUMN movc_id SET DEFAULT nextval('movstoc_movc_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: pb_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY periibb ALTER COLUMN pb_id SET DEFAULT nextval('periibb_pb_id_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: pro_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY provin ALTER COLUMN pro_codigo SET DEFAULT nextval('provin_pro_codigo_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: pxa_id; Type: DEFAULT; Schema: public; Owner: estlm
--

ALTER TABLE ONLY pxarticu ALTER COLUMN pxa_id SET DEFAULT nextval('pxarticu_pxa_id_seq'::regclass);


--
-- Name: re_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY receta ALTER COLUMN re_id SET DEFAULT nextval('receta_re_id_seq'::regclass);


--
-- Name: rn_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relcotnot ALTER COLUMN rn_id SET DEFAULT nextval('relcotnot_rn_id_seq'::regclass);


--
-- Name: rn_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relnotp ALTER COLUMN rn_id SET DEFAULT nextval('relnotp_rn_id_seq'::regclass);


--
-- Name: rr_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relrem ALTER COLUMN rr_id SET DEFAULT nextval('relrem_rr_id_seq'::regclass);


--
-- Name: rr_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relremc ALTER COLUMN rr_id SET DEFAULT nextval('relremc_rr_id_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: ra_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY rutaxastoh ALTER COLUMN ra_id SET DEFAULT nextval('rutaxastoh_ra_id_seq'::regclass);


--
-- Name: stc_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock ALTER COLUMN stc_id SET DEFAULT nextval('stock_stc_id_seq'::regclass);


--
-- Name: stk_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY stockinicial ALTER COLUMN stk_id SET DEFAULT nextval('stockinicial_stk_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: tct_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY tipcta ALTER COLUMN tct_codigo SET DEFAULT nextval('tipcta_tct_codigo_seq'::regclass);


--
-- Name: tet_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY tipentid ALTER COLUMN tet_codigo SET DEFAULT nextval('tipentid_tet_codigo_seq'::regclass);


--
-- Name: ttl_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY tiptel ALTER COLUMN ttl_codigo SET DEFAULT nextval('tiptel_ttl_codigo_seq'::regclass);


--
-- Name: t_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY tributosfe ALTER COLUMN t_id SET DEFAULT nextval('tributosfe_t_id_seq'::regclass);


--
-- Name: ven_id; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY vendedor ALTER COLUMN ven_id SET DEFAULT nextval('vendedor_ven_id_seq'::regclass);


--
-- Name: zon_codigo; Type: DEFAULT; Schema: public; Owner: artl
--

ALTER TABLE ONLY zona ALTER COLUMN zon_codigo SET DEFAULT nextval('zona_zon_codigo_seq'::regclass);


--
-- Name: agrupa_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY agrupa
    ADD CONSTRAINT agrupa_pkey PRIMARY KEY (ag_id);


--
-- Name: articu_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT articu_pkey PRIMARY KEY (artc_id);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: artl_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT artl_pkey PRIMARY KEY (zon_codigo);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: auxfe_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY auxfe
    ADD CONSTRAINT auxfe_pkey PRIMARY KEY (fe_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: cblexasi_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY cblexasi
    ADD CONSTRAINT cblexasi_pkey PRIMARY KEY (cxa_codemp, cxa_tipasi, cxa_cble);


--
-- Name: chat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY chat
    ADD CONSTRAINT chat_pkey PRIMARY KEY (c_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT clientes_pkey PRIMARY KEY (cli_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: concilia_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT concilia_pkey PRIMARY KEY (clia_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (ctr_id);


--
-- Name: contrb_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY contrb
    ADD CONSTRAINT contrb_pkey PRIMARY KEY (ctrb_id);


--
-- Name: conxcxlia_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT conxcxlia_pkey PRIMARY KEY (cxlia_id);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: dispenser_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY dispenser
    ADD CONSTRAINT dispenser_pkey PRIMARY KEY (dis_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: estcivil_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY estcivil
    ADD CONSTRAINT estcivil_pkey PRIMARY KEY (ec_codigo);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: hojaruta_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY hojaruta
    ADD CONSTRAINT hojaruta_pkey PRIMARY KEY (hr_id);


--
-- Name: iibbfile_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY iibbfile
    ADD CONSTRAINT iibbfile_pkey PRIMARY KEY (if_id);


--
-- Name: indices_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY indices
    ADD CONSTRAINT indices_pkey PRIMARY KEY (ind_codigo);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_codemp, int_fecha);


--
-- Name: listas_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY listas
    ADD CONSTRAINT listas_pkey PRIMARY KEY (li_codigo);


--
-- Name: listpre_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT listpre_pkey PRIMARY KEY (ltp_id);


--
-- Name: margenxarticu_pkey; Type: CONSTRAINT; Schema: public; Owner: estlm; Tablespace: 
--

ALTER TABLE ONLY margenxarticu
    ADD CONSTRAINT margenxarticu_pkey PRIMARY KEY (mxa_id);


--
-- Name: modlogs_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY modlogs
    ADD CONSTRAINT modlogs_pkey PRIMARY KEY (log_id);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsleyen_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY movsleyen
    ADD CONSTRAINT movsleyen_pkey PRIMARY KEY (mvl_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: movstoc_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT movstoc_pkey PRIMARY KEY (movc_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: periibb_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY periibb
    ADD CONSTRAINT periibb_pkey PRIMARY KEY (pb_id);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: pxarticu_pkey; Type: CONSTRAINT; Schema: public; Owner: estlm; Tablespace: 
--

ALTER TABLE ONLY pxarticu
    ADD CONSTRAINT pxarticu_pkey PRIMARY KEY (pxa_id);


--
-- Name: receta_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY receta
    ADD CONSTRAINT receta_pkey PRIMARY KEY (re_id);


--
-- Name: relcotnot_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY relcotnot
    ADD CONSTRAINT relcotnot_pkey PRIMARY KEY (rn_id);


--
-- Name: relnotp_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY relnotp
    ADD CONSTRAINT relnotp_pkey PRIMARY KEY (rn_id);


--
-- Name: relrem_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY relrem
    ADD CONSTRAINT relrem_pkey PRIMARY KEY (rr_id);


--
-- Name: relremc_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY relremc
    ADD CONSTRAINT relremc_pkey PRIMARY KEY (rr_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: rutaxastoh_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY rutaxastoh
    ADD CONSTRAINT rutaxastoh_pkey PRIMARY KEY (ra_id);


--
-- Name: stock_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT stock_pkey PRIMARY KEY (stc_id);


--
-- Name: stockinicial_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY stockinicial
    ADD CONSTRAINT stockinicial_pkey PRIMARY KEY (stk_id);


--
-- Name: subxcomp_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY subxcomp
    ADD CONSTRAINT subxcomp_pkey PRIMARY KEY (subxc_idsub, subxc_comprob);


--
-- Name: sucursalc_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY sucursalc
    ADD CONSTRAINT sucursalc_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: sucursalp_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY sucursalp
    ADD CONSTRAINT sucursalp_pkey PRIMARY KEY (suc_prove, suc_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipasi_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tipasi
    ADD CONSTRAINT tipasi_pkey PRIMARY KEY (tas_codemp, tas_codigo);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tributosfe_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY tributosfe
    ADD CONSTRAINT tributosfe_pkey PRIMARY KEY (t_id);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: vendedor_pkey; Type: CONSTRAINT; Schema: public; Owner: artl; Tablespace: 
--

ALTER TABLE ONLY vendedor
    ADD CONSTRAINT vendedor_pkey PRIMARY KEY (ven_id);


--
-- Name: idx_articu_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_articu_1 ON articu USING btree (artc_codemp, artc_codigo);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_codemp, art_codigo);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoh_3 ON astoh USING btree (ash_codemp, ash_idptov, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoh_4 ON astoh USING btree (ash_idemiti);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_idcpra);


--
-- Name: idx_auxfe_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_auxfe_1 ON auxfe USING btree (fe_estado, fe_fechaf, fe_idcli);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_clientes_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_clientes_1 ON clientes USING btree (cli_codemp, cli_idptov, cli_codigo);


--
-- Name: idx_clientes_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_clientes_2 ON clientes USING btree (cli_codemp, cli_codigo);


--
-- Name: idx_clientes_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_clientes_3 ON clientes USING btree (cli_nrcuit);


--
-- Name: idx_clientes_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_clientes_4 ON clientes USING btree (cli_nombre);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_comprob_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_comprob_1 ON comprob USING btree (comp_codemp, comp_idptov, comp_codigo);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_codemp, comp_idptov, comp_siste, comp_codigo);


--
-- Name: idx_concilia_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_concilia_1 ON concilia USING btree (clia_cte, clia_fecha);


--
-- Name: idx_conpag_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_conpag_1 ON conpag USING btree (cdp_codemp, cdp_codigo);


--
-- Name: idx_contratos_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_contratos_1 ON contratos USING btree (ctr_idcli);


--
-- Name: idx_contrb_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_contrb_1 ON contrb USING btree (ctrb_idcontr);


--
-- Name: idx_contrb_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_contrb_2 ON contrb USING btree (ctrb_idcli);


--
-- Name: idx_contrb_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_contrb_3 ON contrb USING btree (ctrb_iddispen);


--
-- Name: idx_conxcxlia_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_conxcxlia_1 ON conxclia USING btree (cxlia_idclia);


--
-- Name: idx_conxcxlia_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_conxcxlia_2 ON conxclia USING btree (cxlia_idastc);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_codigo);


--
-- Name: idx_ctacble_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_ctacble_2 ON ctacble USING btree (cbl_codemp, cbl_posic);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_dispenser_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_dispenser_1 ON dispenser USING btree (dis_idcontr);


--
-- Name: idx_dispenser_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_dispenser_2 ON dispenser USING btree (dis_idprov);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_codemp, doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_codemp, doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_codemp, doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_codemp, fir_nrcuit);


--
-- Name: idx_firman_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_firman_2 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_listpre_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_listpre_2 ON listpre USING btree (ltp_codemp, ltp_idptov, ltp_estado, ltp_idcli, ltp_nrolista, ltp_idart, ltp_orden);


--
-- Name: idx_modlogs_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_1 ON modlogs USING btree (log_idptov, log_tabla);


--
-- Name: idx_modlogs_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_2 ON modlogs USING btree (log_comprob, log_numero);


--
-- Name: idx_modlogs_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_3 ON modlogs USING btree (log_tabla, log_idtabla);


--
-- Name: idx_monex_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_monex_1 ON monex USING btree (mne_idastoc);


--
-- Name: idx_monex_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_monex_2 ON monex USING btree (mne_idastoce);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_movsto_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movsto_6 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic, movs_fecval);


--
-- Name: idx_movstoc_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_1 ON movstoc USING btree (movc_idcompra);


--
-- Name: idx_movstoc_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_2 ON movstoc USING btree (movc_idastoh);


--
-- Name: idx_movstoc_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_3 ON movstoc USING btree (movc_artic);


--
-- Name: idx_movstoc_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_4 ON movstoc USING btree (movc_codemp, movc_idptov, movc_artic);


--
-- Name: idx_movstoc_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_5 ON movstoc USING btree (movc_idastoh, movc_artic);


--
-- Name: idx_movstoc_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_movstoc_6 ON movstoc USING btree (movc_codemp, movc_idptov, movc_artic, movc_fecval);


--
-- Name: idx_novemplre_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_novemplre_1 ON receta USING btree (re_codemp, re_idptov, re_articv);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_periibb_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_periibb_1 ON periibb USING btree (pb_cuit, pb_estado);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_prove_3 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_relcotnot_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relcotnot_1 ON relcotnot USING btree (rn_idemitip);


--
-- Name: idx_relcotnot_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relcotnot_2 ON relcotnot USING btree (rn_idemitip, rn_idemitih);


--
-- Name: idx_relcotnot_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relcotnot_3 ON relcotnot USING btree (rn_idemitih);


--
-- Name: idx_relcotnot_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relcotnot_4 ON relcotnot USING btree (rn_idemitip, rn_estado);


--
-- Name: idx_relnotp_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relnotp_1 ON relnotp USING btree (rn_idemitip);


--
-- Name: idx_relnotp_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relnotp_2 ON relnotp USING btree (rn_idemitip, rn_idemitih);


--
-- Name: idx_relnotp_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relnotp_3 ON relnotp USING btree (rn_idemitih);


--
-- Name: idx_relnotp_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relnotp_4 ON relnotp USING btree (rn_idemitip, rn_estado);


--
-- Name: idx_relrem_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relrem_1 ON relrem USING btree (rr_idastohp);


--
-- Name: idx_relrem_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relrem_2 ON relrem USING btree (rr_idastohp, rr_idastohh);


--
-- Name: idx_relrem_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relrem_3 ON relrem USING btree (rr_idastohh);


--
-- Name: idx_relrem_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_relrem_4 ON relrem USING btree (rr_idastohp, rr_estado);


--
-- Name: idx_rtoxcontr_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_rtoxcontr_1 ON rtoxcontr USING btree (rtc_idcontr);


--
-- Name: idx_rtoxcontr_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_rtoxcontr_2 ON rtoxcontr USING btree (rtc_idemiti);


--
-- Name: idx_rubros_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_rubros_1 ON rubros USING btree (rub_tipo, rub_codigo);


--
-- Name: idx_stock_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_1 ON stock USING btree (stc_codemp, stc_estado, stc_idart);


--
-- Name: idx_stock_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_2 ON stock USING btree (stc_codemp, stc_estado, stc_idartc);


--
-- Name: idx_stock_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_3 ON stock USING btree (stc_idcompra);


--
-- Name: idx_stock_4; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_4 ON stock USING btree (stc_idemiti);


--
-- Name: idx_stock_5; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_5 ON stock USING btree (stc_idastoh);


--
-- Name: idx_stock_6; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_6 ON stock USING btree (stc_idmovsto);


--
-- Name: idx_stock_7; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_7 ON stock USING btree (stc_idmovstoc);


--
-- Name: idx_stock_8; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_stock_8 ON stock USING btree (stc_codemp, stc_estado, stc_idart, stc_fecval);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_codemp, tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: artl; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: ai_articvta; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_articvta AFTER INSERT ON articvta FOR EACH ROW EXECUTE PROCEDURE f_ai_articvta();


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_astoctas AFTER INSERT ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_clientes; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_clientes AFTER INSERT ON clientes FOR EACH ROW EXECUTE PROCEDURE f_ai_clientes();


--
-- Name: ai_empresa; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_empresa AFTER INSERT ON empresa FOR EACH ROW EXECUTE PROCEDURE f_ai_empresa();


--
-- Name: ai_movsto; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_movsto AFTER INSERT ON movsto FOR EACH ROW EXECUTE PROCEDURE f_ai_movsto();


--
-- Name: ai_movstoc; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER ai_movstoc AFTER INSERT ON movstoc FOR EACH ROW EXECUTE PROCEDURE f_ai_movstoc();


--
-- Name: au_articvta; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_articvta AFTER UPDATE ON articvta FOR EACH ROW EXECUTE PROCEDURE f_au_articvta();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_astoctas AFTER UPDATE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_astoh AFTER UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_cheques; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_cheques AFTER UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_au_cheques();


--
-- Name: au_clientes; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_clientes AFTER UPDATE ON clientes FOR EACH ROW EXECUTE PROCEDURE f_au_clientes();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_compra AFTER UPDATE ON compra FOR EACH ROW EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_concilia; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_concilia AFTER UPDATE ON concilia FOR EACH ROW EXECUTE PROCEDURE f_au_concilia();


--
-- Name: au_contratos; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_contratos AFTER UPDATE ON contratos FOR EACH ROW EXECUTE PROCEDURE f_au_contratos();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_emiti AFTER UPDATE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_listpre; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_listpre AFTER UPDATE ON listpre FOR EACH ROW EXECUTE PROCEDURE f_au_listpre();


--
-- Name: au_movsto; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_movsto AFTER UPDATE ON movsto FOR EACH ROW EXECUTE PROCEDURE f_au_movsto();


--
-- Name: au_movstoc; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_movstoc AFTER UPDATE ON movstoc FOR EACH ROW EXECUTE PROCEDURE f_au_movstoc();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER au_prove AFTER UPDATE ON prove FOR EACH ROW EXECUTE PROCEDURE f_au_prove();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_astoctas BEFORE DELETE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_astoh BEFORE DELETE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_clientes; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_clientes BEFORE DELETE ON clientes FOR EACH ROW EXECUTE PROCEDURE f_bd_clientes();


--
-- Name: bd_compra; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_compra BEFORE DELETE ON compra FOR EACH ROW EXECUTE PROCEDURE f_bd_compra();


--
-- Name: bd_contratos; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_contratos BEFORE DELETE ON contratos FOR EACH ROW EXECUTE PROCEDURE f_bd_contratos();


--
-- Name: bd_contrb; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_contrb BEFORE DELETE ON contrb FOR EACH ROW EXECUTE PROCEDURE f_bd_contrb();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_emiti BEFORE DELETE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_empresa; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_empresa BEFORE DELETE ON empresa FOR EACH ROW EXECUTE PROCEDURE f_bd_empresa();


--
-- Name: bd_movsto; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_movsto BEFORE DELETE ON movsto FOR EACH ROW EXECUTE PROCEDURE f_bd_movsto();


--
-- Name: bd_movstoc; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bd_movstoc BEFORE DELETE ON movstoc FOR EACH ROW EXECUTE PROCEDURE f_bd_movstoc();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bu_astoh BEFORE UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: artl
--

CREATE TRIGGER bu_cheques BEFORE UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT "$1" FOREIGN KEY (ptv_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT "$1" FOREIGN KEY (comp_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT "$1" FOREIGN KEY (art_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT "$1" FOREIGN KEY (ash_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT "$1" FOREIGN KEY (astc_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT "$1" FOREIGN KEY (mne_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT "$1" FOREIGN KEY (fir_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT "$1" FOREIGN KEY (int_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT "$1" FOREIGN KEY (chq_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT "$1" FOREIGN KEY (cdp_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$1" FOREIGN KEY (cbl_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT "$1" FOREIGN KEY (cte_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT "$1" FOREIGN KEY (doc_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT "$1" FOREIGN KEY (cli_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT "$1" FOREIGN KEY (cpra_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT "$1" FOREIGN KEY (emi_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT "$1" FOREIGN KEY (prov_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY sucursalc
    ADD CONSTRAINT "$1" FOREIGN KEY (sucu_cliente) REFERENCES clientes(cli_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY sucursalp
    ADD CONSTRAINT "$1" FOREIGN KEY (suc_prove) REFERENCES prove(prov_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$1" FOREIGN KEY (tal_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$1" FOREIGN KEY (tel_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT "$1" FOREIGN KEY (vari_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY vendedor
    ADD CONSTRAINT "$1" FOREIGN KEY (ven_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT "$1" FOREIGN KEY (zon_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT "$1" FOREIGN KEY (subd_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY articu
    ADD CONSTRAINT "$1" FOREIGN KEY (artc_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY receta
    ADD CONSTRAINT "$1" FOREIGN KEY (re_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$1" FOREIGN KEY (movs_artic) REFERENCES articvta(art_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$1" FOREIGN KEY (movc_artic) REFERENCES articu(artc_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$1" FOREIGN KEY (stc_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT "$1" FOREIGN KEY (ltp_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relrem
    ADD CONSTRAINT "$1" FOREIGN KEY (rr_idastohp) REFERENCES astoh(ash_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relnotp
    ADD CONSTRAINT "$1" FOREIGN KEY (rn_idemitip) REFERENCES emiti(emi_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT "$1" FOREIGN KEY (clia_cte) REFERENCES ctes(cte_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$1" FOREIGN KEY (cxlia_idclia) REFERENCES concilia(clia_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY dispenser
    ADD CONSTRAINT "$1" FOREIGN KEY (dis_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$1" FOREIGN KEY (ctr_idcli) REFERENCES clientes(cli_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contrb
    ADD CONSTRAINT "$1" FOREIGN KEY (ctrb_idcli) REFERENCES clientes(cli_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY rtoxcontr
    ADD CONSTRAINT "$1" FOREIGN KEY (rtc_idcontr) REFERENCES contratos(ctr_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relremc
    ADD CONSTRAINT "$1" FOREIGN KEY (rr_idastohh) REFERENCES astoh(ash_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT "$2" FOREIGN KEY (comp_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT "$2" FOREIGN KEY (ash_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT "$2" FOREIGN KEY (astc_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT "$2" FOREIGN KEY (mne_idastoc) REFERENCES astoctas(astc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT "$2" FOREIGN KEY (chq_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT "$2" FOREIGN KEY (cbl_moneda) REFERENCES moneda(mon_codigo);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT "$2" FOREIGN KEY (cte_tipcta) REFERENCES tipcta(tct_codigo);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT "$2" FOREIGN KEY (doc_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT "$2" FOREIGN KEY (cpra_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT "$2" FOREIGN KEY (emi_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$2" FOREIGN KEY (tal_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$2" FOREIGN KEY (tel_tipent) REFERENCES tipentid(tet_codigo);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cblexasi
    ADD CONSTRAINT "$2" FOREIGN KEY (cxa_cble) REFERENCES ctacble(cbl_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT "$2" FOREIGN KEY (subd_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY subxcomp
    ADD CONSTRAINT "$2" FOREIGN KEY (subxc_comprob) REFERENCES comprob(comp_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY receta
    ADD CONSTRAINT "$2" FOREIGN KEY (re_articv) REFERENCES articvta(art_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$2" FOREIGN KEY (movs_idemiti) REFERENCES emiti(emi_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$2" FOREIGN KEY (movc_idcompra) REFERENCES compra(cpra_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$2" FOREIGN KEY (stc_idart) REFERENCES articvta(art_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT "$2" FOREIGN KEY (ltp_idart) REFERENCES articvta(art_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relrem
    ADD CONSTRAINT "$2" FOREIGN KEY (rr_idastohh) REFERENCES astoh(ash_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relnotp
    ADD CONSTRAINT "$2" FOREIGN KEY (rn_idemitih) REFERENCES emiti(emi_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$2" FOREIGN KEY (cxlia_idastc) REFERENCES astoctas(astc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY dispenser
    ADD CONSTRAINT "$2" FOREIGN KEY (dis_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$2" FOREIGN KEY (ctr_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contrb
    ADD CONSTRAINT "$2" FOREIGN KEY (ctrb_idcontr) REFERENCES contratos(ctr_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY rtoxcontr
    ADD CONSTRAINT "$2" FOREIGN KEY (rtc_idemiti) REFERENCES emiti(emi_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY relremc
    ADD CONSTRAINT "$2" FOREIGN KEY (rr_idastohp) REFERENCES astoh(ash_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT "$3" FOREIGN KEY (ash_comprob) REFERENCES comprob(comp_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT "$3" FOREIGN KEY (astc_comprob) REFERENCES comprob(comp_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT "$3" FOREIGN KEY (mne_moneda) REFERENCES moneda(mon_codigo);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT "$3" FOREIGN KEY (chq_idastoc) REFERENCES astoctas(astc_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT "$3" FOREIGN KEY (doc_idastoc) REFERENCES astoctas(astc_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT "$3" FOREIGN KEY (cpra_comprob) REFERENCES comprob(comp_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT "$3" FOREIGN KEY (emi_comprob) REFERENCES comprob(comp_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT "$3" FOREIGN KEY (tel_tiptel) REFERENCES tiptel(ttl_codigo);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY receta
    ADD CONSTRAINT "$3" FOREIGN KEY (re_articc) REFERENCES articu(artc_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$3" FOREIGN KEY (movc_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$3" FOREIGN KEY (stc_idartc) REFERENCES articu(artc_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT "$3" FOREIGN KEY (ctr_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT "$4" FOREIGN KEY (astc_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT "$4" FOREIGN KEY (chq_moneda) REFERENCES moneda(mon_codigo);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT "$4" FOREIGN KEY (cpra_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$4" FOREIGN KEY (stc_idemiti) REFERENCES emiti(emi_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT "$5" FOREIGN KEY (astc_moneda) REFERENCES moneda(mon_codigo);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$5" FOREIGN KEY (stc_idcompra) REFERENCES compra(cpra_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$6" FOREIGN KEY (stc_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$7" FOREIGN KEY (stc_idmovsto) REFERENCES movsto(movs_id);


--
-- Name: $8; Type: FK CONSTRAINT; Schema: public; Owner: artl
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT "$8" FOREIGN KEY (stc_idmovstoc) REFERENCES movstoc(movc_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;
GRANT ALL ON SCHEMA public TO nord;


--
-- Name: agrupa; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE agrupa FROM PUBLIC;
REVOKE ALL ON TABLE agrupa FROM artl;
GRANT ALL ON TABLE agrupa TO artl;
GRANT ALL ON TABLE agrupa TO nobody;
GRANT SELECT ON TABLE agrupa TO nord;


--
-- Name: agrupa_ag_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE agrupa_ag_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE agrupa_ag_id_seq FROM artl;
GRANT ALL ON SEQUENCE agrupa_ag_id_seq TO artl;
GRANT UPDATE ON SEQUENCE agrupa_ag_id_seq TO nobody;
GRANT SELECT ON SEQUENCE agrupa_ag_id_seq TO nord;


--
-- Name: articu; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE articu FROM PUBLIC;
REVOKE ALL ON TABLE articu FROM artl;
GRANT ALL ON TABLE articu TO artl;
GRANT ALL ON TABLE articu TO nobody;
GRANT SELECT ON TABLE articu TO nord;


--
-- Name: articu_artc_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE articu_artc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articu_artc_id_seq FROM artl;
GRANT ALL ON SEQUENCE articu_artc_id_seq TO artl;
GRANT UPDATE ON SEQUENCE articu_artc_id_seq TO nobody;
GRANT SELECT ON SEQUENCE articu_artc_id_seq TO nord;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM artl;
GRANT ALL ON TABLE articvta TO artl;
GRANT ALL ON TABLE articvta TO nobody;
GRANT SELECT ON TABLE articvta TO nord;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM artl;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO artl;
GRANT UPDATE ON SEQUENCE articvta_art_id_seq TO nobody;
GRANT SELECT ON SEQUENCE articvta_art_id_seq TO nord;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM artl;
GRANT ALL ON TABLE astoctas TO artl;
GRANT ALL ON TABLE astoctas TO nobody;
GRANT SELECT ON TABLE astoctas TO nord;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM artl;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO artl;
GRANT UPDATE ON SEQUENCE astoctas_astc_id_seq TO nobody;
GRANT SELECT ON SEQUENCE astoctas_astc_id_seq TO nord;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM artl;
GRANT ALL ON TABLE astoh TO artl;
GRANT ALL ON TABLE astoh TO nobody;
GRANT SELECT ON TABLE astoh TO nord;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM artl;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO artl;
GRANT UPDATE ON SEQUENCE astoh_ash_id_seq TO nobody;
GRANT SELECT ON SEQUENCE astoh_ash_id_seq TO nord;


--
-- Name: auxfe; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxfe FROM PUBLIC;
REVOKE ALL ON TABLE auxfe FROM zona;
GRANT ALL ON TABLE auxfe TO zona;
GRANT ALL ON TABLE auxfe TO nobody;
GRANT SELECT ON TABLE auxfe TO nord;


--
-- Name: auxfe_fe_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE auxfe_fe_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxfe_fe_id_seq FROM zona;
GRANT ALL ON SEQUENCE auxfe_fe_id_seq TO zona;
GRANT UPDATE ON SEQUENCE auxfe_fe_id_seq TO nobody;
GRANT SELECT ON SEQUENCE auxfe_fe_id_seq TO nord;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM artl;
GRANT ALL ON TABLE bancos TO artl;
GRANT ALL ON TABLE bancos TO nobody;
GRANT SELECT ON TABLE bancos TO nord;


--
-- Name: cblexasi; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE cblexasi FROM PUBLIC;
REVOKE ALL ON TABLE cblexasi FROM artl;
GRANT ALL ON TABLE cblexasi TO artl;
GRANT ALL ON TABLE cblexasi TO nobody;
GRANT SELECT ON TABLE cblexasi TO nord;


--
-- Name: chat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE chat FROM PUBLIC;
REVOKE ALL ON TABLE chat FROM zona;
GRANT ALL ON TABLE chat TO zona;
GRANT ALL ON TABLE chat TO nobody;
GRANT SELECT ON TABLE chat TO nord;


--
-- Name: chat_c_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE chat_c_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chat_c_id_seq FROM zona;
GRANT ALL ON SEQUENCE chat_c_id_seq TO zona;
GRANT UPDATE ON SEQUENCE chat_c_id_seq TO nobody;
GRANT SELECT ON SEQUENCE chat_c_id_seq TO nord;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM artl;
GRANT ALL ON TABLE cheques TO artl;
GRANT ALL ON TABLE cheques TO nobody;
GRANT SELECT ON TABLE cheques TO nord;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM artl;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO artl;
GRANT UPDATE ON SEQUENCE cheques_chq_id_seq TO nobody;
GRANT SELECT ON SEQUENCE cheques_chq_id_seq TO nord;


--
-- Name: clientes; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE clientes FROM PUBLIC;
REVOKE ALL ON TABLE clientes FROM artl;
GRANT ALL ON TABLE clientes TO artl;
GRANT ALL ON TABLE clientes TO nobody;
GRANT SELECT ON TABLE clientes TO nord;


--
-- Name: clientes_cli_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM artl;
GRANT ALL ON SEQUENCE clientes_cli_id_seq TO artl;
GRANT UPDATE ON SEQUENCE clientes_cli_id_seq TO nobody;
GRANT SELECT ON SEQUENCE clientes_cli_id_seq TO nord;


--
-- Name: compra; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM artl;
GRANT ALL ON TABLE compra TO artl;
GRANT ALL ON TABLE compra TO nobody;
GRANT SELECT ON TABLE compra TO nord;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM artl;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO artl;
GRANT UPDATE ON SEQUENCE compra_cpra_id_seq TO nobody;
GRANT SELECT ON SEQUENCE compra_cpra_id_seq TO nord;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM artl;
GRANT ALL ON TABLE comprob TO artl;
GRANT ALL ON TABLE comprob TO nobody;
GRANT SELECT ON TABLE comprob TO nord;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM artl;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO artl;
GRANT UPDATE ON SEQUENCE comprob_comp_id_seq TO nobody;
GRANT SELECT ON SEQUENCE comprob_comp_id_seq TO nord;


--
-- Name: concilia; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE concilia FROM PUBLIC;
REVOKE ALL ON TABLE concilia FROM artl;
GRANT ALL ON TABLE concilia TO artl;
GRANT ALL ON TABLE concilia TO nobody;
GRANT SELECT ON TABLE concilia TO nord;


--
-- Name: concilia_clia_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM artl;
GRANT ALL ON SEQUENCE concilia_clia_id_seq TO artl;
GRANT UPDATE ON SEQUENCE concilia_clia_id_seq TO nobody;
GRANT SELECT ON SEQUENCE concilia_clia_id_seq TO nord;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM artl;
GRANT ALL ON TABLE coniva TO artl;
GRANT ALL ON TABLE coniva TO nobody;
GRANT SELECT ON TABLE coniva TO nord;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM artl;
GRANT ALL ON TABLE conpag TO artl;
GRANT ALL ON TABLE conpag TO nobody;
GRANT SELECT ON TABLE conpag TO nord;


--
-- Name: conpag_cdp_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE conpag_cdp_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE conpag_cdp_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE conpag_cdp_codigo_seq TO nord;


--
-- Name: cont; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cont FROM PUBLIC;
REVOKE ALL ON TABLE cont FROM zona;
GRANT ALL ON TABLE cont TO zona;
GRANT SELECT ON TABLE cont TO nord;


--
-- Name: contratos; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
REVOKE ALL ON TABLE contratos FROM artl;
GRANT ALL ON TABLE contratos TO artl;
GRANT ALL ON TABLE contratos TO nobody;
GRANT SELECT ON TABLE contratos TO nord;


--
-- Name: contratos_ctr_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE contratos_ctr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contratos_ctr_id_seq FROM artl;
GRANT ALL ON SEQUENCE contratos_ctr_id_seq TO artl;
GRANT UPDATE ON SEQUENCE contratos_ctr_id_seq TO nobody;
GRANT SELECT ON SEQUENCE contratos_ctr_id_seq TO nord;


--
-- Name: contrb; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE contrb FROM PUBLIC;
REVOKE ALL ON TABLE contrb FROM artl;
GRANT ALL ON TABLE contrb TO artl;
GRANT ALL ON TABLE contrb TO nobody;
GRANT SELECT ON TABLE contrb TO nord;


--
-- Name: contrb_ctrb_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE contrb_ctrb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contrb_ctrb_id_seq FROM artl;
GRANT ALL ON SEQUENCE contrb_ctrb_id_seq TO artl;
GRANT UPDATE ON SEQUENCE contrb_ctrb_id_seq TO nobody;
GRANT SELECT ON SEQUENCE contrb_ctrb_id_seq TO nord;


--
-- Name: conxclia; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE conxclia FROM PUBLIC;
REVOKE ALL ON TABLE conxclia FROM artl;
GRANT ALL ON TABLE conxclia TO artl;
GRANT ALL ON TABLE conxclia TO nobody;
GRANT SELECT ON TABLE conxclia TO nord;


--
-- Name: conxcxlia_cxlia_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM artl;
GRANT ALL ON SEQUENCE conxcxlia_cxlia_id_seq TO artl;
GRANT UPDATE ON SEQUENCE conxcxlia_cxlia_id_seq TO nobody;
GRANT SELECT ON SEQUENCE conxcxlia_cxlia_id_seq TO nord;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM artl;
GRANT ALL ON TABLE ctacble TO artl;
GRANT ALL ON TABLE ctacble TO nobody;
GRANT SELECT ON TABLE ctacble TO nord;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM artl;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO artl;
GRANT UPDATE ON SEQUENCE ctacble_cbl_id_seq TO nobody;
GRANT SELECT ON SEQUENCE ctacble_cbl_id_seq TO nord;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM artl;
GRANT ALL ON TABLE ctes TO artl;
GRANT ALL ON TABLE ctes TO nobody;
GRANT SELECT ON TABLE ctes TO nord;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM artl;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO artl;
GRANT UPDATE ON SEQUENCE ctes_cte_id_seq TO nobody;
GRANT SELECT ON SEQUENCE ctes_cte_id_seq TO nord;


--
-- Name: dispenser; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE dispenser FROM PUBLIC;
REVOKE ALL ON TABLE dispenser FROM artl;
GRANT ALL ON TABLE dispenser TO artl;
GRANT ALL ON TABLE dispenser TO nobody;
GRANT SELECT ON TABLE dispenser TO nord;


--
-- Name: dispenser_dis_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE dispenser_dis_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE dispenser_dis_id_seq FROM artl;
GRANT ALL ON SEQUENCE dispenser_dis_id_seq TO artl;
GRANT UPDATE ON SEQUENCE dispenser_dis_id_seq TO nobody;
GRANT SELECT ON SEQUENCE dispenser_dis_id_seq TO nord;


--
-- Name: docum; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM artl;
GRANT ALL ON TABLE docum TO artl;
GRANT ALL ON TABLE docum TO nobody;
GRANT SELECT ON TABLE docum TO nord;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM artl;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO artl;
GRANT UPDATE ON SEQUENCE docum_doc_id_seq TO nobody;
GRANT SELECT ON SEQUENCE docum_doc_id_seq TO nord;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM artl;
GRANT ALL ON TABLE emiti TO artl;
GRANT ALL ON TABLE emiti TO nobody;
GRANT SELECT ON TABLE emiti TO nord;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM artl;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO artl;
GRANT UPDATE ON SEQUENCE emiti_emi_id_seq TO nobody;
GRANT SELECT ON SEQUENCE emiti_emi_id_seq TO nord;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM artl;
GRANT ALL ON TABLE empresa TO artl;
GRANT ALL ON TABLE empresa TO nobody;
GRANT SELECT ON TABLE empresa TO nord;


--
-- Name: estcivil; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE estcivil FROM PUBLIC;
REVOKE ALL ON TABLE estcivil FROM artl;
GRANT ALL ON TABLE estcivil TO artl;
GRANT ALL ON TABLE estcivil TO nobody;
GRANT SELECT ON TABLE estcivil TO nord;


--
-- Name: firman; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM artl;
GRANT ALL ON TABLE firman TO artl;
GRANT ALL ON TABLE firman TO nobody;
GRANT SELECT ON TABLE firman TO nord;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM artl;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO artl;
GRANT UPDATE ON SEQUENCE firman_fir_id_seq TO nobody;
GRANT SELECT ON SEQUENCE firman_fir_id_seq TO nord;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM artl;
GRANT ALL ON TABLE grupos TO artl;
GRANT ALL ON TABLE grupos TO nobody;
GRANT SELECT ON TABLE grupos TO nord;


--
-- Name: grupos_gpo_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM artl;
GRANT ALL ON SEQUENCE grupos_gpo_id_seq TO artl;
GRANT UPDATE ON SEQUENCE grupos_gpo_id_seq TO nobody;
GRANT SELECT ON SEQUENCE grupos_gpo_id_seq TO nord;


--
-- Name: hojaruta; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE hojaruta FROM PUBLIC;
REVOKE ALL ON TABLE hojaruta FROM artl;
GRANT ALL ON TABLE hojaruta TO artl;
GRANT ALL ON TABLE hojaruta TO nobody;
GRANT SELECT ON TABLE hojaruta TO nord;


--
-- Name: hojaruta_hr_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE hojaruta_hr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE hojaruta_hr_id_seq FROM artl;
GRANT ALL ON SEQUENCE hojaruta_hr_id_seq TO artl;
GRANT UPDATE ON SEQUENCE hojaruta_hr_id_seq TO nobody;
GRANT SELECT ON SEQUENCE hojaruta_hr_id_seq TO nord;


--
-- Name: iibbfile; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE iibbfile FROM PUBLIC;
REVOKE ALL ON TABLE iibbfile FROM artl;
GRANT ALL ON TABLE iibbfile TO artl;
GRANT ALL ON TABLE iibbfile TO nobody;
GRANT SELECT ON TABLE iibbfile TO nord;


--
-- Name: iibbfile_if_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE iibbfile_if_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE iibbfile_if_id_seq FROM artl;
GRANT ALL ON SEQUENCE iibbfile_if_id_seq TO artl;
GRANT UPDATE ON SEQUENCE iibbfile_if_id_seq TO nobody;
GRANT SELECT ON SEQUENCE iibbfile_if_id_seq TO nord;


--
-- Name: indices; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE indices FROM PUBLIC;
REVOKE ALL ON TABLE indices FROM artl;
GRANT ALL ON TABLE indices TO artl;
GRANT ALL ON TABLE indices TO nobody;
GRANT SELECT ON TABLE indices TO nord;


--
-- Name: interes; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM artl;
GRANT ALL ON TABLE interes TO artl;
GRANT ALL ON TABLE interes TO nobody;
GRANT SELECT ON TABLE interes TO nord;


--
-- Name: listas; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE listas FROM PUBLIC;
REVOKE ALL ON TABLE listas FROM artl;
GRANT ALL ON TABLE listas TO artl;
GRANT ALL ON TABLE listas TO nobody;
GRANT SELECT ON TABLE listas TO nord;


--
-- Name: listas_li_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE listas_li_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE listas_li_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE listas_li_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE listas_li_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE listas_li_codigo_seq TO nord;


--
-- Name: listpre; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE listpre FROM PUBLIC;
REVOKE ALL ON TABLE listpre FROM artl;
GRANT ALL ON TABLE listpre TO artl;
GRANT ALL ON TABLE listpre TO nobody;
GRANT SELECT ON TABLE listpre TO nord;


--
-- Name: listpre_ltp_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM artl;
GRANT ALL ON SEQUENCE listpre_ltp_id_seq TO artl;
GRANT UPDATE ON SEQUENCE listpre_ltp_id_seq TO nobody;
GRANT SELECT ON SEQUENCE listpre_ltp_id_seq TO nord;


--
-- Name: logs; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE logs FROM PUBLIC;
REVOKE ALL ON TABLE logs FROM artl;
GRANT ALL ON TABLE logs TO artl;
GRANT ALL ON TABLE logs TO nobody;
GRANT SELECT ON TABLE logs TO nord;


--
-- Name: logs_lg_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE logs_lg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE logs_lg_id_seq FROM artl;
GRANT ALL ON SEQUENCE logs_lg_id_seq TO artl;
GRANT UPDATE ON SEQUENCE logs_lg_id_seq TO nobody;
GRANT SELECT ON SEQUENCE logs_lg_id_seq TO nord;


--
-- Name: margenxarticu; Type: ACL; Schema: public; Owner: estlm
--

REVOKE ALL ON TABLE margenxarticu FROM PUBLIC;
REVOKE ALL ON TABLE margenxarticu FROM estlm;
GRANT ALL ON TABLE margenxarticu TO estlm;
GRANT ALL ON TABLE margenxarticu TO nobody;
GRANT SELECT ON TABLE margenxarticu TO nord;


--
-- Name: margenxarticu_mxa_id_seq; Type: ACL; Schema: public; Owner: estlm
--

REVOKE ALL ON SEQUENCE margenxarticu_mxa_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE margenxarticu_mxa_id_seq FROM estlm;
GRANT ALL ON SEQUENCE margenxarticu_mxa_id_seq TO estlm;
GRANT UPDATE ON SEQUENCE margenxarticu_mxa_id_seq TO nobody;
GRANT SELECT ON SEQUENCE margenxarticu_mxa_id_seq TO nord;


--
-- Name: modlogs; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE modlogs FROM PUBLIC;
REVOKE ALL ON TABLE modlogs FROM zona;
GRANT ALL ON TABLE modlogs TO zona;
GRANT ALL ON TABLE modlogs TO nobody;
GRANT SELECT ON TABLE modlogs TO nord;


--
-- Name: modlogs_log_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM zona;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO zona;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE modlogs_log_id_seq TO nobody;
GRANT SELECT ON SEQUENCE modlogs_log_id_seq TO nord;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM artl;
GRANT ALL ON TABLE moneda TO artl;
GRANT ALL ON TABLE moneda TO nobody;
GRANT SELECT ON TABLE moneda TO nord;


--
-- Name: monex; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM artl;
GRANT ALL ON TABLE monex TO artl;
GRANT ALL ON TABLE monex TO nobody;
GRANT SELECT ON TABLE monex TO nord;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM artl;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO artl;
GRANT UPDATE ON SEQUENCE monex_mne_id_seq TO nobody;
GRANT SELECT ON SEQUENCE monex_mne_id_seq TO nord;


--
-- Name: movsleyen; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE movsleyen FROM PUBLIC;
REVOKE ALL ON TABLE movsleyen FROM zona;
GRANT ALL ON TABLE movsleyen TO zona;
GRANT ALL ON TABLE movsleyen TO nobody;
GRANT SELECT ON TABLE movsleyen TO nord;


--
-- Name: movsleyen_mvl_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE movsleyen_mvl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsleyen_mvl_id_seq FROM zona;
GRANT ALL ON SEQUENCE movsleyen_mvl_id_seq TO zona;
GRANT UPDATE ON SEQUENCE movsleyen_mvl_id_seq TO nobody;
GRANT SELECT ON SEQUENCE movsleyen_mvl_id_seq TO nord;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM artl;
GRANT ALL ON TABLE movsto TO artl;
GRANT ALL ON TABLE movsto TO nobody;
GRANT SELECT ON TABLE movsto TO nord;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM artl;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO artl;
GRANT UPDATE ON SEQUENCE movsto_movs_id_seq TO nobody;
GRANT SELECT ON SEQUENCE movsto_movs_id_seq TO nord;


--
-- Name: movstoc; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE movstoc FROM PUBLIC;
REVOKE ALL ON TABLE movstoc FROM artl;
GRANT ALL ON TABLE movstoc TO artl;
GRANT ALL ON TABLE movstoc TO nobody;
GRANT SELECT ON TABLE movstoc TO nord;


--
-- Name: movstoc_movc_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM artl;
GRANT ALL ON SEQUENCE movstoc_movc_id_seq TO artl;
GRANT UPDATE ON SEQUENCE movstoc_movc_id_seq TO nobody;
GRANT SELECT ON SEQUENCE movstoc_movc_id_seq TO nord;


--
-- Name: nrolista; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE nrolista FROM PUBLIC;
REVOKE ALL ON TABLE nrolista FROM zona;
GRANT ALL ON TABLE nrolista TO zona;
GRANT SELECT ON TABLE nrolista TO nord;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM artl;
GRANT ALL ON TABLE operadores TO artl;
GRANT ALL ON TABLE operadores TO nobody;
GRANT SELECT ON TABLE operadores TO nord;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM artl;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO artl;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;
GRANT SELECT ON SEQUENCE operadores_operad_id_seq TO nord;


--
-- Name: pais; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM artl;
GRANT ALL ON TABLE pais TO artl;
GRANT ALL ON TABLE pais TO nobody;
GRANT SELECT ON TABLE pais TO nord;


--
-- Name: periibb; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE periibb FROM PUBLIC;
REVOKE ALL ON TABLE periibb FROM artl;
GRANT ALL ON TABLE periibb TO artl;
GRANT ALL ON TABLE periibb TO nobody;
GRANT SELECT ON TABLE periibb TO nord;


--
-- Name: periibb_pb_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE periibb_pb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE periibb_pb_id_seq FROM artl;
GRANT ALL ON SEQUENCE periibb_pb_id_seq TO artl;
GRANT UPDATE ON SEQUENCE periibb_pb_id_seq TO nobody;
GRANT SELECT ON SEQUENCE periibb_pb_id_seq TO nord;


--
-- Name: prove; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM artl;
GRANT ALL ON TABLE prove TO artl;
GRANT ALL ON TABLE prove TO nobody;
GRANT SELECT ON TABLE prove TO nord;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM artl;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO artl;
GRANT UPDATE ON SEQUENCE prove_prov_id_seq TO nobody;
GRANT SELECT ON SEQUENCE prove_prov_id_seq TO nord;


--
-- Name: provin; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM artl;
GRANT ALL ON TABLE provin TO artl;
GRANT ALL ON TABLE provin TO nobody;
GRANT SELECT ON TABLE provin TO nord;


--
-- Name: provin_pro_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE provin_pro_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE provin_pro_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE provin_pro_codigo_seq TO nord;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM artl;
GRANT ALL ON TABLE ptovta TO artl;
GRANT ALL ON TABLE ptovta TO nobody;
GRANT SELECT ON TABLE ptovta TO nord;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM artl;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO artl;
GRANT UPDATE ON SEQUENCE ptovta_ptv_id_seq TO nobody;
GRANT SELECT ON SEQUENCE ptovta_ptv_id_seq TO nord;


--
-- Name: pxarticu; Type: ACL; Schema: public; Owner: estlm
--

REVOKE ALL ON TABLE pxarticu FROM PUBLIC;
REVOKE ALL ON TABLE pxarticu FROM estlm;
GRANT ALL ON TABLE pxarticu TO estlm;
GRANT ALL ON TABLE pxarticu TO nobody;
GRANT SELECT ON TABLE pxarticu TO nord;


--
-- Name: pxarticu_pxa_id_seq; Type: ACL; Schema: public; Owner: estlm
--

REVOKE ALL ON SEQUENCE pxarticu_pxa_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE pxarticu_pxa_id_seq FROM estlm;
GRANT ALL ON SEQUENCE pxarticu_pxa_id_seq TO estlm;
GRANT UPDATE ON SEQUENCE pxarticu_pxa_id_seq TO nobody;
GRANT SELECT ON SEQUENCE pxarticu_pxa_id_seq TO nord;


--
-- Name: receta; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE receta FROM PUBLIC;
REVOKE ALL ON TABLE receta FROM artl;
GRANT ALL ON TABLE receta TO artl;
GRANT ALL ON TABLE receta TO nobody;
GRANT SELECT ON TABLE receta TO nord;


--
-- Name: receta_re_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE receta_re_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE receta_re_id_seq FROM artl;
GRANT ALL ON SEQUENCE receta_re_id_seq TO artl;
GRANT UPDATE ON SEQUENCE receta_re_id_seq TO nobody;
GRANT SELECT ON SEQUENCE receta_re_id_seq TO nord;


--
-- Name: relcotnot; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE relcotnot FROM PUBLIC;
REVOKE ALL ON TABLE relcotnot FROM artl;
GRANT ALL ON TABLE relcotnot TO artl;
GRANT ALL ON TABLE relcotnot TO nobody;
GRANT SELECT ON TABLE relcotnot TO nord;


--
-- Name: relcotnot_rn_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE relcotnot_rn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relcotnot_rn_id_seq FROM artl;
GRANT ALL ON SEQUENCE relcotnot_rn_id_seq TO artl;
GRANT UPDATE ON SEQUENCE relcotnot_rn_id_seq TO nobody;
GRANT SELECT ON SEQUENCE relcotnot_rn_id_seq TO nord;


--
-- Name: relnotp; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE relnotp FROM PUBLIC;
REVOKE ALL ON TABLE relnotp FROM artl;
GRANT ALL ON TABLE relnotp TO artl;
GRANT ALL ON TABLE relnotp TO nobody;
GRANT SELECT ON TABLE relnotp TO nord;


--
-- Name: relnotp_rn_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE relnotp_rn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relnotp_rn_id_seq FROM artl;
GRANT ALL ON SEQUENCE relnotp_rn_id_seq TO artl;
GRANT UPDATE ON SEQUENCE relnotp_rn_id_seq TO nobody;
GRANT SELECT ON SEQUENCE relnotp_rn_id_seq TO nord;


--
-- Name: relrem; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE relrem FROM PUBLIC;
REVOKE ALL ON TABLE relrem FROM artl;
GRANT ALL ON TABLE relrem TO artl;
GRANT ALL ON TABLE relrem TO nobody;
GRANT SELECT ON TABLE relrem TO nord;


--
-- Name: relrem_rr_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE relrem_rr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relrem_rr_id_seq FROM artl;
GRANT ALL ON SEQUENCE relrem_rr_id_seq TO artl;
GRANT UPDATE ON SEQUENCE relrem_rr_id_seq TO nobody;
GRANT SELECT ON SEQUENCE relrem_rr_id_seq TO nord;


--
-- Name: relremc; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE relremc FROM PUBLIC;
REVOKE ALL ON TABLE relremc FROM artl;
GRANT ALL ON TABLE relremc TO artl;
GRANT ALL ON TABLE relremc TO nobody;
GRANT SELECT ON TABLE relremc TO nord;


--
-- Name: relremc_rr_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE relremc_rr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relremc_rr_id_seq FROM artl;
GRANT ALL ON SEQUENCE relremc_rr_id_seq TO artl;
GRANT UPDATE ON SEQUENCE relremc_rr_id_seq TO nobody;
GRANT SELECT ON SEQUENCE relremc_rr_id_seq TO nord;


--
-- Name: rtoxcontr; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE rtoxcontr FROM PUBLIC;
REVOKE ALL ON TABLE rtoxcontr FROM artl;
GRANT ALL ON TABLE rtoxcontr TO artl;
GRANT ALL ON TABLE rtoxcontr TO nobody;
GRANT SELECT ON TABLE rtoxcontr TO nord;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM artl;
GRANT ALL ON TABLE rubros TO artl;
GRANT ALL ON TABLE rubros TO nobody;
GRANT SELECT ON TABLE rubros TO nord;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM artl;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO artl;
GRANT UPDATE ON SEQUENCE rubros_rub_id_seq TO nobody;
GRANT SELECT ON SEQUENCE rubros_rub_id_seq TO nord;


--
-- Name: rutaxastoh; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE rutaxastoh FROM PUBLIC;
REVOKE ALL ON TABLE rutaxastoh FROM artl;
GRANT ALL ON TABLE rutaxastoh TO artl;
GRANT ALL ON TABLE rutaxastoh TO nobody;
GRANT SELECT ON TABLE rutaxastoh TO nord;


--
-- Name: rutaxastoh_ra_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE rutaxastoh_ra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rutaxastoh_ra_id_seq FROM artl;
GRANT ALL ON SEQUENCE rutaxastoh_ra_id_seq TO artl;
GRANT UPDATE ON SEQUENCE rutaxastoh_ra_id_seq TO nobody;
GRANT SELECT ON SEQUENCE rutaxastoh_ra_id_seq TO nord;


--
-- Name: stock; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE stock FROM PUBLIC;
REVOKE ALL ON TABLE stock FROM artl;
GRANT ALL ON TABLE stock TO artl;
GRANT ALL ON TABLE stock TO nobody;
GRANT SELECT ON TABLE stock TO nord;


--
-- Name: stock_stc_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE stock_stc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE stock_stc_id_seq FROM artl;
GRANT ALL ON SEQUENCE stock_stc_id_seq TO artl;
GRANT UPDATE ON SEQUENCE stock_stc_id_seq TO nobody;
GRANT SELECT ON SEQUENCE stock_stc_id_seq TO nord;


--
-- Name: stockinicial; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE stockinicial FROM PUBLIC;
REVOKE ALL ON TABLE stockinicial FROM zona;
GRANT ALL ON TABLE stockinicial TO zona;
GRANT ALL ON TABLE stockinicial TO nobody;
GRANT SELECT ON TABLE stockinicial TO nord;


--
-- Name: stockinicial_stk_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE stockinicial_stk_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE stockinicial_stk_id_seq FROM zona;
GRANT ALL ON SEQUENCE stockinicial_stk_id_seq TO zona;
GRANT UPDATE ON SEQUENCE stockinicial_stk_id_seq TO nobody;
GRANT SELECT ON SEQUENCE stockinicial_stk_id_seq TO nord;


--
-- Name: subd; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM artl;
GRANT ALL ON TABLE subd TO artl;
GRANT ALL ON TABLE subd TO nobody;
GRANT SELECT ON TABLE subd TO nord;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM artl;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO artl;
GRANT UPDATE ON SEQUENCE subd_subd_id_seq TO nobody;
GRANT SELECT ON SEQUENCE subd_subd_id_seq TO nord;


--
-- Name: subxcomp; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE subxcomp FROM PUBLIC;
REVOKE ALL ON TABLE subxcomp FROM artl;
GRANT ALL ON TABLE subxcomp TO artl;
GRANT ALL ON TABLE subxcomp TO nobody;
GRANT SELECT ON TABLE subxcomp TO nord;


--
-- Name: sucursalc; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE sucursalc FROM PUBLIC;
REVOKE ALL ON TABLE sucursalc FROM artl;
GRANT ALL ON TABLE sucursalc TO artl;
GRANT ALL ON TABLE sucursalc TO nobody;
GRANT SELECT ON TABLE sucursalc TO nord;


--
-- Name: sucursalp; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE sucursalp FROM PUBLIC;
REVOKE ALL ON TABLE sucursalp FROM artl;
GRANT ALL ON TABLE sucursalp TO artl;
GRANT ALL ON TABLE sucursalp TO nobody;
GRANT SELECT ON TABLE sucursalp TO nord;


--
-- Name: talon; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM artl;
GRANT ALL ON TABLE talon TO artl;
GRANT ALL ON TABLE talon TO nobody;
GRANT SELECT ON TABLE talon TO nord;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM artl;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO artl;
GRANT UPDATE ON SEQUENCE talon_tal_id_seq TO nobody;
GRANT SELECT ON SEQUENCE talon_tal_id_seq TO nord;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM artl;
GRANT ALL ON TABLE telefon TO artl;
GRANT ALL ON TABLE telefon TO nobody;
GRANT SELECT ON TABLE telefon TO nord;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM artl;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO artl;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;
GRANT SELECT ON SEQUENCE telefon_tel_id_seq TO nord;


--
-- Name: tipasi; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tipasi FROM PUBLIC;
REVOKE ALL ON TABLE tipasi FROM artl;
GRANT ALL ON TABLE tipasi TO artl;
GRANT ALL ON TABLE tipasi TO nobody;
GRANT SELECT ON TABLE tipasi TO nord;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM artl;
GRANT ALL ON TABLE tipcta TO artl;
GRANT ALL ON TABLE tipcta TO nobody;
GRANT SELECT ON TABLE tipcta TO nord;


--
-- Name: tipcta_tct_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE tipcta_tct_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE tipcta_tct_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE tipcta_tct_codigo_seq TO nord;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM artl;
GRANT ALL ON TABLE tipdocu TO artl;
GRANT ALL ON TABLE tipdocu TO nobody;
GRANT SELECT ON TABLE tipdocu TO nord;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM artl;
GRANT ALL ON TABLE tipemp TO artl;
GRANT ALL ON TABLE tipemp TO nobody;
GRANT SELECT ON TABLE tipemp TO nord;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM artl;
GRANT ALL ON TABLE tipentid TO artl;
GRANT ALL ON TABLE tipentid TO nobody;
GRANT SELECT ON TABLE tipentid TO nord;


--
-- Name: tipentid_tet_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE tipentid_tet_codigo_seq TO artl;
GRANT SELECT ON SEQUENCE tipentid_tet_codigo_seq TO nord;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM artl;
GRANT ALL ON TABLE tiptel TO artl;
GRANT ALL ON TABLE tiptel TO nobody;
GRANT SELECT ON TABLE tiptel TO nord;


--
-- Name: tiptel_ttl_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE tiptel_ttl_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE tiptel_ttl_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE tiptel_ttl_codigo_seq TO nord;


--
-- Name: tributosfe; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE tributosfe FROM PUBLIC;
REVOKE ALL ON TABLE tributosfe FROM artl;
GRANT ALL ON TABLE tributosfe TO artl;
GRANT ALL ON TABLE tributosfe TO nobody;
GRANT SELECT ON TABLE tributosfe TO nord;


--
-- Name: tributosfe_t_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE tributosfe_t_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tributosfe_t_id_seq FROM artl;
GRANT ALL ON SEQUENCE tributosfe_t_id_seq TO artl;
GRANT UPDATE ON SEQUENCE tributosfe_t_id_seq TO nobody;
GRANT SELECT ON SEQUENCE tributosfe_t_id_seq TO nord;


--
-- Name: unimed; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE unimed FROM PUBLIC;
REVOKE ALL ON TABLE unimed FROM artl;
GRANT ALL ON TABLE unimed TO artl;
GRANT ALL ON TABLE unimed TO nobody;
GRANT SELECT ON TABLE unimed TO nord;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM artl;
GRANT ALL ON TABLE varambi TO artl;
GRANT ALL ON TABLE varambi TO nobody;
GRANT SELECT ON TABLE varambi TO nord;


--
-- Name: vendedor; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE vendedor FROM PUBLIC;
REVOKE ALL ON TABLE vendedor FROM artl;
GRANT ALL ON TABLE vendedor TO artl;
GRANT ALL ON TABLE vendedor TO nobody;
GRANT SELECT ON TABLE vendedor TO nord;


--
-- Name: vendedor_ven_id_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM artl;
GRANT ALL ON SEQUENCE vendedor_ven_id_seq TO artl;
GRANT UPDATE ON SEQUENCE vendedor_ven_id_seq TO nobody;
GRANT SELECT ON SEQUENCE vendedor_ven_id_seq TO nord;


--
-- Name: zona; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM artl;
GRANT ALL ON TABLE zona TO artl;
GRANT SELECT ON TABLE zona TO nord;


--
-- Name: zona_zon_codigo_seq; Type: ACL; Schema: public; Owner: artl
--

REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM artl;
GRANT ALL ON SEQUENCE zona_zon_codigo_seq TO artl;
GRANT UPDATE ON SEQUENCE zona_zon_codigo_seq TO nobody;
GRANT SELECT ON SEQUENCE zona_zon_codigo_seq TO nord;


--
-- PostgreSQL database dump complete
--

