--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.ptovta DROP CONSTRAINT ptovta_ptv_codemp_fkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_oi_prioridad_fkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_oi_operasign_fkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_oi_operal_fkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_oi_idinc_fkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_oi_estado_fkey;
ALTER TABLE ONLY public.ocsingtos DROP CONSTRAINT ocsingtos_osg_idptov_fkey;
ALTER TABLE ONLY public.ocsingtos DROP CONSTRAINT ocsingtos_osg_division_fkey;
ALTER TABLE ONLY public.ocsingtos DROP CONSTRAINT ocsingtos_osg_codemp_fkey;
ALTER TABLE ONLY public.ocsingtos DROP CONSTRAINT ocsingtos_osg_centro_fkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_movs_idptov_fkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_movs_idemiti_fkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_movs_idastoh_fkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_movs_codemp_fkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_movs_artic_fkey;
ALTER TABLE ONLY public.liqegr DROP CONSTRAINT liqegr_eg_tipgto_fkey;
ALTER TABLE ONLY public.liqegr DROP CONSTRAINT liqegr_eg_idptov_fkey;
ALTER TABLE ONLY public.liqegr DROP CONSTRAINT liqegr_eg_idastoh_fkey;
ALTER TABLE ONLY public.liqegr DROP CONSTRAINT liqegr_eg_codemp_fkey;
ALTER TABLE ONLY public.interes DROP CONSTRAINT interes_int_idptov_fkey;
ALTER TABLE ONLY public.interes DROP CONSTRAINT interes_int_codemp_fkey;
ALTER TABLE ONLY public.interes DROP CONSTRAINT interes_int_centro_fkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_in_idptov_fkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_in_idcopr_fkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_in_estado_fkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_in_codemp_fkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_in_categoria_fkey;
ALTER TABLE ONLY public.imgincid DROP CONSTRAINT imgincid_img_idinc_fkey;
ALTER TABLE ONLY public.gtoxliqe DROP CONSTRAINT gtoxliqe_gxl_liqegr_fkey;
ALTER TABLE ONLY public.gtoxliqe DROP CONSTRAINT gtoxliqe_gxl_gasto_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_tipgto_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_idptov_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_idastoh_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_division_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_codemp_fkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_gto_centro_fkey;
ALTER TABLE ONLY public.formapagooc DROP CONSTRAINT formapagooc_fp_idptov_fkey;
ALTER TABLE ONLY public.formapagooc DROP CONSTRAINT formapagooc_fp_codemp_fkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_fap_idptov_fkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_fap_idgto_fkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_fap_division_fkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_fap_codemp_fkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_fap_centro_fkey;
ALTER TABLE ONLY public.estjurid DROP CONSTRAINT estjurid_est_codemp_fkey;
ALTER TABLE ONLY public.emiti DROP CONSTRAINT emiti_emi_idptov_fkey;
ALTER TABLE ONLY public.emiti DROP CONSTRAINT emiti_emi_idastoh_fkey;
ALTER TABLE ONLY public.emiti DROP CONSTRAINT emiti_emi_comprob_fkey;
ALTER TABLE ONLY public.emiti DROP CONSTRAINT emiti_emi_codemp_fkey;
ALTER TABLE ONLY public.docum DROP CONSTRAINT docum_doc_idptov_fkey;
ALTER TABLE ONLY public.docum DROP CONSTRAINT docum_doc_codemp_fkey;
ALTER TABLE ONLY public.division DROP CONSTRAINT division_div_idptov_fkey;
ALTER TABLE ONLY public.division DROP CONSTRAINT division_div_codemp_fkey;
ALTER TABLE ONLY public.cotiza DROP CONSTRAINT cotiza_cot_moneda_fkey;
ALTER TABLE ONLY public.coprop DROP CONSTRAINT coprop_cop_idptov_fkey;
ALTER TABLE ONLY public.coprop DROP CONSTRAINT coprop_cop_codemp_fkey;
ALTER TABLE ONLY public.compra DROP CONSTRAINT compra_cpra_idptov_fkey;
ALTER TABLE ONLY public.compra DROP CONSTRAINT compra_cpra_idastoh_fkey;
ALTER TABLE ONLY public.compra DROP CONSTRAINT compra_cpra_codemp_fkey;
ALTER TABLE ONLY public.cheques DROP CONSTRAINT cheques_chq_idptov_fkey;
ALTER TABLE ONLY public.cheques DROP CONSTRAINT cheques_chq_idastoc_fkey;
ALTER TABLE ONLY public.cheques DROP CONSTRAINT cheques_chq_codemp_fkey;
ALTER TABLE ONLY public.centroc DROP CONSTRAINT centroc_cco_idptov_fkey;
ALTER TABLE ONLY public.centroc DROP CONSTRAINT centroc_cco_codemp_fkey;
ALTER TABLE ONLY public.centroc DROP CONSTRAINT centroc_cco_coddiv_fkey;
ALTER TABLE ONLY public.astoh DROP CONSTRAINT astoh_ash_idptov_fkey;
ALTER TABLE ONLY public.astoh DROP CONSTRAINT astoh_ash_codemp_fkey;
ALTER TABLE ONLY public.astoctas DROP CONSTRAINT astoctas_astc_idptov_fkey;
ALTER TABLE ONLY public.astoctas DROP CONSTRAINT astoctas_astc_idastoh_fkey;
ALTER TABLE ONLY public.astoctas DROP CONSTRAINT astoctas_astc_codemp_fkey;
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$7";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$7";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$6";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$6";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$6";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$6";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.amenity DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.comprop DROP CONSTRAINT "$5";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.amenity DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.comprop DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.liquidacion DROP CONSTRAINT "$4";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.amenity DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.cobrxclq DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.comprop DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.liqui DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.liquidacion DROP CONSTRAINT "$3";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.amenity DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.gtoxoc DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.conxclia DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.cobrxclq DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.auxint DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.comprop DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.liqui DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.liquidacion DROP CONSTRAINT "$2";
ALTER TABLE ONLY public.eventos DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.amenity DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.ordencompra DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.astcconccble DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.conccble DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.conxclia DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.concilia DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.compliq DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.judicial DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.ctasconv DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.convenios DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.auxint DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.comprop DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.liqui DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.compliquid DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.liquidacion DROP CONSTRAINT "$1";
ALTER TABLE ONLY public.cargos DROP CONSTRAINT "$1";
DROP TRIGGER bu_gastos ON public.gastos;
DROP TRIGGER bu_cheques ON public.cheques;
DROP TRIGGER bu_astoh ON public.astoh;
DROP TRIGGER bd_ptovta ON public.ptovta;
DROP TRIGGER bd_prove ON public.prove;
DROP TRIGGER bd_ordencompra ON public.ordencompra;
DROP TRIGGER bd_liquidacion ON public.liquidacion;
DROP TRIGGER bd_incidencias ON public.incidencias;
DROP TRIGGER bd_importoliq ON public.importoliq;
DROP TRIGGER bd_gastos ON public.gastos;
DROP TRIGGER bd_emiti ON public.emiti;
DROP TRIGGER bd_coprop ON public.coprop;
DROP TRIGGER bd_astoh ON public.astoh;
DROP TRIGGER bd_astoctas ON public.astoctas;
DROP TRIGGER au_telefon ON public.telefon;
DROP TRIGGER au_prove ON public.prove;
DROP TRIGGER au_ordencompra ON public.ordencompra;
DROP TRIGGER au_liquidacion ON public.liquidacion;
DROP TRIGGER au_liqegr ON public.liqegr;
DROP TRIGGER au_honorarios ON public.honorarios;
DROP TRIGGER au_gastos ON public.gastos;
DROP TRIGGER au_emiti ON public.emiti;
DROP TRIGGER au_coprop ON public.coprop;
DROP TRIGGER au_concilia ON public.concilia;
DROP TRIGGER au_conccble ON public.conccble;
DROP TRIGGER au_compra ON public.compra;
DROP TRIGGER au_compliq ON public.compliq;
DROP TRIGGER au_cheques ON public.cheques;
DROP TRIGGER au_astoh ON public.astoh;
DROP TRIGGER au_astoctas ON public.astoctas;
DROP TRIGGER ai_ptovta ON public.ptovta;
DROP TRIGGER ai_prove ON public.prove;
DROP TRIGGER ai_ordencompra ON public.ordencompra;
DROP TRIGGER ai_gastos ON public.gastos;
DROP TRIGGER ai_empresa ON public.empresa;
DROP TRIGGER ai_coprop ON public.coprop;
DROP TRIGGER ai_astoh ON public.astoh;
DROP TRIGGER ai_astoctas ON public.astoctas;
DROP TRIGGER ad_prove ON public.prove;
DROP TRIGGER ad_gastos ON public.gastos;
DROP TRIGGER ad_coprop ON public.coprop;
DROP TRIGGER ad_compliq ON public.compliq;
DROP TRIGGER ad_cobrxclq ON public.cobrxclq;
DROP INDEX public.idx_telefon_3;
DROP INDEX public.idx_telefon_2;
DROP INDEX public.idx_telefon_1;
DROP INDEX public.idx_talon_1;
DROP INDEX public.idx_subrub_1;
DROP INDEX public.idx_subd_1;
DROP INDEX public.idx_sinicial_1;
DROP INDEX public.idx_ptovta_1;
DROP INDEX public.idx_prove_2;
DROP INDEX public.idx_prove_1;
DROP INDEX public.idx_ordencompra_1;
DROP INDEX public.idx_operadores_2;
DROP INDEX public.idx_ocsingtos_2;
DROP INDEX public.idx_noticias_3;
DROP INDEX public.idx_noticias_2;
DROP INDEX public.idx_noticias_1;
DROP INDEX public.idx_movsto_5;
DROP INDEX public.idx_movsto_4;
DROP INDEX public.idx_movsto_3;
DROP INDEX public.idx_movsto_2;
DROP INDEX public.idx_movsto_1;
DROP INDEX public.idx_modlogs_3;
DROP INDEX public.idx_modlogs_2;
DROP INDEX public.idx_modlogs_1;
DROP INDEX public.idx_liquidacion_2;
DROP INDEX public.idx_liquidacion_1;
DROP INDEX public.idx_liquidacion_0;
DROP INDEX public.idx_liqui_1;
DROP INDEX public.idx_liqegr_2;
DROP INDEX public.idx_liqegr_1;
DROP INDEX public.idx_judicial_2;
DROP INDEX public.idx_judicial_1;
DROP INDEX public.idx_importoliq_1;
DROP INDEX public.idx_honorarios_2;
DROP INDEX public.idx_gtoxliqe_3;
DROP INDEX public.idx_gtoxliqe_2;
DROP INDEX public.idx_gtoxliqe_1;
DROP INDEX public.idx_gastos_2;
DROP INDEX public.idx_gastos_1;
DROP INDEX public.idx_formapagooc_4;
DROP INDEX public.idx_formapagooc_3;
DROP INDEX public.idx_formapagooc_2;
DROP INDEX public.idx_formapagooc_14;
DROP INDEX public.idx_formapagooc_13;
DROP INDEX public.idx_formapagooc_12;
DROP INDEX public.idx_formapagooc_11;
DROP INDEX public.idx_formapagooc_10;
DROP INDEX public.idx_firman_1;
DROP INDEX public.idx_factpend_2;
DROP INDEX public.idx_empresa_1;
DROP INDEX public.idx_emiti_3;
DROP INDEX public.idx_emiti_2;
DROP INDEX public.idx_emiti_1;
DROP INDEX public.idx_docum_6;
DROP INDEX public.idx_docum_5;
DROP INDEX public.idx_docum_4;
DROP INDEX public.idx_docum_3;
DROP INDEX public.idx_docum_2;
DROP INDEX public.idx_docum_1;
DROP INDEX public.idx_division_1;
DROP INDEX public.idx_dinicial_1;
DROP INDEX public.idx_ctes_1;
DROP INDEX public.idx_ctacble_3;
DROP INDEX public.idx_ctacble_2;
DROP INDEX public.idx_ctacble_1;
DROP INDEX public.idx_coprop_3;
DROP INDEX public.idx_coprop_2;
DROP INDEX public.idx_conxcxlia_2;
DROP INDEX public.idx_conxcxlia_1;
DROP INDEX public.idx_convenios_1;
DROP INDEX public.idx_concilia_1;
DROP INDEX public.idx_conccble_1;
DROP INDEX public.idx_comprop_3;
DROP INDEX public.idx_comprop_2;
DROP INDEX public.idx_comprop_1;
DROP INDEX public.idx_comprob_2;
DROP INDEX public.idx_compra_3;
DROP INDEX public.idx_compra_2;
DROP INDEX public.idx_compra_1;
DROP INDEX public.idx_compliquid_1;
DROP INDEX public.idx_compliq_9;
DROP INDEX public.idx_compliq_8;
DROP INDEX public.idx_compliq_7;
DROP INDEX public.idx_compliq_6;
DROP INDEX public.idx_compliq_5;
DROP INDEX public.idx_compliq_4;
DROP INDEX public.idx_compliq_3;
DROP INDEX public.idx_compliq_2;
DROP INDEX public.idx_cheques_9;
DROP INDEX public.idx_cheques_8;
DROP INDEX public.idx_cheques_7;
DROP INDEX public.idx_cheques_6;
DROP INDEX public.idx_cheques_5;
DROP INDEX public.idx_cheques_4;
DROP INDEX public.idx_cheques_3;
DROP INDEX public.idx_cheques_2;
DROP INDEX public.idx_cheques_10;
DROP INDEX public.idx_cheques_1;
DROP INDEX public.idx_centroc_1;
DROP INDEX public.idx_cargos_3;
DROP INDEX public.idx_cargos_2;
DROP INDEX public.idx_cargos_1;
DROP INDEX public.idx_cambtitu_2;
DROP INDEX public.idx_cambtitu_1;
DROP INDEX public.idx_auxint_1;
DROP INDEX public.idx_astoh_8;
DROP INDEX public.idx_astoh_7;
DROP INDEX public.idx_astoh_6;
DROP INDEX public.idx_astoh_5;
DROP INDEX public.idx_astoh_4;
DROP INDEX public.idx_astoh_3;
DROP INDEX public.idx_astoh_2;
DROP INDEX public.idx_astoh_1;
DROP INDEX public.idx_astoctas_9;
DROP INDEX public.idx_astoctas_8;
DROP INDEX public.idx_astoctas_7;
DROP INDEX public.idx_astoctas_6;
DROP INDEX public.idx_astoctas_5;
DROP INDEX public.idx_astoctas_4;
DROP INDEX public.idx_astoctas_3;
DROP INDEX public.idx_astoctas_2;
DROP INDEX public.idx_astoctas_16;
DROP INDEX public.idx_astoctas_15;
DROP INDEX public.idx_astoctas_14;
DROP INDEX public.idx_astoctas_13;
DROP INDEX public.idx_astoctas_12;
DROP INDEX public.idx_astoctas_11;
DROP INDEX public.idx_astoctas_10;
DROP INDEX public.idx_astoctas_1;
DROP INDEX public.idx_articvta_2;
DROP INDEX public.idx_articvta_1;
DROP INDEX public.cobrxclq_cxc_idcopr_cxc_importe_idx;
DROP INDEX public.cobrxclq_cxc_idclq_cxc_importe_idx;
DROP INDEX public.cobrxclq_cxc_idastoc_cxc_importe_idx;
ALTER TABLE ONLY public.zona DROP CONSTRAINT zona_pkey;
ALTER TABLE ONLY public.varambi DROP CONSTRAINT varambi_pkey;
ALTER TABLE ONLY public.varamb DROP CONSTRAINT varamb_pkey;
ALTER TABLE ONLY public.usermenu DROP CONSTRAINT usermenu_pkey;
ALTER TABLE ONLY public.unimed DROP CONSTRAINT unimed_pkey;
ALTER TABLE ONLY public.tipuf DROP CONSTRAINT tipuf_pkey;
ALTER TABLE ONLY public.tiptel DROP CONSTRAINT tiptel_pkey;
ALTER TABLE ONLY public.tipnot DROP CONSTRAINT tipnot_pkey;
ALTER TABLE ONLY public.tipgto DROP CONSTRAINT tipgto_pkey;
ALTER TABLE ONLY public.tipentid DROP CONSTRAINT tipentid_pkey;
ALTER TABLE ONLY public.tipempr DROP CONSTRAINT tipempr_pkey;
ALTER TABLE ONLY public.tipemp DROP CONSTRAINT tipemp_pkey;
ALTER TABLE ONLY public.tipdocu DROP CONSTRAINT tipdocu_pkey;
ALTER TABLE ONLY public.tipcta DROP CONSTRAINT tipcta_pkey;
ALTER TABLE ONLY public.telefon DROP CONSTRAINT telefon_pkey;
ALTER TABLE ONLY public.talon DROP CONSTRAINT talon_pkey;
ALTER TABLE ONLY public.sucursal DROP CONSTRAINT sucursal_pkey;
ALTER TABLE ONLY public.subrub DROP CONSTRAINT subrub_pkey;
ALTER TABLE ONLY public.subd DROP CONSTRAINT subd_pkey;
ALTER TABLE ONLY public.srubcar DROP CONSTRAINT srubcar_pkey;
ALTER TABLE ONLY public.sinicial DROP CONSTRAINT sinicial_pkey;
ALTER TABLE ONLY public.seccion DROP CONSTRAINT seccion_pkey;
ALTER TABLE ONLY public.scangto DROP CONSTRAINT scangto_pkey;
ALTER TABLE ONLY public.rubros DROP CONSTRAINT rubros_pkey;
ALTER TABLE ONLY public.rubcar DROP CONSTRAINT rubcar_pkey;
ALTER TABLE ONLY public.revisliq DROP CONSTRAINT revisliq_pkey;
ALTER TABLE ONLY public.relmenu DROP CONSTRAINT relmenu_pkey;
ALTER TABLE ONLY public.ptovta DROP CONSTRAINT ptovta_pkey;
ALTER TABLE ONLY public.provin DROP CONSTRAINT provin_pkey;
ALTER TABLE ONLY public.prove DROP CONSTRAINT prove_pkey;
ALTER TABLE ONLY public.priorincid DROP CONSTRAINT priorincid_pkey;
ALTER TABLE ONLY public.pais DROP CONSTRAINT pais_pkey;
ALTER TABLE ONLY public.ordencompra DROP CONSTRAINT ordencompra_pkey;
ALTER TABLE ONLY public.operincid DROP CONSTRAINT operincid_pkey;
ALTER TABLE ONLY public.operadores DROP CONSTRAINT operadores_pkey;
ALTER TABLE ONLY public.ocsingtos DROP CONSTRAINT ocsingtos_pkey;
ALTER TABLE ONLY public.noticias DROP CONSTRAINT noticias_pkey;
ALTER TABLE ONLY public.movsto DROP CONSTRAINT movsto_pkey;
ALTER TABLE ONLY public.monex DROP CONSTRAINT monex_pkey;
ALTER TABLE ONLY public.moneda DROP CONSTRAINT moneda_pkey;
ALTER TABLE ONLY public.modlogs DROP CONSTRAINT modlogs_pkey;
ALTER TABLE ONLY public.menues DROP CONSTRAINT menues_pkey;
ALTER TABLE ONLY public.liquidacion DROP CONSTRAINT liquidacion_pkey;
ALTER TABLE ONLY public.liqegr DROP CONSTRAINT liqegr_pkey;
ALTER TABLE ONLY public.judicial DROP CONSTRAINT judicial_pkey;
ALTER TABLE ONLY public.interes DROP CONSTRAINT interes_pkey;
ALTER TABLE ONLY public.incidencias DROP CONSTRAINT incidencias_pkey;
ALTER TABLE ONLY public.importoliq DROP CONSTRAINT importoliq_pkey;
ALTER TABLE ONLY public.imgincid DROP CONSTRAINT imgincid_pkey;
ALTER TABLE ONLY public.honorarios DROP CONSTRAINT honorarios_pkey;
ALTER TABLE ONLY public.gtoxoc DROP CONSTRAINT gtoxoc_pkey;
ALTER TABLE ONLY public.grupos DROP CONSTRAINT grupos_pkey;
ALTER TABLE ONLY public.grupof_inq DROP CONSTRAINT grupof_inq_pkey;
ALTER TABLE ONLY public.grupof_d DROP CONSTRAINT grupof_d_pkey;
ALTER TABLE ONLY public.gastos DROP CONSTRAINT gastos_pkey;
ALTER TABLE ONLY public.formapagooc DROP CONSTRAINT formapagooc_pkey;
ALTER TABLE ONLY public.firman DROP CONSTRAINT firman_pkey;
ALTER TABLE ONLY public.factpend DROP CONSTRAINT factpend_pkey;
ALTER TABLE ONLY public.eventos DROP CONSTRAINT eventos_pkey;
ALTER TABLE ONLY public.estjurid DROP CONSTRAINT estjurid_pkey;
ALTER TABLE ONLY public.estjud DROP CONSTRAINT estjud_pkey;
ALTER TABLE ONLY public.estincid DROP CONSTRAINT estincid_pkey;
ALTER TABLE ONLY public.entidad DROP CONSTRAINT entidad_pkey;
ALTER TABLE ONLY public.empresa DROP CONSTRAINT empresa_pkey;
ALTER TABLE ONLY public.emiti DROP CONSTRAINT emiti_pkey;
ALTER TABLE ONLY public.docum DROP CONSTRAINT docum_pkey;
ALTER TABLE ONLY public.division DROP CONSTRAINT division_pkey;
ALTER TABLE ONLY public.dinicial DROP CONSTRAINT dinicial_pkey;
ALTER TABLE ONLY public.descripliq DROP CONSTRAINT descripliq_pkey;
ALTER TABLE ONLY public.ctes DROP CONSTRAINT ctes_pkey;
ALTER TABLE ONLY public.ctasconv DROP CONSTRAINT ctasconv_pkey;
ALTER TABLE ONLY public.ctacble DROP CONSTRAINT ctacble_pkey;
ALTER TABLE ONLY public.cotiza DROP CONSTRAINT cotiza_pkey;
ALTER TABLE ONLY public.coprop DROP CONSTRAINT coprop_pkey;
ALTER TABLE ONLY public.conxclia DROP CONSTRAINT conxcxlia_pkey;
ALTER TABLE ONLY public.convenios DROP CONSTRAINT convenios_pkey;
ALTER TABLE ONLY public.contratos DROP CONSTRAINT contratos_pkey;
ALTER TABLE ONLY public.conpag DROP CONSTRAINT conpag_pkey;
ALTER TABLE ONLY public.coniva DROP CONSTRAINT coniva_pkey;
ALTER TABLE ONLY public.concilia DROP CONSTRAINT concilia_pkey;
ALTER TABLE ONLY public.conccble DROP CONSTRAINT conccble_pkey;
ALTER TABLE ONLY public.comprop DROP CONSTRAINT comprop_pkey;
ALTER TABLE ONLY public.comprob DROP CONSTRAINT comprob_pkey;
ALTER TABLE ONLY public.compra DROP CONSTRAINT compra_pkey;
ALTER TABLE ONLY public.compliq DROP CONSTRAINT compliq_pkey;
ALTER TABLE ONLY public.cobrxclq DROP CONSTRAINT cobrxclq_pkey;
ALTER TABLE ONLY public.cheques DROP CONSTRAINT cheques_pkey;
ALTER TABLE ONLY public.chat DROP CONSTRAINT chat_pkey;
ALTER TABLE ONLY public.centroc DROP CONSTRAINT centroc_pkey;
ALTER TABLE ONLY public.catego DROP CONSTRAINT catego_pkey;
ALTER TABLE ONLY public.categincid DROP CONSTRAINT categincid_pkey;
ALTER TABLE ONLY public.cargos DROP CONSTRAINT cargos_pkey;
ALTER TABLE ONLY public.cambtitu DROP CONSTRAINT cambtitu_pkey;
ALTER TABLE ONLY public.bancos DROP CONSTRAINT bancos_pkey;
ALTER TABLE ONLY public.astoh DROP CONSTRAINT astoh_pkey;
ALTER TABLE ONLY public.astoctas DROP CONSTRAINT astoctas_pkey;
ALTER TABLE ONLY public.astcconccble DROP CONSTRAINT astcconccble_pkey;
ALTER TABLE ONLY public.articvta DROP CONSTRAINT articvta_pkey;
ALTER TABLE ONLY public.amenity DROP CONSTRAINT amenity_pkey;
ALTER TABLE public.usermenu ALTER COLUMN umen_id DROP DEFAULT;
ALTER TABLE public.tipgto ALTER COLUMN tg_id DROP DEFAULT;
ALTER TABLE public.telefon ALTER COLUMN tel_id DROP DEFAULT;
ALTER TABLE public.talon ALTER COLUMN tal_id DROP DEFAULT;
ALTER TABLE public.subrub ALTER COLUMN srb_id DROP DEFAULT;
ALTER TABLE public.subd ALTER COLUMN subd_id DROP DEFAULT;
ALTER TABLE public.srubcar ALTER COLUMN srbl_id DROP DEFAULT;
ALTER TABLE public.sinicial ALTER COLUMN sin_id DROP DEFAULT;
ALTER TABLE public.scangto ALTER COLUMN sc_id DROP DEFAULT;
ALTER TABLE public.rubros ALTER COLUMN rub_id DROP DEFAULT;
ALTER TABLE public.rubcar ALTER COLUMN rubl_id DROP DEFAULT;
ALTER TABLE public.revisliq ALTER COLUMN rl_id DROP DEFAULT;
ALTER TABLE public.relmenu ALTER COLUMN rmen_id DROP DEFAULT;
ALTER TABLE public.ptovta ALTER COLUMN ptv_id DROP DEFAULT;
ALTER TABLE public.prove ALTER COLUMN prov_id DROP DEFAULT;
ALTER TABLE public.priorincid ALTER COLUMN pri_codigo DROP DEFAULT;
ALTER TABLE public.ordencompra ALTER COLUMN oc_id DROP DEFAULT;
ALTER TABLE public.operincid ALTER COLUMN oi_id DROP DEFAULT;
ALTER TABLE public.operadores ALTER COLUMN operad_id DROP DEFAULT;
ALTER TABLE public.ocsingtos ALTER COLUMN osg_id DROP DEFAULT;
ALTER TABLE public.noticias ALTER COLUMN not_id DROP DEFAULT;
ALTER TABLE public.notdeb ALTER COLUMN nd_id DROP DEFAULT;
ALTER TABLE public.movsto ALTER COLUMN movs_id DROP DEFAULT;
ALTER TABLE public.monex ALTER COLUMN mne_id DROP DEFAULT;
ALTER TABLE public.modlogs ALTER COLUMN log_id DROP DEFAULT;
ALTER TABLE public.menues ALTER COLUMN men_id DROP DEFAULT;
ALTER TABLE public.logosptv ALTER COLUMN lpt_id DROP DEFAULT;
ALTER TABLE public.liquidacion ALTER COLUMN l_id DROP DEFAULT;
ALTER TABLE public.liqui ALTER COLUMN lq_id DROP DEFAULT;
ALTER TABLE public.liqegr ALTER COLUMN eg_id DROP DEFAULT;
ALTER TABLE public.judicial ALTER COLUMN jud_id DROP DEFAULT;
ALTER TABLE public.incidencias ALTER COLUMN in_id DROP DEFAULT;
ALTER TABLE public.importoliq ALTER COLUMN imp_id DROP DEFAULT;
ALTER TABLE public.imgincid ALTER COLUMN img_codigo DROP DEFAULT;
ALTER TABLE public.honorarios ALTER COLUMN hon_id DROP DEFAULT;
ALTER TABLE public.gtoxoc ALTER COLUMN gxo_id DROP DEFAULT;
ALTER TABLE public.grupof_inq ALTER COLUMN gf_id DROP DEFAULT;
ALTER TABLE public.grupof_d ALTER COLUMN gf_id DROP DEFAULT;
ALTER TABLE public.gastos ALTER COLUMN gto_id DROP DEFAULT;
ALTER TABLE public.formapagooc ALTER COLUMN fp_id DROP DEFAULT;
ALTER TABLE public.firman ALTER COLUMN fir_id DROP DEFAULT;
ALTER TABLE public.factpend ALTER COLUMN fap_id DROP DEFAULT;
ALTER TABLE public.eventos ALTER COLUMN evt_id DROP DEFAULT;
ALTER TABLE public.estincid ALTER COLUMN est_codigo DROP DEFAULT;
ALTER TABLE public.entidad ALTER COLUMN ent_id DROP DEFAULT;
ALTER TABLE public.emiti ALTER COLUMN emi_id DROP DEFAULT;
ALTER TABLE public.docum ALTER COLUMN doc_id DROP DEFAULT;
ALTER TABLE public.division ALTER COLUMN div_id DROP DEFAULT;
ALTER TABLE public.dinicial ALTER COLUMN din_id DROP DEFAULT;
ALTER TABLE public.descripliq ALTER COLUMN dlq_id DROP DEFAULT;
ALTER TABLE public.ctes ALTER COLUMN cte_id DROP DEFAULT;
ALTER TABLE public.ctasconv ALTER COLUMN ctc_id DROP DEFAULT;
ALTER TABLE public.ctacble ALTER COLUMN cbl_id DROP DEFAULT;
ALTER TABLE public.coprop ALTER COLUMN cop_id DROP DEFAULT;
ALTER TABLE public.conxclia ALTER COLUMN cxlia_id DROP DEFAULT;
ALTER TABLE public.convenios ALTER COLUMN con_id DROP DEFAULT;
ALTER TABLE public.contratos ALTER COLUMN ct_id DROP DEFAULT;
ALTER TABLE public.concilia ALTER COLUMN clia_id DROP DEFAULT;
ALTER TABLE public.conccble ALTER COLUMN ccbl_id DROP DEFAULT;
ALTER TABLE public.comprop ALTER COLUMN cmpr_id DROP DEFAULT;
ALTER TABLE public.comprob ALTER COLUMN comp_id DROP DEFAULT;
ALTER TABLE public.compra ALTER COLUMN cpra_id DROP DEFAULT;
ALTER TABLE public.compliquid ALTER COLUMN cl_id DROP DEFAULT;
ALTER TABLE public.compliq ALTER COLUMN clq_id DROP DEFAULT;
ALTER TABLE public.cobrxclq ALTER COLUMN cxc_id DROP DEFAULT;
ALTER TABLE public.chqrech ALTER COLUMN chqr_id DROP DEFAULT;
ALTER TABLE public.chequesaux ALTER COLUMN cqa_id DROP DEFAULT;
ALTER TABLE public.chequesaux ALTER COLUMN cqa_grupo DROP DEFAULT;
ALTER TABLE public.cheques ALTER COLUMN chq_id DROP DEFAULT;
ALTER TABLE public.chat ALTER COLUMN c_id DROP DEFAULT;
ALTER TABLE public.centroc ALTER COLUMN cco_id DROP DEFAULT;
ALTER TABLE public.categincid ALTER COLUMN cat_codigo DROP DEFAULT;
ALTER TABLE public.cargos ALTER COLUMN car_id DROP DEFAULT;
ALTER TABLE public.cambtitu ALTER COLUMN cbt_id DROP DEFAULT;
ALTER TABLE public.auxint ALTER COLUMN ai_id DROP DEFAULT;
ALTER TABLE public.astoh ALTER COLUMN ash_id DROP DEFAULT;
ALTER TABLE public.astoctas ALTER COLUMN astc_id DROP DEFAULT;
ALTER TABLE public.astcconccble ALTER COLUMN accb_id DROP DEFAULT;
ALTER TABLE public.articvta ALTER COLUMN art_id DROP DEFAULT;
ALTER TABLE public.amenity ALTER COLUMN am_id DROP DEFAULT;
DROP TABLE public.zona;
DROP TABLE public.varambi;
DROP TABLE public.varamb;
DROP SEQUENCE public.usermenu_umen_id_seq;
DROP TABLE public.usermenu;
DROP TABLE public.unimed;
DROP TABLE public.total;
DROP TABLE public.tipuf;
DROP TABLE public.tiptel;
DROP TABLE public.tipnot;
DROP SEQUENCE public.tipgto_tg_id_seq;
DROP TABLE public.tipgto;
DROP TABLE public.tipentid;
DROP TABLE public.tipempr;
DROP TABLE public.tipemp;
DROP TABLE public.tipdocu;
DROP TABLE public.tipcta;
DROP SEQUENCE public.telefon_tel_id_seq;
DROP TABLE public.telefon;
DROP SEQUENCE public.talon_tal_id_seq;
DROP TABLE public.talon;
DROP TABLE public.sucursal;
DROP TABLE public.subxcomp;
DROP SEQUENCE public.subrub_srb_id_seq;
DROP TABLE public.subrub;
DROP SEQUENCE public.subd_subd_id_seq;
DROP TABLE public.subd;
DROP SEQUENCE public.srubcar_srbl_id_seq;
DROP TABLE public.srubcar;
DROP SEQUENCE public.sinicial_sin_id_seq;
DROP TABLE public.sinicial;
DROP TABLE public.seccion;
DROP SEQUENCE public.scangto_sc_id_seq;
DROP TABLE public.scangto;
DROP SEQUENCE public.rubros_rub_id_seq;
DROP TABLE public.rubros;
DROP SEQUENCE public.rubcar_rubl_id_seq;
DROP TABLE public.rubcar;
DROP SEQUENCE public.revisliq_rl_id_seq;
DROP TABLE public.revisliq;
DROP SEQUENCE public.relmenu_rmen_id_seq;
DROP TABLE public.relmenu;
DROP SEQUENCE public.ptovta_ptv_id_seq;
DROP TABLE public.ptovta;
DROP TABLE public.provin;
DROP SEQUENCE public.prove_prov_id_seq;
DROP TABLE public.prove;
DROP SEQUENCE public.priorincid_pri_codigo_seq;
DROP TABLE public.priorincid;
DROP TABLE public.pais;
DROP SEQUENCE public.ordencompra_oc_id_seq;
DROP TABLE public.ordencompra;
DROP SEQUENCE public.operincid_oi_id_seq;
DROP TABLE public.operincid;
DROP SEQUENCE public.operadores_operad_id_seq;
DROP TABLE public.operadores;
DROP SEQUENCE public.ocsingtos_osg_id_seq;
DROP TABLE public.ocsingtos;
DROP SEQUENCE public.noticias_not_id_seq;
DROP TABLE public.noticias;
DROP SEQUENCE public.notdeb_nd_id_seq;
DROP TABLE public.notdeb;
DROP SEQUENCE public.movsto_movs_id_seq;
DROP TABLE public.movsto;
DROP SEQUENCE public.monex_mne_id_seq;
DROP TABLE public.monex;
DROP TABLE public.moneda;
DROP SEQUENCE public.modlogs_log_id_seq;
DROP TABLE public.modlogs;
DROP SEQUENCE public.menues_men_id_seq;
DROP TABLE public.menues;
DROP SEQUENCE public.logosptv_lpt_id_seq;
DROP TABLE public.logosptv;
DROP SEQUENCE public.liquidacion_l_id_seq;
DROP TABLE public.liquidacion;
DROP SEQUENCE public.liqui_lq_id_seq;
DROP TABLE public.liqui;
DROP SEQUENCE public.liqegr_eg_id_seq;
DROP TABLE public.liqegr;
DROP SEQUENCE public.judicial_jud_id_seq;
DROP TABLE public.judicial;
DROP TABLE public.interes;
DROP SEQUENCE public.incidencias_in_id_seq;
DROP TABLE public.incidencias;
DROP SEQUENCE public.importoliq_imp_id_seq;
DROP TABLE public.importoliq;
DROP SEQUENCE public.imgincid_img_codigo_seq;
DROP TABLE public.imgincid;
DROP SEQUENCE public.honorarios_hon_id_seq;
DROP TABLE public.honorarios;
DROP SEQUENCE public.gtoxoc_gxo_id_seq;
DROP TABLE public.gtoxoc;
DROP TABLE public.gtoxliqe;
DROP TABLE public.grupos;
DROP SEQUENCE public.grupof_inq_gf_id_seq;
DROP TABLE public.grupof_inq;
DROP SEQUENCE public.grupof_d_gf_id_seq;
DROP TABLE public.grupof_d;
DROP SEQUENCE public.gastos_gto_id_seq;
DROP TABLE public.gastos;
DROP SEQUENCE public.formapagooc_fp_id_seq;
DROP TABLE public.formapagooc;
DROP SEQUENCE public.firman_fir_id_seq;
DROP TABLE public.firman;
DROP SEQUENCE public.factpend_fap_id_seq;
DROP TABLE public.factpend;
DROP SEQUENCE public.eventos_evt_id_seq;
DROP TABLE public.eventos;
DROP TABLE public.estjurid;
DROP TABLE public.estjud;
DROP SEQUENCE public.estincid_est_codigo_seq;
DROP TABLE public.estincid;
DROP SEQUENCE public.entidad_ent_id_seq;
DROP TABLE public.entidad;
DROP TABLE public.empresa;
DROP SEQUENCE public.emiti_emi_id_seq;
DROP TABLE public.emiti;
DROP SEQUENCE public.docum_doc_id_seq;
DROP TABLE public.docum;
DROP SEQUENCE public.division_div_id_seq;
DROP TABLE public.division;
DROP SEQUENCE public.dinicial_din_id_seq;
DROP TABLE public.dinicial;
DROP SEQUENCE public.descripliq_dlq_id_seq;
DROP TABLE public.descripliq;
DROP SEQUENCE public.ctes_cte_id_seq;
DROP TABLE public.ctes;
DROP SEQUENCE public.ctasconv_ctc_id_seq;
DROP TABLE public.ctasconv;
DROP SEQUENCE public.ctacble_cbl_id_seq;
DROP TABLE public.ctacble;
DROP TABLE public.cotiza;
DROP SEQUENCE public.coprop_cop_id_seq;
DROP TABLE public.coprop;
DROP SEQUENCE public.conxcxlia_cxlia_id_seq;
DROP TABLE public.conxclia;
DROP SEQUENCE public.convenios_con_id_seq;
DROP TABLE public.convenios;
DROP SEQUENCE public.contratos_ct_id_seq;
DROP TABLE public.contratos;
DROP TABLE public.conpag;
DROP TABLE public.coniva;
DROP SEQUENCE public.concilia_clia_id_seq;
DROP TABLE public.concilia;
DROP SEQUENCE public.conccble_ccbl_id_seq;
DROP TABLE public.conccble;
DROP SEQUENCE public.comprop_cmpr_id_seq;
DROP TABLE public.comprop;
DROP SEQUENCE public.comprob_comp_id_seq;
DROP TABLE public.comprob;
DROP SEQUENCE public.compra_cpra_id_seq;
DROP TABLE public.compra;
DROP SEQUENCE public.compliquid_cl_id_seq;
DROP TABLE public.compliquid;
DROP SEQUENCE public.compliq_clq_id_seq;
DROP TABLE public.compliq;
DROP SEQUENCE public.cobrxclq_cxc_id_seq;
DROP TABLE public.cobrxclq;
DROP SEQUENCE public.chqrech_chqr_id_seq;
DROP TABLE public.chqrech;
DROP SEQUENCE public.chequesaux_cqa_id_seq;
DROP SEQUENCE public.chequesaux_cqa_grupo_seq;
DROP TABLE public.chequesaux;
DROP SEQUENCE public.cheques_chq_id_seq;
DROP TABLE public.cheques;
DROP SEQUENCE public.chat_c_id_seq;
DROP TABLE public.chat;
DROP SEQUENCE public.centroc_cco_id_seq;
DROP TABLE public.centroc;
DROP TABLE public.catego;
DROP SEQUENCE public.categincid_cat_codigo_seq;
DROP TABLE public.categincid;
DROP SEQUENCE public.cargos_car_id_seq;
DROP TABLE public.cargos;
DROP SEQUENCE public.cambtitu_cbt_id_seq;
DROP TABLE public.cambtitu;
DROP TABLE public.bancos;
DROP SEQUENCE public.auxint_ai_id_seq;
DROP TABLE public.auxint;
DROP SEQUENCE public.astoh_ash_id_seq;
DROP TABLE public.astoh;
DROP SEQUENCE public.astoctas_astc_id_seq;
DROP TABLE public.astoctas;
DROP SEQUENCE public.astcconccble_accb_id_seq;
DROP TABLE public.astcconccble;
DROP SEQUENCE public.articvta_art_id_seq;
DROP TABLE public.articvta;
DROP SEQUENCE public.amenity_am_id_seq;
DROP TABLE public.amenity;
DROP FUNCTION public.valvaramb(integer, integer, character varying);
DROP FUNCTION public.ultcie(integer);
DROP FUNCTION public.ult_cotiz(integer);
DROP FUNCTION public.totenchq(integer);
DROP FUNCTION public.titastoh(integer);
DROP FUNCTION public.tipprove(integer);
DROP FUNCTION public.tipctacbl(integer);
DROP FUNCTION public.tabladin(integer);
DROP FUNCTION public.salgrup(integer, integer, integer, integer);
DROP FUNCTION public.saldocbl(integer, integer, integer, date);
DROP FUNCTION public.reviso_grupof(integer);
DROP FUNCTION public.redondeoliqui(integer);
DROP FUNCTION public.ptovemp(integer);
DROP FUNCTION public.ptovdefault(integer);
DROP FUNCTION public.pseudoash(integer);
DROP FUNCTION public.proxnumptv(integer, integer, character varying);
DROP FUNCTION public.proxcodprov(integer);
DROP FUNCTION public.prorratados(integer);
DROP FUNCTION public.prorrata(integer);
DROP FUNCTION public.paso_sgto(integer, integer);
DROP FUNCTION public.paso_cvar_neg(integer);
DROP FUNCTION public.paso_cvar(integer);
DROP FUNCTION public.paso_comprop(integer);
DROP FUNCTION public.operash(integer);
DROP FUNCTION public.ocdegasto(integer);
DROP FUNCTION public.numtalon(integer, integer, integer);
DROP FUNCTION public.nrotalon(integer, integer, character varying, integer);
DROP FUNCTION public.nroastc(integer);
DROP FUNCTION public.nomtipcta(integer);
DROP FUNCTION public.nomprove(integer);
DROP FUNCTION public.nomprov(integer);
DROP FUNCTION public.nomiva(integer);
DROP FUNCTION public.nomemp(integer);
DROP FUNCTION public.nomctes(integer);
DROP FUNCTION public.nomcomp(integer);
DROP FUNCTION public.nomcble(integer);
DROP FUNCTION public.nomartic(integer);
DROP FUNCTION public.monedacbl(integer);
DROP FUNCTION public.liquido_gf(integer);
DROP FUNCTION public.liquido(integer);
DROP FUNCTION public.intercentro(integer);
DROP FUNCTION public.intdecarg(integer);
DROP FUNCTION public.intacum(integer, date);
DROP FUNCTION public.imputodeuda(integer, numeric, integer, integer);
DROP FUNCTION public.imputocobranza(integer, numeric, integer);
DROP FUNCTION public.imputocargoafavor(integer, numeric, numeric, integer, integer);
DROP FUNCTION public.idcte(integer, integer, integer, integer);
DROP FUNCTION public.idcomp(integer, integer, character varying);
DROP FUNCTION public.idcli(integer, integer, integer, integer, integer);
DROP FUNCTION public.idcble(integer, integer, character varying);
DROP FUNCTION public.idcbl(integer, integer, integer);
DROP FUNCTION public.hago_asiento_lq(integer);
DROP FUNCTION public.grupocli(integer, integer);
DROP FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date);
DROP FUNCTION public.gastoct(integer, integer, integer, numeric);
DROP FUNCTION public.fondo_reserva(integer);
DROP FUNCTION public.fecdechq(integer);
DROP FUNCTION public.f_bu_gastos();
DROP FUNCTION public.f_bu_cheques();
DROP FUNCTION public.f_bu_astoh();
DROP FUNCTION public.f_bd_ptovta();
DROP FUNCTION public.f_bd_prove();
DROP FUNCTION public.f_bd_ordencompra();
DROP FUNCTION public.f_bd_liquidacion();
DROP FUNCTION public.f_bd_incidencias();
DROP FUNCTION public.f_bd_importoliq();
DROP FUNCTION public.f_bd_gastos();
DROP FUNCTION public.f_bd_emiti();
DROP FUNCTION public.f_bd_coprop();
DROP FUNCTION public.f_bd_compliq();
DROP FUNCTION public.f_bd_astoh();
DROP FUNCTION public.f_bd_astoctas();
DROP FUNCTION public.f_au_telefon();
DROP FUNCTION public.f_au_prove();
DROP FUNCTION public.f_au_ordencompra();
DROP FUNCTION public.f_au_liquidacion();
DROP FUNCTION public.f_au_liqegr();
DROP FUNCTION public.f_au_honorarios();
DROP FUNCTION public.f_au_gastos();
DROP FUNCTION public.f_au_emiti();
DROP FUNCTION public.f_au_coprop();
DROP FUNCTION public.f_au_concilia();
DROP FUNCTION public.f_au_conccble();
DROP FUNCTION public.f_au_compra();
DROP FUNCTION public.f_au_compliq();
DROP FUNCTION public.f_au_cheques();
DROP FUNCTION public.f_au_astoh();
DROP FUNCTION public.f_au_astoctas();
DROP FUNCTION public.f_ai_ptovta();
DROP FUNCTION public.f_ai_prove();
DROP FUNCTION public.f_ai_ordencompra();
DROP FUNCTION public.f_ai_gastos();
DROP FUNCTION public.f_ai_empresa();
DROP FUNCTION public.f_ai_coprop();
DROP FUNCTION public.f_ai_convenios();
DROP FUNCTION public.f_ai_astoh();
DROP FUNCTION public.f_ai_astoctas();
DROP FUNCTION public.f_ad_prove();
DROP FUNCTION public.f_ad_gastos();
DROP FUNCTION public.f_ad_coprop();
DROP FUNCTION public.f_ad_cobrxclq();
DROP FUNCTION public.exp_loc(integer);
DROP FUNCTION public.estadoptv(integer);
DROP FUNCTION public.estadocop(integer);
DROP FUNCTION public.emp_ptv(integer);
DROP FUNCTION public.elgrupo(integer, integer, integer);
DROP FUNCTION public.dfecreg(integer);
DROP FUNCTION public.deudacopropm1(integer, integer, integer, integer, integer);
DROP FUNCTION public.deudacopropid(integer, integer, integer);
DROP FUNCTION public.deudacopropafecha(integer, integer, integer, integer, integer, date);
DROP FUNCTION public.deudacoprop(integer, integer, integer, integer, integer);
DROP FUNCTION public.descptv(integer);
DROP FUNCTION public.descprov(integer);
DROP FUNCTION public.descfc(integer);
DROP FUNCTION public.descempptv(integer);
DROP FUNCTION public.descemp(integer, integer);
DROP FUNCTION public.descemp(integer);
DROP FUNCTION public.descctes(integer);
DROP FUNCTION public.desccop(integer);
DROP FUNCTION public.desccompdeastoctas(integer);
DROP FUNCTION public.desccomp(integer);
DROP FUNCTION public.descchq(smallint);
DROP FUNCTION public.desccble(integer);
DROP FUNCTION public.cuitprov(integer);
DROP FUNCTION public.conivaprov(integer);
DROP FUNCTION public.confondo(integer, integer, date, date);
DROP FUNCTION public.confondo(integer, integer);
DROP FUNCTION public.condolusado(integer);
DROP FUNCTION public.condocusado(integer);
DROP FUNCTION public.conchequsado(integer);
DROP FUNCTION public.compnrodeastoctas(integer);
DROP FUNCTION public.compnro(integer);
DROP FUNCTION public.codptv(integer);
DROP FUNCTION public.codprov(integer);
DROP FUNCTION public.codctes(integer);
DROP FUNCTION public.codcop(integer);
DROP FUNCTION public.codcompastc(integer);
DROP FUNCTION public.codcomp(integer);
DROP FUNCTION public.codcble(integer);
DROP FUNCTION public.cargodclq(integer);
DROP FUNCTION public.cargocint(integer);
DROP FUNCTION public.cargo_liqui_lq(integer);
DROP FUNCTION public.cargo_auxint(integer);
DROP FUNCTION public.calculo_cuota(integer);
DROP FUNCTION public.calc_intliq(integer);
DROP FUNCTION public.ashdeastc(integer);
DROP EXTENSION plpgsql;
DROP SCHEMA public;
--
-- Name: public; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA public;


ALTER SCHEMA public OWNER TO postgres;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: ashdeastc(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ashdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idastoh from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ashdeastc(integer) OWNER TO frola;

--
-- Name: calc_intliq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION calc_intliq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	idultcie	 integer;
	idcopant	 integer;
	impgia		 numeric(15,2);
	cobranz		 numeric(15,2);
	totcobr		 numeric(15,2);
	totcobr2	 numeric(15,2);
	import		 numeric(15,2);
	tasaint		 numeric(15,5);
	interes		 numeric(15,2);
	intercar	 numeric(15,2);

	rubro		 integer;
	cargo		 integer;
	srubro		 integer;
	deudxv		 integer;
	leyenda		 character varying(240);

	importe		 numeric(15,2);
	importedos	 numeric(15,2);
	deudant		 numeric(15,2);
	deudagint	 numeric(15,2);
	porcgint	 numeric(15,2);
	retval 		 integer;
	registro	 record;
	regi		 record;
	regis		 record;
BEGIN

retval:=1;
importe:=0;

select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
    into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

select l_id into idultcie from liquidacion where l_id!=idliq and l_estado=2 and l_centro=centro order by l_feccie desc limit 1;

select intercentro(centro) into tasaint;
if tasaint is null then
    tasaint:=0;
end if;

select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
if not found then
    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
    if not found then
	select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
    end if;
end if;

select car_rubcar, car_srubcar, car_leyen into rubro, srubro, leyenda from cargos where car_id=cargo;
select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into deudxv;

    if idultcie is not null then
	for regis in select distinct(clq_idcopr) as copr from compliq where numeric_gt(deudacopropid(clq_idcopr,clq_codemp,clq_idptov),0) and clq_id not in (select distinct cxc_idclq from cobrxclq where cxc_estado=2) and clq_idptov=idptov and clq_centro=centro and intdecarg(clq_cargo)=1 and estadocop(clq_idcopr)=1 and clq_estado=2 order by clq_idcopr 
	    loop
	    idcopant:=regis.copr;
	    totcobr:=0;
	    impgia:=0;
	    cobranz:=0;
	    interes:=0;
	    for regi in select * from compliq where int4ne(clq_idliq,idliq) and intdecarg(clq_cargo)=1 and clq_id not in (select cxc_idclq from cobrxclq where cxc_estado=2 and cxc_idcopr=idcopant) and clq_idcopr=idcopant and clq_estado=2 and clq_importe>0 
		loop
		    impgia:=impgia + regi.clq_importe;
		    if impgia is null then
			impgia:=0;
		    end if;

		    select sum(cxc_importe) into cobranz from cobrxclq where cxc_idclq=regi.clq_id;
		    if cobranz is null then
			cobranz:=0;
		    end if;
		    totcobr:=totcobr+cobranz;
		end loop;

	    importedos:=0;
	    cobranz:=0;
	    totcobr2:=0;

	    import:= (impgia - totcobr) + (importedos - totcobr2);

	    if numeric_gt(import,0) then
		interes:=import * tasaint / 100;
	    end if;

	    if numeric_gt(interes,0) then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_idcopr,clq_idliq,clq_srubcar)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubro,cargo,leyenda,1,interes,import,idcopant,idliq,srubro);
		interes:=0;
	    end if;
	end loop;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.calc_intliq(integer) OWNER TO frola;

--
-- Name: calculo_cuota(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION calculo_cuota(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	feccie		 date;
	menores		 integer;
	mayores		 integer;
	cantTot		 numeric(15,2);
	duracion	 integer;
	cuotaMayor	 numeric(15,2);
	cuotaMenor	 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cantidad	 integer;
	contrato	 integer;
	leyMayores	 character varying(255);
	leyMenores	 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_feccie,l_centro 
	into codemp,idptov,feccie,centro from liquidacion where l_id=idliq; 

    mayores:=0;
    menores:=0;

    for regis in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
	loop
	    select ct_id into contrato from contratos where ct_idcopr=regis.cop_id and ct_estado=1;
	    if not found then
		cantidad:=0;
		select count(*) into cantidad from grupof_d where gf_idcopr=regis.cop_id and gf_mayor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    mayores:=mayores + cantidad;
		end if;
		cantidad:=0;
		select count(*) into cantidad from grupof_d where gf_idcopr=regis.cop_id and gf_menor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    menores:=menores + cantidad;
		end if;
	    else
		cantidad:=0;
		select count(*) into cantidad from grupof_inq where gf_idcopr=regis.cop_id and gf_mayor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    mayores:=mayores + cantidad;
		end if;
		cantidad:=0;
		select count(*) into cantidad from grupof_inq where gf_idcopr=regis.cop_id and gf_menor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    menores:=menores + cantidad;
		end if;
	    end if;
	end loop;

    cantTot:=mayores+(menores::numeric/2::numeric)::numeric(15,2);

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select car_leyen into leyMayores from cargos where car_id=cargoMayores;
    select car_leyen into leyMenores from cargos where car_id=cargoMenores;

    for reg in select * from compliquid where cl_idliq=idliq and cl_tipo=4 
	loop
	    cuotaMayor:=reg.cl_importe::numeric/cantTot::numeric;
	    cuotaMenor:=cuotaMayor::numeric/2::numeric;

--	    cuotaMayor:=round(cuotaMayor);
--	    cuotaMenor:=round(cuotaMenor);

	    insert into compliquid (cl_idliq,cl_rubcar,cl_cargo,cl_porc,cl_leyen,cl_importe,cl_tipo,cl_tipuf) values 
		(reg.cl_idliq,reg.cl_rubcar,cargoMayores,reg.cl_porc,leyMayores,cuotaMayor,5,mayores);
	    insert into compliquid (cl_idliq,cl_rubcar,cl_cargo,cl_porc,cl_leyen,cl_importe,cl_tipo,cl_tipuf) values 
		(reg.cl_idliq,reg.cl_rubcar,cargoMenores,reg.cl_porc,leyMenores,cuotaMenor,5,menores);
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.calculo_cuota(integer) OWNER TO frola;

--
-- Name: cargo_auxint(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION cargo_auxint(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	rubcar		 integer;
	centro		 integer;
	perim		 integer;
	peria		 integer;
	mes		 integer;
	anio		 integer;
	inter		 integer;
	genint1		 numeric(15,2);
	genint2		 numeric(15,2);
	genint3		 numeric(15,2);
	totgi		 numeric(15,2);
	suma		 numeric(15,2);
	totngi		 numeric(15,2);
	totint		 numeric(15,2);
	cobgi		 numeric(15,2);
	cobngi		 numeric(15,2);
	cobint		 numeric(15,2);
	idliqant	 integer;
	retval 		 character;
	regist		 record;
	regi		 record;
	reg		 record;
    BEGIN

    select l_centro,l_perim,l_peria,l_mes,l_anio,l_codemp,l_idptov into centro,perim,peria,mes,anio,codemp,idptov from liquidacion where l_id=idliq; 

    retval:='f';
    for regist in select lq_idcopr,sum(lq_importe) as importe from liqui where lq_idliq=idliq group by 1 
	loop
	    genint1:=0;
	    genint2:=0;
	    genint3:=0;
	    totgi:=0;
	    totngi:=0;
	    totint:=0;
	    cobgi:=0;
	    cobngi:=0;
	    cobint:=0;

	    select sum(lq_importe) into genint1 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=1 and lq_importe>0;
	    select sum(lq_importe) into genint2 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=2 and lq_importe>0;
	    select sum(lq_importe) into genint3 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=3 and lq_importe>0;

	    if(genint1 is null) then genint1:=0; end if;
	    if(genint2 is null) then genint2:=0; end if;
	    if(genint3 is null) then genint3:=0; end if;


	    for regi in select a.clq_id as idclq,intdecarg(clq_cargo) as interes,clq_importe,clq_impngi,clq_interes 
			    from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2))
				and clq_idcopr=regist.lq_idcopr and (numeric_gt(clq_importe,0) or numeric_gt(clq_impngi,0) or numeric_gt(clq_interes,0)) 
				and int4ne(clq_idliq,idliq) order by 1
		loop
		    select sum(cxc_importe) into suma from cobrxclq where cxc_idclq=regi.idclq;
		    if (int4eq(regi.interes,1)) then
			totgi:=totgi+regi.clq_importe;
			if suma is not null then
			    cobgi:=cobgi+suma;
			end if;
		    else
			if (int4eq(regi.interes,2)) then
			    totngi:=totngi+regi.clq_impngi;
			    if suma is not null then
				cobngi:=cobngi+suma;
			    end if;
			else
			    if (int4eq(regi.interes,3)) then
				totint:=totint+regi.clq_interes;
				if suma is not null then
				    cobint:=cobint+suma;
				end if;
			    end if;
			end if;
		    end if;
		end loop;

	    for regi in select a.clq_id as idclq,intdecarg(clq_cargo) as interes,clq_importe,clq_impngi,clq_interes 
			    from compliq a where clq_idcopr=regist.lq_idcopr 
				and (numeric_gt(clq_importe,0) or numeric_gt(clq_impngi,0) or numeric_gt(clq_interes,0)) 
				and int4eq(clq_idliq,idliq) order by 1
		loop
		    select sum(cxc_importe) into suma from cobrxclq where cxc_idclq=regi.idclq;
		    if (int4eq(regi.interes,1)) then
			if suma is not null then
			    cobgi:=cobgi+suma;
			end if;
		    else
			if (int4eq(regi.interes,2)) then
			    if suma is not null then
				cobngi:=cobngi+suma;
			    end if;
			else
			    if (int4eq(regi.interes,3)) then
				if suma is not null then
				    cobint:=cobint+suma;
				end if;
			    end if;
			end if;
		    end if;
		end loop;

	    for reg in select clq_id,clq_idastoc from compliq where clq_idcopr=regist.lq_idcopr and clq_anio=anio and clq_mes=mes and clq_rubcar=7 and clq_estado=1
		loop
		    update compliq set clq_estado=2 where clq_id=reg.clq_id and clq_estado=1;
		end loop;

	    if(cobgi is null) then cobgi:=0; end if;
	    if(cobngi is null) then cobngi:=0; end if;
	    if(cobint is null) then cobint:=0; end if;

	    if(numeric_le(cobgi,0::numeric)) then cobgi:=cobgi*-1; end if;
	    if(numeric_le(cobngi,0::numeric)) then cobngi:=cobngi*-1; end if;
	    if(numeric_le(cobint,0::numeric)) then cobint:=cobint*-1; end if;

	    totgi:=totgi + genint1 - cobgi;
	    totngi:=totngi + genint2 - cobngi;
	    totint:=totint + genint3 - cobint;

	    insert into auxint (ai_idliq,ai_idcopr,ai_impgi,ai_impngi,ai_intacu) values (idliq,regist.lq_idcopr,totgi,totngi,totint);
	    retval:='t';
	end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.cargo_auxint(integer) OWNER TO frola;

--
-- Name: cargo_liqui_lq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION cargo_liqui_lq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	retval 		 integer;
	cargo 		 integer;
	deuda 		 numeric;
	regi		 record;
	r1		 record;
    BEGIN

    retval:=0;

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

	select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	    if not found then
		select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	    end if;
	end if;

    for r1 in select distinct clq_idcopr from compliq where clq_idliq=idliq and clq_estado=1 and clq_cargo=cargo 
	loop
	    select deudacopropid(r1.clq_idcopr,codemp,idptov) into deuda;
	    if (numeric_lt(deuda,0)) then
		delete from compliq where clq_idcopr=r1.clq_idcopr and clq_idliq=idliq and clq_comprob=comprob and clq_numero=numero and clq_cargo=cargo;
	    end if;
	end loop;

    for regi in select clq_idcopr,clq_cargo,clq_rubcar,clq_leyen,sum(clq_importe+clq_impngi+clq_interes) as impgi, sum(clq_canti) as canti from compliq where clq_idliq=idliq and clq_estado=1 and clq_rubcar!=7 group by 1,2,3,4
	loop
	    insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
		    values (idliq,regi.clq_idcopr,regi.clq_rubcar,regi.clq_cargo,regi.canti,regi.impgi / regi.canti,regi.impgi,regi.clq_leyen,1);
	end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.cargo_liqui_lq(integer) OWNER TO frola;

--
-- Name: cargocint(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION cargocint(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select car_genint from cargos where car_id= $1 ;$_$;


ALTER FUNCTION public.cargocint(integer) OWNER TO frola;

--
-- Name: cargodclq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION cargodclq(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select clq_cargo from compliq where clq_id= $1 ;$_$;


ALTER FUNCTION public.cargodclq(integer) OWNER TO frola;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codcble(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_codigo::int2 from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO frola;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO frola;

--
-- Name: codcompastc(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codcompastc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.codcompastc(integer) OWNER TO frola;

--
-- Name: codcop(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codcop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_unifun from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.codcop(integer) OWNER TO frola;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO frola;

--
-- Name: codprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_codigo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.codprov(integer) OWNER TO frola;

--
-- Name: codptv(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION codptv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_codigo from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.codptv(integer) OWNER TO frola;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO frola;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO frola;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO frola;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO frola;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO frola;

--
-- Name: confondo(integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION confondo(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	cargo		 ALIAS FOR $2; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;

	retval		 numeric(15,2);
BEGIN

select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
    into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select sum(cxc_importe) into retval from cobrxclq where 
				cxc_mes=mes and cxc_anio=anio and 
				cxc_idcopr in (select cop_id from coprop where cop_idptov=idptov and cop_estado in (1,2)) and 
				cargodclq(cxc_idclq)=cargo;
    if not found then
	retval:=0;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.confondo(integer, integer) OWNER TO frola;

--
-- Name: confondo(integer, integer, date, date); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION confondo(integer, integer, date, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idptov		 ALIAS FOR $1; 
	cargo		 ALIAS FOR $2; 
	fechad		 ALIAS FOR $3; 
	fechah		 ALIAS FOR $4; 

	retval		 numeric(15,2);
BEGIN

    select sum(cxc_importe) into retval from cobrxclq where 
				date_ge(cxc_fecha,fechad) and 
				date_le(cxc_fecha,fechah) and 
				cxc_idcopr in (select cop_id from coprop where cop_idptov=idptov and cop_estado in (1,2)) and 
				cargodclq(cxc_idclq)=cargo;
    if not found then
	retval:=0;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.confondo(integer, integer, date, date) OWNER TO frola;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO frola;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO frola;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO frola;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO frola;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO frola;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO frola;

--
-- Name: desccop(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION desccop(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cop_unifun||'  -  '||cop_nombre from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.desccop(integer) OWNER TO frola;

--
-- Name: descctes(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descctes(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cte_codigo||' - '||cte_nombre from ctes where cte_id= $1;$_$;


ALTER FUNCTION public.descctes(integer) OWNER TO frola;

--
-- Name: descemp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_codigo||'  -  '||emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.descemp(integer) OWNER TO frola;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: elm
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO elm;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO frola;

--
-- Name: descfc(integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION descfc(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0'::text) ||' - '|| lpad(cpra_nucomp::text,8,'0'::text) from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.descfc(integer) OWNER TO frola;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO frola;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO frola;

--
-- Name: deudacoprop(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION deudacoprop(integer, integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_estado=2; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacoprop(integer, integer, integer, integer, integer) OWNER TO frola;

--
-- Name: deudacopropafecha(integer, integer, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION deudacopropafecha(integer, integer, integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	fecha		 ALIAS FOR $6;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_fecval<=fecha and astc_estado=2; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropafecha(integer, integer, integer, integer, integer, date) OWNER TO frola;

--
-- Name: deudacopropid(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION deudacopropid(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_ctacte=coprop and astc_estado=2 and astc_tipcta=tipctacbl(cuentadxv) and astc_ctacble=cuentadxv; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropid(integer, integer, integer) OWNER TO frola;

--
-- Name: deudacopropm1(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION deudacopropm1(integer, integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_estado in (2,-1); 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropm1(integer, integer, integer, integer, integer) OWNER TO frola;

--
-- Name: dfecreg(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION dfecreg(integer) RETURNS date
    LANGUAGE sql
    AS $_$select date(ash_fecreg) from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.dfecreg(integer) OWNER TO frola;

--
-- Name: elgrupo(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elgrupo(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	tipcta		ALIAS FOR $1; 
	codigo		ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN

    retval:=1;
    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXV')::int4) then
	select cop_grupo into retval from coprop where int4eq(codigo,cop_id);
	if found then
	    if int4eq(modo,1) then
		update coprop set cop_grupo=cop_grupo+1 where int4eq(codigo,cop_id);
	    end if;
	end if;
    end if;

    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXC')::int4) then
	select prov_grupo into retval from prove where int4eq(codigo,prov_id);
	if found then
	    if int4eq(modo,1) then
		update prove set prov_grupo=prov_grupo+1 where int4eq(codigo,prov_id);
	    end if;
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elgrupo(integer, integer, integer) OWNER TO frola;

--
-- Name: emp_ptv(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION emp_ptv(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Empresa: '||lpad(ptv_codemp::text,4,'0')||'  Emprendimiento '||lpad(ptv_codigo::text,4,'0') from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.emp_ptv(integer) OWNER TO frola;

--
-- Name: estadocop(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION estadocop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_estado from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.estadocop(integer) OWNER TO frola;

--
-- Name: estadoptv(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION estadoptv(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ptv_estado from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.estadoptv(integer) OWNER TO frola;

--
-- Name: exp_loc(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION exp_loc(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	suma		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cargoExp	 integer;
	cargoLoc	 integer;
	porcDuracion	 numeric(15,2);
	porc1		 numeric(15,2);
	porc2		 numeric(15,2);
	porc3		 numeric(15,2);
	rubcar		 integer;
	srubcar		 integer;
	leyen		 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select valvaramb(codemp,idptov,'CARGOORDINARIAS') into cargoExp;
    select valvaramb(codemp,idptov,'CARGOLOCACION') into cargoLoc;
    select car_srubcar into srubcar from cargos where car_id=cargoLoc;
    select car_rubcar into rubcar from cargos where car_id=cargoLoc;
    select car_leyen into leyen from cargos where car_id=cargoLoc;

    select valvaramb(codemp,idptov,'PORC1LOC')::numeric(15,2) into porc1;
    select valvaramb(codemp,idptov,'PORC2LOC')::numeric(15,2) into porc2;
    select valvaramb(codemp,idptov,'PORC3LOC')::numeric(15,2) into porc3;

    for reg in select * from contratos where ct_idptov=idptov and ct_estado=1 
	loop
	    suma:=0;
	    select sum(clq_importe) into suma from compliq where clq_cargo in (cargoMayores,cargoMenores,cargoExp) and clq_idliq=idliq and clq_idcopr=reg.ct_idcopr;
	    --logica duracion establece porcDuracion
/*
	    if(int4le(reg.ct_duracion,1)) then
		porcDuracion:=porc1;
	    else
		if(int4eq(reg.ct_duracion,2) or int4eq(reg.ct_duracion,3)) then
		    porcDuracion:=porc2;
		else
		    if(int4ge(reg.ct_duracion,4) and int4le(reg.ct_duracion,36)) then
			porcDuracion:=porc3;
		    else
			porcDuracion:=0;
		    end if;
		end if;
	    end if;
*/

	    if(int4le(reg.ct_duracion,36)) then
		if(int4le(reg.ct_modo,1)) then
		    porcDuracion:=porc1;
		else
		    porcDuracion:=(reg.ct_modo::numeric(15,2)/100::numeric(15,2))::numeric(15,2);
		end if;
	    else
		porcDuracion:=0;
	    end if;

	    impaux:=suma*porcDuracion;
--	    importe:=round(impaux);
	    importe:=impaux;
	    if(numeric_gt(importe,0))then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubcar,srubcar,cargoLoc,leyen,1,importe,importe,reg.ct_idcopr,idliq);
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.exp_loc(integer) OWNER TO frola;

--
-- Name: f_ad_cobrxclq(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_ad_cobrxclq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cuantos		int4;
BEGIN
    select count(*) into cuantos from cobrxclq where int4eq(cxc_idclq,OLD.cxc_idclq) and int4eq(cxc_estado,2) and int4ne(cxc_id,OLD.cxc_id);
    if found then
	update cobrxclq set cxc_estado=1 where int4eq(cxc_idclq,OLD.cxc_idclq) and int4ne(cxc_id,OLD.cxc_id);
    end if;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_ad_cobrxclq() OWNER TO frola;

--
-- Name: f_ad_coprop(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ad_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	delete from ctes where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_coprop() OWNER TO frola;

--
-- Name: f_ad_gastos(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ad_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4eq(cuantos,1) THEN 
	    delete from liqegr where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_gasto=OLD.gto_id;
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_gastos() OWNER TO frola;

--
-- Name: f_ad_prove(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ad_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	delete from ctes where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_prove() OWNER TO frola;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcble(NEW.astc_codemp,NEW.astc_idptov,'BANCO') into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;
    if(int4eq(NEW.astc_ctacble,ctabco))  THEN
	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;
	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO frola;

--
-- Name: f_ai_astoh(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    comproba		character varying;
    proxnum		integer;
BEGIN
    if (NEW.ash_numptv is null) then
	select comp_codigo into comproba from comprob where comp_id=NEW.ash_comprob;
	select proxnumptv(NEW.ash_codemp,NEW.ash_idptov,comproba) into proxnum;
	update astoh set ash_numptv=proxnum where ash_id=NEW.ash_id;
    END IF;
    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_astoh() OWNER TO frola;

--
-- Name: f_ai_convenios(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_convenios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	centro		integer;
	newunif		integer;
	existe		integer;
	idastoh		integer;
	cuentadxv	integer;
	rubro		integer;
	cargo		integer;
    BEGIN

	select cop_unifun,cop_centro into unifun,centro from coprop where cop_id=NEW.con_idcopr;
	newunif:=unifun + 90000;

	select cop_id into existe from coprop where cop_centro=centro and cop_unifun=newunif;
	if not found then
	    insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
		select cop_codemp,cop_idptov,newunif,cop_nombre,cop_codaso,0,0,0,0,0,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,1,cop_mail,cop_inter,cop_recib,cop_centro,cop_division from coprop where cop_id=NEW.con_idcopr;
	  else
	    update coprop set cop_estado=1 where cop_id=existe;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	    values (NEW.con_codemp,NEW.con_idptov,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_comprob,NEW.con_numero,'Convenio de Pago',NEW.con_fechai,NEW.con_fechai,'Convenio de Pago',0,-1);

	select ash_id into idastoh from astoh where ash_codemp=NEW.con_codemp and ash_idptov=NEW.con_idptov and ash_comprob=NEW.con_comprob and ash_numero=NEW.con_numero;

	select idcbl(NEW.con_codemp,NEW.con_idptov,valvaramb(NEW.con_codemp,NEW.con_idptov,'DEUDXV')::integer)  into cuentadxv;


	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),NEW.con_idcopr,idastoh,cuentadxv,NEW.con_monto*-1,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);

	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),existe,idastoh,cuentadxv,NEW.con_monto,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);


	select valvaramb(NEW.con_codemp,NEW.con_idptov,'CODCARCONV') into cargo;

	select car_rubcar into rubro from cargos where car_id=cargo;

	insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr)
	    values (NEW.con_codemp,NEW.con_idptov,NEW.con_centro,NEW.con_division,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_fechai,NEW.con_fechai,NEW.con_comprob,NEW.con_numero,NEW.con_operador,rubro,cargo,NEW.con_leyen,1,0,NEW.con_monto,NEW.con_monto,NEW.con_idcopr);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_convenios() OWNER TO frola;

--
-- Name: f_ai_coprop(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    newunif		int4;
    tipcta		int4;
    BEGIN

    select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
    insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla,cte_centro,cte_division) values (NEW.cop_codemp,NEW.cop_idptov,tipcta,NEW.cop_unifun,NEW.cop_nombre,0,NEW.cop_id,NEW.cop_centro,NEW.cop_division);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_coprop() OWNER TO frola;

--
-- Name: f_ai_empresa(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	regis		record;
    BEGIN

    for regis in select * from varambi where vari_codemp=1 and vari_idptov=0 
	loop
	    insert into varambi values (NEW.emp_codigo,0,regis.vari_codigo,regis.vari_nombre,regis.vari_valor,regis.vari_tipo);
	end loop;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_empresa() OWNER TO frola;

--
-- Name: f_ai_gastos(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    idliqegr		integer;
    BEGIN
--	insert into liqegr 
--	    (eg_idastoh,eg_codemp,eg_idptov,eg_centro,eg_rubro,eg_subrub,eg_hayfac,eg_fecreg,eg_prove,eg_nprove,eg_cuitprov,eg_factur,eg_anio,eg_mes,eg_estado,eg_impag,eg_importe,eg_operador,eg_leyen)
--	    values 
--	    (NEW.gto_idastoh,NEW.gto_codemp,NEW.gto_idptov,NEW.gto_centro,NEW.gto_rubro,NEW.gto_subrub,NEW.gto_hayfac,NEW.gto_fecreg,NEW.gto_prove,NEW.gto_nprove,NEW.gto_cuitprov,NEW.gto_factur,NEW.gto_anio,NEW.gto_mes,NEW.gto_estado,NEW.gto_impag,NEW.gto_importe,NEW.gto_operador,NEW.gto_leyen);
--	select max(eg_id) into idliqegr from liqegr;
--	insert into gtoxliqe (gxl_liqegr,gxl_gasto,gxl_operador,eg_leyen) values (idliqegr, NEW.gto_id, NEW.gto_operador, NEW.gto_leyen);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_gastos() OWNER TO frola;

--
-- Name: f_ai_ordencompra(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    anio	 integer;
    numint	 integer;
BEGIN
    select date_part('year',NEW.oc_fecha)::integer into anio;
    select max(oc_numint) into numint from ordencompra where oc_centro=NEW.oc_centro;
    if (not found or numint is null) then
	numint:=0;
    end if;

    update ordencompra set oc_anio=anio,oc_numint=numint+1 where oc_id=NEW.oc_id;
    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_ordencompra() OWNER TO frola;

--
-- Name: f_ai_prove(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla,cte_centro,cte_division) values (NEW.prov_codemp,NEW.prov_idptov,tipcta,NEW.prov_codigo,NEW.prov_nombre,0,NEW.prov_id,0,0);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_prove() OWNER TO frola;

--
-- Name: f_ai_ptovta(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_ai_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
	divis		 int4;
    BEGIN

    for registro in select * from comprob where comp_codemp=NEW.ptv_codemp and comp_idptov=0 
	loop
	    insert into talon (tal_codemp,tal_idptov,tal_comprob,tal_valor,tal_fecha,tal_nombre) values (NEW.ptv_codemp,NEW.ptv_id,registro.comp_id,1,date(now()),registro.comp_nombre);
	end loop;
    insert into division (div_codemp, div_idptov, div_codigo, div_nombre) values (NEW.ptv_codemp, NEW.ptv_id, 1, NEW.ptv_nombre);
    select div_id into divis from division order by div_id desc limit 1;
    insert into centroc (cco_codemp,cco_idptov,cco_coddiv,cco_codigo,cco_nombre) values (NEW.ptv_codemp, NEW.ptv_id, divis, 1, NEW.ptv_nombre);
    insert into sucursal (sucu_cliente,sucu_codigo,sucu_nombre,sucu_direcc,sucu_locali,sucu_codpos,sucu_provin,sucu_pais,sucu_repres,sucu_direccl,sucu_localil,sucu_codposl,sucu_codprovl,sucu_paisl) values 
	(NEW.ptv_id,NEW.ptv_codigo,NEW.ptv_nombre,NEW.ptv_direcc,NEW.ptv_locali,NEW.ptv_codpos,NEW.ptv_provin,NEW.ptv_pais,NEW.ptv_nombre,NEW.ptv_direcc,NEW.ptv_locali,NEW.ptv_codpos,NEW.ptv_provin,NEW.ptv_pais);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_ptovta() OWNER TO frola;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total		 numeric;
	ultcie		 date;
	fecconc		 timestamp without time zone;
	cuantos		 integer;
	idconc		 integer;
	deudxv		 integer;
	aportes		 integer;
	deudxc		 integer;
	cont		 integer;
	registro	 record;
BEGIN
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer) into deudxv;
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXC')::integer) into deudxc;
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'1242')::integer) into aportes;

    select l_feccie into ultcie from liquidacion where l_idptov=NEW.astc_idptov and l_estado=2 order by l_feccie desc limit 1;

    if (int4eq(NEW.astc_ctacble,aportes) and int4eq(OLD.astc_cierra,2) and int4eq(NEW.astc_cierra,1)) THEN 
	select accb_idccbl into idconc from astcconccble where accb_idastc=OLD.astc_id;
	delete from astcconccble where accb_idastc=OLD.astc_id;
	select ccbl_fecha into fecconc from conccble where ccbl_id=idconc;
	for registro in select * from conccble where date_ge(ccbl_fecha::date,fecconc::date) order by ccbl_fecha asc 
	    loop
		if (date_eq(fecconc::date,registro.ccbl_fecha::date)) then
		    update conccble set ccbl_salcon=ccbl_salcon-(OLD.astc_importe) where ccbl_id=idconc;
		else
		    update conccble set ccbl_salcon=ccbl_salcon-(OLD.astc_importe),ccbl_salant=ccbl_salant-(OLD.astc_importe) where ccbl_id=idconc;
		end if;
	    end loop;
    end if;

    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=NEW.astc_id;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=NEW.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=NEW.astc_id;
    END IF;

    if int4eq(OLD.astc_ctacble,deudxv) THEN 
	if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	    update compliq set clq_idcopr=NEW.astc_ctacte where clq_idastoc=NEW.astc_id;
	    update cobrxclq set cxc_idcopr=NEW.astc_ctacte where cxc_idastoc=NEW.astc_id;
	END IF;
	if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
	    update compliq set clq_estado=999 where clq_idastoc=NEW.astc_id;
	    delete from cobrxclq where cxc_idastoc=NEW.astc_id;
	END IF;
	if date_ne(NEW.astc_fecval,OLD.astc_fecval) THEN 
	    update compliq set clq_fecha=NEW.astc_fecval where clq_idastoc=NEW.astc_id;
	    update cobrxclq set cxc_fecha=NEW.astc_fecval,cxc_mes=date_part('month',NEW.astc_fecval),cxc_anio=date_part('year',NEW.astc_fecval) where cxc_idastoc=NEW.astc_id;
	END IF;
	if numeric_ne(NEW.astc_importe,OLD.astc_importe) THEN 
	    select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) into total from compliq where clq_idastoc=NEW.astc_id;
	    if numeric_ne(NEW.astc_importe,total) then
		RAISE EXCEPTION 'NO SE PUEDE MODIFICAR UN IMPORTE DE UNA COBRANZA, SIN ANTES MODIFICAR LOS CONCEPTOS DE COBRANZA DE LIQUIDACION (COMPLIQ)';
	    end if;
	END IF;
    else
	if int4eq(OLD.astc_ctacble,deudxc) THEN 
	    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
		update gastos set gto_prove=NEW.astc_ctacte where gto_id=NEW.astc_idgto;
	    END IF;
	    if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
		update gastos set gto_estado=999 where gto_id=NEW.astc_idgto;
	    END IF;
	END IF;
    END IF;

    if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
	if (int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,deudxv) or int4eq(NEW.astc_ctacble,deudxc))) THEN
	    update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=NEW.astc_idastoh;
	end if;
	update cheques set chq_estado=2,chq_idastoce=NULL where chq_idastoce=NEW.astc_id;
    end if;



	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=NEW.astc_id;
	if cont is null then
	    cont:=1;
	end if;
	if (numeric_ne(NEW.astc_importe,OLD.astc_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_importe',OLD.astc_importe,NEW.astc_importe,cont);
	end if;
	if (int4ne(NEW.astc_ctacte,OLD.astc_ctacte)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_ctacte',OLD.astc_ctacte,NEW.astc_ctacte,cont);
	end if;
	if (int4ne(NEW.astc_cierra,OLD.astc_cierra)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_cierra',OLD.astc_cierra,NEW.astc_cierra,cont);
	end if;
	if (int4ne(NEW.astc_estado,OLD.astc_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_estado',OLD.astc_estado,NEW.astc_estado,cont);
	end if;


    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO frola;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	ultcie		 date;
	cont		 integer;
BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=NEW.ash_idptov and l_estado=2 order by l_feccie desc limit 1;

--    if int4eq(OLD.ash_estado,2) then
--	if date_lt(NEW.ash_fecval,ultcie) then
--	    RAISE EXCEPTION 'NO SE PUEDE MODIFICAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
--	END IF;
--    END IF;

	if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	    update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	    update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	    update gastos set gto_estado=NEW.ash_estado where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_estado=NEW.ash_estado where eg_idastoh=OLD.ash_id;
	    delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;
	if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	END IF;
	if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	    update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	    update gastos set gto_fecval=NEW.ash_fecval where gto_idastoh=OLD.ash_id;
	    update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	    update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	    update gastos set gto_comprob=NEW.ash_comprob where gto_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	    update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	    update gastos set gto_numero=NEW.ash_numero where gto_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	    update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	    update gastos set gto_codemp=NEW.ash_codemp where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_codemp=NEW.ash_codemp where eg_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	    update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	    update gastos set gto_idptov=NEW.ash_idptov where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_idptov=NEW.ash_idptov where eg_idastoh=OLD.ash_id;
	END IF;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=NEW.ash_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.ash_anio,OLD.ash_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_anio',OLD.ash_anio,NEW.ash_anio,cont);
	end if;
	if (int4ne(NEW.ash_mes,OLD.ash_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_mes',OLD.ash_mes,NEW.ash_mes,cont);
	end if;
	if (int4ne(NEW.ash_estado,OLD.ash_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_estado',OLD.ash_estado,NEW.ash_estado,cont);
	end if;
	if (date_ne(NEW.ash_fecomp,OLD.ash_fecomp)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecomp',OLD.ash_fecomp,NEW.ash_fecomp,cont);
	end if;
	if (date_ne(NEW.ash_fecval,OLD.ash_fecval)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecval',OLD.ash_fecval,NEW.ash_fecval,cont);
	end if;



    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO frola;

--
-- Name: f_au_cheques(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	numero		 integer;
	comprob		 integer;
BEGIN

	if(NEW.chq_idastoce is null) then
	    select astc_comprob,astc_numero into comprob,numero from astoctas where astc_id=NEW.chq_idastoc;
	else
	    select astc_comprob,astc_numero into comprob,numero from astoctas where astc_id=NEW.chq_idastoce;
	end if;

	select max(log_cont)+1 into cont from modlogs where log_tabla='cheques' and log_idtabla=NEW.chq_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.chq_nucheq,OLD.chq_nucheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_nucheq',OLD.chq_nucheq,NEW.chq_nucheq,cont);
	end if;
	if (int4ne(NEW.chq_codbco,OLD.chq_codbco)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_codbco',OLD.chq_codbco,NEW.chq_codbco,cont);
	end if;
	if (int4ne(NEW.chq_idastoc,OLD.chq_idastoc)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_idastoc',OLD.chq_idastoc,NEW.chq_idastoc,cont);
	end if;
	if (int4ne(NEW.chq_idastoce,OLD.chq_idastoce)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_idastoce',OLD.chq_idastoce,NEW.chq_idastoce,cont);
	end if;
	if (date_ne(NEW.chq_fecheq,OLD.chq_fecheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_fecheq',OLD.chq_fecheq,NEW.chq_fecheq,cont);
	end if;
	if (int4ne(NEW.chq_estado,OLD.chq_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_estado',OLD.chq_estado,NEW.chq_estado,cont);
	end if;
	if (numeric_ne(NEW.chq_importe,OLD.chq_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_importe',OLD.chq_importe,NEW.chq_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_cheques() OWNER TO frola;

--
-- Name: f_au_compliq(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_compliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='compliq' and log_idtabla=NEW.clq_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.clq_anio,OLD.clq_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_anio',OLD.clq_anio,NEW.clq_anio,cont);
	end if;
	if (int4ne(NEW.clq_mes,OLD.clq_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_mes',OLD.clq_mes,NEW.clq_mes,cont);
	end if;
	if (int4ne(NEW.clq_estado,OLD.clq_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_estado',OLD.clq_estado,NEW.clq_estado,cont);
	end if;
	if (date_ne(NEW.clq_fecha,OLD.clq_fecha)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_fecha',OLD.clq_fecha,NEW.clq_fecha,cont);
	end if;
	if (int4ne(NEW.clq_idcopr,OLD.clq_idcopr)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_idcopr',OLD.clq_idcopr,NEW.clq_idcopr,cont);
	end if;
	if (int4ne(NEW.clq_cargo,OLD.clq_cargo)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_cargo',OLD.clq_cargo,NEW.clq_cargo,cont);
	end if;
	if (numeric_ne(NEW.clq_importe,OLD.clq_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_importe',OLD.clq_importe,NEW.clq_importe,cont);
	end if;
	if (numeric_ne(NEW.clq_impngi,OLD.clq_impngi)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_impngi',OLD.clq_impngi,NEW.clq_impngi,cont);
	end if;
	if (numeric_ne(NEW.clq_interes,OLD.clq_interes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_interes',OLD.clq_interes,NEW.clq_interes,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compliq() OWNER TO frola;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO frola;

--
-- Name: f_au_conccble(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_conccble() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.ccbl_estado,OLD.ccbl_estado) THEN 
	update astcconccble set accb_estado=NEW.ccbl_estado where accb_idccbl=OLD.ccbl_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_conccble() OWNER TO frola;

--
-- Name: f_au_concilia(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_concilia() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.clia_estado,OLD.clia_estado) THEN 
	update conxclia set cxlia_estado=NEW.clia_estado where cxlia_idclia=OLD.clia_id;
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_concilia() OWNER TO frola;

--
-- Name: f_au_coprop(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		integer;
	tipcta		integer;
	telefono	character varying;
	mail		character varying;
BEGIN
	select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
	if int4ne(NEW.cop_unifun,OLD.cop_unifun) THEN 
	    update ctes set cte_codigo=NEW.cop_unifun where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if int4ne(NEW.cop_estado,OLD.cop_estado) THEN 
	    update ctes set cte_estado=NEW.cop_estado where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if bpcharne(NEW.cop_nombre,OLD.cop_nombre) THEN 
	    update ctes set cte_nombre=NEW.cop_nombre where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	    if OLD.cop_nombre is not null THEN 
		telefono:=' ';
		mail:=' ';
		select tel_dato into telefono from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel not in (6,7) order by tel_codigo desc limit 1;
		select tel_dato into mail from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel=7 limit 1;
		insert into cambtitu (cbt_codemp,cbt_idptov,cbt_division,cbt_centro,cbt_unifun,cbt_idcopr,cbt_nombre,cbt_direcc,cbt_locali,cbt_codpos,cbt_provin,cbt_tipdoc,cbt_nrodoc,cbt_nrcuit,cbt_telefono,cbt_mail) values (OLD.cop_codemp,OLD.cop_idptov,OLD.cop_division,OLD.cop_centro,OLD.cop_unifun,OLD.cop_id,OLD.cop_nombre,OLD.cop_direcc,OLD.cop_locali,OLD.cop_codpos,OLD.cop_provin,OLD.cop_tipdoc,OLD.cop_nrodoc,OLD.cop_nrcuit,telefono,mail);
	    END IF;
	END IF;

	select max(log_cont)+1 into cont from modlogs where log_tabla='coprop' and log_idtabla=NEW.cop_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.cop_unifun,OLD.cop_unifun)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_unifun',OLD.cop_unifun,NEW.cop_unifun,cont);
	end if;
	if (NEW.cop_direcc is distinct from OLD.cop_direcc) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_direcc',OLD.cop_direcc,NEW.cop_direcc,cont);
	end if;
	if (NEW.cop_locali is distinct from OLD.cop_locali) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_locali',OLD.cop_locali,NEW.cop_locali,cont);
	end if;
	if (NEW.cop_descuf is distinct from OLD.cop_descuf) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_descuf',OLD.cop_descuf,NEW.cop_descuf,cont);
	end if;
	if (NEW.cop_nrcuit is distinct from OLD.cop_nrcuit) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_nrcuit',OLD.cop_nrcuit,NEW.cop_nrcuit,cont);
	end if;
	if (int4ne(NEW.cop_tipuf,OLD.cop_tipuf)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_tipuf',OLD.cop_tipuf,NEW.cop_tipuf,cont);
	end if;
	if (int4ne(NEW.cop_nrodoc,OLD.cop_nrodoc)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_nrodoc',OLD.cop_nrodoc,NEW.cop_nrodoc,cont);
	end if;
	if (int4ne(NEW.cop_estado,OLD.cop_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_estado',OLD.cop_estado,NEW.cop_estado,cont);
	end if;
	if (numeric_ne(NEW.cop_porc1,OLD.cop_porc1)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc1',OLD.cop_porc1,NEW.cop_porc1,cont);
	    insert into chat (c_message,c_to) values ('Se cambio un Porcentaje A',58);
	end if;
	if (numeric_ne(NEW.cop_porc2,OLD.cop_porc2)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc2',OLD.cop_porc2,NEW.cop_porc2,cont);
	end if;
	if (numeric_ne(NEW.cop_porc3,OLD.cop_porc3)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc3',OLD.cop_porc3,NEW.cop_porc3,cont);
	end if;
	if (numeric_ne(NEW.cop_porc4,OLD.cop_porc4)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc4',OLD.cop_porc4,NEW.cop_porc4,cont);
	end if;
	if (numeric_ne(NEW.cop_porc5,OLD.cop_porc5)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc5',OLD.cop_porc5,NEW.cop_porc5,cont);
	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_coprop() OWNER TO frola;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;
	if int4eq(NEW.emi_estado,2) THEN 
	    update astoctas set astc_fecvto=astc_fecval+diasconpag(NEW.emi_conpag) where astc_idastoh=OLD.emi_idastoh and astc_ctacble=idcble(astc_codemp,astc_idptov,'DEUDXV');
	    END IF;
	END IF;
    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrocuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO frola;

--
-- Name: f_au_gastos(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    cuantosenoc		integer;
    ocid		integer;
    cont		integer;
    BEGIN

    select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=NEW.gto_id;
    select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;

    if (int4eq(NEW.gto_estado,999) and int4ne(OLD.gto_estado,999)) then
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=NEW.gto_id;
	if int4eq(cuantos,1) THEN 
	    update liqegr set eg_estado=NEW.gto_estado where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_liqegr=cualliqegr;
	else
	    update liqegr set eg_importe=eg_importe-NEW.gto_importe where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_gasto=NEW.gto_id;
	end if;
	select ocdegasto(NEW.gto_id) into ocid;
	if (ocid is not null) then
	    select count(*) into cuantosenoc from ordencompra where oc_id=ocid;
	    if int4eq(cuantosenoc,1) THEN 
		update ordencompra set oc_estado=NEW.gto_estado where oc_id=ocid;
	    else
		update ordencompra set oc_total=oc_total-NEW.gto_importe where oc_id=ocid;
		delete from gtoxoc where gxo_idgto=NEW.gto_id;
	    end if;
	end if;
    else
	if int4ne(NEW.gto_prove,OLD.gto_prove) then
	    update gastos set gto_nprove=nomprov(NEW.gto_prove),gto_cuitprov=cuitprov(NEW.gto_prove),gto_coniva=conivaprov(NEW.gto_prove) where gto_id=NEW.gto_id;
	end if;
	if int4eq(cuantos,1) THEN 
	    update liqegr set
		eg_codemp=NEW.gto_codemp,
		eg_idptov=NEW.gto_idptov,
		eg_centro=NEW.gto_centro,
		eg_rubro=NEW.gto_rubro,
		eg_subrub=NEW.gto_subrub,
		eg_hayfac=NEW.gto_hayfac,
		eg_prove=NEW.gto_prove,
		eg_nprove=NEW.gto_nprove,
		eg_cuitprov=NEW.gto_cuitprov,
		eg_factur=NEW.gto_factur,
		eg_anio=NEW.gto_anio,
		eg_mes=NEW.gto_mes,
		eg_estado=NEW.gto_estado,
		eg_impag=NEW.gto_impag,
		eg_tipgto=NEW.gto_tipgto,
		eg_importe=NEW.gto_importe,
		eg_operador=NEW.gto_operador,
		eg_leyen=NEW.gto_leyen where eg_id=cualliqegr;
	END IF;
    end if;

	select max(log_cont)+1 into cont from modlogs where log_tabla='gastos' and log_idtabla=NEW.gto_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.gto_anio,OLD.gto_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_anio',OLD.gto_anio,NEW.gto_anio,cont);
	end if;
	if (int4ne(NEW.gto_mes,OLD.gto_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_mes',OLD.gto_mes,NEW.gto_mes,cont);
	end if;
	if (int4ne(NEW.gto_subrub,OLD.gto_subrub)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_subrub',OLD.gto_subrub,NEW.gto_subrub,cont);
	end if;
	if (int4ne(NEW.gto_prove,OLD.gto_prove)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_prove',OLD.gto_prove,NEW.gto_prove,cont);
	end if;
	if (int4ne(NEW.gto_estado,OLD.gto_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_estado',OLD.gto_estado,NEW.gto_estado,cont);
	end if;
	if (numeric_ne(NEW.gto_importe,OLD.gto_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_importe',OLD.gto_importe,NEW.gto_importe,cont);
	end if;
	if (date_ne(NEW.gto_fecval,OLD.gto_fecval)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_fecval',OLD.gto_fecval,NEW.gto_fecval,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_gastos() OWNER TO frola;

--
-- Name: f_au_honorarios(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_honorarios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	idptov		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='honorarios' and log_idtabla=NEW.hon_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.hon_anio,OLD.hon_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_anio',OLD.hon_anio,NEW.hon_anio,cont);
	end if;
	if (int4ne(NEW.hon_mes,OLD.hon_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_mes',OLD.hon_mes,NEW.hon_mes,cont);
	end if;
	if (int4ne(NEW.hon_estado,OLD.hon_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_estado',OLD.hon_estado,NEW.hon_estado,cont);
	end if;
	if (numeric_ne(NEW.hon_importe,OLD.hon_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_importe',OLD.hon_importe,NEW.hon_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_honorarios() OWNER TO frola;

--
-- Name: f_au_liqegr(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_liqegr() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='liqegr' and log_idtabla=NEW.eg_id;
	if cont is null then
	    cont:=1;
	end if;
	if (NEW.eg_leyen is distinct from OLD.eg_leyen) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.eg_idptov,NEW.eg_division,NEW.eg_centro,'liqegr',NEW.eg_id,'eg_leyen',substring(OLD.eg_leyen from 1 for 180),substring(NEW.eg_leyen from 1 for 180),cont);
	end if;
	if (numeric_ne(NEW.eg_importe,OLD.eg_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.eg_idptov,NEW.eg_division,NEW.eg_centro,'liqegr',NEW.eg_id,'eg_importe',OLD.eg_importe,NEW.eg_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_liqegr() OWNER TO frola;

--
-- Name: f_au_liquidacion(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

    if int4ne(NEW.l_estado,OLD.l_estado) THEN 
      if(int4eq(NEW.l_estado,999::int)) THEN
	update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	update liqui set lq_estado=NEW.l_estado where lq_idliq=NEW.l_id;
	update compliq set clq_estado=NEW.l_estado where clq_idliq=NEW.l_id and clq_comprob=OLD.l_comprob;
	update compliq set clq_estado=1,clq_idliq=NULL where clq_idliq=NEW.l_id and clq_comprob!=OLD.l_comprob;
	update auxint set ai_estado=NEW.l_estado where ai_idliq=NEW.l_id;
	update astoh set ash_estado=NEW.l_estado where ash_comprob=NEW.l_comprob and ash_idemiti=NEW.l_id;
      else
	update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	update liqui set lq_estado=NEW.l_estado where lq_idliq=NEW.l_id;
	update compliq set clq_estado=NEW.l_estado where clq_idliq=NEW.l_id;
	update auxint set ai_estado=NEW.l_estado where ai_idliq=NEW.l_id;
	update astoh set ash_estado=NEW.l_estado where ash_comprob=NEW.l_comprob and ash_idemiti=NEW.l_id;
      END IF;
    END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_liquidacion() OWNER TO frola;

--
-- Name: f_au_ordencompra(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4eq(NEW.oc_estado,999) THEN 
	delete from gtoxoc where gxo_idoc=OLD.oc_id;
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_ordencompra() OWNER TO frola;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	tipcta		integer;
BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	if int4ne(NEW.prov_codigo,OLD.prov_codigo) THEN 
	    update ctes set cte_codigo=NEW.prov_codigo where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if int4ne(NEW.prov_estado,OLD.prov_estado) THEN 
	    update ctes set cte_estado=NEW.prov_estado where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	    update ctes set cte_nombre=NEW.prov_nombre where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	    update factpend set fap_nprove=NEW.prov_nombre where fap_prove=OLD.prov_id;
	    update gastos set gto_nprove=NEW.prov_nombre where gto_prove=OLD.prov_id;
	    update liqegr set eg_nprove=NEW.prov_nombre where eg_prove=OLD.prov_id;
	END IF;
	if bpcharne(NEW.prov_nrcuit,OLD.prov_nrcuit) THEN 
	    update factpend set fap_cuitprov=NEW.prov_nrcuit where fap_prove=OLD.prov_id;
	    update gastos set gto_cuitprov=NEW.prov_nrcuit where gto_prove=OLD.prov_id;
	    update liqegr set eg_cuitprov=NEW.prov_nrcuit where eg_prove=OLD.prov_id;
	END IF;
	if int4ne(NEW.prov_coniva,OLD.prov_coniva) THEN 
	    update factpend set fap_coniva=NEW.prov_coniva where fap_prove=OLD.prov_id;
	    update gastos set gto_coniva=NEW.prov_coniva where gto_prove=OLD.prov_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO frola;

--
-- Name: f_au_telefon(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_au_telefon() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	idptov		 integer;
	comprob		 integer;
	numero		 integer;
BEGIN

	select cop_idptov,cop_division,cop_centro into idptov,comprob,numero from coprop where cop_id=NEW.tel_codigo;
	select max(log_cont)+1 into cont from modlogs where log_tabla='telefon' and log_idtabla=NEW.tel_id;
	if cont is null then
	    cont:=1;
	end if;
	if (NEW.tel_dato is distinct from OLD.tel_dato) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (idptov,comprob,numero,'telefon',NEW.tel_id,'tel_dato',substring(OLD.tel_dato from 1 for 180),substring(NEW.tel_dato from 1 for 180),cont);
	end if;
	if (int4ne(NEW.tel_codigo,OLD.tel_codigo)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (idptov,comprob,numero,'telefon',NEW.tel_id,'tel_codigo',OLD.tel_codigo,NEW.tel_codigo,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_telefon() OWNER TO frola;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		 date;
	cuantos		 int4;
	idneg		 integer;
	cont		 integer;
	regis		 record;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.astc_idptov and l_estado=2 order by l_feccie desc limit 1;
    if date_lt(OLD.astc_fecval,ultcie) then
	RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
    end if;

    --que pasa con la conciliacion bancaria???
    if (int4eq(OLD.astc_cierra,2) and (int4eq(OLD.astc_tipcta,99) or int4eq(OLD.astc_tipcta,98))) then
	update astoctas set astc_cierra=1 where astc_cierra=2 and astc_tipcta=OLD.astc_tipcta and astc_ctacte=OLD.astc_ctacte and astc_grupo=OLD.astc_grupo;
    end if;

----------------------------  CHEQUES ---------------------------------------    
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
	if found then
	    update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
	END IF;
----------------------------  MONEX ---------------------------------------    
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
	if found then
	    update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
	END IF;
----------------------------  DOCUM ---------------------------------------    
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
	if found then
	    update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
	END IF;
--------------------------- ELIMINAR COMPLIQ --------------------------------
	select count(*) into cuantos from compliq where int4eq(clq_idastoc,OLD.astc_id);
	if found then
	    delete from compliq where clq_idastoc=OLD.astc_id;
	end if;
-------------------------- ELIMINAR COBRXCLQ ----------------------------------
	select count(*) into cuantos from cobrxclq where int4eq(cxc_idastoc,OLD.astc_id);
	if found then
	    for regis in select cxc_id from cobrxclq where cxc_idastoc=OLD.astc_id 
		loop
		    delete from cobrxclq where cxc_id=regis.cxc_id;
		end loop;
	end if;
	idneg:=OLD.astc_id*-1;
	select count(*) into cuantos from cobrxclq where int4eq(cxc_idastoc,idneg);
	if found then
	    for regis in select cxc_id from cobrxclq where cxc_idastoc=idneg 
		loop
		    delete from cobrxclq where cxc_id=regis.cxc_id;
		end loop;
	end if;
----------------------------------GRABAR MODLOGS--------------------------------


	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=OLD.astc_id;
	if cont is null then
	    cont:=1;
	end if;

	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_importe',OLD.astc_importe,OLD.astc_importe,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_fecval',OLD.astc_fecval,OLD.astc_fecval,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_ctacble',OLD.astc_ctacble,OLD.astc_ctacble,cont,'delete');
	if OLD.astc_ctacte is not null then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_ctacte',OLD.astc_ctacte,OLD.astc_ctacte,cont,'delete');
	end if;

    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO frola;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		date;
	idgto		int4;
	cuantos		integer;
	sgto		integer;
	pasaje		integer;
	cont		integer;
	gtoimpor	numeric;
	idliqegr	int4;
	egimpor		numeric;
	registro	record;
	regis		record;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.ash_idptov and l_estado=2 order by l_feccie desc limit 1;

--    if date_lt(OLD.ash_fecval,ultcie) then
--	select count(*) into cuantos from astoctas where astc_idastoh=OLD.ash_id;
--	if numeric_ne(cuantos,0) then
--	    RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
--	END IF;
--    END IF;

	    for regis in select gto_id as gto,gto_importe as gtoimp from gastos where int4eq(gto_idastoh,OLD.ash_id)
		loop
		    idgto:=regis.gto;
		    gtoimpor:=regis.gtoimp;
		    select gxo_idsgto into sgto from gtoxoc where gxo_idgto=idgto;
		    if (sgto is not null) then
			select paso_sgto(OLD.ash_id,idgto) into pasaje;
			select count(gxo_idsgto) into cuantos from gtoxoc where gxo_idsgto=sgto;
			if (int4gt(cuantos,1)) then
			    delete from gtoxoc where gxo_idgto=idgto and gxo_idsgto=sgto;
			else
			    update gtoxoc set gxo_idgto=-1 where gxo_idsgto=sgto;
			end if;
		    end if;
		    select gxl_liqegr into idliqegr from gtoxliqe where int4eq(gxl_gasto,idgto);
		    select eg_importe into egimpor from liqegr where int4eq(eg_id,idliqegr);
		    if numeric_eq(egimpor,gtoimpor) then
			delete from gtoxliqe where int4eq(gxl_gasto,idgto);
			delete from liqegr where int4eq(eg_id,idliqegr);
			delete from gastos where int4eq(gto_id,idgto);
		    else
			update liqegr set eg_importe=eg_importe-gtoimpor where int4eq(eg_id,idliqegr);
			delete from gtoxliqe where int4eq(gxl_gasto,idgto);
			delete from gastos where int4eq(gto_id,idgto);
		    end if;
		end loop;

	    delete from concilia where int4eq(clia_idastcg,OLD.ash_id);

	    for registro in select astc_id from astoctas where int4eq(astc_idastoh,OLD.ash_id)
		loop
		    delete from conxclia where int4eq(cxlia_idastc,registro.astc_id);
		end loop;

	    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
	    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idashce=OLD.ash_id;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=OLD.ash_id;
	if cont is null then
	    cont:=1;
	end if;


	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_fecval',OLD.ash_fecval,OLD.ash_fecval,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_titulo',OLD.ash_titulo,OLD.ash_titulo,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_numptv',OLD.ash_numptv,OLD.ash_numptv,cont,'delete');


    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO frola;

--
-- Name: f_bd_compliq(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_compliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		 date;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.clq_idptov and l_estado=2 order by l_feccie desc limit 1;

    if (date_lt(OLD.clq_fecha,ultcie) and int4eq(OLD.clq_estado,2)) then
	RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN CONCEPTO DE LIQUIDACION DE UNA LIQUIDACION CERRADA';
    else
	delete from cobrxclq where cxc_idclq=OLD.clq_id;
    end if;

    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_compliq() OWNER TO frola;

--
-- Name: f_bd_coprop(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.cop_codemp and astc_idptov=OLD.cop_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.cop_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN COPROPIETARIO CON REGISTROS CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_coprop() OWNER TO frola;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN
    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO frola;

--
-- Name: f_bd_gastos(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    cuantosenoc		integer;
    ocid		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4gt(cuantos,1) THEN 
	RAISE EXCEPTION  'NO SE PUEDE BORRAR EL GASTO YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO BORRAR';
	END IF;

	select ocdegasto(OLD.gto_id) into ocid;
	if (ocid is not null) then
	    select count(*) into cuantosenoc from ordencompra where oc_id=ocid;
	    if int4eq(cuantosenoc,1) THEN 
		delete from ordencompra where oc_id=ocid;
	    else
		update ordencompra set oc_total=oc_total-OLD.gto_importe where oc_id=ocid;
		delete from gtoxoc where gxo_idgto=OLD.gto_id;
	    end if;
	end if;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_gastos() OWNER TO frola;

--
-- Name: f_bd_importoliq(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_importoliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    delete from sinicial where sin_idsaldos=OLD.imp_id;
    delete from dinicial where din_idsaldos=OLD.imp_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_importoliq() OWNER TO frola;

--
-- Name: f_bd_incidencias(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_incidencias() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
	delete from imgincid where img_idinc=OLD.in_id;
	delete from operincid where oi_idinc=OLD.in_id;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_incidencias() OWNER TO frola;

--
-- Name: f_bd_liquidacion(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos	int4;
    comprob	 integer;
    BEGIN
	delete from compliquid where cl_idliq=OLD.l_id;
	delete from liqui where lq_idliq=OLD.l_id;
	delete from cobrxclq where cxc_idclq in (select clq_id from compliq where clq_idliq=OLD.l_id);
	delete from compliq where clq_idliq=OLD.l_id and clq_comprob=OLD.l_comprob;
	update compliq set clq_idliq=NULL,clq_estado=1 where clq_idliq=OLD.l_id and clq_comprob!=OLD.l_comprob;
	delete from auxint where ai_idliq=OLD.l_id;
	delete from astoh where ash_comprob=OLD.l_comprob and ash_idemiti=OLD.l_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_liquidacion() OWNER TO frola;

--
-- Name: f_bd_ordencompra(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    delete from gtoxoc where gxo_idoc=OLD.oc_id;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_ordencompra() OWNER TO frola;

--
-- Name: f_bd_prove(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.prov_codemp and astc_idptov=OLD.prov_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON REGISTROS CONTABLES CARGADOS';
	END IF;
	select count(*) into cuantos from gastos where gto_prove=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON GASTOS CARGADOS';
	END IF;
	select count(*) into cuantos from liqegr where eg_prove=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON GASTOS DE LIQUIDACION CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_prove() OWNER TO frola;

--
-- Name: f_bd_ptovta(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
    BEGIN

    for registro in select * from comprob where comp_codemp=OLD.ptv_codemp and comp_idptov=0 
	loop
	    delete from talon where tal_codemp=OLD.ptv_codemp and tal_idptov=OLD.ptv_id and tal_comprob=registro.comp_id;
	end loop;
    delete from centroc where cco_codemp=OLD.ptv_codemp and cco_idptov=OLD.ptv_id;
    delete from division where div_codemp=OLD.ptv_codemp and div_idptov=OLD.ptv_id;
    delete from sucursal where sucu_cliente=OLD.ptv_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_ptovta() OWNER TO frola;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 
------------------ PARTIDA DOBLE -----------------------------------
    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;
------------------ CASO CHEQUES -----------------------------------
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO frola;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 
    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO frola;

--
-- Name: f_bu_gastos(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bu_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if(int4gt(cuantos,1) and numeric_ne(OLD.gto_impag,NEW.gto_impag)) THEN 
	RAISE EXCEPTION  'NO SE PUEDE MODIFICAR YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO MODIFICAR';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bu_gastos() OWNER TO frola;

--
-- Name: fecdechq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION fecdechq(integer) RETURNS date
    LANGUAGE sql
    AS $_$select chq_fecheq from cheques where chq_id= $1 ;$_$;


ALTER FUNCTION public.fecdechq(integer) OWNER TO frola;

--
-- Name: fondo_reserva(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION fondo_reserva(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	suma		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cargoExp	 integer;
	cargoReserva	 integer;
	porcReserva	 numeric(15,2);
	rubcar		 integer;
	srubcar		 integer;
	leyen		 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select valvaramb(codemp,idptov,'CARGOORDINARIAS') into cargoExp;
    select valvaramb(codemp,idptov,'CARGORESERVA') into cargoReserva;
    select car_srubcar into srubcar from cargos where car_id=cargoReserva;
    select car_rubcar into rubcar from cargos where car_id=cargoReserva;
    select car_leyen into leyen from cargos where car_id=cargoReserva;
    select valvaramb(codemp,idptov,'FONDORESERVA')::numeric(15,2) into porcReserva;

    for reg in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
	loop
	    suma:=0;
	    select sum(clq_importe) into suma from compliq where clq_cargo in (cargoMayores,cargoMenores,cargoExp) and clq_idliq=idliq and clq_idcopr=reg.cop_id;
	    impaux:=suma*porcReserva;
--	    importe:=round(impaux);
	    importe:=impaux;
	    if(numeric_gt(importe,0))then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubcar,srubcar,cargoReserva,leyen,1,importe,importe,reg.cop_id,idliq);
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.fondo_reserva(integer) OWNER TO frola;

--
-- Name: gastoct(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION gastoct(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then

	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1 
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct(integer, integer, integer, numeric) OWNER TO frola;

--
-- Name: gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctacte		ALIAS FOR $6; 
	nucheq		ALIAS FOR $7; 
	fecvto		ALIAS FOR $8; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then
	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte,astc_nucheq,astc_fecvto) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1,tipcta,ctacte,nucheq,fecvto
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) OWNER TO frola;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cop_grupo into retval from
    	 coprop where int4eq(cliente,cop_id);

    if found then
	if int4eq(modo,1) then
	    update coprop set cop_grupo=cop_grupo+1 where int4eq(cliente,cop_id);
	end if;
    else
	update coprop set cop_grupo=1 where int4eq(cliente,cop_id);
	retval:=1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO frola;

--
-- Name: hago_asiento_lq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION hago_asiento_lq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	idastohmal	 integer;
	numptv 		 integer;
	titulo 		 character varying;
	idastoh		 integer;
	astcid		 integer;
	cuentadxv	 integer;
	cuentac		 integer;
	deuda		 numeric(15,2);
	retval 		 integer;
	imputo 		 character;
	regi		 record;
	regis		 record;
    BEGIN

	retval:=0;
	numptv:=99999;

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 

	select max(ash_numptv) into numptv from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_idemiti is not null and ash_estado=2;
	if numptv is null then
	    numptv:=1;
	    titulo:='Carga Inicial de Saldos  ' || mes || '-' || anio;
	  else
	    numptv:=numptv + 1;
	    titulo:='Liquidacion de Expensas  ' || mes || '-' || anio;
	    select ash_id into idastohmal from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_numptv=numptv and ash_estado!=2;
	    delete from astoh where ash_id=idastohmal;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_division,ash_centro,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_estado,ash_operad,ash_idemiti,ash_date,ash_numptv) 
	    values (codemp,idptov,division,centro,anio,mes,comprob,numero,titulo,feccie,feccie,titulo,-1,operador,idliq,feccie,numptv);

	select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_numero=numero and ash_idemiti=idliq;

	retval:=idastoh;

	select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;

	for regi in select lq_idcopr,sum(lq_importe) as impcop from liqui where lq_idliq=idliq group by 1 
	    loop
		select deudacopropid(regi.lq_idcopr,codemp,idptov) into deuda;
		insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro,astc_fecvto,astc_grupo) 
		     values (tipctacbl(cuentadxv),regi.lq_idcopr,idastoh,cuentadxv,regi.impcop,codemp,idptov,comprob,numero,feccie,-1,division,centro,fecvto,grupocli(regi.lq_idcopr,1));
		select astc_id into astcid from astoctas where astc_ctacte=regi.lq_idcopr and astc_idastoh=idastoh and astc_ctacble=cuentadxv and astc_importe=regi.impcop and astc_tipcta=tipctacbl(cuentadxv);
		update cobrxclq set cxc_idastoc=(astcid*-1),cxc_fecha=feccie,cxc_mes=mes,cxc_anio=anio where cxc_idastoc=0 and cxc_idcopr=regi.lq_idcopr;
		if (numeric_lt(deuda,0)) then
		    select imputodeuda(regi.lq_idcopr,deuda,idliq,astcid) into imputo;
		end if;
	    end loop;


	for regis in select lq_cargo,sum(lq_importe) as impcar from liqui where lq_idliq=idliq group by 1 
	    loop
		select car_ctacble into cuentac from cargos where car_id=regis.lq_cargo;
		insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro,astc_fecvto) 
		     values (idastoh,cuentac,regis.impcar * -1,codemp,idptov,comprob,numero,feccie,-1,division,centro,fecvto);
	    end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.hago_asiento_lq(integer) OWNER TO frola;

--
-- Name: idcbl(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION idcbl(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codcble		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble);
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcbl(integer, integer, integer) OWNER TO frola;

--
-- Name: idcble(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION idcble(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    codcble		integer;
    retval 		varchar;
    BEGIN

    select vari_valor into codcble from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble::int4) ;
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcble(integer, integer, character varying) OWNER TO frola;

--
-- Name: idcli(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION idcli(integer, integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_id from coprop where cop_codemp=$1 and cop_idptov=$2 and cop_centro=$3 and cop_division=$4 and cop_unifun=$5;$_$;


ALTER FUNCTION public.idcli(integer, integer, integer, integer, integer) OWNER TO frola;

--
-- Name: idcomp(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION idcomp(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	retval 		integer;
    BEGIN
    select comp_id into retval from comprob where int4eq(codemp,comp_codemp) and int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_id into retval from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_id into retval from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.idcomp(integer, integer, character varying) OWNER TO frola;

--
-- Name: idcte(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION idcte(integer, integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1;
    ptovta		ALIAS FOR $2;
    tipcta		ALIAS FOR $3;
    codcte		ALIAS FOR $4;
    retval 		varchar;
    BEGIN

    select cte_id into retval from ctes where cte_codemp=codemp and cte_idptov=ptovta and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
    if not found then
	select cte_id into retval from ctes where cte_codemp=codemp and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	if not found then
	    select cte_id into retval from ctes where int4eq(0,cte_codemp) and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcte(integer, integer, integer, integer) OWNER TO frola;

--
-- Name: imputocargoafavor(integer, numeric, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION imputocargoafavor(integer, numeric, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	pago		 ALIAS FOR $2; 
	deuda		 ALIAS FOR $3; 
	astcid		 ALIAS FOR $4; 
	idclq		 ALIAS FOR $5; 
	codemp		 integer;
	idptov		 integer;
	fecval		 date;
	importe		 numeric(15,2);
	deudant		 numeric(15,2);
	retval 		 integer;
    BEGIN

	retval:=-1;
	deudant:=deuda*-1;
	select astc_codemp,astc_idptov,astc_fecval into codemp,idptov,fecval from astoctas where astc_id=astcid;
	if (numeric_le(pago,deudant)) then
	    --imputo todo
	    select sum(clq_importe+clq_interes+clq_impngi) into importe from compliq where clq_id=idclq;
	    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,idclq,2,importe,idcopr,fecval,date_part('month',fecval),date_part('year',fecval));
	    retval:=1;
	else
	    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,idclq,1,deudant,idcopr,fecval,date_part('month',fecval),date_part('year',fecval));
	    retval:=2;
	end if;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.imputocargoafavor(integer, numeric, numeric, integer, integer) OWNER TO frola;

--
-- Name: imputocobranza(integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION imputocobranza(integer, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	pago		 ALIAS FOR $2; 
	astcid		 ALIAS FOR $3; 
	codemp		 integer;
	idptov		 integer;
	fecval		 date;
	pago1		 numeric(15,2);
	totInt		 numeric(15,2);
	totGInt		 numeric(15,2);
	sumaCobrada	 numeric(15,2);
	importeCargo	 numeric(15,2);
	totalPorcentual	 numeric(15,2);
	pInt		 numeric(15,8);
	pGInt		 numeric(15,8);
	cInt		 numeric(15,2);
	cGInt		 numeric(15,2);
	diferencia	 numeric(15,2);
	restante	 numeric(15,2);
	regi		 record;
	r1		 record;
	r2		 record;
	r3		 record;
	retval 		 integer;
    BEGIN
	retval:=-1;
	select astc_codemp,astc_idptov,astc_fecval into codemp,idptov,fecval from astoctas where astc_id=astcid;
	totGInt:=0;
	totInt:=0;
	select pago::numeric(15,2) into pago1;
	for regi in select a.clq_id as idclq,a.clq_idliq as idliq,intdecarg(a.clq_cargo) as interes,a.clq_importe,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and (a.clq_importe>0 or a.clq_impngi>0 or a.clq_interes>0) and a.clq_estado=2 and a.clq_idliq is not null order by 2 
	    loop
		sumaCobrada:=0;
		importeCargo:=0;
		select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=regi.idclq;
		if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
		    sumaCobrada:=0;
		end if;
		if int4eq(regi.interes,3) then
		    importeCargo:=regi.clq_interes-sumaCobrada;
		    totInt:=totInt+importeCargo;
		else
		    if(int4eq(regi.interes,1)) then
			importeCargo:=regi.clq_importe-sumaCobrada;
			totGInt:=totGInt+importeCargo;
		    end if;
		end if;
	    end loop;

	totalPorcentual:=totInt+totGint;
	select totalPorcentual::numeric(15,2) into totalPorcentual;
--	RAISE EXCEPTION '% - %',pago1,totalPorcentual;
	if (numeric_le(pago1,totalPorcentual)) then
	    if(numeric_eq(pago1,totalPorcentual)) then
		cInt:=totInt;
		cGInt:=totGint;
	    else
		pInt:=totInt/totalPorcentual;
		pGInt:=totGInt/totalPorcentual;
		cInt:=pago1*pInt;
		cGInt:=pago1*pGInt;
		diferencia:=pago1-(cInt+cGInt);
		if numeric_ne(diferencia,0) then
		    cInt:=cInt+(diferencia);
		end if;
	    end if;
	    for r1 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_interes>0 and intdecarg(a.clq_cargo)=3 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r1.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r1.clq_interes-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(cInt,0)) then
			if numeric_ge(cInt,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r1.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    cInt:=cInt-importeCargo;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,1,cInt,fecval,date_part('month',fecval),date_part('year',fecval));
			    cInt:=0;
			end if;
		    end if;
		end loop;
	    for r2 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_importe from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_importe>0 and intdecarg(a.clq_cargo)=1 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    if numeric_ne(cInt,0) then
			cGInt:=cGInt+cInt;
		    end if;
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r2.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r2.clq_importe-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(cGInt,0)) then
			if numeric_ge(cGInt,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r2.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    cGInt:=cGInt-importeCargo;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,1,cGInt,fecval,date_part('month',fecval),date_part('year',fecval));
			    cGInt:=0;
			end if;
		    end if;
		end loop;
	    retval=1;
	else
	    restante:=pago1-totalPorcentual;
	    select restante::numeric(15,2) into restante;
	    for r1 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_interes>0 and intdecarg(a.clq_cargo)=3 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r1.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r1.clq_interes-sumaCobrada;
		    if (numeric_gt(sumaCobrada,0)) then
			update cobrxclq set cxc_estado=2 where cxc_idclq=r1.idclq and cxc_estado=1;
		    end if;
		    if numeric_gt(importeCargo,0) then
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			retval=retval+1;
		    end if;
		end loop;
	    for r2 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_importe from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_importe>0 and intdecarg(a.clq_cargo)=1 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r2.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r2.clq_importe-sumaCobrada;
		    if (numeric_gt(sumaCobrada,0)) then
			update cobrxclq set cxc_estado=2 where cxc_idclq=r2.idclq and cxc_estado=1;
		    end if;
		    if (numeric_gt(importeCargo,0)) then
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			retval=retval+1;
		    end if;
		end loop;
	    for r3 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_impngi from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_impngi>0 and intdecarg(a.clq_cargo)=2 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r3.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r3.clq_impngi-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(restante,0)) then
			if numeric_ge(restante,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r3.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r3.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    restante:=restante-importeCargo;
			    retval=retval+1;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r3.idclq,idcopr,1,restante,fecval,date_part('month',fecval),date_part('year',fecval));
			    restante:=0;
			    retval=retval+1;
			end if;
		    end if;
		end loop;
	end if;
	RETURN retval;
END;$_$;


ALTER FUNCTION public.imputocobranza(integer, numeric, integer) OWNER TO frola;

--
-- Name: imputodeuda(integer, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION imputodeuda(integer, numeric, integer, integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	deuda		 ALIAS FOR $2; 
	idliq		 ALIAS FOR $3; 
	astcidp		 ALIAS FOR $4; 
	astcid		 integer; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	sumaCobrada	 numeric(15,2);
	impcop		 numeric(15,2);
	importe		 numeric(15,2);
	deudant		 numeric(15,2);
	totint		 numeric(15,2);
	totgint		 numeric(15,2);
	totngi		 numeric(15,2);
	total		 numeric(15,2);
	porcint		 numeric(15,5);
	porcgint	 numeric(15,5);
	ctogint		 numeric(15,2);
	ctoint		 numeric(15,2);
	dif		 numeric(15,2);
	retval 		 integer;
	regi		 record;
	regis		 record;
	regist		 record;
    BEGIN

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 
	deudant:=deuda*-1;
	astcid:=astcidp*-1;
	totint:=0;
	totgint:=0;
	sumaCobrada:=0;
	select sum(clq_importe+clq_impngi+clq_interes) into impcop from compliq where clq_idliq=idliq and clq_idcopr=idcopr and (clq_importe>0 or clq_impngi>0 or clq_interes>0); 
	if (numeric_le(impcop,deudant)) then
	    --imputo todo
	    for regi in select * from compliq where clq_idliq=idliq and clq_idcopr=idcopr and (clq_importe>0 or clq_impngi>0 or clq_interes>0) 
		loop
		    importe:=regi.clq_importe+regi.clq_interes+regi.clq_impngi;
		    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regi.clq_id,2,importe,idcopr,feccie,mes,anio);
		end loop;
	else
	    -- sumo todo que genera interes porque si tiene plata a favor no puede tener interes
	    select sum(clq_importe) into totgint from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0;
	    -- si ese importe es mayor que deudant imputo todo lo que puedo en genint
	    total:=totgint;
	    if (numeric_le(deudant,total)) then
		ctogint:=deudant;
		for regis in select clq_id,clq_importe from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0 
		    loop
			importe:=regis.clq_importe;
			if (numeric_le(importe,ctogint)) then
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,2,importe,idcopr,feccie,mes,anio);
			    ctogint:=ctogint-importe;
			else
			    if (numeric_gt(ctogint,0)) then
				insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,1,ctogint,idcopr,feccie,mes,anio);
				ctogint:=0;
			    end if;
			end if;
		    end loop;
	    else
		for regis in select clq_id,clq_importe from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0 
		    loop
			importe:=regis.clq_importe;
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,2,importe,idcopr,feccie,mes,anio);
		    end loop;
		--ahora chequeo lo que no genera interes
		totngi:=deudant-total;
		for regist in select clq_id,clq_impngi from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=2 and clq_impngi>0
		    loop
			if (numeric_le(regist.clq_impngi,totngi)) then
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regist.clq_id,2,regist.clq_impngi,idcopr,feccie,mes,anio);
			    totngi:=totngi-regist.clq_impngi;
			else
			    if (numeric_gt(totngi,0)) then
				insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regist.clq_id,1,totngi,idcopr,feccie,mes,anio);
				totngi:=0;
			    end if;
			end if;
		    end loop;
	    end if;
	end if;

	RETURN;
END;$_$;


ALTER FUNCTION public.imputodeuda(integer, numeric, integer, integer) OWNER TO frola;

--
-- Name: intacum(integer, date); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION intacum(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cop_id		 ALIAS FOR $1;
	fecha		 ALIAS FOR $2;
	total		 numeric(15,2);
	fecliq		 date;
	idliqant	 integer;
	centro		 integer;
	regi		 record;
	reg		 record;
	cobint		 numeric(15,2);
	inter		 integer;

BEGIN
    total:=0;
    cobint:=0;
    for reg in select clq_id,clq_interes from compliq where clq_idcopr=cop_id and clq_fecha<=fecha and clq_estado=2 and intdecarg(clq_id)=3 and clq_interes>0 
	loop
	    total:=total+reg.clq_interes;
	    for reg in select * from cobrxclq where cxc_idclq=regi.clq_id
		loop
		    cobint:=cobint+reg.cxc_importe;
		end loop;
	end loop;

    total:=total - cobint;

RETURN total;
END;$_$;


ALTER FUNCTION public.intacum(integer, date) OWNER TO frola;

--
-- Name: intdecarg(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION intdecarg(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select car_genint from cargos where car_id= $1 ;$_$;


ALTER FUNCTION public.intdecarg(integer) OWNER TO frola;

--
-- Name: intercentro(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION intercentro(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select int_valor from interes where int_centro= $1 order by int_fecha desc limit 1;$_$;


ALTER FUNCTION public.intercentro(integer) OWNER TO frola;

--
-- Name: liquido(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION liquido(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	idptov		 integer;
	redondeo	 integer;
	retval 		 integer;
	retvalc 	 character;
    BEGIN

    retval:=0;
    select l_idptov into idptov from liquidacion where l_id=idliq;
    select ptv_redond into redondeo from ptovta where ptv_id=idptov;

    --PASO CARGOS FIJOS 
    select paso_comprop(idliq) into retvalc;

    -- DISTRIBUYO COMPLIQUID
    select prorrata(idliq) into retvalc;

    -- PASO CARGOS VARIABLES
    select paso_cvar(idliq) into retvalc;

    -- CALCULO INTERES
    select calc_intliq(idliq) into retval;

    -- CARGO TABLA LIQUI
    select cargo_liqui_lq(idliq) into retval;

    -- REDONDEO
    if (int4eq(redondeo,2)) then
	select redondeoliqui(idliq) into retval;
    end if;

    -- HAGO ASIENTO DE LIQUIDACION
    select hago_asiento_lq(idliq) into retval;

    -- CARGO TABLA AUXINT
    select cargo_auxint(idliq) into retvalc;

    -- CONFIRMO LIQUIDACION
    update liquidacion set l_estado=2 where l_id=idliq;


    -- IMPUTO CARGOS NEGATIVOS!
    select paso_cvar_neg(idliq) into retvalc;


    RETURN retval;
    END;$_$;


ALTER FUNCTION public.liquido(integer) OWNER TO frola;

--
-- Name: liquido_gf(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION liquido_gf(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	idptov		 integer;
	redondeo	 integer;
	retval 		 integer;
	retvalc 	 character;
    BEGIN

    retval:=0;
    select l_idptov into idptov from liquidacion where l_id=idliq;
    select ptv_redond into redondeo from ptovta where ptv_id=idptov;

    --REVISO MENORES Y DURACION CONTRATOS
    select reviso_grupof(idliq) into retvalc;

    --CALCULO CUOTA MAYOR Y MENOR
    select calculo_cuota(idliq) into retvalc;

    --PASO CARGOS FIJOS 
    select paso_comprop(idliq) into retvalc;

    -- DISTRIBUYO COMPLIQUID
    select prorratados(idliq) into retvalc;

    -- CALCULO RESERVA
/*    select fondo_reserva(idliq) into retvalc;*/

    -- CALCULO EXPENSAS LOCACION
    select exp_loc(idliq) into retvalc;

    -- PASO CARGOS VARIABLES
    select paso_cvar(idliq) into retvalc;

    -- CALCULO INTERES
    select calc_intliq(idliq) into retval;

    -- CARGO TABLA LIQUI
    select cargo_liqui_lq(idliq) into retval;

    -- REDONDEO ? NO!
    if (int4eq(redondeo,2)) then
	select redondeoliqui(idliq) into retval;
    end if;

    -- HAGO ASIENTO DE LIQUIDACION
    select hago_asiento_lq(idliq) into retval;

    -- CARGO TABLA AUXINT
    select cargo_auxint(idliq) into retvalc;

    -- CONFIRMO LIQUIDACION
    update liquidacion set l_estado=2 where l_id=idliq;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.liquido_gf(integer) OWNER TO frola;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO frola;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO frola;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO frola;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO frola;

--
-- Name: nomctes(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.nomctes(integer) OWNER TO frola;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO frola;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO frola;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO frola;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO frola;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nomtipcta(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO frola;

--
-- Name: nroastc(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nroastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_numero from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.nroastc(integer) OWNER TO frola;

--
-- Name: nrotalon(integer, integer, character varying, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION nrotalon(integer, integer, character varying, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	modo		ALIAS FOR $4; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
    talonario:=0;
    select comp_talon into talonario from comprob where int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_talon into talonario from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_talon into talonario from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

    if int4ne(talonario,0) then
	select tal_valor into retval from talon where int4eq(talonario,tal_id);
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.nrotalon(integer, integer, character varying, integer) OWNER TO frola;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO frola;

--
-- Name: ocdegasto(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ocdegasto(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	idgto		 ALIAS FOR $1; 
	retval		 integer;
BEGIN
    select gxo_idoc into retval from gtoxoc where gxo_idgto=idgto;
    RETURN retval;
END;$_$;


ALTER FUNCTION public.ocdegasto(integer) OWNER TO frola;

--
-- Name: operash(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION operash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_operad from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.operash(integer) OWNER TO frola;

--
-- Name: paso_comprop(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION paso_comprop(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	operador	 integer;
	idclq		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	tipo		 integer;
	genint		 integer;
	cargo		 integer;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
    if not found then
	select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('IDUF',vari_codigo);
	end if;
    end if;


    for regis in select * from comprop where cmpr_centro=centro and cmpr_estado=1 and cmpr_cargo!= cargo 
	loop
	    select car_genint into genint from cargos where car_id=regis.cmpr_cargo;
	    if int4eq(genint,1) then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq) 
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
	    else
		if int4eq(genint,2) then
		    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
		else
		    if int4eq(genint,3) then
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
			    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
		    end if;
		end if;
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_comprop(integer) OWNER TO frola;

--
-- Name: paso_cvar(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION paso_cvar(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	rtv		 integer;
	operador	 integer;
	regi		 record;
	estado		 integer;
	importe		 numeric(15,2);
	impcobr		 numeric(15,2);
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    for regi in select clq_id,clq_importe,clq_impngi,clq_interes,clq_idcopr from compliq where clq_centro=centro and clq_anio=anio and clq_mes=mes and clq_estado=1 and (clq_rubcar!=7 or (clq_rubcar=7 and (clq_importe>0 or clq_interes>0 or clq_impngi>0))) and clq_idliq is null
	loop
	    update compliq set clq_idliq=idliq where clq_id=regi.clq_id;
	end loop;
    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_cvar(integer) OWNER TO frola;

--
-- Name: paso_cvar_neg(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION paso_cvar_neg(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	rtv		 integer;
	operador	 integer;
	idastoh		 integer;
	astcid		 integer;
	regi		 record;
	estado		 integer;
	importe		 numeric(15,2);
	impcobr		 numeric(15,2);
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select ash_id into idastoh from astoh where ash_idemiti=idliq and ash_centro=centro and ash_comprob=comprob and ash_numero=numero;

    for regi in select clq_id,clq_importe,clq_impngi,clq_interes,clq_idcopr from compliq where clq_centro=centro and clq_anio=anio and clq_mes=mes and clq_estado in (1,2) and (clq_rubcar!=7 and (clq_importe<0 or clq_impngi<0 or clq_interes<0)) and clq_idliq=idliq
	loop
	    select astc_id into astcid from astoctas where astc_idastoh=idastoh and astc_tipcta=99 and astc_ctacte=regi.clq_idcopr;
	    if not found then
		astcid:=-10;
	    end if;
	    if (regi.clq_importe<0) then
		importe:=regi.clq_importe*-1;
		select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
	    else
		if (regi.clq_impngi<0) then
		    importe:=regi.clq_impngi*-1;
		    select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
		else
		    if (regi.clq_interes<0) then
			importe:=regi.clq_interes*-1;
			select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
		    end if;
		end if;
	    end if;
	end loop;
    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_cvar_neg(integer) OWNER TO frola;

--
-- Name: paso_sgto(integer, integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION paso_sgto(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		 ALIAS FOR $1; 
	idgto		 ALIAS FOR $2; 
	sgto		 integer;
	idfp		 integer;
	retval 		 integer;
	impfp 		 numeric;
	regi		 record;
    BEGIN
    retval:=1;
	select gxo_idsgto into sgto from gtoxoc where gxo_idgto=idgto;
	for regi in select * from astoctas where astc_idastoh=idastoh and astc_importe<0 
	    loop
		impfp=regi.astc_importe*-1;
		select fp_id into idfp from formapagooc where fp_estado=100 and fp_idocsg=sgto and fp_ctacble=regi.astc_ctacble and fp_importe=impfp;
		if (idfp is not null) then
		    update formapagooc set fp_estado=2 where fp_id=idfp;
		    update ocsingtos set osg_impag=osg_impag-impfp,osg_estado=2 where osg_id=sgto;
		else
		    select fp_id into idfp from formapagooc where fp_estado=100 and fp_idocsg=sgto and fp_ctacble=regi.astc_ctacble and numeric_gt(fp_importe,impfp) limit 1;
		    update formapagooc set fp_estado=2 where fp_id=idfp;
		    update ocsingtos set osg_impag=osg_impag-impfp,osg_estado=2 where osg_id=sgto;
		end if;
	    end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.paso_sgto(integer, integer) OWNER TO frola;

--
-- Name: prorrata(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION prorrata(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	operador	 integer;
	idclq		 integer;
	tipo		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	genint		 integer;
	tipouf		 integer;
	idcopr		 integer;
	importe		 numeric(15,2);
	registro	 record;
	regi		 record;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 


    for registro in select * from compliquid where cl_idliq=idliq
	loop
	select car_srubcar into srubcar from cargos where car_id=registro.cl_cargo;
	tipo:=registro.cl_tipo;
	if(int4eq(tipo,1)) then 
	    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2)
		loop
		    if int4eq(registro.cl_porc,1) then
			importe:=registro.cl_importe * regi.cop_porc1 / 100;
		    else
			if int4eq(registro.cl_porc,2) then
			    importe:=registro.cl_importe * regi.cop_porc2 / 100;
		        else
			    if int4eq(registro.cl_porc,3) then
				importe:=registro.cl_importe * regi.cop_porc3 / 100;
			    else
				if int4eq(registro.cl_porc,4) then
				    importe:=registro.cl_importe * regi.cop_porc4 / 100;
			        else
				    if int4eq(registro.cl_porc,5) then
					importe:=registro.cl_importe * regi.cop_porc5 / 100;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		    if numeric_ne(importe,0) then
			select car_genint into genint from cargos where car_id=registro.cl_cargo;
			if int4eq(genint,1) then
			    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			else
			    if int4eq(genint,2) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,3) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				end if;
			    end if;
			end if;
		    end if;
		    importe:=0;
		end loop;
	else
	    if(int4eq(tipo,2)) then 
		importe:=registro.cl_importe;
		for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2)
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
	    else
		if(int4eq(tipo,3)) then
		importe:=registro.cl_importe;
		tipouf:=registro.cl_tipuf;
		for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2) and cop_tipuf=tipouf
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
		end if;
	    end if;
	end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.prorrata(integer) OWNER TO frola;

--
-- Name: prorratados(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION prorratados(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	contr		 integer;
	operador	 integer;
	idclq		 integer;
	tipo		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	genint		 integer;
	tipouf		 integer;
	idcopr		 integer;
	precio		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargo		 integer;
	cargoMayores	 integer;
	cargoMenores	 integer;
	registro	 record;
	regi		 record;
	reg		 record;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;

    for registro in select * from compliquid where cl_idliq=idliq and cl_tipo in (1,2,3,5) 
	loop
	select car_srubcar into srubcar from cargos where car_id=registro.cl_cargo;
	tipo:=registro.cl_tipo;
	cargo:=registro.cl_cargo;
	if(int4eq(tipo,1)) then 
	    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2)
		loop
		    if int4eq(registro.cl_porc,1) then
			importe:=registro.cl_importe * regi.cop_porc1 / 100;
		    else
			if int4eq(registro.cl_porc,2) then
			    importe:=registro.cl_importe * regi.cop_porc2 / 100;
		        else
			    if int4eq(registro.cl_porc,3) then
				importe:=registro.cl_importe * regi.cop_porc3 / 100;
			    else
				if int4eq(registro.cl_porc,4) then
				    importe:=registro.cl_importe * regi.cop_porc4 / 100;
			        else
				    if int4eq(registro.cl_porc,5) then
					importe:=registro.cl_importe * regi.cop_porc5 / 100;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		    impaux:=importe;
--		    importe:=round(impaux);
		    if numeric_ne(importe,0) then
			select car_genint into genint from cargos where car_id=registro.cl_cargo;
			if int4eq(genint,1) then
			    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			else
			    if int4eq(genint,2) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,3) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				end if;
			    end if;
			end if;
		    end if;
		    importe:=0;
		end loop;
	else
	    if(int4eq(tipo,2)) then 
		importe:=registro.cl_importe;
		for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2)
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
	    else
		if(int4eq(tipo,3)) then
		    importe:=registro.cl_importe;
		    tipouf:=registro.cl_tipuf;
		    for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2) and cop_tipuf=tipouf
			loop
			    if numeric_ne(importe,0) then
				select car_genint into genint from cargos where car_id=registro.cl_cargo;
				if int4eq(genint,1) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,2) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    else
					if int4eq(genint,3) then
					    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
						values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
					end if;
				    end if;
				end if;
			    end if;
			end loop;
		else
		    if(int4eq(tipo,5) and int4eq(cargo,cargoMayores)) then
			precio:=registro.cl_importe;
			for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
			    loop
				select ct_id into contr from contratos where ct_idcopr=regi.cop_id and ct_estado=1;
				if not found then
				    for reg in select count(*) as canti from grupof_d where gf_idcopr=regi.cop_id and gf_estado=1 and gf_mayor=1 and gf_idptov=idptov 
					loop
					    importe:=precio*reg.canti;
					    if(numeric_gt(importe,0))then
						insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
						    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
					    end if;
					    importe:=0;
					end loop;
				else
				    for reg in select count(*) as canti from grupof_inq where gf_idcopr=regi.cop_id and gf_estado=1 and gf_mayor=1 and gf_idptov=idptov 
					loop
					    importe:=precio*reg.canti;
					    if(numeric_gt(importe,0))then
						insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
						    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
					    end if;
					    importe:=0;
					end loop;
				end if;
			    end loop;
		    else
			if(int4eq(tipo,5) and int4eq(cargo,cargoMenores)) then
			    precio:=registro.cl_importe;
			    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
				loop
				    select ct_id into contr from contratos where ct_idcopr=regi.cop_id and ct_estado=1;
				    if not found then
					for reg in select count(*) as canti from grupof_d where gf_idcopr=regi.cop_id and gf_estado=1 and gf_menor=1 and gf_idptov=idptov 
					    loop
						importe:=precio*reg.canti;
						if(numeric_gt(importe,0))then
						    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
							values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
						end if;
						importe:=0;
					    end loop;
				    else
					for reg in select count(*) as canti from grupof_inq where gf_idcopr=regi.cop_id and gf_estado=1 and gf_menor=1 and gf_idptov=idptov 
					    loop
						importe:=precio*reg.canti;
						if(numeric_gt(importe,0))then
						    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
							values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
						end if;
						importe:=0;
					    end loop;
				    end if;
				end loop;
			end if;
		    end if;
		end if;
	    end if;
	end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.prorratados(integer) OWNER TO frola;

--
-- Name: proxcodprov(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION proxcodprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(prov_codigo)+1 from prove where prov_codemp= $1 ;$_$;


ALTER FUNCTION public.proxcodprov(integer) OWNER TO frola;

--
-- Name: proxnumptv(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION proxnumptv(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
	if int4ne(ptovta,0) then
	    select idcomp(codemp,ptovta,comproba) into otro;
	    select max(ash_numptv)+1 into retval from astoh where int4eq(codemp,ash_codemp) and int4eq(ptovta,ash_idptov) and int4eq(otro,ash_comprob);
	  else
	    retval:= -100;
	end if;
	if(retval is null) then
	retval:= 1;
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.proxnumptv(integer, integer, character varying) OWNER TO frola;

--
-- Name: pseudoash(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION pseudoash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_pseudogrupo from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.pseudoash(integer) OWNER TO frola;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO frola;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO frola;

--
-- Name: redondeoliqui(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION redondeoliqui(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	redondeo	 integer;
	identificador	 integer;
	rubro		 integer;
	cargo		 integer;
	iduf		 integer;
	srubro		 integer;
	idclq		 integer;
	leyenda		 character varying(240);
	rubrod		 integer;
	srubrod		 integer;
	leyendad	 character varying(240);
	identif		 numeric(15,2);
	total		 numeric(15,2);
	deuda		 numeric(15,2);
	redo		 numeric(15,2);
	redop		 numeric(15,2);
	totalt		 numeric(15,2);
	retval 		 integer;
	regi		 record;
    BEGIN
	retval:=0;
	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 

	select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	    if not found then
		select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	    end if;
	end if;
	select car_rubcar, car_srubcar, car_leyen into rubro, srubro, leyenda from cargos where car_id=cargo;

	select vari_valor into iduf from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	if not found then
	    select vari_valor into iduf from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	    if not found then
		select vari_valor into iduf from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('IDUF',vari_codigo);
	    end if;
	end if;
	select car_rubcar, car_srubcar, car_leyen into rubrod, srubrod, leyendad from cargos where car_id=iduf;


	for regi in select lq_idcopr,sum(lq_importe) as impcop from liqui where lq_idliq=idliq group by 1 
	    loop
		select deudacopropid(regi.lq_idcopr,codemp,idptov) into deuda;
		redo:=regi.impcop+deuda;
		if (numeric_le(redo,0)) then
		    deuda:=0;
		else
		    select round(redo::numeric(15,2),0) into total;
		    totalt:=total-redo;
		    if (numeric_ne(totalt,0)) then
		    --insert compliq totalt y liqui
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,
						clq_anio,clq_mes,clq_fecha,clq_fecvto,
						clq_comprob,clq_numero,clq_operad,
						clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,
						clq_canti,clq_impngi,clq_precio,
						clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,
						    anio,mes,feccie,fecvto,
						    comprob,numero,operador,
						    rubro,srubro,cargo,leyenda,
						    1,totalt,totalt,regi.lq_idcopr,idliq);
			insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,
					    lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
					    values (idliq,regi.lq_idcopr,rubro,cargo,
							1,totalt,totalt,leyenda,1);
		    end if;
		    --paso identificadores pasocomprop(modo2)
		    identif:=0;
		    select cmpr_importe into identif from comprop where cmpr_idcopr=regi.lq_idcopr and cmpr_estado=1 and cmpr_cargo=iduf;
		    if found then 
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,
						clq_anio,clq_mes,clq_fecha,clq_fecvto,
						clq_comprob,clq_numero,clq_operad,
						clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,
						clq_canti,clq_impngi,clq_precio,
						clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,
						    anio,mes,feccie,fecvto,
						    comprob,numero,operador,
						    rubrod,srubrod,iduf,leyendad,
						    1,identif,identif,regi.lq_idcopr,idliq);
			insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,
					    lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
					    values (idliq,regi.lq_idcopr,rubrod,iduf,
							1,identif,identif,leyendad,1);
		    end if;
		end if;
	    end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.redondeoliqui(integer) OWNER TO frola;

--
-- Name: reviso_grupof(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION reviso_grupof(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	feccie		 date;
	minMenor	 integer;
	maxMenor	 integer;
	edad		 integer;
	duracion	 integer;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_feccie 
	into codemp,idptov,feccie from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'EDADMENORMIN') into minMenor;
    select valvaramb(codemp,idptov,'EDADMENORMAX') into maxMenor;

    edad:=0;
    for regis in select * from grupof_d where gf_mayor is null and gf_estado=1 and gf_fecnac is not null and gf_idptov=idptov 
	loop
	    select date_part('year',age(feccie,regis.gf_fecnac)) into edad;
	    if(edad>=minMenor and edad<maxMenor) then
		update grupof_d set gf_menor=1 where gf_id=regis.gf_id;
	    else
		if(edad>=maxMenor) then
		    update grupof_d set gf_mayor=1,gf_menor=NULL where gf_id=regis.gf_id;
--		else
--		    if(edad<minMenor) then
--			update grupof_d set gf_menor=NULL where gf_id=regis.gf_id;
--		    end if;
		end if;
	    end if;
	end loop;

    edad:=0;
    for regis in select * from grupof_inq where gf_mayor is null and gf_estado=1 and gf_fecnac is not null and gf_idptov=idptov 
	loop
	    select date_part('year',age(feccie,regis.gf_fecnac)) into edad;
	    if(edad>=minMenor and edad<maxMenor) then
		update grupof_inq set gf_menor=1 where gf_id=regis.gf_id;
	    else
		if(edad>=maxMenor) then
		    update grupof_inq set gf_mayor=1,gf_menor=NULL where gf_id=regis.gf_id;
--		else
--		    if(edad<minMenor) then
--			update grupof_inq set gf_menor=NULL where gf_id=regis.gf_id;
--		    end if;
		end if;
	    end if;
	end loop;

    for regis in select * from contratos where ct_inicio<=feccie and ct_fin>=feccie and ct_idptov=idptov 
	loop
	    select (date_part('year',age(feccie,regis.ct_inicio))*12 + date_part('month',age(feccie,regis.ct_inicio))) into duracion;
	    duracion:=duracion+1;
	    update contratos set ct_duracion=duracion,ct_estado=1 where ct_id=regis.ct_id;
	end loop;

    for regis in select * from contratos where (ct_fin<feccie or ct_inicio>feccie) and ct_idptov=idptov 
	loop
	    update contratos set ct_estado=9 where ct_id=regis.ct_id;
	    update grupof_inq set gf_estado=999 where gf_idcontr=regis.ct_id;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.reviso_grupof(integer) OWNER TO frola;

--
-- Name: saldocbl(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION saldocbl(integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	cuenta		ALIAS FOR $3; 
	fechad		ALIAS FOR $4;
	retval 		numeric;
    BEGIN
    if int4eq(codemp,-1) then
	    select sum(astc_importe) into retval from astoctas 
		where astc_ctacble=cuenta and astc_fecval< fechad and astc_estado=2 and codcomp(astc_comprob)!='AR' and codptv(astc_idptov)!=9999;
        else
	    if int4eq(ptovta,0) then
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_ctacble=cuenta 
			    and astc_estado=2 and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval< fechad and codptv(astc_idptov)!=9999;
    		else
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_idptov=ptovta  
			    and astc_ctacble=cuenta and astc_estado=2 and codcomp(astc_comprob) not in ('AR','Ar') 
			    and astc_fecval< fechad  and codptv(astc_idptov)!=9999;
	    end if;
    end if;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldocbl(integer, integer, integer, date) OWNER TO estlm;

--
-- Name: salgrup(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION salgrup(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	tipcta		ALIAS FOR $2;
	ctacte		ALIAS FOR $3;
	grupo		ALIAS FOR $4;
	esisti		integer;
	retval 		numeric;
    BEGIN
    if int4eq(grupo,0) then
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo is null;
	else
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo=grupo;
    end if;

    if not found then
	retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.salgrup(integer, integer, integer, integer) OWNER TO estlm;

--
-- Name: tabladin(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION tabladin(integer) RETURNS character
    LANGUAGE sql
    AS $_$select dlq_tabla from descripliq where dlq_id= $1 ;$_$;


ALTER FUNCTION public.tabladin(integer) OWNER TO frola;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO frola;

--
-- Name: tipprove(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION tipprove(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_tipo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.tipprove(integer) OWNER TO frola;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO frola;

--
-- Name: totenchq(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION totenchq(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(chq_importe)::numeric(15,2) 
    from cheques where chq_idastoc= $1 ;$_$;


ALTER FUNCTION public.totenchq(integer) OWNER TO frola;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO frola;

--
-- Name: ultcie(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION ultcie(integer) RETURNS date
    LANGUAGE sql
    AS $_$select l_feccie from liquidacion where l_estado=1 and l_centro= $1 order by 1 desc limit 1;$_$;


ALTER FUNCTION public.ultcie(integer) OWNER TO frola;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select vari_valor into retval from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO frola;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: amenity; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE amenity (
    am_id integer NOT NULL,
    am_codemp integer NOT NULL,
    am_idptov integer NOT NULL,
    am_division integer NOT NULL,
    am_centro integer NOT NULL,
    am_nombre character varying(150) NOT NULL,
    am_cargo integer NOT NULL,
    am_descripcion text,
    am_duracion numeric,
    am_cantidad numeric,
    am_precio numeric(15,2),
    am_color character varying(7),
    am_img bytea,
    am_estado integer DEFAULT 1
);


ALTER TABLE amenity OWNER TO frola;

--
-- Name: amenity_am_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE amenity_am_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE amenity_am_id_seq OWNER TO frola;

--
-- Name: amenity_am_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE amenity_am_id_seq OWNED BY amenity.am_id;


SET default_with_oids = true;

--
-- Name: articvta; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codigo smallint,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_stock numeric(15,5),
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_present numeric(15,5),
    art_peso numeric(15,5),
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_idptov integer DEFAULT 0 NOT NULL,
    art_precio_unique numeric(15,5),
    art_codemp integer DEFAULT 0 NOT NULL,
    art_codi character varying(20),
    art_nombre character varying(140),
    art_leyen text,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codsrb integer,
    art_codcbl integer,
    art_funcion text,
    art_precio numeric(15,5) DEFAULT 0,
    art_idcbl integer
);


ALTER TABLE articvta OWNER TO frola;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articvta_art_id_seq OWNER TO frola;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


SET default_with_oids = false;

--
-- Name: astcconccble; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE astcconccble (
    accb_id integer NOT NULL,
    accb_idccbl integer NOT NULL,
    accb_idastc integer NOT NULL,
    accb_estado integer DEFAULT 1
);


ALTER TABLE astcconccble OWNER TO frola;

--
-- Name: astcconccble_accb_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE astcconccble_accb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astcconccble_accb_id_seq OWNER TO frola;

--
-- Name: astcconccble_accb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE astcconccble_accb_id_seq OWNED BY astcconccble.accb_id;


SET default_with_oids = true;

--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer NOT NULL,
    astc_division integer,
    astc_centro integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(15,2) DEFAULT 0,
    astc_cotiza numeric(15,5) DEFAULT 0,
    astc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(15,5),
    astc_leyen character varying(100),
    astc_idashce integer,
    astc_idgto integer
);


ALTER TABLE astoctas OWNER TO frola;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoctas_astc_id_seq OWNER TO frola;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer NOT NULL,
    ash_division integer,
    ash_centro integer,
    ash_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    ash_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer,
    ash_numptv integer,
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date,
    ash_titulo character varying(200),
    ash_idasoc integer,
    ash_pseudogrupo integer,
    ash_nro2 integer
);


ALTER TABLE astoh OWNER TO frola;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoh_ash_id_seq OWNER TO frola;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


--
-- Name: auxint; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE auxint (
    ai_id integer NOT NULL,
    ai_idliq integer NOT NULL,
    ai_idcopr integer NOT NULL,
    ai_impgi numeric(15,2) DEFAULT 0,
    ai_impngi numeric(15,2) DEFAULT 0,
    ai_intacu numeric(15,2) DEFAULT 0,
    ai_estado integer DEFAULT 1
);


ALTER TABLE auxint OWNER TO frola;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE auxint_ai_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxint_ai_id_seq OWNER TO frola;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE auxint_ai_id_seq OWNED BY auxint.ai_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(140) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE bancos OWNER TO frola;

--
-- Name: cambtitu; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE cambtitu (
    cbt_id integer NOT NULL,
    cbt_codemp integer NOT NULL,
    cbt_idptov integer NOT NULL,
    cbt_division integer,
    cbt_centro integer,
    cbt_unifun integer,
    cbt_idcopr integer NOT NULL,
    cbt_nombre character varying(240) NOT NULL,
    cbt_direcc character varying(240),
    cbt_locali character varying(240),
    cbt_codpos character varying(10),
    cbt_provin integer,
    cbt_telefono character varying(180),
    cbt_mail character varying(180),
    cbt_fecha date DEFAULT date(now()),
    cbt_tipdoc character varying(10),
    cbt_nrodoc integer,
    cbt_nrcuit character varying(20),
    cbt_leyen text,
    cbt_operador integer
);


ALTER TABLE cambtitu OWNER TO frola;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE cambtitu_cbt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cambtitu_cbt_id_seq OWNER TO frola;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE cambtitu_cbt_id_seq OWNED BY cambtitu.cbt_id;


--
-- Name: cargos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE cargos (
    car_id integer NOT NULL,
    car_codemp integer DEFAULT 0 NOT NULL,
    car_idptov integer,
    car_division integer,
    car_centro integer,
    car_codigo integer,
    car_nombre character varying(340),
    car_rubcar integer,
    car_srubcar integer,
    car_genint integer DEFAULT 1 NOT NULL,
    car_interes numeric(15,5) DEFAULT 1,
    car_precio numeric(15,5) DEFAULT 0,
    car_tasa numeric(15,5) DEFAULT 0,
    car_estado integer DEFAULT 1,
    car_funcion text,
    car_leyen text,
    car_ctacble integer NOT NULL
);


ALTER TABLE cargos OWNER TO frola;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE cargos_car_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cargos_car_id_seq OWNER TO frola;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE cargos_car_id_seq OWNED BY cargos.car_id;


--
-- Name: categincid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE categincid (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(150) NOT NULL,
    cat_estado integer DEFAULT 1
);


ALTER TABLE categincid OWNER TO frola;

--
-- Name: categincid_cat_codigo_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE categincid_cat_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE categincid_cat_codigo_seq OWNER TO frola;

--
-- Name: categincid_cat_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE categincid_cat_codigo_seq OWNED BY categincid.cat_codigo;


--
-- Name: catego; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE catego (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(140) NOT NULL
);


ALTER TABLE catego OWNER TO frola;

--
-- Name: centroc; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE centroc (
    cco_id integer NOT NULL,
    cco_codemp integer NOT NULL,
    cco_idptov integer NOT NULL,
    cco_coddiv integer,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(140),
    cco_porcpro numeric(15,6)
);


ALTER TABLE centroc OWNER TO frola;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE centroc_cco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE centroc_cco_id_seq OWNER TO frola;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE centroc_cco_id_seq OWNED BY centroc.cco_id;


--
-- Name: chat; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE chat (
    c_id integer NOT NULL,
    c_message text NOT NULL,
    c_sent timestamp without time zone DEFAULT now() NOT NULL,
    c_recd integer DEFAULT 0 NOT NULL,
    c_from integer,
    c_to integer
);


ALTER TABLE chat OWNER TO frola;

--
-- Name: chat_c_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE chat_c_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chat_c_id_seq OWNER TO frola;

--
-- Name: chat_c_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE chat_c_id_seq OWNED BY chat.c_id;


--
-- Name: cheques; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer DEFAULT 0 NOT NULL,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(15,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text,
    chq_idocsg integer
);


ALTER TABLE cheques OWNER TO frola;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cheques_chq_id_seq OWNER TO frola;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


--
-- Name: chequesaux; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE chequesaux (
    cqa_grupo integer NOT NULL,
    cqa_idchq integer NOT NULL,
    cqa_id integer NOT NULL
);


ALTER TABLE chequesaux OWNER TO frola;

--
-- Name: chequesaux_cqa_grupo_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE chequesaux_cqa_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chequesaux_cqa_grupo_seq OWNER TO frola;

--
-- Name: chequesaux_cqa_grupo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE chequesaux_cqa_grupo_seq OWNED BY chequesaux.cqa_grupo;


--
-- Name: chequesaux_cqa_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE chequesaux_cqa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chequesaux_cqa_id_seq OWNER TO frola;

--
-- Name: chequesaux_cqa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE chequesaux_cqa_id_seq OWNED BY chequesaux.cqa_id;


--
-- Name: chqrech; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE chqrech (
    chqr_id integer NOT NULL,
    chqr_cliente integer DEFAULT 1,
    chqr_idchq integer,
    chqr_idastoh integer,
    chqr_idastohc integer,
    chqr_texto text,
    chqr_estado smallint DEFAULT 1
);


ALTER TABLE chqrech OWNER TO frola;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE chqrech_chqr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chqrech_chqr_id_seq OWNER TO frola;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE chqrech_chqr_id_seq OWNED BY chqrech.chqr_id;


SET default_with_oids = false;

--
-- Name: cobrxclq; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE cobrxclq (
    cxc_id integer NOT NULL,
    cxc_idastoc integer DEFAULT 0 NOT NULL,
    cxc_idclq integer,
    cxc_estado integer,
    cxc_importe numeric(15,5) DEFAULT 0,
    cxc_idcopr integer,
    cxc_fecha date,
    cxc_mes integer,
    cxc_anio integer
);


ALTER TABLE cobrxclq OWNER TO frola;

--
-- Name: cobrxclq_cxc_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE cobrxclq_cxc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cobrxclq_cxc_id_seq OWNER TO frola;

--
-- Name: cobrxclq_cxc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE cobrxclq_cxc_id_seq OWNED BY cobrxclq.cxc_id;


SET default_with_oids = true;

--
-- Name: compliq; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE compliq (
    clq_id integer NOT NULL,
    clq_codemp integer NOT NULL,
    clq_idptov integer NOT NULL,
    clq_division integer,
    clq_centro integer,
    clq_idcopr integer NOT NULL,
    clq_fecha date DEFAULT date(now()),
    clq_fecvto date DEFAULT date(now()),
    clq_anio integer DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    clq_mes integer DEFAULT date_part('month'::text, date(now())) NOT NULL,
    clq_comprob integer,
    clq_numero integer,
    clq_idliq integer,
    clq_rubcar integer NOT NULL,
    clq_cargo integer NOT NULL,
    clq_canti numeric(15,5) DEFAULT 1,
    clq_precio numeric(15,5) DEFAULT 0,
    clq_importe numeric(15,2) DEFAULT 0,
    clq_impngi numeric(15,2) DEFAULT 0,
    clq_interes numeric(15,5) DEFAULT 0,
    clq_estado integer DEFAULT 1,
    clq_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    clq_operad integer,
    clq_leyen text,
    clq_pseudogrupo integer,
    clq_srubcar integer NOT NULL,
    clq_idastoc integer
);


ALTER TABLE compliq OWNER TO frola;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE compliq_clq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compliq_clq_id_seq OWNER TO frola;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE compliq_clq_id_seq OWNED BY compliq.clq_id;


--
-- Name: compliquid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE compliquid (
    cl_id integer NOT NULL,
    cl_idliq integer NOT NULL,
    cl_rubcar integer,
    cl_cargo integer,
    cl_porc integer DEFAULT 1 NOT NULL,
    cl_leyen character varying(240),
    cl_importe numeric(15,2) DEFAULT 0,
    cl_estado integer DEFAULT 1 NOT NULL,
    cl_tipo integer DEFAULT 1,
    cl_tipuf integer
);


ALTER TABLE compliquid OWNER TO frola;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE compliquid_cl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compliquid_cl_id_seq OWNER TO frola;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE compliquid_cl_id_seq OWNED BY compliquid.cl_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer DEFAULT 0 NOT NULL,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(140),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(15,2) DEFAULT 0
);


ALTER TABLE compra OWNER TO frola;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compra_cpra_id_seq OWNER TO frola;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(140) NOT NULL,
    comp_codemp integer DEFAULT 0 NOT NULL,
    comp_idptov integer DEFAULT 0 NOT NULL,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text
);


ALTER TABLE comprob OWNER TO frola;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprob_comp_id_seq OWNER TO frola;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: comprop; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE comprop (
    cmpr_id integer NOT NULL,
    cmpr_codemp integer NOT NULL,
    cmpr_idptov integer NOT NULL,
    cmpr_division integer,
    cmpr_centro integer,
    cmpr_idcopr integer NOT NULL,
    cmpr_rubcar integer NOT NULL,
    cmpr_cargo integer NOT NULL,
    cmpr_canti numeric(15,5) DEFAULT 1,
    cmpr_precio numeric(15,5) DEFAULT 0,
    cmpr_importe numeric(15,2) DEFAULT 0,
    cmpr_estado integer DEFAULT 1,
    cmpr_fecalt date DEFAULT date(now()) NOT NULL,
    cmpr_fecbaj date,
    clq_leyen text,
    cmpr_srubcar integer NOT NULL
);


ALTER TABLE comprop OWNER TO frola;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE comprop_cmpr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprop_cmpr_id_seq OWNER TO frola;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE comprop_cmpr_id_seq OWNED BY comprop.cmpr_id;


SET default_with_oids = false;

--
-- Name: conccble; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE conccble (
    ccbl_id integer NOT NULL,
    ccbl_ctacble integer NOT NULL,
    ccbl_fecha timestamp without time zone DEFAULT now() NOT NULL,
    ccbl_salant numeric(20,5) DEFAULT 0,
    ccbl_salcon numeric(20,5) DEFAULT 0,
    ccbl_leyen text DEFAULT 0,
    ccbl_operad integer NOT NULL,
    ccbl_estado integer DEFAULT 1,
    ccbl_idptov integer DEFAULT (-1) NOT NULL
);


ALTER TABLE conccble OWNER TO frola;

--
-- Name: conccble_ccbl_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE conccble_ccbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conccble_ccbl_id_seq OWNER TO frola;

--
-- Name: conccble_ccbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE conccble_ccbl_id_seq OWNED BY conccble.ccbl_id;


SET default_with_oids = true;

--
-- Name: concilia; Type: TABLE; Schema: public; Owner: elm; Tablespace: 
--

CREATE TABLE concilia (
    clia_id integer NOT NULL,
    clia_cte integer NOT NULL,
    clia_fecha timestamp without time zone DEFAULT now() NOT NULL,
    clia_idastcg integer,
    clia_salant numeric(20,5) DEFAULT 0,
    clia_salcon numeric(20,5) DEFAULT 0,
    clia_grav numeric(20,5) DEFAULT 0,
    clia_iva numeric(20,5) DEFAULT 0,
    clia_ngrab numeric(20,5) DEFAULT 0,
    clia_piibb numeric(20,5) DEFAULT 0,
    clia_sircreb numeric(20,5) DEFAULT 0,
    clia_leyd numeric(20,5) DEFAULT 0,
    clia_leyc numeric(20,5) DEFAULT 0,
    clia_operad integer NOT NULL,
    clia_estado integer DEFAULT 1,
    clia_fechacon date
);


ALTER TABLE concilia OWNER TO elm;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE; Schema: public; Owner: elm
--

CREATE SEQUENCE concilia_clia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE concilia_clia_id_seq OWNER TO elm;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: elm
--

ALTER SEQUENCE concilia_clia_id_seq OWNED BY concilia.clia_id;


--
-- Name: coniva; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(140) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


ALTER TABLE coniva OWNER TO frola;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_nombre character varying(140) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE conpag OWNER TO frola;

--
-- Name: contratos; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE contratos (
    ct_id integer NOT NULL,
    ct_idptov integer NOT NULL,
    ct_idcopr integer NOT NULL,
    ct_duracion integer,
    ct_inicio date,
    ct_fin date,
    ct_estado integer DEFAULT 1 NOT NULL,
    ct_inicioreal date,
    ct_modo integer DEFAULT 1
);


ALTER TABLE contratos OWNER TO frola;

--
-- Name: contratos_ct_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE contratos_ct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contratos_ct_id_seq OWNER TO frola;

--
-- Name: contratos_ct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE contratos_ct_id_seq OWNED BY contratos.ct_id;


--
-- Name: convenios; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE convenios (
    con_id integer NOT NULL,
    con_codemp integer DEFAULT 0 NOT NULL,
    con_idptov integer NOT NULL,
    con_division integer NOT NULL,
    con_centro integer NOT NULL,
    con_idcopr integer NOT NULL,
    con_comprob integer NOT NULL,
    con_numero integer,
    con_monto numeric(15,5) DEFAULT 0,
    con_fechai date DEFAULT date(now()),
    con_fechaf date DEFAULT date(now()),
    con_cuotas integer DEFAULT 1,
    con_operador integer,
    con_leyen text
);


ALTER TABLE convenios OWNER TO frola;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE convenios_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE convenios_con_id_seq OWNER TO frola;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE convenios_con_id_seq OWNED BY convenios.con_id;


--
-- Name: conxclia; Type: TABLE; Schema: public; Owner: elm; Tablespace: 
--

CREATE TABLE conxclia (
    cxlia_id integer NOT NULL,
    cxlia_idclia integer NOT NULL,
    cxlia_idastc integer NOT NULL,
    cxlia_importe numeric(20,5) DEFAULT 0,
    cxlia_estado integer DEFAULT 1
);


ALTER TABLE conxclia OWNER TO elm;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE; Schema: public; Owner: elm
--

CREATE SEQUENCE conxcxlia_cxlia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conxcxlia_cxlia_id_seq OWNER TO elm;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: elm
--

ALTER SEQUENCE conxcxlia_cxlia_id_seq OWNED BY conxclia.cxlia_id;


--
-- Name: coprop; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE coprop (
    cop_id integer NOT NULL,
    cop_codemp integer NOT NULL,
    cop_idptov integer NOT NULL,
    cop_unifun integer NOT NULL,
    cop_nombre character varying(140),
    cop_codaso integer,
    cop_porc1 numeric(15,6),
    cop_porc2 numeric(15,6),
    cop_porc3 numeric(15,6),
    cop_porc4 numeric(15,6),
    cop_porc5 numeric(15,6),
    cop_direcc character varying(160),
    cop_locali character varying(160),
    cop_codpos character varying(10),
    cop_provin integer,
    cop_descuf character varying(160),
    cop_tipuf integer,
    cop_coniva integer,
    cop_nrcuit character varying(20),
    cop_tipdoc character varying(10),
    cop_nrodoc integer,
    cop_grupo integer DEFAULT 1,
    cop_estado integer DEFAULT 1 NOT NULL,
    cop_mail character varying(300) DEFAULT 1,
    cop_inter numeric(15,5) DEFAULT 0,
    cop_recib integer DEFAULT 1,
    cop_centro integer,
    cop_division integer,
    cop_supert numeric(15,5) DEFAULT 0,
    cop_superc numeric(15,5) DEFAULT 0,
    cop_supersc numeric(15,5) DEFAULT 0
);


ALTER TABLE coprop OWNER TO frola;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE coprop_cop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coprop_cop_id_seq OWNER TO frola;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE coprop_cop_id_seq OWNED BY coprop.cop_id;


--
-- Name: cotiza; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


ALTER TABLE cotiza OWNER TO frola;

--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer DEFAULT 0 NOT NULL,
    cbl_idptov integer DEFAULT 0 NOT NULL,
    cbl_divis integer,
    cbl_centro integer,
    cbl_codigo smallint NOT NULL,
    cbl_nombre character varying(140) NOT NULL,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint,
    cbl_present character varying(100)
);


ALTER TABLE ctacble OWNER TO frola;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctacble_cbl_id_seq OWNER TO frola;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctasconv; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ctasconv (
    ctc_id integer NOT NULL,
    ctc_idconv integer NOT NULL,
    ctc_cuota integer DEFAULT 1,
    ctc_fecha date DEFAULT date(now()),
    ctc_importe numeric(15,5) DEFAULT 0,
    ctc_leyen text
);


ALTER TABLE ctasconv OWNER TO frola;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ctasconv_ctc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctasconv_ctc_id_seq OWNER TO frola;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ctasconv_ctc_id_seq OWNED BY ctasconv.ctc_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer DEFAULT 0 NOT NULL,
    cte_idptov integer DEFAULT 0 NOT NULL,
    cte_centro integer DEFAULT 0,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(140),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1,
    cte_idtabla integer,
    cte_division integer
);


ALTER TABLE ctes OWNER TO frola;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctes_cte_id_seq OWNER TO frola;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


SET default_with_oids = false;

--
-- Name: descripliq; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE descripliq (
    dlq_id integer NOT NULL,
    dlq_descripcion character varying(180) NOT NULL,
    dlq_oblig integer DEFAULT 0,
    dlq_estado integer DEFAULT 1 NOT NULL,
    dlq_tabla character varying(50),
    dlq_campo character varying(50)
);


ALTER TABLE descripliq OWNER TO frola;

--
-- Name: descripliq_dlq_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE descripliq_dlq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE descripliq_dlq_id_seq OWNER TO frola;

--
-- Name: descripliq_dlq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE descripliq_dlq_id_seq OWNED BY descripliq.dlq_id;


--
-- Name: dinicial; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE dinicial (
    din_id integer NOT NULL,
    din_idsaldos integer DEFAULT 0 NOT NULL,
    din_iddesc integer
);


ALTER TABLE dinicial OWNER TO frola;

--
-- Name: dinicial_din_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE dinicial_din_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE dinicial_din_id_seq OWNER TO frola;

--
-- Name: dinicial_din_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE dinicial_din_id_seq OWNED BY dinicial.din_id;


SET default_with_oids = true;

--
-- Name: division; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE division (
    div_id integer NOT NULL,
    div_codemp integer NOT NULL,
    div_idptov integer NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(140)
);


ALTER TABLE division OWNER TO frola;

--
-- Name: division_div_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE division_div_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE division_div_id_seq OWNER TO frola;

--
-- Name: division_div_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE division_div_id_seq OWNED BY division.div_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer DEFAULT 0 NOT NULL,
    doc_idptov integer DEFAULT 0 NOT NULL,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE docum OWNER TO frola;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE docum_doc_id_seq OWNER TO frola;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


--
-- Name: emiti; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer NOT NULL,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcliptov integer,
    emi_succli integer,
    emi_nomcli character varying(140),
    emi_conivac smallint,
    emi_nrocuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_zona integer,
    emi_desre numeric(15,2) DEFAULT 0,
    emi_total numeric(15,2) DEFAULT 0,
    emi_retiro integer,
    emi_estado smallint DEFAULT 1,
    emi_leyen text
);


ALTER TABLE emiti OWNER TO frola;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE emiti_emi_id_seq OWNER TO frola;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(140) NOT NULL,
    emp_direcc character varying(160),
    emp_locali character varying(160),
    emp_codpos character varying(10),
    emp_provin integer DEFAULT 1,
    emp_pais smallint DEFAULT 200,
    emp_nrcuit character varying(20),
    emp_estado smallint DEFAULT 1,
    emp_tipo smallint DEFAULT 1,
    emp_coniva smallint DEFAULT 1,
    emp_anti date DEFAULT date(now()),
    emp_fecint date,
    emp_grupo integer DEFAULT 1,
    emp_redond smallint DEFAULT 1,
    emp_nomabr character varying(70)
);


ALTER TABLE empresa OWNER TO frola;

--
-- Name: entidad; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE entidad (
    ent_id integer NOT NULL,
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(140)
);


ALTER TABLE entidad OWNER TO frola;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE entidad_ent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE entidad_ent_id_seq OWNER TO frola;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE entidad_ent_id_seq OWNED BY entidad.ent_id;


--
-- Name: estincid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE estincid (
    est_codigo integer NOT NULL,
    est_nombre character varying(150) NOT NULL,
    est_estado integer DEFAULT 1
);


ALTER TABLE estincid OWNER TO frola;

--
-- Name: estincid_est_codigo_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE estincid_est_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE estincid_est_codigo_seq OWNER TO frola;

--
-- Name: estincid_est_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE estincid_est_codigo_seq OWNED BY estincid.est_codigo;


--
-- Name: estjud; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE estjud (
    etj_codigo integer NOT NULL,
    etj_nombre character varying(240) NOT NULL
);


ALTER TABLE estjud OWNER TO frola;

--
-- Name: estjurid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE estjurid (
    est_codigo integer NOT NULL,
    est_nombre character varying(240) NOT NULL,
    est_codemp integer
);


ALTER TABLE estjurid OWNER TO frola;

SET default_with_oids = false;

--
-- Name: eventos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE eventos (
    evt_id integer NOT NULL,
    evt_codemp integer NOT NULL,
    evt_idptov integer NOT NULL,
    evt_division integer NOT NULL,
    evt_centro integer NOT NULL,
    evt_idcopr integer NOT NULL,
    evt_idamenity integer NOT NULL,
    evt_horad time without time zone,
    evt_horah time without time zone,
    evt_fecha date,
    evt_cantidad numeric,
    evt_estado integer DEFAULT (-1)
);


ALTER TABLE eventos OWNER TO frola;

--
-- Name: eventos_evt_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE eventos_evt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE eventos_evt_id_seq OWNER TO frola;

--
-- Name: eventos_evt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE eventos_evt_id_seq OWNED BY eventos.evt_id;


SET default_with_oids = true;

--
-- Name: factpend; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE factpend (
    fap_id integer NOT NULL,
    fap_codemp integer DEFAULT 0 NOT NULL,
    fap_idptov integer DEFAULT 0 NOT NULL,
    fap_division integer DEFAULT 0 NOT NULL,
    fap_centro integer DEFAULT 0 NOT NULL,
    fap_rubro integer NOT NULL,
    fap_subrub integer NOT NULL,
    fap_lecomp character varying(30),
    fap_sucomp integer,
    fap_nucomp integer,
    fap_hayfac integer DEFAULT 1,
    fap_factur character varying(100),
    fap_prove integer,
    fap_nprove character varying(100),
    fap_cuitprov character varying(20),
    fap_coniva integer,
    fap_importe numeric(15,2) DEFAULT 0,
    fap_impag numeric(15,2) DEFAULT 0,
    fap_fecori date,
    fap_fecval date NOT NULL,
    fap_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    fap_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    fap_vencim date,
    fap_proxv date,
    fap_leyen text,
    fap_estado integer DEFAULT 1,
    fap_idgto integer,
    fap_operador integer,
    fap_fecreg timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE factpend OWNER TO frola;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE factpend_fap_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE factpend_fap_id_seq OWNER TO frola;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE factpend_fap_id_seq OWNED BY factpend.fap_id;


--
-- Name: firman; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(140) NOT NULL,
    fir_direcc character varying(160),
    fir_locali character varying(160),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE firman OWNER TO frola;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE firman_fir_id_seq OWNER TO frola;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


--
-- Name: formapagooc; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE formapagooc (
    fp_id integer NOT NULL,
    fp_idocsg integer NOT NULL,
    fp_codemp integer NOT NULL,
    fp_idptov integer NOT NULL,
    fp_division integer,
    fp_centro integer,
    fp_fecval date NOT NULL,
    fp_ctacble integer NOT NULL,
    fp_moneda smallint DEFAULT 1 NOT NULL,
    fp_valor numeric(15,2) DEFAULT 0,
    fp_cotiza numeric(15,5) DEFAULT 0,
    fp_importe numeric(15,2) DEFAULT 0 NOT NULL,
    fp_tipcta integer,
    fp_ctacte integer,
    fp_nucheq integer DEFAULT 0,
    fp_fecvto date,
    fp_estado smallint DEFAULT 1 NOT NULL,
    fp_tasa numeric(15,5),
    fp_leyen character varying(100),
    fp_idoc integer
);


ALTER TABLE formapagooc OWNER TO frola;

--
-- Name: formapagooc_fp_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE formapagooc_fp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE formapagooc_fp_id_seq OWNER TO frola;

--
-- Name: formapagooc_fp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE formapagooc_fp_id_seq OWNED BY formapagooc.fp_id;


--
-- Name: gastos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE gastos (
    gto_id integer NOT NULL,
    gto_idastoh integer NOT NULL,
    gto_codemp integer DEFAULT 0 NOT NULL,
    gto_idptov integer DEFAULT 0 NOT NULL,
    gto_comprob integer NOT NULL,
    gto_numero integer,
    gto_centro integer DEFAULT 0 NOT NULL,
    gto_rubro integer NOT NULL,
    gto_subrub integer NOT NULL,
    gto_lecomp character varying(30),
    gto_sucomp integer,
    gto_nucomp integer,
    gto_fecori date,
    gto_fecval date NOT NULL,
    gto_hayfac integer DEFAULT 1,
    gto_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gto_prove integer,
    gto_nprove character varying(100),
    gto_cuitprov character varying(20),
    gto_coniva integer,
    gto_factur character varying(100),
    gto_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    gto_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    gto_estado integer DEFAULT 1,
    gto_impag numeric(15,2) DEFAULT 0,
    gto_importe numeric(15,2) DEFAULT 0,
    gto_operador integer,
    gto_proxv date,
    gto_leyen text,
    gto_division integer NOT NULL,
    gto_tipgto integer DEFAULT 1 NOT NULL
);


ALTER TABLE gastos OWNER TO frola;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE gastos_gto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gastos_gto_id_seq OWNER TO frola;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE gastos_gto_id_seq OWNED BY gastos.gto_id;


--
-- Name: grupof_d; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE grupof_d (
    gf_id integer NOT NULL,
    gf_idptov integer NOT NULL,
    gf_idcopr integer NOT NULL,
    gf_mayor integer,
    gf_menor integer,
    gf_fecnac date,
    gf_nombre character varying(255) DEFAULT ''::character varying NOT NULL,
    gf_nrodoc character varying(15) DEFAULT ''::character varying NOT NULL,
    gf_tipdoc integer,
    gf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE grupof_d OWNER TO frola;

--
-- Name: grupof_d_gf_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE grupof_d_gf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupof_d_gf_id_seq OWNER TO frola;

--
-- Name: grupof_d_gf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE grupof_d_gf_id_seq OWNED BY grupof_d.gf_id;


--
-- Name: grupof_inq; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE grupof_inq (
    gf_id integer NOT NULL,
    gf_idptov integer NOT NULL,
    gf_idcopr integer NOT NULL,
    gf_idcontr integer NOT NULL,
    gf_mayor integer,
    gf_menor integer,
    gf_fecnac date,
    gf_nombre character varying(255) DEFAULT ''::character varying NOT NULL,
    gf_nrodoc character varying(15) DEFAULT ''::character varying NOT NULL,
    gf_tipdoc integer,
    gf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE grupof_inq OWNER TO frola;

--
-- Name: grupof_inq_gf_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE grupof_inq_gf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupof_inq_gf_id_seq OWNER TO frola;

--
-- Name: grupof_inq_gf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE grupof_inq_gf_id_seq OWNED BY grupof_inq.gf_id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(140) NOT NULL
);


ALTER TABLE grupos OWNER TO frola;

--
-- Name: gtoxliqe; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE gtoxliqe (
    gxl_liqegr integer NOT NULL,
    gxl_gasto integer NOT NULL,
    gxl_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gxl_operador integer,
    eg_leyena text,
    eg_leyen text
);


ALTER TABLE gtoxliqe OWNER TO frola;

SET default_with_oids = false;

--
-- Name: gtoxoc; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE gtoxoc (
    gxo_id integer NOT NULL,
    gxo_idgto integer NOT NULL,
    gxo_idoc integer NOT NULL,
    gxo_idsgto integer
);


ALTER TABLE gtoxoc OWNER TO frola;

--
-- Name: gtoxoc_gxo_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE gtoxoc_gxo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gtoxoc_gxo_id_seq OWNER TO frola;

--
-- Name: gtoxoc_gxo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE gtoxoc_gxo_id_seq OWNED BY gtoxoc.gxo_id;


SET default_with_oids = true;

--
-- Name: honorarios; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE honorarios (
    hon_id integer NOT NULL,
    hon_codemp integer DEFAULT 1 NOT NULL,
    hon_idptov integer DEFAULT 0 NOT NULL,
    hon_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    hon_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    hon_rubro integer,
    hon_subrub integer,
    hon_centroc integer DEFAULT 1 NOT NULL,
    hon_importe numeric(15,5) DEFAULT 0,
    hon_estado integer DEFAULT 1,
    hon_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    hon_fecgrab timestamp without time zone,
    hon_comprob integer,
    hon_sucu integer,
    hon_ccadm integer NOT NULL,
    hon_division integer DEFAULT 0 NOT NULL
);


ALTER TABLE honorarios OWNER TO frola;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE honorarios_hon_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE honorarios_hon_id_seq OWNER TO frola;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE honorarios_hon_id_seq OWNED BY honorarios.hon_id;


--
-- Name: imgincid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE imgincid (
    img_codigo integer NOT NULL,
    img_idinc integer NOT NULL,
    img_file bytea
);


ALTER TABLE imgincid OWNER TO frola;

--
-- Name: imgincid_img_codigo_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE imgincid_img_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE imgincid_img_codigo_seq OWNER TO frola;

--
-- Name: imgincid_img_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE imgincid_img_codigo_seq OWNED BY imgincid.img_codigo;


--
-- Name: importoliq; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE importoliq (
    imp_id integer NOT NULL,
    imp_codemp integer NOT NULL,
    imp_idptov integer NOT NULL,
    imp_division integer,
    imp_centro integer,
    imp_anio integer DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    imp_mes integer DEFAULT date_part('month'::text, date(now())) NOT NULL,
    imp_estado integer DEFAULT (-1)
);


ALTER TABLE importoliq OWNER TO frola;

--
-- Name: importoliq_imp_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE importoliq_imp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE importoliq_imp_id_seq OWNER TO frola;

--
-- Name: importoliq_imp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE importoliq_imp_id_seq OWNED BY importoliq.imp_id;


--
-- Name: incidencias; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE incidencias (
    in_id integer NOT NULL,
    in_codemp integer NOT NULL,
    in_idptov integer NOT NULL,
    in_idcopr integer,
    in_asunto text,
    in_visibilidad integer,
    in_categoria integer,
    in_estado integer DEFAULT 1,
    in_codigo integer NOT NULL,
    in_anio integer NOT NULL,
    in_fechaest date
);


ALTER TABLE incidencias OWNER TO frola;

--
-- Name: incidencias_in_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE incidencias_in_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE incidencias_in_id_seq OWNER TO frola;

--
-- Name: incidencias_in_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE incidencias_in_id_seq OWNED BY incidencias.in_id;


SET default_with_oids = false;

--
-- Name: interes; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer DEFAULT 0 NOT NULL,
    int_idptov integer DEFAULT 0 NOT NULL,
    int_centro integer NOT NULL,
    int_division integer,
    int_fecha date NOT NULL,
    int_valor numeric(15,5) DEFAULT 0,
    int_tipo integer DEFAULT 1 NOT NULL
);


ALTER TABLE interes OWNER TO frola;

SET default_with_oids = true;

--
-- Name: judicial; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE judicial (
    jud_id integer NOT NULL,
    jud_codemp integer NOT NULL,
    jud_idptov integer NOT NULL,
    jud_division integer,
    jud_centro integer,
    jud_idcopr integer NOT NULL,
    jud_ejcod integer,
    jud_fecha date DEFAULT date(now()),
    jud_deuda numeric(15,2) DEFAULT 0,
    jud_gasto numeric(15,2) DEFAULT 0,
    jud_reintg integer DEFAULT 1,
    jud_estado integer DEFAULT 1,
    jud_estudio integer,
    jud_leyen text,
    jud_operador integer
);


ALTER TABLE judicial OWNER TO frola;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE judicial_jud_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE judicial_jud_id_seq OWNER TO frola;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE judicial_jud_id_seq OWNED BY judicial.jud_id;


--
-- Name: liqegr; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE liqegr (
    eg_id integer NOT NULL,
    eg_idastoh integer NOT NULL,
    eg_codemp integer DEFAULT 0 NOT NULL,
    eg_idptov integer DEFAULT 0 NOT NULL,
    eg_centro integer DEFAULT 0 NOT NULL,
    eg_rubro integer NOT NULL,
    eg_subrub integer NOT NULL,
    eg_hayfac integer DEFAULT 1,
    eg_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    eg_prove integer,
    eg_nprove character varying(100),
    eg_cuitprov character varying(20),
    eg_factur character varying(100),
    eg_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    eg_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    eg_estado integer DEFAULT 1,
    eg_impag numeric(15,2) DEFAULT 0,
    eg_importe numeric(15,2) DEFAULT 0,
    eg_operador integer,
    eg_leyen text,
    eg_division integer DEFAULT 0 NOT NULL,
    eg_tipgto integer DEFAULT 1 NOT NULL
);


ALTER TABLE liqegr OWNER TO frola;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE liqegr_eg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liqegr_eg_id_seq OWNER TO frola;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE liqegr_eg_id_seq OWNED BY liqegr.eg_id;


--
-- Name: liqui; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE liqui (
    lq_id integer NOT NULL,
    lq_idliq integer NOT NULL,
    lq_idcopr integer NOT NULL,
    lq_rubcar integer,
    lq_cargo integer,
    lq_canti numeric(15,5) DEFAULT 1,
    lq_precio numeric(15,5) DEFAULT 1,
    lq_importe numeric(15,2) DEFAULT 0,
    lq_leyen text,
    lq_estado integer
);


ALTER TABLE liqui OWNER TO frola;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE liqui_lq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liqui_lq_id_seq OWNER TO frola;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE liqui_lq_id_seq OWNED BY liqui.lq_id;


--
-- Name: liquidacion; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE liquidacion (
    l_id integer NOT NULL,
    l_codemp integer NOT NULL,
    l_idptov integer DEFAULT 0 NOT NULL,
    l_division integer,
    l_centro integer DEFAULT 0 NOT NULL,
    l_anio integer NOT NULL,
    l_mes integer NOT NULL,
    l_perim integer NOT NULL,
    l_peria integer NOT NULL,
    l_feccie date NOT NULL,
    l_fecvto date NOT NULL,
    l_comprob integer NOT NULL,
    l_numero integer NOT NULL,
    l_estado integer DEFAULT 1 NOT NULL,
    l_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    l_operador integer NOT NULL
);


ALTER TABLE liquidacion OWNER TO frola;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE liquidacion_l_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liquidacion_l_id_seq OWNER TO frola;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE liquidacion_l_id_seq OWNED BY liquidacion.l_id;


SET default_with_oids = false;

--
-- Name: logosptv; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE logosptv (
    lpt_idptov integer NOT NULL,
    lpt_tipo integer DEFAULT 1 NOT NULL,
    lpt_estado integer DEFAULT 1 NOT NULL,
    lpt_img bytea,
    lpt_archivo integer DEFAULT 1,
    lpt_link character varying(500),
    lpt_id integer NOT NULL
);


ALTER TABLE logosptv OWNER TO frola;

--
-- Name: logosptv_lpt_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE logosptv_lpt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logosptv_lpt_id_seq OWNER TO frola;

--
-- Name: logosptv_lpt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE logosptv_lpt_id_seq OWNED BY logosptv.lpt_id;


--
-- Name: menues; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE menues (
    men_id integer NOT NULL,
    men_titulo text NOT NULL,
    men_tipo smallint DEFAULT 1,
    men_idmenu integer,
    men_estado smallint DEFAULT 1,
    men_alias text
);


ALTER TABLE menues OWNER TO frola;

--
-- Name: menues_men_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE menues_men_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE menues_men_id_seq OWNER TO frola;

--
-- Name: menues_men_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE menues_men_id_seq OWNED BY menues.men_id;


SET default_with_oids = true;

--
-- Name: modlogs; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE modlogs (
    log_id integer NOT NULL,
    log_idptov integer NOT NULL,
    log_comprob integer NOT NULL,
    log_numero integer NOT NULL,
    log_tabla character varying(30),
    log_idtabla integer DEFAULT 1 NOT NULL,
    log_campo character varying(30),
    log_valant character varying(180),
    log_valpos character varying(180),
    log_fecha timestamp without time zone DEFAULT now() NOT NULL,
    log_operador integer,
    log_cont integer DEFAULT 1,
    log_obs text
);


ALTER TABLE modlogs OWNER TO frola;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE modlogs_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE modlogs_log_id_seq OWNER TO frola;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE modlogs_log_id_seq OWNED BY modlogs.log_id;


--
-- Name: moneda; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(140) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE moneda OWNER TO frola;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(130),
    mne_valor numeric(15,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE monex OWNER TO frola;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE monex_mne_id_seq OWNER TO frola;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_idastoh integer NOT NULL,
    movs_idemiti integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer DEFAULT 0 NOT NULL,
    movs_fecval date,
    movs_artic integer,
    movs_canti numeric(15,5) DEFAULT 0,
    movs_dias numeric(15,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(15,2) DEFAULT 0,
    movs_tasa numeric(15,5) DEFAULT 0,
    movs_peso numeric(15,2) DEFAULT 0,
    movs_volum numeric(15,2) DEFAULT 0,
    movs_entreg numeric(15,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado smallint DEFAULT 1,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer,
    movs_compbte character varying(16)
);


ALTER TABLE movsto OWNER TO frola;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsto_movs_id_seq OWNER TO frola;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: notdeb; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE notdeb (
    nd_id integer NOT NULL,
    nd_idasho integer NOT NULL,
    nd_codemp integer NOT NULL,
    nd_idptov integer,
    nd_fecval date,
    nd_grupo integer,
    nd_codcop integer,
    nd_estado integer DEFAULT 1,
    nd_tpago numeric(15,2) DEFAULT 0,
    nd_tnd numeric(15,2) DEFAULT 0,
    nd_interes numeric(15,2) DEFAULT 0,
    nd_operadb integer
);


ALTER TABLE notdeb OWNER TO frola;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE notdeb_nd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notdeb_nd_id_seq OWNER TO frola;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE notdeb_nd_id_seq OWNED BY notdeb.nd_id;


--
-- Name: noticias; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE noticias (
    not_id integer NOT NULL,
    not_codemp integer DEFAULT 1 NOT NULL,
    not_idptov integer NOT NULL,
    not_titulo character varying(300),
    not_tipo integer,
    not_mes integer,
    not_anio integer,
    not_fechad date,
    not_fechah date,
    not_archivo character varying(300),
    not_estado integer DEFAULT 1
);


ALTER TABLE noticias OWNER TO frola;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE noticias_not_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE noticias_not_id_seq OWNER TO frola;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE noticias_not_id_seq OWNED BY noticias.not_id;


--
-- Name: ocsingtos; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ocsingtos (
    osg_id integer NOT NULL,
    osg_codemp integer DEFAULT 0 NOT NULL,
    osg_idptov integer DEFAULT 0 NOT NULL,
    osg_division integer NOT NULL,
    osg_centro integer DEFAULT 0 NOT NULL,
    osg_rubro integer NOT NULL,
    osg_subrub integer NOT NULL,
    osg_lecomp character varying(30),
    osg_sucomp integer,
    osg_nucomp integer,
    osg_fecori date,
    osg_fecval date NOT NULL,
    osg_hayfac integer DEFAULT 1,
    osg_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    osg_prove integer,
    osg_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    osg_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    osg_estado integer DEFAULT 1,
    osg_importe numeric(15,2) DEFAULT 0,
    osg_operador integer,
    osg_leyen text,
    osg_impag numeric(15,2) DEFAULT 0
);


ALTER TABLE ocsingtos OWNER TO frola;

--
-- Name: ocsingtos_osg_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ocsingtos_osg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ocsingtos_osg_id_seq OWNER TO frola;

--
-- Name: ocsingtos_osg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ocsingtos_osg_id_seq OWNED BY ocsingtos.osg_id;


--
-- Name: operadores; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(140) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(140),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(290),
    operad_telefono character varying(190),
    operad_codemp integer,
    operad_ptovta integer,
    operad_revision integer DEFAULT 0,
    operad_logued integer DEFAULT 0
);


ALTER TABLE operadores OWNER TO frola;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operadores_operad_id_seq OWNER TO frola;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


--
-- Name: operincid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE operincid (
    oi_id integer NOT NULL,
    oi_idinc integer NOT NULL,
    oi_operal integer NOT NULL,
    oi_operasign integer NOT NULL,
    oi_prioridad integer,
    oi_observ text,
    oi_fecha date DEFAULT now(),
    oi_hora time without time zone DEFAULT now(),
    oi_estado integer DEFAULT 1
);


ALTER TABLE operincid OWNER TO frola;

--
-- Name: operincid_oi_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE operincid_oi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operincid_oi_id_seq OWNER TO frola;

--
-- Name: operincid_oi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE operincid_oi_id_seq OWNED BY operincid.oi_id;


--
-- Name: ordencompra; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ordencompra (
    oc_id integer NOT NULL,
    oc_fecha timestamp without time zone DEFAULT now() NOT NULL,
    oc_total numeric(20,5) DEFAULT 0,
    oc_numanio integer,
    oc_numint integer,
    oc_anio integer,
    oc_centro integer,
    oc_operad integer NOT NULL,
    oc_estado integer DEFAULT 1
);


ALTER TABLE ordencompra OWNER TO frola;

--
-- Name: ordencompra_oc_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ordencompra_oc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ordencompra_oc_id_seq OWNER TO frola;

--
-- Name: ordencompra_oc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ordencompra_oc_id_seq OWNED BY ordencompra.oc_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(140) NOT NULL
);


ALTER TABLE pais OWNER TO frola;

--
-- Name: priorincid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE priorincid (
    pri_codigo integer NOT NULL,
    pri_nombre character varying(150) NOT NULL,
    pri_estado integer DEFAULT 1
);


ALTER TABLE priorincid OWNER TO frola;

--
-- Name: priorincid_pri_codigo_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE priorincid_pri_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE priorincid_pri_codigo_seq OWNER TO frola;

--
-- Name: priorincid_pri_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE priorincid_pri_codigo_seq OWNED BY priorincid.pri_codigo;


--
-- Name: prove; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_nrcuit character varying(20),
    prov_codemp integer DEFAULT 0 NOT NULL,
    prov_idptov integer DEFAULT 0 NOT NULL,
    prov_codigo integer,
    prov_nombre character varying(140),
    prov_direcc character varying(160),
    prov_locali character varying(160),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(160),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE prove OWNER TO frola;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE prove_prov_id_seq OWNER TO frola;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(140) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE provin OWNER TO frola;

--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_codemp integer NOT NULL,
    ptv_codigo integer NOT NULL,
    ptv_nombre character varying(140) NOT NULL,
    ptv_direcc character varying(160),
    ptv_locali character varying(160),
    ptv_codpos character varying(10),
    ptv_provin integer DEFAULT 1,
    ptv_pais smallint DEFAULT 200,
    ptv_nrcuit character varying(20),
    ptv_tipo integer DEFAULT 1,
    ptv_anti date DEFAULT date(now()),
    ptv_fecint integer DEFAULT 15,
    ptv_grupo integer DEFAULT 1,
    ptv_redond integer DEFAULT 1,
    ptv_nomabre character varying(140),
    ptv_estado smallint DEFAULT 1,
    ptv_aplicadesc integer DEFAULT 1,
    ptv_imputacion integer DEFAULT 3 NOT NULL,
    ptv_liqgs integer DEFAULT 0
);


ALTER TABLE ptovta OWNER TO frola;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ptovta_ptv_id_seq OWNER TO frola;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


SET default_with_oids = false;

--
-- Name: relmenu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE relmenu (
    rmen_id integer NOT NULL,
    rmen_titulo text NOT NULL,
    rmen_link text NOT NULL,
    rmen_tipo smallint DEFAULT 1,
    rmen_idmenu integer,
    rmen_nivel smallint DEFAULT 0,
    rmen_estado smallint DEFAULT 1
);


ALTER TABLE relmenu OWNER TO frola;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE relmenu_rmen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relmenu_rmen_id_seq OWNER TO frola;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE relmenu_rmen_id_seq OWNED BY relmenu.rmen_id;


SET default_with_oids = true;

--
-- Name: revisliq; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE revisliq (
    rl_id integer NOT NULL,
    rl_idliq integer NOT NULL,
    rl_operador integer,
    rl_operalta integer,
    rl_estado integer DEFAULT 1 NOT NULL,
    rl_pdf integer DEFAULT 0,
    rl_mail integer DEFAULT 0,
    rl_web integer DEFAULT 0
);


ALTER TABLE revisliq OWNER TO frola;

--
-- Name: revisliq_rl_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE revisliq_rl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE revisliq_rl_id_seq OWNER TO frola;

--
-- Name: revisliq_rl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE revisliq_rl_id_seq OWNED BY revisliq.rl_id;


--
-- Name: rubcar; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE rubcar (
    rubl_id integer NOT NULL,
    rubl_codemp integer DEFAULT 0 NOT NULL,
    rubl_tipo integer DEFAULT 1,
    rubl_codigo integer,
    rubl_nombre character varying(340) NOT NULL
);


ALTER TABLE rubcar OWNER TO frola;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE rubcar_rubl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubcar_rubl_id_seq OWNER TO frola;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE rubcar_rubl_id_seq OWNED BY rubcar.rubl_id;


--
-- Name: rubros; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_codemp integer DEFAULT 0 NOT NULL,
    rub_idptov integer DEFAULT 0 NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(140) NOT NULL
);


ALTER TABLE rubros OWNER TO frola;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubros_rub_id_seq OWNER TO frola;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: scangto; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE scangto (
    sc_id integer NOT NULL,
    sc_idgto integer NOT NULL,
    sc_tipo integer DEFAULT 1,
    sc_estado integer DEFAULT 1 NOT NULL,
    sc_img bytea,
    sc_archivo integer DEFAULT 1
);


ALTER TABLE scangto OWNER TO frola;

--
-- Name: scangto_sc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE scangto_sc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE scangto_sc_id_seq OWNER TO frola;

--
-- Name: scangto_sc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE scangto_sc_id_seq OWNED BY scangto.sc_id;


--
-- Name: seccion; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(140) NOT NULL
);


ALTER TABLE seccion OWNER TO frola;

SET default_with_oids = false;

--
-- Name: sinicial; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE sinicial (
    sin_id integer NOT NULL,
    sin_idsaldos integer DEFAULT 0 NOT NULL,
    sin_idcargo integer
);


ALTER TABLE sinicial OWNER TO frola;

--
-- Name: sinicial_sin_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE sinicial_sin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sinicial_sin_id_seq OWNER TO frola;

--
-- Name: sinicial_sin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE sinicial_sin_id_seq OWNED BY sinicial.sin_id;


SET default_with_oids = true;

--
-- Name: srubcar; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE srubcar (
    srbl_id integer NOT NULL,
    srbl_rubro integer NOT NULL,
    srbl_codigo integer NOT NULL,
    srbl_nombre character varying(340) NOT NULL,
    srbl_precio numeric(15,5) DEFAULT 0,
    srbl_leyen text,
    srbl_codemp integer DEFAULT 1 NOT NULL,
    srbl_idptov integer DEFAULT 0 NOT NULL,
    srbl_genint integer DEFAULT 0 NOT NULL
);


ALTER TABLE srubcar OWNER TO frola;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE srubcar_srbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE srubcar_srbl_id_seq OWNER TO frola;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE srubcar_srbl_id_seq OWNED BY srubcar.srbl_id;


--
-- Name: subd; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer DEFAULT 0 NOT NULL,
    subd_idptov integer DEFAULT 0 NOT NULL,
    subd_nombre character varying(140),
    subd_titulo character varying(140),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer
);


ALTER TABLE subd OWNER TO frola;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subd_subd_id_seq OWNER TO frola;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subrub; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE subrub (
    srb_id integer NOT NULL,
    srb_rubro integer NOT NULL,
    srb_codemp integer DEFAULT 0 NOT NULL,
    srb_idptov integer DEFAULT 0 NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(140) NOT NULL,
    srb_precio numeric(15,2) DEFAULT 0,
    srb_leyen text,
    srb_codtg smallint DEFAULT 1,
    srb_conper smallint DEFAULT 1,
    srb_tiprub integer,
    srb_cuenta integer
);


ALTER TABLE subrub OWNER TO frola;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE subrub_srb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subrub_srb_id_seq OWNER TO frola;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE subrub_srb_id_seq OWNED BY subrub.srb_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL
);


ALTER TABLE subxcomp OWNER TO frola;

--
-- Name: sucursal; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE sucursal (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(140) NOT NULL,
    sucu_direcc character varying(160),
    sucu_locali character varying(160),
    sucu_codpos character varying(10),
    sucu_provin integer,
    sucu_pais smallint,
    sucu_repres character varying(240),
    sucu_contacto character varying(240),
    sucu_observ text,
    sucu_direccl character varying(160),
    sucu_localil character varying(160),
    sucu_codposl character varying(10),
    sucu_codprovl integer,
    sucu_paisl smallint
);


ALTER TABLE sucursal OWNER TO frola;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_idptov integer DEFAULT 0 NOT NULL,
    tal_comprob integer,
    tal_nombre character varying(140) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date,
    tal_codemp integer DEFAULT 0 NOT NULL
);


ALTER TABLE talon OWNER TO frola;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE talon_tal_id_seq OWNER TO frola;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: telefon; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(60) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE telefon OWNER TO frola;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE telefon_tel_id_seq OWNER TO frola;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(140) NOT NULL
);


ALTER TABLE tipcta OWNER TO frola;

--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(140) NOT NULL
);


ALTER TABLE tipdocu OWNER TO frola;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(140) NOT NULL
);


ALTER TABLE tipemp OWNER TO frola;

--
-- Name: tipempr; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipempr (
    ter_codigo integer NOT NULL,
    ter_nombre character varying(140) NOT NULL
);


ALTER TABLE tipempr OWNER TO frola;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(140) NOT NULL
);


ALTER TABLE tipentid OWNER TO frola;

SET default_with_oids = false;

--
-- Name: tipgto; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipgto (
    tg_id integer NOT NULL,
    tg_nombre character varying(150) NOT NULL,
    tg_estado integer DEFAULT 1,
    tg_codemp integer DEFAULT 1 NOT NULL,
    tg_cargo integer DEFAULT 1 NOT NULL,
    tg_porc integer DEFAULT 1 NOT NULL
);


ALTER TABLE tipgto OWNER TO frola;

--
-- Name: tipgto_tg_id_seq; Type: SEQUENCE; Schema: public; Owner: frola
--

CREATE SEQUENCE tipgto_tg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipgto_tg_id_seq OWNER TO frola;

--
-- Name: tipgto_tg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: frola
--

ALTER SEQUENCE tipgto_tg_id_seq OWNED BY tipgto.tg_id;


--
-- Name: tipnot; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipnot (
    tnot_codigo integer NOT NULL,
    tnot_codemp integer DEFAULT 1 NOT NULL,
    tnot_nombre character varying(300)
);


ALTER TABLE tipnot OWNER TO frola;

SET default_with_oids = true;

--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(140) NOT NULL
);


ALTER TABLE tiptel OWNER TO frola;

--
-- Name: tipuf; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE tipuf (
    tuf_codigo integer NOT NULL,
    tuf_nombre character varying(140) NOT NULL
);


ALTER TABLE tipuf OWNER TO frola;

SET default_with_oids = false;

--
-- Name: total; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE total (
    sum numeric
);


ALTER TABLE total OWNER TO frola;

SET default_with_oids = true;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_nombre character varying(140) NOT NULL,
    uni_coef numeric(15,5),
    uni_simbolo character(3)
);


ALTER TABLE unimed OWNER TO frola;

SET default_with_oids = false;

--
-- Name: usermenu; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE usermenu (
    umen_id integer NOT NULL,
    umen_operador integer NOT NULL,
    umen_idmenu integer,
    umen_estado smallint DEFAULT 1,
    umen_menufinal integer
);


ALTER TABLE usermenu OWNER TO frola;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE usermenu_umen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE usermenu_umen_id_seq OWNER TO frola;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE usermenu_umen_id_seq OWNED BY usermenu.umen_id;


SET default_with_oids = true;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(140) NOT NULL,
    var_nombre character varying(140) NOT NULL,
    var_valor character varying(140)
);


ALTER TABLE varamb OWNER TO frola;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(140) NOT NULL,
    vari_nombre character varying(140) NOT NULL,
    vari_valor character varying(140),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE varambi OWNER TO frola;

--
-- Name: zona; Type: TABLE; Schema: public; Owner: frola; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(140) NOT NULL
);


ALTER TABLE zona OWNER TO frola;

--
-- Name: am_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity ALTER COLUMN am_id SET DEFAULT nextval('amenity_am_id_seq'::regclass);


--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: accb_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astcconccble ALTER COLUMN accb_id SET DEFAULT nextval('astcconccble_accb_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: ai_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY auxint ALTER COLUMN ai_id SET DEFAULT nextval('auxint_ai_id_seq'::regclass);


--
-- Name: cbt_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu ALTER COLUMN cbt_id SET DEFAULT nextval('cambtitu_cbt_id_seq'::regclass);


--
-- Name: car_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cargos ALTER COLUMN car_id SET DEFAULT nextval('cargos_car_id_seq'::regclass);


--
-- Name: cat_codigo; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY categincid ALTER COLUMN cat_codigo SET DEFAULT nextval('categincid_cat_codigo_seq'::regclass);


--
-- Name: cco_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY centroc ALTER COLUMN cco_id SET DEFAULT nextval('centroc_cco_id_seq'::regclass);


--
-- Name: c_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY chat ALTER COLUMN c_id SET DEFAULT nextval('chat_c_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: cqa_grupo; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY chequesaux ALTER COLUMN cqa_grupo SET DEFAULT nextval('chequesaux_cqa_grupo_seq'::regclass);


--
-- Name: cqa_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY chequesaux ALTER COLUMN cqa_id SET DEFAULT nextval('chequesaux_cqa_id_seq'::regclass);


--
-- Name: chqr_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY chqrech ALTER COLUMN chqr_id SET DEFAULT nextval('chqrech_chqr_id_seq'::regclass);


--
-- Name: cxc_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cobrxclq ALTER COLUMN cxc_id SET DEFAULT nextval('cobrxclq_cxc_id_seq'::regclass);


--
-- Name: clq_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq ALTER COLUMN clq_id SET DEFAULT nextval('compliq_clq_id_seq'::regclass);


--
-- Name: cl_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliquid ALTER COLUMN cl_id SET DEFAULT nextval('compliquid_cl_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: cmpr_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop ALTER COLUMN cmpr_id SET DEFAULT nextval('comprop_cmpr_id_seq'::regclass);


--
-- Name: ccbl_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY conccble ALTER COLUMN ccbl_id SET DEFAULT nextval('conccble_ccbl_id_seq'::regclass);


--
-- Name: clia_id; Type: DEFAULT; Schema: public; Owner: elm
--

ALTER TABLE ONLY concilia ALTER COLUMN clia_id SET DEFAULT nextval('concilia_clia_id_seq'::regclass);


--
-- Name: ct_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY contratos ALTER COLUMN ct_id SET DEFAULT nextval('contratos_ct_id_seq'::regclass);


--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios ALTER COLUMN con_id SET DEFAULT nextval('convenios_con_id_seq'::regclass);


--
-- Name: cxlia_id; Type: DEFAULT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia ALTER COLUMN cxlia_id SET DEFAULT nextval('conxcxlia_cxlia_id_seq'::regclass);


--
-- Name: cop_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY coprop ALTER COLUMN cop_id SET DEFAULT nextval('coprop_cop_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: ctc_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ctasconv ALTER COLUMN ctc_id SET DEFAULT nextval('ctasconv_ctc_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: dlq_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY descripliq ALTER COLUMN dlq_id SET DEFAULT nextval('descripliq_dlq_id_seq'::regclass);


--
-- Name: din_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY dinicial ALTER COLUMN din_id SET DEFAULT nextval('dinicial_din_id_seq'::regclass);


--
-- Name: div_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY division ALTER COLUMN div_id SET DEFAULT nextval('division_div_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: ent_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY entidad ALTER COLUMN ent_id SET DEFAULT nextval('entidad_ent_id_seq'::regclass);


--
-- Name: est_codigo; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY estincid ALTER COLUMN est_codigo SET DEFAULT nextval('estincid_est_codigo_seq'::regclass);


--
-- Name: evt_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos ALTER COLUMN evt_id SET DEFAULT nextval('eventos_evt_id_seq'::regclass);


--
-- Name: fap_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend ALTER COLUMN fap_id SET DEFAULT nextval('factpend_fap_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: fp_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY formapagooc ALTER COLUMN fp_id SET DEFAULT nextval('formapagooc_fp_id_seq'::regclass);


--
-- Name: gto_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos ALTER COLUMN gto_id SET DEFAULT nextval('gastos_gto_id_seq'::regclass);


--
-- Name: gf_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY grupof_d ALTER COLUMN gf_id SET DEFAULT nextval('grupof_d_gf_id_seq'::regclass);


--
-- Name: gf_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY grupof_inq ALTER COLUMN gf_id SET DEFAULT nextval('grupof_inq_gf_id_seq'::regclass);


--
-- Name: gxo_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gtoxoc ALTER COLUMN gxo_id SET DEFAULT nextval('gtoxoc_gxo_id_seq'::regclass);


--
-- Name: hon_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY honorarios ALTER COLUMN hon_id SET DEFAULT nextval('honorarios_hon_id_seq'::regclass);


--
-- Name: img_codigo; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY imgincid ALTER COLUMN img_codigo SET DEFAULT nextval('imgincid_img_codigo_seq'::regclass);


--
-- Name: imp_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY importoliq ALTER COLUMN imp_id SET DEFAULT nextval('importoliq_imp_id_seq'::regclass);


--
-- Name: in_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias ALTER COLUMN in_id SET DEFAULT nextval('incidencias_in_id_seq'::regclass);


--
-- Name: jud_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial ALTER COLUMN jud_id SET DEFAULT nextval('judicial_jud_id_seq'::regclass);


--
-- Name: eg_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqegr ALTER COLUMN eg_id SET DEFAULT nextval('liqegr_eg_id_seq'::regclass);


--
-- Name: lq_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqui ALTER COLUMN lq_id SET DEFAULT nextval('liqui_lq_id_seq'::regclass);


--
-- Name: l_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liquidacion ALTER COLUMN l_id SET DEFAULT nextval('liquidacion_l_id_seq'::regclass);


--
-- Name: lpt_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY logosptv ALTER COLUMN lpt_id SET DEFAULT nextval('logosptv_lpt_id_seq'::regclass);


--
-- Name: men_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY menues ALTER COLUMN men_id SET DEFAULT nextval('menues_men_id_seq'::regclass);


--
-- Name: log_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY modlogs ALTER COLUMN log_id SET DEFAULT nextval('modlogs_log_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: nd_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY notdeb ALTER COLUMN nd_id SET DEFAULT nextval('notdeb_nd_id_seq'::regclass);


--
-- Name: not_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY noticias ALTER COLUMN not_id SET DEFAULT nextval('noticias_not_id_seq'::regclass);


--
-- Name: osg_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ocsingtos ALTER COLUMN osg_id SET DEFAULT nextval('ocsingtos_osg_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: oi_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid ALTER COLUMN oi_id SET DEFAULT nextval('operincid_oi_id_seq'::regclass);


--
-- Name: oc_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ordencompra ALTER COLUMN oc_id SET DEFAULT nextval('ordencompra_oc_id_seq'::regclass);


--
-- Name: pri_codigo; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY priorincid ALTER COLUMN pri_codigo SET DEFAULT nextval('priorincid_pri_codigo_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: rmen_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY relmenu ALTER COLUMN rmen_id SET DEFAULT nextval('relmenu_rmen_id_seq'::regclass);


--
-- Name: rl_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY revisliq ALTER COLUMN rl_id SET DEFAULT nextval('revisliq_rl_id_seq'::regclass);


--
-- Name: rubl_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY rubcar ALTER COLUMN rubl_id SET DEFAULT nextval('rubcar_rubl_id_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: sc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY scangto ALTER COLUMN sc_id SET DEFAULT nextval('scangto_sc_id_seq'::regclass);


--
-- Name: sin_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY sinicial ALTER COLUMN sin_id SET DEFAULT nextval('sinicial_sin_id_seq'::regclass);


--
-- Name: srbl_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY srubcar ALTER COLUMN srbl_id SET DEFAULT nextval('srubcar_srbl_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: srb_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY subrub ALTER COLUMN srb_id SET DEFAULT nextval('subrub_srb_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: tg_id; Type: DEFAULT; Schema: public; Owner: frola
--

ALTER TABLE ONLY tipgto ALTER COLUMN tg_id SET DEFAULT nextval('tipgto_tg_id_seq'::regclass);


--
-- Name: umen_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY usermenu ALTER COLUMN umen_id SET DEFAULT nextval('usermenu_umen_id_seq'::regclass);


--
-- Name: amenity_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT amenity_pkey PRIMARY KEY (am_id);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: astcconccble_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY astcconccble
    ADD CONSTRAINT astcconccble_pkey PRIMARY KEY (accb_id);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: cambtitu_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT cambtitu_pkey PRIMARY KEY (cbt_id);


--
-- Name: cargos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT cargos_pkey PRIMARY KEY (car_id);


--
-- Name: categincid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY categincid
    ADD CONSTRAINT categincid_pkey PRIMARY KEY (cat_codigo);


--
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_id);


--
-- Name: chat_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY chat
    ADD CONSTRAINT chat_pkey PRIMARY KEY (c_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: cobrxclq_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT cobrxclq_pkey PRIMARY KEY (cxc_id);


--
-- Name: compliq_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT compliq_pkey PRIMARY KEY (clq_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: comprop_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT comprop_pkey PRIMARY KEY (cmpr_id);


--
-- Name: conccble_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY conccble
    ADD CONSTRAINT conccble_pkey PRIMARY KEY (ccbl_id);


--
-- Name: concilia_pkey; Type: CONSTRAINT; Schema: public; Owner: elm; Tablespace: 
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT concilia_pkey PRIMARY KEY (clia_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (ct_id);


--
-- Name: convenios_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT convenios_pkey PRIMARY KEY (con_id);


--
-- Name: conxcxlia_pkey; Type: CONSTRAINT; Schema: public; Owner: elm; Tablespace: 
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT conxcxlia_pkey PRIMARY KEY (cxlia_id);


--
-- Name: coprop_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_pkey PRIMARY KEY (cop_id);


--
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctasconv_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT ctasconv_pkey PRIMARY KEY (ctc_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: descripliq_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY descripliq
    ADD CONSTRAINT descripliq_pkey PRIMARY KEY (dlq_id);


--
-- Name: dinicial_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY dinicial
    ADD CONSTRAINT dinicial_pkey PRIMARY KEY (din_id);


--
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_id);


--
-- Name: estincid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY estincid
    ADD CONSTRAINT estincid_pkey PRIMARY KEY (est_codigo);


--
-- Name: estjud_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY estjud
    ADD CONSTRAINT estjud_pkey PRIMARY KEY (etj_codigo);


--
-- Name: estjurid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY estjurid
    ADD CONSTRAINT estjurid_pkey PRIMARY KEY (est_codigo);


--
-- Name: eventos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT eventos_pkey PRIMARY KEY (evt_id);


--
-- Name: factpend_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_pkey PRIMARY KEY (fap_id);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: formapagooc_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_pkey PRIMARY KEY (fp_id);


--
-- Name: gastos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_pkey PRIMARY KEY (gto_id);


--
-- Name: grupof_d_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY grupof_d
    ADD CONSTRAINT grupof_d_pkey PRIMARY KEY (gf_id);


--
-- Name: grupof_inq_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY grupof_inq
    ADD CONSTRAINT grupof_inq_pkey PRIMARY KEY (gf_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: gtoxoc_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY gtoxoc
    ADD CONSTRAINT gtoxoc_pkey PRIMARY KEY (gxo_id);


--
-- Name: honorarios_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY honorarios
    ADD CONSTRAINT honorarios_pkey PRIMARY KEY (hon_id);


--
-- Name: imgincid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY imgincid
    ADD CONSTRAINT imgincid_pkey PRIMARY KEY (img_codigo);


--
-- Name: importoliq_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY importoliq
    ADD CONSTRAINT importoliq_pkey PRIMARY KEY (imp_id);


--
-- Name: incidencias_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_pkey PRIMARY KEY (in_id);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_centro, int_fecha, int_tipo);


--
-- Name: judicial_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT judicial_pkey PRIMARY KEY (jud_id);


--
-- Name: liqegr_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_pkey PRIMARY KEY (eg_id);


--
-- Name: liquidacion_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT liquidacion_pkey PRIMARY KEY (l_id);


--
-- Name: menues_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY menues
    ADD CONSTRAINT menues_pkey PRIMARY KEY (men_id);


--
-- Name: modlogs_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY modlogs
    ADD CONSTRAINT modlogs_pkey PRIMARY KEY (log_id);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: noticias_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY noticias
    ADD CONSTRAINT noticias_pkey PRIMARY KEY (not_id);


--
-- Name: ocsingtos_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_pkey PRIMARY KEY (osg_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: operincid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_pkey PRIMARY KEY (oi_id);


--
-- Name: ordencompra_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ordencompra
    ADD CONSTRAINT ordencompra_pkey PRIMARY KEY (oc_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: priorincid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY priorincid
    ADD CONSTRAINT priorincid_pkey PRIMARY KEY (pri_codigo);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: relmenu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY relmenu
    ADD CONSTRAINT relmenu_pkey PRIMARY KEY (rmen_id);


--
-- Name: revisliq_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY revisliq
    ADD CONSTRAINT revisliq_pkey PRIMARY KEY (rl_id);


--
-- Name: rubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY rubcar
    ADD CONSTRAINT rubcar_pkey PRIMARY KEY (rubl_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: scangto_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY scangto
    ADD CONSTRAINT scangto_pkey PRIMARY KEY (sc_id);


--
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- Name: sinicial_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY sinicial
    ADD CONSTRAINT sinicial_pkey PRIMARY KEY (sin_id);


--
-- Name: srubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY srubcar
    ADD CONSTRAINT srubcar_pkey PRIMARY KEY (srbl_id);


--
-- Name: subd_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT subd_pkey PRIMARY KEY (subd_id);


--
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_id);


--
-- Name: sucursal_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY sucursal
    ADD CONSTRAINT sucursal_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipempr_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipempr
    ADD CONSTRAINT tipempr_pkey PRIMARY KEY (ter_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tipgto_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipgto
    ADD CONSTRAINT tipgto_pkey PRIMARY KEY (tg_id);


--
-- Name: tipnot_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipnot
    ADD CONSTRAINT tipnot_pkey PRIMARY KEY (tnot_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tipuf_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY tipuf
    ADD CONSTRAINT tipuf_pkey PRIMARY KEY (tuf_codigo);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: usermenu_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY usermenu
    ADD CONSTRAINT usermenu_pkey PRIMARY KEY (umen_id);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: zona_pkey; Type: CONSTRAINT; Schema: public; Owner: frola; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT zona_pkey PRIMARY KEY (zon_codigo);


--
-- Name: cobrxclq_cxc_idastoc_cxc_importe_idx; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idastoc_cxc_importe_idx ON cobrxclq USING btree (cxc_idastoc, cxc_importe);


--
-- Name: cobrxclq_cxc_idclq_cxc_importe_idx; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idclq_cxc_importe_idx ON cobrxclq USING btree (cxc_idclq, cxc_importe);


--
-- Name: cobrxclq_cxc_idcopr_cxc_importe_idx; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idcopr_cxc_importe_idx ON cobrxclq USING btree (cxc_idcopr, cxc_importe);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_tipoper, art_codigo);


--
-- Name: idx_articvta_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_2 ON articvta USING btree (art_idptov, art_codi);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_16; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_16 ON astoctas USING btree (astc_ctacte, astc_tipcta, astc_estado, astc_importe);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_centro, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_3 ON astoh USING btree (ash_codemp, ash_centro, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_4 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_centro, ash_fecomp);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_centro, ash_fecval);


--
-- Name: idx_astoh_6; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_6 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_7; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_7 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_idptov, ash_centro, ash_fecval);


--
-- Name: idx_astoh_8; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_astoh_8 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_titulo);


--
-- Name: idx_auxint_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_auxint_1 ON auxint USING btree (ai_idliq, ai_idcopr);


--
-- Name: idx_cambtitu_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cambtitu_1 ON cambtitu USING btree (cbt_codemp, cbt_idptov, cbt_idcopr);


--
-- Name: idx_cambtitu_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cambtitu_2 ON cambtitu USING btree (cbt_idcopr);


--
-- Name: idx_cargos_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cargos_1 ON cargos USING btree (car_codemp, car_idptov, car_division, car_centro, car_codigo);


--
-- Name: idx_cargos_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cargos_2 ON cargos USING btree (car_codemp, car_idptov, car_codigo);


--
-- Name: idx_cargos_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cargos_3 ON cargos USING btree (car_codemp, car_idptov, car_rubcar, car_srubcar);


--
-- Name: idx_centroc_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_centroc_1 ON centroc USING btree (cco_codemp, cco_idptov, cco_coddiv, cco_codigo);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_compliq_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_2 ON compliq USING btree (clq_codemp, clq_idptov, clq_comprob, clq_numero);


--
-- Name: idx_compliq_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_3 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes);


--
-- Name: idx_compliq_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_4 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes, clq_rubcar, clq_cargo);


--
-- Name: idx_compliq_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_5 ON compliq USING btree (clq_codemp, clq_centro, clq_anio, clq_mes);


--
-- Name: idx_compliq_6; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_6 ON compliq USING btree (clq_codemp, clq_centro, clq_anio, clq_mes, clq_idcopr, clq_estado);


--
-- Name: idx_compliq_7; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_7 ON compliq USING btree (clq_id, clq_importe);


--
-- Name: idx_compliq_8; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_8 ON compliq USING btree (clq_fecha, clq_idcopr, clq_rubcar, clq_cargo, clq_importe);


--
-- Name: idx_compliq_9; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliq_9 ON compliq USING btree (clq_idliq, clq_cargo, clq_idcopr, clq_estado, clq_importe);


--
-- Name: idx_compliquid_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compliquid_1 ON compliquid USING btree (cl_idliq);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_codemp, comp_idptov, comp_codigo);


--
-- Name: idx_comprop_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_comprop_1 ON comprop USING btree (cmpr_centro, cmpr_idcopr);


--
-- Name: idx_comprop_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_comprop_2 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr);


--
-- Name: idx_comprop_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_comprop_3 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr, cmpr_rubcar, cmpr_cargo);


--
-- Name: idx_conccble_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_conccble_1 ON conccble USING btree (ccbl_ctacble, ccbl_fecha);


--
-- Name: idx_concilia_1; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_concilia_1 ON concilia USING btree (clia_cte, clia_fecha);


--
-- Name: idx_convenios_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_convenios_1 ON convenios USING btree (con_codemp, con_idptov, con_division, con_centro, con_idcopr);


--
-- Name: idx_conxcxlia_1; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_conxcxlia_1 ON conxclia USING btree (cxlia_idclia);


--
-- Name: idx_conxcxlia_2; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_conxcxlia_2 ON conxclia USING btree (cxlia_idastc);


--
-- Name: idx_coprop_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_coprop_2 ON coprop USING btree (cop_codemp, cop_idptov, cop_codaso);


--
-- Name: idx_coprop_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_coprop_3 ON coprop USING btree (cop_codemp, cop_idptov, cop_division, cop_centro, cop_unifun);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_ctacble_2 ON ctacble USING btree (cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_ctacble_3 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_nombre);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_dinicial_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_dinicial_1 ON dinicial USING btree (din_idsaldos, din_iddesc);


--
-- Name: idx_division_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_division_1 ON division USING btree (div_codemp, div_idptov, div_codigo);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_factpend_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_factpend_2 ON factpend USING btree (fap_codemp, fap_idptov, fap_centro);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_formapagooc_10; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_10 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_tipcta, fp_ctacte);


--
-- Name: idx_formapagooc_11; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_11 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_tipcta, fp_ctacte, fp_fecval);


--
-- Name: idx_formapagooc_12; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_12 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_moneda);


--
-- Name: idx_formapagooc_13; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_13 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_ctacble, fp_estado, fp_fecval);


--
-- Name: idx_formapagooc_14; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_14 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_estado, fp_fecval);


--
-- Name: idx_formapagooc_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_2 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_fecval);


--
-- Name: idx_formapagooc_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_3 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_ctacble, fp_fecval);


--
-- Name: idx_formapagooc_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_formapagooc_4 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_ctacte, fp_fecval);


--
-- Name: idx_gastos_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_gastos_1 ON gastos USING btree (gto_idastoh);


--
-- Name: idx_gastos_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_gastos_2 ON gastos USING btree (gto_codemp, gto_idptov, gto_centro);


--
-- Name: idx_gtoxliqe_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_1 ON gtoxliqe USING btree (gxl_liqegr, gxl_gasto);


--
-- Name: idx_gtoxliqe_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_2 ON gtoxliqe USING btree (gxl_liqegr);


--
-- Name: idx_gtoxliqe_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_3 ON gtoxliqe USING btree (gxl_gasto);


--
-- Name: idx_honorarios_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_honorarios_2 ON honorarios USING btree (hon_codemp, hon_idptov, hon_rubro, hon_subrub);


--
-- Name: idx_importoliq_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_importoliq_1 ON importoliq USING btree (imp_centro, imp_anio, imp_mes);


--
-- Name: idx_judicial_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_judicial_1 ON judicial USING btree (jud_codemp, jud_idptov, jud_idcopr);


--
-- Name: idx_judicial_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_judicial_2 ON judicial USING btree (jud_idcopr);


--
-- Name: idx_liqegr_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liqegr_1 ON liqegr USING btree (eg_idastoh);


--
-- Name: idx_liqegr_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liqegr_2 ON liqegr USING btree (eg_codemp, eg_idptov, eg_centro);


--
-- Name: idx_liqui_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liqui_1 ON liqui USING btree (lq_idliq, lq_idcopr);


--
-- Name: idx_liquidacion_0; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liquidacion_0 ON liquidacion USING btree (l_codemp, l_idptov, l_centro, l_division, l_anio, l_mes);


--
-- Name: idx_liquidacion_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liquidacion_1 ON liquidacion USING btree (l_codemp, l_idptov, l_anio, l_mes);


--
-- Name: idx_liquidacion_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_liquidacion_2 ON liquidacion USING btree (l_idptov, l_anio, l_mes);


--
-- Name: idx_modlogs_1; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_1 ON modlogs USING btree (log_idptov, log_tabla);


--
-- Name: idx_modlogs_2; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_2 ON modlogs USING btree (log_comprob, log_numero);


--
-- Name: idx_modlogs_3; Type: INDEX; Schema: public; Owner: zona; Tablespace: 
--

CREATE INDEX idx_modlogs_3 ON modlogs USING btree (log_tabla, log_idtabla);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_noticias_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_noticias_1 ON noticias USING btree (not_idptov, not_tipo, not_titulo);


--
-- Name: idx_noticias_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_noticias_2 ON noticias USING btree (not_idptov, not_tipo, not_anio, not_mes);


--
-- Name: idx_noticias_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_noticias_3 ON noticias USING btree (not_idptov, not_anio, not_mes);


--
-- Name: idx_ocsingtos_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_ocsingtos_2 ON ocsingtos USING btree (osg_codemp, osg_idptov, osg_division, osg_centro);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_ordencompra_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_ordencompra_1 ON ordencompra USING btree (oc_numanio, oc_anio);


--
-- Name: idx_prove_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_prove_1 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_sinicial_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_sinicial_1 ON sinicial USING btree (sin_idsaldos, sin_idcargo);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_subrub_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_subrub_1 ON subrub USING btree (srb_rubro, srb_codigo);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: frola; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: ad_cobrxclq; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ad_cobrxclq AFTER DELETE ON cobrxclq FOR EACH ROW EXECUTE PROCEDURE f_ad_cobrxclq();


--
-- Name: ad_compliq; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ad_compliq BEFORE DELETE ON compliq FOR EACH ROW EXECUTE PROCEDURE f_bd_compliq();


--
-- Name: ad_coprop; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ad_coprop AFTER DELETE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_ad_coprop();


--
-- Name: ad_gastos; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ad_gastos AFTER DELETE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_ad_gastos();


--
-- Name: ad_prove; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ad_prove AFTER DELETE ON prove FOR EACH ROW EXECUTE PROCEDURE f_ad_prove();


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_astoctas AFTER INSERT ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_astoh; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_astoh AFTER INSERT ON astoh FOR EACH ROW EXECUTE PROCEDURE f_ai_astoh();


--
-- Name: ai_coprop; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_coprop AFTER INSERT ON coprop FOR EACH ROW EXECUTE PROCEDURE f_ai_coprop();


--
-- Name: ai_empresa; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_empresa AFTER INSERT ON empresa FOR EACH ROW EXECUTE PROCEDURE f_ai_empresa();


--
-- Name: ai_gastos; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_gastos AFTER INSERT ON gastos FOR EACH ROW EXECUTE PROCEDURE f_ai_gastos();


--
-- Name: ai_ordencompra; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_ordencompra AFTER INSERT ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_ai_ordencompra();


--
-- Name: ai_prove; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_prove AFTER INSERT ON prove FOR EACH ROW EXECUTE PROCEDURE f_ai_prove();


--
-- Name: ai_ptovta; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER ai_ptovta AFTER INSERT ON ptovta FOR EACH ROW EXECUTE PROCEDURE f_ai_ptovta();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_astoctas AFTER UPDATE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_astoh AFTER UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_cheques; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_cheques AFTER UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_au_cheques();


--
-- Name: au_compliq; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_compliq AFTER UPDATE ON compliq FOR EACH ROW EXECUTE PROCEDURE f_au_compliq();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_compra AFTER UPDATE ON compra FOR EACH ROW EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_conccble; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_conccble AFTER UPDATE ON conccble FOR EACH ROW EXECUTE PROCEDURE f_au_conccble();


--
-- Name: au_concilia; Type: TRIGGER; Schema: public; Owner: elm
--

CREATE TRIGGER au_concilia AFTER UPDATE ON concilia FOR EACH ROW EXECUTE PROCEDURE f_au_concilia();


--
-- Name: au_coprop; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_coprop AFTER UPDATE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_au_coprop();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_emiti AFTER UPDATE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_gastos; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_gastos AFTER UPDATE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_au_gastos();


--
-- Name: au_honorarios; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_honorarios AFTER UPDATE ON honorarios FOR EACH ROW EXECUTE PROCEDURE f_au_honorarios();


--
-- Name: au_liqegr; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_liqegr AFTER UPDATE ON liqegr FOR EACH ROW EXECUTE PROCEDURE f_au_liqegr();


--
-- Name: au_liquidacion; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_liquidacion AFTER UPDATE ON liquidacion FOR EACH ROW EXECUTE PROCEDURE f_au_liquidacion();


--
-- Name: au_ordencompra; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_ordencompra AFTER UPDATE ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_au_ordencompra();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_prove AFTER UPDATE ON prove FOR EACH ROW EXECUTE PROCEDURE f_au_prove();


--
-- Name: au_telefon; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER au_telefon AFTER UPDATE ON telefon FOR EACH ROW EXECUTE PROCEDURE f_au_telefon();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_astoctas BEFORE DELETE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_astoh BEFORE DELETE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_coprop; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_coprop BEFORE DELETE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_bd_coprop();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_emiti BEFORE DELETE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_gastos; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_gastos BEFORE DELETE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_bd_gastos();


--
-- Name: bd_importoliq; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_importoliq BEFORE DELETE ON importoliq FOR EACH ROW EXECUTE PROCEDURE f_bd_importoliq();


--
-- Name: bd_incidencias; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_incidencias BEFORE DELETE ON incidencias FOR EACH ROW EXECUTE PROCEDURE f_bd_incidencias();


--
-- Name: bd_liquidacion; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_liquidacion BEFORE DELETE ON liquidacion FOR EACH ROW EXECUTE PROCEDURE f_bd_liquidacion();


--
-- Name: bd_ordencompra; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_ordencompra BEFORE DELETE ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_bd_ordencompra();


--
-- Name: bd_prove; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_prove BEFORE DELETE ON prove FOR EACH ROW EXECUTE PROCEDURE f_bd_prove();


--
-- Name: bd_ptovta; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bd_ptovta BEFORE DELETE ON ptovta FOR EACH ROW EXECUTE PROCEDURE f_bd_ptovta();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bu_astoh BEFORE UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bu_cheques BEFORE UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: bu_gastos; Type: TRIGGER; Schema: public; Owner: frola
--

CREATE TRIGGER bu_gastos AFTER UPDATE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_bu_gastos();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT "$1" FOREIGN KEY (car_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$1" FOREIGN KEY (l_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliquid
    ADD CONSTRAINT "$1" FOREIGN KEY (cl_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$1" FOREIGN KEY (lq_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$1" FOREIGN KEY (cmpr_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$1" FOREIGN KEY (ai_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$1" FOREIGN KEY (con_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT "$1" FOREIGN KEY (ctc_idconv) REFERENCES convenios(con_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$1" FOREIGN KEY (cbt_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$1" FOREIGN KEY (jud_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$1" FOREIGN KEY (clq_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT "$1" FOREIGN KEY (clia_cte) REFERENCES ctes(cte_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$1" FOREIGN KEY (cxlia_idclia) REFERENCES concilia(clia_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY conccble
    ADD CONSTRAINT "$1" FOREIGN KEY (ccbl_ctacble) REFERENCES ctacble(cbl_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astcconccble
    ADD CONSTRAINT "$1" FOREIGN KEY (accb_idccbl) REFERENCES conccble(ccbl_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ordencompra
    ADD CONSTRAINT "$1" FOREIGN KEY (oc_centro) REFERENCES centroc(cco_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$1" FOREIGN KEY (am_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$1" FOREIGN KEY (evt_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$2" FOREIGN KEY (l_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$2" FOREIGN KEY (lq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$2" FOREIGN KEY (cmpr_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$2" FOREIGN KEY (ai_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$2" FOREIGN KEY (con_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$2" FOREIGN KEY (cbt_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$2" FOREIGN KEY (jud_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$2" FOREIGN KEY (clq_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT "$2" FOREIGN KEY (cxc_idclq) REFERENCES compliq(clq_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$2" FOREIGN KEY (cxlia_idastc) REFERENCES astoctas(astc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gtoxoc
    ADD CONSTRAINT "$2" FOREIGN KEY (gxo_idoc) REFERENCES ordencompra(oc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$2" FOREIGN KEY (am_division) REFERENCES division(div_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$2" FOREIGN KEY (evt_division) REFERENCES division(div_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$3" FOREIGN KEY (l_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$3" FOREIGN KEY (lq_cargo) REFERENCES cargos(car_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$3" FOREIGN KEY (cmpr_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$3" FOREIGN KEY (con_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$3" FOREIGN KEY (cbt_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$3" FOREIGN KEY (jud_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$3" FOREIGN KEY (clq_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT "$3" FOREIGN KEY (cxc_idcopr) REFERENCES coprop(cop_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$3" FOREIGN KEY (am_centro) REFERENCES centroc(cco_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$3" FOREIGN KEY (evt_centro) REFERENCES centroc(cco_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$4" FOREIGN KEY (l_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$4" FOREIGN KEY (cmpr_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$4" FOREIGN KEY (con_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$4" FOREIGN KEY (cbt_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$4" FOREIGN KEY (jud_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$4" FOREIGN KEY (clq_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$4" FOREIGN KEY (am_cargo) REFERENCES cargos(car_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$4" FOREIGN KEY (evt_idcopr) REFERENCES coprop(cop_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$5" FOREIGN KEY (cmpr_cargo) REFERENCES cargos(car_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$5" FOREIGN KEY (con_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$5" FOREIGN KEY (cbt_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$5" FOREIGN KEY (jud_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$5" FOREIGN KEY (clq_comprob) REFERENCES comprob(comp_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$5" FOREIGN KEY (am_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$5" FOREIGN KEY (evt_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$6" FOREIGN KEY (con_comprob) REFERENCES comprob(comp_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$6" FOREIGN KEY (jud_ejcod) REFERENCES estjud(etj_codigo) MATCH FULL;


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$6" FOREIGN KEY (clq_cargo) REFERENCES cargos(car_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$6" FOREIGN KEY (evt_idamenity) REFERENCES amenity(am_id);


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$7" FOREIGN KEY (jud_estudio) REFERENCES estjurid(est_codigo) MATCH FULL;


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$7" FOREIGN KEY (clq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: astoctas_astc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_codemp_fkey FOREIGN KEY (astc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoctas_astc_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idastoh_fkey FOREIGN KEY (astc_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: astoctas_astc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idptov_fkey FOREIGN KEY (astc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: astoh_ash_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_codemp_fkey FOREIGN KEY (ash_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoh_ash_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_idptov_fkey FOREIGN KEY (ash_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: centroc_cco_coddiv_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_coddiv_fkey FOREIGN KEY (cco_coddiv) REFERENCES division(div_id) MATCH FULL;


--
-- Name: centroc_cco_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_codemp_fkey FOREIGN KEY (cco_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: centroc_cco_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_idptov_fkey FOREIGN KEY (cco_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cheques_chq_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_codemp_fkey FOREIGN KEY (chq_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: cheques_chq_idastoc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idastoc_fkey FOREIGN KEY (chq_idastoc) REFERENCES astoctas(astc_id) MATCH FULL;


--
-- Name: cheques_chq_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idptov_fkey FOREIGN KEY (chq_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: compra_cpra_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_codemp_fkey FOREIGN KEY (cpra_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: compra_cpra_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idastoh_fkey FOREIGN KEY (cpra_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: compra_cpra_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idptov_fkey FOREIGN KEY (cpra_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: coprop_cop_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_codemp_fkey FOREIGN KEY (cop_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: coprop_cop_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_idptov_fkey FOREIGN KEY (cop_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cotiza_cot_moneda_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_cot_moneda_fkey FOREIGN KEY (cot_moneda) REFERENCES moneda(mon_codigo) MATCH FULL;


--
-- Name: division_div_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_codemp_fkey FOREIGN KEY (div_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: division_div_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_idptov_fkey FOREIGN KEY (div_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: docum_doc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_codemp_fkey FOREIGN KEY (doc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: docum_doc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_idptov_fkey FOREIGN KEY (doc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: emiti_emi_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_codemp_fkey FOREIGN KEY (emi_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: emiti_emi_comprob_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_comprob_fkey FOREIGN KEY (emi_comprob) REFERENCES comprob(comp_id) MATCH FULL;


--
-- Name: emiti_emi_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idastoh_fkey FOREIGN KEY (emi_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: emiti_emi_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idptov_fkey FOREIGN KEY (emi_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: estjurid_est_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY estjurid
    ADD CONSTRAINT estjurid_est_codemp_fkey FOREIGN KEY (est_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: factpend_fap_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_centro_fkey FOREIGN KEY (fap_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: factpend_fap_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_codemp_fkey FOREIGN KEY (fap_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: factpend_fap_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_division_fkey FOREIGN KEY (fap_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: factpend_fap_idgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idgto_fkey FOREIGN KEY (fap_idgto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: factpend_fap_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idptov_fkey FOREIGN KEY (fap_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: formapagooc_fp_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_fp_codemp_fkey FOREIGN KEY (fp_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: formapagooc_fp_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_fp_idptov_fkey FOREIGN KEY (fp_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gastos_gto_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_centro_fkey FOREIGN KEY (gto_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: gastos_gto_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_codemp_fkey FOREIGN KEY (gto_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: gastos_gto_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_division_fkey FOREIGN KEY (gto_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: gastos_gto_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idastoh_fkey FOREIGN KEY (gto_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: gastos_gto_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idptov_fkey FOREIGN KEY (gto_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gastos_gto_tipgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_tipgto_fkey FOREIGN KEY (gto_tipgto) REFERENCES tipgto(tg_id);


--
-- Name: gtoxliqe_gxl_gasto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_gasto_fkey FOREIGN KEY (gxl_gasto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: gtoxliqe_gxl_liqegr_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_liqegr_fkey FOREIGN KEY (gxl_liqegr) REFERENCES liqegr(eg_id) MATCH FULL;


--
-- Name: imgincid_img_idinc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY imgincid
    ADD CONSTRAINT imgincid_img_idinc_fkey FOREIGN KEY (img_idinc) REFERENCES incidencias(in_id);


--
-- Name: incidencias_in_categoria_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_categoria_fkey FOREIGN KEY (in_categoria) REFERENCES categincid(cat_codigo);


--
-- Name: incidencias_in_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_codemp_fkey FOREIGN KEY (in_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: incidencias_in_estado_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_estado_fkey FOREIGN KEY (in_estado) REFERENCES estincid(est_codigo);


--
-- Name: incidencias_in_idcopr_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_idcopr_fkey FOREIGN KEY (in_idcopr) REFERENCES coprop(cop_id);


--
-- Name: incidencias_in_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_idptov_fkey FOREIGN KEY (in_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: interes_int_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_centro_fkey FOREIGN KEY (int_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: interes_int_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_codemp_fkey FOREIGN KEY (int_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: interes_int_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_idptov_fkey FOREIGN KEY (int_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqegr_eg_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_codemp_fkey FOREIGN KEY (eg_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: liqegr_eg_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idastoh_fkey FOREIGN KEY (eg_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: liqegr_eg_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idptov_fkey FOREIGN KEY (eg_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqegr_eg_tipgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_tipgto_fkey FOREIGN KEY (eg_tipgto) REFERENCES tipgto(tg_id);


--
-- Name: movsto_movs_artic_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_artic_fkey FOREIGN KEY (movs_artic) REFERENCES articvta(art_id) MATCH FULL;


--
-- Name: movsto_movs_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_codemp_fkey FOREIGN KEY (movs_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: movsto_movs_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idastoh_fkey FOREIGN KEY (movs_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: movsto_movs_idemiti_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idemiti_fkey FOREIGN KEY (movs_idemiti) REFERENCES emiti(emi_id) MATCH FULL;


--
-- Name: movsto_movs_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idptov_fkey FOREIGN KEY (movs_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: ocsingtos_osg_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_centro_fkey FOREIGN KEY (osg_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: ocsingtos_osg_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_codemp_fkey FOREIGN KEY (osg_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: ocsingtos_osg_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_division_fkey FOREIGN KEY (osg_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: ocsingtos_osg_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_idptov_fkey FOREIGN KEY (osg_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: operincid_oi_estado_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_estado_fkey FOREIGN KEY (oi_estado) REFERENCES estincid(est_codigo);


--
-- Name: operincid_oi_idinc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_idinc_fkey FOREIGN KEY (oi_idinc) REFERENCES incidencias(in_id);


--
-- Name: operincid_oi_operal_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_operal_fkey FOREIGN KEY (oi_operal) REFERENCES operadores(operad_id);


--
-- Name: operincid_oi_operasign_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_operasign_fkey FOREIGN KEY (oi_operasign) REFERENCES operadores(operad_id);


--
-- Name: operincid_oi_prioridad_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_prioridad_fkey FOREIGN KEY (oi_prioridad) REFERENCES priorincid(pri_codigo);


--
-- Name: ptovta_ptv_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: frola
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_ptv_codemp_fkey FOREIGN KEY (ptv_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: amenity; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE amenity FROM PUBLIC;
REVOKE ALL ON TABLE amenity FROM frola;
GRANT ALL ON TABLE amenity TO frola;
GRANT ALL ON TABLE amenity TO nobody;


--
-- Name: amenity_am_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM frola;
GRANT ALL ON SEQUENCE amenity_am_id_seq TO frola;
GRANT UPDATE ON SEQUENCE amenity_am_id_seq TO nobody;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM frola;
GRANT ALL ON TABLE articvta TO frola;
GRANT ALL ON TABLE articvta TO nobody;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM frola;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO frola;
GRANT UPDATE ON SEQUENCE articvta_art_id_seq TO nobody;


--
-- Name: astcconccble; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE astcconccble FROM PUBLIC;
REVOKE ALL ON TABLE astcconccble FROM frola;
GRANT ALL ON TABLE astcconccble TO frola;
GRANT ALL ON TABLE astcconccble TO nobody;


--
-- Name: astcconccble_accb_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE astcconccble_accb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astcconccble_accb_id_seq FROM frola;
GRANT ALL ON SEQUENCE astcconccble_accb_id_seq TO frola;
GRANT UPDATE ON SEQUENCE astcconccble_accb_id_seq TO nobody;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM frola;
GRANT ALL ON TABLE astoctas TO frola;
GRANT ALL ON TABLE astoctas TO nobody;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM frola;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE astoctas_astc_id_seq TO nobody;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM frola;
GRANT ALL ON TABLE astoh TO frola;
GRANT ALL ON TABLE astoh TO nobody;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM frola;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO frola;
GRANT UPDATE ON SEQUENCE astoh_ash_id_seq TO nobody;


--
-- Name: auxint; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE auxint FROM PUBLIC;
REVOKE ALL ON TABLE auxint FROM frola;
GRANT ALL ON TABLE auxint TO frola;
GRANT ALL ON TABLE auxint TO nobody;


--
-- Name: auxint_ai_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE auxint_ai_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxint_ai_id_seq FROM frola;
GRANT ALL ON SEQUENCE auxint_ai_id_seq TO frola;
GRANT UPDATE ON SEQUENCE auxint_ai_id_seq TO nobody;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM frola;
GRANT ALL ON TABLE bancos TO frola;
GRANT ALL ON TABLE bancos TO nobody;


--
-- Name: cambtitu; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE cambtitu FROM PUBLIC;
REVOKE ALL ON TABLE cambtitu FROM frola;
GRANT ALL ON TABLE cambtitu TO frola;
GRANT ALL ON TABLE cambtitu TO nobody;


--
-- Name: cambtitu_cbt_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM frola;
GRANT ALL ON SEQUENCE cambtitu_cbt_id_seq TO frola;
GRANT UPDATE ON SEQUENCE cambtitu_cbt_id_seq TO nobody;


--
-- Name: cargos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE cargos FROM PUBLIC;
REVOKE ALL ON TABLE cargos FROM frola;
GRANT ALL ON TABLE cargos TO frola;
GRANT ALL ON TABLE cargos TO nobody;


--
-- Name: cargos_car_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM frola;
GRANT ALL ON SEQUENCE cargos_car_id_seq TO frola;
GRANT UPDATE ON SEQUENCE cargos_car_id_seq TO nobody;


--
-- Name: categincid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE categincid FROM PUBLIC;
REVOKE ALL ON TABLE categincid FROM frola;
GRANT ALL ON TABLE categincid TO frola;
GRANT ALL ON TABLE categincid TO nobody;


--
-- Name: categincid_cat_codigo_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE categincid_cat_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE categincid_cat_codigo_seq FROM frola;
GRANT ALL ON SEQUENCE categincid_cat_codigo_seq TO frola;
GRANT UPDATE ON SEQUENCE categincid_cat_codigo_seq TO nobody;


--
-- Name: catego; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
REVOKE ALL ON TABLE catego FROM frola;
GRANT ALL ON TABLE catego TO frola;
GRANT ALL ON TABLE catego TO nobody;


--
-- Name: centroc; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
REVOKE ALL ON TABLE centroc FROM frola;
GRANT ALL ON TABLE centroc TO frola;
GRANT ALL ON TABLE centroc TO nobody;


--
-- Name: centroc_cco_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM frola;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO frola;
GRANT UPDATE ON SEQUENCE centroc_cco_id_seq TO nobody;


--
-- Name: chat; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE chat FROM PUBLIC;
REVOKE ALL ON TABLE chat FROM zona;
GRANT ALL ON TABLE chat TO frola;
GRANT ALL ON TABLE chat TO nobody;


--
-- Name: chat_c_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE chat_c_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chat_c_id_seq FROM zona;
GRANT ALL ON SEQUENCE chat_c_id_seq TO frola;
GRANT UPDATE ON SEQUENCE chat_c_id_seq TO nobody;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM frola;
GRANT ALL ON TABLE cheques TO frola;
GRANT ALL ON TABLE cheques TO nobody;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM frola;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO frola;
GRANT UPDATE ON SEQUENCE cheques_chq_id_seq TO nobody;


--
-- Name: chequesaux; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE chequesaux FROM PUBLIC;
REVOKE ALL ON TABLE chequesaux FROM zona;
GRANT ALL ON TABLE chequesaux TO frola;
GRANT ALL ON TABLE chequesaux TO nobody;


--
-- Name: chequesaux_cqa_grupo_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE chequesaux_cqa_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chequesaux_cqa_grupo_seq FROM zona;
GRANT ALL ON SEQUENCE chequesaux_cqa_grupo_seq TO frola;
GRANT ALL ON SEQUENCE chequesaux_cqa_grupo_seq TO frola;
GRANT UPDATE ON SEQUENCE chequesaux_cqa_grupo_seq TO nobody;


--
-- Name: chequesaux_cqa_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE chequesaux_cqa_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chequesaux_cqa_id_seq FROM zona;
GRANT ALL ON SEQUENCE chequesaux_cqa_id_seq TO frola;
GRANT ALL ON SEQUENCE chequesaux_cqa_id_seq TO nobody;
GRANT ALL ON SEQUENCE chequesaux_cqa_id_seq TO frola;


--
-- Name: chqrech; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE chqrech FROM PUBLIC;
REVOKE ALL ON TABLE chqrech FROM frola;
GRANT ALL ON TABLE chqrech TO frola;
GRANT ALL ON TABLE chqrech TO nobody;


--
-- Name: chqrech_chqr_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM frola;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO frola;
GRANT UPDATE ON SEQUENCE chqrech_chqr_id_seq TO nobody;


--
-- Name: cobrxclq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE cobrxclq FROM PUBLIC;
REVOKE ALL ON TABLE cobrxclq FROM frola;
GRANT ALL ON TABLE cobrxclq TO frola;
GRANT ALL ON TABLE cobrxclq TO nobody;


--
-- Name: cobrxclq_cxc_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE cobrxclq_cxc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cobrxclq_cxc_id_seq FROM frola;
GRANT ALL ON SEQUENCE cobrxclq_cxc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE cobrxclq_cxc_id_seq TO nobody;


--
-- Name: compliq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE compliq FROM PUBLIC;
REVOKE ALL ON TABLE compliq FROM frola;
GRANT ALL ON TABLE compliq TO frola;
GRANT ALL ON TABLE compliq TO nobody;


--
-- Name: compliq_clq_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM frola;
GRANT ALL ON SEQUENCE compliq_clq_id_seq TO frola;
GRANT UPDATE ON SEQUENCE compliq_clq_id_seq TO nobody;


--
-- Name: compliquid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE compliquid FROM PUBLIC;
REVOKE ALL ON TABLE compliquid FROM frola;
GRANT ALL ON TABLE compliquid TO frola;
GRANT ALL ON TABLE compliquid TO nobody;


--
-- Name: compliquid_cl_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM frola;
GRANT ALL ON SEQUENCE compliquid_cl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE compliquid_cl_id_seq TO nobody;


--
-- Name: compra; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM frola;
GRANT ALL ON TABLE compra TO frola;
GRANT ALL ON TABLE compra TO nobody;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM frola;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO frola;
GRANT UPDATE ON SEQUENCE compra_cpra_id_seq TO nobody;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM frola;
GRANT ALL ON TABLE comprob TO frola;
GRANT ALL ON TABLE comprob TO nobody;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM frola;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO frola;
GRANT UPDATE ON SEQUENCE comprob_comp_id_seq TO nobody;


--
-- Name: comprop; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE comprop FROM PUBLIC;
REVOKE ALL ON TABLE comprop FROM frola;
GRANT ALL ON TABLE comprop TO frola;
GRANT ALL ON TABLE comprop TO nobody;


--
-- Name: comprop_cmpr_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM frola;
GRANT ALL ON SEQUENCE comprop_cmpr_id_seq TO frola;
GRANT UPDATE ON SEQUENCE comprop_cmpr_id_seq TO nobody;


--
-- Name: conccble; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE conccble FROM PUBLIC;
REVOKE ALL ON TABLE conccble FROM frola;
GRANT ALL ON TABLE conccble TO frola;
GRANT ALL ON TABLE conccble TO nobody;


--
-- Name: conccble_ccbl_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE conccble_ccbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conccble_ccbl_id_seq FROM frola;
GRANT ALL ON SEQUENCE conccble_ccbl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE conccble_ccbl_id_seq TO nobody;


--
-- Name: concilia; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON TABLE concilia FROM PUBLIC;
REVOKE ALL ON TABLE concilia FROM elm;
GRANT ALL ON TABLE concilia TO elm;
GRANT ALL ON TABLE concilia TO nobody;


--
-- Name: concilia_clia_id_seq; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM elm;
GRANT ALL ON SEQUENCE concilia_clia_id_seq TO elm;
GRANT UPDATE ON SEQUENCE concilia_clia_id_seq TO nobody;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM frola;
GRANT ALL ON TABLE coniva TO frola;
GRANT ALL ON TABLE coniva TO nobody;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM frola;
GRANT ALL ON TABLE conpag TO frola;
GRANT ALL ON TABLE conpag TO nobody;


--
-- Name: contratos; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
REVOKE ALL ON TABLE contratos FROM zona;
GRANT ALL ON TABLE contratos TO frola;
GRANT ALL ON TABLE contratos TO nobody;


--
-- Name: contratos_ct_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE contratos_ct_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contratos_ct_id_seq FROM zona;
GRANT ALL ON SEQUENCE contratos_ct_id_seq TO frola;
GRANT UPDATE ON SEQUENCE contratos_ct_id_seq TO nobody;


--
-- Name: convenios; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE convenios FROM PUBLIC;
REVOKE ALL ON TABLE convenios FROM frola;
GRANT ALL ON TABLE convenios TO frola;
GRANT ALL ON TABLE convenios TO nobody;


--
-- Name: convenios_con_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM frola;
GRANT ALL ON SEQUENCE convenios_con_id_seq TO frola;
GRANT UPDATE ON SEQUENCE convenios_con_id_seq TO nobody;


--
-- Name: conxclia; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON TABLE conxclia FROM PUBLIC;
REVOKE ALL ON TABLE conxclia FROM elm;
GRANT ALL ON TABLE conxclia TO elm;
GRANT ALL ON TABLE conxclia TO nobody;


--
-- Name: conxcxlia_cxlia_id_seq; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM elm;
GRANT ALL ON SEQUENCE conxcxlia_cxlia_id_seq TO elm;
GRANT UPDATE ON SEQUENCE conxcxlia_cxlia_id_seq TO nobody;


--
-- Name: coprop; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE coprop FROM PUBLIC;
REVOKE ALL ON TABLE coprop FROM frola;
GRANT ALL ON TABLE coprop TO frola;
GRANT ALL ON TABLE coprop TO nobody;


--
-- Name: coprop_cop_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM frola;
GRANT ALL ON SEQUENCE coprop_cop_id_seq TO frola;
GRANT UPDATE ON SEQUENCE coprop_cop_id_seq TO nobody;


--
-- Name: cotiza; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
REVOKE ALL ON TABLE cotiza FROM frola;
GRANT ALL ON TABLE cotiza TO frola;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM frola;
GRANT ALL ON TABLE ctacble TO frola;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM frola;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ctacble_cbl_id_seq TO nobody;


--
-- Name: ctasconv; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ctasconv FROM PUBLIC;
REVOKE ALL ON TABLE ctasconv FROM frola;
GRANT ALL ON TABLE ctasconv TO frola;
GRANT ALL ON TABLE ctasconv TO nobody;


--
-- Name: ctasconv_ctc_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM frola;
GRANT ALL ON SEQUENCE ctasconv_ctc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ctasconv_ctc_id_seq TO nobody;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM frola;
GRANT ALL ON TABLE ctes TO frola;
GRANT ALL ON TABLE ctes TO nobody;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM frola;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ctes_cte_id_seq TO nobody;


--
-- Name: descripliq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE descripliq FROM PUBLIC;
REVOKE ALL ON TABLE descripliq FROM frola;
GRANT ALL ON TABLE descripliq TO frola;
GRANT ALL ON TABLE descripliq TO nobody;


--
-- Name: descripliq_dlq_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE descripliq_dlq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE descripliq_dlq_id_seq FROM frola;
GRANT ALL ON SEQUENCE descripliq_dlq_id_seq TO frola;
GRANT UPDATE ON SEQUENCE descripliq_dlq_id_seq TO nobody;


--
-- Name: dinicial; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE dinicial FROM PUBLIC;
REVOKE ALL ON TABLE dinicial FROM frola;
GRANT ALL ON TABLE dinicial TO frola;
GRANT ALL ON TABLE dinicial TO nobody;


--
-- Name: dinicial_din_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE dinicial_din_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE dinicial_din_id_seq FROM frola;
GRANT ALL ON SEQUENCE dinicial_din_id_seq TO frola;
GRANT UPDATE ON SEQUENCE dinicial_din_id_seq TO nobody;


--
-- Name: division; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE division FROM PUBLIC;
REVOKE ALL ON TABLE division FROM frola;
GRANT ALL ON TABLE division TO frola;
GRANT ALL ON TABLE division TO nobody;


--
-- Name: division_div_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE division_div_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE division_div_id_seq FROM frola;
GRANT ALL ON SEQUENCE division_div_id_seq TO frola;
GRANT UPDATE ON SEQUENCE division_div_id_seq TO nobody;


--
-- Name: docum; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM frola;
GRANT ALL ON TABLE docum TO frola;
GRANT ALL ON TABLE docum TO nobody;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM frola;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE docum_doc_id_seq TO nobody;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM frola;
GRANT ALL ON TABLE emiti TO frola;
GRANT ALL ON TABLE emiti TO nobody;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM frola;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO frola;
GRANT UPDATE ON SEQUENCE emiti_emi_id_seq TO nobody;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM frola;
GRANT ALL ON TABLE empresa TO frola;
GRANT ALL ON TABLE empresa TO nobody;


--
-- Name: entidad; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
REVOKE ALL ON TABLE entidad FROM frola;
GRANT ALL ON TABLE entidad TO frola;
GRANT ALL ON TABLE entidad TO nobody;


--
-- Name: entidad_ent_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM frola;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO frola;
GRANT UPDATE ON SEQUENCE entidad_ent_id_seq TO nobody;


--
-- Name: estincid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE estincid FROM PUBLIC;
REVOKE ALL ON TABLE estincid FROM frola;
GRANT ALL ON TABLE estincid TO frola;
GRANT ALL ON TABLE estincid TO nobody;


--
-- Name: estincid_est_codigo_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE estincid_est_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE estincid_est_codigo_seq FROM frola;
GRANT ALL ON SEQUENCE estincid_est_codigo_seq TO frola;
GRANT UPDATE ON SEQUENCE estincid_est_codigo_seq TO nobody;


--
-- Name: estjud; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE estjud FROM PUBLIC;
REVOKE ALL ON TABLE estjud FROM frola;
GRANT ALL ON TABLE estjud TO frola;
GRANT ALL ON TABLE estjud TO nobody;


--
-- Name: estjurid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE estjurid FROM PUBLIC;
REVOKE ALL ON TABLE estjurid FROM frola;
GRANT ALL ON TABLE estjurid TO frola;
GRANT ALL ON TABLE estjurid TO nobody;


--
-- Name: eventos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE eventos FROM PUBLIC;
REVOKE ALL ON TABLE eventos FROM frola;
GRANT ALL ON TABLE eventos TO frola;
GRANT ALL ON TABLE eventos TO nobody;


--
-- Name: eventos_evt_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM frola;
GRANT ALL ON SEQUENCE eventos_evt_id_seq TO frola;
GRANT UPDATE ON SEQUENCE eventos_evt_id_seq TO nobody;


--
-- Name: factpend; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE factpend FROM PUBLIC;
REVOKE ALL ON TABLE factpend FROM frola;
GRANT ALL ON TABLE factpend TO frola;
GRANT ALL ON TABLE factpend TO nobody;


--
-- Name: factpend_fap_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM frola;
GRANT ALL ON SEQUENCE factpend_fap_id_seq TO frola;
GRANT UPDATE ON SEQUENCE factpend_fap_id_seq TO nobody;


--
-- Name: firman; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM frola;
GRANT ALL ON TABLE firman TO frola;
GRANT ALL ON TABLE firman TO nobody;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM frola;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO frola;
GRANT UPDATE ON SEQUENCE firman_fir_id_seq TO nobody;


--
-- Name: formapagooc; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE formapagooc FROM PUBLIC;
REVOKE ALL ON TABLE formapagooc FROM frola;
GRANT ALL ON TABLE formapagooc TO frola;
GRANT ALL ON TABLE formapagooc TO nobody;


--
-- Name: formapagooc_fp_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE formapagooc_fp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE formapagooc_fp_id_seq FROM frola;
GRANT ALL ON SEQUENCE formapagooc_fp_id_seq TO frola;
GRANT UPDATE ON SEQUENCE formapagooc_fp_id_seq TO nobody;


--
-- Name: gastos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE gastos FROM PUBLIC;
REVOKE ALL ON TABLE gastos FROM frola;
GRANT ALL ON TABLE gastos TO frola;
GRANT ALL ON TABLE gastos TO nobody;


--
-- Name: gastos_gto_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM frola;
GRANT ALL ON SEQUENCE gastos_gto_id_seq TO frola;
GRANT UPDATE ON SEQUENCE gastos_gto_id_seq TO nobody;


--
-- Name: grupof_d; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE grupof_d FROM PUBLIC;
REVOKE ALL ON TABLE grupof_d FROM zona;
GRANT ALL ON TABLE grupof_d TO frola;
GRANT ALL ON TABLE grupof_d TO nobody;


--
-- Name: grupof_d_gf_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE grupof_d_gf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupof_d_gf_id_seq FROM zona;
GRANT ALL ON SEQUENCE grupof_d_gf_id_seq TO frola;
GRANT UPDATE ON SEQUENCE grupof_d_gf_id_seq TO nobody;


--
-- Name: grupof_inq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE grupof_inq FROM PUBLIC;
REVOKE ALL ON TABLE grupof_inq FROM zona;
GRANT ALL ON TABLE grupof_inq TO frola;
GRANT ALL ON TABLE grupof_inq TO nobody;


--
-- Name: grupof_inq_gf_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE grupof_inq_gf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupof_inq_gf_id_seq FROM zona;
GRANT ALL ON SEQUENCE grupof_inq_gf_id_seq TO frola;
GRANT UPDATE ON SEQUENCE grupof_inq_gf_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM frola;
GRANT ALL ON TABLE grupos TO frola;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: gtoxliqe; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE gtoxliqe FROM PUBLIC;
REVOKE ALL ON TABLE gtoxliqe FROM frola;
GRANT ALL ON TABLE gtoxliqe TO frola;
GRANT ALL ON TABLE gtoxliqe TO nobody;


--
-- Name: gtoxoc; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE gtoxoc FROM PUBLIC;
REVOKE ALL ON TABLE gtoxoc FROM frola;
GRANT ALL ON TABLE gtoxoc TO frola;
GRANT ALL ON TABLE gtoxoc TO nobody;


--
-- Name: gtoxoc_gxo_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE gtoxoc_gxo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gtoxoc_gxo_id_seq FROM frola;
GRANT ALL ON SEQUENCE gtoxoc_gxo_id_seq TO frola;
GRANT UPDATE ON SEQUENCE gtoxoc_gxo_id_seq TO nobody;


--
-- Name: honorarios; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE honorarios FROM PUBLIC;
REVOKE ALL ON TABLE honorarios FROM frola;
GRANT ALL ON TABLE honorarios TO frola;
GRANT ALL ON TABLE honorarios TO nobody;


--
-- Name: honorarios_hon_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM frola;
GRANT ALL ON SEQUENCE honorarios_hon_id_seq TO frola;
GRANT UPDATE ON SEQUENCE honorarios_hon_id_seq TO nobody;


--
-- Name: imgincid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE imgincid FROM PUBLIC;
REVOKE ALL ON TABLE imgincid FROM frola;
GRANT ALL ON TABLE imgincid TO frola;
GRANT ALL ON TABLE imgincid TO nobody;


--
-- Name: imgincid_img_codigo_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE imgincid_img_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE imgincid_img_codigo_seq FROM frola;
GRANT ALL ON SEQUENCE imgincid_img_codigo_seq TO frola;
GRANT UPDATE ON SEQUENCE imgincid_img_codigo_seq TO nobody;


--
-- Name: importoliq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE importoliq FROM PUBLIC;
REVOKE ALL ON TABLE importoliq FROM frola;
GRANT ALL ON TABLE importoliq TO frola;
GRANT ALL ON TABLE importoliq TO nobody;


--
-- Name: importoliq_imp_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE importoliq_imp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE importoliq_imp_id_seq FROM frola;
GRANT ALL ON SEQUENCE importoliq_imp_id_seq TO frola;
GRANT UPDATE ON SEQUENCE importoliq_imp_id_seq TO nobody;


--
-- Name: incidencias; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE incidencias FROM PUBLIC;
REVOKE ALL ON TABLE incidencias FROM frola;
GRANT ALL ON TABLE incidencias TO frola;
GRANT ALL ON TABLE incidencias TO nobody;


--
-- Name: incidencias_in_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE incidencias_in_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE incidencias_in_id_seq FROM frola;
GRANT ALL ON SEQUENCE incidencias_in_id_seq TO frola;
GRANT UPDATE ON SEQUENCE incidencias_in_id_seq TO nobody;


--
-- Name: interes; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM frola;
GRANT ALL ON TABLE interes TO frola;
GRANT ALL ON TABLE interes TO nobody;


--
-- Name: judicial; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE judicial FROM PUBLIC;
REVOKE ALL ON TABLE judicial FROM frola;
GRANT ALL ON TABLE judicial TO frola;
GRANT ALL ON TABLE judicial TO nobody;


--
-- Name: judicial_jud_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM frola;
GRANT ALL ON SEQUENCE judicial_jud_id_seq TO frola;
GRANT UPDATE ON SEQUENCE judicial_jud_id_seq TO nobody;


--
-- Name: liqegr; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE liqegr FROM PUBLIC;
REVOKE ALL ON TABLE liqegr FROM frola;
GRANT ALL ON TABLE liqegr TO frola;
GRANT ALL ON TABLE liqegr TO nobody;


--
-- Name: liqegr_eg_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM frola;
GRANT ALL ON SEQUENCE liqegr_eg_id_seq TO frola;
GRANT UPDATE ON SEQUENCE liqegr_eg_id_seq TO nobody;


--
-- Name: liqui; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE liqui FROM PUBLIC;
REVOKE ALL ON TABLE liqui FROM frola;
GRANT ALL ON TABLE liqui TO frola;
GRANT ALL ON TABLE liqui TO nobody;


--
-- Name: liqui_lq_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE liqui_lq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqui_lq_id_seq FROM frola;
GRANT ALL ON SEQUENCE liqui_lq_id_seq TO frola;
GRANT UPDATE ON SEQUENCE liqui_lq_id_seq TO nobody;


--
-- Name: liquidacion; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE liquidacion FROM PUBLIC;
REVOKE ALL ON TABLE liquidacion FROM frola;
GRANT ALL ON TABLE liquidacion TO frola;
GRANT ALL ON TABLE liquidacion TO nobody;


--
-- Name: liquidacion_l_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM frola;
GRANT ALL ON SEQUENCE liquidacion_l_id_seq TO frola;
GRANT UPDATE ON SEQUENCE liquidacion_l_id_seq TO nobody;


--
-- Name: logosptv; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE logosptv FROM PUBLIC;
REVOKE ALL ON TABLE logosptv FROM zona;
GRANT ALL ON TABLE logosptv TO frola;
GRANT ALL ON TABLE logosptv TO nobody;


--
-- Name: menues; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE menues FROM PUBLIC;
REVOKE ALL ON TABLE menues FROM zona;
GRANT ALL ON TABLE menues TO frola;
GRANT ALL ON TABLE menues TO nobody;


--
-- Name: menues_men_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE menues_men_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE menues_men_id_seq FROM zona;
GRANT ALL ON SEQUENCE menues_men_id_seq TO frola;
GRANT UPDATE ON SEQUENCE menues_men_id_seq TO nobody;


--
-- Name: modlogs; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE modlogs FROM PUBLIC;
REVOKE ALL ON TABLE modlogs FROM zona;
GRANT ALL ON TABLE modlogs TO frola;
GRANT ALL ON TABLE modlogs TO nobody;


--
-- Name: modlogs_log_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM zona;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO frola;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO frola;
GRANT UPDATE ON SEQUENCE modlogs_log_id_seq TO nobody;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM frola;
GRANT ALL ON TABLE moneda TO frola;
GRANT ALL ON TABLE moneda TO nobody;


--
-- Name: monex; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM frola;
GRANT ALL ON TABLE monex TO frola;
GRANT ALL ON TABLE monex TO nobody;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM frola;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO frola;
GRANT UPDATE ON SEQUENCE monex_mne_id_seq TO nobody;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM frola;
GRANT ALL ON TABLE movsto TO frola;
GRANT ALL ON TABLE movsto TO nobody;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM frola;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO frola;
GRANT UPDATE ON SEQUENCE movsto_movs_id_seq TO nobody;


--
-- Name: notdeb; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE notdeb FROM PUBLIC;
REVOKE ALL ON TABLE notdeb FROM frola;
GRANT ALL ON TABLE notdeb TO frola;
GRANT ALL ON TABLE notdeb TO nobody;


--
-- Name: notdeb_nd_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM frola;
GRANT ALL ON SEQUENCE notdeb_nd_id_seq TO frola;
GRANT UPDATE ON SEQUENCE notdeb_nd_id_seq TO nobody;


--
-- Name: noticias; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
REVOKE ALL ON TABLE noticias FROM frola;
GRANT ALL ON TABLE noticias TO frola;
GRANT ALL ON TABLE noticias TO nobody;


--
-- Name: noticias_not_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM frola;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO frola;
GRANT UPDATE ON SEQUENCE noticias_not_id_seq TO nobody;


--
-- Name: ocsingtos; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ocsingtos FROM PUBLIC;
REVOKE ALL ON TABLE ocsingtos FROM frola;
GRANT ALL ON TABLE ocsingtos TO frola;
GRANT ALL ON TABLE ocsingtos TO nobody;


--
-- Name: ocsingtos_osg_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ocsingtos_osg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ocsingtos_osg_id_seq FROM frola;
GRANT ALL ON SEQUENCE ocsingtos_osg_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ocsingtos_osg_id_seq TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM frola;
GRANT ALL ON TABLE operadores TO frola;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM frola;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO frola;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: operincid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE operincid FROM PUBLIC;
REVOKE ALL ON TABLE operincid FROM frola;
GRANT ALL ON TABLE operincid TO frola;
GRANT ALL ON TABLE operincid TO nobody;


--
-- Name: operincid_oi_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE operincid_oi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operincid_oi_id_seq FROM frola;
GRANT ALL ON SEQUENCE operincid_oi_id_seq TO frola;
GRANT UPDATE ON SEQUENCE operincid_oi_id_seq TO nobody;


--
-- Name: ordencompra; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ordencompra FROM PUBLIC;
REVOKE ALL ON TABLE ordencompra FROM frola;
GRANT ALL ON TABLE ordencompra TO frola;
GRANT ALL ON TABLE ordencompra TO nobody;


--
-- Name: ordencompra_oc_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ordencompra_oc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ordencompra_oc_id_seq FROM frola;
GRANT ALL ON SEQUENCE ordencompra_oc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ordencompra_oc_id_seq TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM frola;
GRANT ALL ON TABLE pais TO frola;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: priorincid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE priorincid FROM PUBLIC;
REVOKE ALL ON TABLE priorincid FROM frola;
GRANT ALL ON TABLE priorincid TO frola;
GRANT ALL ON TABLE priorincid TO nobody;


--
-- Name: priorincid_pri_codigo_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE priorincid_pri_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE priorincid_pri_codigo_seq FROM frola;
GRANT ALL ON SEQUENCE priorincid_pri_codigo_seq TO frola;
GRANT UPDATE ON SEQUENCE priorincid_pri_codigo_seq TO nobody;


--
-- Name: prove; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM frola;
GRANT ALL ON TABLE prove TO frola;
GRANT ALL ON TABLE prove TO nobody;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM frola;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO frola;
GRANT UPDATE ON SEQUENCE prove_prov_id_seq TO nobody;


--
-- Name: provin; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM frola;
GRANT ALL ON TABLE provin TO frola;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM frola;
GRANT ALL ON TABLE ptovta TO frola;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM frola;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO frola;
GRANT UPDATE ON SEQUENCE ptovta_ptv_id_seq TO nobody;


--
-- Name: relmenu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE relmenu FROM PUBLIC;
REVOKE ALL ON TABLE relmenu FROM zona;
GRANT ALL ON TABLE relmenu TO frola;
GRANT ALL ON TABLE relmenu TO nobody;


--
-- Name: relmenu_rmen_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM zona;
GRANT ALL ON SEQUENCE relmenu_rmen_id_seq TO frola;
GRANT UPDATE ON SEQUENCE relmenu_rmen_id_seq TO nobody;


--
-- Name: revisliq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE revisliq FROM PUBLIC;
REVOKE ALL ON TABLE revisliq FROM zona;
GRANT ALL ON TABLE revisliq TO frola;
GRANT ALL ON TABLE revisliq TO nobody;


--
-- Name: revisliq_rl_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE revisliq_rl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE revisliq_rl_id_seq FROM zona;
GRANT ALL ON SEQUENCE revisliq_rl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE revisliq_rl_id_seq TO nobody;


--
-- Name: rubcar; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE rubcar FROM PUBLIC;
REVOKE ALL ON TABLE rubcar FROM frola;
GRANT ALL ON TABLE rubcar TO frola;
GRANT ALL ON TABLE rubcar TO nobody;


--
-- Name: rubcar_rubl_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM frola;
GRANT ALL ON SEQUENCE rubcar_rubl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE rubcar_rubl_id_seq TO nobody;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM frola;
GRANT ALL ON TABLE rubros TO frola;
GRANT ALL ON TABLE rubros TO nobody;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM frola;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO frola;
GRANT UPDATE ON SEQUENCE rubros_rub_id_seq TO nobody;


--
-- Name: scangto; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE scangto FROM PUBLIC;
REVOKE ALL ON TABLE scangto FROM zona;
GRANT ALL ON TABLE scangto TO frola;
GRANT ALL ON TABLE scangto TO nobody;


--
-- Name: scangto_sc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE scangto_sc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE scangto_sc_id_seq FROM zona;
GRANT ALL ON SEQUENCE scangto_sc_id_seq TO frola;
GRANT UPDATE ON SEQUENCE scangto_sc_id_seq TO nobody;


--
-- Name: seccion; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
REVOKE ALL ON TABLE seccion FROM frola;
GRANT ALL ON TABLE seccion TO frola;
GRANT ALL ON TABLE seccion TO nobody;


--
-- Name: sinicial; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE sinicial FROM PUBLIC;
REVOKE ALL ON TABLE sinicial FROM frola;
GRANT ALL ON TABLE sinicial TO frola;
GRANT ALL ON TABLE sinicial TO nobody;


--
-- Name: sinicial_sin_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE sinicial_sin_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE sinicial_sin_id_seq FROM frola;
GRANT ALL ON SEQUENCE sinicial_sin_id_seq TO frola;
GRANT UPDATE ON SEQUENCE sinicial_sin_id_seq TO nobody;


--
-- Name: srubcar; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE srubcar FROM PUBLIC;
REVOKE ALL ON TABLE srubcar FROM frola;
GRANT ALL ON TABLE srubcar TO frola;
GRANT ALL ON TABLE srubcar TO nobody;


--
-- Name: srubcar_srbl_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM frola;
GRANT ALL ON SEQUENCE srubcar_srbl_id_seq TO frola;
GRANT UPDATE ON SEQUENCE srubcar_srbl_id_seq TO nobody;


--
-- Name: subd; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM frola;
GRANT ALL ON TABLE subd TO frola;
GRANT ALL ON TABLE subd TO nobody;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM frola;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO frola;
GRANT UPDATE ON SEQUENCE subd_subd_id_seq TO nobody;


--
-- Name: subrub; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
REVOKE ALL ON TABLE subrub FROM frola;
GRANT ALL ON TABLE subrub TO frola;
GRANT ALL ON TABLE subrub TO nobody;


--
-- Name: subrub_srb_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM frola;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO frola;
GRANT UPDATE ON SEQUENCE subrub_srb_id_seq TO nobody;


--
-- Name: sucursal; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE sucursal FROM PUBLIC;
REVOKE ALL ON TABLE sucursal FROM frola;
GRANT ALL ON TABLE sucursal TO frola;
GRANT ALL ON TABLE sucursal TO nobody;


--
-- Name: talon; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM frola;
GRANT ALL ON TABLE talon TO frola;
GRANT ALL ON TABLE talon TO nobody;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM frola;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO frola;
GRANT UPDATE ON SEQUENCE talon_tal_id_seq TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM frola;
GRANT ALL ON TABLE telefon TO frola;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM frola;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO frola;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM frola;
GRANT ALL ON TABLE tipcta TO frola;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM frola;
GRANT ALL ON TABLE tipdocu TO frola;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM frola;
GRANT ALL ON TABLE tipemp TO frola;
GRANT ALL ON TABLE tipemp TO nobody;


--
-- Name: tipempr; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipempr FROM PUBLIC;
REVOKE ALL ON TABLE tipempr FROM frola;
GRANT ALL ON TABLE tipempr TO frola;
GRANT ALL ON TABLE tipempr TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM frola;
GRANT ALL ON TABLE tipentid TO frola;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipgto; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipgto FROM PUBLIC;
REVOKE ALL ON TABLE tipgto FROM frola;
GRANT ALL ON TABLE tipgto TO frola;
GRANT ALL ON TABLE tipgto TO nobody;


--
-- Name: tipgto_tg_id_seq; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON SEQUENCE tipgto_tg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipgto_tg_id_seq FROM frola;
GRANT ALL ON SEQUENCE tipgto_tg_id_seq TO frola;
GRANT UPDATE ON SEQUENCE tipgto_tg_id_seq TO nobody;


--
-- Name: tipnot; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipnot FROM PUBLIC;
REVOKE ALL ON TABLE tipnot FROM frola;
GRANT ALL ON TABLE tipnot TO frola;
GRANT ALL ON TABLE tipnot TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM frola;
GRANT ALL ON TABLE tiptel TO frola;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tipuf; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE tipuf FROM PUBLIC;
REVOKE ALL ON TABLE tipuf FROM frola;
GRANT ALL ON TABLE tipuf TO frola;
GRANT ALL ON TABLE tipuf TO nobody;


--
-- Name: usermenu; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE usermenu FROM PUBLIC;
REVOKE ALL ON TABLE usermenu FROM zona;
GRANT ALL ON TABLE usermenu TO frola;
GRANT ALL ON TABLE usermenu TO nobody;


--
-- Name: usermenu_umen_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM zona;
GRANT ALL ON SEQUENCE usermenu_umen_id_seq TO frola;
GRANT UPDATE ON SEQUENCE usermenu_umen_id_seq TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM frola;
GRANT ALL ON TABLE varamb TO frola;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM frola;
GRANT ALL ON TABLE varambi TO frola;
GRANT ALL ON TABLE varambi TO nobody;


--
-- Name: zona; Type: ACL; Schema: public; Owner: frola
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM frola;
GRANT ALL ON TABLE zona TO frola;
GRANT ALL ON TABLE zona TO nobody;


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

--
-- Data for Name: empresa; Type: TABLE DATA; Schema: public; Owner: frola
--

SET SESSION AUTHORIZATION DEFAULT;

ALTER TABLE empresa DISABLE TRIGGER ALL;

COPY empresa (emp_codigo, emp_nombre, emp_direcc, emp_locali, emp_codpos, emp_provin, emp_pais, emp_nrcuit, emp_estado, emp_tipo, emp_coniva, emp_anti, emp_fecint, emp_grupo, emp_redond, emp_nomabr) FROM stdin;
1	ADMINISTRACION SAN JORGE S.R.L.	RUTA 8 KM 51 OF: 8 PASEO EL MIRADOR	PILAR	1629	1	200	30-71176072-1	1	3	1	\N	\N	\N	\N	\N
\.


ALTER TABLE empresa ENABLE TRIGGER ALL;

--
-- Data for Name: cargos; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE cargos DISABLE TRIGGER ALL;

COPY cargos (car_id, car_codemp, car_idptov, car_division, car_centro, car_codigo, car_nombre, car_rubcar, car_srubcar, car_genint, car_interes, car_precio, car_tasa, car_estado, car_funcion, car_leyen, car_ctacble) FROM stdin;
40	1	-1	14	10	1130	FONDO DE DEPORTES	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO DE DEPORTES	1353
41	1	-1	14	10	1140	FONDO SIN FIN ESPECIFICO	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO SIN FIN ESPECIFICO	1353
15	1	-1	14	10	430	OTROS GASTOS JUDICIALES	4	4	1	1.00000	0.00000	\N	1		OTROS GASTOS JUDICIALES	1356
1	1	-1	14	10	101	EXPENSAS ORDINARIAS	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS	1352
2	1	-1	14	10	110	EXPENSAS ORDINARIAS B	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS B	1406
3	1	-1	14	10	120	EXPENSAS ORDINARIAS C	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS C	1407
4	1	-1	14	10	130	EXPENSAS ORDINARIAS D	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS D	1408
5	1	-1	14	10	140	EXPENSAS ORDINARIAS E	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS E	1409
6	1	-1	14	10	201	EXPENSAS EXTRAORDINARIAS	2	2	1	1.00000	0.00000	0.00000	1	\N	EXPENSAS EXTRAORDINARIAS	1306
7	1	-1	14	10	301	CORTE DE CESPED	3	3	1	1.00000	0.00000	\N	1		CORTE DE CESPED	1405
8	1	-1	14	10	310	REPARACIONES PARTICULARES	3	3	1	1.00000	0.00000	0.00000	1	\N	REPARACIONES PARTICULARES	1308
17	1	-1	14	10	511	CANON DE OBRA	5	5	1	1.00000	0.00000	\N	1		CANON DE OBRA	1398
11	1	-1	14	10	410	CONFECCION Y ENVIO DE CARTAS DOCUMENTOS GESTION MOROSIDAD	4	4	1	1.00000	0.00000	0.00000	1	\N	CONFECCION Y ENVIO DE CARTAS DOCUMENTOS GESTION MOROSIDAD	1356
19	1	-1	14	10	610	ENERGIA ELECTRICA	6	6	1	1.00000	0.00000	\N	1		ENERGIA ELECTRICA	1314
20	1	-1	14	10	620	S.U.M.	6	6	1	1.00000	0.00000	\N	1		S.U.M.	1402
21	1	-1	14	10	630	CORREO	6	6	1	1.00000	0.00000	\N	1		CORREO	1375
22	1	-1	14	10	640	FOTOCOPIAS	6	6	1	1.00000	0.00000	\N	1		FOTOCOPIAS	1332
23	1	-1	14	10	650	FUTBOL	6	6	1	1.00000	0.00000	\N	1		FUTBOL	1400
24	1	-1	14	10	652	LUZ CANCHAS DE TENIS	6	6	1	1.00000	0.00000	\N	1		LUZ CANCHAS DE TENIS	1403
25	1	-1	14	10	654	PISCINA	6	6	1	1.00000	0.00000	\N	1		PISCINA	1400
26	1	-1	14	10	656	LAUDRY	6	6	1	1.00000	0.00000	\N	1		LAUDRY	1404
27	1	-1	14	10	660	EVENTOS	6	6	1	1.00000	0.00000	0.00000	1	\N	EVENTOS	1357
28	1	-1	14	10	710	COBRANZAS	7	7	1	1.00000	0.00000	0.00000	1	\N	COBRANZAS	1230
13	1	-1	14	10	430	GASTOS JUDICIALES O PREJUDICIALES REINTEGRABLES	4	4	1	1.00000	0.00000	\N	1		GASTOS JUDICIALES O PREJUDICIALES REINTEGRABLES	1356
9	1	-1	14	10	320	ENVIO DE LIQUIDACIONES POR CORREO	3	3	1	1.00000	0.00000	\N	1		ENVIO DE LIQUIDACIONES POR CORREO	1375
10	1	-1	14	10	390	OTROS REINTEGROS	3	3	1	1.00000	0.00000	0.00000	1	\N	OTROS REINTEGROS	1308
44	1	-1	14	10	830	INTERES RESARCITORIO	12	10	3	2.00000	0.00000	0.00000	1	\N	INTERES RESARCITORIO	1355
33	1	-1	14	10	810	AJUSTES DE MULTAS	7	8	1	1.00000	0.00000	\N	1		AJUSTES DE MULTAS	1399
31	1	-1	14	10	810	AJUSTES POR PAGO EN TERMINO	7	8	1	1.00000	0.00000	\N	1		AJUSTES POR PAGO EN TERMINO	1352
32	1	-1	14	10	810	AJUSTES POR ERROR EN LA IMPUTACION	7	8	1	1.00000	0.00000	\N	1		AJUSTES POR ERROR EN LA IMPUTACION	1358
34	1	-1	14	10	810	AJUSTES DE INTERESES	7	8	1	1.00000	0.00000	\N	1		AJUSTES DE INTERESES	1355
35	1	-1	14	10	810	AJUSTES VARIOS	7	8	1	1.00000	0.00000	0.00000	1	\N	AJUSTES VARIOS	1358
38	1	-1	14	10	1110	FONDO DE OBRA	11	12	1	1.00000	0.00000	\N	1		FONDO DE OBRA	1398
18	1	-1	14	10	520	MULTAS	5	5	2	2.00000	0.00000	\N	1		MULTAS	1399
14	1	-1	14	10	420	HONORARIOS LETRADOS	4	4	1	1.00000	0.00000	0.00000	1	\N	HONORARIOS LETRADOS	1356
54	1	-1	14	10	500	AJUSTE POR REDONDEO	6	6	2	1.00000	0.00000	0.00000	1	\N	AJUSTE POR REDONDEO	1410
55	1	-1	14	10	510	IDENTIFICADOR DE UNIDAD FUNCIONAL	6	6	2	1.00000	0.00000	0.00000	1	\N	IDENTIFICADOR DE UNIDAD FUNCIONAL	1410
37	1	-1	14	10	1010	FONDO DE RESERVA	10	11	1	1.00000	0.00000	\N	1		FONDO DE RESERVA	1354
61	1	-1	14	10	410	GRUPO FAMILIAR	5	5	1	1.00000	0.00000	\N	1		CANTIDAD PERSONAS GRUPO FAMILIAR	1381
58	1	-1	\N	\N	1180	SERVICIO DE AGUA	11	12	1	1.00000	0.00000	0.00000	1	\N	SERVICIO DE AGUA	1316
59	1	-1	\N	\N	1185	ARBA	11	12	1	1.00000	0.00000	\N	1		ARBA	1395
60	1	-1	\N	\N	1187	IMPUESTO MUNICIPAL	11	12	1	1.00000	0.00000	0.00000	1	\N	\N	1338
62	1	-1	14	10	655	INVITADOS DE PISCINA	6	6	1	1.00000	0.00000	0.00000	1	\N	Invitadios de Piscina	1400
64	1	-1	14	10	5000	UNIDAD COMPLEM.	5	5	1	1.00000	120.00000	0.00000	1	\N	Unidad Complementaria	1352
29	1	-1	14	10	720	IDENTIFICACION DE DEPOSITOS	7	7	1	1.00000	0.00000	0.00000	1	\N	IDENTIFICACION DE DEPOSITOS	1230
12	1	-1	14	10	420	SOLICITUD DE INFORMES DE DOMINIO	4	4	1	1.00000	0.00000	0.00000	1	\N	SOLICITUD DE INFORMES DE DOMINIO	1356
16	1	-1	14	10	510	INGRESO DE CAMIONES	5	5	1	1.00000	0.00000	0.00000	1	\N	INGRESO DE CAMIONES	1357
46	1	-1	14	10	\N	SALDO INICIAL QUE GENERA INTERESES	13	13	1	1.00000	0.00000	0.00000	1	\N	SALDO INICIAL QUE GENERA INTERESES	1359
47	1	-1	14	10	\N	SALDO INICIAL QUE NO GENERA INTERESES	13	13	1	2.00000	0.00000	0.00000	1	\N	SALDO INICIAL QUE NO GENERA INTERESES	1359
30	1	-1	14	10	730	IDENTIFICACION DE DEPOSITOS PERIODOS ANTERIORES	7	7	1	1.00000	0.00000	0.00000	1	\N	IDENTIFICACION DE DEPOSITOS PERIODOS ANTERIORES	1230
36	1	-1	14	10	910	CONVENIOS DE PAGO	9	9	1	1.00000	0.00000	0.00000	1	\N	CONVENIOS DE PAGO	1230
63	1	-1	14	10	658	INVTADOS DE TENIS	6	6	1	1.00000	0.00000	0.00000	1	\N	INVTADOS DE TENIS	1403
39	1	-1	14	10	1120	FONDO DE EVENTOS	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO DE EVENTOS	1353
65	1	-1	14	10	600	MERIENDA	5	5	1	1.00000	0.00000	0.00000	1	\N	MERIENDA	1323
72	1	-1	14	10	1001	CUOTA MAYOR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA MAYOR	1352
66	1	-1	14	10	601	MANTENIMIENTO POR LOTE	5	5	1	1.00000	0.00000	0.00000	1	\N	MANTENMIENTO POR LOTE	1321
67	1	-1	14	10	602	TRABAJO TARIFADO	5	5	1	1.00000	0.00000	0.00000	1	\N	TRABAJO TARIFADO	1328
68	1	-1	14	10	603	ALQUILER DE QUINCHO	5	5	1	1.00000	0.00000	0.00000	1	\N	ALQUILER DE QUINCHO	1331
69	1	42	46	45	134	PESOS TRONCO	6	6	1	1.00000	204.00000	0.00000	1	\N	Pesos Tronco	1378
70	1	-1	\N	\N	302	DEBITOS POR TARJETA	6	6	1	1.00000	0.00000	0.00000	1	\N	DEBITOS POR TARJETA	1413
71	1	-1	14	10	1000	CUOTA GRUPO FAMILIAR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA GRUPO FAMILIAR	1352
73	1	-1	14	10	1002	CUOTA MENOR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA MENOR	1352
74	1	-1	14	10	2500	EXPENSAS DE LOCACION	5	5	1	1.00000	0.00000	0.00000	1	\N	Expensas de Locacion	1352
75	1	42	46	45	41	DERECHO DE INCORPORACION	6	6	1	1.00000	0.00000	0.00000	1	\N	DERECHO DE INCORPORACION	1323
76	1	42	46	45	42	INVITADOS ACTIVIDAD MENORES	6	6	1	1.00000	0.00000	0.00000	1	\N	INVITADOS ACTIVIDAD MENORES	1345
77	1	-1	14	10	101	AJUSTE DE INTERES QUE NO GENERA INTERESES	7	8	3	1.00000	0.00000	0.00000	1	\N	Ajuste de intereses.	1355
78	1	-1	14	10	9999	OTROS CARGOS	5	5	1	1.00000	0.00000	0.00000	1	\N	Otros Cargos	1357
79	1	-1	14	10	124	TARJETAS DE ACCESO	5	5	1	1.00000	0.00000	0.00000	1	\N	Tarjetas de Acceso	1328
82	3	-1	27	24	1130	FONDO DE DEPORTES	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO DE DEPORTES	1353
83	3	-1	27	24	1140	FONDO SIN FIN ESPECIFICO	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO SIN FIN ESPECIFICO	1353
84	3	-1	27	24	430	OTROS GASTOS JUDICIALES	4	4	1	1.00000	0.00000	\N	1		OTROS GASTOS JUDICIALES	1356
85	3	-1	27	24	101	EXPENSAS ORDINARIAS	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS	1352
86	3	-1	27	24	110	EXPENSAS ORDINARIAS B	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS B	1406
87	3	-1	27	24	120	EXPENSAS ORDINARIAS C	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS C	1407
88	3	-1	27	24	130	EXPENSAS ORDINARIAS D	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS D	1408
89	3	-1	27	24	140	EXPENSAS ORDINARIAS E	1	1	1	1.00000	0.00000	\N	1		EXPENSAS ORDINARIAS E	1409
90	3	-1	27	24	201	EXPENSAS EXTRAORDINARIAS	2	2	1	1.00000	0.00000	0.00000	1	\N	EXPENSAS EXTRAORDINARIAS	1306
91	3	-1	27	24	301	CORTE DE CESPED	3	3	1	1.00000	0.00000	\N	1		CORTE DE CESPED	1405
92	3	-1	27	24	310	REPARACIONES PARTICULARES	3	3	1	1.00000	0.00000	0.00000	1	\N	REPARACIONES PARTICULARES	1308
93	3	-1	27	24	511	CANON DE OBRA	5	5	1	1.00000	0.00000	\N	1		CANON DE OBRA	1398
94	3	-1	27	24	410	CONFECCION Y ENVIO DE CARTAS DOCUMENTOS GESTION MOROSIDAD	4	4	1	1.00000	0.00000	0.00000	1	\N	CONFECCION Y ENVIO DE CARTAS DOCUMENTOS GESTION MOROSIDAD	1356
95	3	-1	27	24	610	ENERGIA ELECTRICA	6	6	1	1.00000	0.00000	\N	1		ENERGIA ELECTRICA	1314
96	3	-1	27	24	620	S.U.M.	6	6	1	1.00000	0.00000	\N	1		S.U.M.	1402
97	3	-1	27	24	630	CORREO	6	6	1	1.00000	0.00000	\N	1		CORREO	1375
98	3	-1	27	24	640	FOTOCOPIAS	6	6	1	1.00000	0.00000	\N	1		FOTOCOPIAS	1332
99	3	-1	27	24	650	FUTBOL	6	6	1	1.00000	0.00000	\N	1		FUTBOL	1400
100	3	-1	27	24	652	LUZ CANCHAS DE TENIS	6	6	1	1.00000	0.00000	\N	1		LUZ CANCHAS DE TENIS	1403
101	3	-1	27	24	654	PISCINA	6	6	1	1.00000	0.00000	\N	1		PISCINA	1400
102	3	-1	27	24	656	LAUDRY	6	6	1	1.00000	0.00000	\N	1		LAUDRY	1404
103	3	-1	27	24	660	EVENTOS	6	6	1	1.00000	0.00000	0.00000	1	\N	EVENTOS	1357
104	3	-1	27	24	710	COBRANZAS	7	7	1	1.00000	0.00000	0.00000	1	\N	COBRANZAS	1230
105	3	-1	27	24	430	GASTOS JUDICIALES O PREJUDICIALES REINTEGRABLES	4	4	1	1.00000	0.00000	\N	1		GASTOS JUDICIALES O PREJUDICIALES REINTEGRABLES	1356
106	3	-1	27	24	320	ENVIO DE LIQUIDACIONES POR CORREO	3	3	1	1.00000	0.00000	\N	1		ENVIO DE LIQUIDACIONES POR CORREO	1375
107	3	-1	27	24	390	OTROS REINTEGROS	3	3	1	1.00000	0.00000	0.00000	1	\N	OTROS REINTEGROS	1308
108	3	-1	27	24	830	INTERES RESARCITORIO	12	10	3	2.00000	0.00000	0.00000	1	\N	INTERES RESARCITORIO	1355
109	3	-1	27	24	810	AJUSTES DE MULTAS	7	8	1	1.00000	0.00000	\N	1		AJUSTES DE MULTAS	1399
110	3	-1	27	24	810	AJUSTES POR PAGO EN TERMINO	7	8	1	1.00000	0.00000	\N	1		AJUSTES POR PAGO EN TERMINO	1352
111	3	-1	27	24	810	AJUSTES POR ERROR EN LA IMPUTACION	7	8	1	1.00000	0.00000	\N	1		AJUSTES POR ERROR EN LA IMPUTACION	1358
112	3	-1	27	24	810	AJUSTES DE INTERESES	7	8	1	1.00000	0.00000	\N	1		AJUSTES DE INTERESES	1355
113	3	-1	27	24	810	AJUSTES VARIOS	7	8	1	1.00000	0.00000	0.00000	1	\N	AJUSTES VARIOS	1358
114	3	-1	27	24	1110	FONDO DE OBRA	11	12	1	1.00000	0.00000	\N	1		FONDO DE OBRA	1398
115	3	-1	27	24	520	MULTAS	5	5	2	2.00000	0.00000	\N	1		MULTAS	1399
116	3	-1	27	24	420	HONORARIOS LETRADOS	4	4	1	1.00000	0.00000	0.00000	1	\N	HONORARIOS LETRADOS	1356
117	3	-1	27	24	500	AJUSTE POR REDONDEO	6	6	2	1.00000	0.00000	0.00000	1	\N	AJUSTE POR REDONDEO	1410
118	3	-1	27	24	510	IDENTIFICADOR DE UNIDAD FUNCIONAL	6	6	2	1.00000	0.00000	0.00000	1	\N	IDENTIFICADOR DE UNIDAD FUNCIONAL	1410
119	3	-1	27	24	521	PUBLICIDAD	5	5	1	1.00000	0.00000	0.00000	1	\N	PUBLICIDAD	1357
120	3	-1	27	24	522	ASOCIACION TRANSITORIA	5	5	1	1.00000	0.00000	0.00000	1	\N	ASOCIACION TRANSITORIA	1357
121	3	-1	27	24	1010	FONDO DE RESERVA	10	11	1	1.00000	0.00000	\N	1		FONDO DE RESERVA	1354
122	3	-1	27	24	410	GRUPO FAMILIAR	5	5	1	1.00000	0.00000	\N	1		CANTIDAD PERSONAS GRUPO FAMILIAR	1381
123	3	-1	27	24	1180	SERVICIO DE AGUA	11	12	1	1.00000	0.00000	0.00000	1	\N	SERVICIO DE AGUA	1316
124	3	-1	27	24	1185	ARBA	11	12	1	1.00000	0.00000	\N	1		ARBA	1395
125	3	-1	27	24	1187	IMPUESTO MUNICIPAL	11	12	1	1.00000	0.00000	0.00000	1	\N	\N	1338
126	3	-1	27	24	655	INVITADOS DE PISCINA	6	6	1	1.00000	0.00000	0.00000	1	\N	Invitadios de Piscina	1400
127	3	-1	27	24	5000	UNIDAD COMPLEM.	5	5	1	1.00000	120.00000	0.00000	1	\N	Unidad Complementaria	1352
128	3	-1	27	24	720	IDENTIFICACION DE DEPOSITOS	7	7	1	1.00000	0.00000	0.00000	1	\N	IDENTIFICACION DE DEPOSITOS	1230
129	3	-1	27	24	420	SOLICITUD DE INFORMES DE DOMINIO	4	4	1	1.00000	0.00000	0.00000	1	\N	SOLICITUD DE INFORMES DE DOMINIO	1356
81	1	-1	14	10	12	REINTEGRO DE GASTOS	3	3	1	1.00000	0.00000	\N	1		Reintegro de Gastos	1308
130	3	-1	27	24	510	INGRESO DE CAMIONES	5	5	1	1.00000	0.00000	0.00000	1	\N	INGRESO DE CAMIONES	1357
131	3	-1	27	24	\N	SALDO INICIAL QUE GENERA INTERESES	13	13	1	1.00000	0.00000	0.00000	1	\N	SALDO INICIAL QUE GENERA INTERESES	1359
132	3	-1	27	24	\N	SALDO INICIAL QUE NO GENERA INTERESES	13	13	1	2.00000	0.00000	0.00000	1	\N	SALDO INICIAL QUE NO GENERA INTERESES	1359
133	3	-1	27	24	730	IDENTIFICACION DE DEPOSITOS PERIODOS ANTERIORES	7	7	1	1.00000	0.00000	0.00000	1	\N	IDENTIFICACION DE DEPOSITOS PERIODOS ANTERIORES	1230
134	3	-1	27	24	910	CONVENIOS DE PAGO	9	9	1	1.00000	0.00000	0.00000	1	\N	CONVENIOS DE PAGO	1230
135	3	-1	27	24	658	INVTADOS DE TENIS	6	6	1	1.00000	0.00000	0.00000	1	\N	INVTADOS DE TENIS	1403
136	3	-1	27	24	1120	FONDO DE EVENTOS	11	11	1	1.00000	0.00000	0.00000	1	\N	FONDO DE EVENTOS	1353
137	3	-1	27	24	600	MERIENDA	5	5	1	1.00000	0.00000	0.00000	1	\N	MERIENDA	1323
138	3	-1	27	24	1001	CUOTA MAYOR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA MAYOR	1352
139	3	-1	27	24	601	MANTENIMIENTO POR LOTE	5	5	1	1.00000	0.00000	0.00000	1	\N	MANTENMIENTO POR LOTE	1321
140	3	-1	27	24	602	TRABAJO TARIFADO	5	5	1	1.00000	0.00000	0.00000	1	\N	TRABAJO TARIFADO	1328
141	3	-1	27	24	603	ALQUILER DE QUINCHO	5	5	1	1.00000	0.00000	0.00000	1	\N	ALQUILER DE QUINCHO	1331
142	3	42	27	24	134	PESOS TRONCO	6	6	1	1.00000	204.00000	0.00000	1	\N	Pesos Tronco	1378
143	3	-1	27	24	302	DEBITOS POR TARJETA	6	6	1	1.00000	0.00000	0.00000	1	\N	DEBITOS POR TARJETA	1413
144	3	-1	27	24	1000	CUOTA GRUPO FAMILIAR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA GRUPO FAMILIAR	1352
145	3	-1	27	24	1002	CUOTA MENOR	1	1	1	1.00000	0.00000	0.00000	1	\N	CUOTA MENOR	1352
146	3	-1	27	24	2500	EXPENSAS DE LOCACION	5	5	1	1.00000	0.00000	0.00000	1	\N	Expensas de Locacion	1352
147	3	42	27	24	41	DERECHO DE INCORPORACION	6	6	1	1.00000	0.00000	0.00000	1	\N	DERECHO DE INCORPORACION	1323
148	3	42	27	24	42	INVITADOS ACTIVIDAD MENORES	6	6	1	1.00000	0.00000	0.00000	1	\N	INVITADOS ACTIVIDAD MENORES	1345
149	3	-1	27	24	101	AJUSTE DE INTERES QUE NO GENERA INTERESES	7	8	3	1.00000	0.00000	0.00000	1	\N	Ajuste de intereses.	1355
150	3	-1	27	24	9999	OTROS CARGOS	5	5	1	1.00000	0.00000	0.00000	1	\N	Otros Cargos	1357
151	3	-1	27	24	124	TARJETAS DE ACCESO	5	5	1	1.00000	0.00000	0.00000	1	\N	Tarjetas de Acceso	1328
152	3	-1	27	24	121	GASTOS A REINTEGRAR	5	5	1	1.00000	0.00000	0.00000	1	\N	Gastos a Reintegrar 	1289
153	3	-1	27	24	12	REINTEGRO DE GASTOS	3	3	1	1.00000	0.00000	0.00000	1	\N	Reintegro de Gastos	1289
80	1	-1	14	10	121	GASTOS A REINTEGRAR	5	5	1	1.00000	0.00000	\N	1		Gastos a Reintegrar 	1308
154	1	-1	14	10	3810	CUOTA MENOR VOLUNTARIO	5	5	1	1.00000	0.00000	0.00000	1	\N	Cuota Menor Voluntario	1352
155	1	-1	14	10	99	AJUSTES PROVISORIOS	5	5	1	1.00000	0.00000	0.00000	1	\N	Ajustes Provisorios Pendientes de Confirmacion	1357
156	1	-1	14	10	3521	SAUNA	6	6	1	1.00000	0.00000	0.00000	1	\N	SAUNA	1323
157	1	-1	14	10	621	ALQUILER DE HOUSE	6	6	1	1.00000	0.00000	0.00000	1	\N	Alquiler de House	1402
158	1	-1	14	10	623	CANON POR ALQUILER 	6	6	1	1.00000	0.00000	0.00000	1	\N	CANON POR ALQUILER 	1331
159	1	-1	14	10	653	LUZ CANCHA DE FUTBOL	6	6	1	1.00000	0.00000	0.00000	1	\N	LUZ CANCHA DE FUTBOL	1314
160	1	-1	14	10	710	BOSAS DE RECICLADO	6	6	1	1.00000	0.00000	0.00000	1	\N	BOSAS DE RECICLADO	1323
56	1	-1	14	10	521	SERVICIOS HOUSE	5	5	1	1.00000	0.00000	\N	1		SERVICIOS HOUSE	1357
57	1	-1	14	10	522	CONSUMO TELEFONICO	5	5	1	1.00000	0.00000	\N	1		CONSUMO TELEFONICO	1357
161	1	-1	14	10	4200	LIMPIEZA SUM	6	6	1	1.00000	0.00000	0.00000	1	\N	LIMPIEZA SUM	1397
162	1	-1	14	10	3511	INVITADOS FUTBOL	6	6	1	1.00000	0.00000	0.00000	1	\N	INVITADOS FUTBOL	1323
163	1	-1	14	10	4911	DERECHO INCORPORACION RINCON DE M.	6	6	1	1.00000	0.00000	0.00000	1	\N	Derecho de Incorporacion	1323
\.


ALTER TABLE cargos ENABLE TRIGGER ALL;

--
-- Data for Name: ptovta; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE ptovta DISABLE TRIGGER ALL;

COPY ptovta (ptv_id, ptv_codemp, ptv_codigo, ptv_nombre, ptv_direcc, ptv_locali, ptv_codpos, ptv_provin, ptv_pais, ptv_nrcuit, ptv_tipo, ptv_anti, ptv_fecint, ptv_grupo, ptv_redond, ptv_nomabre, ptv_estado, ptv_aplicadesc, ptv_imputacion, ptv_liqgs) FROM stdin;
1	1	1	LA RESERVA				1	200		1	2015-01-30	15	1	2		1	1	2	0
\.


ALTER TABLE ptovta ENABLE TRIGGER ALL;

--
-- Data for Name: division; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE division DISABLE TRIGGER ALL;

COPY division (div_id, div_codemp, div_idptov, div_codigo, div_nombre) FROM stdin;
1	1	1	1	LA RESERVA
\.


ALTER TABLE division ENABLE TRIGGER ALL;

--
-- Data for Name: centroc; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE centroc DISABLE TRIGGER ALL;

COPY centroc (cco_id, cco_codemp, cco_idptov, cco_coddiv, cco_codigo, cco_nombre, cco_porcpro) FROM stdin;
1	1	1	1	1	LA RESERVA	\N
\.


ALTER TABLE centroc ENABLE TRIGGER ALL;

--
-- Data for Name: articvta; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE articvta DISABLE TRIGGER ALL;

COPY articvta (art_id, art_codigo, art_tasa, art_stock, art_nivrep, art_unimed, art_present, art_peso, art_estado, art_codrub, art_automatoper, art_tipoper, art_idptov, art_precio_unique, art_codemp, art_codi, art_nombre, art_leyen, art_siste, art_tipo, art_codsrb, art_codcbl, art_funcion, art_precio, art_idcbl) FROM stdin;
\.


ALTER TABLE articvta ENABLE TRIGGER ALL;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('articvta_art_id_seq', 1, false);


--
-- Data for Name: ctacble; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE ctacble DISABLE TRIGGER ALL;

COPY ctacble (cbl_id, cbl_codemp, cbl_idptov, cbl_divis, cbl_centro, cbl_codigo, cbl_nombre, cbl_moneda, cbl_tipcta, cbl_ajuste, cbl_indice, cbl_present) FROM stdin;
1221	1	0	\N	\N	1001	CAJA CHICA	1	5	1	\N	1.1.1.1.02
1284	1	0	\N	\N	2302	AGUINALDOS A PAGAR	1	\N	1	\N	 1
1311	1	0	\N	\N	4001	SUELDOS Y JORNALES	1	\N	1	\N	 1
1361	1	0	\N	\N	4080	OTROS GASTOS RELACIONADOS AL PERSONAL	1	\N	1	\N	\N
1267	1	0	\N	\N	2061	INTERESES A PAGAR	1	\N	1	\N	 1
1288	1	0	\N	\N	2400	PROVISION VACACIONES	1	\N	1	\N	 1
1289	1	0	\N	\N	2401	GASTOS A REINTEGRAR	1	\N	1	\N	 1
1290	1	0	\N	\N	2403	HON. DIRECTORES A PAGAR	1	\N	1	\N	 1
1291	1	0	\N	\N	2405	HONORARIOS A PAGAR	1	\N	1	\N	 1
1292	1	0	\N	\N	2410	OTRAS DEUDAS	1	\N	1	\N	 1
1293	1	0	\N	\N	2502	PREVIS. DEUD. INCOBRABLES	1	\N	1	\N	 1
1294	1	0	\N	\N	2503	PREVISION PARA DESPIDOS	1	\N	1	\N	 1
1230	1	0	\N	\N	1201	DEUDORES EN CUENTA CORRIENTE	1	99	1	\N	1.1.1.4.10
1297	1	0	\N	\N	2803	CAPITAL SUSCRIPTO	1	\N	1	\N	 1
1298	1	0	\N	\N	2806	AJUSTE DEL CAPITAL	1	\N	1	\N	 1
1270	1	0	\N	\N	2203	PROVIS. IMP. A LAS GCIAS.	1	\N	1	\N	 1
1312	1	0	\N	\N	4020	CONTRIBUCIONES SOCIALES	1	\N	1	\N	 1
1301	1	0	\N	\N	2808	RESERVA LEGAL	1	\N	1	\N	 1
1302	1	0	\N	\N	2813	RESUL. EJERCICIO ANTERIOR	1	\N	1	\N	 1
1303	1	0	\N	\N	2814	RESULTADOS NO ASIGNADOS	1	\N	1	\N	 1
1304	1	0	\N	\N	2815	RESULTADO DEL EJERCICIO	1	\N	1	\N	 1
1305	1	0	\N	\N	2816	AJUSTE EJERCICIO ANTERIOR	1	\N	1	\N	 1
1265	1	0	\N	\N	2051	ACREEDORES FINANCIEROS	1	\N	1	\N	 1
1307	1	0	\N	\N	3600	DESCUENTOS OBTENIDOS	1	\N	1	\N	 1
1266	1	0	\N	\N	2052	ACREEDORES VARIOS	1	\N	1	\N	 1
1342	1	0	\N	\N	4460	MULTAS Y RECARGOS	1	0	1	\N	 1
1310	1	0	\N	\N	3607	RESULTADOS FINANCIEROS	1	\N	1	\N	 1
1396	1	0	\N	\N	4510	GASTOS JUDICIALES NO REINTEGRABLES	1	0	1	\N	
1340	1	0	\N	\N	4500	DESCUENTOS CONCEDIDOS	1	\N	1	\N	 1
1360	1	0	\N	\N	4030	SINDICATOS	1	\N	1	\N	\N
1347	1	0	\N	\N	5088	IMP. A LAS GANANCIAS	1	\N	1	\N	 1
1308	1	0	\N	\N	3602	RECUPERO DE GASTOS PRORATEADOS	1	0	1	\N	 1
1224	1	0	\N	\N	1010	BANCOS MONEDA NACIONAL	1	1	1	\N	1.1.1.2.00
1225	1	0	\N	\N	1014	BANCOS MONEDA EXTRANJERA	2	1	1	\N	1.1.1.3.00
1226	1	0	\N	\N	1015	VALORES A DEPOSITAR	1	\N	1	\N	1.1.1.4.01 
1264	1	0	\N	\N	2050	DEUDAS BANCARIAS	1	\N	1	\N	 1
1234	1	0	\N	\N	1210	DOCUMENTOS A COBRAR	1	\N	1	\N	 1
1235	1	0	\N	\N	1254	IMPUESTO A LOS DEB Y CRED	1	\N	1	\N	 1
1238	1	0	\N	\N	1257	ANTICIPOS POR IMPUESTOS	1	\N	1	\N	 1
1239	1	0	\N	\N	1258	I.V.A. SALDO A FAVOR	1	\N	1	\N	 1
1240	1	0	\N	\N	1259	ING.BRUTOS A RECUPERAR	1	\N	1	\N	 1
1313	1	0	\N	\N	4050	INDUMENTARIA DE TRABAJO	1	\N	1	\N	 1
1242	1	0	\N	\N	1262	ANTICIPO DE GANANCIAS	1	\N	1	\N	\N
1243	1	0	\N	\N	1289	RETENC. ING. BRUT. BS.AS.	1	\N	1	\N	 1
1244	1	0	\N	\N	1290	PERCEPCIN IIBB BS.AS.	1	\N	1	\N	 1
1245	1	0	\N	\N	1307	INTERESES A DEVENGAR	1	\N	1	\N	 1
1246	1	0	\N	\N	1308	RETENCION I.V.A.	1	\N	1	\N	 1
1247	1	0	\N	\N	1309	PERCEPCION I.V.A.	1	\N	1	\N	 1
1248	1	0	\N	\N	1310	ANTICIPO PROVEEDORES	1	98	1	\N	 1
1249	1	0	\N	\N	1311	ANTIC.HON.DIR.Y SNDICOS	1	\N	1	\N	 1
1250	1	0	\N	\N	1312	ACCIONISTAS	1	\N	1	\N	 1
1251	1	0	\N	\N	1801	EDIFICIOS	1	\N	2	\N	 1
1252	1	0	\N	\N	1840	RODADOS	1	\N	2	\N	 1
1253	1	0	\N	\N	1850	EQUIPOS	1	\N	2	\N	 1
1254	1	0	\N	\N	1871	MUEBLES Y UTILES	1	\N	2	\N	 1
1255	1	0	\N	\N	1872	PROGRAMAS	1	\N	2	\N	 1
1256	1	0	\N	\N	1873	HERRAMIENTAS	1	\N	2	\N	 1
1223	1	0	\N	\N	1006	BONOS Y ACCIONES	1	\N	1	\N	1.1.1.1.07
1231	1	0	\N	\N	1202	DEUDORES VARIOS	1	\N	1	\N	1.1.1.4.11
1232	1	0	\N	\N	1203	DEUD.X CHEQUES RECHAZADOS	1	\N	1	\N	1.1.1.4.12
1257	1	0	\N	\N	1901	AMORT.ACUM.EDIFICIOS	1	\N	1	\N	 1
1258	1	0	\N	\N	1902	AMORT.ACUM.BS DE USO	1	\N	1	\N	 1
1259	1	0	\N	\N	1940	AMORT.ACUM RODADOS	1	\N	1	\N	 1
1260	1	0	\N	\N	2001	PROVEEDORES	1	98	1	\N	 1
1262	1	0	\N	\N	2009	ANTICIPO DE CLIENTES	1	\N	1	\N	 1
1263	1	0	\N	\N	2045	ADELANTOS EN CTA. CTE.	1	\N	1	\N	 1
1315	1	0	\N	\N	4110	GAS	1	\N	1	\N	 1
1316	1	0	\N	\N	4120	AGUA	1	\N	1	\N	 1
1285	1	0	\N	\N	2310	APORTES SEGURIDAD SOCIAL A PAGAR	1	0	1	\N	 1
1287	1	0	\N	\N	2336	SEGURO DE VIDA A PAGAR	1	0	1	\N	
1317	1	0	\N	\N	4130	TELEFONOS	1	\N	1	\N	 1
1314	1	0	\N	\N	4100	LUZ	1	\N	1	\N	 1
1318	1	0	\N	\N	4135	CELULARES	1	\N	1	\N	 1
1319	1	0	\N	\N	4630	GASTOS DE RODADOS	1	\N	1	\N	 1
1320	1	0	\N	\N	4640	MANTENIMIENTO DE EQUIPOS	1	0	1	\N	 1
1327	1	0	\N	\N	4800	SEGUROS	1	\N	1	\N	 1
1334	1	0	\N	\N	4700	COLABORACIONES	1	0	1	\N	 1
1345	1	0	\N	\N	4910	GASTOS ACTIVIDADES DEPORTIVAS Y SOCIALES	1	0	1	\N	 1
1346	1	0	\N	\N	4480	RESULT. EXP. A LA INFLACI	1	\N	1	\N	 1
1344	1	0	\N	\N	4485	DIFERENCIA DE CAMBIO	1	\N	1	\N	 1
1341	1	0	\N	\N	4465	INTERESES	1	\N	1	\N	 1
1339	1	0	\N	\N	4490	AMORTIZ. DE BIENES DE USO	1	\N	1	\N	 1
1326	1	0	\N	\N	4491	AMORT. DE BIENES DE USO	1	\N	1	\N	 1
1336	1	0	\N	\N	4470	GAST. DE REPRES. Y VIATI.	1	\N	1	\N	 1
1332	1	0	\N	\N	4471	FOTOCOPIAS	1	\N	1	\N	 1
1329	1	0	\N	\N	4472	LIBRERA E IMPRENTA	1	\N	1	\N	 1
1335	1	0	\N	\N	4478	PUBLICIDAD Y PROPAGANDA	1	\N	1	\N	 1
1324	1	0	\N	\N	4060	GRATIFICACIONES	1	\N	1	\N	 1
1337	1	0	\N	\N	4075	UTILES DE TRABAJO	1	\N	1	\N	 1
1363	1	0	\N	\N	4200	ABONO MANTENIMIENTO DE AREAS VERDES	1	\N	1	\N	\N
1364	1	0	\N	\N	4210	ABONO MANTENIMIENTO GENERAL DEL EMPRENDIMIENTO	1	\N	1	\N	\N
1322	1	0	\N	\N	4300	SEGURIDAD	1	\N	1	\N	 1
1325	1	0	\N	\N	4270	HONORARIOS	1	\N	1	\N	 1
1328	1	0	\N	\N	4670	GASTOS GENERALES	1	\N	1	\N	 1
1331	1	0	\N	\N	4410	ALQUILERES	1	\N	1	\N	 1
1333	1	0	\N	\N	4415	EXPENSAS	1	\N	1	\N	 1
1323	1	0	\N	\N	4149	OTROS SERVICIOS	1	0	1	\N	 1
1413	1	0	\N	\N	4111	DEBITOS POR TARJETAS DE CREDITO	1	\N	1	\N	1
1410	1	0	\N	\N	3990	AJUSTES POR REDONDEO	1	\N	1	\N	\N
1412	1	0	\N	\N	1500	OTROS INGRESOS	1	\N	1	\N	\N
1394	1	0	\N	\N	4140	INTERNET Y TV POR CABLE	1	\N	1	\N	\N
1321	1	0	\N	\N	4600	GASTOS DE MANTENIMIENTO	1	0	1	\N	 1
1377	1	0	\N	\N	4620	MATERIALES Y REPARACIONES ELECTRICAS	1	\N	1	\N	\N
1271	1	0	\N	\N	2205	I.V.A. DEBITO FISCAL	1	\N	1	\N	 1
1272	1	0	\N	\N	2006	SEGUROS A PAGAR	1	\N	1	\N	 1
1376	1	0	\N	\N	4635	COMBUSTIBLES Y LUBRICANTES	1	\N	1	\N	\N
1374	1	0	\N	\N	4650	GASTOS MANTENIMIENTO PISCINA	1	\N	1	\N	\N
1397	1	0	\N	\N	4610	LIMPIEZA DE AREAS COMUNES Y ARTICULOS DE LIMPIEZA	1	\N	1	\N	\N
1276	1	0	\N	\N	2215	I.V.A. A PAGAR	1	\N	1	\N	 1
1277	1	0	\N	\N	2220	IMPUES. S/LOS ING. BRUTOS	1	\N	1	\N	 1
1278	1	0	\N	\N	2225	SEG. E HIGIENE A PAGAR	1	\N	1	\N	 1
1279	1	0	\N	\N	2230	OTROS IMPUESTOS A PAGAR	1	\N	1	\N	 1
1280	1	0	\N	\N	2234	IMP. A LAS GANANCIAS A PA	1	\N	1	\N	\N
1281	1	0	\N	\N	2235	GANANCIA M. PRESUNTA A PA	1	\N	1	\N	\N
1378	1	0	\N	\N	4900	CONCESIONARIOS	1	\N	1	\N	\N
1283	1	0	\N	\N	2301	SUELDOS A PAGAR	1	\N	1	\N	 1
1220	1	0	\N	\N	1000	CAJA	1	\N	1	\N	1.1.1.1.01
1222	1	0	\N	\N	1005	CAJA MONEDA EXTRANJERA	2	\N	1	\N	1.1.1.1.06
1371	1	0	\N	\N	4920	GUARDAVIDAS	1	\N	1	\N	\N
1228	1	0	\N	\N	1017	VALORES A DEPOSITAR EN ME	2	\N	1	\N	 1.1.1.4.03 
1375	1	0	\N	\N	4475	GASTOS ADMINISTRATIVOS Y DE CORREO	1	\N	1	\N	\N
1237	1	0	\N	\N	1256	CREDITO FISCAL NO COMPUTABLE	1	\N	1	\N	 1
1236	1	0	\N	\N	1255	I.V.A. CREDITO FISCAL	1	\N	1	\N	 1
1261	1	0	\N	\N	2005	DOCUMENTOS A PAGAR	1	\N	1	\N	 1
1233	1	0	\N	\N	1205	DEUDORES MOROSOS	1	\N	1	\N	 1
1349	1	0	\N	\N	1242	APORTES ADMINISTRACION	1	\N	1	\N	\N
1350	1	0	\N	\N	1245	DESCUENTOS OBTENIDOS POR ADMINISTRACION	1	\N	1	\N	\N
1351	1	0	\N	\N	1020	DEPOSITOS SIN IDENTIFICAR	1	\N	1	\N	\N
1356	1	0	\N	\N	3401	GASTOS JUDICIALES REINTEGRABLES	1	0	1	\N	
1306	1	0	\N	\N	3101	EXPENSAS EXTRAORDINARIAS PRORRATEADAS	1	0	1	\N	 1
1414	1	0	\N	\N	1016	DEPOSITOS EN PLAZO FIJO	1	\N	1	\N	\N
1353	1	0	\N	\N	3201	FONDOS ESPECIFICOS PRORRATEADOS	1	\N	1	\N	\N
1354	1	0	\N	\N	3301	FONDOS DE RESERVA PRORRATEADOS	1	\N	1	\N	\N
1355	1	0	\N	\N	3701	INTERESES DEVENGADOS	1	\N	1	\N	\N
1379	1	0	\N	\N	1101	FONDO DE RESERVA	1	\N	1	\N	\N
1357	1	0	\N	\N	3501	CARGOS DIRECTOS PRORRATEADOS	1	\N	1	\N	\N
1358	1	0	\N	\N	3801	AJUSTES REALIZADOS	1	\N	1	\N	\N
1359	1	0	\N	\N	5001	CARGA DE SALDOS INICIALES	1	\N	1	\N	\N
1348	1	0	\N	\N	4999	AJUSTES	1	0	1	\N	 1
1380	1	0	\N	\N	1110	FONDO DE OBRA	1	\N	1	\N	\N
1343	1	0	\N	\N	4450	GASTOS Y COMISIONES BANCARIAS	1	0	1	\N	 1
1384	1	0	\N	\N	5100	HONORARIOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1385	1	0	\N	\N	5200	IMPRESOS Y RECIBOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1386	1	0	\N	\N	5300	OTROS CONCEPTOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1398	1	0	\N	\N	3200	FONDO DE OBRA	1	\N	1	\N	\N
1399	1	0	\N	\N	3900	MULTAS COBRADAS	1	\N	1	\N	\N
1400	1	0	\N	\N	3510	DERECHO DE USA DE PISCINA	1	\N	1	\N	\N
1401	1	0	\N	\N	3515	CUOTA FUTBOL	1	\N	1	\N	\N
1402	1	0	\N	\N	3520	UTILIZACION DE S.U.M.	1	\N	1	\N	\N
1403	1	0	\N	\N	3530	CARGOS POR TENIS	1	\N	1	\N	\N
1404	1	0	\N	\N	3550	GOLF	1	\N	1	\N	\N
1405	1	0	\N	\N	3505	CORTE DE CESPED	1	\N	1	\N	\N
1352	1	0	\N	\N	3001	EXPENSAS ORDINARIAS TIPO A	1	0	1	\N	
1381	1	0	\N	\N	1120	FONDO ESPECIFICO	1	\N	1	\N	\N
1382	1	0	\N	\N	4040	IMPUESTO MUNICIPAL	1	\N	1	\N	\N
1383	1	0	\N	\N	4045	IMPUESTO DE RENTAS	1	\N	1	\N	\N
1299	1	0	\N	\N	2807	APORTES Y RETIROS ADMINISTRACION	1	97	1	\N	 1
1241	1	0	\N	\N	1260	IMP. A LAS GCIAS SALDO A FAVOR	1	0	1	\N	 1
1268	1	0	\N	\N	2201	RETENCIONES AFIP A DEPOSITAR	1	0	1	\N	 1
1406	1	0	\N	\N	3002	EXPENSAS ORDINARIAS TIPO B	1	\N	1	\N	\N
1407	1	0	\N	\N	3003	EXPENSAS ORDINARIAS TIPO C	1	\N	1	\N	\N
1282	1	0	\N	\N	2315	ART A PAGAR	1	0	1	\N	 1
1392	1	0	\N	\N	2312	APORTES OBRA SOCIAL A PAGAR	1	\N	1	\N	\N
1286	1	0	\N	\N	2311	CONTRIBUCIONES SEGURIDAD SOCIAL A PAGAR	1	0	1	\N	 1
1393	1	0	\N	\N	2313	CONTRIBUCIONES OBRA SOCIAL A PAGAR	1	\N	1	\N	\N
1372	1	0	\N	\N	4250	HONORARIOS ADMINISTRACION	1	\N	1	\N	\N
1373	1	0	\N	\N	4255	HONORARIOS ESTUDIO CONTABLE	1	\N	1	\N	\N
1365	1	0	\N	\N	4220	ABONO FUMIGACION	1	\N	1	\N	\N
1366	1	0	\N	\N	4230	HONORARIOS ARQUITECTURA	1	0	1	\N	
1367	1	0	\N	\N	4240	ABONO MANTENIMIENTO PLANTA CLOACAL	1	\N	1	\N	\N
1369	1	0	\N	\N	4260	ABONO RECOLECCION DE RESIDUOS	1	\N	1	\N	\N
1370	1	0	\N	\N	4265	RECOLECCION DE RAMAS	1	\N	1	\N	\N
1368	1	0	\N	\N	4290	OTROS ABONOS	1	\N	1	\N	\N
1362	1	0	\N	\N	4350	OTROS GASTOS RELACIONADOS A LA SEGURIDAD	1	\N	1	\N	\N
1408	1	0	\N	\N	3004	EXPENSAS ORDINARIAS TIPO D	1	\N	1	\N	\N
1338	1	0	\N	\N	4160	IMPUESTOS MUNICIPALES Y TASAS	1	0	1	\N	 1
1395	1	0	\N	\N	4150	IMPUESTO DE RENTAS	1	\N	1	\N	\N
1409	1	0	\N	\N	3005	EXPENSAS ORDINARIAS TIPO E	1	\N	1	\N	\N
1771	3	0	27	24	1001	CAJA CHICA	1	5	1	\N	1.1.1.1.02
1772	3	0	27	24	2302	AGUINALDOS A PAGAR	1	\N	1	\N	 1
1773	3	0	27	24	4001	SUELDOS Y JORNALES	1	\N	1	\N	 1
1774	3	0	27	24	4080	OTROS GASTOS RELACIONADOS AL PERSONAL	1	\N	1	\N	\N
1775	3	0	27	24	2061	INTERESES A PAGAR	1	\N	1	\N	 1
1776	3	0	27	24	2400	PROVISION VACACIONES	1	\N	1	\N	 1
1777	3	0	27	24	2401	GASTOS A REINTEGRAR	1	\N	1	\N	 1
1778	3	0	27	24	2403	HON. DIRECTORES A PAGAR	1	\N	1	\N	 1
1779	3	0	27	24	2405	HONORARIOS A PAGAR	1	\N	1	\N	 1
1780	3	0	27	24	2410	OTRAS DEUDAS	1	\N	1	\N	 1
1781	3	0	27	24	2502	PREVIS. DEUD. INCOBRABLES	1	\N	1	\N	 1
1782	3	0	27	24	2503	PREVISION PARA DESPIDOS	1	\N	1	\N	 1
1783	3	0	27	24	1201	DEUDORES EN CUENTA CORRIENTE	1	99	1	\N	1.1.1.4.10
1784	3	0	27	24	2803	CAPITAL SUSCRIPTO	1	\N	1	\N	 1
1785	3	0	27	24	2806	AJUSTE DEL CAPITAL	1	\N	1	\N	 1
1786	3	0	27	24	2203	PROVIS. IMP. A LAS GCIAS.	1	\N	1	\N	 1
1787	3	0	27	24	4020	CONTRIBUCIONES SOCIALES	1	\N	1	\N	 1
1788	3	0	27	24	2808	RESERVA LEGAL	1	\N	1	\N	 1
1789	3	0	27	24	2813	RESUL. EJERCICIO ANTERIOR	1	\N	1	\N	 1
1790	3	0	27	24	2814	RESULTADOS NO ASIGNADOS	1	\N	1	\N	 1
1791	3	0	27	24	2815	RESULTADO DEL EJERCICIO	1	\N	1	\N	 1
1792	3	0	27	24	2816	AJUSTE EJERCICIO ANTERIOR	1	\N	1	\N	 1
1793	3	0	27	24	2051	ACREEDORES FINANCIEROS	1	\N	1	\N	 1
1794	3	0	27	24	3600	DESCUENTOS OBTENIDOS	1	\N	1	\N	 1
1795	3	0	27	24	2052	ACREEDORES VARIOS	1	\N	1	\N	 1
1796	3	0	27	24	4460	MULTAS Y RECARGOS	1	0	1	\N	 1
1797	3	0	27	24	3607	RESULTADOS FINANCIEROS	1	\N	1	\N	 1
1798	3	0	27	24	4510	GASTOS JUDICIALES NO REINTEGRABLES	1	0	1	\N	
1799	3	0	27	24	4500	DESCUENTOS CONCEDIDOS	1	\N	1	\N	 1
1800	3	0	27	24	4030	SINDICATOS	1	\N	1	\N	\N
1801	3	0	27	24	5088	IMP. A LAS GANANCIAS	1	\N	1	\N	 1
1802	3	0	27	24	3602	RECUPERO DE GASTOS PRORATEADOS	1	0	1	\N	 1
1803	3	0	27	24	1010	BANCOS MONEDA NACIONAL	1	1	1	\N	1.1.1.2.00
1804	3	0	27	24	1014	BANCOS MONEDA EXTRANJERA	2	1	1	\N	1.1.1.3.00
1805	3	0	27	24	1015	VALORES A DEPOSITAR	1	\N	1	\N	1.1.1.4.01 
1806	3	0	27	24	2050	DEUDAS BANCARIAS	1	\N	1	\N	 1
1807	3	0	27	24	1210	DOCUMENTOS A COBRAR	1	\N	1	\N	 1
1808	3	0	27	24	1254	IMPUESTO A LOS DEB Y CRED	1	\N	1	\N	 1
1809	3	0	27	24	1257	ANTICIPOS POR IMPUESTOS	1	\N	1	\N	 1
1810	3	0	27	24	1258	I.V.A. SALDO A FAVOR	1	\N	1	\N	 1
1811	3	0	27	24	1259	ING.BRUTOS A RECUPERAR	1	\N	1	\N	 1
1812	3	0	27	24	4050	INDUMENTARIA DE TRABAJO	1	\N	1	\N	 1
1813	3	0	27	24	1262	ANTICIPO DE GANANCIAS	1	\N	1	\N	\N
1814	3	0	27	24	1289	RETENC. ING. BRUT. BS.AS.	1	\N	1	\N	 1
1815	3	0	27	24	1290	PERCEPCIN IIBB BS.AS.	1	\N	1	\N	 1
1816	3	0	27	24	1307	INTERESES A DEVENGAR	1	\N	1	\N	 1
1817	3	0	27	24	1308	RETENCION I.V.A.	1	\N	1	\N	 1
1818	3	0	27	24	1309	PERCEPCION I.V.A.	1	\N	1	\N	 1
1819	3	0	27	24	1310	ANTICIPO PROVEEDORES	1	98	1	\N	 1
1820	3	0	27	24	1311	ANTIC.HON.DIR.Y SNDICOS	1	\N	1	\N	 1
1821	3	0	27	24	1312	ACCIONISTAS	1	\N	1	\N	 1
1822	3	0	27	24	1801	EDIFICIOS	1	\N	2	\N	 1
1823	3	0	27	24	1840	RODADOS	1	\N	2	\N	 1
1824	3	0	27	24	1850	EQUIPOS	1	\N	2	\N	 1
1825	3	0	27	24	1871	MUEBLES Y UTILES	1	\N	2	\N	 1
1826	3	0	27	24	1872	PROGRAMAS	1	\N	2	\N	 1
1827	3	0	27	24	1873	HERRAMIENTAS	1	\N	2	\N	 1
1828	3	0	27	24	1006	BONOS Y ACCIONES	1	\N	1	\N	1.1.1.1.07
1829	3	0	27	24	1202	DEUDORES VARIOS	1	\N	1	\N	1.1.1.4.11
1830	3	0	27	24	1203	DEUD.X CHEQUES RECHAZADOS	1	\N	1	\N	1.1.1.4.12
1831	3	0	27	24	1901	AMORT.ACUM.EDIFICIOS	1	\N	1	\N	 1
1832	3	0	27	24	1902	AMORT.ACUM.BS DE USO	1	\N	1	\N	 1
1833	3	0	27	24	1940	AMORT.ACUM RODADOS	1	\N	1	\N	 1
1834	3	0	27	24	2001	PROVEEDORES	1	98	1	\N	 1
1835	3	0	27	24	2009	ANTICIPO DE CLIENTES	1	\N	1	\N	 1
1836	3	0	27	24	2045	ADELANTOS EN CTA. CTE.	1	\N	1	\N	 1
1837	3	0	27	24	4110	GAS	1	\N	1	\N	 1
1838	3	0	27	24	4120	AGUA	1	\N	1	\N	 1
1839	3	0	27	24	2310	APORTES SEGURIDAD SOCIAL A PAGAR	1	0	1	\N	 1
1840	3	0	27	24	2336	SEGURO DE VIDA A PAGAR	1	0	1	\N	
1841	3	0	27	24	4130	TELEFONOS	1	\N	1	\N	 1
1842	3	0	27	24	4100	LUZ	1	\N	1	\N	 1
1843	3	0	27	24	4135	CELULARES	1	\N	1	\N	 1
1844	3	0	27	24	4630	GASTOS DE RODADOS	1	\N	1	\N	 1
1845	3	0	27	24	4640	MANTENIMIENTO DE EQUIPOS	1	0	1	\N	 1
1846	3	0	27	24	4800	SEGUROS	1	\N	1	\N	 1
1847	3	0	27	24	4700	COLABORACIONES	1	0	1	\N	 1
1848	3	0	27	24	4910	GASTOS ACTIVIDADES DEPORTIVAS Y SOCIALES	1	0	1	\N	 1
1849	3	0	27	24	4480	RESULT. EXP. A LA INFLACI	1	\N	1	\N	 1
1850	3	0	27	24	4485	DIFERENCIA DE CAMBIO	1	\N	1	\N	 1
1851	3	0	27	24	4465	INTERESES	1	\N	1	\N	 1
1852	3	0	27	24	4490	AMORTIZ. DE BIENES DE USO	1	\N	1	\N	 1
1853	3	0	27	24	4491	AMORT. DE BIENES DE USO	1	\N	1	\N	 1
1854	3	0	27	24	4470	GAST. DE REPRES. Y VIATI.	1	\N	1	\N	 1
1855	3	0	27	24	4471	FOTOCOPIAS	1	\N	1	\N	 1
1856	3	0	27	24	4472	LIBRERA E IMPRENTA	1	\N	1	\N	 1
1857	3	0	27	24	4478	PUBLICIDAD Y PROPAGANDA	1	\N	1	\N	 1
1858	3	0	27	24	4060	GRATIFICACIONES	1	\N	1	\N	 1
1859	3	0	27	24	4075	UTILES DE TRABAJO	1	\N	1	\N	 1
1860	3	0	27	24	4200	ABONO MANTENIMIENTO DE AREAS VERDES	1	\N	1	\N	\N
1861	3	0	27	24	4210	ABONO MANTENIMIENTO GENERAL DEL EMPRENDIMIENTO	1	\N	1	\N	\N
1862	3	0	27	24	4300	SEGURIDAD	1	\N	1	\N	 1
1863	3	0	27	24	4270	HONORARIOS	1	\N	1	\N	 1
1864	3	0	27	24	4670	GASTOS GENERALES	1	\N	1	\N	 1
1865	3	0	27	24	4410	ALQUILERES	1	\N	1	\N	 1
1866	3	0	27	24	4415	EXPENSAS	1	\N	1	\N	 1
1867	3	0	27	24	4149	OTROS SERVICIOS	1	0	1	\N	 1
1868	3	0	27	24	4111	DEBITOS POR TARJETAS DE CREDITO	1	\N	1	\N	1
1869	3	0	27	24	3990	AJUSTES POR REDONDEO	1	\N	1	\N	\N
1870	3	0	27	24	1500	OTROS INGRESOS	1	\N	1	\N	\N
1871	3	0	27	24	4140	INTERNET Y TV POR CABLE	1	\N	1	\N	\N
1872	3	0	27	24	4600	GASTOS DE MANTENIMIENTO	1	0	1	\N	 1
1873	3	0	27	24	4620	MATERIALES Y REPARACIONES ELECTRICAS	1	\N	1	\N	\N
1874	3	0	27	24	2205	I.V.A. DEBITO FISCAL	1	\N	1	\N	 1
1875	3	0	27	24	2006	SEGUROS A PAGAR	1	\N	1	\N	 1
1876	3	0	27	24	4635	COMBUSTIBLES Y LUBRICANTES	1	\N	1	\N	\N
1877	3	0	27	24	4650	GASTOS MANTENIMIENTO PISCINA	1	\N	1	\N	\N
1878	3	0	27	24	4610	LIMPIEZA DE AREAS COMUNES Y ARTICULOS DE LIMPIEZA	1	\N	1	\N	\N
1879	3	0	27	24	2215	I.V.A. A PAGAR	1	\N	1	\N	 1
1880	3	0	27	24	2220	IMPUES. S/LOS ING. BRUTOS	1	\N	1	\N	 1
1881	3	0	27	24	2225	SEG. E HIGIENE A PAGAR	1	\N	1	\N	 1
1882	3	0	27	24	2230	OTROS IMPUESTOS A PAGAR	1	\N	1	\N	 1
1883	3	0	27	24	2234	IMP. A LAS GANANCIAS A PA	1	\N	1	\N	\N
1884	3	0	27	24	2235	GANANCIA M. PRESUNTA A PA	1	\N	1	\N	\N
1885	3	0	27	24	4900	CONCESIONARIOS	1	\N	1	\N	\N
1886	3	0	27	24	2301	SUELDOS A PAGAR	1	\N	1	\N	 1
1887	3	0	27	24	1000	CAJA	1	\N	1	\N	1.1.1.1.01
1888	3	0	27	24	1005	CAJA MONEDA EXTRANJERA	2	\N	1	\N	1.1.1.1.06
1889	3	0	27	24	4920	GUARDAVIDAS	1	\N	1	\N	\N
1890	3	0	27	24	1017	VALORES A DEPOSITAR EN ME	2	\N	1	\N	 1.1.1.4.03 
1891	3	0	27	24	4475	GASTOS ADMINISTRATIVOS Y DE CORREO	1	\N	1	\N	\N
1892	3	0	27	24	1256	CREDITO FISCAL NO COMPUTABLE	1	\N	1	\N	 1
1893	3	0	27	24	1255	I.V.A. CREDITO FISCAL	1	\N	1	\N	 1
1894	3	0	27	24	2005	DOCUMENTOS A PAGAR	1	\N	1	\N	 1
1895	3	0	27	24	1205	DEUDORES MOROSOS	1	\N	1	\N	 1
1896	3	0	27	24	1242	APORTES ADMINISTRACION	1	\N	1	\N	\N
1897	3	0	27	24	1245	DESCUENTOS OBTENIDOS POR ADMINISTRACION	1	\N	1	\N	\N
1898	3	0	27	24	1020	DEPOSITOS SIN IDENTIFICAR	1	\N	1	\N	\N
1899	3	0	27	24	3401	GASTOS JUDICIALES REINTEGRABLES	1	0	1	\N	
1900	3	0	27	24	3101	EXPENSAS EXTRAORDINARIAS PRORRATEADAS	1	0	1	\N	 1
1901	3	0	27	24	1016	DEPOSITOS EN PLAZO FIJO	1	\N	1	\N	\N
1902	3	0	27	24	3201	FONDOS ESPECIFICOS PRORRATEADOS	1	\N	1	\N	\N
1903	3	0	27	24	3301	FONDOS DE RESERVA PRORRATEADOS	1	\N	1	\N	\N
1904	3	0	27	24	3701	INTERESES DEVENGADOS	1	\N	1	\N	\N
1905	3	0	27	24	1101	FONDO DE RESERVA	1	\N	1	\N	\N
1906	3	0	27	24	3501	CARGOS DIRECTOS PRORRATEADOS	1	\N	1	\N	\N
1907	3	0	27	24	3801	AJUSTES REALIZADOS	1	\N	1	\N	\N
1908	3	0	27	24	5001	CARGA DE SALDOS INICIALES	1	\N	1	\N	\N
1909	3	0	27	24	4999	AJUSTES	1	0	1	\N	 1
1910	3	0	27	24	1110	FONDO DE OBRA	1	\N	1	\N	\N
1911	3	0	27	24	4450	GASTOS Y COMISIONES BANCARIAS	1	0	1	\N	 1
1912	3	0	27	24	5100	HONORARIOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1913	3	0	27	24	5200	IMPRESOS Y RECIBOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1914	3	0	27	24	5300	OTROS CONCEPTOS FACTURADOS POR LA ADMINISTRACION	1	0	1	\N	
1915	3	0	27	24	3200	FONDO DE OBRA	1	\N	1	\N	\N
1916	3	0	27	24	3900	MULTAS COBRADAS	1	\N	1	\N	\N
1917	3	0	27	24	3510	DERECHO DE USA DE PISCINA	1	\N	1	\N	\N
1918	3	0	27	24	3515	CUOTA FUTBOL	1	\N	1	\N	\N
1919	3	0	27	24	3520	UTILIZACION DE S.U.M.	1	\N	1	\N	\N
1920	3	0	27	24	3530	CARGOS POR TENIS	1	\N	1	\N	\N
1921	3	0	27	24	3550	GOLF	1	\N	1	\N	\N
1922	3	0	27	24	3505	CORTE DE CESPED	1	\N	1	\N	\N
1923	3	0	27	24	3001	EXPENSAS ORDINARIAS TIPO A	1	0	1	\N	
1924	3	0	27	24	1120	FONDO ESPECIFICO	1	\N	1	\N	\N
1925	3	0	27	24	4040	IMPUESTO MUNICIPAL	1	\N	1	\N	\N
1926	3	0	27	24	4045	IMPUESTO DE RENTAS	1	\N	1	\N	\N
1927	3	0	27	24	2807	APORTES Y RETIROS ADMINISTRACION	1	97	1	\N	 1
1928	3	0	27	24	1260	IMP. A LAS GCIAS SALDO A FAVOR	1	0	1	\N	 1
1929	3	0	27	24	2201	RETENCIONES AFIP A DEPOSITAR	1	0	1	\N	 1
1930	3	0	27	24	3002	EXPENSAS ORDINARIAS TIPO B	1	\N	1	\N	\N
1931	3	0	27	24	3003	EXPENSAS ORDINARIAS TIPO C	1	\N	1	\N	\N
1932	3	0	27	24	2315	ART A PAGAR	1	0	1	\N	 1
1933	3	0	27	24	2312	APORTES OBRA SOCIAL A PAGAR	1	\N	1	\N	\N
1934	3	0	27	24	2311	CONTRIBUCIONES SEGURIDAD SOCIAL A PAGAR	1	0	1	\N	 1
1935	3	0	27	24	2313	CONTRIBUCIONES OBRA SOCIAL A PAGAR	1	\N	1	\N	\N
1936	3	0	27	24	4250	HONORARIOS ADMINISTRACION	1	\N	1	\N	\N
1937	3	0	27	24	4255	HONORARIOS ESTUDIO CONTABLE	1	\N	1	\N	\N
1938	3	0	27	24	4220	ABONO FUMIGACION	1	\N	1	\N	\N
1939	3	0	27	24	4230	HONORARIOS ARQUITECTURA	1	0	1	\N	
1940	3	0	27	24	4240	ABONO MANTENIMIENTO PLANTA CLOACAL	1	\N	1	\N	\N
1941	3	0	27	24	4260	ABONO RECOLECCION DE RESIDUOS	1	\N	1	\N	\N
1942	3	0	27	24	4265	RECOLECCION DE RAMAS	1	\N	1	\N	\N
1943	3	0	27	24	4290	OTROS ABONOS	1	\N	1	\N	\N
1944	3	0	27	24	4350	OTROS GASTOS RELACIONADOS A LA SEGURIDAD	1	\N	1	\N	\N
1945	3	0	27	24	3004	EXPENSAS ORDINARIAS TIPO D	1	\N	1	\N	\N
1946	3	0	27	24	4160	IMPUESTOS MUNICIPALES Y TASAS	1	0	1	\N	 1
1947	3	0	27	24	4150	IMPUESTO DE RENTAS	1	\N	1	\N	\N
1948	3	0	27	24	3005	EXPENSAS ORDINARIAS TIPO E	1	\N	1	\N	\N
\.


ALTER TABLE ctacble ENABLE TRIGGER ALL;

--
-- Data for Name: conccble; Type: TABLE DATA; Schema: public; Owner: frola
--


--
-- Data for Name: bancos; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE bancos DISABLE TRIGGER ALL;

COPY bancos (bco_codigo, bco_nombre, bco_estado) FROM stdin;
163	LABOULAYE	1
164	NN	1
165	NN	1
166	SAN JOSE COOP.	1
167	REAL	1
168	COSCREA COOP. LTDO.	1
169	NN	1
170	NN	1
171	NN	1
172	COOP. NICOLAS LAVALLE	1
173	DEL IBERA	1
174	MODELO	1
175	SUDECOR	1
176	COINAG	1
177	NN	1
178	DE BALCARCE	1
179	ALMAFUERTE	1
180	NUCLEO	1
181	MARPLATENSE	1
182	NN	1
183	NN	1
184	COMUNIDADES	1
185	NN	1
186	DEL CENTRO	1
187	NN	1
188	NN	1
189	NOAR	1
190	NN	1
191	CREDICOOP	1
192	HORIZONTE	1
193	ALIANCOOP	1
194	NN	1
195	NUEVA ERA	1
196	VAF	1
197	NN	1
198	DE VALORES S.A.	1
199	DENARIO S.A.	1
200	INSTITUCIONAL	1
201	VALLEMAR COOP LTDO	1
202	LIBERTADOR	1
203	NN	1
204	UDECOOP	1
205	INDEPENDENCIA	1
206	INTEGRADO DEPARTAMENTAL	1
207	CES	1
208	NN	1
209	DE LA RIVERA	1
210	MERIDIONAL	1
211	NN	1
212	ACCION	1
213	NN	1
214	NN	1
215	OCEANICO	1
216	SAN MIGUEL	1
217	BIRCO	1
218	MESOPOTAMICO	1
219	DE LOS ARROYOS	1
220	PELLEGRINI	1
221	NN	1
222	NN	1
223	NN	1
224	NORDECOOP	1
225	ROCA	1
226	NN	1
227	SERRANO	1
228	NN	1
229	BUEN AYRE	1
230	CONCEPCION	1
231	RIO TERCERO	1
232	NN	1
233	CERES	1
234	LOCAL COOP. LTDO.	1
235	COOPESUR	1
236	SAO PAULO	1
237	CASA	1
238	NN	1
239	NN	1
240	NN	1
241	NN	1
242	NN	1
243	LITORCOOP	1
244	SYCOR	1
245	ALAS	1
246	COMAGRO COOP. LTDO.	1
247	ROELA	1
248	NN	1
249	PATRICIOS	1
250	NN	1
251	FEIGIN	1
252	NN	1
253	IRVING AUSTRAL	1
254	MARIVA	1
255	SUQUIA	1
256	NN	1
257	C. HIP. Y EDIF. DE CBA.	1
258	NN	1
259	BANCO ITAU S.A.	1
260	EXTERIOR	1
261	NN	1
262	NN	1
263	NN	1
264	NN	1
265	NAZIONALE DEL LAVORO S.A.	1
266	NATIONALE DE PARIS	1
267	NN	1
268	BCO.PROV.DE TIERRA DEL FUEGO	1
269	REP.ORIENTAL DEL URUGUAY	1
270	NN	1
271	VELOX	1
272	ARGENFE	1
273	LOS TILOS S.A.	1
274	FINAMERICA	1
275	REPUBLICA	1
277	SAENZ	1
278	ASFIN	1
279	PROVENCOR	1
280	FLORENCIA	1
281	LINIERS SUDAMERICANO	1
285	BANCO MACRO S.A.	1
287	MEDEFIN	1
288	UNB	1
289	COMERCIAL FINANZAS	1
290	AMRO BANK	1
297	BANEX	1
299	BANCO COMAFI	1
301	BANCO PIANO	1
303	FINANSUR	1
305	BANCO JULIO S.A.	1
306	BANCO PRIVADO	1
308	BANCO TRANSANDINO	1
309	NUEVO BANCO DE LA RIOJA	1
310	DEL SOL	1
311	NUEVO BANCO DEL CHACO S.A.	1
313	BANCO ARGENCOOP COOP.LIMITADA	1
314	BISEL S.A.	1
315	BANCO DE FORMOSA SA	1
317	RIO NEGRO	1
319	CORPORAC. METROPOLIT. DE FZAS.	1
322	NUEVO BANCO INDUSTRIAL DE AZUL	1
323	CORP BANCA S.A.	1
326	MERCOBANK	1
330	NUEVO BANCO DE SANTA FE	1
386	NUEVO BANCO DE ENTRE RIOS SA	1
387	NUEVO BANCO SUQUIA	1
997	BANKBOSTON (URUGUAY)	1
998	Republic Bank of New York	1
999	BANK OF BOSTON (CHILE)	1
9	DE ITALIA	1
10	LLOYDS BANK	1
11	NACION ARGENTINA	1
12	CREDITO ARGENTINO	1
13	POPULAR ARGENTINO	1
14	PROVINCIA DE BUENOS AIRES	1
72	SANTANDER RIO	1
16	CITIBANK	1
17	BANCO FRANCES	1
18	OF TOKYO	1
19	DE CANADA	1
20	PCIA DE CORDOBA	1
21	AVELLANEDA	1
22	EXPRINTER	1
23	ENCOTEL	1
24	CREDITO RURAL	1
25	DE SANTANDER	1
26	EXTRADER	1
27	SUPERVIELLE	1
28	DI NAPOLI	1
137	EMPRESARIO TUCUMAN	1
30	GENERAL DE NEGOCIOS	1
31	NEWYORK	1
32	NN	1
33	CREDIT LYONNAIS	1
136	NOROESTE C.L.	1
35	NN	1
36	NN	1
37	NN	1
38	NACIONAL DE DESARROLLO	1
39	CAJA NAC. AHORRO Y SEG.	1
40	COOP. DE CASEROS	1
41	DEL INTERIOR	1
42	CHASE	1
43	DE QUILMES	1
44	NN	1
45	DE SAN JUAN	1
46	DO BRASIL	1
47	NN	1
48	DEL OESTE	1
49	PCIA. DE JUJUY	1
50	TORNQUIST	1
51	NN	1
52	NN	1
53	COM. DEL NORTE	1
54	COM. ISRAELITA	1
55	COOP. DE LA PLATA	1
56	CREDITO PROVINCIAL	1
57	NN	1
58	CREDITO COMERCIAL	1
59	ENTRE RIOS	1
60	PCIA. TUCUMAN	1
61	DE MENDOZA	1
62	ISRAELITA DE CORDOBA	1
63	NN	1
64	MONSERRAT	1
65	MUNICIPAL DE ROSARIO	1
66	MUNIC. TUCUMAN	1
67	DEL SUD	1
68	NN	1
69	POPULAR DE ROSARIO	1
70	NN	1
71	PROVINCIAL DE SANTA FE	1
138	NN	1
73	NN	1
74	NN	1
75	DE PREVISION SOCIAL	1
76	NN	1
77	NN	1
78	NN	1
79	REG. DE CUYO	1
80	NN	1
81	SOCIAL DE CORDOBA	1
82	NN	1
83	PROVINCIA DEL CHUBUT	1
84	PCIA DE RIO NEGRO	1
85	PROVINCIA DE SAN LUIS	1
86	PCIA. SANTA CRUZ	1
87	PCIA. SANTIAGO DEL ESTERO	1
88	DE LA RIOJA	1
89	PCIAL. DE SALTA	1
90	NN	1
91	NN	1
92	DE CATAMARCA	1
93	DE LA PAMPA	1
94	PROVINCIA DE CORRIENTES	1
95	PCIA. DE FORMOSA	1
96	DEL CHACO	1
97	PCIA. DEL NEUQUEN	1
98	PCIA. DE MISIONES	1
99	NN	1
100	MUNICIPAL DE PARANA	1
101	NN	1
102	NN	1
103	NN	1
104	NN	1
105	COMERCIAL TANDIL	1
106	AGRARIO	1
107	COM. DE TRES ARROYOS	1
108	COOP DEL ESTE ARGENTINO	1
109	NN	1
110	DORREGO	1
111	CORONEL PRINGLES	1
112	DE JUNIN	1
113	EDIFICADORA OLAVARRIA	1
114	NN	1
115	DE OLAVARRIA	1
116	PARANA S.A.	1
117	NN	1
118	EDIFICADOR	1
119	NN	1
120	NN	1
121	DEL IGUAZU	1
122	NN	1
123	NN	1
124	NN	1
125	NN	1
126	RURAL	1
127	NN	1
128	AZUL	1
129	GANADERO ARGENTINO	1
130	POPULAR FINANCIERO	1
131	NN	1
132	NUEVO BCO DE SGO DEL ESTERO	1
133	CREDITO DE CUYO	1
134	NN	1
135	UNION	1
139	NN	1
140	FEDERAL ARGENTINO	1
141	NN	1
142	NN	1
143	NN	1
144	NN	1
145	NN	1
146	NN	1
147	INTERFINANZAS	1
148	MUNICIPAL DE LA PLATA	1
149	NN	1
34	BANCO PATAGONIA	1
151	ACISO	1
152	FINANCIERO ARGENTINO	1
153	NN	1
154	ALVAREZ	1
155	BCI	1
156	BICA COOP LTDO	1
157	NN	1
158	NN	1
159	BRAGADO	1
160	NN	1
161	BANCO PLATENSE	1
162	MAYO	1
1	DEUTSCHE BANK	1
2	BANCO NACIONALE DEL LAVORO	1
3	EUROPEO	1
4	BANCO ESPAOL	1
321	NN	1
6	SUDAMERIS	1
7	GALICIA	1
8	SHAW	1
388	NN	1
389	NN	1
150	H.S.B.C	1
5	ABN-AMRO	1
29	BANCO CIUDAD	1
15	ICBC	1
\.


ALTER TABLE bancos ENABLE TRIGGER ALL;

SELECT pg_catalog.setval('cargos_car_id_seq', 163, true);


--
-- Data for Name: categincid; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE categincid DISABLE TRIGGER ALL;

COPY categincid (cat_codigo, cat_nombre, cat_estado) FROM stdin;
1	DESCONOCIDA	1
2	OPERATIVA	1
3	COBRANZAS	1
4	PAGO A PROVEEDORES	1
5	RECLAMOS	1
6	ADMINISTRACION	1
7	SISTEMA	1
\.


ALTER TABLE categincid ENABLE TRIGGER ALL;

--
-- Name: categincid_cat_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('categincid_cat_codigo_seq', 7, true);


--
-- Data for Name: catego; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE catego DISABLE TRIGGER ALL;

COPY catego (cat_codigo, cat_nombre) FROM stdin;
1	Categoria 1
2	Categoria 2
\.


ALTER TABLE catego ENABLE TRIGGER ALL;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('centroc_cco_id_seq', 59, true);


--
-- Data for Name: comprob; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE comprob DISABLE TRIGGER ALL;

COPY comprob (comp_id, comp_codigo, comp_nombre, comp_codemp, comp_idptov, comp_sistem, comp_siste, comp_credeb, comp_stcksn, comp_tipo, comp_intext, comp_cuenta, comp_talon, comp_copias, comp_letra, comp_leyen) FROM stdin;
2	RC 	RECIBO DE COBRANZA	1	0	2	4	3	1	1	1	\N	11	1	\N	\N
3	AD 	ASIENTOS DE DIARIOS	1	0	1	4	1	1	1	1	\N	12	1	\N	\N
1	IG 	INGRESO DE GASTOS	1	0	3	\N	1	1	\N	\N	\N	6	1		
4	QL 	INGRESO DE CARGOS	1	0	1	4	1	1	1	1	\N	17	1	\N	\N
5	DI 	DEPOSITOS SIN IDENTIFICAR	1	0	1	4	1	1	1	1	\N	18	1	\N	\N
6	FA 	FACTURA A	1	0	6	4	1	1	1	1	\N	\N	1	A	\N
7	FB 	FACTURA B	1	0	6	4	1	1	1	1	\N	20	1	B	\N
8	ID 	IDENTIFICACION DE COMPROBANTES BANCARIOS	1	0	1	4	1	1	1	1	\N	59	1	\N	\N
9	VN 	CONVENIO DE PAGO	1	0	1	4	1	1	1	1	\N	60	1	\N	\N
10	LQ 	LIQUIDACIONES	1	0	1	4	1	1	1	1	\N	61	1	\N	\N
11	OI 	OTROS INGRESOS	1	0	1	4	1	1	1	1	\N	153	1	\N	\N
13	TR 	TRANSFERENCIA ENTRE CUENTAS 1242	1	0	1	4	1	1	1	1	\N	158	1	\N	\N
14	DC 	DEPOSITO DE CHEQUES	1	0	5	4	1	1	1	1	\N	166	1	\N	Deposito de Cheques
15	DE 	DEPOSITO DE EFECTIVO	1	0	1	4	1	1	1	1	\N	167	1	\N	Deposito de Efectivo
18	RC 	RECIBO DE COBRANZA	3	0	1	4	1	1	1	1	\N	277	1	\N	\N
19	AD 	ASIENTO DE DIARIO	3	0	1	4	1	1	1	1	\N	278	1	\N	\N
20	IG 	INGRESO DE GASTOS	3	0	1	4	1	1	1	1	\N	279	1	\N	\N
21	QL 	INGRESO DE CARGOS	3	0	1	4	1	1	1	1	\N	280	1	\N	\N
22	DI 	DEPOSITOS SIN IDENTIFICAR	3	0	1	4	1	1	1	1	\N	281	1	\N	\N
23	ID 	IDENTIFICACION DE DEPOSITOS	3	0	1	4	1	1	1	1	\N	282	1	\N	\N
24	LQ 	LIQUIDACIONES	3	0	1	4	1	1	1	1	\N	283	1	\N	\N
25	DC 	DEPOSITO DE CHEQUES	3	0	1	4	1	1	1	1	\N	284	1	\N	\N
26	TR 	TRANSFERENCIA ENTRE CUENTAS 1242	3	0	1	4	1	1	1	1	\N	285	1	\N	\N
27	OI 	OTROS INGRESOS	3	0	1	4	1	1	1	1	\N	286	1	\N	\N
28	OE 	OTROS EGRESOS	3	0	1	4	1	1	1	1	\N	287	1	\N	\N
12	OE 	OTROS EGRESOS	1	0	1	\N	1	1	\N	\N	\N	154	1		
\.


ALTER TABLE comprob ENABLE TRIGGER ALL;


ALTER TABLE compra DISABLE TRIGGER ALL;

COPY compra (cpra_id, cpra_idastoh, cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero, cpra_prove, cpra_lecomp, cpra_sucomp, cpra_nucomp, cpra_fecori, cpra_fecval, cpra_fecvto, cpra_estado, cpra_nomprov, cpra_nrcuit, cpra_coniva, cpra_total) FROM stdin;
\.


ALTER TABLE compra ENABLE TRIGGER ALL;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('compra_cpra_id_seq', 1, false);


--
-- Name: comprob_comp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('comprob_comp_id_seq', 28, true);


--
-- Data for Name: coniva; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE coniva DISABLE TRIGGER ALL;

COPY coniva (iva_codigo, iva_nombre, iva_tasa, iva_stasa, iva_discrim) FROM stdin;
1	R.INSCRIP.	21.00000	0.00000	1
6	R.INSCRI. 18%	21.00000	0.00000	1
2	R.NO INSC.	21.00000	0.00000	1
3	CONS.FINAL	21.00000	0.00000	2
5	NO RESP.	21.00000	0.00000	2
7	RESP.MONOTR.	21.00000	0.00000	2
4	EXENTO	21.00000	0.00000	2
\.


ALTER TABLE coniva ENABLE TRIGGER ALL;

--
-- Data for Name: conpag; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE conpag DISABLE TRIGGER ALL;

COPY conpag (cdp_codigo, cdp_nombre, cdp_dias) FROM stdin;
1	CONTADO	0
2	CUENTA CORRIENTE 7 DIAS	7
3	CUENTA CORRIENTE 15 DIAS	15
4	CUENTA CORRIENTE 30 DIAS	30
5	ALQ. CTA.CTE 10 DIAS	9
6	SERVICIOS CTA.CTE. 10 DIAS	10
22	VEINTIDOS DIAS	22
23	VEINTITRES DIAS	23
\.


ALTER TABLE conpag ENABLE TRIGGER ALL;


--
-- Data for Name: moneda; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE moneda DISABLE TRIGGER ALL;

COPY moneda (mon_codigo, mon_nombre, mon_simbol) FROM stdin;
1	PESO           	PES
2	DOLAR EEUU     	DOL
3	FRANCO FRANCES 	FRF
4	LIRA ITALIANA  	LIR
5	PESETA         	PTA
6	MARCO ALEMAN   	MRA
7	FLORIN HOLANDES	FLO
8	FRANCO BELGA   	FRB
9	FRANCO SUIZO   	FRS
10	PESO MEJICANO  	$MX
11	PESO URUGUAYO  	$UR
12	REAL           	REA
13	ESCUDO PORTUG. 	ESP
14	CORONA DANESA  	COD
15	CORONA NORUEGA 	CON
16	CORONA SUECA   	COS
17	CHELIN AUSTRIAC	CHA
18	DOLAR CANADIEN.	U$C
19	YENS           	YEN
21	LIBRA ESTERLINA	LBE
22	MARCO FINLANDES	MRF
23	BOLIVAR        	BOL
24	CORONA CHECA   	COC
25	DINAR          	DIN
26	DOLAR AUSTRALIA	U$A
27	DRACMA         	DRA
28	FLORIN ANT. HOL	FLA
29	GUARANI        	GUA
30	SHEKEL ISRAEL  	SHE
31	PESO BOLIVIANO 	$BO
32	PESO COLOMBIANO	$CO
33	PESO CHILENO   	$CH
34	RAND           	RAN
35	NUEVO SOL PERUA	NSP
36	SUCRE          	SUC
50	LIBRA IRLANDESA	LBI
51	DOLAR HONG KONG	U$H
52	DOLAR SINGAPUR 	U$S
53	DOLAR JAMAICA  	U$J
54	DOLAR TAIWAN   	U$T
55	QUETZAL        	QTZ
56	FORINT HUNGRIA 	FOR
57	BAHT THAILANDIA	BHT
58	ECU            	ECU
59	DINAR KUWAITI  	DIK
60	EURO           	EUR
90	LEV BULGARO    	LEV
91	PESO FILIPINO  	PEF
92	RENMINBI CHINO 	REN
93	RIAL ARABE     	RIA
94	RINGITT MALAYO 	RIN
95	RUBLO RUSO     	RUB
96	RUPIAH INDONESA	RUP
97	WON COREA D.SUR	WON
98	ZLOTY POLACO   	ZLO
\.


ALTER TABLE moneda ENABLE TRIGGER ALL;

--
-- Data for Name: cotiza; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE cotiza DISABLE TRIGGER ALL;

COPY cotiza (cot_moneda, cot_fecha, cot_cotiz) FROM stdin;
\.


ALTER TABLE cotiza ENABLE TRIGGER ALL;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('ctacble_cbl_id_seq', 1948, true);


--
-- Data for Name: ctasconv; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE ctasconv DISABLE TRIGGER ALL;

COPY ctasconv (ctc_id, ctc_idconv, ctc_cuota, ctc_fecha, ctc_importe, ctc_leyen) FROM stdin;
\.


ALTER TABLE ctasconv ENABLE TRIGGER ALL;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('ctasconv_ctc_id_seq', 1, true);


--
-- Name: ctes_cte_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('ctes_cte_id_seq', 4074, true);


--
-- Data for Name: descripliq; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE descripliq DISABLE TRIGGER ALL;

COPY descripliq (dlq_id, dlq_descripcion, dlq_oblig, dlq_estado, dlq_tabla, dlq_campo) FROM stdin;
1	UF	1	1	coprop	cop_unifun
2	NOMBRE	1	1	coprop	cop_nombre
3	TIPO UF	0	1	coprop	cop_tipuf
4	DESC UF	0	1	coprop	cop_descuf
5	TELEFONO	0	1	telefon	tel
6	MAIL	0	1	telefon	mail
7	DIRECCION	0	1	coprop	cop_direcc
8	LOCALIDAD	0	1	coprop	cop_locali
9	CODIGO POSTAL	0	1	coprop	cop_codpos
10	PROVINCIA	0	1	coprop	cop_provin
11	PORCENTAJE A	1	1	coprop	cop_porc1
12	PORCENTAJE B	0	1	coprop	cop_porc2
13	PORCENTAJE C	0	1	coprop	cop_porc3
14	PORCENTAJE D	0	1	coprop	cop_porc4
15	PORCENTAJE E	0	1	coprop	cop_porc5
16	DNI TIPO	0	1	coprop	cop_tipdoc
17	DNI NRO	0	1	coprop	cop_nrdoc
18	SUPERFICIE CUBIERTA	0	1	coprop	cop_superc
19	SUPERFICIE TERRENO	0	1	coprop	cop_supert
20	SUPERFICIE SEMI CUBIERTA	0	1	coprop	cop_supersc
21	PRUEBA	1	0	coprop	\N
\.


ALTER TABLE descripliq ENABLE TRIGGER ALL;

--
-- Name: descripliq_dlq_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('descripliq_dlq_id_seq', 21, true);




--
-- Data for Name: estincid; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE estincid DISABLE TRIGGER ALL;

COPY estincid (est_codigo, est_nombre, est_estado) FROM stdin;
3	RESUELTO	1
5	NO RESUELTO	1
6	IGNORADO	1
1	ABIERTO	1
\.


ALTER TABLE estincid ENABLE TRIGGER ALL;

--
-- Name: estincid_est_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('estincid_est_codigo_seq', 6, true);


--
-- Data for Name: estjud; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE estjud DISABLE TRIGGER ALL;

COPY estjud (etj_codigo, etj_nombre) FROM stdin;
1	A Intimar
2	Intimado
3	Intimado por Carta Documento
4	Informe de Dominio Solicitado
5	Legajo en Estudio Jurico
6	En proceso Judicial
7	En Proceso de Remate Judicial
8	En Convenio de Pago
50	Otra Diligencia
\.


ALTER TABLE estjud ENABLE TRIGGER ALL;

--
-- Data for Name: estjurid; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE estjurid DISABLE TRIGGER ALL;

COPY estjurid (est_codigo, est_nombre, est_codemp) FROM stdin;
1	Estudio Agustn P. Jorge	\N
2	Estudio Benegas	\N
3	Estudio Gorosito	\N
50	Otros Estudios	\N
\.


ALTER TABLE estjurid ENABLE TRIGGER ALL;

--
-- Data for Name: eventos; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE eventos DISABLE TRIGGER ALL;

COPY eventos (evt_id, evt_codemp, evt_idptov, evt_division, evt_centro, evt_idcopr, evt_idamenity, evt_horad, evt_horah, evt_fecha, evt_cantidad, evt_estado) FROM stdin;
\.


ALTER TABLE eventos ENABLE TRIGGER ALL;

--
-- Name: eventos_evt_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('eventos_evt_id_seq', 1, false);


--
-- Data for Name: tipgto; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipgto DISABLE TRIGGER ALL;

COPY tipgto (tg_id, tg_nombre, tg_estado, tg_codemp, tg_cargo, tg_porc) FROM stdin;
1	GASTO A	1	1	1	1
2	GASTO B	1	1	2	2
3	GASTO C	1	1	3	3
4	GASTO D	1	1	4	4
5	GASTO E	1	1	5	5
6	GASTO EXTRAORDINARIO	1	1	6	1
7	GASTO NO PRORRATEABLE	1	1	0	0
8	CUOTA SEGURIDAD	1	1	1	1
\.


ALTER TABLE tipgto ENABLE TRIGGER ALL;



--
-- Data for Name: grupos; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE grupos DISABLE TRIGGER ALL;

COPY grupos (gpo_id, gpo_nombre) FROM stdin;
1	GRUPO 1
\.


ALTER TABLE grupos ENABLE TRIGGER ALL;


--
-- Data for Name: interes; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE interes DISABLE TRIGGER ALL;

COPY interes (int_codemp, int_idptov, int_centro, int_division, int_fecha, int_valor, int_tipo) FROM stdin;
1	1	1	1	2017-03-21	5.00000	1
\.


ALTER TABLE interes ENABLE TRIGGER ALL;

--
-- Data for Name: judicial; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE judicial DISABLE TRIGGER ALL;

COPY judicial (jud_id, jud_codemp, jud_idptov, jud_division, jud_centro, jud_idcopr, jud_ejcod, jud_fecha, jud_deuda, jud_gasto, jud_reintg, jud_estado, jud_estudio, jud_leyen, jud_operador) FROM stdin;
\.


ALTER TABLE judicial ENABLE TRIGGER ALL;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('judicial_jud_id_seq', 1, false);


--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('liqegr_eg_id_seq', 1, true);



--
-- Data for Name: menues; Type: TABLE DATA; Schema: public; Owner: zona
--

ALTER TABLE menues DISABLE TRIGGER ALL;

COPY menues (men_id, men_titulo, men_tipo, men_idmenu, men_estado, men_alias) FROM stdin;
1	Modulo Web	1	\N	1	mMenu_WEB
2	Codificadores	1	\N	1	mMenu_CODIF
3	Copropietarios	1	\N	1	mMenu_COPROP
4	Egresos	1	\N	1	mMenu_EGR
5	Ingresos	1	\N	1	mMenu_ING
6	Cargos	1	\N	1	mMenu_CARGOS
7	Liquidacion	1	\N	1	mMenu_LIQ
8	Contabilidad	1	\N	1	mMenu_CONTAB
9	Bancos	1	\N	1	mMenu_BANCOS
10	Arreglos	1	\N	1	mMenu_ARREGLOS
11	Utilitarios	1	\N	1	mMenu_UTILI
12	Generales	2	2	1	smCODIF_GEN
13	De Egresos	2	2	1	smCODIF_EGR
14	De Ingresos	2	2	1	smCODIF_ING
15	De Liquidacion	2	2	1	smCODIF_LIQ
16	Contables	2	2	1	smCODIF_CONTAB
17	Del Sistema	2	2	1	smCODIF_SIST
18	Judiciales	2	2	1	smCODIF_JUDIC
19	Menues	2	2	1	smCODIF_MENU
20	Ordenes de Compra	2	4	1	smEGR_OCOMPRA
21	Modificaciones	2	4	1	smEGR_MODIF
22	Honorarios	2	4	1	smEGR_HONO
23	Cobranzas	2	5	1	smING_COBR
24	Modificaciones	2	5	1	smING_MODIF
25	Consultas	2	5	1	smING_CONSU
26	Seguimiento de Cheques	2	5	1	smING_SEGCHQ
27	Procesos Periodicos	2	8	1	smCONTAB_PROCPER
28	Consultas Contables	2	8	1	smCONTAB_CONSUL
29	Mensajes	1	\N	1	mMensajes
30	De Grupo Familiar	2	7	1	smLiq_GrupoF
31	Incidencias	1	\N	1	mIncidencias
\.


ALTER TABLE menues ENABLE TRIGGER ALL;

--
-- Name: menues_men_id_seq; Type: SEQUENCE SET; Schema: public; Owner: zona
--

SELECT pg_catalog.setval('menues_men_id_seq', 31, true);


--
-- Data for Name: operadores; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE operadores DISABLE TRIGGER ALL;

COPY operadores (operad_id, operad_nombre, operad_pass, operad_sector, operad_estado, operad_nivaut1, operad_nivaut2, operad_count, operad_grupo, operad_cliente, operad_login, operad_last, operad_contacto, operad_telefono, operad_codemp, operad_ptovta, operad_revision, operad_logued) FROM stdin;
1	Maximiliano Lpez Melnyk	lopez1	\N	1	2 	2 	713	1	\N	maxi	2017-02-24	\N	\N	1	\N	0	0
2	Fabian G. Lopez	monica01	\N	1	2 	2 	1599	1	\N	fabianl	2017-04-10	\N	\N	1	\N	1	1
\.


ALTER TABLE operadores ENABLE TRIGGER ALL;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('operadores_operad_id_seq', 3, true);


--
-- Data for Name: priorincid; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE priorincid DISABLE TRIGGER ALL;

COPY priorincid (pri_codigo, pri_nombre, pri_estado) FROM stdin;
1	NULA	1
2	BAJA	1
3	MEDIA	1
4	ALTA	1
5	URGENTE	1
\.


ALTER TABLE priorincid ENABLE TRIGGER ALL;

--
-- Name: ordencompra_oc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('ordencompra_oc_id_seq', 1, true);


--
-- Data for Name: pais; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE pais DISABLE TRIGGER ALL;

COPY pais (pai_codigo, pai_nombre) FROM stdin;
1	Lépez
101	BURKINA FASO
102	ARGELIA
103	BOTSWANA
104	BURUNDI
105	CAMERUN
107	CENTROAFRIC. REP.
108	CONGO
109	ZAIRE
110	COSTA DE MARFIL
111	CHAD
112	BENIN
113	EGIPTO
115	GABON
116	GAMBIA
117	GHANA
118	GUINEA
119	GUINEA ECUATORIAL
120	KENYA
121	LESOTHO
122	LIBERIA
123	LIBIA
124	MADAGASCAR
125	MALAWI
126	MALI
127	MARRUECOS
128	MAURICIO, ISLAS
129	MAURITANIA
130	NIGER
131	NIGERIA
132	ZIMBABWE
133	RWANDA
134	SENEGAL
135	SIERRA LEONA
136	SOMALIA
137	SWAZILANDIA
138	SUDAN
139	TANZANIA
140	TOGO
141	TUNEZ
142	UGANDA
144	ZAMBIA
145	POS.BRIT.(AFRICA)
146	TERRITORIOS ESPAOLE
147	POS.FRANC.(AFRICA)
149	ANGOLA
150	CABO VERDE, ISLAS
151	MOZAMBIQUE
152	SEYCHELLES
153	DJIBOUTI
155	COMORAS
156	GUINEA BISSAU
157	STO.TOME Y PRINCIPE
158	NAMIBIA
159	SUDAFRICA
160	ERITREA
161	ETIOPIA
198	INDET.(AFRICA)
200	ARGENTINA
201	BARBADOS
202	BOLIVIA
203	BRASIL
204	CANADA
205	COLOMBIA
206	COSTA RICA
207	CUBA
208	CHILE
209	DOMINICANA REP.
210	ECUADOR
211	EL SALVADOR
212	ESTADOS UNIDOS
213	GUATEMALA
214	GUYANA
215	HAITI
216	HONDURAS
217	JAMAICA
218	MEXICO
219	NICARAGUA
220	PANAMA
221	PARAGUAY
222	PERU
223	PUERTO RICO
224	TRINIDAD-TOBAGO
225	URUGUAY
226	VENEZUELA
227	TERRITORIO BRITANICO
228	TERRITORIOS DANESES
229	TERRITORIO FRANCESES
230	TERRIT. HOLANDESES
231	POS.U.S.A.(AMERICA)
232	SURINAME
233	DOMINICA
234	SANTA LUCIA
235	S.VICENTE Y LAS GRAN
236	BELICE
237	ANTIGUA Y BARBUDA
238	S.CRISTOBAL Y NEVIS
239	BAHAMAS
240	GRENADA
250	A.AD.ESP.T.DEL FUEGO
251	Z.F. LA PLATA
252	Z.F. JUSTO DARACT
253	Z.F. RIO GALLEGOS
260	IQUIQUE
270	COLON
280	Z.F. COLONIA
281	Z.F. FLORIDA
282	Z.F. LIBERTAD
283	Z.F. MONTEVIDEO
284	Z.F. NVA.HELVECIA
285	Z.F. NVA. PALMIRA
286	Z.F. RIO NEGRO
287	Z.F. RIVERA
288	Z.F. SAN JOSE
291	Z.F. MANAOS
298	INDET.(AMERICA)
301	AFGANISTAN
302	ARABIA SAUDITA
303	BAHREIN
304	MYANMAR(EX-BIRMANIA)
305	BUTAN
306	CAMBOYA(EX-KAMPUCHE)
307	SRI LANKA
308	COREA DEMOCRATICA
309	COREA REPUBLICANA
310	CHINA
312	FILIPINAS
313	TAIWAN
315	INDIA
316	INDONESIA
317	IRAK
318	IRAN
319	ISRAEL
320	JAPON
321	JORDANIA
322	QATAR
323	KUWAIT
324	LAOS
325	LIBANO
326	MALASIA
327	MALDIVE,ISLAS
328	OMAN
329	MONGOLIA
330	NEPAL
331	EMIRATOS ARABES UNID
332	PAKISTAN
333	SINGAPUR
334	SIRIA
335	THAILANDIA
337	VIETNAM
341	HONG KONG
344	MACAU(PORTUGUES)
345	BANGLADESH
346	BRUNEI
348	YEMEN, REP.
349	ARMENIA
350	AZERBAIDZHAN
351	GEORGIA
352	KAZAJSTAN
353	KIRGUISTAN
354	TAYIKISTAN
355	TURKMENISTAN
356	UZBEKISTAN
357	TERR. AU. PALESTINOS
398	INDET.(ASIA)
401	ALBANIA
404	ANDORRA
405	AUSTRIA
406	BELGICA
407	BULGARIA
409	DINAMARCA
410	ESPAA
411	FINLANDIA
412	FRANCIA
413	GRECIA
414	HUNGRIA
415	IRLANDA
416	ISLANDIA
417	ITALIA
418	LIECHTENSTEIN
419	LUXEMBURGO
420	MALTA
421	MONACO
422	NORUEGA
423	PAISES BAJOS
424	POLONIA
425	PORTUGAL
426	REINO UNIDO
427	RUMANIA
428	SAN MARINO
429	SUECIA
430	SUIZA
431	VATICANO(SANTA SEDE)
433	POS. BRIT.(EUROPA)
435	CHIPRE
436	TURQUIA
438	ALEMANIA REP. FED.
439	BIELORUS
440	ESTONIA
441	LETONIA
442	LITUANIA
443	MOLDOVA
444	RUSIA
445	UCRANIA
446	BOSNIA HERZEGOVINA
447	CROACIA
448	ESLOVAQUIA
449	ESLOVENIA
450	MACEDONIA
451	REP. CHECA
452	YUGOESLAVIA
498	INDET.(EUROPA)
501	AUSTRALIA
503	NAURU
504	NUEVA ZELANDIA
505	VANATU
506	SAMOA OCCIDENTAL
507	POS.AUSTRAL.(OCEANIA
508	POS.BRIT.(OCEANIA)
509	POS.FRANC.(OCEANIA)
510	POS.NEOZEL.(OCEANIA)
511	POS.U.S.A.(OCEANIA)
512	FIJI, ISLAS
513	PAPUA NUEVA GUINEA
514	KIRIBATI, ISLAS
515	MICRONESIA,EST.FEDER
516	PALAU
517	TUVALU
518	SALOMON, ISLAS
519	TONGA
520	MARSHALL, ISLAS
521	MARIANAS, ISLAS
598	INDET.(OCEANIA)
998	INDET.(CONTINENTE)
701	DATO DESCONOCIDO
408	DATO DESCONOCIDO
114	DATO DESCONOCIDO
437	DATO DESCONOCIDO
454	SERVIA
\.


ALTER TABLE pais ENABLE TRIGGER ALL;

--
-- Name: priorincid_pri_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('priorincid_pri_codigo_seq', 5, true);


--
-- Name: prove_prov_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('prove_prov_id_seq', 1, true);


--
-- Data for Name: provin; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE provin DISABLE TRIGGER ALL;

COPY provin (pro_codigo, pro_nombre, pro_tasa, pro_coef, pro_valor) FROM stdin;
20	SANTA CRUZ	0.00000	0.00000	0.00
22	SANTA FE	0.00000	0.00000	0.00
23	SANTIAGO DEL ESTERO	0.00000	0.00000	0.00
24	TIERRA DEL FUEGO	0.00000	0.00000	0.00
25	TUCUMAN	0.00000	0.00000	0.00
3	CATAMARCA	3.00000	\N	0.00
1	BUENOS AIRES	1.00000	0.00000	0.00
4	CHACO	0.00000	0.00000	0.00
5	CHUBUT	0.00000	0.00000	0.00
6	CORDOBA	0.00000	0.00000	0.00
7	CORRIENTES	0.00000	0.00000	0.00
8	ENTRE RIOS	0.00000	0.00000	0.00
9	FORMOSA	0.00000	0.00000	0.00
10	JUJUY	0.00000	0.00000	0.00
11	LA PAMPA	0.00000	0.00000	0.00
12	LA RIOJA	0.00000	0.00000	0.00
13	MENDOZA	0.00000	0.00000	0.00
14	MISIONES	0.00000	0.00000	0.00
15	NEUQUEN	0.00000	0.00000	0.00
16	RIO NEGRO	0.00000	0.00000	0.00
17	SALTA	0.00000	0.00000	0.00
18	SAN JUAN	0.00000	0.00000	0.00
19	SAN LUIS	0.00000	0.00000	0.00
0	NOT SELECT	0.00000	0.00000	0.00
2	CIUDAD AUTONOMA DE BS AS	3.50000	\N	\N
\.


ALTER TABLE provin ENABLE TRIGGER ALL;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('ptovta_ptv_id_seq', 2, true);


--
-- Data for Name: relmenu; Type: TABLE DATA; Schema: public; Owner: zona
--

ALTER TABLE relmenu DISABLE TRIGGER ALL;

COPY relmenu (rmen_id, rmen_titulo, rmen_link, rmen_tipo, rmen_idmenu, rmen_nivel, rmen_estado) FROM stdin;
84	Consulta de un Cheque	contab/cheques/conschq.php?modalidad=3	1	26	0	1
85	Cheque en Cartera por Punto de Venta	contab/cheques/conschq.php?modalidad=4	1	26	0	1
86	Cheques Egresados por Comprobante	contab/cheques/conschq.php?modalidad=5	1	26	0	1
87	Consulta Gen&eacute;rica	contab/cheques/conschq.php?tipctadxv=1&tipctadxc=1	1	26	0	1
88	Cheques en Cauci&oacute;n	contab/cheques/conschq.php?chq_estado=6&accion=CONSULTA	1	26	0	1
121	Propietarios	codificadores/contables/coprop.php	1	3	0	1
7	Publicacion de Liquidaciones	web/notisj.php	1	1	0	1
8	Consulta de Publicaciones	web/muestroliq.php	1	1	0	1
9	Paises	codificadores/codbas/pais.php	1	12	0	1
10	Provincias	codificadores/codbas/provin.php	1	12	0	1
11	Monedas	codificadores/codbas/moneda.php	1	12	0	1
12	Condiciones de Pago	codificadores/codbas/conpag.php	1	12	0	1
13	Categor&iacute;as	codificadores/codbas/catego.php	1	12	0	1
14	Tipos de Empresas	codificadores/codbas/tipemp.php	1	12	0	1
15	Tipos de Emprendimientos	codificadores/codbas/tipempr.php	1	12	0	1
16	Tipos de Documentos	codificadores/codbas/tipdocu.php	1	12	0	1
17	Tipos de Tel&eacute;fonos	codificadores/codbas/tiptel.php	1	12	0	1
18	Tipos de Unidades Funcionales	codificadores/contables/tipuf.php	1	12	0	1
19	Secciones	codificadores/codbas/seccion.php	1	12	0	1
20	Provedores	codificadores/egresos/prove.php	1	13	0	1
21	Rubros de Gastos	codificadores/egresos/rubros.php	1	13	0	1
22	Sub Rubros de Gastos	codificadores/egresos/subrub.php	1	13	0	1
23	Honorarios	codificadores/egresos/honorarios.php	1	13	0	1
24	Cheques	codificadores/ventas/cheques.php	1	14	0	1
25	Cotizaciones Moneda Extranjera	codificadores/contables/cotiza.php	1	14	0	1
26	Rubros de Cargos	codificadores/liquid/rubros_new.php?rubl_tipo=2	1	15	0	1
27	Sub Rubros de Cargos	codificadores/liquid/subrubros_new.php	1	15	0	1
28	Conceptos de Cargos	codificadores/liquid/cargos.php	1	15	0	1
29	Empresas	codificadores/sistema/empresa.php	1	17	0	1
30	Emprendimientos	codificadores/contables/emprend.php	1	17	0	1
31	Logos de Emprendimientos	codificadores/contables/upLogo.php	1	17	0	1
32	Divisiones	codificadores/contables/division.php	1	17	0	1
33	Centro de Costos	codificadores/contables/centroc.php	1	17	0	1
34	Operadores	codificadores/sistema/operad.php	1	17	0	1
35	Grupos de Operadores	codificadores/sistema/grupos.php	1	17	0	1
36	Variables de Ambiente Propias	codificadores/sistema/varambi.php	1	17	0	1
37	Variables de Ambiente Grales	codificadores/sistema/varamb.php	1	17	0	1
38	Estados Judiciales	codificadores/judicial/estjud.php	1	18	0	1
39	Estudios Jur&iacute;dicos	codificadores/judicial/estjurid.php	1	18	0	1
40	Comprobantes	codificadores/contables/comprob.php	1	16	0	1
41	Talonarios	codificadores/contables/talon.php	1	16	0	1
42	Cuentas Contables	codificadores/contables/ctacble.php	1	16	0	1
43	Cuentas Corrientes Asociadas	codificadores/contables/ctes.php	1	16	0	1
44	Interes por mora	codificadores/contables/interes_mora.php	1	16	0	1
45	Cotizaciones	codificadores/contables/cotiza.php	1	16	0	1
46	Subdiarios	codificadores/contables/subdiario.php	1	16	0	1
47	Art&iacute;culos de Venta	codificadores/contables/articvta.php	1	16	0	1
48	Condiciones de Iva	codificadores/contables/coniva.php	1	16	0	1
49	Bancos	codificadores/contables/bancos.php	1	16	0	1
50	Tipos de Cuentas Corrientes	codificadores/contables/tipcta.php	1	16	0	1
51	Menus	codificadores/menues/menues.php	1	19	0	1
52	Item Menus	codificadores/menues/relmenu.php	1	19	0	1
53	Menus por Operador	codificadores/menues/opermenu.php	1	19	0	1
54	Ingreso de Gastos	gastos/ingegr.php	1	4	0	1
55	Ingreso de Gastos Con Un cheque	gastos/vsgsunpago.php	1	4	0	1
56	Agrupamiento de Gastos	gastos/agrupam.php	1	4	0	1
57	Resumen Financiero	gastos/resfin.php	1	4	0	1
58	Resumen Financiero Total	gastos/resfin.php?modo=1	1	4	0	1
59	Orden de Compra sin gasto	gastos/ordencompra.php	1	20	0	1
60	Convertir Orden de Compra en Gasto	gastos/gasto_oc.php	1	20	0	1
61	Crear OC sobre gasto	gastos/haceroc.php	1	20	0	1
62	Reimprimir OC	gastos/reimpreoc.php	1	20	0	1
63	Modificaci&oacute;n de Gastos	gastos/modingegr.php?comprob=IG	1	21	0	1
64	Anulaci&oacute;n de Gastos	gastos/anulaciongs.php	1	21	0	1
65	Carga Mensual de Honorarios	gastos/cargahono.php	1	22	0	1
66	Aumento porcentual de Honorarios	gastos/aumentohono.php	1	22	0	1
67	Cuentas Corrientes de Copropietarios	contab/consultas/consuxcta.php?tipo=99	1	25	0	1
68	Listado de Cuentas Corrientes	contab/consultas/liscte.php	1	25	0	1
69	Listado de Cargos sin liquidar	cargos/listcargos.php	1	25	0	1
70	Consulta de Cobranzas	contab/consultas/consuxcomp.php?comprobante=	1	25	0	1
71	Rendicion de Caja Diaria	contab/consultas/rendcaj.php	1	25	0	1
72	Interes Pago Fuera Termino	contab/consultas/calcint.php	1	25	0	1
73	Cobranzas simples	cobranz/cobransimp.php	1	23	0	1
74	Cobranzas m&uacute;ltiples	cobranz/cobranmult.php	1	23	0	1
75	Identificador	bancos/identificador.php	1	23	0	1
76	Identificador Administraci&oacute;n	bancos/identifadm.php	1	23	0	1
77	Reimpresi&oacute;n de Cobranzas	cobranz/reimprecib.php	1	23	0	1
78	Impresi&oacute;n M&uacute;ltiple	cobranz/imprimorecmult.php	1	23	0	1
79	Modificacin de Identificaciones	bancos/modidentificador.php	1	24	0	1
81	Anulaci&oacute;n de Cobranzas	cobranz/mod_cobran.php?anular=1	1	24	1	1
82	Cheques en Cartera	contab/cheques/conschq.php?chq_estado=2&accion=CONSULTA	1	26	0	1
83	Cheques Ingresados por Comprobante	contab/cheques/conschq.php?modalidad=2	1	26	0	1
133	Carga Excel Varios (Tel)	liquidaciones/cargoTelefonos.php	1	11	0	1
122	Cargos Fijos de Propietarios	codificadores/contables/comprop.php	1	3	1	1
123	Agenda Telef&oacute;nica	codificadores/contables/telefonos.php	1	3	0	1
124	Imprimir Mails	consultas/exportomails.php	1	3	0	1
125	Paso Gasto por Mes	gastos/pasogto.php	1	21	1	1
89	Consulta de Cheque con Parte N&uacute;mero	contab/cheques/conschq.php?modalidad=6	1	26	0	1
90	Modificaci&oacute;n de Cheques	codificadores/ventas/cheques.php	1	26	1	1
91	Ingreso de Cargos	cargos/compliq.php	1	6	0	1
92	Excel Cargos Fijos	cargos/upComprop.php?ash_codemp=$codemp	1	6	0	1
93	Liquidar	liquidaciones/liquidador.php	1	7	0	1
94	Excel Carga Saldos Iniciales	liquidaciones/saldosiniciales.php	1	7	0	1
95	Imprimir Liquidacion	liquidaciones/exportoliq.php	1	7	0	1
96	Carga de Asientos Diarios	contab/asientos/astos.php?comprobante=AD	1	27	0	1
99	Conciliaci&oacute;n de Cuentas Contables	contab/conciliaciones/conc1242.php	1	27	0	1
100	Modificaci&oacute;n de Asientos	contab/asientos/astos.php?modo=1	1	27	1	1
101	Anulaci&oacute;n de Asientos	facturacion/facanul.php?modo=1	1	27	1	1
102	Borrado de Asientos	facturacion/facanul.php?modo=1&borro=1	1	27	1	1
103	Asientos de Cierre y Apertura	contab/asientos/cierre.php	1	27	1	1
104	Consulta de Mayor 	contab/consultas/consumayor.php	1	28	0	1
105	Consulta de Mayor Total	contab/consultas/consumayor.php?moda=1	1	28	0	1
106	Analisis Administracion 	contab/consultas/consuadm.php	1	28	0	1
107	Imputaciones de Gastos 	contab/consultas/verimput.php	1	28	0	1
108	Libro Diario 	asientos/libdiario.php	1	28	0	1
109	Consulta de Cuentas Corrientes	contab/consultas/consuctacte.php	1	28	0	1
110	Balance de Sumas y Saldos	contab/consultas/bcesumsal.php	1	28	0	1
111	Listado de Saldos de Cuentas Asociadas	contab/consultas/lisctacte.php	1	28	0	1
112	Consulta de Asientos	contab/consultas/consuxcomp.php	1	28	0	1
113	Consulta de Mon. Extranjera 	contab/consultas/consumonex.php	1	28	0	1
114	Comprobantes Cargados por Fecha	contab/consultas/compxdia.php	1	28	0	1
115	An&aacute;lisis de Gastos 	contab/consultas/anagas.php	1	28	0	1
116	Dep&oacute;sitos sin identificar	bancos/sidentif.php	1	9	0	1
117	Ingreso de Dep&oacute;sitos	contab/bancos/deposito.php	1	9	0	1
118	Conciliacion Bancaria	contab/bancos/concilia.php?modo=1	1	9	0	1
119	Carga de Asientos	contab/asientos/astosp.php	1	10	0	1
120	Cambio de Contrase&ntilde;a	changpass.php	1	11	0	1
126	Carga de Facturas Fisicas Escaneadas	gastos/cargaimgs.php	1	4	0	1
127	Revision de Liquidaciones	liquidaciones/revisliq.php	1	7	0	1
128	Listado Control Compliq vs Astc	contab/consultas/liscontrol.php	1	25	0	1
129	Nuevo Mensaje	llamadas/llamada.php	1	29	0	1
80	Modificacin de Cobranzas	cobranz/mod_cobran.php	1	24	0	1
130	Mensajes Recibidos	llamadas/llamadas_recibidas.php	1	29	0	1
131	Conversaciones	llamadas/consulta_llamadas.php	1	29	0	1
132	Mensajes a Todos	llamadas/mensaje_a_todos.php	1	29	0	1
134	Modificar Revisiones de Liquidacion	liquidaciones/revisliq.php?accion=MODIFICAR	1	11	0	1
135	Liquidacion con Grupo Familiar	liquidaciones/liquidadorgf.php	1	30	0	1
136	Imprimir Liquidacin de Grupo Familiar	liquidaciones/exportoliqgf.php	1	30	0	1
137	Pasaje de Tipo de Gastos	gastos/cambiotg.php	1	4	0	1
138	Control de Liquidacin	liquidaciones/exportoliqc.php	1	7	0	1
139	Upload Ajustes	cargos/upAjustes.php	1	6	0	1
140	Carga de Otros Ingresos	contab/asientos/astos.php?comprobante=OI	1	27	0	1
141	Carga de Otros Egresos	contab/asientos/astos.php?comprobante=OE	1	27	0	1
98	Carga de Asientos Generales	contab/asientos/astos.php	1	27	0	2
97	Carga de Asientos Mensuales	contab/asientos/astos.php?comprobante=AP&tipo=1	1	27	0	2
142	Modificacion de Cargos	cargos/modcompliq.php	1	6	0	1
143	Consulta Grupo Familiar	codificadores/contables/grupof.php	1	3	0	1
144	Ingresar Incidencia	incidencias/reginc.php	1	31	0	1
146	Consulta Incidencias Sin Resolucion	incidencias/inc_recibidas.php?modo=1	1	31	0	1
147	Consulta Incidencias Resueltas	incidencias/inc_recibidas.php?modo=2	1	31	0	1
145	Consultar Incidencias Propias Pendientes	incidencias/inc_recibidas.php?accion=PROPIAS	1	31	0	1
148	Modificacion Saravi	codificadores/contables/coprop.php?modunif=100	1	3	0	1
149	Contratos	codificadores/contables/contratos.php	1	3	0	1
150	Cambiar fecha de Cheque	contab/bancos/cambfecha.php	1	9	0	1
151	Calculo de Cuota Morosidad	liquidaciones/cuotamorosidad.php	1	7	0	1
\.


ALTER TABLE relmenu ENABLE TRIGGER ALL;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE SET; Schema: public; Owner: zona
--

SELECT pg_catalog.setval('relmenu_rmen_id_seq', 151, true);


--
-- Data for Name: rubcar; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE rubcar DISABLE TRIGGER ALL;

COPY rubcar (rubl_id, rubl_codemp, rubl_tipo, rubl_codigo, rubl_nombre) FROM stdin;
13	1	1	10	CARGA DE SALDOS INICIALES
1	1	1	100	EXPENSAS ORDINARIAS
2	1	1	200	EXPENSAS EXTRAORDINARIAS
3	1	1	300	REINTEGRO DE GASTOS
4	1	1	400	GASTOS JUDICIALES
5	1	1	500	CARGOS DIRECTOS
6	1	1	600	GASTOS PARTICULARES
7	1	1	700	COBRANZAS Y AJUSTES
9	1	1	900	CONVENIOS DE PAGO
10	1	1	1000	FONDOS DE RESERVA
11	1	1	1100	FONDOS ESPECIFICOS
12	1	1	1200	INTERESES
26	3	1	10	CARGA DE SALDOS INICIALES
27	3	1	100	EXPENSAS ORDINARIAS
28	3	1	200	EXPENSAS EXTRAORDINARIAS
29	3	1	300	REINTEGRO DE GASTOS
30	3	1	400	GASTOS JUDICIALES
31	3	1	500	CARGOS DIRECTOS
32	3	1	600	GASTOS PARTICULARES
33	3	1	700	COBRANZAS Y AJUSTES
34	3	1	900	CONVENIOS DE PAGO
35	3	1	1000	FONDOS DE RESERVA
36	3	1	1100	FONDOS ESPECIFICOS
37	3	1	1200	INTERESES
\.


ALTER TABLE rubcar ENABLE TRIGGER ALL;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('rubcar_rubl_id_seq', 37, true);


--
-- Data for Name: rubros; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE rubros DISABLE TRIGGER ALL;

COPY rubros (rub_id, rub_codemp, rub_idptov, rub_tipo, rub_codigo, rub_nombre) FROM stdin;
2	1	0	1	10	SERVICIOS
3	1	0	1	20	HONORARIOS Y ABONOS
4	1	0	1	30	SERVICIOS DE SEGURIDAD
1	1	0	1	1	PERSONAL
6	1	0	1	40	GASTOS ADMINISTRATIVOS
7	1	0	1	50	GASTOS JUDICIALES
8	1	0	1	60	MANTENIMIENTO
9	1	0	1	100	ACTIVIDADES DEPORTIVAS Y RECREATIVAS
13	1	0	1	130	CONSECIONARIOS
14	1	0	1	15	IMPUESTOS TASAS Y CONTRIBUCIONES
11	1	0	1	110	COLABORACIONES
12	1	0	1	120	SEGUROS
16	3	0	1	10	SERVICIOS
17	3	0	1	20	HONORARIOS Y ABONOS
18	3	0	1	30	SERVICIOS DE SEGURIDAD
19	3	0	1	1	PERSONAL
20	3	0	1	40	GASTOS ADMINISTRATIVOS
21	3	0	1	50	GASTOS JUDICIALES
22	3	0	1	60	MANTENIMIENTO
23	3	0	1	100	ACTIVIDADES DEPORTIVAS Y RECREATIVAS
24	3	0	1	130	CONSECIONARIOS
25	3	0	1	15	IMPUESTOS TASAS Y CONTRIBUCIONES
26	3	0	1	110	COLABORACIONES
27	3	0	1	120	SEGUROS
\.


ALTER TABLE rubros ENABLE TRIGGER ALL;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('rubros_rub_id_seq', 27, true);


--
-- Data for Name: seccion; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE seccion DISABLE TRIGGER ALL;

COPY seccion (sec_codigo, sec_nombre) FROM stdin;
4	ARS
1	SECCION I
2	SECCION II
3	SECCION III
\.


ALTER TABLE seccion ENABLE TRIGGER ALL;


--
-- Data for Name: srubcar; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE srubcar DISABLE TRIGGER ALL;

COPY srubcar (srbl_id, srbl_rubro, srbl_codigo, srbl_nombre, srbl_precio, srbl_leyen, srbl_codemp, srbl_idptov, srbl_genint) FROM stdin;
11	10	1	FONDOS DE RESERVA	0.00000	FONDOS DE RESERVA	1	0	1
12	11	1	FONDOS ESPECIFICOS	0.00000	FONDOS ESPECIFICOS	1	0	1
13	13	1	CARGA DE SALDOS INICIALES	0.00000	CARGA DE SALDOS INICIALES	1	0	0
14	6	2	DERECHO DE INCORPORACION	0.00000	DERECHO DE INCORPORACION	1	0	0
1	1	1	EXPENSAS ORDINARIAS	0.00000	EXPENSAS ORDINARIAS	1	0	0
10	12	1	INTERESES RESARCITORIOS	0.00000	INTERESES RESARCITORIOS	1	0	0
2	2	1	EXPENSAS EXTRAORDINARIAS	0.00000	EXPENSAS EXTRAORDINARIAS	1	0	0
3	3	1	REINTEGRO DE GASTOS	0.00000	REINTEGRO DE GASTOS	1	0	0
4	4	1	GASTOS JUDICIALES	0.00000	GASTOS JUDICIALES	1	0	0
5	5	1	CARGOS DIRECTOS	0.00000	CARGOS DIRECTOS	1	0	0
6	6	1	GASTOS PARTICULARES	0.00000	GASTOS PARTICULARES	1	0	0
7	7	1	COBRANZAS	0.00000	COBRANZAS	1	0	0
8	7	2	AJUSTES	0.00000	AJUSTES	1	0	0
9	9	1	CONVENIOS DE PAGO	0.00000	CONVENIOS DE PAGO	1	0	0
\.


ALTER TABLE srubcar ENABLE TRIGGER ALL;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('srubcar_srbl_id_seq', 14, true);


--
-- Data for Name: subd; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE subd DISABLE TRIGGER ALL;

COPY subd (subd_id, subd_codemp, subd_idptov, subd_nombre, subd_titulo, subd_fecd, subd_fech, subd_estado, subd_proxnum) FROM stdin;
\.


ALTER TABLE subd ENABLE TRIGGER ALL;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('subd_subd_id_seq', 1, false);


--
-- Data for Name: subrub; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE subrub DISABLE TRIGGER ALL;

COPY subrub (srb_id, srb_rubro, srb_codemp, srb_idptov, srb_codigo, srb_nombre, srb_precio, srb_leyen, srb_codtg, srb_conper, srb_tiprub, srb_cuenta) FROM stdin;
7	3	1	0	3	AREAS VERDES	0.00	Servicio de Conservaciin de Areas Verdes y Espacios Comunes	1	1	1	1363
2	1	1	0	50	CARGAS SOCIALES	0.00	Cargas Sociales	1	1	1	1312
3	2	1	0	100	ENERGIA ELECTRICA	0.00	Edenor 	1	1	1	1314
4	2	1	0	1	GAS	0.00	Provisin de Gas	1	1	1	1315
1	1	1	0	2	HABERES PERSONAL DEPENDIENTE	0.00	Haberes Sr. 	1	1	1	1311
6	3	1	0	2	HONORARIOS DE ARQUITECTURA	0.00	Honorarios de Arquitectura	1	1	1	1366
5	3	1	0	1	HONORARIOS ADMINISTRACION	0.00	Honorarios Administracion	1	1	1	1372
8	6	1	0	10	GASTOS BANCARIOS	0.00	Gastos Bancarios e Impuesto a los Dbitos y Crditos	1	2	1	1343
9	2	1	0	200	SERVICIOS TELEFNICOS	0.00	Servicio Telefnico	1	2	1	1317
10	2	1	0	300	PROVISIN DE AGUA	0.00	Provisin de Agua	1	2	1	1316
11	4	1	0	100	SERVICIO DE SEGURIDAD	0.00	Servicio de Seguridad	1	1	1	1322
12	4	1	0	200	ABONO CAMARAS DE SEGURIDAD	0.00	Servicio de Mantenimiento de Cmaras de Seguridad	1	1	1	1362
13	8	1	0	1	REPARACIONES	0.00	Reparacion	1	2	1	1321
14	3	1	0	4	AREA PROTEGIDA	0.00	Abono Area Protegida	1	2	1	1368
15	3	1	0	5	ABONO MANTENIMIENTO PLANTA CLOACAL	0.00	Abono Mantenimiento de Planta Cloacal 	3	1	1	1367
16	3	1	0	6	GUARDAVIDAS	0.00	Servicio de Guardavidas 	2	1	1	1371
17	8	1	0	2	ARTICULOS DE LIMPIEZA	0.00	Articulos de Limpieza	3	2	1	1397
18	3	1	0	7	ABONO RECOLECCION DE RESIDUOS 	0.00	Abono Recoleccin de Residuos	1	1	1	1369
19	3	1	0	8	ABONO RECOLECCION DE RAMAS	0.00	Abono Recoleccin de Ramas	1	1	1	1370
20	8	1	0	3	MATERAILES DE FERRETERIA Y VARIOS	0.00	Materiales de Ferreteria y Varios	1	2	1	1321
21	8	1	0	4	COMPRA DE COMBUSTIBLE	0.00	Compra de Combustible	1	2	1	1376
22	3	1	0	9	FUMIGACION	0.00	Abono Fumigacion 	1	1	1	1365
23	13	1	0	1	CONSECIONARIOS	0.00	Consecionario House	1	2	1	1378
24	8	1	0	5	MATERIALES ELECTRICOS E ILUMINACION 	0.00	Materiales de Electricidad e Iluminacin	1	2	1	1377
25	3	1	0	10	MANTENIMIENTO DE PILETA	0.00	Abono Mantenimiento de Piscina	1	1	1	1374
26	7	1	0	1	GESTION MOROSIDAD	0.00	Honorarios Estudio Juridico Gestion de Recupero de Morosidad UF	1	2	1	1396
27	3	1	0	11	ABONO MANTENIMIENTO AREAS COMUNES	0.00	Abono Mantenimiento Areas Comunes	1	1	1	1364
28	8	1	0	6	COMPRA DE MATERIALES DE MANTENIMIENTO	0.00	Compra de Materiales de Mantenimiento	1	1	1	1321
29	6	1	0	1	CORREO	0.00	Gastos de Correo	1	2	1	1375
30	9	1	0	1	ESCUELA DE TENIS	0.00	Escuela de Tenis	1	2	1	1345
31	11	1	0	1	COLABORACION POLICIA	0.00	Colaboracin Policial	1	2	1	1334
32	11	1	0	2	COLABORACION BOMBEROS	0.00	Colaboracin Bomberos 	1	2	1	1334
33	1	1	0	51	SINDICATO	0.00	Sindicato	1	1	1	1360
34	14	1	0	10	IMPUESTO MUNICIPAL	0.00	Impuesto Municipal	1	2	1	1382
41	6	1	0	25	CONFECCIN DE BOLETAS DE FATERYH Y SUTERH	0.00	Confeccin de Boletas FATERYH y SUTERH	1	1	1	1375
35	14	1	0	20	IMPUESTO DE RENTAS	0.00	Impuesto de Rentas	1	1	1	1383
42	7	1	0	2	CONF. Y ENVIO DE CARTA DOCUMENTO GESTION MOROSIDAD 	0.00	Conf. y Envio de Carta Documento Gestion Morosidad UF         a Reintegrar por las Unidades	1	2	1	1356
43	6	1	0	11	FOTOCOPIAS	0.00	Fotocopias	1	2	1	1332
44	8	1	0	7	LIMPIEZA	0.00	Limpieza de Guardia y House	1	2	1	1397
45	6	1	0	7	LIBRERIA	0.00	Gastos de Libreria	1	2	1	1329
48	8	1	0	8	XXXXX	0.00	xxxxx  sj	1	2	1	1328
36	2	1	0	250	INTERNET Y SERVICIO DE CABLE	0.00	Internet y Servicio de TV por Cable	1	1	1	1317
49	6	1	0	9	CAJAS NAVIDEAS	0.00	Cajas Navideas Para Personal	1	2	1	1361
37	3	1	0	15	HONORARIOS INTENDENCIA	0.00	Honorarios por Servicio de Intendencia	1	1	1	1325
50	8	1	0	9	CHEQUE NUMERO	0.00	Cheque N 	1	2	1	1321
51	3	1	0	12	RECOLECCION RECICLABLES	0.00	Abono Recoleccion de Residuos Reciblables	1	1	1	1369
52	12	1	0	1	SEGURO 	0.00	Seguro Integral 	1	2	1	1327
38	3	1	0	18	ABONO SERVICE ASCENSORES	0.00	Abono Service Ascensores	1	1	1	1325
39	6	1	0	20	IMPRESOS Y RECIBOS	0.00	Impresos y Recibos	1	1	1	1329
40	6	1	0	30	PROCESAMIENTO DE DATOS	0.00	Procesamiento de Datos	1	1	1	1375
46	7	1	0	3	INFORME DE DOMINIO	0.00	Pedido de Informe de Dominio UF    a Reintegrar por las Unidades	1	2	1	1356
47	6	1	0	2	DEBITOS TARJETAS	0.00	Gastos Debitos Visa / Master / Diners	1	2	1	1375
53	7	1	0	4	JUICIO	0.00	Gastos Inicio de Juicio UF     a Reintegrar por la Unidad	1	2	1	1396
54	3	1	0	13	MANT. ELECTRICO	0.00	Abono Mantenimiento Electrico	1	1	1	1364
55	6	1	0	3	MOTO	0.00	Envio de Documentacion  	1	2	1	1328
57	3	1	0	17	BIDONES DE AGUA	0.00	Abono de Dispensers y Bidones de Agua  	1	1	1	1323
56	14	1	0	21	AUTORIDAD DEL AGUA	0.00	Tasa de Insp.de Funcionamiento y Control de Calidad de Efluentes 	1	2	1	1382
58	3	1	0	16	LAUNDRY	0.00	Abono SIstema de Laundry y Consumo de Fichas	1	2	1	1323
59	3	1	0	19	SERVICIO DE INTENDENCIA	0.00	SERVICIO DE INTENDENCIA	1	1	1	1325
\.


ALTER TABLE subrub ENABLE TRIGGER ALL;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('subrub_srb_id_seq', 59, true);


--
-- Data for Name: subxcomp; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE subxcomp DISABLE TRIGGER ALL;

COPY subxcomp (subxc_idsub, subxc_comprob) FROM stdin;
\.


ALTER TABLE subxcomp ENABLE TRIGGER ALL;

--
-- Data for Name: sucursal; Type: TABLE DATA; Schema: public; Owner: frola
--

--
-- Data for Name: talon; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE talon DISABLE TRIGGER ALL;

COPY talon (tal_id, tal_idptov, tal_comprob, tal_nombre, tal_valor, tal_fecha, tal_estado, tal_vald, tal_valh, tal_fecvto, tal_codemp) FROM stdin;
19	0	\N	FACTURA A	1	2013-01-23	1	1	10000	2130-12-31	1
20	0	\N	FACTURA B	1	2013-01-23	1	1	10000	2130-12-31	1
60	0	\N	CONVENIO DE PAGO	1	2014-01-28	1	1	10000	2130-12-31	1
158	0	\N	TRANSFERENCIA ENTRE CUENTAS 1242	1	2015-01-14	1	1	10000	2130-12-31	1
59	0	\N	IDENTIFICACION DE COMPROBANTES BANCARIOS	10	2013-09-18	1	1	10000	2130-12-31	1
167	0	\N	DEPOSITO DE EFECTIVO	1	2015-01-14	1	1	10000	2130-12-31	1
154	0	\N	OTROS EGRESOS	1	2015-01-11	1	1	10000	2130-12-31	1
166	0	\N	DEPOSITO DE CHEQUES	1	2015-01-14	1	1	10000	2130-12-31	1
153	0	\N	OTROS INGRESOS	1	2015-01-11	1	1	10000	2130-12-31	1
17	0	\N	INGRESO DE CARGOS	1	2012-10-10	1	1	10000	2130-12-31	1
61	0	\N	LIQUIDACIONES	1	2014-02-14	1	1	10000	2130-12-31	1
12	0	\N	ASIENTOS DE DIARIOS	1	2011-05-22	1	1	1000000	2130-12-31	1
18	0	\N	DEPOSITOS SIN IDENTIFICAR	1	2012-10-22	1	1	10000	2130-12-31	1
6	0	\N	INGRESO DE GASTOS	1	2011-05-10	1	1	10000	2130-12-31	1
11	0	\N	RECIBO DE COBRANZA	1	2011-05-21	1	1	10000000	2130-12-31	1
\.


ALTER TABLE talon ENABLE TRIGGER ALL;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('talon_tal_id_seq', 413, true);


--
-- Data for Name: tipcta; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipcta DISABLE TRIGGER ALL;

COPY tipcta (tct_codigo, tct_nombre) FROM stdin;
1	BANCOS
2	BANCOS MONEDA EXTRANJERA
5	FONDOS FIJOS
10	AMORT.ACUM.EDIFICIOS
11	AMORT.ACUM.BS.DE USO
97	APORTES Y RETIROS ADMINISTRACION
\.


ALTER TABLE tipcta ENABLE TRIGGER ALL;

--
-- Data for Name: tipdocu; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipdocu DISABLE TRIGGER ALL;

COPY tipdocu (td_codigo, td_nombre) FROM stdin;
CUIT	CUIT
CUIL	CUIL
CI	Cedula de Identidad
LE	Libreta de Enrolamiento
LC	Libreta Civica
PT	Pasaporte
DNI	Documento Nacional de Identidad
\.


ALTER TABLE tipdocu ENABLE TRIGGER ALL;

--
-- Data for Name: tipemp; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipemp DISABLE TRIGGER ALL;

COPY tipemp (tem_codigo, tem_nombre) FROM stdin;
1	Estudio Contable
2	Empresa
3	Administracion
\.


ALTER TABLE tipemp ENABLE TRIGGER ALL;

--
-- Data for Name: tipempr; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipempr DISABLE TRIGGER ALL;

COPY tipempr (ter_codigo, ter_nombre) FROM stdin;
1	BARRIO PRIVADO
2	COUNTRIES
3	CLUB DE CAMPO
\.


ALTER TABLE tipempr ENABLE TRIGGER ALL;

--
-- Data for Name: tipentid; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipentid DISABLE TRIGGER ALL;

COPY tipentid (tet_codigo, tet_nombre) FROM stdin;
1	Clientes
2	Despachantes
3	Vendedores
4	Proveedores
5	Propietarios
\.


ALTER TABLE tipentid ENABLE TRIGGER ALL;

--
-- Name: tipgto_tg_id_seq; Type: SEQUENCE SET; Schema: public; Owner: frola
--

SELECT pg_catalog.setval('tipgto_tg_id_seq', 25, true);


--
-- Data for Name: tipnot; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipnot DISABLE TRIGGER ALL;

COPY tipnot (tnot_codigo, tnot_codemp, tnot_nombre) FROM stdin;
1	1	Liquidaciones
2	1	Reglamentos
3	1	Asambleas
4	1	Balances
5	1	Otras Notas
7	1	Imagenes
8	1	Contratos
\.


ALTER TABLE tipnot ENABLE TRIGGER ALL;

--
-- Data for Name: tiptel; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tiptel DISABLE TRIGGER ALL;

COPY tiptel (ttl_codigo, ttl_nombre) FROM stdin;
1	Comercial
2	Comercial Directo
3	Fax
4	Particular
6	Web
7	Celular
5	Mails
\.


ALTER TABLE tiptel ENABLE TRIGGER ALL;

--
-- Data for Name: tipuf; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE tipuf DISABLE TRIGGER ALL;

COPY tipuf (tuf_codigo, tuf_nombre) FROM stdin;
1	Casa
2	Lote
3	Departamento
4	Cochera
5	Baulera
6	En Construccion
7	Dormi
\.


ALTER TABLE tipuf ENABLE TRIGGER ALL;

--
-- Data for Name: total; Type: TABLE DATA; Schema: public; Owner: zona
--

ALTER TABLE total DISABLE TRIGGER ALL;

COPY total (sum) FROM stdin;
-1400.88
\.


ALTER TABLE total ENABLE TRIGGER ALL;

--
-- Data for Name: unimed; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE unimed DISABLE TRIGGER ALL;

COPY unimed (uni_codigo, uni_nombre, uni_coef, uni_simbolo) FROM stdin;
\.


ALTER TABLE unimed ENABLE TRIGGER ALL;

--
-- Data for Name: varamb; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE varamb DISABLE TRIGGER ALL;

COPY varamb (var_codigo, var_nombre, var_valor) FROM stdin;
IMP_SIN_IVA	Importe de alquiler no grabado	1500
MONH	Cdigo de la moneda homogenea	2
\.


ALTER TABLE varamb ENABLE TRIGGER ALL;

--
-- Data for Name: varambi; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE varambi DISABLE TRIGGER ALL;

COPY varambi (vari_codemp, vari_idptov, vari_codigo, vari_nombre, vari_valor, vari_tipo) FROM stdin;
1	0	TCTBANCO	Tipcta de Banco	1	1
1	0	TIPCTADXC	Tipcta de Provedores	98	1
1	0	TIPCTADXV	Tipcta de Deudores por Venta	99	1
1	0	MONEX	Cuenta Contable Moneda Extranjera	1005	1
1	0	CHEQUE	Cuenta Contable Valores	1015	1
1	0	BANCO	Cuenta Contable Bancos	1010	1
1	1	DOCUM	Cuenta Contable Documentos en Cartera	1210	1
1	0	CTAANTP	Cuenta Contable Anticipo de Provedores	1310	1
1	0	CTARDOE	Cuenta Contable Resultado del Ejercicio 	2815	1
1	0	DEUDXC	Cuenta Contable Proveedores	2001	1
1	0	CTARETIG	Cuenta Contable Ret Ganancias	2201	1
1	0	DETDOL	Detalla Dolares Bancos	NO	1
1	0	CTADESCTO	Cuenta Contable Descuentos y Recargos	4500	1
1	0	CAJA	Cuenta Contable Caja	1000	1
1	0	DEUDXV	Cuenta Contable Deudores	1201	1
1	0	ARETIG	RetenciÃ³n Impuestos a las Ganancias	SI	1
1	0	TASARIG	Tasa de RetenciÃ³n Impuesto a las Gcias	2	1
1	0	MNIRETIG	Minimo No Imponible Ret. Imp. Ganancias	5000	1
1	0	CTAFF	Cuenta Contable Fondo Fijo	1001	1
0	0	TCTBANCO	Tipcta de Banco	1	1
0	0	TIPCTADXC	Tipcta de Provedores	98	1
0	0	TIPCTADXV	Tipcta de Deudores por Venta	99	1
0	0	MONEX	Cuenta Contable Moneda Extranjera	1005	1
0	0	CHEQUE	Cuenta Contable Valores	1015	1
0	0	BANCO	Cuenta Contable Bancos	1010	1
0	0	CTAFF	Cuenta Contable Fondo Fijo	1002	1
0	1	DOCUM	Cuenta Contable Documentos en Cartera	1210	1
0	0	CTAANTP	Cuenta Contable Anticipo de Provedores	1310	1
0	0	CTARDOE	Cuenta Contable Resultado del Ejercicio 	2815	1
0	0	DEUDXC	Cuenta Contable Proveedores	2001	1
0	0	CTARETIG	Cuenta Contable Ret Ganancias	2201	1
0	0	DETDOL	Detalla Dolares Bancos	NO	1
0	0	CTADESCTO	Cuenta Contable Descuentos y Recargos	4500	1
0	0	CAJA	Cuenta Contable Caja	1000	1
0	0	DEUDXV	Cuenta Contable Deudores	1201	1
0	0	ARETIG	RetenciÃ³n Impuestos a las Ganancias	SI	1
0	0	TASARIG	Tasa de RetenciÃ³n Impuesto a las Gcias	2	1
0	0	MNIRETIG	Minimo No Imponible Ret. Imp. Ganancias	5000	1
1	0	MONLEGAL	CODIGO DE MONEDA DE CURSO LEGAL	1	2
1	0	1242	Cuenta de Aporte Administración	1242	2
1	0	1245	Cuenta de Descuentos Obtenidos	1245	2
1	0	CTADEPSI	Cuenta Contable Depositos sin Identifica	1020	1
1	0	CMPDI	Combte para Depositos Sin Identificar	DI	2
1	0	CMPID	Combte de Identificacion de Depositos	ID	2
1	0	CMPIG	Combte para Ingreso de Gastos	IG	2
1	0	PTVADM	Punto de Venta Administracion	-1	1
1	0	CMPRC	Comprobante de Recibos de Cobranzas	RC	2
1	0	FINEJ	Fin del ultimo ejercicio cerrado	31-12-2012	2
1	0	ULTPERC	Ultimo perodo cerrado IVA	01-02-2013	2
1	0	AJUSTE	Cuenta de Ajuste	4999	1
1	0	COMPCONV	Comprobante de Convenios de Pasgo	VN	2
1	0	CODCARCONV	CODIGO CARGO CONVENIO DE PAGO	36	2
1	0	CMPQL	Compbte Compliq	QL	2
1	0	CMPLQ	Compbte Liquidacion	LQ	2
1	0	CARGOINT	CONCEPTO DE INTERES RESARCITORIO	44	2
1	0	SINGI	Saldos iniciaes que no Generan Interes	47	2
1	0	SIGI	Saldos iniciaes que Generan Interes	46	2
0	0	TCTCHEQUE	Tipcta de Cheque	3	1
1	0	IDRUBCOB	RUBRO COBRANZAS	7	1
1	0	IDSRUBCOB	Subrubro Cobranzas	7	1
1	0	IDCARCOBR	Cargo Cobranzas	28	1
1	0	CARGOORDINARIAS	CARGO EXPENSAS ORDINARIAS	1	1
1	0	MASMENOSXPESOS	VARIABLE AMBIENTE REDONDEO	10	1
1	0	SRUBGB	Subrubro de Gastos Bancarios	8	2
1	0	TIPCTA1	Formulario Bancos	t_banco.php	2
1	0	TIPCTA2	Formulario Caja Chica	t_cc.php	2
1	0	TIPCTA3	Formulario Cheques	cheque.php	2
1	0	GASBAN	Cuenta Contable Gastos Bancarios	4450	2
1	0	CMPOI	Combte de Otros Ingresos	OI	2
1	0	CMPAD	Comprobante Asientos Diarios	AD	2
1	0	CMPTR	COMPROBANTE TRANSFERENCIA	TR	2
1	0	HONO	Honorarios Administracion	5100	2
1	0	IMPREC	Impresos y Recibos	5200	2
1	0	CONBO	Confeccion de Boletas 	5300	2
1	0	TIPCTA5	FONDOS FIJOS	t_cc.php	2
1	0	TIPCTA97	Aportes y Retiros	t_cc.php	2
1	0	REDONDEO	AJUSTE POR REDONDEO	54	1
1	0	IDUF	IDENTIFICADOR UF	55	1
1	0	INTPER	INTERESES DEVENGADOS	3701	1
1	0	DESCPP	DESCUENTO PRONTO PAGO	3001	1
1	0	CTARED	AJUSTE POR REDONDEO CTACBLE	3990	1
1	0	CARGOCESPED	Cargo Mantenimiento Cesped	7	1
1	0	CARGOENERGIA	Cargo Energia Electrica	19	1
1	0	CARGOFEVENTOS	Cargo Fondo Eventos	39	1
1	0	CARGOFAMILIAR	Cargo Grupo Famliar	61	1
1	0	RUBROORDINARIAS	Rubro de Expensas Ordinarias	1	1
1	0	EDADMENORMIN	Minima edad del menor	3	1
1	0	EDADMENORMAX	Maxima edad del menor	16	1
1	0	CARGOMAYOR	Cargo de cuota de mayores	72	1
1	0	CARGOMENOR	Cargo de cuota de menores	73	1
1	0	FONDORESERVA	Importe de porcentaje del FR	0.05	1
1	0	CARGORESERVA	Cargo de Fondo de Reserva	37	1
1	0	PORC3LOC	Porcentaje Expensa Locacion 4 a 36 meses	0.15	1
1	0	CARGOLOCACION	Cargo de Expensas de Locacion	74	1
1	0	PORC1LOC	Porcentaje Expensa Locacion 1 mes	0.15	1
1	0	PORC2LOC	Porcentaje Expensa Locacion 2 o 3 meses	0.15	1
\.


ALTER TABLE varambi ENABLE TRIGGER ALL;

--
-- Data for Name: zona; Type: TABLE DATA; Schema: public; Owner: frola
--

ALTER TABLE zona DISABLE TRIGGER ALL;

COPY zona (zon_codigo, zon_pais, zon_provin, zon_ciudad, zon_barrio, zon_nombre) FROM stdin;
1	1	1	1	1	UNICA
\.


ALTER TABLE zona ENABLE TRIGGER ALL;

--
-- PostgreSQL database dump complete
--

