--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: admin_preferences; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE admin_preferences (
    id integer NOT NULL,
    user_panel smallint NOT NULL,
    sidebar_form smallint DEFAULT 0 NOT NULL,
    messages_menu smallint DEFAULT 0 NOT NULL,
    notifications_menu smallint DEFAULT 0 NOT NULL,
    tasks_menu smallint DEFAULT 0 NOT NULL,
    user_menu smallint DEFAULT 1 NOT NULL,
    ctrl_sidebar smallint DEFAULT 0 NOT NULL,
    transition_page smallint DEFAULT 0 NOT NULL,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE admin_preferences OWNER TO zona;

--
-- Name: admin_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE admin_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE admin_preferences_id_seq OWNER TO zona;

--
-- Name: admin_preferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE admin_preferences_id_seq OWNED BY admin_preferences.id;


--
-- Name: arribo; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE arribo (
    a_id integer NOT NULL,
    a_fecreg timestamp without time zone DEFAULT now(),
    a_estado integer DEFAULT 1 NOT NULL,
    a_nombre text
);


ALTER TABLE arribo OWNER TO zona;

--
-- Name: arribo_a_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE arribo_a_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE arribo_a_id_seq OWNER TO zona;

--
-- Name: arribo_a_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE arribo_a_id_seq OWNED BY arribo.a_id;


--
-- Name: colocaciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE colocaciones (
    c_id integer NOT NULL,
    c_idcot integer,
    c_fecha date,
    c_importe text,
    c_observaciones text,
    c_file text,
    c_user integer,
    c_user_anul integer,
    c_fecreg timestamp without time zone DEFAULT now(),
    c_estado integer DEFAULT 1 NOT NULL,
    c_hora text,
    c_sms integer
);


ALTER TABLE colocaciones OWNER TO zona;

--
-- Name: colocaciones_c_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE colocaciones_c_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE colocaciones_c_id_seq OWNER TO zona;

--
-- Name: colocaciones_c_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE colocaciones_c_id_seq OWNED BY colocaciones.c_id;


--
-- Name: cotizaciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE cotizaciones (
    cot_id integer NOT NULL,
    cot_nro integer,
    cot_cliente character varying(200),
    cot_telefono character varying(80),
    cot_mail character varying(150),
    cot_fecha date,
    cot_observaciones text,
    cot_fecreg timestamp without time zone DEFAULT now(),
    cot_estado integer DEFAULT 1 NOT NULL,
    cot_domicilio character varying(300),
    cot_localidad character varying(80),
    cot_user integer,
    cot_user_anul integer,
    cot_hora text,
    cot_sms integer
);


ALTER TABLE cotizaciones OWNER TO zona;

--
-- Name: cotizaciones_cot_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE cotizaciones_cot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cotizaciones_cot_id_seq OWNER TO zona;

--
-- Name: cotizaciones_cot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE cotizaciones_cot_id_seq OWNED BY cotizaciones.cot_id;


--
-- Name: encuestas; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE encuestas (
    e_id integer NOT NULL,
    e_arribo integer,
    e_telefono integer,
    e_presupuestador integer,
    e_colocador integer,
    e_observaciones text,
    e_fecreg timestamp without time zone DEFAULT now(),
    e_estado integer DEFAULT 1 NOT NULL,
    e_idcol integer
);


ALTER TABLE encuestas OWNER TO zona;

--
-- Name: encuestas_e_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE encuestas_e_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE encuestas_e_id_seq OWNER TO zona;

--
-- Name: encuestas_e_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE encuestas_e_id_seq OWNED BY encuestas.e_id;


--
-- Name: groups; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE groups (
    id integer NOT NULL,
    name character varying(20) NOT NULL,
    description character varying(100) NOT NULL,
    bgcolor character varying(7) DEFAULT '#607D8B'::character varying NOT NULL,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE groups OWNER TO zona;

--
-- Name: groups_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE groups_id_seq OWNER TO zona;

--
-- Name: groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE groups_id_seq OWNED BY groups.id;


--
-- Name: login_attempts; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE login_attempts (
    id integer NOT NULL,
    ip_address character varying(15),
    login character varying(100) NOT NULL,
    "time" integer,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE login_attempts OWNER TO zona;

--
-- Name: login_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE login_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE login_attempts_id_seq OWNER TO zona;

--
-- Name: login_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE login_attempts_id_seq OWNED BY login_attempts.id;


--
-- Name: notificaciones; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE notificaciones (
    n_id integer NOT NULL,
    n_idint character varying(50),
    n_modo integer,
    n_para character varying(150),
    n_msg text,
    n_estadoapi text,
    n_respuesta text,
    n_frespuesta timestamp without time zone,
    n_fecreg timestamp without time zone DEFAULT now(),
    n_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE notificaciones OWNER TO zona;

--
-- Name: notificaciones_n_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE notificaciones_n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notificaciones_n_id_seq OWNER TO zona;

--
-- Name: notificaciones_n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE notificaciones_n_id_seq OWNED BY notificaciones.n_id;


--
-- Name: public_preferences; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE public_preferences (
    id integer NOT NULL,
    transition_page smallint DEFAULT 0 NOT NULL,
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE public_preferences OWNER TO zona;

--
-- Name: public_preferences_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE public_preferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public_preferences_id_seq OWNER TO zona;

--
-- Name: public_preferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE public_preferences_id_seq OWNED BY public_preferences.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    ip_address character varying(45),
    username character varying(100),
    password character varying(255) NOT NULL,
    salt character varying(255),
    email character varying(100) NOT NULL,
    activation_code character varying(40),
    forgotten_password_code character varying(40),
    forgotten_password_time integer,
    remember_code character varying(40),
    created_on integer NOT NULL,
    last_login integer,
    active integer,
    first_name character varying(50),
    last_name character varying(50),
    company character varying(100),
    phone character varying(20),
    CONSTRAINT check_active CHECK ((active >= 0)),
    CONSTRAINT check_id CHECK ((id >= 0))
);


ALTER TABLE users OWNER TO zona;

--
-- Name: users_groups; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE users_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL,
    CONSTRAINT users_groups_check_group_id CHECK ((group_id >= 0)),
    CONSTRAINT users_groups_check_id CHECK ((id >= 0)),
    CONSTRAINT users_groups_check_user_id CHECK ((user_id >= 0))
);


ALTER TABLE users_groups OWNER TO zona;

--
-- Name: users_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE users_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE users_groups_id_seq OWNER TO zona;

--
-- Name: users_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE users_groups_id_seq OWNED BY users_groups.id;


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE users_id_seq OWNER TO zona;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY admin_preferences ALTER COLUMN id SET DEFAULT nextval('admin_preferences_id_seq'::regclass);


--
-- Name: a_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY arribo ALTER COLUMN a_id SET DEFAULT nextval('arribo_a_id_seq'::regclass);


--
-- Name: c_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY colocaciones ALTER COLUMN c_id SET DEFAULT nextval('colocaciones_c_id_seq'::regclass);


--
-- Name: cot_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY cotizaciones ALTER COLUMN cot_id SET DEFAULT nextval('cotizaciones_cot_id_seq'::regclass);


--
-- Name: e_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY encuestas ALTER COLUMN e_id SET DEFAULT nextval('encuestas_e_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY groups ALTER COLUMN id SET DEFAULT nextval('groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY login_attempts ALTER COLUMN id SET DEFAULT nextval('login_attempts_id_seq'::regclass);


--
-- Name: n_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY notificaciones ALTER COLUMN n_id SET DEFAULT nextval('notificaciones_n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY public_preferences ALTER COLUMN id SET DEFAULT nextval('public_preferences_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY users_groups ALTER COLUMN id SET DEFAULT nextval('users_groups_id_seq'::regclass);


--
-- Name: admin_preferences_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY admin_preferences
    ADD CONSTRAINT admin_preferences_pkey PRIMARY KEY (id);


--
-- Name: arribo_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY arribo
    ADD CONSTRAINT arribo_pkey PRIMARY KEY (a_id);


--
-- Name: colocaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY colocaciones
    ADD CONSTRAINT colocaciones_pkey PRIMARY KEY (c_id);


--
-- Name: cotizaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY cotizaciones
    ADD CONSTRAINT cotizaciones_pkey PRIMARY KEY (cot_id);


--
-- Name: encuestas_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY encuestas
    ADD CONSTRAINT encuestas_pkey PRIMARY KEY (e_id);


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (id);


--
-- Name: login_attempts_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY login_attempts
    ADD CONSTRAINT login_attempts_pkey PRIMARY KEY (id);


--
-- Name: notificaciones_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY notificaciones
    ADD CONSTRAINT notificaciones_pkey PRIMARY KEY (n_id);


--
-- Name: public_preferences_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY public_preferences
    ADD CONSTRAINT public_preferences_pkey PRIMARY KEY (id);


--
-- Name: uc_users_groups; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY users_groups
    ADD CONSTRAINT uc_users_groups UNIQUE (user_id, group_id);


--
-- Name: users_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY users_groups
    ADD CONSTRAINT users_groups_pkey PRIMARY KEY (id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: admin_preferences; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE admin_preferences FROM PUBLIC;
REVOKE ALL ON TABLE admin_preferences FROM zona;
GRANT ALL ON TABLE admin_preferences TO zona;
GRANT ALL ON TABLE admin_preferences TO nobody;


--
-- Name: admin_preferences_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE admin_preferences_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE admin_preferences_id_seq FROM zona;
GRANT ALL ON SEQUENCE admin_preferences_id_seq TO zona;
GRANT ALL ON SEQUENCE admin_preferences_id_seq TO nobody;


--
-- Name: arribo; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE arribo FROM PUBLIC;
REVOKE ALL ON TABLE arribo FROM zona;
GRANT ALL ON TABLE arribo TO zona;
GRANT ALL ON TABLE arribo TO nobody;


--
-- Name: arribo_a_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE arribo_a_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE arribo_a_id_seq FROM zona;
GRANT ALL ON SEQUENCE arribo_a_id_seq TO zona;
GRANT ALL ON SEQUENCE arribo_a_id_seq TO nobody;


--
-- Name: colocaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE colocaciones FROM PUBLIC;
REVOKE ALL ON TABLE colocaciones FROM zona;
GRANT ALL ON TABLE colocaciones TO zona;
GRANT ALL ON TABLE colocaciones TO nobody;


--
-- Name: colocaciones_c_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE colocaciones_c_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE colocaciones_c_id_seq FROM zona;
GRANT ALL ON SEQUENCE colocaciones_c_id_seq TO zona;
GRANT ALL ON SEQUENCE colocaciones_c_id_seq TO nobody;


--
-- Name: cotizaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE cotizaciones FROM PUBLIC;
REVOKE ALL ON TABLE cotizaciones FROM zona;
GRANT ALL ON TABLE cotizaciones TO zona;
GRANT ALL ON TABLE cotizaciones TO nobody;


--
-- Name: cotizaciones_cot_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE cotizaciones_cot_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cotizaciones_cot_id_seq FROM zona;
GRANT ALL ON SEQUENCE cotizaciones_cot_id_seq TO zona;
GRANT ALL ON SEQUENCE cotizaciones_cot_id_seq TO nobody;


--
-- Name: encuestas; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE encuestas FROM PUBLIC;
REVOKE ALL ON TABLE encuestas FROM zona;
GRANT ALL ON TABLE encuestas TO zona;
GRANT ALL ON TABLE encuestas TO nobody;


--
-- Name: encuestas_e_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE encuestas_e_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE encuestas_e_id_seq FROM zona;
GRANT ALL ON SEQUENCE encuestas_e_id_seq TO zona;
GRANT ALL ON SEQUENCE encuestas_e_id_seq TO nobody;


--
-- Name: groups; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE groups FROM PUBLIC;
REVOKE ALL ON TABLE groups FROM zona;
GRANT ALL ON TABLE groups TO zona;
GRANT ALL ON TABLE groups TO nobody;


--
-- Name: groups_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE groups_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE groups_id_seq FROM zona;
GRANT ALL ON SEQUENCE groups_id_seq TO zona;
GRANT ALL ON SEQUENCE groups_id_seq TO nobody;


--
-- Name: login_attempts; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE login_attempts FROM PUBLIC;
REVOKE ALL ON TABLE login_attempts FROM zona;
GRANT ALL ON TABLE login_attempts TO zona;
GRANT ALL ON TABLE login_attempts TO nobody;


--
-- Name: login_attempts_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE login_attempts_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE login_attempts_id_seq FROM zona;
GRANT ALL ON SEQUENCE login_attempts_id_seq TO zona;
GRANT ALL ON SEQUENCE login_attempts_id_seq TO nobody;


--
-- Name: notificaciones; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE notificaciones FROM PUBLIC;
REVOKE ALL ON TABLE notificaciones FROM zona;
GRANT ALL ON TABLE notificaciones TO zona;
GRANT ALL ON TABLE notificaciones TO nobody;


--
-- Name: notificaciones_n_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE notificaciones_n_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE notificaciones_n_id_seq FROM zona;
GRANT ALL ON SEQUENCE notificaciones_n_id_seq TO zona;
GRANT ALL ON SEQUENCE notificaciones_n_id_seq TO nobody;


--
-- Name: public_preferences; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE public_preferences FROM PUBLIC;
REVOKE ALL ON TABLE public_preferences FROM zona;
GRANT ALL ON TABLE public_preferences TO zona;
GRANT ALL ON TABLE public_preferences TO nobody;


--
-- Name: public_preferences_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE public_preferences_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE public_preferences_id_seq FROM zona;
GRANT ALL ON SEQUENCE public_preferences_id_seq TO zona;
GRANT ALL ON SEQUENCE public_preferences_id_seq TO nobody;


--
-- Name: users; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE users FROM PUBLIC;
REVOKE ALL ON TABLE users FROM zona;
GRANT ALL ON TABLE users TO zona;
GRANT ALL ON TABLE users TO nobody;


--
-- Name: users_groups; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE users_groups FROM PUBLIC;
REVOKE ALL ON TABLE users_groups FROM zona;
GRANT ALL ON TABLE users_groups TO zona;
GRANT ALL ON TABLE users_groups TO nobody;


--
-- Name: users_groups_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE users_groups_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_groups_id_seq FROM zona;
GRANT ALL ON SEQUENCE users_groups_id_seq TO zona;
GRANT ALL ON SEQUENCE users_groups_id_seq TO nobody;


--
-- Name: users_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE users_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_id_seq FROM zona;
GRANT ALL ON SEQUENCE users_id_seq TO zona;
GRANT ALL ON SEQUENCE users_id_seq TO nobody;


--
-- PostgreSQL database dump complete
--

