--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: ashdeastc(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ashdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idastoh from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ashdeastc(integer) OWNER TO aaii;

--
-- Name: calc_intliq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION calc_intliq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	idultcie	 integer;
	idcopant	 integer;
	impgia		 numeric(15,2);
	cobranz		 numeric(15,2);
	totcobr		 numeric(15,2);
	totcobr2	 numeric(15,2);
	import		 numeric(15,2);
	tasaint		 numeric(15,5);
	interes		 numeric(15,2);
	intercar	 numeric(15,2);

	rubro		 integer;
	cargo		 integer;
	srubro		 integer;
	deudxv		 integer;
	leyenda		 character varying(240);

	importe		 numeric(15,2);
	importedos	 numeric(15,2);
	deudant		 numeric(15,2);
	deudagint	 numeric(15,2);
	porcgint	 numeric(15,2);
	retval 		 integer;
	registro	 record;
	regi		 record;
	regis		 record;
BEGIN

retval:=1;
importe:=0;

select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
    into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

select l_id into idultcie from liquidacion where l_id!=idliq and l_estado=2 and l_centro=centro order by l_feccie desc limit 1;

select intercentro(centro) into tasaint;
if tasaint is null then
    tasaint:=0;
end if;

select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
if not found then
    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
    if not found then
	select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
    end if;
end if;

select car_rubcar, car_srubcar, car_leyen into rubro, srubro, leyenda from cargos where car_id=cargo;
select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into deudxv;

    if idultcie is not null then
	for regis in select distinct(clq_idcopr) as copr from compliq where numeric_gt(deudacopropid(clq_idcopr,clq_codemp,clq_idptov),0) and clq_id not in (select distinct cxc_idclq from cobrxclq where cxc_estado=2) and clq_idptov=idptov and clq_centro=centro and intdecarg(clq_cargo)=1 and estadocop(clq_idcopr)=1 and clq_estado=2 order by clq_idcopr 
	    loop
	    idcopant:=regis.copr;
	    totcobr:=0;
	    impgia:=0;
	    cobranz:=0;
	    interes:=0;
	    for regi in select * from compliq where int4ne(clq_idliq,idliq) and intdecarg(clq_cargo)=1 and clq_id not in (select cxc_idclq from cobrxclq where cxc_estado=2 and cxc_idcopr=idcopant) and clq_idcopr=idcopant and clq_estado=2 and clq_importe>0 
		loop
		    impgia:=impgia + regi.clq_importe;
		    if impgia is null then
			impgia:=0;
		    end if;

		    select sum(cxc_importe) into cobranz from cobrxclq where cxc_idclq=regi.clq_id;
		    if cobranz is null then
			cobranz:=0;
		    end if;
		    totcobr:=totcobr+cobranz;
		end loop;

	    importedos:=0;
	    cobranz:=0;
	    totcobr2:=0;

	    import:= (impgia - totcobr) + (importedos - totcobr2);

	    if numeric_gt(import,0) then
		interes:=import * tasaint / 100;
	    end if;

	    if numeric_gt(interes,0) then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_idcopr,clq_idliq,clq_srubcar)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubro,cargo,leyenda,1,interes,import,idcopant,idliq,srubro);
		interes:=0;
	    end if;
	end loop;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.calc_intliq(integer) OWNER TO aaii;

--
-- Name: calculo_cuota(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION calculo_cuota(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	feccie		 date;
	menores		 integer;
	mayores		 integer;
	cantTot		 numeric(15,2);
	duracion	 integer;
	cuotaMayor	 numeric(15,2);
	cuotaMenor	 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cantidad	 integer;
	contrato	 integer;
	leyMayores	 character varying(255);
	leyMenores	 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_feccie,l_centro 
	into codemp,idptov,feccie,centro from liquidacion where l_id=idliq; 

    mayores:=0;
    menores:=0;

    for regis in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
	loop
	    select ct_id into contrato from contratos where ct_idcopr=regis.cop_id and ct_estado=1;
	    if not found then
		cantidad:=0;
		select count(*) into cantidad from grupof_d where gf_idcopr=regis.cop_id and gf_mayor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    mayores:=mayores + cantidad;
		end if;
		cantidad:=0;
		select count(*) into cantidad from grupof_d where gf_idcopr=regis.cop_id and gf_menor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    menores:=menores + cantidad;
		end if;
	    else
		cantidad:=0;
		select count(*) into cantidad from grupof_inq where gf_idcopr=regis.cop_id and gf_mayor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    mayores:=mayores + cantidad;
		end if;
		cantidad:=0;
		select count(*) into cantidad from grupof_inq where gf_idcopr=regis.cop_id and gf_menor=1 and gf_idptov=idptov and gf_estado=1;
		if (cantidad is not null) then
		    menores:=menores + cantidad;
		end if;
	    end if;
	end loop;

    cantTot:=mayores+(menores::numeric/2::numeric)::numeric(15,2);

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select car_leyen into leyMayores from cargos where car_id=cargoMayores;
    select car_leyen into leyMenores from cargos where car_id=cargoMenores;

    for reg in select * from compliquid where cl_idliq=idliq and cl_tipo=4 
	loop
	    cuotaMayor:=reg.cl_importe::numeric/cantTot::numeric;
	    cuotaMenor:=cuotaMayor::numeric/2::numeric;

--	    cuotaMayor:=round(cuotaMayor);
--	    cuotaMenor:=round(cuotaMenor);

	    insert into compliquid (cl_idliq,cl_rubcar,cl_cargo,cl_porc,cl_leyen,cl_importe,cl_tipo,cl_tipuf) values 
		(reg.cl_idliq,reg.cl_rubcar,cargoMayores,reg.cl_porc,leyMayores,cuotaMayor,5,mayores);
	    insert into compliquid (cl_idliq,cl_rubcar,cl_cargo,cl_porc,cl_leyen,cl_importe,cl_tipo,cl_tipuf) values 
		(reg.cl_idliq,reg.cl_rubcar,cargoMenores,reg.cl_porc,leyMenores,cuotaMenor,5,menores);
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.calculo_cuota(integer) OWNER TO aaii;

--
-- Name: cargo_auxint(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION cargo_auxint(integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	rubcar		 integer;
	centro		 integer;
	perim		 integer;
	peria		 integer;
	mes		 integer;
	anio		 integer;
	inter		 integer;
	genint1		 numeric(15,2);
	genint2		 numeric(15,2);
	genint3		 numeric(15,2);
	totgi		 numeric(15,2);
	suma		 numeric(15,2);
	totngi		 numeric(15,2);
	totint		 numeric(15,2);
	cobgi		 numeric(15,2);
	cobngi		 numeric(15,2);
	cobint		 numeric(15,2);
	idliqant	 integer;
	retval 		 character;
	regist		 record;
	regi		 record;
	reg		 record;
    BEGIN

    select l_centro,l_perim,l_peria,l_mes,l_anio,l_codemp,l_idptov into centro,perim,peria,mes,anio,codemp,idptov from liquidacion where l_id=idliq; 

    retval:='f';
    for regist in select lq_idcopr,sum(lq_importe) as importe from liqui where lq_idliq=idliq group by 1 
	loop
	    genint1:=0;
	    genint2:=0;
	    genint3:=0;
	    totgi:=0;
	    totngi:=0;
	    totint:=0;
	    cobgi:=0;
	    cobngi:=0;
	    cobint:=0;

	    select sum(lq_importe) into genint1 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=1 and lq_importe>0;
	    select sum(lq_importe) into genint2 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=2 and lq_importe>0;
	    select sum(lq_importe) into genint3 from liqui where lq_idliq=idliq and lq_idcopr=regist.lq_idcopr and intdecarg(lq_cargo)=3 and lq_importe>0;

	    if(genint1 is null) then genint1:=0; end if;
	    if(genint2 is null) then genint2:=0; end if;
	    if(genint3 is null) then genint3:=0; end if;


	    for regi in select a.clq_id as idclq,intdecarg(clq_cargo) as interes,clq_importe,clq_impngi,clq_interes 
			    from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2))
				and clq_idcopr=regist.lq_idcopr and (numeric_gt(clq_importe,0) or numeric_gt(clq_impngi,0) or numeric_gt(clq_interes,0)) 
				and int4ne(clq_idliq,idliq) order by 1
		loop
		    select sum(cxc_importe) into suma from cobrxclq where cxc_idclq=regi.idclq;
		    if (int4eq(regi.interes,1)) then
			totgi:=totgi+regi.clq_importe;
			if suma is not null then
			    cobgi:=cobgi+suma;
			end if;
		    else
			if (int4eq(regi.interes,2)) then
			    totngi:=totngi+regi.clq_impngi;
			    if suma is not null then
				cobngi:=cobngi+suma;
			    end if;
			else
			    if (int4eq(regi.interes,3)) then
				totint:=totint+regi.clq_interes;
				if suma is not null then
				    cobint:=cobint+suma;
				end if;
			    end if;
			end if;
		    end if;
		end loop;

	    for regi in select a.clq_id as idclq,intdecarg(clq_cargo) as interes,clq_importe,clq_impngi,clq_interes 
			    from compliq a where clq_idcopr=regist.lq_idcopr 
				and (numeric_gt(clq_importe,0) or numeric_gt(clq_impngi,0) or numeric_gt(clq_interes,0)) 
				and int4eq(clq_idliq,idliq) order by 1
		loop
		    select sum(cxc_importe) into suma from cobrxclq where cxc_idclq=regi.idclq;
		    if (int4eq(regi.interes,1)) then
			if suma is not null then
			    cobgi:=cobgi+suma;
			end if;
		    else
			if (int4eq(regi.interes,2)) then
			    if suma is not null then
				cobngi:=cobngi+suma;
			    end if;
			else
			    if (int4eq(regi.interes,3)) then
				if suma is not null then
				    cobint:=cobint+suma;
				end if;
			    end if;
			end if;
		    end if;
		end loop;

	    for reg in select clq_id,clq_idastoc from compliq where clq_idcopr=regist.lq_idcopr and clq_anio=anio and clq_mes=mes and clq_rubcar=7 and clq_estado=1
		loop
		    update compliq set clq_estado=2 where clq_id=reg.clq_id and clq_estado=1;
		end loop;

	    if(cobgi is null) then cobgi:=0; end if;
	    if(cobngi is null) then cobngi:=0; end if;
	    if(cobint is null) then cobint:=0; end if;

	    if(numeric_le(cobgi,0::numeric)) then cobgi:=cobgi*-1; end if;
	    if(numeric_le(cobngi,0::numeric)) then cobngi:=cobngi*-1; end if;
	    if(numeric_le(cobint,0::numeric)) then cobint:=cobint*-1; end if;

	    totgi:=totgi + genint1 - cobgi;
	    totngi:=totngi + genint2 - cobngi;
	    totint:=totint + genint3 - cobint;

	    insert into auxint (ai_idliq,ai_idcopr,ai_impgi,ai_impngi,ai_intacu) values (idliq,regist.lq_idcopr,totgi,totngi,totint);
	    retval:='t';
	end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.cargo_auxint(integer) OWNER TO aaii;

--
-- Name: cargo_liqui_lq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION cargo_liqui_lq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	retval 		 integer;
	cargo 		 integer;
	deuda 		 numeric;
	regi		 record;
	r1		 record;
    BEGIN

    retval:=0;

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

	select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	    if not found then
		select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
	    end if;
	end if;

    for r1 in select distinct clq_idcopr from compliq where clq_idliq=idliq and clq_estado=1 and clq_cargo=cargo 
	loop
	    select deudacopropid(r1.clq_idcopr,codemp,idptov) into deuda;
	    if (numeric_lt(deuda,0)) then
		delete from compliq where clq_idcopr=r1.clq_idcopr and clq_idliq=idliq and clq_comprob=comprob and clq_numero=numero and clq_cargo=cargo;
	    end if;
	end loop;

    for regi in select clq_idcopr,clq_cargo,clq_rubcar,clq_leyen,sum(clq_importe+clq_impngi+clq_interes) as impgi, sum(clq_canti) as canti from compliq where clq_idliq=idliq and clq_estado=1 and clq_rubcar!=7 group by 1,2,3,4
	loop
	    insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
		    values (idliq,regi.clq_idcopr,regi.clq_rubcar,regi.clq_cargo,regi.canti,regi.impgi / regi.canti,regi.impgi,regi.clq_leyen,1);
	end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.cargo_liqui_lq(integer) OWNER TO aaii;

--
-- Name: cargocint(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION cargocint(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select car_genint from cargos where car_id= $1 ;$_$;


ALTER FUNCTION public.cargocint(integer) OWNER TO aaii;

--
-- Name: cargodclq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION cargodclq(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select clq_cargo from compliq where clq_id= $1 ;$_$;


ALTER FUNCTION public.cargodclq(integer) OWNER TO aaii;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codcble(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_codigo::int2 from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO aaii;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO aaii;

--
-- Name: codcompastc(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codcompastc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.codcompastc(integer) OWNER TO aaii;

--
-- Name: codcop(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codcop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_unifun from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.codcop(integer) OWNER TO aaii;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO aaii;

--
-- Name: codprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_codigo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.codprov(integer) OWNER TO aaii;

--
-- Name: codptv(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION codptv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_codigo from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.codptv(integer) OWNER TO aaii;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO aaii;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO aaii;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO aaii;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO aaii;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO aaii;

--
-- Name: confondo(integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION confondo(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	cargo		 ALIAS FOR $2; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;

	retval		 numeric(15,2);
BEGIN

select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
    into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select sum(cxc_importe) into retval from cobrxclq where 
				cxc_mes=mes and cxc_anio=anio and 
				cxc_idcopr in (select cop_id from coprop where cop_idptov=idptov and cop_estado in (1,2)) and 
				cargodclq(cxc_idclq)=cargo;
    if not found then
	retval:=0;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.confondo(integer, integer) OWNER TO aaii;

--
-- Name: confondo(integer, integer, date, date); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION confondo(integer, integer, date, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idptov		 ALIAS FOR $1; 
	cargo		 ALIAS FOR $2; 
	fechad		 ALIAS FOR $3; 
	fechah		 ALIAS FOR $4; 

	retval		 numeric(15,2);
BEGIN

    select sum(cxc_importe) into retval from cobrxclq where 
				date_ge(cxc_fecha,fechad) and 
				date_le(cxc_fecha,fechah) and 
				cxc_idcopr in (select cop_id from coprop where cop_idptov=idptov and cop_estado in (1,2)) and 
				cargodclq(cxc_idclq)=cargo;
    if not found then
	retval:=0;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.confondo(integer, integer, date, date) OWNER TO aaii;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO aaii;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO aaii;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO aaii;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO aaii;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO aaii;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO aaii;

--
-- Name: desccop(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION desccop(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cop_unifun||'  -  '||cop_nombre from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.desccop(integer) OWNER TO aaii;

--
-- Name: descctes(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descctes(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cte_codigo||' - '||cte_nombre from ctes where cte_id= $1;$_$;


ALTER FUNCTION public.descctes(integer) OWNER TO aaii;

--
-- Name: descemp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_codigo||'  -  '||emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.descemp(integer) OWNER TO aaii;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: elm
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO elm;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO aaii;

--
-- Name: descfc(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descfc(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cpra_lecomp ||' - '|| lpad(cpra_sucomp::text,4,'0'::text) ||' - '|| lpad(cpra_nucomp::text,8,'0'::text) from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.descfc(integer) OWNER TO aaii;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO aaii;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO aaii;

--
-- Name: deudacoprop(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION deudacoprop(integer, integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_estado=2; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacoprop(integer, integer, integer, integer, integer) OWNER TO aaii;

--
-- Name: deudacopropafecha(integer, integer, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION deudacopropafecha(integer, integer, integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	fecha		 ALIAS FOR $6;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_fecval<=fecha and astc_estado=2; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropafecha(integer, integer, integer, integer, integer, date) OWNER TO aaii;

--
-- Name: deudacopropid(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION deudacopropid(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_ctacte=coprop and astc_estado=2 and astc_tipcta=tipctacbl(cuentadxv) and astc_ctacble=cuentadxv; 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropid(integer, integer, integer) OWNER TO aaii;

--
-- Name: deudacopropm1(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION deudacopropm1(integer, integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	coprop		 ALIAS FOR $1;
	codemp		 ALIAS FOR $2;
	idptov		 ALIAS FOR $3;
	division	 ALIAS FOR $4;
	centro		 ALIAS FOR $5;
	total		 numeric(15,2);
	cuentadxv	 integer;
BEGIN

select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;
if cuentadxv is null then
    select idcbl(codemp,idptov,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;
if cuentadxv is null then
    select idcbl(codemp,0,valvaramb(codemp,0,'DEUDXV')::integer) into cuentadxv;
end if;

select sum(astc_importe) into total from astoctas where astc_codemp=codemp and astc_idptov=idptov and astc_division=division and astc_centro=centro and astc_ctacte=coprop and astc_tipcta=tipctacbl(cuentadxv) and astc_estado in (2,-1); 

RETURN total;
END;$_$;


ALTER FUNCTION public.deudacopropm1(integer, integer, integer, integer, integer) OWNER TO aaii;

--
-- Name: dfecreg(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION dfecreg(integer) RETURNS date
    LANGUAGE sql
    AS $_$select date(ash_fecreg) from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.dfecreg(integer) OWNER TO aaii;

--
-- Name: elgrupo(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION elgrupo(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	tipcta		ALIAS FOR $1; 
	codigo		ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN

    retval:=1;
    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXV')::int4) then
	select cop_grupo into retval from coprop where int4eq(codigo,cop_id);
	if found then
	    if int4eq(modo,1) then
		update coprop set cop_grupo=cop_grupo+1 where int4eq(codigo,cop_id);
	    end if;
	end if;
    end if;

    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXC')::int4) then
	select prov_grupo into retval from prove where int4eq(codigo,prov_id);
	if found then
	    if int4eq(modo,1) then
		update prove set prov_grupo=prov_grupo+1 where int4eq(codigo,prov_id);
	    end if;
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elgrupo(integer, integer, integer) OWNER TO aaii;

--
-- Name: emp_ptv(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION emp_ptv(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Empresa: '||lpad(ptv_codemp::text,4,'0')||'  Emprendimiento '||lpad(ptv_codigo::text,4,'0') from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.emp_ptv(integer) OWNER TO aaii;

--
-- Name: estadocop(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION estadocop(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_estado from coprop where cop_id= $1 ;$_$;


ALTER FUNCTION public.estadocop(integer) OWNER TO aaii;

--
-- Name: estadoptv(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION estadoptv(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ptv_estado from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.estadoptv(integer) OWNER TO aaii;

--
-- Name: exp_loc(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION exp_loc(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	suma		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cargoExp	 integer;
	cargoLoc	 integer;
	porcDuracion	 numeric(15,2);
	porc1		 numeric(15,2);
	porc2		 numeric(15,2);
	porc3		 numeric(15,2);
	rubcar		 integer;
	srubcar		 integer;
	leyen		 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select valvaramb(codemp,idptov,'CARGOORDINARIAS') into cargoExp;
    select valvaramb(codemp,idptov,'CARGOLOCACION') into cargoLoc;
    select car_srubcar into srubcar from cargos where car_id=cargoLoc;
    select car_rubcar into rubcar from cargos where car_id=cargoLoc;
    select car_leyen into leyen from cargos where car_id=cargoLoc;

    select valvaramb(codemp,idptov,'PORC1LOC')::numeric(15,2) into porc1;
    select valvaramb(codemp,idptov,'PORC2LOC')::numeric(15,2) into porc2;
    select valvaramb(codemp,idptov,'PORC3LOC')::numeric(15,2) into porc3;

    for reg in select * from contratos where ct_idptov=idptov and ct_estado=1 
	loop
	    suma:=0;
	    select sum(clq_importe) into suma from compliq where clq_cargo in (cargoMayores,cargoMenores,cargoExp) and clq_idliq=idliq and clq_idcopr=reg.ct_idcopr;
	    --logica duracion establece porcDuracion
/*
	    if(int4le(reg.ct_duracion,1)) then
		porcDuracion:=porc1;
	    else
		if(int4eq(reg.ct_duracion,2) or int4eq(reg.ct_duracion,3)) then
		    porcDuracion:=porc2;
		else
		    if(int4ge(reg.ct_duracion,4) and int4le(reg.ct_duracion,36)) then
			porcDuracion:=porc3;
		    else
			porcDuracion:=0;
		    end if;
		end if;
	    end if;
*/

	    if(int4le(reg.ct_duracion,36)) then
		if(int4le(reg.ct_modo,1)) then
		    porcDuracion:=porc1;
		else
		    porcDuracion:=(reg.ct_modo::numeric(15,2)/100::numeric(15,2))::numeric(15,2);
		end if;
	    else
		porcDuracion:=0;
	    end if;

	    impaux:=suma*porcDuracion;
--	    importe:=round(impaux);
	    importe:=impaux;
	    if(numeric_gt(importe,0))then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubcar,srubcar,cargoLoc,leyen,1,importe,importe,reg.ct_idcopr,idliq);
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.exp_loc(integer) OWNER TO aaii;

--
-- Name: f_ad_cobrxclq(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ad_cobrxclq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cuantos		int4;
BEGIN
    select count(*) into cuantos from cobrxclq where int4eq(cxc_idclq,OLD.cxc_idclq) and int4eq(cxc_estado,2) and int4ne(cxc_id,OLD.cxc_id);
    if found then
	update cobrxclq set cxc_estado=1 where int4eq(cxc_idclq,OLD.cxc_idclq) and int4ne(cxc_id,OLD.cxc_id);
    end if;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_ad_cobrxclq() OWNER TO aaii;

--
-- Name: f_ad_coprop(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ad_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	delete from ctes where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_coprop() OWNER TO aaii;

--
-- Name: f_ad_gastos(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ad_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4eq(cuantos,1) THEN 
	    delete from liqegr where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_gasto=OLD.gto_id;
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_gastos() OWNER TO aaii;

--
-- Name: f_ad_prove(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ad_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	delete from ctes where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_prove() OWNER TO aaii;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcble(NEW.astc_codemp,NEW.astc_idptov,'BANCO') into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;
    if(int4eq(NEW.astc_ctacble,ctabco))  THEN
	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;
	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO aaii;

--
-- Name: f_ai_astoh(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    comproba		character varying;
    proxnum		integer;
BEGIN
    if (NEW.ash_numptv is null) then
	select comp_codigo into comproba from comprob where comp_id=NEW.ash_comprob;
	select proxnumptv(NEW.ash_codemp,NEW.ash_idptov,comproba) into proxnum;
	update astoh set ash_numptv=proxnum where ash_id=NEW.ash_id;
    END IF;
    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_astoh() OWNER TO aaii;

--
-- Name: f_ai_convenios(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_convenios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	centro		integer;
	newunif		integer;
	existe		integer;
	idastoh		integer;
	cuentadxv	integer;
	rubro		integer;
	cargo		integer;
    BEGIN

	select cop_unifun,cop_centro into unifun,centro from coprop where cop_id=NEW.con_idcopr;
	newunif:=unifun + 90000;

	select cop_id into existe from coprop where cop_centro=centro and cop_unifun=newunif;
	if not found then
	    insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
		select cop_codemp,cop_idptov,newunif,cop_nombre,cop_codaso,0,0,0,0,0,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,1,cop_mail,cop_inter,cop_recib,cop_centro,cop_division from coprop where cop_id=NEW.con_idcopr;
	  else
	    update coprop set cop_estado=1 where cop_id=existe;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	    values (NEW.con_codemp,NEW.con_idptov,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_comprob,NEW.con_numero,'Convenio de Pago',NEW.con_fechai,NEW.con_fechai,'Convenio de Pago',0,-1);

	select ash_id into idastoh from astoh where ash_codemp=NEW.con_codemp and ash_idptov=NEW.con_idptov and ash_comprob=NEW.con_comprob and ash_numero=NEW.con_numero;

	select idcbl(NEW.con_codemp,NEW.con_idptov,valvaramb(NEW.con_codemp,NEW.con_idptov,'DEUDXV')::integer)  into cuentadxv;


	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),NEW.con_idcopr,idastoh,cuentadxv,NEW.con_monto*-1,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);

	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),existe,idastoh,cuentadxv,NEW.con_monto,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);


	select valvaramb(NEW.con_codemp,NEW.con_idptov,'CODCARCONV') into cargo;

	select car_rubcar into rubro from cargos where car_id=cargo;

	insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr)
	    values (NEW.con_codemp,NEW.con_idptov,NEW.con_centro,NEW.con_division,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_fechai,NEW.con_fechai,NEW.con_comprob,NEW.con_numero,NEW.con_operador,rubro,cargo,NEW.con_leyen,1,0,NEW.con_monto,NEW.con_monto,NEW.con_idcopr);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_convenios() OWNER TO aaii;

--
-- Name: f_ai_coprop(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    newunif		int4;
    tipcta		int4;
    BEGIN

    select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
    insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla,cte_centro,cte_division) values (NEW.cop_codemp,NEW.cop_idptov,tipcta,NEW.cop_unifun,NEW.cop_nombre,0,NEW.cop_id,NEW.cop_centro,NEW.cop_division);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_coprop() OWNER TO aaii;

--
-- Name: f_ai_empresa(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	regis		record;
    BEGIN

    for regis in select * from varambi where vari_codemp=1 and vari_idptov=0 
	loop
	    insert into varambi values (NEW.emp_codigo,0,regis.vari_codigo,regis.vari_nombre,regis.vari_valor,regis.vari_tipo);
	end loop;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_empresa() OWNER TO aaii;

--
-- Name: f_ai_gastos(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    idliqegr		integer;
    BEGIN
--	insert into liqegr 
--	    (eg_idastoh,eg_codemp,eg_idptov,eg_centro,eg_rubro,eg_subrub,eg_hayfac,eg_fecreg,eg_prove,eg_nprove,eg_cuitprov,eg_factur,eg_anio,eg_mes,eg_estado,eg_impag,eg_importe,eg_operador,eg_leyen)
--	    values 
--	    (NEW.gto_idastoh,NEW.gto_codemp,NEW.gto_idptov,NEW.gto_centro,NEW.gto_rubro,NEW.gto_subrub,NEW.gto_hayfac,NEW.gto_fecreg,NEW.gto_prove,NEW.gto_nprove,NEW.gto_cuitprov,NEW.gto_factur,NEW.gto_anio,NEW.gto_mes,NEW.gto_estado,NEW.gto_impag,NEW.gto_importe,NEW.gto_operador,NEW.gto_leyen);
--	select max(eg_id) into idliqegr from liqegr;
--	insert into gtoxliqe (gxl_liqegr,gxl_gasto,gxl_operador,eg_leyen) values (idliqegr, NEW.gto_id, NEW.gto_operador, NEW.gto_leyen);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_gastos() OWNER TO aaii;

--
-- Name: f_ai_ordencompra(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    anio	 integer;
    numint	 integer;
BEGIN
    select date_part('year',NEW.oc_fecha)::integer into anio;
    select max(oc_numint) into numint from ordencompra where oc_centro=NEW.oc_centro;
    if (not found or numint is null) then
	numint:=0;
    end if;

    update ordencompra set oc_anio=anio,oc_numint=numint+1 where oc_id=NEW.oc_id;
    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_ordencompra() OWNER TO aaii;

--
-- Name: f_ai_prove(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla,cte_centro,cte_division) values (NEW.prov_codemp,NEW.prov_idptov,tipcta,NEW.prov_codigo,NEW.prov_nombre,0,NEW.prov_id,0,0);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_prove() OWNER TO aaii;

--
-- Name: f_ai_ptovta(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_ai_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
	divis		 int4;
    BEGIN

    for registro in select * from comprob where comp_codemp=NEW.ptv_codemp and comp_idptov=0 
	loop
	    insert into talon (tal_codemp,tal_idptov,tal_comprob,tal_valor,tal_fecha,tal_nombre) values (NEW.ptv_codemp,NEW.ptv_id,registro.comp_id,1,date(now()),registro.comp_nombre);
	end loop;
    insert into division (div_codemp, div_idptov, div_codigo, div_nombre) values (NEW.ptv_codemp, NEW.ptv_id, 1, NEW.ptv_nombre);
    select div_id into divis from division order by div_id desc limit 1;
    insert into centroc (cco_codemp,cco_idptov,cco_coddiv,cco_codigo,cco_nombre) values (NEW.ptv_codemp, NEW.ptv_id, divis, 1, NEW.ptv_nombre);
    insert into sucursal (sucu_cliente,sucu_codigo,sucu_nombre,sucu_direcc,sucu_locali,sucu_codpos,sucu_provin,sucu_pais,sucu_repres,sucu_direccl,sucu_localil,sucu_codposl,sucu_codprovl,sucu_paisl) values 
	(NEW.ptv_id,NEW.ptv_codigo,NEW.ptv_nombre,NEW.ptv_direcc,NEW.ptv_locali,NEW.ptv_codpos,NEW.ptv_provin,NEW.ptv_pais,NEW.ptv_nombre,NEW.ptv_direcc,NEW.ptv_locali,NEW.ptv_codpos,NEW.ptv_provin,NEW.ptv_pais);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_ptovta() OWNER TO aaii;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total		 numeric;
	ultcie		 date;
	fecconc		 timestamp without time zone;
	cuantos		 integer;
	idconc		 integer;
	deudxv		 integer;
	aportes		 integer;
	deudxc		 integer;
	cont		 integer;
	registro	 record;
BEGIN
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer) into deudxv;
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'DEUDXC')::integer) into deudxc;
    select idcbl(NEW.astc_codemp,NEW.astc_idptov,valvaramb(NEW.astc_codemp,NEW.astc_idptov,'1242')::integer) into aportes;

    select l_feccie into ultcie from liquidacion where l_idptov=NEW.astc_idptov and l_estado=2 order by l_feccie desc limit 1;

    if (int4eq(NEW.astc_ctacble,aportes) and int4eq(OLD.astc_cierra,2) and int4eq(NEW.astc_cierra,1)) THEN 
	select accb_idccbl into idconc from astcconccble where accb_idastc=OLD.astc_id;
	delete from astcconccble where accb_idastc=OLD.astc_id;
	select ccbl_fecha into fecconc from conccble where ccbl_id=idconc;
	for registro in select * from conccble where date_ge(ccbl_fecha::date,fecconc::date) order by ccbl_fecha asc 
	    loop
		if (date_eq(fecconc::date,registro.ccbl_fecha::date)) then
		    update conccble set ccbl_salcon=ccbl_salcon-(OLD.astc_importe) where ccbl_id=idconc;
		else
		    update conccble set ccbl_salcon=ccbl_salcon-(OLD.astc_importe),ccbl_salant=ccbl_salant-(OLD.astc_importe) where ccbl_id=idconc;
		end if;
	    end loop;
    end if;

    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=NEW.astc_id;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=NEW.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=NEW.astc_id;
    END IF;

    if int4eq(OLD.astc_ctacble,deudxv) THEN 
	if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	    update compliq set clq_idcopr=NEW.astc_ctacte where clq_idastoc=NEW.astc_id;
	    update cobrxclq set cxc_idcopr=NEW.astc_ctacte where cxc_idastoc=NEW.astc_id;
	END IF;
	if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
	    update compliq set clq_estado=999 where clq_idastoc=NEW.astc_id;
	    delete from cobrxclq where cxc_idastoc=NEW.astc_id;
	END IF;
	if date_ne(NEW.astc_fecval,OLD.astc_fecval) THEN 
	    update compliq set clq_fecha=NEW.astc_fecval where clq_idastoc=NEW.astc_id;
	    update cobrxclq set cxc_fecha=NEW.astc_fecval,cxc_mes=date_part('month',NEW.astc_fecval),cxc_anio=date_part('year',NEW.astc_fecval) where cxc_idastoc=NEW.astc_id;
	END IF;
	if numeric_ne(NEW.astc_importe,OLD.astc_importe) THEN 
	    select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) into total from compliq where clq_idastoc=NEW.astc_id;
	    if numeric_ne(NEW.astc_importe,total) then
		RAISE EXCEPTION 'NO SE PUEDE MODIFICAR UN IMPORTE DE UNA COBRANZA, SIN ANTES MODIFICAR LOS CONCEPTOS DE COBRANZA DE LIQUIDACION (COMPLIQ)';
	    end if;
	END IF;
    else
	if int4eq(OLD.astc_ctacble,deudxc) THEN 
	    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
		update gastos set gto_prove=NEW.astc_ctacte where gto_id=NEW.astc_idgto;
	    END IF;
	    if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
		update gastos set gto_estado=999 where gto_id=NEW.astc_idgto;
	    END IF;
	END IF;
    END IF;

    if (int4eq(NEW.astc_estado,999) and int4ne(OLD.astc_estado,999)) then
	if (int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,deudxv) or int4eq(NEW.astc_ctacble,deudxc))) THEN
	    update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=NEW.astc_idastoh;
	end if;
	update cheques set chq_estado=2,chq_idastoce=NULL where chq_idastoce=NEW.astc_id;
    end if;



	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=NEW.astc_id;
	if cont is null then
	    cont:=1;
	end if;
	if (numeric_ne(NEW.astc_importe,OLD.astc_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_importe',OLD.astc_importe,NEW.astc_importe,cont);
	end if;
	if (int4ne(NEW.astc_ctacte,OLD.astc_ctacte)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_ctacte',OLD.astc_ctacte,NEW.astc_ctacte,cont);
	end if;
	if (int4ne(NEW.astc_cierra,OLD.astc_cierra)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_cierra',OLD.astc_cierra,NEW.astc_cierra,cont);
	end if;
	if (int4ne(NEW.astc_estado,OLD.astc_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.astc_idptov,NEW.astc_comprob,NEW.astc_numero,'astoctas',NEW.astc_id,'astc_estado',OLD.astc_estado,NEW.astc_estado,cont);
	end if;


    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO aaii;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	ultcie		 date;
	cont		 integer;
BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=NEW.ash_idptov and l_estado=2 order by l_feccie desc limit 1;

--    if int4eq(OLD.ash_estado,2) then
--	if date_lt(NEW.ash_fecval,ultcie) then
--	    RAISE EXCEPTION 'NO SE PUEDE MODIFICAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
--	END IF;
--    END IF;

	if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	    update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	    update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	    update gastos set gto_estado=NEW.ash_estado where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_estado=NEW.ash_estado where eg_idastoh=OLD.ash_id;
	    delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;
	if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	END IF;
	if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	    update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	    update gastos set gto_fecval=NEW.ash_fecval where gto_idastoh=OLD.ash_id;
	    update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	    update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	    update gastos set gto_comprob=NEW.ash_comprob where gto_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	    update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	    update gastos set gto_numero=NEW.ash_numero where gto_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	    update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	    update gastos set gto_codemp=NEW.ash_codemp where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_codemp=NEW.ash_codemp where eg_idastoh=OLD.ash_id;
	END IF;
	if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	    update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	    update gastos set gto_idptov=NEW.ash_idptov where gto_idastoh=OLD.ash_id;
	    update liqegr set eg_idptov=NEW.ash_idptov where eg_idastoh=OLD.ash_id;
	END IF;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=NEW.ash_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.ash_anio,OLD.ash_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_anio',OLD.ash_anio,NEW.ash_anio,cont);
	end if;
	if (int4ne(NEW.ash_mes,OLD.ash_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_mes',OLD.ash_mes,NEW.ash_mes,cont);
	end if;
	if (int4ne(NEW.ash_estado,OLD.ash_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_estado',OLD.ash_estado,NEW.ash_estado,cont);
	end if;
	if (date_ne(NEW.ash_fecomp,OLD.ash_fecomp)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecomp',OLD.ash_fecomp,NEW.ash_fecomp,cont);
	end if;
	if (date_ne(NEW.ash_fecval,OLD.ash_fecval)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.ash_idptov,NEW.ash_comprob,NEW.ash_numero,'astoh',NEW.ash_id,'ash_fecval',OLD.ash_fecval,NEW.ash_fecval,cont);
	end if;



    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO aaii;

--
-- Name: f_au_cheques(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	numero		 integer;
	comprob		 integer;
BEGIN

	if(NEW.chq_idastoce is null) then
	    select astc_comprob,astc_numero into comprob,numero from astoctas where astc_id=NEW.chq_idastoc;
	else
	    select astc_comprob,astc_numero into comprob,numero from astoctas where astc_id=NEW.chq_idastoce;
	end if;

	select max(log_cont)+1 into cont from modlogs where log_tabla='cheques' and log_idtabla=NEW.chq_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.chq_nucheq,OLD.chq_nucheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_nucheq',OLD.chq_nucheq,NEW.chq_nucheq,cont);
	end if;
	if (int4ne(NEW.chq_codbco,OLD.chq_codbco)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_codbco',OLD.chq_codbco,NEW.chq_codbco,cont);
	end if;
	if (int4ne(NEW.chq_idastoc,OLD.chq_idastoc)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_idastoc',OLD.chq_idastoc,NEW.chq_idastoc,cont);
	end if;
	if (int4ne(NEW.chq_idastoce,OLD.chq_idastoce)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_idastoce',OLD.chq_idastoce,NEW.chq_idastoce,cont);
	end if;
	if (date_ne(NEW.chq_fecheq,OLD.chq_fecheq)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_fecheq',OLD.chq_fecheq,NEW.chq_fecheq,cont);
	end if;
	if (int4ne(NEW.chq_estado,OLD.chq_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_estado',OLD.chq_estado,NEW.chq_estado,cont);
	end if;
	if (numeric_ne(NEW.chq_importe,OLD.chq_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.chq_idptov,comprob,numero,'cheques',NEW.chq_id,'chq_importe',OLD.chq_importe,NEW.chq_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_cheques() OWNER TO aaii;

--
-- Name: f_au_compliq(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_compliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='compliq' and log_idtabla=NEW.clq_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.clq_anio,OLD.clq_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_anio',OLD.clq_anio,NEW.clq_anio,cont);
	end if;
	if (int4ne(NEW.clq_mes,OLD.clq_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_mes',OLD.clq_mes,NEW.clq_mes,cont);
	end if;
	if (int4ne(NEW.clq_estado,OLD.clq_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_estado',OLD.clq_estado,NEW.clq_estado,cont);
	end if;
	if (date_ne(NEW.clq_fecha,OLD.clq_fecha)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_fecha',OLD.clq_fecha,NEW.clq_fecha,cont);
	end if;
	if (int4ne(NEW.clq_idcopr,OLD.clq_idcopr)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_idcopr',OLD.clq_idcopr,NEW.clq_idcopr,cont);
	end if;
	if (int4ne(NEW.clq_cargo,OLD.clq_cargo)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_cargo',OLD.clq_cargo,NEW.clq_cargo,cont);
	end if;
	if (numeric_ne(NEW.clq_importe,OLD.clq_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_importe',OLD.clq_importe,NEW.clq_importe,cont);
	end if;
	if (numeric_ne(NEW.clq_impngi,OLD.clq_impngi)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_impngi',OLD.clq_impngi,NEW.clq_impngi,cont);
	end if;
	if (numeric_ne(NEW.clq_interes,OLD.clq_interes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.clq_idptov,NEW.clq_comprob,NEW.clq_numero,'compliq',NEW.clq_id,'clq_interes',OLD.clq_interes,NEW.clq_interes,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compliq() OWNER TO aaii;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO aaii;

--
-- Name: f_au_conccble(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_conccble() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.ccbl_estado,OLD.ccbl_estado) THEN 
	update astcconccble set accb_estado=NEW.ccbl_estado where accb_idccbl=OLD.ccbl_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_conccble() OWNER TO aaii;

--
-- Name: f_au_concilia(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_concilia() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.clia_estado,OLD.clia_estado) THEN 
	update conxclia set cxlia_estado=NEW.clia_estado where cxlia_idclia=OLD.clia_id;
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_concilia() OWNER TO aaii;

--
-- Name: f_au_coprop(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		integer;
	tipcta		integer;
	telefono	character varying;
	mail		character varying;
BEGIN
	select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
	if int4ne(NEW.cop_unifun,OLD.cop_unifun) THEN 
	    update ctes set cte_codigo=NEW.cop_unifun where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if int4ne(NEW.cop_estado,OLD.cop_estado) THEN 
	    update ctes set cte_estado=NEW.cop_estado where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if bpcharne(NEW.cop_nombre,OLD.cop_nombre) THEN 
	    update ctes set cte_nombre=NEW.cop_nombre where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	    if OLD.cop_nombre is not null THEN 
		telefono:=' ';
		mail:=' ';
		select tel_dato into telefono from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel not in (6,7) order by tel_codigo desc limit 1;
		select tel_dato into mail from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel=7 limit 1;
		insert into cambtitu (cbt_codemp,cbt_idptov,cbt_division,cbt_centro,cbt_unifun,cbt_idcopr,cbt_nombre,cbt_direcc,cbt_locali,cbt_codpos,cbt_provin,cbt_tipdoc,cbt_nrodoc,cbt_nrcuit,cbt_telefono,cbt_mail) values (OLD.cop_codemp,OLD.cop_idptov,OLD.cop_division,OLD.cop_centro,OLD.cop_unifun,OLD.cop_id,OLD.cop_nombre,OLD.cop_direcc,OLD.cop_locali,OLD.cop_codpos,OLD.cop_provin,OLD.cop_tipdoc,OLD.cop_nrodoc,OLD.cop_nrcuit,telefono,mail);
	    END IF;
	END IF;

	select max(log_cont)+1 into cont from modlogs where log_tabla='coprop' and log_idtabla=NEW.cop_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.cop_unifun,OLD.cop_unifun)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_unifun',OLD.cop_unifun,NEW.cop_unifun,cont);
	end if;
	if (NEW.cop_direcc is distinct from OLD.cop_direcc) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_direcc',OLD.cop_direcc,NEW.cop_direcc,cont);
	end if;
	if (NEW.cop_locali is distinct from OLD.cop_locali) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_locali',OLD.cop_locali,NEW.cop_locali,cont);
	end if;
	if (NEW.cop_descuf is distinct from OLD.cop_descuf) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_descuf',OLD.cop_descuf,NEW.cop_descuf,cont);
	end if;
	if (NEW.cop_nrcuit is distinct from OLD.cop_nrcuit) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_nrcuit',OLD.cop_nrcuit,NEW.cop_nrcuit,cont);
	end if;
	if (int4ne(NEW.cop_tipuf,OLD.cop_tipuf)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_tipuf',OLD.cop_tipuf,NEW.cop_tipuf,cont);
	end if;
	if (int4ne(NEW.cop_nrodoc,OLD.cop_nrodoc)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_nrodoc',OLD.cop_nrodoc,NEW.cop_nrodoc,cont);
	end if;
	if (int4ne(NEW.cop_estado,OLD.cop_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_estado',OLD.cop_estado,NEW.cop_estado,cont);
	end if;
	if (numeric_ne(NEW.cop_porc1,OLD.cop_porc1)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc1',OLD.cop_porc1,NEW.cop_porc1,cont);
	    insert into chat (c_message,c_to) values ('Se cambio un Porcentaje A',58);
	end if;
	if (numeric_ne(NEW.cop_porc2,OLD.cop_porc2)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc2',OLD.cop_porc2,NEW.cop_porc2,cont);
	end if;
	if (numeric_ne(NEW.cop_porc3,OLD.cop_porc3)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc3',OLD.cop_porc3,NEW.cop_porc3,cont);
	end if;
	if (numeric_ne(NEW.cop_porc4,OLD.cop_porc4)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc4',OLD.cop_porc4,NEW.cop_porc4,cont);
	end if;
	if (numeric_ne(NEW.cop_porc5,OLD.cop_porc5)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.cop_idptov,NEW.cop_division,NEW.cop_centro,'coprop',NEW.cop_id,'cop_porc5',OLD.cop_porc5,NEW.cop_porc5,cont);
	end if;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_coprop() OWNER TO aaii;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;
	if int4eq(NEW.emi_estado,2) THEN 
	    update astoctas set astc_fecvto=astc_fecval+diasconpag(NEW.emi_conpag) where astc_idastoh=OLD.emi_idastoh and astc_ctacble=idcble(astc_codemp,astc_idptov,'DEUDXV');
	    END IF;
	END IF;
    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrocuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO aaii;

--
-- Name: f_au_gastos(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    cuantosenoc		integer;
    ocid		integer;
    cont		integer;
    BEGIN

    select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=NEW.gto_id;
    select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;

    if (int4eq(NEW.gto_estado,999) and int4ne(OLD.gto_estado,999)) then
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=NEW.gto_id;
	if int4eq(cuantos,1) THEN 
	    update liqegr set eg_estado=NEW.gto_estado where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_liqegr=cualliqegr;
	else
	    update liqegr set eg_importe=eg_importe-NEW.gto_importe where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_gasto=NEW.gto_id;
	end if;
	select ocdegasto(NEW.gto_id) into ocid;
	if (ocid is not null) then
	    select count(*) into cuantosenoc from ordencompra where oc_id=ocid;
	    if int4eq(cuantosenoc,1) THEN 
		update ordencompra set oc_estado=NEW.gto_estado where oc_id=ocid;
	    else
		update ordencompra set oc_total=oc_total-NEW.gto_importe where oc_id=ocid;
		delete from gtoxoc where gxo_idgto=NEW.gto_id;
	    end if;
	end if;
    else
	if int4ne(NEW.gto_prove,OLD.gto_prove) then
	    update gastos set gto_nprove=nomprov(NEW.gto_prove),gto_cuitprov=cuitprov(NEW.gto_prove),gto_coniva=conivaprov(NEW.gto_prove) where gto_id=NEW.gto_id;
	end if;
	if int4eq(cuantos,1) THEN 
	    update liqegr set
		eg_codemp=NEW.gto_codemp,
		eg_idptov=NEW.gto_idptov,
		eg_centro=NEW.gto_centro,
		eg_rubro=NEW.gto_rubro,
		eg_subrub=NEW.gto_subrub,
		eg_hayfac=NEW.gto_hayfac,
		eg_prove=NEW.gto_prove,
		eg_nprove=NEW.gto_nprove,
		eg_cuitprov=NEW.gto_cuitprov,
		eg_factur=NEW.gto_factur,
		eg_anio=NEW.gto_anio,
		eg_mes=NEW.gto_mes,
		eg_estado=NEW.gto_estado,
		eg_impag=NEW.gto_impag,
		eg_tipgto=NEW.gto_tipgto,
		eg_importe=NEW.gto_importe,
		eg_operador=NEW.gto_operador,
		eg_leyen=NEW.gto_leyen where eg_id=cualliqegr;
	END IF;
    end if;

	select max(log_cont)+1 into cont from modlogs where log_tabla='gastos' and log_idtabla=NEW.gto_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.gto_anio,OLD.gto_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_anio',OLD.gto_anio,NEW.gto_anio,cont);
	end if;
	if (int4ne(NEW.gto_mes,OLD.gto_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_mes',OLD.gto_mes,NEW.gto_mes,cont);
	end if;
	if (int4ne(NEW.gto_subrub,OLD.gto_subrub)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_subrub',OLD.gto_subrub,NEW.gto_subrub,cont);
	end if;
	if (int4ne(NEW.gto_prove,OLD.gto_prove)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_prove',OLD.gto_prove,NEW.gto_prove,cont);
	end if;
	if (int4ne(NEW.gto_estado,OLD.gto_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_estado',OLD.gto_estado,NEW.gto_estado,cont);
	end if;
	if (numeric_ne(NEW.gto_importe,OLD.gto_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_importe',OLD.gto_importe,NEW.gto_importe,cont);
	end if;
	if (date_ne(NEW.gto_fecval,OLD.gto_fecval)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.gto_idptov,NEW.gto_comprob,NEW.gto_numero,'gastos',NEW.gto_id,'gto_fecval',OLD.gto_fecval,NEW.gto_fecval,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_gastos() OWNER TO aaii;

--
-- Name: f_au_honorarios(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_honorarios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	idptov		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='honorarios' and log_idtabla=NEW.hon_id;
	if cont is null then
	    cont:=1;
	end if;
	if (int4ne(NEW.hon_anio,OLD.hon_anio)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_anio',OLD.hon_anio,NEW.hon_anio,cont);
	end if;
	if (int4ne(NEW.hon_mes,OLD.hon_mes)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_mes',OLD.hon_mes,NEW.hon_mes,cont);
	end if;
	if (int4ne(NEW.hon_estado,OLD.hon_estado)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_estado',OLD.hon_estado,NEW.hon_estado,cont);
	end if;
	if (numeric_ne(NEW.hon_importe,OLD.hon_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.hon_idptov,NEW.hon_division,NEW.hon_centroc,'honorarios',NEW.hon_id,'hon_importe',OLD.hon_importe,NEW.hon_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_honorarios() OWNER TO aaii;

--
-- Name: f_au_liqegr(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_liqegr() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
BEGIN

	select max(log_cont)+1 into cont from modlogs where log_tabla='liqegr' and log_idtabla=NEW.eg_id;
	if cont is null then
	    cont:=1;
	end if;
	if (NEW.eg_leyen is distinct from OLD.eg_leyen) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.eg_idptov,NEW.eg_division,NEW.eg_centro,'liqegr',NEW.eg_id,'eg_leyen',substring(OLD.eg_leyen from 1 for 180),substring(NEW.eg_leyen from 1 for 180),cont);
	end if;
	if (numeric_ne(NEW.eg_importe,OLD.eg_importe)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (NEW.eg_idptov,NEW.eg_division,NEW.eg_centro,'liqegr',NEW.eg_id,'eg_importe',OLD.eg_importe,NEW.eg_importe,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_liqegr() OWNER TO aaii;

--
-- Name: f_au_liquidacion(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

    if int4ne(NEW.l_estado,OLD.l_estado) THEN 
      if(int4eq(NEW.l_estado,999::int)) THEN
	update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	update liqui set lq_estado=NEW.l_estado where lq_idliq=NEW.l_id;
	update compliq set clq_estado=NEW.l_estado where clq_idliq=NEW.l_id and clq_comprob=OLD.l_comprob;
	update compliq set clq_estado=1,clq_idliq=NULL where clq_idliq=NEW.l_id and clq_comprob!=OLD.l_comprob;
	update auxint set ai_estado=NEW.l_estado where ai_idliq=NEW.l_id;
	update astoh set ash_estado=NEW.l_estado where ash_comprob=NEW.l_comprob and ash_idemiti=NEW.l_id;
      else
	update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	update liqui set lq_estado=NEW.l_estado where lq_idliq=NEW.l_id;
	update compliq set clq_estado=NEW.l_estado where clq_idliq=NEW.l_id;
	update auxint set ai_estado=NEW.l_estado where ai_idliq=NEW.l_id;
	update astoh set ash_estado=NEW.l_estado where ash_comprob=NEW.l_comprob and ash_idemiti=NEW.l_id;
      END IF;
    END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_liquidacion() OWNER TO aaii;

--
-- Name: f_au_ordencompra(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4eq(NEW.oc_estado,999) THEN 
	delete from gtoxoc where gxo_idoc=OLD.oc_id;
    END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_ordencompra() OWNER TO aaii;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	tipcta		integer;
BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	if int4ne(NEW.prov_codigo,OLD.prov_codigo) THEN 
	    update ctes set cte_codigo=NEW.prov_codigo where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if int4ne(NEW.prov_estado,OLD.prov_estado) THEN 
	    update ctes set cte_estado=NEW.prov_estado where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	    update ctes set cte_nombre=NEW.prov_nombre where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	    update factpend set fap_nprove=NEW.prov_nombre where fap_prove=OLD.prov_id;
	    update gastos set gto_nprove=NEW.prov_nombre where gto_prove=OLD.prov_id;
	    update liqegr set eg_nprove=NEW.prov_nombre where eg_prove=OLD.prov_id;
	END IF;
	if bpcharne(NEW.prov_nrcuit,OLD.prov_nrcuit) THEN 
	    update factpend set fap_cuitprov=NEW.prov_nrcuit where fap_prove=OLD.prov_id;
	    update gastos set gto_cuitprov=NEW.prov_nrcuit where gto_prove=OLD.prov_id;
	    update liqegr set eg_cuitprov=NEW.prov_nrcuit where eg_prove=OLD.prov_id;
	END IF;
	if int4ne(NEW.prov_coniva,OLD.prov_coniva) THEN 
	    update factpend set fap_coniva=NEW.prov_coniva where fap_prove=OLD.prov_id;
	    update gastos set gto_coniva=NEW.prov_coniva where gto_prove=OLD.prov_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO aaii;

--
-- Name: f_au_telefon(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_au_telefon() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	cont		 integer;
	idptov		 integer;
	comprob		 integer;
	numero		 integer;
BEGIN

	select cop_idptov,cop_division,cop_centro into idptov,comprob,numero from coprop where cop_id=NEW.tel_codigo;
	select max(log_cont)+1 into cont from modlogs where log_tabla='telefon' and log_idtabla=NEW.tel_id;
	if cont is null then
	    cont:=1;
	end if;
	if (NEW.tel_dato is distinct from OLD.tel_dato) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (idptov,comprob,numero,'telefon',NEW.tel_id,'tel_dato',substring(OLD.tel_dato from 1 for 180),substring(NEW.tel_dato from 1 for 180),cont);
	end if;
	if (int4ne(NEW.tel_codigo,OLD.tel_codigo)) then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont) values (idptov,comprob,numero,'telefon',NEW.tel_id,'tel_codigo',OLD.tel_codigo,NEW.tel_codigo,cont);
	end if;

    RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_telefon() OWNER TO aaii;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		 date;
	cuantos		 int4;
	idneg		 integer;
	cont		 integer;
	regis		 record;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.astc_idptov and l_estado=2 order by l_feccie desc limit 1;
    if date_lt(OLD.astc_fecval,ultcie) then
	RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
    end if;

    --que pasa con la conciliacion bancaria???
    if (int4eq(OLD.astc_cierra,2) and (int4eq(OLD.astc_tipcta,99) or int4eq(OLD.astc_tipcta,98))) then
	update astoctas set astc_cierra=1 where astc_cierra=2 and astc_tipcta=OLD.astc_tipcta and astc_ctacte=OLD.astc_ctacte and astc_grupo=OLD.astc_grupo and astc_idastoh!=OLD.astc_idastoh;
    end if;

----------------------------  CHEQUES ---------------------------------------    
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
	if found then
	    update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
	END IF;
----------------------------  MONEX ---------------------------------------    
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
	if found then
	    update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
	END IF;
----------------------------  DOCUM ---------------------------------------    
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
	if int4ne(cuantos,0) then
	    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	    if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	    END IF;
	END IF;
	select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
	if found then
	    update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
	END IF;
--------------------------- ELIMINAR COMPLIQ --------------------------------
	select count(*) into cuantos from compliq where int4eq(clq_idastoc,OLD.astc_id);
	if found then
	    delete from compliq where clq_idastoc=OLD.astc_id;
	end if;
-------------------------- ELIMINAR COBRXCLQ ----------------------------------
	select count(*) into cuantos from cobrxclq where int4eq(cxc_idastoc,OLD.astc_id);
	if found then
	    for regis in select cxc_id from cobrxclq where cxc_idastoc=OLD.astc_id 
		loop
		    delete from cobrxclq where cxc_id=regis.cxc_id;
		end loop;
	end if;
	idneg:=OLD.astc_id*-1;
	select count(*) into cuantos from cobrxclq where int4eq(cxc_idastoc,idneg);
	if found then
	    for regis in select cxc_id from cobrxclq where cxc_idastoc=idneg 
		loop
		    delete from cobrxclq where cxc_id=regis.cxc_id;
		end loop;
	end if;
----------------------------------GRABAR MODLOGS--------------------------------


	select max(log_cont)+1 into cont from modlogs where log_tabla='astoctas' and log_idtabla=OLD.astc_id;
	if cont is null then
	    cont:=1;
	end if;

	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_importe',OLD.astc_importe,OLD.astc_importe,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_fecval',OLD.astc_fecval,OLD.astc_fecval,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_ctacble',OLD.astc_ctacble,OLD.astc_ctacble,cont,'delete');
	if OLD.astc_ctacte is not null then
	    insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.astc_idptov,OLD.astc_comprob,OLD.astc_numero,'astoctas',OLD.astc_id,'astc_ctacte',OLD.astc_ctacte,OLD.astc_ctacte,cont,'delete');
	end if;

    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO frola;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		date;
	idgto		int4;
	cuantos		integer;
	nastoh		integer;
	sgto		integer;
	pasaje		integer;
	cont		integer;
	gtoimpor	numeric;
	idliqegr	int4;
	egimpor		numeric;
	registro	record;
	regis		record;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.ash_idptov and l_estado=2 order by l_feccie desc limit 1;

--    if date_lt(OLD.ash_fecval,ultcie) then
--	select count(*) into cuantos from astoctas where astc_idastoh=OLD.ash_id;
--	if numeric_ne(cuantos,0) then
--	    RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN ASIENTO DE UNA LIQUIDACION CERRADA';
--	END IF;
--    END IF;

	    for regis in select gto_id as gto,gto_importe as gtoimp from gastos where int4eq(gto_idastoh,OLD.ash_id)
		loop
		    idgto:=regis.gto;
		    gtoimpor:=regis.gtoimp;
		    select gxo_idsgto into sgto from gtoxoc where gxo_idgto=idgto;
		    if (sgto is not null) then
			select paso_sgto(OLD.ash_id,idgto) into pasaje;
			select count(gxo_idsgto) into cuantos from gtoxoc where gxo_idsgto=sgto;
			if (int4gt(cuantos,1)) then
			    delete from gtoxoc where gxo_idgto=idgto and gxo_idsgto=sgto;
			else
			    update gtoxoc set gxo_idgto=-1 where gxo_idsgto=sgto;
			end if;
		    end if;
		    select gxl_liqegr into idliqegr from gtoxliqe where int4eq(gxl_gasto,idgto);
		    if idliqegr is null then
			select eg_id into idliqegr from liqegr where eg_idastoh=OLD.ash_id;
		    end if;
		    select eg_importe into egimpor from liqegr where int4eq(eg_id,idliqegr);
		    if numeric_eq(egimpor,gtoimpor) then
			delete from gtoxliqe where int4eq(gxl_gasto,idgto);
			delete from liqegr where int4eq(eg_id,idliqegr);
			delete from gastos where int4eq(gto_id,idgto);
		    else
			select eg_idastoh into nastoh from liqegr where eg_id in (select gxl_liqegr from gtoxliqe where gxl_gasto!=idgto);
			update liqegr set eg_importe=eg_importe-gtoimpor,eg_idastoh=nastoh where int4eq(eg_id,idliqegr);
			delete from gtoxliqe where int4eq(gxl_gasto,idgto);
			delete from gastos where int4eq(gto_id,idgto);
		    end if;
		end loop;

	    delete from concilia where int4eq(clia_idastcg,OLD.ash_id);

	    for registro in select astc_id from astoctas where int4eq(astc_idastoh,OLD.ash_id)
		loop
		    delete from conxclia where int4eq(cxlia_idastc,registro.astc_id);
		end loop;

	    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
	    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idashce=OLD.ash_id;

	select max(log_cont)+1 into cont from modlogs where log_tabla='astoh' and log_idtabla=OLD.ash_id;
	if cont is null then
	    cont:=1;
	end if;


	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_fecval',OLD.ash_fecval,OLD.ash_fecval,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_titulo',OLD.ash_titulo,OLD.ash_titulo,cont,'delete');
	insert into modlogs (log_idptov,log_comprob,log_numero,log_tabla,log_idtabla,log_campo,log_valant,log_valpos,log_cont,log_obs) values (OLD.ash_idptov,OLD.ash_comprob,OLD.ash_numero,'astoh',OLD.ash_id,'ash_numptv',OLD.ash_numptv,OLD.ash_numptv,cont,'delete');


    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO frola;

--
-- Name: f_bd_compliq(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_compliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ultcie		 date;
    BEGIN

    select l_feccie into ultcie from liquidacion where l_idptov=OLD.clq_idptov and l_estado=2 order by l_feccie desc limit 1;

    if (date_lt(OLD.clq_fecha,ultcie) and int4eq(OLD.clq_estado,2)) then
	RAISE EXCEPTION 'NO SE PUEDE ELIMINAR UN CONCEPTO DE LIQUIDACION DE UNA LIQUIDACION CERRADA';
    else
	delete from cobrxclq where cxc_idclq=OLD.clq_id;
    end if;

    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_compliq() OWNER TO aaii;

--
-- Name: f_bd_coprop(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.cop_codemp and astc_idptov=OLD.cop_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.cop_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN COPROPIETARIO CON REGISTROS CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_coprop() OWNER TO aaii;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN
    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO aaii;

--
-- Name: f_bd_gastos(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    cuantosenoc		integer;
    ocid		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4gt(cuantos,1) THEN 
	RAISE EXCEPTION  'NO SE PUEDE BORRAR EL GASTO YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO BORRAR';
	END IF;

	select ocdegasto(OLD.gto_id) into ocid;
	if (ocid is not null) then
	    select count(*) into cuantosenoc from ordencompra where oc_id=ocid;
	    if int4eq(cuantosenoc,1) THEN 
		delete from ordencompra where oc_id=ocid;
	    else
		update ordencompra set oc_total=oc_total-OLD.gto_importe where oc_id=ocid;
		delete from gtoxoc where gxo_idgto=OLD.gto_id;
	    end if;
	end if;

    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_gastos() OWNER TO aaii;

--
-- Name: f_bd_importoliq(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_importoliq() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    delete from sinicial where sin_idsaldos=OLD.imp_id;
    delete from dinicial where din_idsaldos=OLD.imp_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_importoliq() OWNER TO aaii;

--
-- Name: f_bd_incidencias(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_incidencias() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
	delete from imgincid where img_idinc=OLD.in_id;
	delete from operincid where oi_idinc=OLD.in_id;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_incidencias() OWNER TO aaii;

--
-- Name: f_bd_liquidacion(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos	int4;
    comprob	 integer;
    BEGIN
	delete from compliquid where cl_idliq=OLD.l_id;
	delete from liqui where lq_idliq=OLD.l_id;
	delete from cobrxclq where cxc_idclq in (select clq_id from compliq where clq_idliq=OLD.l_id);
	delete from compliq where clq_idliq=OLD.l_id and clq_comprob=OLD.l_comprob;
	update compliq set clq_idliq=NULL,clq_estado=1 where clq_idliq=OLD.l_id and clq_comprob!=OLD.l_comprob;
	delete from auxint where ai_idliq=OLD.l_id;
	delete from astoh where ash_comprob=OLD.l_comprob and ash_idemiti=OLD.l_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_liquidacion() OWNER TO aaii;

--
-- Name: f_bd_ordencompra(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_ordencompra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    delete from gtoxoc where gxo_idoc=OLD.oc_id;
    RETURN OLD;
END;$$;


ALTER FUNCTION public.f_bd_ordencompra() OWNER TO aaii;

--
-- Name: f_bd_prove(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.prov_codemp and astc_idptov=OLD.prov_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON REGISTROS CONTABLES CARGADOS';
	END IF;
	select count(*) into cuantos from gastos where gto_prove=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON GASTOS CARGADOS';
	END IF;
	select count(*) into cuantos from liqegr where eg_prove=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN PROVEEDOR CON GASTOS DE LIQUIDACION CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_prove() OWNER TO aaii;

--
-- Name: f_bd_ptovta(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bd_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
    BEGIN

    for registro in select * from comprob where comp_codemp=OLD.ptv_codemp and comp_idptov=0 
	loop
	    delete from talon where tal_codemp=OLD.ptv_codemp and tal_idptov=OLD.ptv_id and tal_comprob=registro.comp_id;
	end loop;
    delete from centroc where cco_codemp=OLD.ptv_codemp and cco_idptov=OLD.ptv_id;
    delete from division where div_codemp=OLD.ptv_codemp and div_idptov=OLD.ptv_id;
    delete from sucursal where sucu_cliente=OLD.ptv_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_ptovta() OWNER TO aaii;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 
------------------ PARTIDA DOBLE -----------------------------------
    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;
------------------ CASO CHEQUES -----------------------------------
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO aaii;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 
    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO aaii;

--
-- Name: f_bu_gastos(); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION f_bu_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if(int4gt(cuantos,1) and numeric_ne(OLD.gto_impag,NEW.gto_impag)) THEN 
	RAISE EXCEPTION  'NO SE PUEDE MODIFICAR YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO MODIFICAR';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bu_gastos() OWNER TO aaii;

--
-- Name: fecdechq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION fecdechq(integer) RETURNS date
    LANGUAGE sql
    AS $_$select chq_fecheq from cheques where chq_id= $1 ;$_$;


ALTER FUNCTION public.fecdechq(integer) OWNER TO aaii;

--
-- Name: fondo_reserva(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION fondo_reserva(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	suma		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargoMayores	 integer;
	cargoMenores	 integer;
	cargoExp	 integer;
	cargoReserva	 integer;
	porcReserva	 numeric(15,2);
	rubcar		 integer;
	srubcar		 integer;
	leyen		 character varying(255);
	regis		 record;
	reg		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;
    select valvaramb(codemp,idptov,'CARGOORDINARIAS') into cargoExp;
    select valvaramb(codemp,idptov,'CARGORESERVA') into cargoReserva;
    select car_srubcar into srubcar from cargos where car_id=cargoReserva;
    select car_rubcar into rubcar from cargos where car_id=cargoReserva;
    select car_leyen into leyen from cargos where car_id=cargoReserva;
    select valvaramb(codemp,idptov,'FONDORESERVA')::numeric(15,2) into porcReserva;

    for reg in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
	loop
	    suma:=0;
	    select sum(clq_importe) into suma from compliq where clq_cargo in (cargoMayores,cargoMenores,cargoExp) and clq_idliq=idliq and clq_idcopr=reg.cop_id;
	    impaux:=suma*porcReserva;
--	    importe:=round(impaux);
	    importe:=impaux;
	    if(numeric_gt(importe,0))then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubcar,srubcar,cargoReserva,leyen,1,importe,importe,reg.cop_id,idliq);
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.fondo_reserva(integer) OWNER TO aaii;

--
-- Name: gastoct(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION gastoct(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then

	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1 
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct(integer, integer, integer, numeric) OWNER TO aaii;

--
-- Name: gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctacte		ALIAS FOR $6; 
	nucheq		ALIAS FOR $7; 
	fecvto		ALIAS FOR $8; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then
	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte,astc_nucheq,astc_fecvto) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1,tipcta,ctacte,nucheq,fecvto
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) OWNER TO aaii;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cop_grupo into retval from
    	 coprop where int4eq(cliente,cop_id);

    if found then
	if int4eq(modo,1) then
	    update coprop set cop_grupo=cop_grupo+1 where int4eq(cliente,cop_id);
	end if;
    else
	update coprop set cop_grupo=1 where int4eq(cliente,cop_id);
	retval:=1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO aaii;

--
-- Name: hago_asiento_lq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION hago_asiento_lq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	idastohmal	 integer;
	numptv 		 integer;
	titulo 		 character varying;
	idastoh		 integer;
	astcid		 integer;
	cuentadxv	 integer;
	cuentac		 integer;
	deuda		 numeric(15,2);
	retval 		 integer;
	imputo 		 character;
	regi		 record;
	regis		 record;
    BEGIN

	retval:=0;
	numptv:=99999;

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 

	select max(ash_numptv) into numptv from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_idemiti is not null and ash_estado=2;
	if numptv is null then
	    numptv:=1;
	    titulo:='Carga Inicial de Saldos  ' || mes || '-' || anio;
	  else
	    numptv:=numptv + 1;
	    titulo:='Liquidacion de Expensas  ' || mes || '-' || anio;
	    select ash_id into idastohmal from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_numptv=numptv and ash_estado!=2;
	    delete from astoh where ash_id=idastohmal;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_division,ash_centro,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_estado,ash_operad,ash_idemiti,ash_date,ash_numptv) 
	    values (codemp,idptov,division,centro,anio,mes,comprob,numero,titulo,feccie,feccie,titulo,-1,operador,idliq,feccie,numptv);

	select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_centro=centro and ash_comprob=comprob and ash_numero=numero and ash_idemiti=idliq;

	retval:=idastoh;

	select idcbl(codemp,idptov,valvaramb(codemp,idptov,'DEUDXV')::integer) into cuentadxv;

	for regi in select lq_idcopr,sum(lq_importe) as impcop from liqui where lq_idliq=idliq group by 1 
	    loop
		select deudacopropid(regi.lq_idcopr,codemp,idptov) into deuda;
		insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro,astc_fecvto,astc_grupo) 
		     values (tipctacbl(cuentadxv),regi.lq_idcopr,idastoh,cuentadxv,regi.impcop,codemp,idptov,comprob,numero,feccie,-1,division,centro,fecvto,grupocli(regi.lq_idcopr,1));
		select astc_id into astcid from astoctas where astc_ctacte=regi.lq_idcopr and astc_idastoh=idastoh and astc_ctacble=cuentadxv and astc_importe=regi.impcop and astc_tipcta=tipctacbl(cuentadxv);
		update cobrxclq set cxc_idastoc=(astcid*-1),cxc_fecha=feccie,cxc_mes=mes,cxc_anio=anio where cxc_idastoc=0 and cxc_idcopr=regi.lq_idcopr;
		if (numeric_lt(deuda,0)) then
		    select imputodeuda(regi.lq_idcopr,deuda,idliq,astcid) into imputo;
		end if;
	    end loop;


	for regis in select lq_cargo,sum(lq_importe) as impcar from liqui where lq_idliq=idliq group by 1 
	    loop
		select car_ctacble into cuentac from cargos where car_id=regis.lq_cargo;
		insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro,astc_fecvto) 
		     values (idastoh,cuentac,regis.impcar * -1,codemp,idptov,comprob,numero,feccie,-1,division,centro,fecvto);
	    end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.hago_asiento_lq(integer) OWNER TO aaii;

--
-- Name: idcbl(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION idcbl(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codcble		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble);
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcbl(integer, integer, integer) OWNER TO aaii;

--
-- Name: idcble(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION idcble(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    codcble		integer;
    retval 		varchar;
    BEGIN

    select vari_valor into codcble from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble::int4) ;
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcble(integer, integer, character varying) OWNER TO aaii;

--
-- Name: idcli(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION idcli(integer, integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_id from coprop where cop_codemp=$1 and cop_idptov=$2 and cop_centro=$3 and cop_division=$4 and cop_unifun=$5;$_$;


ALTER FUNCTION public.idcli(integer, integer, integer, integer, integer) OWNER TO aaii;

--
-- Name: idcomp(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION idcomp(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	retval 		integer;
    BEGIN
    select comp_id into retval from comprob where int4eq(codemp,comp_codemp) and int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_id into retval from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_id into retval from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.idcomp(integer, integer, character varying) OWNER TO aaii;

--
-- Name: idcte(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION idcte(integer, integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1;
    ptovta		ALIAS FOR $2;
    tipcta		ALIAS FOR $3;
    codcte		ALIAS FOR $4;
    retval 		varchar;
    BEGIN

    select cte_id into retval from ctes where cte_codemp=codemp and cte_idptov=ptovta and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
    if not found then
	select cte_id into retval from ctes where cte_codemp=codemp and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	if not found then
	    select cte_id into retval from ctes where int4eq(0,cte_codemp) and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcte(integer, integer, integer, integer) OWNER TO aaii;

--
-- Name: importe_fe(numeric); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION importe_fe(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	imp		ALIAS FOR $1;
	retval		text;
    BEGIN
	select lpad((imp::numeric(11,2)*100)::numeric(11,0)::text,11,'0') into retval;
	RETURN retval;
    END;$_$;


ALTER FUNCTION public.importe_fe(numeric) OWNER TO aaii;

--
-- Name: imputocargoafavor(integer, numeric, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION imputocargoafavor(integer, numeric, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	pago		 ALIAS FOR $2; 
	deuda		 ALIAS FOR $3; 
	astcid		 ALIAS FOR $4; 
	idclq		 ALIAS FOR $5; 
	codemp		 integer;
	idptov		 integer;
	fecval		 date;
	importe		 numeric(15,2);
	deudant		 numeric(15,2);
	retval 		 integer;
    BEGIN

	retval:=-1;
	deudant:=deuda*-1;
	select astc_codemp,astc_idptov,astc_fecval into codemp,idptov,fecval from astoctas where astc_id=astcid;
	if (numeric_le(pago,deudant)) then
	    --imputo todo
	    select sum(clq_importe+clq_interes+clq_impngi) into importe from compliq where clq_id=idclq;
	    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,idclq,2,importe,idcopr,fecval,date_part('month',fecval),date_part('year',fecval));
	    retval:=1;
	else
	    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,idclq,1,deudant,idcopr,fecval,date_part('month',fecval),date_part('year',fecval));
	    retval:=2;
	end if;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.imputocargoafavor(integer, numeric, numeric, integer, integer) OWNER TO aaii;

--
-- Name: imputocobranza(integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION imputocobranza(integer, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	pago		 ALIAS FOR $2; 
	astcid		 ALIAS FOR $3; 
	codemp		 integer;
	idptov		 integer;
	fecval		 date;
	pago1		 numeric(15,2);
	totInt		 numeric(15,2);
	totGInt		 numeric(15,2);
	sumaCobrada	 numeric(15,2);
	importeCargo	 numeric(15,2);
	totalPorcentual	 numeric(15,2);
	pInt		 numeric(15,8);
	pGInt		 numeric(15,8);
	cInt		 numeric(15,2);
	cGInt		 numeric(15,2);
	diferencia	 numeric(15,2);
	restante	 numeric(15,2);
	regi		 record;
	r1		 record;
	r2		 record;
	r3		 record;
	retval 		 integer;
    BEGIN
	retval:=-1;
	select astc_codemp,astc_idptov,astc_fecval into codemp,idptov,fecval from astoctas where astc_id=astcid;
	totGInt:=0;
	totInt:=0;
	select pago::numeric(15,2) into pago1;
	for regi in select a.clq_id as idclq,a.clq_idliq as idliq,intdecarg(a.clq_cargo) as interes,a.clq_importe,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and (a.clq_importe>0 or a.clq_impngi>0 or a.clq_interes>0) and a.clq_estado=2 and a.clq_idliq is not null order by 2 
	    loop
		sumaCobrada:=0;
		importeCargo:=0;
		select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=regi.idclq;
		if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
		    sumaCobrada:=0;
		end if;
		if int4eq(regi.interes,3) then
		    importeCargo:=regi.clq_interes-sumaCobrada;
		    totInt:=totInt+importeCargo;
		else
		    if(int4eq(regi.interes,1)) then
			importeCargo:=regi.clq_importe-sumaCobrada;
			totGInt:=totGInt+importeCargo;
		    end if;
		end if;
	    end loop;

	totalPorcentual:=totInt+totGint;
	select totalPorcentual::numeric(15,2) into totalPorcentual;
--	RAISE EXCEPTION '% - %',pago1,totalPorcentual;
	if (numeric_le(pago1,totalPorcentual)) then
	    if(numeric_eq(pago1,totalPorcentual)) then
		cInt:=totInt;
		cGInt:=totGint;
	    else
		pInt:=totInt/totalPorcentual;
		pGInt:=totGInt/totalPorcentual;
		cInt:=pago1*pInt;
		cGInt:=pago1*pGInt;
		diferencia:=pago1-(cInt+cGInt);
		if numeric_ne(diferencia,0) then
		    cInt:=cInt+(diferencia);
		end if;
	    end if;
	    for r1 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_interes>0 and intdecarg(a.clq_cargo)=3 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r1.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r1.clq_interes-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(cInt,0)) then
			if numeric_ge(cInt,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r1.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    cInt:=cInt-importeCargo;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,1,cInt,fecval,date_part('month',fecval),date_part('year',fecval));
			    cInt:=0;
			end if;
		    end if;
		end loop;
	    for r2 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_importe from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_importe>0 and intdecarg(a.clq_cargo)=1 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    if numeric_ne(cInt,0) then
			cGInt:=cGInt+cInt;
		    end if;
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r2.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r2.clq_importe-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(cGInt,0)) then
			if numeric_ge(cGInt,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r2.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    cGInt:=cGInt-importeCargo;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,1,cGInt,fecval,date_part('month',fecval),date_part('year',fecval));
			    cGInt:=0;
			end if;
		    end if;
		end loop;
	    retval=1;
	else
	    restante:=pago1-totalPorcentual;
	    select restante::numeric(15,2) into restante;
	    for r1 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_interes from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_interes>0 and intdecarg(a.clq_cargo)=3 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r1.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r1.clq_interes-sumaCobrada;
		    if (numeric_gt(sumaCobrada,0)) then
			update cobrxclq set cxc_estado=2 where cxc_idclq=r1.idclq and cxc_estado=1;
		    end if;
		    if numeric_gt(importeCargo,0) then
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r1.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			retval=retval+1;
		    end if;
		end loop;
	    for r2 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_importe from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_importe>0 and intdecarg(a.clq_cargo)=1 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r2.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r2.clq_importe-sumaCobrada;
		    if (numeric_gt(sumaCobrada,0)) then
			update cobrxclq set cxc_estado=2 where cxc_idclq=r2.idclq and cxc_estado=1;
		    end if;
		    if (numeric_gt(importeCargo,0)) then
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r2.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			retval=retval+1;
		    end if;
		end loop;
	    for r3 in select a.clq_id as idclq,a.clq_idliq as idliq,a.clq_impngi from compliq a where (a.clq_id not in (select b.cxc_idclq from cobrxclq b where b.cxc_estado=2 and b.cxc_idcopr=idcopr)) and a.clq_idcopr=idcopr and a.clq_impngi>0 and intdecarg(a.clq_cargo)=2 and a.clq_estado=2 and a.clq_idliq is not null order by 2 asc 
		loop
		    sumaCobrada:=0;
		    importeCargo:=0;
		    select sum(cxc_importe) into sumaCobrada from cobrxclq where cxc_estado=1 and cxc_idclq=r3.idclq;
		    if (numeric_le(sumaCobrada,0) or sumaCobrada is null) then
			sumaCobrada:=0;
		    end if;
		    importeCargo:=r3.clq_impngi-sumaCobrada;
		    if (numeric_gt(importeCargo,0) and numeric_gt(restante,0)) then
			if numeric_ge(restante,importeCargo) then
			    update cobrxclq set cxc_estado=2 where cxc_idclq=r3.idclq and cxc_estado=1;
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r3.idclq,idcopr,2,importeCargo,fecval,date_part('month',fecval),date_part('year',fecval));
			    restante:=restante-importeCargo;
			    retval=retval+1;
			else
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_idcopr,cxc_estado,cxc_importe,cxc_fecha,cxc_mes,cxc_anio) values (astcid,r3.idclq,idcopr,1,restante,fecval,date_part('month',fecval),date_part('year',fecval));
			    restante:=0;
			    retval=retval+1;
			end if;
		    end if;
		end loop;
	end if;
	RETURN retval;
END;$_$;


ALTER FUNCTION public.imputocobranza(integer, numeric, integer) OWNER TO aaii;

--
-- Name: imputodeuda(integer, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION imputodeuda(integer, numeric, integer, integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idcopr		 ALIAS FOR $1; 
	deuda		 ALIAS FOR $2; 
	idliq		 ALIAS FOR $3; 
	astcidp		 ALIAS FOR $4; 
	astcid		 integer; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	sumaCobrada	 numeric(15,2);
	impcop		 numeric(15,2);
	importe		 numeric(15,2);
	deudant		 numeric(15,2);
	totint		 numeric(15,2);
	totgint		 numeric(15,2);
	totngi		 numeric(15,2);
	total		 numeric(15,2);
	porcint		 numeric(15,5);
	porcgint	 numeric(15,5);
	ctogint		 numeric(15,2);
	ctoint		 numeric(15,2);
	dif		 numeric(15,2);
	retval 		 integer;
	regi		 record;
	regis		 record;
	regist		 record;
    BEGIN

	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 
	deudant:=deuda*-1;
	astcid:=astcidp*-1;
	totint:=0;
	totgint:=0;
	sumaCobrada:=0;
	select sum(clq_importe+clq_impngi+clq_interes) into impcop from compliq where clq_idliq=idliq and clq_idcopr=idcopr and (clq_importe>0 or clq_impngi>0 or clq_interes>0); 
	if (numeric_le(impcop,deudant)) then
	    --imputo todo
	    for regi in select * from compliq where clq_idliq=idliq and clq_idcopr=idcopr and (clq_importe>0 or clq_impngi>0 or clq_interes>0) 
		loop
		    importe:=regi.clq_importe+regi.clq_interes+regi.clq_impngi;
		    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regi.clq_id,2,importe,idcopr,feccie,mes,anio);
		end loop;
	else
	    -- sumo todo que genera interes porque si tiene plata a favor no puede tener interes
	    select sum(clq_importe) into totgint from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0;
	    -- si ese importe es mayor que deudant imputo todo lo que puedo en genint
	    total:=totgint;
	    if (numeric_le(deudant,total)) then
		ctogint:=deudant;
		for regis in select clq_id,clq_importe from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0 
		    loop
			importe:=regis.clq_importe;
			if (numeric_le(importe,ctogint)) then
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,2,importe,idcopr,feccie,mes,anio);
			    ctogint:=ctogint-importe;
			else
			    if (numeric_gt(ctogint,0)) then
				insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,1,ctogint,idcopr,feccie,mes,anio);
				ctogint:=0;
			    end if;
			end if;
		    end loop;
	    else
		for regis in select clq_id,clq_importe from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=1 and clq_importe>0 
		    loop
			importe:=regis.clq_importe;
			insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regis.clq_id,2,importe,idcopr,feccie,mes,anio);
		    end loop;
		--ahora chequeo lo que no genera interes
		totngi:=deudant-total;
		for regist in select clq_id,clq_impngi from compliq where clq_idliq=idliq and clq_idcopr=idcopr and intdecarg(clq_cargo)=2 and clq_impngi>0
		    loop
			if (numeric_le(regist.clq_impngi,totngi)) then
			    insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regist.clq_id,2,regist.clq_impngi,idcopr,feccie,mes,anio);
			    totngi:=totngi-regist.clq_impngi;
			else
			    if (numeric_gt(totngi,0)) then
				insert into cobrxclq (cxc_idastoc,cxc_idclq,cxc_estado,cxc_importe,cxc_idcopr,cxc_fecha,cxc_mes,cxc_anio) values (astcid,regist.clq_id,1,totngi,idcopr,feccie,mes,anio);
				totngi:=0;
			    end if;
			end if;
		    end loop;
	    end if;
	end if;

	RETURN;
END;$_$;


ALTER FUNCTION public.imputodeuda(integer, numeric, integer, integer) OWNER TO aaii;

--
-- Name: intacum(integer, date); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION intacum(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cop_id		 ALIAS FOR $1;
	fecha		 ALIAS FOR $2;
	total		 numeric(15,2);
	fecliq		 date;
	idliqant	 integer;
	centro		 integer;
	regi		 record;
	reg		 record;
	cobint		 numeric(15,2);
	inter		 integer;

BEGIN
    total:=0;
    cobint:=0;
    for reg in select clq_id,clq_interes from compliq where clq_idcopr=cop_id and clq_fecha<=fecha and clq_estado=2 and intdecarg(clq_id)=3 and clq_interes>0 
	loop
	    total:=total+reg.clq_interes;
	    for reg in select * from cobrxclq where cxc_idclq=regi.clq_id
		loop
		    cobint:=cobint+reg.cxc_importe;
		end loop;
	end loop;

    total:=total - cobint;

RETURN total;
END;$_$;


ALTER FUNCTION public.intacum(integer, date) OWNER TO aaii;

--
-- Name: intdecarg(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION intdecarg(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select car_genint from cargos where car_id= $1 ;$_$;


ALTER FUNCTION public.intdecarg(integer) OWNER TO aaii;

--
-- Name: intercentro(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION intercentro(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select int_valor from interes where int_centro= $1 order by int_fecha desc limit 1;$_$;


ALTER FUNCTION public.intercentro(integer) OWNER TO aaii;

--
-- Name: liquido(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION liquido(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	idptov		 integer;
	redondeo	 integer;
	retval 		 integer;
	retvalc 	 character;
    BEGIN

    retval:=0;
    select l_idptov into idptov from liquidacion where l_id=idliq;
    select ptv_redond into redondeo from ptovta where ptv_id=idptov;

    --PASO CARGOS FIJOS 
    select paso_comprop(idliq) into retvalc;

    -- DISTRIBUYO COMPLIQUID
    select prorrata(idliq) into retvalc;

    -- PASO CARGOS VARIABLES
    select paso_cvar(idliq) into retvalc;

    -- CALCULO INTERES
    select calc_intliq(idliq) into retval;

    -- CARGO TABLA LIQUI
    select cargo_liqui_lq(idliq) into retval;

    -- REDONDEO
    if (int4eq(redondeo,2)) then
	select redondeoliqui(idliq) into retval;
    end if;

    -- HAGO ASIENTO DE LIQUIDACION
    select hago_asiento_lq(idliq) into retval;

    -- CARGO TABLA AUXINT
    select cargo_auxint(idliq) into retvalc;

    -- CONFIRMO LIQUIDACION
    update liquidacion set l_estado=2 where l_id=idliq;


    -- IMPUTO CARGOS NEGATIVOS!
    select paso_cvar_neg(idliq) into retvalc;


    RETURN retval;
    END;$_$;


ALTER FUNCTION public.liquido(integer) OWNER TO aaii;

--
-- Name: liquido_gf(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION liquido_gf(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	idptov		 integer;
	redondeo	 integer;
	retval 		 integer;
	retvalc 	 character;
    BEGIN

    retval:=0;
    select l_idptov into idptov from liquidacion where l_id=idliq;
    select ptv_redond into redondeo from ptovta where ptv_id=idptov;

    --REVISO MENORES Y DURACION CONTRATOS
    select reviso_grupof(idliq) into retvalc;

    --CALCULO CUOTA MAYOR Y MENOR
    select calculo_cuota(idliq) into retvalc;

    --PASO CARGOS FIJOS 
    select paso_comprop(idliq) into retvalc;

    -- DISTRIBUYO COMPLIQUID
    select prorratados(idliq) into retvalc;

    -- CALCULO RESERVA
/*    select fondo_reserva(idliq) into retvalc;*/

    -- CALCULO EXPENSAS LOCACION
    select exp_loc(idliq) into retvalc;

    -- PASO CARGOS VARIABLES
    select paso_cvar(idliq) into retvalc;

    -- CALCULO INTERES
    select calc_intliq(idliq) into retval;

    -- CARGO TABLA LIQUI
    select cargo_liqui_lq(idliq) into retval;

    -- REDONDEO ? NO!
    if (int4eq(redondeo,2)) then
	select redondeoliqui(idliq) into retval;
    end if;

    -- HAGO ASIENTO DE LIQUIDACION
    select hago_asiento_lq(idliq) into retval;

    -- CARGO TABLA AUXINT
    select cargo_auxint(idliq) into retvalc;

    -- CONFIRMO LIQUIDACION
    update liquidacion set l_estado=2 where l_id=idliq;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.liquido_gf(integer) OWNER TO aaii;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO aaii;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO aaii;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO aaii;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO aaii;

--
-- Name: nomctes(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.nomctes(integer) OWNER TO aaii;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO aaii;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO aaii;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO aaii;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO aaii;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nomtipcta(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO aaii;

--
-- Name: nroastc(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nroastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_numero from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.nroastc(integer) OWNER TO aaii;

--
-- Name: nrotalon(integer, integer, character varying, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION nrotalon(integer, integer, character varying, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	modo		ALIAS FOR $4; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
    talonario:=0;
    select comp_talon into talonario from comprob where int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_talon into talonario from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_talon into talonario from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

    if int4ne(talonario,0) then
	select tal_valor into retval from talon where int4eq(talonario,tal_id);
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.nrotalon(integer, integer, character varying, integer) OWNER TO aaii;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO aaii;

--
-- Name: ocdegasto(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ocdegasto(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	idgto		 ALIAS FOR $1; 
	retval		 integer;
BEGIN
    select gxo_idoc into retval from gtoxoc where gxo_idgto=idgto;
    RETURN retval;
END;$_$;


ALTER FUNCTION public.ocdegasto(integer) OWNER TO aaii;

--
-- Name: operash(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION operash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_operad from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.operash(integer) OWNER TO aaii;

--
-- Name: paso_comprop(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION paso_comprop(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	operador	 integer;
	idclq		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	tipo		 integer;
	genint		 integer;
	cargo		 integer;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
    if not found then
	select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('IDUF',vari_codigo);
	end if;
    end if;


    for regis in select * from comprop where cmpr_centro=centro and cmpr_estado=1 and cmpr_cargo!= cargo 
	loop
	    select car_genint into genint from cargos where car_id=regis.cmpr_cargo;
	    if int4eq(genint,1) then
		insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq) 
		    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
	    else
		if int4eq(genint,2) then
		    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
		else
		    if int4eq(genint,3) then
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
			    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.clq_leyen,regis.cmpr_canti,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
		    end if;
		end if;
	    end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_comprop(integer) OWNER TO aaii;

--
-- Name: paso_cvar(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION paso_cvar(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	rtv		 integer;
	operador	 integer;
	regi		 record;
	estado		 integer;
	importe		 numeric(15,2);
	impcobr		 numeric(15,2);
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    for regi in select clq_id,clq_importe,clq_impngi,clq_interes,clq_idcopr from compliq where clq_centro=centro and clq_anio=anio and clq_mes=mes and clq_estado=1 and (clq_rubcar!=7 or (clq_rubcar=7 and (clq_importe>0 or clq_interes>0 or clq_impngi>0))) and clq_idliq is null
	loop
	    update compliq set clq_idliq=idliq where clq_id=regi.clq_id;
	end loop;
    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_cvar(integer) OWNER TO aaii;

--
-- Name: paso_cvar_neg(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION paso_cvar_neg(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	rtv		 integer;
	operador	 integer;
	idastoh		 integer;
	astcid		 integer;
	regi		 record;
	estado		 integer;
	importe		 numeric(15,2);
	impcobr		 numeric(15,2);
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select ash_id into idastoh from astoh where ash_idemiti=idliq and ash_centro=centro and ash_comprob=comprob and ash_numero=numero;

    for regi in select clq_id,clq_importe,clq_impngi,clq_interes,clq_idcopr from compliq where clq_centro=centro and clq_anio=anio and clq_mes=mes and clq_estado in (1,2) and (clq_rubcar!=7 and (clq_importe<0 or clq_impngi<0 or clq_interes<0)) and clq_idliq=idliq
	loop
	    select astc_id into astcid from astoctas where astc_idastoh=idastoh and astc_tipcta=99 and astc_ctacte=regi.clq_idcopr;
	    if not found then
		astcid:=-10;
	    end if;
	    if (regi.clq_importe<0) then
		importe:=regi.clq_importe*-1;
		select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
	    else
		if (regi.clq_impngi<0) then
		    importe:=regi.clq_impngi*-1;
		    select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
		else
		    if (regi.clq_interes<0) then
			importe:=regi.clq_interes*-1;
			select imputocobranza(regi.clq_idcopr,importe,astcid) into rtv;
		    end if;
		end if;
	    end if;
	end loop;
    RETURN;
    END;$_$;


ALTER FUNCTION public.paso_cvar_neg(integer) OWNER TO aaii;

--
-- Name: paso_sgto(integer, integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION paso_sgto(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		 ALIAS FOR $1; 
	idgto		 ALIAS FOR $2; 
	sgto		 integer;
	idfp		 integer;
	retval 		 integer;
	impfp 		 numeric;
	regi		 record;
    BEGIN
    retval:=1;
	select gxo_idsgto into sgto from gtoxoc where gxo_idgto=idgto;
	for regi in select * from astoctas where astc_idastoh=idastoh and astc_importe<0 
	    loop
		impfp=regi.astc_importe*-1;
		select fp_id into idfp from formapagooc where fp_estado=100 and fp_idocsg=sgto and fp_ctacble=regi.astc_ctacble and fp_importe=impfp;
		if (idfp is not null) then
		    update formapagooc set fp_estado=2 where fp_id=idfp;
		    update ocsingtos set osg_impag=osg_impag-impfp,osg_estado=2 where osg_id=sgto;
		else
		    select fp_id into idfp from formapagooc where fp_estado=100 and fp_idocsg=sgto and fp_ctacble=regi.astc_ctacble and numeric_gt(fp_importe,impfp) limit 1;
		    update formapagooc set fp_estado=2 where fp_id=idfp;
		    update ocsingtos set osg_impag=osg_impag-impfp,osg_estado=2 where osg_id=sgto;
		end if;
	    end loop;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.paso_sgto(integer, integer) OWNER TO aaii;

--
-- Name: prorrata(integer); Type: FUNCTION; Schema: public; Owner: frola
--

CREATE FUNCTION prorrata(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	operador	 integer;
	idclq		 integer;
	tipo		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	genint		 integer;
	tipouf		 integer;
	idcopr		 integer;
	importe		 numeric(15,2);
	registro	 record;
	regi		 record;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 


    for registro in select * from compliquid where cl_idliq=idliq
	loop
	select car_srubcar into srubcar from cargos where car_id=registro.cl_cargo;
	tipo:=registro.cl_tipo;
	if(int4eq(tipo,1)) then 
	    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2)
		loop
		    if int4eq(registro.cl_porc,1) then
			importe:=registro.cl_importe * regi.cop_porc1 / 100;
		    else
			if int4eq(registro.cl_porc,2) then
			    importe:=registro.cl_importe * regi.cop_porc2 / 100;
		        else
			    if int4eq(registro.cl_porc,3) then
				importe:=registro.cl_importe * regi.cop_porc3 / 100;
			    else
				if int4eq(registro.cl_porc,4) then
				    importe:=registro.cl_importe * regi.cop_porc4 / 100;
			        else
				    if int4eq(registro.cl_porc,5) then
					importe:=registro.cl_importe * regi.cop_porc5 / 100;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		    if numeric_ne(importe,0) then
			select car_genint into genint from cargos where car_id=registro.cl_cargo;
			if int4eq(genint,1) then
			    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			else
			    if int4eq(genint,2) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,3) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				end if;
			    end if;
			end if;
		    end if;
		    importe:=0;
		end loop;
	else
	    if(int4eq(tipo,2)) then 
		importe:=registro.cl_importe;
		for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2)
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
	    else
		if(int4eq(tipo,3)) then
		importe:=registro.cl_importe;
		tipouf:=registro.cl_tipuf;
		for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2) and cop_tipuf=tipouf
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
		end if;
	    end if;
	end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.prorrata(integer) OWNER TO frola;

--
-- Name: prorratados(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION prorratados(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	contr		 integer;
	operador	 integer;
	idclq		 integer;
	tipo		 integer;
	estado		 integer;
	impcobr		 numeric(15,2);
	genint		 integer;
	tipouf		 integer;
	idcopr		 integer;
	precio		 numeric(15,2);
	importe		 numeric(15,2);
	impaux		 numeric(15,2);
	cargo		 integer;
	cargoMayores	 integer;
	cargoMenores	 integer;
	registro	 record;
	regi		 record;
	reg		 record;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'CARGOMAYOR') into cargoMayores;
    select valvaramb(codemp,idptov,'CARGOMENOR') into cargoMenores;

    for registro in select * from compliquid where cl_idliq=idliq and cl_tipo in (1,2,3,5) 
	loop
	select car_srubcar into srubcar from cargos where car_id=registro.cl_cargo;
	tipo:=registro.cl_tipo;
	cargo:=registro.cl_cargo;
	if(int4eq(tipo,1)) then 
	    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2)
		loop
		    if int4eq(registro.cl_porc,1) then
			importe:=registro.cl_importe * regi.cop_porc1 / 100;
		    else
			if int4eq(registro.cl_porc,2) then
			    importe:=registro.cl_importe * regi.cop_porc2 / 100;
		        else
			    if int4eq(registro.cl_porc,3) then
				importe:=registro.cl_importe * regi.cop_porc3 / 100;
			    else
				if int4eq(registro.cl_porc,4) then
				    importe:=registro.cl_importe * regi.cop_porc4 / 100;
			        else
				    if int4eq(registro.cl_porc,5) then
					importe:=registro.cl_importe * regi.cop_porc5 / 100;
				    end if;
				end if;
			    end if;
			end if;
		    end if;
		    impaux:=importe;
--		    importe:=round(impaux);
		    if numeric_ne(importe,0) then
			select car_genint into genint from cargos where car_id=registro.cl_cargo;
			if int4eq(genint,1) then
			    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			else
			    if int4eq(genint,2) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,3) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				end if;
			    end if;
			end if;
		    end if;
		    importe:=0;
		end loop;
	else
	    if(int4eq(tipo,2)) then 
		importe:=registro.cl_importe;
		for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2)
		    loop
			if numeric_ne(importe,0) then
			    select car_genint into genint from cargos where car_id=registro.cl_cargo;
			    if int4eq(genint,1) then
				insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
				    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
			    else
				if int4eq(genint,2) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,3) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    end if;
				end if;
			    end if;
			end if;
		    end loop;
	    else
		if(int4eq(tipo,3)) then
		    importe:=registro.cl_importe;
		    tipouf:=registro.cl_tipuf;
		    for regi in select * from coprop where cop_centro=centro and numeric_gt(cop_porc1,0) and cop_estado in (1,2) and cop_tipuf=tipouf
			loop
			    if numeric_ne(importe,0) then
				select car_genint into genint from cargos where car_id=registro.cl_cargo;
				if int4eq(genint,1) then
				    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
					values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				else
				    if int4eq(genint,2) then
					insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_impngi,clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
				    else
					if int4eq(genint,3) then
					    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_interes,clq_idcopr,clq_idliq)
						values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,importe,importe,regi.cop_id,idliq);
					end if;
				    end if;
				end if;
			    end if;
			end loop;
		else
		    if(int4eq(tipo,5) and int4eq(cargo,cargoMayores)) then
			precio:=registro.cl_importe;
			for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
			    loop
				select ct_id into contr from contratos where ct_idcopr=regi.cop_id and ct_estado=1;
				if not found then
				    for reg in select count(*) as canti from grupof_d where gf_idcopr=regi.cop_id and gf_estado=1 and gf_mayor=1 and gf_idptov=idptov 
					loop
					    importe:=precio*reg.canti;
					    if(numeric_gt(importe,0))then
						insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
						    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
					    end if;
					    importe:=0;
					end loop;
				else
				    for reg in select count(*) as canti from grupof_inq where gf_idcopr=regi.cop_id and gf_estado=1 and gf_mayor=1 and gf_idptov=idptov 
					loop
					    importe:=precio*reg.canti;
					    if(numeric_gt(importe,0))then
						insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
						    values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
					    end if;
					    importe:=0;
					end loop;
				end if;
			    end loop;
		    else
			if(int4eq(tipo,5) and int4eq(cargo,cargoMenores)) then
			    precio:=registro.cl_importe;
			    for regi in select * from coprop where cop_centro=centro and cop_estado in (1,2) 
				loop
				    select ct_id into contr from contratos where ct_idcopr=regi.cop_id and ct_estado=1;
				    if not found then
					for reg in select count(*) as canti from grupof_d where gf_idcopr=regi.cop_id and gf_estado=1 and gf_menor=1 and gf_idptov=idptov 
					    loop
						importe:=precio*reg.canti;
						if(numeric_gt(importe,0))then
						    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
							values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
						end if;
						importe:=0;
					    end loop;
				    else
					for reg in select count(*) as canti from grupof_inq where gf_idcopr=regi.cop_id and gf_estado=1 and gf_menor=1 and gf_idptov=idptov 
					    loop
						importe:=precio*reg.canti;
						if(numeric_gt(importe,0))then
						    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_precio,clq_importe,clq_idcopr,clq_idliq)
							values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,reg.canti,precio,importe,regi.cop_id,idliq);
						end if;
						importe:=0;
					    end loop;
				    end if;
				end loop;
			end if;
		    end if;
		end if;
	    end if;
	end if;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.prorratados(integer) OWNER TO aaii;

--
-- Name: proxcodprov(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION proxcodprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select case when max(prov_codigo) is not null then max(prov_codigo)+1 else 1 end from prove where prov_codemp= $1 ;$_$;


ALTER FUNCTION public.proxcodprov(integer) OWNER TO aaii;

--
-- Name: proxnumptv(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION proxnumptv(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
	if int4ne(ptovta,0) then
	    select idcomp(codemp,ptovta,comproba) into otro;
	    select max(ash_numptv)+1 into retval from astoh where int4eq(codemp,ash_codemp) and int4eq(ptovta,ash_idptov) and int4eq(otro,ash_comprob);
	  else
	    retval:= -100;
	end if;
	if(retval is null) then
	retval:= 1;
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.proxnumptv(integer, integer, character varying) OWNER TO aaii;

--
-- Name: pseudoash(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION pseudoash(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_pseudogrupo from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.pseudoash(integer) OWNER TO aaii;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO aaii;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO aaii;

--
-- Name: redondeoliqui(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION redondeoliqui(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	perim		 integer;
	peria		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	redondeo	 integer;
	identificador	 integer;
	rubro		 integer;
	cargo		 integer;
	iduf		 integer;
	srubro		 integer;
	idclq		 integer;
	leyenda		 character varying(240);
	rubrod		 integer;
	srubrod		 integer;
	leyendad	 character varying(240);
	identif		 numeric(15,2);
	total		 numeric(15,2);
	deuda		 numeric(15,2);
	redo		 numeric(15,2);
	redop		 numeric(15,2);
	totalt		 numeric(15,2);
	retval 		 integer;
	regi		 record;
    BEGIN
	retval:=0;
	select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador,l_perim,l_peria 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,perim,peria from liquidacion where l_id=idliq; 

	select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	if not found then
	    select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	    if not found then
		select vari_valor into cargo from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('REDONDEO',vari_codigo);
	    end if;
	end if;
	select car_rubcar, car_srubcar, car_leyen into rubro, srubro, leyenda from cargos where car_id=cargo;

	select vari_valor into iduf from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	if not found then
	    select vari_valor into iduf from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('IDUF',vari_codigo);
	    if not found then
		select vari_valor into iduf from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq('IDUF',vari_codigo);
	    end if;
	end if;
	select car_rubcar, car_srubcar, car_leyen into rubrod, srubrod, leyendad from cargos where car_id=iduf;


	for regi in select lq_idcopr,sum(lq_importe) as impcop from liqui where lq_idliq=idliq group by 1 
	    loop
		select deudacopropid(regi.lq_idcopr,codemp,idptov) into deuda;
		redo:=regi.impcop+deuda;
		if (numeric_le(redo,0)) then
		    deuda:=0;
		else
		    select round(redo::numeric(15,2),0) into total;
		    totalt:=total-redo;
		    if (numeric_ne(totalt,0)) then
		    --insert compliq totalt y liqui
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,
						clq_anio,clq_mes,clq_fecha,clq_fecvto,
						clq_comprob,clq_numero,clq_operad,
						clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,
						clq_canti,clq_impngi,clq_precio,
						clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,
						    anio,mes,feccie,fecvto,
						    comprob,numero,operador,
						    rubro,srubro,cargo,leyenda,
						    1,totalt,totalt,regi.lq_idcopr,idliq);
			insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,
					    lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
					    values (idliq,regi.lq_idcopr,rubro,cargo,
							1,totalt,totalt,leyenda,1);
		    end if;
		    --paso identificadores pasocomprop(modo2)
		    identif:=0;
		    select cmpr_importe into identif from comprop where cmpr_idcopr=regi.lq_idcopr and cmpr_estado=1 and cmpr_cargo=iduf;
		    if found then 
			insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,
						clq_anio,clq_mes,clq_fecha,clq_fecvto,
						clq_comprob,clq_numero,clq_operad,
						clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,
						clq_canti,clq_impngi,clq_precio,
						clq_idcopr,clq_idliq)
					    values (codemp,idptov,centro,division,
						    anio,mes,feccie,fecvto,
						    comprob,numero,operador,
						    rubrod,srubrod,iduf,leyendad,
						    1,identif,identif,regi.lq_idcopr,idliq);
			insert into liqui (lq_idliq,lq_idcopr,lq_rubcar,lq_cargo,
					    lq_canti,lq_precio,lq_importe,lq_leyen,lq_estado)
					    values (idliq,regi.lq_idcopr,rubrod,iduf,
							1,identif,identif,leyendad,1);
		    end if;
		end if;
	    end loop;

	RETURN retval;
END;$_$;


ALTER FUNCTION public.redondeoliqui(integer) OWNER TO aaii;

--
-- Name: reviso_grupof(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION reviso_grupof(integer) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	feccie		 date;
	minMenor	 integer;
	maxMenor	 integer;
	edad		 integer;
	duracion	 integer;
	regis		 record;
    BEGIN

    select l_codemp,l_idptov,l_feccie 
	into codemp,idptov,feccie from liquidacion where l_id=idliq; 

    select valvaramb(codemp,idptov,'EDADMENORMIN') into minMenor;
    select valvaramb(codemp,idptov,'EDADMENORMAX') into maxMenor;

    edad:=0;
    for regis in select * from grupof_d where gf_mayor is null and gf_estado=1 and gf_fecnac is not null and gf_idptov=idptov 
	loop
	    select date_part('year',age(feccie,regis.gf_fecnac)) into edad;
	    if(edad>=minMenor and edad<maxMenor) then
		update grupof_d set gf_menor=1 where gf_id=regis.gf_id;
	    else
		if(edad>=maxMenor) then
		    update grupof_d set gf_mayor=1,gf_menor=NULL where gf_id=regis.gf_id;
--		else
--		    if(edad<minMenor) then
--			update grupof_d set gf_menor=NULL where gf_id=regis.gf_id;
--		    end if;
		end if;
	    end if;
	end loop;

    edad:=0;
    for regis in select * from grupof_inq where gf_mayor is null and gf_estado=1 and gf_fecnac is not null and gf_idptov=idptov 
	loop
	    select date_part('year',age(feccie,regis.gf_fecnac)) into edad;
	    if(edad>=minMenor and edad<maxMenor) then
		update grupof_inq set gf_menor=1 where gf_id=regis.gf_id;
	    else
		if(edad>=maxMenor) then
		    update grupof_inq set gf_mayor=1,gf_menor=NULL where gf_id=regis.gf_id;
--		else
--		    if(edad<minMenor) then
--			update grupof_inq set gf_menor=NULL where gf_id=regis.gf_id;
--		    end if;
		end if;
	    end if;
	end loop;

    for regis in select * from contratos where ct_inicio<=feccie and ct_fin>=feccie and ct_idptov=idptov 
	loop
	    select (date_part('year',age(feccie,regis.ct_inicio))*12 + date_part('month',age(feccie,regis.ct_inicio))) into duracion;
	    duracion:=duracion+1;
	    update contratos set ct_duracion=duracion,ct_estado=1 where ct_id=regis.ct_id;
	end loop;

    for regis in select * from contratos where (ct_fin<feccie or ct_inicio>feccie) and ct_idptov=idptov 
	loop
	    update contratos set ct_estado=9 where ct_id=regis.ct_id;
	    update grupof_inq set gf_estado=999 where gf_idcontr=regis.ct_id;
	end loop;

    RETURN;
    END;$_$;


ALTER FUNCTION public.reviso_grupof(integer) OWNER TO aaii;

--
-- Name: saldocbl(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION saldocbl(integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	cuenta		ALIAS FOR $3; 
	fechad		ALIAS FOR $4;
	retval 		numeric;
    BEGIN
    if int4eq(codemp,-1) then
	    select sum(astc_importe) into retval from astoctas 
		where astc_ctacble=cuenta and astc_fecval< fechad and astc_estado=2 and codcomp(astc_comprob)!='AR' and codptv(astc_idptov)!=9999;
        else
	    if int4eq(ptovta,0) then
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_ctacble=cuenta 
			    and astc_estado=2 and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval< fechad and codptv(astc_idptov)!=9999;
    		else
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_idptov=ptovta  
			    and astc_ctacble=cuenta and astc_estado=2 and codcomp(astc_comprob) not in ('AR','Ar') 
			    and astc_fecval< fechad  and codptv(astc_idptov)!=9999;
	    end if;
    end if;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldocbl(integer, integer, integer, date) OWNER TO estlm;

--
-- Name: salgrup(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: estlm
--

CREATE FUNCTION salgrup(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	tipcta		ALIAS FOR $2;
	ctacte		ALIAS FOR $3;
	grupo		ALIAS FOR $4;
	esisti		integer;
	retval 		numeric;
    BEGIN
    if int4eq(grupo,0) then
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo is null;
	else
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo=grupo;
    end if;

    if not found then
	retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.salgrup(integer, integer, integer, integer) OWNER TO estlm;

--
-- Name: tabladin(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION tabladin(integer) RETURNS character
    LANGUAGE sql
    AS $_$select dlq_tabla from descripliq where dlq_id= $1 ;$_$;


ALTER FUNCTION public.tabladin(integer) OWNER TO aaii;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO aaii;

--
-- Name: tipprove(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION tipprove(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_tipo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.tipprove(integer) OWNER TO aaii;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO aaii;

--
-- Name: totenchq(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION totenchq(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(chq_importe)::numeric(15,2) 
    from cheques where chq_idastoc= $1 ;$_$;


ALTER FUNCTION public.totenchq(integer) OWNER TO aaii;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO aaii;

--
-- Name: ultcie(integer); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION ultcie(integer) RETURNS date
    LANGUAGE sql
    AS $_$select l_feccie from liquidacion where l_estado=1 and l_centro= $1 order by 1 desc limit 1;$_$;


ALTER FUNCTION public.ultcie(integer) OWNER TO aaii;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: aaii
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select vari_valor into retval from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO aaii;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: amenity; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE amenity (
    am_id integer NOT NULL,
    am_codemp integer NOT NULL,
    am_idptov integer NOT NULL,
    am_division integer NOT NULL,
    am_centro integer NOT NULL,
    am_nombre character varying(150) NOT NULL,
    am_cargo integer NOT NULL,
    am_descripcion text,
    am_duracion numeric,
    am_cantidad numeric,
    am_precio numeric(15,2),
    am_color character varying(7),
    am_img bytea,
    am_estado integer DEFAULT 1
);


ALTER TABLE amenity OWNER TO aaii;

--
-- Name: amenity_am_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE amenity_am_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE amenity_am_id_seq OWNER TO aaii;

--
-- Name: amenity_am_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE amenity_am_id_seq OWNED BY amenity.am_id;


SET default_with_oids = true;

--
-- Name: articvta; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codigo smallint,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_stock numeric(15,5),
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_present numeric(15,5),
    art_peso numeric(15,5),
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_idptov integer DEFAULT 0 NOT NULL,
    art_precio_unique numeric(15,5),
    art_codemp integer DEFAULT 0 NOT NULL,
    art_codi character varying(20),
    art_nombre character varying(140),
    art_leyen text,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codsrb integer,
    art_codcbl integer,
    art_funcion text,
    art_precio numeric(15,5) DEFAULT 0,
    art_idcbl integer
);


ALTER TABLE articvta OWNER TO aaii;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE articvta_art_id_seq OWNER TO aaii;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


SET default_with_oids = false;

--
-- Name: astcconccble; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE astcconccble (
    accb_id integer NOT NULL,
    accb_idccbl integer NOT NULL,
    accb_idastc integer NOT NULL,
    accb_estado integer DEFAULT 1
);


ALTER TABLE astcconccble OWNER TO aaii;

--
-- Name: astcconccble_accb_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE astcconccble_accb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astcconccble_accb_id_seq OWNER TO aaii;

--
-- Name: astcconccble_accb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE astcconccble_accb_id_seq OWNED BY astcconccble.accb_id;


SET default_with_oids = true;

--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer NOT NULL,
    astc_division integer,
    astc_centro integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(15,2) DEFAULT 0,
    astc_cotiza numeric(15,5) DEFAULT 0,
    astc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(15,5),
    astc_leyen character varying(100),
    astc_idashce integer,
    astc_idgto integer
);


ALTER TABLE astoctas OWNER TO aaii;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoctas_astc_id_seq OWNER TO aaii;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer NOT NULL,
    ash_division integer,
    ash_centro integer,
    ash_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    ash_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer,
    ash_numptv integer,
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date,
    ash_titulo character varying(200),
    ash_idasoc integer,
    ash_pseudogrupo integer,
    ash_nro2 integer
);


ALTER TABLE astoh OWNER TO aaii;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE astoh_ash_id_seq OWNER TO aaii;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


SET default_with_oids = false;

--
-- Name: auxcop; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE auxcop (
    aux_id integer NOT NULL,
    aux_idcopr integer NOT NULL,
    aux_tipdocg integer,
    aux_nrodocg character varying(20),
    aux_tipdocp integer,
    aux_nrodocp character varying(20),
    aux_extranjero integer,
    aux_calleo character varying(30),
    aux_numeroo character varying(6),
    aux_pisoo character varying(5),
    aux_deptoo character varying(5),
    aux_sectoro character varying(5),
    aux_torreo character varying(5),
    aux_manzanao character varying(5),
    aux_localio character varying(60),
    aux_provino integer,
    aux_codposo character varying(10),
    aux_callea character varying(30),
    aux_numeroa character varying(6),
    aux_pisoa character varying(5),
    aux_deptoa character varying(5),
    aux_sectora character varying(5),
    aux_torrea character varying(5),
    aux_manzanaa character varying(5),
    aux_localia character varying(60),
    aux_provina integer,
    aux_codposa character varying(10),
    aux_unifuna character varying(6),
    aux_suptot numeric,
    aux_supcub numeric,
    aux_fecreg timestamp without time zone DEFAULT now(),
    aux_estado integer DEFAULT 1 NOT NULL,
    aux_tipcop integer DEFAULT 1 NOT NULL
);


ALTER TABLE auxcop OWNER TO zona;

--
-- Name: auxcop_aux_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE auxcop_aux_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxcop_aux_id_seq OWNER TO zona;

--
-- Name: auxcop_aux_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE auxcop_aux_id_seq OWNED BY auxcop.aux_id;


SET default_with_oids = true;

--
-- Name: auxint; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE auxint (
    ai_id integer NOT NULL,
    ai_idliq integer NOT NULL,
    ai_idcopr integer NOT NULL,
    ai_impgi numeric(15,2) DEFAULT 0,
    ai_impngi numeric(15,2) DEFAULT 0,
    ai_intacu numeric(15,2) DEFAULT 0,
    ai_estado integer DEFAULT 1
);


ALTER TABLE auxint OWNER TO aaii;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE auxint_ai_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE auxint_ai_id_seq OWNER TO aaii;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE auxint_ai_id_seq OWNED BY auxint.ai_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(140) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE bancos OWNER TO aaii;

--
-- Name: cambtitu; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE cambtitu (
    cbt_id integer NOT NULL,
    cbt_codemp integer NOT NULL,
    cbt_idptov integer NOT NULL,
    cbt_division integer,
    cbt_centro integer,
    cbt_unifun integer,
    cbt_idcopr integer NOT NULL,
    cbt_nombre character varying(240) NOT NULL,
    cbt_direcc character varying(240),
    cbt_locali character varying(240),
    cbt_codpos character varying(10),
    cbt_provin integer,
    cbt_telefono character varying(180),
    cbt_mail character varying(180),
    cbt_fecha date DEFAULT date(now()),
    cbt_tipdoc character varying(10),
    cbt_nrodoc integer,
    cbt_nrcuit character varying(20),
    cbt_leyen text,
    cbt_operador integer
);


ALTER TABLE cambtitu OWNER TO aaii;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE cambtitu_cbt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cambtitu_cbt_id_seq OWNER TO aaii;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE cambtitu_cbt_id_seq OWNED BY cambtitu.cbt_id;


--
-- Name: cargos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE cargos (
    car_id integer NOT NULL,
    car_codemp integer DEFAULT 0 NOT NULL,
    car_idptov integer,
    car_division integer,
    car_centro integer,
    car_codigo integer,
    car_nombre character varying(340),
    car_rubcar integer,
    car_srubcar integer,
    car_genint integer DEFAULT 1 NOT NULL,
    car_interes numeric(15,5) DEFAULT 1,
    car_precio numeric(15,5) DEFAULT 0,
    car_tasa numeric(15,5) DEFAULT 0,
    car_estado integer DEFAULT 1,
    car_funcion text,
    car_leyen text,
    car_ctacble integer NOT NULL
);


ALTER TABLE cargos OWNER TO aaii;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE cargos_car_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cargos_car_id_seq OWNER TO aaii;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE cargos_car_id_seq OWNED BY cargos.car_id;


--
-- Name: categincid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE categincid (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(150) NOT NULL,
    cat_estado integer DEFAULT 1
);


ALTER TABLE categincid OWNER TO aaii;

--
-- Name: categincid_cat_codigo_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE categincid_cat_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE categincid_cat_codigo_seq OWNER TO aaii;

--
-- Name: categincid_cat_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE categincid_cat_codigo_seq OWNED BY categincid.cat_codigo;


--
-- Name: catego; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE catego (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(140) NOT NULL
);


ALTER TABLE catego OWNER TO aaii;

--
-- Name: centroc; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE centroc (
    cco_id integer NOT NULL,
    cco_codemp integer NOT NULL,
    cco_idptov integer NOT NULL,
    cco_coddiv integer,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(140),
    cco_porcpro numeric(15,6)
);


ALTER TABLE centroc OWNER TO aaii;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE centroc_cco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE centroc_cco_id_seq OWNER TO aaii;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE centroc_cco_id_seq OWNED BY centroc.cco_id;


--
-- Name: chat; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE chat (
    c_id integer NOT NULL,
    c_message text NOT NULL,
    c_sent timestamp without time zone DEFAULT now() NOT NULL,
    c_recd integer DEFAULT 0 NOT NULL,
    c_from integer,
    c_to integer
);


ALTER TABLE chat OWNER TO aaii;

--
-- Name: chat_c_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE chat_c_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chat_c_id_seq OWNER TO aaii;

--
-- Name: chat_c_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE chat_c_id_seq OWNED BY chat.c_id;


--
-- Name: cheques; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer DEFAULT 0 NOT NULL,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(15,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text,
    chq_idocsg integer
);


ALTER TABLE cheques OWNER TO aaii;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cheques_chq_id_seq OWNER TO aaii;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


--
-- Name: chequesaux; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE chequesaux (
    cqa_grupo integer NOT NULL,
    cqa_idchq integer NOT NULL,
    cqa_id integer NOT NULL
);


ALTER TABLE chequesaux OWNER TO aaii;

--
-- Name: chequesaux_cqa_grupo_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE chequesaux_cqa_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chequesaux_cqa_grupo_seq OWNER TO aaii;

--
-- Name: chequesaux_cqa_grupo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE chequesaux_cqa_grupo_seq OWNED BY chequesaux.cqa_grupo;


--
-- Name: chequesaux_cqa_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE chequesaux_cqa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chequesaux_cqa_id_seq OWNER TO aaii;

--
-- Name: chequesaux_cqa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE chequesaux_cqa_id_seq OWNED BY chequesaux.cqa_id;


--
-- Name: chqrech; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE chqrech (
    chqr_id integer NOT NULL,
    chqr_cliente integer DEFAULT 1,
    chqr_idchq integer,
    chqr_idastoh integer,
    chqr_idastohc integer,
    chqr_texto text,
    chqr_estado smallint DEFAULT 1
);


ALTER TABLE chqrech OWNER TO aaii;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE chqrech_chqr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE chqrech_chqr_id_seq OWNER TO aaii;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE chqrech_chqr_id_seq OWNED BY chqrech.chqr_id;


SET default_with_oids = false;

--
-- Name: cobrxclq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE cobrxclq (
    cxc_id integer NOT NULL,
    cxc_idastoc integer DEFAULT 0 NOT NULL,
    cxc_idclq integer,
    cxc_estado integer,
    cxc_importe numeric(15,5) DEFAULT 0,
    cxc_idcopr integer,
    cxc_fecha date,
    cxc_mes integer,
    cxc_anio integer
);


ALTER TABLE cobrxclq OWNER TO aaii;

--
-- Name: cobrxclq_cxc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE cobrxclq_cxc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cobrxclq_cxc_id_seq OWNER TO aaii;

--
-- Name: cobrxclq_cxc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE cobrxclq_cxc_id_seq OWNED BY cobrxclq.cxc_id;


SET default_with_oids = true;

--
-- Name: compliq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE compliq (
    clq_id integer NOT NULL,
    clq_codemp integer NOT NULL,
    clq_idptov integer NOT NULL,
    clq_division integer,
    clq_centro integer,
    clq_idcopr integer NOT NULL,
    clq_fecha date DEFAULT date(now()),
    clq_fecvto date DEFAULT date(now()),
    clq_anio integer DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    clq_mes integer DEFAULT date_part('month'::text, date(now())) NOT NULL,
    clq_comprob integer,
    clq_numero integer,
    clq_idliq integer,
    clq_rubcar integer NOT NULL,
    clq_cargo integer NOT NULL,
    clq_canti numeric(15,5) DEFAULT 1,
    clq_precio numeric(15,5) DEFAULT 0,
    clq_importe numeric(15,2) DEFAULT 0,
    clq_impngi numeric(15,2) DEFAULT 0,
    clq_interes numeric(15,5) DEFAULT 0,
    clq_estado integer DEFAULT 1,
    clq_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    clq_operad integer,
    clq_leyen text,
    clq_pseudogrupo integer,
    clq_srubcar integer NOT NULL,
    clq_idastoc integer
);


ALTER TABLE compliq OWNER TO aaii;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE compliq_clq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compliq_clq_id_seq OWNER TO aaii;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE compliq_clq_id_seq OWNED BY compliq.clq_id;


--
-- Name: compliquid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE compliquid (
    cl_id integer NOT NULL,
    cl_idliq integer NOT NULL,
    cl_rubcar integer,
    cl_cargo integer,
    cl_porc integer DEFAULT 1 NOT NULL,
    cl_leyen character varying(240),
    cl_importe numeric(15,2) DEFAULT 0,
    cl_estado integer DEFAULT 1 NOT NULL,
    cl_tipo integer DEFAULT 1,
    cl_tipuf integer
);


ALTER TABLE compliquid OWNER TO aaii;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE compliquid_cl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compliquid_cl_id_seq OWNER TO aaii;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE compliquid_cl_id_seq OWNED BY compliquid.cl_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer DEFAULT 0 NOT NULL,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(140),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(15,2) DEFAULT 0
);


ALTER TABLE compra OWNER TO aaii;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE compra_cpra_id_seq OWNER TO aaii;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(140) NOT NULL,
    comp_codemp integer DEFAULT 0 NOT NULL,
    comp_idptov integer DEFAULT 0 NOT NULL,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text
);


ALTER TABLE comprob OWNER TO aaii;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprob_comp_id_seq OWNER TO aaii;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: comprop; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE comprop (
    cmpr_id integer NOT NULL,
    cmpr_codemp integer NOT NULL,
    cmpr_idptov integer NOT NULL,
    cmpr_division integer,
    cmpr_centro integer,
    cmpr_idcopr integer NOT NULL,
    cmpr_rubcar integer NOT NULL,
    cmpr_cargo integer NOT NULL,
    cmpr_canti numeric(15,5) DEFAULT 1,
    cmpr_precio numeric(15,5) DEFAULT 0,
    cmpr_importe numeric(15,2) DEFAULT 0,
    cmpr_estado integer DEFAULT 1,
    cmpr_fecalt date DEFAULT date(now()) NOT NULL,
    cmpr_fecbaj date,
    clq_leyen text,
    cmpr_srubcar integer NOT NULL
);


ALTER TABLE comprop OWNER TO aaii;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE comprop_cmpr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE comprop_cmpr_id_seq OWNER TO aaii;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE comprop_cmpr_id_seq OWNED BY comprop.cmpr_id;


SET default_with_oids = false;

--
-- Name: conccble; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE conccble (
    ccbl_id integer NOT NULL,
    ccbl_ctacble integer NOT NULL,
    ccbl_fecha timestamp without time zone DEFAULT now() NOT NULL,
    ccbl_salant numeric(20,5) DEFAULT 0,
    ccbl_salcon numeric(20,5) DEFAULT 0,
    ccbl_leyen text DEFAULT 0,
    ccbl_operad integer NOT NULL,
    ccbl_estado integer DEFAULT 1,
    ccbl_idptov integer DEFAULT (-1) NOT NULL
);


ALTER TABLE conccble OWNER TO aaii;

--
-- Name: conccble_ccbl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE conccble_ccbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conccble_ccbl_id_seq OWNER TO aaii;

--
-- Name: conccble_ccbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE conccble_ccbl_id_seq OWNED BY conccble.ccbl_id;


SET default_with_oids = true;

--
-- Name: concilia; Type: TABLE; Schema: public; Owner: elm; Tablespace: 
--

CREATE TABLE concilia (
    clia_id integer NOT NULL,
    clia_cte integer NOT NULL,
    clia_fecha timestamp without time zone DEFAULT now() NOT NULL,
    clia_idastcg integer,
    clia_salant numeric(20,5) DEFAULT 0,
    clia_salcon numeric(20,5) DEFAULT 0,
    clia_grav numeric(20,5) DEFAULT 0,
    clia_iva numeric(20,5) DEFAULT 0,
    clia_ngrab numeric(20,5) DEFAULT 0,
    clia_piibb numeric(20,5) DEFAULT 0,
    clia_sircreb numeric(20,5) DEFAULT 0,
    clia_leyd numeric(20,5) DEFAULT 0,
    clia_leyc numeric(20,5) DEFAULT 0,
    clia_operad integer NOT NULL,
    clia_estado integer DEFAULT 1,
    clia_fechacon date
);


ALTER TABLE concilia OWNER TO elm;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE; Schema: public; Owner: elm
--

CREATE SEQUENCE concilia_clia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE concilia_clia_id_seq OWNER TO elm;

--
-- Name: concilia_clia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: elm
--

ALTER SEQUENCE concilia_clia_id_seq OWNED BY concilia.clia_id;


--
-- Name: coniva; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(140) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


ALTER TABLE coniva OWNER TO aaii;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_nombre character varying(140) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE conpag OWNER TO aaii;

--
-- Name: contratos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE contratos (
    ct_id integer NOT NULL,
    ct_idptov integer NOT NULL,
    ct_idcopr integer NOT NULL,
    ct_duracion integer,
    ct_inicio date,
    ct_fin date,
    ct_estado integer DEFAULT 1 NOT NULL,
    ct_inicioreal date,
    ct_modo integer DEFAULT 1
);


ALTER TABLE contratos OWNER TO aaii;

--
-- Name: contratos_ct_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE contratos_ct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contratos_ct_id_seq OWNER TO aaii;

--
-- Name: contratos_ct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE contratos_ct_id_seq OWNED BY contratos.ct_id;


--
-- Name: convenios; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE convenios (
    con_id integer NOT NULL,
    con_codemp integer DEFAULT 0 NOT NULL,
    con_idptov integer NOT NULL,
    con_division integer NOT NULL,
    con_centro integer NOT NULL,
    con_idcopr integer NOT NULL,
    con_comprob integer NOT NULL,
    con_numero integer,
    con_monto numeric(15,5) DEFAULT 0,
    con_fechai date DEFAULT date(now()),
    con_fechaf date DEFAULT date(now()),
    con_cuotas integer DEFAULT 1,
    con_operador integer,
    con_leyen text
);


ALTER TABLE convenios OWNER TO aaii;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE convenios_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE convenios_con_id_seq OWNER TO aaii;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE convenios_con_id_seq OWNED BY convenios.con_id;


--
-- Name: conxclia; Type: TABLE; Schema: public; Owner: elm; Tablespace: 
--

CREATE TABLE conxclia (
    cxlia_id integer NOT NULL,
    cxlia_idclia integer NOT NULL,
    cxlia_idastc integer NOT NULL,
    cxlia_importe numeric(20,5) DEFAULT 0,
    cxlia_estado integer DEFAULT 1
);


ALTER TABLE conxclia OWNER TO elm;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE; Schema: public; Owner: elm
--

CREATE SEQUENCE conxcxlia_cxlia_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conxcxlia_cxlia_id_seq OWNER TO elm;

--
-- Name: conxcxlia_cxlia_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: elm
--

ALTER SEQUENCE conxcxlia_cxlia_id_seq OWNED BY conxclia.cxlia_id;


--
-- Name: coprop; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE coprop (
    cop_id integer NOT NULL,
    cop_codemp integer NOT NULL,
    cop_idptov integer NOT NULL,
    cop_unifun integer NOT NULL,
    cop_nombre character varying(340),
    cop_codaso integer,
    cop_porc1 numeric(15,6),
    cop_porc2 numeric(15,6),
    cop_porc3 numeric(15,6),
    cop_porc4 numeric(15,6),
    cop_porc5 numeric(15,6),
    cop_direcc character varying(160),
    cop_locali character varying(160),
    cop_codpos character varying(10),
    cop_provin integer,
    cop_descuf character varying(160),
    cop_tipuf integer,
    cop_coniva integer,
    cop_nrcuit character varying(20),
    cop_tipdoc character varying(10),
    cop_nrodoc integer,
    cop_grupo integer DEFAULT 1,
    cop_estado integer DEFAULT 1 NOT NULL,
    cop_mail character varying(300) DEFAULT 1,
    cop_inter numeric(15,5) DEFAULT 0,
    cop_recib integer DEFAULT 1,
    cop_centro integer,
    cop_division integer,
    cop_supert numeric(15,5) DEFAULT 0,
    cop_superc numeric(15,5) DEFAULT 0,
    cop_supersc numeric(15,5) DEFAULT 0
);


ALTER TABLE coprop OWNER TO aaii;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE coprop_cop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE coprop_cop_id_seq OWNER TO aaii;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE coprop_cop_id_seq OWNED BY coprop.cop_id;


--
-- Name: cotiza; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


ALTER TABLE cotiza OWNER TO aaii;

--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer DEFAULT 0 NOT NULL,
    cbl_idptov integer DEFAULT 0 NOT NULL,
    cbl_divis integer,
    cbl_centro integer,
    cbl_codigo smallint NOT NULL,
    cbl_nombre character varying(140) NOT NULL,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint,
    cbl_present character varying(100)
);


ALTER TABLE ctacble OWNER TO aaii;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctacble_cbl_id_seq OWNER TO aaii;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctasconv; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ctasconv (
    ctc_id integer NOT NULL,
    ctc_idconv integer NOT NULL,
    ctc_cuota integer DEFAULT 1,
    ctc_fecha date DEFAULT date(now()),
    ctc_importe numeric(15,5) DEFAULT 0,
    ctc_leyen text
);


ALTER TABLE ctasconv OWNER TO aaii;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ctasconv_ctc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctasconv_ctc_id_seq OWNER TO aaii;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ctasconv_ctc_id_seq OWNED BY ctasconv.ctc_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer DEFAULT 0 NOT NULL,
    cte_idptov integer DEFAULT 0 NOT NULL,
    cte_centro integer DEFAULT 0,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(140),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1,
    cte_idtabla integer,
    cte_division integer
);


ALTER TABLE ctes OWNER TO aaii;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ctes_cte_id_seq OWNER TO aaii;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


SET default_with_oids = false;

--
-- Name: descripliq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE descripliq (
    dlq_id integer NOT NULL,
    dlq_descripcion character varying(180) NOT NULL,
    dlq_oblig integer DEFAULT 0,
    dlq_estado integer DEFAULT 1 NOT NULL,
    dlq_tabla character varying(50),
    dlq_campo character varying(50)
);


ALTER TABLE descripliq OWNER TO aaii;

--
-- Name: descripliq_dlq_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE descripliq_dlq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE descripliq_dlq_id_seq OWNER TO aaii;

--
-- Name: descripliq_dlq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE descripliq_dlq_id_seq OWNED BY descripliq.dlq_id;


--
-- Name: dinicial; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE dinicial (
    din_id integer NOT NULL,
    din_idsaldos integer DEFAULT 0 NOT NULL,
    din_iddesc integer
);


ALTER TABLE dinicial OWNER TO aaii;

--
-- Name: dinicial_din_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE dinicial_din_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE dinicial_din_id_seq OWNER TO aaii;

--
-- Name: dinicial_din_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE dinicial_din_id_seq OWNED BY dinicial.din_id;


SET default_with_oids = true;

--
-- Name: division; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE division (
    div_id integer NOT NULL,
    div_codemp integer NOT NULL,
    div_idptov integer NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(140)
);


ALTER TABLE division OWNER TO aaii;

--
-- Name: division_div_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE division_div_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE division_div_id_seq OWNER TO aaii;

--
-- Name: division_div_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE division_div_id_seq OWNED BY division.div_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer DEFAULT 0 NOT NULL,
    doc_idptov integer DEFAULT 0 NOT NULL,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE docum OWNER TO aaii;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE docum_doc_id_seq OWNER TO aaii;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


--
-- Name: emiti; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer NOT NULL,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcliptov integer,
    emi_succli integer,
    emi_nomcli character varying(140),
    emi_conivac smallint,
    emi_nrocuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_zona integer,
    emi_desre numeric(15,2) DEFAULT 0,
    emi_total numeric(15,2) DEFAULT 0,
    emi_retiro integer,
    emi_estado smallint DEFAULT 1,
    emi_leyen text
);


ALTER TABLE emiti OWNER TO aaii;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE emiti_emi_id_seq OWNER TO aaii;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(140) NOT NULL,
    emp_direcc character varying(160),
    emp_locali character varying(160),
    emp_codpos character varying(10),
    emp_provin integer DEFAULT 1,
    emp_pais smallint DEFAULT 200,
    emp_nrcuit character varying(20),
    emp_estado smallint DEFAULT 1,
    emp_tipo smallint DEFAULT 1,
    emp_coniva smallint DEFAULT 1,
    emp_anti date DEFAULT date(now()),
    emp_fecint date,
    emp_grupo integer DEFAULT 1,
    emp_redond smallint DEFAULT 1,
    emp_nomabr character varying(70)
);


ALTER TABLE empresa OWNER TO aaii;

--
-- Name: entidad; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE entidad (
    ent_id integer NOT NULL,
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(140)
);


ALTER TABLE entidad OWNER TO aaii;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE entidad_ent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE entidad_ent_id_seq OWNER TO aaii;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE entidad_ent_id_seq OWNED BY entidad.ent_id;


--
-- Name: estincid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE estincid (
    est_codigo integer NOT NULL,
    est_nombre character varying(150) NOT NULL,
    est_estado integer DEFAULT 1
);


ALTER TABLE estincid OWNER TO aaii;

--
-- Name: estincid_est_codigo_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE estincid_est_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE estincid_est_codigo_seq OWNER TO aaii;

--
-- Name: estincid_est_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE estincid_est_codigo_seq OWNED BY estincid.est_codigo;


--
-- Name: estjud; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE estjud (
    etj_codigo integer NOT NULL,
    etj_nombre character varying(240) NOT NULL
);


ALTER TABLE estjud OWNER TO aaii;

--
-- Name: estjurid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE estjurid (
    est_codigo integer NOT NULL,
    est_nombre character varying(240) NOT NULL,
    est_codemp integer
);


ALTER TABLE estjurid OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: eventos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE eventos (
    evt_id integer NOT NULL,
    evt_codemp integer NOT NULL,
    evt_idptov integer NOT NULL,
    evt_division integer NOT NULL,
    evt_centro integer NOT NULL,
    evt_idcopr integer NOT NULL,
    evt_idamenity integer NOT NULL,
    evt_horad time without time zone,
    evt_horah time without time zone,
    evt_fecha date,
    evt_cantidad numeric,
    evt_estado integer DEFAULT (-1)
);


ALTER TABLE eventos OWNER TO aaii;

--
-- Name: eventos_evt_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE eventos_evt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE eventos_evt_id_seq OWNER TO aaii;

--
-- Name: eventos_evt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE eventos_evt_id_seq OWNED BY eventos.evt_id;


SET default_with_oids = true;

--
-- Name: factpend; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE factpend (
    fap_id integer NOT NULL,
    fap_codemp integer DEFAULT 0 NOT NULL,
    fap_idptov integer DEFAULT 0 NOT NULL,
    fap_division integer DEFAULT 0 NOT NULL,
    fap_centro integer DEFAULT 0 NOT NULL,
    fap_rubro integer NOT NULL,
    fap_subrub integer NOT NULL,
    fap_lecomp character varying(30),
    fap_sucomp integer,
    fap_nucomp integer,
    fap_hayfac integer DEFAULT 1,
    fap_factur character varying(100),
    fap_prove integer,
    fap_nprove character varying(100),
    fap_cuitprov character varying(20),
    fap_coniva integer,
    fap_importe numeric(15,2) DEFAULT 0,
    fap_impag numeric(15,2) DEFAULT 0,
    fap_fecori date,
    fap_fecval date NOT NULL,
    fap_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    fap_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    fap_vencim date,
    fap_proxv date,
    fap_leyen text,
    fap_estado integer DEFAULT 1,
    fap_idgto integer,
    fap_operador integer,
    fap_fecreg timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE factpend OWNER TO aaii;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE factpend_fap_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE factpend_fap_id_seq OWNER TO aaii;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE factpend_fap_id_seq OWNED BY factpend.fap_id;


--
-- Name: firman; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(140) NOT NULL,
    fir_direcc character varying(160),
    fir_locali character varying(160),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE firman OWNER TO aaii;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE firman_fir_id_seq OWNER TO aaii;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


SET default_with_oids = false;

--
-- Name: fondocobrado; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE fondocobrado (
    fc_id integer NOT NULL,
    fc_idptov integer NOT NULL,
    fc_mesb integer,
    fc_aniob integer,
    fc_importe numeric,
    fc_mes integer,
    fc_anio integer,
    fc_idcopr integer,
    fc_cargo integer,
    fc_fecreg timestamp without time zone DEFAULT now(),
    fc_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE fondocobrado OWNER TO zona;

--
-- Name: fondocobrado_fc_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE fondocobrado_fc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE fondocobrado_fc_id_seq OWNER TO zona;

--
-- Name: fondocobrado_fc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE fondocobrado_fc_id_seq OWNED BY fondocobrado.fc_id;


SET default_with_oids = true;

--
-- Name: formapagooc; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE formapagooc (
    fp_id integer NOT NULL,
    fp_idocsg integer NOT NULL,
    fp_codemp integer NOT NULL,
    fp_idptov integer NOT NULL,
    fp_division integer,
    fp_centro integer,
    fp_fecval date NOT NULL,
    fp_ctacble integer NOT NULL,
    fp_moneda smallint DEFAULT 1 NOT NULL,
    fp_valor numeric(15,2) DEFAULT 0,
    fp_cotiza numeric(15,5) DEFAULT 0,
    fp_importe numeric(15,2) DEFAULT 0 NOT NULL,
    fp_tipcta integer,
    fp_ctacte integer,
    fp_nucheq integer DEFAULT 0,
    fp_fecvto date,
    fp_estado smallint DEFAULT 1 NOT NULL,
    fp_tasa numeric(15,5),
    fp_leyen character varying(100),
    fp_idoc integer
);


ALTER TABLE formapagooc OWNER TO aaii;

--
-- Name: formapagooc_fp_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE formapagooc_fp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE formapagooc_fp_id_seq OWNER TO aaii;

--
-- Name: formapagooc_fp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE formapagooc_fp_id_seq OWNED BY formapagooc.fp_id;


--
-- Name: gastos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE gastos (
    gto_id integer NOT NULL,
    gto_idastoh integer NOT NULL,
    gto_codemp integer DEFAULT 0 NOT NULL,
    gto_idptov integer DEFAULT 0 NOT NULL,
    gto_comprob integer NOT NULL,
    gto_numero integer,
    gto_centro integer DEFAULT 0 NOT NULL,
    gto_rubro integer NOT NULL,
    gto_subrub integer NOT NULL,
    gto_lecomp character varying(30),
    gto_sucomp integer,
    gto_nucomp integer,
    gto_fecori date,
    gto_fecval date NOT NULL,
    gto_hayfac integer DEFAULT 1,
    gto_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gto_prove integer,
    gto_nprove character varying(100),
    gto_cuitprov character varying(20),
    gto_coniva integer,
    gto_factur character varying(100),
    gto_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    gto_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    gto_estado integer DEFAULT 1,
    gto_impag numeric(15,2) DEFAULT 0,
    gto_importe numeric(15,2) DEFAULT 0,
    gto_operador integer,
    gto_proxv date,
    gto_leyen text,
    gto_division integer NOT NULL,
    gto_tipgto integer DEFAULT 1 NOT NULL
);


ALTER TABLE gastos OWNER TO aaii;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE gastos_gto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gastos_gto_id_seq OWNER TO aaii;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE gastos_gto_id_seq OWNED BY gastos.gto_id;


--
-- Name: grupof_d; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE grupof_d (
    gf_id integer NOT NULL,
    gf_idptov integer NOT NULL,
    gf_idcopr integer NOT NULL,
    gf_mayor integer,
    gf_menor integer,
    gf_fecnac date,
    gf_nombre character varying(255) DEFAULT ''::character varying NOT NULL,
    gf_nrodoc character varying(15) DEFAULT ''::character varying NOT NULL,
    gf_tipdoc integer,
    gf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE grupof_d OWNER TO aaii;

--
-- Name: grupof_d_gf_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE grupof_d_gf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupof_d_gf_id_seq OWNER TO aaii;

--
-- Name: grupof_d_gf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE grupof_d_gf_id_seq OWNED BY grupof_d.gf_id;


--
-- Name: grupof_inq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE grupof_inq (
    gf_id integer NOT NULL,
    gf_idptov integer NOT NULL,
    gf_idcopr integer NOT NULL,
    gf_idcontr integer NOT NULL,
    gf_mayor integer,
    gf_menor integer,
    gf_fecnac date,
    gf_nombre character varying(255) DEFAULT ''::character varying NOT NULL,
    gf_nrodoc character varying(15) DEFAULT ''::character varying NOT NULL,
    gf_tipdoc integer,
    gf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE grupof_inq OWNER TO aaii;

--
-- Name: grupof_inq_gf_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE grupof_inq_gf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE grupof_inq_gf_id_seq OWNER TO aaii;

--
-- Name: grupof_inq_gf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE grupof_inq_gf_id_seq OWNED BY grupof_inq.gf_id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(140) NOT NULL
);


ALTER TABLE grupos OWNER TO aaii;

--
-- Name: gtoxliqe; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE gtoxliqe (
    gxl_liqegr integer NOT NULL,
    gxl_gasto integer NOT NULL,
    gxl_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gxl_operador integer,
    eg_leyena text,
    eg_leyen text
);


ALTER TABLE gtoxliqe OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: gtoxoc; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE gtoxoc (
    gxo_id integer NOT NULL,
    gxo_idgto integer NOT NULL,
    gxo_idoc integer NOT NULL,
    gxo_idsgto integer
);


ALTER TABLE gtoxoc OWNER TO aaii;

--
-- Name: gtoxoc_gxo_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE gtoxoc_gxo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gtoxoc_gxo_id_seq OWNER TO aaii;

--
-- Name: gtoxoc_gxo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE gtoxoc_gxo_id_seq OWNED BY gtoxoc.gxo_id;


SET default_with_oids = true;

--
-- Name: honorarios; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE honorarios (
    hon_id integer NOT NULL,
    hon_codemp integer DEFAULT 1 NOT NULL,
    hon_idptov integer DEFAULT 0 NOT NULL,
    hon_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    hon_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    hon_rubro integer,
    hon_subrub integer,
    hon_centroc integer DEFAULT 1 NOT NULL,
    hon_importe numeric(15,5) DEFAULT 0,
    hon_estado integer DEFAULT 1,
    hon_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    hon_fecgrab timestamp without time zone,
    hon_comprob integer,
    hon_sucu integer,
    hon_ccadm integer NOT NULL,
    hon_division integer DEFAULT 0 NOT NULL
);


ALTER TABLE honorarios OWNER TO aaii;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE honorarios_hon_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE honorarios_hon_id_seq OWNER TO aaii;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE honorarios_hon_id_seq OWNED BY honorarios.hon_id;


--
-- Name: imgincid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE imgincid (
    img_codigo integer NOT NULL,
    img_idinc integer NOT NULL,
    img_file bytea
);


ALTER TABLE imgincid OWNER TO aaii;

--
-- Name: imgincid_img_codigo_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE imgincid_img_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE imgincid_img_codigo_seq OWNER TO aaii;

--
-- Name: imgincid_img_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE imgincid_img_codigo_seq OWNED BY imgincid.img_codigo;


--
-- Name: importoliq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE importoliq (
    imp_id integer NOT NULL,
    imp_codemp integer NOT NULL,
    imp_idptov integer NOT NULL,
    imp_division integer,
    imp_centro integer,
    imp_anio integer DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    imp_mes integer DEFAULT date_part('month'::text, date(now())) NOT NULL,
    imp_estado integer DEFAULT (-1)
);


ALTER TABLE importoliq OWNER TO aaii;

--
-- Name: importoliq_imp_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE importoliq_imp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE importoliq_imp_id_seq OWNER TO aaii;

--
-- Name: importoliq_imp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE importoliq_imp_id_seq OWNED BY importoliq.imp_id;


--
-- Name: incidencias; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE incidencias (
    in_id integer NOT NULL,
    in_codemp integer NOT NULL,
    in_idptov integer NOT NULL,
    in_idcopr integer,
    in_asunto text,
    in_visibilidad integer,
    in_categoria integer,
    in_estado integer DEFAULT 1,
    in_codigo integer NOT NULL,
    in_anio integer NOT NULL,
    in_fechaest date,
    in_mail text
);


ALTER TABLE incidencias OWNER TO aaii;

--
-- Name: incidencias_in_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE incidencias_in_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE incidencias_in_id_seq OWNER TO aaii;

--
-- Name: incidencias_in_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE incidencias_in_id_seq OWNED BY incidencias.in_id;


SET default_with_oids = false;

--
-- Name: infdep; Type: TABLE; Schema: public; Owner: zona; Tablespace: 
--

CREATE TABLE infdep (
    inf_id integer NOT NULL,
    inf_idptov integer NOT NULL,
    inf_idcopr integer NOT NULL,
    inf_fecdep date,
    inf_importe numeric,
    inf_banco integer,
    inf_mail text,
    inf_accion integer,
    inf_fecreg timestamp without time zone DEFAULT now(),
    inf_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE infdep OWNER TO zona;

--
-- Name: infdep_inf_id_seq; Type: SEQUENCE; Schema: public; Owner: zona
--

CREATE SEQUENCE infdep_inf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE infdep_inf_id_seq OWNER TO zona;

--
-- Name: infdep_inf_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: zona
--

ALTER SEQUENCE infdep_inf_id_seq OWNED BY infdep.inf_id;


--
-- Name: interes; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer DEFAULT 0 NOT NULL,
    int_idptov integer DEFAULT 0 NOT NULL,
    int_centro integer NOT NULL,
    int_division integer,
    int_fecha date NOT NULL,
    int_valor numeric(15,5) DEFAULT 0,
    int_tipo integer DEFAULT 1 NOT NULL
);


ALTER TABLE interes OWNER TO aaii;

SET default_with_oids = true;

--
-- Name: judicial; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE judicial (
    jud_id integer NOT NULL,
    jud_codemp integer NOT NULL,
    jud_idptov integer NOT NULL,
    jud_division integer,
    jud_centro integer,
    jud_idcopr integer NOT NULL,
    jud_ejcod integer,
    jud_fecha date DEFAULT date(now()),
    jud_deuda numeric(15,2) DEFAULT 0,
    jud_gasto numeric(15,2) DEFAULT 0,
    jud_reintg integer DEFAULT 1,
    jud_estado integer DEFAULT 1,
    jud_estudio integer,
    jud_leyen text,
    jud_operador integer
);


ALTER TABLE judicial OWNER TO aaii;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE judicial_jud_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE judicial_jud_id_seq OWNER TO aaii;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE judicial_jud_id_seq OWNED BY judicial.jud_id;


--
-- Name: liqegr; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE liqegr (
    eg_id integer NOT NULL,
    eg_idastoh integer NOT NULL,
    eg_codemp integer DEFAULT 0 NOT NULL,
    eg_idptov integer DEFAULT 0 NOT NULL,
    eg_centro integer DEFAULT 0 NOT NULL,
    eg_rubro integer NOT NULL,
    eg_subrub integer NOT NULL,
    eg_hayfac integer DEFAULT 1,
    eg_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    eg_prove integer,
    eg_nprove character varying(100),
    eg_cuitprov character varying(20),
    eg_factur character varying(100),
    eg_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    eg_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    eg_estado integer DEFAULT 1,
    eg_impag numeric(15,2) DEFAULT 0,
    eg_importe numeric(15,2) DEFAULT 0,
    eg_operador integer,
    eg_leyen text,
    eg_division integer DEFAULT 0 NOT NULL,
    eg_tipgto integer DEFAULT 1 NOT NULL
);


ALTER TABLE liqegr OWNER TO aaii;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE liqegr_eg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liqegr_eg_id_seq OWNER TO aaii;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE liqegr_eg_id_seq OWNED BY liqegr.eg_id;


--
-- Name: liqui; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE liqui (
    lq_id integer NOT NULL,
    lq_idliq integer NOT NULL,
    lq_idcopr integer NOT NULL,
    lq_rubcar integer,
    lq_cargo integer,
    lq_canti numeric(15,5) DEFAULT 1,
    lq_precio numeric(15,5) DEFAULT 1,
    lq_importe numeric(15,2) DEFAULT 0,
    lq_leyen text,
    lq_estado integer
);


ALTER TABLE liqui OWNER TO aaii;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE liqui_lq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liqui_lq_id_seq OWNER TO aaii;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE liqui_lq_id_seq OWNED BY liqui.lq_id;


--
-- Name: liquidacion; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE liquidacion (
    l_id integer NOT NULL,
    l_codemp integer NOT NULL,
    l_idptov integer DEFAULT 0 NOT NULL,
    l_division integer,
    l_centro integer DEFAULT 0 NOT NULL,
    l_anio integer NOT NULL,
    l_mes integer NOT NULL,
    l_perim integer NOT NULL,
    l_peria integer NOT NULL,
    l_feccie date NOT NULL,
    l_fecvto date NOT NULL,
    l_comprob integer NOT NULL,
    l_numero integer NOT NULL,
    l_estado integer DEFAULT 1 NOT NULL,
    l_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    l_operador integer NOT NULL
);


ALTER TABLE liquidacion OWNER TO aaii;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE liquidacion_l_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE liquidacion_l_id_seq OWNER TO aaii;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE liquidacion_l_id_seq OWNED BY liquidacion.l_id;


SET default_with_oids = false;

--
-- Name: logosptv; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE logosptv (
    lpt_idptov integer NOT NULL,
    lpt_tipo integer DEFAULT 1 NOT NULL,
    lpt_estado integer DEFAULT 1 NOT NULL,
    lpt_img bytea,
    lpt_archivo integer DEFAULT 1,
    lpt_link character varying(500),
    lpt_id integer NOT NULL
);


ALTER TABLE logosptv OWNER TO aaii;

--
-- Name: logosptv_lpt_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE logosptv_lpt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logosptv_lpt_id_seq OWNER TO aaii;

--
-- Name: logosptv_lpt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE logosptv_lpt_id_seq OWNED BY logosptv.lpt_id;


--
-- Name: menues; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE menues (
    men_id integer NOT NULL,
    men_titulo text NOT NULL,
    men_tipo smallint DEFAULT 1,
    men_idmenu integer,
    men_estado smallint DEFAULT 1,
    men_alias text
);


ALTER TABLE menues OWNER TO aaii;

--
-- Name: menues_men_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE menues_men_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE menues_men_id_seq OWNER TO aaii;

--
-- Name: menues_men_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE menues_men_id_seq OWNED BY menues.men_id;


SET default_with_oids = true;

--
-- Name: modlogs; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE modlogs (
    log_id integer NOT NULL,
    log_idptov integer NOT NULL,
    log_comprob integer NOT NULL,
    log_numero integer NOT NULL,
    log_tabla character varying(30),
    log_idtabla integer DEFAULT 1 NOT NULL,
    log_campo character varying(30),
    log_valant character varying(180),
    log_valpos character varying(180),
    log_fecha timestamp without time zone DEFAULT now() NOT NULL,
    log_operador integer,
    log_cont integer DEFAULT 1,
    log_obs text
);


ALTER TABLE modlogs OWNER TO aaii;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE modlogs_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE modlogs_log_id_seq OWNER TO aaii;

--
-- Name: modlogs_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE modlogs_log_id_seq OWNED BY modlogs.log_id;


--
-- Name: moneda; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(140) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE moneda OWNER TO aaii;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(130),
    mne_valor numeric(15,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE monex OWNER TO aaii;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE monex_mne_id_seq OWNER TO aaii;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_idastoh integer NOT NULL,
    movs_idemiti integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer DEFAULT 0 NOT NULL,
    movs_fecval date,
    movs_artic integer,
    movs_canti numeric(15,5) DEFAULT 0,
    movs_dias numeric(15,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(15,2) DEFAULT 0,
    movs_tasa numeric(15,5) DEFAULT 0,
    movs_peso numeric(15,2) DEFAULT 0,
    movs_volum numeric(15,2) DEFAULT 0,
    movs_entreg numeric(15,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado smallint DEFAULT 1,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer,
    movs_compbte character varying(16)
);


ALTER TABLE movsto OWNER TO aaii;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movsto_movs_id_seq OWNER TO aaii;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: notdeb; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE notdeb (
    nd_id integer NOT NULL,
    nd_idasho integer NOT NULL,
    nd_codemp integer NOT NULL,
    nd_idptov integer,
    nd_fecval date,
    nd_grupo integer,
    nd_codcop integer,
    nd_estado integer DEFAULT 1,
    nd_tpago numeric(15,2) DEFAULT 0,
    nd_tnd numeric(15,2) DEFAULT 0,
    nd_interes numeric(15,2) DEFAULT 0,
    nd_operadb integer
);


ALTER TABLE notdeb OWNER TO aaii;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE notdeb_nd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE notdeb_nd_id_seq OWNER TO aaii;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE notdeb_nd_id_seq OWNED BY notdeb.nd_id;


--
-- Name: noticias; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE noticias (
    not_id integer NOT NULL,
    not_codemp integer DEFAULT 1 NOT NULL,
    not_idptov integer NOT NULL,
    not_titulo character varying(300),
    not_tipo integer,
    not_mes integer,
    not_anio integer,
    not_fechad date,
    not_fechah date,
    not_archivo character varying(300),
    not_estado integer DEFAULT 1
);


ALTER TABLE noticias OWNER TO aaii;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE noticias_not_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE noticias_not_id_seq OWNER TO aaii;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE noticias_not_id_seq OWNED BY noticias.not_id;


--
-- Name: novedades; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE novedades (
    nov_id integer NOT NULL,
    nov_idptov integer NOT NULL,
    nov_idcopr integer DEFAULT 0,
    nov_fechad date,
    nov_fechah date,
    nov_titulo text,
    nov_texto text,
    nov_archivo text,
    nov_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE novedades OWNER TO sanjor;

--
-- Name: novedades_nov_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE novedades_nov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE novedades_nov_id_seq OWNER TO sanjor;

--
-- Name: novedades_nov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE novedades_nov_id_seq OWNED BY novedades.nov_id;


--
-- Name: ocsingtos; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ocsingtos (
    osg_id integer NOT NULL,
    osg_codemp integer DEFAULT 0 NOT NULL,
    osg_idptov integer DEFAULT 0 NOT NULL,
    osg_division integer NOT NULL,
    osg_centro integer DEFAULT 0 NOT NULL,
    osg_rubro integer NOT NULL,
    osg_subrub integer NOT NULL,
    osg_lecomp character varying(30),
    osg_sucomp integer,
    osg_nucomp integer,
    osg_fecori date,
    osg_fecval date NOT NULL,
    osg_hayfac integer DEFAULT 1,
    osg_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    osg_prove integer,
    osg_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    osg_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    osg_estado integer DEFAULT 1,
    osg_importe numeric(15,2) DEFAULT 0,
    osg_operador integer,
    osg_leyen text,
    osg_impag numeric(15,2) DEFAULT 0
);


ALTER TABLE ocsingtos OWNER TO aaii;

--
-- Name: ocsingtos_osg_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ocsingtos_osg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ocsingtos_osg_id_seq OWNER TO aaii;

--
-- Name: ocsingtos_osg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ocsingtos_osg_id_seq OWNED BY ocsingtos.osg_id;


--
-- Name: operadores; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(140) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(140),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count integer DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(290),
    operad_telefono character varying(190),
    operad_codemp integer,
    operad_ptovta integer,
    operad_revision integer DEFAULT 0,
    operad_logued integer DEFAULT 0
);


ALTER TABLE operadores OWNER TO aaii;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operadores_operad_id_seq OWNER TO aaii;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


--
-- Name: operincid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE operincid (
    oi_id integer NOT NULL,
    oi_idinc integer NOT NULL,
    oi_operal integer NOT NULL,
    oi_operasign integer NOT NULL,
    oi_prioridad integer,
    oi_observ text,
    oi_fecha date DEFAULT now(),
    oi_hora time without time zone DEFAULT now(),
    oi_estado integer DEFAULT 1
);


ALTER TABLE operincid OWNER TO aaii;

--
-- Name: operincid_oi_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE operincid_oi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE operincid_oi_id_seq OWNER TO aaii;

--
-- Name: operincid_oi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE operincid_oi_id_seq OWNED BY operincid.oi_id;


--
-- Name: ordencompra; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ordencompra (
    oc_id integer NOT NULL,
    oc_fecha timestamp without time zone DEFAULT now() NOT NULL,
    oc_total numeric(20,5) DEFAULT 0,
    oc_numanio integer,
    oc_numint integer,
    oc_anio integer,
    oc_centro integer,
    oc_operad integer NOT NULL,
    oc_estado integer DEFAULT 1
);


ALTER TABLE ordencompra OWNER TO aaii;

--
-- Name: ordencompra_oc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ordencompra_oc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ordencompra_oc_id_seq OWNER TO aaii;

--
-- Name: ordencompra_oc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ordencompra_oc_id_seq OWNED BY ordencompra.oc_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(140) NOT NULL
);


ALTER TABLE pais OWNER TO aaii;

--
-- Name: priorincid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE priorincid (
    pri_codigo integer NOT NULL,
    pri_nombre character varying(150) NOT NULL,
    pri_estado integer DEFAULT 1
);


ALTER TABLE priorincid OWNER TO aaii;

--
-- Name: priorincid_pri_codigo_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE priorincid_pri_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE priorincid_pri_codigo_seq OWNER TO aaii;

--
-- Name: priorincid_pri_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE priorincid_pri_codigo_seq OWNED BY priorincid.pri_codigo;


--
-- Name: prove; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_nrcuit character varying(20),
    prov_codemp integer DEFAULT 0 NOT NULL,
    prov_idptov integer DEFAULT 0 NOT NULL,
    prov_codigo integer,
    prov_nombre character varying(140),
    prov_direcc character varying(160),
    prov_locali character varying(160),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(160),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE prove OWNER TO aaii;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE prove_prov_id_seq OWNER TO aaii;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(140) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE provin OWNER TO aaii;

--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_codemp integer NOT NULL,
    ptv_codigo integer NOT NULL,
    ptv_nombre character varying(140) NOT NULL,
    ptv_direcc character varying(160),
    ptv_locali character varying(160),
    ptv_codpos character varying(10),
    ptv_provin integer DEFAULT 1,
    ptv_pais smallint DEFAULT 200,
    ptv_nrcuit character varying(20),
    ptv_tipo integer DEFAULT 1,
    ptv_anti date DEFAULT date(now()),
    ptv_fecint integer DEFAULT 15,
    ptv_grupo integer DEFAULT 1,
    ptv_redond integer DEFAULT 1,
    ptv_nomabre character varying(140),
    ptv_estado smallint DEFAULT 1,
    ptv_aplicadesc integer DEFAULT 1,
    ptv_imputacion integer DEFAULT 3 NOT NULL,
    ptv_liqgs integer DEFAULT 0,
    ptv_emppmc integer
);


ALTER TABLE ptovta OWNER TO aaii;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ptovta_ptv_id_seq OWNER TO aaii;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


SET default_with_oids = false;

--
-- Name: relmenu; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE relmenu (
    rmen_id integer NOT NULL,
    rmen_titulo text NOT NULL,
    rmen_link text NOT NULL,
    rmen_tipo smallint DEFAULT 1,
    rmen_idmenu integer,
    rmen_nivel smallint DEFAULT 0,
    rmen_estado smallint DEFAULT 1
);


ALTER TABLE relmenu OWNER TO aaii;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE relmenu_rmen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE relmenu_rmen_id_seq OWNER TO aaii;

--
-- Name: relmenu_rmen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE relmenu_rmen_id_seq OWNED BY relmenu.rmen_id;


SET default_with_oids = true;

--
-- Name: revisliq; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE revisliq (
    rl_id integer NOT NULL,
    rl_idliq integer NOT NULL,
    rl_operador integer,
    rl_operalta integer,
    rl_estado integer DEFAULT 1 NOT NULL,
    rl_pdf integer DEFAULT 0,
    rl_mail integer DEFAULT 0,
    rl_web integer DEFAULT 0
);


ALTER TABLE revisliq OWNER TO aaii;

--
-- Name: revisliq_rl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE revisliq_rl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE revisliq_rl_id_seq OWNER TO aaii;

--
-- Name: revisliq_rl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE revisliq_rl_id_seq OWNED BY revisliq.rl_id;


--
-- Name: rubcar; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE rubcar (
    rubl_id integer NOT NULL,
    rubl_codemp integer DEFAULT 0 NOT NULL,
    rubl_tipo integer DEFAULT 1,
    rubl_codigo integer,
    rubl_nombre character varying(340) NOT NULL
);


ALTER TABLE rubcar OWNER TO aaii;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE rubcar_rubl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubcar_rubl_id_seq OWNER TO aaii;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE rubcar_rubl_id_seq OWNED BY rubcar.rubl_id;


--
-- Name: rubros; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_codemp integer DEFAULT 0 NOT NULL,
    rub_idptov integer DEFAULT 0 NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(140) NOT NULL
);


ALTER TABLE rubros OWNER TO aaii;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE rubros_rub_id_seq OWNER TO aaii;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: scangto; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE scangto (
    sc_id integer NOT NULL,
    sc_idgto integer NOT NULL,
    sc_tipo integer DEFAULT 1,
    sc_estado integer DEFAULT 1 NOT NULL,
    sc_img bytea,
    sc_archivo integer DEFAULT 1
);


ALTER TABLE scangto OWNER TO aaii;

--
-- Name: scangto_sc_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE scangto_sc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE scangto_sc_id_seq OWNER TO aaii;

--
-- Name: scangto_sc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE scangto_sc_id_seq OWNED BY scangto.sc_id;


--
-- Name: seccion; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(140) NOT NULL
);


ALTER TABLE seccion OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: sinicial; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE sinicial (
    sin_id integer NOT NULL,
    sin_idsaldos integer DEFAULT 0 NOT NULL,
    sin_idcargo integer
);


ALTER TABLE sinicial OWNER TO aaii;

--
-- Name: sinicial_sin_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE sinicial_sin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sinicial_sin_id_seq OWNER TO aaii;

--
-- Name: sinicial_sin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE sinicial_sin_id_seq OWNED BY sinicial.sin_id;


SET default_with_oids = true;

--
-- Name: srubcar; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE srubcar (
    srbl_id integer NOT NULL,
    srbl_rubro integer NOT NULL,
    srbl_codigo integer NOT NULL,
    srbl_nombre character varying(340) NOT NULL,
    srbl_precio numeric(15,5) DEFAULT 0,
    srbl_leyen text,
    srbl_codemp integer DEFAULT 1 NOT NULL,
    srbl_idptov integer DEFAULT 0 NOT NULL,
    srbl_genint integer DEFAULT 0 NOT NULL
);


ALTER TABLE srubcar OWNER TO aaii;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE srubcar_srbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE srubcar_srbl_id_seq OWNER TO aaii;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE srubcar_srbl_id_seq OWNED BY srubcar.srbl_id;


--
-- Name: subd; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer DEFAULT 0 NOT NULL,
    subd_idptov integer DEFAULT 0 NOT NULL,
    subd_nombre character varying(140),
    subd_titulo character varying(140),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer
);


ALTER TABLE subd OWNER TO aaii;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subd_subd_id_seq OWNER TO aaii;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subrub; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE subrub (
    srb_id integer NOT NULL,
    srb_rubro integer NOT NULL,
    srb_codemp integer DEFAULT 0 NOT NULL,
    srb_idptov integer DEFAULT 0 NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(140) NOT NULL,
    srb_precio numeric(15,2) DEFAULT 0,
    srb_leyen text,
    srb_codtg smallint DEFAULT 1,
    srb_conper smallint DEFAULT 1,
    srb_tiprub integer,
    srb_cuenta integer
);


ALTER TABLE subrub OWNER TO aaii;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE subrub_srb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE subrub_srb_id_seq OWNER TO aaii;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE subrub_srb_id_seq OWNED BY subrub.srb_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL
);


ALTER TABLE subxcomp OWNER TO aaii;

--
-- Name: sucursal; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE sucursal (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(140) NOT NULL,
    sucu_direcc character varying(160),
    sucu_locali character varying(160),
    sucu_codpos character varying(10),
    sucu_provin integer,
    sucu_pais smallint,
    sucu_repres character varying(240),
    sucu_contacto character varying(240),
    sucu_observ text,
    sucu_direccl character varying(160),
    sucu_localil character varying(160),
    sucu_codposl character varying(10),
    sucu_codprovl integer,
    sucu_paisl smallint
);


ALTER TABLE sucursal OWNER TO aaii;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_idptov integer DEFAULT 0 NOT NULL,
    tal_comprob integer,
    tal_nombre character varying(140) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date,
    tal_codemp integer DEFAULT 0 NOT NULL
);


ALTER TABLE talon OWNER TO aaii;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE talon_tal_id_seq OWNER TO aaii;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: telefon; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(340) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE telefon OWNER TO aaii;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE telefon_tel_id_seq OWNER TO aaii;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(140) NOT NULL
);


ALTER TABLE tipcta OWNER TO aaii;

--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(140) NOT NULL
);


ALTER TABLE tipdocu OWNER TO aaii;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(140) NOT NULL
);


ALTER TABLE tipemp OWNER TO aaii;

--
-- Name: tipempr; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipempr (
    ter_codigo integer NOT NULL,
    ter_nombre character varying(140) NOT NULL
);


ALTER TABLE tipempr OWNER TO aaii;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(140) NOT NULL
);


ALTER TABLE tipentid OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: tipgto; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipgto (
    tg_id integer NOT NULL,
    tg_nombre character varying(150) NOT NULL,
    tg_estado integer DEFAULT 1,
    tg_codemp integer DEFAULT 1 NOT NULL,
    tg_cargo integer DEFAULT 1 NOT NULL,
    tg_porc integer DEFAULT 1 NOT NULL
);


ALTER TABLE tipgto OWNER TO aaii;

--
-- Name: tipgto_tg_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE tipgto_tg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipgto_tg_id_seq OWNER TO aaii;

--
-- Name: tipgto_tg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE tipgto_tg_id_seq OWNED BY tipgto.tg_id;


--
-- Name: tipnot; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipnot (
    tnot_codigo integer NOT NULL,
    tnot_codemp integer DEFAULT 1 NOT NULL,
    tnot_nombre character varying(300)
);


ALTER TABLE tipnot OWNER TO aaii;

SET default_with_oids = true;

--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(140) NOT NULL
);


ALTER TABLE tiptel OWNER TO aaii;

--
-- Name: tipuf; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE tipuf (
    tuf_codigo integer NOT NULL,
    tuf_nombre character varying(140) NOT NULL
);


ALTER TABLE tipuf OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: total; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE total (
    sum numeric
);


ALTER TABLE total OWNER TO aaii;

SET default_with_oids = true;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_nombre character varying(140) NOT NULL,
    uni_coef numeric(15,5),
    uni_simbolo character(3)
);


ALTER TABLE unimed OWNER TO aaii;

SET default_with_oids = false;

--
-- Name: usermenu; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE usermenu (
    umen_id integer NOT NULL,
    umen_operador integer NOT NULL,
    umen_idmenu integer,
    umen_estado smallint DEFAULT 1,
    umen_menufinal integer
);


ALTER TABLE usermenu OWNER TO aaii;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE; Schema: public; Owner: aaii
--

CREATE SEQUENCE usermenu_umen_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE usermenu_umen_id_seq OWNER TO aaii;

--
-- Name: usermenu_umen_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: aaii
--

ALTER SEQUENCE usermenu_umen_id_seq OWNED BY usermenu.umen_id;


SET default_with_oids = true;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(140) NOT NULL,
    var_nombre character varying(140) NOT NULL,
    var_valor character varying(140)
);


ALTER TABLE varamb OWNER TO aaii;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(140) NOT NULL,
    vari_nombre character varying(140) NOT NULL,
    vari_valor character varying(140),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE varambi OWNER TO aaii;

--
-- Name: zona; Type: TABLE; Schema: public; Owner: aaii; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(140) NOT NULL
);


ALTER TABLE zona OWNER TO aaii;

--
-- Name: am_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity ALTER COLUMN am_id SET DEFAULT nextval('amenity_am_id_seq'::regclass);


--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: accb_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astcconccble ALTER COLUMN accb_id SET DEFAULT nextval('astcconccble_accb_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: aux_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY auxcop ALTER COLUMN aux_id SET DEFAULT nextval('auxcop_aux_id_seq'::regclass);


--
-- Name: ai_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY auxint ALTER COLUMN ai_id SET DEFAULT nextval('auxint_ai_id_seq'::regclass);


--
-- Name: cbt_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu ALTER COLUMN cbt_id SET DEFAULT nextval('cambtitu_cbt_id_seq'::regclass);


--
-- Name: car_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cargos ALTER COLUMN car_id SET DEFAULT nextval('cargos_car_id_seq'::regclass);


--
-- Name: cat_codigo; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY categincid ALTER COLUMN cat_codigo SET DEFAULT nextval('categincid_cat_codigo_seq'::regclass);


--
-- Name: cco_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY centroc ALTER COLUMN cco_id SET DEFAULT nextval('centroc_cco_id_seq'::regclass);


--
-- Name: c_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY chat ALTER COLUMN c_id SET DEFAULT nextval('chat_c_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: cqa_grupo; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY chequesaux ALTER COLUMN cqa_grupo SET DEFAULT nextval('chequesaux_cqa_grupo_seq'::regclass);


--
-- Name: cqa_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY chequesaux ALTER COLUMN cqa_id SET DEFAULT nextval('chequesaux_cqa_id_seq'::regclass);


--
-- Name: chqr_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY chqrech ALTER COLUMN chqr_id SET DEFAULT nextval('chqrech_chqr_id_seq'::regclass);


--
-- Name: cxc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cobrxclq ALTER COLUMN cxc_id SET DEFAULT nextval('cobrxclq_cxc_id_seq'::regclass);


--
-- Name: clq_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq ALTER COLUMN clq_id SET DEFAULT nextval('compliq_clq_id_seq'::regclass);


--
-- Name: cl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliquid ALTER COLUMN cl_id SET DEFAULT nextval('compliquid_cl_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: cmpr_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop ALTER COLUMN cmpr_id SET DEFAULT nextval('comprop_cmpr_id_seq'::regclass);


--
-- Name: ccbl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY conccble ALTER COLUMN ccbl_id SET DEFAULT nextval('conccble_ccbl_id_seq'::regclass);


--
-- Name: clia_id; Type: DEFAULT; Schema: public; Owner: elm
--

ALTER TABLE ONLY concilia ALTER COLUMN clia_id SET DEFAULT nextval('concilia_clia_id_seq'::regclass);


--
-- Name: ct_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY contratos ALTER COLUMN ct_id SET DEFAULT nextval('contratos_ct_id_seq'::regclass);


--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios ALTER COLUMN con_id SET DEFAULT nextval('convenios_con_id_seq'::regclass);


--
-- Name: cxlia_id; Type: DEFAULT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia ALTER COLUMN cxlia_id SET DEFAULT nextval('conxcxlia_cxlia_id_seq'::regclass);


--
-- Name: cop_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY coprop ALTER COLUMN cop_id SET DEFAULT nextval('coprop_cop_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: ctc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ctasconv ALTER COLUMN ctc_id SET DEFAULT nextval('ctasconv_ctc_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: dlq_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY descripliq ALTER COLUMN dlq_id SET DEFAULT nextval('descripliq_dlq_id_seq'::regclass);


--
-- Name: din_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY dinicial ALTER COLUMN din_id SET DEFAULT nextval('dinicial_din_id_seq'::regclass);


--
-- Name: div_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY division ALTER COLUMN div_id SET DEFAULT nextval('division_div_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: ent_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY entidad ALTER COLUMN ent_id SET DEFAULT nextval('entidad_ent_id_seq'::regclass);


--
-- Name: est_codigo; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY estincid ALTER COLUMN est_codigo SET DEFAULT nextval('estincid_est_codigo_seq'::regclass);


--
-- Name: evt_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos ALTER COLUMN evt_id SET DEFAULT nextval('eventos_evt_id_seq'::regclass);


--
-- Name: fap_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend ALTER COLUMN fap_id SET DEFAULT nextval('factpend_fap_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: fc_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY fondocobrado ALTER COLUMN fc_id SET DEFAULT nextval('fondocobrado_fc_id_seq'::regclass);


--
-- Name: fp_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY formapagooc ALTER COLUMN fp_id SET DEFAULT nextval('formapagooc_fp_id_seq'::regclass);


--
-- Name: gto_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos ALTER COLUMN gto_id SET DEFAULT nextval('gastos_gto_id_seq'::regclass);


--
-- Name: gf_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY grupof_d ALTER COLUMN gf_id SET DEFAULT nextval('grupof_d_gf_id_seq'::regclass);


--
-- Name: gf_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY grupof_inq ALTER COLUMN gf_id SET DEFAULT nextval('grupof_inq_gf_id_seq'::regclass);


--
-- Name: gxo_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gtoxoc ALTER COLUMN gxo_id SET DEFAULT nextval('gtoxoc_gxo_id_seq'::regclass);


--
-- Name: hon_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY honorarios ALTER COLUMN hon_id SET DEFAULT nextval('honorarios_hon_id_seq'::regclass);


--
-- Name: img_codigo; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY imgincid ALTER COLUMN img_codigo SET DEFAULT nextval('imgincid_img_codigo_seq'::regclass);


--
-- Name: imp_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY importoliq ALTER COLUMN imp_id SET DEFAULT nextval('importoliq_imp_id_seq'::regclass);


--
-- Name: in_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias ALTER COLUMN in_id SET DEFAULT nextval('incidencias_in_id_seq'::regclass);


--
-- Name: inf_id; Type: DEFAULT; Schema: public; Owner: zona
--

ALTER TABLE ONLY infdep ALTER COLUMN inf_id SET DEFAULT nextval('infdep_inf_id_seq'::regclass);


--
-- Name: jud_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial ALTER COLUMN jud_id SET DEFAULT nextval('judicial_jud_id_seq'::regclass);


--
-- Name: eg_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqegr ALTER COLUMN eg_id SET DEFAULT nextval('liqegr_eg_id_seq'::regclass);


--
-- Name: lq_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqui ALTER COLUMN lq_id SET DEFAULT nextval('liqui_lq_id_seq'::regclass);


--
-- Name: l_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liquidacion ALTER COLUMN l_id SET DEFAULT nextval('liquidacion_l_id_seq'::regclass);


--
-- Name: lpt_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY logosptv ALTER COLUMN lpt_id SET DEFAULT nextval('logosptv_lpt_id_seq'::regclass);


--
-- Name: men_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY menues ALTER COLUMN men_id SET DEFAULT nextval('menues_men_id_seq'::regclass);


--
-- Name: log_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY modlogs ALTER COLUMN log_id SET DEFAULT nextval('modlogs_log_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: nd_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY notdeb ALTER COLUMN nd_id SET DEFAULT nextval('notdeb_nd_id_seq'::regclass);


--
-- Name: not_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY noticias ALTER COLUMN not_id SET DEFAULT nextval('noticias_not_id_seq'::regclass);


--
-- Name: nov_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY novedades ALTER COLUMN nov_id SET DEFAULT nextval('novedades_nov_id_seq'::regclass);


--
-- Name: osg_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ocsingtos ALTER COLUMN osg_id SET DEFAULT nextval('ocsingtos_osg_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: oi_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid ALTER COLUMN oi_id SET DEFAULT nextval('operincid_oi_id_seq'::regclass);


--
-- Name: oc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ordencompra ALTER COLUMN oc_id SET DEFAULT nextval('ordencompra_oc_id_seq'::regclass);


--
-- Name: pri_codigo; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY priorincid ALTER COLUMN pri_codigo SET DEFAULT nextval('priorincid_pri_codigo_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: rmen_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY relmenu ALTER COLUMN rmen_id SET DEFAULT nextval('relmenu_rmen_id_seq'::regclass);


--
-- Name: rl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY revisliq ALTER COLUMN rl_id SET DEFAULT nextval('revisliq_rl_id_seq'::regclass);


--
-- Name: rubl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY rubcar ALTER COLUMN rubl_id SET DEFAULT nextval('rubcar_rubl_id_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: sc_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY scangto ALTER COLUMN sc_id SET DEFAULT nextval('scangto_sc_id_seq'::regclass);


--
-- Name: sin_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY sinicial ALTER COLUMN sin_id SET DEFAULT nextval('sinicial_sin_id_seq'::regclass);


--
-- Name: srbl_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY srubcar ALTER COLUMN srbl_id SET DEFAULT nextval('srubcar_srbl_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: srb_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY subrub ALTER COLUMN srb_id SET DEFAULT nextval('subrub_srb_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: tg_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY tipgto ALTER COLUMN tg_id SET DEFAULT nextval('tipgto_tg_id_seq'::regclass);


--
-- Name: umen_id; Type: DEFAULT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY usermenu ALTER COLUMN umen_id SET DEFAULT nextval('usermenu_umen_id_seq'::regclass);


--
-- Name: amenity_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT amenity_pkey PRIMARY KEY (am_id);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: astcconccble_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY astcconccble
    ADD CONSTRAINT astcconccble_pkey PRIMARY KEY (accb_id);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: auxcop_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY auxcop
    ADD CONSTRAINT auxcop_pkey PRIMARY KEY (aux_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: cambtitu_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT cambtitu_pkey PRIMARY KEY (cbt_id);


--
-- Name: cargos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT cargos_pkey PRIMARY KEY (car_id);


--
-- Name: categincid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY categincid
    ADD CONSTRAINT categincid_pkey PRIMARY KEY (cat_codigo);


--
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_id);


--
-- Name: chat_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY chat
    ADD CONSTRAINT chat_pkey PRIMARY KEY (c_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: cobrxclq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT cobrxclq_pkey PRIMARY KEY (cxc_id);


--
-- Name: compliq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT compliq_pkey PRIMARY KEY (clq_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: comprop_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT comprop_pkey PRIMARY KEY (cmpr_id);


--
-- Name: conccble_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY conccble
    ADD CONSTRAINT conccble_pkey PRIMARY KEY (ccbl_id);


--
-- Name: concilia_pkey; Type: CONSTRAINT; Schema: public; Owner: elm; Tablespace: 
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT concilia_pkey PRIMARY KEY (clia_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: contratos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY contratos
    ADD CONSTRAINT contratos_pkey PRIMARY KEY (ct_id);


--
-- Name: convenios_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT convenios_pkey PRIMARY KEY (con_id);


--
-- Name: conxcxlia_pkey; Type: CONSTRAINT; Schema: public; Owner: elm; Tablespace: 
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT conxcxlia_pkey PRIMARY KEY (cxlia_id);


--
-- Name: coprop_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_pkey PRIMARY KEY (cop_id);


--
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctasconv_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT ctasconv_pkey PRIMARY KEY (ctc_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: descripliq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY descripliq
    ADD CONSTRAINT descripliq_pkey PRIMARY KEY (dlq_id);


--
-- Name: dinicial_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY dinicial
    ADD CONSTRAINT dinicial_pkey PRIMARY KEY (din_id);


--
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_id);


--
-- Name: estincid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY estincid
    ADD CONSTRAINT estincid_pkey PRIMARY KEY (est_codigo);


--
-- Name: estjud_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY estjud
    ADD CONSTRAINT estjud_pkey PRIMARY KEY (etj_codigo);


--
-- Name: estjurid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY estjurid
    ADD CONSTRAINT estjurid_pkey PRIMARY KEY (est_codigo);


--
-- Name: eventos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT eventos_pkey PRIMARY KEY (evt_id);


--
-- Name: factpend_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_pkey PRIMARY KEY (fap_id);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: fondocobrado_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY fondocobrado
    ADD CONSTRAINT fondocobrado_pkey PRIMARY KEY (fc_id);


--
-- Name: formapagooc_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_pkey PRIMARY KEY (fp_id);


--
-- Name: gastos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_pkey PRIMARY KEY (gto_id);


--
-- Name: grupof_d_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY grupof_d
    ADD CONSTRAINT grupof_d_pkey PRIMARY KEY (gf_id);


--
-- Name: grupof_inq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY grupof_inq
    ADD CONSTRAINT grupof_inq_pkey PRIMARY KEY (gf_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: gtoxoc_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY gtoxoc
    ADD CONSTRAINT gtoxoc_pkey PRIMARY KEY (gxo_id);


--
-- Name: honorarios_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY honorarios
    ADD CONSTRAINT honorarios_pkey PRIMARY KEY (hon_id);


--
-- Name: imgincid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY imgincid
    ADD CONSTRAINT imgincid_pkey PRIMARY KEY (img_codigo);


--
-- Name: importoliq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY importoliq
    ADD CONSTRAINT importoliq_pkey PRIMARY KEY (imp_id);


--
-- Name: incidencias_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_pkey PRIMARY KEY (in_id);


--
-- Name: infdep_pkey; Type: CONSTRAINT; Schema: public; Owner: zona; Tablespace: 
--

ALTER TABLE ONLY infdep
    ADD CONSTRAINT infdep_pkey PRIMARY KEY (inf_id);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_centro, int_fecha, int_tipo);


--
-- Name: judicial_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT judicial_pkey PRIMARY KEY (jud_id);


--
-- Name: liqegr_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_pkey PRIMARY KEY (eg_id);


--
-- Name: liquidacion_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT liquidacion_pkey PRIMARY KEY (l_id);


--
-- Name: menues_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY menues
    ADD CONSTRAINT menues_pkey PRIMARY KEY (men_id);


--
-- Name: modlogs_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY modlogs
    ADD CONSTRAINT modlogs_pkey PRIMARY KEY (log_id);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: noticias_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY noticias
    ADD CONSTRAINT noticias_pkey PRIMARY KEY (not_id);


--
-- Name: novedades_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY novedades
    ADD CONSTRAINT novedades_pkey PRIMARY KEY (nov_id);


--
-- Name: ocsingtos_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_pkey PRIMARY KEY (osg_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: operincid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_pkey PRIMARY KEY (oi_id);


--
-- Name: ordencompra_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ordencompra
    ADD CONSTRAINT ordencompra_pkey PRIMARY KEY (oc_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: priorincid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY priorincid
    ADD CONSTRAINT priorincid_pkey PRIMARY KEY (pri_codigo);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: relmenu_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY relmenu
    ADD CONSTRAINT relmenu_pkey PRIMARY KEY (rmen_id);


--
-- Name: revisliq_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY revisliq
    ADD CONSTRAINT revisliq_pkey PRIMARY KEY (rl_id);


--
-- Name: rubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY rubcar
    ADD CONSTRAINT rubcar_pkey PRIMARY KEY (rubl_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: scangto_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY scangto
    ADD CONSTRAINT scangto_pkey PRIMARY KEY (sc_id);


--
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- Name: sinicial_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY sinicial
    ADD CONSTRAINT sinicial_pkey PRIMARY KEY (sin_id);


--
-- Name: srubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY srubcar
    ADD CONSTRAINT srubcar_pkey PRIMARY KEY (srbl_id);


--
-- Name: subd_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT subd_pkey PRIMARY KEY (subd_id);


--
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_id);


--
-- Name: sucursal_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY sucursal
    ADD CONSTRAINT sucursal_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipempr_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipempr
    ADD CONSTRAINT tipempr_pkey PRIMARY KEY (ter_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tipgto_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipgto
    ADD CONSTRAINT tipgto_pkey PRIMARY KEY (tg_id);


--
-- Name: tipnot_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipnot
    ADD CONSTRAINT tipnot_pkey PRIMARY KEY (tnot_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tipuf_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY tipuf
    ADD CONSTRAINT tipuf_pkey PRIMARY KEY (tuf_codigo);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: usermenu_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY usermenu
    ADD CONSTRAINT usermenu_pkey PRIMARY KEY (umen_id);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: zona_pkey; Type: CONSTRAINT; Schema: public; Owner: aaii; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT zona_pkey PRIMARY KEY (zon_codigo);


--
-- Name: cobrxclq_cxc_idastoc_cxc_importe_idx; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idastoc_cxc_importe_idx ON cobrxclq USING btree (cxc_idastoc, cxc_importe);


--
-- Name: cobrxclq_cxc_idclq_cxc_importe_idx; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idclq_cxc_importe_idx ON cobrxclq USING btree (cxc_idclq, cxc_importe);


--
-- Name: cobrxclq_cxc_idcopr_cxc_importe_idx; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX cobrxclq_cxc_idcopr_cxc_importe_idx ON cobrxclq USING btree (cxc_idcopr, cxc_importe);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_tipoper, art_codigo);


--
-- Name: idx_articvta_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_2 ON articvta USING btree (art_idptov, art_codi);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_16; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_16 ON astoctas USING btree (astc_ctacte, astc_tipcta, astc_estado, astc_importe);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_centro, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_3 ON astoh USING btree (ash_codemp, ash_centro, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_4 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_centro, ash_fecomp);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_centro, ash_fecval);


--
-- Name: idx_astoh_6; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_6 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_7; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_7 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_idptov, ash_centro, ash_fecval);


--
-- Name: idx_astoh_8; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_astoh_8 ON astoh USING btree (ash_codemp, ash_idptov, ash_centro, ash_titulo);


--
-- Name: idx_auxint_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_auxint_1 ON auxint USING btree (ai_idliq, ai_idcopr);


--
-- Name: idx_cambtitu_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cambtitu_1 ON cambtitu USING btree (cbt_codemp, cbt_idptov, cbt_idcopr);


--
-- Name: idx_cambtitu_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cambtitu_2 ON cambtitu USING btree (cbt_idcopr);


--
-- Name: idx_cargos_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cargos_1 ON cargos USING btree (car_codemp, car_idptov, car_division, car_centro, car_codigo);


--
-- Name: idx_cargos_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cargos_2 ON cargos USING btree (car_codemp, car_idptov, car_codigo);


--
-- Name: idx_cargos_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cargos_3 ON cargos USING btree (car_codemp, car_idptov, car_rubcar, car_srubcar);


--
-- Name: idx_centroc_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_centroc_1 ON centroc USING btree (cco_codemp, cco_idptov, cco_coddiv, cco_codigo);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_compliq_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_2 ON compliq USING btree (clq_codemp, clq_idptov, clq_comprob, clq_numero);


--
-- Name: idx_compliq_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_3 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes);


--
-- Name: idx_compliq_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_4 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes, clq_rubcar, clq_cargo);


--
-- Name: idx_compliq_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_5 ON compliq USING btree (clq_codemp, clq_centro, clq_anio, clq_mes);


--
-- Name: idx_compliq_6; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_6 ON compliq USING btree (clq_codemp, clq_centro, clq_anio, clq_mes, clq_idcopr, clq_estado);


--
-- Name: idx_compliq_7; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_7 ON compliq USING btree (clq_id, clq_importe);


--
-- Name: idx_compliq_8; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_8 ON compliq USING btree (clq_fecha, clq_idcopr, clq_rubcar, clq_cargo, clq_importe);


--
-- Name: idx_compliq_9; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliq_9 ON compliq USING btree (clq_idliq, clq_cargo, clq_idcopr, clq_estado, clq_importe);


--
-- Name: idx_compliquid_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compliquid_1 ON compliquid USING btree (cl_idliq);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_codemp, comp_idptov, comp_codigo);


--
-- Name: idx_comprop_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_comprop_1 ON comprop USING btree (cmpr_centro, cmpr_idcopr);


--
-- Name: idx_comprop_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_comprop_2 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr);


--
-- Name: idx_comprop_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_comprop_3 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr, cmpr_rubcar, cmpr_cargo);


--
-- Name: idx_conccble_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_conccble_1 ON conccble USING btree (ccbl_ctacble, ccbl_fecha);


--
-- Name: idx_concilia_1; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_concilia_1 ON concilia USING btree (clia_cte, clia_fecha);


--
-- Name: idx_convenios_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_convenios_1 ON convenios USING btree (con_codemp, con_idptov, con_division, con_centro, con_idcopr);


--
-- Name: idx_conxcxlia_1; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_conxcxlia_1 ON conxclia USING btree (cxlia_idclia);


--
-- Name: idx_conxcxlia_2; Type: INDEX; Schema: public; Owner: elm; Tablespace: 
--

CREATE INDEX idx_conxcxlia_2 ON conxclia USING btree (cxlia_idastc);


--
-- Name: idx_coprop_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_coprop_2 ON coprop USING btree (cop_codemp, cop_idptov, cop_codaso);


--
-- Name: idx_coprop_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_coprop_3 ON coprop USING btree (cop_codemp, cop_idptov, cop_division, cop_centro, cop_unifun);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_ctacble_2 ON ctacble USING btree (cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_ctacble_3 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_nombre);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_dinicial_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_dinicial_1 ON dinicial USING btree (din_idsaldos, din_iddesc);


--
-- Name: idx_division_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_division_1 ON division USING btree (div_codemp, div_idptov, div_codigo);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_factpend_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_factpend_2 ON factpend USING btree (fap_codemp, fap_idptov, fap_centro);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_formapagooc_10; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_10 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_tipcta, fp_ctacte);


--
-- Name: idx_formapagooc_11; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_11 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_tipcta, fp_ctacte, fp_fecval);


--
-- Name: idx_formapagooc_12; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_12 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_moneda);


--
-- Name: idx_formapagooc_13; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_13 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_ctacble, fp_estado, fp_fecval);


--
-- Name: idx_formapagooc_14; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_14 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_estado, fp_fecval);


--
-- Name: idx_formapagooc_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_2 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_fecval);


--
-- Name: idx_formapagooc_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_3 ON formapagooc USING btree (fp_codemp, fp_idptov, fp_ctacble, fp_fecval);


--
-- Name: idx_formapagooc_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_formapagooc_4 ON formapagooc USING btree (fp_codemp, fp_ctacble, fp_ctacte, fp_fecval);


--
-- Name: idx_gastos_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_gastos_1 ON gastos USING btree (gto_idastoh);


--
-- Name: idx_gastos_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_gastos_2 ON gastos USING btree (gto_codemp, gto_idptov, gto_centro);


--
-- Name: idx_gtoxliqe_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_1 ON gtoxliqe USING btree (gxl_liqegr, gxl_gasto);


--
-- Name: idx_gtoxliqe_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_2 ON gtoxliqe USING btree (gxl_liqegr);


--
-- Name: idx_gtoxliqe_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_3 ON gtoxliqe USING btree (gxl_gasto);


--
-- Name: idx_honorarios_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_honorarios_2 ON honorarios USING btree (hon_codemp, hon_idptov, hon_rubro, hon_subrub);


--
-- Name: idx_importoliq_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_importoliq_1 ON importoliq USING btree (imp_centro, imp_anio, imp_mes);


--
-- Name: idx_judicial_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_judicial_1 ON judicial USING btree (jud_codemp, jud_idptov, jud_idcopr);


--
-- Name: idx_judicial_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_judicial_2 ON judicial USING btree (jud_idcopr);


--
-- Name: idx_liqegr_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liqegr_1 ON liqegr USING btree (eg_idastoh);


--
-- Name: idx_liqegr_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liqegr_2 ON liqegr USING btree (eg_codemp, eg_idptov, eg_centro);


--
-- Name: idx_liqui_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liqui_1 ON liqui USING btree (lq_idliq, lq_idcopr);


--
-- Name: idx_liquidacion_0; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liquidacion_0 ON liquidacion USING btree (l_codemp, l_idptov, l_centro, l_division, l_anio, l_mes);


--
-- Name: idx_liquidacion_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liquidacion_1 ON liquidacion USING btree (l_codemp, l_idptov, l_anio, l_mes);


--
-- Name: idx_liquidacion_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_liquidacion_2 ON liquidacion USING btree (l_idptov, l_anio, l_mes);


--
-- Name: idx_modlogs_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_modlogs_1 ON modlogs USING btree (log_idptov, log_tabla);


--
-- Name: idx_modlogs_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_modlogs_2 ON modlogs USING btree (log_comprob, log_numero);


--
-- Name: idx_modlogs_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_modlogs_3 ON modlogs USING btree (log_tabla, log_idtabla);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_noticias_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_noticias_1 ON noticias USING btree (not_idptov, not_tipo, not_titulo);


--
-- Name: idx_noticias_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_noticias_2 ON noticias USING btree (not_idptov, not_tipo, not_anio, not_mes);


--
-- Name: idx_noticias_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_noticias_3 ON noticias USING btree (not_idptov, not_anio, not_mes);


--
-- Name: idx_ocsingtos_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_ocsingtos_2 ON ocsingtos USING btree (osg_codemp, osg_idptov, osg_division, osg_centro);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_ordencompra_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_ordencompra_1 ON ordencompra USING btree (oc_numanio, oc_anio);


--
-- Name: idx_prove_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_prove_1 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_sinicial_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_sinicial_1 ON sinicial USING btree (sin_idsaldos, sin_idcargo);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_subrub_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_subrub_1 ON subrub USING btree (srb_rubro, srb_codigo);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: aaii; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: ad_cobrxclq; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ad_cobrxclq AFTER DELETE ON cobrxclq FOR EACH ROW EXECUTE PROCEDURE f_ad_cobrxclq();


--
-- Name: ad_compliq; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ad_compliq BEFORE DELETE ON compliq FOR EACH ROW EXECUTE PROCEDURE f_bd_compliq();


--
-- Name: ad_coprop; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ad_coprop AFTER DELETE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_ad_coprop();


--
-- Name: ad_gastos; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ad_gastos AFTER DELETE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_ad_gastos();


--
-- Name: ad_prove; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ad_prove AFTER DELETE ON prove FOR EACH ROW EXECUTE PROCEDURE f_ad_prove();


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_astoctas AFTER INSERT ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_astoh; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_astoh AFTER INSERT ON astoh FOR EACH ROW EXECUTE PROCEDURE f_ai_astoh();


--
-- Name: ai_coprop; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_coprop AFTER INSERT ON coprop FOR EACH ROW EXECUTE PROCEDURE f_ai_coprop();


--
-- Name: ai_empresa; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_empresa AFTER INSERT ON empresa FOR EACH ROW EXECUTE PROCEDURE f_ai_empresa();


--
-- Name: ai_gastos; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_gastos AFTER INSERT ON gastos FOR EACH ROW EXECUTE PROCEDURE f_ai_gastos();


--
-- Name: ai_ordencompra; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_ordencompra AFTER INSERT ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_ai_ordencompra();


--
-- Name: ai_prove; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_prove AFTER INSERT ON prove FOR EACH ROW EXECUTE PROCEDURE f_ai_prove();


--
-- Name: ai_ptovta; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER ai_ptovta AFTER INSERT ON ptovta FOR EACH ROW EXECUTE PROCEDURE f_ai_ptovta();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_astoctas AFTER UPDATE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_astoh AFTER UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_cheques; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_cheques AFTER UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_au_cheques();


--
-- Name: au_compliq; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_compliq AFTER UPDATE ON compliq FOR EACH ROW EXECUTE PROCEDURE f_au_compliq();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_compra AFTER UPDATE ON compra FOR EACH ROW EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_conccble; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_conccble AFTER UPDATE ON conccble FOR EACH ROW EXECUTE PROCEDURE f_au_conccble();


--
-- Name: au_concilia; Type: TRIGGER; Schema: public; Owner: elm
--

CREATE TRIGGER au_concilia AFTER UPDATE ON concilia FOR EACH ROW EXECUTE PROCEDURE f_au_concilia();


--
-- Name: au_coprop; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_coprop AFTER UPDATE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_au_coprop();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_emiti AFTER UPDATE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_gastos; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_gastos AFTER UPDATE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_au_gastos();


--
-- Name: au_honorarios; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_honorarios AFTER UPDATE ON honorarios FOR EACH ROW EXECUTE PROCEDURE f_au_honorarios();


--
-- Name: au_liqegr; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_liqegr AFTER UPDATE ON liqegr FOR EACH ROW EXECUTE PROCEDURE f_au_liqegr();


--
-- Name: au_liquidacion; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_liquidacion AFTER UPDATE ON liquidacion FOR EACH ROW EXECUTE PROCEDURE f_au_liquidacion();


--
-- Name: au_ordencompra; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_ordencompra AFTER UPDATE ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_au_ordencompra();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_prove AFTER UPDATE ON prove FOR EACH ROW EXECUTE PROCEDURE f_au_prove();


--
-- Name: au_telefon; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER au_telefon AFTER UPDATE ON telefon FOR EACH ROW EXECUTE PROCEDURE f_au_telefon();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_astoctas BEFORE DELETE ON astoctas FOR EACH ROW EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_astoh BEFORE DELETE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_coprop; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_coprop BEFORE DELETE ON coprop FOR EACH ROW EXECUTE PROCEDURE f_bd_coprop();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_emiti BEFORE DELETE ON emiti FOR EACH ROW EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_gastos; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_gastos BEFORE DELETE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_bd_gastos();


--
-- Name: bd_importoliq; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_importoliq BEFORE DELETE ON importoliq FOR EACH ROW EXECUTE PROCEDURE f_bd_importoliq();


--
-- Name: bd_incidencias; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_incidencias BEFORE DELETE ON incidencias FOR EACH ROW EXECUTE PROCEDURE f_bd_incidencias();


--
-- Name: bd_liquidacion; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_liquidacion BEFORE DELETE ON liquidacion FOR EACH ROW EXECUTE PROCEDURE f_bd_liquidacion();


--
-- Name: bd_ordencompra; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_ordencompra BEFORE DELETE ON ordencompra FOR EACH ROW EXECUTE PROCEDURE f_bd_ordencompra();


--
-- Name: bd_prove; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_prove BEFORE DELETE ON prove FOR EACH ROW EXECUTE PROCEDURE f_bd_prove();


--
-- Name: bd_ptovta; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bd_ptovta BEFORE DELETE ON ptovta FOR EACH ROW EXECUTE PROCEDURE f_bd_ptovta();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bu_astoh BEFORE UPDATE ON astoh FOR EACH ROW EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bu_cheques BEFORE UPDATE ON cheques FOR EACH ROW EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: bu_gastos; Type: TRIGGER; Schema: public; Owner: aaii
--

CREATE TRIGGER bu_gastos AFTER UPDATE ON gastos FOR EACH ROW EXECUTE PROCEDURE f_bu_gastos();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT "$1" FOREIGN KEY (car_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$1" FOREIGN KEY (l_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliquid
    ADD CONSTRAINT "$1" FOREIGN KEY (cl_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$1" FOREIGN KEY (lq_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$1" FOREIGN KEY (cmpr_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$1" FOREIGN KEY (ai_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$1" FOREIGN KEY (con_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT "$1" FOREIGN KEY (ctc_idconv) REFERENCES convenios(con_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$1" FOREIGN KEY (cbt_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$1" FOREIGN KEY (jud_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$1" FOREIGN KEY (clq_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY concilia
    ADD CONSTRAINT "$1" FOREIGN KEY (clia_cte) REFERENCES ctes(cte_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$1" FOREIGN KEY (cxlia_idclia) REFERENCES concilia(clia_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY conccble
    ADD CONSTRAINT "$1" FOREIGN KEY (ccbl_ctacble) REFERENCES ctacble(cbl_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astcconccble
    ADD CONSTRAINT "$1" FOREIGN KEY (accb_idccbl) REFERENCES conccble(ccbl_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ordencompra
    ADD CONSTRAINT "$1" FOREIGN KEY (oc_centro) REFERENCES centroc(cco_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$1" FOREIGN KEY (am_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$1" FOREIGN KEY (evt_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$2" FOREIGN KEY (l_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$2" FOREIGN KEY (lq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$2" FOREIGN KEY (cmpr_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$2" FOREIGN KEY (ai_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$2" FOREIGN KEY (con_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$2" FOREIGN KEY (cbt_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$2" FOREIGN KEY (jud_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$2" FOREIGN KEY (clq_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT "$2" FOREIGN KEY (cxc_idclq) REFERENCES compliq(clq_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: elm
--

ALTER TABLE ONLY conxclia
    ADD CONSTRAINT "$2" FOREIGN KEY (cxlia_idastc) REFERENCES astoctas(astc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gtoxoc
    ADD CONSTRAINT "$2" FOREIGN KEY (gxo_idoc) REFERENCES ordencompra(oc_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$2" FOREIGN KEY (am_division) REFERENCES division(div_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$2" FOREIGN KEY (evt_division) REFERENCES division(div_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$3" FOREIGN KEY (l_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$3" FOREIGN KEY (lq_cargo) REFERENCES cargos(car_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$3" FOREIGN KEY (cmpr_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$3" FOREIGN KEY (con_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$3" FOREIGN KEY (cbt_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$3" FOREIGN KEY (jud_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$3" FOREIGN KEY (clq_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cobrxclq
    ADD CONSTRAINT "$3" FOREIGN KEY (cxc_idcopr) REFERENCES coprop(cop_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$3" FOREIGN KEY (am_centro) REFERENCES centroc(cco_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$3" FOREIGN KEY (evt_centro) REFERENCES centroc(cco_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$4" FOREIGN KEY (l_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$4" FOREIGN KEY (cmpr_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$4" FOREIGN KEY (con_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$4" FOREIGN KEY (cbt_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$4" FOREIGN KEY (jud_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$4" FOREIGN KEY (clq_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$4" FOREIGN KEY (am_cargo) REFERENCES cargos(car_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$4" FOREIGN KEY (evt_idcopr) REFERENCES coprop(cop_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$5" FOREIGN KEY (cmpr_cargo) REFERENCES cargos(car_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$5" FOREIGN KEY (con_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$5" FOREIGN KEY (cbt_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$5" FOREIGN KEY (jud_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$5" FOREIGN KEY (clq_comprob) REFERENCES comprob(comp_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY amenity
    ADD CONSTRAINT "$5" FOREIGN KEY (am_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$5" FOREIGN KEY (evt_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$6" FOREIGN KEY (con_comprob) REFERENCES comprob(comp_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$6" FOREIGN KEY (jud_ejcod) REFERENCES estjud(etj_codigo) MATCH FULL;


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$6" FOREIGN KEY (clq_cargo) REFERENCES cargos(car_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT "$6" FOREIGN KEY (evt_idamenity) REFERENCES amenity(am_id);


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$7" FOREIGN KEY (jud_estudio) REFERENCES estjurid(est_codigo) MATCH FULL;


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$7" FOREIGN KEY (clq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: astoctas_astc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_codemp_fkey FOREIGN KEY (astc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoctas_astc_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idastoh_fkey FOREIGN KEY (astc_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: astoctas_astc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idptov_fkey FOREIGN KEY (astc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: astoh_ash_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_codemp_fkey FOREIGN KEY (ash_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoh_ash_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_idptov_fkey FOREIGN KEY (ash_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: centroc_cco_coddiv_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_coddiv_fkey FOREIGN KEY (cco_coddiv) REFERENCES division(div_id) MATCH FULL;


--
-- Name: centroc_cco_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_codemp_fkey FOREIGN KEY (cco_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: centroc_cco_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_idptov_fkey FOREIGN KEY (cco_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cheques_chq_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_codemp_fkey FOREIGN KEY (chq_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: cheques_chq_idastoc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idastoc_fkey FOREIGN KEY (chq_idastoc) REFERENCES astoctas(astc_id) MATCH FULL;


--
-- Name: cheques_chq_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idptov_fkey FOREIGN KEY (chq_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: compra_cpra_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_codemp_fkey FOREIGN KEY (cpra_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: compra_cpra_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idastoh_fkey FOREIGN KEY (cpra_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: compra_cpra_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idptov_fkey FOREIGN KEY (cpra_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: coprop_cop_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_codemp_fkey FOREIGN KEY (cop_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: coprop_cop_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_idptov_fkey FOREIGN KEY (cop_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cotiza_cot_moneda_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_cot_moneda_fkey FOREIGN KEY (cot_moneda) REFERENCES moneda(mon_codigo) MATCH FULL;


--
-- Name: division_div_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_codemp_fkey FOREIGN KEY (div_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: division_div_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_idptov_fkey FOREIGN KEY (div_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: docum_doc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_codemp_fkey FOREIGN KEY (doc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: docum_doc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_idptov_fkey FOREIGN KEY (doc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: emiti_emi_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_codemp_fkey FOREIGN KEY (emi_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: emiti_emi_comprob_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_comprob_fkey FOREIGN KEY (emi_comprob) REFERENCES comprob(comp_id) MATCH FULL;


--
-- Name: emiti_emi_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idastoh_fkey FOREIGN KEY (emi_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: emiti_emi_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idptov_fkey FOREIGN KEY (emi_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: estjurid_est_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY estjurid
    ADD CONSTRAINT estjurid_est_codemp_fkey FOREIGN KEY (est_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: factpend_fap_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_centro_fkey FOREIGN KEY (fap_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: factpend_fap_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_codemp_fkey FOREIGN KEY (fap_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: factpend_fap_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_division_fkey FOREIGN KEY (fap_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: factpend_fap_idgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idgto_fkey FOREIGN KEY (fap_idgto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: factpend_fap_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idptov_fkey FOREIGN KEY (fap_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: formapagooc_fp_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_fp_codemp_fkey FOREIGN KEY (fp_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: formapagooc_fp_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY formapagooc
    ADD CONSTRAINT formapagooc_fp_idptov_fkey FOREIGN KEY (fp_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gastos_gto_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_centro_fkey FOREIGN KEY (gto_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: gastos_gto_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_codemp_fkey FOREIGN KEY (gto_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: gastos_gto_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_division_fkey FOREIGN KEY (gto_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: gastos_gto_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idastoh_fkey FOREIGN KEY (gto_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: gastos_gto_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idptov_fkey FOREIGN KEY (gto_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gastos_gto_tipgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_tipgto_fkey FOREIGN KEY (gto_tipgto) REFERENCES tipgto(tg_id);


--
-- Name: gtoxliqe_gxl_gasto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_gasto_fkey FOREIGN KEY (gxl_gasto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: gtoxliqe_gxl_liqegr_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_liqegr_fkey FOREIGN KEY (gxl_liqegr) REFERENCES liqegr(eg_id) MATCH FULL;


--
-- Name: imgincid_img_idinc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY imgincid
    ADD CONSTRAINT imgincid_img_idinc_fkey FOREIGN KEY (img_idinc) REFERENCES incidencias(in_id);


--
-- Name: incidencias_in_categoria_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_categoria_fkey FOREIGN KEY (in_categoria) REFERENCES categincid(cat_codigo);


--
-- Name: incidencias_in_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_codemp_fkey FOREIGN KEY (in_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: incidencias_in_estado_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_estado_fkey FOREIGN KEY (in_estado) REFERENCES estincid(est_codigo);


--
-- Name: incidencias_in_idcopr_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_idcopr_fkey FOREIGN KEY (in_idcopr) REFERENCES coprop(cop_id);


--
-- Name: incidencias_in_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY incidencias
    ADD CONSTRAINT incidencias_in_idptov_fkey FOREIGN KEY (in_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: interes_int_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_centro_fkey FOREIGN KEY (int_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: interes_int_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_codemp_fkey FOREIGN KEY (int_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: interes_int_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_idptov_fkey FOREIGN KEY (int_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqegr_eg_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_codemp_fkey FOREIGN KEY (eg_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: liqegr_eg_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idastoh_fkey FOREIGN KEY (eg_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: liqegr_eg_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idptov_fkey FOREIGN KEY (eg_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqegr_eg_tipgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_tipgto_fkey FOREIGN KEY (eg_tipgto) REFERENCES tipgto(tg_id);


--
-- Name: movsto_movs_artic_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_artic_fkey FOREIGN KEY (movs_artic) REFERENCES articvta(art_id) MATCH FULL;


--
-- Name: movsto_movs_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_codemp_fkey FOREIGN KEY (movs_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: movsto_movs_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idastoh_fkey FOREIGN KEY (movs_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: movsto_movs_idemiti_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idemiti_fkey FOREIGN KEY (movs_idemiti) REFERENCES emiti(emi_id) MATCH FULL;


--
-- Name: movsto_movs_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idptov_fkey FOREIGN KEY (movs_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: ocsingtos_osg_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_centro_fkey FOREIGN KEY (osg_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: ocsingtos_osg_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_codemp_fkey FOREIGN KEY (osg_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: ocsingtos_osg_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_division_fkey FOREIGN KEY (osg_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: ocsingtos_osg_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ocsingtos
    ADD CONSTRAINT ocsingtos_osg_idptov_fkey FOREIGN KEY (osg_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: operincid_oi_estado_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_estado_fkey FOREIGN KEY (oi_estado) REFERENCES estincid(est_codigo);


--
-- Name: operincid_oi_idinc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_idinc_fkey FOREIGN KEY (oi_idinc) REFERENCES incidencias(in_id);


--
-- Name: operincid_oi_operal_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_operal_fkey FOREIGN KEY (oi_operal) REFERENCES operadores(operad_id);


--
-- Name: operincid_oi_operasign_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_operasign_fkey FOREIGN KEY (oi_operasign) REFERENCES operadores(operad_id);


--
-- Name: operincid_oi_prioridad_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY operincid
    ADD CONSTRAINT operincid_oi_prioridad_fkey FOREIGN KEY (oi_prioridad) REFERENCES priorincid(pri_codigo);


--
-- Name: ptovta_ptv_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: aaii
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_ptv_codemp_fkey FOREIGN KEY (ptv_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: amenity; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE amenity FROM PUBLIC;
REVOKE ALL ON TABLE amenity FROM aaii;
GRANT ALL ON TABLE amenity TO aaii;
GRANT ALL ON TABLE amenity TO nobody;


--
-- Name: amenity_am_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM aaii;
GRANT ALL ON SEQUENCE amenity_am_id_seq TO aaii;
GRANT ALL ON SEQUENCE amenity_am_id_seq TO nobody;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM aaii;
GRANT ALL ON TABLE articvta TO aaii;
GRANT ALL ON TABLE articvta TO nobody;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM aaii;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO aaii;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO nobody;


--
-- Name: astcconccble; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE astcconccble FROM PUBLIC;
REVOKE ALL ON TABLE astcconccble FROM aaii;
GRANT ALL ON TABLE astcconccble TO aaii;
GRANT ALL ON TABLE astcconccble TO nobody;


--
-- Name: astcconccble_accb_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE astcconccble_accb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astcconccble_accb_id_seq FROM aaii;
GRANT ALL ON SEQUENCE astcconccble_accb_id_seq TO aaii;
GRANT ALL ON SEQUENCE astcconccble_accb_id_seq TO nobody;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM aaii;
GRANT ALL ON TABLE astoctas TO aaii;
GRANT ALL ON TABLE astoctas TO nobody;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO aaii;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO nobody;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM aaii;
GRANT ALL ON TABLE astoh TO aaii;
GRANT ALL ON TABLE astoh TO nobody;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM aaii;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO aaii;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO nobody;


--
-- Name: auxcop; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE auxcop FROM PUBLIC;
REVOKE ALL ON TABLE auxcop FROM zona;
GRANT ALL ON TABLE auxcop TO zona;
GRANT ALL ON TABLE auxcop TO nobody;


--
-- Name: auxcop_aux_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE auxcop_aux_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxcop_aux_id_seq FROM zona;
GRANT ALL ON SEQUENCE auxcop_aux_id_seq TO zona;
GRANT UPDATE ON SEQUENCE auxcop_aux_id_seq TO nobody;


--
-- Name: auxint; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE auxint FROM PUBLIC;
REVOKE ALL ON TABLE auxint FROM aaii;
GRANT ALL ON TABLE auxint TO aaii;
GRANT ALL ON TABLE auxint TO nobody;


--
-- Name: auxint_ai_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE auxint_ai_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE auxint_ai_id_seq FROM aaii;
GRANT ALL ON SEQUENCE auxint_ai_id_seq TO aaii;
GRANT ALL ON SEQUENCE auxint_ai_id_seq TO nobody;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM aaii;
GRANT ALL ON TABLE bancos TO aaii;
GRANT ALL ON TABLE bancos TO nobody;


--
-- Name: cambtitu; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE cambtitu FROM PUBLIC;
REVOKE ALL ON TABLE cambtitu FROM aaii;
GRANT ALL ON TABLE cambtitu TO aaii;
GRANT ALL ON TABLE cambtitu TO nobody;


--
-- Name: cambtitu_cbt_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM aaii;
GRANT ALL ON SEQUENCE cambtitu_cbt_id_seq TO aaii;
GRANT ALL ON SEQUENCE cambtitu_cbt_id_seq TO nobody;


--
-- Name: cargos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE cargos FROM PUBLIC;
REVOKE ALL ON TABLE cargos FROM aaii;
GRANT ALL ON TABLE cargos TO aaii;
GRANT ALL ON TABLE cargos TO nobody;


--
-- Name: cargos_car_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM aaii;
GRANT ALL ON SEQUENCE cargos_car_id_seq TO aaii;
GRANT ALL ON SEQUENCE cargos_car_id_seq TO nobody;


--
-- Name: categincid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE categincid FROM PUBLIC;
REVOKE ALL ON TABLE categincid FROM aaii;
GRANT ALL ON TABLE categincid TO aaii;
GRANT ALL ON TABLE categincid TO nobody;


--
-- Name: categincid_cat_codigo_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE categincid_cat_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE categincid_cat_codigo_seq FROM aaii;
GRANT ALL ON SEQUENCE categincid_cat_codigo_seq TO aaii;
GRANT ALL ON SEQUENCE categincid_cat_codigo_seq TO nobody;


--
-- Name: catego; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
REVOKE ALL ON TABLE catego FROM aaii;
GRANT ALL ON TABLE catego TO aaii;
GRANT ALL ON TABLE catego TO nobody;


--
-- Name: centroc; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
REVOKE ALL ON TABLE centroc FROM aaii;
GRANT ALL ON TABLE centroc TO aaii;
GRANT ALL ON TABLE centroc TO nobody;


--
-- Name: centroc_cco_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM aaii;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO aaii;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO nobody;


--
-- Name: chat; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE chat FROM PUBLIC;
REVOKE ALL ON TABLE chat FROM aaii;
GRANT ALL ON TABLE chat TO aaii;
GRANT ALL ON TABLE chat TO nobody;


--
-- Name: chat_c_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE chat_c_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chat_c_id_seq FROM aaii;
GRANT ALL ON SEQUENCE chat_c_id_seq TO aaii;
GRANT ALL ON SEQUENCE chat_c_id_seq TO nobody;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM aaii;
GRANT ALL ON TABLE cheques TO aaii;
GRANT ALL ON TABLE cheques TO nobody;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM aaii;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO aaii;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO nobody;


--
-- Name: chequesaux; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE chequesaux FROM PUBLIC;
REVOKE ALL ON TABLE chequesaux FROM aaii;
GRANT ALL ON TABLE chequesaux TO aaii;
GRANT ALL ON TABLE chequesaux TO nobody;


--
-- Name: chequesaux_cqa_grupo_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE chequesaux_cqa_grupo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chequesaux_cqa_grupo_seq FROM aaii;
GRANT ALL ON SEQUENCE chequesaux_cqa_grupo_seq TO aaii;
GRANT ALL ON SEQUENCE chequesaux_cqa_grupo_seq TO nobody;


--
-- Name: chequesaux_cqa_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE chequesaux_cqa_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chequesaux_cqa_id_seq FROM aaii;
GRANT ALL ON SEQUENCE chequesaux_cqa_id_seq TO aaii;
GRANT ALL ON SEQUENCE chequesaux_cqa_id_seq TO nobody;


--
-- Name: chqrech; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE chqrech FROM PUBLIC;
REVOKE ALL ON TABLE chqrech FROM aaii;
GRANT ALL ON TABLE chqrech TO aaii;
GRANT ALL ON TABLE chqrech TO nobody;


--
-- Name: chqrech_chqr_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM aaii;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO aaii;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO nobody;


--
-- Name: cobrxclq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE cobrxclq FROM PUBLIC;
REVOKE ALL ON TABLE cobrxclq FROM aaii;
GRANT ALL ON TABLE cobrxclq TO aaii;
GRANT ALL ON TABLE cobrxclq TO nobody;


--
-- Name: cobrxclq_cxc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE cobrxclq_cxc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cobrxclq_cxc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE cobrxclq_cxc_id_seq TO aaii;
GRANT ALL ON SEQUENCE cobrxclq_cxc_id_seq TO nobody;


--
-- Name: compliq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE compliq FROM PUBLIC;
REVOKE ALL ON TABLE compliq FROM aaii;
GRANT ALL ON TABLE compliq TO aaii;
GRANT ALL ON TABLE compliq TO nobody;


--
-- Name: compliq_clq_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM aaii;
GRANT ALL ON SEQUENCE compliq_clq_id_seq TO aaii;
GRANT ALL ON SEQUENCE compliq_clq_id_seq TO nobody;


--
-- Name: compliquid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE compliquid FROM PUBLIC;
REVOKE ALL ON TABLE compliquid FROM aaii;
GRANT ALL ON TABLE compliquid TO aaii;
GRANT ALL ON TABLE compliquid TO nobody;


--
-- Name: compliquid_cl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE compliquid_cl_id_seq TO aaii;
GRANT ALL ON SEQUENCE compliquid_cl_id_seq TO nobody;


--
-- Name: compra; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM aaii;
GRANT ALL ON TABLE compra TO aaii;
GRANT ALL ON TABLE compra TO nobody;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM aaii;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO aaii;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO nobody;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM aaii;
GRANT ALL ON TABLE comprob TO aaii;
GRANT ALL ON TABLE comprob TO nobody;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM aaii;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO aaii;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO nobody;


--
-- Name: comprop; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE comprop FROM PUBLIC;
REVOKE ALL ON TABLE comprop FROM aaii;
GRANT ALL ON TABLE comprop TO aaii;
GRANT ALL ON TABLE comprop TO nobody;


--
-- Name: comprop_cmpr_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM aaii;
GRANT ALL ON SEQUENCE comprop_cmpr_id_seq TO aaii;
GRANT ALL ON SEQUENCE comprop_cmpr_id_seq TO nobody;


--
-- Name: conccble; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE conccble FROM PUBLIC;
REVOKE ALL ON TABLE conccble FROM aaii;
GRANT ALL ON TABLE conccble TO aaii;
GRANT ALL ON TABLE conccble TO nobody;


--
-- Name: conccble_ccbl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE conccble_ccbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conccble_ccbl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE conccble_ccbl_id_seq TO aaii;
GRANT ALL ON SEQUENCE conccble_ccbl_id_seq TO nobody;


--
-- Name: concilia; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON TABLE concilia FROM PUBLIC;
REVOKE ALL ON TABLE concilia FROM elm;
GRANT ALL ON TABLE concilia TO elm;
GRANT ALL ON TABLE concilia TO nobody;


--
-- Name: concilia_clia_id_seq; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE concilia_clia_id_seq FROM elm;
GRANT ALL ON SEQUENCE concilia_clia_id_seq TO elm;
GRANT ALL ON SEQUENCE concilia_clia_id_seq TO nobody;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM aaii;
GRANT ALL ON TABLE coniva TO aaii;
GRANT ALL ON TABLE coniva TO nobody;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM aaii;
GRANT ALL ON TABLE conpag TO aaii;
GRANT ALL ON TABLE conpag TO nobody;


--
-- Name: contratos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE contratos FROM PUBLIC;
REVOKE ALL ON TABLE contratos FROM aaii;
GRANT ALL ON TABLE contratos TO aaii;
GRANT ALL ON TABLE contratos TO nobody;


--
-- Name: contratos_ct_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE contratos_ct_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contratos_ct_id_seq FROM aaii;
GRANT ALL ON SEQUENCE contratos_ct_id_seq TO aaii;
GRANT ALL ON SEQUENCE contratos_ct_id_seq TO nobody;


--
-- Name: convenios; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE convenios FROM PUBLIC;
REVOKE ALL ON TABLE convenios FROM aaii;
GRANT ALL ON TABLE convenios TO aaii;
GRANT ALL ON TABLE convenios TO nobody;


--
-- Name: convenios_con_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM aaii;
GRANT ALL ON SEQUENCE convenios_con_id_seq TO aaii;
GRANT ALL ON SEQUENCE convenios_con_id_seq TO nobody;


--
-- Name: conxclia; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON TABLE conxclia FROM PUBLIC;
REVOKE ALL ON TABLE conxclia FROM elm;
GRANT ALL ON TABLE conxclia TO elm;
GRANT ALL ON TABLE conxclia TO nobody;


--
-- Name: conxcxlia_cxlia_id_seq; Type: ACL; Schema: public; Owner: elm
--

REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conxcxlia_cxlia_id_seq FROM elm;
GRANT ALL ON SEQUENCE conxcxlia_cxlia_id_seq TO elm;
GRANT ALL ON SEQUENCE conxcxlia_cxlia_id_seq TO nobody;


--
-- Name: coprop; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE coprop FROM PUBLIC;
REVOKE ALL ON TABLE coprop FROM aaii;
GRANT ALL ON TABLE coprop TO aaii;
GRANT ALL ON TABLE coprop TO nobody;


--
-- Name: coprop_cop_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM aaii;
GRANT ALL ON SEQUENCE coprop_cop_id_seq TO aaii;
GRANT ALL ON SEQUENCE coprop_cop_id_seq TO nobody;


--
-- Name: cotiza; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
REVOKE ALL ON TABLE cotiza FROM aaii;
GRANT ALL ON TABLE cotiza TO aaii;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM aaii;
GRANT ALL ON TABLE ctacble TO aaii;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO aaii;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO nobody;


--
-- Name: ctasconv; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ctasconv FROM PUBLIC;
REVOKE ALL ON TABLE ctasconv FROM aaii;
GRANT ALL ON TABLE ctasconv TO aaii;
GRANT ALL ON TABLE ctasconv TO nobody;


--
-- Name: ctasconv_ctc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ctasconv_ctc_id_seq TO aaii;
GRANT ALL ON SEQUENCE ctasconv_ctc_id_seq TO nobody;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM aaii;
GRANT ALL ON TABLE ctes TO aaii;
GRANT ALL ON TABLE ctes TO nobody;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO aaii;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO nobody;


--
-- Name: descripliq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE descripliq FROM PUBLIC;
REVOKE ALL ON TABLE descripliq FROM aaii;
GRANT ALL ON TABLE descripliq TO aaii;
GRANT ALL ON TABLE descripliq TO nobody;


--
-- Name: descripliq_dlq_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE descripliq_dlq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE descripliq_dlq_id_seq FROM aaii;
GRANT ALL ON SEQUENCE descripliq_dlq_id_seq TO aaii;
GRANT ALL ON SEQUENCE descripliq_dlq_id_seq TO nobody;


--
-- Name: dinicial; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE dinicial FROM PUBLIC;
REVOKE ALL ON TABLE dinicial FROM aaii;
GRANT ALL ON TABLE dinicial TO aaii;
GRANT ALL ON TABLE dinicial TO nobody;


--
-- Name: dinicial_din_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE dinicial_din_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE dinicial_din_id_seq FROM aaii;
GRANT ALL ON SEQUENCE dinicial_din_id_seq TO aaii;
GRANT ALL ON SEQUENCE dinicial_din_id_seq TO nobody;


--
-- Name: division; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE division FROM PUBLIC;
REVOKE ALL ON TABLE division FROM aaii;
GRANT ALL ON TABLE division TO aaii;
GRANT ALL ON TABLE division TO nobody;


--
-- Name: division_div_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE division_div_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE division_div_id_seq FROM aaii;
GRANT ALL ON SEQUENCE division_div_id_seq TO aaii;
GRANT ALL ON SEQUENCE division_div_id_seq TO nobody;


--
-- Name: docum; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM aaii;
GRANT ALL ON TABLE docum TO aaii;
GRANT ALL ON TABLE docum TO nobody;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO aaii;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO nobody;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM aaii;
GRANT ALL ON TABLE emiti TO aaii;
GRANT ALL ON TABLE emiti TO nobody;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM aaii;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO aaii;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO nobody;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM aaii;
GRANT ALL ON TABLE empresa TO aaii;
GRANT ALL ON TABLE empresa TO nobody;


--
-- Name: entidad; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
REVOKE ALL ON TABLE entidad FROM aaii;
GRANT ALL ON TABLE entidad TO aaii;
GRANT ALL ON TABLE entidad TO nobody;


--
-- Name: entidad_ent_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM aaii;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO aaii;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO nobody;


--
-- Name: estincid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE estincid FROM PUBLIC;
REVOKE ALL ON TABLE estincid FROM aaii;
GRANT ALL ON TABLE estincid TO aaii;
GRANT ALL ON TABLE estincid TO nobody;


--
-- Name: estincid_est_codigo_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE estincid_est_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE estincid_est_codigo_seq FROM aaii;
GRANT ALL ON SEQUENCE estincid_est_codigo_seq TO aaii;
GRANT ALL ON SEQUENCE estincid_est_codigo_seq TO nobody;


--
-- Name: estjud; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE estjud FROM PUBLIC;
REVOKE ALL ON TABLE estjud FROM aaii;
GRANT ALL ON TABLE estjud TO aaii;
GRANT ALL ON TABLE estjud TO nobody;


--
-- Name: estjurid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE estjurid FROM PUBLIC;
REVOKE ALL ON TABLE estjurid FROM aaii;
GRANT ALL ON TABLE estjurid TO aaii;
GRANT ALL ON TABLE estjurid TO nobody;


--
-- Name: eventos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE eventos FROM PUBLIC;
REVOKE ALL ON TABLE eventos FROM aaii;
GRANT ALL ON TABLE eventos TO aaii;
GRANT ALL ON TABLE eventos TO nobody;


--
-- Name: eventos_evt_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM aaii;
GRANT ALL ON SEQUENCE eventos_evt_id_seq TO aaii;
GRANT ALL ON SEQUENCE eventos_evt_id_seq TO nobody;


--
-- Name: factpend; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE factpend FROM PUBLIC;
REVOKE ALL ON TABLE factpend FROM aaii;
GRANT ALL ON TABLE factpend TO aaii;
GRANT ALL ON TABLE factpend TO nobody;


--
-- Name: factpend_fap_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM aaii;
GRANT ALL ON SEQUENCE factpend_fap_id_seq TO aaii;
GRANT ALL ON SEQUENCE factpend_fap_id_seq TO nobody;


--
-- Name: firman; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM aaii;
GRANT ALL ON TABLE firman TO aaii;
GRANT ALL ON TABLE firman TO nobody;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM aaii;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO aaii;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO nobody;


--
-- Name: fondocobrado; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE fondocobrado FROM PUBLIC;
REVOKE ALL ON TABLE fondocobrado FROM zona;
GRANT ALL ON TABLE fondocobrado TO zona;
GRANT ALL ON TABLE fondocobrado TO nobody;


--
-- Name: fondocobrado_fc_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE fondocobrado_fc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE fondocobrado_fc_id_seq FROM zona;
GRANT ALL ON SEQUENCE fondocobrado_fc_id_seq TO zona;
GRANT UPDATE ON SEQUENCE fondocobrado_fc_id_seq TO nobody;


--
-- Name: formapagooc; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE formapagooc FROM PUBLIC;
REVOKE ALL ON TABLE formapagooc FROM aaii;
GRANT ALL ON TABLE formapagooc TO aaii;
GRANT ALL ON TABLE formapagooc TO nobody;


--
-- Name: formapagooc_fp_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE formapagooc_fp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE formapagooc_fp_id_seq FROM aaii;
GRANT ALL ON SEQUENCE formapagooc_fp_id_seq TO aaii;
GRANT ALL ON SEQUENCE formapagooc_fp_id_seq TO nobody;


--
-- Name: gastos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE gastos FROM PUBLIC;
REVOKE ALL ON TABLE gastos FROM aaii;
GRANT ALL ON TABLE gastos TO aaii;
GRANT ALL ON TABLE gastos TO nobody;


--
-- Name: gastos_gto_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM aaii;
GRANT ALL ON SEQUENCE gastos_gto_id_seq TO aaii;
GRANT ALL ON SEQUENCE gastos_gto_id_seq TO nobody;


--
-- Name: grupof_d; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE grupof_d FROM PUBLIC;
REVOKE ALL ON TABLE grupof_d FROM aaii;
GRANT ALL ON TABLE grupof_d TO aaii;
GRANT ALL ON TABLE grupof_d TO nobody;


--
-- Name: grupof_d_gf_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE grupof_d_gf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupof_d_gf_id_seq FROM aaii;
GRANT ALL ON SEQUENCE grupof_d_gf_id_seq TO aaii;
GRANT ALL ON SEQUENCE grupof_d_gf_id_seq TO nobody;


--
-- Name: grupof_inq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE grupof_inq FROM PUBLIC;
REVOKE ALL ON TABLE grupof_inq FROM aaii;
GRANT ALL ON TABLE grupof_inq TO aaii;
GRANT ALL ON TABLE grupof_inq TO nobody;


--
-- Name: grupof_inq_gf_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE grupof_inq_gf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupof_inq_gf_id_seq FROM aaii;
GRANT ALL ON SEQUENCE grupof_inq_gf_id_seq TO aaii;
GRANT ALL ON SEQUENCE grupof_inq_gf_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM aaii;
GRANT ALL ON TABLE grupos TO aaii;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: gtoxliqe; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE gtoxliqe FROM PUBLIC;
REVOKE ALL ON TABLE gtoxliqe FROM aaii;
GRANT ALL ON TABLE gtoxliqe TO aaii;
GRANT ALL ON TABLE gtoxliqe TO nobody;


--
-- Name: gtoxoc; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE gtoxoc FROM PUBLIC;
REVOKE ALL ON TABLE gtoxoc FROM aaii;
GRANT ALL ON TABLE gtoxoc TO aaii;
GRANT ALL ON TABLE gtoxoc TO nobody;


--
-- Name: gtoxoc_gxo_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE gtoxoc_gxo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gtoxoc_gxo_id_seq FROM aaii;
GRANT ALL ON SEQUENCE gtoxoc_gxo_id_seq TO aaii;
GRANT ALL ON SEQUENCE gtoxoc_gxo_id_seq TO nobody;


--
-- Name: honorarios; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE honorarios FROM PUBLIC;
REVOKE ALL ON TABLE honorarios FROM aaii;
GRANT ALL ON TABLE honorarios TO aaii;
GRANT ALL ON TABLE honorarios TO nobody;


--
-- Name: honorarios_hon_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM aaii;
GRANT ALL ON SEQUENCE honorarios_hon_id_seq TO aaii;
GRANT ALL ON SEQUENCE honorarios_hon_id_seq TO nobody;


--
-- Name: imgincid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE imgincid FROM PUBLIC;
REVOKE ALL ON TABLE imgincid FROM aaii;
GRANT ALL ON TABLE imgincid TO aaii;
GRANT ALL ON TABLE imgincid TO nobody;


--
-- Name: imgincid_img_codigo_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE imgincid_img_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE imgincid_img_codigo_seq FROM aaii;
GRANT ALL ON SEQUENCE imgincid_img_codigo_seq TO aaii;
GRANT ALL ON SEQUENCE imgincid_img_codigo_seq TO nobody;


--
-- Name: importoliq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE importoliq FROM PUBLIC;
REVOKE ALL ON TABLE importoliq FROM aaii;
GRANT ALL ON TABLE importoliq TO aaii;
GRANT ALL ON TABLE importoliq TO nobody;


--
-- Name: importoliq_imp_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE importoliq_imp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE importoliq_imp_id_seq FROM aaii;
GRANT ALL ON SEQUENCE importoliq_imp_id_seq TO aaii;
GRANT ALL ON SEQUENCE importoliq_imp_id_seq TO nobody;


--
-- Name: incidencias; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE incidencias FROM PUBLIC;
REVOKE ALL ON TABLE incidencias FROM aaii;
GRANT ALL ON TABLE incidencias TO aaii;
GRANT ALL ON TABLE incidencias TO nobody;


--
-- Name: incidencias_in_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE incidencias_in_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE incidencias_in_id_seq FROM aaii;
GRANT ALL ON SEQUENCE incidencias_in_id_seq TO aaii;
GRANT ALL ON SEQUENCE incidencias_in_id_seq TO nobody;


--
-- Name: infdep; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON TABLE infdep FROM PUBLIC;
REVOKE ALL ON TABLE infdep FROM zona;
GRANT ALL ON TABLE infdep TO zona;
GRANT ALL ON TABLE infdep TO nobody;


--
-- Name: infdep_inf_id_seq; Type: ACL; Schema: public; Owner: zona
--

REVOKE ALL ON SEQUENCE infdep_inf_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE infdep_inf_id_seq FROM zona;
GRANT ALL ON SEQUENCE infdep_inf_id_seq TO zona;
GRANT ALL ON SEQUENCE infdep_inf_id_seq TO nobody;


--
-- Name: interes; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM aaii;
GRANT ALL ON TABLE interes TO aaii;
GRANT ALL ON TABLE interes TO nobody;


--
-- Name: judicial; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE judicial FROM PUBLIC;
REVOKE ALL ON TABLE judicial FROM aaii;
GRANT ALL ON TABLE judicial TO aaii;
GRANT ALL ON TABLE judicial TO nobody;


--
-- Name: judicial_jud_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM aaii;
GRANT ALL ON SEQUENCE judicial_jud_id_seq TO aaii;
GRANT ALL ON SEQUENCE judicial_jud_id_seq TO nobody;


--
-- Name: liqegr; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE liqegr FROM PUBLIC;
REVOKE ALL ON TABLE liqegr FROM aaii;
GRANT ALL ON TABLE liqegr TO aaii;
GRANT ALL ON TABLE liqegr TO nobody;


--
-- Name: liqegr_eg_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM aaii;
GRANT ALL ON SEQUENCE liqegr_eg_id_seq TO aaii;
GRANT ALL ON SEQUENCE liqegr_eg_id_seq TO nobody;


--
-- Name: liqui; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE liqui FROM PUBLIC;
REVOKE ALL ON TABLE liqui FROM aaii;
GRANT ALL ON TABLE liqui TO aaii;
GRANT ALL ON TABLE liqui TO nobody;


--
-- Name: liqui_lq_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE liqui_lq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqui_lq_id_seq FROM aaii;
GRANT ALL ON SEQUENCE liqui_lq_id_seq TO aaii;
GRANT ALL ON SEQUENCE liqui_lq_id_seq TO nobody;


--
-- Name: liquidacion; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE liquidacion FROM PUBLIC;
REVOKE ALL ON TABLE liquidacion FROM aaii;
GRANT ALL ON TABLE liquidacion TO aaii;
GRANT ALL ON TABLE liquidacion TO nobody;


--
-- Name: liquidacion_l_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM aaii;
GRANT ALL ON SEQUENCE liquidacion_l_id_seq TO aaii;
GRANT ALL ON SEQUENCE liquidacion_l_id_seq TO nobody;


--
-- Name: logosptv; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE logosptv FROM PUBLIC;
REVOKE ALL ON TABLE logosptv FROM aaii;
GRANT ALL ON TABLE logosptv TO aaii;
GRANT ALL ON TABLE logosptv TO nobody;


--
-- Name: logosptv_lpt_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE logosptv_lpt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE logosptv_lpt_id_seq FROM aaii;
GRANT ALL ON SEQUENCE logosptv_lpt_id_seq TO aaii;
GRANT SELECT,USAGE ON SEQUENCE logosptv_lpt_id_seq TO nobody;


--
-- Name: menues; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE menues FROM PUBLIC;
REVOKE ALL ON TABLE menues FROM aaii;
GRANT ALL ON TABLE menues TO aaii;
GRANT ALL ON TABLE menues TO nobody;


--
-- Name: menues_men_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE menues_men_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE menues_men_id_seq FROM aaii;
GRANT ALL ON SEQUENCE menues_men_id_seq TO aaii;
GRANT ALL ON SEQUENCE menues_men_id_seq TO nobody;


--
-- Name: modlogs; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE modlogs FROM PUBLIC;
REVOKE ALL ON TABLE modlogs FROM aaii;
GRANT ALL ON TABLE modlogs TO aaii;
GRANT ALL ON TABLE modlogs TO nobody;


--
-- Name: modlogs_log_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE modlogs_log_id_seq FROM aaii;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO aaii;
GRANT ALL ON SEQUENCE modlogs_log_id_seq TO nobody;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM aaii;
GRANT ALL ON TABLE moneda TO aaii;
GRANT ALL ON TABLE moneda TO nobody;


--
-- Name: monex; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM aaii;
GRANT ALL ON TABLE monex TO aaii;
GRANT ALL ON TABLE monex TO nobody;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM aaii;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO aaii;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO nobody;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM aaii;
GRANT ALL ON TABLE movsto TO aaii;
GRANT ALL ON TABLE movsto TO nobody;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM aaii;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO aaii;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO nobody;


--
-- Name: notdeb; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE notdeb FROM PUBLIC;
REVOKE ALL ON TABLE notdeb FROM aaii;
GRANT ALL ON TABLE notdeb TO aaii;
GRANT ALL ON TABLE notdeb TO nobody;


--
-- Name: notdeb_nd_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM aaii;
GRANT ALL ON SEQUENCE notdeb_nd_id_seq TO aaii;
GRANT ALL ON SEQUENCE notdeb_nd_id_seq TO nobody;


--
-- Name: noticias; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
REVOKE ALL ON TABLE noticias FROM aaii;
GRANT ALL ON TABLE noticias TO aaii;
GRANT ALL ON TABLE noticias TO nobody;


--
-- Name: noticias_not_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM aaii;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO aaii;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO nobody;


--
-- Name: novedades; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE novedades FROM PUBLIC;
REVOKE ALL ON TABLE novedades FROM sanjor;
GRANT ALL ON TABLE novedades TO sanjor;
GRANT ALL ON TABLE novedades TO nobody;


--
-- Name: novedades_nov_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE novedades_nov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE novedades_nov_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE novedades_nov_id_seq TO sanjor;
GRANT ALL ON SEQUENCE novedades_nov_id_seq TO nobody;


--
-- Name: ocsingtos; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ocsingtos FROM PUBLIC;
REVOKE ALL ON TABLE ocsingtos FROM aaii;
GRANT ALL ON TABLE ocsingtos TO aaii;
GRANT ALL ON TABLE ocsingtos TO nobody;


--
-- Name: ocsingtos_osg_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ocsingtos_osg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ocsingtos_osg_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ocsingtos_osg_id_seq TO aaii;
GRANT ALL ON SEQUENCE ocsingtos_osg_id_seq TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM aaii;
GRANT ALL ON TABLE operadores TO aaii;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM aaii;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO aaii;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: operincid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE operincid FROM PUBLIC;
REVOKE ALL ON TABLE operincid FROM aaii;
GRANT ALL ON TABLE operincid TO aaii;
GRANT ALL ON TABLE operincid TO nobody;


--
-- Name: operincid_oi_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE operincid_oi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operincid_oi_id_seq FROM aaii;
GRANT ALL ON SEQUENCE operincid_oi_id_seq TO aaii;
GRANT ALL ON SEQUENCE operincid_oi_id_seq TO nobody;


--
-- Name: ordencompra; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ordencompra FROM PUBLIC;
REVOKE ALL ON TABLE ordencompra FROM aaii;
GRANT ALL ON TABLE ordencompra TO aaii;
GRANT ALL ON TABLE ordencompra TO nobody;


--
-- Name: ordencompra_oc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ordencompra_oc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ordencompra_oc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ordencompra_oc_id_seq TO aaii;
GRANT ALL ON SEQUENCE ordencompra_oc_id_seq TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM aaii;
GRANT ALL ON TABLE pais TO aaii;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: priorincid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE priorincid FROM PUBLIC;
REVOKE ALL ON TABLE priorincid FROM aaii;
GRANT ALL ON TABLE priorincid TO aaii;
GRANT ALL ON TABLE priorincid TO nobody;


--
-- Name: priorincid_pri_codigo_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE priorincid_pri_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE priorincid_pri_codigo_seq FROM aaii;
GRANT ALL ON SEQUENCE priorincid_pri_codigo_seq TO aaii;
GRANT ALL ON SEQUENCE priorincid_pri_codigo_seq TO nobody;


--
-- Name: prove; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM aaii;
GRANT ALL ON TABLE prove TO aaii;
GRANT ALL ON TABLE prove TO nobody;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM aaii;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO aaii;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO nobody;


--
-- Name: provin; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM aaii;
GRANT ALL ON TABLE provin TO aaii;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM aaii;
GRANT ALL ON TABLE ptovta TO aaii;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM aaii;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO aaii;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO nobody;


--
-- Name: relmenu; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE relmenu FROM PUBLIC;
REVOKE ALL ON TABLE relmenu FROM aaii;
GRANT ALL ON TABLE relmenu TO aaii;
GRANT ALL ON TABLE relmenu TO nobody;


--
-- Name: relmenu_rmen_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE relmenu_rmen_id_seq FROM aaii;
GRANT ALL ON SEQUENCE relmenu_rmen_id_seq TO aaii;
GRANT ALL ON SEQUENCE relmenu_rmen_id_seq TO nobody;


--
-- Name: revisliq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE revisliq FROM PUBLIC;
REVOKE ALL ON TABLE revisliq FROM aaii;
GRANT ALL ON TABLE revisliq TO aaii;
GRANT ALL ON TABLE revisliq TO nobody;


--
-- Name: revisliq_rl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE revisliq_rl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE revisliq_rl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE revisliq_rl_id_seq TO aaii;
GRANT ALL ON SEQUENCE revisliq_rl_id_seq TO nobody;


--
-- Name: rubcar; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE rubcar FROM PUBLIC;
REVOKE ALL ON TABLE rubcar FROM aaii;
GRANT ALL ON TABLE rubcar TO aaii;
GRANT ALL ON TABLE rubcar TO nobody;


--
-- Name: rubcar_rubl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE rubcar_rubl_id_seq TO aaii;
GRANT ALL ON SEQUENCE rubcar_rubl_id_seq TO nobody;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM aaii;
GRANT ALL ON TABLE rubros TO aaii;
GRANT ALL ON TABLE rubros TO nobody;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM aaii;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO aaii;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO nobody;


--
-- Name: scangto; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE scangto FROM PUBLIC;
REVOKE ALL ON TABLE scangto FROM aaii;
GRANT ALL ON TABLE scangto TO aaii;
GRANT ALL ON TABLE scangto TO nobody;


--
-- Name: scangto_sc_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE scangto_sc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE scangto_sc_id_seq FROM aaii;
GRANT ALL ON SEQUENCE scangto_sc_id_seq TO aaii;
GRANT ALL ON SEQUENCE scangto_sc_id_seq TO nobody;


--
-- Name: seccion; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
REVOKE ALL ON TABLE seccion FROM aaii;
GRANT ALL ON TABLE seccion TO aaii;
GRANT ALL ON TABLE seccion TO nobody;


--
-- Name: sinicial; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE sinicial FROM PUBLIC;
REVOKE ALL ON TABLE sinicial FROM aaii;
GRANT ALL ON TABLE sinicial TO aaii;
GRANT ALL ON TABLE sinicial TO nobody;


--
-- Name: sinicial_sin_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE sinicial_sin_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE sinicial_sin_id_seq FROM aaii;
GRANT ALL ON SEQUENCE sinicial_sin_id_seq TO aaii;
GRANT ALL ON SEQUENCE sinicial_sin_id_seq TO nobody;


--
-- Name: srubcar; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE srubcar FROM PUBLIC;
REVOKE ALL ON TABLE srubcar FROM aaii;
GRANT ALL ON TABLE srubcar TO aaii;
GRANT ALL ON TABLE srubcar TO nobody;


--
-- Name: srubcar_srbl_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM aaii;
GRANT ALL ON SEQUENCE srubcar_srbl_id_seq TO aaii;
GRANT ALL ON SEQUENCE srubcar_srbl_id_seq TO nobody;


--
-- Name: subd; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM aaii;
GRANT ALL ON TABLE subd TO aaii;
GRANT ALL ON TABLE subd TO nobody;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM aaii;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO aaii;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO nobody;


--
-- Name: subrub; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
REVOKE ALL ON TABLE subrub FROM aaii;
GRANT ALL ON TABLE subrub TO aaii;
GRANT ALL ON TABLE subrub TO nobody;


--
-- Name: subrub_srb_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM aaii;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO aaii;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO nobody;


--
-- Name: sucursal; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE sucursal FROM PUBLIC;
REVOKE ALL ON TABLE sucursal FROM aaii;
GRANT ALL ON TABLE sucursal TO aaii;
GRANT ALL ON TABLE sucursal TO nobody;


--
-- Name: talon; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM aaii;
GRANT ALL ON TABLE talon TO aaii;
GRANT ALL ON TABLE talon TO nobody;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM aaii;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO aaii;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM aaii;
GRANT ALL ON TABLE telefon TO aaii;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM aaii;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO aaii;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM aaii;
GRANT ALL ON TABLE tipcta TO aaii;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM aaii;
GRANT ALL ON TABLE tipdocu TO aaii;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM aaii;
GRANT ALL ON TABLE tipemp TO aaii;
GRANT ALL ON TABLE tipemp TO nobody;


--
-- Name: tipempr; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipempr FROM PUBLIC;
REVOKE ALL ON TABLE tipempr FROM aaii;
GRANT ALL ON TABLE tipempr TO aaii;
GRANT ALL ON TABLE tipempr TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM aaii;
GRANT ALL ON TABLE tipentid TO aaii;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipgto; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipgto FROM PUBLIC;
REVOKE ALL ON TABLE tipgto FROM aaii;
GRANT ALL ON TABLE tipgto TO aaii;
GRANT ALL ON TABLE tipgto TO nobody;


--
-- Name: tipgto_tg_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE tipgto_tg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipgto_tg_id_seq FROM aaii;
GRANT ALL ON SEQUENCE tipgto_tg_id_seq TO aaii;
GRANT ALL ON SEQUENCE tipgto_tg_id_seq TO nobody;


--
-- Name: tipnot; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipnot FROM PUBLIC;
REVOKE ALL ON TABLE tipnot FROM aaii;
GRANT ALL ON TABLE tipnot TO aaii;
GRANT ALL ON TABLE tipnot TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM aaii;
GRANT ALL ON TABLE tiptel TO aaii;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tipuf; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE tipuf FROM PUBLIC;
REVOKE ALL ON TABLE tipuf FROM aaii;
GRANT ALL ON TABLE tipuf TO aaii;
GRANT ALL ON TABLE tipuf TO nobody;


--
-- Name: usermenu; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE usermenu FROM PUBLIC;
REVOKE ALL ON TABLE usermenu FROM aaii;
GRANT ALL ON TABLE usermenu TO aaii;
GRANT ALL ON TABLE usermenu TO nobody;


--
-- Name: usermenu_umen_id_seq; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE usermenu_umen_id_seq FROM aaii;
GRANT ALL ON SEQUENCE usermenu_umen_id_seq TO aaii;
GRANT ALL ON SEQUENCE usermenu_umen_id_seq TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM aaii;
GRANT ALL ON TABLE varamb TO aaii;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM aaii;
GRANT ALL ON TABLE varambi TO aaii;
GRANT ALL ON TABLE varambi TO nobody;


--
-- Name: zona; Type: ACL; Schema: public; Owner: aaii
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM aaii;
GRANT ALL ON TABLE zona TO aaii;
GRANT ALL ON TABLE zona TO nobody;


--
-- PostgreSQL database dump complete
--

